(window["webpackJsonp"] = window["webpackJsonp"] || []).push([[11],{

/***/ "./src/js/api/commands/user/domains/$processors.ts":
/*!*********************************************************!*\
  !*** ./src/js/api/commands/user/domains/$processors.ts ***!
  \*********************************************************/
/*! exports provided: toDomain, getDomainInfo, processCheckbox, processText, processSelect, getMap, getCustomItems, getPhpVersions, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"toDomain\", function() { return toDomain; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"getDomainInfo\", function() { return getDomainInfo; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"processCheckbox\", function() { return processCheckbox; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"processText\", function() { return processText; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"processSelect\", function() { return processSelect; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"getMap\", function() { return getMap; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"getCustomItems\", function() { return getCustomItems; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"getPhpVersions\", function() { return getPhpVersions; });\n/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ramda */ \"./node_modules/ramda/es/index.js\");\n/* harmony import */ var _api_converters__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @api/converters */ \"./src/js/api/commands/converters/index.ts\");\nvar __assign = (undefined && undefined.__assign) || function () {\n    __assign = Object.assign || function(t) {\n        for (var s, i = 1, n = arguments.length; i < n; i++) {\n            s = arguments[i];\n            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))\n                t[p] = s[p];\n        }\n        return t;\n    };\n    return __assign.apply(this, arguments);\n};\n\n\n;\n;\n;\n;\n/**\n * Functions\n */\nvar isNumber = ramda__WEBPACK_IMPORTED_MODULE_0__[\"pipe\"](Number, Number.isFinite);\nvar toDomain = function (apiDomain) { return ({\n    domain: apiDomain.domain,\n    active: Object(_api_converters__WEBPACK_IMPORTED_MODULE_1__[\"toBoolean\"])(apiDomain.active),\n    defaultdomain: Object(_api_converters__WEBPACK_IMPORTED_MODULE_1__[\"toBoolean\"])(apiDomain.defaultdomain),\n    subdomain: Object(_api_converters__WEBPACK_IMPORTED_MODULE_1__[\"toNumber\"])(apiDomain.subdomain),\n    bandwidth: Object(_api_converters__WEBPACK_IMPORTED_MODULE_1__[\"toUsage\"])({\n        usage: isNumber(apiDomain.bandwidth) ? apiDomain.bandwidth : '0',\n        limit: apiDomain.bandwidth_limit,\n    }),\n    quota: Object(_api_converters__WEBPACK_IMPORTED_MODULE_1__[\"toUsage\"])({\n        usage: isNumber(apiDomain.quota) ? apiDomain.quota : '0',\n        limit: apiDomain.quota_limit,\n    }),\n    pointers: ramda__WEBPACK_IMPORTED_MODULE_0__[\"pipe\"](ramda__WEBPACK_IMPORTED_MODULE_0__[\"defaultTo\"]({}), ramda__WEBPACK_IMPORTED_MODULE_0__[\"keys\"], ramda__WEBPACK_IMPORTED_MODULE_0__[\"map\"](String))(apiDomain.pointers),\n}); };\nvar getDomainInfo = function (apiDomain) { return ({\n    bandwidth: apiDomain.bandwidth,\n    quota: apiDomain.quota,\n    ssl: apiDomain.ssl === 'ON',\n    cgi: apiDomain.cgi === 'ON',\n    php: apiDomain.php === 'ON',\n    show_ips: apiDomain.has_multiple_ips === 'yes',\n    show_php: apiDomain.has_php_selector === 'yes',\n    force_ssl: apiDomain.force_ssl === 'yes',\n    private_html: apiDomain.private_html === 'link' ? 'symlink' : 'directory',\n    force_redirect: apiDomain.force_redirect || 'none',\n    modsecurity: apiDomain.modsecurity === 'yes',\n    nginx: apiDomain.nginx === '1',\n}); };\n;\nvar processCheckbox = function (data) {\n    return {\n        type: 'checkbox',\n        value: data.value === 'ON' || data.checked === 'yes',\n        description: data.desc || '',\n        label: data.string || '',\n        api_only: data.api_only === 'yes',\n        hidden: data.hidden === 'yes',\n    };\n};\nvar processText = function (data) {\n    return {\n        type: 'text',\n        description: data.desc || '',\n        label: data.string || '',\n        value: data.value || '',\n        api_only: data.api_only === 'yes',\n        hidden: data.hidden === 'yes',\n    };\n};\nvar processSelect = function (data) {\n    var options = Object.keys(data)\n        .filter(function (key) { return /^item\\d+val*$/.test(key); }) // leave only itemXXval\n        .reduce(function (acc, key) {\n        var _a;\n        return (__assign(__assign({}, acc), (_a = {}, _a[data[key]] = data[key.replace('val', 'txt')] || '', _a)));\n    }, {});\n    return {\n        type: 'select',\n        description: data.desc || '',\n        label: data.string || '',\n        value: data.value || data.default || '',\n        options: options,\n        api_only: data.api_only === 'yes',\n        hidden: data.hidden === 'yes',\n    };\n};\nvar getMap = function (str) { return str.split('&').reduce(function (acc, param) {\n    var _a;\n    var _b = param.split('='), _c = _b[0], id = _c === void 0 ? '' : _c, _d = _b[1], value = _d === void 0 ? '' : _d;\n    return __assign(__assign({}, acc), (_a = {}, _a[id] = value, _a));\n}, {}); };\nvar getCustomItem = function (data) {\n    switch (data.type) {\n        case 'listbox': return processSelect(data);\n        case 'checkbox': return processCheckbox(data);\n        default: return processText(data);\n    }\n};\nvar getCustomItems = function (response) {\n    var items = ramda__WEBPACK_IMPORTED_MODULE_0__[\"mapObjIndexed\"](getMap, response.custom_domain_items || {});\n    var values = ramda__WEBPACK_IMPORTED_MODULE_0__[\"pickAll\"](ramda__WEBPACK_IMPORTED_MODULE_0__[\"keys\"](items), response);\n    var merged = ramda__WEBPACK_IMPORTED_MODULE_0__[\"mergeDeepLeft\"](ramda__WEBPACK_IMPORTED_MODULE_0__[\"mapObjIndexed\"](function (value) { return ({ value: value }); }, values), items);\n    //@ts-ignore\n    var result = ramda__WEBPACK_IMPORTED_MODULE_0__[\"mapObjIndexed\"](getCustomItem, merged);\n    return result;\n};\nvar getPhpVersions = function (response) {\n    if (response.has_php_selector === 'yes') {\n        if (typeof response.php1_select === 'object') {\n            return {\n                enabled: true,\n                legacy: response.php_selector_count === '2',\n                versions: Object(_api_converters__WEBPACK_IMPORTED_MODULE_1__[\"toSelectData\"])(response.php1_select),\n            };\n        }\n        var options = ramda__WEBPACK_IMPORTED_MODULE_0__[\"pick\"](ramda__WEBPACK_IMPORTED_MODULE_0__[\"map\"](function (index) { return \"php\" + index + \"_select\"; }, ramda__WEBPACK_IMPORTED_MODULE_0__[\"range\"](1, 5)), response.options);\n        return {\n            enabled: true,\n            versions: {\n                value: response.php1_select,\n                options: options,\n            },\n            legacy: response.php_selector_count === '2',\n        };\n    }\n    else {\n        return {\n            enabled: false,\n            legacy: false,\n            versions: {\n                options: {},\n                value: '',\n            },\n        };\n    }\n};\n/* harmony default export */ __webpack_exports__[\"default\"] = ({\n    getDomains: function (response) { return ramda__WEBPACK_IMPORTED_MODULE_0__[\"map\"](toDomain, ramda__WEBPACK_IMPORTED_MODULE_0__[\"values\"](response)); },\n    getDomain: {\n        domain: getDomainInfo,\n        custom_items: getCustomItems,\n    },\n    getPhpVersions: getPhpVersions,\n});\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./src/js/api/commands/user/domains/$processors.ts\n");

/***/ }),

/***/ "./src/js/api/commands/user/domains/index.js":
/*!***************************************************!*\
  !*** ./src/js/api/commands/user/domains/index.js ***!
  \***************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("\n\n__webpack_require__(/*! core-js/modules/es.object.keys.js */ \"./node_modules/core-js/modules/es.object.keys.js\");\n\n__webpack_require__(/*! core-js/modules/es.symbol.js */ \"./node_modules/core-js/modules/es.symbol.js\");\n\n__webpack_require__(/*! core-js/modules/es.array.filter.js */ \"./node_modules/core-js/modules/es.array.filter.js\");\n\n__webpack_require__(/*! core-js/modules/es.object.get-own-property-descriptor.js */ \"./node_modules/core-js/modules/es.object.get-own-property-descriptor.js\");\n\n__webpack_require__(/*! core-js/modules/web.dom-collections.for-each.js */ \"./node_modules/core-js/modules/web.dom-collections.for-each.js\");\n\n__webpack_require__(/*! core-js/modules/es.object.get-own-property-descriptors.js */ \"./node_modules/core-js/modules/es.object.get-own-property-descriptors.js\");\n\nvar _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ \"./node_modules/@babel/runtime/helpers/interopRequireDefault.js\");\n\nObject.defineProperty(exports, \"__esModule\", {\n  value: true\n});\nexports.setDomainPHPVersions = exports.getDomainPHPVersions = exports.deleteDomainIps = exports.getDomainIps = exports.assignDomainIps = exports.setDomainPrivateHtml = exports.modifyDomain = exports.renameDomain = exports.createDomain = exports.deleteDomains = exports.changeDomainStatus = exports.setDefaultDomain = exports.getCustomItems = exports.getDomain = exports.getDomains = void 0;\n\n__webpack_require__(/*! core-js/modules/es.array.includes.js */ \"./node_modules/core-js/modules/es.array.includes.js\");\n\nvar _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ \"./node_modules/@babel/runtime/helpers/defineProperty.js\"));\n\nvar _command = _interopRequireDefault(__webpack_require__(/*! api/command */ \"./src/js/api/command/index.js\"));\n\nvar _$processors = _interopRequireDefault(__webpack_require__(/*! ./$processors.ts */ \"./src/js/api/commands/user/domains/$processors.ts\"));\n\nfunction ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }\n\nfunction _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }\n\nvar getDomains = _command.default.get({\n  id: 'GET_DOMAINS',\n  url: '/CMD_ADDITIONAL_DOMAINS',\n  params: {\n    bytes: true\n  },\n  response: [],\n  mapResponse: _$processors.default.getDomains\n});\n\nexports.getDomains = getDomains;\n\nvar getDomain = _command.default.get({\n  id: 'GET_DOMAIN',\n  url: '/CMD_ADDITIONAL_DOMAINS',\n  params: {\n    action: 'view'\n  },\n  schema: {\n    domain: _command.default.DOMAIN\n  },\n  mapResponse: _$processors.default.getDomain\n});\n\nexports.getDomain = getDomain;\n\nvar getCustomItems = _command.default.get({\n  id: 'DOMAIN_CUSTOM_ITEMS',\n  url: '/HTM_ADD_DOMAIN',\n  mapResponse: _$processors.default.getDomain.custom_items\n});\n\nexports.getCustomItems = getCustomItems;\n\nvar DOMAIN_ACTION = _command.default.select({\n  url: '/CMD_DOMAIN'\n});\n\nvar setDefaultDomain = DOMAIN_ACTION.extend({\n  params: {\n    default: true\n  }\n});\nexports.setDefaultDomain = setDefaultDomain;\nvar changeDomainStatus = DOMAIN_ACTION.extend({\n  params: {\n    reason: 'Other',\n    suspend: true\n  }\n});\nexports.changeDomainStatus = changeDomainStatus;\nvar deleteDomains = DOMAIN_ACTION.extend({\n  params: {\n    delete: true,\n    confirmed: true,\n    delete_data_aware: true\n  },\n  schema: {\n    delete_data: _command.default.REQUIRED_BOOL\n  }\n});\nexports.deleteDomains = deleteDomains;\n\nvar createDomain = _command.default.post({\n  url: '/CMD_DOMAIN',\n  params: {\n    action: 'create'\n  },\n  schema: {\n    domain: _command.default.REQUIRED_STRING,\n    bandwidth: _command.default.OPTIONAL_STRING,\n    unbandwidth: _command.default.OPTIONAL_STRING,\n    quota: _command.default.OPTIONAL_STRING,\n    uquota: _command.default.OPTIONAL_STRING,\n    ssl: _command.default.OPTIONAL_STRING,\n    cgi: _command.default.OPTIONAL_STRING,\n    php: _command.default.OPTIONAL_STRING\n  },\n  notifySuccess: true,\n  notifyError: true\n});\n\nexports.createDomain = createDomain;\n\nvar renameDomain = _command.default.post({\n  url: '/CMD_CHANGE_DOMAIN',\n  params: {\n    json: true\n  },\n  schema: {\n    old_domain: _command.default.REQUIRED_STRING,\n    new_domain: _command.default.REQUIRED_STRING\n  }\n});\n\nexports.renameDomain = renameDomain;\n\nvar modifyDomain = _command.default.post({\n  url: '/CMD_DOMAIN',\n  params: {\n    action: 'modify',\n    form_version: '1.1'\n  },\n  body: {\n    domain: _command.default.DOMAIN,\n    bandwidth: _command.default.REQUIRED_STRING,\n    ubandwidth: _command.default.REQUIRED_STRING,\n    quota: _command.default.REQUIRED_STRING,\n    uquota: _command.default.REQUIRED_STRING,\n    ssl: _command.default.REQUIRED_STRING,\n    php: _command.default.REQUIRED_STRING,\n    cgi: _command.default.REQUIRED_STRING,\n    www_pointers: _command.default.OPTIONAL_STRING,\n    force_redirect: _command.default.REQUIRED_STRING\n  }\n});\n\nexports.modifyDomain = modifyDomain;\n\nvar setDomainPrivateHtml = _command.default.post({\n  url: '/CMD_DOMAIN',\n  params: {\n    action: 'private_html'\n  },\n  schema: {\n    domain: _command.default.DOMAIN,\n    val: _objectSpread(_objectSpread({}, _command.default.REQUIRED_STRING), {}, {\n      validator: function validator(val) {\n        return ['directory', 'symlink'].includes(val);\n      }\n    }),\n    force_ssl: _command.default.OPTIONAL_BOOL\n  },\n  notifySuccess: false\n});\n\nexports.setDomainPrivateHtml = setDomainPrivateHtml;\n\nvar assignDomainIps = _command.default.post({\n  url: '/CMD_DOMAIN',\n  params: {\n    action: 'multi_ip',\n    add: true\n  },\n  schema: {\n    domain: _command.default.DOMAIN,\n    ip: _command.default.REQUIRED_STRING,\n    dns: _command.default.OPTIONAL_BOOL\n  }\n});\n\nexports.assignDomainIps = assignDomainIps;\n\nvar getDomainIps = _command.default.get({\n  id: 'DOMAIN_IPS',\n  url: '/CMD_ADDITIONAL_DOMAINS',\n  params: {\n    action: 'view',\n    ips: true\n  },\n  schema: {\n    domain: _command.default.DOMAIN\n  },\n  after: function after(fp) {\n    return fp.flow(fp.project({\n      assigned: 'assigned_ips',\n      available: 'available_ips'\n    }), fp.mapProp('assigned', fp.mapArray(function (ip) {\n      return {\n        ip: ip\n      };\n    })));\n  }\n});\n\nexports.getDomainIps = getDomainIps;\n\nvar deleteDomainIps = _command.default.post({\n  url: '/CMD_DOMAIN',\n  params: {\n    action: 'multi_ip',\n    delete: true\n  },\n  schema: {\n    domain: _command.default.DOMAIN,\n    select: _command.default.ROWS,\n    removedns: _command.default.OPTIONAL_BOOL\n  }\n});\n\nexports.deleteDomainIps = deleteDomainIps;\n\nvar getDomainPHPVersions = _command.default.get({\n  id: 'DOMAIN_PHP_VERSIONS',\n  url: '/CMD_ADDITIONAL_DOMAINS',\n  params: {\n    action: 'view'\n  },\n  domain: true,\n  mapResponse: _$processors.default.getPhpVersions\n});\n\nexports.getDomainPHPVersions = getDomainPHPVersions;\n\nvar setDomainPHPVersions = _command.default.post({\n  url: '/CMD_DOMAIN',\n  method: 'POST',\n  params: {\n    action: 'php_selector',\n    save: true\n  },\n  domain: true,\n  schema: {\n    php1_select: _command.default.REQUIRED_STRING\n  }\n});\n\nexports.setDomainPHPVersions = setDomainPHPVersions;//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./src/js/api/commands/user/domains/index.js\n");

/***/ })

}]);