<?php

define('SM_PATH', '../../');
include_once(SM_PATH . 'include/validate.php');
include_once('functions.php');

// Make sure plugin is activated!
//
global $plugins;
if (!in_array('directadmin', $plugins))
   exit;

function directadmin_go_header()
{
	global $color;
	displayPageHeader($color, 'None');

	echo html_tag( 'table',
	        html_tag( 'tr',
	            html_tag( 'td','<div style="text-align: center;"><b>' . _("Vacation Message") .'</b></div>', 'center', $color[0] )
	        ) ,
	    'center', '', 'width="95%" cellpadding="1" cellspacing="2" border="0"' );

	echo "<center>";
}

function header_then_error($txt)
{
	directadmin_go_header();
	directadmin_error($txt);
}

$startstamp=time();
$endstamp=time();
$text="";

$time_of_day = array( "morning" => _("Morning"), "afternoon" => _("Afternoon"), "evening" => _("Evening"));
$months = array();
for ($i=1; $i<=12; $i++)
{
        $months[$i] = date("M", mktime(0,0,0,$i,1,0));
}
$days = array();
for ($i=1; $i<=31; $i++)
{
        $days[$i] = $i;
}

$start_year = 2007;
$end_year = 2029;
$years = array();
for ($i=$start_year; $i<=$end_year; $i++)
{
        $years[$i] = $i;
}

if (isset($_POST['action']) && ($_POST['action'] == "create" || $_POST['action'] == "modify" || $_POST['action'] == "delete"))
{

        global $username;
        list($da_user, $da_domain) = explode('@', $username);
        if ($da_user == "" || $da_domain == "") return 0;

        $sock = newSock();
	set_ssl_setting_message($sock);
        $sock->query('/CMD_API_EMAIL_ACCOUNT_VACATION',
        array(
                'user' => $da_user,
                'domain'=>$da_domain,
                'password' => sqauth_read_password(),
                'action' => $_POST['action'],
                'text' => stripslashes($_POST['text']),
                'starttime' => $_POST['starttime'],
                'startmonth' => $_POST['startmonth'],
                'startday' => $_POST['startday'],
                'startyear' => $_POST['startyear'],
                'endtime' => $_POST['endtime'],
                'endmonth' => $_POST['endmonth'],
                'endday' => $_POST['endday'],
                'endyear' => $_POST['endyear']
         ));

        $result = $sock->fetch_parsed_body();

        if ( $result['error'] != "0" )
        {
                return header_then_error("Unable to set vacation message:<br><b>".$result['text']."</b>");
        }

	directadmin_go_header();	

        echo _("Vacation message")." ";
        switch ($_POST['action'])
        {       case "create" : echo _("created"); break;
                case "modify" : echo _("updated"); break;
                case "delete" : echo _("deleted"); break;
        }
        echo ".<br><br>";

        exit(0);
}

global $username;
list($da_user, $da_domain) = explode('@', $username);
if ($da_user == "" || $da_domain == "") return 0;

//grab any vacation message if there is one.
$sock1 = newSock();
set_ssl_setting_message($sock1);
$sock1->query('/CMD_API_EMAIL_ACCOUNT_VACATION',
        array(
                'user' => $da_user,
                'domain'=> $da_domain,
                'password' => sqauth_read_password(),
        ));

$result1 = $sock1->fetch_parsed_body();

$exists=0;

if ($result1 == 0)
{
        return header_then_error(_("socket retuned a zero result"));
}

if ( $result1['error'] == "0" )
{

        if (!isset($result1['startyear']))
        {
                return header_then_error("socket returned no error, but there is data missing.  Try reloading this page.");
        }

        $startstamp=getTimeFromVars($result1['startyear'], $result1['startmonth'], $result1['startday'], $result1['starttime']);
        $endstamp=getTimeFromVars($result1['endyear'], $result1['endmonth'], $result1['endday'], $result1['endtime']);
        $text=$result1['text'];
        $exists=1;
}
else
{
        //echo, I guess it doesn't exist yet.
        //echo "not there!<br>";
        //print_r($result1);
}

directadmin_go_header();

?>

<table cellpadding=3 cellspacing=1>
<form action="?" method="POST">
<input type=hidden name="action" value="<? if ($exists) { echo "modify";}else{echo "create";}?>">
<tr><td>Vacation Message:</td><td class=list align=center><textarea rows=15 cols=60 name=text><?=$text;?></textarea></td></tr>
<tr><td>Vacation Start: </td><td><? showTime("start", $startstamp); ?></td></tr>
<tr><td>Vacation End: </td><td><? showTime("end", $endstamp); ?></td></tr>
<tr><td>Current Server Time:</td><td><? echo get_tod(time())." of ".date("M j, Y"); ?></td></tr>
<tr><td colspan=2 align=center><input type=submit value="<? if($exists){echo "Update";}else{echo "Set";}?> Vacation Message"></td></tr>

</form>
</table>

<? if ($exists) { ?>
<br><br>
<form action="?" method="POST">
<input type=hidden name="action" value="delete">
<input type=submit value="Delete current Vacation Message">
</form>
<?
}

function show_select($name, $arr, $selected='')
{

        echo "<select name='$name'>";
        foreach($arr as $v => $t)
        {
                if ($v == $selected)
                {
                        echo "\t<option selected value='$v'>$t</option>\n";
                }
                else
                {
                        echo "\t<option value='$v'>$t</option>\n";
                }
        }
        echo "</select>\n";

}

function get_tod($stamp)
{
        $hour = (int)date("H", $stamp);

        if (0 <= $hour && $hour < 12) { return "morning"; }
        if (12 <= $hour && $hour < 18) { return "afternoon"; }
        return "evening";
}

function getTimeFromVars($year, $month, $day, $tod)
{
        switch($tod)
        {
                case "morning" : $hour = 6; break;
                case "afternoon" : $hour = 12; break;
                case "evening" : $hour = 18; break;
                default : $hour = 0; break;
        }

        return mktime($hour, 0, 0, $month, $day, $year);
}

function showTime($prefix, $stamp=0)
{
        global $time_of_day, $months, $days, $years;

        show_select("${prefix}time", $time_of_day, get_tod($stamp));

        show_select("${prefix}month", $months, date("m", $stamp));

        show_select("${prefix}day", $days, date("j", $stamp));

        show_select("${prefix}year", $years, date("Y", $stamp));


}

echo "</center>";

?>
