<?php

include_once('include/httpsocket.php');

//don't set these here, they're just here so they can be global'ed in config.php
//not sure why, but wouldn't let me call global here on config.php variables.
$da_host="";
$da_ssl="";
$da_port="";

include_once('include/config.php');

function directadmin_left_menu()
{
	echo "<hr>\n";

	if (!directadmin_ensure_data()) return;

	directadmin_draw_bar($_SESSION['da_total'], $_SESSION['da_quota'], 'Total Usage', 'red');
	
	if ($_SESSION['da_quota'] == 0)
		echo "<font size=2><b>of:</b> Unlimited<br><br>\n";
	else
		echo "<font size=2><b>of Limit</b>: ".readable_byte($_SESSION['da_quota'])."</font><br><br>\n";

	directadmin_draw_bar($_SESSION['da_inbox'], $_SESSION['da_quota'], 'Inbox', 'green');
	directadmin_draw_bar($_SESSION['da_spam'], $_SESSION['da_quota'], 'Spam', 'black');
	directadmin_draw_bar($_SESSION['da_webmail'], $_SESSION['da_quota'], 'Webmail', 'blue');
	directadmin_draw_bar($_SESSION['da_imap'], $_SESSION['da_quota'], 'IMAP Data', 'orange');


	displayInternalLink('plugins/directadmin/update.php', "<font size=2>Refresh</font>", 'left');

}

function directadmin_menuline_do()
{
	global $username;
	list($da_user, $da_domain) = explode('@', $username);
	if ($da_user == "" || $da_domain == "") return 0;
	
	displayInternalLink('plugins/directadmin/change_pass.php', "Change Password", 'right');
	echo "&nbsp;&nbsp;\n";
	displayInternalLink('plugins/directadmin/set_vacation.php', "Vacation Message", 'right');
	echo "&nbsp;&nbsp;\n";
}

function directadmin_draw_bar($usage, $max, $txt, $color)
{

	echo "<font size=2><b>${txt}</b>: ".readable_byte($usage);
	echo "</font><br>";

	if ($max == 0) return;

	$bar_width=125;

	echo "<table width=$bar_width bgColor=white cellspacing=0 cellpadding=0 style='border: 1px solid gray;'>\n<tr><td>\n";
	echo "<table height=10 bgColor=$color width=". ($usage*$bar_width/$max) ." cellspacing=0 cellpadding=0 border=0>\n";
	echo "<tr><td><font size=1>&nbsp;</font></td></tr>\n</table>\n";

	echo "</td></tr></table>\n";

}

//we check to make sure it's in the session.
//If not we fill it.  If the user wants to update the sessions, he has to actively click the button to do so.
function directadmin_ensure_data()
{
	if (!isset($_SESSION['da_inbox']) || !is_numeric($_SESSION['da_inbox']))
	{
		global $username;
		list($da_user, $da_domain) = explode('@', $username);
		if ($da_user == "" || $da_domain == "") return 0;

	        $sock = newSock();
		set_ssl_setting_message($sock);
	        $sock->query('/CMD_API_EMAIL_ACCOUNT_QUOTA',
	                array(
	                        'domain' => $da_domain,
        	                'user' => $da_user,
	                        'password' => sqauth_read_password(),
        	                'api' => '1',
	                        'quota' => 'yes'
	                 ));

	        $result = $sock->fetch_parsed_body();

	        //this is for the no-header bug. Only needed for DA 1.31.1 and older.
	        if (count($result) == 0)
	        {
	                parse_str($sock->fetch_result(), $result);
	        }

	        if ( $result['error'] != "0" )
	        {
        	        directadmin_error("You have entered an invalid email or password<br>".$result['text']);
	                return 0;
	        }

	        //error=0&imap=20480&inbox=750&spam=0&total=21230&webmail=0
	        $_SESSION['da_imap']	= $result['imap'];
	        $_SESSION['da_inbox']	= $result['inbox'];
	        $_SESSION['da_spam']	= $result['spam'];
	        $_SESSION['da_total']	= $result['total'];
	        $_SESSION['da_quota']	= $result['quota'];
	        $_SESSION['da_webmail']	= $result['webmail'];
	}
	return 1;
}

function newSock()
{
	//these 3 should be global, but config.php isn't including for some reason.

	global $da_host;
	global $da_port;
	global $da_ssl;

        $tsock = new HTTPSocket;
        $tsock->set_method('POST');

        if ($da_ssl)
        {
                $tsock->connect("ssl://$da_host", $da_port);
        }
        else
        {
                $tsock->connect("$da_host", $da_port);
        }

        return $tsock;
}

function readable_byte($bytes)
{
        if ($bytes<1024)
                return "$bytes Bytes";
        if ($bytes<1024*1024)
                return ($bytes/1024)." Kb";

        return ($bytes/(1024*1024))." Meg";
}

function directadmin_error($txt)
{
	echo $txt;
	return 0;
}

function is_pass($pass)
{
        return preg_match("/^([a-zA-Z0-9]|[~`!@#$%^&*()_+-=])+$/", $pass);
}

function set_ssl_setting_message($sock)
{
	if (method_exists($sock, 'set_ssl_setting_message') == FALSE)
		die('Cannot find httpsocket function set_ssl_setting_message. Ensure you have httpsocket version 2.7.2 or newer.  You have '.$sock->version);

	$sock->set_ssl_setting_message("DirectAdmin appears to be using SSL.<br>Edit:<br>\n".$_SERVER["DOCUMENT_ROOT"]."/squirrelmail/plugins/directadmin/include/config.php<br>\nand set \$da_ssl=true;");
}

?>
