<?php
$outfile	= $_GET['outputfile'];
$chunkTotal = $_GET['chunkcount'];
$chunkGUI   = $_GET['chunkgui'];
$chunkPath = "filechunks/";

// removed the temporary file chunks on disk
function clearChunks() {
	global $chunkTotal, $chunkPath, $chunkGUI;
	for ($count = 1; $count <= $chunkTotal; $count = $count + 1) {
		$filename = $chunkPath . $chunkGUI . "_" . $count;
		unlink($filename);
	}

	// also removed all chunk files that are older then 1 day
	clearOldChunks();
}

// remove all chunk files that are older then 12 hours
// NOTE: this function is also in the file clearChunks.php
function clearOldChunks() {
	global $chunkPath;

	$today = date("U");

	// build array of files
	$files = array();
	$dh  = opendir($chunkPath); 
	while (false !== ($filename = readdir($dh))) { 
		if ($filename != "." && $filename != ".." && $filename != "frontpage_fix.txt") {
			$mypath = $chunkPath . DIRECTORY_SEPARATOR . $filename;
			if (is_file($mypath)) {
				// if the file is old then delete it
				$filestamp = date("U", filemtime($mypath));
				$elapses = $today - $filestamp;
				$hourDiff = intval($elapses / 3600);
				if ($hourDiff > 12) {
					$files[] = $mypath; 
				}
			}
		}
	} 
	foreach ($files as $file) {
		unlink($file);
	}
}

//we want to create/overwrite the xml output from flash.
//$fp = fopen("mergeOutput.txt","w+");
//fwrite($fp, "outfile:" . $outfile . " chuntTotal:" . $chunkTotal . " chunkPath:" . $chunkPath . "\n");

$fout = fopen($outfile, "wb");
if ($fout === FALSE) {
	clearChunks();
	echo "<response><status>error opening file for writing</status></response>";
	exit;
}

// open each file and append to the output file
for ($count = 1; $count <= $chunkTotal; $count = $count + 1) {
	$filename = $chunkPath . $chunkGUI . "_" . $count;
	// fwrite($fp, "writing chunk from file:" . $filename . "\n");

	$fin = fopen($filename, "rb");
	if ($fin === FALSE) {
		fclose($fout);
		clearChunks();
		echo "<response><status>error opening file for reading</status></response>";
		exit;
	}

	// read 
	$data = fread($fin, filesize($filename));
	fwrite($fout, $data);
	fclose($fin);

}
fclose($fout);
//fclose($fp);

clearChunks();
echo "<response><status>success</status></response>";
?>
