<?php

//************************************
// delete unused images in a photo album
//************************************

ini_set("always_populate_raw_post_data", true);
include "includes/getDocumentRoot.inc.php";

// global variables
$site = "";
$dir = "";
$message = "";
$images = Array();


// The handler for the XML element opening tags
function startElementHandler($parser, $name, $attr) {
	global $dir, $site, $message, $images;
	if (strcmp($name, "PHOTOALBUMIMAGES") == 0) {
		$site = $attr["SITE"];
		$dir = $attr["DIR"];
	} elseif (strcmp($name, "IMAGE") == 0) {
		$imageName = $attr["NAME"]; 
		$images[$imageName] = true; 	
	}
}

// The handler for the XML element closing tags
function endElementHandler () {
	// nothing to do in this case
}

// create our XML parser
$parser = xml_parser_create();

// register the start and end element handlers
xml_set_element_handler($parser, "startElementHandler", "endElementHandler");


if (!xml_parse($parser, $HTTP_RAW_POST_DATA, true)) {
	// return XML document with an error message
	$message = "There was an error in the XML line " .
				xml_get_current_line_number($parser) . " at position " .
				xml_get_current_column_number($parser);
	echo "<response><status>". $message ."</status></response>";
	exit;
}

// finished parsing the XML
xml_parser_free($parser);

if ($site == "" || $dir == "") {
	echo "<response><status>Error, invalid information sent to the server.</status></response>";
	exit;
}


// get each image in the directory associated with the photo album, and if the
// image does not exsits in the photo album then delete it from disk
$files = array();
$path = getDocumentRoot() . $site . "/photoAlbums/" . $dir;
$dh  = opendir($path); 
while (false !== ($filename = readdir($dh))) { 
	if ($filename != "." && $filename != ".." && $filename != "frontpage_fix.txt") {
		if ($images[$filename] != true) {
			// this image does not exist in the photo album so delete it from disk
			$mypath = $path . "/" . $filename;
			if (is_file($mypath)) {
				// delete the image
				$delResult = unlink($mypath);
				if (!$delResult) {
					if ($message == "") {
						$message = "Error deleting the image(s): " . $filename;
					} else {
						$message .= ", " . $filename;
					}
				}
		   }
	   }
   }
} 

if ($message != "") {
	$message .= ".";
	echo "<response><status>" . $message . "</status></response>";
} else {
	echo "<response><status>success</status></response>";
}
?>