<?php

// createApplicationFilesFromTemplate.php

// create a new application file
// include "includes/getDocumentRoot.inc.php";

$templateID = "";
$sourceArray = array();
$destArray = array();
$typeArray = array();
$filenameArray = array();

ini_set("always_populate_raw_post_data", true);


//$logHandle = fopen("c:/log/createApplicationFilesFromTemplate.txt" ,"w");
//fwrite($logHandle, "startup \n");


// The handler for the XML element opening tags
function startElementHandler($parser, $name, $attr) {
	global  $sourceArray, $destArray, $filenameArray, $typeArray, $templateID, $logHandle;

	if (strcmp($name, "APPLICATIONTEMPLATE") == 0) {
		//fwrite($logHandle, "found APPLICATIONTEMPLATE in parser \n");
		$templateID = $attr["TEMPLATEID"];
	} else if (strcmp($name, "APPLICATIONFILE") == 0) {

		//fwrite($logHandle, "found APPLICATIONFILE in parser \n");

		// initialize the variables
		$sourceFile = "";
		$destFile = "";
		$filename = "";

		// add a new element to the array of files to create
		$sourceFile = $attr["SOURCEFILE"];
		$destFile = $attr["DESTFILE"];
		$filename = $attr["FILENAME"];
		$type = $attr["TYPE"];

		//fwrite($logHandle, "APPLICATIONFILE values: sourceFile: $sourceFile destFile: $destFile filename: $filename \n");
	
		$sourceArray[] = $sourceFile;
		$destArray[] = $destFile;
		$filenameArray[] = $filename;
		$typeArray[] = $type;
	}
}

// The handler for the XML element closing tags
function endElementHandler () {
	// nothing to do in this case
}

// create our XML parser
$parser = xml_parser_create();

// register the start and end element handlers
xml_set_element_handler($parser, "startElementHandler", "endElementHandler");

if (!xml_parse($parser, $HTTP_RAW_POST_DATA, true)) {
	// return XML document with an error message
	$message = "There was an error in the XML line " .
				xml_get_current_line_number($parser) . " at position " .
				xml_get_current_column_number($parser);

	echo "<response><status>". $message ."</status></response>";
	exit;
}

// finished parsing the XML
xml_parser_free($parser);


if ($templateID == "") {
	$message = "Unexpected error.";
	echo "<response><status>". $message ."</status></response>";
	exit;
} 



// traverse the array and create the corresponding application files
//fwrite($logHandle, "Now calling FOREEACH to create each file");
foreach ($sourceArray as $keyVar => $valueVar) {

	//fwrite($logHandle, "CREATING an application file in foreach");
	$sourceFile = $sourceArray[$keyVar];
	$destFile =	$destArray[$keyVar];
	$buttonType = $typeArray[$keyVar];
	$filename = $filenameArray[$keyVar];

	//fwrite($logHandle, "copying $sourceFile to $destFile \n");

	// copy the template application XML file
	copy("../" . $sourceFile, "../" . $destFile);

	// if we have a photo album, also create the corresponding subdirectory to contain the images
	if ($buttonType == "photos") {

		// 1 get the name of the filename without the extension, this is the subdirectory for the images
		$imageDir = substr($filename, 0, -4);

		// 2) remove the filename from the path
		$mapPath = substr($destFile, 0, -(strlen($filename)));

		// 2) append "photoAlbums" and the image dir
		$mapPath = "../" . $mapPath . "photoAlbums/" . $imageDir;

		// 3) create the directory 
		mkdir($mapPath);
	}
}

//fwrite($logHandle, "DONE calling FOREEACH to create each file");
//fclose($logHandle);

// return the result, including the filename
echo '<response><status>success</status><templateID>' . $templateID . '</templateID></response>';

?>