<?php

// global variables
$siteWidth = "";
$siteHeight = "";
$contentNode = "";
$startupMap = "";
$viewerToolbarColor = "";


ini_set("always_populate_raw_post_data", true);

//$debugfd = fopen("c:/bogus/res.txt", "w+");
//fwrite($debugfd, "Startup \n");
//fflush($debugfd);
 

// The handler for the XML element opening tags
function startElementHandler($parser, $name, $attr) {
	global $siteWidth, $siteHeight, $contentNode, $startupMap, $viewerToolbarColor;

	// TODO: we also need the full path, so we can set the path, such as "content/sitename/merchants/maps/" for saving the map
	if (strcmp($name, "RESOLUTION") == 0) {
		$siteWidth = $attr["SITEWIDTH"];
		$siteHeight = $attr["SITEHEIGHT"];
		$contentNode = $attr["CONTENTNODE"];
		$startupMap = $attr["STARTUPMAP"];
		$viewerToolbarColor = $attr["VIEWERTOOLBARCOLOR"];

		// we are done parsing, exit the parser; NOTE: this doesn not work, it hangs, so we are stuck reading the whole document for now
		// xml_parser_free($parser);
	}
}

// The handler for the XML element closing tags
function endElementHandler () {
	// nothing to do in this case
}

// create our XML parser
//fwrite($debugfd, "calling xml_parse_create \n");
//fflush($debugfd);
$parser = xml_parser_create();


// register the start and end element handlers
xml_set_element_handler($parser, "startElementHandler", "endElementHandler");

//fwrite($debugfd, "calling xml_parse \n");
//fflush($debugfd);

if (!xml_parse($parser, $HTTP_RAW_POST_DATA, true)) {
	// return XML document with an error message
	$message = "There was an error in the XML line " .
				xml_get_current_line_number($parser) . " at position " .
				xml_get_current_column_number($parser);
	echo "<response><status>". $message ."</status></response>";
	exit;
}


// finished parsing the XML
xml_parser_free($parser);
//fwrite($debugfd, "After calling xml_parser_free \n");
//fflush($dbugfd);


if ($siteWidth == "" || $siteHeight == "") {
	$message = "Error reading the incomming site resolution...";
	echo "<response><status>". $message . "</status></response>";
	exit;
}

//fwrite($debugfd, "after parsing resolution \n");
//flush($dbugfd);



// read the index.html template file into memory and substitue the real resolution for WISENAV_WIDTH and WISENAV_HEIGHT
$filename = "includes/previewTemplate.php";
//$fp = fopen($filename, "r");
//$templateString = fread($fp, filesize($filename));
$templateString = file_get_contents($filename);
 //fclose($fp)

//fwrite($debugfd, "read template file: $templateString \n");
//fflush($debugfd);


// substitue the resolution
$widthSubstituted = str_replace("WISENAV_WIDTH", $siteWidth, $templateString);

//fwrite($debugfd, "substituted WISENAV_WIDTH \n");
//fflush($debugfd);


 $indexHTML = str_replace("WISENAV_HEIGHT", $siteHeight, $widthSubstituted);
//fwrite($debugfd, "final template file: $indexHTML \n");
//fflush($debugfd);

// set the content node, startup map and the toolbar color
 $data1 = str_replace("WISENAV_CONTENTNODE", $contentNode, $indexHTML);
 $data2 = str_replace("WISENAV_STARTUPMAP", $startupMap, $data1);
 $data3 = str_replace("WISENAV_VIEWERTOOLBARCOLOR", $viewerToolbarColor, $data2);

// get a random number number for the the file (we append a number to the file, so
// that the file is not cached by the browser)
srand ((double) microtime( )*1000000);
$random_number = rand();
$previewname = "preview" . $random_number . ".html";

// remove the old existing preview page(s)
$dir  = opendir("../../preview/"); 
 while($file=readdir($dir)){
   if ($file!="." and $file!=".." and $file!="ArcticExternalAll.swf" and $file!="ArcticExternalPlaySeekMute.swf") {
      if (!is_dir($file)) {
		 unlink("../../preview/" . $file);
	  }
   }
}

//we want to create/overwrite the index.html file
$filename2 = "../../preview/" . $previewname;
//fwrite($debugfd, "Writing resolution to file: $filename2 \n");
//fflush($debugfd);
$fp2 = fopen($filename2,"w+");
if (fwrite($fp2, $data3)) {
	$message = "success";
} else {
	$message = "Error saving the runtime resolution file!";
}
fclose($fp2);

// delete the old preview pages


echo "<response><status>". $message . "</status><filename>" . $previewname . "</filename></response>";  
?>