<?php

// createSite.php

// create a new content node
include "includes/getDocumentRoot.inc.php";

$nodeName = "";
$directory = "";
$siteWidth = "";
$siteHeight = "";


ini_set("always_populate_raw_post_data", true);


//$logHandle = fopen("c:/bogus/createContentNode.txt" ,"w");
//fwrite($logHandle, "startup");


// The handler for the XML element opening tags
function startElementHandler($parser, $name, $attr) {
	global  $nodeName, $directory, $siteWidth, $siteHeight;

	if (strcmp($name, "CONTENTNODE") == 0) {
		$nodeName = $attr["CONTENTNODENAME"];
		$directory = $attr["DIRECTORY"];
		$siteWidth = $attr["SITEWIDTH"];
		$siteHeight = $attr["SITEHEIGHT"];
	}
}

// The handler for the XML element closing tags
function endElementHandler () {
	// nothing to do in this case
}

// create our XML parser
$parser = xml_parser_create();

// register the start and end element handlers
xml_set_element_handler($parser, "startElementHandler", "endElementHandler");

if (!xml_parse($parser, $HTTP_RAW_POST_DATA, true)) {
	// return XML document with an error message
	$message = "There was an error in the XML line " .
				xml_get_current_line_number($parser) . " at position " .
				xml_get_current_column_number($parser);

	echo "<response><status>". $message ."</status></response>";
	//fclose($logHandle);
	exit;
}

// finished parsing the XML
xml_parser_free($parser);


if ($nodeName == "" || $directory == "" || $siteWidth == "" || $siteHeight == "") {
	$message = "Unexpected error.";
	echo "<response><status>". $message ."</status></response>";
	//fclose($logHandle);
	exit;
}

// create the contentNode
$source = "../WVTemplates/WVContentNodeTemplate";
$destination = getDocumentRoot() . $directory . $nodeName;
$message = "";


//fwrite($logHandle, "calling copyDirectory, source: " . $source . " dest: " . $destination);
copyDirectory($source, $destination);

// now create an XML file representing the site and containing the resolution for the site
$xmlFilename = getDocumentRoot() . $directory . $nodeName . "/startupMap.xml";
$xmlContent = "<?xml version=\"1.0\" ?><startupmap name=\"\" siteWidth=\"" . $siteWidth . "\" siteHeight=\"". $siteHeight . "\" />";
$fileHandle = fopen($xmlFilename ,"w");
fwrite($fileHandle, $xmlContent);
fclose($fileHandle);


//fclose($logHandle);
echo '<response><status>success</status><nodeName>' . $nodeName . '</nodeName></response>';
//fclose($logHandle);


function copyDirectory($src, $dest) {
	global $logHandle;

    // fwrite($logHandle, "inside copyDirectory");

	if (!mkdir($dest, 0777)) {
		$message = "ERROR creating the site directory.";
		echo "<response><status>" . urlencode($message) . "</status></response>";
		//fclose($logHandle);
		exit();
	} 

	#echo "made dir '$basepath$id'.<BR>";
	if ($handle = opendir($src)) {
		
		while (false !== ($file = readdir($handle))) { 			
			if ($file != "." && $file != ".." && $file != ".svn") {
				if (is_dir($src . "/" . $file)) {
					#echo "dir: $file<BR>";
					copyDirectory($src . "/" . $file, $dest . "/" . $file);
				} elseif (is_file($src . "/" . $file)) {
					copy($src . "/" . $file, $dest . "/" . $file);
				} 
			} 
		}
		closedir($handle); 
	} else {
		$message = "ERROR openning the template for creating the content node.";
		echo '<response><status>' . urlencode($message) . '</status></response>';
		//fclose($logHandle);
		exit();
	}
} 

?>