<?php


//*********************************
// delete a content node from disk
//*********************************

include "includes/getDocumentRoot.inc.php";

$directory = "";
$filename = "";
$sitename = "";
$scenename = "";

ini_set("always_populate_raw_post_data", true);

 function rmdirr($dirname)
 {
     // Sanity check
     if (!file_exists($dirname)) {
         return false;
     }
  
     // Simple delete for a file
     if (is_file($dirname) || is_link($dirname)) {
         return unlink($dirname);
     }
  
     // Loop through the folder
     $dir = dir($dirname);
     while (false !== $entry = $dir->read()) {
         // Skip pointers
         if ($entry == '.' || $entry == '..') {
             continue;
         }
  
         // Recurse
         rmdirr($dirname . DIRECTORY_SEPARATOR . $entry);
     }
  
     // Clean up
     $dir->close();
     return rmdir($dirname);
 }

// The handler for the XML element opening tags
function startElementHandler($parser, $name, $attr) {
	global $directory, $filename, $sitename, $scenename;
	
	if (strcmp($name, "MAPNODE") == 0) {
		$directory = $attr["DIRECTORY"];
		$filename = $attr["FILENAME"];
		$sitename = $attr["SITENAME"];
		$scenename = $attr["SCENENAME"];
	}
}

// The handler for the XML element closing tags
function endElementHandler () {
	// nothing to do in this case
}

// create our XML parser
$parser = xml_parser_create();

// register the start and end element handlers
xml_set_element_handler($parser, "startElementHandler", "endElementHandler");

if (!xml_parse($parser, $HTTP_RAW_POST_DATA, true)) {
	// return XML document with an error message
	$errormsg = "There was an error in the XML line " .
				xml_get_current_line_number($parser) . " at position " .
				xml_get_current_column_number($parser);

	echo "<response><status>". $message ."</status></response>";
	exit;
}

// finished parsing the XML
xml_parser_free($parser);

if ($directory == "" || $filename == "" || $scenename == "") {
	$message = "Unexpected error";
	echo "<response><status>". $message ."</status></response>";
	exit;
}


//location of the content node directory to delete
$fullpath = "../" . $directory . $filename;

// remove the directory
$delResult = rmdirr($fullpath);

if ($delResult) {
	$message = "success";

	// also remove the shadow HTML page
	$shadowHTML = "../../" . urldecode($scenename) . ".php";
	unlink($shadowHTML);
} else {
	$message = "Error Deleting the scene!";
}
echo "<response><status>". $message ."</status><filename>" . $filename . "</filename><sitename>" . $sitename . "</sitename></response>";
?>