<?php

//************************************
// create a new photo album directory
//************************************

include "includes/getDocumentRoot.inc.php";

// global variables
$site = "";
$message = "";

ini_set("always_populate_raw_post_data", true);

function rmdirr($dirname) {
	// Sanity check
	if (!file_exists($dirname)) {
	 return false;
	}

	// Simple delete for a file
	if (is_file($dirname) || is_link($dirname)) {
	 return unlink($dirname);
	}

	// Loop through the folder
	$dir = dir($dirname);
	while (false !== $entry = $dir->read()) {
	 // Skip pointers
	 if ($entry == '.' || $entry == '..') {
		 continue;
	 }

	 // Recurse
	 rmdirr($dirname . DIRECTORY_SEPARATOR . $entry);
	}

	// Clean up
	$dir->close();
	return rmdir($dirname);
}

// The handler for the XML element opening tags
function startElementHandler($parser, $name, $attr) {
	global $site, $message;

	// TODO: we also need the full path, so we can set the path, such as "content/sitename/merchants/maps/" for saving the map
	if (strcmp($name, "DELETEPHOTOALBUMS") == 0) {
		// $dir = $attr["DIR"];
		$site = $attr["SITE"];
	} else if (strcmp($name, "ALBUM") == 0) {
		$dir = $attr["DIR"];
				
		$photoAlbumDir = getDocumentRoot() . $site . "/photoAlbums/" . $dir;
		if (is_dir($photoAlbumDir)) {

			// delete the directory (and all its content)
			$delResult = rmdirr($photoAlbumDir);
			if (!$delResult) {
				if ($message == "") {
					$message = "Error deleting the directory for the photo album(s): " . $dir;
				} else {
					$message .= ", " . $dir;
				}
			}
		}
	}

}

// The handler for the XML element closing tags
function endElementHandler () {
	// nothing to do in this case
}

// create our XML parser
$parser = xml_parser_create();

// register the start and end element handlers
xml_set_element_handler($parser, "startElementHandler", "endElementHandler");


if (!xml_parse($parser, $HTTP_RAW_POST_DATA, true)) {
	// return XML document with an error message
	$message = "There was an error in the XML line " .
				xml_get_current_line_number($parser) . " at position " .
				xml_get_current_column_number($parser);
	echo "<response><status>". $message ."</status></response>";
	exit;
}

// finished parsing the XML
xml_parser_free($parser);

if ($message != "") {
	$message .= ".";
	echo "<response><status>" . $message . "</status></response>";
} else {
	echo "<response><status>success</status></response>";
}
?>