<html>
<head><title>File Uploader</title>
<style type="text/css">
<!--
.style1 {
	font-family: Verdana, Arial, Helvetica, sans-serif;
	font-size: small;
	color: #666666;
}
-->
</style>

</head>
<script language="JavaScript" type="text/javascript">
	var uploadFilename = "";
	var uploadFlag = "false";
	var uploadMessage = "success";

	function showWiseNav() {

		var flash;

		// get the flash object
		if (navigator.appName.indexOf("Microsoft") != -1) {
			//alert("Microsoft environment");
			flash = top.document.all.myflashObjectID;

		} else {
			//alert("Firefox environment");
			flash = top.document.myflashObjectID;
		}
		if (flash != null) {
			flash.uploadViaBrowserResult(uploadFlag, uploadMessage, uploadFilename);
		} else {
			alert("An error occured in updating WiseNav.");
		}

		var d = top.document.getElementById('uploadfile');
		if (d != null) {
			d.innerHTML = '';
		} else {
			alert("An error was encountered while closing the upload dialog!");
		}
	}

	// cancel the file upload
	function cancelUpload() {
		uploadFlag = "false";
		uploadMessage = "Upload canceled by user.";
		uploadFilename = "uploadCanceled";
		showWiseNav();
	}

	function isblank(s) {
		for(var i = 0; i < s.length; i++) {
			var c = s.charAt(i);
			if ((c != ' ') && (c != '\n') && (c != '\t')) return false;
		}
		return true;
	}


	function checkExt(filename, filetype){
		var fileext = filename.substr(filename.lastIndexOf('.') + 1);
		fileext = fileext.toLowerCase();
		// alert("file extension: " + fileext);
		  // Check file extenstion
		switch (filetype){
			case "image":
				if (fileext != "gif" && fileext != "jpg" && fileext != "jpeg" && fileext != "png") {
					return "An image with the file extension of ." + fileext + " is not supported.";
				}
				break;
			case "movie":
				if (fileext != "flv") {
					return "A video with the file extension of ." + fileext + " is not supported.";
				}
				break;
			case "swfAnimation":
				if (fileext != "swf") {
					return "An animated movie with the file extension of ." + fileext + " is not supported";
				}
				break;
			case "audio":
				if (fileext != "mp3") {
					return "An audio clip with the file extension of ." + fileext + " is not supported.";
				}
				break;
			default : return "Unknown File type.";
		}	

		 // formObj.fileToUpload.focus();
		return "";
	}

	function submitMyForm(b) {
		
		var myfile = b.form.userfile.value;
		if (isblank(myfile)) {
			var textElement = document.getElementById('errorMessage');
			if (textElement != null) {
				textElement.innerHTML = "* You must select a file name";
			}
			return;	
		}

		var filetype = b.form.uploadtype.value;
		var returnMessage = checkExt(myfile, filetype);
		if (returnMessage != "") {
			var textElement = document.getElementById('errorMessage');
			if (textElement != null) {
				textElement.innerHTML = "* " + returnMessage;
			}
			return;	
		}		

		b.disabled = true;
		b.value = 'Submitting';
		b.form.submit();

		var d = document.getElementById('uploadForm');
		if (d != null) {
			d.style.visibility = "hidden";
		}
		d = document.getElementById('footerMessage');
		if (d!= null) {
			d.innerHTML = "* Uploading may take several minutes depending on the size of your file.";
		}
		
		// add an animated gif of a busy cursor
		d = document.getElementById('busyCursor');
		if (d != null) {
			// alert("Will show busy cursor here");
			d.style.visibility = "visible";
		} else {
			alert("invalid busycursor id");
		} 
	}

</script>
<body background="uploadBackground.png" border="0" scroll="no">
<!-- <image src="uploadHeader.jpg"/> -->

<?php
	
   /* page variables */	
	$debug = 0;
	// $destinationDir = '../../content/PlaceHolder/images/mapImages/';

	
	if($_SERVER['REQUEST_METHOD']=='POST') {
		echo "<br/><br/>";

		$destinationDir = $_POST['destination'];
		$uploadtype = $_POST['uploadtype'];
		$myImageWidth = $_POST['imageWidth'];
		$myImageHeight = $_POST['imageHeight'];
		$fileUploadSize = $_POST['fileUploadSize'];
		$fileUploadSize *= 1024;  // change into bytes


		// check for an error
		if ($_FILES['userfile']['error'] != 0) {
			switch($_FILES['userfile']['error']){
				case 1: //uploaded file exceeds the upload_max_filesize directive in php.ini
					$errMsg = "The file you are trying to upload is too big (code=1).";
					break;
				case 2: //uploaded file exceeds the MAX_FILE_SIZE directive that was specified in the html form
					$errMsg = "The file you are trying to upload is too big (code=2).";
					break;
				case 3: //uploaded file was only partially uploaded
					$errMsg = "The file you are trying to upload was only partially uploaded.";
					break;
				case 4: //no file was uploaded
					$errMsg = "You must select a file for upload.";
					break;
				case 6: 
					$errMsg = "Upload error; missing a temporary folder.";
					break;
				case 7: 
					$errMsg = "Upload error; failed to write file to disk";
					break;
				default: //a default error, just in case!  :)
					$errMsg = "There was a problem with your upload.";
					break;
			}
			echo $errMsg;
			echo '<script>uploadFlag = "false"; uploadMessage="No file was selected for uploading."; uploadFilename = "uploadCanceled";</script>';
			echo '<br/><br/><input type="button" value="Close" onClick="showWiseNav()">';
			echo '</body></html>';
			exit();
		}

		if(!isset($_FILES['userfile']['tmp_name']))
        {
			echo 'No file was uploaded (your file is too big).';
			echo '<script>uploadFlag = "false"; uploadMessage="No file was selected for uploading."; uploadFilename = "uploadCanceled";</script>';
			echo '<br/><br/><input type="button" value="Close" onClick="showWiseNav()">';
			echo '</body></html>';
			exit();
        }

		if (!is_uploaded_file($_FILES['userfile']['tmp_name'])) {
			echo 'Your file was rejected by the server.';
			echo '<script>uploadFlag = "false"; uploadMessage="No file was selected for uploading."; uploadFilename = "uploadCanceled";</script>';
			echo '<br/><br/><input type="button" value="Close" onClick="showWiseNav()">';
			echo '</body></html>';
			exit();
		}

		// TODO: to chekck, the following 2 test could be removed since they should be raised in the above switch statement
		$userfile = $_FILES['userfile']['tmp_name'];	
		if ($userfile == "") {
			echo 'Upload was cancelled; the size of your file exceeds the maximum size allowed.';
			echo '<script>uploadFlag = "false"; uploadMessage="No file was selected for uploading."; uploadFilename = "uploadCanceled";</script>';
			echo '<br/><br/><input type="button" value="Close" onClick="showWiseNav()">';
			echo '</body></html>';
			exit();
		} 
		$userfile_size = $_FILES['userfile']['size'];
		if ($userfile_size > $fileUploadSize) {
			echo 'Upload was canceled since the size of your file (' . $userfile_size . ' Kb) exceeds the maximum allowed file size of ' . $fileUploadSize . ' Kb.';
			echo '<script>uploadFlag = "false"; uploadMessage="No file was selected for uploading."; uploadFilename = "uploadCanceled";</script>';
			echo '<br/><br/><input type="button" value="Close" onClick="showWiseNav()">';
			echo '</body></html>';
			exit();
		}
				
		$userfile_name = $_FILES['userfile']['name'];
		$userfile_type = $_FILES['userfile']['type'];
		// get the file extension
		$extensionPos = strrpos($userfile_name, '.');
		if ($extensionPos === false) {
			$errMsg = $userfile_name . " is an invalid file since it has no extension.";
			echo $errMsg;
			echo '<script>uploadFlag = "false"; uploadMessage="' . $errMsg . '"; uploadFilename = "uploadCanceled";</script>';
			echo '<br/><br/><input type="button" value="Close" onClick="showWiseNav()">';
			echo '</body></html>';
			exit();
		}
		$extensionPos++;

		// extract the file extension
		$myLength = strlen($userfile_name);
		$extensionLength = $myLength - $extensionPos;
		$myExtension = substr($userfile_name, $extensionPos, $extensionLength);

		#Check if the filename matches default
		$fileext = strtolower($myExtension);
		$validExtension = false;
		$errMsg = $userfile_name . " has an invalid extension of ." . $fileext;
		switch ($uploadtype) {
			case "image":
				if ($fileext == "gif" || $fileext == "jpg" || $fileext == "jpeg" || $fileext == "png") {
					// getting the size of the image will confirm that this is indeed an image,
					// and not a file disguised with an image extension
					if (function_exists("gd_info")) {
						$imageInfo = getimagesize($userfile);
						if ($imageInfo) {
							$validExtension = true;
						} else {
							$errMsg = "Upload canceled, " . $userfile_name . " could not be identified as a valid image.";
						}
					} else {
						$validExtension = true;
					}
				}
				break;
			case "movie":
				if ($fileext == "flv") {
					$validExtension = true;
				}
				break;
			case "swfAnimation":
				if ($fileext == "swf") {
					$validExtension = true;
				}
				break;
			case "audio":
				if ($fileext == "mp3") {
					$validExtension = true;
				}
				break;
		}
		if (!$validExtension) {
			echo $errMsg;
			echo '<script>uploadFlag = "false"; uploadMessage="' . $errMsg . '"; uploadFilename = "uploadCanceled";</script>';
			echo '<br/><br/><input type="button" value="Close" onClick="showWiseNav()">';
			echo '</body></html>';
			exit();
		}
	  
		$destination = $destinationDir .$userfile_name;
		$result = move_uploaded_file ($userfile, $destination);
		if (!$result) {
			$errMsg = "There was a problem uploading your file.";
			echo $errMsg;
			echo '<script>uploadFlag = "false"; uploadMessage="' . $errMsg . '"; uploadFilename = "uploadCanceled";</script>';
			echo '<br/><br/><input type="button" value="Close" onClick="showWiseNav()">';
			echo '</body></html>';
			exit();
		} else {
			// the file has been moved but it does not have the proper file permission on Windows (IUSR needs to be able to view the file), so
			// create the new file name with proper permission
			if (!$fileHandle = fopen($destination ,"r")) {
				$errMsg = "An error (file open) occured while opening the image source.";
				echo $errMsg;
				echo '<script>uploadFlag = "false"; uploadMessage="' . $errMsg . '"; uploadFilename = "uploadCanceled";</script>';
				echo '<br/><br/><input type="button" value="Close" onClick="showWiseNav()">';
				echo '</body></html>';
				exit;
			}
			$mydata = fread($fileHandle, filesize($destination));
			fclose($fileHandle);
			$myfile = $destinationDir . uniqid(temporary);
			if (!$fileHandle2 = fopen($myfile ,"w")) {
				$errMsg = "An error (file open) occured while opening output image.";
				echo $errMsg;
				echo '<script>uploadFlag = "false"; uploadMessage="' . $errMsg . '"; uploadFilename = "uploadCanceled";</script>';
				echo '<br/><br/><input type="button" value="Close" onClick="showWiseNav()">';
				echo '</body></html>';
				exit;
			}

			if (fwrite($fileHandle2, $mydata) === FALSE) {
				$errMsg = "An error (file write) occured while copying the image.";
				echo $errMsg;
				echo '<script>uploadFlag = "false"; uploadMessage="' . $errMsg . '"; uploadFilename = "uploadCanceled";</script>';
				echo '<br/><br/><input type="button" value="Close" onClick="showWiseNav()">';
				echo '</body></html>';
				fclose($fileHandle2);
				exit;
			}

			fclose($fileHandle2);
			unlink($destination);
			rename($myfile, $destination);

			// if we have an image, resize it if it is bigger then the scene's dimension
			if ($uploadtype == "image" && function_exists("gd_info")) {
				resizeImageToFit($myImageWidth, $myImageHeight, $destination);
			}


			//echo $form;
			echo '<script>uploadFlag = "true"; uploadMessage="success"; uploadFilename = "' . $userfile_name . '";</script>';

			//echo '<font color=green>The file: '.$userfile_name .' has been successfully uploaded<br></font><br/>';
			echo '<script>showWiseNav()</script>';
		}	 
		echo '<input type="button" value="Close" onClick="showWiseNav()">';
	}	
	else {
		//New upload form
		$destinationDir = $_GET['destination'];
		$uploadtype = $_GET['uploadtype'];
		$flashObject = $_GET['myFlashObject'];
		$imageWidth = $_GET['imageWidth'];
		$imageHeight = $_GET['imageHeight'];
		$fileUploadSize = $_GET['fileUploadSize'];
		$fileBytesUploadSize = $fileUploadSize * 1024;
				
		#Check if the filename matches default
		switch ($uploadtype) {
			case "image":
				$title = "Please select an image: (supported file extension: .jpg, .jpeg, .gif, .png)"; 
				break;
			case "movie":
				$title = "Please select a video: (file extension of .flv supported)"; 
				break;
			case "swfAnimation":
				$title = "Please select an animated movie: (file extension of .swf supported)";
				break;
			case "audio":
				$title = "Please select an audio clip: (file extension of .mp3 supported)";
				break;
			default:
				// TODO: this should not happen, so we should throw an ERROR here
				$title = "Please select a file to upload:";
				break;
		}

		$form  = '
			<form name="frm" action="fileUpload.php" method="POST" enctype="multipart/form-data">
				<div id="uploadForm" style="visibility:visible">
					<input type="hidden" name="submitted" value="true">
					<input type="hidden" name="MAX_FILE_SIZE" value="' . $fileBytesUploadSize . '">
					<input type="hidden" name="uploadtype" value="' . $uploadtype . '">
					<input type="hidden" name="destination" value="' . $destinationDir . '">
					<input type="hidden" name="fileUploadSize" value="' . $fileUploadSize . '">
					<input type="hidden" name="imageWidth" value="' . $imageWidth . '">
					<input type="hidden" name="imageHeight" value="' . $imageHeight . '">
					<br/>
					<table>
						<tr><td>' . $title . '</td></tr>
						<tr><td><input type="file" name="userfile"><div id="errorMessage"></div></td></tr>
						<tr><td><input type="submit" name="btn_submit" value="Upload File" onClick="submitMyForm(this);return false;">
						<input type="button" value="Cancel" onClick="cancelUpload()"></td></tr>
					</table>
				</div>
			</form>
			<div id="busyCursor" style="position:absolute; left:10; top:40; visibility:hidden" >
				Your file is currently being uploaded...<img src="busy.gif" border=0/>
				<br/><br/><input type="button" value="Cancel" onclick="cancelUpload()">
			</div>
			<div id="footerMessage">* The server supports a mazimum file size of ' . $fileUploadSize . ' KB.</div>';
		echo $form;	
		//destination: ' . $destinationDir . ' type: ' . $uploadtype;
	}  	


	// TODO: this function is not working on IE on the UK server in testing accounts (need to try on Firefox); it could be a time out issue since
	//       I can see the the uploaded file on the server (with no resizing) and the upload dialog simpy goes empty (no GUI or content in the dialog)
	//       and the upload modal dialog never closes, forcing the user to refresh the browser.
	function resizeImageToFit($width, $height, $target_path) {
		return;

		// If width and heigth are set, then it's an image and we should handle
		// check to be sure that the image is within the limits
		if ($width != "" && $height != "") {
			
			// Get image dimensions and file type
			$imageInfo = @getimagesize($target_path);
			if (!$imageInfo) {
				// Failure !
				return;
			}
			$imageWidth = $imageInfo[0];
			$imageHeight = $imageInfo[1];
			$imageType = $imageInfo[2];
			if ($imageWidth == 0 || $imageHeight == 0) {
				return;
			}

			// If either of the dimensions is out of range, we resize the image.
			if ($imageWidth > $width || $imageHeight > $height) {

				// The height if we constrain the width is : 
				// height = width / (aspect ratio)
				$newHeight = ($width * $imageHeight) / $imageWidth;
				
				// The width if we constraint the height is :
				// width = height * (aspect ratio)
				$newWidth = ($height * $imageWidth) / $imageHeight;
				
				// Pick the constrained dimension that fits best		
				if ($newHeight <= $height) {
					// Constrained width works 
					$newWidth = $width;
				} else {
					// Constrained height works
					$newHeight = $height;
				}
							
				$image = NULL;
				switch ($imageType) {
					case IMAGETYPE_GIF:
						$image = @imagecreatefromgif($target_path);
						break;
					case IMAGETYPE_JPEG:
						$image = @imagecreatefromjpeg($target_path);
						break;
					case IMAGETYPE_PNG:
						$image = @imagecreatefrompng($target_path);
						break;
					default:
						// Unsupported (this would be odd).
						break;
				}
				// Did we open the image file?
				if ($image == FALSE || $image == NULL) {
					// Could not open the existing image
					return;
				}
					
				// Create an image to hold the scaled image
				if ($imageType == IMAGETYPE_GIF) {
					// GIF's can't be copied into true color images.
					$newImage = @imagecreate($newWidth, $newHeight);
					if ($newImage == FALSE) {
						@imagedestroy($image);
						$image = NULL;
						return;
					}
				} else {
					$newImage = @imagecreatetruecolor($newWidth, $newHeight);
					if ($newImage == FALSE) {
						@imagedestroy($image);
						$image = NULL;
						return;
					}
				}

				// Scale the original image into the new image
				$success = imagecopyresized($newImage, $image, 0, 0, 0, 0, $newWidth, $newHeight, $imageWidth, $imageHeight);
				if (!$success) {
					// Clean-up and bail out
					@imagedestroy($newImage);
					@imagedestroy($image);
					$newImage = NULL;
					$image = NULL;
					return;
				}
				
				// Close the original image so we can overwrite it.
				@imagedestroy($image);
				$image = NULL;
				
				// Save the resized image, overwriting the old image. 
				switch ($imageType) {
					case IMAGETYPE_GIF:
						@imagegif($newImage, $target_path);
						break;
					case IMAGETYPE_JPEG:
						@imagejpeg($newImage, $target_path);
						break;
					case IMAGETYPE_PNG:
						@imagepng($newImage, $target_path);
						break;
					default:
						// Unsupported (this would be odd).
						break;
				}
				
				// Finally, make sure we clean-up after ourselves
				@imagedestroy($newImage);
				$newImage = NULL;
				$image = NULL;
			}
		}
	}

?>
</body>
</html>