<?php 
/*********************************************************************************
Function: resizeImageJPG
Parameters: $forcedwidth  = new width of jpeg to be created
            $forcedheight = new height of jpeg to be created
				$sourcefile   = original jpeg that is to be resized
				$destfile     = new jpeg that is to be created
				$imgqual      = image quality (0 is best quality, 100 is most compressed)
Returns: true on success, false on failure
Side Effects: creates a new jpeg of $forcedwidth*$forcedheight size called $destfile
*********************************************************************************/
function resizeImageJPG ($forcedwidth, $forcedheight, $sourcefile, $destfile, $imgqual) {
	$g_imgcomp = 100-$imgqual;
	$g_srcfile = $sourcefile;
	$g_dstfile = $destfile;
	$g_fw = $forcedwidth;
	$g_fh = $forcedheight;
	$debug = 0;

	if (file_exists($g_srcfile)) {
		if ($debug) {
			echo "$g_srcfile exists<BR>";
		}
		$g_is = getimagesize($g_srcfile);

		//check to make sure it does not scale up.
		$g_diffw = $g_is[0] - $g_fw;
		$g_diffh = $g_is[1] - $g_fh; 
		if (($g_diffw >= 0) && ($g_diffh >= 0)) {
			if ($g_diffw >= $g_diffh) {
				$g_fh = ($g_fw/$g_is[0]) * $g_is[1];
			} else {
				$g_fw = ($g_fh/$g_is[1]) * $g_is[0]; 
			}
		}
	
      $img_src = imagecreatefromjpeg($g_srcfile);	
		if ($debug && $img_src == '') {
			echo "imagecreatefromjpeg failed<BR>";
		} elseif ($debug) {
			echo "imagecreatefromjpeg succeeded<BR>";
		}
		
		$img_dst = imagecreatetruecolor($g_fw, $g_fh);	
      $imgCpRES = imagecopyresampled($img_dst, $img_src, 0, 0, 0, 0, $g_fw, $g_fh, $g_is[0], $g_is[1]);
      $imgJPEG = imagejpeg($img_dst, $g_dstfile, $g_imgcomp);
      imagedestroy($img_dst);
		if ($imgJPEG) {
         return true;
		} else {
         return false;
		}
   } else {
		if ($debug) {
			echo "$g_srcfile does not exist<BR>";
		}
	}
}