<?php

// global variables
$siteWidth = "";
$siteHeight = "";


ini_set("always_populate_raw_post_data", true);

//$debugfd = fopen("c:/bogus/res.txt", "w+");
//fwrite($debugfd, "Startup \n");
//fflush($debugfd);
 

// The handler for the XML element opening tags
function startElementHandler($parser, $name, $attr) {
	global $siteWidth, $siteHeight;

	// TODO: we also need the full path, so we can set the path, such as "content/sitename/merchants/maps/" for saving the map
	if (strcmp($name, "RESOLUTION") == 0) {
		$siteWidth = $attr["SITEWIDTH"];
		$siteHeight = $attr["SITEHEIGHT"];

		// we are done parsing, exit the parser; NOTE: this doesn not work, it hangs, so we are stuck reading the whole document for now
		// xml_parser_free($parser);
	}
}

// The handler for the XML element closing tags
function endElementHandler () {
	// nothing to do in this case
}

// create our XML parser
//fwrite($debugfd, "calling xml_parse_create \n");
//fflush($debugfd);
$parser = xml_parser_create();


// register the start and end element handlers
xml_set_element_handler($parser, "startElementHandler", "endElementHandler");

//fwrite($debugfd, "calling xml_parse \n");
//fflush($debugfd);

if (!xml_parse($parser, $HTTP_RAW_POST_DATA, true)) {
	// return XML document with an error message
	$message = "There was an error in the XML line " .
				xml_get_current_line_number($parser) . " at position " .
				xml_get_current_column_number($parser);
	echo "<response><status>". $message ."</status></response>";
	exit;
}


// finished parsing the XML
xml_parser_free($parser);
//fwrite($debugfd, "After calling xml_parser_free \n");
//fflush($dbugfd);


if ($siteWidth == "" || $siteHeight == "") {
	$message = "Error reading the incomming site resolution...";
	echo "<response><status>". $message . "</status></response>";
	exit;
}

//fwrite($debugfd, "after parsing resolution \n");
//flush($dbugfd);



// read the index.html template file into memory and substitue the real resolution for WISENAV_WIDTH and WISENAV_HEIGHT
$filename = "includes/runtimeResolutionTemplate.php";
//$fp = fopen($filename, "r");
//$templateString = fread($fp, filesize($filename));
$templateString = file_get_contents($filename);
 //fclose($fp)

//fwrite($debugfd, "read template file: $templateString \n");
//fflush($debugfd);


// substitue the resolution
$widthSubstituted = str_replace("WISENAV_WIDTH", $siteWidth, $templateString);

//fwrite($debugfd, "substituted WISENAV_WIDTH \n");
//fflush($debugfd);


 $indexHTML = str_replace("WISENAV_HEIGHT", $siteHeight, $widthSubstituted);
//fwrite($debugfd, "final template file: $indexHTML \n");
//fflush($debugfd);

//we want to create/overwrite the index.html file
$filename2 = "../../index.html";
//fwrite($debugfd, "Writing resolution to file: $filename2 \n");
//fflush($debugfd);
$fp2 = fopen($filename2,"w+");
if (fwrite($fp2, $indexHTML)) {
	$message = "success";
} else {
	$message = "Error saving the runtime resolution file!";
}
fclose($fp2);


echo "<response><status>". $message . "</status></response>";  
?>