<?php

// get the file containing information on all directories and files to be updated

// Step 1: retrieve the version number that we will update to
$versionNumber = $_GET['version'];
$packageTarget = $_GET['target'];
$diskAutoUpdate = $GET['diskautoupdate'];
if ($diskAutoUpdate == "") {
	$diskAutoUpdate = "0";
}
$siteTarget = urldecode($_GET['autoupdatepath']);
if ($siteTarget == "") {
	$siteTarget = "http://www.wisenav.com/updates/";
}
$httpTarget = $siteTarget . "$versionNumber/$packageTarget/";

// Step 2: create the temporary directory to contain the update files
// build path to save document
$tempDirectory = $versionNumber;
$downloadDirectory = "";
// check if the subdirectory is already there, if not create it
if (file_exists($versionNumber)) {
	$subdir = $versionNumber . "/" . $packageTarget;
	if (file_exists($subdir)) {
		echo '<invalidresponse status="error" message="An update has already been performed for this version.  Please contact your HSP for more info."/>';
		return;
	}
} else {
	mkdir($versionNumber, 0772);
	// create the subdirectory
	mkdir($versionNumber . "/" . $packageTarget, 0772);
}
//fwrite($fp, "tempDirectory: $tempDirectory \n");

if ($diskAutoUpdate == "1") {
	// copy directly from disk

	$fullPath = $httpTarget . "updateinfo.xml";
	
	if ($fp = fopen($fullPath, 'r')) {
		$content = '';
		// keep reading until there's nothing left
		while ($line = fread($fp, 1024)) {
		  $fstring .= $line;
		}
		fclose($fp);
		if (strlen($fstring) < 1) {
			echo '<invalidresponse status="error" message="Unable to retrieve the update information."/>';
			exit();
		} else {
			// write the file to disk
			$xmlFile = $tempDirectory . "/updateinfo.xml";
			$fd = fopen($xmlFile, "w+");
			$fout = fwrite($fd, $fstring);
			fclose($fd);
		}
	} else {
		// an error occured when trying to open the specified url
		//echo "<br>error reading file via fopen";
		echo "error";
	}
} else if (ini_get('allow_url_fopen') == '1') {

	// Step 3: get the xml File describing all files to download
	$fstring = file_get_contents($httpTarget . "updateinfo.xml");
	if ($fstring == FALSE) {
		// TODO: error reading the file, do something... inform the user with ERROR CODE
		echo '<invalidresponse status="error" message="Unable to retrieve the update information."/>';
		exit();
	} else {
		// write the file to disk
		$xmlFile = $tempDirectory . "/updateinfo.xml";
		$fd = fopen($xmlFile, "w+");
		$fout = fwrite($fd, $fstring);
		fclose($fd);
	}
} else {
	echo '<invalidresponse status="error" message="allow_url_fopen protocol not supported."/>';
	exit();
}

$currentDir = $tempDirectory;
// The handler for the XML element opening tags
function startElementHandler($parser, $name, $attr) {
	global $versionNumber, $packageTarget, $fp;
	
	if ($name == "DIR") {
		// create the directory]
		$newName = $attr["NAME"];
		$newdir = "$versionNumber/$packageTarget/$newName";
		mkdir($newdir, 0772);
	}
}


// The handler for the XML element closing tags
function endElementHandler ($parser, $name) {
	global $currentDir, $downloadDirectory;
	if ($name == "DIR") {
		// we have reached the end of the directory, go back up one level
		$currentDir = dirname($currentDir);
		$downloadDirectory = dirname($downloadDirectory);
	}
}

// create our XML parser
$parser = xml_parser_create();

// register the start and end element handlers
xml_set_element_handler($parser, "startElementHandler", "endElementHandler");

// Step 3: open the XML document
if (!($xmlHandle = fopen($xmlFile, "r"))) {
	echo '<invalidresponse status="error" message="Access denied when saving update data to disk."/>';
	exit();
}

// Step 4: parse the XML document, create the required directory and download the files
while ($data = fread($xmlHandle, filesize($xmlFile))) {
	if (!xml_parse($parser, $data, feof($xmlHandle))) {
		// report an error
		echo '<invalidresponse status="error" message="Problem parsing the update information."/>';
	}
}
xml_parser_free($parser);

// Step 5: send back response to flash
echo "$fstring";
?>