#! /bin/sh
#
# Copyright 1997-2001 Microsoft Corporation -- All Rights Reserved.
#
# $Revision: 1.2 $
# $Date: 2003/02/27 22:07:46 $
#


# This script resets the permission of the current FrontPage
# server extensions tree to the default values.  We begin
# changing things at versionX.Y so that none of the .cnf files
# will be changed/compromised.

PATH=".:/bin:/usr/bin:/sbin:/usr/sbin:/usr/ucb:/etc:/usr/bsd"

# process the standard frontpage installation unless indicated
# otherwise on the command line
if [ "$1" = "" ] 
then
   FPDIR=/usr/local/frontpage/version5.0
else
   FPDIR=$1
fi

# come here if we fail at any point
die() {
   echo "Aborting, could not successfully $*"
   exit 1
}

# Change some of the simple stuff at the top
chown bin $FPDIR `dirname $FPDIR` || die chown top dirs
chgrp bin $FPDIR `dirname $FPDIR` || die chgrp top dirs
chmod 775 $FPDIR `dirname $FPDIR` || die chmod top dirs
chown bin $FPDIR/frontpage.cnf || die chown frontpage.cnf
chgrp bin $FPDIR/frontpage.cnf || die chgrp frontpage.cnf
chmod 664 $FPDIR/frontpage.cnf || die chmod frontpage.cnf
chown bin $FPDIR/*.sh $FPDIR/*.TXT $FPDIR/*.htm || die chown top level files
chgrp bin $FPDIR/*.sh $FPDIR/*.TXT $FPDIR/*.htm || die chgrp top level files
chmod 555 $FPDIR/*.sh                           || die chmod top level files
chmod 444             $FPDIR/*.TXT $FPDIR/*.htm || die chmod top level files

# Handle all of the non apache-fp directory trees
for dir in bin nls admin exes help ; do
    # we want everything owned by user bin, group bin
    chown -R bin $FPDIR/$dir      ||
        die chown $dir to bin
    chgrp -R bin $FPDIR/$dir      || 
        die chgrp $dir to bin
    # start with read only permissions and add in what we're missing
    chmod -R 444 $FPDIR/$dir      ||
        die make everything read only in $dir
    # directories all get execute/access permission
    for i in `find $FPDIR/$dir -type d -print` ; do
       chmod a+x $i || die add execute/access permissions to $i
    done
    # scripts and programs all get execute/access permission
    for i in `find $FPDIR/$dir -type f -print` ; do
       case "$i" in
          *.exe) chmod a+x $i || die set execute permissions for $i ;;
          *.sh)  chmod a+x $i || die set execute permissions for $i ;;
          httpd) chmod a+x $i || die set execute permissions for $i ;;
         *) ;;
       esac
    done
done

# bin/_vti_inf.htm and bin/postinfo.htm need user write permission
chmod u+w $FPDIR/bin/_vti_inf.htm || die chmod write perm on _vti_inf.htm
chmod u+w $FPDIR/bin/postinfo.htm || die chmod write perm on postinfo.htm

# The apache-fp directory tree should be owned by root, group bin
chown -R root $FPDIR/apache-fp || die chown apache-fp
chgrp -R bin  $FPDIR/apache-fp || die chgrp apache-fp

# Remove all write/execute permissions
chmod -R ugo-wx,ugo+r $FPDIR/apache-fp

# The apache-fp fpexe stub needs to be suid root
chmod 4755 $FPDIR/apache-fp/_vti_bin/fpexe || die set fpexe to be suid

# Set httpd
chmod 555  $FPDIR/apache-fp/httpd || die make httpd executable

# The apache-fp directory should not be writable to protect the stub program.
chmod 555  $FPDIR/apache-fp/_vti_bin || die restrict the apache-fp directory

# The apache-fp directory should not be group/world readable or writable to
# protect the suidkey.pid files..  
chmod 711 $FPDIR/apache-fp || die restrict the apache-fp directory

# The suidkey files should all be completely close to group/world
for i in $FPDIR/apache-fp/suidkey* ; do
    if [ -f "$i" ]
    then
       chmod 600 $i || 
       die remove rwx group/world permissions from the suidkey file $i
    fi
done
