<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head><!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>Optimisation des performances d'Apache - Serveur Apache HTTP</title>
<link href="../style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="../style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="../style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" />
<link href="../images/favicon.ico" rel="shortcut icon" /></head>
<body id="manual-page"><div id="page-header">
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="../faq/">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.3</p>
<img alt="" src="../images/feather.gif" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="../images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="../">Version 2.3</a> &gt; <a href="./">Documentations diverses</a></div><div id="page-content"><div id="preamble"><h1>Optimisation des performances d'Apache</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="../en/misc/perf-tuning.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/misc/perf-tuning.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ko/misc/perf-tuning.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a> |
<a href="../tr/misc/perf-tuning.html" hreflang="tr" rel="alternate" title="Trke">&nbsp;tr&nbsp;</a></p>
</div>


    <p>Apache 2.x est un serveur web  usage gnral, conu dans un but
    d'quilibre entre souplesse, portabilit et performances. Bien que non
    conu dans le seul but d'tablir une rfrence en la matire,
    Apache 2.x est capable de hautes performances dans de nombreuses situations
    du monde rel.</p>

    <p>Compare  Apache 1.3, la version 2.x comporte de nombreuses
    optimisations supplmentaires permettant d'amliorer le dbit du serveur
    et sa personnalisation. La plupart de ces amliorations sont actives par
    dfaut. Cependant, certains choix de configuration  la compilation et 
    l'excution peuvent affecter les performances de manire significative. Ce
    document dcrit les options qu'un administrateur de serveur peut configurer
    pour amliorer les performances d'une installation d'Apache 2.x. Certaines
    de ces options de configuration permettent au dmon httpd de mieux tirer
    parti des possibilits du matriel et du systme d'exploitation, tandis
    que d'autres permettent  l'administrateur de privilgier la vitesse
    par rapport aux fonctionnalits.</p>

  </div>
<div id="quickview"><ul id="toc"><li><img alt="" src="../images/down.gif" /> <a href="#hardware">Problmes matriels et relatifs au systme d'exploitation</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#runtime">Optimisation de la configuration  l'excution</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#compiletime">Optimisation de la configuration  la compilation</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#trace">Appendice : Analyse dtaille d'une trace</a></li>
</ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="hardware" id="hardware">Problmes matriels et relatifs au systme d'exploitation</a></h2>

    

    <p>Le principal problme matriel qui affecte les performances du serveur
    web est la mmoire vive (RAM). Un serveur web ne devrait jamais avoir 
    utiliser le swap, car le swapping augmente le temps de rponse de chaque
    requte au del du point que les utilisateurs considrent comme
    "trop lent". Ceci incite les utilisateurs  cliquer sur "Stop", puis
    "Charger  nouveau", ce qui a pour effet d'augmenter encore la charge
    du serveur. Vous pouvez, et mme devez dfinir la valeur de la directive
    <code class="directive"><a href="../mod/mpm_common.html#maxrequestworkers">MaxRequestWorkers</a></code> de faon  ce que
    votre serveur ne lance pas un nombre de processus enfants tel qu'il
    commence  faire du swapping. La mthode pour y parvenir est
    simple : dterminez la taille de votre processus Apache standard en
    consultant votre liste de processus  l'aide d'un outil tel que
    <code>top</code>, et divisez votre quantit totale de mmoire disponible
    par cette taille, tout en gardant un espace suffisant
    pour les autres processus.</p>

    <p>Hormis ce rglage relatif  la mmoire, le reste est trivial : le
    processeur, la carte rseau et les disques doivent tre suffisamment
    rapides, o "suffisamment rapide" doit tre dtermin par
    l'exprience.</p>

    <p>Le choix du systme d'exploitation dpend principalement du
    contexte local. Voici cependant quelques conseils qui se sont
    gnralement avrs utiles :</p>

    <ul>
      <li>
        <p>Excutez la dernire version stable et le niveau de patches le
	plus haut du systme d'exploitation que vous avez choisi. De nombreux
	diteurs de systmes d'exploitation ont amlior de manire
	significative les performances de leurs piles TCP et de leurs
	bibliothques de thread ces dernires annes.</p>
      </li>

      <li>
        <p>Si votre systme d'exploitation possde un appel systme
	<code>sendfile(2)</code>, assurez-vous d'avoir install la version
	et/ou les patches ncessaires  son activation. (Pour Linux, par
	exemple, cela se traduit par Linux 2.4 ou plus. Pour les versions
	anciennes de Solaris 8, vous pouvez tre amen  appliquer un patch.)
	Sur les systmes o il est disponible, <code>sendfile</code> permet
	 Apache 2 de servir les contenus statiques plus rapidement, tout en
	induisant une charge CPU infrieure.</p>
      </li>
    </ul>

  </div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="runtime" id="runtime">Optimisation de la configuration  l'excution</a></h2>

    

    <table class="related"><tr><th>Modules Apparents</th><th>Directives Apparentes</th></tr><tr><td><ul><li><code class="module"><a href="../mod/mod_dir.html">mod_dir</a></code></li><li><code class="module"><a href="../mod/mpm_common.html">mpm_common</a></code></li><li><code class="module"><a href="../mod/mod_status.html">mod_status</a></code></li></ul></td><td><ul><li><code class="directive"><a href="../mod/core.html#allowoverride">AllowOverride</a></code></li><li><code class="directive"><a href="../mod/mod_dir.html#directoryindex">DirectoryIndex</a></code></li><li><code class="directive"><a href="../mod/core.html#hostnamelookups">HostnameLookups</a></code></li><li><code class="directive"><a href="../mod/core.html#enablemmap">EnableMMAP</a></code></li><li><code class="directive"><a href="../mod/core.html#enablesendfile">EnableSendfile</a></code></li><li><code class="directive"><a href="../mod/core.html#keepalivetimeout">KeepAliveTimeout</a></code></li><li><code class="directive"><a href="../mod/prefork.html#maxspareservers">MaxSpareServers</a></code></li><li><code class="directive"><a href="../mod/prefork.html#minspareservers">MinSpareServers</a></code></li><li><code class="directive"><a href="../mod/core.html#options">Options</a></code></li><li><code class="directive"><a href="../mod/mpm_common.html#startservers">StartServers</a></code></li></ul></td></tr></table>

    <h3><a name="dns" id="dns">HostnameLookups et autres considrations  propos du DNS</a></h3>

      

      <p>Avant Apache 1.3, la directive
      <code class="directive"><a href="../mod/core.html#hostnamelookups">HostnameLookups</a></code> tait positionne
      par dfaut  <code>On</code>. Ce rglage augmente le temps de rponse de
      chaque requte car il entrane une recherche DNS et le traitement de la
      requte ne pourra pas tre achev tant que cette recherche ne sera
      pas termine. Avec Apache 1.3, ce rglage est dfini par dfaut 
      <code>Off</code>. Si vous souhaitez que les adresses dans vos fichiers
      journaux soient rsolues en noms d'htes, utilisez le programme
      <code class="program"><a href="../programs/logresolve.html">logresolve</a></code> fourni avec Apache, ou un des nombreux
      paquets gnrateurs de rapports sur les journaux disponibles.</p>

      <p>Il est recommand d'effectuer ce genre de traitement a posteriori
      de vos fichiers journaux sur une autre machine que celle qui hberge le
      serveur web en production, afin que cette activit n'affecte pas les
      performances du serveur.</p>

      <p>Si vous utilisez une directive
      <code><code class="directive"><a href="../mod/mod_access_compat.html#allow">Allow</a></code>from domain</code>
      ou
      <code><code class="directive"><a href="../mod/mod_access_compat.html#deny">Deny</a></code> from domain</code>
      (ce qui signifie que vous utilisez un nom d'hte ou un nom de domaine 
      la place d'une adresse IP), vous devrez compter avec deux recherches
      DNS (une recherche inverse suivie d'une recherche directe pour
      s'assurer que l'adresse IP n'a pas t usurpe). C'est pourquoi il est
      prfrable, pour amliorer les performances, d'utiliser des adresses IP
      plutt que des noms lorsqu'on utilise ces directives, du moins chaque
      fois que c'est possible.</p>

      <p>Notez qu'il est possible de modifier la porte des directives, en les
      plaant par exemple  l'intrieur d'une section
      <code>&lt;Location /server-status&gt;</code>. Les recherches DNS ne
      seront alors effectues que pour les requtes qui satisfont aux critres.
      Voici un exemple qui dsactive les recherches DNS sauf pour les fichiers
      <code>.html</code> et <code>.cgi</code> :</p>

      <div class="example"><p><code>
        HostnameLookups off<br />
        &lt;Files ~ "\.(html|cgi)$"&gt;<br />
        <span class="indent">
          HostnameLookups on<br />
        </span>
        &lt;/Files&gt;
      </code></p></div>

      <p>Mais mme dans ce cas, si vous n'avez besoin de noms DNS que dans
      certains CGIs, vous pouvez effectuer l'appel  <code>gethostbyname</code>
      dans les CGIs spcifiques qui en ont besoin.</p>

    

    <h3><a name="symlinks" id="symlinks">FollowSymLinks et SymLinksIfOwnerMatch</a></h3>

      

      <p>Chaque fois que la ligne <code>Options FollowSymLinks</code> sera
      absente, ou que la ligne <code>Options SymLinksIfOwnerMatch</code> sera
      prsente dans votre espace d'adressage, Apache devra effectuer des
      appels systme supplmentaires pour vrifier la prsence de liens
      symboliques. Un appel supplmentaire par lment du chemin du fichier.
      Par exemple, si vous avez :</p>

      <div class="example"><p><code>
        DocumentRoot /www/htdocs<br />
        &lt;Directory /&gt;<br />
        <span class="indent">
          Options SymLinksIfOwnerMatch<br />
        </span>
        &lt;/Directory&gt;
      </code></p></div>

      <p>et si une requte demande l'URI <code>/index.html</code>, Apache
      effectuera un appel  <code>lstat(2)</code> pour
      <code>/www</code>, <code>/www/htdocs</code>, et
      <code>/www/htdocs/index.html</code>. Les rsultats de ces appels 
      <code>lstat</code> ne sont jamais mis en cache, ils devront donc tre
      gnrs  nouveau pour chaque nouvelle requte. Si vous voulez absolument
      vrifier la scurit des liens symboliques, vous pouvez utiliser une
      configuration du style :</p>

      <div class="example"><p><code>
        DocumentRoot /www/htdocs<br />
        &lt;Directory /&gt;<br />
        <span class="indent">
          Options FollowSymLinks<br />
        </span>
        &lt;/Directory&gt;<br />
        <br />
        &lt;Directory /www/htdocs&gt;<br />
        <span class="indent">
          Options -FollowSymLinks +SymLinksIfOwnerMatch<br />
        </span>
        &lt;/Directory&gt;
      </code></p></div>

      <p>Ceci vite au moins les vrifications supplmentaires pour le chemin
      dfini par <code class="directive"><a href="../mod/core.html#documentroot">DocumentRoot</a></code>. Notez que
      vous devrez ajouter des sections similaires si vous avez des chemins
      dfinis par les directives
      <code class="directive"><a href="../mod/mod_alias.html#alias">Alias</a></code> ou
      <code class="directive"><a href="../mod/mod_rewrite.html#rewriterule">RewriteRule</a></code> en dehors de
      la racine de vos documents. Pour amliorer les performances, et supprimer
      toute protection des liens symboliques, ajoutez l'option
      <code>FollowSymLinks</code> partout, et n'utilisez jamais l'option
      <code>SymLinksIfOwnerMatch</code>.</p>

    

    <h3><a name="htacess" id="htacess">AllowOverride</a></h3>

      

      <p>Dans toute partie de votre espace d'adressage o vous autoriserez
      la surcharge de la configuration (en gnral  l'aide de fichiers
      <code>.htaccess</code>), Apache va tenter d'ouvrir <code>.htaccess</code>
      pour chaque lment du chemin du fichier demand. Par exemple, si vous
      avez : </p>

      <div class="example"><p><code>
        DocumentRoot /www/htdocs<br />
        &lt;Directory /&gt;<br />
        <span class="indent">
          AllowOverride all<br />
        </span>
        &lt;/Directory&gt;
      </code></p></div>

      <p>et qu'une requte demande l'URI <code>/index.html</code>, Apache
      tentera d'ouvrir <code>/.htaccess</code>, <code>/www/.htaccess</code>,
      et <code>/www/htdocs/.htaccess</code>. Les solutions sont similaires 
      celles voques prcdemment pour <code>Options FollowSymLinks</code>.
      Pour amliorer les performances, utilisez <code>AllowOverride None</code>
      pour tous les niveaux de votre espace d'adressage.</p>

    

    <h3><a name="negotiation" id="negotiation">Ngociation</a></h3>

      

      <p>Dans la mesure du possible, vitez toute ngociation de contenu si
      vous tenez au moindre gain en performances. En pratique toutefois,
      les bnfices de la ngociation l'emportent souvent sur la diminution
      des performances.
      Il y a cependant un cas dans lequel vous pouvez acclrer le serveur.
      Au lieu d'utiliser une directive gnrique comme :</p>

      <div class="example"><p><code>
        DirectoryIndex index
      </code></p></div>

      <p>utilisez une liste explicite d'options :</p>

      <div class="example"><p><code>
        DirectoryIndex index.cgi index.pl index.shtml index.html
      </code></p></div>

      <p>o vous placez le choix courant en premire position.</p>

      <p>Notez aussi que crer explicitement un fichier de
      <code>correspondances de type</code> fournit de meilleures performances
      que l'utilisation des <code>MultiViews</code>, car les informations
      ncessaires peuvent tre simplement obtenues en lisant ce fichier, sans
      avoir  parcourir le rpertoire  la recherche de types de fichiers.</p>

    <p>Par consquent, si la ngociation de contenu est ncessaire pour votre
    site, prfrez les fichiers de <code>correspondances de type</code> aux
    directives <code>Options MultiViews</code> pour mener  bien cette
    ngociation. Se rfrer au document sur la
    <a href="../content-negotiation.html">Ngociation de contenu</a> pour une
    description complte des mthodes de ngociation, et les instructions
    permettant de crer des fichiers de <code>correspondances de type</code>.</p>

    

    <h3>Transfert en mmoire</h3>

      

      <p>Dans les situations o Apache 2.x doit consulter le contenu d'un
      fichier en train d'tre servi - par exemple  l'occasion du traitement
      d'une inclusion ct serveur - il transfre en gnral le fichier en
      mmoire si le systme d'exploitation supporte une forme quelconque
      de <code>mmap(2)</code>.</p>

      <p>Sur certains systmes, ce transfert en mmoire amliore les
      performances. Dans certains cas, ce transfert peut toutefois les dgrader
      et mme diminuer la stabilit du dmon httpd :</p>

      <ul>
        <li>
          <p>Dans certains systmes d'exploitation, <code>mmap</code> devient
	  moins efficace que <code>read(2)</code> quand le nombre de
	  processeurs augmente. Sur les serveurs multiprocesseurs sous Solaris,
	  par exemple, Apache 2.x sert parfois les fichiers consults par le
	  serveur plus rapidement quand <code>mmap</code> est dsactiv.</p>
        </li>

        <li>
          <p>Si vous transfrez en mmoire un fichier localis dans un systme
	  de fichiers mont par NFS, et si un processus sur
	  une autre machine cliente NFS supprime ou tronque le fichier, votre
	  processus peut rencontrer une erreur de bus la prochaine fois qu'il
	  essaiera d'accder au contenu du fichier en mmoire.</p>
        </li>
      </ul>

      <p>Pour les installations o une de ces situations peut se produire,
      vous devez utiliser <code>EnableMMAP off</code> afin de dsactiver le
      transfert en mmoire des fichiers servis. (Note : il est possible de
      passer outre cette directive au niveau de chaque rpertoire.)</p>

    

    <h3>Sendfile</h3>

      

      <p>Dans les cas o Apache peut se permettre d'ignorer le contenu du
      fichier  servir - par exemple, lorsqu'il sert un contenu de fichier
      statique - il utilise en gnral le support sendfile du noyau si le
      systme d'exploitation supporte l'opration <code>sendfile(2)</code>.</p>

      <p>Sur la plupart des plateformes, l'utilisation de sendfile amliore
      les performances en liminant les mcanismes de lecture et envoi spars.
      Dans certains cas cependant, l'utilisation de sendfile peut nuire  la
      stabilit du dmon httpd :</p>

      <ul>
        <li>
          <p>Certaines plateformes peuvent prsenter un support de sendfile
	  dfaillant que la construction du systme n'a pas dtect, en
	  particulier si les binaires ont t construits sur une autre machine
	  et transfrs sur la machine o le support de sendfile est
	  dfaillant.</p>
        </li>
        <li>
          <p>Dans le cas d'un systme de fichiers mont
	  sous NFS, le noyau peut s'avrer incapable de servir
	  les fichiers rseau de manire fiable depuis
	  son propre cache.</p>
        </li>
      </ul>

      <p>Pour les installations o une de ces situations peut se produire,
      vous devez utiliser <code>EnableSendfile off</code> afin de dsactiver
      la mise  disposition de contenus de fichiers par sendfile. (Note : il
      est possible de passer outre cette directive au niveau de chaque
      rpertoire.)</p>

    

    <h3><a name="process" id="process">Process Creation</a></h3>

      

      <p>Avant Apache 1.3, les directives
      <code class="directive"><a href="../mod/prefork.html#minspareservers">MinSpareServers</a></code>,
      <code class="directive"><a href="../mod/prefork.html#maxspareservers">MaxSpareServers</a></code>, et
      <code class="directive"><a href="../mod/mpm_common.html#startservers">StartServers</a></code> avaient des
      effets drastiques sur les performances de rfrence. En particulier,
      Apache avait besoin d'un dlai de "monte en puissance" afin d'atteindre
      un nombre de processus enfants suffisant pour supporter la charge qui lui
      tait applique. Aprs le lancement initial des processus enfants par
      <code class="directive"><a href="../mod/mpm_common.html#startservers">StartServers</a></code>, seulement un
      processus enfant par seconde tait cr afin d'atteindre la valeur de la
      directive <code class="directive"><a href="../mod/prefork.html#minspareservers">MinSpareServers</a></code>. Ainsi,
      un serveur accd par 100 clients simultans et utilisant la valeur par
      dfaut de <code>5</code> pour la directive
      <code class="directive"><a href="../mod/mpm_common.html#startservers">StartServers</a></code>, ncessitait
      environ 95 secondes pour lancer suffisamment de processus enfants
      permettant de faire face  la charge. Ceci fonctionne en pratique pour
      les serveurs en production, car ils sont rarement redmarrs. Ce n'est
      cependant pas le cas pour les tests de rfrence (benchmarks) o le
      serveur ne fonctionne que 10 minutes.</p>

      <p>La rgle "un processus par seconde" avait t implmente afin
      d'viter l'enlisement de la machine dans le dmarrage de nouveaux
      processus enfants. Pendant que la machine est occupe  lancer des
      processus enfants, elle ne peut pas traiter les requtes. Mais cette
      rgle impactait tellement la perception des performances d'Apache qu'elle
      a d tre remplace. A partir d'Apache 1.3, le code a assoupli la rgle
      "un processus par seconde". Il va en lancer un, attendre une seconde,
      puis en lancer deux, attendre une seconde, puis en lancer quatre et
      ainsi de suite jusqu' lancer 32 processus. Il s'arrtera lorsque le
      nombre de processus aura atteint la valeur dfinie par la directive
      <code class="directive"><a href="../mod/prefork.html#minspareservers">MinSpareServers</a></code>.</p>

      <p>Ceci s'avre suffisamment ractif pour pouvoir en gnral se passer
      de manipuler les valeurs des directives
      <code class="directive"><a href="../mod/prefork.html#minspareservers">MinSpareServers</a></code>,
      <code class="directive"><a href="../mod/prefork.html#maxspareservers">MaxSpareServers</a></code> et
      <code class="directive"><a href="../mod/mpm_common.html#startservers">StartServers</a></code>. Lorsque plus de
      4 processus enfants sont lancs par seconde, un message est mis vers
      le journal des erreurs. Si vous voyez apparatre souvent ce genre de
      message, vous devez vous pencher sur ces rglages. Pour vous guider,
      utilisez les informations dlivres par le module
      <code class="module"><a href="../mod/mod_status.html">mod_status</a></code>.</p>

    <p> mettre en relation avec la cration de processus, leur destruction
    est dfinie par la valeur de la directive
    <code class="directive"><a href="../mod/mpm_common.html#maxconnectionsperchild">MaxConnectionsPerChild</a></code>. Sa valeur
    par dfaut est <code>0</code>, ce qui signifie qu'il n'y a pas de limite
    au nombre de connexions qu'un processus enfant peut traiter. Si votre
    configuration actuelle a cette directive rgle  une valeur trs basse,
    de l'ordre de <code>30</code>, il est conseill de l'augmenter de manire
    significative. Si vous utilisez SunOs ou une ancienne version de Solaris,
    utilisez une valeur de l'ordre de <code>10000</code>   cause des fuites
    de mmoire.</p>

    <p>Lorsqu'ils sont en mode "keep-alive", les processus enfants sont
    maintenus et ne font rien sinon attendre la prochaine requte sur la
    connexion dj ouverte. La valeur par dfaut de <code>5</code> de la
    directive <code class="directive"><a href="../mod/core.html#keepalivetimeout">KeepAliveTimeout</a></code> tend 
    minimiser cet effet. Il faut trouver le bon compromis entre la bande
    passante rseau et les ressources du serveur. En aucun cas vous ne devez
    choisir une valeur suprieure  <code>60</code> seconds, car
    <a href="http://www.hpl.hp.com/techreports/Compaq-DEC/WRL-95-4.html">
    la plupart des bnfices sont alors perdus</a>.</p>

    

  </div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="compiletime" id="compiletime">Optimisation de la configuration  la compilation</a></h2>

    

    <h3>Choisir un Module Multi-Processus (MPM)</h3>

      

      <p>Apache 2.x supporte les modles simultans enfichables, appels
      <a href="../mpm.html">Modules Multi-Processus</a> (MPMs). Vous devez
      choisir un MPM au moment de la construction d'Apache. Certaines
      plateformes ont des modules MPM spcifiques : 
      <code class="module"><a href="../mod/mpm_netware.html">mpm_netware</a></code>, <code class="module"><a href="../mod/mpmt_os2.html">mpmt_os2</a></code> et
      <code class="module"><a href="../mod/mpm_winnt.html">mpm_winnt</a></code>. Sur les systmes de type Unix, vous avez le
      choix entre un grand nombre de modules MPM. Le choix du MPM peut affecter
      la vitesse et l'volutivit du dmon httpd :</p>

      <ul>

        <li>Le MPM <code class="module"><a href="../mod/worker.html">worker</a></code> utilise plusieurs processus
	enfants possdant chacun de nombreux threads. Chaque thread gre une
	seule connexion  la fois. Worker est en gnral un bon choix pour les
	serveurs prsentant un traffic important car il possde une empreinte
	mmoire plus petite que le MPM prefork.</li>

        <li>Le MPM <code class="module"><a href="../mod/prefork.html">prefork</a></code> utilise plusieurs processus enfants
	possdant chacun un seul thread. Chaque processus gre une seule
	connexion  la fois. Sur de nombreux systmes, prefork est comparable
	en matire de vitesse  worker, mais il utilise plus de mmoire. De par
	sa conception sans thread, prefork prsente des avantages par rapport 
	worker dans certaines situations : il peut tre utilis avec les
	modules tiers qui ne supportent pas le threading, et son dbogage est plus
	ais sur les platesformes prsentant un support du dbogage des threads
	rudimentaire.</li>

      </ul>

      <p>Pour plus d'informations sur ces deux MPMs et les autres, veuillez
      vous rfrer  la <a href="../mpm.html">documentation sur les
      MPM</a>.</p>

    

    <h3><a name="modules" id="modules">Modules</a></h3>

        

        <p>Comme le contrle de l'utilisation de la mmoire est trs important
	en matire de performance, il est conseill d'liminer les modules que
	vous n'utilisez pas vraiment. Si vous avez construit ces modules en
	tant que <a href="../dso.html">DSOs</a>, leur limination consiste
	simplement  commenter la directive
	<code class="directive"><a href="../mod/mod_so.html#loadmodule">LoadModule</a></code> associe  ce
	module. Ceci vous permet de vrifier si votre site fonctionne toujours
	aprs la suppression de tel ou tel module.</p>

        <p>Par contre, si les modules que vous voulez supprimer sont lis
	statiquement  votre binaire Apache, vous devrez recompiler ce dernier
	afin de pouvoir les liminer.</p>

        <p>La question qui dcoule de ce qui prcde est videmment de
	savoir de quels modules vous avez besoin et desquels vous pouvez vous
	passer. La rponse sera bien entendu diffrente d'un site web 
	l'autre. Cependant, la liste <em>minimale</em> de modules ncessaire 
	la survie de votre site contiendra certainement
	<code class="module"><a href="../mod/mod_mime.html">mod_mime</a></code>, <code class="module"><a href="../mod/mod_dir.html">mod_dir</a></code> et
	<code class="module"><a href="../mod/mod_log_config.html">mod_log_config</a></code>. <code>mod_log_config</code> est bien
	entendu optionnel puisque vous pouvez faire fonctionner un site web
	en se passant de fichiers journaux ; ceci est cependant
	dconseill.</p>

    

    <h3>Oprations atomiques</h3>

      

      <p>Certains modules,  l'instar de <code class="module"><a href="../mod/mod_cache.html">mod_cache</a></code> et des
      versions de dveloppement rcentes du MPM worker, utilisent l'API
      atomique d'APR. Cette API propose des oprations atomiques que l'on
      peut utiliser pour allger la synchronisation des threads.</p>

      <p>Par dfaut, APR implmente ces oprations en utilisant les
      mcanismes les plus efficaces disponibles sur chaque plateforme cible
      (Systme d'exploitation et processeur). De nombreux processeurs modernes,
      par exemple, possdent une instruction qui effectue une opration
      atomique de type comparaison et change ou compare-and-swap (CAS) au
      niveau matriel. Sur certaines platesformes cependant, APR utilise par
      dfaut une implmentation de l'API atomique plus lente, base sur les
      mutex, afin d'assurer la compatibilit avec les anciens modles de
      processeurs qui ne possdent pas ce genre d'instruction. Si vous
      construisez Apache pour une de ces platesformes, et ne prvoyez de
      l'excuter que sur des processeurs rcents, vous pouvez slectionner une
      implmentation atomique plus rapide  la compilation en utilisant
      l'option <code>--enable-nonportable-atomics</code> du
      script configure :</p>

      <div class="example"><p><code>
        ./buildconf<br />
        ./configure --with-mpm=worker --enable-nonportable-atomics=yes
      </code></p></div>

      <p>L'option <code>--enable-nonportable-atomics</code> concerne les
      platesformes suivantes :</p>

      <ul>

        <li>Solaris sur SPARC<br />
            Sur Solaris/SPARC, APR utilise par dfaut les oprations
	    atomiques bases sur les mutex. Cependant, si vous ajoutez l'option
	    <code>--enable-nonportable-atomics</code> au script configure, APR
	    gnre un code qui utilise le code opration SPARC v8plus pour des
	    oprations de compare-and-swap matriel plus rapides. Si vous
	    utilisez cette option de configure avec Apache, les oprations
	    atomiques seront plus efficaces (permettant d'allger la charge du
	    processeur et un plus haut niveau de simultanit), mais
	    l'excutable produit ne fonctionnera que sur les processeurs
	    UltraSPARC.
	</li>

        <li>Linux sur x86<br />
            Sous Linux, APR utilise par dfaut les oprations atomiques bases
	    sur les mutex. Cependant, si vous ajoutez l'option
	    <code>--enable-nonportable-atomics</code> au script configure,
	    APR gnrera un code qui utilise un code d'opration du 486
	    pour des oprations de compare-and-swap matriel plus rapides. Le
	    code rsultant est plus efficace en matire d'oprations atomiques,
	    mais l'excutable produit ne fonctionnera que sur des processeurs
	    486 et suprieurs (et non sur des 386).
        </li>

      </ul>

    

    <h3>Module mod_status et ExtendedStatus On</h3>

      

      <p>Si vous incluez le module <code class="module"><a href="../mod/mod_status.html">mod_status</a></code>  la
      construction d'Apache et ajoutez <code>ExtendedStatus On</code>  sa
      configuration, Apache va effectuer pour chaque requte deux appels 
      <code>gettimeofday(2)</code> (ou <code>times(2)</code> selon votre
      systme d'exploitation), et (pour les versions antrieures  1.3) de
      nombreux appels supplmentaires  <code>time(2)</code>. Tous ces
      appels sont effectus afin que le rapport de statut puisse contenir
      des indications temporelles. Pour amliorer les performances, utilisez
      <code>ExtendedStatus off</code> (qui est le rglage par dfaut).</p>

    

    <h3>accept Serialization - points de connexion  un programme (sockets) multiples</h3>

      

    <div class="warning"><h3>Mise en garde :</h3>
      <p>Cette section n'a pas t totalement mise  jour car elle ne tient pas
      compte des changements intervenus dans la version 2.x du Serveur HTTP
      Apache. Certaines informations sont encore pertinentes, il vous est
      cependant conseill de les utiliser avec prudence.</p>
    </div>

      <p>Ce qui suit est une brve discussion  propos de l'API des sockets
      Unix. Supposons que votre serveur web utilise plusieurs directives
      <code class="directive"><a href="../mod/mpm_common.html#listen">Listen</a></code> afin d'couter
      plusieurs ports ou de multiples adresses. Afin de tester chaque socket
      pour voir s'il a une connexion en attente, Apache utilise
      <code>select(2)</code>. <code>select(2)</code> indique si un socket a
      <em>zro</em> ou <em>au moins une</em> connexion en attente. Le modle
      d'Apache comporte plusieurs processus enfants, et tous ceux qui sont
      inactifs testent la prsence de nouvelles connexions au mme moment.
      Une implmentation rudimentaire de ceci pourrait ressembler 
      l'exemple suivant
      (ces exemples ne sont pas extraits du code d'Apache, ils ne sont
      proposs qu' des fins pdagogiques) :</p>

      <div class="example"><p><code>
        for (;;) {<br />
        <span class="indent">
          for (;;) {<br />
          <span class="indent">
            fd_set accept_fds;<br />
            <br />
            FD_ZERO (&amp;accept_fds);<br />
            for (i = first_socket; i &lt;= last_socket; ++i) {<br />
            <span class="indent">
              FD_SET (i, &amp;accept_fds);<br />
            </span>
            }<br />
            rc = select (last_socket+1, &amp;accept_fds, NULL, NULL, NULL);<br />
            if (rc &lt; 1) continue;<br />
            new_connection = -1;<br />
            for (i = first_socket; i &lt;= last_socket; ++i) {<br />
            <span class="indent">
              if (FD_ISSET (i, &amp;accept_fds)) {<br />
              <span class="indent">
                new_connection = accept (i, NULL, NULL);<br />
                if (new_connection != -1) break;<br />
              </span>
              }<br />
            </span>
            }<br />
            if (new_connection != -1) break;<br />
          </span>
          }<br />
          process the new_connection;<br />
        </span>
        }
      </code></p></div>

      <p>Mais cette implmentation rudimentaire prsente une srieuse lacune.
      Rappelez-vous que les processus enfants excutent cette boucle au mme
      moment ; ils vont ainsi bloquer sur <code>select</code> s'ils se trouvent
      entre deux requtes. Tous ces processus bloqus vont se ractiver et
      sortir de <code>select</code> quand une requte va apparatre sur un des
      sockets (le nombre de processus enfants qui se ractivent varie en
      fonction du systme d'exploitation et des rglages de synchronisation).
      Ils vont alors tous entrer dans la boucle et tenter un
      <code>"accept"</code> de la connexion. Mais seulement un d'entre eux y
      parviendra (en supposant qu'il ne reste q'une seule connexion en
      attente), les autres vont se bloquer au niveau de <code>accept</code>.
      Ceci verrouille vraiment ces processus de telle sorte qu'ils ne peuvent
      plus servir de requtes que par cet unique socket, et il en sera ainsi
      jusqu' ce que suffisamment de nouvelles requtes apparaissent sur ce
      socket pour les ractiver tous. Cette lacune a t documente pour la
      premire fois dans
      <a href="http://bugs.apache.org/index/full/467">PR#467</a>. Il existe
      au moins deux solutions.</p>

      <p>La premire consiste  rendre les sockets non blocants. Dans ce cas,
      <code>accept</code> ne bloquera pas les processus enfants, et ils
      pourront continuer  s'excuter immdiatement. Mais ceci consomme des
      ressources processeur. Supposons que vous ayez dix processus enfants
      inactifs dans <code>select</code>, et qu'une connexion arrive.
      Neuf des dix processus vont se ractiver, tenter un <code>accept</code>
      de la connexion, chouer, et boucler dans <code>select</code>, tout en
      n'ayant finalement rien accompli. Pendant ce temps, aucun de ces processus
      ne traite les requtes qui arrivent sur d'autres sockets jusqu' ce
      qu'ils retournent dans <code>select</code>. Finalement, cette solution
      ne semble pas trs efficace,  moins que vous ne disposiez d'autant de
      processeurs inactifs (dans un serveur multiprocesseur) que de processus
      enfants inactifs, ce qui n'est pas une situation trs courante.</p>

      <p>Une autre solution, celle qu'utilise Apache, consiste  srialiser les
      entres dans la boucle interne. La boucle ressemble  ceci (les
      diffrences sont mises en surbrillance) :</p>

      <div class="example"><p><code>
        for (;;) {<br />
        <span class="indent">
          <strong>accept_mutex_on ();</strong><br />
          for (;;) {<br />
          <span class="indent">
            fd_set accept_fds;<br />
            <br />
            FD_ZERO (&amp;accept_fds);<br />
            for (i = first_socket; i &lt;= last_socket; ++i) {<br />
            <span class="indent">
              FD_SET (i, &amp;accept_fds);<br />
            </span>
            }<br />
            rc = select (last_socket+1, &amp;accept_fds, NULL, NULL, NULL);<br />
            if (rc &lt; 1) continue;<br />
            new_connection = -1;<br />
            for (i = first_socket; i &lt;= last_socket; ++i) {<br />
            <span class="indent">
              if (FD_ISSET (i, &amp;accept_fds)) {<br />
              <span class="indent">
                new_connection = accept (i, NULL, NULL);<br />
                if (new_connection != -1) break;<br />
              </span>
              }<br />
            </span>
            }<br />
            if (new_connection != -1) break;<br />
          </span>
          }<br />
          <strong>accept_mutex_off ();</strong><br />
          process the new_connection;<br />
        </span>
        }
      </code></p></div>

      <p><a id="serialize" name="serialize">Les fonctions</a>
      <code>accept_mutex_on</code> et <code>accept_mutex_off</code>
      implmentent un smaphore permettant une exclusion mutuelle. Un seul
      processus enfant  la fois peut possder le mutex. Plusieurs choix se
      prsentent pour implmenter ces mutex. Ce choix est dfini dans
      <code>src/conf.h</code> (versions antrieures  1.3) ou
      <code>src/include/ap_config.h</code> (versions 1.3 ou suprieures).
      Certaines architectures ne font pas ce choix du mode de verrouillage ;
      l'utilisation de directives
      <code class="directive"><a href="../mod/mpm_common.html#listen">Listen</a></code> multiples sur ces
      architectures est donc peu sr.</p>

      <p>La directive <code class="directive"><a href="../mod/core.html#mutex">Mutex</a></code> permet
      de modifier l'implmentation du mutex <code>mpm-accept</code> 
      l'excution. Des considrations spcifiques aux diffrentes
      implmentations de mutex sont documentes avec cette directive.</p>
      
      <p>Une autre solution qui a t imagine mais jamais implmente, consiste
       srialiser partiellement la boucle -- c'est  dire y faire entrer un
      certain nombre de processus. Ceci ne prsenterait un intrt que sur les
      machines multiprocesseurs o plusieurs processus enfants peuvent
      s'excuter simultanment, et encore, la srialisation ne tire pas
      vraiment parti de toute la bande passante. C'est une possibilit
      d'investigation future, mais demeure de priorit basse car les serveurs
      web  architecture hautement parallle ne sont pas la norme.</p>

      <p>Pour bien faire, vous devriez faire fonctionner votre serveur sans
      directives <code class="directive"><a href="../mod/mpm_common.html#listen">Listen</a></code> multiples
      si vous visez les performances les plus leves.
      Mais lisez ce qui suit.</p>

    

    <h3>accept Serialization - point de connexion  un programme (sockets) unique</h3>

      

      <p>Ce qui prcde convient pour les serveurs  sockets multiples, mais
      qu'en est-il des serveurs  socket unique ? En thorie, ils ne
      devraient pas rencontrer les mmes problmes car tous les processus
      enfants peuvent se bloquer dans <code>accept(2)</code> jusqu' ce qu'une
      connexion arrive, et ils ne sont pas utiliss  ne rien faire. En
      pratique, ceci dissimule un mme comportement de bouclage
      discut plus haut dans la solution non-blocante. De la manire dont
      sont implmentes les piles TCP, le noyau ractive vritablement tous les
      processus bloqus dans <code>accept</code> quand une seule connexion
      arrive. Un de ces processus prend la connexion en compte et retourne
      dans l'espace utilisateur, les autres bouclant dans l'espace du
      noyau et se dsactivant quand ils s'aperoivent qu'il n'y a pas de
      connexion pour eux. Ce bouclage est invisible depuis le code de l'espace
      utilisateur, mais il est quand-mme prsent. Ceci peut conduire  la
      mme augmentation de charge  perte que la solution non blocante au cas
      des sockets multiples peut induire.</p>

      <p>Pour cette raison, il apparat que de nombreuses architectures se
      comportent plus "proprement" si on srialise mme dans le cas d'une socket
      unique. Il s'agit en fait du comportement par dfaut dans la plupart des
      cas. Des expriences pousses sous Linux (noyau 2.0.30 sur un
      biprocesseur Pentium pro 166 avec 128 Mo de RAM) ont montr que la
      srialisation d'une socket unique provoque une diminution infrieure  3%
      du nombre de requtes par secondes par rapport au traitement non
      srialis. Mais le traitement non srialis des sockets uniques induit
      un temps de rponse supplmentaire de 100 ms pour chaque requte. Ce
      temps de rponse est probablement provoqu par une limitation sur les
      lignes  haute charge, et ne constitue un problme que sur les rseaux
      locaux. Si vous voulez vous passer de la srialisation des sockets
      uniques, vous pouvez dfinir
      <code>SINGLE_LISTEN_UNSERIALIZED_ACCEPT</code> et les
      serveurs  socket unique ne pratiqueront plus du tout la
      srialisation.</p>

    

    <h3>Fermeture en prenant son temps (Lingering close)</h3>

      

      <p>Comme discut dans <a href="http://www.ics.uci.edu/pub/ietf/http/draft-ietf-http-connection-00.txt">
      draft-ietf-http-connection-00.txt</a> section 8, pour implmenter de
      manire <strong>fiable</strong> le protocole, un serveur HTTP doit fermer
      les deux directions d'une communication indpendamment (rappelez-vous
      qu'une connexion TCP est bidirectionnelle, chaque direction tant
      indpendante de l'autre).</p>

      <p>Quand cette fonctionnalit fut ajoute  Apache, elle causa une
      avalanche de problmes sur plusieurs versions d'Unix  cause d'une
      implmentation  courte vue. La spcification TCP ne prcise pas que
      l'tat <code>FIN_WAIT_2</code> possde un temps de rponse mais elle ne
      l'exclut pas. Sur les systmes qui n'introduisent pas ce temps de
      rponse, Apache 1.2 induit de nombreux blocages dfinitifs de socket
      dans l'tat <code>FIN_WAIT_2</code>. On peut eviter ceci dans de nombreux
      cas tout simplement en mettant  jour TCP/IP avec le dernier patch mis 
      disposition par le fournisseur. Dans les cas o le fournisseur n'a
      jamais fourni de patch (par exemple, SunOS4 -- bien que les utilisateurs
      possdant une license source puissent le patcher eux-mmes), nous avons
      dcid de dsactiver cette fonctionnalit.</p>

      <p>Il y a deux mthodes pour arriver  ce rsultat. La premire est
      l'option de socket <code>SO_LINGER</code>. Mais le sort a voulu que cette
      solution ne soit jamais implmente correctement dans la plupart des
      piles TCP/IP. Et mme dans les rares cas o cette solution a t
      implmente correctement (par exemple Linux 2.0.31), elle se
      montre beaucoup plus gourmande (en temps processeur) que la solution
      suivante.</p>

      <p>Pour la plus grande partie, Apache implmente cette solution  l'aide
      d'une fonction appele <code>lingering_close</code> (dfinie dans
      <code>http_main.c</code>). La fonction ressemble approximativement 
      ceci :</p>

      <div class="example"><p><code>
        void lingering_close (int s)<br />
        {<br />
        <span class="indent">
          char junk_buffer[2048];<br />
          <br />
          /* shutdown the sending side */<br />
          shutdown (s, 1);<br />
          <br />
          signal (SIGALRM, lingering_death);<br />
          alarm (30);<br />
          <br />
          for (;;) {<br />
          <span class="indent">
            select (s for reading, 2 second timeout);<br />
            if (error) break;<br />
            if (s is ready for reading) {<br />
            <span class="indent">
              if (read (s, junk_buffer, sizeof (junk_buffer)) &lt;= 0) {<br />
              <span class="indent">
                break;<br />
              </span>
              }<br />
              /* just toss away whatever is here */<br />
            </span>
            }<br />
          </span>
          }<br />
          <br />
          close (s);<br />
        </span>
        }
      </code></p></div>

      <p>Ceci ajoute naturellement un peu de charge  la fin d'une connexion,
      mais s'avre ncessaire pour une implmentation fiable. Comme HTTP/1.1
      est de plus en plus prsent et que toutes les connexions sont
      persistentes, la charge sera amortie par la multiplicit des requtes.
      Si vous voulez jouer avec le feu en dsactivant cette fonctionnalit,
      vous pouvez dfinir <code>NO_LINGCLOSE</code>, mais c'est fortement
      dconseill. En particulier, comme les connexions persistantes en
      pipeline de HTTP/1.1 commencent  tre utilises,
      <code>lingering_close</code> devient une absolue ncessit (et les
      <a href="http://www.w3.org/Protocols/HTTP/Performance/Pipeline.html">
      connexions en pipeline sont plus rapides</a> ; vous avez donc tout
      intrt  les supporter).</p>

    

    <h3>Fichier tableau de bord (Scoreboard file)</h3>

      

      <p>Les processus parent et enfants d'Apache communiquent entre eux 
      l'aide d'un objet appel "Tableau de bord" (Scoreboard). Idalement, cet
      change devrait s'effectuer en mmoire partage. Pour les systmes
      d'exploitation auxquels nous avons eu accs, ou pour lesquels nous avons
      obtenu des informations suffisamment dtailles pour effectuer un
      portage, cet change est en gnral implment en utilisant la mmoire
      partage. Pour les autres, on utilise par dfaut un fichier d'change sur
      disque. Le fichier d'change sur disque est non seulement lent, mais
      aussi peu fiable (et propose moins de fonctionnalits). Recherchez dans
      le fichier <code>src/main/conf.h</code> correspondant  votre
      architecture soit <code>USE_MMAP_SCOREBOARD</code>, soit
      <code>USE_SHMGET_SCOREBOARD</code>. La dfinition de l'un des deux
      (ainsi que leurs compagnons respectifs <code>HAVE_MMAP</code> et
      <code>HAVE_SHMGET</code>), active le code fourni pour la mmoire
      partage. Si votre systme propose une autre solution pour la gestion de
      la mmoire partage, ditez le fichier <code>src/main/http_main.c</code>
      et ajoutez la portion de code ncessaire pour pouvoir l'utiliser dans
      Apache (Merci de nous envoyer aussi le patch correspondant).</p>

      <div class="note">Note  caractre historique : le portage d'Apache sous Linux
      n'utilisait pas la mmoire partage avant la version 1.2. Ceci entranait
      un comportement trs rudimentaire et peu fiable des versions antrieures
      d'Apache sous Linux.</div>

    

    <h3>DYNAMIC_MODULE_LIMIT</h3>

      

      <p>Si vous n'avez pas l'intention d'utiliser les modules chargs
      dynamiquement (ce qui est probablement le cas si vous tes en train de
      lire ce document afin de personnaliser votre serveur en recherchant le
      moindre des gains en performances), vous pouvez ajouter la dfinition
      <code>-DDYNAMIC_MODULE_LIMIT=0</code>  la construction de votre serveur.
      Ceci aura pour effet de librer la mmoire RAM alloue pour le
      chargement dynamique des modules.</p>

    

  </div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="trace" id="trace">Appendice : Analyse dtaille d'une trace</a></h2>

    

    <p>Voici la trace d'un appel systme d'Apache 2.0.38 avec le MPM worker
    sous Solaris 8. Cette trace a t collecte  l'aide de la commande :</p>

    <div class="example"><p><code>
      truss -l -p <var>httpd_child_pid</var>.
    </code></p></div>

    <p>L'option <code>-l</code> demande  truss de tracer l'ID du LWP
    (lightweight process--la version de Solaris des threads niveau noyau) qui
    invoque chaque appel systme.</p>

    <p>Les autres systmes peuvent proposer des utilitaires de traage
    des appels systme diffrents comme <code>strace</code>,
    <code>ktrace</code>, ou <code>par</code>. Ils produisent cependant tous une
    trace similaire.</p>

    <p>Dans cette trace, un client a demand un fichier statique de 10 ko au
    dmon httpd. Le traage des requtes pour des contenus non statiques
    ou comportant une ngociation de contenu a une prsentation
    diffrente (et mme assez laide dans certains cas).</p>

    <div class="example"><pre>/67:    accept(3, 0x00200BEC, 0x00200C0C, 1) (sleeping...)
/67:    accept(3, 0x00200BEC, 0x00200C0C, 1)            = 9</pre></div>

    <p>Dans cette trace, le thread  l'coute s'excute  l'intrieur de
    LWP #67.</p>

    <div class="note">Notez l'absence de la srialisation d'<code>accept(2)</code>. Sur
    cette plateforme spcifique, le MPM worker utilise un accept non srialis
    par dfaut sauf s'il est en coute sur des ports multiples.</div>

    <div class="example"><pre>/65:    lwp_park(0x00000000, 0)                         = 0
/67:    lwp_unpark(65, 1)                               = 0</pre></div>

    <p>Aprs avoir accept la connexion, le thread  l'coute ractive un
    thread du worker pour effectuer le traitement de la requte. Dans cette
    trace, le thread du worker qui traite la requte est associ 
    LWP #65.</p>

    <div class="example"><pre>/65:    getsockname(9, 0x00200BA4, 0x00200BC4, 1)       = 0</pre></div>

    <p>Afin de pouvoir implmenter les htes virtuels, Apache doit connatre
    l'adresse du socket local utilis pour accepter la connexion. On pourrait
    supprimer cet appel dans de nombreuses situations (par exemple dans le cas
    o il n'y a pas d'hte virtuel ou dans le cas o les directives
    <code class="directive"><a href="../mod/mpm_common.html#listen">Listen</a></code> contiennent des adresses
    sans caractres de substitution). Mais aucun effort n'a t accompli  ce
    jour pour effectuer ces optimisations.</p>

    <div class="example"><pre>/65:    brk(0x002170E8)                                 = 0
/65:    brk(0x002190E8)                                 = 0</pre></div>

    <p>L'appel <code>brk(2)</code> alloue de la mmoire dans le tas. Ceci est
    rarement visible dans une trace d'appel systme, car le dmon httpd
    utilise des allocateurs mmoire de son cru (<code>apr_pool</code> et
    <code>apr_bucket_alloc</code>) pour la plupart des traitements de requtes.
    Dans cette trace, le dmon httpd vient juste de dmarrer, et il doit
    appeler <code>malloc(3)</code> pour rserver les blocs de mmoire
    ncessaires  la cration de ses propres allocateurs de mmoire.</p>

    <div class="example"><pre>/65:    fcntl(9, F_GETFL, 0x00000000)                   = 2
/65:    fstat64(9, 0xFAF7B818)                          = 0
/65:    getsockopt(9, 65535, 8192, 0xFAF7B918, 0xFAF7B910, 2190656) = 0
/65:    fstat64(9, 0xFAF7B818)                          = 0
/65:    getsockopt(9, 65535, 8192, 0xFAF7B918, 0xFAF7B914, 2190656) = 0
/65:    setsockopt(9, 65535, 8192, 0xFAF7B918, 4, 2190656) = 0
/65:    fcntl(9, F_SETFL, 0x00000082)                   = 0</pre></div>

    <p>Ensuite, le thread de worker passe la connexion du client (descripteur
    de fichier 9) en mode non blocant. Les appels <code>setsockopt(2)</code>
    et <code>getsockopt(2)</code> constituent un effet de bord de la manire
    dont la libc de Solaris utilise <code>fcntl(2)</code> pour les sockets.</p>

    <div class="example"><pre>/65:    read(9, " G E T   / 1 0 k . h t m".., 8000)     = 97</pre></div>

    <p>Le thread de worker lit la requte du client.</p>

    <div class="example"><pre>/65:    stat("/var/httpd/apache/httpd-8999/htdocs/10k.html", 0xFAF7B978) = 0
/65:    open("/var/httpd/apache/httpd-8999/htdocs/10k.html", O_RDONLY) = 10</pre></div>

    <p>Ce dmon httpd a t configur avec les options
    <code>Options FollowSymLinks</code> et <code>AllowOverride None</code>. Il
    n'a donc ni besoin d'appeler <code>lstat(2)</code> pour chaque rpertoire
    du chemin du fichier demand, ni besoin de vrifier la prsence de fichiers
    <code>.htaccess</code>. Il appelle simplement <code>stat(2)</code> pour
    vrifier d'une part que le fichier existe, et d'autre part que c'est un
    fichier rgulier, et non un rpertoire.</p>

    <div class="example"><pre>/65:    sendfilev(0, 9, 0x00200F90, 2, 0xFAF7B53C)      = 10269</pre></div>

    <p>Dans cet exemple, le dmon httpd peut envoyer l'en-tte de la rponse
    HTTP et le fichier demand  l'aide d'un seul appel systme
    <code>sendfilev(2)</code>. La smantique de sendfile varie en fonction des
    systmes d'exploitation. Sur certains autres systmes, il faut faire un
    appel  <code>write(2)</code> ou <code>writev(2)</code> pour envoyer les
    en-ttes avant d'appeler <code>sendfile(2)</code>.</p>

    <div class="example"><pre>/65:    write(4, " 1 2 7 . 0 . 0 . 1   -  ".., 78)      = 78</pre></div>

    <p>Cet appel  <code>write(2)</code> enregistre la requte dans le journal
    des accs. Notez qu'une des choses manquant  cette trace est un appel 
    <code>time(2)</code>. A la diffrence d'Apache 1.3, Apache 2.x utilise
    <code>gettimeofday(3)</code> pour consulter l'heure. Sur certains systmes
    d'exploitation, comme Linux ou Solaris, <code>gettimeofday</code> est
    implment de manire optimise de telle sorte qu'il consomme moins de
    ressources qu'un appel systme habituel.</p>

    <div class="example"><pre>/65:    shutdown(9, 1, 1)                               = 0
/65:    poll(0xFAF7B980, 1, 2000)                       = 1
/65:    read(9, 0xFAF7BC20, 512)                        = 0
/65:    close(9)                                        = 0</pre></div>

    <p>Le thread de worker effectue une fermeture "en prenant son temps"
    (lingering close) de la connexion.</p>

    <div class="example"><pre>/65:    close(10)                                       = 0
/65:    lwp_park(0x00000000, 0)         (sleeping...)</pre></div>

    <p>Enfin, le thread de worker ferme le fichier qu'il vient de dlivrer et
    se bloque jusqu' ce que le thread en coute lui assigne une autre
    connexion.</p>

    <div class="example"><pre>/67:    accept(3, 0x001FEB74, 0x001FEB94, 1) (sleeping...)</pre></div>

    <p>Pendant ce temps, le thread  l'coute peut accepter une autre connexion
     partir du moment o il a assign la connexion prsente  un thread de
    worker (selon une certaine logique de contrle de flux dans le MPM worker
    qui impose des limites au thread  l'coute si tous les threads de worker
    sont occups). Bien que cela n'apparaisse pas dans cette trace,
    l'<code>accept(2)</code> suivant peut (et le fait en gnral, en situation
    de charge leve) s'excuter en parallle avec le traitement de la
    connexion qui vient d'tre accepte par le thread de worker.</p>

  </div></div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="../en/misc/perf-tuning.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/misc/perf-tuning.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ko/misc/perf-tuning.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a> |
<a href="../tr/misc/perf-tuning.html" hreflang="tr" rel="alternate" title="Trke">&nbsp;tr&nbsp;</a></p>
</div><div id="footer">
<p class="apache">Copyright 2011 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="../faq/">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p></div>
</body></html>