<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head><!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>mod_setenvif - Serveur Apache HTTP</title>
<link href="../style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="../style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="../style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" />
<link href="../images/favicon.ico" rel="shortcut icon" /></head>
<body>
<div id="page-header">
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="../faq/">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.3</p>
<img alt="" src="../images/feather.gif" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="../images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="../">Version 2.3</a> &gt; <a href="./">Modules</a></div>
<div id="page-content">
<div id="preamble"><h1>Module Apache mod_setenvif</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_setenvif.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_setenvif.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ja/mod/mod_setenvif.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="../ko/mod/mod_setenvif.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a> |
<a href="../tr/mod/mod_setenvif.html" hreflang="tr" rel="alternate" title="Trke">&nbsp;tr&nbsp;</a></p>
</div>
<table class="module"><tr><th><a href="module-dict.html#Description">Description:</a></th><td>Permet de dfinir des variables d'environnement en fonction
de caractristiques de la requte</td></tr>
<tr><th><a href="module-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="module-dict.html#ModuleIdentifier">IdentificateurdeModule:</a></th><td>setenvif_module</td></tr>
<tr><th><a href="module-dict.html#SourceFile">FichierSource:</a></th><td>mod_setenvif.c</td></tr></table>
<h3>Sommaire</h3>


    <p>Le module <code class="module"><a href="../mod/mod_setenvif.html">mod_setenvif</a></code> vous permet de dfinir
    des variables d'environnement internes en fonction du fait que telle ou telle
    caractristique de la requte correspond ou non aux expressions
    rationnelles que vous spcifiez. Ces variables d'environnement
    peuvent tre utilises par d'autres parties du serveur pour prendre
    des dcisions quant aux actions  entreprendre, et pour dterminer
    si les scripts CGI et les pages SSI doivent pouvoir y accder.</p>

    <p>Les directives sont interprtes selon l'ordre dans lequel elles
    apparassent dans les fichiers de configuration. Ainsi, des
    squences plus complexes peuvent tre utilises, comme dans cet
    exemple qui dfinit netscape si le navigateur est Mozilla et non
    MSIE.</p>

<div class="example"><p><code>
  BrowserMatch ^Mozilla netscape<br />
  BrowserMatch MSIE !netscape<br />
</code></p></div>
</div>
<div id="quickview"><h3 class="directives">Directives</h3>
<ul id="toc">
<li><img alt="" src="../images/down.gif" /> <a href="#browsermatch">BrowserMatch</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#browsermatchnocase">BrowserMatchNoCase</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#setenvif">SetEnvIf</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#setenvifexpr">SetEnvIfExpr</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#setenvifnocase">SetEnvIfNoCase</a></li>
</ul>
<h3>Voir aussi</h3>
<ul class="seealso">
<li><a href="../env.html">Les variables d'environnement et le
serveur HTTP Apache</a></li>
</ul></div>

<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="BrowserMatch" id="BrowserMatch">BrowserMatch</a> <a name="browsermatch" id="browsermatch">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dfinit des variables d'environnement en fonction du
contenu de l'en-tte HTTP User-Agent</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>BrowserMatch <em>regex [!]env-variable</em>[=<em>valeur</em>]
[[!]<em>env-variable</em>[=<em>valeur</em>]] ...</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>FileInfo</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_setenvif</td></tr>
</table>
  <p>La directive <code class="directive">BrowserMatch</code> est un cas
  particulier de la directive <code class="directive"><a href="#setenvif">SetEnvIf</a></code>, qui dfinit des variables
  d'environnement en fonction du contenu de l'en-tte de requte HTTP
  <code>User-Agent</code>. Les deux lignes suivantes produisent le mme
  effet :</p>
<div class="example"><p><code>
   BrowserMatchNoCase Robot est_un_robot<br />
   SetEnvIfNoCase User-Agent Robot est_un_robot<br />
</code></p></div>

    <p>Quelques exemples supplmentaires :</p>
<div class="example"><p><code>
    BrowserMatch ^Mozilla forms jpeg=yes browser=netscape<br />
    BrowserMatch "^Mozilla/[2-3]" tables agif frames javascript<br />
    BrowserMatch MSIE !javascript<br />
</code></p></div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="BrowserMatchNoCase" id="BrowserMatchNoCase">BrowserMatchNoCase</a> <a name="browsermatchnocase" id="browsermatchnocase">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dfinit des variables d'environnement en fonction du
contenu de l'en-tte HTTP User-Agent sans tenir compte de la
casse</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>BrowserMatchNoCase  <em>regex [!]env-variable</em>[=<em>valeur</em>]
    [[!]<em>env-variable</em>[=<em>valeur</em>]] ...</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>FileInfo</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_setenvif</td></tr>
</table>

    <p>La directive <code class="directive">BrowserMatchNoCase</code> est
    identique sur le plan smantique  la directive <code class="directive"><a href="#browsermatch">BrowserMatch</a></code>. Elle permet
    cependant une comparaison insensible  la casse. Par exemple :</p>
<div class="example"><p><code>
    BrowserMatchNoCase mac platform=macintosh<br />
    BrowserMatchNoCase win platform=windows<br />
</code></p></div>

    <p>Les directives <code class="directive">BrowserMatch</code> et
    <code class="directive">BrowserMatchNoCase</code> sont des cas particuliers
    des directives <code class="directive"><a href="#setenvif">SetEnvIf</a></code>
    et <code class="directive"><a href="#setenvifnocase">SetEnvIfNoCase</a></code>.
    Ainsi, les deux lignes suivantes produisent le mme effet :</p>
<div class="example"><p><code>
   BrowserMatchNoCase Robot est_un_robot<br />
   SetEnvIfNoCase User-Agent Robot est_un_robot<br />
</code></p></div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="SetEnvIf" id="SetEnvIf">SetEnvIf</a> <a name="setenvif" id="setenvif">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dfinit des variables d'environnement en fonction des
attributs de la requte</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SetEnvIf <em>attribut
    regex [!]env-variable</em>[=<em>valeur</em>]
    [[!]<em>env-variable</em>[=<em>valeur</em>]] ...</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>FileInfo</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_setenvif</td></tr>
</table>
    <p>La directive <code class="directive">SetEnvIf</code> permet de dfinir
    des variables d'environnement en fonction des attributs de la
    requte. L'<em>attribut</em> spcifi comme premier argument peut
    se prsenter sous l'une des quatre formes suivantes :</p>

<ol>
<li>Un champ d'en-tte de requte HTTP (voir la <a href="http://www.rfc-editor.org/rfc/rfc2616.txt">RFC2616</a> pour
    plus d'information  leur propos) ; par exemple : <code>Host</code>,
    <code>User-Agent</code>, <code>Referer</code>, ou
    <code>Accept-Language</code>. Il est possible d'utiliser une
    expression rationnelle pour spcifier un jeu d'en-ttes de
    requte.</li>

<li>Une des caractristiques de la requte suivantes :
    <ul>
      <li><code>Remote_Host</code> - le nom d'hte (s'il est disponible)
      du client qui effectue la requte</li>

      <li><code>Remote_Addr</code> - l'adresse IP du client qui effectue
      la requte</li>

      <li><code>Server_Addr</code> - l'adresse IP du serveur qui a reu
      la requte (uniquement  partir des versions suprieures 
      2.0.43)</li>

      <li><code>Request_Method</code> - Le nom de la mthode HTTP
      utilise (<code>GET</code>, <code>POST</code>, <em>et
      cetera...</em>)</li>

      <li><code>Request_Protocol</code> - le nom et la version du
      protocole utilis pour la requte (par exemple "HTTP/0.9",
      "HTTP/1.1", <em>etc...</em>)</li>

      <li><code>Request_URI</code> - la ressource demande dans la ligne
      de requte HTTP -- en gnral la partie de l'URL suivant le
      protocole et le nom du serveur, sans la chane d'arguments. Voir
      la directive <code class="directive"><a href="../mod/mod_rewrite.html#rewritecond">RewriteCond</a></code> du module
      <code class="module"><a href="../mod/mod_rewrite.html">mod_rewrite</a></code> pour plus d'informations sur la
      manire de mettre en correspondance votre chane d'arguments.</li>
    </ul>
</li>

<li>Le nom d'une variable d'environnement parmi la liste de celles qui
sont associes  la requte. Ceci permet  la directive
<code class="directive">SetEnvIf</code> d'effectuer des tests en fonction du
rsultat de comparaisons prcdentes. Seules les variables
d'environnement dfinies par des directives
<code>SetEnvIf[NoCase]</code> prcdentes sont disponibles pour
effectuer des tests de cette manire. 'Prcdentes' signifie qu'elles se
trouvent  un niveau plus global de la configuration (par exemple au
niveau du serveur principal), ou plus haut chronologiquement dans le
contexte de la directive. Les variables d'environnement ne seront prises
en compte que si aucune correspondance n'a t trouve parmi les
caractristiques de la requte, et si <em>attribut</em> n'a pas t
spcifi sous la forme d'une expression rationnelle.</li>

</ol>

<p>Le second argument (<em>regex</em>) est une <a class="glossarylink" href="../glossary.html#regex" title="voir glossaire">expression rationnelle</a>. Si  <em>regex</em>
correspond  l'<em>attribut</em>, les arguments suivants sont valus.</p>

<p>Le reste des arguments constitue les noms des variables  dfinir,
ainsi que les valeurs optionnelles qui doivent leur tre affectes. Ils
peuvent se prsenter sous les formes suivantes :</p>

    <ol>
      <li><code><em>nom-variable</em></code>, or</li>

      <li><code>!<em>nom-variable</em></code>, or</li>

      <li><code><em>nom-variable</em>=<em>valeur</em></code></li>
    </ol>

    <p>Dans la premire forme, la valeur sera dfinie  "1". Dans la
    seconde forme, la variable sera supprime si elle a t dfinie au
    pralable, et dans la troisime forme, la variable sera dfinie  la
    valeur littrale spcifie par <code><em>valeur</em></code>. Depuis
    la version 2.0.51, Apache httpd reconnat les occurrences de variables
    <code>$1</code>..<code>$9</code>  l'intrieur de
    <code><em>valeur</em></code>, et les remplace par les
    sous-expressions entre parenthses correspondantes de
    <var>regex</var>.</p>

<div class="example"><h3>Example:</h3><p><code>

   SetEnvIf Request_URI "\.gif$" objet_est_une_image=gif<br />
   SetEnvIf Request_URI "\.jpg$" objet_est_une_image=jpg<br />
   SetEnvIf Request_URI "\.xbm$" objet_est_une_image=xbm<br />
        :<br />
   SetEnvIf Referer www\.mon-domaine\.example\.com rfrant_intra_site<br />
        :<br />
   SetEnvIf objet_est_une_image xbm XBIT_PROCESSING=1<br />
        :<br />
   SetEnvIf ^TS  ^[a-z]  HAVE_TS<br />
</code></p></div>

    <p>Les trois premires lignes dfinissent la variable
    d'environnement <code>objet_est_une_image</code> si l'objet de la
    requte est un fichier image, et la quatrime dfinit la variable
    <code>rfrant_intra_site</code> si la page rfrante se trouve
    quelque part dans le site web
    <code>www.mon-domaine.example.com</code>.</p>

    <p>La dernire ligne dfinit la variable d'environnement
    <code>HAVE_TS</code> si la requte contient un en-tte dont le nom
    commence par "TS" et dont la valeur commence par tout caractre du
    jeu [a-z].</p>

<h3>Voir aussi</h3>
<ul>
<li><a href="../env.html">Les variables d'environnement et le
serveur HTTP Apache</a> pour des exemples supplmentaires.
</li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="SetEnvIfExpr" id="SetEnvIfExpr">SetEnvIfExpr</a> <a name="setenvifexpr" id="setenvifexpr">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dfinit des variables d'environnement en fonction d'une expression ap_expr</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SetEnvIfExpr <em>expr
    [!]env-variable</em>[=<em>valeur</em>]
    [[!]<em>env-variable</em>[=<em>valeur</em>]] ...</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>FileInfo</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_setenvif</td></tr>
</table>
    <p>La directive <code class="directive">SetEnvIfExpr</code> permet de
    dfinir des variables d'environnement en fonction d'une expression
    <code class="directive">&lt;If&gt;</code> <code>ap_expr</code>. Cette
    expression est value  l'excution, et utilise les variables
    d'environnement <em>env-variable</em> de la mme manire que la
    directive <code class="directive">SetEnvIf</code>.</p>

<div class="example"><p><code>
    SetEnvIfExpr "tolower(req('X-Sendfile')) == 'd:\images\very_big.iso')" iso_delivered
</code></p></div>

    <p>Dans cet exemple, la variable d'environnement
    <code>iso_delivered</code> est dfinie chaque fois que notre
    application tente de l'envoyer via <code>X-Sendfile</code>.</p>

    <p>Il pourrait tre plus utile de dfinir une variable rfc1918 si
    l'adresse IP distante est une adresse prive au sens de la RFC 1918
    :</p>

<div class="example"><p><code>
    SetEnvIfExpr "-R '10.0.0.0/8' || -R '172.16.0.0/12' || -R '192.168.0.0/16'" rfc1918
</code></p></div>

<h3>Voir aussi</h3>
<ul>
<li><a href="../expr.html">Les expressions dans le serveur HTTP
Apache</a>, pour une rfrence complte et davantage d'exemples.</li>
<li>La directive <code class="directive">&lt;If&gt;</code> peut tre
utilise pour obtenir des rsultats similaires.</li>
<li><code class="module"><a href="../mod/mod_filter.html">mod_filter</a></code></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="SetEnvIfNoCase" id="SetEnvIfNoCase">SetEnvIfNoCase</a> <a name="setenvifnocase" id="setenvifnocase">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dfinit des variables d'environnement en fonction des
attributs de la requte sans tenir compte de la casse</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>SetEnvIfNoCase <em>attribut regex
        [!]env-variable</em>[=<em>valeur</em>]
    [[!]<em>env-variable</em>[=<em>valeur</em>]] ...</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>FileInfo</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_setenvif</td></tr>
</table>

    <p>La directive <code class="directive">SetEnvIfNoCase</code> est identique
    d'un point de vue smantique  la directive <code class="directive"><a href="#setenvif">SetEnvIf</a></code>, et ne s'en distingue que
    par le fait que la comparaison des expressions rationnelles est
    effectue sans tenir compte de la casse. Par exemple :</p>
<div class="example"><p><code>
   SetEnvIfNoCase Host Example\.Org site=apache
</code></p></div>

    <p>Cette ligne va dfinir la variable d'environnement
    <code>site</code> avec la valeur "<code>example</code>" si le champ
    d'en-tte de requte HTTP <code>Host:</code> est prsent et contient
    <code>Example.Org</code>, <code>example.org</code>, ou une autre
    combinaison des mmes caractres, sans tenir compte de la casse.</p>

</div>
</div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_setenvif.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_setenvif.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ja/mod/mod_setenvif.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="../ko/mod/mod_setenvif.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a> |
<a href="../tr/mod/mod_setenvif.html" hreflang="tr" rel="alternate" title="Trke">&nbsp;tr&nbsp;</a></p>
</div><div id="footer">
<p class="apache">Copyright 2011 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="../faq/">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p></div>
</body></html>