<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head><!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>Utiliser mod_rewrite pour le contrle d'accs - Serveur Apache HTTP</title>
<link href="../style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="../style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="../style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" />
<link href="../images/favicon.ico" rel="shortcut icon" /></head>
<body id="manual-page"><div id="page-header">
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="../faq/">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.4</p>
<img alt="" src="../images/feather.gif" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="../images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="../">Version 2.4</a> &gt; <a href="./">Rewrite</a></div><div id="page-content"><div id="preamble"><h1>Utiliser mod_rewrite pour le contrle d'accs</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="../en/rewrite/access.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/rewrite/access.html" title="Franais">&nbsp;fr&nbsp;</a></p>
</div>


<p>Ce document est un complment  la <a href="../mod/mod_rewrite.html">documentation de rfrence</a> de
<code class="module"><a href="../mod/mod_rewrite.html">mod_rewrite</a></code>. Il explique comment utiliser
<code class="module"><a href="../mod/mod_rewrite.html">mod_rewrite</a></code> pour contrler l'accs  diverses
ressources, ainsi que d'autres techniques en rapport. Il contient de
nombreux exemples d'utilisation courante de mod_rewrite avec une
description dtaille de leur fonctionnement.</p>

<div class="warning">Vous devez vous attacher  comprendre le
fonctionnement des exemples, car la plupart d'entre eux ne
fonctionneront pas sur votre systme si vous vous contentez de les
copier/coller dans vos fichiers de configuration.</div>

</div>
<div id="quickview"><ul id="toc"><li><img alt="" src="../images/down.gif" /> <a href="#blocked-inline-images">Blocage du rfrencement  chaud (Hotlinking) d'images</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#blocking-of-robots">Blocage des robots</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#host-deny">Rejet des clients contenus dans une liste noire</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#referer-deflector">Aiguillage bas sur l'en-tte Referer</a></li>
</ul><h3>Voir aussi</h3><ul class="seealso"><li><a href="../mod/mod_rewrite.html">Documentation du module mod_rewrite</a></li><li><a href="intro.html">Introduction  mod_rewrite</a></li><li><a href="remapping.html">Redirection et remise en
correspondance</a></li><li><a href="vhosts.html">Serveurs virtuels</a></li><li><a href="proxy.html">Serveurs mandataires</a></li><li><a href="rewritemap.html">Utilisation de RewriteMap</a></li><li><a href="advanced.html">Techniques avances</a></li><li><a href="avoid.html">Quand ne pas utiliser mod_rewrite</a></li></ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="blocked-inline-images" id="blocked-inline-images">Blocage du rfrencement  chaud (Hotlinking) d'images</a></h2>

      

      <dl>
        <dt>Description :</dt>

        <dd>
          <p>Cette technique vous permet d'interdire  d'autres sites
	  d'inclure directement vos images dans leurs pages. On fait
	  souvent rfrence  cette pratique sous le nom de
	  rfrencement  chaud (Hotlinking) qui entrane l'utilisation
	  de votre bande passante pour servir des contenus faisant
	  partie du site de quelqu'un d'autre.</p>
        </dd>

        <dt>Solution :</dt>

        <dd>
	<p>Cette technique repose sur la valeur de la variable
	optionnelle <code>HTTP_REFERER</code>. Certaines personnes
	pourront donc contourner cette limitation. Pour la plupart des
	utilisateurs cependant, la requte chouera, en ce sens que
	l'image ne sera pas affiche depuis le site tiers.</p>
	<p>Il y a plusieurs manires de grer cette situation.</p>

	<p>Dans le premier exemple, nous rejetons tout simplement la
	requte si elle ne provenait pas d'une page appartenant  notre
	site. Pour les besoins de cet exemple, nous supposons que le nom
	de votre site est <code>www.example.com</code>.</p>



<div class="example"><p><code>
RewriteCond %{HTTP_REFERER} <strong>!^$</strong><br />
RewriteCond %{HTTP_REFERER} !www.example.com [NC]<br />
RewriteRule <strong>\.(gif|jpg|png)$</strong>    -   [F,NC]
</code></p></div>

	<p>Dans le second exemple, plutt que de rejeter la requte,
	nous affichons une autre image  la place.</p>

<div class="example"><p><code>
RewriteCond %{HTTP_REFERER} <strong>!^$</strong><br />
RewriteCond %{HTTP_REFERER} !www.example.com [NC]<br />
RewriteRule <strong>\.(gif|jpg|png)$</strong>    /images/go-away.png   [R,NC]
</code></p></div>

	<p>Dans le troisime exemple, nous redirigeons la requte vers
	une image appartenant  un autre site.</p>


<div class="example"><p><code>
RewriteCond %{HTTP_REFERER} <strong>!^$</strong><br />
RewriteCond %{HTTP_REFERER} !www.example.com [NC]<br />
RewriteRule <strong>\.(gif|jpg|png)$</strong> http://other.example.com/image.gif   [R,NC]
</code></p></div>
	<p>De tous ces exemples, les deux derniers semblent les plus
	efficaces pour faire en sorte que les gens arrtent de
	rfrencer vos images  chaud, car il ne verront pas les images
	qu'ils s'attendent  voir.</p>

        </dd>

        <dt>Discussion :</dt>

        <dd>
        <p>Si vous ne voulez pas rediriger la requte, mais
	simplement interdire l'accs  la ressource, vous pouvez y
	parvenir sans utiliser mod_rewrite :</p>

        <div class="example"><p><code>
        SetEnvIf Referer exemple\.com localreferer<br />
        &lt;FilesMatch \.(jpg|png|gif)$&gt;<br />
        Order deny,allow<br />
        Deny from all<br />
        Allow from env=localreferer<br />
        &lt;/FilesMatch&gt;
        </code></p></div>
        </dd>
      </dl>

    </div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="blocking-of-robots" id="blocking-of-robots">Blocage des robots</a></h2>

      

      <dl>
        <dt>Description :</dt>

        <dd>
        <p>
        Dans cet exemple, nous allons discuter d'une mthode permettant
	de bloquer les requtes persistentes en provenance d'un robot
	particulier, ou d'un navigateur.</p>

        <p>La mthode classique pour exclure un robot consiste  dfinir
	un fichier, <code>/robots.txt</code> qui spcifie les parties de
	votre site web pour lesquelles vous voulez exclure les robots.
	Malheureusement, certains robots ne tiennent pas compte de ces
	fichiers.
        </p>

        <p>Notez qu'il existe des mthodes d'exclusion qui n'utilisent
	pas mod_rewrite. Notez aussi que toute technique qui repose sur
	le contenu de la chane client <code>USER_AGENT</code> peut tre
	contourne trs facilement car cette chane de caractres peut
        tre modifie.</p>
        </dd>

        <dt>Solution :</dt>

        <dd>
        <p>On utilise un jeu de rgles qui spcifie le rpertoire 
	protger, ainsi que la chane client <code>USER_AGENT</code> qui
	identifie le robot indsirable ou envahissant.</p>

        <p>Dans cet exemple, nous bloquons un robot nomm
	<code>Vilain_Robot</code> pour le rpertoire
	<code>/secret/fichiers</code>. Si vous voulez bloquer ce client
	seulement depuis une source particulire, vous pouvez aussi
	spcifier un intervalle d'adresses IP.</p>

<div class="example"><p><code>
RewriteCond %{HTTP_USER_AGENT}   ^<strong>Vilain_Robot</strong><br />
RewriteCond %{REMOTE_ADDR}       =<strong>123\.45\.67\.[8-9]</strong><br />
RewriteRule ^<strong>/secret/fichiers/</strong>   -   [<strong>F</strong>]
</code></p></div>
        </dd>

      <dt>Discussion :</dt>

      <dd>
      <p>
        Vous pouvez cependant parvenir au mme rsultat sans utiliser
	mod_rewrite via la mthode alternative suivante :
      </p>
      <div class="example"><p><code>
      SetEnvIfNoCase User-Agent ^Vilain_Robot interdit<br />
      &lt;Location /secret/fichiers&gt;<br />
      Order allow,deny<br />
      Allow from all<br />
      Deny from env=interdit<br />
      &lt;/Location&gt;
      </code></p></div>
      <p>
      Comme indiqu plus haut, il est ais de contourner cette
      technique, simplement en modifiant le contenu de l'en-tte
      <code>USER_AGENT</code>. Si vous subissez une attaque en rgle,
      vous allez devoir rflchir  un blocage  un niveau suprieur,
      par exemple une rgle de filtrage de votre pare-feu.
      </p>

      </dd>

      </dl>

    </div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="host-deny" id="host-deny">Rejet des clients contenus dans une liste noire</a></h2>

  

  <dl>
    <dt>Description :</dt>

    <dd>
      <p>Nous voulons interdire l'accs  notre serveur aux clients
      contenus dans une liste noire similaire 
      <code>hosts.deny</code>.</p>
    </dd>

    <dt>Solution :</dt>

    <dd>
<div class="example"><p><code>
RewriteEngine on<br />
RewriteMap    hosts-deny  txt:/chemin/vers/hosts.deny<br />
RewriteCond   ${hosts-deny:%{REMOTE_ADDR}|NOT-FOUND} !=NOT-FOUND [OR]<br />
RewriteCond   ${hosts-deny:%{REMOTE_HOST}|NOT-FOUND} !=NOT-FOUND<br />
RewriteRule   ^  -  [F]
</code></p></div>

<div class="example"><p><code>
##<br />
##  hosts.deny<br />
##<br />
##  ATTENTION! Ceci est une table de correspondances, non une liste,<br />
##		mme si elle est traite comme telle. mod_rewrite<br />
##		l'interprte comme une liste de paires cl/valeur, et<br />
##		chaque entre doit au moins possder une valeur par<br />
##		dfaut "-".<br />
<br />
193.102.180.41 -<br />
bsdti1.sdm.de  -<br />
192.76.162.40  -<br />
</code></p></div>
    </dd>

    <dt>Discussion :</dt>
    <dd>
    <p>
    La seconde condition RewriteCond prsuppose que HostNameLookups est
    dfini  On, de faon  ce que les adresses IP des clients puissent
    tre rsolues. Dans le cas contraire, vous devez supprimer la
    seconde condition, ainsi que le drapeau <code>[OR]</code> de la
    premire.
    </p>
    </dd>
  </dl>

</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="referer-deflector" id="referer-deflector">Aiguillage bas sur l'en-tte Referer</a></h2>

  

  <dl>
    <dt>Description :</dt>

    <dd>
      <p>Redirige les requtes en fonction du Referer de provenance de
      la requte, avec des cibles diffrentes pour chaque Referer.</p>
    </dd>

    <dt>Solution :</dt>

    <dd>
  <p>Le jeu de rgles suivant utilise un fichier de correspondances pour
  associer chaque Referer  une cible de redirection.</p>

<div class="example"><p><code>
RewriteMap  deflector txt:/chemin/vers/deflector.map<br />
<br />
RewriteCond %{HTTP_REFERER} !=""<br />
RewriteCond ${deflector:%{HTTP_REFERER}} =-<br />
RewriteRule ^ %{HTTP_REFERER} [R,L]<br />
<br />
RewriteCond %{HTTP_REFERER} !=""<br />
RewriteCond ${deflector:%{HTTP_REFERER}|NOT-FOUND} !=NOT-FOUND<br />
RewriteRule ^ ${deflector:%{HTTP_REFERER}} [R,L]
</code></p></div>

      <p>Le fichier de correspondances contient les cibles de
      redirection associes  chaque Referer, ou, si nous voulons
      simplement rediriger les requtes vers leur Referer, un "-" est
      inscrit dans le fichier de correspondances :</p>

<div class="example"><p><code>
##<br />
##  deflector.map<br />
##<br />
<br />
http://www.mauvais-gars.example.com/mauvais/index.html    -<br />
http://www.mauvais-gars.example.com/mauvais/index2.html   -<br />
http://www.mauvais-gars.example.com/mauvais/index3.html   http://quelque-part.example.com/
</code></p></div>

    </dd>
  </dl>

</div></div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="../en/rewrite/access.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/rewrite/access.html" title="Franais">&nbsp;fr&nbsp;</a></p>
</div><div id="footer">
<p class="apache">Copyright 2012 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="../faq/">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p></div>
</body></html>