/* Generated by re2c 0.13.5 */
#line 1 "Zend/zend_ini_scanner.l"
/*
   +----------------------------------------------------------------------+
   | Zend Engine                                                          |
   +----------------------------------------------------------------------+
   | Copyright (c) 1998-2015 Zend Technologies Ltd. (http://www.zend.com) |
   +----------------------------------------------------------------------+
   | This source file is subject to version 2.00 of the Zend license,     |
   | that is bundled with this package in the file LICENSE, and is        |
   | available through the world-wide-web at the following url:           |
   | http://www.zend.com/license/2_00.txt.                                |
   | If you did not receive a copy of the Zend license and are unable to  |
   | obtain it through the world-wide-web, please send a note to          |
   | license@zend.com so we can mail you a copy immediately.              |
   +----------------------------------------------------------------------+
   | Authors: Zeev Suraski <zeev@zend.com>                                |
   |          Jani Taskinen <jani@php.net>                                |
   |          Marcus Boerger <helly@php.net>                              |
   |          Nuno Lopes <nlopess@php.net>                                |
   |          Scott MacVicar <scottmac@php.net>                           |
   +----------------------------------------------------------------------+
*/

/* $Id$ */

#include <errno.h>
#include "zend.h"
#include "zend_API.h"
#include "zend_globals.h"
#include <zend_ini_parser.h>
#include "zend_ini_scanner.h"

#ifdef YYDEBUG
#undef YYDEBUG
#endif

#if 0
# define YYDEBUG(s, c) printf("state: %d char: %c\n", s, c)
#else
# define YYDEBUG(s, c)
#endif

#include "zend_ini_scanner_defs.h"

#define YYCTYPE   unsigned char
/* allow the scanner to read one null byte after the end of the string (from ZEND_MMAP_AHEAD)
 * so that if will be able to terminate to match the current token (e.g. non-enclosed string) */
#define YYFILL(n) { if (YYCURSOR > YYLIMIT) return 0; }
#define YYCURSOR  SCNG(yy_cursor)
#define YYLIMIT   SCNG(yy_limit)
#define YYMARKER  SCNG(yy_marker)

#define YYGETCONDITION()  SCNG(yy_state)
#define YYSETCONDITION(s) SCNG(yy_state) = s

#define STATE(name)  yyc##name

/* emulate flex constructs */
#define BEGIN(state) YYSETCONDITION(STATE(state))
#define YYSTATE      YYGETCONDITION()
#define yytext       ((char*)SCNG(yy_text))
#define yyleng       SCNG(yy_leng)
#define yyless(x)    do {	YYCURSOR = (unsigned char*)yytext + x; \
							yyleng   = (unsigned int)x; } while(0)

/* #define yymore()     goto yymore_restart */

/* perform sanity check. If this message is triggered you should
   increase the ZEND_MMAP_AHEAD value in the zend_streams.h file */
#define YYMAXFILL 6
#if ZEND_MMAP_AHEAD < (YYMAXFILL + 1)
# error ZEND_MMAP_AHEAD should be greater than YYMAXFILL
#endif


/* How it works (for the core ini directives):
 * ===========================================
 *
 * 1. Scanner scans file for tokens and passes them to parser.
 * 2. Parser parses the tokens and passes the name/value pairs to the callback
 *    function which stores them in the configuration hash table.
 * 3. Later REGISTER_INI_ENTRIES() is called which triggers the actual
 *    registering of ini entries and uses zend_get_configuration_directive()
 *    to fetch the previously stored name/value pair from configuration hash table
 *    and registers the static ini entries which match the name to the value
 *    into EG(ini_directives) hash table.
 * 4. PATH section entries are used per-request from down to top, each overriding
 *    previous if one exists. zend_alter_ini_entry() is called for each entry.
 *    Settings in PATH section are ZEND_INI_SYSTEM accessible and thus mimics the
 *    php_admin_* directives used within Apache httpd.conf when PHP is compiled as
 *    module for Apache.
 * 5. User defined ini files (like .htaccess for apache) are parsed for each request and
 *    stored in separate hash defined by SAPI.
 */

/* TODO: (ordered by importance :-)
 * ===============================================================================
 *
 *  - Separate constant lookup totally from plain strings (using CONSTANT pattern)
 *  - Add #if .. #else .. #endif and ==, !=, <, > , <=, >= operators
 *  - Add #include "some.ini"
 *  - Allow variables to refer to options also when using parse_ini_file()
 *
 */

/* Globals Macros */
#define SCNG	INI_SCNG
#ifdef ZTS
ZEND_API ts_rsrc_id ini_scanner_globals_id;
#else
ZEND_API zend_ini_scanner_globals ini_scanner_globals;
#endif

/* Eat leading whitespace */
#define EAT_LEADING_WHITESPACE()                     \
	while (yytext[0]) {                              \
		if (yytext[0] == ' ' || yytext[0] == '\t') { \
			SCNG(yy_text)++;                         \
			yyleng--;                                \
		} else {                                     \
			break;                                   \
		}                                            \
	}

/* Eat trailing whitespace + extra char */
#define EAT_TRAILING_WHITESPACE_EX(ch)              \
	while (yyleng > 0 && (                          \
		(ch != 'X' && yytext[yyleng - 1] ==  ch) || \
		yytext[yyleng - 1] == '\n' ||               \
		yytext[yyleng - 1] == '\r' ||               \
		yytext[yyleng - 1] == '\t' ||               \
		yytext[yyleng - 1] == ' ')                  \
	) {                                             \
		yyleng--;                                   \
	}

/* Eat trailing whitespace */
#define EAT_TRAILING_WHITESPACE()	EAT_TRAILING_WHITESPACE_EX('X')

#define zend_ini_copy_value(retval, str, len)	\
	ZVAL_NEW_STR(retval, zend_string_init(str, len, 1))


#define RETURN_TOKEN(type, str, len) {                       \
	if (SCNG(scanner_mode) == ZEND_INI_SCANNER_TYPED) {      \
		zend_ini_copy_typed_value(ini_lval, type, str, len); \
	} else {                                                 \
		zend_ini_copy_value(ini_lval, str, len);             \
	}                                                        \
	return type;                                             \
}

static inline int convert_to_number(zval *retval, const char *str, const int str_len)
{
	zend_uchar type;
	int overflow;
	zend_long lval;
	double dval;

	if ((type = is_numeric_string_ex(str, str_len, &lval, &dval, 0, &overflow)) != 0) {
		if (type == IS_LONG) {
			ZVAL_LONG(retval, lval);
			return SUCCESS;
		} else if (type == IS_DOUBLE && !overflow) {
			ZVAL_DOUBLE(retval, dval);
			return SUCCESS;
		}
	}

	return FAILURE;
}

static void zend_ini_copy_typed_value(zval *retval, const int type, const char *str, int len)
{
	switch (type) {
		case BOOL_FALSE:
		case BOOL_TRUE:
			ZVAL_BOOL(retval, type == BOOL_TRUE);
			break;

		case NULL_NULL:
			ZVAL_NULL(retval);
			break;

		case TC_NUMBER:
			if (convert_to_number(retval, str, len) == SUCCESS) {
				break;
			}
			/* intentional fall-through */
		default:
			zend_ini_copy_value(retval, str, len);
	}
}

static void _yy_push_state(int new_state)
{
	zend_stack_push(&SCNG(state_stack), (void *) &YYGETCONDITION());
	YYSETCONDITION(new_state);
}

#define yy_push_state(state_and_tsrm) _yy_push_state(yyc##state_and_tsrm)

static void yy_pop_state(void)
{
	int *stack_state = zend_stack_top(&SCNG(state_stack));
	YYSETCONDITION(*stack_state);
	zend_stack_del_top(&SCNG(state_stack));
}

static void yy_scan_buffer(char *str, unsigned int len)
{
	YYCURSOR = (YYCTYPE*)str;
	SCNG(yy_start) = YYCURSOR;
	YYLIMIT  = YYCURSOR + len;
}

#define ini_filename SCNG(filename)

/* {{{ init_ini_scanner()
*/
static int init_ini_scanner(int scanner_mode, zend_file_handle *fh)
{
	/* Sanity check */
	if (scanner_mode != ZEND_INI_SCANNER_NORMAL && scanner_mode != ZEND_INI_SCANNER_RAW && scanner_mode != ZEND_INI_SCANNER_TYPED) {
		zend_error(E_WARNING, "Invalid scanner mode");
		return FAILURE;
	}

	SCNG(lineno) = 1;
	SCNG(scanner_mode) = scanner_mode;
	SCNG(yy_in) = fh;

	if (fh != NULL) {
		ini_filename = zend_strndup(fh->filename, strlen(fh->filename));
	} else {
		ini_filename = NULL;
	}

	zend_stack_init(&SCNG(state_stack), sizeof(int));
	BEGIN(INITIAL);

	return SUCCESS;
}
/* }}} */

/* {{{ shutdown_ini_scanner()
*/
void shutdown_ini_scanner(void)
{
	zend_stack_destroy(&SCNG(state_stack));
	if (ini_filename) {
		free(ini_filename);
	}
}
/* }}} */

/* {{{ zend_ini_scanner_get_lineno()
*/
ZEND_COLD int zend_ini_scanner_get_lineno(void)
{
	return SCNG(lineno);
}
/* }}} */

/* {{{ zend_ini_scanner_get_filename()
*/
ZEND_COLD char *zend_ini_scanner_get_filename(void)
{
	return ini_filename ? ini_filename : "Unknown";
}
/* }}} */

/* {{{ zend_ini_open_file_for_scanning()
*/
int zend_ini_open_file_for_scanning(zend_file_handle *fh, int scanner_mode)
{
	char *buf;
	size_t size;

	if (zend_stream_fixup(fh, &buf, &size) == FAILURE) {
		return FAILURE;
	}

	if (init_ini_scanner(scanner_mode, fh) == FAILURE) {
		zend_file_handle_dtor(fh);
		return FAILURE;
	}

	yy_scan_buffer(buf, (unsigned int)size);

	return SUCCESS;
}
/* }}} */

/* {{{ zend_ini_prepare_string_for_scanning()
*/
int zend_ini_prepare_string_for_scanning(char *str, int scanner_mode)
{
	int len = (int)strlen(str);

	if (init_ini_scanner(scanner_mode, NULL) == FAILURE) {
		return FAILURE;
	}

	yy_scan_buffer(str, len);

	return SUCCESS;
}
/* }}} */

/* {{{ zend_ini_escape_string()
 */
static void zend_ini_escape_string(zval *lval, char *str, int len, char quote_type)
{
	register char *s, *t;
	char *end;

	zend_ini_copy_value(lval, str, len);

	/* convert escape sequences */
	s = t = Z_STRVAL_P(lval);
	end = s + Z_STRLEN_P(lval);

	while (s < end) {
		if (*s == '\\') {
			s++;
			if (s >= end) {
				*t++ = '\\';
				continue;
			}
			switch (*s) {
				case '"':
					if (*s != quote_type) {
						*t++ = '\\';
						*t++ = *s;
						break;
					}
				case '\\':
				case '$':
					*t++ = *s;
					Z_STRLEN_P(lval)--;
					break;
				default:
					*t++ = '\\';
					*t++ = *s;
					break;
			}
		} else {
			*t++ = *s;
		}
		if (*s == '\n' || (*s == '\r' && (*(s+1) != '\n'))) {
			SCNG(lineno)++;
		}
		s++;
	}
	*t = 0;
}
/* }}} */

int ini_lex(zval *ini_lval)
{
restart:
	SCNG(yy_text) = YYCURSOR;

/* yymore_restart: */
	/* detect EOF */
	if (YYCURSOR >= YYLIMIT) {
		if (YYSTATE == STATE(ST_VALUE) || YYSTATE == STATE(ST_RAW)) {
			BEGIN(INITIAL);
			return END_OF_LINE;
		}
		return 0;
	}

	/* Eat any UTF-8 BOM we find in the first 3 bytes */
	if (YYCURSOR == SCNG(yy_start) && YYCURSOR + 3 < YYLIMIT) {
		if (memcmp(YYCURSOR, "\xef\xbb\xbf", 3) == 0) {
			YYCURSOR += 3;
			goto restart;
		}
	}

#line 385 "Zend/zend_ini_scanner.c"
{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	if (YYGETCONDITION() < 4) {
		if (YYGETCONDITION() < 2) {
			if (YYGETCONDITION() < 1) {
				goto yyc_INITIAL;
			} else {
				goto yyc_ST_OFFSET;
			}
		} else {
			if (YYGETCONDITION() < 3) {
				goto yyc_ST_SECTION_VALUE;
			} else {
				goto yyc_ST_VALUE;
			}
		}
	} else {
		if (YYGETCONDITION() < 6) {
			if (YYGETCONDITION() < 5) {
				goto yyc_ST_SECTION_RAW;
			} else {
				goto yyc_ST_DOUBLE_QUOTES;
			}
		} else {
			if (YYGETCONDITION() < 7) {
				goto yyc_ST_VARNAME;
			} else {
				goto yyc_ST_RAW;
			}
		}
	}
/* *********************************** */
yyc_INITIAL:
	{
		static const unsigned char yybm[] = {
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 160,   0, 144, 144,   0, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			240, 128, 128, 144, 128, 144, 128, 144, 
			128, 128, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 128, 144, 128, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 128, 144, 144, 128, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 128, 128, 128, 128, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
		};

		YYDEBUG(0, *YYCURSOR);
		YYFILL(5);
		yych = *YYCURSOR;
		YYDEBUG(-1, yych);
		switch (yych) {
		case '\t':	goto yy4;
		case '\n':	goto yy6;
		case '\r':	goto yy8;
		case ' ':	goto yy9;
		case '!':
		case '"':
		case '$':
		case '&':
		case '(':
		case ')':
		case '^':
		case '{':
		case '|':
		case '}':
		case '~':	goto yy10;
		case '%':
		case '\'':
		case '*':
		case '+':
		case ',':
		case '-':
		case '.':
		case '/':
		case ':':
		case '<':
		case '>':
		case '?':
		case '@':
		case ']':	goto yy12;
		case ';':	goto yy13;
		case '=':	goto yy15;
		case 'F':
		case 'f':	goto yy17;
		case 'N':
		case 'n':	goto yy18;
		case 'O':
		case 'o':	goto yy19;
		case 'T':
		case 't':	goto yy20;
		case 'Y':
		case 'y':	goto yy21;
		case '[':	goto yy22;
		default:	goto yy2;
		}
yy2:
		YYDEBUG(2, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy25;
yy3:
		YYDEBUG(3, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 481 "Zend/zend_ini_scanner.l"
		{ /* Get option name */
	/* Eat leading whitespace */
	EAT_LEADING_WHITESPACE();

	/* Eat trailing whitespace */
	EAT_TRAILING_WHITESPACE();

	RETURN_TOKEN(TC_LABEL, yytext, yyleng);
}
#line 523 "Zend/zend_ini_scanner.c"
yy4:
		YYDEBUG(4, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		goto yy63;
yy5:
		YYDEBUG(5, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 627 "Zend/zend_ini_scanner.l"
		{
	/* eat whitespace */
	goto restart;
}
#line 537 "Zend/zend_ini_scanner.c"
yy6:
		YYDEBUG(6, *YYCURSOR);
		++YYCURSOR;
yy7:
		YYDEBUG(7, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 632 "Zend/zend_ini_scanner.l"
		{
	SCNG(lineno)++;
	return END_OF_LINE;
}
#line 549 "Zend/zend_ini_scanner.c"
yy8:
		YYDEBUG(8, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy66;
		goto yy7;
yy9:
		YYDEBUG(9, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 0x1F) {
			if (yych <= '\n') {
				if (yych <= 0x08) goto yy25;
				if (yych <= '\t') goto yy62;
				goto yy66;
			} else {
				if (yych == '\r') goto yy67;
				goto yy25;
			}
		} else {
			if (yych <= ';') {
				if (yych <= ' ') goto yy64;
				if (yych <= ':') goto yy25;
				goto yy57;
			} else {
				if (yych == '=') goto yy55;
				goto yy25;
			}
		}
yy10:
		YYDEBUG(10, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(11, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 555 "Zend/zend_ini_scanner.l"
		{ /* Disallow these chars outside option values */
	return yytext[0];
}
#line 587 "Zend/zend_ini_scanner.c"
yy12:
		YYDEBUG(12, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy25;
yy13:
		YYDEBUG(13, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		goto yy58;
		YYDEBUG(14, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 648 "Zend/zend_ini_scanner.l"
		{
	return 0;
}
#line 603 "Zend/zend_ini_scanner.c"
yy15:
		YYDEBUG(15, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy56;
yy16:
		YYDEBUG(16, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 491 "Zend/zend_ini_scanner.l"
		{ /* Start option value */
	if (SCNG(scanner_mode) == ZEND_INI_SCANNER_RAW) {
		yy_push_state(ST_RAW);
	} else {
		yy_push_state(ST_VALUE);
	}
	return '=';
}
#line 621 "Zend/zend_ini_scanner.c"
yy17:
		YYDEBUG(17, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy52;
		if (yych == 'a') goto yy52;
		goto yy25;
yy18:
		YYDEBUG(18, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'U') {
			if (yych == 'O') goto yy43;
			if (yych <= 'T') goto yy25;
			goto yy44;
		} else {
			if (yych <= 'o') {
				if (yych <= 'n') goto yy25;
				goto yy43;
			} else {
				if (yych == 'u') goto yy44;
				goto yy25;
			}
		}
yy19:
		YYDEBUG(19, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'N') {
			if (yych == 'F') goto yy37;
			if (yych <= 'M') goto yy25;
			goto yy30;
		} else {
			if (yych <= 'f') {
				if (yych <= 'e') goto yy25;
				goto yy37;
			} else {
				if (yych == 'n') goto yy30;
				goto yy25;
			}
		}
yy20:
		YYDEBUG(20, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy35;
		if (yych == 'r') goto yy35;
		goto yy25;
yy21:
		YYDEBUG(21, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy26;
		if (yych == 'e') goto yy26;
		goto yy25;
yy22:
		YYDEBUG(22, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(23, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 406 "Zend/zend_ini_scanner.l"
		{ /* Section start */
	/* Enter section data lookup state */
	if (SCNG(scanner_mode) == ZEND_INI_SCANNER_RAW) {
		yy_push_state(ST_SECTION_RAW);
	} else {
		yy_push_state(ST_SECTION_VALUE);
	}
	return TC_SECTION;
}
#line 687 "Zend/zend_ini_scanner.c"
yy24:
		YYDEBUG(24, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy25:
		YYDEBUG(25, *YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy24;
		}
		if (yych == '[') goto yy27;
		goto yy3;
yy26:
		YYDEBUG(26, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy30;
		if (yych == 's') goto yy30;
		goto yy25;
yy27:
		YYDEBUG(27, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(28, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy27;
		}
		YYDEBUG(29, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 431 "Zend/zend_ini_scanner.l"
		{ /* Start of option with offset */
	/* Eat leading whitespace */
	EAT_LEADING_WHITESPACE();

	/* Eat trailing whitespace and [ */
	EAT_TRAILING_WHITESPACE_EX('[');

	/* Enter offset lookup state */
	yy_push_state(ST_OFFSET);

	RETURN_TOKEN(TC_OFFSET, yytext, yyleng);
}
#line 730 "Zend/zend_ini_scanner.c"
yy30:
		YYDEBUG(30, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(31, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy30;
		}
		if (yych <= '\'') {
			if (yych <= ' ') {
				if (yych <= '\n') {
					if (yych <= 0x08) goto yy24;
					if (yych <= '\t') goto yy33;
				} else {
					if (yych != '\r') goto yy24;
				}
			} else {
				if (yych <= '$') {
					if (yych == '#') goto yy24;
				} else {
					if (yych != '&') goto yy24;
				}
			}
		} else {
			if (yych <= 'Z') {
				if (yych <= ';') {
					if (yych <= ')') goto yy32;
					if (yych <= ':') goto yy24;
				} else {
					if (yych != '=') goto yy24;
				}
			} else {
				if (yych <= '^') {
					if (yych <= '[') goto yy27;
					if (yych <= ']') goto yy24;
				} else {
					if (yych <= 'z') goto yy24;
					if (yych >= 0x7F) goto yy24;
				}
			}
		}
yy32:
		YYDEBUG(32, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 469 "Zend/zend_ini_scanner.l"
		{ /* TRUE value (when used outside option value/offset this causes parse error!) */
	RETURN_TOKEN(BOOL_TRUE, "1", 1);
}
#line 780 "Zend/zend_ini_scanner.c"
yy33:
		YYDEBUG(33, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(34, *YYCURSOR);
		if (yych == '\t') goto yy33;
		if (yych == ' ') goto yy33;
		goto yy32;
yy35:
		YYDEBUG(35, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy36;
		if (yych != 'u') goto yy25;
yy36:
		YYDEBUG(36, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy30;
		if (yych == 'e') goto yy30;
		goto yy25;
yy37:
		YYDEBUG(37, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'F') goto yy38;
		if (yych != 'f') goto yy25;
yy38:
		YYDEBUG(38, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(39, *YYCURSOR);
		if (yych <= '&') {
			if (yych <= 0x1F) {
				if (yych <= '\n') {
					if (yych <= 0x08) goto yy24;
					if (yych <= '\t') goto yy41;
				} else {
					if (yych != '\r') goto yy24;
				}
			} else {
				if (yych <= '#') {
					if (yych <= ' ') goto yy38;
					if (yych >= '#') goto yy24;
				} else {
					if (yych == '%') goto yy24;
				}
			}
		} else {
			if (yych <= '=') {
				if (yych <= ':') {
					if (yych <= '\'') goto yy24;
					if (yych >= '*') goto yy24;
				} else {
					if (yych == '<') goto yy24;
				}
			} else {
				if (yych <= ']') {
					if (yych == '[') goto yy27;
					goto yy24;
				} else {
					if (yych <= '^') goto yy40;
					if (yych <= 'z') goto yy24;
					if (yych >= 0x7F) goto yy24;
				}
			}
		}
yy40:
		YYDEBUG(40, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 473 "Zend/zend_ini_scanner.l"
		{ /* FALSE value (when used outside option value/offset this causes parse error!)*/
	RETURN_TOKEN(BOOL_FALSE, "", 0);
}
#line 854 "Zend/zend_ini_scanner.c"
yy41:
		YYDEBUG(41, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(42, *YYCURSOR);
		if (yych == '\t') goto yy41;
		if (yych == ' ') goto yy41;
		goto yy40;
yy43:
		YYDEBUG(43, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '\'') {
			if (yych <= 0x1F) {
				if (yych <= '\n') {
					if (yych <= 0x08) goto yy25;
					if (yych <= '\t') goto yy41;
					goto yy40;
				} else {
					if (yych == '\r') goto yy40;
					goto yy25;
				}
			} else {
				if (yych <= '#') {
					if (yych <= ' ') goto yy38;
					if (yych <= '"') goto yy40;
					goto yy25;
				} else {
					if (yych == '%') goto yy25;
					if (yych <= '&') goto yy40;
					goto yy25;
				}
			}
		} else {
			if (yych <= 'N') {
				if (yych <= ';') {
					if (yych <= ')') goto yy40;
					if (yych <= ':') goto yy25;
					goto yy40;
				} else {
					if (yych == '=') goto yy40;
					if (yych <= 'M') goto yy25;
					goto yy51;
				}
			} else {
				if (yych <= 'm') {
					if (yych == '^') goto yy40;
					goto yy25;
				} else {
					if (yych <= 'n') goto yy51;
					if (yych <= 'z') goto yy25;
					if (yych <= '~') goto yy40;
					goto yy25;
				}
			}
		}
yy44:
		YYDEBUG(44, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy45;
		if (yych != 'l') goto yy25;
yy45:
		YYDEBUG(45, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy46;
		if (yych != 'l') goto yy25;
yy46:
		YYDEBUG(46, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(47, *YYCURSOR);
		if (yych <= '&') {
			if (yych <= 0x1F) {
				if (yych <= '\n') {
					if (yych <= 0x08) goto yy24;
					if (yych <= '\t') goto yy49;
				} else {
					if (yych != '\r') goto yy24;
				}
			} else {
				if (yych <= '#') {
					if (yych <= ' ') goto yy46;
					if (yych >= '#') goto yy24;
				} else {
					if (yych == '%') goto yy24;
				}
			}
		} else {
			if (yych <= '=') {
				if (yych <= ':') {
					if (yych <= '\'') goto yy24;
					if (yych >= '*') goto yy24;
				} else {
					if (yych == '<') goto yy24;
				}
			} else {
				if (yych <= ']') {
					if (yych == '[') goto yy27;
					goto yy24;
				} else {
					if (yych <= '^') goto yy48;
					if (yych <= 'z') goto yy24;
					if (yych >= 0x7F) goto yy24;
				}
			}
		}
yy48:
		YYDEBUG(48, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 477 "Zend/zend_ini_scanner.l"
		{
	RETURN_TOKEN(NULL_NULL, "", 0);
}
#line 969 "Zend/zend_ini_scanner.c"
yy49:
		YYDEBUG(49, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(50, *YYCURSOR);
		if (yych == '\t') goto yy49;
		if (yych == ' ') goto yy49;
		goto yy48;
yy51:
		YYDEBUG(51, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy38;
		if (yych == 'e') goto yy38;
		goto yy25;
yy52:
		YYDEBUG(52, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy53;
		if (yych != 'l') goto yy25;
yy53:
		YYDEBUG(53, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy54;
		if (yych != 's') goto yy25;
yy54:
		YYDEBUG(54, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy38;
		if (yych == 'e') goto yy38;
		goto yy25;
yy55:
		YYDEBUG(55, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy56:
		YYDEBUG(56, *YYCURSOR);
		if (yych == '\t') goto yy55;
		if (yych == ' ') goto yy55;
		goto yy16;
yy57:
		YYDEBUG(57, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
yy58:
		YYDEBUG(58, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy57;
		}
		if (yych >= '\r') goto yy61;
yy59:
		YYDEBUG(59, *YYCURSOR);
		++YYCURSOR;
yy60:
		YYDEBUG(60, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 637 "Zend/zend_ini_scanner.l"
		{ /* Comment */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return END_OF_LINE;
}
#line 1034 "Zend/zend_ini_scanner.c"
yy61:
		YYDEBUG(61, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy59;
		goto yy60;
yy62:
		YYDEBUG(62, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
yy63:
		YYDEBUG(63, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych <= '\n') {
				if (yych <= 0x08) goto yy5;
				if (yych <= '\t') goto yy62;
				goto yy66;
			} else {
				if (yych == '\r') goto yy67;
				goto yy5;
			}
		} else {
			if (yych <= ';') {
				if (yych <= ' ') goto yy62;
				if (yych <= ':') goto yy5;
				goto yy57;
			} else {
				if (yych == '=') goto yy55;
				goto yy5;
			}
		}
yy64:
		YYDEBUG(64, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(65, *YYCURSOR);
		if (yych <= '&') {
			if (yych <= 0x1F) {
				if (yych <= '\n') {
					if (yych <= 0x08) goto yy24;
					if (yych <= '\t') goto yy62;
				} else {
					if (yych == '\r') goto yy67;
					goto yy24;
				}
			} else {
				if (yych <= '#') {
					if (yych <= ' ') goto yy64;
					if (yych <= '"') goto yy3;
					goto yy24;
				} else {
					if (yych == '%') goto yy24;
					goto yy3;
				}
			}
		} else {
			if (yych <= '=') {
				if (yych <= ':') {
					if (yych <= '\'') goto yy24;
					if (yych <= ')') goto yy3;
					goto yy24;
				} else {
					if (yych <= ';') goto yy57;
					if (yych <= '<') goto yy24;
					goto yy55;
				}
			} else {
				if (yych <= ']') {
					if (yych == '[') goto yy27;
					goto yy24;
				} else {
					if (yych <= '^') goto yy3;
					if (yych <= 'z') goto yy24;
					if (yych <= '~') goto yy3;
					goto yy24;
				}
			}
		}
yy66:
		YYDEBUG(66, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy7;
yy67:
		YYDEBUG(67, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '\n') goto yy66;
		goto yy7;
	}
/* *********************************** */
yyc_ST_DOUBLE_QUOTES:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0, 128,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
		};
		YYDEBUG(68, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych == '"') goto yy72;
		if (yych == '$') goto yy74;
		YYDEBUG(70, *YYCURSOR);
		++YYCURSOR;
yy71:
		YYDEBUG(71, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 587 "Zend/zend_ini_scanner.l"
		{ /* Escape double quoted string contents */
	if (YYCURSOR > YYLIMIT) {
		return 0;
	}

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '"':
				if (YYCURSOR < YYLIMIT && YYCURSOR[-2] == '\\' && *YYCURSOR != '\r' && *YYCURSOR != '\n') {
					continue;
				}
				break;
			case '$':
				if (*YYCURSOR == '{') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT && *YYCURSOR != '"') {
					YYCURSOR++;
				}
				/* fall through */
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

	yyleng = YYCURSOR - SCNG(yy_text);

	zend_ini_escape_string(ini_lval, yytext, yyleng, '"');
	return TC_QUOTED_STRING;
}
#line 1209 "Zend/zend_ini_scanner.c"
yy72:
		YYDEBUG(72, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy78;
yy73:
		YYDEBUG(73, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 582 "Zend/zend_ini_scanner.l"
		{ /* Double quoted '"' string ends */
	yy_pop_state();
	return '"';
}
#line 1223 "Zend/zend_ini_scanner.c"
yy74:
		YYDEBUG(74, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '{') goto yy71;
		YYDEBUG(75, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(76, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 449 "Zend/zend_ini_scanner.l"
		{ /* Variable start */
	yy_push_state(ST_VARNAME);
	return TC_DOLLAR_CURLY;
}
#line 1237 "Zend/zend_ini_scanner.c"
yy77:
		YYDEBUG(77, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy78:
		YYDEBUG(78, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy77;
		}
		goto yy73;
	}
/* *********************************** */
yyc_ST_OFFSET:
	{
		static const unsigned char yybm[] = {
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66, 194,  64,  66,  66,  64,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			194,  66,  64,  66,  68,  66,  66,   0, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			114, 114, 114, 114, 114, 114, 114, 114, 
			114, 114,  66,  64,  66,  66,  66,  66, 
			 66,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  66,  72,  64,  66,  82, 
			 66,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
		};
		YYDEBUG(79, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '-') {
			if (yych <= ' ') {
				if (yych <= '\n') {
					if (yych <= 0x08) goto yy81;
					if (yych <= '\t') goto yy83;
					goto yy84;
				} else {
					if (yych == '\r') goto yy84;
					if (yych >= ' ') goto yy83;
				}
			} else {
				if (yych <= '$') {
					if (yych == '"') goto yy86;
					if (yych >= '$') goto yy88;
				} else {
					if (yych == '\'') goto yy89;
					if (yych >= '-') goto yy90;
				}
			}
		} else {
			if (yych <= 'Z') {
				if (yych <= '9') {
					if (yych <= '.') goto yy91;
					if (yych >= '0') goto yy92;
				} else {
					if (yych == ';') goto yy84;
					if (yych >= 'A') goto yy94;
				}
			} else {
				if (yych <= '^') {
					if (yych <= '[') goto yy81;
					if (yych <= '\\') goto yy96;
					if (yych <= ']') goto yy97;
				} else {
					if (yych == '`') goto yy81;
					if (yych <= 'z') goto yy94;
				}
			}
		}
yy81:
		YYDEBUG(81, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		goto yy100;
yy82:
		YYDEBUG(82, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 573 "Zend/zend_ini_scanner.l"
		{ /* Get rest as section/offset value */
	RETURN_TOKEN(TC_STRING, yytext, yyleng);
}
#line 1341 "Zend/zend_ini_scanner.c"
yy83:
		YYDEBUG(83, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy126;
		}
		if (yych == '"') goto yy128;
		if (yych == ']') goto yy129;
		goto yy100;
yy84:
		YYDEBUG(84, *YYCURSOR);
		++YYCURSOR;
yy85:
		YYDEBUG(85, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 648 "Zend/zend_ini_scanner.l"
		{
	return 0;
}
#line 1362 "Zend/zend_ini_scanner.c"
yy86:
		YYDEBUG(86, *YYCURSOR);
		++YYCURSOR;
yy87:
		YYDEBUG(87, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 577 "Zend/zend_ini_scanner.l"
		{ /* Double quoted '"' string start */
	yy_push_state(ST_DOUBLE_QUOTES);
	return '"';
}
#line 1374 "Zend/zend_ini_scanner.c"
yy88:
		YYDEBUG(88, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '\\') {
			if (yych <= 0x00) goto yy85;
			if (yych <= '[') goto yy99;
			goto yy104;
		} else {
			if (yych == '{') goto yy124;
			goto yy99;
		}
yy89:
		YYDEBUG(89, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy120;
		}
		goto yy85;
yy90:
		YYDEBUG(90, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '/') goto yy100;
		if (yych <= '9') goto yy118;
		goto yy100;
yy91:
		YYDEBUG(91, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '/') goto yy100;
		if (yych <= '9') goto yy116;
		goto yy100;
yy92:
		YYDEBUG(92, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '\'') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy93;
				if (yych <= '\f') goto yy100;
			} else {
				if (yych == '"') goto yy93;
				if (yych <= '&') goto yy100;
			}
		} else {
			if (yych <= '9') {
				if (yych == '.') goto yy112;
				if (yych <= '/') goto yy100;
				goto yy114;
			} else {
				if (yych <= ';') {
					if (yych <= ':') goto yy100;
				} else {
					if (yych != ']') goto yy100;
				}
			}
		}
yy93:
		YYDEBUG(93, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 551 "Zend/zend_ini_scanner.l"
		{ /* Get number option value as string */
	RETURN_TOKEN(TC_NUMBER, yytext, yyleng);
}
#line 1440 "Zend/zend_ini_scanner.c"
yy94:
		YYDEBUG(94, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy110;
		}
		if (yych <= '"') {
			if (yych <= '\f') {
				if (yych != '\n') goto yy100;
			} else {
				if (yych <= '\r') goto yy95;
				if (yych <= '!') goto yy100;
			}
		} else {
			if (yych <= ':') {
				if (yych != '\'') goto yy100;
			} else {
				if (yych <= ';') goto yy95;
				if (yych != ']') goto yy100;
			}
		}
yy95:
		YYDEBUG(95, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 547 "Zend/zend_ini_scanner.l"
		{ /* Get constant option value */
	RETURN_TOKEN(TC_CONSTANT, yytext, yyleng);
}
#line 1470 "Zend/zend_ini_scanner.c"
yy96:
		YYDEBUG(96, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy99;
yy97:
		YYDEBUG(97, *YYCURSOR);
		++YYCURSOR;
yy98:
		YYDEBUG(98, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 444 "Zend/zend_ini_scanner.l"
		{ /* End of section or an option offset */
	BEGIN(INITIAL);
	return ']';
}
#line 1486 "Zend/zend_ini_scanner.c"
yy99:
		YYDEBUG(99, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy100:
		YYDEBUG(100, *YYCURSOR);
		if (yybm[0+yych] & 2) {
			goto yy99;
		}
		if (yych == '$') goto yy102;
		if (yych != '\\') goto yy82;
yy101:
		YYDEBUG(101, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		goto yy99;
yy102:
		YYDEBUG(102, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\\') {
			if (yych <= 0x00) goto yy103;
			if (yych <= '[') goto yy99;
			goto yy104;
		} else {
			if (yych != '{') goto yy99;
		}
yy103:
		YYDEBUG(103, *YYCURSOR);
		YYCURSOR = YYMARKER;
		if (yyaccept <= 1) {
			if (yyaccept <= 0) {
				goto yy82;
			} else {
				goto yy85;
			}
		} else {
			if (yyaccept <= 2) {
				goto yy93;
			} else {
				goto yy95;
			}
		}
yy104:
		YYDEBUG(104, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 4) {
			goto yy105;
		}
		if (yych == '\\') goto yy107;
		goto yy99;
yy105:
		YYDEBUG(105, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(106, *YYCURSOR);
		if (yybm[0+yych] & 4) {
			goto yy105;
		}
		if (yych == '\\') goto yy109;
		goto yy99;
yy107:
		YYDEBUG(107, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(108, *YYCURSOR);
		if (yybm[0+yych] & 4) {
			goto yy105;
		}
		if (yych == '\\') goto yy107;
		goto yy99;
yy109:
		YYDEBUG(109, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 4) {
			goto yy105;
		}
		if (yych == '\\') goto yy107;
		goto yy99;
yy110:
		YYDEBUG(110, *YYCURSOR);
		yyaccept = 3;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(111, *YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy110;
		}
		if (yych <= '$') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy95;
				if (yych <= '\f') goto yy99;
				goto yy95;
			} else {
				if (yych == '"') goto yy95;
				if (yych <= '#') goto yy99;
				goto yy102;
			}
		} else {
			if (yych <= ';') {
				if (yych == '\'') goto yy95;
				if (yych <= ':') goto yy99;
				goto yy95;
			} else {
				if (yych <= '[') goto yy99;
				if (yych <= '\\') goto yy101;
				if (yych <= ']') goto yy95;
				goto yy99;
			}
		}
yy112:
		YYDEBUG(112, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(113, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy112;
		}
		if (yych <= '$') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy93;
				if (yych <= '\f') goto yy99;
				goto yy93;
			} else {
				if (yych == '"') goto yy93;
				if (yych <= '#') goto yy99;
				goto yy102;
			}
		} else {
			if (yych <= ';') {
				if (yych == '\'') goto yy93;
				if (yych <= ':') goto yy99;
				goto yy93;
			} else {
				if (yych <= '[') goto yy99;
				if (yych <= '\\') goto yy101;
				if (yych <= ']') goto yy93;
				goto yy99;
			}
		}
yy114:
		YYDEBUG(114, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(115, *YYCURSOR);
		if (yych <= '\'') {
			if (yych <= '!') {
				if (yych <= '\n') {
					if (yych <= '\t') goto yy99;
					goto yy93;
				} else {
					if (yych == '\r') goto yy93;
					goto yy99;
				}
			} else {
				if (yych <= '#') {
					if (yych <= '"') goto yy93;
					goto yy99;
				} else {
					if (yych <= '$') goto yy102;
					if (yych <= '&') goto yy99;
					goto yy93;
				}
			}
		} else {
			if (yych <= ':') {
				if (yych <= '.') {
					if (yych <= '-') goto yy99;
					goto yy112;
				} else {
					if (yych <= '/') goto yy99;
					if (yych <= '9') goto yy114;
					goto yy99;
				}
			} else {
				if (yych <= '[') {
					if (yych <= ';') goto yy93;
					goto yy99;
				} else {
					if (yych <= '\\') goto yy101;
					if (yych <= ']') goto yy93;
					goto yy99;
				}
			}
		}
yy116:
		YYDEBUG(116, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(117, *YYCURSOR);
		if (yych <= '&') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy93;
				if (yych <= '\f') goto yy99;
				goto yy93;
			} else {
				if (yych <= '"') {
					if (yych <= '!') goto yy99;
					goto yy93;
				} else {
					if (yych == '$') goto yy102;
					goto yy99;
				}
			}
		} else {
			if (yych <= ':') {
				if (yych <= '\'') goto yy93;
				if (yych <= '/') goto yy99;
				if (yych <= '9') goto yy116;
				goto yy99;
			} else {
				if (yych <= '[') {
					if (yych <= ';') goto yy93;
					goto yy99;
				} else {
					if (yych <= '\\') goto yy101;
					if (yych <= ']') goto yy93;
					goto yy99;
				}
			}
		}
yy118:
		YYDEBUG(118, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(119, *YYCURSOR);
		if (yych <= '&') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy93;
				if (yych <= '\f') goto yy99;
				goto yy93;
			} else {
				if (yych <= '"') {
					if (yych <= '!') goto yy99;
					goto yy93;
				} else {
					if (yych == '$') goto yy102;
					goto yy99;
				}
			}
		} else {
			if (yych <= ':') {
				if (yych <= '\'') goto yy93;
				if (yych <= '/') goto yy99;
				if (yych <= '9') goto yy118;
				goto yy99;
			} else {
				if (yych <= '[') {
					if (yych <= ';') goto yy93;
					goto yy99;
				} else {
					if (yych <= '\\') goto yy101;
					if (yych <= ']') goto yy93;
					goto yy99;
				}
			}
		}
yy120:
		YYDEBUG(120, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(121, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy120;
		}
		YYDEBUG(122, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(123, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 416 "Zend/zend_ini_scanner.l"
		{ /* Raw string */
	/* Eat leading and trailing single quotes */
	if (yytext[0] == '\'' && yytext[yyleng - 1] == '\'') {
		SCNG(yy_text)++;
		yyleng = yyleng - 2;
	}
	RETURN_TOKEN(TC_RAW, yytext, yyleng);
}
#line 1785 "Zend/zend_ini_scanner.c"
yy124:
		YYDEBUG(124, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(125, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 449 "Zend/zend_ini_scanner.l"
		{ /* Variable start */
	yy_push_state(ST_VARNAME);
	return TC_DOLLAR_CURLY;
}
#line 1796 "Zend/zend_ini_scanner.c"
yy126:
		YYDEBUG(126, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(127, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy126;
		}
		if (yych <= '$') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy82;
				if (yych <= '\f') goto yy99;
				goto yy82;
			} else {
				if (yych == '"') goto yy128;
				if (yych <= '#') goto yy99;
				goto yy102;
			}
		} else {
			if (yych <= ';') {
				if (yych == '\'') goto yy82;
				if (yych <= ':') goto yy99;
				goto yy82;
			} else {
				if (yych <= '[') goto yy99;
				if (yych <= '\\') goto yy101;
				if (yych <= ']') goto yy129;
				goto yy99;
			}
		}
yy128:
		YYDEBUG(128, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy87;
yy129:
		YYDEBUG(129, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy98;
	}
/* *********************************** */
yyc_ST_RAW:
	{
		static const unsigned char yybm[] = {
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64, 192,   0,  64,  64,   0,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			192,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
		};
		YYDEBUG(130, *YYCURSOR);
		YYFILL(3);
		yych = *YYCURSOR;
		if (yych <= '\f') {
			if (yych <= 0x08) {
				if (yych >= 0x01) goto yy134;
			} else {
				if (yych <= '\t') goto yy136;
				if (yych <= '\n') goto yy137;
				goto yy134;
			}
		} else {
			if (yych <= ' ') {
				if (yych <= '\r') goto yy139;
				if (yych <= 0x1F) goto yy134;
				goto yy136;
			} else {
				if (yych == ';') goto yy140;
				goto yy134;
			}
		}
		YYDEBUG(132, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(133, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 643 "Zend/zend_ini_scanner.l"
		{ /* End of option value (if EOF is reached before EOL */
	BEGIN(INITIAL);
	return END_OF_LINE;
}
#line 1906 "Zend/zend_ini_scanner.c"
yy134:
		YYDEBUG(134, *YYCURSOR);
		++YYCURSOR;
yy135:
		YYDEBUG(135, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 500 "Zend/zend_ini_scanner.l"
		{ /* Raw value, only used when SCNG(scanner_mode) == ZEND_INI_SCANNER_RAW. */
	unsigned char *sc = NULL;
	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR) {
			case '\n':
			case '\r':
				goto end_raw_value_chars;
				break;
			case ';':
				if (sc == NULL) {
					sc = YYCURSOR;
				}
				/* no break */
			default:
				YYCURSOR++;
				break;
		}
	}
end_raw_value_chars:
	yyleng = YYCURSOR - SCNG(yy_text);

	/* Eat trailing semicolons */
	while (yytext[yyleng - 1] == ';') {
		yyleng--;
	}

	/* Eat leading and trailing double quotes */
	if (yyleng > 1 && yytext[0] == '"' && yytext[yyleng - 1] == '"') {
		SCNG(yy_text)++;
		yyleng = yyleng - 2;
	} else if (sc) {
		YYCURSOR = sc;
		yyleng = YYCURSOR - SCNG(yy_text);
	}
	RETURN_TOKEN(TC_RAW, yytext, yyleng);
}
#line 1950 "Zend/zend_ini_scanner.c"
yy136:
		YYDEBUG(136, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '\r') {
			if (yych <= 0x08) goto yy135;
			if (yych <= '\n') goto yy148;
			if (yych <= '\f') goto yy135;
			goto yy148;
		} else {
			if (yych <= ' ') {
				if (yych <= 0x1F) goto yy135;
				goto yy148;
			} else {
				if (yych == ';') goto yy148;
				goto yy135;
			}
		}
yy137:
		YYDEBUG(137, *YYCURSOR);
		++YYCURSOR;
yy138:
		YYDEBUG(138, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 541 "Zend/zend_ini_scanner.l"
		{ /* End of option value */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return END_OF_LINE;
}
#line 1981 "Zend/zend_ini_scanner.c"
yy139:
		YYDEBUG(139, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy146;
		goto yy138;
yy140:
		YYDEBUG(140, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		goto yy142;
yy141:
		YYDEBUG(141, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
yy142:
		YYDEBUG(142, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy141;
		}
		if (yych >= '\r') goto yy145;
yy143:
		YYDEBUG(143, *YYCURSOR);
		++YYCURSOR;
yy144:
		YYDEBUG(144, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 637 "Zend/zend_ini_scanner.l"
		{ /* Comment */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return END_OF_LINE;
}
#line 2015 "Zend/zend_ini_scanner.c"
yy145:
		YYDEBUG(145, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy143;
		goto yy144;
yy146:
		YYDEBUG(146, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy138;
yy147:
		YYDEBUG(147, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
yy148:
		YYDEBUG(148, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy147;
		}
		if (yych <= '\f') {
			if (yych == '\n') goto yy146;
		} else {
			if (yych <= '\r') goto yy150;
			if (yych == ';') goto yy141;
		}
		YYDEBUG(149, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 627 "Zend/zend_ini_scanner.l"
		{
	/* eat whitespace */
	goto restart;
}
#line 2049 "Zend/zend_ini_scanner.c"
yy150:
		YYDEBUG(150, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '\n') goto yy146;
		goto yy138;
	}
/* *********************************** */
yyc_ST_SECTION_RAW:
	{
		static const unsigned char yybm[] = {
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 192,   0, 128, 128,   0, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			192, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128,   0, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(151, *YYCURSOR);
		YYFILL(3);
		yych = *YYCURSOR;
		if (yych <= '\f') {
			if (yych == '\n') goto yy155;
		} else {
			if (yych <= '\r') goto yy155;
			if (yych == ']') goto yy157;
		}
		YYDEBUG(153, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy164;
yy154:
		YYDEBUG(154, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 537 "Zend/zend_ini_scanner.l"
		{ /* Raw value, only used when SCNG(scanner_mode) == ZEND_INI_SCANNER_RAW. */
	RETURN_TOKEN(TC_RAW, yytext, yyleng);
}
#line 2113 "Zend/zend_ini_scanner.c"
yy155:
		YYDEBUG(155, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(156, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 648 "Zend/zend_ini_scanner.l"
		{
	return 0;
}
#line 2123 "Zend/zend_ini_scanner.c"
yy157:
		YYDEBUG(157, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy160;
yy158:
		YYDEBUG(158, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 425 "Zend/zend_ini_scanner.l"
		{ /* End of section */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return ']';
}
#line 2138 "Zend/zend_ini_scanner.c"
yy159:
		YYDEBUG(159, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
yy160:
		YYDEBUG(160, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy159;
		}
		if (yych == '\n') goto yy161;
		if (yych == '\r') goto yy162;
		goto yy158;
yy161:
		YYDEBUG(161, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy158;
yy162:
		YYDEBUG(162, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy161;
		goto yy158;
yy163:
		YYDEBUG(163, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy164:
		YYDEBUG(164, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy163;
		}
		goto yy154;
	}
/* *********************************** */
yyc_ST_SECTION_VALUE:
	{
		static const unsigned char yybm[] = {
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 134, 128, 132, 132, 128, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			134, 132, 128, 132, 136, 132, 132,   0, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			228, 228, 228, 228, 228, 228, 228, 228, 
			228, 228, 132, 128, 132, 132, 132, 132, 
			132, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 132, 144, 128, 132, 164, 
			132, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
		};
		YYDEBUG(165, *YYCURSOR);
		YYFILL(3);
		yych = *YYCURSOR;
		if (yych <= '-') {
			if (yych <= ' ') {
				if (yych <= '\n') {
					if (yych <= 0x08) goto yy167;
					if (yych <= '\t') goto yy169;
					goto yy170;
				} else {
					if (yych == '\r') goto yy170;
					if (yych >= ' ') goto yy169;
				}
			} else {
				if (yych <= '$') {
					if (yych == '"') goto yy172;
					if (yych >= '$') goto yy174;
				} else {
					if (yych == '\'') goto yy175;
					if (yych >= '-') goto yy176;
				}
			}
		} else {
			if (yych <= 'Z') {
				if (yych <= '9') {
					if (yych <= '.') goto yy177;
					if (yych >= '0') goto yy178;
				} else {
					if (yych == ';') goto yy170;
					if (yych >= 'A') goto yy180;
				}
			} else {
				if (yych <= '^') {
					if (yych <= '[') goto yy167;
					if (yych <= '\\') goto yy182;
					if (yych <= ']') goto yy183;
				} else {
					if (yych == '`') goto yy167;
					if (yych <= 'z') goto yy180;
				}
			}
		}
yy167:
		YYDEBUG(167, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		goto yy190;
yy168:
		YYDEBUG(168, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 573 "Zend/zend_ini_scanner.l"
		{ /* Get rest as section/offset value */
	RETURN_TOKEN(TC_STRING, yytext, yyleng);
}
#line 2264 "Zend/zend_ini_scanner.c"
yy169:
		YYDEBUG(169, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy216;
			goto yy190;
		} else {
			if (yych <= ' ') goto yy216;
			if (yych == '"') goto yy218;
			goto yy190;
		}
yy170:
		YYDEBUG(170, *YYCURSOR);
		++YYCURSOR;
yy171:
		YYDEBUG(171, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 648 "Zend/zend_ini_scanner.l"
		{
	return 0;
}
#line 2287 "Zend/zend_ini_scanner.c"
yy172:
		YYDEBUG(172, *YYCURSOR);
		++YYCURSOR;
yy173:
		YYDEBUG(173, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 577 "Zend/zend_ini_scanner.l"
		{ /* Double quoted '"' string start */
	yy_push_state(ST_DOUBLE_QUOTES);
	return '"';
}
#line 2299 "Zend/zend_ini_scanner.c"
yy174:
		YYDEBUG(174, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '\\') {
			if (yych <= 0x00) goto yy171;
			if (yych <= '[') goto yy189;
			goto yy194;
		} else {
			if (yych == '{') goto yy214;
			goto yy189;
		}
yy175:
		YYDEBUG(175, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy210;
		}
		goto yy171;
yy176:
		YYDEBUG(176, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '/') goto yy190;
		if (yych <= '9') goto yy208;
		goto yy190;
yy177:
		YYDEBUG(177, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '/') goto yy190;
		if (yych <= '9') goto yy206;
		goto yy190;
yy178:
		YYDEBUG(178, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '\'') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy179;
				if (yych <= '\f') goto yy190;
			} else {
				if (yych == '"') goto yy179;
				if (yych <= '&') goto yy190;
			}
		} else {
			if (yych <= '9') {
				if (yych == '.') goto yy202;
				if (yych <= '/') goto yy190;
				goto yy204;
			} else {
				if (yych <= ';') {
					if (yych <= ':') goto yy190;
				} else {
					if (yych != ']') goto yy190;
				}
			}
		}
yy179:
		YYDEBUG(179, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 551 "Zend/zend_ini_scanner.l"
		{ /* Get number option value as string */
	RETURN_TOKEN(TC_NUMBER, yytext, yyleng);
}
#line 2365 "Zend/zend_ini_scanner.c"
yy180:
		YYDEBUG(180, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy200;
		}
		if (yych <= '"') {
			if (yych <= '\f') {
				if (yych != '\n') goto yy190;
			} else {
				if (yych <= '\r') goto yy181;
				if (yych <= '!') goto yy190;
			}
		} else {
			if (yych <= ':') {
				if (yych != '\'') goto yy190;
			} else {
				if (yych <= ';') goto yy181;
				if (yych != ']') goto yy190;
			}
		}
yy181:
		YYDEBUG(181, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 547 "Zend/zend_ini_scanner.l"
		{ /* Get constant option value */
	RETURN_TOKEN(TC_CONSTANT, yytext, yyleng);
}
#line 2395 "Zend/zend_ini_scanner.c"
yy182:
		YYDEBUG(182, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy189;
yy183:
		YYDEBUG(183, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy186;
yy184:
		YYDEBUG(184, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 425 "Zend/zend_ini_scanner.l"
		{ /* End of section */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return ']';
}
#line 2414 "Zend/zend_ini_scanner.c"
yy185:
		YYDEBUG(185, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
yy186:
		YYDEBUG(186, *YYCURSOR);
		if (yybm[0+yych] & 2) {
			goto yy185;
		}
		if (yych == '\n') goto yy187;
		if (yych == '\r') goto yy188;
		goto yy184;
yy187:
		YYDEBUG(187, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy184;
yy188:
		YYDEBUG(188, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy187;
		goto yy184;
yy189:
		YYDEBUG(189, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy190:
		YYDEBUG(190, *YYCURSOR);
		if (yybm[0+yych] & 4) {
			goto yy189;
		}
		if (yych == '$') goto yy192;
		if (yych != '\\') goto yy168;
yy191:
		YYDEBUG(191, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		goto yy189;
yy192:
		YYDEBUG(192, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\\') {
			if (yych <= 0x00) goto yy193;
			if (yych <= '[') goto yy189;
			goto yy194;
		} else {
			if (yych != '{') goto yy189;
		}
yy193:
		YYDEBUG(193, *YYCURSOR);
		YYCURSOR = YYMARKER;
		if (yyaccept <= 1) {
			if (yyaccept <= 0) {
				goto yy168;
			} else {
				goto yy171;
			}
		} else {
			if (yyaccept <= 2) {
				goto yy179;
			} else {
				goto yy181;
			}
		}
yy194:
		YYDEBUG(194, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 8) {
			goto yy195;
		}
		if (yych == '\\') goto yy197;
		goto yy189;
yy195:
		YYDEBUG(195, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(196, *YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy195;
		}
		if (yych == '\\') goto yy199;
		goto yy189;
yy197:
		YYDEBUG(197, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(198, *YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy195;
		}
		if (yych == '\\') goto yy197;
		goto yy189;
yy199:
		YYDEBUG(199, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 8) {
			goto yy195;
		}
		if (yych == '\\') goto yy197;
		goto yy189;
yy200:
		YYDEBUG(200, *YYCURSOR);
		yyaccept = 3;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(201, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy200;
		}
		if (yych <= '$') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy181;
				if (yych <= '\f') goto yy189;
				goto yy181;
			} else {
				if (yych == '"') goto yy181;
				if (yych <= '#') goto yy189;
				goto yy192;
			}
		} else {
			if (yych <= ';') {
				if (yych == '\'') goto yy181;
				if (yych <= ':') goto yy189;
				goto yy181;
			} else {
				if (yych <= '[') goto yy189;
				if (yych <= '\\') goto yy191;
				if (yych <= ']') goto yy181;
				goto yy189;
			}
		}
yy202:
		YYDEBUG(202, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(203, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy202;
		}
		if (yych <= '$') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy179;
				if (yych <= '\f') goto yy189;
				goto yy179;
			} else {
				if (yych == '"') goto yy179;
				if (yych <= '#') goto yy189;
				goto yy192;
			}
		} else {
			if (yych <= ';') {
				if (yych == '\'') goto yy179;
				if (yych <= ':') goto yy189;
				goto yy179;
			} else {
				if (yych <= '[') goto yy189;
				if (yych <= '\\') goto yy191;
				if (yych <= ']') goto yy179;
				goto yy189;
			}
		}
yy204:
		YYDEBUG(204, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(205, *YYCURSOR);
		if (yych <= '\'') {
			if (yych <= '!') {
				if (yych <= '\n') {
					if (yych <= '\t') goto yy189;
					goto yy179;
				} else {
					if (yych == '\r') goto yy179;
					goto yy189;
				}
			} else {
				if (yych <= '#') {
					if (yych <= '"') goto yy179;
					goto yy189;
				} else {
					if (yych <= '$') goto yy192;
					if (yych <= '&') goto yy189;
					goto yy179;
				}
			}
		} else {
			if (yych <= ':') {
				if (yych <= '.') {
					if (yych <= '-') goto yy189;
					goto yy202;
				} else {
					if (yych <= '/') goto yy189;
					if (yych <= '9') goto yy204;
					goto yy189;
				}
			} else {
				if (yych <= '[') {
					if (yych <= ';') goto yy179;
					goto yy189;
				} else {
					if (yych <= '\\') goto yy191;
					if (yych <= ']') goto yy179;
					goto yy189;
				}
			}
		}
yy206:
		YYDEBUG(206, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(207, *YYCURSOR);
		if (yych <= '&') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy179;
				if (yych <= '\f') goto yy189;
				goto yy179;
			} else {
				if (yych <= '"') {
					if (yych <= '!') goto yy189;
					goto yy179;
				} else {
					if (yych == '$') goto yy192;
					goto yy189;
				}
			}
		} else {
			if (yych <= ':') {
				if (yych <= '\'') goto yy179;
				if (yych <= '/') goto yy189;
				if (yych <= '9') goto yy206;
				goto yy189;
			} else {
				if (yych <= '[') {
					if (yych <= ';') goto yy179;
					goto yy189;
				} else {
					if (yych <= '\\') goto yy191;
					if (yych <= ']') goto yy179;
					goto yy189;
				}
			}
		}
yy208:
		YYDEBUG(208, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(209, *YYCURSOR);
		if (yych <= '&') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy179;
				if (yych <= '\f') goto yy189;
				goto yy179;
			} else {
				if (yych <= '"') {
					if (yych <= '!') goto yy189;
					goto yy179;
				} else {
					if (yych == '$') goto yy192;
					goto yy189;
				}
			}
		} else {
			if (yych <= ':') {
				if (yych <= '\'') goto yy179;
				if (yych <= '/') goto yy189;
				if (yych <= '9') goto yy208;
				goto yy189;
			} else {
				if (yych <= '[') {
					if (yych <= ';') goto yy179;
					goto yy189;
				} else {
					if (yych <= '\\') goto yy191;
					if (yych <= ']') goto yy179;
					goto yy189;
				}
			}
		}
yy210:
		YYDEBUG(210, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(211, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy210;
		}
		YYDEBUG(212, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(213, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 416 "Zend/zend_ini_scanner.l"
		{ /* Raw string */
	/* Eat leading and trailing single quotes */
	if (yytext[0] == '\'' && yytext[yyleng - 1] == '\'') {
		SCNG(yy_text)++;
		yyleng = yyleng - 2;
	}
	RETURN_TOKEN(TC_RAW, yytext, yyleng);
}
#line 2735 "Zend/zend_ini_scanner.c"
yy214:
		YYDEBUG(214, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(215, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 449 "Zend/zend_ini_scanner.l"
		{ /* Variable start */
	yy_push_state(ST_VARNAME);
	return TC_DOLLAR_CURLY;
}
#line 2746 "Zend/zend_ini_scanner.c"
yy216:
		YYDEBUG(216, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(217, *YYCURSOR);
		if (yych <= '"') {
			if (yych <= '\f') {
				if (yych <= 0x08) goto yy189;
				if (yych <= '\t') goto yy216;
				if (yych <= '\n') goto yy168;
				goto yy189;
			} else {
				if (yych <= 0x1F) {
					if (yych <= '\r') goto yy168;
					goto yy189;
				} else {
					if (yych <= ' ') goto yy216;
					if (yych <= '!') goto yy189;
				}
			}
		} else {
			if (yych <= ':') {
				if (yych <= '$') {
					if (yych <= '#') goto yy189;
					goto yy192;
				} else {
					if (yych == '\'') goto yy168;
					goto yy189;
				}
			} else {
				if (yych <= '[') {
					if (yych <= ';') goto yy168;
					goto yy189;
				} else {
					if (yych <= '\\') goto yy191;
					if (yych <= ']') goto yy168;
					goto yy189;
				}
			}
		}
yy218:
		YYDEBUG(218, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy173;
	}
/* *********************************** */
yyc_ST_VALUE:
	{
		static const unsigned char yybm[] = {
			160, 162, 162, 162, 162, 162, 162, 162, 
			162, 176, 128, 162, 162, 128, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			176, 160, 160, 162, 168, 162, 160,  32, 
			160, 160, 162, 162, 162, 162, 162, 162, 
			230, 230, 230, 230, 230, 230, 230, 230, 
			230, 230, 162, 160, 162, 160, 162, 162, 
			162, 166, 166, 166, 166, 166, 166, 166, 
			166, 166, 166, 166, 166, 166, 166, 166, 
			166, 166, 166, 166, 166, 166, 166, 166, 
			166, 166, 166, 162, 162, 162, 160, 166, 
			162, 166, 166, 166, 166, 166, 166, 166, 
			166, 166, 166, 166, 166, 166, 166, 166, 
			166, 166, 166, 166, 166, 166, 166, 166, 
			166, 166, 166, 162, 160, 162, 160, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
		};
		YYDEBUG(219, *YYCURSOR);
		YYFILL(6);
		yych = *YYCURSOR;
		YYDEBUG(-1, yych);
		switch (yych) {
		case 0x00:	goto yy221;
		case '\t':
		case ' ':	goto yy225;
		case '\n':	goto yy227;
		case '\r':	goto yy229;
		case '!':
		case '&':
		case '(':
		case ')':
		case '^':
		case '|':
		case '~':	goto yy230;
		case '"':	goto yy232;
		case '$':	goto yy234;
		case '\'':	goto yy235;
		case '-':	goto yy236;
		case '.':	goto yy237;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':	goto yy238;
		case ';':	goto yy240;
		case '=':	goto yy241;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'z':	goto yy243;
		case 'F':
		case 'f':	goto yy245;
		case 'N':
		case 'n':	goto yy246;
		case 'O':
		case 'o':	goto yy247;
		case 'T':
		case 't':	goto yy248;
		case 'Y':
		case 'y':	goto yy249;
		default:	goto yy223;
		}
yy221:
		YYDEBUG(221, *YYCURSOR);
		++YYCURSOR;
yy222:
		YYDEBUG(222, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 643 "Zend/zend_ini_scanner.l"
		{ /* End of option value (if EOF is reached before EOL */
	BEGIN(INITIAL);
	return END_OF_LINE;
}
#line 2932 "Zend/zend_ini_scanner.c"
yy223:
		YYDEBUG(223, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		goto yy251;
yy224:
		YYDEBUG(224, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 569 "Zend/zend_ini_scanner.l"
		{ /* Get everything else as option/offset value */
	RETURN_TOKEN(TC_STRING, yytext, yyleng);
}
#line 2945 "Zend/zend_ini_scanner.c"
yy225:
		YYDEBUG(225, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		goto yy305;
yy226:
		YYDEBUG(226, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 623 "Zend/zend_ini_scanner.l"
		{
	RETURN_TOKEN(TC_WHITESPACE, yytext, yyleng);
}
#line 2958 "Zend/zend_ini_scanner.c"
yy227:
		YYDEBUG(227, *YYCURSOR);
		++YYCURSOR;
yy228:
		YYDEBUG(228, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 541 "Zend/zend_ini_scanner.l"
		{ /* End of option value */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return END_OF_LINE;
}
#line 2971 "Zend/zend_ini_scanner.c"
yy229:
		YYDEBUG(229, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy303;
		goto yy228;
yy230:
		YYDEBUG(230, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy302;
yy231:
		YYDEBUG(231, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 559 "Zend/zend_ini_scanner.l"
		{ /* Boolean operators */
	return yytext[0];
}
#line 2989 "Zend/zend_ini_scanner.c"
yy232:
		YYDEBUG(232, *YYCURSOR);
		++YYCURSOR;
yy233:
		YYDEBUG(233, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 577 "Zend/zend_ini_scanner.l"
		{ /* Double quoted '"' string start */
	yy_push_state(ST_DOUBLE_QUOTES);
	return '"';
}
#line 3001 "Zend/zend_ini_scanner.c"
yy234:
		YYDEBUG(234, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '\\') {
			if (yych <= 0x00) goto yy222;
			if (yych <= '[') goto yy250;
			goto yy257;
		} else {
			if (yych == '{') goto yy299;
			goto yy250;
		}
yy235:
		YYDEBUG(235, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy295;
		}
		goto yy222;
yy236:
		YYDEBUG(236, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '/') goto yy251;
		if (yych <= '9') goto yy293;
		goto yy251;
yy237:
		YYDEBUG(237, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '/') goto yy251;
		if (yych <= '9') goto yy291;
		goto yy251;
yy238:
		YYDEBUG(238, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '/') {
			if (yych <= 0x1F) {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy239;
					if (yych <= 0x08) goto yy251;
				} else {
					if (yych != '\r') goto yy251;
				}
			} else {
				if (yych <= ')') {
					if (yych <= '"') goto yy239;
					if (yych <= '%') goto yy251;
				} else {
					if (yych == '.') goto yy287;
					goto yy251;
				}
			}
		} else {
			if (yych <= ']') {
				if (yych <= ';') {
					if (yych <= '9') goto yy289;
					if (yych <= ':') goto yy251;
				} else {
					if (yych != '=') goto yy251;
				}
			} else {
				if (yych <= '|') {
					if (yych <= '^') goto yy239;
					if (yych <= '{') goto yy251;
				} else {
					if (yych != '~') goto yy251;
				}
			}
		}
yy239:
		YYDEBUG(239, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 551 "Zend/zend_ini_scanner.l"
		{ /* Get number option value as string */
	RETURN_TOKEN(TC_NUMBER, yytext, yyleng);
}
#line 3080 "Zend/zend_ini_scanner.c"
yy240:
		YYDEBUG(240, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		goto yy283;
yy241:
		YYDEBUG(241, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(242, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 563 "Zend/zend_ini_scanner.l"
		{ /* Make = used in option value to trigger error */
	yyless(0);
	BEGIN(INITIAL);
	return END_OF_LINE;
}
#line 3097 "Zend/zend_ini_scanner.c"
yy243:
		YYDEBUG(243, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 4) {
			goto yy252;
		}
		if (yych <= ':') {
			if (yych <= '\r') {
				if (yych <= 0x08) {
					if (yych >= 0x01) goto yy251;
				} else {
					if (yych <= '\n') goto yy244;
					if (yych <= '\f') goto yy251;
				}
			} else {
				if (yych <= '"') {
					if (yych <= 0x1F) goto yy251;
				} else {
					if (yych <= '%') goto yy251;
					if (yych >= '*') goto yy251;
				}
			}
		} else {
			if (yych <= '^') {
				if (yych <= '<') {
					if (yych >= '<') goto yy251;
				} else {
					if (yych <= '=') goto yy244;
					if (yych <= ']') goto yy251;
				}
			} else {
				if (yych <= '|') {
					if (yych <= '{') goto yy251;
				} else {
					if (yych != '~') goto yy251;
				}
			}
		}
yy244:
		YYDEBUG(244, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 547 "Zend/zend_ini_scanner.l"
		{ /* Get constant option value */
	RETURN_TOKEN(TC_CONSTANT, yytext, yyleng);
}
#line 3144 "Zend/zend_ini_scanner.c"
yy245:
		YYDEBUG(245, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '<') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy244;
					if (yych <= 0x08) goto yy251;
					goto yy244;
				} else {
					if (yych == '\r') goto yy244;
					if (yych <= 0x1F) goto yy251;
					goto yy244;
				}
			} else {
				if (yych <= '/') {
					if (yych <= '%') goto yy251;
					if (yych <= ')') goto yy244;
					goto yy251;
				} else {
					if (yych <= '9') goto yy252;
					if (yych == ';') goto yy244;
					goto yy251;
				}
			}
		} else {
			if (yych <= '_') {
				if (yych <= 'A') {
					if (yych <= '=') goto yy244;
					if (yych <= '@') goto yy251;
					goto yy279;
				} else {
					if (yych <= 'Z') goto yy252;
					if (yych <= ']') goto yy251;
					if (yych <= '^') goto yy244;
					goto yy252;
				}
			} else {
				if (yych <= '{') {
					if (yych <= '`') goto yy251;
					if (yych <= 'a') goto yy279;
					if (yych <= 'z') goto yy252;
					goto yy251;
				} else {
					if (yych == '}') goto yy251;
					if (yych <= '~') goto yy244;
					goto yy251;
				}
			}
		}
yy246:
		YYDEBUG(246, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'N') {
			if (yych <= '%') {
				if (yych <= '\f') {
					if (yych <= 0x00) goto yy244;
					if (yych <= 0x08) goto yy251;
					if (yych <= '\n') goto yy244;
					goto yy251;
				} else {
					if (yych <= '\r') goto yy244;
					if (yych <= 0x1F) goto yy251;
					if (yych <= '"') goto yy244;
					goto yy251;
				}
			} else {
				if (yych <= ':') {
					if (yych <= ')') goto yy244;
					if (yych <= '/') goto yy251;
					if (yych <= '9') goto yy252;
					goto yy251;
				} else {
					if (yych <= '<') {
						if (yych <= ';') goto yy244;
						goto yy251;
					} else {
						if (yych <= '=') goto yy244;
						if (yych <= '@') goto yy251;
						goto yy252;
					}
				}
			}
		} else {
			if (yych <= 'n') {
				if (yych <= 'Z') {
					if (yych <= 'O') goto yy271;
					if (yych == 'U') goto yy272;
					goto yy252;
				} else {
					if (yych <= '^') {
						if (yych <= ']') goto yy251;
						goto yy244;
					} else {
						if (yych == '`') goto yy251;
						goto yy252;
					}
				}
			} else {
				if (yych <= 'z') {
					if (yych <= 'o') goto yy271;
					if (yych == 'u') goto yy272;
					goto yy252;
				} else {
					if (yych <= '|') {
						if (yych <= '{') goto yy251;
						goto yy244;
					} else {
						if (yych == '~') goto yy244;
						goto yy251;
					}
				}
			}
		}
yy247:
		YYDEBUG(247, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'E') {
			if (yych <= '%') {
				if (yych <= '\f') {
					if (yych <= 0x00) goto yy244;
					if (yych <= 0x08) goto yy251;
					if (yych <= '\n') goto yy244;
					goto yy251;
				} else {
					if (yych <= '\r') goto yy244;
					if (yych <= 0x1F) goto yy251;
					if (yych <= '"') goto yy244;
					goto yy251;
				}
			} else {
				if (yych <= ':') {
					if (yych <= ')') goto yy244;
					if (yych <= '/') goto yy251;
					if (yych <= '9') goto yy252;
					goto yy251;
				} else {
					if (yych <= '<') {
						if (yych <= ';') goto yy244;
						goto yy251;
					} else {
						if (yych <= '=') goto yy244;
						if (yych <= '@') goto yy251;
						goto yy252;
					}
				}
			}
		} else {
			if (yych <= 'e') {
				if (yych <= 'Z') {
					if (yych <= 'F') goto yy266;
					if (yych == 'N') goto yy260;
					goto yy252;
				} else {
					if (yych <= '^') {
						if (yych <= ']') goto yy251;
						goto yy244;
					} else {
						if (yych == '`') goto yy251;
						goto yy252;
					}
				}
			} else {
				if (yych <= 'z') {
					if (yych <= 'f') goto yy266;
					if (yych == 'n') goto yy260;
					goto yy252;
				} else {
					if (yych <= '|') {
						if (yych <= '{') goto yy251;
						goto yy244;
					} else {
						if (yych == '~') goto yy244;
						goto yy251;
					}
				}
			}
		}
yy248:
		YYDEBUG(248, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy244;
					if (yych <= 0x08) goto yy251;
					goto yy244;
				} else {
					if (yych == '\r') goto yy244;
					if (yych <= 0x1F) goto yy251;
					goto yy244;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy251;
					if (yych <= ')') goto yy244;
					if (yych <= '/') goto yy251;
					goto yy252;
				} else {
					if (yych == ';') goto yy244;
					if (yych <= '<') goto yy251;
					goto yy244;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy251;
					if (yych == 'R') goto yy264;
					goto yy252;
				} else {
					if (yych <= ']') goto yy251;
					if (yych <= '^') goto yy244;
					if (yych <= '_') goto yy252;
					goto yy251;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'r') goto yy264;
					if (yych <= 'z') goto yy252;
					goto yy251;
				} else {
					if (yych == '}') goto yy251;
					if (yych <= '~') goto yy244;
					goto yy251;
				}
			}
		}
yy249:
		YYDEBUG(249, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy244;
					if (yych <= 0x08) goto yy251;
					goto yy244;
				} else {
					if (yych == '\r') goto yy244;
					if (yych <= 0x1F) goto yy251;
					goto yy244;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy251;
					if (yych <= ')') goto yy244;
					if (yych <= '/') goto yy251;
					goto yy252;
				} else {
					if (yych == ';') goto yy244;
					if (yych <= '<') goto yy251;
					goto yy244;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy251;
					if (yych == 'E') goto yy254;
					goto yy252;
				} else {
					if (yych <= ']') goto yy251;
					if (yych <= '^') goto yy244;
					if (yych <= '_') goto yy252;
					goto yy251;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'e') goto yy254;
					if (yych <= 'z') goto yy252;
					goto yy251;
				} else {
					if (yych == '}') goto yy251;
					if (yych <= '~') goto yy244;
					goto yy251;
				}
			}
		}
yy250:
		YYDEBUG(250, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy251:
		YYDEBUG(251, *YYCURSOR);
		if (yybm[0+yych] & 2) {
			goto yy250;
		}
		if (yych == '$') goto yy255;
		goto yy224;
yy252:
		YYDEBUG(252, *YYCURSOR);
		yyaccept = 4;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(253, *YYCURSOR);
		if (yybm[0+yych] & 4) {
			goto yy252;
		}
		if (yych <= ')') {
			if (yych <= '\r') {
				if (yych <= 0x08) {
					if (yych <= 0x00) goto yy244;
					goto yy250;
				} else {
					if (yych <= '\n') goto yy244;
					if (yych <= '\f') goto yy250;
					goto yy244;
				}
			} else {
				if (yych <= '#') {
					if (yych <= 0x1F) goto yy250;
					if (yych <= '"') goto yy244;
					goto yy250;
				} else {
					if (yych <= '$') goto yy255;
					if (yych <= '%') goto yy250;
					goto yy244;
				}
			}
		} else {
			if (yych <= ']') {
				if (yych <= ';') {
					if (yych <= ':') goto yy250;
					goto yy244;
				} else {
					if (yych == '=') goto yy244;
					goto yy250;
				}
			} else {
				if (yych <= '|') {
					if (yych <= '^') goto yy244;
					if (yych <= '{') goto yy250;
					goto yy244;
				} else {
					if (yych == '~') goto yy244;
					goto yy250;
				}
			}
		}
yy254:
		YYDEBUG(254, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy244;
					if (yych <= 0x08) goto yy251;
					goto yy244;
				} else {
					if (yych == '\r') goto yy244;
					if (yych <= 0x1F) goto yy251;
					goto yy244;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy251;
					if (yych <= ')') goto yy244;
					if (yych <= '/') goto yy251;
					goto yy252;
				} else {
					if (yych == ';') goto yy244;
					if (yych <= '<') goto yy251;
					goto yy244;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy251;
					if (yych == 'S') goto yy260;
					goto yy252;
				} else {
					if (yych <= ']') goto yy251;
					if (yych <= '^') goto yy244;
					if (yych <= '_') goto yy252;
					goto yy251;
				}
			} else {
				if (yych <= '{') {
					if (yych == 's') goto yy260;
					if (yych <= 'z') goto yy252;
					goto yy251;
				} else {
					if (yych == '}') goto yy251;
					if (yych <= '~') goto yy244;
					goto yy251;
				}
			}
		}
yy255:
		YYDEBUG(255, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\\') {
			if (yych <= 0x00) goto yy256;
			if (yych <= '[') goto yy250;
			goto yy257;
		} else {
			if (yych != '{') goto yy250;
		}
yy256:
		YYDEBUG(256, *YYCURSOR);
		YYCURSOR = YYMARKER;
		if (yyaccept <= 3) {
			if (yyaccept <= 1) {
				if (yyaccept <= 0) {
					goto yy224;
				} else {
					goto yy226;
				}
			} else {
				if (yyaccept <= 2) {
					goto yy222;
				} else {
					goto yy239;
				}
			}
		} else {
			if (yyaccept <= 5) {
				if (yyaccept <= 4) {
					goto yy244;
				} else {
					goto yy261;
				}
			} else {
				if (yyaccept <= 6) {
					goto yy268;
				} else {
					goto yy275;
				}
			}
		}
yy257:
		YYDEBUG(257, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 8) {
			goto yy258;
		}
		goto yy250;
yy258:
		YYDEBUG(258, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(259, *YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy258;
		}
		if (yych <= 0x00) goto yy224;
		if (yych == '\\') goto yy257;
		goto yy250;
yy260:
		YYDEBUG(260, *YYCURSOR);
		yyaccept = 5;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy262;
		}
		if (yych <= ';') {
			if (yych <= ' ') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy261;
					if (yych <= '\t') goto yy251;
				} else {
					if (yych != '\r') goto yy251;
				}
			} else {
				if (yych <= ')') {
					if (yych <= '"') goto yy261;
					if (yych <= '%') goto yy251;
				} else {
					if (yych <= '/') goto yy251;
					if (yych <= '9') goto yy252;
					if (yych <= ':') goto yy251;
				}
			}
		} else {
			if (yych <= '_') {
				if (yych <= '@') {
					if (yych != '=') goto yy251;
				} else {
					if (yych <= 'Z') goto yy252;
					if (yych <= ']') goto yy251;
					if (yych >= '_') goto yy252;
				}
			} else {
				if (yych <= '{') {
					if (yych <= '`') goto yy251;
					if (yych <= 'z') goto yy252;
					goto yy251;
				} else {
					if (yych == '}') goto yy251;
					if (yych >= 0x7F) goto yy251;
				}
			}
		}
yy261:
		YYDEBUG(261, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 469 "Zend/zend_ini_scanner.l"
		{ /* TRUE value (when used outside option value/offset this causes parse error!) */
	RETURN_TOKEN(BOOL_TRUE, "1", 1);
}
#line 3660 "Zend/zend_ini_scanner.c"
yy262:
		YYDEBUG(262, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(263, *YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy262;
		}
		goto yy261;
yy264:
		YYDEBUG(264, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy244;
					if (yych <= 0x08) goto yy251;
					goto yy244;
				} else {
					if (yych == '\r') goto yy244;
					if (yych <= 0x1F) goto yy251;
					goto yy244;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy251;
					if (yych <= ')') goto yy244;
					if (yych <= '/') goto yy251;
					goto yy252;
				} else {
					if (yych == ';') goto yy244;
					if (yych <= '<') goto yy251;
					goto yy244;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy251;
					if (yych != 'U') goto yy252;
				} else {
					if (yych <= ']') goto yy251;
					if (yych <= '^') goto yy244;
					if (yych <= '_') goto yy252;
					goto yy251;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'u') goto yy265;
					if (yych <= 'z') goto yy252;
					goto yy251;
				} else {
					if (yych == '}') goto yy251;
					if (yych <= '~') goto yy244;
					goto yy251;
				}
			}
		}
yy265:
		YYDEBUG(265, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy244;
					if (yych <= 0x08) goto yy251;
					goto yy244;
				} else {
					if (yych == '\r') goto yy244;
					if (yych <= 0x1F) goto yy251;
					goto yy244;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy251;
					if (yych <= ')') goto yy244;
					if (yych <= '/') goto yy251;
					goto yy252;
				} else {
					if (yych == ';') goto yy244;
					if (yych <= '<') goto yy251;
					goto yy244;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy251;
					if (yych == 'E') goto yy260;
					goto yy252;
				} else {
					if (yych <= ']') goto yy251;
					if (yych <= '^') goto yy244;
					if (yych <= '_') goto yy252;
					goto yy251;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'e') goto yy260;
					if (yych <= 'z') goto yy252;
					goto yy251;
				} else {
					if (yych == '}') goto yy251;
					if (yych <= '~') goto yy244;
					goto yy251;
				}
			}
		}
yy266:
		YYDEBUG(266, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy244;
					if (yych <= 0x08) goto yy251;
					goto yy244;
				} else {
					if (yych == '\r') goto yy244;
					if (yych <= 0x1F) goto yy251;
					goto yy244;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy251;
					if (yych <= ')') goto yy244;
					if (yych <= '/') goto yy251;
					goto yy252;
				} else {
					if (yych == ';') goto yy244;
					if (yych <= '<') goto yy251;
					goto yy244;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy251;
					if (yych != 'F') goto yy252;
				} else {
					if (yych <= ']') goto yy251;
					if (yych <= '^') goto yy244;
					if (yych <= '_') goto yy252;
					goto yy251;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'f') goto yy267;
					if (yych <= 'z') goto yy252;
					goto yy251;
				} else {
					if (yych == '}') goto yy251;
					if (yych <= '~') goto yy244;
					goto yy251;
				}
			}
		}
yy267:
		YYDEBUG(267, *YYCURSOR);
		yyaccept = 6;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 4) {
			goto yy252;
		}
		if (yych <= ')') {
			if (yych <= '\f') {
				if (yych <= 0x08) {
					if (yych >= 0x01) goto yy251;
				} else {
					if (yych <= '\t') goto yy269;
					if (yych >= '\v') goto yy251;
				}
			} else {
				if (yych <= ' ') {
					if (yych <= '\r') goto yy268;
					if (yych <= 0x1F) goto yy251;
					goto yy269;
				} else {
					if (yych <= '"') goto yy268;
					if (yych <= '%') goto yy251;
				}
			}
		} else {
			if (yych <= ']') {
				if (yych <= ';') {
					if (yych <= ':') goto yy251;
				} else {
					if (yych != '=') goto yy251;
				}
			} else {
				if (yych <= '|') {
					if (yych <= '^') goto yy268;
					if (yych <= '{') goto yy251;
				} else {
					if (yych != '~') goto yy251;
				}
			}
		}
yy268:
		YYDEBUG(268, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 473 "Zend/zend_ini_scanner.l"
		{ /* FALSE value (when used outside option value/offset this causes parse error!)*/
	RETURN_TOKEN(BOOL_FALSE, "", 0);
}
#line 3870 "Zend/zend_ini_scanner.c"
yy269:
		YYDEBUG(269, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(270, *YYCURSOR);
		if (yych == '\t') goto yy269;
		if (yych == ' ') goto yy269;
		goto yy268;
yy271:
		YYDEBUG(271, *YYCURSOR);
		yyaccept = 6;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '<') {
			if (yych <= ' ') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy268;
					if (yych <= 0x08) goto yy251;
					if (yych <= '\t') goto yy269;
					goto yy268;
				} else {
					if (yych == '\r') goto yy268;
					if (yych <= 0x1F) goto yy251;
					goto yy269;
				}
			} else {
				if (yych <= '/') {
					if (yych <= '"') goto yy268;
					if (yych <= '%') goto yy251;
					if (yych <= ')') goto yy268;
					goto yy251;
				} else {
					if (yych <= '9') goto yy252;
					if (yych == ';') goto yy268;
					goto yy251;
				}
			}
		} else {
			if (yych <= '_') {
				if (yych <= 'N') {
					if (yych <= '=') goto yy268;
					if (yych <= '@') goto yy251;
					if (yych <= 'M') goto yy252;
					goto yy278;
				} else {
					if (yych <= 'Z') goto yy252;
					if (yych <= ']') goto yy251;
					if (yych <= '^') goto yy268;
					goto yy252;
				}
			} else {
				if (yych <= 'z') {
					if (yych <= '`') goto yy251;
					if (yych == 'n') goto yy278;
					goto yy252;
				} else {
					if (yych <= '|') {
						if (yych <= '{') goto yy251;
						goto yy268;
					} else {
						if (yych == '~') goto yy268;
						goto yy251;
					}
				}
			}
		}
yy272:
		YYDEBUG(272, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy244;
					if (yych <= 0x08) goto yy251;
					goto yy244;
				} else {
					if (yych == '\r') goto yy244;
					if (yych <= 0x1F) goto yy251;
					goto yy244;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy251;
					if (yych <= ')') goto yy244;
					if (yych <= '/') goto yy251;
					goto yy252;
				} else {
					if (yych == ';') goto yy244;
					if (yych <= '<') goto yy251;
					goto yy244;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy251;
					if (yych != 'L') goto yy252;
				} else {
					if (yych <= ']') goto yy251;
					if (yych <= '^') goto yy244;
					if (yych <= '_') goto yy252;
					goto yy251;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'l') goto yy273;
					if (yych <= 'z') goto yy252;
					goto yy251;
				} else {
					if (yych == '}') goto yy251;
					if (yych <= '~') goto yy244;
					goto yy251;
				}
			}
		}
yy273:
		YYDEBUG(273, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy244;
					if (yych <= 0x08) goto yy251;
					goto yy244;
				} else {
					if (yych == '\r') goto yy244;
					if (yych <= 0x1F) goto yy251;
					goto yy244;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy251;
					if (yych <= ')') goto yy244;
					if (yych <= '/') goto yy251;
					goto yy252;
				} else {
					if (yych == ';') goto yy244;
					if (yych <= '<') goto yy251;
					goto yy244;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy251;
					if (yych != 'L') goto yy252;
				} else {
					if (yych <= ']') goto yy251;
					if (yych <= '^') goto yy244;
					if (yych <= '_') goto yy252;
					goto yy251;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'l') goto yy274;
					if (yych <= 'z') goto yy252;
					goto yy251;
				} else {
					if (yych == '}') goto yy251;
					if (yych <= '~') goto yy244;
					goto yy251;
				}
			}
		}
yy274:
		YYDEBUG(274, *YYCURSOR);
		yyaccept = 7;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 4) {
			goto yy252;
		}
		if (yych <= ')') {
			if (yych <= '\f') {
				if (yych <= 0x08) {
					if (yych >= 0x01) goto yy251;
				} else {
					if (yych <= '\t') goto yy276;
					if (yych >= '\v') goto yy251;
				}
			} else {
				if (yych <= ' ') {
					if (yych <= '\r') goto yy275;
					if (yych <= 0x1F) goto yy251;
					goto yy276;
				} else {
					if (yych <= '"') goto yy275;
					if (yych <= '%') goto yy251;
				}
			}
		} else {
			if (yych <= ']') {
				if (yych <= ';') {
					if (yych <= ':') goto yy251;
				} else {
					if (yych != '=') goto yy251;
				}
			} else {
				if (yych <= '|') {
					if (yych <= '^') goto yy275;
					if (yych <= '{') goto yy251;
				} else {
					if (yych != '~') goto yy251;
				}
			}
		}
yy275:
		YYDEBUG(275, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 477 "Zend/zend_ini_scanner.l"
		{
	RETURN_TOKEN(NULL_NULL, "", 0);
}
#line 4085 "Zend/zend_ini_scanner.c"
yy276:
		YYDEBUG(276, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(277, *YYCURSOR);
		if (yych == '\t') goto yy276;
		if (yych == ' ') goto yy276;
		goto yy275;
yy278:
		YYDEBUG(278, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy244;
					if (yych <= 0x08) goto yy251;
					goto yy244;
				} else {
					if (yych == '\r') goto yy244;
					if (yych <= 0x1F) goto yy251;
					goto yy244;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy251;
					if (yych <= ')') goto yy244;
					if (yych <= '/') goto yy251;
					goto yy252;
				} else {
					if (yych == ';') goto yy244;
					if (yych <= '<') goto yy251;
					goto yy244;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy251;
					if (yych == 'E') goto yy267;
					goto yy252;
				} else {
					if (yych <= ']') goto yy251;
					if (yych <= '^') goto yy244;
					if (yych <= '_') goto yy252;
					goto yy251;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'e') goto yy267;
					if (yych <= 'z') goto yy252;
					goto yy251;
				} else {
					if (yych == '}') goto yy251;
					if (yych <= '~') goto yy244;
					goto yy251;
				}
			}
		}
yy279:
		YYDEBUG(279, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy244;
					if (yych <= 0x08) goto yy251;
					goto yy244;
				} else {
					if (yych == '\r') goto yy244;
					if (yych <= 0x1F) goto yy251;
					goto yy244;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy251;
					if (yych <= ')') goto yy244;
					if (yych <= '/') goto yy251;
					goto yy252;
				} else {
					if (yych == ';') goto yy244;
					if (yych <= '<') goto yy251;
					goto yy244;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy251;
					if (yych != 'L') goto yy252;
				} else {
					if (yych <= ']') goto yy251;
					if (yych <= '^') goto yy244;
					if (yych <= '_') goto yy252;
					goto yy251;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'l') goto yy280;
					if (yych <= 'z') goto yy252;
					goto yy251;
				} else {
					if (yych == '}') goto yy251;
					if (yych <= '~') goto yy244;
					goto yy251;
				}
			}
		}
yy280:
		YYDEBUG(280, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy244;
					if (yych <= 0x08) goto yy251;
					goto yy244;
				} else {
					if (yych == '\r') goto yy244;
					if (yych <= 0x1F) goto yy251;
					goto yy244;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy251;
					if (yych <= ')') goto yy244;
					if (yych <= '/') goto yy251;
					goto yy252;
				} else {
					if (yych == ';') goto yy244;
					if (yych <= '<') goto yy251;
					goto yy244;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy251;
					if (yych != 'S') goto yy252;
				} else {
					if (yych <= ']') goto yy251;
					if (yych <= '^') goto yy244;
					if (yych <= '_') goto yy252;
					goto yy251;
				}
			} else {
				if (yych <= '{') {
					if (yych == 's') goto yy281;
					if (yych <= 'z') goto yy252;
					goto yy251;
				} else {
					if (yych == '}') goto yy251;
					if (yych <= '~') goto yy244;
					goto yy251;
				}
			}
		}
yy281:
		YYDEBUG(281, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy244;
					if (yych <= 0x08) goto yy251;
					goto yy244;
				} else {
					if (yych == '\r') goto yy244;
					if (yych <= 0x1F) goto yy251;
					goto yy244;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy251;
					if (yych <= ')') goto yy244;
					if (yych <= '/') goto yy251;
					goto yy252;
				} else {
					if (yych == ';') goto yy244;
					if (yych <= '<') goto yy251;
					goto yy244;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy251;
					if (yych == 'E') goto yy267;
					goto yy252;
				} else {
					if (yych <= ']') goto yy251;
					if (yych <= '^') goto yy244;
					if (yych <= '_') goto yy252;
					goto yy251;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'e') goto yy267;
					if (yych <= 'z') goto yy252;
					goto yy251;
				} else {
					if (yych == '}') goto yy251;
					if (yych <= '~') goto yy244;
					goto yy251;
				}
			}
		}
yy282:
		YYDEBUG(282, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
yy283:
		YYDEBUG(283, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy282;
		}
		if (yych >= '\r') goto yy286;
yy284:
		YYDEBUG(284, *YYCURSOR);
		++YYCURSOR;
yy285:
		YYDEBUG(285, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 637 "Zend/zend_ini_scanner.l"
		{ /* Comment */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return END_OF_LINE;
}
#line 4320 "Zend/zend_ini_scanner.c"
yy286:
		YYDEBUG(286, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy284;
		goto yy285;
yy287:
		YYDEBUG(287, *YYCURSOR);
		yyaccept = 3;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(288, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy287;
		}
		if (yych <= ')') {
			if (yych <= '\r') {
				if (yych <= 0x08) {
					if (yych <= 0x00) goto yy239;
					goto yy250;
				} else {
					if (yych <= '\n') goto yy239;
					if (yych <= '\f') goto yy250;
					goto yy239;
				}
			} else {
				if (yych <= '#') {
					if (yych <= 0x1F) goto yy250;
					if (yych <= '"') goto yy239;
					goto yy250;
				} else {
					if (yych <= '$') goto yy255;
					if (yych <= '%') goto yy250;
					goto yy239;
				}
			}
		} else {
			if (yych <= ']') {
				if (yych <= ';') {
					if (yych <= ':') goto yy250;
					goto yy239;
				} else {
					if (yych == '=') goto yy239;
					goto yy250;
				}
			} else {
				if (yych <= '|') {
					if (yych <= '^') goto yy239;
					if (yych <= '{') goto yy250;
					goto yy239;
				} else {
					if (yych == '~') goto yy239;
					goto yy250;
				}
			}
		}
yy289:
		YYDEBUG(289, *YYCURSOR);
		yyaccept = 3;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(290, *YYCURSOR);
		if (yych <= '.') {
			if (yych <= 0x1F) {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy239;
					if (yych <= 0x08) goto yy250;
					goto yy239;
				} else {
					if (yych == '\r') goto yy239;
					goto yy250;
				}
			} else {
				if (yych <= '$') {
					if (yych <= '"') goto yy239;
					if (yych <= '#') goto yy250;
					goto yy255;
				} else {
					if (yych <= '%') goto yy250;
					if (yych <= ')') goto yy239;
					if (yych <= '-') goto yy250;
					goto yy287;
				}
			}
		} else {
			if (yych <= '=') {
				if (yych <= ':') {
					if (yych <= '/') goto yy250;
					if (yych <= '9') goto yy289;
					goto yy250;
				} else {
					if (yych == '<') goto yy250;
					goto yy239;
				}
			} else {
				if (yych <= '{') {
					if (yych == '^') goto yy239;
					goto yy250;
				} else {
					if (yych == '}') goto yy250;
					if (yych <= '~') goto yy239;
					goto yy250;
				}
			}
		}
yy291:
		YYDEBUG(291, *YYCURSOR);
		yyaccept = 3;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(292, *YYCURSOR);
		if (yych <= '/') {
			if (yych <= 0x1F) {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy239;
					if (yych <= 0x08) goto yy250;
					goto yy239;
				} else {
					if (yych == '\r') goto yy239;
					goto yy250;
				}
			} else {
				if (yych <= '$') {
					if (yych <= '"') goto yy239;
					if (yych <= '#') goto yy250;
					goto yy255;
				} else {
					if (yych <= '%') goto yy250;
					if (yych <= ')') goto yy239;
					goto yy250;
				}
			}
		} else {
			if (yych <= ']') {
				if (yych <= ';') {
					if (yych <= '9') goto yy291;
					if (yych <= ':') goto yy250;
					goto yy239;
				} else {
					if (yych == '=') goto yy239;
					goto yy250;
				}
			} else {
				if (yych <= '|') {
					if (yych <= '^') goto yy239;
					if (yych <= '{') goto yy250;
					goto yy239;
				} else {
					if (yych == '~') goto yy239;
					goto yy250;
				}
			}
		}
yy293:
		YYDEBUG(293, *YYCURSOR);
		yyaccept = 3;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(294, *YYCURSOR);
		if (yych <= '/') {
			if (yych <= 0x1F) {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy239;
					if (yych <= 0x08) goto yy250;
					goto yy239;
				} else {
					if (yych == '\r') goto yy239;
					goto yy250;
				}
			} else {
				if (yych <= '$') {
					if (yych <= '"') goto yy239;
					if (yych <= '#') goto yy250;
					goto yy255;
				} else {
					if (yych <= '%') goto yy250;
					if (yych <= ')') goto yy239;
					goto yy250;
				}
			}
		} else {
			if (yych <= ']') {
				if (yych <= ';') {
					if (yych <= '9') goto yy293;
					if (yych <= ':') goto yy250;
					goto yy239;
				} else {
					if (yych == '=') goto yy239;
					goto yy250;
				}
			} else {
				if (yych <= '|') {
					if (yych <= '^') goto yy239;
					if (yych <= '{') goto yy250;
					goto yy239;
				} else {
					if (yych == '~') goto yy239;
					goto yy250;
				}
			}
		}
yy295:
		YYDEBUG(295, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(296, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy295;
		}
		YYDEBUG(297, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(298, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 416 "Zend/zend_ini_scanner.l"
		{ /* Raw string */
	/* Eat leading and trailing single quotes */
	if (yytext[0] == '\'' && yytext[yyleng - 1] == '\'') {
		SCNG(yy_text)++;
		yyleng = yyleng - 2;
	}
	RETURN_TOKEN(TC_RAW, yytext, yyleng);
}
#line 4547 "Zend/zend_ini_scanner.c"
yy299:
		YYDEBUG(299, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(300, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 449 "Zend/zend_ini_scanner.l"
		{ /* Variable start */
	yy_push_state(ST_VARNAME);
	return TC_DOLLAR_CURLY;
}
#line 4558 "Zend/zend_ini_scanner.c"
yy301:
		YYDEBUG(301, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy302:
		YYDEBUG(302, *YYCURSOR);
		if (yych == '\t') goto yy301;
		if (yych == ' ') goto yy301;
		goto yy231;
yy303:
		YYDEBUG(303, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy228;
yy304:
		YYDEBUG(304, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
yy305:
		YYDEBUG(305, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych <= '\n') {
				if (yych <= 0x08) goto yy226;
				if (yych <= '\t') goto yy304;
				goto yy303;
			} else {
				if (yych == '\r') goto yy307;
				goto yy226;
			}
		} else {
			if (yych <= '"') {
				if (yych <= ' ') goto yy304;
				if (yych <= '!') goto yy226;
			} else {
				if (yych == ';') goto yy282;
				goto yy226;
			}
		}
		YYDEBUG(306, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy233;
yy307:
		YYDEBUG(307, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '\n') goto yy303;
		goto yy228;
	}
/* *********************************** */
yyc_ST_VARNAME:
	{
		static const unsigned char yybm[] = {
			128, 128, 128, 128, 128, 128, 128, 128, 
			128,   0,   0, 128, 128,   0, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128,   0,   0, 128,   0, 128,   0, 128, 
			  0,   0, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0, 128,   0, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0, 128, 128,   0, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(308, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= ')') {
			if (yych <= '"') {
				if (yych <= '\f') {
					if (yych <= 0x08) goto yy310;
					if (yych <= '\n') goto yy312;
				} else {
					if (yych <= '\r') goto yy312;
					if (yych >= '!') goto yy312;
				}
			} else {
				if (yych <= '%') {
					if (yych == '$') goto yy312;
				} else {
					if (yych != '\'') goto yy312;
				}
			}
		} else {
			if (yych <= '[') {
				if (yych <= '<') {
					if (yych == ';') goto yy312;
				} else {
					if (yych <= '=') goto yy312;
					if (yych >= '[') goto yy312;
				}
			} else {
				if (yych <= 'z') {
					if (yych == '^') goto yy312;
				} else {
					if (yych == '}') goto yy314;
					if (yych <= '~') goto yy312;
				}
			}
		}
yy310:
		YYDEBUG(310, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy317;
yy311:
		YYDEBUG(311, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 454 "Zend/zend_ini_scanner.l"
		{ /* Variable name */
	/* Eat leading whitespace */
	EAT_LEADING_WHITESPACE();

	/* Eat trailing whitespace */
	EAT_TRAILING_WHITESPACE();

	RETURN_TOKEN(TC_VARNAME, yytext, yyleng);
}
#line 4699 "Zend/zend_ini_scanner.c"
yy312:
		YYDEBUG(312, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(313, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 648 "Zend/zend_ini_scanner.l"
		{
	return 0;
}
#line 4709 "Zend/zend_ini_scanner.c"
yy314:
		YYDEBUG(314, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(315, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 464 "Zend/zend_ini_scanner.l"
		{ /* Variable end */
	yy_pop_state();
	return '}';
}
#line 4720 "Zend/zend_ini_scanner.c"
yy316:
		YYDEBUG(316, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy317:
		YYDEBUG(317, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy316;
		}
		goto yy311;
	}
}
#line 652 "Zend/zend_ini_scanner.l"

}
