/* Generated by re2c 0.13.5 */
/*
   +----------------------------------------------------------------------+
   | Zend Engine                                                          |
   +----------------------------------------------------------------------+
   | Copyright (c) Zend Technologies Ltd. (http://www.zend.com)           |
   +----------------------------------------------------------------------+
   | This source file is subject to version 2.00 of the Zend license,     |
   | that is bundled with this package in the file LICENSE, and is        |
   | available through the world-wide-web at the following url:           |
   | http://www.zend.com/license/2_00.txt.                                |
   | If you did not receive a copy of the Zend license and are unable to  |
   | obtain it through the world-wide-web, please send a note to          |
   | license@zend.com so we can mail you a copy immediately.              |
   +----------------------------------------------------------------------+
   | Authors: Marcus Boerger <helly@php.net>                              |
   |          Nuno Lopes <nlopess@php.net>                                |
   |          Scott MacVicar <scottmac@php.net>                           |
   | Flex version authors:                                                |
   |          Andi Gutmans <andi@php.net>                                 |
   |          Zeev Suraski <zeev@php.net>                                 |
   +----------------------------------------------------------------------+
*/

#if 0
# define YYDEBUG(s, c) printf("state: %d char: %c\n", s, c)
#else
# define YYDEBUG(s, c)
#endif

#include "zend_language_scanner_defs.h"

#include <errno.h>
#include "zend.h"
#ifdef ZEND_WIN32
# include <Winuser.h>
#endif
#include "zend_alloc.h"
#include <zend_language_parser.h>
#include "zend_compile.h"
#include "zend_language_scanner.h"
#include "zend_highlight.h"
#include "zend_constants.h"
#include "zend_variables.h"
#include "zend_operators.h"
#include "zend_API.h"
#include "zend_strtod.h"
#include "zend_exceptions.h"
#include "zend_virtual_cwd.h"

#define YYCTYPE   unsigned char
#define YYFILL(n) { if ((YYCURSOR + n) >= (YYLIMIT + ZEND_MMAP_AHEAD)) { return 0; } }
#define YYCURSOR  SCNG(yy_cursor)
#define YYLIMIT   SCNG(yy_limit)
#define YYMARKER  SCNG(yy_marker)

#define YYGETCONDITION()  SCNG(yy_state)
#define YYSETCONDITION(s) SCNG(yy_state) = s

#define STATE(name)  yyc##name

/* emulate flex constructs */
#define BEGIN(state) YYSETCONDITION(STATE(state))
#define YYSTATE      YYGETCONDITION()
#define yytext       ((char*)SCNG(yy_text))
#define yyleng       SCNG(yy_leng)
#define yyless(x)    do { YYCURSOR = (unsigned char*)yytext + x; \
                          yyleng   = (unsigned int)x; } while(0)
#define yymore()     goto yymore_restart

/* perform sanity check. If this message is triggered you should
   increase the ZEND_MMAP_AHEAD value in the zend_streams.h file */
#define YYMAXFILL 16
#if ZEND_MMAP_AHEAD < YYMAXFILL
# error ZEND_MMAP_AHEAD should be greater than or equal to YYMAXFILL
#endif

#include <stdarg.h>

#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif

/* Globals Macros */
#define SCNG	LANG_SCNG
#ifdef ZTS
ZEND_API ts_rsrc_id language_scanner_globals_id;
ZEND_API size_t language_scanner_globals_offset;
#else
ZEND_API zend_php_scanner_globals language_scanner_globals;
#endif

#define HANDLE_NEWLINES(s, l)													\
do {																			\
	char *p = (s), *boundary = p+(l);											\
																				\
	while (p<boundary) {														\
		if (*p == '\n' || (*p == '\r' && (*(p+1) != '\n'))) {					\
			CG(zend_lineno)++;													\
		}																		\
		p++;																	\
	}																			\
} while (0)

#define HANDLE_NEWLINE(c) \
{ \
	if (c == '\n' || c == '\r') { \
		CG(zend_lineno)++; \
	} \
}

/* To save initial string length after scanning to first variable */
#define SET_DOUBLE_QUOTES_SCANNED_LENGTH(len) SCNG(scanned_string_len) = (len)
#define GET_DOUBLE_QUOTES_SCANNED_LENGTH()    SCNG(scanned_string_len)

#define IS_LABEL_START(c) (((c) >= 'a' && (c) <= 'z') || ((c) >= 'A' && (c) <= 'Z') || (c) == '_' || (c) >= 0x80)
#define IS_LABEL_SUCCESSOR(c) (((c) >= 'a' && (c) <= 'z') || ((c) >= 'A' && (c) <= 'Z') || ((c) >= '0' && (c) <= '9') || (c) == '_' || (c) >= 0x80)

#define ZEND_IS_OCT(c)  ((c)>='0' && (c)<='7')
#define ZEND_IS_HEX(c)  (((c)>='0' && (c)<='9') || ((c)>='a' && (c)<='f') || ((c)>='A' && (c)<='F'))

BEGIN_EXTERN_C()

static void strip_underscores(char *str, size_t *len)
{
	char *src = str, *dest = str;
	while (*src != '\0') {
		if (*src != '_') {
			*dest = *src;
			dest++;
		} else {
			--(*len);
		}
		src++;
	}
	*dest = '\0';
}

static size_t encoding_filter_script_to_internal(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length)
{
	const zend_encoding *internal_encoding = zend_multibyte_get_internal_encoding();
	ZEND_ASSERT(internal_encoding);
	return zend_multibyte_encoding_converter(to, to_length, from, from_length, internal_encoding, LANG_SCNG(script_encoding));
}

static size_t encoding_filter_script_to_intermediate(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length)
{
	return zend_multibyte_encoding_converter(to, to_length, from, from_length, zend_multibyte_encoding_utf8, LANG_SCNG(script_encoding));
}

static size_t encoding_filter_intermediate_to_script(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length)
{
	return zend_multibyte_encoding_converter(to, to_length, from, from_length,
LANG_SCNG(script_encoding), zend_multibyte_encoding_utf8);
}

static size_t encoding_filter_intermediate_to_internal(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length)
{
	const zend_encoding *internal_encoding = zend_multibyte_get_internal_encoding();
	ZEND_ASSERT(internal_encoding);
	return zend_multibyte_encoding_converter(to, to_length, from, from_length,
internal_encoding, zend_multibyte_encoding_utf8);
}


static void _yy_push_state(int new_state)
{
	zend_stack_push(&SCNG(state_stack), (void *) &YYGETCONDITION());
	YYSETCONDITION(new_state);
}

#define yy_push_state(state_and_tsrm) _yy_push_state(yyc##state_and_tsrm)

static void yy_pop_state(void)
{
	int *stack_state = zend_stack_top(&SCNG(state_stack));
	YYSETCONDITION(*stack_state);
	zend_stack_del_top(&SCNG(state_stack));
}

static void yy_scan_buffer(char *str, unsigned int len)
{
	YYCURSOR       = (YYCTYPE*)str;
	YYLIMIT        = YYCURSOR + len;
	if (!SCNG(yy_start)) {
		SCNG(yy_start) = YYCURSOR;
	}
}

void startup_scanner(void)
{
	CG(parse_error) = 0;
	CG(doc_comment) = NULL;
	CG(extra_fn_flags) = 0;
	zend_stack_init(&SCNG(state_stack), sizeof(int));
	zend_ptr_stack_init(&SCNG(heredoc_label_stack));
	SCNG(heredoc_scan_ahead) = 0;
}

static void heredoc_label_dtor(zend_heredoc_label *heredoc_label) {
    efree(heredoc_label->label);
}

void shutdown_scanner(void)
{
	CG(parse_error) = 0;
	RESET_DOC_COMMENT();
	zend_stack_destroy(&SCNG(state_stack));
	zend_ptr_stack_clean(&SCNG(heredoc_label_stack), (void (*)(void *)) &heredoc_label_dtor, 1);
	zend_ptr_stack_destroy(&SCNG(heredoc_label_stack));
	SCNG(heredoc_scan_ahead) = 0;
	SCNG(on_event) = NULL;
}

ZEND_API void zend_save_lexical_state(zend_lex_state *lex_state)
{
	lex_state->yy_leng   = SCNG(yy_leng);
	lex_state->yy_start  = SCNG(yy_start);
	lex_state->yy_text   = SCNG(yy_text);
	lex_state->yy_cursor = SCNG(yy_cursor);
	lex_state->yy_marker = SCNG(yy_marker);
	lex_state->yy_limit  = SCNG(yy_limit);

	lex_state->state_stack = SCNG(state_stack);
	zend_stack_init(&SCNG(state_stack), sizeof(int));

	lex_state->heredoc_label_stack = SCNG(heredoc_label_stack);
	zend_ptr_stack_init(&SCNG(heredoc_label_stack));

	lex_state->in = SCNG(yy_in);
	lex_state->yy_state = YYSTATE;
	lex_state->filename = zend_get_compiled_filename();
	lex_state->lineno = CG(zend_lineno);

	lex_state->script_org = SCNG(script_org);
	lex_state->script_org_size = SCNG(script_org_size);
	lex_state->script_filtered = SCNG(script_filtered);
	lex_state->script_filtered_size = SCNG(script_filtered_size);
	lex_state->input_filter = SCNG(input_filter);
	lex_state->output_filter = SCNG(output_filter);
	lex_state->script_encoding = SCNG(script_encoding);

	lex_state->on_event = SCNG(on_event);
	lex_state->on_event_context = SCNG(on_event_context);

	lex_state->ast = CG(ast);
	lex_state->ast_arena = CG(ast_arena);
}

ZEND_API void zend_restore_lexical_state(zend_lex_state *lex_state)
{
	SCNG(yy_leng)   = lex_state->yy_leng;
	SCNG(yy_start)  = lex_state->yy_start;
	SCNG(yy_text)   = lex_state->yy_text;
	SCNG(yy_cursor) = lex_state->yy_cursor;
	SCNG(yy_marker) = lex_state->yy_marker;
	SCNG(yy_limit)  = lex_state->yy_limit;

	zend_stack_destroy(&SCNG(state_stack));
	SCNG(state_stack) = lex_state->state_stack;

	zend_ptr_stack_clean(&SCNG(heredoc_label_stack), (void (*)(void *)) &heredoc_label_dtor, 1);
	zend_ptr_stack_destroy(&SCNG(heredoc_label_stack));
	SCNG(heredoc_label_stack) = lex_state->heredoc_label_stack;

	SCNG(yy_in) = lex_state->in;
	YYSETCONDITION(lex_state->yy_state);
	CG(zend_lineno) = lex_state->lineno;
	zend_restore_compiled_filename(lex_state->filename);

	if (SCNG(script_filtered)) {
		efree(SCNG(script_filtered));
		SCNG(script_filtered) = NULL;
	}
	SCNG(script_org) = lex_state->script_org;
	SCNG(script_org_size) = lex_state->script_org_size;
	SCNG(script_filtered) = lex_state->script_filtered;
	SCNG(script_filtered_size) = lex_state->script_filtered_size;
	SCNG(input_filter) = lex_state->input_filter;
	SCNG(output_filter) = lex_state->output_filter;
	SCNG(script_encoding) = lex_state->script_encoding;

	SCNG(on_event) = lex_state->on_event;
	SCNG(on_event_context) = lex_state->on_event_context;

	CG(ast) = lex_state->ast;
	CG(ast_arena) = lex_state->ast_arena;

	RESET_DOC_COMMENT();
}

ZEND_API void zend_destroy_file_handle(zend_file_handle *file_handle)
{
	zend_llist_del_element(&CG(open_files), file_handle, (int (*)(void *, void *)) zend_compare_file_handles);
	/* zend_file_handle_dtor() operates on the copy, so we have to NULLify the original here */
	file_handle->opened_path = NULL;
	if (file_handle->free_filename) {
		file_handle->filename = NULL;
	}
}

ZEND_API void zend_lex_tstring(zval *zv)
{
	if (SCNG(on_event)) {
		SCNG(on_event)(ON_FEEDBACK, T_STRING, 0, SCNG(on_event_context));
	}

	ZVAL_STRINGL(zv, (char*)SCNG(yy_text), SCNG(yy_leng));
}

#define BOM_UTF32_BE	"\x00\x00\xfe\xff"
#define	BOM_UTF32_LE	"\xff\xfe\x00\x00"
#define	BOM_UTF16_BE	"\xfe\xff"
#define	BOM_UTF16_LE	"\xff\xfe"
#define	BOM_UTF8		"\xef\xbb\xbf"

static const zend_encoding *zend_multibyte_detect_utf_encoding(const unsigned char *script, size_t script_size)
{
	const unsigned char *p;
	int wchar_size = 2;
	int le = 0;

	/* utf-16 or utf-32? */
	p = script;
	assert(p >= script);
	while ((size_t)(p-script) < script_size) {
		p = memchr(p, 0, script_size-(p-script)-2);
		if (!p) {
			break;
		}
		if (*(p+1) == '\0' && *(p+2) == '\0') {
			wchar_size = 4;
			break;
		}

		/* searching for UTF-32 specific byte orders, so this will do */
		p += 4;
	}

	/* BE or LE? */
	p = script;
	assert(p >= script);
	while ((size_t)(p-script) < script_size) {
		if (*p == '\0' && *(p+wchar_size-1) != '\0') {
			/* BE */
			le = 0;
			break;
		} else if (*p != '\0' && *(p+wchar_size-1) == '\0') {
			/* LE* */
			le = 1;
			break;
		}
		p += wchar_size;
	}

	if (wchar_size == 2) {
		return le ? zend_multibyte_encoding_utf16le : zend_multibyte_encoding_utf16be;
	} else {
		return le ? zend_multibyte_encoding_utf32le : zend_multibyte_encoding_utf32be;
	}

	return NULL;
}

static const zend_encoding* zend_multibyte_detect_unicode(void)
{
	const zend_encoding *script_encoding = NULL;
	int bom_size;
	unsigned char *pos1, *pos2;

	if (LANG_SCNG(script_org_size) < sizeof(BOM_UTF32_LE)-1) {
		return NULL;
	}

	/* check out BOM */
	if (!memcmp(LANG_SCNG(script_org), BOM_UTF32_BE, sizeof(BOM_UTF32_BE)-1)) {
		script_encoding = zend_multibyte_encoding_utf32be;
		bom_size = sizeof(BOM_UTF32_BE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF32_LE, sizeof(BOM_UTF32_LE)-1)) {
		script_encoding = zend_multibyte_encoding_utf32le;
		bom_size = sizeof(BOM_UTF32_LE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF16_BE, sizeof(BOM_UTF16_BE)-1)) {
		script_encoding = zend_multibyte_encoding_utf16be;
		bom_size = sizeof(BOM_UTF16_BE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF16_LE, sizeof(BOM_UTF16_LE)-1)) {
		script_encoding = zend_multibyte_encoding_utf16le;
		bom_size = sizeof(BOM_UTF16_LE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF8, sizeof(BOM_UTF8)-1)) {
		script_encoding = zend_multibyte_encoding_utf8;
		bom_size = sizeof(BOM_UTF8)-1;
	}

	if (script_encoding) {
		/* remove BOM */
		LANG_SCNG(script_org) += bom_size;
		LANG_SCNG(script_org_size) -= bom_size;

		return script_encoding;
	}

	/* script contains NULL bytes -> auto-detection */
	if ((pos1 = memchr(LANG_SCNG(script_org), 0, LANG_SCNG(script_org_size)))) {
		/* check if the NULL byte is after the __HALT_COMPILER(); */
		pos2 = LANG_SCNG(script_org);

		while ((size_t)(pos1 - pos2) >= sizeof("__HALT_COMPILER();")-1) {
			pos2 = memchr(pos2, '_', pos1 - pos2);
			if (!pos2) break;
			pos2++;
			if (strncasecmp((char*)pos2, "_HALT_COMPILER", sizeof("_HALT_COMPILER")-1) == 0) {
				pos2 += sizeof("_HALT_COMPILER")-1;
				while (*pos2 == ' '  ||
					   *pos2 == '\t' ||
					   *pos2 == '\r' ||
					   *pos2 == '\n') {
					pos2++;
				}
				if (*pos2 == '(') {
					pos2++;
					while (*pos2 == ' '  ||
						   *pos2 == '\t' ||
						   *pos2 == '\r' ||
						   *pos2 == '\n') {
						pos2++;
					}
					if (*pos2 == ')') {
						pos2++;
						while (*pos2 == ' '  ||
							   *pos2 == '\t' ||
							   *pos2 == '\r' ||
							   *pos2 == '\n') {
							pos2++;
						}
						if (*pos2 == ';') {
							return NULL;
						}
					}
				}
			}
		}
		/* make best effort if BOM is missing */
		return zend_multibyte_detect_utf_encoding(LANG_SCNG(script_org), LANG_SCNG(script_org_size));
	}

	return NULL;
}

static const zend_encoding* zend_multibyte_find_script_encoding(void)
{
	const zend_encoding *script_encoding;

	if (CG(detect_unicode)) {
		/* check out bom(byte order mark) and see if containing wchars */
		script_encoding = zend_multibyte_detect_unicode();
		if (script_encoding != NULL) {
			/* bom or wchar detection is prior to 'script_encoding' option */
			return script_encoding;
		}
	}

	/* if no script_encoding specified, just leave alone */
	if (!CG(script_encoding_list) || !CG(script_encoding_list_size)) {
		return NULL;
	}

	/* if multiple encodings specified, detect automagically */
	if (CG(script_encoding_list_size) > 1) {
		return zend_multibyte_encoding_detector(LANG_SCNG(script_org), LANG_SCNG(script_org_size), CG(script_encoding_list), CG(script_encoding_list_size));
	}

	return CG(script_encoding_list)[0];
}

ZEND_API int zend_multibyte_set_filter(const zend_encoding *onetime_encoding)
{
	const zend_encoding *internal_encoding = zend_multibyte_get_internal_encoding();
	const zend_encoding *script_encoding = onetime_encoding ? onetime_encoding: zend_multibyte_find_script_encoding();

	if (!script_encoding) {
		return FAILURE;
	}

	/* judge input/output filter */
	LANG_SCNG(script_encoding) = script_encoding;
	LANG_SCNG(input_filter) = NULL;
	LANG_SCNG(output_filter) = NULL;

	if (!internal_encoding || LANG_SCNG(script_encoding) == internal_encoding) {
		if (!zend_multibyte_check_lexer_compatibility(LANG_SCNG(script_encoding))) {
			/* and if not, work around w/ script_encoding -> utf-8 -> script_encoding conversion */
			LANG_SCNG(input_filter) = encoding_filter_script_to_intermediate;
			LANG_SCNG(output_filter) = encoding_filter_intermediate_to_script;
		} else {
			LANG_SCNG(input_filter) = NULL;
			LANG_SCNG(output_filter) = NULL;
		}
		return SUCCESS;
	}

	if (zend_multibyte_check_lexer_compatibility(internal_encoding)) {
		LANG_SCNG(input_filter) = encoding_filter_script_to_internal;
		LANG_SCNG(output_filter) = NULL;
	} else if (zend_multibyte_check_lexer_compatibility(LANG_SCNG(script_encoding))) {
		LANG_SCNG(input_filter) = NULL;
		LANG_SCNG(output_filter) = encoding_filter_script_to_internal;
	} else {
		/* both script and internal encodings are incompatible w/ flex */
		LANG_SCNG(input_filter) = encoding_filter_script_to_intermediate;
		LANG_SCNG(output_filter) = encoding_filter_intermediate_to_internal;
	}

	return 0;
}

ZEND_API int open_file_for_scanning(zend_file_handle *file_handle)
{
	char *buf;
	size_t size;
	zend_string *compiled_filename;

	if (zend_stream_fixup(file_handle, &buf, &size) == FAILURE) {
		/* Still add it to open_files to make destroy_file_handle work */
		zend_llist_add_element(&CG(open_files), file_handle);
		return FAILURE;
	}

	ZEND_ASSERT(!EG(exception) && "stream_fixup() should have failed");
	zend_llist_add_element(&CG(open_files), file_handle);
	if (file_handle->handle.stream.handle >= (void*)file_handle && file_handle->handle.stream.handle <= (void*)(file_handle+1)) {
		zend_file_handle *fh = (zend_file_handle*)zend_llist_get_last(&CG(open_files));
		size_t diff = (char*)file_handle->handle.stream.handle - (char*)file_handle;
		fh->handle.stream.handle = (void*)(((char*)fh) + diff);
		file_handle->handle.stream.handle = fh->handle.stream.handle;
	}

	/* Reset the scanner for scanning the new file */
	SCNG(yy_in) = file_handle;
	SCNG(yy_start) = NULL;

	if (size != (size_t)-1) {
		if (CG(multibyte)) {
			SCNG(script_org) = (unsigned char*)buf;
			SCNG(script_org_size) = size;
			SCNG(script_filtered) = NULL;

			zend_multibyte_set_filter(NULL);

			if (SCNG(input_filter)) {
				if ((size_t)-1 == SCNG(input_filter)(&SCNG(script_filtered), &SCNG(script_filtered_size), SCNG(script_org), SCNG(script_org_size))) {
					zend_error_noreturn(E_COMPILE_ERROR, "Could not convert the script from the detected "
							"encoding \"%s\" to a compatible encoding", zend_multibyte_get_encoding_name(LANG_SCNG(script_encoding)));
				}
				buf = (char*)SCNG(script_filtered);
				size = SCNG(script_filtered_size);
			}
		}
		SCNG(yy_start) = (unsigned char *)buf;
		yy_scan_buffer(buf, (unsigned int)size);
	} else {
		zend_error_noreturn(E_COMPILE_ERROR, "zend_stream_mmap() failed");
	}

	if (CG(skip_shebang)) {
		CG(skip_shebang) = 0;
		BEGIN(SHEBANG);
	} else {
		BEGIN(INITIAL);
	}

	if (file_handle->opened_path) {
		compiled_filename = zend_string_copy(file_handle->opened_path);
	} else {
		compiled_filename = zend_string_init(file_handle->filename, strlen(file_handle->filename), 0);
	}

	zend_set_compiled_filename(compiled_filename);
	zend_string_release_ex(compiled_filename, 0);

	RESET_DOC_COMMENT();
	CG(zend_lineno) = 1;
	CG(increment_lineno) = 0;
	return SUCCESS;
}
END_EXTERN_C()

static zend_op_array *zend_compile(int type)
{
	zend_op_array *op_array = NULL;
	zend_bool original_in_compilation = CG(in_compilation);

	CG(in_compilation) = 1;
	CG(ast) = NULL;
	CG(ast_arena) = zend_arena_create(1024 * 32);

	if (!zendparse()) {
		int last_lineno = CG(zend_lineno);
		zend_file_context original_file_context;
		zend_oparray_context original_oparray_context;
		zend_op_array *original_active_op_array = CG(active_op_array);

		op_array = emalloc(sizeof(zend_op_array));
		init_op_array(op_array, type, INITIAL_OP_ARRAY_SIZE);
		CG(active_op_array) = op_array;

		/* Use heap to not waste arena memory */
		op_array->fn_flags |= ZEND_ACC_HEAP_RT_CACHE;

		if (zend_ast_process) {
			zend_ast_process(CG(ast));
		}

		zend_file_context_begin(&original_file_context);
		zend_oparray_context_begin(&original_oparray_context);
		zend_compile_top_stmt(CG(ast));
		CG(zend_lineno) = last_lineno;
		zend_emit_final_return(type == ZEND_USER_FUNCTION);
		op_array->line_start = 1;
		op_array->line_end = last_lineno;
		pass_two(op_array);
		zend_oparray_context_end(&original_oparray_context);
		zend_file_context_end(&original_file_context);

		CG(active_op_array) = original_active_op_array;
	}

	zend_ast_destroy(CG(ast));
	zend_arena_destroy(CG(ast_arena));

	CG(in_compilation) = original_in_compilation;

	return op_array;
}

ZEND_API zend_op_array *compile_file(zend_file_handle *file_handle, int type)
{
	zend_lex_state original_lex_state;
	zend_op_array *op_array = NULL;
	zend_save_lexical_state(&original_lex_state);

	if (open_file_for_scanning(file_handle)==FAILURE) {
		if (!EG(exception)) {
			if (type==ZEND_REQUIRE) {
				zend_message_dispatcher(ZMSG_FAILED_REQUIRE_FOPEN, file_handle->filename);
				zend_bailout();
			} else {
				zend_message_dispatcher(ZMSG_FAILED_INCLUDE_FOPEN, file_handle->filename);
			}
		}
	} else {
		op_array = zend_compile(ZEND_USER_FUNCTION);
	}

	zend_restore_lexical_state(&original_lex_state);
	return op_array;
}


zend_op_array *compile_filename(int type, zval *filename)
{
	zend_file_handle file_handle;
	zval tmp;
	zend_op_array *retval;
	zend_string *opened_path = NULL;

	if (Z_TYPE_P(filename) != IS_STRING) {
		ZVAL_STR(&tmp, zval_get_string(filename));
		filename = &tmp;
	}
	zend_stream_init_filename(&file_handle, Z_STRVAL_P(filename));

	retval = zend_compile_file(&file_handle, type);
	if (retval && file_handle.handle.stream.handle) {
		if (!file_handle.opened_path) {
			file_handle.opened_path = opened_path = zend_string_copy(Z_STR_P(filename));
		}

		zend_hash_add_empty_element(&EG(included_files), file_handle.opened_path);

		if (opened_path) {
			zend_string_release_ex(opened_path, 0);
		}
	}
	zend_destroy_file_handle(&file_handle);

	if (UNEXPECTED(filename == &tmp)) {
		zval_ptr_dtor(&tmp);
	}
	return retval;
}

ZEND_API int zend_prepare_string_for_scanning(zval *str, char *filename)
{
	char *buf;
	size_t size, old_len;
	zend_string *new_compiled_filename;

	/* enforce ZEND_MMAP_AHEAD trailing NULLs for flex... */
	old_len = Z_STRLEN_P(str);
	Z_STR_P(str) = zend_string_extend(Z_STR_P(str), old_len + ZEND_MMAP_AHEAD, 0);
	Z_TYPE_INFO_P(str) = IS_STRING_EX;
	memset(Z_STRVAL_P(str) + old_len, 0, ZEND_MMAP_AHEAD + 1);

	SCNG(yy_in) = NULL;
	SCNG(yy_start) = NULL;

	buf = Z_STRVAL_P(str);
	size = old_len;

	if (CG(multibyte)) {
		SCNG(script_org) = (unsigned char*)buf;
		SCNG(script_org_size) = size;
		SCNG(script_filtered) = NULL;

		zend_multibyte_set_filter(zend_multibyte_get_internal_encoding());

		if (SCNG(input_filter)) {
			if ((size_t)-1 == SCNG(input_filter)(&SCNG(script_filtered), &SCNG(script_filtered_size), SCNG(script_org), SCNG(script_org_size))) {
				zend_error_noreturn(E_COMPILE_ERROR, "Could not convert the script from the detected "
						"encoding \"%s\" to a compatible encoding", zend_multibyte_get_encoding_name(LANG_SCNG(script_encoding)));
			}
			buf = (char*)SCNG(script_filtered);
			size = SCNG(script_filtered_size);
		}
	}

	yy_scan_buffer(buf, (unsigned int)size);

	new_compiled_filename = zend_string_init(filename, strlen(filename), 0);
	zend_set_compiled_filename(new_compiled_filename);
	zend_string_release_ex(new_compiled_filename, 0);
	CG(zend_lineno) = 1;
	CG(increment_lineno) = 0;
	RESET_DOC_COMMENT();
	return SUCCESS;
}


ZEND_API size_t zend_get_scanned_file_offset(void)
{
	size_t offset = SCNG(yy_cursor) - SCNG(yy_start);
	if (SCNG(input_filter)) {
		size_t original_offset = offset, length = 0;
		do {
			unsigned char *p = NULL;
			if ((size_t)-1 == SCNG(input_filter)(&p, &length, SCNG(script_org), offset)) {
				return (size_t)-1;
			}
			efree(p);
			if (length > original_offset) {
				offset--;
			} else if (length < original_offset) {
				offset++;
			}
		} while (original_offset != length);
	}
	return offset;
}

zend_op_array *compile_string(zval *source_string, char *filename)
{
	zend_lex_state original_lex_state;
	zend_op_array *op_array = NULL;
	zval tmp;

	if (UNEXPECTED(Z_TYPE_P(source_string) != IS_STRING)) {
		ZVAL_STR(&tmp, zval_get_string_func(source_string));
	} else {
		ZVAL_COPY(&tmp, source_string);
	}

	if (Z_STRLEN(tmp)==0) {
		zval_ptr_dtor(&tmp);
		return NULL;
	}

	zend_save_lexical_state(&original_lex_state);
	if (zend_prepare_string_for_scanning(&tmp, filename) == SUCCESS) {
		BEGIN(ST_IN_SCRIPTING);
		op_array = zend_compile(ZEND_EVAL_CODE);
	}

	zend_restore_lexical_state(&original_lex_state);
	zval_ptr_dtor(&tmp);

	return op_array;
}


BEGIN_EXTERN_C()
int highlight_file(char *filename, zend_syntax_highlighter_ini *syntax_highlighter_ini)
{
	zend_lex_state original_lex_state;
	zend_file_handle file_handle;

	zend_stream_init_filename(&file_handle, filename);
	zend_save_lexical_state(&original_lex_state);
	if (open_file_for_scanning(&file_handle)==FAILURE) {
		zend_message_dispatcher(ZMSG_FAILED_HIGHLIGHT_FOPEN, filename);
		zend_restore_lexical_state(&original_lex_state);
		return FAILURE;
	}
	zend_highlight(syntax_highlighter_ini);
	if (SCNG(script_filtered)) {
		efree(SCNG(script_filtered));
		SCNG(script_filtered) = NULL;
	}
	zend_destroy_file_handle(&file_handle);
	zend_restore_lexical_state(&original_lex_state);
	return SUCCESS;
}

int highlight_string(zval *str, zend_syntax_highlighter_ini *syntax_highlighter_ini, char *str_name)
{
	zend_lex_state original_lex_state;
	zval tmp;

	if (UNEXPECTED(Z_TYPE_P(str) != IS_STRING)) {
		ZVAL_STR(&tmp, zval_get_string_func(str));
		str = &tmp;
	}
	zend_save_lexical_state(&original_lex_state);
	if (zend_prepare_string_for_scanning(str, str_name)==FAILURE) {
		zend_restore_lexical_state(&original_lex_state);
		if (UNEXPECTED(str == &tmp)) {
			zval_ptr_dtor(&tmp);
		}
		return FAILURE;
	}
	BEGIN(INITIAL);
	zend_highlight(syntax_highlighter_ini);
	if (SCNG(script_filtered)) {
		efree(SCNG(script_filtered));
		SCNG(script_filtered) = NULL;
	}
	zend_restore_lexical_state(&original_lex_state);
	if (UNEXPECTED(str == &tmp)) {
		zval_ptr_dtor(&tmp);
	}
	return SUCCESS;
}

ZEND_API void zend_multibyte_yyinput_again(zend_encoding_filter old_input_filter, const zend_encoding *old_encoding)
{
	size_t length;
	unsigned char *new_yy_start;

	/* convert and set */
	if (!SCNG(input_filter)) {
		if (SCNG(script_filtered)) {
			efree(SCNG(script_filtered));
			SCNG(script_filtered) = NULL;
		}
		SCNG(script_filtered_size) = 0;
		length = SCNG(script_org_size);
		new_yy_start = SCNG(script_org);
	} else {
		if ((size_t)-1 == SCNG(input_filter)(&new_yy_start, &length, SCNG(script_org), SCNG(script_org_size))) {
			zend_error_noreturn(E_COMPILE_ERROR, "Could not convert the script from the detected "
					"encoding \"%s\" to a compatible encoding", zend_multibyte_get_encoding_name(LANG_SCNG(script_encoding)));
		}
		if (SCNG(script_filtered)) {
			efree(SCNG(script_filtered));
		}
		SCNG(script_filtered) = new_yy_start;
		SCNG(script_filtered_size) = length;
	}

	SCNG(yy_cursor) = new_yy_start + (SCNG(yy_cursor) - SCNG(yy_start));
	SCNG(yy_marker) = new_yy_start + (SCNG(yy_marker) - SCNG(yy_start));
	SCNG(yy_text) = new_yy_start + (SCNG(yy_text) - SCNG(yy_start));
	SCNG(yy_limit) = new_yy_start + length;

	SCNG(yy_start) = new_yy_start;
}


// TODO: avoid reallocation ???
# define zend_copy_value(zendlval, yytext, yyleng) \
	if (SCNG(output_filter)) { \
		size_t sz = 0; \
		char *s = NULL; \
		SCNG(output_filter)((unsigned char **)&s, &sz, (unsigned char *)yytext, (size_t)yyleng); \
		ZVAL_STRINGL(zendlval, s, sz); \
		efree(s); \
	} else if (yyleng == 1) { \
		ZVAL_INTERNED_STR(zendlval, ZSTR_CHAR((zend_uchar)*(yytext))); \
	} else { \
		ZVAL_STRINGL(zendlval, yytext, yyleng); \
	}

static int zend_scan_escape_string(zval *zendlval, char *str, int len, char quote_type)
{
	register char *s, *t;
	char *end;

	if (len <= 1) {
		if (len < 1) {
			ZVAL_EMPTY_STRING(zendlval);
		} else {
			zend_uchar c = (zend_uchar)*str;
			if (c == '\n' || c == '\r') {
				CG(zend_lineno)++;
			}
			ZVAL_INTERNED_STR(zendlval, ZSTR_CHAR(c));
		}
		goto skip_escape_conversion;
	}

	ZVAL_STRINGL(zendlval, str, len);

	/* convert escape sequences */
	s = Z_STRVAL_P(zendlval);
	end = s+Z_STRLEN_P(zendlval);
	while (1) {
		if (UNEXPECTED(*s=='\\')) {
			break;
		}
		if (*s == '\n' || (*s == '\r' && (*(s+1) != '\n'))) {
			CG(zend_lineno)++;
		}
		s++;
		if (s == end) {
			goto skip_escape_conversion;
		}
	}

	t = s;
	while (s<end) {
		if (*s=='\\') {
			s++;
			if (s >= end) {
				*t++ = '\\';
				break;
			}

			switch(*s) {
				case 'n':
					*t++ = '\n';
					break;
				case 'r':
					*t++ = '\r';
					break;
				case 't':
					*t++ = '\t';
					break;
				case 'f':
					*t++ = '\f';
					break;
				case 'v':
					*t++ = '\v';
					break;
				case 'e':
#ifdef ZEND_WIN32
					*t++ = VK_ESCAPE;
#else
					*t++ = '\e';
#endif
					break;
				case '"':
				case '`':
					if (*s != quote_type) {
						*t++ = '\\';
						*t++ = *s;
						break;
					}
				case '\\':
				case '$':
					*t++ = *s;
					break;
				case 'x':
				case 'X':
					if (ZEND_IS_HEX(*(s+1))) {
						char hex_buf[3] = { 0, 0, 0 };

						hex_buf[0] = *(++s);
						if (ZEND_IS_HEX(*(s+1))) {
							hex_buf[1] = *(++s);
						}
						*t++ = (char) ZEND_STRTOL(hex_buf, NULL, 16);
					} else {
						*t++ = '\\';
						*t++ = *s;
					}
					break;
				/* UTF-8 codepoint escape, format: /\\u\{\x+\}/ */
				case 'u':
					{
						/* cache where we started so we can parse after validating */
						char *start = s + 1;
						size_t len = 0;
						zend_bool valid = 1;
						unsigned long codepoint;

						if (*start != '{') {
							/* we silently let this pass to avoid breaking code
							 * with JSON in string literals (e.g. "\"\u202e\""
							 */
							*t++ = '\\';
							*t++ = 'u';
							break;
						} else {
							/* on the other hand, invalid \u{blah} errors */
							s++;
							len++;
							s++;
							while (*s != '}') {
								if (!ZEND_IS_HEX(*s)) {
									valid = 0;
									break;
								} else {
									len++;
								}
								s++;
							}
							if (*s == '}') {
								valid = 1;
								len++;
							}
						}

						/* \u{} is invalid */
						if (len <= 2) {
							valid = 0;
						}

						if (!valid) {
							zend_throw_exception(zend_ce_parse_error,
								"Invalid UTF-8 codepoint escape sequence", 0);
							zval_ptr_dtor(zendlval);
							ZVAL_UNDEF(zendlval);
							return FAILURE;
						}

						errno = 0;
						codepoint = strtoul(start + 1, NULL, 16);

						/* per RFC 3629, UTF-8 can only represent 21 bits */
						if (codepoint > 0x10FFFF || errno) {
							zend_throw_exception(zend_ce_parse_error,
								"Invalid UTF-8 codepoint escape sequence: Codepoint too large", 0);
							zval_ptr_dtor(zendlval);
							ZVAL_UNDEF(zendlval);
							return FAILURE;
						}

						/* based on https://en.wikipedia.org/wiki/UTF-8#Sample_code */
						if (codepoint < 0x80) {
							*t++ = codepoint;
						} else if (codepoint <= 0x7FF) {
							*t++ = (codepoint >> 6) + 0xC0;
							*t++ = (codepoint & 0x3F) + 0x80;
						} else if (codepoint <= 0xFFFF) {
							*t++ = (codepoint >> 12) + 0xE0;
							*t++ = ((codepoint >> 6) & 0x3F) + 0x80;
							*t++ = (codepoint & 0x3F) + 0x80;
						} else if (codepoint <= 0x10FFFF) {
							*t++ = (codepoint >> 18) + 0xF0;
							*t++ = ((codepoint >> 12) & 0x3F) + 0x80;
							*t++ = ((codepoint >> 6) & 0x3F) + 0x80;
							*t++ = (codepoint & 0x3F) + 0x80;
						}
					}
					break;
				default:
					/* check for an octal */
					if (ZEND_IS_OCT(*s)) {
						char octal_buf[4] = { 0, 0, 0, 0 };

						octal_buf[0] = *s;
						if (ZEND_IS_OCT(*(s+1))) {
							octal_buf[1] = *(++s);
							if (ZEND_IS_OCT(*(s+1))) {
								octal_buf[2] = *(++s);
							}
						}
						if (octal_buf[2] &&
						    (octal_buf[0] > '3')) {
							/* 3 octit values must not overflow 0xFF (\377) */
							zend_error(E_COMPILE_WARNING, "Octal escape sequence overflow \\%s is greater than \\377", octal_buf);
						}

						*t++ = (char) ZEND_STRTOL(octal_buf, NULL, 8);
					} else {
						*t++ = '\\';
						*t++ = *s;
					}
					break;
			}
		} else {
			*t++ = *s;
		}

		if (*s == '\n' || (*s == '\r' && (*(s+1) != '\n'))) {
			CG(zend_lineno)++;
		}
		s++;
	}
	*t = 0;
	Z_STRLEN_P(zendlval) = t - Z_STRVAL_P(zendlval);

skip_escape_conversion:
	if (SCNG(output_filter)) {
		size_t sz = 0;
		unsigned char *str;
		// TODO: avoid realocation ???
		s = Z_STRVAL_P(zendlval);
		SCNG(output_filter)(&str, &sz, (unsigned char *)s, (size_t)Z_STRLEN_P(zendlval));
		zval_ptr_dtor(zendlval);
		ZVAL_STRINGL(zendlval, (char *) str, sz);
		efree(str);
	}
	return SUCCESS;
}

#define HEREDOC_USING_SPACES 1
#define HEREDOC_USING_TABS 2

static const char *next_newline(const char *str, const char *end, size_t *newline_len) {
	for (; str < end; str++) {
		if (*str == '\r') {
			*newline_len = str + 1 < end && *(str + 1) == '\n' ? 2 : 1;
		} else if (*str == '\n') {
			*newline_len = 1;
			return str;
		}
	}
	*newline_len = 0;
	return NULL;
}

static zend_bool strip_multiline_string_indentation(
	zval *zendlval, int indentation, zend_bool using_spaces,
	zend_bool newline_at_start, zend_bool newline_at_end)
{
	const char *str = Z_STRVAL_P(zendlval), *end = str + Z_STRLEN_P(zendlval);
	char *copy = Z_STRVAL_P(zendlval);

	int newline_count = 0;
	size_t newline_len;
	const char *nl;

	if (!newline_at_start) {
		nl = next_newline(str, end, &newline_len);
		if (!nl) {
			return 1;
		}

		str = nl + newline_len;
		copy = (char *) nl + newline_len;
		newline_count++;
	} else {
		nl = str;
	}

	/* <= intentional */
	while (str <= end && nl) {
		size_t skip;
		nl = next_newline(str, end, &newline_len);
		if (!nl && newline_at_end) {
			nl = end;
		}

		/* Try to skip indentation */
		for (skip = 0; skip < indentation; skip++, str++) {
			if (str == nl) {
				/* Don't require full indentation on whitespace-only lines */
				break;
			}

			if (str == end || (*str != ' ' && *str != '\t')) {
				CG(zend_lineno) += newline_count;
				zend_throw_exception_ex(zend_ce_parse_error, 0,
					"Invalid body indentation level (expecting an indentation level of at least %d)", indentation);
				goto error;
			}

			if ((!using_spaces && *str == ' ') || (using_spaces && *str == '\t')) {
				CG(zend_lineno) += newline_count;
				zend_throw_exception(zend_ce_parse_error,
					"Invalid indentation - tabs and spaces cannot be mixed", 0);
				goto error;
			}
		}

		if (str == end) {
			break;
		}

		size_t len = nl ? (nl - str + newline_len) : (end - str);
		memmove(copy, str, len);
		str += len;
		copy += len;
		newline_count++;
	}

	*copy = '\0';
	Z_STRLEN_P(zendlval) = copy - Z_STRVAL_P(zendlval);
	return 1;

error:
	zval_ptr_dtor_str(zendlval);
	ZVAL_UNDEF(zendlval);

	return 0;
}

static void copy_heredoc_label_stack(void *void_heredoc_label)
{
	zend_heredoc_label *heredoc_label = void_heredoc_label;
	zend_heredoc_label *new_heredoc_label = emalloc(sizeof(zend_heredoc_label));

	*new_heredoc_label = *heredoc_label;
	new_heredoc_label->label = estrndup(heredoc_label->label, heredoc_label->length);

	zend_ptr_stack_push(&SCNG(heredoc_label_stack), (void *) new_heredoc_label);
}

#define PARSER_MODE() \
	EXPECTED(elem != NULL)

#define RETURN_TOKEN(_token) do { \
		token = _token; \
		goto emit_token; \
	} while (0)

#define RETURN_TOKEN_WITH_VAL(_token) do { \
		token = _token; \
		goto emit_token_with_val; \
	} while (0)

#define RETURN_TOKEN_WITH_STR(_token, _offset) do { \
		token = _token; \
		offset = _offset; \
		goto emit_token_with_str; \
	} while (0)

#define RETURN_OR_SKIP_TOKEN(_token) do { \
		token = _token; \
		if (PARSER_MODE()) { \
			goto skip_token; \
		} \
		goto emit_token; \
	} while (0)

int ZEND_FASTCALL lex_scan(zval *zendlval, zend_parser_stack_elem *elem)
{
int token;
int offset;
int start_line = CG(zend_lineno);

	ZVAL_UNDEF(zendlval);
restart:
	SCNG(yy_text) = YYCURSOR;


{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	if (YYGETCONDITION() < 5) {
		if (YYGETCONDITION() < 2) {
			if (YYGETCONDITION() < 1) {
				goto yyc_ST_IN_SCRIPTING;
			} else {
				goto yyc_ST_LOOKING_FOR_PROPERTY;
			}
		} else {
			if (YYGETCONDITION() < 3) {
				goto yyc_ST_BACKQUOTE;
			} else {
				if (YYGETCONDITION() < 4) {
					goto yyc_ST_DOUBLE_QUOTES;
				} else {
					goto yyc_ST_HEREDOC;
				}
			}
		}
	} else {
		if (YYGETCONDITION() < 8) {
			if (YYGETCONDITION() < 6) {
				goto yyc_ST_LOOKING_FOR_VARNAME;
			} else {
				if (YYGETCONDITION() < 7) {
					goto yyc_ST_VAR_OFFSET;
				} else {
					goto yyc_SHEBANG;
				}
			}
		} else {
			if (YYGETCONDITION() < 9) {
				goto yyc_INITIAL;
			} else {
				if (YYGETCONDITION() < 10) {
					goto yyc_ST_END_HEREDOC;
				} else {
					goto yyc_ST_NOWDOC;
				}
			}
		}
	}
/* *********************************** */
yyc_INITIAL:

	YYDEBUG(0, *YYCURSOR);
	YYFILL(7);
	yych = *YYCURSOR;
	if (yych != '<') goto yy4;
	YYDEBUG(2, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) == '?') goto yy5;
yy3:
	YYDEBUG(3, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	if (YYCURSOR > YYLIMIT) {
		RETURN_TOKEN(END);
	}

inline_char_handler:

	while (1) {
		YYCTYPE *ptr = memchr(YYCURSOR, '<', YYLIMIT - YYCURSOR);

		YYCURSOR = ptr ? ptr + 1 : YYLIMIT;

		if (YYCURSOR >= YYLIMIT) {
			break;
		}

		if (*YYCURSOR == '?') {
			if (CG(short_tags) /* <? */
				|| (*(YYCURSOR + 1) == '=') /* <?= */
				|| (!strncasecmp((char*)YYCURSOR + 1, "php", 3) && /* <?php[ \t\r\n] */
					(YYCURSOR + 4 == YYLIMIT ||
					YYCURSOR[4] == ' ' || YYCURSOR[4] == '\t' ||
					YYCURSOR[4] == '\n' || YYCURSOR[4] == '\r'))
			) {
				YYCURSOR--;
				break;
			}
		}
	}

	yyleng = YYCURSOR - SCNG(yy_text);

	if (SCNG(output_filter)) {
		size_t readsize;
		char *s = NULL;
		size_t sz = 0;
		// TODO: avoid reallocation ???
		readsize = SCNG(output_filter)((unsigned char **)&s, &sz, (unsigned char *)yytext, (size_t)yyleng);
		ZVAL_STRINGL(zendlval, s, sz);
		efree(s);
		if (readsize < yyleng) {
			yyless(readsize);
		}
	} else if (yyleng == 1) {
		ZVAL_INTERNED_STR(zendlval, ZSTR_CHAR((zend_uchar)*yytext));
	} else {
		ZVAL_STRINGL(zendlval, yytext, yyleng);
	}
	HANDLE_NEWLINES(yytext, yyleng);
	RETURN_TOKEN_WITH_VAL(T_INLINE_HTML);
}
yy4:
	YYDEBUG(4, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy3;
yy5:
	YYDEBUG(5, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'O') {
		if (yych == '=') goto yy7;
	} else {
		if (yych <= 'P') goto yy9;
		if (yych == 'p') goto yy9;
	}
yy6:
	YYDEBUG(6, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	if (CG(short_tags)) {
		BEGIN(ST_IN_SCRIPTING);
		RETURN_OR_SKIP_TOKEN(T_OPEN_TAG);
	} else {
		goto inline_char_handler;
	}
}
yy7:
	YYDEBUG(7, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(8, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	BEGIN(ST_IN_SCRIPTING);
	if (PARSER_MODE()) {
		RETURN_TOKEN(T_ECHO);
	}
	RETURN_TOKEN(T_OPEN_TAG_WITH_ECHO);
}
yy9:
	YYDEBUG(9, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy11;
	if (yych == 'h') goto yy11;
yy10:
	YYDEBUG(10, *YYCURSOR);
	YYCURSOR = YYMARKER;
	goto yy6;
yy11:
	YYDEBUG(11, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy12;
	if (yych != 'p') goto yy10;
yy12:
	YYDEBUG(12, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '\f') {
		if (yych <= 0x08) goto yy13;
		if (yych <= '\n') goto yy14;
	} else {
		if (yych <= '\r') goto yy16;
		if (yych == ' ') goto yy14;
	}
yy13:
	YYDEBUG(13, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	/* Allow <?php followed by end of file. */
	if (YYCURSOR == YYLIMIT) {
		BEGIN(ST_IN_SCRIPTING);
		RETURN_OR_SKIP_TOKEN(T_OPEN_TAG);
	}
	/* Degenerate case: <?phpX is interpreted as <? phpX with short tags. */
	if (CG(short_tags)) {
		yyless(2);
		BEGIN(ST_IN_SCRIPTING);
		RETURN_OR_SKIP_TOKEN(T_OPEN_TAG);
	}
	goto inline_char_handler;
}
yy14:
	YYDEBUG(14, *YYCURSOR);
	++YYCURSOR;
yy15:
	YYDEBUG(15, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	HANDLE_NEWLINE(yytext[yyleng-1]);
	BEGIN(ST_IN_SCRIPTING);
	RETURN_OR_SKIP_TOKEN(T_OPEN_TAG);
}
yy16:
	YYDEBUG(16, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) == '\n') goto yy14;
	goto yy15;
/* *********************************** */
yyc_SHEBANG:
	{
		static const unsigned char yybm[] = {
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,   0,  64,  64, 128,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
		};
		YYDEBUG(17, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych != '#') goto yy21;
		YYDEBUG(19, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '!') goto yy22;
yy20:
		YYDEBUG(20, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(0);
	BEGIN(INITIAL);
	goto restart;
}
yy21:
		YYDEBUG(21, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy20;
yy22:
		YYDEBUG(22, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(23, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy22;
		}
		if (yych <= '\f') goto yy27;
yy24:
		YYDEBUG(24, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(25, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy22;
		}
		if (yych <= '\f') goto yy27;
		goto yy24;
yy26:
		YYDEBUG(26, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	CG(zend_lineno)++;
	BEGIN(INITIAL);
	goto restart;
}
yy27:
		YYDEBUG(27, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy26;
	}
/* *********************************** */
yyc_ST_BACKQUOTE:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(28, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '_') {
			if (yych != '$') goto yy35;
		} else {
			if (yych <= '`') goto yy33;
			if (yych == '{') goto yy32;
			goto yy35;
		}
		YYDEBUG(30, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '_') {
			if (yych <= '@') goto yy31;
			if (yych <= 'Z') goto yy38;
			if (yych >= '_') goto yy38;
		} else {
			if (yych <= 'z') {
				if (yych >= 'a') goto yy38;
			} else {
				if (yych <= '{') goto yy41;
				if (yych >= 0x80) goto yy38;
			}
		}
yy31:
		YYDEBUG(31, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (YYCURSOR > YYLIMIT) {
		RETURN_TOKEN(END);
	}
	if (yytext[0] == '\\' && YYCURSOR < YYLIMIT) {
		YYCURSOR++;
	}

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '`':
				break;
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT) {
					YYCURSOR++;
				}
				/* fall through */
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

	yyleng = YYCURSOR - SCNG(yy_text);

	if (EXPECTED(zend_scan_escape_string(zendlval, yytext, yyleng, '`') == SUCCESS)
	 || !PARSER_MODE()) {
		RETURN_TOKEN_WITH_VAL(T_ENCAPSED_AND_WHITESPACE);
	} else {
		RETURN_TOKEN(T_ERROR);
	}
}
yy32:
		YYDEBUG(32, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '$') goto yy36;
		goto yy31;
yy33:
		YYDEBUG(33, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(34, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	BEGIN(ST_IN_SCRIPTING);
	RETURN_TOKEN('`');
}
yy35:
		YYDEBUG(35, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy31;
yy36:
		YYDEBUG(36, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(37, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_IN_SCRIPTING);
	yyless(1);
	RETURN_TOKEN(T_CURLY_OPEN);
}
yy38:
		YYDEBUG(38, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(39, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy38;
		}
		if (yych == '-') goto yy43;
		if (yych == '[') goto yy45;
yy40:
		YYDEBUG(40, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy41:
		YYDEBUG(41, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(42, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_LOOKING_FOR_VARNAME);
	RETURN_TOKEN(T_DOLLAR_OPEN_CURLY_BRACES);
}
yy43:
		YYDEBUG(43, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy47;
yy44:
		YYDEBUG(44, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy40;
yy45:
		YYDEBUG(45, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(46, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 1);
	yy_push_state(ST_VAR_OFFSET);
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy47:
		YYDEBUG(47, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy44;
			if (yych <= 'Z') goto yy48;
			if (yych <= '^') goto yy44;
		} else {
			if (yych <= '`') goto yy44;
			if (yych <= 'z') goto yy48;
			if (yych <= 0x7F) goto yy44;
		}
yy48:
		YYDEBUG(48, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(49, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 3);
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
	}
/* *********************************** */
yyc_ST_DOUBLE_QUOTES:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(50, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '#') {
			if (yych == '"') goto yy55;
			goto yy57;
		} else {
			if (yych <= '$') goto yy52;
			if (yych == '{') goto yy54;
			goto yy57;
		}
yy52:
		YYDEBUG(52, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '_') {
			if (yych <= '@') goto yy53;
			if (yych <= 'Z') goto yy60;
			if (yych >= '_') goto yy60;
		} else {
			if (yych <= 'z') {
				if (yych >= 'a') goto yy60;
			} else {
				if (yych <= '{') goto yy63;
				if (yych >= 0x80) goto yy60;
			}
		}
yy53:
		YYDEBUG(53, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (GET_DOUBLE_QUOTES_SCANNED_LENGTH()) {
		YYCURSOR += GET_DOUBLE_QUOTES_SCANNED_LENGTH() - 1;
		SET_DOUBLE_QUOTES_SCANNED_LENGTH(0);

		goto double_quotes_scan_done;
	}

	if (YYCURSOR > YYLIMIT) {
		RETURN_TOKEN(END);
	}
	if (yytext[0] == '\\' && YYCURSOR < YYLIMIT) {
		YYCURSOR++;
	}

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '"':
				break;
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT) {
					YYCURSOR++;
				}
				/* fall through */
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

double_quotes_scan_done:
	yyleng = YYCURSOR - SCNG(yy_text);

	if (EXPECTED(zend_scan_escape_string(zendlval, yytext, yyleng, '"') == SUCCESS)
	 || !PARSER_MODE()) {
		RETURN_TOKEN_WITH_VAL(T_ENCAPSED_AND_WHITESPACE);
	} else {
		RETURN_TOKEN(T_ERROR);
	}
}
yy54:
		YYDEBUG(54, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '$') goto yy58;
		goto yy53;
yy55:
		YYDEBUG(55, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(56, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	BEGIN(ST_IN_SCRIPTING);
	RETURN_TOKEN('"');
}
yy57:
		YYDEBUG(57, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy53;
yy58:
		YYDEBUG(58, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(59, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_IN_SCRIPTING);
	yyless(1);
	RETURN_TOKEN(T_CURLY_OPEN);
}
yy60:
		YYDEBUG(60, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(61, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy60;
		}
		if (yych == '-') goto yy65;
		if (yych == '[') goto yy67;
yy62:
		YYDEBUG(62, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy63:
		YYDEBUG(63, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(64, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_LOOKING_FOR_VARNAME);
	RETURN_TOKEN(T_DOLLAR_OPEN_CURLY_BRACES);
}
yy65:
		YYDEBUG(65, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy69;
yy66:
		YYDEBUG(66, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy62;
yy67:
		YYDEBUG(67, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(68, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 1);
	yy_push_state(ST_VAR_OFFSET);
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy69:
		YYDEBUG(69, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy66;
			if (yych <= 'Z') goto yy70;
			if (yych <= '^') goto yy66;
		} else {
			if (yych <= '`') goto yy66;
			if (yych <= 'z') goto yy70;
			if (yych <= 0x7F) goto yy66;
		}
yy70:
		YYDEBUG(70, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(71, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 3);
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
	}
/* *********************************** */
yyc_ST_END_HEREDOC:
	YYDEBUG(72, *YYCURSOR);
	YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(74, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(75, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	zend_heredoc_label *heredoc_label = zend_ptr_stack_pop(&SCNG(heredoc_label_stack));

	yyleng = heredoc_label->indentation + heredoc_label->length;
	YYCURSOR += yyleng - 1;

	heredoc_label_dtor(heredoc_label);
	efree(heredoc_label);

	BEGIN(ST_IN_SCRIPTING);
	RETURN_TOKEN(T_END_HEREDOC);
}
/* *********************************** */
yyc_ST_HEREDOC:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(76, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych == '$') goto yy78;
		if (yych == '{') goto yy80;
		goto yy81;
yy78:
		YYDEBUG(78, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '_') {
			if (yych <= '@') goto yy79;
			if (yych <= 'Z') goto yy84;
			if (yych >= '_') goto yy84;
		} else {
			if (yych <= 'z') {
				if (yych >= 'a') goto yy84;
			} else {
				if (yych <= '{') goto yy87;
				if (yych >= 0x80) goto yy84;
			}
		}
yy79:
		YYDEBUG(79, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	zend_heredoc_label *heredoc_label = zend_ptr_stack_top(&SCNG(heredoc_label_stack));
	int newline = 0, indentation = 0, spacing = 0;

	if (YYCURSOR > YYLIMIT) {
		RETURN_TOKEN(END);
	}

	YYCURSOR--;

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '\r':
				if (*YYCURSOR == '\n') {
					YYCURSOR++;
				}
				/* fall through */
			case '\n':
				indentation = spacing = 0;

				while (YYCURSOR < YYLIMIT && (*YYCURSOR == ' ' || *YYCURSOR == '\t')) {
					if (*YYCURSOR == '\t') {
						spacing |= HEREDOC_USING_TABS;
					} else {
						spacing |= HEREDOC_USING_SPACES;
					}
					++YYCURSOR;
					++indentation;
				}

				if (YYCURSOR == YYLIMIT) {
					yyleng = YYCURSOR - SCNG(yy_text);
					HANDLE_NEWLINES(yytext, yyleng);
					ZVAL_NULL(zendlval);
					RETURN_TOKEN_WITH_VAL(T_ENCAPSED_AND_WHITESPACE);
				}

				/* Check for ending label on the next line */
				if (IS_LABEL_START(*YYCURSOR) && heredoc_label->length < YYLIMIT - YYCURSOR && !memcmp(YYCURSOR, heredoc_label->label, heredoc_label->length)) {
					if (IS_LABEL_SUCCESSOR(YYCURSOR[heredoc_label->length])) {
						continue;
					}

					if (spacing == (HEREDOC_USING_SPACES | HEREDOC_USING_TABS)) {
						zend_throw_exception(zend_ce_parse_error, "Invalid indentation - tabs and spaces cannot be mixed", 0);
						if (PARSER_MODE()) {
							RETURN_TOKEN(T_ERROR);
						}
					}

					/* newline before label will be subtracted from returned text, but
					 * yyleng/yytext will include it, for zend_highlight/strip, tokenizer, etc. */
					if (YYCURSOR[-indentation - 2] == '\r' && YYCURSOR[-indentation - 1] == '\n') {
						newline = 2; /* Windows newline */
					} else {
						newline = 1;
					}

					CG(increment_lineno) = 1; /* For newline before label */

					if (SCNG(heredoc_scan_ahead)) {
						SCNG(heredoc_indentation) = indentation;
						SCNG(heredoc_indentation_uses_spaces) = (spacing == HEREDOC_USING_SPACES);
					} else {
						YYCURSOR -= indentation;
					}

					BEGIN(ST_END_HEREDOC);

					goto heredoc_scan_done;
				}
				continue;
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT && *YYCURSOR != '\n' && *YYCURSOR != '\r') {
					YYCURSOR++;
				}
				/* fall through */
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

heredoc_scan_done:

	yyleng = YYCURSOR - SCNG(yy_text);
	ZVAL_STRINGL(zendlval, yytext, yyleng - newline);

	if (!SCNG(heredoc_scan_ahead) && !EG(exception) && PARSER_MODE()) {
		zend_bool newline_at_start = *(yytext - 1) == '\n' || *(yytext - 1) == '\r';
		zend_string *copy = Z_STR_P(zendlval);

		if (!strip_multiline_string_indentation(
				zendlval, heredoc_label->indentation, heredoc_label->indentation_uses_spaces,
				newline_at_start, newline != 0)) {
			RETURN_TOKEN(T_ERROR);
		}

		if (UNEXPECTED(zend_scan_escape_string(zendlval, ZSTR_VAL(copy), ZSTR_LEN(copy), 0) != SUCCESS)) {
			zend_string_efree(copy);
			RETURN_TOKEN(T_ERROR);
		}

		zend_string_efree(copy);
	} else {
		HANDLE_NEWLINES(yytext, yyleng - newline);
	}

	RETURN_TOKEN_WITH_VAL(T_ENCAPSED_AND_WHITESPACE);
}
yy80:
		YYDEBUG(80, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '$') goto yy82;
		goto yy79;
yy81:
		YYDEBUG(81, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy79;
yy82:
		YYDEBUG(82, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(83, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_IN_SCRIPTING);
	yyless(1);
	RETURN_TOKEN(T_CURLY_OPEN);
}
yy84:
		YYDEBUG(84, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(85, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy84;
		}
		if (yych == '-') goto yy89;
		if (yych == '[') goto yy91;
yy86:
		YYDEBUG(86, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy87:
		YYDEBUG(87, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(88, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_LOOKING_FOR_VARNAME);
	RETURN_TOKEN(T_DOLLAR_OPEN_CURLY_BRACES);
}
yy89:
		YYDEBUG(89, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy93;
yy90:
		YYDEBUG(90, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy86;
yy91:
		YYDEBUG(91, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(92, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 1);
	yy_push_state(ST_VAR_OFFSET);
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy93:
		YYDEBUG(93, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy90;
			if (yych <= 'Z') goto yy94;
			if (yych <= '^') goto yy90;
		} else {
			if (yych <= '`') goto yy90;
			if (yych <= 'z') goto yy94;
			if (yych <= 0x7F) goto yy90;
		}
yy94:
		YYDEBUG(94, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(95, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 3);
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
	}
/* *********************************** */
yyc_ST_IN_SCRIPTING:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0, 192,  64,   0,   0,  64,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			192,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			 60,  60,  44,  44,  44,  44,  44,  44, 
			 44,  44,   0,   0,   0,   0,   0,   0, 
			  0,  36,  36,  36,  36,  36,  36,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   0,   0,   0,   0,   4, 
			  0,  36,  36,  36,  36,  36,  36,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   0,   0,   0,   0,   0, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
		};
		YYDEBUG(96, *YYCURSOR);
		YYFILL(16);
		yych = *YYCURSOR;
		YYDEBUG(-1, yych);
		switch (yych) {
		case 0x00:
		case 0x01:
		case 0x02:
		case 0x03:
		case 0x04:
		case 0x05:
		case 0x06:
		case 0x07:
		case 0x08:
		case '\v':
		case '\f':
		case 0x0E:
		case 0x0F:
		case 0x10:
		case 0x11:
		case 0x12:
		case 0x13:
		case 0x14:
		case 0x15:
		case 0x16:
		case 0x17:
		case 0x18:
		case 0x19:
		case 0x1A:
		case 0x1B:
		case 0x1C:
		case 0x1D:
		case 0x1E:
		case 0x1F:
		case 0x7F:	goto yy159;
		case '\t':
		case '\n':
		case '\r':
		case ' ':	goto yy115;
		case '!':	goto yy130;
		case '"':	goto yy155;
		case '#':	goto yy151;
		case '$':	goto yy141;
		case '%':	goto yy135;
		case '&':	goto yy136;
		case '\'':	goto yy153;
		case '(':	goto yy124;
		case ')':
		case ',':
		case ';':
		case '@':
		case '[':
		case ']':
		case '~':	goto yy142;
		case '*':	goto yy133;
		case '+':	goto yy129;
		case '-':	goto yy113;
		case '.':	goto yy120;
		case '/':	goto yy134;
		case '0':	goto yy147;
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':	goto yy149;
		case ':':	goto yy117;
		case '<':	goto yy131;
		case '=':	goto yy127;
		case '>':	goto yy132;
		case '?':	goto yy121;
		case 'A':
		case 'a':	goto yy108;
		case 'B':
		case 'b':	goto yy110;
		case 'C':
		case 'c':	goto yy102;
		case 'D':
		case 'd':	goto yy100;
		case 'E':
		case 'e':	goto yy98;
		case 'F':
		case 'f':	goto yy101;
		case 'G':
		case 'g':	goto yy111;
		case 'I':
		case 'i':	goto yy106;
		case 'L':
		case 'l':	goto yy128;
		case 'N':
		case 'n':	goto yy122;
		case 'O':
		case 'o':	goto yy139;
		case 'P':
		case 'p':	goto yy112;
		case 'R':
		case 'r':	goto yy103;
		case 'S':
		case 's':	goto yy109;
		case 'T':
		case 't':	goto yy105;
		case 'U':
		case 'u':	goto yy125;
		case 'V':
		case 'v':	goto yy123;
		case 'W':
		case 'w':	goto yy107;
		case 'X':
		case 'x':	goto yy140;
		case 'Y':
		case 'y':	goto yy104;
		case '\\':	goto yy118;
		case '^':	goto yy138;
		case '_':	goto yy126;
		case '`':	goto yy157;
		case '{':	goto yy143;
		case '|':	goto yy137;
		case '}':	goto yy145;
		default:	goto yy150;
		}
yy98:
		YYDEBUG(98, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(-1, yych);
		switch ((yych = *YYCURSOR)) {
		case 'C':
		case 'c':	goto yy744;
		case 'L':
		case 'l':	goto yy745;
		case 'M':
		case 'm':	goto yy746;
		case 'N':
		case 'n':	goto yy747;
		case 'V':
		case 'v':	goto yy748;
		case 'X':
		case 'x':	goto yy749;
		default:	goto yy162;
		}
yy99:
		YYDEBUG(99, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_STR(T_STRING, 0);
}
yy100:
		YYDEBUG(100, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'O') {
			if (yych <= 'H') {
				if (yych == 'E') goto yy726;
				goto yy162;
			} else {
				if (yych <= 'I') goto yy727;
				if (yych <= 'N') goto yy162;
				goto yy728;
			}
		} else {
			if (yych <= 'h') {
				if (yych == 'e') goto yy726;
				goto yy162;
			} else {
				if (yych <= 'i') goto yy727;
				if (yych == 'o') goto yy728;
				goto yy162;
			}
		}
yy101:
		YYDEBUG(101, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'U') {
			if (yych <= 'M') {
				if (yych == 'I') goto yy700;
				goto yy162;
			} else {
				if (yych <= 'N') goto yy701;
				if (yych <= 'O') goto yy703;
				if (yych <= 'T') goto yy162;
				goto yy704;
			}
		} else {
			if (yych <= 'n') {
				if (yych == 'i') goto yy700;
				if (yych <= 'm') goto yy162;
				goto yy701;
			} else {
				if (yych <= 'o') goto yy703;
				if (yych == 'u') goto yy704;
				goto yy162;
			}
		}
yy102:
		YYDEBUG(102, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'O') {
			if (yych <= 'K') {
				if (yych == 'A') goto yy665;
				goto yy162;
			} else {
				if (yych <= 'L') goto yy666;
				if (yych <= 'N') goto yy162;
				goto yy667;
			}
		} else {
			if (yych <= 'k') {
				if (yych == 'a') goto yy665;
				goto yy162;
			} else {
				if (yych <= 'l') goto yy666;
				if (yych == 'o') goto yy667;
				goto yy162;
			}
		}
yy103:
		YYDEBUG(103, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy647;
		if (yych == 'e') goto yy647;
		goto yy162;
yy104:
		YYDEBUG(104, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy634;
		if (yych == 'i') goto yy634;
		goto yy162;
yy105:
		YYDEBUG(105, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'R') {
			if (yych == 'H') goto yy622;
			if (yych <= 'Q') goto yy162;
			goto yy623;
		} else {
			if (yych <= 'h') {
				if (yych <= 'g') goto yy162;
				goto yy622;
			} else {
				if (yych == 'r') goto yy623;
				goto yy162;
			}
		}
yy106:
		YYDEBUG(106, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'S') {
			if (yych <= 'L') {
				if (yych == 'F') goto yy569;
				goto yy162;
			} else {
				if (yych <= 'M') goto yy571;
				if (yych <= 'N') goto yy572;
				if (yych <= 'R') goto yy162;
				goto yy573;
			}
		} else {
			if (yych <= 'm') {
				if (yych == 'f') goto yy569;
				if (yych <= 'l') goto yy162;
				goto yy571;
			} else {
				if (yych <= 'n') goto yy572;
				if (yych == 's') goto yy573;
				goto yy162;
			}
		}
yy107:
		YYDEBUG(107, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy564;
		if (yych == 'h') goto yy564;
		goto yy162;
yy108:
		YYDEBUG(108, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'S') {
			if (yych <= 'M') {
				if (yych == 'B') goto yy546;
				goto yy162;
			} else {
				if (yych <= 'N') goto yy547;
				if (yych <= 'Q') goto yy162;
				if (yych <= 'R') goto yy548;
				goto yy549;
			}
		} else {
			if (yych <= 'n') {
				if (yych == 'b') goto yy546;
				if (yych <= 'm') goto yy162;
				goto yy547;
			} else {
				if (yych <= 'q') goto yy162;
				if (yych <= 'r') goto yy548;
				if (yych <= 's') goto yy549;
				goto yy162;
			}
		}
yy109:
		YYDEBUG(109, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'W') {
			if (yych == 'T') goto yy534;
			if (yych <= 'V') goto yy162;
			goto yy535;
		} else {
			if (yych <= 't') {
				if (yych <= 's') goto yy162;
				goto yy534;
			} else {
				if (yych == 'w') goto yy535;
				goto yy162;
			}
		}
yy110:
		YYDEBUG(110, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= ';') {
			if (yych <= '"') {
				if (yych <= '!') goto yy162;
				goto yy526;
			} else {
				if (yych == '\'') goto yy527;
				goto yy162;
			}
		} else {
			if (yych <= 'R') {
				if (yych <= '<') goto yy525;
				if (yych <= 'Q') goto yy162;
				goto yy528;
			} else {
				if (yych == 'r') goto yy528;
				goto yy162;
			}
		}
yy111:
		YYDEBUG(111, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'O') {
			if (yych == 'L') goto yy515;
			if (yych <= 'N') goto yy162;
			goto yy516;
		} else {
			if (yych <= 'l') {
				if (yych <= 'k') goto yy162;
				goto yy515;
			} else {
				if (yych == 'o') goto yy516;
				goto yy162;
			}
		}
yy112:
		YYDEBUG(112, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'U') {
			if (yych == 'R') goto yy491;
			if (yych <= 'T') goto yy162;
			goto yy492;
		} else {
			if (yych <= 'r') {
				if (yych <= 'q') goto yy162;
				goto yy491;
			} else {
				if (yych == 'u') goto yy492;
				goto yy162;
			}
		}
yy113:
		YYDEBUG(113, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '<') {
			if (yych == '-') goto yy487;
		} else {
			if (yych <= '=') goto yy485;
			if (yych <= '>') goto yy489;
		}
yy114:
		YYDEBUG(114, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(yytext[0]);
}
yy115:
		YYDEBUG(115, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy484;
yy116:
		YYDEBUG(116, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	goto return_whitespace;
}
yy117:
		YYDEBUG(117, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == ':') goto yy481;
		goto yy114;
yy118:
		YYDEBUG(118, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(119, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_NS_SEPARATOR);
}
yy120:
		YYDEBUG(120, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '/') {
			if (yych == '.') goto yy475;
			goto yy114;
		} else {
			if (yych <= '9') goto yy471;
			if (yych == '=') goto yy473;
			goto yy114;
		}
yy121:
		YYDEBUG(121, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '=') goto yy114;
		if (yych <= '>') goto yy463;
		if (yych <= '?') goto yy465;
		goto yy114;
yy122:
		YYDEBUG(122, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'E') {
			if (yych == 'A') goto yy451;
			if (yych <= 'D') goto yy162;
			goto yy452;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy162;
				goto yy451;
			} else {
				if (yych == 'e') goto yy452;
				goto yy162;
			}
		}
yy123:
		YYDEBUG(123, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy448;
		if (yych == 'a') goto yy448;
		goto yy162;
yy124:
		YYDEBUG(124, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'S') {
			if (yych <= 'D') {
				if (yych <= ' ') {
					if (yych == '\t') goto yy369;
					if (yych <= 0x1F) goto yy114;
					goto yy369;
				} else {
					if (yych <= '@') goto yy114;
					if (yych == 'C') goto yy114;
					goto yy369;
				}
			} else {
				if (yych <= 'I') {
					if (yych == 'F') goto yy369;
					if (yych <= 'H') goto yy114;
					goto yy369;
				} else {
					if (yych == 'O') goto yy369;
					if (yych <= 'Q') goto yy114;
					goto yy369;
				}
			}
		} else {
			if (yych <= 'f') {
				if (yych <= 'b') {
					if (yych == 'U') goto yy369;
					if (yych <= '`') goto yy114;
					goto yy369;
				} else {
					if (yych == 'd') goto yy369;
					if (yych <= 'e') goto yy114;
					goto yy369;
				}
			} else {
				if (yych <= 'o') {
					if (yych == 'i') goto yy369;
					if (yych <= 'n') goto yy114;
					goto yy369;
				} else {
					if (yych <= 's') {
						if (yych <= 'q') goto yy114;
						goto yy369;
					} else {
						if (yych == 'u') goto yy369;
						goto yy114;
					}
				}
			}
		}
yy125:
		YYDEBUG(125, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'S') {
			if (yych == 'N') goto yy360;
			if (yych <= 'R') goto yy162;
			goto yy361;
		} else {
			if (yych <= 'n') {
				if (yych <= 'm') goto yy162;
				goto yy360;
			} else {
				if (yych == 's') goto yy361;
				goto yy162;
			}
		}
yy126:
		YYDEBUG(126, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy278;
		goto yy162;
yy127:
		YYDEBUG(127, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '<') goto yy114;
		if (yych <= '=') goto yy272;
		if (yych <= '>') goto yy274;
		goto yy114;
yy128:
		YYDEBUG(128, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy268;
		if (yych == 'i') goto yy268;
		goto yy162;
yy129:
		YYDEBUG(129, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '+') goto yy266;
		if (yych == '=') goto yy264;
		goto yy114;
yy130:
		YYDEBUG(130, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy261;
		goto yy114;
yy131:
		YYDEBUG(131, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= ';') goto yy114;
		if (yych <= '<') goto yy237;
		if (yych <= '=') goto yy239;
		if (yych <= '>') goto yy241;
		goto yy114;
yy132:
		YYDEBUG(132, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '<') goto yy114;
		if (yych <= '=') goto yy233;
		if (yych <= '>') goto yy231;
		goto yy114;
yy133:
		YYDEBUG(133, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '*') goto yy225;
		if (yych == '=') goto yy227;
		goto yy114;
yy134:
		YYDEBUG(134, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '.') {
			if (yych == '*') goto yy217;
			goto yy114;
		} else {
			if (yych <= '/') goto yy219;
			if (yych == '=') goto yy220;
			goto yy114;
		}
yy135:
		YYDEBUG(135, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy215;
		goto yy114;
yy136:
		YYDEBUG(136, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '&') goto yy211;
		if (yych == '=') goto yy213;
		goto yy114;
yy137:
		YYDEBUG(137, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy209;
		if (yych == '|') goto yy207;
		goto yy114;
yy138:
		YYDEBUG(138, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy205;
		goto yy114;
yy139:
		YYDEBUG(139, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy203;
		if (yych == 'r') goto yy203;
		goto yy162;
yy140:
		YYDEBUG(140, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy200;
		if (yych == 'o') goto yy200;
		goto yy162;
yy141:
		YYDEBUG(141, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy114;
			if (yych <= 'Z') goto yy197;
			if (yych <= '^') goto yy114;
			goto yy197;
		} else {
			if (yych <= '`') goto yy114;
			if (yych <= 'z') goto yy197;
			if (yych <= 0x7F) goto yy114;
			goto yy197;
		}
yy142:
		YYDEBUG(142, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy114;
yy143:
		YYDEBUG(143, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(144, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_IN_SCRIPTING);
	RETURN_TOKEN('{');
}
yy145:
		YYDEBUG(145, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(146, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RESET_DOC_COMMENT();
	if (!zend_stack_is_empty(&SCNG(state_stack))) {
		yy_pop_state();
	}
	RETURN_TOKEN('}');
}
yy147:
		YYDEBUG(147, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'X') {
			if (yych == 'B') goto yy184;
			if (yych <= 'W') goto yy168;
			goto yy183;
		} else {
			if (yych <= 'b') {
				if (yych <= 'a') goto yy168;
				goto yy184;
			} else {
				if (yych == 'x') goto yy183;
				goto yy168;
			}
		}
yy148:
		YYDEBUG(148, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	size_t len = yyleng;
	char *end, *lnum = yytext;
	zend_bool is_octal = lnum[0] == '0';
	zend_bool contains_underscores = (memchr(lnum, '_', len) != NULL);

	if (contains_underscores) {
		lnum = estrndup(lnum, len);
		strip_underscores(lnum, &len);
	}

	/* Digits 8 and 9 are illegal in octal literals. */
	if (is_octal) {
		size_t i;
		for (i = 0; i < len; i++) {
			if (lnum[i] == '8' || lnum[i] == '9') {
				zend_throw_exception(zend_ce_parse_error, "Invalid numeric literal", 0);
				if (PARSER_MODE()) {
					if (contains_underscores) {
						efree(lnum);
					}
					ZVAL_UNDEF(zendlval);
					RETURN_TOKEN(T_ERROR);
				}

				/* Continue in order to determine if this is T_LNUMBER or T_DNUMBER. */
				len = i;
				break;
			}
		}
	}


	if (len < MAX_LENGTH_OF_LONG - 1) { /* Won't overflow */
		errno = 0;
		/* base must be passed explicitly for correct parse error on Windows */
		ZVAL_LONG(zendlval, ZEND_STRTOL(lnum, &end, is_octal ? 8 : 10));
		ZEND_ASSERT(end == lnum + len);
	} else {
		errno = 0;
		ZVAL_LONG(zendlval, ZEND_STRTOL(lnum, &end, 0));
		if (errno == ERANGE) { /* Overflow */
			errno = 0;
			if (is_octal) { /* octal overflow */
				ZVAL_DOUBLE(zendlval, zend_oct_strtod(lnum, (const char **)&end));
			} else {
				ZVAL_DOUBLE(zendlval, zend_strtod(lnum, (const char **)&end));
			}
			ZEND_ASSERT(end == lnum + len);
			if (contains_underscores) {
				efree(lnum);
			}
			RETURN_TOKEN_WITH_VAL(T_DNUMBER);
		}
		ZEND_ASSERT(end == lnum + len);
	}
	ZEND_ASSERT(!errno);
	if (contains_underscores) {
		efree(lnum);
	}
	RETURN_TOKEN_WITH_VAL(T_LNUMBER);
}
yy149:
		YYDEBUG(149, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		goto yy168;
yy150:
		YYDEBUG(150, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy162;
yy151:
		YYDEBUG(151, *YYCURSOR);
		++YYCURSOR;
yy152:
		YYDEBUG(152, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '\r':
				if (*YYCURSOR == '\n') {
					YYCURSOR++;
				}
				/* fall through */
			case '\n':
				CG(zend_lineno)++;
				break;
			case '?':
				if (*YYCURSOR == '>') {
					YYCURSOR--;
					break;
				}
				/* fall through */
			default:
				continue;
		}

		break;
	}

	yyleng = YYCURSOR - SCNG(yy_text);
	RETURN_OR_SKIP_TOKEN(T_COMMENT);
}
yy153:
		YYDEBUG(153, *YYCURSOR);
		++YYCURSOR;
yy154:
		YYDEBUG(154, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	register char *s, *t;
	char *end;
	int bprefix = (yytext[0] != '\'') ? 1 : 0;

	while (1) {
		if (YYCURSOR < YYLIMIT) {
			if (*YYCURSOR == '\'') {
				YYCURSOR++;
				yyleng = YYCURSOR - SCNG(yy_text);

				break;
			} else if (*YYCURSOR++ == '\\' && YYCURSOR < YYLIMIT) {
				YYCURSOR++;
			}
		} else {
			yyleng = YYLIMIT - SCNG(yy_text);

			/* Unclosed single quotes; treat similar to double quotes, but without a separate token
			 * for ' (unrecognized by parser), instead of old flex fallback to "Unexpected character..."
			 * rule, which continued in ST_IN_SCRIPTING state after the quote */
			ZVAL_NULL(zendlval);
			RETURN_TOKEN_WITH_VAL(T_ENCAPSED_AND_WHITESPACE);
		}
	}

	if (yyleng-bprefix-2 <= 1) {
		if (yyleng-bprefix-2 < 1) {
			ZVAL_EMPTY_STRING(zendlval);
		} else {
			zend_uchar c = (zend_uchar)*(yytext+bprefix+1);
			if (c == '\n' || c == '\r') {
				CG(zend_lineno)++;
			}
			ZVAL_INTERNED_STR(zendlval, ZSTR_CHAR(c));
		}
		goto skip_escape_conversion;
	}
	ZVAL_STRINGL(zendlval, yytext+bprefix+1, yyleng-bprefix-2);

	/* convert escape sequences */
	s = Z_STRVAL_P(zendlval);
	end = s+Z_STRLEN_P(zendlval);
	while (1) {
		if (UNEXPECTED(*s=='\\')) {
			break;
		}
		if (*s == '\n' || (*s == '\r' && (*(s+1) != '\n'))) {
			CG(zend_lineno)++;
		}
		s++;
		if (s == end) {
			goto skip_escape_conversion;
		}
	}

	t = s;
	while (s<end) {
		if (*s=='\\') {
			s++;
			if (*s == '\\' || *s == '\'') {
				*t++ = *s;
			} else {
				*t++ = '\\';
				*t++ = *s;
			}
		} else {
			*t++ = *s;
		}
		if (*s == '\n' || (*s == '\r' && (*(s+1) != '\n'))) {
			CG(zend_lineno)++;
		}
		s++;
	}
	*t = 0;
	Z_STRLEN_P(zendlval) = t - Z_STRVAL_P(zendlval);

skip_escape_conversion:
	if (SCNG(output_filter)) {
		size_t sz = 0;
		char *str = NULL;
		zend_string *new_str;
		s = Z_STRVAL_P(zendlval);
		// TODO: avoid reallocation ???
		SCNG(output_filter)((unsigned char **)&str, &sz, (unsigned char *)s, (size_t)Z_STRLEN_P(zendlval));
		new_str = zend_string_init(str, sz, 0);
		if (str != s) {
			efree(str);
		}
		zend_string_release_ex(Z_STR_P(zendlval), 0);
		ZVAL_STR(zendlval, new_str);
	}
	RETURN_TOKEN_WITH_VAL(T_CONSTANT_ENCAPSED_STRING);
}
yy155:
		YYDEBUG(155, *YYCURSOR);
		++YYCURSOR;
yy156:
		YYDEBUG(156, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	int bprefix = (yytext[0] != '"') ? 1 : 0;

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '"':
				yyleng = YYCURSOR - SCNG(yy_text);
				if (EXPECTED(zend_scan_escape_string(zendlval, yytext+bprefix+1, yyleng-bprefix-2, '"') == SUCCESS)
				 || !PARSER_MODE()) {
					RETURN_TOKEN_WITH_VAL(T_CONSTANT_ENCAPSED_STRING);
				} else {
					RETURN_TOKEN(T_ERROR);
				}
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT) {
					YYCURSOR++;
				}
				/* fall through */
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

	/* Remember how much was scanned to save rescanning */
	SET_DOUBLE_QUOTES_SCANNED_LENGTH(YYCURSOR - SCNG(yy_text) - yyleng);

	YYCURSOR = SCNG(yy_text) + yyleng;

	BEGIN(ST_DOUBLE_QUOTES);
	RETURN_TOKEN('"');
}
yy157:
		YYDEBUG(157, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(158, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	BEGIN(ST_BACKQUOTE);
	RETURN_TOKEN('`');
}
yy159:
		YYDEBUG(159, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(160, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (YYCURSOR > YYLIMIT) {
		RETURN_TOKEN(END);
	}

	if (!SCNG(heredoc_scan_ahead)) {
		zend_error(E_COMPILE_WARNING, "Unexpected character in input:  '%c' (ASCII=%d) state=%d", yytext[0], yytext[0], YYSTATE);
	}
	if (PARSER_MODE()) {
		goto restart;
	} else {
		RETURN_TOKEN(T_BAD_CHARACTER);
	}
}
yy161:
		YYDEBUG(161, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy162:
		YYDEBUG(162, *YYCURSOR);
		if (yybm[0+yych] & 4) {
			goto yy161;
		}
		goto yy99;
yy163:
		YYDEBUG(163, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '/') goto yy164;
		if (yych <= '9') goto yy181;
yy164:
		YYDEBUG(164, *YYCURSOR);
		YYCURSOR = YYMARKER;
		if (yyaccept <= 4) {
			if (yyaccept <= 2) {
				if (yyaccept <= 1) {
					if (yyaccept <= 0) {
						goto yy99;
					} else {
						goto yy114;
					}
				} else {
					goto yy148;
				}
			} else {
				if (yyaccept <= 3) {
					goto yy166;
				} else {
					goto yy187;
				}
			}
		} else {
			if (yyaccept <= 6) {
				if (yyaccept <= 5) {
					goto yy193;
				} else {
					goto yy218;
				}
			} else {
				if (yyaccept <= 7) {
					goto yy238;
				} else {
					goto yy638;
				}
			}
		}
yy165:
		YYDEBUG(165, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych != '_') goto yy177;
yy166:
		YYDEBUG(166, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	const char *end;
	size_t len = yyleng;
	char *dnum = yytext;
	zend_bool contains_underscores = (memchr(dnum, '_', len) != NULL);

	if (contains_underscores) {
		dnum = estrndup(dnum, len);
		strip_underscores(dnum, &len);
	}

	ZVAL_DOUBLE(zendlval, zend_strtod(dnum, &end));
	/* errno isn't checked since we allow HUGE_VAL/INF overflow */
	ZEND_ASSERT(end == dnum + len);
	if (contains_underscores) {
		efree(dnum);
	}
	RETURN_TOKEN_WITH_VAL(T_DNUMBER);
}
yy167:
		YYDEBUG(167, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(4);
		yych = *YYCURSOR;
yy168:
		YYDEBUG(168, *YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy167;
		}
		if (yych <= 'E') {
			if (yych == '.') goto yy165;
			if (yych <= 'D') goto yy148;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy148;
				goto yy163;
			} else {
				if (yych != 'e') goto yy148;
			}
		}
yy169:
		YYDEBUG(169, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= ',') {
			if (yych != '+') goto yy164;
		} else {
			if (yych <= '-') goto yy170;
			if (yych <= '/') goto yy164;
			if (yych <= '9') goto yy171;
			goto yy164;
		}
yy170:
		YYDEBUG(170, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '/') goto yy164;
		if (yych >= ':') goto yy164;
yy171:
		YYDEBUG(171, *YYCURSOR);
		yyaccept = 3;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(172, *YYCURSOR);
		if (yych <= '/') goto yy166;
		if (yych <= '9') goto yy171;
		if (yych != '_') goto yy166;
yy173:
		YYDEBUG(173, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '/') goto yy164;
		if (yych >= ':') goto yy164;
yy174:
		YYDEBUG(174, *YYCURSOR);
		yyaccept = 3;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(175, *YYCURSOR);
		if (yych <= '/') goto yy166;
		if (yych <= '9') goto yy174;
		if (yych == '_') goto yy173;
		goto yy166;
yy176:
		YYDEBUG(176, *YYCURSOR);
		yyaccept = 3;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
yy177:
		YYDEBUG(177, *YYCURSOR);
		if (yych <= 'E') {
			if (yych <= '/') goto yy166;
			if (yych <= '9') goto yy176;
			if (yych <= 'D') goto yy166;
			goto yy169;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy166;
			} else {
				if (yych == 'e') goto yy169;
				goto yy166;
			}
		}
yy178:
		YYDEBUG(178, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '/') goto yy164;
		if (yych >= ':') goto yy164;
yy179:
		YYDEBUG(179, *YYCURSOR);
		yyaccept = 3;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(180, *YYCURSOR);
		if (yych <= 'E') {
			if (yych <= '/') goto yy166;
			if (yych <= '9') goto yy179;
			if (yych <= 'D') goto yy166;
			goto yy169;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy166;
				goto yy178;
			} else {
				if (yych == 'e') goto yy169;
				goto yy166;
			}
		}
yy181:
		YYDEBUG(181, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(4);
		yych = *YYCURSOR;
		YYDEBUG(182, *YYCURSOR);
		if (yych <= 'D') {
			if (yych <= '.') {
				if (yych <= '-') goto yy148;
				goto yy165;
			} else {
				if (yych <= '/') goto yy148;
				if (yych <= '9') goto yy181;
				goto yy148;
			}
		} else {
			if (yych <= '_') {
				if (yych <= 'E') goto yy169;
				if (yych <= '^') goto yy148;
				goto yy163;
			} else {
				if (yych == 'e') goto yy169;
				goto yy148;
			}
		}
yy183:
		YYDEBUG(183, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 32) {
			goto yy191;
		}
		goto yy164;
yy184:
		YYDEBUG(184, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy185;
		}
		goto yy164;
yy185:
		YYDEBUG(185, *YYCURSOR);
		yyaccept = 4;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(186, *YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy185;
		}
		if (yych == '_') goto yy188;
yy187:
		YYDEBUG(187, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	/* The +/- 2 skips "0b" */
	size_t len = yyleng - 2;
	char *end, *bin = yytext + 2;
	zend_bool contains_underscores;

	/* Skip any leading 0s */
	while (len > 0 && (*bin == '0' || *bin == '_')) {
		++bin;
		--len;
	}

	contains_underscores = (memchr(bin, '_', len) != NULL);

	if (contains_underscores) {
		bin = estrndup(bin, len);
		strip_underscores(bin, &len);
	}

	if (len < SIZEOF_ZEND_LONG * 8) {
		if (len == 0) {
			ZVAL_LONG(zendlval, 0);
		} else {
			errno = 0;
			ZVAL_LONG(zendlval, ZEND_STRTOL(bin, &end, 2));
			ZEND_ASSERT(!errno && end == bin + len);
		}
		if (contains_underscores) {
			efree(bin);
		}
		RETURN_TOKEN_WITH_VAL(T_LNUMBER);
	} else {
		ZVAL_DOUBLE(zendlval, zend_bin_strtod(bin, (const char **)&end));
		/* errno isn't checked since we allow HUGE_VAL/INF overflow */
		ZEND_ASSERT(end == bin + len);
		if (contains_underscores) {
			efree(bin);
		}
		RETURN_TOKEN_WITH_VAL(T_DNUMBER);
	}
}
yy188:
		YYDEBUG(188, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '/') goto yy164;
		if (yych >= '2') goto yy164;
yy189:
		YYDEBUG(189, *YYCURSOR);
		yyaccept = 4;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(190, *YYCURSOR);
		if (yych <= '/') goto yy187;
		if (yych <= '1') goto yy189;
		if (yych == '_') goto yy188;
		goto yy187;
yy191:
		YYDEBUG(191, *YYCURSOR);
		yyaccept = 5;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(192, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy191;
		}
		if (yych == '_') goto yy194;
yy193:
		YYDEBUG(193, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	/* The +/- 2 skips "0x" */
	size_t len = yyleng - 2;
	char *end, *hex = yytext + 2;
	zend_bool contains_underscores;

	/* Skip any leading 0s */
	while (len > 0 && (*hex == '0' || *hex == '_')) {
		++hex;
		--len;
	}

	contains_underscores = (memchr(hex, '_', len) != NULL);

	if (contains_underscores) {
		hex = estrndup(hex, len);
		strip_underscores(hex, &len);
	}

	if (len < SIZEOF_ZEND_LONG * 2 || (len == SIZEOF_ZEND_LONG * 2 && *hex <= '7')) {
		if (len == 0) {
			ZVAL_LONG(zendlval, 0);
		} else {
			errno = 0;
			ZVAL_LONG(zendlval, ZEND_STRTOL(hex, &end, 16));
			ZEND_ASSERT(!errno && end == hex + len);
		}
		if (contains_underscores) {
			efree(hex);
		}
		RETURN_TOKEN_WITH_VAL(T_LNUMBER);
	} else {
		ZVAL_DOUBLE(zendlval, zend_hex_strtod(hex, (const char **)&end));
		/* errno isn't checked since we allow HUGE_VAL/INF overflow */
		ZEND_ASSERT(end == hex + len);
		if (contains_underscores) {
			efree(hex);
		}
		RETURN_TOKEN_WITH_VAL(T_DNUMBER);
	}
}
yy194:
		YYDEBUG(194, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy164;
			if (yych >= ':') goto yy164;
		} else {
			if (yych <= 'F') goto yy195;
			if (yych <= '`') goto yy164;
			if (yych >= 'g') goto yy164;
		}
yy195:
		YYDEBUG(195, *YYCURSOR);
		yyaccept = 5;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(196, *YYCURSOR);
		if (yych <= 'F') {
			if (yych <= '/') goto yy193;
			if (yych <= '9') goto yy195;
			if (yych <= '@') goto yy193;
			goto yy195;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy193;
				goto yy194;
			} else {
				if (yych <= '`') goto yy193;
				if (yych <= 'f') goto yy195;
				goto yy193;
			}
		}
yy197:
		YYDEBUG(197, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(198, *YYCURSOR);
		if (yych <= '^') {
			if (yych <= '9') {
				if (yych >= '0') goto yy197;
			} else {
				if (yych <= '@') goto yy199;
				if (yych <= 'Z') goto yy197;
			}
		} else {
			if (yych <= '`') {
				if (yych <= '_') goto yy197;
			} else {
				if (yych <= 'z') goto yy197;
				if (yych >= 0x80) goto yy197;
			}
		}
yy199:
		YYDEBUG(199, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy200:
		YYDEBUG(200, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy201;
		if (yych != 'r') goto yy162;
yy201:
		YYDEBUG(201, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy161;
		}
		YYDEBUG(202, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_LOGICAL_XOR);
}
yy203:
		YYDEBUG(203, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy161;
		}
		YYDEBUG(204, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_LOGICAL_OR);
}
yy205:
		YYDEBUG(205, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(206, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_XOR_EQUAL);
}
yy207:
		YYDEBUG(207, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(208, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_BOOLEAN_OR);
}
yy209:
		YYDEBUG(209, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(210, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_OR_EQUAL);
}
yy211:
		YYDEBUG(211, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(212, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_BOOLEAN_AND);
}
yy213:
		YYDEBUG(213, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(214, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_AND_EQUAL);
}
yy215:
		YYDEBUG(215, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(216, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_MOD_EQUAL);
}
yy217:
		YYDEBUG(217, *YYCURSOR);
		yyaccept = 6;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '*') goto yy222;
yy218:
		YYDEBUG(218, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	int doc_com;

	if (yyleng > 2) {
		doc_com = 1;
		RESET_DOC_COMMENT();
	} else {
		doc_com = 0;
	}

	while (YYCURSOR < YYLIMIT) {
		if (*YYCURSOR++ == '*' && *YYCURSOR == '/') {
			break;
		}
	}

	if (YYCURSOR < YYLIMIT) {
		YYCURSOR++;
	} else if (!SCNG(heredoc_scan_ahead)) {
		zend_error(E_COMPILE_WARNING, "Unterminated comment starting line %d", CG(zend_lineno));
	}

	yyleng = YYCURSOR - SCNG(yy_text);
	HANDLE_NEWLINES(yytext, yyleng);

	if (doc_com) {
		CG(doc_comment) = zend_string_init(yytext, yyleng, 0);
		RETURN_OR_SKIP_TOKEN(T_DOC_COMMENT);
	}

	RETURN_OR_SKIP_TOKEN(T_COMMENT);
}
yy219:
		YYDEBUG(219, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy152;
yy220:
		YYDEBUG(220, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(221, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_DIV_EQUAL);
}
yy222:
		YYDEBUG(222, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy223;
		}
		goto yy164;
yy223:
		YYDEBUG(223, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(224, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy223;
		}
		goto yy218;
yy225:
		YYDEBUG(225, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '=') goto yy229;
		YYDEBUG(226, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_POW);
}
yy227:
		YYDEBUG(227, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(228, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_MUL_EQUAL);
}
yy229:
		YYDEBUG(229, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(230, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_POW_EQUAL);
}
yy231:
		YYDEBUG(231, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '=') goto yy235;
		YYDEBUG(232, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_SR);
}
yy233:
		YYDEBUG(233, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(234, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_IS_GREATER_OR_EQUAL);
}
yy235:
		YYDEBUG(235, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(236, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_SR_EQUAL);
}
yy237:
		YYDEBUG(237, *YYCURSOR);
		yyaccept = 7;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= ';') goto yy238;
		if (yych <= '<') goto yy247;
		if (yych <= '=') goto yy245;
yy238:
		YYDEBUG(238, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_SL);
}
yy239:
		YYDEBUG(239, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '>') goto yy243;
		YYDEBUG(240, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_IS_SMALLER_OR_EQUAL);
}
yy241:
		YYDEBUG(241, *YYCURSOR);
		++YYCURSOR;
yy242:
		YYDEBUG(242, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_IS_NOT_EQUAL);
}
yy243:
		YYDEBUG(243, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(244, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_SPACESHIP);
}
yy245:
		YYDEBUG(245, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(246, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_SL_EQUAL);
}
yy247:
		YYDEBUG(247, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(248, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy247;
		}
		if (yych <= 'Z') {
			if (yych <= '&') {
				if (yych == '"') goto yy252;
				goto yy164;
			} else {
				if (yych <= '\'') goto yy251;
				if (yych <= '@') goto yy164;
			}
		} else {
			if (yych <= '`') {
				if (yych != '_') goto yy164;
			} else {
				if (yych <= 'z') goto yy249;
				if (yych <= 0x7F) goto yy164;
			}
		}
yy249:
		YYDEBUG(249, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(250, *YYCURSOR);
		if (yych <= '@') {
			if (yych <= '\f') {
				if (yych == '\n') goto yy256;
				goto yy164;
			} else {
				if (yych <= '\r') goto yy258;
				if (yych <= '/') goto yy164;
				if (yych <= '9') goto yy249;
				goto yy164;
			}
		} else {
			if (yych <= '_') {
				if (yych <= 'Z') goto yy249;
				if (yych <= '^') goto yy164;
				goto yy249;
			} else {
				if (yych <= '`') goto yy164;
				if (yych <= 'z') goto yy249;
				if (yych <= 0x7F) goto yy164;
				goto yy249;
			}
		}
yy251:
		YYDEBUG(251, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\'') goto yy164;
		if (yych <= '/') goto yy260;
		if (yych <= '9') goto yy164;
		goto yy260;
yy252:
		YYDEBUG(252, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '"') goto yy164;
		if (yych <= '/') goto yy254;
		if (yych <= '9') goto yy164;
		goto yy254;
yy253:
		YYDEBUG(253, *YYCURSOR);
		++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
yy254:
		YYDEBUG(254, *YYCURSOR);
		if (yych <= 'Z') {
			if (yych <= '/') {
				if (yych != '"') goto yy164;
			} else {
				if (yych <= '9') goto yy253;
				if (yych <= '@') goto yy164;
				goto yy253;
			}
		} else {
			if (yych <= '`') {
				if (yych == '_') goto yy253;
				goto yy164;
			} else {
				if (yych <= 'z') goto yy253;
				if (yych <= 0x7F) goto yy164;
				goto yy253;
			}
		}
yy255:
		YYDEBUG(255, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy256;
		if (yych == '\r') goto yy258;
		goto yy164;
yy256:
		YYDEBUG(256, *YYCURSOR);
		++YYCURSOR;
yy257:
		YYDEBUG(257, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	char *s;
	unsigned char *saved_cursor;
	int bprefix = (yytext[0] != '<') ? 1 : 0, spacing = 0, indentation = 0;
	zend_heredoc_label *heredoc_label = emalloc(sizeof(zend_heredoc_label));
	zend_bool is_heredoc = 1;

	CG(zend_lineno)++;
	heredoc_label->length = yyleng-bprefix-3-1-(yytext[yyleng-2]=='\r'?1:0);
	s = yytext+bprefix+3;
	while ((*s == ' ') || (*s == '\t')) {
		s++;
		heredoc_label->length--;
	}

	if (*s == '\'') {
		s++;
		heredoc_label->length -= 2;
		is_heredoc = 0;

		BEGIN(ST_NOWDOC);
	} else {
		if (*s == '"') {
			s++;
			heredoc_label->length -= 2;
		}

		BEGIN(ST_HEREDOC);
	}

	heredoc_label->label = estrndup(s, heredoc_label->length);
	heredoc_label->indentation = 0;
	saved_cursor = YYCURSOR;

	zend_ptr_stack_push(&SCNG(heredoc_label_stack), (void *) heredoc_label);

	while (YYCURSOR < YYLIMIT && (*YYCURSOR == ' ' || *YYCURSOR == '\t')) {
		if (*YYCURSOR == '\t') {
			spacing |= HEREDOC_USING_TABS;
		} else {
			spacing |= HEREDOC_USING_SPACES;
		}
		++YYCURSOR;
		++indentation;
	}

	if (YYCURSOR == YYLIMIT) {
		YYCURSOR = saved_cursor;
		RETURN_TOKEN(T_START_HEREDOC);
	}

	/* Check for ending label on the next line */
	if (heredoc_label->length < YYLIMIT - YYCURSOR && !memcmp(YYCURSOR, s, heredoc_label->length)) {
		if (!IS_LABEL_SUCCESSOR(YYCURSOR[heredoc_label->length])) {
			if (spacing == (HEREDOC_USING_SPACES | HEREDOC_USING_TABS)) {
				zend_throw_exception(zend_ce_parse_error, "Invalid indentation - tabs and spaces cannot be mixed", 0);
				if (PARSER_MODE()) {
					RETURN_TOKEN(T_ERROR);
				}
			}

			YYCURSOR = saved_cursor;
			heredoc_label->indentation = indentation;

			BEGIN(ST_END_HEREDOC);
			RETURN_TOKEN(T_START_HEREDOC);
		}
	}

	YYCURSOR = saved_cursor;

	if (is_heredoc && !SCNG(heredoc_scan_ahead)) {
		zend_lex_state current_state;
		int heredoc_nesting_level = 1;
		int first_token = 0;
		int error = 0;

		zend_save_lexical_state(&current_state);

		SCNG(heredoc_scan_ahead) = 1;
		SCNG(heredoc_indentation) = 0;
		SCNG(heredoc_indentation_uses_spaces) = 0;
		LANG_SCNG(on_event) = NULL;

		zend_ptr_stack_reverse_apply(&current_state.heredoc_label_stack, copy_heredoc_label_stack);

		zend_exception_save();
		while (heredoc_nesting_level) {
			zval zv;
			int retval;

			ZVAL_UNDEF(&zv);
			retval = lex_scan(&zv, NULL);
			zval_ptr_dtor_nogc(&zv);

			if (EG(exception)) {
				zend_clear_exception();
				break;
			}

			if (!first_token) {
				first_token = retval;
			}

			switch (retval) {
				case T_START_HEREDOC:
					++heredoc_nesting_level;
					break;
				case T_END_HEREDOC:
					--heredoc_nesting_level;
					break;
				case END:
					heredoc_nesting_level = 0;
			}
		}
		zend_exception_restore();

		if (
		    (first_token == T_VARIABLE
		     || first_token == T_DOLLAR_OPEN_CURLY_BRACES
		     || first_token == T_CURLY_OPEN
		    ) && SCNG(heredoc_indentation)) {
			zend_throw_exception_ex(zend_ce_parse_error, 0, "Invalid body indentation level (expecting an indentation level of at least %d)", SCNG(heredoc_indentation));
			error = 1;
		}

		heredoc_label->indentation = SCNG(heredoc_indentation);
		heredoc_label->indentation_uses_spaces = SCNG(heredoc_indentation_uses_spaces);

		zend_restore_lexical_state(&current_state);
		SCNG(heredoc_scan_ahead) = 0;
		CG(increment_lineno) = 0;

		if (PARSER_MODE() && error) {
			RETURN_TOKEN(T_ERROR);
		}
	}

	RETURN_TOKEN(T_START_HEREDOC);
}
yy258:
		YYDEBUG(258, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy256;
		goto yy257;
yy259:
		YYDEBUG(259, *YYCURSOR);
		++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
yy260:
		YYDEBUG(260, *YYCURSOR);
		if (yych <= 'Z') {
			if (yych <= '/') {
				if (yych == '\'') goto yy255;
				goto yy164;
			} else {
				if (yych <= '9') goto yy259;
				if (yych <= '@') goto yy164;
				goto yy259;
			}
		} else {
			if (yych <= '`') {
				if (yych == '_') goto yy259;
				goto yy164;
			} else {
				if (yych <= 'z') goto yy259;
				if (yych <= 0x7F) goto yy164;
				goto yy259;
			}
		}
yy261:
		YYDEBUG(261, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '=') goto yy242;
		YYDEBUG(262, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(263, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_IS_NOT_IDENTICAL);
}
yy264:
		YYDEBUG(264, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(265, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_PLUS_EQUAL);
}
yy266:
		YYDEBUG(266, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(267, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_INC);
}
yy268:
		YYDEBUG(268, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy269;
		if (yych != 's') goto yy162;
yy269:
		YYDEBUG(269, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy270;
		if (yych != 't') goto yy162;
yy270:
		YYDEBUG(270, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy161;
		}
		YYDEBUG(271, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_LIST);
}
yy272:
		YYDEBUG(272, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '=') goto yy276;
		YYDEBUG(273, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_IS_EQUAL);
}
yy274:
		YYDEBUG(274, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(275, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_DOUBLE_ARROW);
}
yy276:
		YYDEBUG(276, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(277, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_IS_IDENTICAL);
}
yy278:
		YYDEBUG(278, *YYCURSOR);
		yych = *++YYCURSOR;
		YYDEBUG(-1, yych);
		switch (yych) {
		case 'C':
		case 'c':	goto yy280;
		case 'D':
		case 'd':	goto yy285;
		case 'F':
		case 'f':	goto yy282;
		case 'H':
		case 'h':	goto yy279;
		case 'L':
		case 'l':	goto yy284;
		case 'M':
		case 'm':	goto yy283;
		case 'N':
		case 'n':	goto yy286;
		case 'T':
		case 't':	goto yy281;
		default:	goto yy162;
		}
yy279:
		YYDEBUG(279, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy347;
		if (yych == 'a') goto yy347;
		goto yy162;
yy280:
		YYDEBUG(280, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy340;
		if (yych == 'l') goto yy340;
		goto yy162;
yy281:
		YYDEBUG(281, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy333;
		if (yych == 'r') goto yy333;
		goto yy162;
yy282:
		YYDEBUG(282, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'U') {
			if (yych == 'I') goto yy317;
			if (yych <= 'T') goto yy162;
			goto yy318;
		} else {
			if (yych <= 'i') {
				if (yych <= 'h') goto yy162;
				goto yy317;
			} else {
				if (yych == 'u') goto yy318;
				goto yy162;
			}
		}
yy283:
		YYDEBUG(283, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy309;
		if (yych == 'e') goto yy309;
		goto yy162;
yy284:
		YYDEBUG(284, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy303;
		if (yych == 'i') goto yy303;
		goto yy162;
yy285:
		YYDEBUG(285, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy298;
		if (yych == 'i') goto yy298;
		goto yy162;
yy286:
		YYDEBUG(286, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy287;
		if (yych != 'a') goto yy162;
yy287:
		YYDEBUG(287, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'M') goto yy288;
		if (yych != 'm') goto yy162;
yy288:
		YYDEBUG(288, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy289;
		if (yych != 'e') goto yy162;
yy289:
		YYDEBUG(289, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy290;
		if (yych != 's') goto yy162;
yy290:
		YYDEBUG(290, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy291;
		if (yych != 'p') goto yy162;
yy291:
		YYDEBUG(291, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy292;
		if (yych != 'a') goto yy162;
yy292:
		YYDEBUG(292, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy293;
		if (yych != 'c') goto yy162;
yy293:
		YYDEBUG(293, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy294;
		if (yych != 'e') goto yy162;
yy294:
		YYDEBUG(294, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy162;
		YYDEBUG(295, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy162;
		YYDEBUG(296, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy161;
		}
		YYDEBUG(297, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_NS_C);
}
yy298:
		YYDEBUG(298, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy299;
		if (yych != 'r') goto yy162;
yy299:
		YYDEBUG(299, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy162;
		YYDEBUG(300, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy162;
		YYDEBUG(301, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy161;
		}
		YYDEBUG(302, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_DIR);
}
yy303:
		YYDEBUG(303, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy304;
		if (yych != 'n') goto yy162;
yy304:
		YYDEBUG(304, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy305;
		if (yych != 'e') goto yy162;
yy305:
		YYDEBUG(305, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy162;
		YYDEBUG(306, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy162;
		YYDEBUG(307, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy161;
		}
		YYDEBUG(308, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_LINE);
}
yy309:
		YYDEBUG(309, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy310;
		if (yych != 't') goto yy162;
yy310:
		YYDEBUG(310, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy311;
		if (yych != 'h') goto yy162;
yy311:
		YYDEBUG(311, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy312;
		if (yych != 'o') goto yy162;
yy312:
		YYDEBUG(312, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy313;
		if (yych != 'd') goto yy162;
yy313:
		YYDEBUG(313, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy162;
		YYDEBUG(314, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy162;
		YYDEBUG(315, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy161;
		}
		YYDEBUG(316, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_METHOD_C);
}
yy317:
		YYDEBUG(317, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy328;
		if (yych == 'l') goto yy328;
		goto yy162;
yy318:
		YYDEBUG(318, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy319;
		if (yych != 'n') goto yy162;
yy319:
		YYDEBUG(319, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy320;
		if (yych != 'c') goto yy162;
yy320:
		YYDEBUG(320, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy321;
		if (yych != 't') goto yy162;
yy321:
		YYDEBUG(321, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy322;
		if (yych != 'i') goto yy162;
yy322:
		YYDEBUG(322, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy323;
		if (yych != 'o') goto yy162;
yy323:
		YYDEBUG(323, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy324;
		if (yych != 'n') goto yy162;
yy324:
		YYDEBUG(324, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy162;
		YYDEBUG(325, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy162;
		YYDEBUG(326, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy161;
		}
		YYDEBUG(327, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_FUNC_C);
}
yy328:
		YYDEBUG(328, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy329;
		if (yych != 'e') goto yy162;
yy329:
		YYDEBUG(329, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy162;
		YYDEBUG(330, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy162;
		YYDEBUG(331, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy161;
		}
		YYDEBUG(332, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_FILE);
}
yy333:
		YYDEBUG(333, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy334;
		if (yych != 'a') goto yy162;
yy334:
		YYDEBUG(334, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy335;
		if (yych != 'i') goto yy162;
yy335:
		YYDEBUG(335, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy336;
		if (yych != 't') goto yy162;
yy336:
		YYDEBUG(336, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy162;
		YYDEBUG(337, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy162;
		YYDEBUG(338, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy161;
		}
		YYDEBUG(339, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_TRAIT_C);
}
yy340:
		YYDEBUG(340, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy341;
		if (yych != 'a') goto yy162;
yy341:
		YYDEBUG(341, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy342;
		if (yych != 's') goto yy162;
yy342:
		YYDEBUG(342, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy343;
		if (yych != 's') goto yy162;
yy343:
		YYDEBUG(343, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy162;
		YYDEBUG(344, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy162;
		YYDEBUG(345, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy161;
		}
		YYDEBUG(346, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_CLASS_C);
}
yy347:
		YYDEBUG(347, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy348;
		if (yych != 'l') goto yy162;
yy348:
		YYDEBUG(348, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy349;
		if (yych != 't') goto yy162;
yy349:
		YYDEBUG(349, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy162;
		YYDEBUG(350, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy351;
		if (yych != 'c') goto yy162;
yy351:
		YYDEBUG(351, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy352;
		if (yych != 'o') goto yy162;
yy352:
		YYDEBUG(352, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'M') goto yy353;
		if (yych != 'm') goto yy162;
yy353:
		YYDEBUG(353, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy354;
		if (yych != 'p') goto yy162;
yy354:
		YYDEBUG(354, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy355;
		if (yych != 'i') goto yy162;
yy355:
		YYDEBUG(355, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy356;
		if (yych != 'l') goto yy162;
yy356:
		YYDEBUG(356, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy357;
		if (yych != 'e') goto yy162;
yy357:
		YYDEBUG(357, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy358;
		if (yych != 'r') goto yy162;
yy358:
		YYDEBUG(358, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy161;
		}
		YYDEBUG(359, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_HALT_COMPILER);
}
yy360:
		YYDEBUG(360, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy364;
		if (yych == 's') goto yy364;
		goto yy162;
yy361:
		YYDEBUG(361, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy362;
		if (yych != 'e') goto yy162;
yy362:
		YYDEBUG(362, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy161;
		}
		YYDEBUG(363, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_USE);
}
yy364:
		YYDEBUG(364, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy365;
		if (yych != 'e') goto yy162;
yy365:
		YYDEBUG(365, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy366;
		if (yych != 't') goto yy162;
yy366:
		YYDEBUG(366, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy161;
		}
		YYDEBUG(367, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_UNSET);
}
yy368:
		YYDEBUG(368, *YYCURSOR);
		++YYCURSOR;
		YYFILL(7);
		yych = *YYCURSOR;
yy369:
		YYDEBUG(369, *YYCURSOR);
		if (yych <= 'S') {
			if (yych <= 'D') {
				if (yych <= ' ') {
					if (yych == '\t') goto yy368;
					if (yych <= 0x1F) goto yy164;
					goto yy368;
				} else {
					if (yych <= 'A') {
						if (yych <= '@') goto yy164;
						goto yy373;
					} else {
						if (yych <= 'B') goto yy371;
						if (yych <= 'C') goto yy164;
						goto yy376;
					}
				}
			} else {
				if (yych <= 'I') {
					if (yych == 'F') goto yy377;
					if (yych <= 'H') goto yy164;
					goto yy378;
				} else {
					if (yych <= 'O') {
						if (yych <= 'N') goto yy164;
						goto yy372;
					} else {
						if (yych <= 'Q') goto yy164;
						if (yych <= 'R') goto yy375;
						goto yy374;
					}
				}
			}
		} else {
			if (yych <= 'f') {
				if (yych <= 'a') {
					if (yych == 'U') goto yy370;
					if (yych <= '`') goto yy164;
					goto yy373;
				} else {
					if (yych <= 'c') {
						if (yych <= 'b') goto yy371;
						goto yy164;
					} else {
						if (yych <= 'd') goto yy376;
						if (yych <= 'e') goto yy164;
						goto yy377;
					}
				}
			} else {
				if (yych <= 'q') {
					if (yych <= 'i') {
						if (yych <= 'h') goto yy164;
						goto yy378;
					} else {
						if (yych == 'o') goto yy372;
						goto yy164;
					}
				} else {
					if (yych <= 's') {
						if (yych <= 'r') goto yy375;
						goto yy374;
					} else {
						if (yych != 'u') goto yy164;
					}
				}
			}
		}
yy370:
		YYDEBUG(370, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy441;
		if (yych == 'n') goto yy441;
		goto yy164;
yy371:
		YYDEBUG(371, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'O') {
			if (yych == 'I') goto yy428;
			if (yych <= 'N') goto yy164;
			goto yy429;
		} else {
			if (yych <= 'i') {
				if (yych <= 'h') goto yy164;
				goto yy428;
			} else {
				if (yych == 'o') goto yy429;
				goto yy164;
			}
		}
yy372:
		YYDEBUG(372, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'B') goto yy420;
		if (yych == 'b') goto yy420;
		goto yy164;
yy373:
		YYDEBUG(373, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy413;
		if (yych == 'r') goto yy413;
		goto yy164;
yy374:
		YYDEBUG(374, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy405;
		if (yych == 't') goto yy405;
		goto yy164;
yy375:
		YYDEBUG(375, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy399;
		if (yych == 'e') goto yy399;
		goto yy164;
yy376:
		YYDEBUG(376, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy395;
		if (yych == 'o') goto yy395;
		goto yy164;
yy377:
		YYDEBUG(377, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy388;
		if (yych == 'l') goto yy388;
		goto yy164;
yy378:
		YYDEBUG(378, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy379;
		if (yych != 'n') goto yy164;
yy379:
		YYDEBUG(379, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy380;
		if (yych != 't') goto yy164;
yy380:
		YYDEBUG(380, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy381;
		if (yych != 'e') goto yy383;
yy381:
		YYDEBUG(381, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'G') goto yy386;
		if (yych == 'g') goto yy386;
		goto yy164;
yy382:
		YYDEBUG(382, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy383:
		YYDEBUG(383, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy382;
			goto yy164;
		} else {
			if (yych <= ' ') goto yy382;
			if (yych != ')') goto yy164;
		}
		YYDEBUG(384, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(385, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_INT_CAST);
}
yy386:
		YYDEBUG(386, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy387;
		if (yych != 'e') goto yy164;
yy387:
		YYDEBUG(387, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy382;
		if (yych == 'r') goto yy382;
		goto yy164;
yy388:
		YYDEBUG(388, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy389;
		if (yych != 'o') goto yy164;
yy389:
		YYDEBUG(389, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy390;
		if (yych != 'a') goto yy164;
yy390:
		YYDEBUG(390, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy391;
		if (yych != 't') goto yy164;
yy391:
		YYDEBUG(391, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(392, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy391;
			goto yy164;
		} else {
			if (yych <= ' ') goto yy391;
			if (yych != ')') goto yy164;
		}
		YYDEBUG(393, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(394, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_DOUBLE_CAST);
}
yy395:
		YYDEBUG(395, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy396;
		if (yych != 'u') goto yy164;
yy396:
		YYDEBUG(396, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'B') goto yy397;
		if (yych != 'b') goto yy164;
yy397:
		YYDEBUG(397, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy398;
		if (yych != 'l') goto yy164;
yy398:
		YYDEBUG(398, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy391;
		if (yych == 'e') goto yy391;
		goto yy164;
yy399:
		YYDEBUG(399, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy400;
		if (yych != 'a') goto yy164;
yy400:
		YYDEBUG(400, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy401;
		if (yych != 'l') goto yy164;
yy401:
		YYDEBUG(401, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(402, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy401;
			goto yy164;
		} else {
			if (yych <= ' ') goto yy401;
			if (yych != ')') goto yy164;
		}
		YYDEBUG(403, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(404, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (PARSER_MODE()) {
		zend_error(E_DEPRECATED, "The (real) cast is deprecated, use (float) instead");
	}
	RETURN_TOKEN(T_DOUBLE_CAST);
}
yy405:
		YYDEBUG(405, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy406;
		if (yych != 'r') goto yy164;
yy406:
		YYDEBUG(406, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy407;
		if (yych != 'i') goto yy164;
yy407:
		YYDEBUG(407, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy408;
		if (yych != 'n') goto yy164;
yy408:
		YYDEBUG(408, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'G') goto yy409;
		if (yych != 'g') goto yy164;
yy409:
		YYDEBUG(409, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(410, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy409;
			goto yy164;
		} else {
			if (yych <= ' ') goto yy409;
			if (yych != ')') goto yy164;
		}
		YYDEBUG(411, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(412, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_STRING_CAST);
}
yy413:
		YYDEBUG(413, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy414;
		if (yych != 'r') goto yy164;
yy414:
		YYDEBUG(414, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy415;
		if (yych != 'a') goto yy164;
yy415:
		YYDEBUG(415, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'Y') goto yy416;
		if (yych != 'y') goto yy164;
yy416:
		YYDEBUG(416, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(417, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy416;
			goto yy164;
		} else {
			if (yych <= ' ') goto yy416;
			if (yych != ')') goto yy164;
		}
		YYDEBUG(418, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(419, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_ARRAY_CAST);
}
yy420:
		YYDEBUG(420, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'J') goto yy421;
		if (yych != 'j') goto yy164;
yy421:
		YYDEBUG(421, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy422;
		if (yych != 'e') goto yy164;
yy422:
		YYDEBUG(422, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy423;
		if (yych != 'c') goto yy164;
yy423:
		YYDEBUG(423, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy424;
		if (yych != 't') goto yy164;
yy424:
		YYDEBUG(424, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(425, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy424;
			goto yy164;
		} else {
			if (yych <= ' ') goto yy424;
			if (yych != ')') goto yy164;
		}
		YYDEBUG(426, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(427, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_OBJECT_CAST);
}
yy428:
		YYDEBUG(428, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy438;
		if (yych == 'n') goto yy438;
		goto yy164;
yy429:
		YYDEBUG(429, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy430;
		if (yych != 'o') goto yy164;
yy430:
		YYDEBUG(430, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy431;
		if (yych != 'l') goto yy164;
yy431:
		YYDEBUG(431, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy436;
		if (yych == 'e') goto yy436;
		goto yy433;
yy432:
		YYDEBUG(432, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy433:
		YYDEBUG(433, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy432;
			goto yy164;
		} else {
			if (yych <= ' ') goto yy432;
			if (yych != ')') goto yy164;
		}
		YYDEBUG(434, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(435, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_BOOL_CAST);
}
yy436:
		YYDEBUG(436, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy437;
		if (yych != 'a') goto yy164;
yy437:
		YYDEBUG(437, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy432;
		if (yych == 'n') goto yy432;
		goto yy164;
yy438:
		YYDEBUG(438, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy439;
		if (yych != 'a') goto yy164;
yy439:
		YYDEBUG(439, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy440;
		if (yych != 'r') goto yy164;
yy440:
		YYDEBUG(440, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'Y') goto yy409;
		if (yych == 'y') goto yy409;
		goto yy164;
yy441:
		YYDEBUG(441, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy442;
		if (yych != 's') goto yy164;
yy442:
		YYDEBUG(442, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy443;
		if (yych != 'e') goto yy164;
yy443:
		YYDEBUG(443, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy444;
		if (yych != 't') goto yy164;
yy444:
		YYDEBUG(444, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(445, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy444;
			goto yy164;
		} else {
			if (yych <= ' ') goto yy444;
			if (yych != ')') goto yy164;
		}
		YYDEBUG(446, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(447, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_UNSET_CAST);
}
yy448:
		YYDEBUG(448, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy449;
		if (yych != 'r') goto yy162;
yy449:
		YYDEBUG(449, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy161;
		}
		YYDEBUG(450, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_VAR);
}
yy451:
		YYDEBUG(451, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'M') goto yy455;
		if (yych == 'm') goto yy455;
		goto yy162;
yy452:
		YYDEBUG(452, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'W') goto yy453;
		if (yych != 'w') goto yy162;
yy453:
		YYDEBUG(453, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy161;
		}
		YYDEBUG(454, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_NEW);
}
yy455:
		YYDEBUG(455, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy456;
		if (yych != 'e') goto yy162;
yy456:
		YYDEBUG(456, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy457;
		if (yych != 's') goto yy162;
yy457:
		YYDEBUG(457, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy458;
		if (yych != 'p') goto yy162;
yy458:
		YYDEBUG(458, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy459;
		if (yych != 'a') goto yy162;
yy459:
		YYDEBUG(459, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy460;
		if (yych != 'c') goto yy162;
yy460:
		YYDEBUG(460, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy461;
		if (yych != 'e') goto yy162;
yy461:
		YYDEBUG(461, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy161;
		}
		YYDEBUG(462, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_NAMESPACE);
}
yy463:
		YYDEBUG(463, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '\n') goto yy469;
		if (yych == '\r') goto yy470;
yy464:
		YYDEBUG(464, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	BEGIN(INITIAL);
	if (yytext[yyleng-1] != '>') {
		CG(increment_lineno) = 1;
	}
	if (PARSER_MODE()) {
		RETURN_TOKEN(';');  /* implicit ';' at php-end tag */
	}
	RETURN_TOKEN(T_CLOSE_TAG);
}
yy465:
		YYDEBUG(465, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '=') goto yy467;
		YYDEBUG(466, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_COALESCE);
}
yy467:
		YYDEBUG(467, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(468, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_COALESCE_EQUAL);
}
yy469:
		YYDEBUG(469, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy464;
yy470:
		YYDEBUG(470, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy469;
		goto yy464;
yy471:
		YYDEBUG(471, *YYCURSOR);
		yyaccept = 3;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(472, *YYCURSOR);
		if (yych <= 'E') {
			if (yych <= '/') goto yy166;
			if (yych <= '9') goto yy471;
			if (yych <= 'D') goto yy166;
			goto yy169;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy166;
				goto yy478;
			} else {
				if (yych == 'e') goto yy169;
				goto yy166;
			}
		}
yy473:
		YYDEBUG(473, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(474, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_CONCAT_EQUAL);
}
yy475:
		YYDEBUG(475, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '.') goto yy164;
		YYDEBUG(476, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(477, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_ELLIPSIS);
}
yy478:
		YYDEBUG(478, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '/') goto yy164;
		if (yych >= ':') goto yy164;
yy479:
		YYDEBUG(479, *YYCURSOR);
		yyaccept = 3;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(480, *YYCURSOR);
		if (yych <= 'E') {
			if (yych <= '/') goto yy166;
			if (yych <= '9') goto yy479;
			if (yych <= 'D') goto yy166;
			goto yy169;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy166;
				goto yy478;
			} else {
				if (yych == 'e') goto yy169;
				goto yy166;
			}
		}
yy481:
		YYDEBUG(481, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(482, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_PAAMAYIM_NEKUDOTAYIM);
}
yy483:
		YYDEBUG(483, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy484:
		YYDEBUG(484, *YYCURSOR);
		if (yych <= '\f') {
			if (yych <= 0x08) goto yy116;
			if (yych <= '\n') goto yy483;
			goto yy116;
		} else {
			if (yych <= '\r') goto yy483;
			if (yych == ' ') goto yy483;
			goto yy116;
		}
yy485:
		YYDEBUG(485, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(486, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_MINUS_EQUAL);
}
yy487:
		YYDEBUG(487, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(488, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_DEC);
}
yy489:
		YYDEBUG(489, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(490, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	RETURN_TOKEN(T_OBJECT_OPERATOR);
}
yy491:
		YYDEBUG(491, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'O') {
			if (yych == 'I') goto yy498;
			if (yych <= 'N') goto yy162;
			goto yy499;
		} else {
			if (yych <= 'i') {
				if (yych <= 'h') goto yy162;
				goto yy498;
			} else {
				if (yych == 'o') goto yy499;
				goto yy162;
			}
		}
yy492:
		YYDEBUG(492, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'B') goto yy493;
		if (yych != 'b') goto yy162;
yy493:
		YYDEBUG(493, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy494;
		if (yych != 'l') goto yy162;
yy494:
		YYDEBUG(494, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy495;
		if (yych != 'i') goto yy162;
yy495:
		YYDEBUG(495, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy496;
		if (yych != 'c') goto yy162;
yy496:
		YYDEBUG(496, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy161;
		}
		YYDEBUG(497, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_PUBLIC);
}
yy498:
		YYDEBUG(498, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'V') {
			if (yych == 'N') goto yy507;
			if (yych <= 'U') goto yy162;
			goto yy508;
		} else {
			if (yych <= 'n') {
				if (yych <= 'm') goto yy162;
				goto yy507;
			} else {
				if (yych == 'v') goto yy508;
				goto yy162;
			}
		}
yy499:
		YYDEBUG(499, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy500;
		if (yych != 't') goto yy162;
yy500:
		YYDEBUG(500, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy501;
		if (yych != 'e') goto yy162;
yy501:
		YYDEBUG(501, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy502;
		if (yych != 'c') goto yy162;
yy502:
		YYDEBUG(502, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy503;
		if (yych != 't') goto yy162;
yy503:
		YYDEBUG(503, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy504;
		if (yych != 'e') goto yy162;
yy504:
		YYDEBUG(504, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy505;
		if (yych != 'd') goto yy162;
yy505:
		YYDEBUG(505, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy161;
		}
		YYDEBUG(506, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_PROTECTED);
}
yy507:
		YYDEBUG(507, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy513;
		if (yych == 't') goto yy513;
		goto yy162;
yy508:
		YYDEBUG(508, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy509;
		if (yych != 'a') goto yy162;
yy509:
		YYDEBUG(509, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy510;
		if (yych != 't') goto yy162;
yy510:
		YYDEBUG(510, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy511;
		if (yych != 'e') goto yy162;
yy511:
		YYDEBUG(511, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy161;
		}
		YYDEBUG(512, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_PRIVATE);
}
yy513:
		YYDEBUG(513, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy161;
		}
		YYDEBUG(514, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_PRINT);
}
yy515:
		YYDEBUG(515, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy520;
		if (yych == 'o') goto yy520;
		goto yy162;
yy516:
		YYDEBUG(516, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy517;
		if (yych != 't') goto yy162;
yy517:
		YYDEBUG(517, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy518;
		if (yych != 'o') goto yy162;
yy518:
		YYDEBUG(518, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy161;
		}
		YYDEBUG(519, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_GOTO);
}
yy520:
		YYDEBUG(520, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'B') goto yy521;
		if (yych != 'b') goto yy162;
yy521:
		YYDEBUG(521, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy522;
		if (yych != 'a') goto yy162;
yy522:
		YYDEBUG(522, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy523;
		if (yych != 'l') goto yy162;
yy523:
		YYDEBUG(523, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy161;
		}
		YYDEBUG(524, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_GLOBAL);
}
yy525:
		YYDEBUG(525, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '<') goto yy533;
		goto yy164;
yy526:
		YYDEBUG(526, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy156;
yy527:
		YYDEBUG(527, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy154;
yy528:
		YYDEBUG(528, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy529;
		if (yych != 'e') goto yy162;
yy529:
		YYDEBUG(529, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy530;
		if (yych != 'a') goto yy162;
yy530:
		YYDEBUG(530, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'K') goto yy531;
		if (yych != 'k') goto yy162;
yy531:
		YYDEBUG(531, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy161;
		}
		YYDEBUG(532, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_BREAK);
}
yy533:
		YYDEBUG(533, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '<') goto yy247;
		goto yy164;
yy534:
		YYDEBUG(534, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy541;
		if (yych == 'a') goto yy541;
		goto yy162;
yy535:
		YYDEBUG(535, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy536;
		if (yych != 'i') goto yy162;
yy536:
		YYDEBUG(536, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy537;
		if (yych != 't') goto yy162;
yy537:
		YYDEBUG(537, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy538;
		if (yych != 'c') goto yy162;
yy538:
		YYDEBUG(538, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy539;
		if (yych != 'h') goto yy162;
yy539:
		YYDEBUG(539, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy161;
		}
		YYDEBUG(540, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_SWITCH);
}
yy541:
		YYDEBUG(541, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy542;
		if (yych != 't') goto yy162;
yy542:
		YYDEBUG(542, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy543;
		if (yych != 'i') goto yy162;
yy543:
		YYDEBUG(543, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy544;
		if (yych != 'c') goto yy162;
yy544:
		YYDEBUG(544, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy161;
		}
		YYDEBUG(545, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_STATIC);
}
yy546:
		YYDEBUG(546, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy557;
		if (yych == 's') goto yy557;
		goto yy162;
yy547:
		YYDEBUG(547, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy555;
		if (yych == 'd') goto yy555;
		goto yy162;
yy548:
		YYDEBUG(548, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy551;
		if (yych == 'r') goto yy551;
		goto yy162;
yy549:
		YYDEBUG(549, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy161;
		}
		YYDEBUG(550, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_AS);
}
yy551:
		YYDEBUG(551, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy552;
		if (yych != 'a') goto yy162;
yy552:
		YYDEBUG(552, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'Y') goto yy553;
		if (yych != 'y') goto yy162;
yy553:
		YYDEBUG(553, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy161;
		}
		YYDEBUG(554, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_ARRAY);
}
yy555:
		YYDEBUG(555, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy161;
		}
		YYDEBUG(556, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_LOGICAL_AND);
}
yy557:
		YYDEBUG(557, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy558;
		if (yych != 't') goto yy162;
yy558:
		YYDEBUG(558, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy559;
		if (yych != 'r') goto yy162;
yy559:
		YYDEBUG(559, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy560;
		if (yych != 'a') goto yy162;
yy560:
		YYDEBUG(560, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy561;
		if (yych != 'c') goto yy162;
yy561:
		YYDEBUG(561, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy562;
		if (yych != 't') goto yy162;
yy562:
		YYDEBUG(562, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy161;
		}
		YYDEBUG(563, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_ABSTRACT);
}
yy564:
		YYDEBUG(564, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy565;
		if (yych != 'i') goto yy162;
yy565:
		YYDEBUG(565, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy566;
		if (yych != 'l') goto yy162;
yy566:
		YYDEBUG(566, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy567;
		if (yych != 'e') goto yy162;
yy567:
		YYDEBUG(567, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy161;
		}
		YYDEBUG(568, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_WHILE);
}
yy569:
		YYDEBUG(569, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy161;
		}
		YYDEBUG(570, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_IF);
}
yy571:
		YYDEBUG(571, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy613;
		if (yych == 'p') goto yy613;
		goto yy162;
yy572:
		YYDEBUG(572, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'T') {
			if (yych <= 'C') {
				if (yych <= 'B') goto yy162;
				goto yy580;
			} else {
				if (yych <= 'R') goto yy162;
				if (yych <= 'S') goto yy578;
				goto yy579;
			}
		} else {
			if (yych <= 'r') {
				if (yych == 'c') goto yy580;
				goto yy162;
			} else {
				if (yych <= 's') goto yy578;
				if (yych <= 't') goto yy579;
				goto yy162;
			}
		}
yy573:
		YYDEBUG(573, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy574;
		if (yych != 's') goto yy162;
yy574:
		YYDEBUG(574, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy575;
		if (yych != 'e') goto yy162;
yy575:
		YYDEBUG(575, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy576;
		if (yych != 't') goto yy162;
yy576:
		YYDEBUG(576, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy161;
		}
		YYDEBUG(577, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_ISSET);
}
yy578:
		YYDEBUG(578, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy599;
		if (yych == 't') goto yy599;
		goto yy162;
yy579:
		YYDEBUG(579, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy592;
		if (yych == 'e') goto yy592;
		goto yy162;
yy580:
		YYDEBUG(580, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy581;
		if (yych != 'l') goto yy162;
yy581:
		YYDEBUG(581, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy582;
		if (yych != 'u') goto yy162;
yy582:
		YYDEBUG(582, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy583;
		if (yych != 'd') goto yy162;
yy583:
		YYDEBUG(583, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy584;
		if (yych != 'e') goto yy162;
yy584:
		YYDEBUG(584, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '^') {
			if (yych <= '9') {
				if (yych >= '0') goto yy161;
			} else {
				if (yych <= '@') goto yy585;
				if (yych <= 'Z') goto yy161;
			}
		} else {
			if (yych <= '`') {
				if (yych <= '_') goto yy586;
			} else {
				if (yych <= 'z') goto yy161;
				if (yych >= 0x80) goto yy161;
			}
		}
yy585:
		YYDEBUG(585, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_INCLUDE);
}
yy586:
		YYDEBUG(586, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy587;
		if (yych != 'o') goto yy162;
yy587:
		YYDEBUG(587, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy588;
		if (yych != 'n') goto yy162;
yy588:
		YYDEBUG(588, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy589;
		if (yych != 'c') goto yy162;
yy589:
		YYDEBUG(589, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy590;
		if (yych != 'e') goto yy162;
yy590:
		YYDEBUG(590, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy161;
		}
		YYDEBUG(591, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_INCLUDE_ONCE);
}
yy592:
		YYDEBUG(592, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy593;
		if (yych != 'r') goto yy162;
yy593:
		YYDEBUG(593, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'F') goto yy594;
		if (yych != 'f') goto yy162;
yy594:
		YYDEBUG(594, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy595;
		if (yych != 'a') goto yy162;
yy595:
		YYDEBUG(595, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy596;
		if (yych != 'c') goto yy162;
yy596:
		YYDEBUG(596, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy597;
		if (yych != 'e') goto yy162;
yy597:
		YYDEBUG(597, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy161;
		}
		YYDEBUG(598, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_INTERFACE);
}
yy599:
		YYDEBUG(599, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'E') {
			if (yych == 'A') goto yy600;
			if (yych <= 'D') goto yy162;
			goto yy601;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy162;
			} else {
				if (yych == 'e') goto yy601;
				goto yy162;
			}
		}
yy600:
		YYDEBUG(600, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy607;
		if (yych == 'n') goto yy607;
		goto yy162;
yy601:
		YYDEBUG(601, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy602;
		if (yych != 'a') goto yy162;
yy602:
		YYDEBUG(602, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy603;
		if (yych != 'd') goto yy162;
yy603:
		YYDEBUG(603, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy604;
		if (yych != 'o') goto yy162;
yy604:
		YYDEBUG(604, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'F') goto yy605;
		if (yych != 'f') goto yy162;
yy605:
		YYDEBUG(605, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy161;
		}
		YYDEBUG(606, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
    RETURN_TOKEN(T_INSTEADOF);
}
yy607:
		YYDEBUG(607, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy608;
		if (yych != 'c') goto yy162;
yy608:
		YYDEBUG(608, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy609;
		if (yych != 'e') goto yy162;
yy609:
		YYDEBUG(609, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy610;
		if (yych != 'o') goto yy162;
yy610:
		YYDEBUG(610, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'F') goto yy611;
		if (yych != 'f') goto yy162;
yy611:
		YYDEBUG(611, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy161;
		}
		YYDEBUG(612, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_INSTANCEOF);
}
yy613:
		YYDEBUG(613, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy614;
		if (yych != 'l') goto yy162;
yy614:
		YYDEBUG(614, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy615;
		if (yych != 'e') goto yy162;
yy615:
		YYDEBUG(615, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'M') goto yy616;
		if (yych != 'm') goto yy162;
yy616:
		YYDEBUG(616, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy617;
		if (yych != 'e') goto yy162;
yy617:
		YYDEBUG(617, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy618;
		if (yych != 'n') goto yy162;
yy618:
		YYDEBUG(618, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy619;
		if (yych != 't') goto yy162;
yy619:
		YYDEBUG(619, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy620;
		if (yych != 's') goto yy162;
yy620:
		YYDEBUG(620, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy161;
		}
		YYDEBUG(621, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_IMPLEMENTS);
}
yy622:
		YYDEBUG(622, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy630;
		if (yych == 'r') goto yy630;
		goto yy162;
yy623:
		YYDEBUG(623, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'Y') {
			if (yych == 'A') goto yy626;
			if (yych <= 'X') goto yy162;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy162;
				goto yy626;
			} else {
				if (yych != 'y') goto yy162;
			}
		}
		YYDEBUG(624, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy161;
		}
		YYDEBUG(625, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_TRY);
}
yy626:
		YYDEBUG(626, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy627;
		if (yych != 'i') goto yy162;
yy627:
		YYDEBUG(627, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy628;
		if (yych != 't') goto yy162;
yy628:
		YYDEBUG(628, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy161;
		}
		YYDEBUG(629, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_TRAIT);
}
yy630:
		YYDEBUG(630, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy631;
		if (yych != 'o') goto yy162;
yy631:
		YYDEBUG(631, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'W') goto yy632;
		if (yych != 'w') goto yy162;
yy632:
		YYDEBUG(632, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy161;
		}
		YYDEBUG(633, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_THROW);
}
yy634:
		YYDEBUG(634, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy635;
		if (yych != 'e') goto yy162;
yy635:
		YYDEBUG(635, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy636;
		if (yych != 'l') goto yy162;
yy636:
		YYDEBUG(636, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy637;
		if (yych != 'd') goto yy162;
yy637:
		YYDEBUG(637, *YYCURSOR);
		yyaccept = 8;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 4) {
			goto yy161;
		}
		if (yych <= '\f') {
			if (yych <= 0x08) goto yy638;
			if (yych <= '\n') goto yy639;
		} else {
			if (yych <= '\r') goto yy639;
			if (yych == ' ') goto yy639;
		}
yy638:
		YYDEBUG(638, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_YIELD);
}
yy639:
		YYDEBUG(639, *YYCURSOR);
		++YYCURSOR;
		YYFILL(5);
		yych = *YYCURSOR;
		YYDEBUG(640, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych <= '\n') {
				if (yych <= 0x08) goto yy164;
				goto yy639;
			} else {
				if (yych == '\r') goto yy639;
				goto yy164;
			}
		} else {
			if (yych <= 'F') {
				if (yych <= ' ') goto yy639;
				if (yych <= 'E') goto yy164;
			} else {
				if (yych != 'f') goto yy164;
			}
		}
		YYDEBUG(641, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy642;
		if (yych != 'r') goto yy164;
yy642:
		YYDEBUG(642, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy643;
		if (yych != 'o') goto yy164;
yy643:
		YYDEBUG(643, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'M') goto yy644;
		if (yych != 'm') goto yy164;
yy644:
		YYDEBUG(644, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '^') {
			if (yych <= '9') {
				if (yych >= '0') goto yy164;
			} else {
				if (yych <= '@') goto yy645;
				if (yych <= 'Z') goto yy164;
			}
		} else {
			if (yych <= '`') {
				if (yych <= '_') goto yy164;
			} else {
				if (yych <= 'z') goto yy164;
				if (yych >= 0x80) goto yy164;
			}
		}
yy645:
		YYDEBUG(645, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(646, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 1);
	HANDLE_NEWLINES(yytext, yyleng);
	RETURN_TOKEN(T_YIELD_FROM);
}
yy647:
		YYDEBUG(647, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'T') {
			if (yych == 'Q') goto yy649;
			if (yych <= 'S') goto yy162;
		} else {
			if (yych <= 'q') {
				if (yych <= 'p') goto yy162;
				goto yy649;
			} else {
				if (yych != 't') goto yy162;
			}
		}
		YYDEBUG(648, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy661;
		if (yych == 'u') goto yy661;
		goto yy162;
yy649:
		YYDEBUG(649, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy650;
		if (yych != 'u') goto yy162;
yy650:
		YYDEBUG(650, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy651;
		if (yych != 'i') goto yy162;
yy651:
		YYDEBUG(651, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy652;
		if (yych != 'r') goto yy162;
yy652:
		YYDEBUG(652, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy653;
		if (yych != 'e') goto yy162;
yy653:
		YYDEBUG(653, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '^') {
			if (yych <= '9') {
				if (yych >= '0') goto yy161;
			} else {
				if (yych <= '@') goto yy654;
				if (yych <= 'Z') goto yy161;
			}
		} else {
			if (yych <= '`') {
				if (yych <= '_') goto yy655;
			} else {
				if (yych <= 'z') goto yy161;
				if (yych >= 0x80) goto yy161;
			}
		}
yy654:
		YYDEBUG(654, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_REQUIRE);
}
yy655:
		YYDEBUG(655, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy656;
		if (yych != 'o') goto yy162;
yy656:
		YYDEBUG(656, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy657;
		if (yych != 'n') goto yy162;
yy657:
		YYDEBUG(657, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy658;
		if (yych != 'c') goto yy162;
yy658:
		YYDEBUG(658, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy659;
		if (yych != 'e') goto yy162;
yy659:
		YYDEBUG(659, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy161;
		}
		YYDEBUG(660, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_REQUIRE_ONCE);
}
yy661:
		YYDEBUG(661, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy662;
		if (yych != 'r') goto yy162;
yy662:
		YYDEBUG(662, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy663;
		if (yych != 'n') goto yy162;
yy663:
		YYDEBUG(663, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy161;
		}
		YYDEBUG(664, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_RETURN);
}
yy665:
		YYDEBUG(665, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'T') {
			if (yych <= 'L') {
				if (yych <= 'K') goto yy162;
				goto yy688;
			} else {
				if (yych <= 'R') goto yy162;
				if (yych <= 'S') goto yy687;
				goto yy686;
			}
		} else {
			if (yych <= 'r') {
				if (yych == 'l') goto yy688;
				goto yy162;
			} else {
				if (yych <= 's') goto yy687;
				if (yych <= 't') goto yy686;
				goto yy162;
			}
		}
yy666:
		YYDEBUG(666, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'O') {
			if (yych == 'A') goto yy678;
			if (yych <= 'N') goto yy162;
			goto yy679;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy162;
				goto yy678;
			} else {
				if (yych == 'o') goto yy679;
				goto yy162;
			}
		}
yy667:
		YYDEBUG(667, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy668;
		if (yych != 'n') goto yy162;
yy668:
		YYDEBUG(668, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'T') {
			if (yych <= 'R') goto yy162;
			if (yych >= 'T') goto yy670;
		} else {
			if (yych <= 'r') goto yy162;
			if (yych <= 's') goto yy669;
			if (yych <= 't') goto yy670;
			goto yy162;
		}
yy669:
		YYDEBUG(669, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy676;
		if (yych == 't') goto yy676;
		goto yy162;
yy670:
		YYDEBUG(670, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy671;
		if (yych != 'i') goto yy162;
yy671:
		YYDEBUG(671, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy672;
		if (yych != 'n') goto yy162;
yy672:
		YYDEBUG(672, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy673;
		if (yych != 'u') goto yy162;
yy673:
		YYDEBUG(673, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy674;
		if (yych != 'e') goto yy162;
yy674:
		YYDEBUG(674, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy161;
		}
		YYDEBUG(675, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_CONTINUE);
}
yy676:
		YYDEBUG(676, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy161;
		}
		YYDEBUG(677, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_CONST);
}
yy678:
		YYDEBUG(678, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy683;
		if (yych == 's') goto yy683;
		goto yy162;
yy679:
		YYDEBUG(679, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy680;
		if (yych != 'n') goto yy162;
yy680:
		YYDEBUG(680, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy681;
		if (yych != 'e') goto yy162;
yy681:
		YYDEBUG(681, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy161;
		}
		YYDEBUG(682, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_CLONE);
}
yy683:
		YYDEBUG(683, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy684;
		if (yych != 's') goto yy162;
yy684:
		YYDEBUG(684, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy161;
		}
		YYDEBUG(685, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_CLASS);
}
yy686:
		YYDEBUG(686, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy697;
		if (yych == 'c') goto yy697;
		goto yy162;
yy687:
		YYDEBUG(687, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy695;
		if (yych == 'e') goto yy695;
		goto yy162;
yy688:
		YYDEBUG(688, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy689;
		if (yych != 'l') goto yy162;
yy689:
		YYDEBUG(689, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy690;
		if (yych != 'a') goto yy162;
yy690:
		YYDEBUG(690, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'B') goto yy691;
		if (yych != 'b') goto yy162;
yy691:
		YYDEBUG(691, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy692;
		if (yych != 'l') goto yy162;
yy692:
		YYDEBUG(692, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy693;
		if (yych != 'e') goto yy162;
yy693:
		YYDEBUG(693, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy161;
		}
		YYDEBUG(694, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_CALLABLE);
}
yy695:
		YYDEBUG(695, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy161;
		}
		YYDEBUG(696, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_CASE);
}
yy697:
		YYDEBUG(697, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy698;
		if (yych != 'h') goto yy162;
yy698:
		YYDEBUG(698, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy161;
		}
		YYDEBUG(699, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_CATCH);
}
yy700:
		YYDEBUG(700, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy719;
		if (yych == 'n') goto yy719;
		goto yy162;
yy701:
		YYDEBUG(701, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy161;
		}
		YYDEBUG(702, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_FN);
}
yy703:
		YYDEBUG(703, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy712;
		if (yych == 'r') goto yy712;
		goto yy162;
yy704:
		YYDEBUG(704, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy705;
		if (yych != 'n') goto yy162;
yy705:
		YYDEBUG(705, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy706;
		if (yych != 'c') goto yy162;
yy706:
		YYDEBUG(706, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy707;
		if (yych != 't') goto yy162;
yy707:
		YYDEBUG(707, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy708;
		if (yych != 'i') goto yy162;
yy708:
		YYDEBUG(708, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy709;
		if (yych != 'o') goto yy162;
yy709:
		YYDEBUG(709, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy710;
		if (yych != 'n') goto yy162;
yy710:
		YYDEBUG(710, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy161;
		}
		YYDEBUG(711, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_FUNCTION);
}
yy712:
		YYDEBUG(712, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '^') {
			if (yych <= '@') {
				if (yych <= '/') goto yy713;
				if (yych <= '9') goto yy161;
			} else {
				if (yych == 'E') goto yy714;
				if (yych <= 'Z') goto yy161;
			}
		} else {
			if (yych <= 'd') {
				if (yych != '`') goto yy161;
			} else {
				if (yych <= 'e') goto yy714;
				if (yych <= 'z') goto yy161;
				if (yych >= 0x80) goto yy161;
			}
		}
yy713:
		YYDEBUG(713, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_FOR);
}
yy714:
		YYDEBUG(714, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy715;
		if (yych != 'a') goto yy162;
yy715:
		YYDEBUG(715, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy716;
		if (yych != 'c') goto yy162;
yy716:
		YYDEBUG(716, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy717;
		if (yych != 'h') goto yy162;
yy717:
		YYDEBUG(717, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy161;
		}
		YYDEBUG(718, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_FOREACH);
}
yy719:
		YYDEBUG(719, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy720;
		if (yych != 'a') goto yy162;
yy720:
		YYDEBUG(720, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy721;
		if (yych != 'l') goto yy162;
yy721:
		YYDEBUG(721, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '^') {
			if (yych <= '@') {
				if (yych <= '/') goto yy722;
				if (yych <= '9') goto yy161;
			} else {
				if (yych == 'L') goto yy723;
				if (yych <= 'Z') goto yy161;
			}
		} else {
			if (yych <= 'k') {
				if (yych != '`') goto yy161;
			} else {
				if (yych <= 'l') goto yy723;
				if (yych <= 'z') goto yy161;
				if (yych >= 0x80) goto yy161;
			}
		}
yy722:
		YYDEBUG(722, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_FINAL);
}
yy723:
		YYDEBUG(723, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'Y') goto yy724;
		if (yych != 'y') goto yy162;
yy724:
		YYDEBUG(724, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy161;
		}
		YYDEBUG(725, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_FINALLY);
}
yy726:
		YYDEBUG(726, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'F') {
			if (yych == 'C') goto yy732;
			if (yych <= 'E') goto yy162;
			goto yy733;
		} else {
			if (yych <= 'c') {
				if (yych <= 'b') goto yy162;
				goto yy732;
			} else {
				if (yych == 'f') goto yy733;
				goto yy162;
			}
		}
yy727:
		YYDEBUG(727, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy730;
		if (yych == 'e') goto yy730;
		goto yy162;
yy728:
		YYDEBUG(728, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy161;
		}
		YYDEBUG(729, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_DO);
}
yy730:
		YYDEBUG(730, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy161;
		}
		YYDEBUG(731, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_EXIT);
}
yy732:
		YYDEBUG(732, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy739;
		if (yych == 'l') goto yy739;
		goto yy162;
yy733:
		YYDEBUG(733, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy734;
		if (yych != 'a') goto yy162;
yy734:
		YYDEBUG(734, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy735;
		if (yych != 'u') goto yy162;
yy735:
		YYDEBUG(735, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy736;
		if (yych != 'l') goto yy162;
yy736:
		YYDEBUG(736, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy737;
		if (yych != 't') goto yy162;
yy737:
		YYDEBUG(737, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy161;
		}
		YYDEBUG(738, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_DEFAULT);
}
yy739:
		YYDEBUG(739, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy740;
		if (yych != 'a') goto yy162;
yy740:
		YYDEBUG(740, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy741;
		if (yych != 'r') goto yy162;
yy741:
		YYDEBUG(741, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy742;
		if (yych != 'e') goto yy162;
yy742:
		YYDEBUG(742, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy161;
		}
		YYDEBUG(743, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_DECLARE);
}
yy744:
		YYDEBUG(744, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy806;
		if (yych == 'h') goto yy806;
		goto yy162;
yy745:
		YYDEBUG(745, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy800;
		if (yych == 's') goto yy800;
		goto yy162;
yy746:
		YYDEBUG(746, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy796;
		if (yych == 'p') goto yy796;
		goto yy162;
yy747:
		YYDEBUG(747, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy762;
		if (yych == 'd') goto yy762;
		goto yy162;
yy748:
		YYDEBUG(748, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy759;
		if (yych == 'a') goto yy759;
		goto yy162;
yy749:
		YYDEBUG(749, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'T') {
			if (yych == 'I') goto yy750;
			if (yych <= 'S') goto yy162;
			goto yy751;
		} else {
			if (yych <= 'i') {
				if (yych <= 'h') goto yy162;
			} else {
				if (yych == 't') goto yy751;
				goto yy162;
			}
		}
yy750:
		YYDEBUG(750, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy757;
		if (yych == 't') goto yy757;
		goto yy162;
yy751:
		YYDEBUG(751, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy752;
		if (yych != 'e') goto yy162;
yy752:
		YYDEBUG(752, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy753;
		if (yych != 'n') goto yy162;
yy753:
		YYDEBUG(753, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy754;
		if (yych != 'd') goto yy162;
yy754:
		YYDEBUG(754, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy755;
		if (yych != 's') goto yy162;
yy755:
		YYDEBUG(755, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy161;
		}
		YYDEBUG(756, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_EXTENDS);
}
yy757:
		YYDEBUG(757, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy161;
		}
		YYDEBUG(758, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_EXIT);
}
yy759:
		YYDEBUG(759, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy760;
		if (yych != 'l') goto yy162;
yy760:
		YYDEBUG(760, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy161;
		}
		YYDEBUG(761, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_EVAL);
}
yy762:
		YYDEBUG(762, *YYCURSOR);
		yych = *++YYCURSOR;
		YYDEBUG(-1, yych);
		switch (yych) {
		case 'D':
		case 'd':	goto yy763;
		case 'F':
		case 'f':	goto yy764;
		case 'I':
		case 'i':	goto yy765;
		case 'S':
		case 's':	goto yy766;
		case 'W':
		case 'w':	goto yy767;
		default:	goto yy162;
		}
yy763:
		YYDEBUG(763, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy789;
		if (yych == 'e') goto yy789;
		goto yy162;
yy764:
		YYDEBUG(764, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy781;
		if (yych == 'o') goto yy781;
		goto yy162;
yy765:
		YYDEBUG(765, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'F') goto yy779;
		if (yych == 'f') goto yy779;
		goto yy162;
yy766:
		YYDEBUG(766, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'W') goto yy773;
		if (yych == 'w') goto yy773;
		goto yy162;
yy767:
		YYDEBUG(767, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy768;
		if (yych != 'h') goto yy162;
yy768:
		YYDEBUG(768, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy769;
		if (yych != 'i') goto yy162;
yy769:
		YYDEBUG(769, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy770;
		if (yych != 'l') goto yy162;
yy770:
		YYDEBUG(770, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy771;
		if (yych != 'e') goto yy162;
yy771:
		YYDEBUG(771, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy161;
		}
		YYDEBUG(772, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_ENDWHILE);
}
yy773:
		YYDEBUG(773, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy774;
		if (yych != 'i') goto yy162;
yy774:
		YYDEBUG(774, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy775;
		if (yych != 't') goto yy162;
yy775:
		YYDEBUG(775, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy776;
		if (yych != 'c') goto yy162;
yy776:
		YYDEBUG(776, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy777;
		if (yych != 'h') goto yy162;
yy777:
		YYDEBUG(777, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy161;
		}
		YYDEBUG(778, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_ENDSWITCH);
}
yy779:
		YYDEBUG(779, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy161;
		}
		YYDEBUG(780, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_ENDIF);
}
yy781:
		YYDEBUG(781, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy782;
		if (yych != 'r') goto yy162;
yy782:
		YYDEBUG(782, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '^') {
			if (yych <= '@') {
				if (yych <= '/') goto yy783;
				if (yych <= '9') goto yy161;
			} else {
				if (yych == 'E') goto yy784;
				if (yych <= 'Z') goto yy161;
			}
		} else {
			if (yych <= 'd') {
				if (yych != '`') goto yy161;
			} else {
				if (yych <= 'e') goto yy784;
				if (yych <= 'z') goto yy161;
				if (yych >= 0x80) goto yy161;
			}
		}
yy783:
		YYDEBUG(783, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_ENDFOR);
}
yy784:
		YYDEBUG(784, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy785;
		if (yych != 'a') goto yy162;
yy785:
		YYDEBUG(785, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy786;
		if (yych != 'c') goto yy162;
yy786:
		YYDEBUG(786, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy787;
		if (yych != 'h') goto yy162;
yy787:
		YYDEBUG(787, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy161;
		}
		YYDEBUG(788, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_ENDFOREACH);
}
yy789:
		YYDEBUG(789, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy790;
		if (yych != 'c') goto yy162;
yy790:
		YYDEBUG(790, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy791;
		if (yych != 'l') goto yy162;
yy791:
		YYDEBUG(791, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy792;
		if (yych != 'a') goto yy162;
yy792:
		YYDEBUG(792, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy793;
		if (yych != 'r') goto yy162;
yy793:
		YYDEBUG(793, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy794;
		if (yych != 'e') goto yy162;
yy794:
		YYDEBUG(794, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy161;
		}
		YYDEBUG(795, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_ENDDECLARE);
}
yy796:
		YYDEBUG(796, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy797;
		if (yych != 't') goto yy162;
yy797:
		YYDEBUG(797, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'Y') goto yy798;
		if (yych != 'y') goto yy162;
yy798:
		YYDEBUG(798, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy161;
		}
		YYDEBUG(799, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_EMPTY);
}
yy800:
		YYDEBUG(800, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy801;
		if (yych != 'e') goto yy162;
yy801:
		YYDEBUG(801, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '^') {
			if (yych <= '@') {
				if (yych <= '/') goto yy802;
				if (yych <= '9') goto yy161;
			} else {
				if (yych == 'I') goto yy803;
				if (yych <= 'Z') goto yy161;
			}
		} else {
			if (yych <= 'h') {
				if (yych != '`') goto yy161;
			} else {
				if (yych <= 'i') goto yy803;
				if (yych <= 'z') goto yy161;
				if (yych >= 0x80) goto yy161;
			}
		}
yy802:
		YYDEBUG(802, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_ELSE);
}
yy803:
		YYDEBUG(803, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'F') goto yy804;
		if (yych != 'f') goto yy162;
yy804:
		YYDEBUG(804, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy161;
		}
		YYDEBUG(805, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_ELSEIF);
}
yy806:
		YYDEBUG(806, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy807;
		if (yych != 'o') goto yy162;
yy807:
		YYDEBUG(807, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy161;
		}
		YYDEBUG(808, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_ECHO);
}
	}
/* *********************************** */
yyc_ST_LOOKING_FOR_PROPERTY:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128,   0,   0, 128,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,   0,   0,   0,   0,   0,   0, 
			  0,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,   0,   0,   0,   0,  64, 
			  0,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,   0,   0,   0,   0,   0, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
		};
		YYDEBUG(809, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '-') {
			if (yych <= '\r') {
				if (yych <= 0x08) goto yy817;
				if (yych <= '\n') goto yy811;
				if (yych <= '\f') goto yy817;
			} else {
				if (yych == ' ') goto yy811;
				if (yych <= ',') goto yy817;
				goto yy813;
			}
		} else {
			if (yych <= '_') {
				if (yych <= '@') goto yy817;
				if (yych <= 'Z') goto yy815;
				if (yych <= '^') goto yy817;
				goto yy815;
			} else {
				if (yych <= '`') goto yy817;
				if (yych <= 'z') goto yy815;
				if (yych <= 0x7F) goto yy817;
				goto yy815;
			}
		}
yy811:
		YYDEBUG(811, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy823;
yy812:
		YYDEBUG(812, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	goto return_whitespace;
}
yy813:
		YYDEBUG(813, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '>') goto yy820;
yy814:
		YYDEBUG(814, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(0);
	yy_pop_state();
	goto restart;
}
yy815:
		YYDEBUG(815, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy819;
yy816:
		YYDEBUG(816, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_pop_state();
	RETURN_TOKEN_WITH_STR(T_STRING, 0);
}
yy817:
		YYDEBUG(817, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy814;
yy818:
		YYDEBUG(818, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy819:
		YYDEBUG(819, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy818;
		}
		goto yy816;
yy820:
		YYDEBUG(820, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(821, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_OBJECT_OPERATOR);
}
yy822:
		YYDEBUG(822, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy823:
		YYDEBUG(823, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy822;
		}
		goto yy812;
	}
/* *********************************** */
yyc_ST_LOOKING_FOR_VARNAME:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(824, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy828;
			if (yych <= 'Z') goto yy826;
			if (yych <= '^') goto yy828;
		} else {
			if (yych <= '`') goto yy828;
			if (yych <= 'z') goto yy826;
			if (yych <= 0x7F) goto yy828;
		}
yy826:
		YYDEBUG(826, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '_') {
			if (yych <= '@') {
				if (yych <= '/') goto yy827;
				if (yych <= '9') goto yy830;
			} else {
				if (yych <= '[') goto yy830;
				if (yych >= '_') goto yy830;
			}
		} else {
			if (yych <= '|') {
				if (yych <= '`') goto yy827;
				if (yych <= 'z') goto yy830;
			} else {
				if (yych <= '}') goto yy830;
				if (yych >= 0x80) goto yy830;
			}
		}
yy827:
		YYDEBUG(827, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(0);
	yy_pop_state();
	yy_push_state(ST_IN_SCRIPTING);
	goto restart;
}
yy828:
		YYDEBUG(828, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy827;
yy829:
		YYDEBUG(829, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy830:
		YYDEBUG(830, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy829;
		}
		if (yych == '[') goto yy832;
		if (yych == '}') goto yy832;
		YYDEBUG(831, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy827;
yy832:
		YYDEBUG(832, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(833, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 1);
	yy_pop_state();
	yy_push_state(ST_IN_SCRIPTING);
	RETURN_TOKEN_WITH_STR(T_STRING_VARNAME, 0);
}
	}
/* *********************************** */
yyc_ST_NOWDOC:
	YYDEBUG(834, *YYCURSOR);
	YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(836, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(837, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	zend_heredoc_label *heredoc_label = zend_ptr_stack_top(&SCNG(heredoc_label_stack));
	int newline = 0, indentation = 0, spacing = -1;

	if (YYCURSOR > YYLIMIT) {
		RETURN_TOKEN(END);
	}

	YYCURSOR--;

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '\r':
				if (*YYCURSOR == '\n') {
					YYCURSOR++;
				}
				/* fall through */
			case '\n':
				indentation = spacing = 0;

				while (YYCURSOR < YYLIMIT && (*YYCURSOR == ' ' || *YYCURSOR == '\t')) {
					if (*YYCURSOR == '\t') {
						spacing |= HEREDOC_USING_TABS;
					} else {
						spacing |= HEREDOC_USING_SPACES;
					}
					++YYCURSOR;
					++indentation;
				}

				if (YYCURSOR == YYLIMIT) {
					yyleng = YYCURSOR - SCNG(yy_text);
					HANDLE_NEWLINES(yytext, yyleng);
					ZVAL_NULL(zendlval);
					RETURN_TOKEN_WITH_VAL(T_ENCAPSED_AND_WHITESPACE);
				}

				/* Check for ending label on the next line */
				if (IS_LABEL_START(*YYCURSOR) && heredoc_label->length < YYLIMIT - YYCURSOR && !memcmp(YYCURSOR, heredoc_label->label, heredoc_label->length)) {
					if (IS_LABEL_SUCCESSOR(YYCURSOR[heredoc_label->length])) {
						continue;
					}

					if (spacing == (HEREDOC_USING_SPACES | HEREDOC_USING_TABS)) {
						zend_throw_exception(zend_ce_parse_error, "Invalid indentation - tabs and spaces cannot be mixed", 0);
						if (PARSER_MODE()) {
							RETURN_TOKEN(T_ERROR);
						}
					}

					/* newline before label will be subtracted from returned text, but
					 * yyleng/yytext will include it, for zend_highlight/strip, tokenizer, etc. */
					if (YYCURSOR[-indentation - 2] == '\r' && YYCURSOR[-indentation - 1] == '\n') {
						newline = 2; /* Windows newline */
					} else {
						newline = 1;
					}

					CG(increment_lineno) = 1; /* For newline before label */

					YYCURSOR -= indentation;
					heredoc_label->indentation = indentation;

					BEGIN(ST_END_HEREDOC);

					goto nowdoc_scan_done;
				}
				/* fall through */
			default:
				continue;
		}
	}

nowdoc_scan_done:
	yyleng = YYCURSOR - SCNG(yy_text);
	ZVAL_STRINGL(zendlval, yytext, yyleng - newline);

	if (!EG(exception) && spacing != -1 && PARSER_MODE()) {
		zend_bool newline_at_start = *(yytext - 1) == '\n' || *(yytext - 1) == '\r';
		if (!strip_multiline_string_indentation(
				zendlval, indentation, spacing == HEREDOC_USING_SPACES,
				newline_at_start, newline != 0)) {
			RETURN_TOKEN(T_ERROR);
		}
	}

	HANDLE_NEWLINES(yytext, yyleng - newline);
	RETURN_TOKEN_WITH_VAL(T_ENCAPSED_AND_WHITESPACE);
}
/* *********************************** */
yyc_ST_VAR_OFFSET:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			240, 240, 112, 112, 112, 112, 112, 112, 
			112, 112,   0,   0,   0,   0,   0,   0, 
			  0,  80,  80,  80,  80,  80,  80,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,   0,   0,   0,   0,  16, 
			  0,  80,  80,  80,  80,  80,  80,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,   0,   0,   0,   0,   0, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
		};
		YYDEBUG(838, *YYCURSOR);
		YYFILL(3);
		yych = *YYCURSOR;
		if (yych <= '0') {
			if (yych <= ' ') {
				if (yych <= '\f') {
					if (yych <= 0x08) goto yy852;
					if (yych <= '\n') goto yy848;
					goto yy852;
				} else {
					if (yych <= '\r') goto yy848;
					if (yych <= 0x1F) goto yy852;
					goto yy848;
				}
			} else {
				if (yych <= '$') {
					if (yych <= '"') goto yy847;
					if (yych <= '#') goto yy848;
					goto yy843;
				} else {
					if (yych == '\'') goto yy848;
					if (yych <= '/') goto yy847;
				}
			}
		} else {
			if (yych <= ']') {
				if (yych <= 'Z') {
					if (yych <= '9') goto yy842;
					if (yych <= '@') goto yy847;
					goto yy850;
				} else {
					if (yych <= '[') goto yy847;
					if (yych <= '\\') goto yy848;
					goto yy845;
				}
			} else {
				if (yych <= '`') {
					if (yych == '_') goto yy850;
					goto yy847;
				} else {
					if (yych <= 'z') goto yy850;
					if (yych <= '~') goto yy847;
					if (yych <= 0x7F) goto yy852;
					goto yy850;
				}
			}
		}
		YYDEBUG(840, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'X') {
			if (yych <= 'A') {
				if (yych <= '/') goto yy841;
				if (yych <= '9') goto yy868;
			} else {
				if (yych <= 'B') goto yy866;
				if (yych >= 'X') goto yy867;
			}
		} else {
			if (yych <= 'a') {
				if (yych == '_') goto yy859;
			} else {
				if (yych <= 'b') goto yy866;
				if (yych == 'x') goto yy867;
			}
		}
yy841:
		YYDEBUG(841, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Offset could be treated as a long */
	if (yyleng < MAX_LENGTH_OF_LONG - 1 || (yyleng == MAX_LENGTH_OF_LONG - 1 && strcmp(yytext, long_min_digits) < 0)) {
		char *end;
		errno = 0;
		ZVAL_LONG(zendlval, ZEND_STRTOL(yytext, &end, 10));
		if (errno == ERANGE) {
			goto string;
		}
		ZEND_ASSERT(end == yytext + yyleng);
	} else {
string:
		ZVAL_STRINGL(zendlval, yytext, yyleng);
	}
	RETURN_TOKEN_WITH_VAL(T_NUM_STRING);
}
yy842:
		YYDEBUG(842, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		goto yy862;
yy843:
		YYDEBUG(843, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '_') {
			if (yych <= '@') goto yy844;
			if (yych <= 'Z') goto yy856;
			if (yych >= '_') goto yy856;
		} else {
			if (yych <= '`') goto yy844;
			if (yych <= 'z') goto yy856;
			if (yych >= 0x80) goto yy856;
		}
yy844:
		YYDEBUG(844, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	/* Only '[' or '-' can be valid, but returning other tokens will allow a more explicit parse error */
	RETURN_TOKEN(yytext[0]);
}
yy845:
		YYDEBUG(845, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(846, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_pop_state();
	RETURN_TOKEN(']');
}
yy847:
		YYDEBUG(847, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy844;
yy848:
		YYDEBUG(848, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(849, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	/* Invalid rule to return a more explicit parse error with proper line number */
	yyless(0);
	yy_pop_state();
	ZVAL_NULL(zendlval);
	RETURN_TOKEN_WITH_VAL(T_ENCAPSED_AND_WHITESPACE);
}
yy850:
		YYDEBUG(850, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy855;
yy851:
		YYDEBUG(851, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_STR(T_STRING, 0);
}
yy852:
		YYDEBUG(852, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(853, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (YYCURSOR > YYLIMIT) {
		RETURN_TOKEN(END);
	}

	if (!SCNG(heredoc_scan_ahead)) {
		zend_error(E_COMPILE_WARNING, "Unexpected character in input:  '%c' (ASCII=%d) state=%d", yytext[0], yytext[0], YYSTATE);
	}
	if (PARSER_MODE()) {
		goto restart;
	} else {
		RETURN_TOKEN(T_BAD_CHARACTER);
	}
}
yy854:
		YYDEBUG(854, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy855:
		YYDEBUG(855, *YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy854;
		}
		goto yy851;
yy856:
		YYDEBUG(856, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(857, *YYCURSOR);
		if (yych <= '^') {
			if (yych <= '9') {
				if (yych >= '0') goto yy856;
			} else {
				if (yych <= '@') goto yy858;
				if (yych <= 'Z') goto yy856;
			}
		} else {
			if (yych <= '`') {
				if (yych <= '_') goto yy856;
			} else {
				if (yych <= 'z') goto yy856;
				if (yych >= 0x80) goto yy856;
			}
		}
yy858:
		YYDEBUG(858, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy859:
		YYDEBUG(859, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '/') goto yy860;
		if (yych <= '9') goto yy863;
yy860:
		YYDEBUG(860, *YYCURSOR);
		YYCURSOR = YYMARKER;
		if (yyaccept <= 0) {
			goto yy841;
		} else {
			goto yy865;
		}
yy861:
		YYDEBUG(861, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy862:
		YYDEBUG(862, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy861;
		}
		if (yych == '_') goto yy859;
		goto yy841;
yy863:
		YYDEBUG(863, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(864, *YYCURSOR);
		if (yych <= '/') goto yy865;
		if (yych <= '9') goto yy863;
		if (yych == '_') goto yy859;
yy865:
		YYDEBUG(865, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Offset must be treated as a string */
	if (yyleng == 1) {
		ZVAL_INTERNED_STR(zendlval, ZSTR_CHAR((zend_uchar)*(yytext)));
	} else {
		ZVAL_STRINGL(zendlval, yytext, yyleng);
	}
	RETURN_TOKEN_WITH_VAL(T_NUM_STRING);
}
yy866:
		YYDEBUG(866, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy875;
		}
		goto yy860;
yy867:
		YYDEBUG(867, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy870;
		}
		goto yy860;
yy868:
		YYDEBUG(868, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(869, *YYCURSOR);
		if (yych <= '/') goto yy865;
		if (yych <= '9') goto yy868;
		if (yych == '_') goto yy859;
		goto yy865;
yy870:
		YYDEBUG(870, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(871, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy870;
		}
		if (yych != '_') goto yy865;
yy872:
		YYDEBUG(872, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy860;
			if (yych >= ':') goto yy860;
		} else {
			if (yych <= 'F') goto yy873;
			if (yych <= '`') goto yy860;
			if (yych >= 'g') goto yy860;
		}
yy873:
		YYDEBUG(873, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(874, *YYCURSOR);
		if (yych <= 'F') {
			if (yych <= '/') goto yy865;
			if (yych <= '9') goto yy873;
			if (yych <= '@') goto yy865;
			goto yy873;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy865;
				goto yy872;
			} else {
				if (yych <= '`') goto yy865;
				if (yych <= 'f') goto yy873;
				goto yy865;
			}
		}
yy875:
		YYDEBUG(875, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(876, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy875;
		}
		if (yych != '_') goto yy865;
yy877:
		YYDEBUG(877, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '/') goto yy860;
		if (yych >= '2') goto yy860;
yy878:
		YYDEBUG(878, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(879, *YYCURSOR);
		if (yych <= '/') goto yy865;
		if (yych <= '1') goto yy878;
		if (yych == '_') goto yy877;
		goto yy865;
	}
}


emit_token_with_str:
	zend_copy_value(zendlval, (yytext + offset), (yyleng - offset));

emit_token_with_val:
	if (PARSER_MODE()) {
		ZEND_ASSERT(Z_TYPE_P(zendlval) != IS_UNDEF);
		elem->ast = zend_ast_create_zval_with_lineno(zendlval, start_line);
	}

emit_token:
	if (SCNG(on_event)) {
		SCNG(on_event)(ON_TOKEN, token, start_line, SCNG(on_event_context));
	}
	return token;

return_whitespace:
	HANDLE_NEWLINES(yytext, yyleng);
	if (SCNG(on_event)) {
		SCNG(on_event)(ON_TOKEN, T_WHITESPACE, start_line, SCNG(on_event_context));
	}
	if (PARSER_MODE()) {
		start_line = CG(zend_lineno);
		goto restart;
	} else {
		return T_WHITESPACE;
	}

skip_token:
	if (SCNG(on_event)) {
		SCNG(on_event)(ON_TOKEN, token, start_line, SCNG(on_event_context));
	}
	start_line = CG(zend_lineno);
	goto restart;
}
