<?php

/**
 * BackgroundProcess
 *
 * Runs a process in the background.
 *
 * @package   BraincraftedBackgroundProcess
 * @author    Florian Eckerstorfer <florian@eckerstorfer.co>
 * @copyright 2013 Florian Eckerstorfer
 * @license   http://opensource.org/licenses/MIT The MIT License
 * @link      http://braincrafted.com/php-background-processes/ Running background processes in PHP
 */
class BackgroundProcess
{
    /** @var string */
    private $command;

    /** @var integer */
    private $pid;

    /** @var string */
    private $outputFile;

    /** @var string */
    private $timestamp;

    /**
     * Constructor.
     *
     * @param string $command The command to execute
     */
    public function __construct($command)
    {
        $this->command = escapeshellcmd($command);
    }

    /**
     * Runs the command in a background process.
     *
     * @param string $outputFile File to write the output of the process to; defaults to /dev/null
     *
     * @return void
     */
    public function run()
    {
        $this->outputFile = strstr(
            trim(
                shell_exec(
                    '/usr/local/directadmin/plugins/custombuild/admin/build background ' . $this->command . ' &'
                )
            ),
            ' ',
            true
        );
        $numofdots = substr_count($this->outputFile, '.'); // must be 2
        if ($numofdots != 2) {
            die('Background process has not been started!');
        }
        $getpid = explode(".", $this->outputFile);
        $this->pid = $getpid[1];
        $this->timestamp = $getpid[0];
    }

    /**
     * Returns if the process is currently running.
     *
     * @return boolean TRUE if the process is running, FALSE if not.
     */
    public function isRunning()
    {
        return (bool)posix_getpgid($this->pid);
    }

    /**
     * Returns the ID of the process.
     *
     * @return integer The ID of the process
     */
    public function getPid()
    {
        return $this->pid;
    }

    /**
     * @param $pid
     */
    public function setPid($pid)
    {
        $this->pid = $pid;
    }

    public function getOutputFile()
    {
        return $this->outputFile;
    }

    public function getTimestamp()
    {
        return $this->timestamp;
    }
}

?>
