import { url } from '~/api';
import { NativeEventSource, EventSourcePolyfill } from 'event-source-polyfill';

const EventSource = NativeEventSource || EventSourcePolyfill;

export default ({ commit, state, dispatch }, { command, onDone }) => new Promise(
    (resolve, reject) => {
        // Initial data setup
        commit('SET_UPDATE_LOG', '');
        commit('SET_UPDATE_STATUS', true);
        commit('SET_UPDATE_PID', 0);

        commit('SET_UPDATE_COMMAND', command);

        const source = new EventSource(
            `${url('build_software_command_sse')}?command=${command}`,
            { withCredentials: true },
        );

        const closeSource = () => {
            commit('SET_UPDATE_STATUS', false);
            commit('SET_UPDATE_PID', 0);
            source.close();
            if (onDone) {
                dispatch(onDone);
            }
            resolve(state.updateCommandData.log);
        };

        source.addEventListener(
            'message',
            (e) => {
                const { data, finished, pid } = JSON.parse(e.data);
                if (finished) {
                    closeSource();
                }
                if (pid && pid !== '0') {
                    commit('SET_UPDATE_PID', Number(pid));
                }
                if (data) {
                    commit('SET_UPDATE_LOG', data);
                }
            },
            false
        );

        source.addEventListener(
            'error',
            (e) => {
                if (e.readyState === EventSource.CLOSED) {
                    commit('SET_UPDATE_STATUS', false);
                    commit('SET_UPDATE_PID', 0);
                    reject(new Error('Connection was closed'));
                } else {
                    reject(new Error('EventSource Error'));
                }
            },
            false
        );
    }
);