<?php

function version_compare2($v1,$v2)
{
   if(preg_match('/.\d(\w+)/', $v1, $matchesv1) && preg_match('/.\d(\w+)/', $v2, $matchesv2))
   {
      $str1 = $matchesv1[1];
      $str2 = $matchesv2[1];
      if(version_compare(substr($v1,0,-1), substr($v2,0,-1)) == 0)
      {
          return strcmp($str1 ,$str2);
      }
   }
   return version_compare($v1,$v2);
}

function parseFile($contents){

    $contents = preg_replace('/^#.*\\n/m','',$contents);
    $params = explode("\n", $contents);
    foreach($params as $param){

        $values = explode("=",$param);
        $configVals[$values[0]] = @$values[1];
    }

    return $configVals;
}

function printObjectItem($key, $value) {
    if(!empty($key) && !empty($value)) {
        $key = str_replace('-', '_', $key);
        echo "'$key'" . ":" . "'$value'" . ",";
    }
}

function inProgress()
{
    $pid = shell_exec("/usr/local/directadmin/plugins/custombuild/admin/build show_file lockfile");

    if($pid) {
        return trim($pid);
    } else {
        $logsDir = '/usr/local/directadmin/plugins/custombuild/logs/';
        $files = getLogFiles($logsDir);
        foreach($files as $file) {
            if(substr($file, 0, 4) == 'PID_') {
                unlink($logsDir . $file);
            }
        }
    }

    return false;
}

function getLogFiles($logsDir = '/usr/local/directadmin/plugins/custombuild/logs') {
    return scandir($logsDir, 1);
}

function getDirSize($path = '/usr/local/directadmin/plugins/custombuild/logs')
{
    $io = popen('/usr/bin/du -sb '.$path, 'r');
    $size = intval(fgets($io,80));
    pclose($io);
    return $size;
}

function formatBytes($bytes, $precision = 2) {
    $units = array('B', 'KB', 'MB', 'GB', 'TB');

    $bytes = max($bytes, 0);
    $pow = floor(($bytes ? log($bytes) : 0) / log(1024));
    $pow = min($pow, count($units) - 1);
    $bytes /= pow(1024, $pow);
    return round($bytes, $precision) . ' ' . $units[$pow];
}

function showViewLog($pid) {

    $pidFile = '/usr/local/directadmin/plugins/custombuild/logs/PID_'.trim($pid).'.log';
    if(file_exists($pidFile)) {
        $result = '<a href="#" class="showLogButton" data-log-file="'.file_get_contents($pidFile).'">View log</a>';
    } else {
        $result = 'Started from terminal.';
    }

    return $result;
}

function getAction($current, $offered)
{
    $comp = version_compare2($offered, $current);
    if($comp == -1) {
        return 'downgrade';
    }

    return 'update';
}

function makeDescription($text, $popover = false)
{
    $text = preg_replace(
        '@(https?://([-\w\.]+[-\w])+(:\d+)?(/([\w/_\.#-]*(\?\S+)?[^\.\s])?)?)@',
        "<a href='$1' target='_blank'>$1</a>",
        $text
    );
    $warning = strpos($text, 'WARNING:');
    if ($warning !== false) {
        if($popover) {
            $text = str_replace('WARNING:', '<span class="badge btn-danger" data-content="<strong class=\'text-danger bold\'>WARNING:', $text) . '</strong>">!</span>';
        } else {
            $text = str_replace('WARNING:', "<strong class='text-danger bold'>WARNING:", $text) . '</strong>';
        }
    }

    return $text;
}

?>
