<?php
    inProgress();
    $logFiles = getLogFiles();
    ini_set("precision", "16");
?>
<div class="panel panel-default">
    <div class="panel-heading">
        <strong>Log files list</strong>
        <em class="pull-right">Directory size: <?php echo formatBytes(getDirSize()); ?></em>
    </div>
    <div class="panel-body">
        <table class="table">
            <thead>
                <tr>
                    <th class="col-md-4">Filename</th>
                    <th class="col-md-4">Date</th>
                    <th class="col-md-2">File size</th>
                    <th class="col-md-2">Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php $timezone = trim(shell_exec("/usr/local/directadmin/plugins/custombuild/admin/build get_timezone")); ?>
                <?php if(count($logFiles) > 2) { ?>
                    <?php foreach($logFiles as $file) { ?>
                        <?php if(!in_array($file, array('.', '..')) && strpos($file, 'PID_') === false) { ?>
                            <tr>
                                <td><?php echo $file; $array = explode(".", $file); ?></td>
                                <td><?php $datetime = new \DateTime('now', new DateTimeZone($timezone)); $datetime->setTimestamp(preg_replace('/[^0-9]/', '', $array[0])); echo $datetime->format('Y-m-d H:i:s'); ?></td>
                                <td><?php echo formatBytes(filesize('/usr/local/directadmin/plugins/custombuild/logs/'.preg_replace('/[^0-9]/', '', $array[0]).'.'.preg_replace("/[^0-9]/", "", $array[1]).'.log')); ?></td>
                                <td>
                                    <button class="btn btn-success btn-sm previewButton" data-log="<?php echo preg_replace('/[^0-9]/', '', $array[0]).'.'.preg_replace('/[^0-9]/', '', $array[1]); ?>" title="Preview"><span class="glyphicon glyphicon-eye-open"></span></button>
                                    <button class="btn btn-danger btn-sm removeButton" data-log="<?php echo preg_replace('/[^0-9]/', '', $array[0]).'.'.preg_replace('/[^0-9]/', '', $array[1]); ?>" title="Delete"><span class="glyphicon glyphicon-trash"></span></button>
                                </td>
                            </tr>
                        <?php } ?>
                    <?php } ?>
                <?php } else { ?>
                    <tr>
                        <td colspan="2">No log files</td>
                    </tr>
                <?php } ?>
            </tbody>
        </table>
    </div>
    <div class="panel-footer">
        <strong>Auto-removal of log files: Every 1 week. To change the setting please edit /usr/local/directadmin/plugins/custombuild/tools/clearlogs.php</strong>
    </div>
</div>

<div class="modal fade" id="log-modal" tabindex="-1" role="dialog" aria-labelledby="myLogModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                <h4 class="modal-title" id="myLogModalLabel">Log preview</h4>
            </div>
            <div class="modal-body">
                <pre id="modal-log-body"></pre>
            </div>
            <div class="modal-footer">
                <button type="button" id="log-modal-close-button" class="btn btn-default" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
