<?php

function isDisabled($button, $value, $configData)
{

    if ($button == 'mod_ruid2' && $value == 'yes') {
        //Cannot be set to yes, if nginx webserver is chosen.
        if ($configData['webserver_settings']['webserver']['current'] == 'nginx') {
            return true;
        }
        //Cannot be set to "yes" if OS is FreeBSD
        if (trim(shell_exec("uname -r | cut -d- -f1")) == 'FreeBSD') {
            return true;
        }
        //php1_mode is set to fastcgi or php-fpm
        if (in_array($configData['php_settings']['php1_mode']['current'], array('fastcgi', 'php-fpm'))) {
            return true;
        }
        //php2_mode is set to fastcgi or php-fpm
        if (in_array(
                $configData['php_settings']['php2_mode']['current'],
                array('fastcgi', 'php-fpm')
            ) && $configData['php_settings']['php2_release']['current'] != 'no'
        ) {
            return true;
        }
    }

    if($button == 'webserver' && $value == 'nginx') {
        //nginx cannot be set as a webserver, if php1_mode is not set to "php-fpm"
        if($configData['php_settings']['php1_mode']['current'] != 'php-fpm') {
            return true;
        }
        //nginx cannot be set as a webserver, if php2_mode is not set to "php-fpm"
        if($configData['php_settings']['php1_mode']['current'] != 'php-fpm' &&
            $configData['php_settings']['php2_release']['current'] != 'no') {
            return true;
        }
    }

    if($button == 'php1_mode' && $value == 'mod_php') {
        //php1_mode and php2_mode cannot both be set to mod_php. Only 1 of them could be set to mod_php.
        if($configData['php_settings']['php2_mode']['current'] == 'mod_php') {
            return true;
        }
        if($configData['webserver_settings']['webserver']['current'] == 'nginx') {
            return true;
        }
    }

    if($button == 'php2_mode' && $value == 'mod_php') {
        //php1_mode and php2_mode cannot both be set to mod_php. Only 1 of them could be set to mod_php.
        if($configData['php_settings']['php1_mode']['current'] == 'mod_php') {
            return true;
        }
        if($configData['webserver_settings']['webserver']['current'] == 'nginx') {
            return true;
        }
    }

    //php1_release and php2_release cannot both be set to the same version (for example 5.3).
    if($button == 'php1_release') {
        if($configData['php_settings']['php2_release']['current'] == $value) {
            return true;
        }
    }

    //php1_release and php2_release cannot both be set to the same version (for example 5.3).
    if($button == 'php2_release') {
        if($configData['php_settings']['php1_release']['current'] == $value) {
            return true;
        }
    }

    if($button == 'suhosin_php_uploadscan' && $value == 'yes') {
        if($configData['php_settings']['suhosin']['current'] != 'yes' || $configData['clamav_settings']['clamav']['current'] != 'yes') {
            return true;
        }
    }

    if($button == 'pureftpd_uploadscan' && $value == 'yes') {
        if($configData['ftp_settings']['ftpd']['current'] != 'pureftpd' || $configData['clamav_settings']['clamav']['current'] != 'yes') {
            return true;
        }
    }


    return false;
}

function getValidationMessage($button, $value)
{
    $validations = array(
        'php2_release' => array($value => 'php1_release and php2_release cannot both be set to the same version (for example 5.3).')
    );

    if(isset($validations[$button][$value])) {
        return $validations[$button][$value];
    }
}

?>