const path = require("path");
const package = require("./package.json");
const TerserPlugin = require("terser-webpack-plugin");
const webpack = require("webpack");

const configGenerator = ({ branding }) => (_, { mode = "development" }) => {
  const config = {
    mode,
    entry: {
      admin: "./index.js",
    },
    output: {
      path: path.resolve(__dirname, "./dist"),
      filename: branding ? "[name]-branded.js" : "[name].js",
      library: package.name,
      libraryTarget: "window",
    },
    resolve: {
      extensions: [".js", ".vue", ".json"],
      modules: ["node_modules"],
      alias: {
        "~": path.resolve(__dirname, `./src`),
      },
    },
    module: {
      rules: [
        {
          test: /\.vue$/,
          loader: "vue-loader",
        },
        {
          test: /\.js$/,
          exclude: /node_modules/,
          loader: "babel-loader",
        },
      ],
    },
    plugins: [
      new webpack.DefinePlugin({
        SHOW_BRANDING: branding,
      }),
    ],
  };
  if (mode === "development") {
    config.devServer = {
      port: 9000,
      hot: false,
      https: true,
      headers: {
        "Access-Control-Allow-Origin": "*",
        "Access-Control-Allow-Methods":
          "GET, POST, PUT, DELETE, PATCH, OPTIONS",
        "Access-Control-Allow-Headers":
          "X-Requested-With, content-type, Authorization, X-DirectAdmin-Session-ID",
      },
    };
    return config;
  } else {
    config.performance = { hints: false };
    config.optimization = {
      minimize: true,
      minimizer: [
        new TerserPlugin({
          cache: true,
          parallel: true,
          sourceMap: true,
        }),
      ],
    };
    return config;
  }
};

module.exports = [
  configGenerator({
    branding: true,
  }),
  configGenerator({
    branding: false,
  }),
];
