#include "TH.h"
#include "THMath.h"
#include "luaT.h"
#include "utils.h"

static const void* torch_istensortype(lua_State *L, const char *tname)
{
  if(!tname)
    return NULL;

  if(!luaT_pushmetatable(L, tname))
    return NULL;

  lua_pushstring(L, "torch");
  lua_rawget(L, -2);
  if(lua_istable(L, -1))
    return tname;
  else
  {
    lua_pop(L, 2);
    return NULL;
  }

  return NULL;
}

static int torch_isnonemptytable(lua_State *L, int idx)
{
  int empty;
  if (!lua_istable(L, idx)) return 0;

  lua_rawgeti(L, idx, 1);
  empty = lua_isnil(L, -1);
  lua_pop(L, 1);
  return !empty;
}

static const void* torch_istensorarray(lua_State *L, int idx)
{
  const char* tname;
  int tensor_idx;
  if (!torch_isnonemptytable(L, idx)) return 0;

  lua_checkstack(L, 3);
  lua_rawgeti(L, idx, 1);
  tensor_idx = lua_gettop(L);
  tname = (torch_istensortype(L, luaT_typename(L, -1)));
  lua_remove(L, tensor_idx);
  return tname;
}

/* WARNING: autogenerated file */

#ifndef _CWRAP_STR_ARG_TYPES_4821726c1947cdf3eebacade98173939
#define _CWRAP_STR_ARG_TYPES_4821726c1947cdf3eebacade98173939
#include "string.h"
static void str_arg_types(lua_State *L, char *buf, int n) {
    int i;
  int nargs = lua_gettop(L);
  if (nargs == 0) {
    snprintf(buf, n, "no arguments provided");
    return;
  }
  for (i = 1; i <= nargs; i++) {
    int l;
    const char *torch_type = luaT_typename(L, i);
    if(torch_type && !strncmp(torch_type, "torch.", 6)) torch_type += 6;
    if (torch_type) l = snprintf(buf, n, "%s ", torch_type);
    else if(lua_isnil(L, i)) l = snprintf(buf, n, "%s ", "nil");
    else if(lua_isboolean(L, i)) l = snprintf(buf, n, "%s ", "boolean");
    else if(lua_isnumber(L, i)) l = snprintf(buf, n, "%s ", "number");
    else if(lua_isstring(L, i)) l = snprintf(buf, n, "%s ", "string");
    else if(lua_istable(L, i)) l = snprintf(buf, n, "%s ", "table");
    else if(lua_isuserdata(L, i)) l = snprintf(buf, n, "%s ", "userdata");
    else l = snprintf(buf, n, "%s ", "???");
    if (l >= n) return;
    buf += l;
    n   -= l;
  }
}
#endif
static int torch_ByteTensor_zero(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
if(narg == 1
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
)
{
arg1_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ByteTensor*", type_buf);
}
lua_pushvalue(L, arg1_idx);
THByteTensor_zero(arg1);
return 1;
}

static int torch_zero(lua_State *L)
{
  int narg = lua_gettop(L);
  const void *tname;
  if(narg >= 1 && (tname = torch_istensortype(L, luaT_typename(L, 1)))) /* first argument is tensor? */
  {
  }
  else if(narg >= 2 && (tname = torch_istensortype(L, luaT_typename(L, 2)))) /* second? */
  {
  }
  else if(narg >= 1 && (tname = torch_istensorarray(L, 1))) /* torch table argument? */
  {
  }
  else if(narg >= 1 && lua_type(L, narg) == LUA_TSTRING
	  && (tname = torch_istensortype(L, lua_tostring(L, narg)))) /* do we have a valid tensor type string then? */
  {
    lua_remove(L, -2);
  }
  else if(!(tname = torch_istensortype(L, torch_getdefaulttensortype(L))))
    luaL_error(L, "internal error: the default tensor type does not seem to be an actual tensor");

  lua_pushstring(L, "zero");
  lua_rawget(L, -2);
  if(lua_isfunction(L, -1))
  {
    lua_insert(L, 1);
    lua_pop(L, 2); /* the two tables we put on the stack above */
    lua_call(L, lua_gettop(L)-1, LUA_MULTRET);
  }
  else
    return luaL_error(L, "%s does not implement the torch.zero() function", tname);

  return lua_gettop(L);
}

static int torch_ByteTensor_fill(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
unsigned char arg2 = 0;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
)
{
arg1_idx = 1;
arg2 = (unsigned char)lua_tonumber(L, 2);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ByteTensor* unsigned char", type_buf);
}
lua_pushvalue(L, arg1_idx);
THByteTensor_fill(arg1,arg2);
return 1;
}

static int torch_fill(lua_State *L)
{
  int narg = lua_gettop(L);
  const void *tname;
  if(narg >= 1 && (tname = torch_istensortype(L, luaT_typename(L, 1)))) /* first argument is tensor? */
  {
  }
  else if(narg >= 2 && (tname = torch_istensortype(L, luaT_typename(L, 2)))) /* second? */
  {
  }
  else if(narg >= 1 && (tname = torch_istensorarray(L, 1))) /* torch table argument? */
  {
  }
  else if(narg >= 1 && lua_type(L, narg) == LUA_TSTRING
	  && (tname = torch_istensortype(L, lua_tostring(L, narg)))) /* do we have a valid tensor type string then? */
  {
    lua_remove(L, -2);
  }
  else if(!(tname = torch_istensortype(L, torch_getdefaulttensortype(L))))
    luaL_error(L, "internal error: the default tensor type does not seem to be an actual tensor");

  lua_pushstring(L, "fill");
  lua_rawget(L, -2);
  if(lua_isfunction(L, -1))
  {
    lua_insert(L, 1);
    lua_pop(L, 2); /* the two tables we put on the stack above */
    lua_call(L, lua_gettop(L)-1, LUA_MULTRET);
  }
  else
    return luaL_error(L, "%s does not implement the torch.fill() function", tname);

  return lua_gettop(L);
}

static int torch_ByteTensor_zeros(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THLongStorage *arg2 = NULL;
if(narg >= 1
&& torch_islongargs(L, 1)
)
{
arg2 = torch_checklongargs(L, 1);
arg1 = THByteTensor_new();
}
else if(narg >= 2
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& torch_islongargs(L, 2)
)
{
arg1_idx = 1;
arg2 = torch_checklongargs(L, 2);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] (LongStorage | dim1 [dim2...])", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THByteTensor_zeros(arg1,arg2);
THLongStorage_free(arg2);
return 1;
}

static int torch_zeros(lua_State *L)
{
  int narg = lua_gettop(L);
  const void *tname;
  if(narg >= 1 && (tname = torch_istensortype(L, luaT_typename(L, 1)))) /* first argument is tensor? */
  {
  }
  else if(narg >= 2 && (tname = torch_istensortype(L, luaT_typename(L, 2)))) /* second? */
  {
  }
  else if(narg >= 1 && (tname = torch_istensorarray(L, 1))) /* torch table argument? */
  {
  }
  else if(narg >= 1 && lua_type(L, narg) == LUA_TSTRING
	  && (tname = torch_istensortype(L, lua_tostring(L, narg)))) /* do we have a valid tensor type string then? */
  {
    lua_remove(L, -2);
  }
  else if(!(tname = torch_istensortype(L, torch_getdefaulttensortype(L))))
    luaL_error(L, "internal error: the default tensor type does not seem to be an actual tensor");

  lua_pushstring(L, "zeros");
  lua_rawget(L, -2);
  if(lua_isfunction(L, -1))
  {
    lua_insert(L, 1);
    lua_pop(L, 2); /* the two tables we put on the stack above */
    lua_call(L, lua_gettop(L)-1, LUA_MULTRET);
  }
  else
    return luaL_error(L, "%s does not implement the torch.zeros() function", tname);

  return lua_gettop(L);
}

static int torch_ByteTensor_ones(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THLongStorage *arg2 = NULL;
if(narg >= 1
&& torch_islongargs(L, 1)
)
{
arg2 = torch_checklongargs(L, 1);
arg1 = THByteTensor_new();
}
else if(narg >= 2
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& torch_islongargs(L, 2)
)
{
arg1_idx = 1;
arg2 = torch_checklongargs(L, 2);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] (LongStorage | dim1 [dim2...])", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THByteTensor_ones(arg1,arg2);
THLongStorage_free(arg2);
return 1;
}

static int torch_ones(lua_State *L)
{
  int narg = lua_gettop(L);
  const void *tname;
  if(narg >= 1 && (tname = torch_istensortype(L, luaT_typename(L, 1)))) /* first argument is tensor? */
  {
  }
  else if(narg >= 2 && (tname = torch_istensortype(L, luaT_typename(L, 2)))) /* second? */
  {
  }
  else if(narg >= 1 && (tname = torch_istensorarray(L, 1))) /* torch table argument? */
  {
  }
  else if(narg >= 1 && lua_type(L, narg) == LUA_TSTRING
	  && (tname = torch_istensortype(L, lua_tostring(L, narg)))) /* do we have a valid tensor type string then? */
  {
    lua_remove(L, -2);
  }
  else if(!(tname = torch_istensortype(L, torch_getdefaulttensortype(L))))
    luaL_error(L, "internal error: the default tensor type does not seem to be an actual tensor");

  lua_pushstring(L, "ones");
  lua_rawget(L, -2);
  if(lua_isfunction(L, -1))
  {
    lua_insert(L, 1);
    lua_pop(L, 2); /* the two tables we put on the stack above */
    lua_call(L, lua_gettop(L)-1, LUA_MULTRET);
  }
  else
    return luaL_error(L, "%s does not implement the torch.ones() function", tname);

  return lua_gettop(L);
}

static int torch_ByteTensor_reshape(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
THLongStorage *arg3 = NULL;
if(narg >= 2
&& (arg2 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& torch_islongargs(L, 2)
)
{
arg3 = torch_checklongargs(L, 2);
arg1 = THByteTensor_new();
}
else if(narg >= 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& torch_islongargs(L, 3)
)
{
arg1_idx = 1;
arg3 = torch_checklongargs(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] ByteTensor (LongStorage | dim1 [dim2...])", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THByteTensor_reshape(arg1,arg2,arg3);
THLongStorage_free(arg3);
return 1;
}

static int torch_reshape(lua_State *L)
{
  int narg = lua_gettop(L);
  const void *tname;
  if(narg >= 1 && (tname = torch_istensortype(L, luaT_typename(L, 1)))) /* first argument is tensor? */
  {
  }
  else if(narg >= 2 && (tname = torch_istensortype(L, luaT_typename(L, 2)))) /* second? */
  {
  }
  else if(narg >= 1 && (tname = torch_istensorarray(L, 1))) /* torch table argument? */
  {
  }
  else if(narg >= 1 && lua_type(L, narg) == LUA_TSTRING
	  && (tname = torch_istensortype(L, lua_tostring(L, narg)))) /* do we have a valid tensor type string then? */
  {
    lua_remove(L, -2);
  }
  else if(!(tname = torch_istensortype(L, torch_getdefaulttensortype(L))))
    luaL_error(L, "internal error: the default tensor type does not seem to be an actual tensor");

  lua_pushstring(L, "reshape");
  lua_rawget(L, -2);
  if(lua_isfunction(L, -1))
  {
    lua_insert(L, 1);
    lua_pop(L, 2); /* the two tables we put on the stack above */
    lua_call(L, lua_gettop(L)-1, LUA_MULTRET);
  }
  else
    return luaL_error(L, "%s does not implement the torch.reshape() function", tname);

  return lua_gettop(L);
}

static int torch_ByteTensor_gather(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
long arg3 = 0;
THLongTensor *arg4 = NULL;
if(narg == 3
&& (arg2 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
&& (arg4 = luaT_toudata(L, 3, "torch.LongTensor"))
)
{
arg3 = (long)lua_tonumber(L, 2)-1;
arg1 = THByteTensor_new();
THLongStorage* arg1_size = THLongTensor_newSizeOf(arg4);
THByteTensor_resize(arg1, arg1_size, NULL);
THLongStorage_free(arg1_size);
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
&& (arg4 = luaT_toudata(L, 4, "torch.LongTensor"))
)
{
arg1_idx = 1;
arg3 = (long)lua_tonumber(L, 3)-1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] ByteTensor index LongTensor", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THByteTensor_gather(arg1,arg2,arg3,arg4);
return 1;
}

static int torch_gather(lua_State *L)
{
  int narg = lua_gettop(L);
  const void *tname;
  if(narg >= 1 && (tname = torch_istensortype(L, luaT_typename(L, 1)))) /* first argument is tensor? */
  {
  }
  else if(narg >= 2 && (tname = torch_istensortype(L, luaT_typename(L, 2)))) /* second? */
  {
  }
  else if(narg >= 1 && (tname = torch_istensorarray(L, 1))) /* torch table argument? */
  {
  }
  else if(narg >= 1 && lua_type(L, narg) == LUA_TSTRING
	  && (tname = torch_istensortype(L, lua_tostring(L, narg)))) /* do we have a valid tensor type string then? */
  {
    lua_remove(L, -2);
  }
  else if(!(tname = torch_istensortype(L, torch_getdefaulttensortype(L))))
    luaL_error(L, "internal error: the default tensor type does not seem to be an actual tensor");

  lua_pushstring(L, "gather");
  lua_rawget(L, -2);
  if(lua_isfunction(L, -1))
  {
    lua_insert(L, 1);
    lua_pop(L, 2); /* the two tables we put on the stack above */
    lua_call(L, lua_gettop(L)-1, LUA_MULTRET);
  }
  else
    return luaL_error(L, "%s does not implement the torch.gather() function", tname);

  return lua_gettop(L);
}

static int torch_ByteTensor_scatter(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
long arg2 = 0;
THLongTensor *arg3 = NULL;
THByteTensor *arg4 = NULL;
THByteTensor *arg5 = NULL;
int arg5_idx = 0;
long arg6 = 0;
THLongTensor *arg7 = NULL;
unsigned char arg8 = 0;
if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
&& (arg3 = luaT_toudata(L, 3, "torch.LongTensor"))
&& (arg4 = luaT_toudata(L, 4, "torch.ByteTensor"))
)
{
argset = 1;
arg1_idx = 1;
arg2 = (long)lua_tonumber(L, 2)-1;
}
else if(narg == 4
&& (arg5 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
&& (arg7 = luaT_toudata(L, 3, "torch.LongTensor"))
&& lua_isnumber(L, 4)
)
{
argset = 2;
arg5_idx = 1;
arg6 = (long)lua_tonumber(L, 2)-1;
arg8 = (unsigned char)lua_tonumber(L, 4);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ByteTensor* index LongTensor ByteTensor | *ByteTensor* index LongTensor unsigned char", type_buf);
}
if(argset == 1)
{
lua_pushvalue(L, arg1_idx);
THByteTensor_scatter(arg1,arg2,arg3,arg4);
return 1;
}
else if(argset == 2)
{
lua_pushvalue(L, arg5_idx);
THByteTensor_scatterFill(arg5,arg6,arg7,arg8);
return 1;
}
return 0;
}

static int torch_scatter(lua_State *L)
{
  int narg = lua_gettop(L);
  const void *tname;
  if(narg >= 1 && (tname = torch_istensortype(L, luaT_typename(L, 1)))) /* first argument is tensor? */
  {
  }
  else if(narg >= 2 && (tname = torch_istensortype(L, luaT_typename(L, 2)))) /* second? */
  {
  }
  else if(narg >= 1 && (tname = torch_istensorarray(L, 1))) /* torch table argument? */
  {
  }
  else if(narg >= 1 && lua_type(L, narg) == LUA_TSTRING
	  && (tname = torch_istensortype(L, lua_tostring(L, narg)))) /* do we have a valid tensor type string then? */
  {
    lua_remove(L, -2);
  }
  else if(!(tname = torch_istensortype(L, torch_getdefaulttensortype(L))))
    luaL_error(L, "internal error: the default tensor type does not seem to be an actual tensor");

  lua_pushstring(L, "scatter");
  lua_rawget(L, -2);
  if(lua_isfunction(L, -1))
  {
    lua_insert(L, 1);
    lua_pop(L, 2); /* the two tables we put on the stack above */
    lua_call(L, lua_gettop(L)-1, LUA_MULTRET);
  }
  else
    return luaL_error(L, "%s does not implement the torch.scatter() function", tname);

  return lua_gettop(L);
}

static int torch_ByteTensor_dot(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
THByteTensor *arg2 = NULL;
long arg3 = 0;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
)
{
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: ByteTensor ByteTensor", type_buf);
}
arg3 = THByteTensor_dot(arg1,arg2);
lua_pushnumber(L, (lua_Number)arg3);
return 1;
}

static int torch_dot(lua_State *L)
{
  int narg = lua_gettop(L);
  const void *tname;
  if(narg >= 1 && (tname = torch_istensortype(L, luaT_typename(L, 1)))) /* first argument is tensor? */
  {
  }
  else if(narg >= 2 && (tname = torch_istensortype(L, luaT_typename(L, 2)))) /* second? */
  {
  }
  else if(narg >= 1 && (tname = torch_istensorarray(L, 1))) /* torch table argument? */
  {
  }
  else if(narg >= 1 && lua_type(L, narg) == LUA_TSTRING
	  && (tname = torch_istensortype(L, lua_tostring(L, narg)))) /* do we have a valid tensor type string then? */
  {
    lua_remove(L, -2);
  }
  else if(!(tname = torch_istensortype(L, torch_getdefaulttensortype(L))))
    luaL_error(L, "internal error: the default tensor type does not seem to be an actual tensor");

  lua_pushstring(L, "dot");
  lua_rawget(L, -2);
  if(lua_isfunction(L, -1))
  {
    lua_insert(L, 1);
    lua_pop(L, 2); /* the two tables we put on the stack above */
    lua_call(L, lua_gettop(L)-1, LUA_MULTRET);
  }
  else
    return luaL_error(L, "%s does not implement the torch.dot() function", tname);

  return lua_gettop(L);
}

static int torch_ByteTensor_equal(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
THByteTensor *arg2 = NULL;
int arg3 = 0;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
)
{
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: ByteTensor ByteTensor", type_buf);
}
arg3 = THByteTensor_equal(arg1,arg2);
lua_pushboolean(L, arg3);
return 1;
}

static int torch_equal(lua_State *L)
{
  int narg = lua_gettop(L);
  const void *tname;
  if(narg >= 1 && (tname = torch_istensortype(L, luaT_typename(L, 1)))) /* first argument is tensor? */
  {
  }
  else if(narg >= 2 && (tname = torch_istensortype(L, luaT_typename(L, 2)))) /* second? */
  {
  }
  else if(narg >= 1 && (tname = torch_istensorarray(L, 1))) /* torch table argument? */
  {
  }
  else if(narg >= 1 && lua_type(L, narg) == LUA_TSTRING
	  && (tname = torch_istensortype(L, lua_tostring(L, narg)))) /* do we have a valid tensor type string then? */
  {
    lua_remove(L, -2);
  }
  else if(!(tname = torch_istensortype(L, torch_getdefaulttensortype(L))))
    luaL_error(L, "internal error: the default tensor type does not seem to be an actual tensor");

  lua_pushstring(L, "equal");
  lua_rawget(L, -2);
  if(lua_isfunction(L, -1))
  {
    lua_insert(L, 1);
    lua_pop(L, 2); /* the two tables we put on the stack above */
    lua_call(L, lua_gettop(L)-1, LUA_MULTRET);
  }
  else
    return luaL_error(L, "%s does not implement the torch.equal() function", tname);

  return lua_gettop(L);
}

static int torch_ByteTensor_add(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
unsigned char arg3 = 0;
THByteTensor *arg4 = NULL;
int arg4_idx = 0;
THByteTensor *arg5 = NULL;
unsigned char arg6 = 1;
THByteTensor *arg7 = NULL;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 1;
arg3 = (unsigned char)lua_tonumber(L, 2);
arg1 = THByteTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 1;
arg1_idx = 1;
arg3 = (unsigned char)lua_tonumber(L, 3);
}
else if(narg == 2
&& (arg5 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg7 = luaT_toudata(L, 2, "torch.ByteTensor"))
)
{
argset = 2;
arg4 = THByteTensor_new();
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& (arg7 = luaT_toudata(L, 3, "torch.ByteTensor"))
)
{
argset = 2;
arg4_idx = 1;
}
else if(narg == 3
&& (arg5 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
&& (arg7 = luaT_toudata(L, 3, "torch.ByteTensor"))
)
{
argset = 2;
arg6 = (unsigned char)lua_tonumber(L, 2);
arg4 = THByteTensor_new();
}
else if(narg == 4
&& (arg4 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
&& (arg7 = luaT_toudata(L, 4, "torch.ByteTensor"))
)
{
argset = 2;
arg4_idx = 1;
arg6 = (unsigned char)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] ByteTensor unsigned char | [*ByteTensor*] ByteTensor [unsigned char] ByteTensor", type_buf);
}
if(argset == 1)
{
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THByteTensor_add(arg1,arg2,arg3);
return 1;
}
else if(argset == 2)
{
if(arg4_idx)
lua_pushvalue(L, arg4_idx);
else
luaT_pushudata(L, arg4, "torch.ByteTensor");
THByteTensor_cadd(arg4,arg5,arg6,arg7);
return 1;
}
return 0;
}

static int torch_add(lua_State *L)
{
  int narg = lua_gettop(L);
  const void *tname;
  if(narg >= 1 && (tname = torch_istensortype(L, luaT_typename(L, 1)))) /* first argument is tensor? */
  {
  }
  else if(narg >= 2 && (tname = torch_istensortype(L, luaT_typename(L, 2)))) /* second? */
  {
  }
  else if(narg >= 1 && (tname = torch_istensorarray(L, 1))) /* torch table argument? */
  {
  }
  else if(narg >= 1 && lua_type(L, narg) == LUA_TSTRING
	  && (tname = torch_istensortype(L, lua_tostring(L, narg)))) /* do we have a valid tensor type string then? */
  {
    lua_remove(L, -2);
  }
  else if(!(tname = torch_istensortype(L, torch_getdefaulttensortype(L))))
    luaL_error(L, "internal error: the default tensor type does not seem to be an actual tensor");

  lua_pushstring(L, "add");
  lua_rawget(L, -2);
  if(lua_isfunction(L, -1))
  {
    lua_insert(L, 1);
    lua_pop(L, 2); /* the two tables we put on the stack above */
    lua_call(L, lua_gettop(L)-1, LUA_MULTRET);
  }
  else
    return luaL_error(L, "%s does not implement the torch.add() function", tname);

  return lua_gettop(L);
}

static int torch_ByteTensor_csub(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
unsigned char arg3 = 0;
THByteTensor *arg4 = NULL;
int arg4_idx = 0;
THByteTensor *arg5 = NULL;
unsigned char arg6 = 1;
THByteTensor *arg7 = NULL;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 1;
arg3 = (unsigned char)lua_tonumber(L, 2);
arg1 = THByteTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 1;
arg1_idx = 1;
arg3 = (unsigned char)lua_tonumber(L, 3);
}
else if(narg == 2
&& (arg5 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg7 = luaT_toudata(L, 2, "torch.ByteTensor"))
)
{
argset = 2;
arg4 = THByteTensor_new();
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& (arg7 = luaT_toudata(L, 3, "torch.ByteTensor"))
)
{
argset = 2;
arg4_idx = 1;
}
else if(narg == 3
&& (arg5 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
&& (arg7 = luaT_toudata(L, 3, "torch.ByteTensor"))
)
{
argset = 2;
arg6 = (unsigned char)lua_tonumber(L, 2);
arg4 = THByteTensor_new();
}
else if(narg == 4
&& (arg4 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
&& (arg7 = luaT_toudata(L, 4, "torch.ByteTensor"))
)
{
argset = 2;
arg4_idx = 1;
arg6 = (unsigned char)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] ByteTensor unsigned char | [*ByteTensor*] ByteTensor [unsigned char] ByteTensor", type_buf);
}
if(argset == 1)
{
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THByteTensor_sub(arg1,arg2,arg3);
return 1;
}
else if(argset == 2)
{
if(arg4_idx)
lua_pushvalue(L, arg4_idx);
else
luaT_pushudata(L, arg4, "torch.ByteTensor");
THByteTensor_csub(arg4,arg5,arg6,arg7);
return 1;
}
return 0;
}

static int torch_csub(lua_State *L)
{
  int narg = lua_gettop(L);
  const void *tname;
  if(narg >= 1 && (tname = torch_istensortype(L, luaT_typename(L, 1)))) /* first argument is tensor? */
  {
  }
  else if(narg >= 2 && (tname = torch_istensortype(L, luaT_typename(L, 2)))) /* second? */
  {
  }
  else if(narg >= 1 && (tname = torch_istensorarray(L, 1))) /* torch table argument? */
  {
  }
  else if(narg >= 1 && lua_type(L, narg) == LUA_TSTRING
	  && (tname = torch_istensortype(L, lua_tostring(L, narg)))) /* do we have a valid tensor type string then? */
  {
    lua_remove(L, -2);
  }
  else if(!(tname = torch_istensortype(L, torch_getdefaulttensortype(L))))
    luaL_error(L, "internal error: the default tensor type does not seem to be an actual tensor");

  lua_pushstring(L, "csub");
  lua_rawget(L, -2);
  if(lua_isfunction(L, -1))
  {
    lua_insert(L, 1);
    lua_pop(L, 2); /* the two tables we put on the stack above */
    lua_call(L, lua_gettop(L)-1, LUA_MULTRET);
  }
  else
    return luaL_error(L, "%s does not implement the torch.csub() function", tname);

  return lua_gettop(L);
}

static int torch_ByteTensor_mul(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
unsigned char arg3 = 0;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
)
{
arg3 = (unsigned char)lua_tonumber(L, 2);
arg1 = THByteTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (unsigned char)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] ByteTensor unsigned char", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THByteTensor_mul(arg1,arg2,arg3);
return 1;
}

static int torch_mul(lua_State *L)
{
  int narg = lua_gettop(L);
  const void *tname;
  if(narg >= 1 && (tname = torch_istensortype(L, luaT_typename(L, 1)))) /* first argument is tensor? */
  {
  }
  else if(narg >= 2 && (tname = torch_istensortype(L, luaT_typename(L, 2)))) /* second? */
  {
  }
  else if(narg >= 1 && (tname = torch_istensorarray(L, 1))) /* torch table argument? */
  {
  }
  else if(narg >= 1 && lua_type(L, narg) == LUA_TSTRING
	  && (tname = torch_istensortype(L, lua_tostring(L, narg)))) /* do we have a valid tensor type string then? */
  {
    lua_remove(L, -2);
  }
  else if(!(tname = torch_istensortype(L, torch_getdefaulttensortype(L))))
    luaL_error(L, "internal error: the default tensor type does not seem to be an actual tensor");

  lua_pushstring(L, "mul");
  lua_rawget(L, -2);
  if(lua_isfunction(L, -1))
  {
    lua_insert(L, 1);
    lua_pop(L, 2); /* the two tables we put on the stack above */
    lua_call(L, lua_gettop(L)-1, LUA_MULTRET);
  }
  else
    return luaL_error(L, "%s does not implement the torch.mul() function", tname);

  return lua_gettop(L);
}

static int torch_ByteTensor_div(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
unsigned char arg3 = 0;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
)
{
arg3 = (unsigned char)lua_tonumber(L, 2);
arg1 = THByteTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (unsigned char)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] ByteTensor unsigned char", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THByteTensor_div(arg1,arg2,arg3);
return 1;
}

static int torch_div(lua_State *L)
{
  int narg = lua_gettop(L);
  const void *tname;
  if(narg >= 1 && (tname = torch_istensortype(L, luaT_typename(L, 1)))) /* first argument is tensor? */
  {
  }
  else if(narg >= 2 && (tname = torch_istensortype(L, luaT_typename(L, 2)))) /* second? */
  {
  }
  else if(narg >= 1 && (tname = torch_istensorarray(L, 1))) /* torch table argument? */
  {
  }
  else if(narg >= 1 && lua_type(L, narg) == LUA_TSTRING
	  && (tname = torch_istensortype(L, lua_tostring(L, narg)))) /* do we have a valid tensor type string then? */
  {
    lua_remove(L, -2);
  }
  else if(!(tname = torch_istensortype(L, torch_getdefaulttensortype(L))))
    luaL_error(L, "internal error: the default tensor type does not seem to be an actual tensor");

  lua_pushstring(L, "div");
  lua_rawget(L, -2);
  if(lua_isfunction(L, -1))
  {
    lua_insert(L, 1);
    lua_pop(L, 2); /* the two tables we put on the stack above */
    lua_call(L, lua_gettop(L)-1, LUA_MULTRET);
  }
  else
    return luaL_error(L, "%s does not implement the torch.div() function", tname);

  return lua_gettop(L);
}

static int torch_ByteTensor_lshift(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
unsigned char arg3 = 0;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
)
{
arg3 = (unsigned char)lua_tonumber(L, 2);
arg1 = THByteTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (unsigned char)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] ByteTensor unsigned char", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THByteTensor_lshift(arg1,arg2,arg3);
return 1;
}

static int torch_lshift(lua_State *L)
{
  int narg = lua_gettop(L);
  const void *tname;
  if(narg >= 1 && (tname = torch_istensortype(L, luaT_typename(L, 1)))) /* first argument is tensor? */
  {
  }
  else if(narg >= 2 && (tname = torch_istensortype(L, luaT_typename(L, 2)))) /* second? */
  {
  }
  else if(narg >= 1 && (tname = torch_istensorarray(L, 1))) /* torch table argument? */
  {
  }
  else if(narg >= 1 && lua_type(L, narg) == LUA_TSTRING
	  && (tname = torch_istensortype(L, lua_tostring(L, narg)))) /* do we have a valid tensor type string then? */
  {
    lua_remove(L, -2);
  }
  else if(!(tname = torch_istensortype(L, torch_getdefaulttensortype(L))))
    luaL_error(L, "internal error: the default tensor type does not seem to be an actual tensor");

  lua_pushstring(L, "lshift");
  lua_rawget(L, -2);
  if(lua_isfunction(L, -1))
  {
    lua_insert(L, 1);
    lua_pop(L, 2); /* the two tables we put on the stack above */
    lua_call(L, lua_gettop(L)-1, LUA_MULTRET);
  }
  else
    return luaL_error(L, "%s does not implement the torch.lshift() function", tname);

  return lua_gettop(L);
}

static int torch_ByteTensor_rshift(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
unsigned char arg3 = 0;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
)
{
arg3 = (unsigned char)lua_tonumber(L, 2);
arg1 = THByteTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (unsigned char)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] ByteTensor unsigned char", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THByteTensor_rshift(arg1,arg2,arg3);
return 1;
}

static int torch_rshift(lua_State *L)
{
  int narg = lua_gettop(L);
  const void *tname;
  if(narg >= 1 && (tname = torch_istensortype(L, luaT_typename(L, 1)))) /* first argument is tensor? */
  {
  }
  else if(narg >= 2 && (tname = torch_istensortype(L, luaT_typename(L, 2)))) /* second? */
  {
  }
  else if(narg >= 1 && (tname = torch_istensorarray(L, 1))) /* torch table argument? */
  {
  }
  else if(narg >= 1 && lua_type(L, narg) == LUA_TSTRING
	  && (tname = torch_istensortype(L, lua_tostring(L, narg)))) /* do we have a valid tensor type string then? */
  {
    lua_remove(L, -2);
  }
  else if(!(tname = torch_istensortype(L, torch_getdefaulttensortype(L))))
    luaL_error(L, "internal error: the default tensor type does not seem to be an actual tensor");

  lua_pushstring(L, "rshift");
  lua_rawget(L, -2);
  if(lua_isfunction(L, -1))
  {
    lua_insert(L, 1);
    lua_pop(L, 2); /* the two tables we put on the stack above */
    lua_call(L, lua_gettop(L)-1, LUA_MULTRET);
  }
  else
    return luaL_error(L, "%s does not implement the torch.rshift() function", tname);

  return lua_gettop(L);
}

static int torch_ByteTensor_fmod(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
unsigned char arg3 = 0;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
)
{
arg3 = (unsigned char)lua_tonumber(L, 2);
arg1 = THByteTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (unsigned char)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] ByteTensor unsigned char", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THByteTensor_fmod(arg1,arg2,arg3);
return 1;
}

static int torch_fmod(lua_State *L)
{
  int narg = lua_gettop(L);
  const void *tname;
  if(narg >= 1 && (tname = torch_istensortype(L, luaT_typename(L, 1)))) /* first argument is tensor? */
  {
  }
  else if(narg >= 2 && (tname = torch_istensortype(L, luaT_typename(L, 2)))) /* second? */
  {
  }
  else if(narg >= 1 && (tname = torch_istensorarray(L, 1))) /* torch table argument? */
  {
  }
  else if(narg >= 1 && lua_type(L, narg) == LUA_TSTRING
	  && (tname = torch_istensortype(L, lua_tostring(L, narg)))) /* do we have a valid tensor type string then? */
  {
    lua_remove(L, -2);
  }
  else if(!(tname = torch_istensortype(L, torch_getdefaulttensortype(L))))
    luaL_error(L, "internal error: the default tensor type does not seem to be an actual tensor");

  lua_pushstring(L, "fmod");
  lua_rawget(L, -2);
  if(lua_isfunction(L, -1))
  {
    lua_insert(L, 1);
    lua_pop(L, 2); /* the two tables we put on the stack above */
    lua_call(L, lua_gettop(L)-1, LUA_MULTRET);
  }
  else
    return luaL_error(L, "%s does not implement the torch.fmod() function", tname);

  return lua_gettop(L);
}

static int torch_ByteTensor_remainder(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
unsigned char arg3 = 0;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
)
{
arg3 = (unsigned char)lua_tonumber(L, 2);
arg1 = THByteTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (unsigned char)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] ByteTensor unsigned char", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THByteTensor_remainder(arg1,arg2,arg3);
return 1;
}

static int torch_remainder(lua_State *L)
{
  int narg = lua_gettop(L);
  const void *tname;
  if(narg >= 1 && (tname = torch_istensortype(L, luaT_typename(L, 1)))) /* first argument is tensor? */
  {
  }
  else if(narg >= 2 && (tname = torch_istensortype(L, luaT_typename(L, 2)))) /* second? */
  {
  }
  else if(narg >= 1 && (tname = torch_istensorarray(L, 1))) /* torch table argument? */
  {
  }
  else if(narg >= 1 && lua_type(L, narg) == LUA_TSTRING
	  && (tname = torch_istensortype(L, lua_tostring(L, narg)))) /* do we have a valid tensor type string then? */
  {
    lua_remove(L, -2);
  }
  else if(!(tname = torch_istensortype(L, torch_getdefaulttensortype(L))))
    luaL_error(L, "internal error: the default tensor type does not seem to be an actual tensor");

  lua_pushstring(L, "remainder");
  lua_rawget(L, -2);
  if(lua_isfunction(L, -1))
  {
    lua_insert(L, 1);
    lua_pop(L, 2); /* the two tables we put on the stack above */
    lua_call(L, lua_gettop(L)-1, LUA_MULTRET);
  }
  else
    return luaL_error(L, "%s does not implement the torch.remainder() function", tname);

  return lua_gettop(L);
}

static int torch_ByteTensor_bitand(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
unsigned char arg3 = 0;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
)
{
arg3 = (unsigned char)lua_tonumber(L, 2);
arg1 = THByteTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (unsigned char)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] ByteTensor unsigned char", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THByteTensor_bitand(arg1,arg2,arg3);
return 1;
}

static int torch_bitand(lua_State *L)
{
  int narg = lua_gettop(L);
  const void *tname;
  if(narg >= 1 && (tname = torch_istensortype(L, luaT_typename(L, 1)))) /* first argument is tensor? */
  {
  }
  else if(narg >= 2 && (tname = torch_istensortype(L, luaT_typename(L, 2)))) /* second? */
  {
  }
  else if(narg >= 1 && (tname = torch_istensorarray(L, 1))) /* torch table argument? */
  {
  }
  else if(narg >= 1 && lua_type(L, narg) == LUA_TSTRING
	  && (tname = torch_istensortype(L, lua_tostring(L, narg)))) /* do we have a valid tensor type string then? */
  {
    lua_remove(L, -2);
  }
  else if(!(tname = torch_istensortype(L, torch_getdefaulttensortype(L))))
    luaL_error(L, "internal error: the default tensor type does not seem to be an actual tensor");

  lua_pushstring(L, "bitand");
  lua_rawget(L, -2);
  if(lua_isfunction(L, -1))
  {
    lua_insert(L, 1);
    lua_pop(L, 2); /* the two tables we put on the stack above */
    lua_call(L, lua_gettop(L)-1, LUA_MULTRET);
  }
  else
    return luaL_error(L, "%s does not implement the torch.bitand() function", tname);

  return lua_gettop(L);
}

static int torch_ByteTensor_bitor(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
unsigned char arg3 = 0;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
)
{
arg3 = (unsigned char)lua_tonumber(L, 2);
arg1 = THByteTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (unsigned char)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] ByteTensor unsigned char", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THByteTensor_bitor(arg1,arg2,arg3);
return 1;
}

static int torch_bitor(lua_State *L)
{
  int narg = lua_gettop(L);
  const void *tname;
  if(narg >= 1 && (tname = torch_istensortype(L, luaT_typename(L, 1)))) /* first argument is tensor? */
  {
  }
  else if(narg >= 2 && (tname = torch_istensortype(L, luaT_typename(L, 2)))) /* second? */
  {
  }
  else if(narg >= 1 && (tname = torch_istensorarray(L, 1))) /* torch table argument? */
  {
  }
  else if(narg >= 1 && lua_type(L, narg) == LUA_TSTRING
	  && (tname = torch_istensortype(L, lua_tostring(L, narg)))) /* do we have a valid tensor type string then? */
  {
    lua_remove(L, -2);
  }
  else if(!(tname = torch_istensortype(L, torch_getdefaulttensortype(L))))
    luaL_error(L, "internal error: the default tensor type does not seem to be an actual tensor");

  lua_pushstring(L, "bitor");
  lua_rawget(L, -2);
  if(lua_isfunction(L, -1))
  {
    lua_insert(L, 1);
    lua_pop(L, 2); /* the two tables we put on the stack above */
    lua_call(L, lua_gettop(L)-1, LUA_MULTRET);
  }
  else
    return luaL_error(L, "%s does not implement the torch.bitor() function", tname);

  return lua_gettop(L);
}

static int torch_ByteTensor_bitxor(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
unsigned char arg3 = 0;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
)
{
arg3 = (unsigned char)lua_tonumber(L, 2);
arg1 = THByteTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (unsigned char)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] ByteTensor unsigned char", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THByteTensor_bitxor(arg1,arg2,arg3);
return 1;
}

static int torch_bitxor(lua_State *L)
{
  int narg = lua_gettop(L);
  const void *tname;
  if(narg >= 1 && (tname = torch_istensortype(L, luaT_typename(L, 1)))) /* first argument is tensor? */
  {
  }
  else if(narg >= 2 && (tname = torch_istensortype(L, luaT_typename(L, 2)))) /* second? */
  {
  }
  else if(narg >= 1 && (tname = torch_istensorarray(L, 1))) /* torch table argument? */
  {
  }
  else if(narg >= 1 && lua_type(L, narg) == LUA_TSTRING
	  && (tname = torch_istensortype(L, lua_tostring(L, narg)))) /* do we have a valid tensor type string then? */
  {
    lua_remove(L, -2);
  }
  else if(!(tname = torch_istensortype(L, torch_getdefaulttensortype(L))))
    luaL_error(L, "internal error: the default tensor type does not seem to be an actual tensor");

  lua_pushstring(L, "bitxor");
  lua_rawget(L, -2);
  if(lua_isfunction(L, -1))
  {
    lua_insert(L, 1);
    lua_pop(L, 2); /* the two tables we put on the stack above */
    lua_call(L, lua_gettop(L)-1, LUA_MULTRET);
  }
  else
    return luaL_error(L, "%s does not implement the torch.bitxor() function", tname);

  return lua_gettop(L);
}

static int torch_ByteTensor_mod(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
unsigned char arg3 = 0;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
)
{
arg3 = (unsigned char)lua_tonumber(L, 2);
arg1 = THByteTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (unsigned char)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] ByteTensor unsigned char", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THByteTensor_fmod(arg1,arg2,arg3);
return 1;
}

static int torch_mod(lua_State *L)
{
  int narg = lua_gettop(L);
  const void *tname;
  if(narg >= 1 && (tname = torch_istensortype(L, luaT_typename(L, 1)))) /* first argument is tensor? */
  {
  }
  else if(narg >= 2 && (tname = torch_istensortype(L, luaT_typename(L, 2)))) /* second? */
  {
  }
  else if(narg >= 1 && (tname = torch_istensorarray(L, 1))) /* torch table argument? */
  {
  }
  else if(narg >= 1 && lua_type(L, narg) == LUA_TSTRING
	  && (tname = torch_istensortype(L, lua_tostring(L, narg)))) /* do we have a valid tensor type string then? */
  {
    lua_remove(L, -2);
  }
  else if(!(tname = torch_istensortype(L, torch_getdefaulttensortype(L))))
    luaL_error(L, "internal error: the default tensor type does not seem to be an actual tensor");

  lua_pushstring(L, "mod");
  lua_rawget(L, -2);
  if(lua_isfunction(L, -1))
  {
    lua_insert(L, 1);
    lua_pop(L, 2); /* the two tables we put on the stack above */
    lua_call(L, lua_gettop(L)-1, LUA_MULTRET);
  }
  else
    return luaL_error(L, "%s does not implement the torch.mod() function", tname);

  return lua_gettop(L);
}

static int torch_ByteTensor_clamp(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
unsigned char arg3 = 0;
unsigned char arg4 = 0;
if(narg == 3
&& (arg2 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
&& lua_isnumber(L, 3)
)
{
arg3 = (unsigned char)lua_tonumber(L, 2);
arg4 = (unsigned char)lua_tonumber(L, 3);
arg1 = THByteTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
&& lua_isnumber(L, 4)
)
{
arg1_idx = 1;
arg3 = (unsigned char)lua_tonumber(L, 3);
arg4 = (unsigned char)lua_tonumber(L, 4);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] ByteTensor unsigned char unsigned char", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THByteTensor_clamp(arg1,arg2,arg3,arg4);
return 1;
}

static int torch_clamp(lua_State *L)
{
  int narg = lua_gettop(L);
  const void *tname;
  if(narg >= 1 && (tname = torch_istensortype(L, luaT_typename(L, 1)))) /* first argument is tensor? */
  {
  }
  else if(narg >= 2 && (tname = torch_istensortype(L, luaT_typename(L, 2)))) /* second? */
  {
  }
  else if(narg >= 1 && (tname = torch_istensorarray(L, 1))) /* torch table argument? */
  {
  }
  else if(narg >= 1 && lua_type(L, narg) == LUA_TSTRING
	  && (tname = torch_istensortype(L, lua_tostring(L, narg)))) /* do we have a valid tensor type string then? */
  {
    lua_remove(L, -2);
  }
  else if(!(tname = torch_istensortype(L, torch_getdefaulttensortype(L))))
    luaL_error(L, "internal error: the default tensor type does not seem to be an actual tensor");

  lua_pushstring(L, "clamp");
  lua_rawget(L, -2);
  if(lua_isfunction(L, -1))
  {
    lua_insert(L, 1);
    lua_pop(L, 2); /* the two tables we put on the stack above */
    lua_call(L, lua_gettop(L)-1, LUA_MULTRET);
  }
  else
    return luaL_error(L, "%s does not implement the torch.clamp() function", tname);

  return lua_gettop(L);
}

static int torch_ByteTensor_match(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
THByteTensor *arg3 = NULL;
unsigned char arg4 = 1;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
)
{
arg1 = THByteTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
)
{
arg1_idx = 1;
}
else if(narg == 3
&& (arg2 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
arg4 = (unsigned char)lua_tonumber(L, 3);
arg1 = THByteTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
&& lua_isnumber(L, 4)
)
{
arg1_idx = 1;
arg4 = (unsigned char)lua_tonumber(L, 4);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] ByteTensor ByteTensor [unsigned char]", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THByteTensor_match(arg1,arg2,arg3,arg4);
return 1;
}

static int torch_match(lua_State *L)
{
  int narg = lua_gettop(L);
  const void *tname;
  if(narg >= 1 && (tname = torch_istensortype(L, luaT_typename(L, 1)))) /* first argument is tensor? */
  {
  }
  else if(narg >= 2 && (tname = torch_istensortype(L, luaT_typename(L, 2)))) /* second? */
  {
  }
  else if(narg >= 1 && (tname = torch_istensorarray(L, 1))) /* torch table argument? */
  {
  }
  else if(narg >= 1 && lua_type(L, narg) == LUA_TSTRING
	  && (tname = torch_istensortype(L, lua_tostring(L, narg)))) /* do we have a valid tensor type string then? */
  {
    lua_remove(L, -2);
  }
  else if(!(tname = torch_istensortype(L, torch_getdefaulttensortype(L))))
    luaL_error(L, "internal error: the default tensor type does not seem to be an actual tensor");

  lua_pushstring(L, "match");
  lua_rawget(L, -2);
  if(lua_isfunction(L, -1))
  {
    lua_insert(L, 1);
    lua_pop(L, 2); /* the two tables we put on the stack above */
    lua_call(L, lua_gettop(L)-1, LUA_MULTRET);
  }
  else
    return luaL_error(L, "%s does not implement the torch.match() function", tname);

  return lua_gettop(L);
}

static int torch_ByteTensor_cmul(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
THByteTensor *arg3 = NULL;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
)
{
arg1 = THByteTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
)
{
arg1_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] ByteTensor ByteTensor", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THByteTensor_cmul(arg1,arg2,arg3);
return 1;
}

static int torch_cmul(lua_State *L)
{
  int narg = lua_gettop(L);
  const void *tname;
  if(narg >= 1 && (tname = torch_istensortype(L, luaT_typename(L, 1)))) /* first argument is tensor? */
  {
  }
  else if(narg >= 2 && (tname = torch_istensortype(L, luaT_typename(L, 2)))) /* second? */
  {
  }
  else if(narg >= 1 && (tname = torch_istensorarray(L, 1))) /* torch table argument? */
  {
  }
  else if(narg >= 1 && lua_type(L, narg) == LUA_TSTRING
	  && (tname = torch_istensortype(L, lua_tostring(L, narg)))) /* do we have a valid tensor type string then? */
  {
    lua_remove(L, -2);
  }
  else if(!(tname = torch_istensortype(L, torch_getdefaulttensortype(L))))
    luaL_error(L, "internal error: the default tensor type does not seem to be an actual tensor");

  lua_pushstring(L, "cmul");
  lua_rawget(L, -2);
  if(lua_isfunction(L, -1))
  {
    lua_insert(L, 1);
    lua_pop(L, 2); /* the two tables we put on the stack above */
    lua_call(L, lua_gettop(L)-1, LUA_MULTRET);
  }
  else
    return luaL_error(L, "%s does not implement the torch.cmul() function", tname);

  return lua_gettop(L);
}

static int torch_ByteTensor_cpow(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
THByteTensor *arg3 = NULL;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
)
{
arg1 = THByteTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
)
{
arg1_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] ByteTensor ByteTensor", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THByteTensor_cpow(arg1,arg2,arg3);
return 1;
}

static int torch_cpow(lua_State *L)
{
  int narg = lua_gettop(L);
  const void *tname;
  if(narg >= 1 && (tname = torch_istensortype(L, luaT_typename(L, 1)))) /* first argument is tensor? */
  {
  }
  else if(narg >= 2 && (tname = torch_istensortype(L, luaT_typename(L, 2)))) /* second? */
  {
  }
  else if(narg >= 1 && (tname = torch_istensorarray(L, 1))) /* torch table argument? */
  {
  }
  else if(narg >= 1 && lua_type(L, narg) == LUA_TSTRING
	  && (tname = torch_istensortype(L, lua_tostring(L, narg)))) /* do we have a valid tensor type string then? */
  {
    lua_remove(L, -2);
  }
  else if(!(tname = torch_istensortype(L, torch_getdefaulttensortype(L))))
    luaL_error(L, "internal error: the default tensor type does not seem to be an actual tensor");

  lua_pushstring(L, "cpow");
  lua_rawget(L, -2);
  if(lua_isfunction(L, -1))
  {
    lua_insert(L, 1);
    lua_pop(L, 2); /* the two tables we put on the stack above */
    lua_call(L, lua_gettop(L)-1, LUA_MULTRET);
  }
  else
    return luaL_error(L, "%s does not implement the torch.cpow() function", tname);

  return lua_gettop(L);
}

static int torch_ByteTensor_cdiv(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
THByteTensor *arg3 = NULL;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
)
{
arg1 = THByteTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
)
{
arg1_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] ByteTensor ByteTensor", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THByteTensor_cdiv(arg1,arg2,arg3);
return 1;
}

static int torch_cdiv(lua_State *L)
{
  int narg = lua_gettop(L);
  const void *tname;
  if(narg >= 1 && (tname = torch_istensortype(L, luaT_typename(L, 1)))) /* first argument is tensor? */
  {
  }
  else if(narg >= 2 && (tname = torch_istensortype(L, luaT_typename(L, 2)))) /* second? */
  {
  }
  else if(narg >= 1 && (tname = torch_istensorarray(L, 1))) /* torch table argument? */
  {
  }
  else if(narg >= 1 && lua_type(L, narg) == LUA_TSTRING
	  && (tname = torch_istensortype(L, lua_tostring(L, narg)))) /* do we have a valid tensor type string then? */
  {
    lua_remove(L, -2);
  }
  else if(!(tname = torch_istensortype(L, torch_getdefaulttensortype(L))))
    luaL_error(L, "internal error: the default tensor type does not seem to be an actual tensor");

  lua_pushstring(L, "cdiv");
  lua_rawget(L, -2);
  if(lua_isfunction(L, -1))
  {
    lua_insert(L, 1);
    lua_pop(L, 2); /* the two tables we put on the stack above */
    lua_call(L, lua_gettop(L)-1, LUA_MULTRET);
  }
  else
    return luaL_error(L, "%s does not implement the torch.cdiv() function", tname);

  return lua_gettop(L);
}

static int torch_ByteTensor_clshift(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
THByteTensor *arg3 = NULL;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
)
{
arg1 = THByteTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
)
{
arg1_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] ByteTensor ByteTensor", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THByteTensor_clshift(arg1,arg2,arg3);
return 1;
}

static int torch_clshift(lua_State *L)
{
  int narg = lua_gettop(L);
  const void *tname;
  if(narg >= 1 && (tname = torch_istensortype(L, luaT_typename(L, 1)))) /* first argument is tensor? */
  {
  }
  else if(narg >= 2 && (tname = torch_istensortype(L, luaT_typename(L, 2)))) /* second? */
  {
  }
  else if(narg >= 1 && (tname = torch_istensorarray(L, 1))) /* torch table argument? */
  {
  }
  else if(narg >= 1 && lua_type(L, narg) == LUA_TSTRING
	  && (tname = torch_istensortype(L, lua_tostring(L, narg)))) /* do we have a valid tensor type string then? */
  {
    lua_remove(L, -2);
  }
  else if(!(tname = torch_istensortype(L, torch_getdefaulttensortype(L))))
    luaL_error(L, "internal error: the default tensor type does not seem to be an actual tensor");

  lua_pushstring(L, "clshift");
  lua_rawget(L, -2);
  if(lua_isfunction(L, -1))
  {
    lua_insert(L, 1);
    lua_pop(L, 2); /* the two tables we put on the stack above */
    lua_call(L, lua_gettop(L)-1, LUA_MULTRET);
  }
  else
    return luaL_error(L, "%s does not implement the torch.clshift() function", tname);

  return lua_gettop(L);
}

static int torch_ByteTensor_crshift(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
THByteTensor *arg3 = NULL;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
)
{
arg1 = THByteTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
)
{
arg1_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] ByteTensor ByteTensor", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THByteTensor_crshift(arg1,arg2,arg3);
return 1;
}

static int torch_crshift(lua_State *L)
{
  int narg = lua_gettop(L);
  const void *tname;
  if(narg >= 1 && (tname = torch_istensortype(L, luaT_typename(L, 1)))) /* first argument is tensor? */
  {
  }
  else if(narg >= 2 && (tname = torch_istensortype(L, luaT_typename(L, 2)))) /* second? */
  {
  }
  else if(narg >= 1 && (tname = torch_istensorarray(L, 1))) /* torch table argument? */
  {
  }
  else if(narg >= 1 && lua_type(L, narg) == LUA_TSTRING
	  && (tname = torch_istensortype(L, lua_tostring(L, narg)))) /* do we have a valid tensor type string then? */
  {
    lua_remove(L, -2);
  }
  else if(!(tname = torch_istensortype(L, torch_getdefaulttensortype(L))))
    luaL_error(L, "internal error: the default tensor type does not seem to be an actual tensor");

  lua_pushstring(L, "crshift");
  lua_rawget(L, -2);
  if(lua_isfunction(L, -1))
  {
    lua_insert(L, 1);
    lua_pop(L, 2); /* the two tables we put on the stack above */
    lua_call(L, lua_gettop(L)-1, LUA_MULTRET);
  }
  else
    return luaL_error(L, "%s does not implement the torch.crshift() function", tname);

  return lua_gettop(L);
}

static int torch_ByteTensor_cfmod(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
THByteTensor *arg3 = NULL;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
)
{
arg1 = THByteTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
)
{
arg1_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] ByteTensor ByteTensor", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THByteTensor_cfmod(arg1,arg2,arg3);
return 1;
}

static int torch_cfmod(lua_State *L)
{
  int narg = lua_gettop(L);
  const void *tname;
  if(narg >= 1 && (tname = torch_istensortype(L, luaT_typename(L, 1)))) /* first argument is tensor? */
  {
  }
  else if(narg >= 2 && (tname = torch_istensortype(L, luaT_typename(L, 2)))) /* second? */
  {
  }
  else if(narg >= 1 && (tname = torch_istensorarray(L, 1))) /* torch table argument? */
  {
  }
  else if(narg >= 1 && lua_type(L, narg) == LUA_TSTRING
	  && (tname = torch_istensortype(L, lua_tostring(L, narg)))) /* do we have a valid tensor type string then? */
  {
    lua_remove(L, -2);
  }
  else if(!(tname = torch_istensortype(L, torch_getdefaulttensortype(L))))
    luaL_error(L, "internal error: the default tensor type does not seem to be an actual tensor");

  lua_pushstring(L, "cfmod");
  lua_rawget(L, -2);
  if(lua_isfunction(L, -1))
  {
    lua_insert(L, 1);
    lua_pop(L, 2); /* the two tables we put on the stack above */
    lua_call(L, lua_gettop(L)-1, LUA_MULTRET);
  }
  else
    return luaL_error(L, "%s does not implement the torch.cfmod() function", tname);

  return lua_gettop(L);
}

static int torch_ByteTensor_cremainder(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
THByteTensor *arg3 = NULL;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
)
{
arg1 = THByteTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
)
{
arg1_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] ByteTensor ByteTensor", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THByteTensor_cremainder(arg1,arg2,arg3);
return 1;
}

static int torch_cremainder(lua_State *L)
{
  int narg = lua_gettop(L);
  const void *tname;
  if(narg >= 1 && (tname = torch_istensortype(L, luaT_typename(L, 1)))) /* first argument is tensor? */
  {
  }
  else if(narg >= 2 && (tname = torch_istensortype(L, luaT_typename(L, 2)))) /* second? */
  {
  }
  else if(narg >= 1 && (tname = torch_istensorarray(L, 1))) /* torch table argument? */
  {
  }
  else if(narg >= 1 && lua_type(L, narg) == LUA_TSTRING
	  && (tname = torch_istensortype(L, lua_tostring(L, narg)))) /* do we have a valid tensor type string then? */
  {
    lua_remove(L, -2);
  }
  else if(!(tname = torch_istensortype(L, torch_getdefaulttensortype(L))))
    luaL_error(L, "internal error: the default tensor type does not seem to be an actual tensor");

  lua_pushstring(L, "cremainder");
  lua_rawget(L, -2);
  if(lua_isfunction(L, -1))
  {
    lua_insert(L, 1);
    lua_pop(L, 2); /* the two tables we put on the stack above */
    lua_call(L, lua_gettop(L)-1, LUA_MULTRET);
  }
  else
    return luaL_error(L, "%s does not implement the torch.cremainder() function", tname);

  return lua_gettop(L);
}

static int torch_ByteTensor_cbitand(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
THByteTensor *arg3 = NULL;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
)
{
arg1 = THByteTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
)
{
arg1_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] ByteTensor ByteTensor", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THByteTensor_cbitand(arg1,arg2,arg3);
return 1;
}

static int torch_cbitand(lua_State *L)
{
  int narg = lua_gettop(L);
  const void *tname;
  if(narg >= 1 && (tname = torch_istensortype(L, luaT_typename(L, 1)))) /* first argument is tensor? */
  {
  }
  else if(narg >= 2 && (tname = torch_istensortype(L, luaT_typename(L, 2)))) /* second? */
  {
  }
  else if(narg >= 1 && (tname = torch_istensorarray(L, 1))) /* torch table argument? */
  {
  }
  else if(narg >= 1 && lua_type(L, narg) == LUA_TSTRING
	  && (tname = torch_istensortype(L, lua_tostring(L, narg)))) /* do we have a valid tensor type string then? */
  {
    lua_remove(L, -2);
  }
  else if(!(tname = torch_istensortype(L, torch_getdefaulttensortype(L))))
    luaL_error(L, "internal error: the default tensor type does not seem to be an actual tensor");

  lua_pushstring(L, "cbitand");
  lua_rawget(L, -2);
  if(lua_isfunction(L, -1))
  {
    lua_insert(L, 1);
    lua_pop(L, 2); /* the two tables we put on the stack above */
    lua_call(L, lua_gettop(L)-1, LUA_MULTRET);
  }
  else
    return luaL_error(L, "%s does not implement the torch.cbitand() function", tname);

  return lua_gettop(L);
}

static int torch_ByteTensor_cbitor(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
THByteTensor *arg3 = NULL;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
)
{
arg1 = THByteTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
)
{
arg1_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] ByteTensor ByteTensor", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THByteTensor_cbitor(arg1,arg2,arg3);
return 1;
}

static int torch_cbitor(lua_State *L)
{
  int narg = lua_gettop(L);
  const void *tname;
  if(narg >= 1 && (tname = torch_istensortype(L, luaT_typename(L, 1)))) /* first argument is tensor? */
  {
  }
  else if(narg >= 2 && (tname = torch_istensortype(L, luaT_typename(L, 2)))) /* second? */
  {
  }
  else if(narg >= 1 && (tname = torch_istensorarray(L, 1))) /* torch table argument? */
  {
  }
  else if(narg >= 1 && lua_type(L, narg) == LUA_TSTRING
	  && (tname = torch_istensortype(L, lua_tostring(L, narg)))) /* do we have a valid tensor type string then? */
  {
    lua_remove(L, -2);
  }
  else if(!(tname = torch_istensortype(L, torch_getdefaulttensortype(L))))
    luaL_error(L, "internal error: the default tensor type does not seem to be an actual tensor");

  lua_pushstring(L, "cbitor");
  lua_rawget(L, -2);
  if(lua_isfunction(L, -1))
  {
    lua_insert(L, 1);
    lua_pop(L, 2); /* the two tables we put on the stack above */
    lua_call(L, lua_gettop(L)-1, LUA_MULTRET);
  }
  else
    return luaL_error(L, "%s does not implement the torch.cbitor() function", tname);

  return lua_gettop(L);
}

static int torch_ByteTensor_cbitxor(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
THByteTensor *arg3 = NULL;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
)
{
arg1 = THByteTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
)
{
arg1_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] ByteTensor ByteTensor", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THByteTensor_cbitxor(arg1,arg2,arg3);
return 1;
}

static int torch_cbitxor(lua_State *L)
{
  int narg = lua_gettop(L);
  const void *tname;
  if(narg >= 1 && (tname = torch_istensortype(L, luaT_typename(L, 1)))) /* first argument is tensor? */
  {
  }
  else if(narg >= 2 && (tname = torch_istensortype(L, luaT_typename(L, 2)))) /* second? */
  {
  }
  else if(narg >= 1 && (tname = torch_istensorarray(L, 1))) /* torch table argument? */
  {
  }
  else if(narg >= 1 && lua_type(L, narg) == LUA_TSTRING
	  && (tname = torch_istensortype(L, lua_tostring(L, narg)))) /* do we have a valid tensor type string then? */
  {
    lua_remove(L, -2);
  }
  else if(!(tname = torch_istensortype(L, torch_getdefaulttensortype(L))))
    luaL_error(L, "internal error: the default tensor type does not seem to be an actual tensor");

  lua_pushstring(L, "cbitxor");
  lua_rawget(L, -2);
  if(lua_isfunction(L, -1))
  {
    lua_insert(L, 1);
    lua_pop(L, 2); /* the two tables we put on the stack above */
    lua_call(L, lua_gettop(L)-1, LUA_MULTRET);
  }
  else
    return luaL_error(L, "%s does not implement the torch.cbitxor() function", tname);

  return lua_gettop(L);
}

static int torch_ByteTensor_cmod(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
THByteTensor *arg3 = NULL;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
)
{
arg1 = THByteTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
)
{
arg1_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] ByteTensor ByteTensor", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THByteTensor_cfmod(arg1,arg2,arg3);
return 1;
}

static int torch_cmod(lua_State *L)
{
  int narg = lua_gettop(L);
  const void *tname;
  if(narg >= 1 && (tname = torch_istensortype(L, luaT_typename(L, 1)))) /* first argument is tensor? */
  {
  }
  else if(narg >= 2 && (tname = torch_istensortype(L, luaT_typename(L, 2)))) /* second? */
  {
  }
  else if(narg >= 1 && (tname = torch_istensorarray(L, 1))) /* torch table argument? */
  {
  }
  else if(narg >= 1 && lua_type(L, narg) == LUA_TSTRING
	  && (tname = torch_istensortype(L, lua_tostring(L, narg)))) /* do we have a valid tensor type string then? */
  {
    lua_remove(L, -2);
  }
  else if(!(tname = torch_istensortype(L, torch_getdefaulttensortype(L))))
    luaL_error(L, "internal error: the default tensor type does not seem to be an actual tensor");

  lua_pushstring(L, "cmod");
  lua_rawget(L, -2);
  if(lua_isfunction(L, -1))
  {
    lua_insert(L, 1);
    lua_pop(L, 2); /* the two tables we put on the stack above */
    lua_call(L, lua_gettop(L)-1, LUA_MULTRET);
  }
  else
    return luaL_error(L, "%s does not implement the torch.cmod() function", tname);

  return lua_gettop(L);
}

static int torch_ByteTensor_addcmul(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
unsigned char arg3 = 1;
THByteTensor *arg4 = NULL;
THByteTensor *arg5 = NULL;
if(narg == 3
&& (arg2 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg4 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& (arg5 = luaT_toudata(L, 3, "torch.ByteTensor"))
)
{
arg1 = THByteTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& (arg4 = luaT_toudata(L, 3, "torch.ByteTensor"))
&& (arg5 = luaT_toudata(L, 4, "torch.ByteTensor"))
)
{
arg1_idx = 1;
}
else if(narg == 4
&& (arg2 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
&& (arg4 = luaT_toudata(L, 3, "torch.ByteTensor"))
&& (arg5 = luaT_toudata(L, 4, "torch.ByteTensor"))
)
{
arg3 = (unsigned char)lua_tonumber(L, 2);
arg1 = THByteTensor_new();
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
&& (arg4 = luaT_toudata(L, 4, "torch.ByteTensor"))
&& (arg5 = luaT_toudata(L, 5, "torch.ByteTensor"))
)
{
arg1_idx = 1;
arg3 = (unsigned char)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] ByteTensor [unsigned char] ByteTensor ByteTensor", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THByteTensor_addcmul(arg1,arg2,arg3,arg4,arg5);
return 1;
}

static int torch_addcmul(lua_State *L)
{
  int narg = lua_gettop(L);
  const void *tname;
  if(narg >= 1 && (tname = torch_istensortype(L, luaT_typename(L, 1)))) /* first argument is tensor? */
  {
  }
  else if(narg >= 2 && (tname = torch_istensortype(L, luaT_typename(L, 2)))) /* second? */
  {
  }
  else if(narg >= 1 && (tname = torch_istensorarray(L, 1))) /* torch table argument? */
  {
  }
  else if(narg >= 1 && lua_type(L, narg) == LUA_TSTRING
	  && (tname = torch_istensortype(L, lua_tostring(L, narg)))) /* do we have a valid tensor type string then? */
  {
    lua_remove(L, -2);
  }
  else if(!(tname = torch_istensortype(L, torch_getdefaulttensortype(L))))
    luaL_error(L, "internal error: the default tensor type does not seem to be an actual tensor");

  lua_pushstring(L, "addcmul");
  lua_rawget(L, -2);
  if(lua_isfunction(L, -1))
  {
    lua_insert(L, 1);
    lua_pop(L, 2); /* the two tables we put on the stack above */
    lua_call(L, lua_gettop(L)-1, LUA_MULTRET);
  }
  else
    return luaL_error(L, "%s does not implement the torch.addcmul() function", tname);

  return lua_gettop(L);
}

static int torch_ByteTensor_addcdiv(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
unsigned char arg3 = 1;
THByteTensor *arg4 = NULL;
THByteTensor *arg5 = NULL;
if(narg == 3
&& (arg2 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg4 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& (arg5 = luaT_toudata(L, 3, "torch.ByteTensor"))
)
{
arg1 = THByteTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& (arg4 = luaT_toudata(L, 3, "torch.ByteTensor"))
&& (arg5 = luaT_toudata(L, 4, "torch.ByteTensor"))
)
{
arg1_idx = 1;
}
else if(narg == 4
&& (arg2 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
&& (arg4 = luaT_toudata(L, 3, "torch.ByteTensor"))
&& (arg5 = luaT_toudata(L, 4, "torch.ByteTensor"))
)
{
arg3 = (unsigned char)lua_tonumber(L, 2);
arg1 = THByteTensor_new();
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
&& (arg4 = luaT_toudata(L, 4, "torch.ByteTensor"))
&& (arg5 = luaT_toudata(L, 5, "torch.ByteTensor"))
)
{
arg1_idx = 1;
arg3 = (unsigned char)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] ByteTensor [unsigned char] ByteTensor ByteTensor", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THByteTensor_addcdiv(arg1,arg2,arg3,arg4,arg5);
return 1;
}

static int torch_addcdiv(lua_State *L)
{
  int narg = lua_gettop(L);
  const void *tname;
  if(narg >= 1 && (tname = torch_istensortype(L, luaT_typename(L, 1)))) /* first argument is tensor? */
  {
  }
  else if(narg >= 2 && (tname = torch_istensortype(L, luaT_typename(L, 2)))) /* second? */
  {
  }
  else if(narg >= 1 && (tname = torch_istensorarray(L, 1))) /* torch table argument? */
  {
  }
  else if(narg >= 1 && lua_type(L, narg) == LUA_TSTRING
	  && (tname = torch_istensortype(L, lua_tostring(L, narg)))) /* do we have a valid tensor type string then? */
  {
    lua_remove(L, -2);
  }
  else if(!(tname = torch_istensortype(L, torch_getdefaulttensortype(L))))
    luaL_error(L, "internal error: the default tensor type does not seem to be an actual tensor");

  lua_pushstring(L, "addcdiv");
  lua_rawget(L, -2);
  if(lua_isfunction(L, -1))
  {
    lua_insert(L, 1);
    lua_pop(L, 2); /* the two tables we put on the stack above */
    lua_call(L, lua_gettop(L)-1, LUA_MULTRET);
  }
  else
    return luaL_error(L, "%s does not implement the torch.addcdiv() function", tname);

  return lua_gettop(L);
}

static int torch_ByteTensor_mv(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
unsigned char arg2 = 0;
THByteTensor *arg3 = NULL;
unsigned char arg4 = 1;
THByteTensor *arg5 = NULL;
THByteTensor *arg6 = NULL;
if(narg == 2
&& (arg5 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg6->nDimension == 1)
)
{
arg1 = THByteTensor_new();
THByteTensor_resize1d(arg1, arg5->size[0]);
arg3 = arg1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg6->nDimension == 1)
)
{
arg1_idx = 1;
arg3 = arg1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] ByteTensor~2D ByteTensor~1D", type_buf);
}
THByteTensor_zero(arg1);
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THByteTensor_addmv(arg1,arg2,arg3,arg4,arg5,arg6);
return 1;
}

static int torch_mv(lua_State *L)
{
  int narg = lua_gettop(L);
  const void *tname;
  if(narg >= 1 && (tname = torch_istensortype(L, luaT_typename(L, 1)))) /* first argument is tensor? */
  {
  }
  else if(narg >= 2 && (tname = torch_istensortype(L, luaT_typename(L, 2)))) /* second? */
  {
  }
  else if(narg >= 1 && (tname = torch_istensorarray(L, 1))) /* torch table argument? */
  {
  }
  else if(narg >= 1 && lua_type(L, narg) == LUA_TSTRING
	  && (tname = torch_istensortype(L, lua_tostring(L, narg)))) /* do we have a valid tensor type string then? */
  {
    lua_remove(L, -2);
  }
  else if(!(tname = torch_istensortype(L, torch_getdefaulttensortype(L))))
    luaL_error(L, "internal error: the default tensor type does not seem to be an actual tensor");

  lua_pushstring(L, "mv");
  lua_rawget(L, -2);
  if(lua_isfunction(L, -1))
  {
    lua_insert(L, 1);
    lua_pop(L, 2); /* the two tables we put on the stack above */
    lua_call(L, lua_gettop(L)-1, LUA_MULTRET);
  }
  else
    return luaL_error(L, "%s does not implement the torch.mv() function", tname);

  return lua_gettop(L);
}

static int torch_ByteTensor_mm(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
unsigned char arg2 = 0;
THByteTensor *arg3 = NULL;
unsigned char arg4 = 1;
THByteTensor *arg5 = NULL;
THByteTensor *arg6 = NULL;
if(narg == 2
&& (arg5 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg6->nDimension == 2)
)
{
arg1 = THByteTensor_new();
THByteTensor_resize2d(arg1, arg5->size[0], arg6->size[1]);
arg3 = arg1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg6->nDimension == 2)
)
{
arg1_idx = 1;
arg3 = arg1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] ByteTensor~2D ByteTensor~2D", type_buf);
}
THByteTensor_zero(arg1);
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THByteTensor_addmm(arg1,arg2,arg3,arg4,arg5,arg6);
return 1;
}

static int torch_mm(lua_State *L)
{
  int narg = lua_gettop(L);
  const void *tname;
  if(narg >= 1 && (tname = torch_istensortype(L, luaT_typename(L, 1)))) /* first argument is tensor? */
  {
  }
  else if(narg >= 2 && (tname = torch_istensortype(L, luaT_typename(L, 2)))) /* second? */
  {
  }
  else if(narg >= 1 && (tname = torch_istensorarray(L, 1))) /* torch table argument? */
  {
  }
  else if(narg >= 1 && lua_type(L, narg) == LUA_TSTRING
	  && (tname = torch_istensortype(L, lua_tostring(L, narg)))) /* do we have a valid tensor type string then? */
  {
    lua_remove(L, -2);
  }
  else if(!(tname = torch_istensortype(L, torch_getdefaulttensortype(L))))
    luaL_error(L, "internal error: the default tensor type does not seem to be an actual tensor");

  lua_pushstring(L, "mm");
  lua_rawget(L, -2);
  if(lua_isfunction(L, -1))
  {
    lua_insert(L, 1);
    lua_pop(L, 2); /* the two tables we put on the stack above */
    lua_call(L, lua_gettop(L)-1, LUA_MULTRET);
  }
  else
    return luaL_error(L, "%s does not implement the torch.mm() function", tname);

  return lua_gettop(L);
}

static int torch_ByteTensor_bmm(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
unsigned char arg2 = 0;
THByteTensor *arg3 = NULL;
unsigned char arg4 = 1;
THByteTensor *arg5 = NULL;
THByteTensor *arg6 = NULL;
if(narg == 2
&& (arg5 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg5->nDimension == 3)
&& (arg6 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg6->nDimension == 3)
)
{
arg1 = THByteTensor_new();
THByteTensor_resize3d(arg1, arg5->size[0], arg5->size[1], arg6->size[2]);
arg3 = arg1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg5->nDimension == 3)
&& (arg6 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg6->nDimension == 3)
)
{
arg1_idx = 1;
arg3 = arg1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] ByteTensor~3D ByteTensor~3D", type_buf);
}
THByteTensor_zero(arg1);
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THByteTensor_baddbmm(arg1,arg2,arg3,arg4,arg5,arg6);
return 1;
}

static int torch_bmm(lua_State *L)
{
  int narg = lua_gettop(L);
  const void *tname;
  if(narg >= 1 && (tname = torch_istensortype(L, luaT_typename(L, 1)))) /* first argument is tensor? */
  {
  }
  else if(narg >= 2 && (tname = torch_istensortype(L, luaT_typename(L, 2)))) /* second? */
  {
  }
  else if(narg >= 1 && (tname = torch_istensorarray(L, 1))) /* torch table argument? */
  {
  }
  else if(narg >= 1 && lua_type(L, narg) == LUA_TSTRING
	  && (tname = torch_istensortype(L, lua_tostring(L, narg)))) /* do we have a valid tensor type string then? */
  {
    lua_remove(L, -2);
  }
  else if(!(tname = torch_istensortype(L, torch_getdefaulttensortype(L))))
    luaL_error(L, "internal error: the default tensor type does not seem to be an actual tensor");

  lua_pushstring(L, "bmm");
  lua_rawget(L, -2);
  if(lua_isfunction(L, -1))
  {
    lua_insert(L, 1);
    lua_pop(L, 2); /* the two tables we put on the stack above */
    lua_call(L, lua_gettop(L)-1, LUA_MULTRET);
  }
  else
    return luaL_error(L, "%s does not implement the torch.bmm() function", tname);

  return lua_gettop(L);
}

static int torch_ByteTensor_ger(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
unsigned char arg2 = 1;
THByteTensor *arg3 = NULL;
unsigned char arg4 = 1;
THByteTensor *arg5 = NULL;
THByteTensor *arg6 = NULL;
if(narg == 2
&& (arg5 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg5->nDimension == 1)
&& (arg6 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg6->nDimension == 1)
)
{
arg1 = THByteTensor_new();
THByteTensor_resize2d(arg1, arg5->size[0], arg6->size[0]);
arg3 = arg1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg5->nDimension == 1)
&& (arg6 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg6->nDimension == 1)
)
{
arg1_idx = 1;
arg3 = arg1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] ByteTensor~1D ByteTensor~1D", type_buf);
}
THByteTensor_zero(arg1);
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THByteTensor_addr(arg1,arg2,arg3,arg4,arg5,arg6);
return 1;
}

static int torch_ger(lua_State *L)
{
  int narg = lua_gettop(L);
  const void *tname;
  if(narg >= 1 && (tname = torch_istensortype(L, luaT_typename(L, 1)))) /* first argument is tensor? */
  {
  }
  else if(narg >= 2 && (tname = torch_istensortype(L, luaT_typename(L, 2)))) /* second? */
  {
  }
  else if(narg >= 1 && (tname = torch_istensorarray(L, 1))) /* torch table argument? */
  {
  }
  else if(narg >= 1 && lua_type(L, narg) == LUA_TSTRING
	  && (tname = torch_istensortype(L, lua_tostring(L, narg)))) /* do we have a valid tensor type string then? */
  {
    lua_remove(L, -2);
  }
  else if(!(tname = torch_istensortype(L, torch_getdefaulttensortype(L))))
    luaL_error(L, "internal error: the default tensor type does not seem to be an actual tensor");

  lua_pushstring(L, "ger");
  lua_rawget(L, -2);
  if(lua_isfunction(L, -1))
  {
    lua_insert(L, 1);
    lua_pop(L, 2); /* the two tables we put on the stack above */
    lua_call(L, lua_gettop(L)-1, LUA_MULTRET);
  }
  else
    return luaL_error(L, "%s does not implement the torch.ger() function", tname);

  return lua_gettop(L);
}

static int torch_ByteTensor_addmv(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
unsigned char arg2 = 1;
THByteTensor *arg3 = NULL;
unsigned char arg4 = 1;
THByteTensor *arg5 = NULL;
THByteTensor *arg6 = NULL;
if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg3->nDimension == 1)
&& (arg5 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg6->nDimension == 1)
)
{
arg1 = THByteTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg3->nDimension == 1)
&& (arg5 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 4, "torch.ByteTensor")) && (arg6->nDimension == 1)
)
{
arg1_idx = 1;
}
else if(narg == 4
&& lua_isnumber(L, 1)
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg3->nDimension == 1)
&& (arg5 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 4, "torch.ByteTensor")) && (arg6->nDimension == 1)
)
{
arg2 = (unsigned char)lua_tonumber(L, 1);
arg1 = THByteTensor_new();
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg3->nDimension == 1)
&& (arg5 = luaT_toudata(L, 4, "torch.ByteTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 5, "torch.ByteTensor")) && (arg6->nDimension == 1)
)
{
arg1_idx = 1;
arg2 = (unsigned char)lua_tonumber(L, 2);
}
else if(narg == 4
&& (arg3 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg3->nDimension == 1)
&& lua_isnumber(L, 2)
&& (arg5 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 4, "torch.ByteTensor")) && (arg6->nDimension == 1)
)
{
arg4 = (unsigned char)lua_tonumber(L, 2);
arg1 = THByteTensor_new();
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg3->nDimension == 1)
&& lua_isnumber(L, 3)
&& (arg5 = luaT_toudata(L, 4, "torch.ByteTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 5, "torch.ByteTensor")) && (arg6->nDimension == 1)
)
{
arg1_idx = 1;
arg4 = (unsigned char)lua_tonumber(L, 3);
}
else if(narg == 5
&& lua_isnumber(L, 1)
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg3->nDimension == 1)
&& lua_isnumber(L, 3)
&& (arg5 = luaT_toudata(L, 4, "torch.ByteTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 5, "torch.ByteTensor")) && (arg6->nDimension == 1)
)
{
arg2 = (unsigned char)lua_tonumber(L, 1);
arg4 = (unsigned char)lua_tonumber(L, 3);
arg1 = THByteTensor_new();
}
else if(narg == 6
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg3->nDimension == 1)
&& lua_isnumber(L, 4)
&& (arg5 = luaT_toudata(L, 5, "torch.ByteTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 6, "torch.ByteTensor")) && (arg6->nDimension == 1)
)
{
arg1_idx = 1;
arg2 = (unsigned char)lua_tonumber(L, 2);
arg4 = (unsigned char)lua_tonumber(L, 4);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] [unsigned char] ByteTensor~1D [unsigned char] ByteTensor~2D ByteTensor~1D", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THByteTensor_addmv(arg1,arg2,arg3,arg4,arg5,arg6);
return 1;
}

static int torch_addmv(lua_State *L)
{
  int narg = lua_gettop(L);
  const void *tname;
  if(narg >= 1 && (tname = torch_istensortype(L, luaT_typename(L, 1)))) /* first argument is tensor? */
  {
  }
  else if(narg >= 2 && (tname = torch_istensortype(L, luaT_typename(L, 2)))) /* second? */
  {
  }
  else if(narg >= 1 && (tname = torch_istensorarray(L, 1))) /* torch table argument? */
  {
  }
  else if(narg >= 1 && lua_type(L, narg) == LUA_TSTRING
	  && (tname = torch_istensortype(L, lua_tostring(L, narg)))) /* do we have a valid tensor type string then? */
  {
    lua_remove(L, -2);
  }
  else if(!(tname = torch_istensortype(L, torch_getdefaulttensortype(L))))
    luaL_error(L, "internal error: the default tensor type does not seem to be an actual tensor");

  lua_pushstring(L, "addmv");
  lua_rawget(L, -2);
  if(lua_isfunction(L, -1))
  {
    lua_insert(L, 1);
    lua_pop(L, 2); /* the two tables we put on the stack above */
    lua_call(L, lua_gettop(L)-1, LUA_MULTRET);
  }
  else
    return luaL_error(L, "%s does not implement the torch.addmv() function", tname);

  return lua_gettop(L);
}

static int torch_ByteTensor_addmm(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
unsigned char arg2 = 1;
THByteTensor *arg3 = NULL;
unsigned char arg4 = 1;
THByteTensor *arg5 = NULL;
THByteTensor *arg6 = NULL;
if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg3->nDimension == 2)
&& (arg5 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg6->nDimension == 2)
)
{
arg1 = THByteTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg3->nDimension == 2)
&& (arg5 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 4, "torch.ByteTensor")) && (arg6->nDimension == 2)
)
{
arg1_idx = 1;
}
else if(narg == 4
&& lua_isnumber(L, 1)
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg3->nDimension == 2)
&& (arg5 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 4, "torch.ByteTensor")) && (arg6->nDimension == 2)
)
{
arg2 = (unsigned char)lua_tonumber(L, 1);
arg1 = THByteTensor_new();
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg3->nDimension == 2)
&& (arg5 = luaT_toudata(L, 4, "torch.ByteTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 5, "torch.ByteTensor")) && (arg6->nDimension == 2)
)
{
arg1_idx = 1;
arg2 = (unsigned char)lua_tonumber(L, 2);
}
else if(narg == 4
&& (arg3 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg3->nDimension == 2)
&& lua_isnumber(L, 2)
&& (arg5 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 4, "torch.ByteTensor")) && (arg6->nDimension == 2)
)
{
arg4 = (unsigned char)lua_tonumber(L, 2);
arg1 = THByteTensor_new();
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg3->nDimension == 2)
&& lua_isnumber(L, 3)
&& (arg5 = luaT_toudata(L, 4, "torch.ByteTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 5, "torch.ByteTensor")) && (arg6->nDimension == 2)
)
{
arg1_idx = 1;
arg4 = (unsigned char)lua_tonumber(L, 3);
}
else if(narg == 5
&& lua_isnumber(L, 1)
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg3->nDimension == 2)
&& lua_isnumber(L, 3)
&& (arg5 = luaT_toudata(L, 4, "torch.ByteTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 5, "torch.ByteTensor")) && (arg6->nDimension == 2)
)
{
arg2 = (unsigned char)lua_tonumber(L, 1);
arg4 = (unsigned char)lua_tonumber(L, 3);
arg1 = THByteTensor_new();
}
else if(narg == 6
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg3->nDimension == 2)
&& lua_isnumber(L, 4)
&& (arg5 = luaT_toudata(L, 5, "torch.ByteTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 6, "torch.ByteTensor")) && (arg6->nDimension == 2)
)
{
arg1_idx = 1;
arg2 = (unsigned char)lua_tonumber(L, 2);
arg4 = (unsigned char)lua_tonumber(L, 4);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] [unsigned char] ByteTensor~2D [unsigned char] ByteTensor~2D ByteTensor~2D", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THByteTensor_addmm(arg1,arg2,arg3,arg4,arg5,arg6);
return 1;
}

static int torch_addmm(lua_State *L)
{
  int narg = lua_gettop(L);
  const void *tname;
  if(narg >= 1 && (tname = torch_istensortype(L, luaT_typename(L, 1)))) /* first argument is tensor? */
  {
  }
  else if(narg >= 2 && (tname = torch_istensortype(L, luaT_typename(L, 2)))) /* second? */
  {
  }
  else if(narg >= 1 && (tname = torch_istensorarray(L, 1))) /* torch table argument? */
  {
  }
  else if(narg >= 1 && lua_type(L, narg) == LUA_TSTRING
	  && (tname = torch_istensortype(L, lua_tostring(L, narg)))) /* do we have a valid tensor type string then? */
  {
    lua_remove(L, -2);
  }
  else if(!(tname = torch_istensortype(L, torch_getdefaulttensortype(L))))
    luaL_error(L, "internal error: the default tensor type does not seem to be an actual tensor");

  lua_pushstring(L, "addmm");
  lua_rawget(L, -2);
  if(lua_isfunction(L, -1))
  {
    lua_insert(L, 1);
    lua_pop(L, 2); /* the two tables we put on the stack above */
    lua_call(L, lua_gettop(L)-1, LUA_MULTRET);
  }
  else
    return luaL_error(L, "%s does not implement the torch.addmm() function", tname);

  return lua_gettop(L);
}

static int torch_ByteTensor_addr(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
unsigned char arg2 = 1;
THByteTensor *arg3 = NULL;
unsigned char arg4 = 1;
THByteTensor *arg5 = NULL;
THByteTensor *arg6 = NULL;
if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg3->nDimension == 2)
&& (arg5 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg5->nDimension == 1)
&& (arg6 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg6->nDimension == 1)
)
{
arg1 = THByteTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg3->nDimension == 2)
&& (arg5 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg5->nDimension == 1)
&& (arg6 = luaT_toudata(L, 4, "torch.ByteTensor")) && (arg6->nDimension == 1)
)
{
arg1_idx = 1;
}
else if(narg == 4
&& lua_isnumber(L, 1)
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg3->nDimension == 2)
&& (arg5 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg5->nDimension == 1)
&& (arg6 = luaT_toudata(L, 4, "torch.ByteTensor")) && (arg6->nDimension == 1)
)
{
arg2 = (unsigned char)lua_tonumber(L, 1);
arg1 = THByteTensor_new();
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg3->nDimension == 2)
&& (arg5 = luaT_toudata(L, 4, "torch.ByteTensor")) && (arg5->nDimension == 1)
&& (arg6 = luaT_toudata(L, 5, "torch.ByteTensor")) && (arg6->nDimension == 1)
)
{
arg1_idx = 1;
arg2 = (unsigned char)lua_tonumber(L, 2);
}
else if(narg == 4
&& (arg3 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg3->nDimension == 2)
&& lua_isnumber(L, 2)
&& (arg5 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg5->nDimension == 1)
&& (arg6 = luaT_toudata(L, 4, "torch.ByteTensor")) && (arg6->nDimension == 1)
)
{
arg4 = (unsigned char)lua_tonumber(L, 2);
arg1 = THByteTensor_new();
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg3->nDimension == 2)
&& lua_isnumber(L, 3)
&& (arg5 = luaT_toudata(L, 4, "torch.ByteTensor")) && (arg5->nDimension == 1)
&& (arg6 = luaT_toudata(L, 5, "torch.ByteTensor")) && (arg6->nDimension == 1)
)
{
arg1_idx = 1;
arg4 = (unsigned char)lua_tonumber(L, 3);
}
else if(narg == 5
&& lua_isnumber(L, 1)
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg3->nDimension == 2)
&& lua_isnumber(L, 3)
&& (arg5 = luaT_toudata(L, 4, "torch.ByteTensor")) && (arg5->nDimension == 1)
&& (arg6 = luaT_toudata(L, 5, "torch.ByteTensor")) && (arg6->nDimension == 1)
)
{
arg2 = (unsigned char)lua_tonumber(L, 1);
arg4 = (unsigned char)lua_tonumber(L, 3);
arg1 = THByteTensor_new();
}
else if(narg == 6
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg3->nDimension == 2)
&& lua_isnumber(L, 4)
&& (arg5 = luaT_toudata(L, 5, "torch.ByteTensor")) && (arg5->nDimension == 1)
&& (arg6 = luaT_toudata(L, 6, "torch.ByteTensor")) && (arg6->nDimension == 1)
)
{
arg1_idx = 1;
arg2 = (unsigned char)lua_tonumber(L, 2);
arg4 = (unsigned char)lua_tonumber(L, 4);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] [unsigned char] ByteTensor~2D [unsigned char] ByteTensor~1D ByteTensor~1D", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THByteTensor_addr(arg1,arg2,arg3,arg4,arg5,arg6);
return 1;
}

static int torch_addr(lua_State *L)
{
  int narg = lua_gettop(L);
  const void *tname;
  if(narg >= 1 && (tname = torch_istensortype(L, luaT_typename(L, 1)))) /* first argument is tensor? */
  {
  }
  else if(narg >= 2 && (tname = torch_istensortype(L, luaT_typename(L, 2)))) /* second? */
  {
  }
  else if(narg >= 1 && (tname = torch_istensorarray(L, 1))) /* torch table argument? */
  {
  }
  else if(narg >= 1 && lua_type(L, narg) == LUA_TSTRING
	  && (tname = torch_istensortype(L, lua_tostring(L, narg)))) /* do we have a valid tensor type string then? */
  {
    lua_remove(L, -2);
  }
  else if(!(tname = torch_istensortype(L, torch_getdefaulttensortype(L))))
    luaL_error(L, "internal error: the default tensor type does not seem to be an actual tensor");

  lua_pushstring(L, "addr");
  lua_rawget(L, -2);
  if(lua_isfunction(L, -1))
  {
    lua_insert(L, 1);
    lua_pop(L, 2); /* the two tables we put on the stack above */
    lua_call(L, lua_gettop(L)-1, LUA_MULTRET);
  }
  else
    return luaL_error(L, "%s does not implement the torch.addr() function", tname);

  return lua_gettop(L);
}

static int torch_ByteTensor_addbmm(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
unsigned char arg2 = 1;
THByteTensor *arg3 = NULL;
unsigned char arg4 = 1;
THByteTensor *arg5 = NULL;
THByteTensor *arg6 = NULL;
if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg3->nDimension == 2)
&& (arg5 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg5->nDimension == 3)
&& (arg6 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg6->nDimension == 3)
)
{
arg1 = THByteTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg3->nDimension == 2)
&& (arg5 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg5->nDimension == 3)
&& (arg6 = luaT_toudata(L, 4, "torch.ByteTensor")) && (arg6->nDimension == 3)
)
{
arg1_idx = 1;
}
else if(narg == 4
&& lua_isnumber(L, 1)
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg3->nDimension == 2)
&& (arg5 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg5->nDimension == 3)
&& (arg6 = luaT_toudata(L, 4, "torch.ByteTensor")) && (arg6->nDimension == 3)
)
{
arg2 = (unsigned char)lua_tonumber(L, 1);
arg1 = THByteTensor_new();
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg3->nDimension == 2)
&& (arg5 = luaT_toudata(L, 4, "torch.ByteTensor")) && (arg5->nDimension == 3)
&& (arg6 = luaT_toudata(L, 5, "torch.ByteTensor")) && (arg6->nDimension == 3)
)
{
arg1_idx = 1;
arg2 = (unsigned char)lua_tonumber(L, 2);
}
else if(narg == 4
&& (arg3 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg3->nDimension == 2)
&& lua_isnumber(L, 2)
&& (arg5 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg5->nDimension == 3)
&& (arg6 = luaT_toudata(L, 4, "torch.ByteTensor")) && (arg6->nDimension == 3)
)
{
arg4 = (unsigned char)lua_tonumber(L, 2);
arg1 = THByteTensor_new();
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg3->nDimension == 2)
&& lua_isnumber(L, 3)
&& (arg5 = luaT_toudata(L, 4, "torch.ByteTensor")) && (arg5->nDimension == 3)
&& (arg6 = luaT_toudata(L, 5, "torch.ByteTensor")) && (arg6->nDimension == 3)
)
{
arg1_idx = 1;
arg4 = (unsigned char)lua_tonumber(L, 3);
}
else if(narg == 5
&& lua_isnumber(L, 1)
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg3->nDimension == 2)
&& lua_isnumber(L, 3)
&& (arg5 = luaT_toudata(L, 4, "torch.ByteTensor")) && (arg5->nDimension == 3)
&& (arg6 = luaT_toudata(L, 5, "torch.ByteTensor")) && (arg6->nDimension == 3)
)
{
arg2 = (unsigned char)lua_tonumber(L, 1);
arg4 = (unsigned char)lua_tonumber(L, 3);
arg1 = THByteTensor_new();
}
else if(narg == 6
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg3->nDimension == 2)
&& lua_isnumber(L, 4)
&& (arg5 = luaT_toudata(L, 5, "torch.ByteTensor")) && (arg5->nDimension == 3)
&& (arg6 = luaT_toudata(L, 6, "torch.ByteTensor")) && (arg6->nDimension == 3)
)
{
arg1_idx = 1;
arg2 = (unsigned char)lua_tonumber(L, 2);
arg4 = (unsigned char)lua_tonumber(L, 4);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] [unsigned char] ByteTensor~2D [unsigned char] ByteTensor~3D ByteTensor~3D", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THByteTensor_addbmm(arg1,arg2,arg3,arg4,arg5,arg6);
return 1;
}

static int torch_addbmm(lua_State *L)
{
  int narg = lua_gettop(L);
  const void *tname;
  if(narg >= 1 && (tname = torch_istensortype(L, luaT_typename(L, 1)))) /* first argument is tensor? */
  {
  }
  else if(narg >= 2 && (tname = torch_istensortype(L, luaT_typename(L, 2)))) /* second? */
  {
  }
  else if(narg >= 1 && (tname = torch_istensorarray(L, 1))) /* torch table argument? */
  {
  }
  else if(narg >= 1 && lua_type(L, narg) == LUA_TSTRING
	  && (tname = torch_istensortype(L, lua_tostring(L, narg)))) /* do we have a valid tensor type string then? */
  {
    lua_remove(L, -2);
  }
  else if(!(tname = torch_istensortype(L, torch_getdefaulttensortype(L))))
    luaL_error(L, "internal error: the default tensor type does not seem to be an actual tensor");

  lua_pushstring(L, "addbmm");
  lua_rawget(L, -2);
  if(lua_isfunction(L, -1))
  {
    lua_insert(L, 1);
    lua_pop(L, 2); /* the two tables we put on the stack above */
    lua_call(L, lua_gettop(L)-1, LUA_MULTRET);
  }
  else
    return luaL_error(L, "%s does not implement the torch.addbmm() function", tname);

  return lua_gettop(L);
}

static int torch_ByteTensor_baddbmm(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
unsigned char arg2 = 1;
THByteTensor *arg3 = NULL;
unsigned char arg4 = 1;
THByteTensor *arg5 = NULL;
THByteTensor *arg6 = NULL;
if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg3->nDimension == 3)
&& (arg5 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg5->nDimension == 3)
&& (arg6 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg6->nDimension == 3)
)
{
arg1 = THByteTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg3->nDimension == 3)
&& (arg5 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg5->nDimension == 3)
&& (arg6 = luaT_toudata(L, 4, "torch.ByteTensor")) && (arg6->nDimension == 3)
)
{
arg1_idx = 1;
}
else if(narg == 4
&& lua_isnumber(L, 1)
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg3->nDimension == 3)
&& (arg5 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg5->nDimension == 3)
&& (arg6 = luaT_toudata(L, 4, "torch.ByteTensor")) && (arg6->nDimension == 3)
)
{
arg2 = (unsigned char)lua_tonumber(L, 1);
arg1 = THByteTensor_new();
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg3->nDimension == 3)
&& (arg5 = luaT_toudata(L, 4, "torch.ByteTensor")) && (arg5->nDimension == 3)
&& (arg6 = luaT_toudata(L, 5, "torch.ByteTensor")) && (arg6->nDimension == 3)
)
{
arg1_idx = 1;
arg2 = (unsigned char)lua_tonumber(L, 2);
}
else if(narg == 4
&& (arg3 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg3->nDimension == 3)
&& lua_isnumber(L, 2)
&& (arg5 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg5->nDimension == 3)
&& (arg6 = luaT_toudata(L, 4, "torch.ByteTensor")) && (arg6->nDimension == 3)
)
{
arg4 = (unsigned char)lua_tonumber(L, 2);
arg1 = THByteTensor_new();
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg3->nDimension == 3)
&& lua_isnumber(L, 3)
&& (arg5 = luaT_toudata(L, 4, "torch.ByteTensor")) && (arg5->nDimension == 3)
&& (arg6 = luaT_toudata(L, 5, "torch.ByteTensor")) && (arg6->nDimension == 3)
)
{
arg1_idx = 1;
arg4 = (unsigned char)lua_tonumber(L, 3);
}
else if(narg == 5
&& lua_isnumber(L, 1)
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg3->nDimension == 3)
&& lua_isnumber(L, 3)
&& (arg5 = luaT_toudata(L, 4, "torch.ByteTensor")) && (arg5->nDimension == 3)
&& (arg6 = luaT_toudata(L, 5, "torch.ByteTensor")) && (arg6->nDimension == 3)
)
{
arg2 = (unsigned char)lua_tonumber(L, 1);
arg4 = (unsigned char)lua_tonumber(L, 3);
arg1 = THByteTensor_new();
}
else if(narg == 6
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg3->nDimension == 3)
&& lua_isnumber(L, 4)
&& (arg5 = luaT_toudata(L, 5, "torch.ByteTensor")) && (arg5->nDimension == 3)
&& (arg6 = luaT_toudata(L, 6, "torch.ByteTensor")) && (arg6->nDimension == 3)
)
{
arg1_idx = 1;
arg2 = (unsigned char)lua_tonumber(L, 2);
arg4 = (unsigned char)lua_tonumber(L, 4);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] [unsigned char] ByteTensor~3D [unsigned char] ByteTensor~3D ByteTensor~3D", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THByteTensor_baddbmm(arg1,arg2,arg3,arg4,arg5,arg6);
return 1;
}

static int torch_baddbmm(lua_State *L)
{
  int narg = lua_gettop(L);
  const void *tname;
  if(narg >= 1 && (tname = torch_istensortype(L, luaT_typename(L, 1)))) /* first argument is tensor? */
  {
  }
  else if(narg >= 2 && (tname = torch_istensortype(L, luaT_typename(L, 2)))) /* second? */
  {
  }
  else if(narg >= 1 && (tname = torch_istensorarray(L, 1))) /* torch table argument? */
  {
  }
  else if(narg >= 1 && lua_type(L, narg) == LUA_TSTRING
	  && (tname = torch_istensortype(L, lua_tostring(L, narg)))) /* do we have a valid tensor type string then? */
  {
    lua_remove(L, -2);
  }
  else if(!(tname = torch_istensortype(L, torch_getdefaulttensortype(L))))
    luaL_error(L, "internal error: the default tensor type does not seem to be an actual tensor");

  lua_pushstring(L, "baddbmm");
  lua_rawget(L, -2);
  if(lua_isfunction(L, -1))
  {
    lua_insert(L, 1);
    lua_pop(L, 2); /* the two tables we put on the stack above */
    lua_call(L, lua_gettop(L)-1, LUA_MULTRET);
  }
  else
    return luaL_error(L, "%s does not implement the torch.baddbmm() function", tname);

  return lua_gettop(L);
}

static int torch_ByteTensor_numel(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
ptrdiff_t arg2 = 0;
if(narg == 1
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
)
{
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: ByteTensor", type_buf);
}
arg2 = THByteTensor_numel(arg1);
lua_pushnumber(L, (lua_Number)arg2);
return 1;
}

static int torch_numel(lua_State *L)
{
  int narg = lua_gettop(L);
  const void *tname;
  if(narg >= 1 && (tname = torch_istensortype(L, luaT_typename(L, 1)))) /* first argument is tensor? */
  {
  }
  else if(narg >= 2 && (tname = torch_istensortype(L, luaT_typename(L, 2)))) /* second? */
  {
  }
  else if(narg >= 1 && (tname = torch_istensorarray(L, 1))) /* torch table argument? */
  {
  }
  else if(narg >= 1 && lua_type(L, narg) == LUA_TSTRING
	  && (tname = torch_istensortype(L, lua_tostring(L, narg)))) /* do we have a valid tensor type string then? */
  {
    lua_remove(L, -2);
  }
  else if(!(tname = torch_istensortype(L, torch_getdefaulttensortype(L))))
    luaL_error(L, "internal error: the default tensor type does not seem to be an actual tensor");

  lua_pushstring(L, "numel");
  lua_rawget(L, -2);
  if(lua_isfunction(L, -1))
  {
    lua_insert(L, 1);
    lua_pop(L, 2); /* the two tables we put on the stack above */
    lua_call(L, lua_gettop(L)-1, LUA_MULTRET);
  }
  else
    return luaL_error(L, "%s does not implement the torch.numel() function", tname);

  return lua_gettop(L);
}

static int torch_ByteTensor_cumsum(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
long arg3 = 0;
if(narg == 1
&& (arg2 = luaT_toudata(L, 1, "torch.ByteTensor"))
)
{
arg1 = THByteTensor_new();
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
)
{
arg1_idx = 1;
}
else if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
)
{
arg3 = (long)lua_tonumber(L, 2)-1;
arg1 = THByteTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (long)lua_tonumber(L, 3)-1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] ByteTensor [index]", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THByteTensor_cumsum(arg1,arg2,arg3);
return 1;
}

static int torch_cumsum(lua_State *L)
{
  int narg = lua_gettop(L);
  const void *tname;
  if(narg >= 1 && (tname = torch_istensortype(L, luaT_typename(L, 1)))) /* first argument is tensor? */
  {
  }
  else if(narg >= 2 && (tname = torch_istensortype(L, luaT_typename(L, 2)))) /* second? */
  {
  }
  else if(narg >= 1 && (tname = torch_istensorarray(L, 1))) /* torch table argument? */
  {
  }
  else if(narg >= 1 && lua_type(L, narg) == LUA_TSTRING
	  && (tname = torch_istensortype(L, lua_tostring(L, narg)))) /* do we have a valid tensor type string then? */
  {
    lua_remove(L, -2);
  }
  else if(!(tname = torch_istensortype(L, torch_getdefaulttensortype(L))))
    luaL_error(L, "internal error: the default tensor type does not seem to be an actual tensor");

  lua_pushstring(L, "cumsum");
  lua_rawget(L, -2);
  if(lua_isfunction(L, -1))
  {
    lua_insert(L, 1);
    lua_pop(L, 2); /* the two tables we put on the stack above */
    lua_call(L, lua_gettop(L)-1, LUA_MULTRET);
  }
  else
    return luaL_error(L, "%s does not implement the torch.cumsum() function", tname);

  return lua_gettop(L);
}

static int torch_ByteTensor_cumprod(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
long arg3 = 0;
if(narg == 1
&& (arg2 = luaT_toudata(L, 1, "torch.ByteTensor"))
)
{
arg1 = THByteTensor_new();
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
)
{
arg1_idx = 1;
}
else if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
)
{
arg3 = (long)lua_tonumber(L, 2)-1;
arg1 = THByteTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (long)lua_tonumber(L, 3)-1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] ByteTensor [index]", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THByteTensor_cumprod(arg1,arg2,arg3);
return 1;
}

static int torch_cumprod(lua_State *L)
{
  int narg = lua_gettop(L);
  const void *tname;
  if(narg >= 1 && (tname = torch_istensortype(L, luaT_typename(L, 1)))) /* first argument is tensor? */
  {
  }
  else if(narg >= 2 && (tname = torch_istensortype(L, luaT_typename(L, 2)))) /* second? */
  {
  }
  else if(narg >= 1 && (tname = torch_istensorarray(L, 1))) /* torch table argument? */
  {
  }
  else if(narg >= 1 && lua_type(L, narg) == LUA_TSTRING
	  && (tname = torch_istensortype(L, lua_tostring(L, narg)))) /* do we have a valid tensor type string then? */
  {
    lua_remove(L, -2);
  }
  else if(!(tname = torch_istensortype(L, torch_getdefaulttensortype(L))))
    luaL_error(L, "internal error: the default tensor type does not seem to be an actual tensor");

  lua_pushstring(L, "cumprod");
  lua_rawget(L, -2);
  if(lua_isfunction(L, -1))
  {
    lua_insert(L, 1);
    lua_pop(L, 2); /* the two tables we put on the stack above */
    lua_call(L, lua_gettop(L)-1, LUA_MULTRET);
  }
  else
    return luaL_error(L, "%s does not implement the torch.cumprod() function", tname);

  return lua_gettop(L);
}

static int torch_ByteTensor_sum(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THByteTensor *arg1 = NULL;
long arg2 = 0;
THByteTensor *arg3 = NULL;
int arg3_idx = 0;
THByteTensor *arg4 = NULL;
long arg5 = 0;
int arg6 = 1;
if(narg == 1
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
)
{
argset = 1;
}
else if(narg == 2
&& (arg4 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 2;
arg5 = (long)lua_tonumber(L, 2)-1;
arg3 = THByteTensor_new();
}
else if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg4 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg3_idx = 1;
arg5 = (long)lua_tonumber(L, 3)-1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: ByteTensor | [*ByteTensor*] ByteTensor index", type_buf);
}
if(argset == 1)
{
arg2 = THByteTensor_sumall(arg1);
lua_pushnumber(L, (lua_Number)arg2);
return 1;
}
else if(argset == 2)
{
if(arg3_idx)
lua_pushvalue(L, arg3_idx);
else
luaT_pushudata(L, arg3, "torch.ByteTensor");
THByteTensor_sum(arg3,arg4,arg5,arg6);
return 1;
}
return 0;
}

static int torch_sum(lua_State *L)
{
  int narg = lua_gettop(L);
  const void *tname;
  if(narg >= 1 && (tname = torch_istensortype(L, luaT_typename(L, 1)))) /* first argument is tensor? */
  {
  }
  else if(narg >= 2 && (tname = torch_istensortype(L, luaT_typename(L, 2)))) /* second? */
  {
  }
  else if(narg >= 1 && (tname = torch_istensorarray(L, 1))) /* torch table argument? */
  {
  }
  else if(narg >= 1 && lua_type(L, narg) == LUA_TSTRING
	  && (tname = torch_istensortype(L, lua_tostring(L, narg)))) /* do we have a valid tensor type string then? */
  {
    lua_remove(L, -2);
  }
  else if(!(tname = torch_istensortype(L, torch_getdefaulttensortype(L))))
    luaL_error(L, "internal error: the default tensor type does not seem to be an actual tensor");

  lua_pushstring(L, "sum");
  lua_rawget(L, -2);
  if(lua_isfunction(L, -1))
  {
    lua_insert(L, 1);
    lua_pop(L, 2); /* the two tables we put on the stack above */
    lua_call(L, lua_gettop(L)-1, LUA_MULTRET);
  }
  else
    return luaL_error(L, "%s does not implement the torch.sum() function", tname);

  return lua_gettop(L);
}

static int torch_ByteTensor_prod(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THByteTensor *arg1 = NULL;
long arg2 = 0;
THByteTensor *arg3 = NULL;
int arg3_idx = 0;
THByteTensor *arg4 = NULL;
long arg5 = 0;
int arg6 = 1;
if(narg == 1
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
)
{
argset = 1;
}
else if(narg == 2
&& (arg4 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 2;
arg5 = (long)lua_tonumber(L, 2)-1;
arg3 = THByteTensor_new();
}
else if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg4 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg3_idx = 1;
arg5 = (long)lua_tonumber(L, 3)-1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: ByteTensor | [*ByteTensor*] ByteTensor index", type_buf);
}
if(argset == 1)
{
arg2 = THByteTensor_prodall(arg1);
lua_pushnumber(L, (lua_Number)arg2);
return 1;
}
else if(argset == 2)
{
if(arg3_idx)
lua_pushvalue(L, arg3_idx);
else
luaT_pushudata(L, arg3, "torch.ByteTensor");
THByteTensor_prod(arg3,arg4,arg5,arg6);
return 1;
}
return 0;
}

static int torch_prod(lua_State *L)
{
  int narg = lua_gettop(L);
  const void *tname;
  if(narg >= 1 && (tname = torch_istensortype(L, luaT_typename(L, 1)))) /* first argument is tensor? */
  {
  }
  else if(narg >= 2 && (tname = torch_istensortype(L, luaT_typename(L, 2)))) /* second? */
  {
  }
  else if(narg >= 1 && (tname = torch_istensorarray(L, 1))) /* torch table argument? */
  {
  }
  else if(narg >= 1 && lua_type(L, narg) == LUA_TSTRING
	  && (tname = torch_istensortype(L, lua_tostring(L, narg)))) /* do we have a valid tensor type string then? */
  {
    lua_remove(L, -2);
  }
  else if(!(tname = torch_istensortype(L, torch_getdefaulttensortype(L))))
    luaL_error(L, "internal error: the default tensor type does not seem to be an actual tensor");

  lua_pushstring(L, "prod");
  lua_rawget(L, -2);
  if(lua_isfunction(L, -1))
  {
    lua_insert(L, 1);
    lua_pop(L, 2); /* the two tables we put on the stack above */
    lua_call(L, lua_gettop(L)-1, LUA_MULTRET);
  }
  else
    return luaL_error(L, "%s does not implement the torch.prod() function", tname);

  return lua_gettop(L);
}

static int torch_ByteTensor_min(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THByteTensor *arg1 = NULL;
unsigned char arg2 = 0;
THByteTensor *arg3 = NULL;
int arg3_idx = 0;
THLongTensor *arg4 = NULL;
int arg4_idx = 0;
THByteTensor *arg5 = NULL;
long arg6 = 0;
int arg7 = 1;
if(narg == 1
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
)
{
argset = 1;
}
else if(narg == 2
&& (arg5 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 2;
arg6 = (long)lua_tonumber(L, 2)-1;
arg3 = THByteTensor_new();
arg4 = THLongTensor_new();
}
else if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg3_idx = 1;
arg6 = (long)lua_tonumber(L, 3)-1;
arg4 = THLongTensor_new();
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg4_idx = 1;
arg6 = (long)lua_tonumber(L, 3)-1;
arg3 = THByteTensor_new();
}
else if(narg == 4
&& (arg3 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg4 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg5 = luaT_toudata(L, 3, "torch.ByteTensor"))
&& lua_isnumber(L, 4)
)
{
argset = 2;
arg3_idx = 1;
arg4_idx = 2;
arg6 = (long)lua_tonumber(L, 4)-1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: ByteTensor | [*ByteTensor*] [*LongTensor*] ByteTensor index", type_buf);
}
if(argset == 1)
{
arg2 = THByteTensor_minall(arg1);
lua_pushnumber(L, (lua_Number)arg2);
return 1;
}
else if(argset == 2)
{
if(arg3_idx)
lua_pushvalue(L, arg3_idx);
else
luaT_pushudata(L, arg3, "torch.ByteTensor");
if(arg4_idx)
lua_pushvalue(L, arg4_idx);
else
luaT_pushudata(L, arg4, "torch.LongTensor");
THByteTensor_min(arg3,arg4,arg5,arg6,arg7);
THLongTensor_add(arg4, arg4, 1);
return 2;
}
return 0;
}

static int torch_min(lua_State *L)
{
  int narg = lua_gettop(L);
  const void *tname;
  if(narg >= 1 && (tname = torch_istensortype(L, luaT_typename(L, 1)))) /* first argument is tensor? */
  {
  }
  else if(narg >= 2 && (tname = torch_istensortype(L, luaT_typename(L, 2)))) /* second? */
  {
  }
  else if(narg >= 1 && (tname = torch_istensorarray(L, 1))) /* torch table argument? */
  {
  }
  else if(narg >= 1 && lua_type(L, narg) == LUA_TSTRING
	  && (tname = torch_istensortype(L, lua_tostring(L, narg)))) /* do we have a valid tensor type string then? */
  {
    lua_remove(L, -2);
  }
  else if(!(tname = torch_istensortype(L, torch_getdefaulttensortype(L))))
    luaL_error(L, "internal error: the default tensor type does not seem to be an actual tensor");

  lua_pushstring(L, "min");
  lua_rawget(L, -2);
  if(lua_isfunction(L, -1))
  {
    lua_insert(L, 1);
    lua_pop(L, 2); /* the two tables we put on the stack above */
    lua_call(L, lua_gettop(L)-1, LUA_MULTRET);
  }
  else
    return luaL_error(L, "%s does not implement the torch.min() function", tname);

  return lua_gettop(L);
}

static int torch_ByteTensor_max(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THByteTensor *arg1 = NULL;
unsigned char arg2 = 0;
THByteTensor *arg3 = NULL;
int arg3_idx = 0;
THLongTensor *arg4 = NULL;
int arg4_idx = 0;
THByteTensor *arg5 = NULL;
long arg6 = 0;
int arg7 = 1;
if(narg == 1
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
)
{
argset = 1;
}
else if(narg == 2
&& (arg5 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 2;
arg6 = (long)lua_tonumber(L, 2)-1;
arg3 = THByteTensor_new();
arg4 = THLongTensor_new();
}
else if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg3_idx = 1;
arg6 = (long)lua_tonumber(L, 3)-1;
arg4 = THLongTensor_new();
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg4_idx = 1;
arg6 = (long)lua_tonumber(L, 3)-1;
arg3 = THByteTensor_new();
}
else if(narg == 4
&& (arg3 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg4 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg5 = luaT_toudata(L, 3, "torch.ByteTensor"))
&& lua_isnumber(L, 4)
)
{
argset = 2;
arg3_idx = 1;
arg4_idx = 2;
arg6 = (long)lua_tonumber(L, 4)-1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: ByteTensor | [*ByteTensor*] [*LongTensor*] ByteTensor index", type_buf);
}
if(argset == 1)
{
arg2 = THByteTensor_maxall(arg1);
lua_pushnumber(L, (lua_Number)arg2);
return 1;
}
else if(argset == 2)
{
if(arg3_idx)
lua_pushvalue(L, arg3_idx);
else
luaT_pushudata(L, arg3, "torch.ByteTensor");
if(arg4_idx)
lua_pushvalue(L, arg4_idx);
else
luaT_pushudata(L, arg4, "torch.LongTensor");
THByteTensor_max(arg3,arg4,arg5,arg6,arg7);
THLongTensor_add(arg4, arg4, 1);
return 2;
}
return 0;
}

static int torch_max(lua_State *L)
{
  int narg = lua_gettop(L);
  const void *tname;
  if(narg >= 1 && (tname = torch_istensortype(L, luaT_typename(L, 1)))) /* first argument is tensor? */
  {
  }
  else if(narg >= 2 && (tname = torch_istensortype(L, luaT_typename(L, 2)))) /* second? */
  {
  }
  else if(narg >= 1 && (tname = torch_istensorarray(L, 1))) /* torch table argument? */
  {
  }
  else if(narg >= 1 && lua_type(L, narg) == LUA_TSTRING
	  && (tname = torch_istensortype(L, lua_tostring(L, narg)))) /* do we have a valid tensor type string then? */
  {
    lua_remove(L, -2);
  }
  else if(!(tname = torch_istensortype(L, torch_getdefaulttensortype(L))))
    luaL_error(L, "internal error: the default tensor type does not seem to be an actual tensor");

  lua_pushstring(L, "max");
  lua_rawget(L, -2);
  if(lua_isfunction(L, -1))
  {
    lua_insert(L, 1);
    lua_pop(L, 2); /* the two tables we put on the stack above */
    lua_call(L, lua_gettop(L)-1, LUA_MULTRET);
  }
  else
    return luaL_error(L, "%s does not implement the torch.max() function", tname);

  return lua_gettop(L);
}

static int torch_ByteTensor_cmin(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
THByteTensor *arg3 = NULL;
THByteTensor *arg4 = NULL;
int arg4_idx = 0;
THByteTensor *arg5 = NULL;
unsigned char arg6 = 0;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
)
{
argset = 1;
arg1 = THByteTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
)
{
argset = 1;
arg1_idx = 1;
}
else if(narg == 2
&& (arg5 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 2;
arg6 = (unsigned char)lua_tonumber(L, 2);
arg4 = THByteTensor_new();
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg4_idx = 1;
arg6 = (unsigned char)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] ByteTensor ByteTensor | [*ByteTensor*] ByteTensor unsigned char", type_buf);
}
if(argset == 1)
{
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THByteTensor_cmin(arg1,arg2,arg3);
return 1;
}
else if(argset == 2)
{
if(arg4_idx)
lua_pushvalue(L, arg4_idx);
else
luaT_pushudata(L, arg4, "torch.ByteTensor");
THByteTensor_cminValue(arg4,arg5,arg6);
return 1;
}
return 0;
}

static int torch_cmin(lua_State *L)
{
  int narg = lua_gettop(L);
  const void *tname;
  if(narg >= 1 && (tname = torch_istensortype(L, luaT_typename(L, 1)))) /* first argument is tensor? */
  {
  }
  else if(narg >= 2 && (tname = torch_istensortype(L, luaT_typename(L, 2)))) /* second? */
  {
  }
  else if(narg >= 1 && (tname = torch_istensorarray(L, 1))) /* torch table argument? */
  {
  }
  else if(narg >= 1 && lua_type(L, narg) == LUA_TSTRING
	  && (tname = torch_istensortype(L, lua_tostring(L, narg)))) /* do we have a valid tensor type string then? */
  {
    lua_remove(L, -2);
  }
  else if(!(tname = torch_istensortype(L, torch_getdefaulttensortype(L))))
    luaL_error(L, "internal error: the default tensor type does not seem to be an actual tensor");

  lua_pushstring(L, "cmin");
  lua_rawget(L, -2);
  if(lua_isfunction(L, -1))
  {
    lua_insert(L, 1);
    lua_pop(L, 2); /* the two tables we put on the stack above */
    lua_call(L, lua_gettop(L)-1, LUA_MULTRET);
  }
  else
    return luaL_error(L, "%s does not implement the torch.cmin() function", tname);

  return lua_gettop(L);
}

static int torch_ByteTensor_cmax(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
THByteTensor *arg3 = NULL;
THByteTensor *arg4 = NULL;
int arg4_idx = 0;
THByteTensor *arg5 = NULL;
unsigned char arg6 = 0;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
)
{
argset = 1;
arg1 = THByteTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
)
{
argset = 1;
arg1_idx = 1;
}
else if(narg == 2
&& (arg5 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 2;
arg6 = (unsigned char)lua_tonumber(L, 2);
arg4 = THByteTensor_new();
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg4_idx = 1;
arg6 = (unsigned char)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] ByteTensor ByteTensor | [*ByteTensor*] ByteTensor unsigned char", type_buf);
}
if(argset == 1)
{
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THByteTensor_cmax(arg1,arg2,arg3);
return 1;
}
else if(argset == 2)
{
if(arg4_idx)
lua_pushvalue(L, arg4_idx);
else
luaT_pushudata(L, arg4, "torch.ByteTensor");
THByteTensor_cmaxValue(arg4,arg5,arg6);
return 1;
}
return 0;
}

static int torch_cmax(lua_State *L)
{
  int narg = lua_gettop(L);
  const void *tname;
  if(narg >= 1 && (tname = torch_istensortype(L, luaT_typename(L, 1)))) /* first argument is tensor? */
  {
  }
  else if(narg >= 2 && (tname = torch_istensortype(L, luaT_typename(L, 2)))) /* second? */
  {
  }
  else if(narg >= 1 && (tname = torch_istensorarray(L, 1))) /* torch table argument? */
  {
  }
  else if(narg >= 1 && lua_type(L, narg) == LUA_TSTRING
	  && (tname = torch_istensortype(L, lua_tostring(L, narg)))) /* do we have a valid tensor type string then? */
  {
    lua_remove(L, -2);
  }
  else if(!(tname = torch_istensortype(L, torch_getdefaulttensortype(L))))
    luaL_error(L, "internal error: the default tensor type does not seem to be an actual tensor");

  lua_pushstring(L, "cmax");
  lua_rawget(L, -2);
  if(lua_isfunction(L, -1))
  {
    lua_insert(L, 1);
    lua_pop(L, 2); /* the two tables we put on the stack above */
    lua_call(L, lua_gettop(L)-1, LUA_MULTRET);
  }
  else
    return luaL_error(L, "%s does not implement the torch.cmax() function", tname);

  return lua_gettop(L);
}

static int torch_ByteTensor_trace(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
long arg2 = 0;
if(narg == 1
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
)
{
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: ByteTensor", type_buf);
}
arg2 = THByteTensor_trace(arg1);
lua_pushnumber(L, (lua_Number)arg2);
return 1;
}

static int torch_trace(lua_State *L)
{
  int narg = lua_gettop(L);
  const void *tname;
  if(narg >= 1 && (tname = torch_istensortype(L, luaT_typename(L, 1)))) /* first argument is tensor? */
  {
  }
  else if(narg >= 2 && (tname = torch_istensortype(L, luaT_typename(L, 2)))) /* second? */
  {
  }
  else if(narg >= 1 && (tname = torch_istensorarray(L, 1))) /* torch table argument? */
  {
  }
  else if(narg >= 1 && lua_type(L, narg) == LUA_TSTRING
	  && (tname = torch_istensortype(L, lua_tostring(L, narg)))) /* do we have a valid tensor type string then? */
  {
    lua_remove(L, -2);
  }
  else if(!(tname = torch_istensortype(L, torch_getdefaulttensortype(L))))
    luaL_error(L, "internal error: the default tensor type does not seem to be an actual tensor");

  lua_pushstring(L, "trace");
  lua_rawget(L, -2);
  if(lua_isfunction(L, -1))
  {
    lua_insert(L, 1);
    lua_pop(L, 2); /* the two tables we put on the stack above */
    lua_call(L, lua_gettop(L)-1, LUA_MULTRET);
  }
  else
    return luaL_error(L, "%s does not implement the torch.trace() function", tname);

  return lua_gettop(L);
}

static int torch_ByteTensor_cross(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
THByteTensor *arg3 = NULL;
long arg4 = -1;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
)
{
arg1 = THByteTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
)
{
arg1_idx = 1;
}
else if(narg == 3
&& (arg2 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
arg4 = (long)lua_tonumber(L, 3)-1;
arg1 = THByteTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
&& lua_isnumber(L, 4)
)
{
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 4)-1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] ByteTensor ByteTensor [index]", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THByteTensor_cross(arg1,arg2,arg3,arg4);
return 1;
}

static int torch_cross(lua_State *L)
{
  int narg = lua_gettop(L);
  const void *tname;
  if(narg >= 1 && (tname = torch_istensortype(L, luaT_typename(L, 1)))) /* first argument is tensor? */
  {
  }
  else if(narg >= 2 && (tname = torch_istensortype(L, luaT_typename(L, 2)))) /* second? */
  {
  }
  else if(narg >= 1 && (tname = torch_istensorarray(L, 1))) /* torch table argument? */
  {
  }
  else if(narg >= 1 && lua_type(L, narg) == LUA_TSTRING
	  && (tname = torch_istensortype(L, lua_tostring(L, narg)))) /* do we have a valid tensor type string then? */
  {
    lua_remove(L, -2);
  }
  else if(!(tname = torch_istensortype(L, torch_getdefaulttensortype(L))))
    luaL_error(L, "internal error: the default tensor type does not seem to be an actual tensor");

  lua_pushstring(L, "cross");
  lua_rawget(L, -2);
  if(lua_isfunction(L, -1))
  {
    lua_insert(L, 1);
    lua_pop(L, 2); /* the two tables we put on the stack above */
    lua_call(L, lua_gettop(L)-1, LUA_MULTRET);
  }
  else
    return luaL_error(L, "%s does not implement the torch.cross() function", tname);

  return lua_gettop(L);
}

static int torch_ByteTensor_diag(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
long arg3 = 0;
if(narg == 1
&& (arg2 = luaT_toudata(L, 1, "torch.ByteTensor"))
)
{
arg1 = THByteTensor_new();
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
)
{
arg1_idx = 1;
}
else if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
)
{
arg3 = (long)lua_tonumber(L, 2);
arg1 = THByteTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (long)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] ByteTensor [long]", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THByteTensor_diag(arg1,arg2,arg3);
return 1;
}

static int torch_diag(lua_State *L)
{
  int narg = lua_gettop(L);
  const void *tname;
  if(narg >= 1 && (tname = torch_istensortype(L, luaT_typename(L, 1)))) /* first argument is tensor? */
  {
  }
  else if(narg >= 2 && (tname = torch_istensortype(L, luaT_typename(L, 2)))) /* second? */
  {
  }
  else if(narg >= 1 && (tname = torch_istensorarray(L, 1))) /* torch table argument? */
  {
  }
  else if(narg >= 1 && lua_type(L, narg) == LUA_TSTRING
	  && (tname = torch_istensortype(L, lua_tostring(L, narg)))) /* do we have a valid tensor type string then? */
  {
    lua_remove(L, -2);
  }
  else if(!(tname = torch_istensortype(L, torch_getdefaulttensortype(L))))
    luaL_error(L, "internal error: the default tensor type does not seem to be an actual tensor");

  lua_pushstring(L, "diag");
  lua_rawget(L, -2);
  if(lua_isfunction(L, -1))
  {
    lua_insert(L, 1);
    lua_pop(L, 2); /* the two tables we put on the stack above */
    lua_call(L, lua_gettop(L)-1, LUA_MULTRET);
  }
  else
    return luaL_error(L, "%s does not implement the torch.diag() function", tname);

  return lua_gettop(L);
}

static int torch_ByteTensor_eye(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
long arg2 = 0;
long arg3 = 0;
if(narg == 1
&& lua_isnumber(L, 1)
)
{
arg2 = (long)lua_tonumber(L, 1);
arg1 = THByteTensor_new();
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
)
{
arg1_idx = 1;
arg2 = (long)lua_tonumber(L, 2);
}
else if(narg == 2
&& lua_isnumber(L, 1)
&& lua_isnumber(L, 2)
)
{
arg2 = (long)lua_tonumber(L, 1);
arg3 = (long)lua_tonumber(L, 2);
arg1 = THByteTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg2 = (long)lua_tonumber(L, 2);
arg3 = (long)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] long [long]", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THByteTensor_eye(arg1,arg2,arg3);
return 1;
}

static int torch_eye(lua_State *L)
{
  int narg = lua_gettop(L);
  const void *tname;
  if(narg >= 1 && (tname = torch_istensortype(L, luaT_typename(L, 1)))) /* first argument is tensor? */
  {
  }
  else if(narg >= 2 && (tname = torch_istensortype(L, luaT_typename(L, 2)))) /* second? */
  {
  }
  else if(narg >= 1 && (tname = torch_istensorarray(L, 1))) /* torch table argument? */
  {
  }
  else if(narg >= 1 && lua_type(L, narg) == LUA_TSTRING
	  && (tname = torch_istensortype(L, lua_tostring(L, narg)))) /* do we have a valid tensor type string then? */
  {
    lua_remove(L, -2);
  }
  else if(!(tname = torch_istensortype(L, torch_getdefaulttensortype(L))))
    luaL_error(L, "internal error: the default tensor type does not seem to be an actual tensor");

  lua_pushstring(L, "eye");
  lua_rawget(L, -2);
  if(lua_isfunction(L, -1))
  {
    lua_insert(L, 1);
    lua_pop(L, 2); /* the two tables we put on the stack above */
    lua_call(L, lua_gettop(L)-1, LUA_MULTRET);
  }
  else
    return luaL_error(L, "%s does not implement the torch.eye() function", tname);

  return lua_gettop(L);
}

static int torch_ByteTensor_range(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
long arg2 = 0;
long arg3 = 0;
long arg4 = 1;
if(narg == 2
&& lua_isnumber(L, 1)
&& lua_isnumber(L, 2)
)
{
arg2 = (long)lua_tonumber(L, 1);
arg3 = (long)lua_tonumber(L, 2);
arg1 = THByteTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg2 = (long)lua_tonumber(L, 2);
arg3 = (long)lua_tonumber(L, 3);
}
else if(narg == 3
&& lua_isnumber(L, 1)
&& lua_isnumber(L, 2)
&& lua_isnumber(L, 3)
)
{
arg2 = (long)lua_tonumber(L, 1);
arg3 = (long)lua_tonumber(L, 2);
arg4 = (long)lua_tonumber(L, 3);
arg1 = THByteTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
&& lua_isnumber(L, 3)
&& lua_isnumber(L, 4)
)
{
arg1_idx = 1;
arg2 = (long)lua_tonumber(L, 2);
arg3 = (long)lua_tonumber(L, 3);
arg4 = (long)lua_tonumber(L, 4);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] long long [long]", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THByteTensor_range(arg1,arg2,arg3,arg4);
return 1;
}

static int torch_range(lua_State *L)
{
  int narg = lua_gettop(L);
  const void *tname;
  if(narg >= 1 && (tname = torch_istensortype(L, luaT_typename(L, 1)))) /* first argument is tensor? */
  {
  }
  else if(narg >= 2 && (tname = torch_istensortype(L, luaT_typename(L, 2)))) /* second? */
  {
  }
  else if(narg >= 1 && (tname = torch_istensorarray(L, 1))) /* torch table argument? */
  {
  }
  else if(narg >= 1 && lua_type(L, narg) == LUA_TSTRING
	  && (tname = torch_istensortype(L, lua_tostring(L, narg)))) /* do we have a valid tensor type string then? */
  {
    lua_remove(L, -2);
  }
  else if(!(tname = torch_istensortype(L, torch_getdefaulttensortype(L))))
    luaL_error(L, "internal error: the default tensor type does not seem to be an actual tensor");

  lua_pushstring(L, "range");
  lua_rawget(L, -2);
  if(lua_isfunction(L, -1))
  {
    lua_insert(L, 1);
    lua_pop(L, 2); /* the two tables we put on the stack above */
    lua_call(L, lua_gettop(L)-1, LUA_MULTRET);
  }
  else
    return luaL_error(L, "%s does not implement the torch.range() function", tname);

  return lua_gettop(L);
}

static int torch_ByteTensor_randperm(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THGenerator *arg2 = NULL;
long arg3 = 0;
if(narg == 1
&& lua_isnumber(L, 1)
)
{
arg3 = (long)lua_tonumber(L, 1);
arg1 = THByteTensor_new();
lua_getglobal(L,"torch");
arg2 = luaT_getfieldcheckudata(L, -1, "_gen", torch_Generator);
lua_pop(L, 2);
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
)
{
arg1_idx = 1;
arg3 = (long)lua_tonumber(L, 2);
lua_getglobal(L,"torch");
arg2 = luaT_getfieldcheckudata(L, -1, "_gen", torch_Generator);
lua_pop(L, 2);
}
else if(narg == 2
&& (arg2 = luaT_toudata(L, 1, torch_Generator))
&& lua_isnumber(L, 2)
)
{
arg3 = (long)lua_tonumber(L, 2);
arg1 = THByteTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, torch_Generator))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (long)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] [Generator] long", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THByteTensor_randperm(arg1,arg2,arg3);

THByteTensor_add(arg1, arg1, 1);
return 1;
}

static int torch_randperm(lua_State *L)
{
  int narg = lua_gettop(L);
  const void *tname;
  if(narg >= 1 && (tname = torch_istensortype(L, luaT_typename(L, 1)))) /* first argument is tensor? */
  {
  }
  else if(narg >= 2 && (tname = torch_istensortype(L, luaT_typename(L, 2)))) /* second? */
  {
  }
  else if(narg >= 1 && (tname = torch_istensorarray(L, 1))) /* torch table argument? */
  {
  }
  else if(narg >= 1 && lua_type(L, narg) == LUA_TSTRING
	  && (tname = torch_istensortype(L, lua_tostring(L, narg)))) /* do we have a valid tensor type string then? */
  {
    lua_remove(L, -2);
  }
  else if(!(tname = torch_istensortype(L, torch_getdefaulttensortype(L))))
    luaL_error(L, "internal error: the default tensor type does not seem to be an actual tensor");

  lua_pushstring(L, "randperm");
  lua_rawget(L, -2);
  if(lua_isfunction(L, -1))
  {
    lua_insert(L, 1);
    lua_pop(L, 2); /* the two tables we put on the stack above */
    lua_call(L, lua_gettop(L)-1, LUA_MULTRET);
  }
  else
    return luaL_error(L, "%s does not implement the torch.randperm() function", tname);

  return lua_gettop(L);
}

static int torch_ByteTensor_sort(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THLongTensor *arg2 = NULL;
int arg2_idx = 0;
THByteTensor *arg3 = NULL;
long arg4 = 0;
int arg5 = 0;
if(narg == 1
&& (arg3 = luaT_toudata(L, 1, "torch.ByteTensor"))
)
{
arg1 = THByteTensor_new();
arg2 = THLongTensor_new();
arg4 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
)
{
arg1_idx = 1;
arg2 = THLongTensor_new();
arg4 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
)
{
arg2_idx = 1;
arg1 = THByteTensor_new();
arg4 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 2
&& (arg3 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
)
{
arg4 = (long)lua_tonumber(L, 2)-1;
arg1 = THByteTensor_new();
arg2 = THLongTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 3)-1;
arg2 = THLongTensor_new();
}
else if(narg == 3
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
arg2_idx = 1;
arg4 = (long)lua_tonumber(L, 3)-1;
arg1 = THByteTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
&& lua_isnumber(L, 4)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = (long)lua_tonumber(L, 4)-1;
}
else if(narg == 2
&& (arg3 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isboolean(L, 2)
)
{
arg5 = lua_toboolean(L, 2);
arg1 = THByteTensor_new();
arg2 = THLongTensor_new();
arg4 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isboolean(L, 3)
)
{
arg1_idx = 1;
arg5 = lua_toboolean(L, 3);
arg2 = THLongTensor_new();
arg4 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isboolean(L, 3)
)
{
arg2_idx = 1;
arg5 = lua_toboolean(L, 3);
arg1 = THByteTensor_new();
arg4 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
&& lua_isboolean(L, 4)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg5 = lua_toboolean(L, 4);
arg4 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
&& lua_isboolean(L, 3)
)
{
arg4 = (long)lua_tonumber(L, 2)-1;
arg5 = lua_toboolean(L, 3);
arg1 = THByteTensor_new();
arg2 = THLongTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
)
{
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 3)-1;
arg5 = lua_toboolean(L, 4);
arg2 = THLongTensor_new();
}
else if(narg == 4
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
)
{
arg2_idx = 1;
arg4 = (long)lua_tonumber(L, 3)-1;
arg5 = lua_toboolean(L, 4);
arg1 = THByteTensor_new();
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
&& lua_isnumber(L, 4)
&& lua_isboolean(L, 5)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = (long)lua_tonumber(L, 4)-1;
arg5 = lua_toboolean(L, 5);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] [*LongTensor*] ByteTensor [index] [boolean]", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
if(arg2_idx)
lua_pushvalue(L, arg2_idx);
else
luaT_pushudata(L, arg2, "torch.LongTensor");
THByteTensor_sort(arg1,arg2,arg3,arg4,arg5);
THLongTensor_add(arg2, arg2, 1);
return 2;
}

static int torch_sort(lua_State *L)
{
  int narg = lua_gettop(L);
  const void *tname;
  if(narg >= 1 && (tname = torch_istensortype(L, luaT_typename(L, 1)))) /* first argument is tensor? */
  {
  }
  else if(narg >= 2 && (tname = torch_istensortype(L, luaT_typename(L, 2)))) /* second? */
  {
  }
  else if(narg >= 1 && (tname = torch_istensorarray(L, 1))) /* torch table argument? */
  {
  }
  else if(narg >= 1 && lua_type(L, narg) == LUA_TSTRING
	  && (tname = torch_istensortype(L, lua_tostring(L, narg)))) /* do we have a valid tensor type string then? */
  {
    lua_remove(L, -2);
  }
  else if(!(tname = torch_istensortype(L, torch_getdefaulttensortype(L))))
    luaL_error(L, "internal error: the default tensor type does not seem to be an actual tensor");

  lua_pushstring(L, "sort");
  lua_rawget(L, -2);
  if(lua_isfunction(L, -1))
  {
    lua_insert(L, 1);
    lua_pop(L, 2); /* the two tables we put on the stack above */
    lua_call(L, lua_gettop(L)-1, LUA_MULTRET);
  }
  else
    return luaL_error(L, "%s does not implement the torch.sort() function", tname);

  return lua_gettop(L);
}

static int torch_ByteTensor_topk(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THLongTensor *arg2 = NULL;
int arg2_idx = 0;
THByteTensor *arg3 = NULL;
long arg4 = 1;
long arg5 = 0;
int arg6 = 0;
int arg7 = 0;
if(narg == 1
&& (arg3 = luaT_toudata(L, 1, "torch.ByteTensor"))
)
{
arg1 = THByteTensor_new();
arg2 = THLongTensor_new();
arg5 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
)
{
arg1_idx = 1;
arg2 = THLongTensor_new();
arg5 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
)
{
arg2_idx = 1;
arg1 = THByteTensor_new();
arg5 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
)
{
arg1_idx = 1;
arg2_idx = 2;
arg5 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 2
&& (arg3 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
)
{
arg4 = (long)lua_tonumber(L, 2);
arg1 = THByteTensor_new();
arg2 = THLongTensor_new();
arg5 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg2 = THLongTensor_new();
arg5 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
arg2_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg1 = THByteTensor_new();
arg5 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
&& lua_isnumber(L, 4)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = (long)lua_tonumber(L, 4);
arg5 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 2
&& (arg3 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
)
{
arg5 = (long)lua_tonumber(L, 2)-1;
arg1 = THByteTensor_new();
arg2 = THLongTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg5 = (long)lua_tonumber(L, 3)-1;
arg2 = THLongTensor_new();
}
else if(narg == 3
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
arg2_idx = 1;
arg5 = (long)lua_tonumber(L, 3)-1;
arg1 = THByteTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
&& lua_isnumber(L, 4)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg5 = (long)lua_tonumber(L, 4)-1;
}
else if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
&& lua_isnumber(L, 3)
)
{
arg4 = (long)lua_tonumber(L, 2);
arg5 = (long)lua_tonumber(L, 3)-1;
arg1 = THByteTensor_new();
arg2 = THLongTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
&& lua_isnumber(L, 4)
)
{
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg5 = (long)lua_tonumber(L, 4)-1;
arg2 = THLongTensor_new();
}
else if(narg == 4
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
&& lua_isnumber(L, 4)
)
{
arg2_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg5 = (long)lua_tonumber(L, 4)-1;
arg1 = THByteTensor_new();
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
&& lua_isnumber(L, 4)
&& lua_isnumber(L, 5)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = (long)lua_tonumber(L, 4);
arg5 = (long)lua_tonumber(L, 5)-1;
}
else if(narg == 2
&& (arg3 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isboolean(L, 2)
)
{
arg6 = lua_toboolean(L, 2);
arg1 = THByteTensor_new();
arg2 = THLongTensor_new();
arg5 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isboolean(L, 3)
)
{
arg1_idx = 1;
arg6 = lua_toboolean(L, 3);
arg2 = THLongTensor_new();
arg5 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isboolean(L, 3)
)
{
arg2_idx = 1;
arg6 = lua_toboolean(L, 3);
arg1 = THByteTensor_new();
arg5 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
&& lua_isboolean(L, 4)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg6 = lua_toboolean(L, 4);
arg5 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
&& lua_isboolean(L, 3)
)
{
arg4 = (long)lua_tonumber(L, 2);
arg6 = lua_toboolean(L, 3);
arg1 = THByteTensor_new();
arg2 = THLongTensor_new();
arg5 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
)
{
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg6 = lua_toboolean(L, 4);
arg2 = THLongTensor_new();
arg5 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 4
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
)
{
arg2_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg6 = lua_toboolean(L, 4);
arg1 = THByteTensor_new();
arg5 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
&& lua_isnumber(L, 4)
&& lua_isboolean(L, 5)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = (long)lua_tonumber(L, 4);
arg6 = lua_toboolean(L, 5);
arg5 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
&& lua_isboolean(L, 3)
)
{
arg5 = (long)lua_tonumber(L, 2)-1;
arg6 = lua_toboolean(L, 3);
arg1 = THByteTensor_new();
arg2 = THLongTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
)
{
arg1_idx = 1;
arg5 = (long)lua_tonumber(L, 3)-1;
arg6 = lua_toboolean(L, 4);
arg2 = THLongTensor_new();
}
else if(narg == 4
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
)
{
arg2_idx = 1;
arg5 = (long)lua_tonumber(L, 3)-1;
arg6 = lua_toboolean(L, 4);
arg1 = THByteTensor_new();
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
&& lua_isnumber(L, 4)
&& lua_isboolean(L, 5)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg5 = (long)lua_tonumber(L, 4)-1;
arg6 = lua_toboolean(L, 5);
}
else if(narg == 4
&& (arg3 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
)
{
arg4 = (long)lua_tonumber(L, 2);
arg5 = (long)lua_tonumber(L, 3)-1;
arg6 = lua_toboolean(L, 4);
arg1 = THByteTensor_new();
arg2 = THLongTensor_new();
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
&& lua_isnumber(L, 4)
&& lua_isboolean(L, 5)
)
{
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg5 = (long)lua_tonumber(L, 4)-1;
arg6 = lua_toboolean(L, 5);
arg2 = THLongTensor_new();
}
else if(narg == 5
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
&& lua_isnumber(L, 4)
&& lua_isboolean(L, 5)
)
{
arg2_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg5 = (long)lua_tonumber(L, 4)-1;
arg6 = lua_toboolean(L, 5);
arg1 = THByteTensor_new();
}
else if(narg == 6
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
&& lua_isnumber(L, 4)
&& lua_isnumber(L, 5)
&& lua_isboolean(L, 6)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = (long)lua_tonumber(L, 4);
arg5 = (long)lua_tonumber(L, 5)-1;
arg6 = lua_toboolean(L, 6);
}
else if(narg == 2
&& (arg3 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isboolean(L, 2)
)
{
arg7 = lua_toboolean(L, 2);
arg1 = THByteTensor_new();
arg2 = THLongTensor_new();
arg5 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isboolean(L, 3)
)
{
arg1_idx = 1;
arg7 = lua_toboolean(L, 3);
arg2 = THLongTensor_new();
arg5 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isboolean(L, 3)
)
{
arg2_idx = 1;
arg7 = lua_toboolean(L, 3);
arg1 = THByteTensor_new();
arg5 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
&& lua_isboolean(L, 4)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg7 = lua_toboolean(L, 4);
arg5 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
&& lua_isboolean(L, 3)
)
{
arg4 = (long)lua_tonumber(L, 2);
arg7 = lua_toboolean(L, 3);
arg1 = THByteTensor_new();
arg2 = THLongTensor_new();
arg5 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
)
{
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg7 = lua_toboolean(L, 4);
arg2 = THLongTensor_new();
arg5 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 4
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
)
{
arg2_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg7 = lua_toboolean(L, 4);
arg1 = THByteTensor_new();
arg5 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
&& lua_isnumber(L, 4)
&& lua_isboolean(L, 5)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = (long)lua_tonumber(L, 4);
arg7 = lua_toboolean(L, 5);
arg5 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
&& lua_isboolean(L, 3)
)
{
arg5 = (long)lua_tonumber(L, 2)-1;
arg7 = lua_toboolean(L, 3);
arg1 = THByteTensor_new();
arg2 = THLongTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
)
{
arg1_idx = 1;
arg5 = (long)lua_tonumber(L, 3)-1;
arg7 = lua_toboolean(L, 4);
arg2 = THLongTensor_new();
}
else if(narg == 4
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
)
{
arg2_idx = 1;
arg5 = (long)lua_tonumber(L, 3)-1;
arg7 = lua_toboolean(L, 4);
arg1 = THByteTensor_new();
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
&& lua_isnumber(L, 4)
&& lua_isboolean(L, 5)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg5 = (long)lua_tonumber(L, 4)-1;
arg7 = lua_toboolean(L, 5);
}
else if(narg == 4
&& (arg3 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
)
{
arg4 = (long)lua_tonumber(L, 2);
arg5 = (long)lua_tonumber(L, 3)-1;
arg7 = lua_toboolean(L, 4);
arg1 = THByteTensor_new();
arg2 = THLongTensor_new();
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
&& lua_isnumber(L, 4)
&& lua_isboolean(L, 5)
)
{
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg5 = (long)lua_tonumber(L, 4)-1;
arg7 = lua_toboolean(L, 5);
arg2 = THLongTensor_new();
}
else if(narg == 5
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
&& lua_isnumber(L, 4)
&& lua_isboolean(L, 5)
)
{
arg2_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg5 = (long)lua_tonumber(L, 4)-1;
arg7 = lua_toboolean(L, 5);
arg1 = THByteTensor_new();
}
else if(narg == 6
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
&& lua_isnumber(L, 4)
&& lua_isnumber(L, 5)
&& lua_isboolean(L, 6)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = (long)lua_tonumber(L, 4);
arg5 = (long)lua_tonumber(L, 5)-1;
arg7 = lua_toboolean(L, 6);
}
else if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isboolean(L, 2)
&& lua_isboolean(L, 3)
)
{
arg6 = lua_toboolean(L, 2);
arg7 = lua_toboolean(L, 3);
arg1 = THByteTensor_new();
arg2 = THLongTensor_new();
arg5 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isboolean(L, 3)
&& lua_isboolean(L, 4)
)
{
arg1_idx = 1;
arg6 = lua_toboolean(L, 3);
arg7 = lua_toboolean(L, 4);
arg2 = THLongTensor_new();
arg5 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 4
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isboolean(L, 3)
&& lua_isboolean(L, 4)
)
{
arg2_idx = 1;
arg6 = lua_toboolean(L, 3);
arg7 = lua_toboolean(L, 4);
arg1 = THByteTensor_new();
arg5 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
&& lua_isboolean(L, 4)
&& lua_isboolean(L, 5)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg6 = lua_toboolean(L, 4);
arg7 = lua_toboolean(L, 5);
arg5 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 4
&& (arg3 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
&& lua_isboolean(L, 3)
&& lua_isboolean(L, 4)
)
{
arg4 = (long)lua_tonumber(L, 2);
arg6 = lua_toboolean(L, 3);
arg7 = lua_toboolean(L, 4);
arg1 = THByteTensor_new();
arg2 = THLongTensor_new();
arg5 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
&& lua_isboolean(L, 5)
)
{
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg6 = lua_toboolean(L, 4);
arg7 = lua_toboolean(L, 5);
arg2 = THLongTensor_new();
arg5 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 5
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
&& lua_isboolean(L, 5)
)
{
arg2_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg6 = lua_toboolean(L, 4);
arg7 = lua_toboolean(L, 5);
arg1 = THByteTensor_new();
arg5 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 6
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
&& lua_isnumber(L, 4)
&& lua_isboolean(L, 5)
&& lua_isboolean(L, 6)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = (long)lua_tonumber(L, 4);
arg6 = lua_toboolean(L, 5);
arg7 = lua_toboolean(L, 6);
arg5 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 4
&& (arg3 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
&& lua_isboolean(L, 3)
&& lua_isboolean(L, 4)
)
{
arg5 = (long)lua_tonumber(L, 2)-1;
arg6 = lua_toboolean(L, 3);
arg7 = lua_toboolean(L, 4);
arg1 = THByteTensor_new();
arg2 = THLongTensor_new();
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
&& lua_isboolean(L, 5)
)
{
arg1_idx = 1;
arg5 = (long)lua_tonumber(L, 3)-1;
arg6 = lua_toboolean(L, 4);
arg7 = lua_toboolean(L, 5);
arg2 = THLongTensor_new();
}
else if(narg == 5
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
&& lua_isboolean(L, 5)
)
{
arg2_idx = 1;
arg5 = (long)lua_tonumber(L, 3)-1;
arg6 = lua_toboolean(L, 4);
arg7 = lua_toboolean(L, 5);
arg1 = THByteTensor_new();
}
else if(narg == 6
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
&& lua_isnumber(L, 4)
&& lua_isboolean(L, 5)
&& lua_isboolean(L, 6)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg5 = (long)lua_tonumber(L, 4)-1;
arg6 = lua_toboolean(L, 5);
arg7 = lua_toboolean(L, 6);
}
else if(narg == 5
&& (arg3 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
&& lua_isboolean(L, 5)
)
{
arg4 = (long)lua_tonumber(L, 2);
arg5 = (long)lua_tonumber(L, 3)-1;
arg6 = lua_toboolean(L, 4);
arg7 = lua_toboolean(L, 5);
arg1 = THByteTensor_new();
arg2 = THLongTensor_new();
}
else if(narg == 6
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
&& lua_isnumber(L, 4)
&& lua_isboolean(L, 5)
&& lua_isboolean(L, 6)
)
{
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg5 = (long)lua_tonumber(L, 4)-1;
arg6 = lua_toboolean(L, 5);
arg7 = lua_toboolean(L, 6);
arg2 = THLongTensor_new();
}
else if(narg == 6
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
&& lua_isnumber(L, 4)
&& lua_isboolean(L, 5)
&& lua_isboolean(L, 6)
)
{
arg2_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg5 = (long)lua_tonumber(L, 4)-1;
arg6 = lua_toboolean(L, 5);
arg7 = lua_toboolean(L, 6);
arg1 = THByteTensor_new();
}
else if(narg == 7
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
&& lua_isnumber(L, 4)
&& lua_isnumber(L, 5)
&& lua_isboolean(L, 6)
&& lua_isboolean(L, 7)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = (long)lua_tonumber(L, 4);
arg5 = (long)lua_tonumber(L, 5)-1;
arg6 = lua_toboolean(L, 6);
arg7 = lua_toboolean(L, 7);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] [*LongTensor*] ByteTensor [long] [index] [boolean] [boolean]", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
if(arg2_idx)
lua_pushvalue(L, arg2_idx);
else
luaT_pushudata(L, arg2, "torch.LongTensor");
THByteTensor_topk(arg1,arg2,arg3,arg4,arg5,arg6,arg7);
THLongTensor_add(arg2, arg2, 1);
return 2;
}

static int torch_topk(lua_State *L)
{
  int narg = lua_gettop(L);
  const void *tname;
  if(narg >= 1 && (tname = torch_istensortype(L, luaT_typename(L, 1)))) /* first argument is tensor? */
  {
  }
  else if(narg >= 2 && (tname = torch_istensortype(L, luaT_typename(L, 2)))) /* second? */
  {
  }
  else if(narg >= 1 && (tname = torch_istensorarray(L, 1))) /* torch table argument? */
  {
  }
  else if(narg >= 1 && lua_type(L, narg) == LUA_TSTRING
	  && (tname = torch_istensortype(L, lua_tostring(L, narg)))) /* do we have a valid tensor type string then? */
  {
    lua_remove(L, -2);
  }
  else if(!(tname = torch_istensortype(L, torch_getdefaulttensortype(L))))
    luaL_error(L, "internal error: the default tensor type does not seem to be an actual tensor");

  lua_pushstring(L, "topk");
  lua_rawget(L, -2);
  if(lua_isfunction(L, -1))
  {
    lua_insert(L, 1);
    lua_pop(L, 2); /* the two tables we put on the stack above */
    lua_call(L, lua_gettop(L)-1, LUA_MULTRET);
  }
  else
    return luaL_error(L, "%s does not implement the torch.topk() function", tname);

  return lua_gettop(L);
}

static int torch_ByteTensor_kthvalue(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THLongTensor *arg2 = NULL;
int arg2_idx = 0;
THByteTensor *arg3 = NULL;
long arg4 = 0;
long arg5 = 0;
int arg6 = 1;
if(narg == 2
&& (arg3 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
)
{
arg4 = (long)lua_tonumber(L, 2);
arg1 = THByteTensor_new();
arg2 = THLongTensor_new();
arg5 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg2 = THLongTensor_new();
arg5 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
arg2_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg1 = THByteTensor_new();
arg5 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
&& lua_isnumber(L, 4)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = (long)lua_tonumber(L, 4);
arg5 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
&& lua_isnumber(L, 3)
)
{
arg4 = (long)lua_tonumber(L, 2);
arg5 = (long)lua_tonumber(L, 3)-1;
arg1 = THByteTensor_new();
arg2 = THLongTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
&& lua_isnumber(L, 4)
)
{
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg5 = (long)lua_tonumber(L, 4)-1;
arg2 = THLongTensor_new();
}
else if(narg == 4
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
&& lua_isnumber(L, 4)
)
{
arg2_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg5 = (long)lua_tonumber(L, 4)-1;
arg1 = THByteTensor_new();
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
&& lua_isnumber(L, 4)
&& lua_isnumber(L, 5)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = (long)lua_tonumber(L, 4);
arg5 = (long)lua_tonumber(L, 5)-1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] [*LongTensor*] ByteTensor long [index]", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
if(arg2_idx)
lua_pushvalue(L, arg2_idx);
else
luaT_pushudata(L, arg2, "torch.LongTensor");
THByteTensor_kthvalue(arg1,arg2,arg3,arg4,arg5,arg6);
THLongTensor_add(arg2, arg2, 1);
return 2;
}

static int torch_kthvalue(lua_State *L)
{
  int narg = lua_gettop(L);
  const void *tname;
  if(narg >= 1 && (tname = torch_istensortype(L, luaT_typename(L, 1)))) /* first argument is tensor? */
  {
  }
  else if(narg >= 2 && (tname = torch_istensortype(L, luaT_typename(L, 2)))) /* second? */
  {
  }
  else if(narg >= 1 && (tname = torch_istensorarray(L, 1))) /* torch table argument? */
  {
  }
  else if(narg >= 1 && lua_type(L, narg) == LUA_TSTRING
	  && (tname = torch_istensortype(L, lua_tostring(L, narg)))) /* do we have a valid tensor type string then? */
  {
    lua_remove(L, -2);
  }
  else if(!(tname = torch_istensortype(L, torch_getdefaulttensortype(L))))
    luaL_error(L, "internal error: the default tensor type does not seem to be an actual tensor");

  lua_pushstring(L, "kthvalue");
  lua_rawget(L, -2);
  if(lua_isfunction(L, -1))
  {
    lua_insert(L, 1);
    lua_pop(L, 2); /* the two tables we put on the stack above */
    lua_call(L, lua_gettop(L)-1, LUA_MULTRET);
  }
  else
    return luaL_error(L, "%s does not implement the torch.kthvalue() function", tname);

  return lua_gettop(L);
}

static int torch_ByteTensor_mode(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THLongTensor *arg2 = NULL;
int arg2_idx = 0;
THByteTensor *arg3 = NULL;
long arg4 = 0;
int arg5 = 1;
if(narg == 1
&& (arg3 = luaT_toudata(L, 1, "torch.ByteTensor"))
)
{
arg1 = THByteTensor_new();
arg2 = THLongTensor_new();
arg4 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
)
{
arg1_idx = 1;
arg2 = THLongTensor_new();
arg4 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
)
{
arg2_idx = 1;
arg1 = THByteTensor_new();
arg4 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 2
&& (arg3 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
)
{
arg4 = (long)lua_tonumber(L, 2)-1;
arg1 = THByteTensor_new();
arg2 = THLongTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 3)-1;
arg2 = THLongTensor_new();
}
else if(narg == 3
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
arg2_idx = 1;
arg4 = (long)lua_tonumber(L, 3)-1;
arg1 = THByteTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
&& lua_isnumber(L, 4)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = (long)lua_tonumber(L, 4)-1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] [*LongTensor*] ByteTensor [index]", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
if(arg2_idx)
lua_pushvalue(L, arg2_idx);
else
luaT_pushudata(L, arg2, "torch.LongTensor");
THByteTensor_mode(arg1,arg2,arg3,arg4,arg5);
THLongTensor_add(arg2, arg2, 1);
return 2;
}

static int torch_mode(lua_State *L)
{
  int narg = lua_gettop(L);
  const void *tname;
  if(narg >= 1 && (tname = torch_istensortype(L, luaT_typename(L, 1)))) /* first argument is tensor? */
  {
  }
  else if(narg >= 2 && (tname = torch_istensortype(L, luaT_typename(L, 2)))) /* second? */
  {
  }
  else if(narg >= 1 && (tname = torch_istensorarray(L, 1))) /* torch table argument? */
  {
  }
  else if(narg >= 1 && lua_type(L, narg) == LUA_TSTRING
	  && (tname = torch_istensortype(L, lua_tostring(L, narg)))) /* do we have a valid tensor type string then? */
  {
    lua_remove(L, -2);
  }
  else if(!(tname = torch_istensortype(L, torch_getdefaulttensortype(L))))
    luaL_error(L, "internal error: the default tensor type does not seem to be an actual tensor");

  lua_pushstring(L, "mode");
  lua_rawget(L, -2);
  if(lua_isfunction(L, -1))
  {
    lua_insert(L, 1);
    lua_pop(L, 2); /* the two tables we put on the stack above */
    lua_call(L, lua_gettop(L)-1, LUA_MULTRET);
  }
  else
    return luaL_error(L, "%s does not implement the torch.mode() function", tname);

  return lua_gettop(L);
}

static int torch_ByteTensor_median(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THLongTensor *arg2 = NULL;
int arg2_idx = 0;
THByteTensor *arg3 = NULL;
long arg4 = 0;
int arg5 = 1;
if(narg == 1
&& (arg3 = luaT_toudata(L, 1, "torch.ByteTensor"))
)
{
arg1 = THByteTensor_new();
arg2 = THLongTensor_new();
arg4 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
)
{
arg1_idx = 1;
arg2 = THLongTensor_new();
arg4 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
)
{
arg2_idx = 1;
arg1 = THByteTensor_new();
arg4 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 2
&& (arg3 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
)
{
arg4 = (long)lua_tonumber(L, 2)-1;
arg1 = THByteTensor_new();
arg2 = THLongTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 3)-1;
arg2 = THLongTensor_new();
}
else if(narg == 3
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
arg2_idx = 1;
arg4 = (long)lua_tonumber(L, 3)-1;
arg1 = THByteTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
&& lua_isnumber(L, 4)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = (long)lua_tonumber(L, 4)-1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] [*LongTensor*] ByteTensor [index]", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
if(arg2_idx)
lua_pushvalue(L, arg2_idx);
else
luaT_pushudata(L, arg2, "torch.LongTensor");
THByteTensor_median(arg1,arg2,arg3,arg4,arg5);
THLongTensor_add(arg2, arg2, 1);
return 2;
}

static int torch_median(lua_State *L)
{
  int narg = lua_gettop(L);
  const void *tname;
  if(narg >= 1 && (tname = torch_istensortype(L, luaT_typename(L, 1)))) /* first argument is tensor? */
  {
  }
  else if(narg >= 2 && (tname = torch_istensortype(L, luaT_typename(L, 2)))) /* second? */
  {
  }
  else if(narg >= 1 && (tname = torch_istensorarray(L, 1))) /* torch table argument? */
  {
  }
  else if(narg >= 1 && lua_type(L, narg) == LUA_TSTRING
	  && (tname = torch_istensortype(L, lua_tostring(L, narg)))) /* do we have a valid tensor type string then? */
  {
    lua_remove(L, -2);
  }
  else if(!(tname = torch_istensortype(L, torch_getdefaulttensortype(L))))
    luaL_error(L, "internal error: the default tensor type does not seem to be an actual tensor");

  lua_pushstring(L, "median");
  lua_rawget(L, -2);
  if(lua_isfunction(L, -1))
  {
    lua_insert(L, 1);
    lua_pop(L, 2); /* the two tables we put on the stack above */
    lua_call(L, lua_gettop(L)-1, LUA_MULTRET);
  }
  else
    return luaL_error(L, "%s does not implement the torch.median() function", tname);

  return lua_gettop(L);
}

static int torch_ByteTensor_tril(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
int arg3 = 0;
if(narg == 1
&& (arg2 = luaT_toudata(L, 1, "torch.ByteTensor"))
)
{
arg1 = THByteTensor_new();
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
)
{
arg1_idx = 1;
}
else if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
)
{
arg3 = (int)lua_tonumber(L, 2);
arg1 = THByteTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (int)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] ByteTensor [int]", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THByteTensor_tril(arg1,arg2,arg3);
return 1;
}

static int torch_tril(lua_State *L)
{
  int narg = lua_gettop(L);
  const void *tname;
  if(narg >= 1 && (tname = torch_istensortype(L, luaT_typename(L, 1)))) /* first argument is tensor? */
  {
  }
  else if(narg >= 2 && (tname = torch_istensortype(L, luaT_typename(L, 2)))) /* second? */
  {
  }
  else if(narg >= 1 && (tname = torch_istensorarray(L, 1))) /* torch table argument? */
  {
  }
  else if(narg >= 1 && lua_type(L, narg) == LUA_TSTRING
	  && (tname = torch_istensortype(L, lua_tostring(L, narg)))) /* do we have a valid tensor type string then? */
  {
    lua_remove(L, -2);
  }
  else if(!(tname = torch_istensortype(L, torch_getdefaulttensortype(L))))
    luaL_error(L, "internal error: the default tensor type does not seem to be an actual tensor");

  lua_pushstring(L, "tril");
  lua_rawget(L, -2);
  if(lua_isfunction(L, -1))
  {
    lua_insert(L, 1);
    lua_pop(L, 2); /* the two tables we put on the stack above */
    lua_call(L, lua_gettop(L)-1, LUA_MULTRET);
  }
  else
    return luaL_error(L, "%s does not implement the torch.tril() function", tname);

  return lua_gettop(L);
}

static int torch_ByteTensor_triu(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
int arg3 = 0;
if(narg == 1
&& (arg2 = luaT_toudata(L, 1, "torch.ByteTensor"))
)
{
arg1 = THByteTensor_new();
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
)
{
arg1_idx = 1;
}
else if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
)
{
arg3 = (int)lua_tonumber(L, 2);
arg1 = THByteTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (int)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] ByteTensor [int]", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THByteTensor_triu(arg1,arg2,arg3);
return 1;
}

static int torch_triu(lua_State *L)
{
  int narg = lua_gettop(L);
  const void *tname;
  if(narg >= 1 && (tname = torch_istensortype(L, luaT_typename(L, 1)))) /* first argument is tensor? */
  {
  }
  else if(narg >= 2 && (tname = torch_istensortype(L, luaT_typename(L, 2)))) /* second? */
  {
  }
  else if(narg >= 1 && (tname = torch_istensorarray(L, 1))) /* torch table argument? */
  {
  }
  else if(narg >= 1 && lua_type(L, narg) == LUA_TSTRING
	  && (tname = torch_istensortype(L, lua_tostring(L, narg)))) /* do we have a valid tensor type string then? */
  {
    lua_remove(L, -2);
  }
  else if(!(tname = torch_istensortype(L, torch_getdefaulttensortype(L))))
    luaL_error(L, "internal error: the default tensor type does not seem to be an actual tensor");

  lua_pushstring(L, "triu");
  lua_rawget(L, -2);
  if(lua_isfunction(L, -1))
  {
    lua_insert(L, 1);
    lua_pop(L, 2); /* the two tables we put on the stack above */
    lua_call(L, lua_gettop(L)-1, LUA_MULTRET);
  }
  else
    return luaL_error(L, "%s does not implement the torch.triu() function", tname);

  return lua_gettop(L);
}

static int torch_ByteTensor_cat(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
THByteTensor *arg3 = NULL;
long arg4 = -2;
THByteTensor *arg5 = NULL;
int arg5_idx = 0;
THByteTensor **arg6_data = NULL;
long arg6_size = 0;
int arg6_i = 0;
long arg7 = -2;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
)
{
argset = 1;
arg1 = THByteTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
)
{
argset = 1;
arg1_idx = 1;
}
else if(narg == 3
&& (arg2 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 1;
arg4 = (long)lua_tonumber(L, 3)-1;
arg1 = THByteTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
&& lua_isnumber(L, 4)
)
{
argset = 1;
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 4)-1;
}
else if(narg == 1
&& torch_isnonemptytable(L, 1)
)
{
argset = 2;
do
{
  arg6_size++;
  lua_checkstack(L, 1);
  lua_rawgeti(L, 1, arg6_size);
}
while (!lua_isnil(L, -1));
arg6_size--;
lua_pop(L, 1);
arg6_data = (THByteTensor**)THAlloc(arg6_size * sizeof(THByteTensor*));
for (arg6_i = arg6_size - 1; arg6_i >= 0; arg6_i--)
{
  if (!(arg6_data[arg6_i] = luaT_toudata(L, -1, "torch.ByteTensor")))
    luaL_error(L, "expected ByteTensor in tensor array");
  lua_pop(L, 1);
}

arg5 = THByteTensor_new();
}
else if(narg == 2
&& (arg5 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& torch_isnonemptytable(L, 2)
)
{
argset = 2;
arg5_idx = 1;
do
{
  arg6_size++;
  lua_checkstack(L, 1);
  lua_rawgeti(L, 2, arg6_size);
}
while (!lua_isnil(L, -1));
arg6_size--;
lua_pop(L, 1);
arg6_data = (THByteTensor**)THAlloc(arg6_size * sizeof(THByteTensor*));
for (arg6_i = arg6_size - 1; arg6_i >= 0; arg6_i--)
{
  if (!(arg6_data[arg6_i] = luaT_toudata(L, -1, "torch.ByteTensor")))
    luaL_error(L, "expected ByteTensor in tensor array");
  lua_pop(L, 1);
}

}
else if(narg == 2
&& torch_isnonemptytable(L, 1)
&& lua_isnumber(L, 2)
)
{
argset = 2;
do
{
  arg6_size++;
  lua_checkstack(L, 1);
  lua_rawgeti(L, 1, arg6_size);
}
while (!lua_isnil(L, -1));
arg6_size--;
lua_pop(L, 1);
arg6_data = (THByteTensor**)THAlloc(arg6_size * sizeof(THByteTensor*));
for (arg6_i = arg6_size - 1; arg6_i >= 0; arg6_i--)
{
  if (!(arg6_data[arg6_i] = luaT_toudata(L, -1, "torch.ByteTensor")))
    luaL_error(L, "expected ByteTensor in tensor array");
  lua_pop(L, 1);
}

arg7 = (long)lua_tonumber(L, 2)-1;
arg5 = THByteTensor_new();
}
else if(narg == 3
&& (arg5 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& torch_isnonemptytable(L, 2)
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg5_idx = 1;
do
{
  arg6_size++;
  lua_checkstack(L, 1);
  lua_rawgeti(L, 2, arg6_size);
}
while (!lua_isnil(L, -1));
arg6_size--;
lua_pop(L, 1);
arg6_data = (THByteTensor**)THAlloc(arg6_size * sizeof(THByteTensor*));
for (arg6_i = arg6_size - 1; arg6_i >= 0; arg6_i--)
{
  if (!(arg6_data[arg6_i] = luaT_toudata(L, -1, "torch.ByteTensor")))
    luaL_error(L, "expected ByteTensor in tensor array");
  lua_pop(L, 1);
}

arg7 = (long)lua_tonumber(L, 3)-1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] ByteTensor ByteTensor [index] | [*ByteTensor*] {ByteTensor+} [index]", type_buf);
}
if(argset == 1)
{
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THByteTensor_cat(arg1,arg2,arg3,arg4);
return 1;
}
else if(argset == 2)
{
if(arg5_idx)
lua_pushvalue(L, arg5_idx);
else
luaT_pushudata(L, arg5, "torch.ByteTensor");
THByteTensor_catArray(arg5,arg6_data,arg6_size,arg7);
THFree(arg6_data);
return 1;
}
return 0;
}

static int torch_cat(lua_State *L)
{
  int narg = lua_gettop(L);
  const void *tname;
  if(narg >= 1 && (tname = torch_istensortype(L, luaT_typename(L, 1)))) /* first argument is tensor? */
  {
  }
  else if(narg >= 2 && (tname = torch_istensortype(L, luaT_typename(L, 2)))) /* second? */
  {
  }
  else if(narg >= 1 && (tname = torch_istensorarray(L, 1))) /* torch table argument? */
  {
  }
  else if(narg >= 1 && lua_type(L, narg) == LUA_TSTRING
	  && (tname = torch_istensortype(L, lua_tostring(L, narg)))) /* do we have a valid tensor type string then? */
  {
    lua_remove(L, -2);
  }
  else if(!(tname = torch_istensortype(L, torch_getdefaulttensortype(L))))
    luaL_error(L, "internal error: the default tensor type does not seem to be an actual tensor");

  lua_pushstring(L, "cat");
  lua_rawget(L, -2);
  if(lua_isfunction(L, -1))
  {
    lua_insert(L, 1);
    lua_pop(L, 2); /* the two tables we put on the stack above */
    lua_call(L, lua_gettop(L)-1, LUA_MULTRET);
  }
  else
    return luaL_error(L, "%s does not implement the torch.cat() function", tname);

  return lua_gettop(L);
}

static long THRandom_random2__(THGenerator *gen, long a, long b)
{
  THArgCheck(b >= a, 2, "upper bound must be larger than lower bound");
  return((THRandom_random(gen) % (b+1-a)) + a);
}

static long THRandom_random1__(THGenerator *gen, long b)
{
  THArgCheck(b > 0, 1, "upper bound must be strictly positive");
  return(THRandom_random(gen) % b + 1);
}

static void THByteTensor_random2__(THByteTensor *self, THGenerator *gen, long a, long b)
{
  THArgCheck(b >= a, 2, "upper bound must be larger than lower bound");
  TH_TENSOR_APPLY(unsigned char, self, *self_data = ((THRandom_random(gen) % (b+1-a)) + a);)
}

static void THByteTensor_random1__(THByteTensor *self, THGenerator *gen, long b)
{
  THArgCheck(b > 0, 1, "upper bound must be strictly positive");
  TH_TENSOR_APPLY(unsigned char, self, *self_data = (THRandom_random(gen) % b + 1);)
}

static int torch_ByteTensor_random(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THGenerator *arg1 = NULL;
long arg2 = 0;
long arg3 = 0;
long arg4 = 0;
THGenerator *arg5 = NULL;
long arg6 = 0;
long arg7 = 0;
THGenerator *arg8 = NULL;
long arg9 = 0;
THByteTensor *arg10 = NULL;
int arg10_idx = 0;
THGenerator *arg11 = NULL;
long arg12 = 0;
long arg13 = 0;
THByteTensor *arg14 = NULL;
int arg14_idx = 0;
THGenerator *arg15 = NULL;
long arg16 = 0;
THByteTensor *arg17 = NULL;
int arg17_idx = 0;
THGenerator *arg18 = NULL;
if(narg == 2
&& lua_isnumber(L, 1)
&& lua_isnumber(L, 2)
)
{
argset = 1;
arg2 = (long)lua_tonumber(L, 1);
arg3 = (long)lua_tonumber(L, 2);
lua_getglobal(L,"torch");
arg1 = luaT_getfieldcheckudata(L, -1, "_gen", torch_Generator);
lua_pop(L, 2);
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, torch_Generator))
&& lua_isnumber(L, 2)
&& lua_isnumber(L, 3)
)
{
argset = 1;
arg2 = (long)lua_tonumber(L, 2);
arg3 = (long)lua_tonumber(L, 3);
}
else if(narg == 1
&& lua_isnumber(L, 1)
)
{
argset = 2;
arg6 = (long)lua_tonumber(L, 1);
lua_getglobal(L,"torch");
arg5 = luaT_getfieldcheckudata(L, -1, "_gen", torch_Generator);
lua_pop(L, 2);
}
else if(narg == 2
&& (arg5 = luaT_toudata(L, 1, torch_Generator))
&& lua_isnumber(L, 2)
)
{
argset = 2;
arg6 = (long)lua_tonumber(L, 2);
}
else if(narg == 0
)
{
argset = 3;
lua_getglobal(L,"torch");
arg8 = luaT_getfieldcheckudata(L, -1, "_gen", torch_Generator);
lua_pop(L, 2);
}
else if(narg == 1
&& (arg8 = luaT_toudata(L, 1, torch_Generator))
)
{
argset = 3;
}
else if(narg == 3
&& (arg10 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
&& lua_isnumber(L, 3)
)
{
argset = 4;
arg10_idx = 1;
arg12 = (long)lua_tonumber(L, 2);
arg13 = (long)lua_tonumber(L, 3);
lua_getglobal(L,"torch");
arg11 = luaT_getfieldcheckudata(L, -1, "_gen", torch_Generator);
lua_pop(L, 2);
}
else if(narg == 4
&& (arg10 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg11 = luaT_toudata(L, 2, torch_Generator))
&& lua_isnumber(L, 3)
&& lua_isnumber(L, 4)
)
{
argset = 4;
arg10_idx = 1;
arg12 = (long)lua_tonumber(L, 3);
arg13 = (long)lua_tonumber(L, 4);
}
else if(narg == 2
&& (arg14 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 5;
arg14_idx = 1;
arg16 = (long)lua_tonumber(L, 2);
lua_getglobal(L,"torch");
arg15 = luaT_getfieldcheckudata(L, -1, "_gen", torch_Generator);
lua_pop(L, 2);
}
else if(narg == 3
&& (arg14 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg15 = luaT_toudata(L, 2, torch_Generator))
&& lua_isnumber(L, 3)
)
{
argset = 5;
arg14_idx = 1;
arg16 = (long)lua_tonumber(L, 3);
}
else if(narg == 1
&& (arg17 = luaT_toudata(L, 1, "torch.ByteTensor"))
)
{
argset = 6;
arg17_idx = 1;
lua_getglobal(L,"torch");
arg18 = luaT_getfieldcheckudata(L, -1, "_gen", torch_Generator);
lua_pop(L, 2);
}
else if(narg == 2
&& (arg17 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg18 = luaT_toudata(L, 2, torch_Generator))
)
{
argset = 6;
arg17_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [Generator] long long | [Generator] long | [Generator] | *ByteTensor* [Generator] long long | *ByteTensor* [Generator] long | *ByteTensor* [Generator]", type_buf);
}
if(argset == 1)
{
arg4 = THRandom_random2__(arg1,arg2,arg3);
lua_pushnumber(L, (lua_Number)arg4);
return 1;
}
else if(argset == 2)
{
arg7 = THRandom_random1__(arg5,arg6);
lua_pushnumber(L, (lua_Number)arg7);
return 1;
}
else if(argset == 3)
{
arg9 = THRandom_random(arg8);
lua_pushnumber(L, (lua_Number)arg9);
return 1;
}
else if(argset == 4)
{
lua_pushvalue(L, arg10_idx);
THByteTensor_random2__(arg10,arg11,arg12,arg13);
return 1;
}
else if(argset == 5)
{
lua_pushvalue(L, arg14_idx);
THByteTensor_random1__(arg14,arg15,arg16);
return 1;
}
else if(argset == 6)
{
lua_pushvalue(L, arg17_idx);
THByteTensor_random(arg17,arg18);
return 1;
}
return 0;
}

static int torch_random(lua_State *L)
{
  int narg = lua_gettop(L);
  const void *tname;
  if(narg >= 1 && (tname = torch_istensortype(L, luaT_typename(L, 1)))) /* first argument is tensor? */
  {
  }
  else if(narg >= 2 && (tname = torch_istensortype(L, luaT_typename(L, 2)))) /* second? */
  {
  }
  else if(narg >= 1 && (tname = torch_istensorarray(L, 1))) /* torch table argument? */
  {
  }
  else if(narg >= 1 && lua_type(L, narg) == LUA_TSTRING
	  && (tname = torch_istensortype(L, lua_tostring(L, narg)))) /* do we have a valid tensor type string then? */
  {
    lua_remove(L, -2);
  }
  else if(!(tname = torch_istensortype(L, torch_getdefaulttensortype(L))))
    luaL_error(L, "internal error: the default tensor type does not seem to be an actual tensor");

  lua_pushstring(L, "random");
  lua_rawget(L, -2);
  if(lua_isfunction(L, -1))
  {
    lua_insert(L, 1);
    lua_pop(L, 2); /* the two tables we put on the stack above */
    lua_call(L, lua_gettop(L)-1, LUA_MULTRET);
  }
  else
    return luaL_error(L, "%s does not implement the torch.random() function", tname);

  return lua_gettop(L);
}

static int torch_ByteTensor_geometric(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THGenerator *arg1 = NULL;
double arg2 = 0;
double arg3 = 0;
THByteTensor *arg4 = NULL;
int arg4_idx = 0;
THGenerator *arg5 = NULL;
double arg6 = 0;
if(narg == 1
&& lua_isnumber(L, 1)
)
{
argset = 1;
arg2 = (double)lua_tonumber(L, 1);
lua_getglobal(L,"torch");
arg1 = luaT_getfieldcheckudata(L, -1, "_gen", torch_Generator);
lua_pop(L, 2);
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, torch_Generator))
&& lua_isnumber(L, 2)
)
{
argset = 1;
arg2 = (double)lua_tonumber(L, 2);
}
else if(narg == 2
&& (arg4 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 2;
arg4_idx = 1;
arg6 = (double)lua_tonumber(L, 2);
lua_getglobal(L,"torch");
arg5 = luaT_getfieldcheckudata(L, -1, "_gen", torch_Generator);
lua_pop(L, 2);
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg5 = luaT_toudata(L, 2, torch_Generator))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg4_idx = 1;
arg6 = (double)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [Generator] double | *ByteTensor* [Generator] double", type_buf);
}
if(argset == 1)
{
arg3 = THRandom_geometric(arg1,arg2);
lua_pushnumber(L, (lua_Number)arg3);
return 1;
}
else if(argset == 2)
{
lua_pushvalue(L, arg4_idx);
THByteTensor_geometric(arg4,arg5,arg6);
return 1;
}
return 0;
}

static int torch_geometric(lua_State *L)
{
  int narg = lua_gettop(L);
  const void *tname;
  if(narg >= 1 && (tname = torch_istensortype(L, luaT_typename(L, 1)))) /* first argument is tensor? */
  {
  }
  else if(narg >= 2 && (tname = torch_istensortype(L, luaT_typename(L, 2)))) /* second? */
  {
  }
  else if(narg >= 1 && (tname = torch_istensorarray(L, 1))) /* torch table argument? */
  {
  }
  else if(narg >= 1 && lua_type(L, narg) == LUA_TSTRING
	  && (tname = torch_istensortype(L, lua_tostring(L, narg)))) /* do we have a valid tensor type string then? */
  {
    lua_remove(L, -2);
  }
  else if(!(tname = torch_istensortype(L, torch_getdefaulttensortype(L))))
    luaL_error(L, "internal error: the default tensor type does not seem to be an actual tensor");

  lua_pushstring(L, "geometric");
  lua_rawget(L, -2);
  if(lua_isfunction(L, -1))
  {
    lua_insert(L, 1);
    lua_pop(L, 2); /* the two tables we put on the stack above */
    lua_call(L, lua_gettop(L)-1, LUA_MULTRET);
  }
  else
    return luaL_error(L, "%s does not implement the torch.geometric() function", tname);

  return lua_gettop(L);
}

static int torch_ByteTensor_bernoulli(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THGenerator *arg1 = NULL;
double arg2 = 0.5;
double arg3 = 0;
THByteTensor *arg4 = NULL;
int arg4_idx = 0;
THGenerator *arg5 = NULL;
double arg6 = 0.5;
THByteTensor *arg7 = NULL;
int arg7_idx = 0;
THGenerator *arg8 = NULL;
THFloatTensor *arg9 = NULL;
THByteTensor *arg10 = NULL;
int arg10_idx = 0;
THGenerator *arg11 = NULL;
THDoubleTensor *arg12 = NULL;
if(narg == 0
)
{
argset = 1;
lua_getglobal(L,"torch");
arg1 = luaT_getfieldcheckudata(L, -1, "_gen", torch_Generator);
lua_pop(L, 2);
}
else if(narg == 1
&& (arg1 = luaT_toudata(L, 1, torch_Generator))
)
{
argset = 1;
}
else if(narg == 1
&& lua_isnumber(L, 1)
)
{
argset = 1;
arg2 = (double)lua_tonumber(L, 1);
lua_getglobal(L,"torch");
arg1 = luaT_getfieldcheckudata(L, -1, "_gen", torch_Generator);
lua_pop(L, 2);
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, torch_Generator))
&& lua_isnumber(L, 2)
)
{
argset = 1;
arg2 = (double)lua_tonumber(L, 2);
}
else if(narg == 1
&& (arg4 = luaT_toudata(L, 1, "torch.ByteTensor"))
)
{
argset = 2;
arg4_idx = 1;
lua_getglobal(L,"torch");
arg5 = luaT_getfieldcheckudata(L, -1, "_gen", torch_Generator);
lua_pop(L, 2);
}
else if(narg == 2
&& (arg4 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg5 = luaT_toudata(L, 2, torch_Generator))
)
{
argset = 2;
arg4_idx = 1;
}
else if(narg == 2
&& (arg4 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 2;
arg4_idx = 1;
arg6 = (double)lua_tonumber(L, 2);
lua_getglobal(L,"torch");
arg5 = luaT_getfieldcheckudata(L, -1, "_gen", torch_Generator);
lua_pop(L, 2);
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg5 = luaT_toudata(L, 2, torch_Generator))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg4_idx = 1;
arg6 = (double)lua_tonumber(L, 3);
}
else if(narg == 2
&& (arg7 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg9 = luaT_toudata(L, 2, "torch.FloatTensor"))
)
{
argset = 3;
arg7_idx = 1;
lua_getglobal(L,"torch");
arg8 = luaT_getfieldcheckudata(L, -1, "_gen", torch_Generator);
lua_pop(L, 2);
}
else if(narg == 3
&& (arg7 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg8 = luaT_toudata(L, 2, torch_Generator))
&& (arg9 = luaT_toudata(L, 3, "torch.FloatTensor"))
)
{
argset = 3;
arg7_idx = 1;
}
else if(narg == 2
&& (arg10 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg12 = luaT_toudata(L, 2, "torch.DoubleTensor"))
)
{
argset = 4;
arg10_idx = 1;
lua_getglobal(L,"torch");
arg11 = luaT_getfieldcheckudata(L, -1, "_gen", torch_Generator);
lua_pop(L, 2);
}
else if(narg == 3
&& (arg10 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg11 = luaT_toudata(L, 2, torch_Generator))
&& (arg12 = luaT_toudata(L, 3, "torch.DoubleTensor"))
)
{
argset = 4;
arg10_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [Generator] [double] | *ByteTensor* [Generator] [double] | *ByteTensor* [Generator] FloatTensor | *ByteTensor* [Generator] DoubleTensor", type_buf);
}
if(argset == 1)
{
arg3 = THRandom_bernoulli(arg1,arg2);
lua_pushnumber(L, (lua_Number)arg3);
return 1;
}
else if(argset == 2)
{
lua_pushvalue(L, arg4_idx);
THByteTensor_bernoulli(arg4,arg5,arg6);
return 1;
}
else if(argset == 3)
{
lua_pushvalue(L, arg7_idx);
THByteTensor_bernoulli_FloatTensor(arg7,arg8,arg9);
return 1;
}
else if(argset == 4)
{
lua_pushvalue(L, arg10_idx);
THByteTensor_bernoulli_DoubleTensor(arg10,arg11,arg12);
return 1;
}
return 0;
}

static int torch_bernoulli(lua_State *L)
{
  int narg = lua_gettop(L);
  const void *tname;
  if(narg >= 1 && (tname = torch_istensortype(L, luaT_typename(L, 1)))) /* first argument is tensor? */
  {
  }
  else if(narg >= 2 && (tname = torch_istensortype(L, luaT_typename(L, 2)))) /* second? */
  {
  }
  else if(narg >= 1 && (tname = torch_istensorarray(L, 1))) /* torch table argument? */
  {
  }
  else if(narg >= 1 && lua_type(L, narg) == LUA_TSTRING
	  && (tname = torch_istensortype(L, lua_tostring(L, narg)))) /* do we have a valid tensor type string then? */
  {
    lua_remove(L, -2);
  }
  else if(!(tname = torch_istensortype(L, torch_getdefaulttensortype(L))))
    luaL_error(L, "internal error: the default tensor type does not seem to be an actual tensor");

  lua_pushstring(L, "bernoulli");
  lua_rawget(L, -2);
  if(lua_isfunction(L, -1))
  {
    lua_insert(L, 1);
    lua_pop(L, 2); /* the two tables we put on the stack above */
    lua_call(L, lua_gettop(L)-1, LUA_MULTRET);
  }
  else
    return luaL_error(L, "%s does not implement the torch.bernoulli() function", tname);

  return lua_gettop(L);
}

static int torch_ByteTensor_squeeze(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
THByteTensor *arg3 = NULL;
int arg3_idx = 0;
THByteTensor *arg4 = NULL;
long arg5 = 0;
if(narg == 1
&& (arg2 = luaT_toudata(L, 1, "torch.ByteTensor"))
)
{
argset = 1;
arg1 = THByteTensor_new();
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
)
{
argset = 1;
arg1_idx = 1;
}
else if(narg == 2
&& (arg4 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 2;
arg5 = (long)lua_tonumber(L, 2)-1;
arg3 = THByteTensor_new();
}
else if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg4 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg3_idx = 1;
arg5 = (long)lua_tonumber(L, 3)-1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] ByteTensor | [*ByteTensor*] ByteTensor index", type_buf);
}
if(argset == 1)
{
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THByteTensor_squeeze(arg1,arg2);
if(arg1->nDimension == 1 && arg1->size[0] == 1)
lua_pushnumber(L, (lua_Number)(*THByteTensor_data(arg1)));
return 1;
}
else if(argset == 2)
{
if(arg3_idx)
lua_pushvalue(L, arg3_idx);
else
luaT_pushudata(L, arg3, "torch.ByteTensor");
{int hasdims = arg4->nDimension > 1;
THByteTensor_squeeze1d(arg3,arg4,arg5);
if(!hasdims && arg3->nDimension == 1 && arg3->size[0] == 1)
lua_pushnumber(L, (lua_Number)(*THByteTensor_data(arg3)));}
return 1;
}
return 0;
}

static int torch_squeeze(lua_State *L)
{
  int narg = lua_gettop(L);
  const void *tname;
  if(narg >= 1 && (tname = torch_istensortype(L, luaT_typename(L, 1)))) /* first argument is tensor? */
  {
  }
  else if(narg >= 2 && (tname = torch_istensortype(L, luaT_typename(L, 2)))) /* second? */
  {
  }
  else if(narg >= 1 && (tname = torch_istensorarray(L, 1))) /* torch table argument? */
  {
  }
  else if(narg >= 1 && lua_type(L, narg) == LUA_TSTRING
	  && (tname = torch_istensortype(L, lua_tostring(L, narg)))) /* do we have a valid tensor type string then? */
  {
    lua_remove(L, -2);
  }
  else if(!(tname = torch_istensortype(L, torch_getdefaulttensortype(L))))
    luaL_error(L, "internal error: the default tensor type does not seem to be an actual tensor");

  lua_pushstring(L, "squeeze");
  lua_rawget(L, -2);
  if(lua_isfunction(L, -1))
  {
    lua_insert(L, 1);
    lua_pop(L, 2); /* the two tables we put on the stack above */
    lua_call(L, lua_gettop(L)-1, LUA_MULTRET);
  }
  else
    return luaL_error(L, "%s does not implement the torch.squeeze() function", tname);

  return lua_gettop(L);
}

static int torch_ByteTensor_sign(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
if(narg == 1
&& (arg2 = luaT_toudata(L, 1, "torch.ByteTensor"))
)
{
arg1 = THByteTensor_new();
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
)
{
arg1_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] ByteTensor", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THByteTensor_sign(arg1,arg2);
return 1;
}

static int torch_sign(lua_State *L)
{
  int narg = lua_gettop(L);
  const void *tname;
  if(narg >= 1 && (tname = torch_istensortype(L, luaT_typename(L, 1)))) /* first argument is tensor? */
  {
  }
  else if(narg >= 2 && (tname = torch_istensortype(L, luaT_typename(L, 2)))) /* second? */
  {
  }
  else if(narg >= 1 && (tname = torch_istensorarray(L, 1))) /* torch table argument? */
  {
  }
  else if(narg >= 1 && lua_type(L, narg) == LUA_TSTRING
	  && (tname = torch_istensortype(L, lua_tostring(L, narg)))) /* do we have a valid tensor type string then? */
  {
    lua_remove(L, -2);
  }
  else if(!(tname = torch_istensortype(L, torch_getdefaulttensortype(L))))
    luaL_error(L, "internal error: the default tensor type does not seem to be an actual tensor");

  lua_pushstring(L, "sign");
  lua_rawget(L, -2);
  if(lua_isfunction(L, -1))
  {
    lua_insert(L, 1);
    lua_pop(L, 2); /* the two tables we put on the stack above */
    lua_call(L, lua_gettop(L)-1, LUA_MULTRET);
  }
  else
    return luaL_error(L, "%s does not implement the torch.sign() function", tname);

  return lua_gettop(L);
}

static int torch_ByteTensor_conv2(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
unsigned char arg2 = 0;
unsigned char arg3 = 1;
THByteTensor *arg4 = NULL;
THByteTensor *arg5 = NULL;
unsigned char arg6 = 1;
unsigned char arg7 = 1;
const char *arg8 = NULL;
char arg8_default = 'V';
const char *arg9 = NULL;
char arg9_default = 'C';
THByteTensor *arg10 = NULL;
int arg10_idx = 0;
unsigned char arg11 = 0;
unsigned char arg12 = 1;
THByteTensor *arg13 = NULL;
THByteTensor *arg14 = NULL;
unsigned char arg15 = 1;
unsigned char arg16 = 1;
const char *arg17 = NULL;
char arg17_default = 'V';
const char *arg18 = NULL;
char arg18_default = 'C';
THByteTensor *arg19 = NULL;
int arg19_idx = 0;
unsigned char arg20 = 0;
unsigned char arg21 = 1;
THByteTensor *arg22 = NULL;
THByteTensor *arg23 = NULL;
unsigned char arg24 = 1;
unsigned char arg25 = 1;
const char *arg26 = NULL;
char arg26_default = 'V';
const char *arg27 = NULL;
char arg27_default = 'C';
if(narg == 2
&& (arg4 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg4->nDimension == 2)
&& (arg5 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg5->nDimension == 2)
)
{
argset = 1;
arg1 = THByteTensor_new();
arg8 = &arg8_default;
arg9 = &arg9_default;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg4 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg4->nDimension == 2)
&& (arg5 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg5->nDimension == 2)
)
{
argset = 1;
arg1_idx = 1;
arg8 = &arg8_default;
arg9 = &arg9_default;
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg4->nDimension == 2)
&& (arg5 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg5->nDimension == 2)
&& (arg8 = lua_tostring(L, 3)) && (*arg8 == 'V' || *arg8 == 'F')
)
{
argset = 1;
arg1 = THByteTensor_new();
arg9 = &arg9_default;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg4 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg4->nDimension == 2)
&& (arg5 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg5->nDimension == 2)
&& (arg8 = lua_tostring(L, 4)) && (*arg8 == 'V' || *arg8 == 'F')
)
{
argset = 1;
arg1_idx = 1;
arg9 = &arg9_default;
}
else if(narg == 2
&& (arg13 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg13->nDimension == 3)
&& (arg14 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg14->nDimension == 3)
)
{
argset = 2;
arg10 = THByteTensor_new();
arg17 = &arg17_default;
arg18 = &arg18_default;
}
else if(narg == 3
&& (arg10 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg13 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg13->nDimension == 3)
&& (arg14 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg14->nDimension == 3)
)
{
argset = 2;
arg10_idx = 1;
arg17 = &arg17_default;
arg18 = &arg18_default;
}
else if(narg == 3
&& (arg13 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg13->nDimension == 3)
&& (arg14 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg14->nDimension == 3)
&& (arg17 = lua_tostring(L, 3)) && (*arg17 == 'V' || *arg17 == 'F')
)
{
argset = 2;
arg10 = THByteTensor_new();
arg18 = &arg18_default;
}
else if(narg == 4
&& (arg10 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg13 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg13->nDimension == 3)
&& (arg14 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg14->nDimension == 3)
&& (arg17 = lua_tostring(L, 4)) && (*arg17 == 'V' || *arg17 == 'F')
)
{
argset = 2;
arg10_idx = 1;
arg18 = &arg18_default;
}
else if(narg == 2
&& (arg22 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg22->nDimension == 3)
&& (arg23 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg23->nDimension == 4)
)
{
argset = 3;
arg19 = THByteTensor_new();
arg26 = &arg26_default;
arg27 = &arg27_default;
}
else if(narg == 3
&& (arg19 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg22 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg22->nDimension == 3)
&& (arg23 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg23->nDimension == 4)
)
{
argset = 3;
arg19_idx = 1;
arg26 = &arg26_default;
arg27 = &arg27_default;
}
else if(narg == 3
&& (arg22 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg22->nDimension == 3)
&& (arg23 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg23->nDimension == 4)
&& (arg26 = lua_tostring(L, 3)) && (*arg26 == 'V' || *arg26 == 'F')
)
{
argset = 3;
arg19 = THByteTensor_new();
arg27 = &arg27_default;
}
else if(narg == 4
&& (arg19 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg22 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg22->nDimension == 3)
&& (arg23 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg23->nDimension == 4)
&& (arg26 = lua_tostring(L, 4)) && (*arg26 == 'V' || *arg26 == 'F')
)
{
argset = 3;
arg19_idx = 1;
arg27 = &arg27_default;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] ByteTensor~2D ByteTensor~2D [(V|F)] | [*ByteTensor*] ByteTensor~3D ByteTensor~3D [(V|F)] | [*ByteTensor*] ByteTensor~3D ByteTensor~4D [(V|F)]", type_buf);
}
if(argset == 1)
{
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THByteTensor_conv2Dmul(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9);
return 1;
}
else if(argset == 2)
{
if(arg10_idx)
lua_pushvalue(L, arg10_idx);
else
luaT_pushudata(L, arg10, "torch.ByteTensor");
THByteTensor_conv2Dcmul(arg10,arg11,arg12,arg13,arg14,arg15,arg16,arg17,arg18);
return 1;
}
else if(argset == 3)
{
if(arg19_idx)
lua_pushvalue(L, arg19_idx);
else
luaT_pushudata(L, arg19, "torch.ByteTensor");
THByteTensor_conv2Dmv(arg19,arg20,arg21,arg22,arg23,arg24,arg25,arg26,arg27);
return 1;
}
return 0;
}

static int torch_conv2(lua_State *L)
{
  int narg = lua_gettop(L);
  const void *tname;
  if(narg >= 1 && (tname = torch_istensortype(L, luaT_typename(L, 1)))) /* first argument is tensor? */
  {
  }
  else if(narg >= 2 && (tname = torch_istensortype(L, luaT_typename(L, 2)))) /* second? */
  {
  }
  else if(narg >= 1 && (tname = torch_istensorarray(L, 1))) /* torch table argument? */
  {
  }
  else if(narg >= 1 && lua_type(L, narg) == LUA_TSTRING
	  && (tname = torch_istensortype(L, lua_tostring(L, narg)))) /* do we have a valid tensor type string then? */
  {
    lua_remove(L, -2);
  }
  else if(!(tname = torch_istensortype(L, torch_getdefaulttensortype(L))))
    luaL_error(L, "internal error: the default tensor type does not seem to be an actual tensor");

  lua_pushstring(L, "conv2");
  lua_rawget(L, -2);
  if(lua_isfunction(L, -1))
  {
    lua_insert(L, 1);
    lua_pop(L, 2); /* the two tables we put on the stack above */
    lua_call(L, lua_gettop(L)-1, LUA_MULTRET);
  }
  else
    return luaL_error(L, "%s does not implement the torch.conv2() function", tname);

  return lua_gettop(L);
}

static int torch_ByteTensor_xcorr2(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
unsigned char arg2 = 0;
unsigned char arg3 = 1;
THByteTensor *arg4 = NULL;
THByteTensor *arg5 = NULL;
unsigned char arg6 = 1;
unsigned char arg7 = 1;
const char *arg8 = NULL;
char arg8_default = 'V';
const char *arg9 = NULL;
char arg9_default = 'X';
THByteTensor *arg10 = NULL;
int arg10_idx = 0;
unsigned char arg11 = 0;
unsigned char arg12 = 1;
THByteTensor *arg13 = NULL;
THByteTensor *arg14 = NULL;
unsigned char arg15 = 1;
unsigned char arg16 = 1;
const char *arg17 = NULL;
char arg17_default = 'V';
const char *arg18 = NULL;
char arg18_default = 'X';
THByteTensor *arg19 = NULL;
int arg19_idx = 0;
unsigned char arg20 = 0;
unsigned char arg21 = 1;
THByteTensor *arg22 = NULL;
THByteTensor *arg23 = NULL;
unsigned char arg24 = 1;
unsigned char arg25 = 1;
const char *arg26 = NULL;
char arg26_default = 'V';
const char *arg27 = NULL;
char arg27_default = 'X';
if(narg == 2
&& (arg4 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg4->nDimension == 2)
&& (arg5 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg5->nDimension == 2)
)
{
argset = 1;
arg1 = THByteTensor_new();
arg8 = &arg8_default;
arg9 = &arg9_default;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg4 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg4->nDimension == 2)
&& (arg5 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg5->nDimension == 2)
)
{
argset = 1;
arg1_idx = 1;
arg8 = &arg8_default;
arg9 = &arg9_default;
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg4->nDimension == 2)
&& (arg5 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg5->nDimension == 2)
&& (arg8 = lua_tostring(L, 3)) && (*arg8 == 'V' || *arg8 == 'F')
)
{
argset = 1;
arg1 = THByteTensor_new();
arg9 = &arg9_default;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg4 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg4->nDimension == 2)
&& (arg5 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg5->nDimension == 2)
&& (arg8 = lua_tostring(L, 4)) && (*arg8 == 'V' || *arg8 == 'F')
)
{
argset = 1;
arg1_idx = 1;
arg9 = &arg9_default;
}
else if(narg == 2
&& (arg13 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg13->nDimension == 3)
&& (arg14 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg14->nDimension == 3)
)
{
argset = 2;
arg10 = THByteTensor_new();
arg17 = &arg17_default;
arg18 = &arg18_default;
}
else if(narg == 3
&& (arg10 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg13 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg13->nDimension == 3)
&& (arg14 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg14->nDimension == 3)
)
{
argset = 2;
arg10_idx = 1;
arg17 = &arg17_default;
arg18 = &arg18_default;
}
else if(narg == 3
&& (arg13 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg13->nDimension == 3)
&& (arg14 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg14->nDimension == 3)
&& (arg17 = lua_tostring(L, 3)) && (*arg17 == 'V' || *arg17 == 'F')
)
{
argset = 2;
arg10 = THByteTensor_new();
arg18 = &arg18_default;
}
else if(narg == 4
&& (arg10 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg13 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg13->nDimension == 3)
&& (arg14 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg14->nDimension == 3)
&& (arg17 = lua_tostring(L, 4)) && (*arg17 == 'V' || *arg17 == 'F')
)
{
argset = 2;
arg10_idx = 1;
arg18 = &arg18_default;
}
else if(narg == 2
&& (arg22 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg22->nDimension == 3)
&& (arg23 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg23->nDimension == 4)
)
{
argset = 3;
arg19 = THByteTensor_new();
arg26 = &arg26_default;
arg27 = &arg27_default;
}
else if(narg == 3
&& (arg19 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg22 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg22->nDimension == 3)
&& (arg23 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg23->nDimension == 4)
)
{
argset = 3;
arg19_idx = 1;
arg26 = &arg26_default;
arg27 = &arg27_default;
}
else if(narg == 3
&& (arg22 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg22->nDimension == 3)
&& (arg23 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg23->nDimension == 4)
&& (arg26 = lua_tostring(L, 3)) && (*arg26 == 'V' || *arg26 == 'F')
)
{
argset = 3;
arg19 = THByteTensor_new();
arg27 = &arg27_default;
}
else if(narg == 4
&& (arg19 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg22 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg22->nDimension == 3)
&& (arg23 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg23->nDimension == 4)
&& (arg26 = lua_tostring(L, 4)) && (*arg26 == 'V' || *arg26 == 'F')
)
{
argset = 3;
arg19_idx = 1;
arg27 = &arg27_default;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] ByteTensor~2D ByteTensor~2D [(V|F)] | [*ByteTensor*] ByteTensor~3D ByteTensor~3D [(V|F)] | [*ByteTensor*] ByteTensor~3D ByteTensor~4D [(V|F)]", type_buf);
}
if(argset == 1)
{
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THByteTensor_conv2Dmul(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9);
return 1;
}
else if(argset == 2)
{
if(arg10_idx)
lua_pushvalue(L, arg10_idx);
else
luaT_pushudata(L, arg10, "torch.ByteTensor");
THByteTensor_conv2Dcmul(arg10,arg11,arg12,arg13,arg14,arg15,arg16,arg17,arg18);
return 1;
}
else if(argset == 3)
{
if(arg19_idx)
lua_pushvalue(L, arg19_idx);
else
luaT_pushudata(L, arg19, "torch.ByteTensor");
THByteTensor_conv2Dmv(arg19,arg20,arg21,arg22,arg23,arg24,arg25,arg26,arg27);
return 1;
}
return 0;
}

static int torch_xcorr2(lua_State *L)
{
  int narg = lua_gettop(L);
  const void *tname;
  if(narg >= 1 && (tname = torch_istensortype(L, luaT_typename(L, 1)))) /* first argument is tensor? */
  {
  }
  else if(narg >= 2 && (tname = torch_istensortype(L, luaT_typename(L, 2)))) /* second? */
  {
  }
  else if(narg >= 1 && (tname = torch_istensorarray(L, 1))) /* torch table argument? */
  {
  }
  else if(narg >= 1 && lua_type(L, narg) == LUA_TSTRING
	  && (tname = torch_istensortype(L, lua_tostring(L, narg)))) /* do we have a valid tensor type string then? */
  {
    lua_remove(L, -2);
  }
  else if(!(tname = torch_istensortype(L, torch_getdefaulttensortype(L))))
    luaL_error(L, "internal error: the default tensor type does not seem to be an actual tensor");

  lua_pushstring(L, "xcorr2");
  lua_rawget(L, -2);
  if(lua_isfunction(L, -1))
  {
    lua_insert(L, 1);
    lua_pop(L, 2); /* the two tables we put on the stack above */
    lua_call(L, lua_gettop(L)-1, LUA_MULTRET);
  }
  else
    return luaL_error(L, "%s does not implement the torch.xcorr2() function", tname);

  return lua_gettop(L);
}

static int torch_ByteTensor_conv3(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
unsigned char arg2 = 0;
unsigned char arg3 = 1;
THByteTensor *arg4 = NULL;
THByteTensor *arg5 = NULL;
unsigned char arg6 = 1;
unsigned char arg7 = 1;
unsigned char arg8 = 1;
const char *arg9 = NULL;
char arg9_default = 'V';
const char *arg10 = NULL;
char arg10_default = 'C';
THByteTensor *arg11 = NULL;
int arg11_idx = 0;
unsigned char arg12 = 0;
unsigned char arg13 = 1;
THByteTensor *arg14 = NULL;
THByteTensor *arg15 = NULL;
unsigned char arg16 = 1;
unsigned char arg17 = 1;
unsigned char arg18 = 1;
const char *arg19 = NULL;
char arg19_default = 'V';
const char *arg20 = NULL;
char arg20_default = 'C';
THByteTensor *arg21 = NULL;
int arg21_idx = 0;
unsigned char arg22 = 0;
unsigned char arg23 = 1;
THByteTensor *arg24 = NULL;
THByteTensor *arg25 = NULL;
unsigned char arg26 = 1;
unsigned char arg27 = 1;
unsigned char arg28 = 1;
const char *arg29 = NULL;
char arg29_default = 'V';
const char *arg30 = NULL;
char arg30_default = 'C';
if(narg == 2
&& (arg4 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg4->nDimension == 3)
&& (arg5 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg5->nDimension == 3)
)
{
argset = 1;
arg1 = THByteTensor_new();
arg9 = &arg9_default;
arg10 = &arg10_default;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg4 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg4->nDimension == 3)
&& (arg5 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg5->nDimension == 3)
)
{
argset = 1;
arg1_idx = 1;
arg9 = &arg9_default;
arg10 = &arg10_default;
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg4->nDimension == 3)
&& (arg5 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg5->nDimension == 3)
&& (arg9 = lua_tostring(L, 3)) && (*arg9 == 'V' || *arg9 == 'F')
)
{
argset = 1;
arg1 = THByteTensor_new();
arg10 = &arg10_default;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg4 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg4->nDimension == 3)
&& (arg5 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg5->nDimension == 3)
&& (arg9 = lua_tostring(L, 4)) && (*arg9 == 'V' || *arg9 == 'F')
)
{
argset = 1;
arg1_idx = 1;
arg10 = &arg10_default;
}
else if(narg == 2
&& (arg14 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg14->nDimension == 4)
&& (arg15 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg15->nDimension == 4)
)
{
argset = 2;
arg11 = THByteTensor_new();
arg19 = &arg19_default;
arg20 = &arg20_default;
}
else if(narg == 3
&& (arg11 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg14 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg14->nDimension == 4)
&& (arg15 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg15->nDimension == 4)
)
{
argset = 2;
arg11_idx = 1;
arg19 = &arg19_default;
arg20 = &arg20_default;
}
else if(narg == 3
&& (arg14 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg14->nDimension == 4)
&& (arg15 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg15->nDimension == 4)
&& (arg19 = lua_tostring(L, 3)) && (*arg19 == 'V' || *arg19 == 'F')
)
{
argset = 2;
arg11 = THByteTensor_new();
arg20 = &arg20_default;
}
else if(narg == 4
&& (arg11 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg14 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg14->nDimension == 4)
&& (arg15 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg15->nDimension == 4)
&& (arg19 = lua_tostring(L, 4)) && (*arg19 == 'V' || *arg19 == 'F')
)
{
argset = 2;
arg11_idx = 1;
arg20 = &arg20_default;
}
else if(narg == 2
&& (arg24 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg24->nDimension == 4)
&& (arg25 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg25->nDimension == 5)
)
{
argset = 3;
arg21 = THByteTensor_new();
arg29 = &arg29_default;
arg30 = &arg30_default;
}
else if(narg == 3
&& (arg21 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg24 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg24->nDimension == 4)
&& (arg25 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg25->nDimension == 5)
)
{
argset = 3;
arg21_idx = 1;
arg29 = &arg29_default;
arg30 = &arg30_default;
}
else if(narg == 3
&& (arg24 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg24->nDimension == 4)
&& (arg25 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg25->nDimension == 5)
&& (arg29 = lua_tostring(L, 3)) && (*arg29 == 'V' || *arg29 == 'F')
)
{
argset = 3;
arg21 = THByteTensor_new();
arg30 = &arg30_default;
}
else if(narg == 4
&& (arg21 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg24 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg24->nDimension == 4)
&& (arg25 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg25->nDimension == 5)
&& (arg29 = lua_tostring(L, 4)) && (*arg29 == 'V' || *arg29 == 'F')
)
{
argset = 3;
arg21_idx = 1;
arg30 = &arg30_default;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] ByteTensor~3D ByteTensor~3D [(V|F)] | [*ByteTensor*] ByteTensor~4D ByteTensor~4D [(V|F)] | [*ByteTensor*] ByteTensor~4D ByteTensor~5D [(V|F)]", type_buf);
}
if(argset == 1)
{
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THByteTensor_conv3Dmul(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10);
return 1;
}
else if(argset == 2)
{
if(arg11_idx)
lua_pushvalue(L, arg11_idx);
else
luaT_pushudata(L, arg11, "torch.ByteTensor");
THByteTensor_conv3Dcmul(arg11,arg12,arg13,arg14,arg15,arg16,arg17,arg18,arg19,arg20);
return 1;
}
else if(argset == 3)
{
if(arg21_idx)
lua_pushvalue(L, arg21_idx);
else
luaT_pushudata(L, arg21, "torch.ByteTensor");
THByteTensor_conv3Dmv(arg21,arg22,arg23,arg24,arg25,arg26,arg27,arg28,arg29,arg30);
return 1;
}
return 0;
}

static int torch_conv3(lua_State *L)
{
  int narg = lua_gettop(L);
  const void *tname;
  if(narg >= 1 && (tname = torch_istensortype(L, luaT_typename(L, 1)))) /* first argument is tensor? */
  {
  }
  else if(narg >= 2 && (tname = torch_istensortype(L, luaT_typename(L, 2)))) /* second? */
  {
  }
  else if(narg >= 1 && (tname = torch_istensorarray(L, 1))) /* torch table argument? */
  {
  }
  else if(narg >= 1 && lua_type(L, narg) == LUA_TSTRING
	  && (tname = torch_istensortype(L, lua_tostring(L, narg)))) /* do we have a valid tensor type string then? */
  {
    lua_remove(L, -2);
  }
  else if(!(tname = torch_istensortype(L, torch_getdefaulttensortype(L))))
    luaL_error(L, "internal error: the default tensor type does not seem to be an actual tensor");

  lua_pushstring(L, "conv3");
  lua_rawget(L, -2);
  if(lua_isfunction(L, -1))
  {
    lua_insert(L, 1);
    lua_pop(L, 2); /* the two tables we put on the stack above */
    lua_call(L, lua_gettop(L)-1, LUA_MULTRET);
  }
  else
    return luaL_error(L, "%s does not implement the torch.conv3() function", tname);

  return lua_gettop(L);
}

static int torch_ByteTensor_xcorr3(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
unsigned char arg2 = 0;
unsigned char arg3 = 1;
THByteTensor *arg4 = NULL;
THByteTensor *arg5 = NULL;
unsigned char arg6 = 1;
unsigned char arg7 = 1;
unsigned char arg8 = 1;
const char *arg9 = NULL;
char arg9_default = 'V';
const char *arg10 = NULL;
char arg10_default = 'X';
THByteTensor *arg11 = NULL;
int arg11_idx = 0;
unsigned char arg12 = 0;
unsigned char arg13 = 1;
THByteTensor *arg14 = NULL;
THByteTensor *arg15 = NULL;
unsigned char arg16 = 1;
unsigned char arg17 = 1;
unsigned char arg18 = 1;
const char *arg19 = NULL;
char arg19_default = 'V';
const char *arg20 = NULL;
char arg20_default = 'X';
THByteTensor *arg21 = NULL;
int arg21_idx = 0;
unsigned char arg22 = 0;
unsigned char arg23 = 1;
THByteTensor *arg24 = NULL;
THByteTensor *arg25 = NULL;
unsigned char arg26 = 1;
unsigned char arg27 = 1;
unsigned char arg28 = 1;
const char *arg29 = NULL;
char arg29_default = 'V';
const char *arg30 = NULL;
char arg30_default = 'X';
if(narg == 2
&& (arg4 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg4->nDimension == 3)
&& (arg5 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg5->nDimension == 3)
)
{
argset = 1;
arg1 = THByteTensor_new();
arg9 = &arg9_default;
arg10 = &arg10_default;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg4 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg4->nDimension == 3)
&& (arg5 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg5->nDimension == 3)
)
{
argset = 1;
arg1_idx = 1;
arg9 = &arg9_default;
arg10 = &arg10_default;
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg4->nDimension == 3)
&& (arg5 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg5->nDimension == 3)
&& (arg9 = lua_tostring(L, 3)) && (*arg9 == 'V' || *arg9 == 'F')
)
{
argset = 1;
arg1 = THByteTensor_new();
arg10 = &arg10_default;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg4 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg4->nDimension == 3)
&& (arg5 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg5->nDimension == 3)
&& (arg9 = lua_tostring(L, 4)) && (*arg9 == 'V' || *arg9 == 'F')
)
{
argset = 1;
arg1_idx = 1;
arg10 = &arg10_default;
}
else if(narg == 2
&& (arg14 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg14->nDimension == 4)
&& (arg15 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg15->nDimension == 4)
)
{
argset = 2;
arg11 = THByteTensor_new();
arg19 = &arg19_default;
arg20 = &arg20_default;
}
else if(narg == 3
&& (arg11 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg14 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg14->nDimension == 4)
&& (arg15 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg15->nDimension == 4)
)
{
argset = 2;
arg11_idx = 1;
arg19 = &arg19_default;
arg20 = &arg20_default;
}
else if(narg == 3
&& (arg14 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg14->nDimension == 4)
&& (arg15 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg15->nDimension == 4)
&& (arg19 = lua_tostring(L, 3)) && (*arg19 == 'V' || *arg19 == 'F')
)
{
argset = 2;
arg11 = THByteTensor_new();
arg20 = &arg20_default;
}
else if(narg == 4
&& (arg11 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg14 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg14->nDimension == 4)
&& (arg15 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg15->nDimension == 4)
&& (arg19 = lua_tostring(L, 4)) && (*arg19 == 'V' || *arg19 == 'F')
)
{
argset = 2;
arg11_idx = 1;
arg20 = &arg20_default;
}
else if(narg == 2
&& (arg24 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg24->nDimension == 4)
&& (arg25 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg25->nDimension == 5)
)
{
argset = 3;
arg21 = THByteTensor_new();
arg29 = &arg29_default;
arg30 = &arg30_default;
}
else if(narg == 3
&& (arg21 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg24 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg24->nDimension == 4)
&& (arg25 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg25->nDimension == 5)
)
{
argset = 3;
arg21_idx = 1;
arg29 = &arg29_default;
arg30 = &arg30_default;
}
else if(narg == 3
&& (arg24 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg24->nDimension == 4)
&& (arg25 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg25->nDimension == 5)
&& (arg29 = lua_tostring(L, 3)) && (*arg29 == 'V' || *arg29 == 'F')
)
{
argset = 3;
arg21 = THByteTensor_new();
arg30 = &arg30_default;
}
else if(narg == 4
&& (arg21 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg24 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg24->nDimension == 4)
&& (arg25 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg25->nDimension == 5)
&& (arg29 = lua_tostring(L, 4)) && (*arg29 == 'V' || *arg29 == 'F')
)
{
argset = 3;
arg21_idx = 1;
arg30 = &arg30_default;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] ByteTensor~3D ByteTensor~3D [(V|F)] | [*ByteTensor*] ByteTensor~4D ByteTensor~4D [(V|F)] | [*ByteTensor*] ByteTensor~4D ByteTensor~5D [(V|F)]", type_buf);
}
if(argset == 1)
{
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THByteTensor_conv3Dmul(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10);
return 1;
}
else if(argset == 2)
{
if(arg11_idx)
lua_pushvalue(L, arg11_idx);
else
luaT_pushudata(L, arg11, "torch.ByteTensor");
THByteTensor_conv3Dcmul(arg11,arg12,arg13,arg14,arg15,arg16,arg17,arg18,arg19,arg20);
return 1;
}
else if(argset == 3)
{
if(arg21_idx)
lua_pushvalue(L, arg21_idx);
else
luaT_pushudata(L, arg21, "torch.ByteTensor");
THByteTensor_conv3Dmv(arg21,arg22,arg23,arg24,arg25,arg26,arg27,arg28,arg29,arg30);
return 1;
}
return 0;
}

static int torch_xcorr3(lua_State *L)
{
  int narg = lua_gettop(L);
  const void *tname;
  if(narg >= 1 && (tname = torch_istensortype(L, luaT_typename(L, 1)))) /* first argument is tensor? */
  {
  }
  else if(narg >= 2 && (tname = torch_istensortype(L, luaT_typename(L, 2)))) /* second? */
  {
  }
  else if(narg >= 1 && (tname = torch_istensorarray(L, 1))) /* torch table argument? */
  {
  }
  else if(narg >= 1 && lua_type(L, narg) == LUA_TSTRING
	  && (tname = torch_istensortype(L, lua_tostring(L, narg)))) /* do we have a valid tensor type string then? */
  {
    lua_remove(L, -2);
  }
  else if(!(tname = torch_istensortype(L, torch_getdefaulttensortype(L))))
    luaL_error(L, "internal error: the default tensor type does not seem to be an actual tensor");

  lua_pushstring(L, "xcorr3");
  lua_rawget(L, -2);
  if(lua_isfunction(L, -1))
  {
    lua_insert(L, 1);
    lua_pop(L, 2); /* the two tables we put on the stack above */
    lua_call(L, lua_gettop(L)-1, LUA_MULTRET);
  }
  else
    return luaL_error(L, "%s does not implement the torch.xcorr3() function", tname);

  return lua_gettop(L);
}

static int torch_ByteTensor_lt(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
unsigned char arg3 = 0;
THByteTensor *arg4 = NULL;
int arg4_idx = 0;
THByteTensor *arg5 = NULL;
unsigned char arg6 = 0;
THByteTensor *arg7 = NULL;
int arg7_idx = 0;
THByteTensor *arg8 = NULL;
THByteTensor *arg9 = NULL;
THByteTensor *arg10 = NULL;
int arg10_idx = 0;
THByteTensor *arg11 = NULL;
THByteTensor *arg12 = NULL;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 1;
arg3 = (unsigned char)lua_tonumber(L, 2);
arg1 = THByteTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 1;
arg1_idx = 1;
arg3 = (unsigned char)lua_tonumber(L, 3);
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg4_idx = 1;
arg6 = (unsigned char)lua_tonumber(L, 3);
}
else if(narg == 2
&& (arg8 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg9 = luaT_toudata(L, 2, "torch.ByteTensor"))
)
{
argset = 3;
arg7 = THByteTensor_new();
}
else if(narg == 3
&& (arg7 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg8 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& (arg9 = luaT_toudata(L, 3, "torch.ByteTensor"))
)
{
argset = 3;
arg7_idx = 1;
}
else if(narg == 3
&& (arg10 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg11 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& (arg12 = luaT_toudata(L, 3, "torch.ByteTensor"))
)
{
argset = 4;
arg10_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] ByteTensor unsigned char | *ByteTensor* ByteTensor unsigned char | [*ByteTensor*] ByteTensor ByteTensor | *ByteTensor* ByteTensor ByteTensor", type_buf);
}
if(argset == 1)
{
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THByteTensor_ltValue(arg1,arg2,arg3);
return 1;
}
else if(argset == 2)
{
lua_pushvalue(L, arg4_idx);
THByteTensor_ltValueT(arg4,arg5,arg6);
return 1;
}
else if(argset == 3)
{
if(arg7_idx)
lua_pushvalue(L, arg7_idx);
else
luaT_pushudata(L, arg7, "torch.ByteTensor");
THByteTensor_ltTensor(arg7,arg8,arg9);
return 1;
}
else if(argset == 4)
{
lua_pushvalue(L, arg10_idx);
THByteTensor_ltTensorT(arg10,arg11,arg12);
return 1;
}
return 0;
}

static int torch_lt(lua_State *L)
{
  int narg = lua_gettop(L);
  const void *tname;
  if(narg >= 1 && (tname = torch_istensortype(L, luaT_typename(L, 1)))) /* first argument is tensor? */
  {
  }
  else if(narg >= 2 && (tname = torch_istensortype(L, luaT_typename(L, 2)))) /* second? */
  {
  }
  else if(narg >= 1 && (tname = torch_istensorarray(L, 1))) /* torch table argument? */
  {
  }
  else if(narg >= 1 && lua_type(L, narg) == LUA_TSTRING
	  && (tname = torch_istensortype(L, lua_tostring(L, narg)))) /* do we have a valid tensor type string then? */
  {
    lua_remove(L, -2);
  }
  else if(!(tname = torch_istensortype(L, torch_getdefaulttensortype(L))))
    luaL_error(L, "internal error: the default tensor type does not seem to be an actual tensor");

  lua_pushstring(L, "lt");
  lua_rawget(L, -2);
  if(lua_isfunction(L, -1))
  {
    lua_insert(L, 1);
    lua_pop(L, 2); /* the two tables we put on the stack above */
    lua_call(L, lua_gettop(L)-1, LUA_MULTRET);
  }
  else
    return luaL_error(L, "%s does not implement the torch.lt() function", tname);

  return lua_gettop(L);
}

static int torch_ByteTensor_gt(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
unsigned char arg3 = 0;
THByteTensor *arg4 = NULL;
int arg4_idx = 0;
THByteTensor *arg5 = NULL;
unsigned char arg6 = 0;
THByteTensor *arg7 = NULL;
int arg7_idx = 0;
THByteTensor *arg8 = NULL;
THByteTensor *arg9 = NULL;
THByteTensor *arg10 = NULL;
int arg10_idx = 0;
THByteTensor *arg11 = NULL;
THByteTensor *arg12 = NULL;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 1;
arg3 = (unsigned char)lua_tonumber(L, 2);
arg1 = THByteTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 1;
arg1_idx = 1;
arg3 = (unsigned char)lua_tonumber(L, 3);
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg4_idx = 1;
arg6 = (unsigned char)lua_tonumber(L, 3);
}
else if(narg == 2
&& (arg8 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg9 = luaT_toudata(L, 2, "torch.ByteTensor"))
)
{
argset = 3;
arg7 = THByteTensor_new();
}
else if(narg == 3
&& (arg7 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg8 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& (arg9 = luaT_toudata(L, 3, "torch.ByteTensor"))
)
{
argset = 3;
arg7_idx = 1;
}
else if(narg == 3
&& (arg10 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg11 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& (arg12 = luaT_toudata(L, 3, "torch.ByteTensor"))
)
{
argset = 4;
arg10_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] ByteTensor unsigned char | *ByteTensor* ByteTensor unsigned char | [*ByteTensor*] ByteTensor ByteTensor | *ByteTensor* ByteTensor ByteTensor", type_buf);
}
if(argset == 1)
{
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THByteTensor_gtValue(arg1,arg2,arg3);
return 1;
}
else if(argset == 2)
{
lua_pushvalue(L, arg4_idx);
THByteTensor_gtValueT(arg4,arg5,arg6);
return 1;
}
else if(argset == 3)
{
if(arg7_idx)
lua_pushvalue(L, arg7_idx);
else
luaT_pushudata(L, arg7, "torch.ByteTensor");
THByteTensor_gtTensor(arg7,arg8,arg9);
return 1;
}
else if(argset == 4)
{
lua_pushvalue(L, arg10_idx);
THByteTensor_gtTensorT(arg10,arg11,arg12);
return 1;
}
return 0;
}

static int torch_gt(lua_State *L)
{
  int narg = lua_gettop(L);
  const void *tname;
  if(narg >= 1 && (tname = torch_istensortype(L, luaT_typename(L, 1)))) /* first argument is tensor? */
  {
  }
  else if(narg >= 2 && (tname = torch_istensortype(L, luaT_typename(L, 2)))) /* second? */
  {
  }
  else if(narg >= 1 && (tname = torch_istensorarray(L, 1))) /* torch table argument? */
  {
  }
  else if(narg >= 1 && lua_type(L, narg) == LUA_TSTRING
	  && (tname = torch_istensortype(L, lua_tostring(L, narg)))) /* do we have a valid tensor type string then? */
  {
    lua_remove(L, -2);
  }
  else if(!(tname = torch_istensortype(L, torch_getdefaulttensortype(L))))
    luaL_error(L, "internal error: the default tensor type does not seem to be an actual tensor");

  lua_pushstring(L, "gt");
  lua_rawget(L, -2);
  if(lua_isfunction(L, -1))
  {
    lua_insert(L, 1);
    lua_pop(L, 2); /* the two tables we put on the stack above */
    lua_call(L, lua_gettop(L)-1, LUA_MULTRET);
  }
  else
    return luaL_error(L, "%s does not implement the torch.gt() function", tname);

  return lua_gettop(L);
}

static int torch_ByteTensor_le(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
unsigned char arg3 = 0;
THByteTensor *arg4 = NULL;
int arg4_idx = 0;
THByteTensor *arg5 = NULL;
unsigned char arg6 = 0;
THByteTensor *arg7 = NULL;
int arg7_idx = 0;
THByteTensor *arg8 = NULL;
THByteTensor *arg9 = NULL;
THByteTensor *arg10 = NULL;
int arg10_idx = 0;
THByteTensor *arg11 = NULL;
THByteTensor *arg12 = NULL;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 1;
arg3 = (unsigned char)lua_tonumber(L, 2);
arg1 = THByteTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 1;
arg1_idx = 1;
arg3 = (unsigned char)lua_tonumber(L, 3);
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg4_idx = 1;
arg6 = (unsigned char)lua_tonumber(L, 3);
}
else if(narg == 2
&& (arg8 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg9 = luaT_toudata(L, 2, "torch.ByteTensor"))
)
{
argset = 3;
arg7 = THByteTensor_new();
}
else if(narg == 3
&& (arg7 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg8 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& (arg9 = luaT_toudata(L, 3, "torch.ByteTensor"))
)
{
argset = 3;
arg7_idx = 1;
}
else if(narg == 3
&& (arg10 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg11 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& (arg12 = luaT_toudata(L, 3, "torch.ByteTensor"))
)
{
argset = 4;
arg10_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] ByteTensor unsigned char | *ByteTensor* ByteTensor unsigned char | [*ByteTensor*] ByteTensor ByteTensor | *ByteTensor* ByteTensor ByteTensor", type_buf);
}
if(argset == 1)
{
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THByteTensor_leValue(arg1,arg2,arg3);
return 1;
}
else if(argset == 2)
{
lua_pushvalue(L, arg4_idx);
THByteTensor_leValueT(arg4,arg5,arg6);
return 1;
}
else if(argset == 3)
{
if(arg7_idx)
lua_pushvalue(L, arg7_idx);
else
luaT_pushudata(L, arg7, "torch.ByteTensor");
THByteTensor_leTensor(arg7,arg8,arg9);
return 1;
}
else if(argset == 4)
{
lua_pushvalue(L, arg10_idx);
THByteTensor_leTensorT(arg10,arg11,arg12);
return 1;
}
return 0;
}

static int torch_le(lua_State *L)
{
  int narg = lua_gettop(L);
  const void *tname;
  if(narg >= 1 && (tname = torch_istensortype(L, luaT_typename(L, 1)))) /* first argument is tensor? */
  {
  }
  else if(narg >= 2 && (tname = torch_istensortype(L, luaT_typename(L, 2)))) /* second? */
  {
  }
  else if(narg >= 1 && (tname = torch_istensorarray(L, 1))) /* torch table argument? */
  {
  }
  else if(narg >= 1 && lua_type(L, narg) == LUA_TSTRING
	  && (tname = torch_istensortype(L, lua_tostring(L, narg)))) /* do we have a valid tensor type string then? */
  {
    lua_remove(L, -2);
  }
  else if(!(tname = torch_istensortype(L, torch_getdefaulttensortype(L))))
    luaL_error(L, "internal error: the default tensor type does not seem to be an actual tensor");

  lua_pushstring(L, "le");
  lua_rawget(L, -2);
  if(lua_isfunction(L, -1))
  {
    lua_insert(L, 1);
    lua_pop(L, 2); /* the two tables we put on the stack above */
    lua_call(L, lua_gettop(L)-1, LUA_MULTRET);
  }
  else
    return luaL_error(L, "%s does not implement the torch.le() function", tname);

  return lua_gettop(L);
}

static int torch_ByteTensor_ge(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
unsigned char arg3 = 0;
THByteTensor *arg4 = NULL;
int arg4_idx = 0;
THByteTensor *arg5 = NULL;
unsigned char arg6 = 0;
THByteTensor *arg7 = NULL;
int arg7_idx = 0;
THByteTensor *arg8 = NULL;
THByteTensor *arg9 = NULL;
THByteTensor *arg10 = NULL;
int arg10_idx = 0;
THByteTensor *arg11 = NULL;
THByteTensor *arg12 = NULL;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 1;
arg3 = (unsigned char)lua_tonumber(L, 2);
arg1 = THByteTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 1;
arg1_idx = 1;
arg3 = (unsigned char)lua_tonumber(L, 3);
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg4_idx = 1;
arg6 = (unsigned char)lua_tonumber(L, 3);
}
else if(narg == 2
&& (arg8 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg9 = luaT_toudata(L, 2, "torch.ByteTensor"))
)
{
argset = 3;
arg7 = THByteTensor_new();
}
else if(narg == 3
&& (arg7 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg8 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& (arg9 = luaT_toudata(L, 3, "torch.ByteTensor"))
)
{
argset = 3;
arg7_idx = 1;
}
else if(narg == 3
&& (arg10 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg11 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& (arg12 = luaT_toudata(L, 3, "torch.ByteTensor"))
)
{
argset = 4;
arg10_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] ByteTensor unsigned char | *ByteTensor* ByteTensor unsigned char | [*ByteTensor*] ByteTensor ByteTensor | *ByteTensor* ByteTensor ByteTensor", type_buf);
}
if(argset == 1)
{
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THByteTensor_geValue(arg1,arg2,arg3);
return 1;
}
else if(argset == 2)
{
lua_pushvalue(L, arg4_idx);
THByteTensor_geValueT(arg4,arg5,arg6);
return 1;
}
else if(argset == 3)
{
if(arg7_idx)
lua_pushvalue(L, arg7_idx);
else
luaT_pushudata(L, arg7, "torch.ByteTensor");
THByteTensor_geTensor(arg7,arg8,arg9);
return 1;
}
else if(argset == 4)
{
lua_pushvalue(L, arg10_idx);
THByteTensor_geTensorT(arg10,arg11,arg12);
return 1;
}
return 0;
}

static int torch_ge(lua_State *L)
{
  int narg = lua_gettop(L);
  const void *tname;
  if(narg >= 1 && (tname = torch_istensortype(L, luaT_typename(L, 1)))) /* first argument is tensor? */
  {
  }
  else if(narg >= 2 && (tname = torch_istensortype(L, luaT_typename(L, 2)))) /* second? */
  {
  }
  else if(narg >= 1 && (tname = torch_istensorarray(L, 1))) /* torch table argument? */
  {
  }
  else if(narg >= 1 && lua_type(L, narg) == LUA_TSTRING
	  && (tname = torch_istensortype(L, lua_tostring(L, narg)))) /* do we have a valid tensor type string then? */
  {
    lua_remove(L, -2);
  }
  else if(!(tname = torch_istensortype(L, torch_getdefaulttensortype(L))))
    luaL_error(L, "internal error: the default tensor type does not seem to be an actual tensor");

  lua_pushstring(L, "ge");
  lua_rawget(L, -2);
  if(lua_isfunction(L, -1))
  {
    lua_insert(L, 1);
    lua_pop(L, 2); /* the two tables we put on the stack above */
    lua_call(L, lua_gettop(L)-1, LUA_MULTRET);
  }
  else
    return luaL_error(L, "%s does not implement the torch.ge() function", tname);

  return lua_gettop(L);
}

static int torch_ByteTensor_eq(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
unsigned char arg3 = 0;
THByteTensor *arg4 = NULL;
int arg4_idx = 0;
THByteTensor *arg5 = NULL;
unsigned char arg6 = 0;
THByteTensor *arg7 = NULL;
int arg7_idx = 0;
THByteTensor *arg8 = NULL;
THByteTensor *arg9 = NULL;
THByteTensor *arg10 = NULL;
int arg10_idx = 0;
THByteTensor *arg11 = NULL;
THByteTensor *arg12 = NULL;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 1;
arg3 = (unsigned char)lua_tonumber(L, 2);
arg1 = THByteTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 1;
arg1_idx = 1;
arg3 = (unsigned char)lua_tonumber(L, 3);
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg4_idx = 1;
arg6 = (unsigned char)lua_tonumber(L, 3);
}
else if(narg == 2
&& (arg8 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg9 = luaT_toudata(L, 2, "torch.ByteTensor"))
)
{
argset = 3;
arg7 = THByteTensor_new();
}
else if(narg == 3
&& (arg7 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg8 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& (arg9 = luaT_toudata(L, 3, "torch.ByteTensor"))
)
{
argset = 3;
arg7_idx = 1;
}
else if(narg == 3
&& (arg10 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg11 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& (arg12 = luaT_toudata(L, 3, "torch.ByteTensor"))
)
{
argset = 4;
arg10_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] ByteTensor unsigned char | *ByteTensor* ByteTensor unsigned char | [*ByteTensor*] ByteTensor ByteTensor | *ByteTensor* ByteTensor ByteTensor", type_buf);
}
if(argset == 1)
{
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THByteTensor_eqValue(arg1,arg2,arg3);
return 1;
}
else if(argset == 2)
{
lua_pushvalue(L, arg4_idx);
THByteTensor_eqValueT(arg4,arg5,arg6);
return 1;
}
else if(argset == 3)
{
if(arg7_idx)
lua_pushvalue(L, arg7_idx);
else
luaT_pushudata(L, arg7, "torch.ByteTensor");
THByteTensor_eqTensor(arg7,arg8,arg9);
return 1;
}
else if(argset == 4)
{
lua_pushvalue(L, arg10_idx);
THByteTensor_eqTensorT(arg10,arg11,arg12);
return 1;
}
return 0;
}

static int torch_eq(lua_State *L)
{
  int narg = lua_gettop(L);
  const void *tname;
  if(narg >= 1 && (tname = torch_istensortype(L, luaT_typename(L, 1)))) /* first argument is tensor? */
  {
  }
  else if(narg >= 2 && (tname = torch_istensortype(L, luaT_typename(L, 2)))) /* second? */
  {
  }
  else if(narg >= 1 && (tname = torch_istensorarray(L, 1))) /* torch table argument? */
  {
  }
  else if(narg >= 1 && lua_type(L, narg) == LUA_TSTRING
	  && (tname = torch_istensortype(L, lua_tostring(L, narg)))) /* do we have a valid tensor type string then? */
  {
    lua_remove(L, -2);
  }
  else if(!(tname = torch_istensortype(L, torch_getdefaulttensortype(L))))
    luaL_error(L, "internal error: the default tensor type does not seem to be an actual tensor");

  lua_pushstring(L, "eq");
  lua_rawget(L, -2);
  if(lua_isfunction(L, -1))
  {
    lua_insert(L, 1);
    lua_pop(L, 2); /* the two tables we put on the stack above */
    lua_call(L, lua_gettop(L)-1, LUA_MULTRET);
  }
  else
    return luaL_error(L, "%s does not implement the torch.eq() function", tname);

  return lua_gettop(L);
}

static int torch_ByteTensor_ne(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
unsigned char arg3 = 0;
THByteTensor *arg4 = NULL;
int arg4_idx = 0;
THByteTensor *arg5 = NULL;
unsigned char arg6 = 0;
THByteTensor *arg7 = NULL;
int arg7_idx = 0;
THByteTensor *arg8 = NULL;
THByteTensor *arg9 = NULL;
THByteTensor *arg10 = NULL;
int arg10_idx = 0;
THByteTensor *arg11 = NULL;
THByteTensor *arg12 = NULL;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 1;
arg3 = (unsigned char)lua_tonumber(L, 2);
arg1 = THByteTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 1;
arg1_idx = 1;
arg3 = (unsigned char)lua_tonumber(L, 3);
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg4_idx = 1;
arg6 = (unsigned char)lua_tonumber(L, 3);
}
else if(narg == 2
&& (arg8 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg9 = luaT_toudata(L, 2, "torch.ByteTensor"))
)
{
argset = 3;
arg7 = THByteTensor_new();
}
else if(narg == 3
&& (arg7 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg8 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& (arg9 = luaT_toudata(L, 3, "torch.ByteTensor"))
)
{
argset = 3;
arg7_idx = 1;
}
else if(narg == 3
&& (arg10 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg11 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& (arg12 = luaT_toudata(L, 3, "torch.ByteTensor"))
)
{
argset = 4;
arg10_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] ByteTensor unsigned char | *ByteTensor* ByteTensor unsigned char | [*ByteTensor*] ByteTensor ByteTensor | *ByteTensor* ByteTensor ByteTensor", type_buf);
}
if(argset == 1)
{
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THByteTensor_neValue(arg1,arg2,arg3);
return 1;
}
else if(argset == 2)
{
lua_pushvalue(L, arg4_idx);
THByteTensor_neValueT(arg4,arg5,arg6);
return 1;
}
else if(argset == 3)
{
if(arg7_idx)
lua_pushvalue(L, arg7_idx);
else
luaT_pushudata(L, arg7, "torch.ByteTensor");
THByteTensor_neTensor(arg7,arg8,arg9);
return 1;
}
else if(argset == 4)
{
lua_pushvalue(L, arg10_idx);
THByteTensor_neTensorT(arg10,arg11,arg12);
return 1;
}
return 0;
}

static int torch_ne(lua_State *L)
{
  int narg = lua_gettop(L);
  const void *tname;
  if(narg >= 1 && (tname = torch_istensortype(L, luaT_typename(L, 1)))) /* first argument is tensor? */
  {
  }
  else if(narg >= 2 && (tname = torch_istensortype(L, luaT_typename(L, 2)))) /* second? */
  {
  }
  else if(narg >= 1 && (tname = torch_istensorarray(L, 1))) /* torch table argument? */
  {
  }
  else if(narg >= 1 && lua_type(L, narg) == LUA_TSTRING
	  && (tname = torch_istensortype(L, lua_tostring(L, narg)))) /* do we have a valid tensor type string then? */
  {
    lua_remove(L, -2);
  }
  else if(!(tname = torch_istensortype(L, torch_getdefaulttensortype(L))))
    luaL_error(L, "internal error: the default tensor type does not seem to be an actual tensor");

  lua_pushstring(L, "ne");
  lua_rawget(L, -2);
  if(lua_isfunction(L, -1))
  {
    lua_insert(L, 1);
    lua_pop(L, 2); /* the two tables we put on the stack above */
    lua_call(L, lua_gettop(L)-1, LUA_MULTRET);
  }
  else
    return luaL_error(L, "%s does not implement the torch.ne() function", tname);

  return lua_gettop(L);
}

static int torch_ByteTensor_nonzero(lua_State *L)
{
int narg = lua_gettop(L);
THLongTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
if(narg == 1
&& (arg2 = luaT_toudata(L, 1, "torch.ByteTensor"))
)
{
arg1 = THLongTensor_new();
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
)
{
THLongTensor_add(arg1, arg1, -1);
arg1_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*LongTensor*] ByteTensor", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.LongTensor");
THByteTensor_nonzero(arg1,arg2);
THLongTensor_add(arg1, arg1, 1);
return 1;
}

static int torch_nonzero(lua_State *L)
{
  int narg = lua_gettop(L);
  const void *tname;
  if(narg >= 1 && (tname = torch_istensortype(L, luaT_typename(L, 1)))) /* first argument is tensor? */
  {
  }
  else if(narg >= 2 && (tname = torch_istensortype(L, luaT_typename(L, 2)))) /* second? */
  {
  }
  else if(narg >= 1 && (tname = torch_istensorarray(L, 1))) /* torch table argument? */
  {
  }
  else if(narg >= 1 && lua_type(L, narg) == LUA_TSTRING
	  && (tname = torch_istensortype(L, lua_tostring(L, narg)))) /* do we have a valid tensor type string then? */
  {
    lua_remove(L, -2);
  }
  else if(!(tname = torch_istensortype(L, torch_getdefaulttensortype(L))))
    luaL_error(L, "internal error: the default tensor type does not seem to be an actual tensor");

  lua_pushstring(L, "nonzero");
  lua_rawget(L, -2);
  if(lua_isfunction(L, -1))
  {
    lua_insert(L, 1);
    lua_pop(L, 2); /* the two tables we put on the stack above */
    lua_call(L, lua_gettop(L)-1, LUA_MULTRET);
  }
  else
    return luaL_error(L, "%s does not implement the torch.nonzero() function", tname);

  return lua_gettop(L);
}

static int torch_ByteTensor_all(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg2 = 0;
if(narg == 1
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
)
{
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: ByteTensor", type_buf);
}
arg2 = THByteTensor_logicalall(arg1);
lua_pushboolean(L, arg2);
return 1;
}

static int torch_all(lua_State *L)
{
  int narg = lua_gettop(L);
  const void *tname;
  if(narg >= 1 && (tname = torch_istensortype(L, luaT_typename(L, 1)))) /* first argument is tensor? */
  {
  }
  else if(narg >= 2 && (tname = torch_istensortype(L, luaT_typename(L, 2)))) /* second? */
  {
  }
  else if(narg >= 1 && (tname = torch_istensorarray(L, 1))) /* torch table argument? */
  {
  }
  else if(narg >= 1 && lua_type(L, narg) == LUA_TSTRING
	  && (tname = torch_istensortype(L, lua_tostring(L, narg)))) /* do we have a valid tensor type string then? */
  {
    lua_remove(L, -2);
  }
  else if(!(tname = torch_istensortype(L, torch_getdefaulttensortype(L))))
    luaL_error(L, "internal error: the default tensor type does not seem to be an actual tensor");

  lua_pushstring(L, "all");
  lua_rawget(L, -2);
  if(lua_isfunction(L, -1))
  {
    lua_insert(L, 1);
    lua_pop(L, 2); /* the two tables we put on the stack above */
    lua_call(L, lua_gettop(L)-1, LUA_MULTRET);
  }
  else
    return luaL_error(L, "%s does not implement the torch.all() function", tname);

  return lua_gettop(L);
}

static int torch_ByteTensor_any(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg2 = 0;
if(narg == 1
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
)
{
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: ByteTensor", type_buf);
}
arg2 = THByteTensor_logicalany(arg1);
lua_pushboolean(L, arg2);
return 1;
}

static int torch_any(lua_State *L)
{
  int narg = lua_gettop(L);
  const void *tname;
  if(narg >= 1 && (tname = torch_istensortype(L, luaT_typename(L, 1)))) /* first argument is tensor? */
  {
  }
  else if(narg >= 2 && (tname = torch_istensortype(L, luaT_typename(L, 2)))) /* second? */
  {
  }
  else if(narg >= 1 && (tname = torch_istensorarray(L, 1))) /* torch table argument? */
  {
  }
  else if(narg >= 1 && lua_type(L, narg) == LUA_TSTRING
	  && (tname = torch_istensortype(L, lua_tostring(L, narg)))) /* do we have a valid tensor type string then? */
  {
    lua_remove(L, -2);
  }
  else if(!(tname = torch_istensortype(L, torch_getdefaulttensortype(L))))
    luaL_error(L, "internal error: the default tensor type does not seem to be an actual tensor");

  lua_pushstring(L, "any");
  lua_rawget(L, -2);
  if(lua_isfunction(L, -1))
  {
    lua_insert(L, 1);
    lua_pop(L, 2); /* the two tables we put on the stack above */
    lua_call(L, lua_gettop(L)-1, LUA_MULTRET);
  }
  else
    return luaL_error(L, "%s does not implement the torch.any() function", tname);

  return lua_gettop(L);
}

#ifndef _CWRAP_STR_ARG_TYPES_4821726c1947cdf3eebacade98173939
#define _CWRAP_STR_ARG_TYPES_4821726c1947cdf3eebacade98173939
#include "string.h"
static void str_arg_types(lua_State *L, char *buf, int n) {
    int i;
  int nargs = lua_gettop(L);
  if (nargs == 0) {
    snprintf(buf, n, "no arguments provided");
    return;
  }
  for (i = 1; i <= nargs; i++) {
    int l;
    const char *torch_type = luaT_typename(L, i);
    if(torch_type && !strncmp(torch_type, "torch.", 6)) torch_type += 6;
    if (torch_type) l = snprintf(buf, n, "%s ", torch_type);
    else if(lua_isnil(L, i)) l = snprintf(buf, n, "%s ", "nil");
    else if(lua_isboolean(L, i)) l = snprintf(buf, n, "%s ", "boolean");
    else if(lua_isnumber(L, i)) l = snprintf(buf, n, "%s ", "number");
    else if(lua_isstring(L, i)) l = snprintf(buf, n, "%s ", "string");
    else if(lua_istable(L, i)) l = snprintf(buf, n, "%s ", "table");
    else if(lua_isuserdata(L, i)) l = snprintf(buf, n, "%s ", "userdata");
    else l = snprintf(buf, n, "%s ", "???");
    if (l >= n) return;
    buf += l;
    n   -= l;
  }
}
#endif
static int m_torch_ByteTensor_zero(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
if(narg == 1
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
)
{
arg1_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ByteTensor*", type_buf);
}
lua_pushvalue(L, arg1_idx);
THByteTensor_zero(arg1);
return 1;
}

static int m_torch_ByteTensor_fill(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
unsigned char arg2 = 0;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
)
{
arg1_idx = 1;
arg2 = (unsigned char)lua_tonumber(L, 2);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ByteTensor* unsigned char", type_buf);
}
lua_pushvalue(L, arg1_idx);
THByteTensor_fill(arg1,arg2);
return 1;
}

static int m_torch_ByteTensor_zeros(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THLongStorage *arg2 = NULL;
if(narg >= 2
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& torch_islongargs(L, 2)
)
{
arg1_idx = 1;
arg2 = torch_checklongargs(L, 2);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ByteTensor* (LongStorage | dim1 [dim2...])", type_buf);
}
lua_pushvalue(L, arg1_idx);
THByteTensor_zeros(arg1,arg2);
THLongStorage_free(arg2);
return 1;
}

static int m_torch_ByteTensor_ones(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THLongStorage *arg2 = NULL;
if(narg >= 2
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& torch_islongargs(L, 2)
)
{
arg1_idx = 1;
arg2 = torch_checklongargs(L, 2);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ByteTensor* (LongStorage | dim1 [dim2...])", type_buf);
}
lua_pushvalue(L, arg1_idx);
THByteTensor_ones(arg1,arg2);
THLongStorage_free(arg2);
return 1;
}

static int m_torch_ByteTensor_reshape(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
THLongStorage *arg3 = NULL;
if(narg >= 2
&& (arg2 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& torch_islongargs(L, 2)
)
{
arg3 = torch_checklongargs(L, 2);
arg1 = THByteTensor_new();
}
else if(narg >= 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& torch_islongargs(L, 3)
)
{
arg1_idx = 1;
arg3 = torch_checklongargs(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] ByteTensor (LongStorage | dim1 [dim2...])", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THByteTensor_reshape(arg1,arg2,arg3);
THLongStorage_free(arg3);
return 1;
}

static int m_torch_ByteTensor_gather(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
long arg3 = 0;
THLongTensor *arg4 = NULL;
if(narg == 3
&& (arg2 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
&& (arg4 = luaT_toudata(L, 3, "torch.LongTensor"))
)
{
arg3 = (long)lua_tonumber(L, 2)-1;
arg1 = THByteTensor_new();
THLongStorage* arg1_size = THLongTensor_newSizeOf(arg4);
THByteTensor_resize(arg1, arg1_size, NULL);
THLongStorage_free(arg1_size);
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
&& (arg4 = luaT_toudata(L, 4, "torch.LongTensor"))
)
{
arg1_idx = 1;
arg3 = (long)lua_tonumber(L, 3)-1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] ByteTensor index LongTensor", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THByteTensor_gather(arg1,arg2,arg3,arg4);
return 1;
}

static int m_torch_ByteTensor_scatter(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
long arg2 = 0;
THLongTensor *arg3 = NULL;
THByteTensor *arg4 = NULL;
THByteTensor *arg5 = NULL;
int arg5_idx = 0;
long arg6 = 0;
THLongTensor *arg7 = NULL;
unsigned char arg8 = 0;
if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
&& (arg3 = luaT_toudata(L, 3, "torch.LongTensor"))
&& (arg4 = luaT_toudata(L, 4, "torch.ByteTensor"))
)
{
argset = 1;
arg1_idx = 1;
arg2 = (long)lua_tonumber(L, 2)-1;
}
else if(narg == 4
&& (arg5 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
&& (arg7 = luaT_toudata(L, 3, "torch.LongTensor"))
&& lua_isnumber(L, 4)
)
{
argset = 2;
arg5_idx = 1;
arg6 = (long)lua_tonumber(L, 2)-1;
arg8 = (unsigned char)lua_tonumber(L, 4);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ByteTensor* index LongTensor ByteTensor | *ByteTensor* index LongTensor unsigned char", type_buf);
}
if(argset == 1)
{
lua_pushvalue(L, arg1_idx);
THByteTensor_scatter(arg1,arg2,arg3,arg4);
return 1;
}
else if(argset == 2)
{
lua_pushvalue(L, arg5_idx);
THByteTensor_scatterFill(arg5,arg6,arg7,arg8);
return 1;
}
return 0;
}

static int m_torch_ByteTensor_dot(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
THByteTensor *arg2 = NULL;
long arg3 = 0;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
)
{
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: ByteTensor ByteTensor", type_buf);
}
arg3 = THByteTensor_dot(arg1,arg2);
lua_pushnumber(L, (lua_Number)arg3);
return 1;
}

static int m_torch_ByteTensor_equal(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
THByteTensor *arg2 = NULL;
int arg3 = 0;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
)
{
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: ByteTensor ByteTensor", type_buf);
}
arg3 = THByteTensor_equal(arg1,arg2);
lua_pushboolean(L, arg3);
return 1;
}

static int m_torch_ByteTensor_add(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
unsigned char arg3 = 0;
THByteTensor *arg4 = NULL;
int arg4_idx = 0;
THByteTensor *arg5 = NULL;
unsigned char arg6 = 1;
THByteTensor *arg7 = NULL;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 1;
arg1_idx = 1;
arg3 = (unsigned char)lua_tonumber(L, 2);
arg2 = arg1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 1;
arg1_idx = 1;
arg3 = (unsigned char)lua_tonumber(L, 3);
}
else if(narg == 2
&& (arg4 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg7 = luaT_toudata(L, 2, "torch.ByteTensor"))
)
{
argset = 2;
arg4_idx = 1;
arg5 = arg4;
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& (arg7 = luaT_toudata(L, 3, "torch.ByteTensor"))
)
{
argset = 2;
arg4_idx = 1;
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
&& (arg7 = luaT_toudata(L, 3, "torch.ByteTensor"))
)
{
argset = 2;
arg4_idx = 1;
arg6 = (unsigned char)lua_tonumber(L, 2);
arg5 = arg4;
}
else if(narg == 4
&& (arg4 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
&& (arg7 = luaT_toudata(L, 4, "torch.ByteTensor"))
)
{
argset = 2;
arg4_idx = 1;
arg6 = (unsigned char)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ByteTensor* [ByteTensor] unsigned char | *ByteTensor* [ByteTensor] [unsigned char] ByteTensor", type_buf);
}
if(argset == 1)
{
lua_pushvalue(L, arg1_idx);
THByteTensor_add(arg1,arg2,arg3);
return 1;
}
else if(argset == 2)
{
lua_pushvalue(L, arg4_idx);
THByteTensor_cadd(arg4,arg5,arg6,arg7);
return 1;
}
return 0;
}

static int m_torch_ByteTensor_csub(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
unsigned char arg3 = 0;
THByteTensor *arg4 = NULL;
int arg4_idx = 0;
THByteTensor *arg5 = NULL;
unsigned char arg6 = 1;
THByteTensor *arg7 = NULL;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 1;
arg1_idx = 1;
arg3 = (unsigned char)lua_tonumber(L, 2);
arg2 = arg1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 1;
arg1_idx = 1;
arg3 = (unsigned char)lua_tonumber(L, 3);
}
else if(narg == 2
&& (arg4 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg7 = luaT_toudata(L, 2, "torch.ByteTensor"))
)
{
argset = 2;
arg4_idx = 1;
arg5 = arg4;
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& (arg7 = luaT_toudata(L, 3, "torch.ByteTensor"))
)
{
argset = 2;
arg4_idx = 1;
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
&& (arg7 = luaT_toudata(L, 3, "torch.ByteTensor"))
)
{
argset = 2;
arg4_idx = 1;
arg6 = (unsigned char)lua_tonumber(L, 2);
arg5 = arg4;
}
else if(narg == 4
&& (arg4 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
&& (arg7 = luaT_toudata(L, 4, "torch.ByteTensor"))
)
{
argset = 2;
arg4_idx = 1;
arg6 = (unsigned char)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ByteTensor* [ByteTensor] unsigned char | *ByteTensor* [ByteTensor] [unsigned char] ByteTensor", type_buf);
}
if(argset == 1)
{
lua_pushvalue(L, arg1_idx);
THByteTensor_sub(arg1,arg2,arg3);
return 1;
}
else if(argset == 2)
{
lua_pushvalue(L, arg4_idx);
THByteTensor_csub(arg4,arg5,arg6,arg7);
return 1;
}
return 0;
}

static int m_torch_ByteTensor_mul(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
unsigned char arg3 = 0;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
)
{
arg1_idx = 1;
arg3 = (unsigned char)lua_tonumber(L, 2);
arg2 = arg1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (unsigned char)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ByteTensor* [ByteTensor] unsigned char", type_buf);
}
lua_pushvalue(L, arg1_idx);
THByteTensor_mul(arg1,arg2,arg3);
return 1;
}

static int m_torch_ByteTensor_div(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
unsigned char arg3 = 0;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
)
{
arg1_idx = 1;
arg3 = (unsigned char)lua_tonumber(L, 2);
arg2 = arg1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (unsigned char)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ByteTensor* [ByteTensor] unsigned char", type_buf);
}
lua_pushvalue(L, arg1_idx);
THByteTensor_div(arg1,arg2,arg3);
return 1;
}

static int m_torch_ByteTensor_lshift(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
unsigned char arg3 = 0;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
)
{
arg1_idx = 1;
arg3 = (unsigned char)lua_tonumber(L, 2);
arg2 = arg1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (unsigned char)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ByteTensor* [ByteTensor] unsigned char", type_buf);
}
lua_pushvalue(L, arg1_idx);
THByteTensor_lshift(arg1,arg2,arg3);
return 1;
}

static int m_torch_ByteTensor_rshift(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
unsigned char arg3 = 0;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
)
{
arg1_idx = 1;
arg3 = (unsigned char)lua_tonumber(L, 2);
arg2 = arg1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (unsigned char)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ByteTensor* [ByteTensor] unsigned char", type_buf);
}
lua_pushvalue(L, arg1_idx);
THByteTensor_rshift(arg1,arg2,arg3);
return 1;
}

static int m_torch_ByteTensor_fmod(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
unsigned char arg3 = 0;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
)
{
arg1_idx = 1;
arg3 = (unsigned char)lua_tonumber(L, 2);
arg2 = arg1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (unsigned char)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ByteTensor* [ByteTensor] unsigned char", type_buf);
}
lua_pushvalue(L, arg1_idx);
THByteTensor_fmod(arg1,arg2,arg3);
return 1;
}

static int m_torch_ByteTensor_remainder(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
unsigned char arg3 = 0;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
)
{
arg1_idx = 1;
arg3 = (unsigned char)lua_tonumber(L, 2);
arg2 = arg1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (unsigned char)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ByteTensor* [ByteTensor] unsigned char", type_buf);
}
lua_pushvalue(L, arg1_idx);
THByteTensor_remainder(arg1,arg2,arg3);
return 1;
}

static int m_torch_ByteTensor_bitand(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
unsigned char arg3 = 0;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
)
{
arg1_idx = 1;
arg3 = (unsigned char)lua_tonumber(L, 2);
arg2 = arg1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (unsigned char)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ByteTensor* [ByteTensor] unsigned char", type_buf);
}
lua_pushvalue(L, arg1_idx);
THByteTensor_bitand(arg1,arg2,arg3);
return 1;
}

static int m_torch_ByteTensor_bitor(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
unsigned char arg3 = 0;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
)
{
arg1_idx = 1;
arg3 = (unsigned char)lua_tonumber(L, 2);
arg2 = arg1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (unsigned char)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ByteTensor* [ByteTensor] unsigned char", type_buf);
}
lua_pushvalue(L, arg1_idx);
THByteTensor_bitor(arg1,arg2,arg3);
return 1;
}

static int m_torch_ByteTensor_bitxor(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
unsigned char arg3 = 0;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
)
{
arg1_idx = 1;
arg3 = (unsigned char)lua_tonumber(L, 2);
arg2 = arg1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (unsigned char)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ByteTensor* [ByteTensor] unsigned char", type_buf);
}
lua_pushvalue(L, arg1_idx);
THByteTensor_bitxor(arg1,arg2,arg3);
return 1;
}

static int m_torch_ByteTensor_mod(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
unsigned char arg3 = 0;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
)
{
arg1_idx = 1;
arg3 = (unsigned char)lua_tonumber(L, 2);
arg2 = arg1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (unsigned char)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ByteTensor* [ByteTensor] unsigned char", type_buf);
}
lua_pushvalue(L, arg1_idx);
THByteTensor_fmod(arg1,arg2,arg3);
return 1;
}

static int m_torch_ByteTensor_clamp(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
unsigned char arg3 = 0;
unsigned char arg4 = 0;
if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (unsigned char)lua_tonumber(L, 2);
arg4 = (unsigned char)lua_tonumber(L, 3);
arg2 = arg1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
&& lua_isnumber(L, 4)
)
{
arg1_idx = 1;
arg3 = (unsigned char)lua_tonumber(L, 3);
arg4 = (unsigned char)lua_tonumber(L, 4);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ByteTensor* [ByteTensor] unsigned char unsigned char", type_buf);
}
lua_pushvalue(L, arg1_idx);
THByteTensor_clamp(arg1,arg2,arg3,arg4);
return 1;
}

static int m_torch_ByteTensor_match(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
THByteTensor *arg3 = NULL;
unsigned char arg4 = 1;
if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
)
{
arg1_idx = 1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
&& lua_isnumber(L, 4)
)
{
arg1_idx = 1;
arg4 = (unsigned char)lua_tonumber(L, 4);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ByteTensor* ByteTensor ByteTensor [unsigned char]", type_buf);
}
lua_pushvalue(L, arg1_idx);
THByteTensor_match(arg1,arg2,arg3,arg4);
return 1;
}

static int m_torch_ByteTensor_cmul(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
THByteTensor *arg3 = NULL;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
)
{
arg1_idx = 1;
arg2 = arg1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
)
{
arg1_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ByteTensor* [ByteTensor] ByteTensor", type_buf);
}
lua_pushvalue(L, arg1_idx);
THByteTensor_cmul(arg1,arg2,arg3);
return 1;
}

static int m_torch_ByteTensor_cpow(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
THByteTensor *arg3 = NULL;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
)
{
arg1_idx = 1;
arg2 = arg1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
)
{
arg1_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ByteTensor* [ByteTensor] ByteTensor", type_buf);
}
lua_pushvalue(L, arg1_idx);
THByteTensor_cpow(arg1,arg2,arg3);
return 1;
}

static int m_torch_ByteTensor_cdiv(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
THByteTensor *arg3 = NULL;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
)
{
arg1_idx = 1;
arg2 = arg1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
)
{
arg1_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ByteTensor* [ByteTensor] ByteTensor", type_buf);
}
lua_pushvalue(L, arg1_idx);
THByteTensor_cdiv(arg1,arg2,arg3);
return 1;
}

static int m_torch_ByteTensor_clshift(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
THByteTensor *arg3 = NULL;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
)
{
arg1_idx = 1;
arg2 = arg1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
)
{
arg1_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ByteTensor* [ByteTensor] ByteTensor", type_buf);
}
lua_pushvalue(L, arg1_idx);
THByteTensor_clshift(arg1,arg2,arg3);
return 1;
}

static int m_torch_ByteTensor_crshift(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
THByteTensor *arg3 = NULL;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
)
{
arg1_idx = 1;
arg2 = arg1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
)
{
arg1_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ByteTensor* [ByteTensor] ByteTensor", type_buf);
}
lua_pushvalue(L, arg1_idx);
THByteTensor_crshift(arg1,arg2,arg3);
return 1;
}

static int m_torch_ByteTensor_cfmod(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
THByteTensor *arg3 = NULL;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
)
{
arg1_idx = 1;
arg2 = arg1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
)
{
arg1_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ByteTensor* [ByteTensor] ByteTensor", type_buf);
}
lua_pushvalue(L, arg1_idx);
THByteTensor_cfmod(arg1,arg2,arg3);
return 1;
}

static int m_torch_ByteTensor_cremainder(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
THByteTensor *arg3 = NULL;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
)
{
arg1_idx = 1;
arg2 = arg1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
)
{
arg1_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ByteTensor* [ByteTensor] ByteTensor", type_buf);
}
lua_pushvalue(L, arg1_idx);
THByteTensor_cremainder(arg1,arg2,arg3);
return 1;
}

static int m_torch_ByteTensor_cbitand(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
THByteTensor *arg3 = NULL;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
)
{
arg1_idx = 1;
arg2 = arg1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
)
{
arg1_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ByteTensor* [ByteTensor] ByteTensor", type_buf);
}
lua_pushvalue(L, arg1_idx);
THByteTensor_cbitand(arg1,arg2,arg3);
return 1;
}

static int m_torch_ByteTensor_cbitor(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
THByteTensor *arg3 = NULL;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
)
{
arg1_idx = 1;
arg2 = arg1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
)
{
arg1_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ByteTensor* [ByteTensor] ByteTensor", type_buf);
}
lua_pushvalue(L, arg1_idx);
THByteTensor_cbitor(arg1,arg2,arg3);
return 1;
}

static int m_torch_ByteTensor_cbitxor(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
THByteTensor *arg3 = NULL;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
)
{
arg1_idx = 1;
arg2 = arg1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
)
{
arg1_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ByteTensor* [ByteTensor] ByteTensor", type_buf);
}
lua_pushvalue(L, arg1_idx);
THByteTensor_cbitxor(arg1,arg2,arg3);
return 1;
}

static int m_torch_ByteTensor_cmod(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
THByteTensor *arg3 = NULL;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
)
{
arg1_idx = 1;
arg2 = arg1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
)
{
arg1_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ByteTensor* [ByteTensor] ByteTensor", type_buf);
}
lua_pushvalue(L, arg1_idx);
THByteTensor_cfmod(arg1,arg2,arg3);
return 1;
}

static int m_torch_ByteTensor_addcmul(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
unsigned char arg3 = 1;
THByteTensor *arg4 = NULL;
THByteTensor *arg5 = NULL;
if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg4 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& (arg5 = luaT_toudata(L, 3, "torch.ByteTensor"))
)
{
arg1_idx = 1;
arg2 = arg1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& (arg4 = luaT_toudata(L, 3, "torch.ByteTensor"))
&& (arg5 = luaT_toudata(L, 4, "torch.ByteTensor"))
)
{
arg1_idx = 1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
&& (arg4 = luaT_toudata(L, 3, "torch.ByteTensor"))
&& (arg5 = luaT_toudata(L, 4, "torch.ByteTensor"))
)
{
arg1_idx = 1;
arg3 = (unsigned char)lua_tonumber(L, 2);
arg2 = arg1;
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
&& (arg4 = luaT_toudata(L, 4, "torch.ByteTensor"))
&& (arg5 = luaT_toudata(L, 5, "torch.ByteTensor"))
)
{
arg1_idx = 1;
arg3 = (unsigned char)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ByteTensor* [ByteTensor] [unsigned char] ByteTensor ByteTensor", type_buf);
}
lua_pushvalue(L, arg1_idx);
THByteTensor_addcmul(arg1,arg2,arg3,arg4,arg5);
return 1;
}

static int m_torch_ByteTensor_addcdiv(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
unsigned char arg3 = 1;
THByteTensor *arg4 = NULL;
THByteTensor *arg5 = NULL;
if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg4 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& (arg5 = luaT_toudata(L, 3, "torch.ByteTensor"))
)
{
arg1_idx = 1;
arg2 = arg1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& (arg4 = luaT_toudata(L, 3, "torch.ByteTensor"))
&& (arg5 = luaT_toudata(L, 4, "torch.ByteTensor"))
)
{
arg1_idx = 1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
&& (arg4 = luaT_toudata(L, 3, "torch.ByteTensor"))
&& (arg5 = luaT_toudata(L, 4, "torch.ByteTensor"))
)
{
arg1_idx = 1;
arg3 = (unsigned char)lua_tonumber(L, 2);
arg2 = arg1;
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
&& (arg4 = luaT_toudata(L, 4, "torch.ByteTensor"))
&& (arg5 = luaT_toudata(L, 5, "torch.ByteTensor"))
)
{
arg1_idx = 1;
arg3 = (unsigned char)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ByteTensor* [ByteTensor] [unsigned char] ByteTensor ByteTensor", type_buf);
}
lua_pushvalue(L, arg1_idx);
THByteTensor_addcdiv(arg1,arg2,arg3,arg4,arg5);
return 1;
}

static int m_torch_ByteTensor_mv(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
unsigned char arg2 = 0;
THByteTensor *arg3 = NULL;
unsigned char arg4 = 1;
THByteTensor *arg5 = NULL;
THByteTensor *arg6 = NULL;
if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg6->nDimension == 1)
)
{
arg1_idx = 1;
arg3 = arg1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ByteTensor* ByteTensor~2D ByteTensor~1D", type_buf);
}
THByteTensor_zero(arg1);
lua_pushvalue(L, arg1_idx);
THByteTensor_addmv(arg1,arg2,arg3,arg4,arg5,arg6);
return 1;
}

static int m_torch_ByteTensor_mm(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
unsigned char arg2 = 0;
THByteTensor *arg3 = NULL;
unsigned char arg4 = 1;
THByteTensor *arg5 = NULL;
THByteTensor *arg6 = NULL;
if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg6->nDimension == 2)
)
{
arg1_idx = 1;
arg3 = arg1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ByteTensor* ByteTensor~2D ByteTensor~2D", type_buf);
}
THByteTensor_zero(arg1);
lua_pushvalue(L, arg1_idx);
THByteTensor_addmm(arg1,arg2,arg3,arg4,arg5,arg6);
return 1;
}

static int m_torch_ByteTensor_bmm(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
unsigned char arg2 = 0;
THByteTensor *arg3 = NULL;
unsigned char arg4 = 1;
THByteTensor *arg5 = NULL;
THByteTensor *arg6 = NULL;
if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg5->nDimension == 3)
&& (arg6 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg6->nDimension == 3)
)
{
arg1_idx = 1;
arg3 = arg1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ByteTensor* ByteTensor~3D ByteTensor~3D", type_buf);
}
THByteTensor_zero(arg1);
lua_pushvalue(L, arg1_idx);
THByteTensor_baddbmm(arg1,arg2,arg3,arg4,arg5,arg6);
return 1;
}

static int m_torch_ByteTensor_ger(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
unsigned char arg2 = 1;
THByteTensor *arg3 = NULL;
unsigned char arg4 = 1;
THByteTensor *arg5 = NULL;
THByteTensor *arg6 = NULL;
if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg5->nDimension == 1)
&& (arg6 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg6->nDimension == 1)
)
{
arg1_idx = 1;
arg3 = arg1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ByteTensor* ByteTensor~1D ByteTensor~1D", type_buf);
}
THByteTensor_zero(arg1);
lua_pushvalue(L, arg1_idx);
THByteTensor_addr(arg1,arg2,arg3,arg4,arg5,arg6);
return 1;
}

static int m_torch_ByteTensor_addmv(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
unsigned char arg2 = 1;
THByteTensor *arg3 = NULL;
unsigned char arg4 = 1;
THByteTensor *arg5 = NULL;
THByteTensor *arg6 = NULL;
THByteTensor *arg7 = NULL;
int arg7_idx = 0;
unsigned char arg8 = 0;
THByteTensor *arg9 = NULL;
unsigned char arg10 = 0;
THByteTensor *arg11 = NULL;
THByteTensor *arg12 = NULL;
if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg1->nDimension == 1)
&& (arg5 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg6->nDimension == 1)
)
{
argset = 1;
arg1_idx = 1;
arg3 = arg1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg1->nDimension == 1)
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg3->nDimension == 1)
&& (arg5 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 4, "torch.ByteTensor")) && (arg6->nDimension == 1)
)
{
argset = 1;
arg1_idx = 1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg1->nDimension == 1)
&& lua_isnumber(L, 2)
&& (arg5 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 4, "torch.ByteTensor")) && (arg6->nDimension == 1)
)
{
argset = 1;
arg1_idx = 1;
arg4 = (unsigned char)lua_tonumber(L, 2);
arg3 = arg1;
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg1->nDimension == 1)
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg3->nDimension == 1)
&& lua_isnumber(L, 3)
&& (arg5 = luaT_toudata(L, 4, "torch.ByteTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 5, "torch.ByteTensor")) && (arg6->nDimension == 1)
)
{
argset = 1;
arg1_idx = 1;
arg4 = (unsigned char)lua_tonumber(L, 3);
}
else if(narg == 5
&& (arg7 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg7->nDimension == 1)
&& lua_isnumber(L, 2)
&& lua_isnumber(L, 3)
&& (arg11 = luaT_toudata(L, 4, "torch.ByteTensor")) && (arg11->nDimension == 2)
&& (arg12 = luaT_toudata(L, 5, "torch.ByteTensor")) && (arg12->nDimension == 1)
)
{
argset = 2;
arg7_idx = 1;
arg8 = (unsigned char)lua_tonumber(L, 2);
arg10 = (unsigned char)lua_tonumber(L, 3);
arg9 = arg7;
}
else if(narg == 6
&& (arg7 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg7->nDimension == 1)
&& lua_isnumber(L, 2)
&& (arg9 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg9->nDimension == 1)
&& lua_isnumber(L, 4)
&& (arg11 = luaT_toudata(L, 5, "torch.ByteTensor")) && (arg11->nDimension == 2)
&& (arg12 = luaT_toudata(L, 6, "torch.ByteTensor")) && (arg12->nDimension == 1)
)
{
argset = 2;
arg7_idx = 1;
arg8 = (unsigned char)lua_tonumber(L, 2);
arg10 = (unsigned char)lua_tonumber(L, 4);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ByteTensor~1D* [ByteTensor~1D] [unsigned char] ByteTensor~2D ByteTensor~1D | *ByteTensor~1D* unsigned char [ByteTensor~1D] unsigned char ByteTensor~2D ByteTensor~1D", type_buf);
}
if(argset == 1)
{
lua_pushvalue(L, arg1_idx);
THByteTensor_addmv(arg1,arg2,arg3,arg4,arg5,arg6);
return 1;
}
else if(argset == 2)
{
lua_pushvalue(L, arg7_idx);
THByteTensor_addmv(arg7,arg8,arg9,arg10,arg11,arg12);
return 1;
}
return 0;
}

static int m_torch_ByteTensor_addmm(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
unsigned char arg2 = 1;
THByteTensor *arg3 = NULL;
unsigned char arg4 = 1;
THByteTensor *arg5 = NULL;
THByteTensor *arg6 = NULL;
THByteTensor *arg7 = NULL;
int arg7_idx = 0;
unsigned char arg8 = 0;
THByteTensor *arg9 = NULL;
unsigned char arg10 = 0;
THByteTensor *arg11 = NULL;
THByteTensor *arg12 = NULL;
if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg1->nDimension == 2)
&& (arg5 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg6->nDimension == 2)
)
{
argset = 1;
arg1_idx = 1;
arg3 = arg1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg1->nDimension == 2)
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg3->nDimension == 2)
&& (arg5 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 4, "torch.ByteTensor")) && (arg6->nDimension == 2)
)
{
argset = 1;
arg1_idx = 1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg1->nDimension == 2)
&& lua_isnumber(L, 2)
&& (arg5 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 4, "torch.ByteTensor")) && (arg6->nDimension == 2)
)
{
argset = 1;
arg1_idx = 1;
arg4 = (unsigned char)lua_tonumber(L, 2);
arg3 = arg1;
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg1->nDimension == 2)
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg3->nDimension == 2)
&& lua_isnumber(L, 3)
&& (arg5 = luaT_toudata(L, 4, "torch.ByteTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 5, "torch.ByteTensor")) && (arg6->nDimension == 2)
)
{
argset = 1;
arg1_idx = 1;
arg4 = (unsigned char)lua_tonumber(L, 3);
}
else if(narg == 5
&& (arg7 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg7->nDimension == 2)
&& lua_isnumber(L, 2)
&& lua_isnumber(L, 3)
&& (arg11 = luaT_toudata(L, 4, "torch.ByteTensor")) && (arg11->nDimension == 2)
&& (arg12 = luaT_toudata(L, 5, "torch.ByteTensor")) && (arg12->nDimension == 2)
)
{
argset = 2;
arg7_idx = 1;
arg8 = (unsigned char)lua_tonumber(L, 2);
arg10 = (unsigned char)lua_tonumber(L, 3);
arg9 = arg7;
}
else if(narg == 6
&& (arg7 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg7->nDimension == 2)
&& lua_isnumber(L, 2)
&& (arg9 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg9->nDimension == 2)
&& lua_isnumber(L, 4)
&& (arg11 = luaT_toudata(L, 5, "torch.ByteTensor")) && (arg11->nDimension == 2)
&& (arg12 = luaT_toudata(L, 6, "torch.ByteTensor")) && (arg12->nDimension == 2)
)
{
argset = 2;
arg7_idx = 1;
arg8 = (unsigned char)lua_tonumber(L, 2);
arg10 = (unsigned char)lua_tonumber(L, 4);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ByteTensor~2D* [ByteTensor~2D] [unsigned char] ByteTensor~2D ByteTensor~2D | *ByteTensor~2D* unsigned char [ByteTensor~2D] unsigned char ByteTensor~2D ByteTensor~2D", type_buf);
}
if(argset == 1)
{
lua_pushvalue(L, arg1_idx);
THByteTensor_addmm(arg1,arg2,arg3,arg4,arg5,arg6);
return 1;
}
else if(argset == 2)
{
lua_pushvalue(L, arg7_idx);
THByteTensor_addmm(arg7,arg8,arg9,arg10,arg11,arg12);
return 1;
}
return 0;
}

static int m_torch_ByteTensor_addr(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
unsigned char arg2 = 1;
THByteTensor *arg3 = NULL;
unsigned char arg4 = 1;
THByteTensor *arg5 = NULL;
THByteTensor *arg6 = NULL;
THByteTensor *arg7 = NULL;
int arg7_idx = 0;
unsigned char arg8 = 0;
THByteTensor *arg9 = NULL;
unsigned char arg10 = 0;
THByteTensor *arg11 = NULL;
THByteTensor *arg12 = NULL;
if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg1->nDimension == 2)
&& (arg5 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg5->nDimension == 1)
&& (arg6 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg6->nDimension == 1)
)
{
argset = 1;
arg1_idx = 1;
arg3 = arg1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg1->nDimension == 2)
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg3->nDimension == 2)
&& (arg5 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg5->nDimension == 1)
&& (arg6 = luaT_toudata(L, 4, "torch.ByteTensor")) && (arg6->nDimension == 1)
)
{
argset = 1;
arg1_idx = 1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg1->nDimension == 2)
&& lua_isnumber(L, 2)
&& (arg5 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg5->nDimension == 1)
&& (arg6 = luaT_toudata(L, 4, "torch.ByteTensor")) && (arg6->nDimension == 1)
)
{
argset = 1;
arg1_idx = 1;
arg4 = (unsigned char)lua_tonumber(L, 2);
arg3 = arg1;
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg1->nDimension == 2)
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg3->nDimension == 2)
&& lua_isnumber(L, 3)
&& (arg5 = luaT_toudata(L, 4, "torch.ByteTensor")) && (arg5->nDimension == 1)
&& (arg6 = luaT_toudata(L, 5, "torch.ByteTensor")) && (arg6->nDimension == 1)
)
{
argset = 1;
arg1_idx = 1;
arg4 = (unsigned char)lua_tonumber(L, 3);
}
else if(narg == 5
&& (arg7 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg7->nDimension == 2)
&& lua_isnumber(L, 2)
&& lua_isnumber(L, 3)
&& (arg11 = luaT_toudata(L, 4, "torch.ByteTensor")) && (arg11->nDimension == 1)
&& (arg12 = luaT_toudata(L, 5, "torch.ByteTensor")) && (arg12->nDimension == 1)
)
{
argset = 2;
arg7_idx = 1;
arg8 = (unsigned char)lua_tonumber(L, 2);
arg10 = (unsigned char)lua_tonumber(L, 3);
arg9 = arg7;
}
else if(narg == 6
&& (arg7 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg7->nDimension == 2)
&& lua_isnumber(L, 2)
&& (arg9 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg9->nDimension == 2)
&& lua_isnumber(L, 4)
&& (arg11 = luaT_toudata(L, 5, "torch.ByteTensor")) && (arg11->nDimension == 1)
&& (arg12 = luaT_toudata(L, 6, "torch.ByteTensor")) && (arg12->nDimension == 1)
)
{
argset = 2;
arg7_idx = 1;
arg8 = (unsigned char)lua_tonumber(L, 2);
arg10 = (unsigned char)lua_tonumber(L, 4);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ByteTensor~2D* [ByteTensor~2D] [unsigned char] ByteTensor~1D ByteTensor~1D | *ByteTensor~2D* unsigned char [ByteTensor~2D] unsigned char ByteTensor~1D ByteTensor~1D", type_buf);
}
if(argset == 1)
{
lua_pushvalue(L, arg1_idx);
THByteTensor_addr(arg1,arg2,arg3,arg4,arg5,arg6);
return 1;
}
else if(argset == 2)
{
lua_pushvalue(L, arg7_idx);
THByteTensor_addr(arg7,arg8,arg9,arg10,arg11,arg12);
return 1;
}
return 0;
}

static int m_torch_ByteTensor_addbmm(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
unsigned char arg2 = 1;
THByteTensor *arg3 = NULL;
unsigned char arg4 = 1;
THByteTensor *arg5 = NULL;
THByteTensor *arg6 = NULL;
THByteTensor *arg7 = NULL;
int arg7_idx = 0;
unsigned char arg8 = 0;
THByteTensor *arg9 = NULL;
unsigned char arg10 = 0;
THByteTensor *arg11 = NULL;
THByteTensor *arg12 = NULL;
if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg1->nDimension == 2)
&& (arg5 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg5->nDimension == 3)
&& (arg6 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg6->nDimension == 3)
)
{
argset = 1;
arg1_idx = 1;
arg3 = arg1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg1->nDimension == 2)
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg3->nDimension == 2)
&& (arg5 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg5->nDimension == 3)
&& (arg6 = luaT_toudata(L, 4, "torch.ByteTensor")) && (arg6->nDimension == 3)
)
{
argset = 1;
arg1_idx = 1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg1->nDimension == 2)
&& lua_isnumber(L, 2)
&& (arg5 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg5->nDimension == 3)
&& (arg6 = luaT_toudata(L, 4, "torch.ByteTensor")) && (arg6->nDimension == 3)
)
{
argset = 1;
arg1_idx = 1;
arg4 = (unsigned char)lua_tonumber(L, 2);
arg3 = arg1;
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg1->nDimension == 2)
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg3->nDimension == 2)
&& lua_isnumber(L, 3)
&& (arg5 = luaT_toudata(L, 4, "torch.ByteTensor")) && (arg5->nDimension == 3)
&& (arg6 = luaT_toudata(L, 5, "torch.ByteTensor")) && (arg6->nDimension == 3)
)
{
argset = 1;
arg1_idx = 1;
arg4 = (unsigned char)lua_tonumber(L, 3);
}
else if(narg == 5
&& (arg7 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg7->nDimension == 2)
&& lua_isnumber(L, 2)
&& lua_isnumber(L, 3)
&& (arg11 = luaT_toudata(L, 4, "torch.ByteTensor")) && (arg11->nDimension == 3)
&& (arg12 = luaT_toudata(L, 5, "torch.ByteTensor")) && (arg12->nDimension == 3)
)
{
argset = 2;
arg7_idx = 1;
arg8 = (unsigned char)lua_tonumber(L, 2);
arg10 = (unsigned char)lua_tonumber(L, 3);
arg9 = arg7;
}
else if(narg == 6
&& (arg7 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg7->nDimension == 2)
&& lua_isnumber(L, 2)
&& (arg9 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg9->nDimension == 2)
&& lua_isnumber(L, 4)
&& (arg11 = luaT_toudata(L, 5, "torch.ByteTensor")) && (arg11->nDimension == 3)
&& (arg12 = luaT_toudata(L, 6, "torch.ByteTensor")) && (arg12->nDimension == 3)
)
{
argset = 2;
arg7_idx = 1;
arg8 = (unsigned char)lua_tonumber(L, 2);
arg10 = (unsigned char)lua_tonumber(L, 4);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ByteTensor~2D* [ByteTensor~2D] [unsigned char] ByteTensor~3D ByteTensor~3D | *ByteTensor~2D* unsigned char [ByteTensor~2D] unsigned char ByteTensor~3D ByteTensor~3D", type_buf);
}
if(argset == 1)
{
lua_pushvalue(L, arg1_idx);
THByteTensor_addbmm(arg1,arg2,arg3,arg4,arg5,arg6);
return 1;
}
else if(argset == 2)
{
lua_pushvalue(L, arg7_idx);
THByteTensor_addbmm(arg7,arg8,arg9,arg10,arg11,arg12);
return 1;
}
return 0;
}

static int m_torch_ByteTensor_baddbmm(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
unsigned char arg2 = 1;
THByteTensor *arg3 = NULL;
unsigned char arg4 = 1;
THByteTensor *arg5 = NULL;
THByteTensor *arg6 = NULL;
THByteTensor *arg7 = NULL;
int arg7_idx = 0;
unsigned char arg8 = 0;
THByteTensor *arg9 = NULL;
unsigned char arg10 = 0;
THByteTensor *arg11 = NULL;
THByteTensor *arg12 = NULL;
if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg1->nDimension == 3)
&& (arg5 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg5->nDimension == 3)
&& (arg6 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg6->nDimension == 3)
)
{
argset = 1;
arg1_idx = 1;
arg3 = arg1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg1->nDimension == 3)
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg3->nDimension == 3)
&& (arg5 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg5->nDimension == 3)
&& (arg6 = luaT_toudata(L, 4, "torch.ByteTensor")) && (arg6->nDimension == 3)
)
{
argset = 1;
arg1_idx = 1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg1->nDimension == 3)
&& lua_isnumber(L, 2)
&& (arg5 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg5->nDimension == 3)
&& (arg6 = luaT_toudata(L, 4, "torch.ByteTensor")) && (arg6->nDimension == 3)
)
{
argset = 1;
arg1_idx = 1;
arg4 = (unsigned char)lua_tonumber(L, 2);
arg3 = arg1;
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg1->nDimension == 3)
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg3->nDimension == 3)
&& lua_isnumber(L, 3)
&& (arg5 = luaT_toudata(L, 4, "torch.ByteTensor")) && (arg5->nDimension == 3)
&& (arg6 = luaT_toudata(L, 5, "torch.ByteTensor")) && (arg6->nDimension == 3)
)
{
argset = 1;
arg1_idx = 1;
arg4 = (unsigned char)lua_tonumber(L, 3);
}
else if(narg == 5
&& (arg7 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg7->nDimension == 3)
&& lua_isnumber(L, 2)
&& lua_isnumber(L, 3)
&& (arg11 = luaT_toudata(L, 4, "torch.ByteTensor")) && (arg11->nDimension == 3)
&& (arg12 = luaT_toudata(L, 5, "torch.ByteTensor")) && (arg12->nDimension == 3)
)
{
argset = 2;
arg7_idx = 1;
arg8 = (unsigned char)lua_tonumber(L, 2);
arg10 = (unsigned char)lua_tonumber(L, 3);
arg9 = arg7;
}
else if(narg == 6
&& (arg7 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg7->nDimension == 3)
&& lua_isnumber(L, 2)
&& (arg9 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg9->nDimension == 3)
&& lua_isnumber(L, 4)
&& (arg11 = luaT_toudata(L, 5, "torch.ByteTensor")) && (arg11->nDimension == 3)
&& (arg12 = luaT_toudata(L, 6, "torch.ByteTensor")) && (arg12->nDimension == 3)
)
{
argset = 2;
arg7_idx = 1;
arg8 = (unsigned char)lua_tonumber(L, 2);
arg10 = (unsigned char)lua_tonumber(L, 4);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ByteTensor~3D* [ByteTensor~3D] [unsigned char] ByteTensor~3D ByteTensor~3D | *ByteTensor~3D* unsigned char [ByteTensor~3D] unsigned char ByteTensor~3D ByteTensor~3D", type_buf);
}
if(argset == 1)
{
lua_pushvalue(L, arg1_idx);
THByteTensor_baddbmm(arg1,arg2,arg3,arg4,arg5,arg6);
return 1;
}
else if(argset == 2)
{
lua_pushvalue(L, arg7_idx);
THByteTensor_baddbmm(arg7,arg8,arg9,arg10,arg11,arg12);
return 1;
}
return 0;
}

static int m_torch_ByteTensor_numel(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
ptrdiff_t arg2 = 0;
if(narg == 1
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
)
{
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: ByteTensor", type_buf);
}
arg2 = THByteTensor_numel(arg1);
lua_pushnumber(L, (lua_Number)arg2);
return 1;
}

static int m_torch_ByteTensor_cumsum(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
long arg3 = 0;
if(narg == 1
&& (arg2 = luaT_toudata(L, 1, "torch.ByteTensor"))
)
{
arg1 = THByteTensor_new();
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
)
{
arg1_idx = 1;
}
else if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
)
{
arg3 = (long)lua_tonumber(L, 2)-1;
arg1 = THByteTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (long)lua_tonumber(L, 3)-1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] ByteTensor [index]", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THByteTensor_cumsum(arg1,arg2,arg3);
return 1;
}

static int m_torch_ByteTensor_cumprod(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
long arg3 = 0;
if(narg == 1
&& (arg2 = luaT_toudata(L, 1, "torch.ByteTensor"))
)
{
arg1 = THByteTensor_new();
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
)
{
arg1_idx = 1;
}
else if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
)
{
arg3 = (long)lua_tonumber(L, 2)-1;
arg1 = THByteTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (long)lua_tonumber(L, 3)-1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] ByteTensor [index]", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THByteTensor_cumprod(arg1,arg2,arg3);
return 1;
}

static int m_torch_ByteTensor_sum(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THByteTensor *arg1 = NULL;
long arg2 = 0;
THByteTensor *arg3 = NULL;
int arg3_idx = 0;
THByteTensor *arg4 = NULL;
long arg5 = 0;
int arg6 = 1;
if(narg == 1
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
)
{
argset = 1;
}
else if(narg == 2
&& (arg4 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 2;
arg5 = (long)lua_tonumber(L, 2)-1;
arg3 = THByteTensor_new();
}
else if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg4 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg3_idx = 1;
arg5 = (long)lua_tonumber(L, 3)-1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: ByteTensor | [*ByteTensor*] ByteTensor index", type_buf);
}
if(argset == 1)
{
arg2 = THByteTensor_sumall(arg1);
lua_pushnumber(L, (lua_Number)arg2);
return 1;
}
else if(argset == 2)
{
if(arg3_idx)
lua_pushvalue(L, arg3_idx);
else
luaT_pushudata(L, arg3, "torch.ByteTensor");
THByteTensor_sum(arg3,arg4,arg5,arg6);
return 1;
}
return 0;
}

static int m_torch_ByteTensor_prod(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THByteTensor *arg1 = NULL;
long arg2 = 0;
THByteTensor *arg3 = NULL;
int arg3_idx = 0;
THByteTensor *arg4 = NULL;
long arg5 = 0;
int arg6 = 1;
if(narg == 1
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
)
{
argset = 1;
}
else if(narg == 2
&& (arg4 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 2;
arg5 = (long)lua_tonumber(L, 2)-1;
arg3 = THByteTensor_new();
}
else if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg4 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg3_idx = 1;
arg5 = (long)lua_tonumber(L, 3)-1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: ByteTensor | [*ByteTensor*] ByteTensor index", type_buf);
}
if(argset == 1)
{
arg2 = THByteTensor_prodall(arg1);
lua_pushnumber(L, (lua_Number)arg2);
return 1;
}
else if(argset == 2)
{
if(arg3_idx)
lua_pushvalue(L, arg3_idx);
else
luaT_pushudata(L, arg3, "torch.ByteTensor");
THByteTensor_prod(arg3,arg4,arg5,arg6);
return 1;
}
return 0;
}

static int m_torch_ByteTensor_min(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THByteTensor *arg1 = NULL;
unsigned char arg2 = 0;
THByteTensor *arg3 = NULL;
int arg3_idx = 0;
THLongTensor *arg4 = NULL;
int arg4_idx = 0;
THByteTensor *arg5 = NULL;
long arg6 = 0;
int arg7 = 1;
if(narg == 1
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
)
{
argset = 1;
}
else if(narg == 2
&& (arg5 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 2;
arg6 = (long)lua_tonumber(L, 2)-1;
arg3 = THByteTensor_new();
arg4 = THLongTensor_new();
}
else if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg3_idx = 1;
arg6 = (long)lua_tonumber(L, 3)-1;
arg4 = THLongTensor_new();
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg4_idx = 1;
arg6 = (long)lua_tonumber(L, 3)-1;
arg3 = THByteTensor_new();
}
else if(narg == 4
&& (arg3 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg4 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg5 = luaT_toudata(L, 3, "torch.ByteTensor"))
&& lua_isnumber(L, 4)
)
{
argset = 2;
arg3_idx = 1;
arg4_idx = 2;
arg6 = (long)lua_tonumber(L, 4)-1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: ByteTensor | [*ByteTensor*] [*LongTensor*] ByteTensor index", type_buf);
}
if(argset == 1)
{
arg2 = THByteTensor_minall(arg1);
lua_pushnumber(L, (lua_Number)arg2);
return 1;
}
else if(argset == 2)
{
if(arg3_idx)
lua_pushvalue(L, arg3_idx);
else
luaT_pushudata(L, arg3, "torch.ByteTensor");
if(arg4_idx)
lua_pushvalue(L, arg4_idx);
else
luaT_pushudata(L, arg4, "torch.LongTensor");
THByteTensor_min(arg3,arg4,arg5,arg6,arg7);
THLongTensor_add(arg4, arg4, 1);
return 2;
}
return 0;
}

static int m_torch_ByteTensor_max(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THByteTensor *arg1 = NULL;
unsigned char arg2 = 0;
THByteTensor *arg3 = NULL;
int arg3_idx = 0;
THLongTensor *arg4 = NULL;
int arg4_idx = 0;
THByteTensor *arg5 = NULL;
long arg6 = 0;
int arg7 = 1;
if(narg == 1
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
)
{
argset = 1;
}
else if(narg == 2
&& (arg5 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 2;
arg6 = (long)lua_tonumber(L, 2)-1;
arg3 = THByteTensor_new();
arg4 = THLongTensor_new();
}
else if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg3_idx = 1;
arg6 = (long)lua_tonumber(L, 3)-1;
arg4 = THLongTensor_new();
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg4_idx = 1;
arg6 = (long)lua_tonumber(L, 3)-1;
arg3 = THByteTensor_new();
}
else if(narg == 4
&& (arg3 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg4 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg5 = luaT_toudata(L, 3, "torch.ByteTensor"))
&& lua_isnumber(L, 4)
)
{
argset = 2;
arg3_idx = 1;
arg4_idx = 2;
arg6 = (long)lua_tonumber(L, 4)-1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: ByteTensor | [*ByteTensor*] [*LongTensor*] ByteTensor index", type_buf);
}
if(argset == 1)
{
arg2 = THByteTensor_maxall(arg1);
lua_pushnumber(L, (lua_Number)arg2);
return 1;
}
else if(argset == 2)
{
if(arg3_idx)
lua_pushvalue(L, arg3_idx);
else
luaT_pushudata(L, arg3, "torch.ByteTensor");
if(arg4_idx)
lua_pushvalue(L, arg4_idx);
else
luaT_pushudata(L, arg4, "torch.LongTensor");
THByteTensor_max(arg3,arg4,arg5,arg6,arg7);
THLongTensor_add(arg4, arg4, 1);
return 2;
}
return 0;
}

static int m_torch_ByteTensor_cmin(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
THByteTensor *arg3 = NULL;
THByteTensor *arg4 = NULL;
int arg4_idx = 0;
THByteTensor *arg5 = NULL;
unsigned char arg6 = 0;
if(narg == 1
&& (arg3 = luaT_toudata(L, 1, "torch.ByteTensor"))
)
{
argset = 1;
arg1 = THByteTensor_new();
arg2 = arg1;
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
)
{
argset = 1;
arg1_idx = 1;
arg2 = arg1;
}
else if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
)
{
argset = 1;
arg1 = THByteTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
)
{
argset = 1;
arg1_idx = 1;
}
else if(narg == 1
&& lua_isnumber(L, 1)
)
{
argset = 2;
arg6 = (unsigned char)lua_tonumber(L, 1);
arg4 = THByteTensor_new();
arg5 = arg4;
}
else if(narg == 2
&& (arg4 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 2;
arg4_idx = 1;
arg6 = (unsigned char)lua_tonumber(L, 2);
arg5 = arg4;
}
else if(narg == 2
&& (arg5 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 2;
arg6 = (unsigned char)lua_tonumber(L, 2);
arg4 = THByteTensor_new();
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg4_idx = 1;
arg6 = (unsigned char)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] [ByteTensor] ByteTensor | [*ByteTensor*] [ByteTensor] unsigned char", type_buf);
}
if(argset == 1)
{
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THByteTensor_cmin(arg1,arg2,arg3);
return 1;
}
else if(argset == 2)
{
if(arg4_idx)
lua_pushvalue(L, arg4_idx);
else
luaT_pushudata(L, arg4, "torch.ByteTensor");
THByteTensor_cminValue(arg4,arg5,arg6);
return 1;
}
return 0;
}

static int m_torch_ByteTensor_cmax(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
THByteTensor *arg3 = NULL;
THByteTensor *arg4 = NULL;
int arg4_idx = 0;
THByteTensor *arg5 = NULL;
unsigned char arg6 = 0;
if(narg == 1
&& (arg3 = luaT_toudata(L, 1, "torch.ByteTensor"))
)
{
argset = 1;
arg1 = THByteTensor_new();
arg2 = arg1;
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
)
{
argset = 1;
arg1_idx = 1;
arg2 = arg1;
}
else if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
)
{
argset = 1;
arg1 = THByteTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
)
{
argset = 1;
arg1_idx = 1;
}
else if(narg == 1
&& lua_isnumber(L, 1)
)
{
argset = 2;
arg6 = (unsigned char)lua_tonumber(L, 1);
arg4 = THByteTensor_new();
arg5 = arg4;
}
else if(narg == 2
&& (arg4 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 2;
arg4_idx = 1;
arg6 = (unsigned char)lua_tonumber(L, 2);
arg5 = arg4;
}
else if(narg == 2
&& (arg5 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 2;
arg6 = (unsigned char)lua_tonumber(L, 2);
arg4 = THByteTensor_new();
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg4_idx = 1;
arg6 = (unsigned char)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] [ByteTensor] ByteTensor | [*ByteTensor*] [ByteTensor] unsigned char", type_buf);
}
if(argset == 1)
{
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THByteTensor_cmax(arg1,arg2,arg3);
return 1;
}
else if(argset == 2)
{
if(arg4_idx)
lua_pushvalue(L, arg4_idx);
else
luaT_pushudata(L, arg4, "torch.ByteTensor");
THByteTensor_cmaxValue(arg4,arg5,arg6);
return 1;
}
return 0;
}

static int m_torch_ByteTensor_trace(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
long arg2 = 0;
if(narg == 1
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
)
{
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: ByteTensor", type_buf);
}
arg2 = THByteTensor_trace(arg1);
lua_pushnumber(L, (lua_Number)arg2);
return 1;
}

static int m_torch_ByteTensor_cross(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
THByteTensor *arg3 = NULL;
long arg4 = -1;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
)
{
arg1 = THByteTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
)
{
arg1_idx = 1;
}
else if(narg == 3
&& (arg2 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
arg4 = (long)lua_tonumber(L, 3)-1;
arg1 = THByteTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
&& lua_isnumber(L, 4)
)
{
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 4)-1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] ByteTensor ByteTensor [index]", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THByteTensor_cross(arg1,arg2,arg3,arg4);
return 1;
}

static int m_torch_ByteTensor_diag(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
long arg3 = 0;
if(narg == 1
&& (arg2 = luaT_toudata(L, 1, "torch.ByteTensor"))
)
{
arg1 = THByteTensor_new();
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
)
{
arg1_idx = 1;
}
else if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
)
{
arg3 = (long)lua_tonumber(L, 2);
arg1 = THByteTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (long)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] ByteTensor [long]", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THByteTensor_diag(arg1,arg2,arg3);
return 1;
}

static int m_torch_ByteTensor_eye(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
long arg2 = 0;
long arg3 = 0;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
)
{
arg1_idx = 1;
arg2 = (long)lua_tonumber(L, 2);
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg2 = (long)lua_tonumber(L, 2);
arg3 = (long)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ByteTensor* long [long]", type_buf);
}
lua_pushvalue(L, arg1_idx);
THByteTensor_eye(arg1,arg2,arg3);
return 1;
}

static int m_torch_ByteTensor_range(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
long arg2 = 0;
long arg3 = 0;
long arg4 = 1;
if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg2 = (long)lua_tonumber(L, 2);
arg3 = (long)lua_tonumber(L, 3);
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
&& lua_isnumber(L, 3)
&& lua_isnumber(L, 4)
)
{
arg1_idx = 1;
arg2 = (long)lua_tonumber(L, 2);
arg3 = (long)lua_tonumber(L, 3);
arg4 = (long)lua_tonumber(L, 4);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ByteTensor* long long [long]", type_buf);
}
lua_pushvalue(L, arg1_idx);
THByteTensor_range(arg1,arg2,arg3,arg4);
return 1;
}

static int m_torch_ByteTensor_randperm(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THGenerator *arg2 = NULL;
long arg3 = 0;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
)
{
arg1_idx = 1;
arg3 = (long)lua_tonumber(L, 2);
lua_getglobal(L,"torch");
arg2 = luaT_getfieldcheckudata(L, -1, "_gen", torch_Generator);
lua_pop(L, 2);
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, torch_Generator))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (long)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ByteTensor* [Generator] long", type_buf);
}
lua_pushvalue(L, arg1_idx);
THByteTensor_randperm(arg1,arg2,arg3);

THByteTensor_add(arg1, arg1, 1);
return 1;
}

static int m_torch_ByteTensor_sort(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THLongTensor *arg2 = NULL;
int arg2_idx = 0;
THByteTensor *arg3 = NULL;
long arg4 = 0;
int arg5 = 0;
if(narg == 1
&& (arg3 = luaT_toudata(L, 1, "torch.ByteTensor"))
)
{
arg1 = THByteTensor_new();
arg2 = THLongTensor_new();
arg4 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
)
{
arg1_idx = 1;
arg2 = THLongTensor_new();
arg4 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
)
{
arg2_idx = 1;
arg1 = THByteTensor_new();
arg4 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 2
&& (arg3 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
)
{
arg4 = (long)lua_tonumber(L, 2)-1;
arg1 = THByteTensor_new();
arg2 = THLongTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 3)-1;
arg2 = THLongTensor_new();
}
else if(narg == 3
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
arg2_idx = 1;
arg4 = (long)lua_tonumber(L, 3)-1;
arg1 = THByteTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
&& lua_isnumber(L, 4)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = (long)lua_tonumber(L, 4)-1;
}
else if(narg == 2
&& (arg3 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isboolean(L, 2)
)
{
arg5 = lua_toboolean(L, 2);
arg1 = THByteTensor_new();
arg2 = THLongTensor_new();
arg4 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isboolean(L, 3)
)
{
arg1_idx = 1;
arg5 = lua_toboolean(L, 3);
arg2 = THLongTensor_new();
arg4 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isboolean(L, 3)
)
{
arg2_idx = 1;
arg5 = lua_toboolean(L, 3);
arg1 = THByteTensor_new();
arg4 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
&& lua_isboolean(L, 4)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg5 = lua_toboolean(L, 4);
arg4 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
&& lua_isboolean(L, 3)
)
{
arg4 = (long)lua_tonumber(L, 2)-1;
arg5 = lua_toboolean(L, 3);
arg1 = THByteTensor_new();
arg2 = THLongTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
)
{
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 3)-1;
arg5 = lua_toboolean(L, 4);
arg2 = THLongTensor_new();
}
else if(narg == 4
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
)
{
arg2_idx = 1;
arg4 = (long)lua_tonumber(L, 3)-1;
arg5 = lua_toboolean(L, 4);
arg1 = THByteTensor_new();
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
&& lua_isnumber(L, 4)
&& lua_isboolean(L, 5)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = (long)lua_tonumber(L, 4)-1;
arg5 = lua_toboolean(L, 5);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] [*LongTensor*] ByteTensor [index] [boolean]", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
if(arg2_idx)
lua_pushvalue(L, arg2_idx);
else
luaT_pushudata(L, arg2, "torch.LongTensor");
THByteTensor_sort(arg1,arg2,arg3,arg4,arg5);
THLongTensor_add(arg2, arg2, 1);
return 2;
}

static int m_torch_ByteTensor_topk(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THLongTensor *arg2 = NULL;
int arg2_idx = 0;
THByteTensor *arg3 = NULL;
long arg4 = 1;
long arg5 = 0;
int arg6 = 0;
int arg7 = 0;
if(narg == 1
&& (arg3 = luaT_toudata(L, 1, "torch.ByteTensor"))
)
{
arg1 = THByteTensor_new();
arg2 = THLongTensor_new();
arg5 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
)
{
arg1_idx = 1;
arg2 = THLongTensor_new();
arg5 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
)
{
arg2_idx = 1;
arg1 = THByteTensor_new();
arg5 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
)
{
arg1_idx = 1;
arg2_idx = 2;
arg5 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 2
&& (arg3 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
)
{
arg4 = (long)lua_tonumber(L, 2);
arg1 = THByteTensor_new();
arg2 = THLongTensor_new();
arg5 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg2 = THLongTensor_new();
arg5 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
arg2_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg1 = THByteTensor_new();
arg5 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
&& lua_isnumber(L, 4)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = (long)lua_tonumber(L, 4);
arg5 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 2
&& (arg3 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
)
{
arg5 = (long)lua_tonumber(L, 2)-1;
arg1 = THByteTensor_new();
arg2 = THLongTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg5 = (long)lua_tonumber(L, 3)-1;
arg2 = THLongTensor_new();
}
else if(narg == 3
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
arg2_idx = 1;
arg5 = (long)lua_tonumber(L, 3)-1;
arg1 = THByteTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
&& lua_isnumber(L, 4)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg5 = (long)lua_tonumber(L, 4)-1;
}
else if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
&& lua_isnumber(L, 3)
)
{
arg4 = (long)lua_tonumber(L, 2);
arg5 = (long)lua_tonumber(L, 3)-1;
arg1 = THByteTensor_new();
arg2 = THLongTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
&& lua_isnumber(L, 4)
)
{
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg5 = (long)lua_tonumber(L, 4)-1;
arg2 = THLongTensor_new();
}
else if(narg == 4
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
&& lua_isnumber(L, 4)
)
{
arg2_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg5 = (long)lua_tonumber(L, 4)-1;
arg1 = THByteTensor_new();
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
&& lua_isnumber(L, 4)
&& lua_isnumber(L, 5)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = (long)lua_tonumber(L, 4);
arg5 = (long)lua_tonumber(L, 5)-1;
}
else if(narg == 2
&& (arg3 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isboolean(L, 2)
)
{
arg6 = lua_toboolean(L, 2);
arg1 = THByteTensor_new();
arg2 = THLongTensor_new();
arg5 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isboolean(L, 3)
)
{
arg1_idx = 1;
arg6 = lua_toboolean(L, 3);
arg2 = THLongTensor_new();
arg5 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isboolean(L, 3)
)
{
arg2_idx = 1;
arg6 = lua_toboolean(L, 3);
arg1 = THByteTensor_new();
arg5 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
&& lua_isboolean(L, 4)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg6 = lua_toboolean(L, 4);
arg5 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
&& lua_isboolean(L, 3)
)
{
arg4 = (long)lua_tonumber(L, 2);
arg6 = lua_toboolean(L, 3);
arg1 = THByteTensor_new();
arg2 = THLongTensor_new();
arg5 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
)
{
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg6 = lua_toboolean(L, 4);
arg2 = THLongTensor_new();
arg5 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 4
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
)
{
arg2_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg6 = lua_toboolean(L, 4);
arg1 = THByteTensor_new();
arg5 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
&& lua_isnumber(L, 4)
&& lua_isboolean(L, 5)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = (long)lua_tonumber(L, 4);
arg6 = lua_toboolean(L, 5);
arg5 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
&& lua_isboolean(L, 3)
)
{
arg5 = (long)lua_tonumber(L, 2)-1;
arg6 = lua_toboolean(L, 3);
arg1 = THByteTensor_new();
arg2 = THLongTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
)
{
arg1_idx = 1;
arg5 = (long)lua_tonumber(L, 3)-1;
arg6 = lua_toboolean(L, 4);
arg2 = THLongTensor_new();
}
else if(narg == 4
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
)
{
arg2_idx = 1;
arg5 = (long)lua_tonumber(L, 3)-1;
arg6 = lua_toboolean(L, 4);
arg1 = THByteTensor_new();
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
&& lua_isnumber(L, 4)
&& lua_isboolean(L, 5)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg5 = (long)lua_tonumber(L, 4)-1;
arg6 = lua_toboolean(L, 5);
}
else if(narg == 4
&& (arg3 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
)
{
arg4 = (long)lua_tonumber(L, 2);
arg5 = (long)lua_tonumber(L, 3)-1;
arg6 = lua_toboolean(L, 4);
arg1 = THByteTensor_new();
arg2 = THLongTensor_new();
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
&& lua_isnumber(L, 4)
&& lua_isboolean(L, 5)
)
{
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg5 = (long)lua_tonumber(L, 4)-1;
arg6 = lua_toboolean(L, 5);
arg2 = THLongTensor_new();
}
else if(narg == 5
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
&& lua_isnumber(L, 4)
&& lua_isboolean(L, 5)
)
{
arg2_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg5 = (long)lua_tonumber(L, 4)-1;
arg6 = lua_toboolean(L, 5);
arg1 = THByteTensor_new();
}
else if(narg == 6
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
&& lua_isnumber(L, 4)
&& lua_isnumber(L, 5)
&& lua_isboolean(L, 6)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = (long)lua_tonumber(L, 4);
arg5 = (long)lua_tonumber(L, 5)-1;
arg6 = lua_toboolean(L, 6);
}
else if(narg == 2
&& (arg3 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isboolean(L, 2)
)
{
arg7 = lua_toboolean(L, 2);
arg1 = THByteTensor_new();
arg2 = THLongTensor_new();
arg5 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isboolean(L, 3)
)
{
arg1_idx = 1;
arg7 = lua_toboolean(L, 3);
arg2 = THLongTensor_new();
arg5 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isboolean(L, 3)
)
{
arg2_idx = 1;
arg7 = lua_toboolean(L, 3);
arg1 = THByteTensor_new();
arg5 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
&& lua_isboolean(L, 4)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg7 = lua_toboolean(L, 4);
arg5 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
&& lua_isboolean(L, 3)
)
{
arg4 = (long)lua_tonumber(L, 2);
arg7 = lua_toboolean(L, 3);
arg1 = THByteTensor_new();
arg2 = THLongTensor_new();
arg5 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
)
{
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg7 = lua_toboolean(L, 4);
arg2 = THLongTensor_new();
arg5 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 4
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
)
{
arg2_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg7 = lua_toboolean(L, 4);
arg1 = THByteTensor_new();
arg5 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
&& lua_isnumber(L, 4)
&& lua_isboolean(L, 5)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = (long)lua_tonumber(L, 4);
arg7 = lua_toboolean(L, 5);
arg5 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
&& lua_isboolean(L, 3)
)
{
arg5 = (long)lua_tonumber(L, 2)-1;
arg7 = lua_toboolean(L, 3);
arg1 = THByteTensor_new();
arg2 = THLongTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
)
{
arg1_idx = 1;
arg5 = (long)lua_tonumber(L, 3)-1;
arg7 = lua_toboolean(L, 4);
arg2 = THLongTensor_new();
}
else if(narg == 4
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
)
{
arg2_idx = 1;
arg5 = (long)lua_tonumber(L, 3)-1;
arg7 = lua_toboolean(L, 4);
arg1 = THByteTensor_new();
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
&& lua_isnumber(L, 4)
&& lua_isboolean(L, 5)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg5 = (long)lua_tonumber(L, 4)-1;
arg7 = lua_toboolean(L, 5);
}
else if(narg == 4
&& (arg3 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
)
{
arg4 = (long)lua_tonumber(L, 2);
arg5 = (long)lua_tonumber(L, 3)-1;
arg7 = lua_toboolean(L, 4);
arg1 = THByteTensor_new();
arg2 = THLongTensor_new();
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
&& lua_isnumber(L, 4)
&& lua_isboolean(L, 5)
)
{
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg5 = (long)lua_tonumber(L, 4)-1;
arg7 = lua_toboolean(L, 5);
arg2 = THLongTensor_new();
}
else if(narg == 5
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
&& lua_isnumber(L, 4)
&& lua_isboolean(L, 5)
)
{
arg2_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg5 = (long)lua_tonumber(L, 4)-1;
arg7 = lua_toboolean(L, 5);
arg1 = THByteTensor_new();
}
else if(narg == 6
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
&& lua_isnumber(L, 4)
&& lua_isnumber(L, 5)
&& lua_isboolean(L, 6)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = (long)lua_tonumber(L, 4);
arg5 = (long)lua_tonumber(L, 5)-1;
arg7 = lua_toboolean(L, 6);
}
else if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isboolean(L, 2)
&& lua_isboolean(L, 3)
)
{
arg6 = lua_toboolean(L, 2);
arg7 = lua_toboolean(L, 3);
arg1 = THByteTensor_new();
arg2 = THLongTensor_new();
arg5 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isboolean(L, 3)
&& lua_isboolean(L, 4)
)
{
arg1_idx = 1;
arg6 = lua_toboolean(L, 3);
arg7 = lua_toboolean(L, 4);
arg2 = THLongTensor_new();
arg5 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 4
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isboolean(L, 3)
&& lua_isboolean(L, 4)
)
{
arg2_idx = 1;
arg6 = lua_toboolean(L, 3);
arg7 = lua_toboolean(L, 4);
arg1 = THByteTensor_new();
arg5 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
&& lua_isboolean(L, 4)
&& lua_isboolean(L, 5)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg6 = lua_toboolean(L, 4);
arg7 = lua_toboolean(L, 5);
arg5 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 4
&& (arg3 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
&& lua_isboolean(L, 3)
&& lua_isboolean(L, 4)
)
{
arg4 = (long)lua_tonumber(L, 2);
arg6 = lua_toboolean(L, 3);
arg7 = lua_toboolean(L, 4);
arg1 = THByteTensor_new();
arg2 = THLongTensor_new();
arg5 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
&& lua_isboolean(L, 5)
)
{
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg6 = lua_toboolean(L, 4);
arg7 = lua_toboolean(L, 5);
arg2 = THLongTensor_new();
arg5 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 5
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
&& lua_isboolean(L, 5)
)
{
arg2_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg6 = lua_toboolean(L, 4);
arg7 = lua_toboolean(L, 5);
arg1 = THByteTensor_new();
arg5 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 6
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
&& lua_isnumber(L, 4)
&& lua_isboolean(L, 5)
&& lua_isboolean(L, 6)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = (long)lua_tonumber(L, 4);
arg6 = lua_toboolean(L, 5);
arg7 = lua_toboolean(L, 6);
arg5 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 4
&& (arg3 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
&& lua_isboolean(L, 3)
&& lua_isboolean(L, 4)
)
{
arg5 = (long)lua_tonumber(L, 2)-1;
arg6 = lua_toboolean(L, 3);
arg7 = lua_toboolean(L, 4);
arg1 = THByteTensor_new();
arg2 = THLongTensor_new();
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
&& lua_isboolean(L, 5)
)
{
arg1_idx = 1;
arg5 = (long)lua_tonumber(L, 3)-1;
arg6 = lua_toboolean(L, 4);
arg7 = lua_toboolean(L, 5);
arg2 = THLongTensor_new();
}
else if(narg == 5
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
&& lua_isboolean(L, 5)
)
{
arg2_idx = 1;
arg5 = (long)lua_tonumber(L, 3)-1;
arg6 = lua_toboolean(L, 4);
arg7 = lua_toboolean(L, 5);
arg1 = THByteTensor_new();
}
else if(narg == 6
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
&& lua_isnumber(L, 4)
&& lua_isboolean(L, 5)
&& lua_isboolean(L, 6)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg5 = (long)lua_tonumber(L, 4)-1;
arg6 = lua_toboolean(L, 5);
arg7 = lua_toboolean(L, 6);
}
else if(narg == 5
&& (arg3 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
&& lua_isboolean(L, 5)
)
{
arg4 = (long)lua_tonumber(L, 2);
arg5 = (long)lua_tonumber(L, 3)-1;
arg6 = lua_toboolean(L, 4);
arg7 = lua_toboolean(L, 5);
arg1 = THByteTensor_new();
arg2 = THLongTensor_new();
}
else if(narg == 6
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
&& lua_isnumber(L, 4)
&& lua_isboolean(L, 5)
&& lua_isboolean(L, 6)
)
{
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg5 = (long)lua_tonumber(L, 4)-1;
arg6 = lua_toboolean(L, 5);
arg7 = lua_toboolean(L, 6);
arg2 = THLongTensor_new();
}
else if(narg == 6
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
&& lua_isnumber(L, 4)
&& lua_isboolean(L, 5)
&& lua_isboolean(L, 6)
)
{
arg2_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg5 = (long)lua_tonumber(L, 4)-1;
arg6 = lua_toboolean(L, 5);
arg7 = lua_toboolean(L, 6);
arg1 = THByteTensor_new();
}
else if(narg == 7
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
&& lua_isnumber(L, 4)
&& lua_isnumber(L, 5)
&& lua_isboolean(L, 6)
&& lua_isboolean(L, 7)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = (long)lua_tonumber(L, 4);
arg5 = (long)lua_tonumber(L, 5)-1;
arg6 = lua_toboolean(L, 6);
arg7 = lua_toboolean(L, 7);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] [*LongTensor*] ByteTensor [long] [index] [boolean] [boolean]", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
if(arg2_idx)
lua_pushvalue(L, arg2_idx);
else
luaT_pushudata(L, arg2, "torch.LongTensor");
THByteTensor_topk(arg1,arg2,arg3,arg4,arg5,arg6,arg7);
THLongTensor_add(arg2, arg2, 1);
return 2;
}

static int m_torch_ByteTensor_kthvalue(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THLongTensor *arg2 = NULL;
int arg2_idx = 0;
THByteTensor *arg3 = NULL;
long arg4 = 0;
long arg5 = 0;
int arg6 = 1;
if(narg == 2
&& (arg3 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
)
{
arg4 = (long)lua_tonumber(L, 2);
arg1 = THByteTensor_new();
arg2 = THLongTensor_new();
arg5 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg2 = THLongTensor_new();
arg5 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
arg2_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg1 = THByteTensor_new();
arg5 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
&& lua_isnumber(L, 4)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = (long)lua_tonumber(L, 4);
arg5 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
&& lua_isnumber(L, 3)
)
{
arg4 = (long)lua_tonumber(L, 2);
arg5 = (long)lua_tonumber(L, 3)-1;
arg1 = THByteTensor_new();
arg2 = THLongTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
&& lua_isnumber(L, 4)
)
{
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg5 = (long)lua_tonumber(L, 4)-1;
arg2 = THLongTensor_new();
}
else if(narg == 4
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
&& lua_isnumber(L, 4)
)
{
arg2_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg5 = (long)lua_tonumber(L, 4)-1;
arg1 = THByteTensor_new();
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
&& lua_isnumber(L, 4)
&& lua_isnumber(L, 5)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = (long)lua_tonumber(L, 4);
arg5 = (long)lua_tonumber(L, 5)-1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] [*LongTensor*] ByteTensor long [index]", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
if(arg2_idx)
lua_pushvalue(L, arg2_idx);
else
luaT_pushudata(L, arg2, "torch.LongTensor");
THByteTensor_kthvalue(arg1,arg2,arg3,arg4,arg5,arg6);
THLongTensor_add(arg2, arg2, 1);
return 2;
}

static int m_torch_ByteTensor_mode(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THLongTensor *arg2 = NULL;
int arg2_idx = 0;
THByteTensor *arg3 = NULL;
long arg4 = 0;
int arg5 = 1;
if(narg == 1
&& (arg3 = luaT_toudata(L, 1, "torch.ByteTensor"))
)
{
arg1 = THByteTensor_new();
arg2 = THLongTensor_new();
arg4 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
)
{
arg1_idx = 1;
arg2 = THLongTensor_new();
arg4 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
)
{
arg2_idx = 1;
arg1 = THByteTensor_new();
arg4 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 2
&& (arg3 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
)
{
arg4 = (long)lua_tonumber(L, 2)-1;
arg1 = THByteTensor_new();
arg2 = THLongTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 3)-1;
arg2 = THLongTensor_new();
}
else if(narg == 3
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
arg2_idx = 1;
arg4 = (long)lua_tonumber(L, 3)-1;
arg1 = THByteTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
&& lua_isnumber(L, 4)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = (long)lua_tonumber(L, 4)-1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] [*LongTensor*] ByteTensor [index]", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
if(arg2_idx)
lua_pushvalue(L, arg2_idx);
else
luaT_pushudata(L, arg2, "torch.LongTensor");
THByteTensor_mode(arg1,arg2,arg3,arg4,arg5);
THLongTensor_add(arg2, arg2, 1);
return 2;
}

static int m_torch_ByteTensor_median(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THLongTensor *arg2 = NULL;
int arg2_idx = 0;
THByteTensor *arg3 = NULL;
long arg4 = 0;
int arg5 = 1;
if(narg == 1
&& (arg3 = luaT_toudata(L, 1, "torch.ByteTensor"))
)
{
arg1 = THByteTensor_new();
arg2 = THLongTensor_new();
arg4 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
)
{
arg1_idx = 1;
arg2 = THLongTensor_new();
arg4 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
)
{
arg2_idx = 1;
arg1 = THByteTensor_new();
arg4 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = THByteTensor_nDimension(arg3)-1;
}
else if(narg == 2
&& (arg3 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
)
{
arg4 = (long)lua_tonumber(L, 2)-1;
arg1 = THByteTensor_new();
arg2 = THLongTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 3)-1;
arg2 = THLongTensor_new();
}
else if(narg == 3
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
arg2_idx = 1;
arg4 = (long)lua_tonumber(L, 3)-1;
arg1 = THByteTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
&& lua_isnumber(L, 4)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = (long)lua_tonumber(L, 4)-1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] [*LongTensor*] ByteTensor [index]", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
if(arg2_idx)
lua_pushvalue(L, arg2_idx);
else
luaT_pushudata(L, arg2, "torch.LongTensor");
THByteTensor_median(arg1,arg2,arg3,arg4,arg5);
THLongTensor_add(arg2, arg2, 1);
return 2;
}

static int m_torch_ByteTensor_tril(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
int arg3 = 0;
if(narg == 1
&& (arg2 = luaT_toudata(L, 1, "torch.ByteTensor"))
)
{
arg1 = THByteTensor_new();
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
)
{
arg1_idx = 1;
}
else if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
)
{
arg3 = (int)lua_tonumber(L, 2);
arg1 = THByteTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (int)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] ByteTensor [int]", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THByteTensor_tril(arg1,arg2,arg3);
return 1;
}

static int m_torch_ByteTensor_triu(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
int arg3 = 0;
if(narg == 1
&& (arg2 = luaT_toudata(L, 1, "torch.ByteTensor"))
)
{
arg1 = THByteTensor_new();
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
)
{
arg1_idx = 1;
}
else if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
)
{
arg3 = (int)lua_tonumber(L, 2);
arg1 = THByteTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (int)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] ByteTensor [int]", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THByteTensor_triu(arg1,arg2,arg3);
return 1;
}

static int m_torch_ByteTensor_cat(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
THByteTensor *arg3 = NULL;
long arg4 = -2;
THByteTensor *arg5 = NULL;
int arg5_idx = 0;
THByteTensor **arg6_data = NULL;
long arg6_size = 0;
int arg6_i = 0;
long arg7 = -2;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
)
{
argset = 1;
arg1 = THByteTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
)
{
argset = 1;
arg1_idx = 1;
}
else if(narg == 3
&& (arg2 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 1;
arg4 = (long)lua_tonumber(L, 3)-1;
arg1 = THByteTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ByteTensor"))
&& lua_isnumber(L, 4)
)
{
argset = 1;
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 4)-1;
}
else if(narg == 1
&& torch_isnonemptytable(L, 1)
)
{
argset = 2;
do
{
  arg6_size++;
  lua_checkstack(L, 1);
  lua_rawgeti(L, 1, arg6_size);
}
while (!lua_isnil(L, -1));
arg6_size--;
lua_pop(L, 1);
arg6_data = (THByteTensor**)THAlloc(arg6_size * sizeof(THByteTensor*));
for (arg6_i = arg6_size - 1; arg6_i >= 0; arg6_i--)
{
  if (!(arg6_data[arg6_i] = luaT_toudata(L, -1, "torch.ByteTensor")))
    luaL_error(L, "expected ByteTensor in tensor array");
  lua_pop(L, 1);
}

arg5 = THByteTensor_new();
}
else if(narg == 2
&& (arg5 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& torch_isnonemptytable(L, 2)
)
{
argset = 2;
arg5_idx = 1;
do
{
  arg6_size++;
  lua_checkstack(L, 1);
  lua_rawgeti(L, 2, arg6_size);
}
while (!lua_isnil(L, -1));
arg6_size--;
lua_pop(L, 1);
arg6_data = (THByteTensor**)THAlloc(arg6_size * sizeof(THByteTensor*));
for (arg6_i = arg6_size - 1; arg6_i >= 0; arg6_i--)
{
  if (!(arg6_data[arg6_i] = luaT_toudata(L, -1, "torch.ByteTensor")))
    luaL_error(L, "expected ByteTensor in tensor array");
  lua_pop(L, 1);
}

}
else if(narg == 2
&& torch_isnonemptytable(L, 1)
&& lua_isnumber(L, 2)
)
{
argset = 2;
do
{
  arg6_size++;
  lua_checkstack(L, 1);
  lua_rawgeti(L, 1, arg6_size);
}
while (!lua_isnil(L, -1));
arg6_size--;
lua_pop(L, 1);
arg6_data = (THByteTensor**)THAlloc(arg6_size * sizeof(THByteTensor*));
for (arg6_i = arg6_size - 1; arg6_i >= 0; arg6_i--)
{
  if (!(arg6_data[arg6_i] = luaT_toudata(L, -1, "torch.ByteTensor")))
    luaL_error(L, "expected ByteTensor in tensor array");
  lua_pop(L, 1);
}

arg7 = (long)lua_tonumber(L, 2)-1;
arg5 = THByteTensor_new();
}
else if(narg == 3
&& (arg5 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& torch_isnonemptytable(L, 2)
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg5_idx = 1;
do
{
  arg6_size++;
  lua_checkstack(L, 1);
  lua_rawgeti(L, 2, arg6_size);
}
while (!lua_isnil(L, -1));
arg6_size--;
lua_pop(L, 1);
arg6_data = (THByteTensor**)THAlloc(arg6_size * sizeof(THByteTensor*));
for (arg6_i = arg6_size - 1; arg6_i >= 0; arg6_i--)
{
  if (!(arg6_data[arg6_i] = luaT_toudata(L, -1, "torch.ByteTensor")))
    luaL_error(L, "expected ByteTensor in tensor array");
  lua_pop(L, 1);
}

arg7 = (long)lua_tonumber(L, 3)-1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] ByteTensor ByteTensor [index] | [*ByteTensor*] {ByteTensor+} [index]", type_buf);
}
if(argset == 1)
{
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THByteTensor_cat(arg1,arg2,arg3,arg4);
return 1;
}
else if(argset == 2)
{
if(arg5_idx)
lua_pushvalue(L, arg5_idx);
else
luaT_pushudata(L, arg5, "torch.ByteTensor");
THByteTensor_catArray(arg5,arg6_data,arg6_size,arg7);
THFree(arg6_data);
return 1;
}
return 0;
}

static int m_torch_ByteTensor_random(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THGenerator *arg1 = NULL;
long arg2 = 0;
long arg3 = 0;
long arg4 = 0;
THGenerator *arg5 = NULL;
long arg6 = 0;
long arg7 = 0;
THGenerator *arg8 = NULL;
long arg9 = 0;
THByteTensor *arg10 = NULL;
int arg10_idx = 0;
THGenerator *arg11 = NULL;
long arg12 = 0;
long arg13 = 0;
THByteTensor *arg14 = NULL;
int arg14_idx = 0;
THGenerator *arg15 = NULL;
long arg16 = 0;
THByteTensor *arg17 = NULL;
int arg17_idx = 0;
THGenerator *arg18 = NULL;
if(narg == 2
&& lua_isnumber(L, 1)
&& lua_isnumber(L, 2)
)
{
argset = 1;
arg2 = (long)lua_tonumber(L, 1);
arg3 = (long)lua_tonumber(L, 2);
lua_getglobal(L,"torch");
arg1 = luaT_getfieldcheckudata(L, -1, "_gen", torch_Generator);
lua_pop(L, 2);
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, torch_Generator))
&& lua_isnumber(L, 2)
&& lua_isnumber(L, 3)
)
{
argset = 1;
arg2 = (long)lua_tonumber(L, 2);
arg3 = (long)lua_tonumber(L, 3);
}
else if(narg == 1
&& lua_isnumber(L, 1)
)
{
argset = 2;
arg6 = (long)lua_tonumber(L, 1);
lua_getglobal(L,"torch");
arg5 = luaT_getfieldcheckudata(L, -1, "_gen", torch_Generator);
lua_pop(L, 2);
}
else if(narg == 2
&& (arg5 = luaT_toudata(L, 1, torch_Generator))
&& lua_isnumber(L, 2)
)
{
argset = 2;
arg6 = (long)lua_tonumber(L, 2);
}
else if(narg == 0
)
{
argset = 3;
lua_getglobal(L,"torch");
arg8 = luaT_getfieldcheckudata(L, -1, "_gen", torch_Generator);
lua_pop(L, 2);
}
else if(narg == 1
&& (arg8 = luaT_toudata(L, 1, torch_Generator))
)
{
argset = 3;
}
else if(narg == 3
&& (arg10 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
&& lua_isnumber(L, 3)
)
{
argset = 4;
arg10_idx = 1;
arg12 = (long)lua_tonumber(L, 2);
arg13 = (long)lua_tonumber(L, 3);
lua_getglobal(L,"torch");
arg11 = luaT_getfieldcheckudata(L, -1, "_gen", torch_Generator);
lua_pop(L, 2);
}
else if(narg == 4
&& (arg10 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg11 = luaT_toudata(L, 2, torch_Generator))
&& lua_isnumber(L, 3)
&& lua_isnumber(L, 4)
)
{
argset = 4;
arg10_idx = 1;
arg12 = (long)lua_tonumber(L, 3);
arg13 = (long)lua_tonumber(L, 4);
}
else if(narg == 2
&& (arg14 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 5;
arg14_idx = 1;
arg16 = (long)lua_tonumber(L, 2);
lua_getglobal(L,"torch");
arg15 = luaT_getfieldcheckudata(L, -1, "_gen", torch_Generator);
lua_pop(L, 2);
}
else if(narg == 3
&& (arg14 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg15 = luaT_toudata(L, 2, torch_Generator))
&& lua_isnumber(L, 3)
)
{
argset = 5;
arg14_idx = 1;
arg16 = (long)lua_tonumber(L, 3);
}
else if(narg == 1
&& (arg17 = luaT_toudata(L, 1, "torch.ByteTensor"))
)
{
argset = 6;
arg17_idx = 1;
lua_getglobal(L,"torch");
arg18 = luaT_getfieldcheckudata(L, -1, "_gen", torch_Generator);
lua_pop(L, 2);
}
else if(narg == 2
&& (arg17 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg18 = luaT_toudata(L, 2, torch_Generator))
)
{
argset = 6;
arg17_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [Generator] long long | [Generator] long | [Generator] | *ByteTensor* [Generator] long long | *ByteTensor* [Generator] long | *ByteTensor* [Generator]", type_buf);
}
if(argset == 1)
{
arg4 = THRandom_random2__(arg1,arg2,arg3);
lua_pushnumber(L, (lua_Number)arg4);
return 1;
}
else if(argset == 2)
{
arg7 = THRandom_random1__(arg5,arg6);
lua_pushnumber(L, (lua_Number)arg7);
return 1;
}
else if(argset == 3)
{
arg9 = THRandom_random(arg8);
lua_pushnumber(L, (lua_Number)arg9);
return 1;
}
else if(argset == 4)
{
lua_pushvalue(L, arg10_idx);
THByteTensor_random2__(arg10,arg11,arg12,arg13);
return 1;
}
else if(argset == 5)
{
lua_pushvalue(L, arg14_idx);
THByteTensor_random1__(arg14,arg15,arg16);
return 1;
}
else if(argset == 6)
{
lua_pushvalue(L, arg17_idx);
THByteTensor_random(arg17,arg18);
return 1;
}
return 0;
}

static int m_torch_ByteTensor_geometric(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THGenerator *arg1 = NULL;
double arg2 = 0;
double arg3 = 0;
THByteTensor *arg4 = NULL;
int arg4_idx = 0;
THGenerator *arg5 = NULL;
double arg6 = 0;
if(narg == 1
&& lua_isnumber(L, 1)
)
{
argset = 1;
arg2 = (double)lua_tonumber(L, 1);
lua_getglobal(L,"torch");
arg1 = luaT_getfieldcheckudata(L, -1, "_gen", torch_Generator);
lua_pop(L, 2);
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, torch_Generator))
&& lua_isnumber(L, 2)
)
{
argset = 1;
arg2 = (double)lua_tonumber(L, 2);
}
else if(narg == 2
&& (arg4 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 2;
arg4_idx = 1;
arg6 = (double)lua_tonumber(L, 2);
lua_getglobal(L,"torch");
arg5 = luaT_getfieldcheckudata(L, -1, "_gen", torch_Generator);
lua_pop(L, 2);
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg5 = luaT_toudata(L, 2, torch_Generator))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg4_idx = 1;
arg6 = (double)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [Generator] double | *ByteTensor* [Generator] double", type_buf);
}
if(argset == 1)
{
arg3 = THRandom_geometric(arg1,arg2);
lua_pushnumber(L, (lua_Number)arg3);
return 1;
}
else if(argset == 2)
{
lua_pushvalue(L, arg4_idx);
THByteTensor_geometric(arg4,arg5,arg6);
return 1;
}
return 0;
}

static int m_torch_ByteTensor_bernoulli(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THGenerator *arg1 = NULL;
double arg2 = 0.5;
double arg3 = 0;
THByteTensor *arg4 = NULL;
int arg4_idx = 0;
THGenerator *arg5 = NULL;
double arg6 = 0.5;
THByteTensor *arg7 = NULL;
int arg7_idx = 0;
THGenerator *arg8 = NULL;
THFloatTensor *arg9 = NULL;
THByteTensor *arg10 = NULL;
int arg10_idx = 0;
THGenerator *arg11 = NULL;
THDoubleTensor *arg12 = NULL;
if(narg == 0
)
{
argset = 1;
lua_getglobal(L,"torch");
arg1 = luaT_getfieldcheckudata(L, -1, "_gen", torch_Generator);
lua_pop(L, 2);
}
else if(narg == 1
&& (arg1 = luaT_toudata(L, 1, torch_Generator))
)
{
argset = 1;
}
else if(narg == 1
&& lua_isnumber(L, 1)
)
{
argset = 1;
arg2 = (double)lua_tonumber(L, 1);
lua_getglobal(L,"torch");
arg1 = luaT_getfieldcheckudata(L, -1, "_gen", torch_Generator);
lua_pop(L, 2);
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, torch_Generator))
&& lua_isnumber(L, 2)
)
{
argset = 1;
arg2 = (double)lua_tonumber(L, 2);
}
else if(narg == 1
&& (arg4 = luaT_toudata(L, 1, "torch.ByteTensor"))
)
{
argset = 2;
arg4_idx = 1;
lua_getglobal(L,"torch");
arg5 = luaT_getfieldcheckudata(L, -1, "_gen", torch_Generator);
lua_pop(L, 2);
}
else if(narg == 2
&& (arg4 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg5 = luaT_toudata(L, 2, torch_Generator))
)
{
argset = 2;
arg4_idx = 1;
}
else if(narg == 2
&& (arg4 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 2;
arg4_idx = 1;
arg6 = (double)lua_tonumber(L, 2);
lua_getglobal(L,"torch");
arg5 = luaT_getfieldcheckudata(L, -1, "_gen", torch_Generator);
lua_pop(L, 2);
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg5 = luaT_toudata(L, 2, torch_Generator))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg4_idx = 1;
arg6 = (double)lua_tonumber(L, 3);
}
else if(narg == 2
&& (arg7 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg9 = luaT_toudata(L, 2, "torch.FloatTensor"))
)
{
argset = 3;
arg7_idx = 1;
lua_getglobal(L,"torch");
arg8 = luaT_getfieldcheckudata(L, -1, "_gen", torch_Generator);
lua_pop(L, 2);
}
else if(narg == 3
&& (arg7 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg8 = luaT_toudata(L, 2, torch_Generator))
&& (arg9 = luaT_toudata(L, 3, "torch.FloatTensor"))
)
{
argset = 3;
arg7_idx = 1;
}
else if(narg == 2
&& (arg10 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg12 = luaT_toudata(L, 2, "torch.DoubleTensor"))
)
{
argset = 4;
arg10_idx = 1;
lua_getglobal(L,"torch");
arg11 = luaT_getfieldcheckudata(L, -1, "_gen", torch_Generator);
lua_pop(L, 2);
}
else if(narg == 3
&& (arg10 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg11 = luaT_toudata(L, 2, torch_Generator))
&& (arg12 = luaT_toudata(L, 3, "torch.DoubleTensor"))
)
{
argset = 4;
arg10_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [Generator] [double] | *ByteTensor* [Generator] [double] | *ByteTensor* [Generator] FloatTensor | *ByteTensor* [Generator] DoubleTensor", type_buf);
}
if(argset == 1)
{
arg3 = THRandom_bernoulli(arg1,arg2);
lua_pushnumber(L, (lua_Number)arg3);
return 1;
}
else if(argset == 2)
{
lua_pushvalue(L, arg4_idx);
THByteTensor_bernoulli(arg4,arg5,arg6);
return 1;
}
else if(argset == 3)
{
lua_pushvalue(L, arg7_idx);
THByteTensor_bernoulli_FloatTensor(arg7,arg8,arg9);
return 1;
}
else if(argset == 4)
{
lua_pushvalue(L, arg10_idx);
THByteTensor_bernoulli_DoubleTensor(arg10,arg11,arg12);
return 1;
}
return 0;
}

static int m_torch_ByteTensor_squeeze(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
THByteTensor *arg3 = NULL;
int arg3_idx = 0;
THByteTensor *arg4 = NULL;
long arg5 = 0;
if(narg == 1
&& (arg2 = luaT_toudata(L, 1, "torch.ByteTensor"))
)
{
argset = 1;
arg1 = THByteTensor_new();
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
)
{
argset = 1;
arg1_idx = 1;
}
else if(narg == 2
&& (arg4 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 2;
arg5 = (long)lua_tonumber(L, 2)-1;
arg3 = THByteTensor_new();
}
else if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg4 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg3_idx = 1;
arg5 = (long)lua_tonumber(L, 3)-1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] ByteTensor | [*ByteTensor*] ByteTensor index", type_buf);
}
if(argset == 1)
{
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THByteTensor_squeeze(arg1,arg2);
if(arg1->nDimension == 1 && arg1->size[0] == 1)
lua_pushnumber(L, (lua_Number)(*THByteTensor_data(arg1)));
return 1;
}
else if(argset == 2)
{
if(arg3_idx)
lua_pushvalue(L, arg3_idx);
else
luaT_pushudata(L, arg3, "torch.ByteTensor");
{int hasdims = arg4->nDimension > 1;
THByteTensor_squeeze1d(arg3,arg4,arg5);
if(!hasdims && arg3->nDimension == 1 && arg3->size[0] == 1)
lua_pushnumber(L, (lua_Number)(*THByteTensor_data(arg3)));}
return 1;
}
return 0;
}

static int m_torch_ByteTensor_sign(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
if(narg == 1
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
)
{
arg1_idx = 1;
arg2 = arg1;
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
)
{
arg1_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ByteTensor* [ByteTensor]", type_buf);
}
lua_pushvalue(L, arg1_idx);
THByteTensor_sign(arg1,arg2);
return 1;
}

static int m_torch_ByteTensor_conv2(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
unsigned char arg2 = 0;
unsigned char arg3 = 1;
THByteTensor *arg4 = NULL;
THByteTensor *arg5 = NULL;
unsigned char arg6 = 1;
unsigned char arg7 = 1;
const char *arg8 = NULL;
char arg8_default = 'V';
const char *arg9 = NULL;
char arg9_default = 'C';
THByteTensor *arg10 = NULL;
int arg10_idx = 0;
unsigned char arg11 = 0;
unsigned char arg12 = 1;
THByteTensor *arg13 = NULL;
THByteTensor *arg14 = NULL;
unsigned char arg15 = 1;
unsigned char arg16 = 1;
const char *arg17 = NULL;
char arg17_default = 'V';
const char *arg18 = NULL;
char arg18_default = 'C';
THByteTensor *arg19 = NULL;
int arg19_idx = 0;
unsigned char arg20 = 0;
unsigned char arg21 = 1;
THByteTensor *arg22 = NULL;
THByteTensor *arg23 = NULL;
unsigned char arg24 = 1;
unsigned char arg25 = 1;
const char *arg26 = NULL;
char arg26_default = 'V';
const char *arg27 = NULL;
char arg27_default = 'C';
if(narg == 2
&& (arg4 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg4->nDimension == 2)
&& (arg5 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg5->nDimension == 2)
)
{
argset = 1;
arg1 = THByteTensor_new();
arg8 = &arg8_default;
arg9 = &arg9_default;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg4 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg4->nDimension == 2)
&& (arg5 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg5->nDimension == 2)
)
{
argset = 1;
arg1_idx = 1;
arg8 = &arg8_default;
arg9 = &arg9_default;
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg4->nDimension == 2)
&& (arg5 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg5->nDimension == 2)
&& (arg8 = lua_tostring(L, 3)) && (*arg8 == 'V' || *arg8 == 'F')
)
{
argset = 1;
arg1 = THByteTensor_new();
arg9 = &arg9_default;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg4 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg4->nDimension == 2)
&& (arg5 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg5->nDimension == 2)
&& (arg8 = lua_tostring(L, 4)) && (*arg8 == 'V' || *arg8 == 'F')
)
{
argset = 1;
arg1_idx = 1;
arg9 = &arg9_default;
}
else if(narg == 2
&& (arg13 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg13->nDimension == 3)
&& (arg14 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg14->nDimension == 3)
)
{
argset = 2;
arg10 = THByteTensor_new();
arg17 = &arg17_default;
arg18 = &arg18_default;
}
else if(narg == 3
&& (arg10 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg13 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg13->nDimension == 3)
&& (arg14 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg14->nDimension == 3)
)
{
argset = 2;
arg10_idx = 1;
arg17 = &arg17_default;
arg18 = &arg18_default;
}
else if(narg == 3
&& (arg13 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg13->nDimension == 3)
&& (arg14 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg14->nDimension == 3)
&& (arg17 = lua_tostring(L, 3)) && (*arg17 == 'V' || *arg17 == 'F')
)
{
argset = 2;
arg10 = THByteTensor_new();
arg18 = &arg18_default;
}
else if(narg == 4
&& (arg10 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg13 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg13->nDimension == 3)
&& (arg14 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg14->nDimension == 3)
&& (arg17 = lua_tostring(L, 4)) && (*arg17 == 'V' || *arg17 == 'F')
)
{
argset = 2;
arg10_idx = 1;
arg18 = &arg18_default;
}
else if(narg == 2
&& (arg22 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg22->nDimension == 3)
&& (arg23 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg23->nDimension == 4)
)
{
argset = 3;
arg19 = THByteTensor_new();
arg26 = &arg26_default;
arg27 = &arg27_default;
}
else if(narg == 3
&& (arg19 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg22 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg22->nDimension == 3)
&& (arg23 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg23->nDimension == 4)
)
{
argset = 3;
arg19_idx = 1;
arg26 = &arg26_default;
arg27 = &arg27_default;
}
else if(narg == 3
&& (arg22 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg22->nDimension == 3)
&& (arg23 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg23->nDimension == 4)
&& (arg26 = lua_tostring(L, 3)) && (*arg26 == 'V' || *arg26 == 'F')
)
{
argset = 3;
arg19 = THByteTensor_new();
arg27 = &arg27_default;
}
else if(narg == 4
&& (arg19 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg22 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg22->nDimension == 3)
&& (arg23 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg23->nDimension == 4)
&& (arg26 = lua_tostring(L, 4)) && (*arg26 == 'V' || *arg26 == 'F')
)
{
argset = 3;
arg19_idx = 1;
arg27 = &arg27_default;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] ByteTensor~2D ByteTensor~2D [(V|F)] | [*ByteTensor*] ByteTensor~3D ByteTensor~3D [(V|F)] | [*ByteTensor*] ByteTensor~3D ByteTensor~4D [(V|F)]", type_buf);
}
if(argset == 1)
{
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THByteTensor_conv2Dmul(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9);
return 1;
}
else if(argset == 2)
{
if(arg10_idx)
lua_pushvalue(L, arg10_idx);
else
luaT_pushudata(L, arg10, "torch.ByteTensor");
THByteTensor_conv2Dcmul(arg10,arg11,arg12,arg13,arg14,arg15,arg16,arg17,arg18);
return 1;
}
else if(argset == 3)
{
if(arg19_idx)
lua_pushvalue(L, arg19_idx);
else
luaT_pushudata(L, arg19, "torch.ByteTensor");
THByteTensor_conv2Dmv(arg19,arg20,arg21,arg22,arg23,arg24,arg25,arg26,arg27);
return 1;
}
return 0;
}

static int m_torch_ByteTensor_xcorr2(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
unsigned char arg2 = 0;
unsigned char arg3 = 1;
THByteTensor *arg4 = NULL;
THByteTensor *arg5 = NULL;
unsigned char arg6 = 1;
unsigned char arg7 = 1;
const char *arg8 = NULL;
char arg8_default = 'V';
const char *arg9 = NULL;
char arg9_default = 'X';
THByteTensor *arg10 = NULL;
int arg10_idx = 0;
unsigned char arg11 = 0;
unsigned char arg12 = 1;
THByteTensor *arg13 = NULL;
THByteTensor *arg14 = NULL;
unsigned char arg15 = 1;
unsigned char arg16 = 1;
const char *arg17 = NULL;
char arg17_default = 'V';
const char *arg18 = NULL;
char arg18_default = 'X';
THByteTensor *arg19 = NULL;
int arg19_idx = 0;
unsigned char arg20 = 0;
unsigned char arg21 = 1;
THByteTensor *arg22 = NULL;
THByteTensor *arg23 = NULL;
unsigned char arg24 = 1;
unsigned char arg25 = 1;
const char *arg26 = NULL;
char arg26_default = 'V';
const char *arg27 = NULL;
char arg27_default = 'X';
if(narg == 2
&& (arg4 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg4->nDimension == 2)
&& (arg5 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg5->nDimension == 2)
)
{
argset = 1;
arg1 = THByteTensor_new();
arg8 = &arg8_default;
arg9 = &arg9_default;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg4 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg4->nDimension == 2)
&& (arg5 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg5->nDimension == 2)
)
{
argset = 1;
arg1_idx = 1;
arg8 = &arg8_default;
arg9 = &arg9_default;
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg4->nDimension == 2)
&& (arg5 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg5->nDimension == 2)
&& (arg8 = lua_tostring(L, 3)) && (*arg8 == 'V' || *arg8 == 'F')
)
{
argset = 1;
arg1 = THByteTensor_new();
arg9 = &arg9_default;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg4 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg4->nDimension == 2)
&& (arg5 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg5->nDimension == 2)
&& (arg8 = lua_tostring(L, 4)) && (*arg8 == 'V' || *arg8 == 'F')
)
{
argset = 1;
arg1_idx = 1;
arg9 = &arg9_default;
}
else if(narg == 2
&& (arg13 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg13->nDimension == 3)
&& (arg14 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg14->nDimension == 3)
)
{
argset = 2;
arg10 = THByteTensor_new();
arg17 = &arg17_default;
arg18 = &arg18_default;
}
else if(narg == 3
&& (arg10 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg13 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg13->nDimension == 3)
&& (arg14 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg14->nDimension == 3)
)
{
argset = 2;
arg10_idx = 1;
arg17 = &arg17_default;
arg18 = &arg18_default;
}
else if(narg == 3
&& (arg13 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg13->nDimension == 3)
&& (arg14 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg14->nDimension == 3)
&& (arg17 = lua_tostring(L, 3)) && (*arg17 == 'V' || *arg17 == 'F')
)
{
argset = 2;
arg10 = THByteTensor_new();
arg18 = &arg18_default;
}
else if(narg == 4
&& (arg10 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg13 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg13->nDimension == 3)
&& (arg14 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg14->nDimension == 3)
&& (arg17 = lua_tostring(L, 4)) && (*arg17 == 'V' || *arg17 == 'F')
)
{
argset = 2;
arg10_idx = 1;
arg18 = &arg18_default;
}
else if(narg == 2
&& (arg22 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg22->nDimension == 3)
&& (arg23 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg23->nDimension == 4)
)
{
argset = 3;
arg19 = THByteTensor_new();
arg26 = &arg26_default;
arg27 = &arg27_default;
}
else if(narg == 3
&& (arg19 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg22 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg22->nDimension == 3)
&& (arg23 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg23->nDimension == 4)
)
{
argset = 3;
arg19_idx = 1;
arg26 = &arg26_default;
arg27 = &arg27_default;
}
else if(narg == 3
&& (arg22 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg22->nDimension == 3)
&& (arg23 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg23->nDimension == 4)
&& (arg26 = lua_tostring(L, 3)) && (*arg26 == 'V' || *arg26 == 'F')
)
{
argset = 3;
arg19 = THByteTensor_new();
arg27 = &arg27_default;
}
else if(narg == 4
&& (arg19 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg22 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg22->nDimension == 3)
&& (arg23 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg23->nDimension == 4)
&& (arg26 = lua_tostring(L, 4)) && (*arg26 == 'V' || *arg26 == 'F')
)
{
argset = 3;
arg19_idx = 1;
arg27 = &arg27_default;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] ByteTensor~2D ByteTensor~2D [(V|F)] | [*ByteTensor*] ByteTensor~3D ByteTensor~3D [(V|F)] | [*ByteTensor*] ByteTensor~3D ByteTensor~4D [(V|F)]", type_buf);
}
if(argset == 1)
{
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THByteTensor_conv2Dmul(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9);
return 1;
}
else if(argset == 2)
{
if(arg10_idx)
lua_pushvalue(L, arg10_idx);
else
luaT_pushudata(L, arg10, "torch.ByteTensor");
THByteTensor_conv2Dcmul(arg10,arg11,arg12,arg13,arg14,arg15,arg16,arg17,arg18);
return 1;
}
else if(argset == 3)
{
if(arg19_idx)
lua_pushvalue(L, arg19_idx);
else
luaT_pushudata(L, arg19, "torch.ByteTensor");
THByteTensor_conv2Dmv(arg19,arg20,arg21,arg22,arg23,arg24,arg25,arg26,arg27);
return 1;
}
return 0;
}

static int m_torch_ByteTensor_conv3(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
unsigned char arg2 = 0;
unsigned char arg3 = 1;
THByteTensor *arg4 = NULL;
THByteTensor *arg5 = NULL;
unsigned char arg6 = 1;
unsigned char arg7 = 1;
unsigned char arg8 = 1;
const char *arg9 = NULL;
char arg9_default = 'V';
const char *arg10 = NULL;
char arg10_default = 'C';
THByteTensor *arg11 = NULL;
int arg11_idx = 0;
unsigned char arg12 = 0;
unsigned char arg13 = 1;
THByteTensor *arg14 = NULL;
THByteTensor *arg15 = NULL;
unsigned char arg16 = 1;
unsigned char arg17 = 1;
unsigned char arg18 = 1;
const char *arg19 = NULL;
char arg19_default = 'V';
const char *arg20 = NULL;
char arg20_default = 'C';
THByteTensor *arg21 = NULL;
int arg21_idx = 0;
unsigned char arg22 = 0;
unsigned char arg23 = 1;
THByteTensor *arg24 = NULL;
THByteTensor *arg25 = NULL;
unsigned char arg26 = 1;
unsigned char arg27 = 1;
unsigned char arg28 = 1;
const char *arg29 = NULL;
char arg29_default = 'V';
const char *arg30 = NULL;
char arg30_default = 'C';
if(narg == 2
&& (arg4 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg4->nDimension == 3)
&& (arg5 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg5->nDimension == 3)
)
{
argset = 1;
arg1 = THByteTensor_new();
arg9 = &arg9_default;
arg10 = &arg10_default;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg4 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg4->nDimension == 3)
&& (arg5 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg5->nDimension == 3)
)
{
argset = 1;
arg1_idx = 1;
arg9 = &arg9_default;
arg10 = &arg10_default;
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg4->nDimension == 3)
&& (arg5 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg5->nDimension == 3)
&& (arg9 = lua_tostring(L, 3)) && (*arg9 == 'V' || *arg9 == 'F')
)
{
argset = 1;
arg1 = THByteTensor_new();
arg10 = &arg10_default;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg4 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg4->nDimension == 3)
&& (arg5 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg5->nDimension == 3)
&& (arg9 = lua_tostring(L, 4)) && (*arg9 == 'V' || *arg9 == 'F')
)
{
argset = 1;
arg1_idx = 1;
arg10 = &arg10_default;
}
else if(narg == 2
&& (arg14 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg14->nDimension == 4)
&& (arg15 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg15->nDimension == 4)
)
{
argset = 2;
arg11 = THByteTensor_new();
arg19 = &arg19_default;
arg20 = &arg20_default;
}
else if(narg == 3
&& (arg11 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg14 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg14->nDimension == 4)
&& (arg15 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg15->nDimension == 4)
)
{
argset = 2;
arg11_idx = 1;
arg19 = &arg19_default;
arg20 = &arg20_default;
}
else if(narg == 3
&& (arg14 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg14->nDimension == 4)
&& (arg15 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg15->nDimension == 4)
&& (arg19 = lua_tostring(L, 3)) && (*arg19 == 'V' || *arg19 == 'F')
)
{
argset = 2;
arg11 = THByteTensor_new();
arg20 = &arg20_default;
}
else if(narg == 4
&& (arg11 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg14 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg14->nDimension == 4)
&& (arg15 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg15->nDimension == 4)
&& (arg19 = lua_tostring(L, 4)) && (*arg19 == 'V' || *arg19 == 'F')
)
{
argset = 2;
arg11_idx = 1;
arg20 = &arg20_default;
}
else if(narg == 2
&& (arg24 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg24->nDimension == 4)
&& (arg25 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg25->nDimension == 5)
)
{
argset = 3;
arg21 = THByteTensor_new();
arg29 = &arg29_default;
arg30 = &arg30_default;
}
else if(narg == 3
&& (arg21 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg24 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg24->nDimension == 4)
&& (arg25 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg25->nDimension == 5)
)
{
argset = 3;
arg21_idx = 1;
arg29 = &arg29_default;
arg30 = &arg30_default;
}
else if(narg == 3
&& (arg24 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg24->nDimension == 4)
&& (arg25 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg25->nDimension == 5)
&& (arg29 = lua_tostring(L, 3)) && (*arg29 == 'V' || *arg29 == 'F')
)
{
argset = 3;
arg21 = THByteTensor_new();
arg30 = &arg30_default;
}
else if(narg == 4
&& (arg21 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg24 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg24->nDimension == 4)
&& (arg25 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg25->nDimension == 5)
&& (arg29 = lua_tostring(L, 4)) && (*arg29 == 'V' || *arg29 == 'F')
)
{
argset = 3;
arg21_idx = 1;
arg30 = &arg30_default;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] ByteTensor~3D ByteTensor~3D [(V|F)] | [*ByteTensor*] ByteTensor~4D ByteTensor~4D [(V|F)] | [*ByteTensor*] ByteTensor~4D ByteTensor~5D [(V|F)]", type_buf);
}
if(argset == 1)
{
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THByteTensor_conv3Dmul(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10);
return 1;
}
else if(argset == 2)
{
if(arg11_idx)
lua_pushvalue(L, arg11_idx);
else
luaT_pushudata(L, arg11, "torch.ByteTensor");
THByteTensor_conv3Dcmul(arg11,arg12,arg13,arg14,arg15,arg16,arg17,arg18,arg19,arg20);
return 1;
}
else if(argset == 3)
{
if(arg21_idx)
lua_pushvalue(L, arg21_idx);
else
luaT_pushudata(L, arg21, "torch.ByteTensor");
THByteTensor_conv3Dmv(arg21,arg22,arg23,arg24,arg25,arg26,arg27,arg28,arg29,arg30);
return 1;
}
return 0;
}

static int m_torch_ByteTensor_xcorr3(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
unsigned char arg2 = 0;
unsigned char arg3 = 1;
THByteTensor *arg4 = NULL;
THByteTensor *arg5 = NULL;
unsigned char arg6 = 1;
unsigned char arg7 = 1;
unsigned char arg8 = 1;
const char *arg9 = NULL;
char arg9_default = 'V';
const char *arg10 = NULL;
char arg10_default = 'X';
THByteTensor *arg11 = NULL;
int arg11_idx = 0;
unsigned char arg12 = 0;
unsigned char arg13 = 1;
THByteTensor *arg14 = NULL;
THByteTensor *arg15 = NULL;
unsigned char arg16 = 1;
unsigned char arg17 = 1;
unsigned char arg18 = 1;
const char *arg19 = NULL;
char arg19_default = 'V';
const char *arg20 = NULL;
char arg20_default = 'X';
THByteTensor *arg21 = NULL;
int arg21_idx = 0;
unsigned char arg22 = 0;
unsigned char arg23 = 1;
THByteTensor *arg24 = NULL;
THByteTensor *arg25 = NULL;
unsigned char arg26 = 1;
unsigned char arg27 = 1;
unsigned char arg28 = 1;
const char *arg29 = NULL;
char arg29_default = 'V';
const char *arg30 = NULL;
char arg30_default = 'X';
if(narg == 2
&& (arg4 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg4->nDimension == 3)
&& (arg5 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg5->nDimension == 3)
)
{
argset = 1;
arg1 = THByteTensor_new();
arg9 = &arg9_default;
arg10 = &arg10_default;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg4 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg4->nDimension == 3)
&& (arg5 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg5->nDimension == 3)
)
{
argset = 1;
arg1_idx = 1;
arg9 = &arg9_default;
arg10 = &arg10_default;
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg4->nDimension == 3)
&& (arg5 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg5->nDimension == 3)
&& (arg9 = lua_tostring(L, 3)) && (*arg9 == 'V' || *arg9 == 'F')
)
{
argset = 1;
arg1 = THByteTensor_new();
arg10 = &arg10_default;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg4 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg4->nDimension == 3)
&& (arg5 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg5->nDimension == 3)
&& (arg9 = lua_tostring(L, 4)) && (*arg9 == 'V' || *arg9 == 'F')
)
{
argset = 1;
arg1_idx = 1;
arg10 = &arg10_default;
}
else if(narg == 2
&& (arg14 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg14->nDimension == 4)
&& (arg15 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg15->nDimension == 4)
)
{
argset = 2;
arg11 = THByteTensor_new();
arg19 = &arg19_default;
arg20 = &arg20_default;
}
else if(narg == 3
&& (arg11 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg14 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg14->nDimension == 4)
&& (arg15 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg15->nDimension == 4)
)
{
argset = 2;
arg11_idx = 1;
arg19 = &arg19_default;
arg20 = &arg20_default;
}
else if(narg == 3
&& (arg14 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg14->nDimension == 4)
&& (arg15 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg15->nDimension == 4)
&& (arg19 = lua_tostring(L, 3)) && (*arg19 == 'V' || *arg19 == 'F')
)
{
argset = 2;
arg11 = THByteTensor_new();
arg20 = &arg20_default;
}
else if(narg == 4
&& (arg11 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg14 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg14->nDimension == 4)
&& (arg15 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg15->nDimension == 4)
&& (arg19 = lua_tostring(L, 4)) && (*arg19 == 'V' || *arg19 == 'F')
)
{
argset = 2;
arg11_idx = 1;
arg20 = &arg20_default;
}
else if(narg == 2
&& (arg24 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg24->nDimension == 4)
&& (arg25 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg25->nDimension == 5)
)
{
argset = 3;
arg21 = THByteTensor_new();
arg29 = &arg29_default;
arg30 = &arg30_default;
}
else if(narg == 3
&& (arg21 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg24 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg24->nDimension == 4)
&& (arg25 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg25->nDimension == 5)
)
{
argset = 3;
arg21_idx = 1;
arg29 = &arg29_default;
arg30 = &arg30_default;
}
else if(narg == 3
&& (arg24 = luaT_toudata(L, 1, "torch.ByteTensor")) && (arg24->nDimension == 4)
&& (arg25 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg25->nDimension == 5)
&& (arg29 = lua_tostring(L, 3)) && (*arg29 == 'V' || *arg29 == 'F')
)
{
argset = 3;
arg21 = THByteTensor_new();
arg30 = &arg30_default;
}
else if(narg == 4
&& (arg21 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg24 = luaT_toudata(L, 2, "torch.ByteTensor")) && (arg24->nDimension == 4)
&& (arg25 = luaT_toudata(L, 3, "torch.ByteTensor")) && (arg25->nDimension == 5)
&& (arg29 = lua_tostring(L, 4)) && (*arg29 == 'V' || *arg29 == 'F')
)
{
argset = 3;
arg21_idx = 1;
arg30 = &arg30_default;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] ByteTensor~3D ByteTensor~3D [(V|F)] | [*ByteTensor*] ByteTensor~4D ByteTensor~4D [(V|F)] | [*ByteTensor*] ByteTensor~4D ByteTensor~5D [(V|F)]", type_buf);
}
if(argset == 1)
{
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THByteTensor_conv3Dmul(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10);
return 1;
}
else if(argset == 2)
{
if(arg11_idx)
lua_pushvalue(L, arg11_idx);
else
luaT_pushudata(L, arg11, "torch.ByteTensor");
THByteTensor_conv3Dcmul(arg11,arg12,arg13,arg14,arg15,arg16,arg17,arg18,arg19,arg20);
return 1;
}
else if(argset == 3)
{
if(arg21_idx)
lua_pushvalue(L, arg21_idx);
else
luaT_pushudata(L, arg21, "torch.ByteTensor");
THByteTensor_conv3Dmv(arg21,arg22,arg23,arg24,arg25,arg26,arg27,arg28,arg29,arg30);
return 1;
}
return 0;
}

static int m_torch_ByteTensor_lt(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
unsigned char arg3 = 0;
THByteTensor *arg4 = NULL;
int arg4_idx = 0;
THByteTensor *arg5 = NULL;
unsigned char arg6 = 0;
THByteTensor *arg7 = NULL;
int arg7_idx = 0;
THByteTensor *arg8 = NULL;
THByteTensor *arg9 = NULL;
THByteTensor *arg10 = NULL;
int arg10_idx = 0;
THByteTensor *arg11 = NULL;
THByteTensor *arg12 = NULL;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 1;
arg3 = (unsigned char)lua_tonumber(L, 2);
arg1 = THByteTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 1;
arg1_idx = 1;
arg3 = (unsigned char)lua_tonumber(L, 3);
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg4_idx = 1;
arg6 = (unsigned char)lua_tonumber(L, 3);
}
else if(narg == 2
&& (arg8 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg9 = luaT_toudata(L, 2, "torch.ByteTensor"))
)
{
argset = 3;
arg7 = THByteTensor_new();
}
else if(narg == 3
&& (arg7 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg8 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& (arg9 = luaT_toudata(L, 3, "torch.ByteTensor"))
)
{
argset = 3;
arg7_idx = 1;
}
else if(narg == 3
&& (arg10 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg11 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& (arg12 = luaT_toudata(L, 3, "torch.ByteTensor"))
)
{
argset = 4;
arg10_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] ByteTensor unsigned char | *ByteTensor* ByteTensor unsigned char | [*ByteTensor*] ByteTensor ByteTensor | *ByteTensor* ByteTensor ByteTensor", type_buf);
}
if(argset == 1)
{
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THByteTensor_ltValue(arg1,arg2,arg3);
return 1;
}
else if(argset == 2)
{
lua_pushvalue(L, arg4_idx);
THByteTensor_ltValueT(arg4,arg5,arg6);
return 1;
}
else if(argset == 3)
{
if(arg7_idx)
lua_pushvalue(L, arg7_idx);
else
luaT_pushudata(L, arg7, "torch.ByteTensor");
THByteTensor_ltTensor(arg7,arg8,arg9);
return 1;
}
else if(argset == 4)
{
lua_pushvalue(L, arg10_idx);
THByteTensor_ltTensorT(arg10,arg11,arg12);
return 1;
}
return 0;
}

static int m_torch_ByteTensor_gt(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
unsigned char arg3 = 0;
THByteTensor *arg4 = NULL;
int arg4_idx = 0;
THByteTensor *arg5 = NULL;
unsigned char arg6 = 0;
THByteTensor *arg7 = NULL;
int arg7_idx = 0;
THByteTensor *arg8 = NULL;
THByteTensor *arg9 = NULL;
THByteTensor *arg10 = NULL;
int arg10_idx = 0;
THByteTensor *arg11 = NULL;
THByteTensor *arg12 = NULL;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 1;
arg3 = (unsigned char)lua_tonumber(L, 2);
arg1 = THByteTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 1;
arg1_idx = 1;
arg3 = (unsigned char)lua_tonumber(L, 3);
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg4_idx = 1;
arg6 = (unsigned char)lua_tonumber(L, 3);
}
else if(narg == 2
&& (arg8 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg9 = luaT_toudata(L, 2, "torch.ByteTensor"))
)
{
argset = 3;
arg7 = THByteTensor_new();
}
else if(narg == 3
&& (arg7 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg8 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& (arg9 = luaT_toudata(L, 3, "torch.ByteTensor"))
)
{
argset = 3;
arg7_idx = 1;
}
else if(narg == 3
&& (arg10 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg11 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& (arg12 = luaT_toudata(L, 3, "torch.ByteTensor"))
)
{
argset = 4;
arg10_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] ByteTensor unsigned char | *ByteTensor* ByteTensor unsigned char | [*ByteTensor*] ByteTensor ByteTensor | *ByteTensor* ByteTensor ByteTensor", type_buf);
}
if(argset == 1)
{
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THByteTensor_gtValue(arg1,arg2,arg3);
return 1;
}
else if(argset == 2)
{
lua_pushvalue(L, arg4_idx);
THByteTensor_gtValueT(arg4,arg5,arg6);
return 1;
}
else if(argset == 3)
{
if(arg7_idx)
lua_pushvalue(L, arg7_idx);
else
luaT_pushudata(L, arg7, "torch.ByteTensor");
THByteTensor_gtTensor(arg7,arg8,arg9);
return 1;
}
else if(argset == 4)
{
lua_pushvalue(L, arg10_idx);
THByteTensor_gtTensorT(arg10,arg11,arg12);
return 1;
}
return 0;
}

static int m_torch_ByteTensor_le(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
unsigned char arg3 = 0;
THByteTensor *arg4 = NULL;
int arg4_idx = 0;
THByteTensor *arg5 = NULL;
unsigned char arg6 = 0;
THByteTensor *arg7 = NULL;
int arg7_idx = 0;
THByteTensor *arg8 = NULL;
THByteTensor *arg9 = NULL;
THByteTensor *arg10 = NULL;
int arg10_idx = 0;
THByteTensor *arg11 = NULL;
THByteTensor *arg12 = NULL;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 1;
arg3 = (unsigned char)lua_tonumber(L, 2);
arg1 = THByteTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 1;
arg1_idx = 1;
arg3 = (unsigned char)lua_tonumber(L, 3);
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg4_idx = 1;
arg6 = (unsigned char)lua_tonumber(L, 3);
}
else if(narg == 2
&& (arg8 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg9 = luaT_toudata(L, 2, "torch.ByteTensor"))
)
{
argset = 3;
arg7 = THByteTensor_new();
}
else if(narg == 3
&& (arg7 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg8 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& (arg9 = luaT_toudata(L, 3, "torch.ByteTensor"))
)
{
argset = 3;
arg7_idx = 1;
}
else if(narg == 3
&& (arg10 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg11 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& (arg12 = luaT_toudata(L, 3, "torch.ByteTensor"))
)
{
argset = 4;
arg10_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] ByteTensor unsigned char | *ByteTensor* ByteTensor unsigned char | [*ByteTensor*] ByteTensor ByteTensor | *ByteTensor* ByteTensor ByteTensor", type_buf);
}
if(argset == 1)
{
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THByteTensor_leValue(arg1,arg2,arg3);
return 1;
}
else if(argset == 2)
{
lua_pushvalue(L, arg4_idx);
THByteTensor_leValueT(arg4,arg5,arg6);
return 1;
}
else if(argset == 3)
{
if(arg7_idx)
lua_pushvalue(L, arg7_idx);
else
luaT_pushudata(L, arg7, "torch.ByteTensor");
THByteTensor_leTensor(arg7,arg8,arg9);
return 1;
}
else if(argset == 4)
{
lua_pushvalue(L, arg10_idx);
THByteTensor_leTensorT(arg10,arg11,arg12);
return 1;
}
return 0;
}

static int m_torch_ByteTensor_ge(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
unsigned char arg3 = 0;
THByteTensor *arg4 = NULL;
int arg4_idx = 0;
THByteTensor *arg5 = NULL;
unsigned char arg6 = 0;
THByteTensor *arg7 = NULL;
int arg7_idx = 0;
THByteTensor *arg8 = NULL;
THByteTensor *arg9 = NULL;
THByteTensor *arg10 = NULL;
int arg10_idx = 0;
THByteTensor *arg11 = NULL;
THByteTensor *arg12 = NULL;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 1;
arg3 = (unsigned char)lua_tonumber(L, 2);
arg1 = THByteTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 1;
arg1_idx = 1;
arg3 = (unsigned char)lua_tonumber(L, 3);
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg4_idx = 1;
arg6 = (unsigned char)lua_tonumber(L, 3);
}
else if(narg == 2
&& (arg8 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg9 = luaT_toudata(L, 2, "torch.ByteTensor"))
)
{
argset = 3;
arg7 = THByteTensor_new();
}
else if(narg == 3
&& (arg7 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg8 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& (arg9 = luaT_toudata(L, 3, "torch.ByteTensor"))
)
{
argset = 3;
arg7_idx = 1;
}
else if(narg == 3
&& (arg10 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg11 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& (arg12 = luaT_toudata(L, 3, "torch.ByteTensor"))
)
{
argset = 4;
arg10_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] ByteTensor unsigned char | *ByteTensor* ByteTensor unsigned char | [*ByteTensor*] ByteTensor ByteTensor | *ByteTensor* ByteTensor ByteTensor", type_buf);
}
if(argset == 1)
{
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THByteTensor_geValue(arg1,arg2,arg3);
return 1;
}
else if(argset == 2)
{
lua_pushvalue(L, arg4_idx);
THByteTensor_geValueT(arg4,arg5,arg6);
return 1;
}
else if(argset == 3)
{
if(arg7_idx)
lua_pushvalue(L, arg7_idx);
else
luaT_pushudata(L, arg7, "torch.ByteTensor");
THByteTensor_geTensor(arg7,arg8,arg9);
return 1;
}
else if(argset == 4)
{
lua_pushvalue(L, arg10_idx);
THByteTensor_geTensorT(arg10,arg11,arg12);
return 1;
}
return 0;
}

static int m_torch_ByteTensor_eq(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
unsigned char arg3 = 0;
THByteTensor *arg4 = NULL;
int arg4_idx = 0;
THByteTensor *arg5 = NULL;
unsigned char arg6 = 0;
THByteTensor *arg7 = NULL;
int arg7_idx = 0;
THByteTensor *arg8 = NULL;
THByteTensor *arg9 = NULL;
THByteTensor *arg10 = NULL;
int arg10_idx = 0;
THByteTensor *arg11 = NULL;
THByteTensor *arg12 = NULL;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 1;
arg3 = (unsigned char)lua_tonumber(L, 2);
arg1 = THByteTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 1;
arg1_idx = 1;
arg3 = (unsigned char)lua_tonumber(L, 3);
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg4_idx = 1;
arg6 = (unsigned char)lua_tonumber(L, 3);
}
else if(narg == 2
&& (arg8 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg9 = luaT_toudata(L, 2, "torch.ByteTensor"))
)
{
argset = 3;
arg7 = THByteTensor_new();
}
else if(narg == 3
&& (arg7 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg8 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& (arg9 = luaT_toudata(L, 3, "torch.ByteTensor"))
)
{
argset = 3;
arg7_idx = 1;
}
else if(narg == 3
&& (arg10 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg11 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& (arg12 = luaT_toudata(L, 3, "torch.ByteTensor"))
)
{
argset = 4;
arg10_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] ByteTensor unsigned char | *ByteTensor* ByteTensor unsigned char | [*ByteTensor*] ByteTensor ByteTensor | *ByteTensor* ByteTensor ByteTensor", type_buf);
}
if(argset == 1)
{
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THByteTensor_eqValue(arg1,arg2,arg3);
return 1;
}
else if(argset == 2)
{
lua_pushvalue(L, arg4_idx);
THByteTensor_eqValueT(arg4,arg5,arg6);
return 1;
}
else if(argset == 3)
{
if(arg7_idx)
lua_pushvalue(L, arg7_idx);
else
luaT_pushudata(L, arg7, "torch.ByteTensor");
THByteTensor_eqTensor(arg7,arg8,arg9);
return 1;
}
else if(argset == 4)
{
lua_pushvalue(L, arg10_idx);
THByteTensor_eqTensorT(arg10,arg11,arg12);
return 1;
}
return 0;
}

static int m_torch_ByteTensor_ne(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
unsigned char arg3 = 0;
THByteTensor *arg4 = NULL;
int arg4_idx = 0;
THByteTensor *arg5 = NULL;
unsigned char arg6 = 0;
THByteTensor *arg7 = NULL;
int arg7_idx = 0;
THByteTensor *arg8 = NULL;
THByteTensor *arg9 = NULL;
THByteTensor *arg10 = NULL;
int arg10_idx = 0;
THByteTensor *arg11 = NULL;
THByteTensor *arg12 = NULL;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 1;
arg3 = (unsigned char)lua_tonumber(L, 2);
arg1 = THByteTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 1;
arg1_idx = 1;
arg3 = (unsigned char)lua_tonumber(L, 3);
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg4_idx = 1;
arg6 = (unsigned char)lua_tonumber(L, 3);
}
else if(narg == 2
&& (arg8 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg9 = luaT_toudata(L, 2, "torch.ByteTensor"))
)
{
argset = 3;
arg7 = THByteTensor_new();
}
else if(narg == 3
&& (arg7 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg8 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& (arg9 = luaT_toudata(L, 3, "torch.ByteTensor"))
)
{
argset = 3;
arg7_idx = 1;
}
else if(narg == 3
&& (arg10 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg11 = luaT_toudata(L, 2, "torch.ByteTensor"))
&& (arg12 = luaT_toudata(L, 3, "torch.ByteTensor"))
)
{
argset = 4;
arg10_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] ByteTensor unsigned char | *ByteTensor* ByteTensor unsigned char | [*ByteTensor*] ByteTensor ByteTensor | *ByteTensor* ByteTensor ByteTensor", type_buf);
}
if(argset == 1)
{
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THByteTensor_neValue(arg1,arg2,arg3);
return 1;
}
else if(argset == 2)
{
lua_pushvalue(L, arg4_idx);
THByteTensor_neValueT(arg4,arg5,arg6);
return 1;
}
else if(argset == 3)
{
if(arg7_idx)
lua_pushvalue(L, arg7_idx);
else
luaT_pushudata(L, arg7, "torch.ByteTensor");
THByteTensor_neTensor(arg7,arg8,arg9);
return 1;
}
else if(argset == 4)
{
lua_pushvalue(L, arg10_idx);
THByteTensor_neTensorT(arg10,arg11,arg12);
return 1;
}
return 0;
}

static int m_torch_ByteTensor_nonzero(lua_State *L)
{
int narg = lua_gettop(L);
THLongTensor *arg1 = NULL;
int arg1_idx = 0;
THByteTensor *arg2 = NULL;
if(narg == 1
&& (arg2 = luaT_toudata(L, 1, "torch.ByteTensor"))
)
{
arg1 = THLongTensor_new();
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ByteTensor"))
)
{
THLongTensor_add(arg1, arg1, -1);
arg1_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*LongTensor*] ByteTensor", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.LongTensor");
THByteTensor_nonzero(arg1,arg2);
THLongTensor_add(arg1, arg1, 1);
return 1;
}

static int m_torch_ByteTensor_all(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg2 = 0;
if(narg == 1
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
)
{
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: ByteTensor", type_buf);
}
arg2 = THByteTensor_logicalall(arg1);
lua_pushboolean(L, arg2);
return 1;
}

static int m_torch_ByteTensor_any(lua_State *L)
{
int narg = lua_gettop(L);
THByteTensor *arg1 = NULL;
int arg2 = 0;
if(narg == 1
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
)
{
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: ByteTensor", type_buf);
}
arg2 = THByteTensor_logicalany(arg1);
lua_pushboolean(L, arg2);
return 1;
}

static const struct luaL_Reg m_torch_ByteTensorMath__ [] = {
{"zero", m_torch_ByteTensor_zero},
{"fill", m_torch_ByteTensor_fill},
{"zeros", m_torch_ByteTensor_zeros},
{"ones", m_torch_ByteTensor_ones},
{"reshape", m_torch_ByteTensor_reshape},
{"gather", m_torch_ByteTensor_gather},
{"scatter", m_torch_ByteTensor_scatter},
{"dot", m_torch_ByteTensor_dot},
{"equal", m_torch_ByteTensor_equal},
{"add", m_torch_ByteTensor_add},
{"csub", m_torch_ByteTensor_csub},
{"mul", m_torch_ByteTensor_mul},
{"div", m_torch_ByteTensor_div},
{"lshift", m_torch_ByteTensor_lshift},
{"rshift", m_torch_ByteTensor_rshift},
{"fmod", m_torch_ByteTensor_fmod},
{"remainder", m_torch_ByteTensor_remainder},
{"bitand", m_torch_ByteTensor_bitand},
{"bitor", m_torch_ByteTensor_bitor},
{"bitxor", m_torch_ByteTensor_bitxor},
{"mod", m_torch_ByteTensor_mod},
{"clamp", m_torch_ByteTensor_clamp},
{"match", m_torch_ByteTensor_match},
{"cmul", m_torch_ByteTensor_cmul},
{"cpow", m_torch_ByteTensor_cpow},
{"cdiv", m_torch_ByteTensor_cdiv},
{"clshift", m_torch_ByteTensor_clshift},
{"crshift", m_torch_ByteTensor_crshift},
{"cfmod", m_torch_ByteTensor_cfmod},
{"cremainder", m_torch_ByteTensor_cremainder},
{"cbitand", m_torch_ByteTensor_cbitand},
{"cbitor", m_torch_ByteTensor_cbitor},
{"cbitxor", m_torch_ByteTensor_cbitxor},
{"cmod", m_torch_ByteTensor_cmod},
{"addcmul", m_torch_ByteTensor_addcmul},
{"addcdiv", m_torch_ByteTensor_addcdiv},
{"mv", m_torch_ByteTensor_mv},
{"mm", m_torch_ByteTensor_mm},
{"bmm", m_torch_ByteTensor_bmm},
{"ger", m_torch_ByteTensor_ger},
{"addmv", m_torch_ByteTensor_addmv},
{"addmm", m_torch_ByteTensor_addmm},
{"addr", m_torch_ByteTensor_addr},
{"addbmm", m_torch_ByteTensor_addbmm},
{"baddbmm", m_torch_ByteTensor_baddbmm},
{"numel", m_torch_ByteTensor_numel},
{"cumsum", m_torch_ByteTensor_cumsum},
{"cumprod", m_torch_ByteTensor_cumprod},
{"sum", m_torch_ByteTensor_sum},
{"prod", m_torch_ByteTensor_prod},
{"min", m_torch_ByteTensor_min},
{"max", m_torch_ByteTensor_max},
{"cmin", m_torch_ByteTensor_cmin},
{"cmax", m_torch_ByteTensor_cmax},
{"trace", m_torch_ByteTensor_trace},
{"cross", m_torch_ByteTensor_cross},
{"diag", m_torch_ByteTensor_diag},
{"eye", m_torch_ByteTensor_eye},
{"range", m_torch_ByteTensor_range},
{"randperm", m_torch_ByteTensor_randperm},
{"sort", m_torch_ByteTensor_sort},
{"topk", m_torch_ByteTensor_topk},
{"kthvalue", m_torch_ByteTensor_kthvalue},
{"mode", m_torch_ByteTensor_mode},
{"median", m_torch_ByteTensor_median},
{"tril", m_torch_ByteTensor_tril},
{"triu", m_torch_ByteTensor_triu},
{"cat", m_torch_ByteTensor_cat},
{"random", m_torch_ByteTensor_random},
{"geometric", m_torch_ByteTensor_geometric},
{"bernoulli", m_torch_ByteTensor_bernoulli},
{"squeeze", m_torch_ByteTensor_squeeze},
{"sign", m_torch_ByteTensor_sign},
{"conv2", m_torch_ByteTensor_conv2},
{"xcorr2", m_torch_ByteTensor_xcorr2},
{"conv3", m_torch_ByteTensor_conv3},
{"xcorr3", m_torch_ByteTensor_xcorr3},
{"lt", m_torch_ByteTensor_lt},
{"gt", m_torch_ByteTensor_gt},
{"le", m_torch_ByteTensor_le},
{"ge", m_torch_ByteTensor_ge},
{"eq", m_torch_ByteTensor_eq},
{"ne", m_torch_ByteTensor_ne},
{"nonzero", m_torch_ByteTensor_nonzero},
{"all", m_torch_ByteTensor_all},
{"any", m_torch_ByteTensor_any},
{NULL, NULL}
};

static const struct luaL_Reg torch_ByteTensorMath__ [] = {
{"zero", torch_ByteTensor_zero},
{"fill", torch_ByteTensor_fill},
{"zeros", torch_ByteTensor_zeros},
{"ones", torch_ByteTensor_ones},
{"reshape", torch_ByteTensor_reshape},
{"gather", torch_ByteTensor_gather},
{"scatter", torch_ByteTensor_scatter},
{"dot", torch_ByteTensor_dot},
{"equal", torch_ByteTensor_equal},
{"add", torch_ByteTensor_add},
{"csub", torch_ByteTensor_csub},
{"mul", torch_ByteTensor_mul},
{"div", torch_ByteTensor_div},
{"lshift", torch_ByteTensor_lshift},
{"rshift", torch_ByteTensor_rshift},
{"fmod", torch_ByteTensor_fmod},
{"remainder", torch_ByteTensor_remainder},
{"bitand", torch_ByteTensor_bitand},
{"bitor", torch_ByteTensor_bitor},
{"bitxor", torch_ByteTensor_bitxor},
{"mod", torch_ByteTensor_mod},
{"clamp", torch_ByteTensor_clamp},
{"match", torch_ByteTensor_match},
{"cmul", torch_ByteTensor_cmul},
{"cpow", torch_ByteTensor_cpow},
{"cdiv", torch_ByteTensor_cdiv},
{"clshift", torch_ByteTensor_clshift},
{"crshift", torch_ByteTensor_crshift},
{"cfmod", torch_ByteTensor_cfmod},
{"cremainder", torch_ByteTensor_cremainder},
{"cbitand", torch_ByteTensor_cbitand},
{"cbitor", torch_ByteTensor_cbitor},
{"cbitxor", torch_ByteTensor_cbitxor},
{"cmod", torch_ByteTensor_cmod},
{"addcmul", torch_ByteTensor_addcmul},
{"addcdiv", torch_ByteTensor_addcdiv},
{"mv", torch_ByteTensor_mv},
{"mm", torch_ByteTensor_mm},
{"bmm", torch_ByteTensor_bmm},
{"ger", torch_ByteTensor_ger},
{"addmv", torch_ByteTensor_addmv},
{"addmm", torch_ByteTensor_addmm},
{"addr", torch_ByteTensor_addr},
{"addbmm", torch_ByteTensor_addbmm},
{"baddbmm", torch_ByteTensor_baddbmm},
{"numel", torch_ByteTensor_numel},
{"cumsum", torch_ByteTensor_cumsum},
{"cumprod", torch_ByteTensor_cumprod},
{"sum", torch_ByteTensor_sum},
{"prod", torch_ByteTensor_prod},
{"min", torch_ByteTensor_min},
{"max", torch_ByteTensor_max},
{"cmin", torch_ByteTensor_cmin},
{"cmax", torch_ByteTensor_cmax},
{"trace", torch_ByteTensor_trace},
{"cross", torch_ByteTensor_cross},
{"diag", torch_ByteTensor_diag},
{"eye", torch_ByteTensor_eye},
{"range", torch_ByteTensor_range},
{"randperm", torch_ByteTensor_randperm},
{"sort", torch_ByteTensor_sort},
{"topk", torch_ByteTensor_topk},
{"kthvalue", torch_ByteTensor_kthvalue},
{"mode", torch_ByteTensor_mode},
{"median", torch_ByteTensor_median},
{"tril", torch_ByteTensor_tril},
{"triu", torch_ByteTensor_triu},
{"cat", torch_ByteTensor_cat},
{"random", torch_ByteTensor_random},
{"geometric", torch_ByteTensor_geometric},
{"bernoulli", torch_ByteTensor_bernoulli},
{"squeeze", torch_ByteTensor_squeeze},
{"sign", torch_ByteTensor_sign},
{"conv2", torch_ByteTensor_conv2},
{"xcorr2", torch_ByteTensor_xcorr2},
{"conv3", torch_ByteTensor_conv3},
{"xcorr3", torch_ByteTensor_xcorr3},
{"lt", torch_ByteTensor_lt},
{"gt", torch_ByteTensor_gt},
{"le", torch_ByteTensor_le},
{"ge", torch_ByteTensor_ge},
{"eq", torch_ByteTensor_eq},
{"ne", torch_ByteTensor_ne},
{"nonzero", torch_ByteTensor_nonzero},
{"all", torch_ByteTensor_all},
{"any", torch_ByteTensor_any},
{NULL, NULL}
};

static void torch_ByteTensorMath_init(lua_State *L)
{
  luaT_pushmetatable(L, "torch.ByteTensor");

  /* register methods */
  luaT_setfuncs(L, m_torch_ByteTensorMath__, 0);

  /* register functions into the "torch" field of the tensor metaclass */
  lua_pushstring(L, "torch");
  lua_newtable(L);
  luaT_setfuncs(L, torch_ByteTensorMath__, 0);
  lua_rawset(L, -3);
  lua_pop(L, 1);
}

static int torch_CharTensor_zero(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
if(narg == 1
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
)
{
arg1_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *CharTensor*", type_buf);
}
lua_pushvalue(L, arg1_idx);
THCharTensor_zero(arg1);
return 1;
}

static int torch_CharTensor_fill(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
char arg2 = 0;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
)
{
arg1_idx = 1;
arg2 = (char)lua_tonumber(L, 2);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *CharTensor* char", type_buf);
}
lua_pushvalue(L, arg1_idx);
THCharTensor_fill(arg1,arg2);
return 1;
}

static int torch_CharTensor_zeros(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THLongStorage *arg2 = NULL;
if(narg >= 1
&& torch_islongargs(L, 1)
)
{
arg2 = torch_checklongargs(L, 1);
arg1 = THCharTensor_new();
}
else if(narg >= 2
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& torch_islongargs(L, 2)
)
{
arg1_idx = 1;
arg2 = torch_checklongargs(L, 2);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*CharTensor*] (LongStorage | dim1 [dim2...])", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.CharTensor");
THCharTensor_zeros(arg1,arg2);
THLongStorage_free(arg2);
return 1;
}

static int torch_CharTensor_ones(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THLongStorage *arg2 = NULL;
if(narg >= 1
&& torch_islongargs(L, 1)
)
{
arg2 = torch_checklongargs(L, 1);
arg1 = THCharTensor_new();
}
else if(narg >= 2
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& torch_islongargs(L, 2)
)
{
arg1_idx = 1;
arg2 = torch_checklongargs(L, 2);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*CharTensor*] (LongStorage | dim1 [dim2...])", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.CharTensor");
THCharTensor_ones(arg1,arg2);
THLongStorage_free(arg2);
return 1;
}

static int torch_CharTensor_reshape(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
THLongStorage *arg3 = NULL;
if(narg >= 2
&& (arg2 = luaT_toudata(L, 1, "torch.CharTensor"))
&& torch_islongargs(L, 2)
)
{
arg3 = torch_checklongargs(L, 2);
arg1 = THCharTensor_new();
}
else if(narg >= 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& torch_islongargs(L, 3)
)
{
arg1_idx = 1;
arg3 = torch_checklongargs(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*CharTensor*] CharTensor (LongStorage | dim1 [dim2...])", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.CharTensor");
THCharTensor_reshape(arg1,arg2,arg3);
THLongStorage_free(arg3);
return 1;
}

static int torch_CharTensor_gather(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
long arg3 = 0;
THLongTensor *arg4 = NULL;
if(narg == 3
&& (arg2 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
&& (arg4 = luaT_toudata(L, 3, "torch.LongTensor"))
)
{
arg3 = (long)lua_tonumber(L, 2)-1;
arg1 = THCharTensor_new();
THLongStorage* arg1_size = THLongTensor_newSizeOf(arg4);
THCharTensor_resize(arg1, arg1_size, NULL);
THLongStorage_free(arg1_size);
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
&& (arg4 = luaT_toudata(L, 4, "torch.LongTensor"))
)
{
arg1_idx = 1;
arg3 = (long)lua_tonumber(L, 3)-1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*CharTensor*] CharTensor index LongTensor", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.CharTensor");
THCharTensor_gather(arg1,arg2,arg3,arg4);
return 1;
}

static int torch_CharTensor_scatter(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
long arg2 = 0;
THLongTensor *arg3 = NULL;
THCharTensor *arg4 = NULL;
THCharTensor *arg5 = NULL;
int arg5_idx = 0;
long arg6 = 0;
THLongTensor *arg7 = NULL;
char arg8 = 0;
if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
&& (arg3 = luaT_toudata(L, 3, "torch.LongTensor"))
&& (arg4 = luaT_toudata(L, 4, "torch.CharTensor"))
)
{
argset = 1;
arg1_idx = 1;
arg2 = (long)lua_tonumber(L, 2)-1;
}
else if(narg == 4
&& (arg5 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
&& (arg7 = luaT_toudata(L, 3, "torch.LongTensor"))
&& lua_isnumber(L, 4)
)
{
argset = 2;
arg5_idx = 1;
arg6 = (long)lua_tonumber(L, 2)-1;
arg8 = (char)lua_tonumber(L, 4);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *CharTensor* index LongTensor CharTensor | *CharTensor* index LongTensor char", type_buf);
}
if(argset == 1)
{
lua_pushvalue(L, arg1_idx);
THCharTensor_scatter(arg1,arg2,arg3,arg4);
return 1;
}
else if(argset == 2)
{
lua_pushvalue(L, arg5_idx);
THCharTensor_scatterFill(arg5,arg6,arg7,arg8);
return 1;
}
return 0;
}

static int torch_CharTensor_dot(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
THCharTensor *arg2 = NULL;
long arg3 = 0;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
)
{
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: CharTensor CharTensor", type_buf);
}
arg3 = THCharTensor_dot(arg1,arg2);
lua_pushnumber(L, (lua_Number)arg3);
return 1;
}

static int torch_CharTensor_equal(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
THCharTensor *arg2 = NULL;
int arg3 = 0;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
)
{
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: CharTensor CharTensor", type_buf);
}
arg3 = THCharTensor_equal(arg1,arg2);
lua_pushboolean(L, arg3);
return 1;
}

static int torch_CharTensor_add(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
char arg3 = 0;
THCharTensor *arg4 = NULL;
int arg4_idx = 0;
THCharTensor *arg5 = NULL;
char arg6 = 1;
THCharTensor *arg7 = NULL;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 1;
arg3 = (char)lua_tonumber(L, 2);
arg1 = THCharTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 1;
arg1_idx = 1;
arg3 = (char)lua_tonumber(L, 3);
}
else if(narg == 2
&& (arg5 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg7 = luaT_toudata(L, 2, "torch.CharTensor"))
)
{
argset = 2;
arg4 = THCharTensor_new();
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.CharTensor"))
&& (arg7 = luaT_toudata(L, 3, "torch.CharTensor"))
)
{
argset = 2;
arg4_idx = 1;
}
else if(narg == 3
&& (arg5 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
&& (arg7 = luaT_toudata(L, 3, "torch.CharTensor"))
)
{
argset = 2;
arg6 = (char)lua_tonumber(L, 2);
arg4 = THCharTensor_new();
}
else if(narg == 4
&& (arg4 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
&& (arg7 = luaT_toudata(L, 4, "torch.CharTensor"))
)
{
argset = 2;
arg4_idx = 1;
arg6 = (char)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*CharTensor*] CharTensor char | [*CharTensor*] CharTensor [char] CharTensor", type_buf);
}
if(argset == 1)
{
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.CharTensor");
THCharTensor_add(arg1,arg2,arg3);
return 1;
}
else if(argset == 2)
{
if(arg4_idx)
lua_pushvalue(L, arg4_idx);
else
luaT_pushudata(L, arg4, "torch.CharTensor");
THCharTensor_cadd(arg4,arg5,arg6,arg7);
return 1;
}
return 0;
}

static int torch_CharTensor_csub(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
char arg3 = 0;
THCharTensor *arg4 = NULL;
int arg4_idx = 0;
THCharTensor *arg5 = NULL;
char arg6 = 1;
THCharTensor *arg7 = NULL;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 1;
arg3 = (char)lua_tonumber(L, 2);
arg1 = THCharTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 1;
arg1_idx = 1;
arg3 = (char)lua_tonumber(L, 3);
}
else if(narg == 2
&& (arg5 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg7 = luaT_toudata(L, 2, "torch.CharTensor"))
)
{
argset = 2;
arg4 = THCharTensor_new();
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.CharTensor"))
&& (arg7 = luaT_toudata(L, 3, "torch.CharTensor"))
)
{
argset = 2;
arg4_idx = 1;
}
else if(narg == 3
&& (arg5 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
&& (arg7 = luaT_toudata(L, 3, "torch.CharTensor"))
)
{
argset = 2;
arg6 = (char)lua_tonumber(L, 2);
arg4 = THCharTensor_new();
}
else if(narg == 4
&& (arg4 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
&& (arg7 = luaT_toudata(L, 4, "torch.CharTensor"))
)
{
argset = 2;
arg4_idx = 1;
arg6 = (char)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*CharTensor*] CharTensor char | [*CharTensor*] CharTensor [char] CharTensor", type_buf);
}
if(argset == 1)
{
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.CharTensor");
THCharTensor_sub(arg1,arg2,arg3);
return 1;
}
else if(argset == 2)
{
if(arg4_idx)
lua_pushvalue(L, arg4_idx);
else
luaT_pushudata(L, arg4, "torch.CharTensor");
THCharTensor_csub(arg4,arg5,arg6,arg7);
return 1;
}
return 0;
}

static int torch_CharTensor_mul(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
char arg3 = 0;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
)
{
arg3 = (char)lua_tonumber(L, 2);
arg1 = THCharTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (char)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*CharTensor*] CharTensor char", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.CharTensor");
THCharTensor_mul(arg1,arg2,arg3);
return 1;
}

static int torch_CharTensor_div(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
char arg3 = 0;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
)
{
arg3 = (char)lua_tonumber(L, 2);
arg1 = THCharTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (char)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*CharTensor*] CharTensor char", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.CharTensor");
THCharTensor_div(arg1,arg2,arg3);
return 1;
}

static int torch_CharTensor_lshift(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
char arg3 = 0;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
)
{
arg3 = (char)lua_tonumber(L, 2);
arg1 = THCharTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (char)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*CharTensor*] CharTensor char", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.CharTensor");
THCharTensor_lshift(arg1,arg2,arg3);
return 1;
}

static int torch_CharTensor_rshift(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
char arg3 = 0;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
)
{
arg3 = (char)lua_tonumber(L, 2);
arg1 = THCharTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (char)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*CharTensor*] CharTensor char", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.CharTensor");
THCharTensor_rshift(arg1,arg2,arg3);
return 1;
}

static int torch_CharTensor_fmod(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
char arg3 = 0;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
)
{
arg3 = (char)lua_tonumber(L, 2);
arg1 = THCharTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (char)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*CharTensor*] CharTensor char", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.CharTensor");
THCharTensor_fmod(arg1,arg2,arg3);
return 1;
}

static int torch_CharTensor_remainder(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
char arg3 = 0;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
)
{
arg3 = (char)lua_tonumber(L, 2);
arg1 = THCharTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (char)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*CharTensor*] CharTensor char", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.CharTensor");
THCharTensor_remainder(arg1,arg2,arg3);
return 1;
}

static int torch_CharTensor_bitand(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
char arg3 = 0;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
)
{
arg3 = (char)lua_tonumber(L, 2);
arg1 = THCharTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (char)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*CharTensor*] CharTensor char", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.CharTensor");
THCharTensor_bitand(arg1,arg2,arg3);
return 1;
}

static int torch_CharTensor_bitor(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
char arg3 = 0;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
)
{
arg3 = (char)lua_tonumber(L, 2);
arg1 = THCharTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (char)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*CharTensor*] CharTensor char", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.CharTensor");
THCharTensor_bitor(arg1,arg2,arg3);
return 1;
}

static int torch_CharTensor_bitxor(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
char arg3 = 0;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
)
{
arg3 = (char)lua_tonumber(L, 2);
arg1 = THCharTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (char)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*CharTensor*] CharTensor char", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.CharTensor");
THCharTensor_bitxor(arg1,arg2,arg3);
return 1;
}

static int torch_CharTensor_mod(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
char arg3 = 0;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
)
{
arg3 = (char)lua_tonumber(L, 2);
arg1 = THCharTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (char)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*CharTensor*] CharTensor char", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.CharTensor");
THCharTensor_fmod(arg1,arg2,arg3);
return 1;
}

static int torch_CharTensor_clamp(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
char arg3 = 0;
char arg4 = 0;
if(narg == 3
&& (arg2 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
&& lua_isnumber(L, 3)
)
{
arg3 = (char)lua_tonumber(L, 2);
arg4 = (char)lua_tonumber(L, 3);
arg1 = THCharTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
&& lua_isnumber(L, 4)
)
{
arg1_idx = 1;
arg3 = (char)lua_tonumber(L, 3);
arg4 = (char)lua_tonumber(L, 4);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*CharTensor*] CharTensor char char", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.CharTensor");
THCharTensor_clamp(arg1,arg2,arg3,arg4);
return 1;
}

static int torch_CharTensor_match(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
THCharTensor *arg3 = NULL;
char arg4 = 1;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
)
{
arg1 = THCharTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
)
{
arg1_idx = 1;
}
else if(narg == 3
&& (arg2 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
arg4 = (char)lua_tonumber(L, 3);
arg1 = THCharTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
&& lua_isnumber(L, 4)
)
{
arg1_idx = 1;
arg4 = (char)lua_tonumber(L, 4);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*CharTensor*] CharTensor CharTensor [char]", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.CharTensor");
THCharTensor_match(arg1,arg2,arg3,arg4);
return 1;
}

static int torch_CharTensor_cmul(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
THCharTensor *arg3 = NULL;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
)
{
arg1 = THCharTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
)
{
arg1_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*CharTensor*] CharTensor CharTensor", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.CharTensor");
THCharTensor_cmul(arg1,arg2,arg3);
return 1;
}

static int torch_CharTensor_cpow(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
THCharTensor *arg3 = NULL;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
)
{
arg1 = THCharTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
)
{
arg1_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*CharTensor*] CharTensor CharTensor", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.CharTensor");
THCharTensor_cpow(arg1,arg2,arg3);
return 1;
}

static int torch_CharTensor_cdiv(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
THCharTensor *arg3 = NULL;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
)
{
arg1 = THCharTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
)
{
arg1_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*CharTensor*] CharTensor CharTensor", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.CharTensor");
THCharTensor_cdiv(arg1,arg2,arg3);
return 1;
}

static int torch_CharTensor_clshift(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
THCharTensor *arg3 = NULL;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
)
{
arg1 = THCharTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
)
{
arg1_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*CharTensor*] CharTensor CharTensor", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.CharTensor");
THCharTensor_clshift(arg1,arg2,arg3);
return 1;
}

static int torch_CharTensor_crshift(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
THCharTensor *arg3 = NULL;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
)
{
arg1 = THCharTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
)
{
arg1_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*CharTensor*] CharTensor CharTensor", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.CharTensor");
THCharTensor_crshift(arg1,arg2,arg3);
return 1;
}

static int torch_CharTensor_cfmod(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
THCharTensor *arg3 = NULL;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
)
{
arg1 = THCharTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
)
{
arg1_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*CharTensor*] CharTensor CharTensor", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.CharTensor");
THCharTensor_cfmod(arg1,arg2,arg3);
return 1;
}

static int torch_CharTensor_cremainder(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
THCharTensor *arg3 = NULL;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
)
{
arg1 = THCharTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
)
{
arg1_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*CharTensor*] CharTensor CharTensor", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.CharTensor");
THCharTensor_cremainder(arg1,arg2,arg3);
return 1;
}

static int torch_CharTensor_cbitand(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
THCharTensor *arg3 = NULL;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
)
{
arg1 = THCharTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
)
{
arg1_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*CharTensor*] CharTensor CharTensor", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.CharTensor");
THCharTensor_cbitand(arg1,arg2,arg3);
return 1;
}

static int torch_CharTensor_cbitor(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
THCharTensor *arg3 = NULL;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
)
{
arg1 = THCharTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
)
{
arg1_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*CharTensor*] CharTensor CharTensor", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.CharTensor");
THCharTensor_cbitor(arg1,arg2,arg3);
return 1;
}

static int torch_CharTensor_cbitxor(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
THCharTensor *arg3 = NULL;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
)
{
arg1 = THCharTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
)
{
arg1_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*CharTensor*] CharTensor CharTensor", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.CharTensor");
THCharTensor_cbitxor(arg1,arg2,arg3);
return 1;
}

static int torch_CharTensor_cmod(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
THCharTensor *arg3 = NULL;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
)
{
arg1 = THCharTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
)
{
arg1_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*CharTensor*] CharTensor CharTensor", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.CharTensor");
THCharTensor_cfmod(arg1,arg2,arg3);
return 1;
}

static int torch_CharTensor_addcmul(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
char arg3 = 1;
THCharTensor *arg4 = NULL;
THCharTensor *arg5 = NULL;
if(narg == 3
&& (arg2 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg4 = luaT_toudata(L, 2, "torch.CharTensor"))
&& (arg5 = luaT_toudata(L, 3, "torch.CharTensor"))
)
{
arg1 = THCharTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& (arg4 = luaT_toudata(L, 3, "torch.CharTensor"))
&& (arg5 = luaT_toudata(L, 4, "torch.CharTensor"))
)
{
arg1_idx = 1;
}
else if(narg == 4
&& (arg2 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
&& (arg4 = luaT_toudata(L, 3, "torch.CharTensor"))
&& (arg5 = luaT_toudata(L, 4, "torch.CharTensor"))
)
{
arg3 = (char)lua_tonumber(L, 2);
arg1 = THCharTensor_new();
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
&& (arg4 = luaT_toudata(L, 4, "torch.CharTensor"))
&& (arg5 = luaT_toudata(L, 5, "torch.CharTensor"))
)
{
arg1_idx = 1;
arg3 = (char)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*CharTensor*] CharTensor [char] CharTensor CharTensor", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.CharTensor");
THCharTensor_addcmul(arg1,arg2,arg3,arg4,arg5);
return 1;
}

static int torch_CharTensor_addcdiv(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
char arg3 = 1;
THCharTensor *arg4 = NULL;
THCharTensor *arg5 = NULL;
if(narg == 3
&& (arg2 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg4 = luaT_toudata(L, 2, "torch.CharTensor"))
&& (arg5 = luaT_toudata(L, 3, "torch.CharTensor"))
)
{
arg1 = THCharTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& (arg4 = luaT_toudata(L, 3, "torch.CharTensor"))
&& (arg5 = luaT_toudata(L, 4, "torch.CharTensor"))
)
{
arg1_idx = 1;
}
else if(narg == 4
&& (arg2 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
&& (arg4 = luaT_toudata(L, 3, "torch.CharTensor"))
&& (arg5 = luaT_toudata(L, 4, "torch.CharTensor"))
)
{
arg3 = (char)lua_tonumber(L, 2);
arg1 = THCharTensor_new();
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
&& (arg4 = luaT_toudata(L, 4, "torch.CharTensor"))
&& (arg5 = luaT_toudata(L, 5, "torch.CharTensor"))
)
{
arg1_idx = 1;
arg3 = (char)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*CharTensor*] CharTensor [char] CharTensor CharTensor", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.CharTensor");
THCharTensor_addcdiv(arg1,arg2,arg3,arg4,arg5);
return 1;
}

static int torch_CharTensor_mv(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
char arg2 = 0;
THCharTensor *arg3 = NULL;
char arg4 = 1;
THCharTensor *arg5 = NULL;
THCharTensor *arg6 = NULL;
if(narg == 2
&& (arg5 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg6->nDimension == 1)
)
{
arg1 = THCharTensor_new();
THCharTensor_resize1d(arg1, arg5->size[0]);
arg3 = arg1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg6->nDimension == 1)
)
{
arg1_idx = 1;
arg3 = arg1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*CharTensor*] CharTensor~2D CharTensor~1D", type_buf);
}
THCharTensor_zero(arg1);
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.CharTensor");
THCharTensor_addmv(arg1,arg2,arg3,arg4,arg5,arg6);
return 1;
}

static int torch_CharTensor_mm(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
char arg2 = 0;
THCharTensor *arg3 = NULL;
char arg4 = 1;
THCharTensor *arg5 = NULL;
THCharTensor *arg6 = NULL;
if(narg == 2
&& (arg5 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg6->nDimension == 2)
)
{
arg1 = THCharTensor_new();
THCharTensor_resize2d(arg1, arg5->size[0], arg6->size[1]);
arg3 = arg1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg6->nDimension == 2)
)
{
arg1_idx = 1;
arg3 = arg1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*CharTensor*] CharTensor~2D CharTensor~2D", type_buf);
}
THCharTensor_zero(arg1);
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.CharTensor");
THCharTensor_addmm(arg1,arg2,arg3,arg4,arg5,arg6);
return 1;
}

static int torch_CharTensor_bmm(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
char arg2 = 0;
THCharTensor *arg3 = NULL;
char arg4 = 1;
THCharTensor *arg5 = NULL;
THCharTensor *arg6 = NULL;
if(narg == 2
&& (arg5 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg5->nDimension == 3)
&& (arg6 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg6->nDimension == 3)
)
{
arg1 = THCharTensor_new();
THCharTensor_resize3d(arg1, arg5->size[0], arg5->size[1], arg6->size[2]);
arg3 = arg1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg5->nDimension == 3)
&& (arg6 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg6->nDimension == 3)
)
{
arg1_idx = 1;
arg3 = arg1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*CharTensor*] CharTensor~3D CharTensor~3D", type_buf);
}
THCharTensor_zero(arg1);
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.CharTensor");
THCharTensor_baddbmm(arg1,arg2,arg3,arg4,arg5,arg6);
return 1;
}

static int torch_CharTensor_ger(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
char arg2 = 1;
THCharTensor *arg3 = NULL;
char arg4 = 1;
THCharTensor *arg5 = NULL;
THCharTensor *arg6 = NULL;
if(narg == 2
&& (arg5 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg5->nDimension == 1)
&& (arg6 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg6->nDimension == 1)
)
{
arg1 = THCharTensor_new();
THCharTensor_resize2d(arg1, arg5->size[0], arg6->size[0]);
arg3 = arg1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg5->nDimension == 1)
&& (arg6 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg6->nDimension == 1)
)
{
arg1_idx = 1;
arg3 = arg1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*CharTensor*] CharTensor~1D CharTensor~1D", type_buf);
}
THCharTensor_zero(arg1);
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.CharTensor");
THCharTensor_addr(arg1,arg2,arg3,arg4,arg5,arg6);
return 1;
}

static int torch_CharTensor_addmv(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
char arg2 = 1;
THCharTensor *arg3 = NULL;
char arg4 = 1;
THCharTensor *arg5 = NULL;
THCharTensor *arg6 = NULL;
if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg3->nDimension == 1)
&& (arg5 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg6->nDimension == 1)
)
{
arg1 = THCharTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg3->nDimension == 1)
&& (arg5 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 4, "torch.CharTensor")) && (arg6->nDimension == 1)
)
{
arg1_idx = 1;
}
else if(narg == 4
&& lua_isnumber(L, 1)
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg3->nDimension == 1)
&& (arg5 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 4, "torch.CharTensor")) && (arg6->nDimension == 1)
)
{
arg2 = (char)lua_tonumber(L, 1);
arg1 = THCharTensor_new();
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg3->nDimension == 1)
&& (arg5 = luaT_toudata(L, 4, "torch.CharTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 5, "torch.CharTensor")) && (arg6->nDimension == 1)
)
{
arg1_idx = 1;
arg2 = (char)lua_tonumber(L, 2);
}
else if(narg == 4
&& (arg3 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg3->nDimension == 1)
&& lua_isnumber(L, 2)
&& (arg5 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 4, "torch.CharTensor")) && (arg6->nDimension == 1)
)
{
arg4 = (char)lua_tonumber(L, 2);
arg1 = THCharTensor_new();
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg3->nDimension == 1)
&& lua_isnumber(L, 3)
&& (arg5 = luaT_toudata(L, 4, "torch.CharTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 5, "torch.CharTensor")) && (arg6->nDimension == 1)
)
{
arg1_idx = 1;
arg4 = (char)lua_tonumber(L, 3);
}
else if(narg == 5
&& lua_isnumber(L, 1)
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg3->nDimension == 1)
&& lua_isnumber(L, 3)
&& (arg5 = luaT_toudata(L, 4, "torch.CharTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 5, "torch.CharTensor")) && (arg6->nDimension == 1)
)
{
arg2 = (char)lua_tonumber(L, 1);
arg4 = (char)lua_tonumber(L, 3);
arg1 = THCharTensor_new();
}
else if(narg == 6
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg3->nDimension == 1)
&& lua_isnumber(L, 4)
&& (arg5 = luaT_toudata(L, 5, "torch.CharTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 6, "torch.CharTensor")) && (arg6->nDimension == 1)
)
{
arg1_idx = 1;
arg2 = (char)lua_tonumber(L, 2);
arg4 = (char)lua_tonumber(L, 4);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*CharTensor*] [char] CharTensor~1D [char] CharTensor~2D CharTensor~1D", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.CharTensor");
THCharTensor_addmv(arg1,arg2,arg3,arg4,arg5,arg6);
return 1;
}

static int torch_CharTensor_addmm(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
char arg2 = 1;
THCharTensor *arg3 = NULL;
char arg4 = 1;
THCharTensor *arg5 = NULL;
THCharTensor *arg6 = NULL;
if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg3->nDimension == 2)
&& (arg5 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg6->nDimension == 2)
)
{
arg1 = THCharTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg3->nDimension == 2)
&& (arg5 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 4, "torch.CharTensor")) && (arg6->nDimension == 2)
)
{
arg1_idx = 1;
}
else if(narg == 4
&& lua_isnumber(L, 1)
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg3->nDimension == 2)
&& (arg5 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 4, "torch.CharTensor")) && (arg6->nDimension == 2)
)
{
arg2 = (char)lua_tonumber(L, 1);
arg1 = THCharTensor_new();
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg3->nDimension == 2)
&& (arg5 = luaT_toudata(L, 4, "torch.CharTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 5, "torch.CharTensor")) && (arg6->nDimension == 2)
)
{
arg1_idx = 1;
arg2 = (char)lua_tonumber(L, 2);
}
else if(narg == 4
&& (arg3 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg3->nDimension == 2)
&& lua_isnumber(L, 2)
&& (arg5 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 4, "torch.CharTensor")) && (arg6->nDimension == 2)
)
{
arg4 = (char)lua_tonumber(L, 2);
arg1 = THCharTensor_new();
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg3->nDimension == 2)
&& lua_isnumber(L, 3)
&& (arg5 = luaT_toudata(L, 4, "torch.CharTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 5, "torch.CharTensor")) && (arg6->nDimension == 2)
)
{
arg1_idx = 1;
arg4 = (char)lua_tonumber(L, 3);
}
else if(narg == 5
&& lua_isnumber(L, 1)
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg3->nDimension == 2)
&& lua_isnumber(L, 3)
&& (arg5 = luaT_toudata(L, 4, "torch.CharTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 5, "torch.CharTensor")) && (arg6->nDimension == 2)
)
{
arg2 = (char)lua_tonumber(L, 1);
arg4 = (char)lua_tonumber(L, 3);
arg1 = THCharTensor_new();
}
else if(narg == 6
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg3->nDimension == 2)
&& lua_isnumber(L, 4)
&& (arg5 = luaT_toudata(L, 5, "torch.CharTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 6, "torch.CharTensor")) && (arg6->nDimension == 2)
)
{
arg1_idx = 1;
arg2 = (char)lua_tonumber(L, 2);
arg4 = (char)lua_tonumber(L, 4);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*CharTensor*] [char] CharTensor~2D [char] CharTensor~2D CharTensor~2D", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.CharTensor");
THCharTensor_addmm(arg1,arg2,arg3,arg4,arg5,arg6);
return 1;
}

static int torch_CharTensor_addr(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
char arg2 = 1;
THCharTensor *arg3 = NULL;
char arg4 = 1;
THCharTensor *arg5 = NULL;
THCharTensor *arg6 = NULL;
if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg3->nDimension == 2)
&& (arg5 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg5->nDimension == 1)
&& (arg6 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg6->nDimension == 1)
)
{
arg1 = THCharTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg3->nDimension == 2)
&& (arg5 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg5->nDimension == 1)
&& (arg6 = luaT_toudata(L, 4, "torch.CharTensor")) && (arg6->nDimension == 1)
)
{
arg1_idx = 1;
}
else if(narg == 4
&& lua_isnumber(L, 1)
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg3->nDimension == 2)
&& (arg5 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg5->nDimension == 1)
&& (arg6 = luaT_toudata(L, 4, "torch.CharTensor")) && (arg6->nDimension == 1)
)
{
arg2 = (char)lua_tonumber(L, 1);
arg1 = THCharTensor_new();
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg3->nDimension == 2)
&& (arg5 = luaT_toudata(L, 4, "torch.CharTensor")) && (arg5->nDimension == 1)
&& (arg6 = luaT_toudata(L, 5, "torch.CharTensor")) && (arg6->nDimension == 1)
)
{
arg1_idx = 1;
arg2 = (char)lua_tonumber(L, 2);
}
else if(narg == 4
&& (arg3 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg3->nDimension == 2)
&& lua_isnumber(L, 2)
&& (arg5 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg5->nDimension == 1)
&& (arg6 = luaT_toudata(L, 4, "torch.CharTensor")) && (arg6->nDimension == 1)
)
{
arg4 = (char)lua_tonumber(L, 2);
arg1 = THCharTensor_new();
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg3->nDimension == 2)
&& lua_isnumber(L, 3)
&& (arg5 = luaT_toudata(L, 4, "torch.CharTensor")) && (arg5->nDimension == 1)
&& (arg6 = luaT_toudata(L, 5, "torch.CharTensor")) && (arg6->nDimension == 1)
)
{
arg1_idx = 1;
arg4 = (char)lua_tonumber(L, 3);
}
else if(narg == 5
&& lua_isnumber(L, 1)
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg3->nDimension == 2)
&& lua_isnumber(L, 3)
&& (arg5 = luaT_toudata(L, 4, "torch.CharTensor")) && (arg5->nDimension == 1)
&& (arg6 = luaT_toudata(L, 5, "torch.CharTensor")) && (arg6->nDimension == 1)
)
{
arg2 = (char)lua_tonumber(L, 1);
arg4 = (char)lua_tonumber(L, 3);
arg1 = THCharTensor_new();
}
else if(narg == 6
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg3->nDimension == 2)
&& lua_isnumber(L, 4)
&& (arg5 = luaT_toudata(L, 5, "torch.CharTensor")) && (arg5->nDimension == 1)
&& (arg6 = luaT_toudata(L, 6, "torch.CharTensor")) && (arg6->nDimension == 1)
)
{
arg1_idx = 1;
arg2 = (char)lua_tonumber(L, 2);
arg4 = (char)lua_tonumber(L, 4);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*CharTensor*] [char] CharTensor~2D [char] CharTensor~1D CharTensor~1D", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.CharTensor");
THCharTensor_addr(arg1,arg2,arg3,arg4,arg5,arg6);
return 1;
}

static int torch_CharTensor_addbmm(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
char arg2 = 1;
THCharTensor *arg3 = NULL;
char arg4 = 1;
THCharTensor *arg5 = NULL;
THCharTensor *arg6 = NULL;
if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg3->nDimension == 2)
&& (arg5 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg5->nDimension == 3)
&& (arg6 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg6->nDimension == 3)
)
{
arg1 = THCharTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg3->nDimension == 2)
&& (arg5 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg5->nDimension == 3)
&& (arg6 = luaT_toudata(L, 4, "torch.CharTensor")) && (arg6->nDimension == 3)
)
{
arg1_idx = 1;
}
else if(narg == 4
&& lua_isnumber(L, 1)
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg3->nDimension == 2)
&& (arg5 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg5->nDimension == 3)
&& (arg6 = luaT_toudata(L, 4, "torch.CharTensor")) && (arg6->nDimension == 3)
)
{
arg2 = (char)lua_tonumber(L, 1);
arg1 = THCharTensor_new();
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg3->nDimension == 2)
&& (arg5 = luaT_toudata(L, 4, "torch.CharTensor")) && (arg5->nDimension == 3)
&& (arg6 = luaT_toudata(L, 5, "torch.CharTensor")) && (arg6->nDimension == 3)
)
{
arg1_idx = 1;
arg2 = (char)lua_tonumber(L, 2);
}
else if(narg == 4
&& (arg3 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg3->nDimension == 2)
&& lua_isnumber(L, 2)
&& (arg5 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg5->nDimension == 3)
&& (arg6 = luaT_toudata(L, 4, "torch.CharTensor")) && (arg6->nDimension == 3)
)
{
arg4 = (char)lua_tonumber(L, 2);
arg1 = THCharTensor_new();
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg3->nDimension == 2)
&& lua_isnumber(L, 3)
&& (arg5 = luaT_toudata(L, 4, "torch.CharTensor")) && (arg5->nDimension == 3)
&& (arg6 = luaT_toudata(L, 5, "torch.CharTensor")) && (arg6->nDimension == 3)
)
{
arg1_idx = 1;
arg4 = (char)lua_tonumber(L, 3);
}
else if(narg == 5
&& lua_isnumber(L, 1)
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg3->nDimension == 2)
&& lua_isnumber(L, 3)
&& (arg5 = luaT_toudata(L, 4, "torch.CharTensor")) && (arg5->nDimension == 3)
&& (arg6 = luaT_toudata(L, 5, "torch.CharTensor")) && (arg6->nDimension == 3)
)
{
arg2 = (char)lua_tonumber(L, 1);
arg4 = (char)lua_tonumber(L, 3);
arg1 = THCharTensor_new();
}
else if(narg == 6
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg3->nDimension == 2)
&& lua_isnumber(L, 4)
&& (arg5 = luaT_toudata(L, 5, "torch.CharTensor")) && (arg5->nDimension == 3)
&& (arg6 = luaT_toudata(L, 6, "torch.CharTensor")) && (arg6->nDimension == 3)
)
{
arg1_idx = 1;
arg2 = (char)lua_tonumber(L, 2);
arg4 = (char)lua_tonumber(L, 4);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*CharTensor*] [char] CharTensor~2D [char] CharTensor~3D CharTensor~3D", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.CharTensor");
THCharTensor_addbmm(arg1,arg2,arg3,arg4,arg5,arg6);
return 1;
}

static int torch_CharTensor_baddbmm(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
char arg2 = 1;
THCharTensor *arg3 = NULL;
char arg4 = 1;
THCharTensor *arg5 = NULL;
THCharTensor *arg6 = NULL;
if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg3->nDimension == 3)
&& (arg5 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg5->nDimension == 3)
&& (arg6 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg6->nDimension == 3)
)
{
arg1 = THCharTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg3->nDimension == 3)
&& (arg5 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg5->nDimension == 3)
&& (arg6 = luaT_toudata(L, 4, "torch.CharTensor")) && (arg6->nDimension == 3)
)
{
arg1_idx = 1;
}
else if(narg == 4
&& lua_isnumber(L, 1)
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg3->nDimension == 3)
&& (arg5 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg5->nDimension == 3)
&& (arg6 = luaT_toudata(L, 4, "torch.CharTensor")) && (arg6->nDimension == 3)
)
{
arg2 = (char)lua_tonumber(L, 1);
arg1 = THCharTensor_new();
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg3->nDimension == 3)
&& (arg5 = luaT_toudata(L, 4, "torch.CharTensor")) && (arg5->nDimension == 3)
&& (arg6 = luaT_toudata(L, 5, "torch.CharTensor")) && (arg6->nDimension == 3)
)
{
arg1_idx = 1;
arg2 = (char)lua_tonumber(L, 2);
}
else if(narg == 4
&& (arg3 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg3->nDimension == 3)
&& lua_isnumber(L, 2)
&& (arg5 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg5->nDimension == 3)
&& (arg6 = luaT_toudata(L, 4, "torch.CharTensor")) && (arg6->nDimension == 3)
)
{
arg4 = (char)lua_tonumber(L, 2);
arg1 = THCharTensor_new();
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg3->nDimension == 3)
&& lua_isnumber(L, 3)
&& (arg5 = luaT_toudata(L, 4, "torch.CharTensor")) && (arg5->nDimension == 3)
&& (arg6 = luaT_toudata(L, 5, "torch.CharTensor")) && (arg6->nDimension == 3)
)
{
arg1_idx = 1;
arg4 = (char)lua_tonumber(L, 3);
}
else if(narg == 5
&& lua_isnumber(L, 1)
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg3->nDimension == 3)
&& lua_isnumber(L, 3)
&& (arg5 = luaT_toudata(L, 4, "torch.CharTensor")) && (arg5->nDimension == 3)
&& (arg6 = luaT_toudata(L, 5, "torch.CharTensor")) && (arg6->nDimension == 3)
)
{
arg2 = (char)lua_tonumber(L, 1);
arg4 = (char)lua_tonumber(L, 3);
arg1 = THCharTensor_new();
}
else if(narg == 6
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg3->nDimension == 3)
&& lua_isnumber(L, 4)
&& (arg5 = luaT_toudata(L, 5, "torch.CharTensor")) && (arg5->nDimension == 3)
&& (arg6 = luaT_toudata(L, 6, "torch.CharTensor")) && (arg6->nDimension == 3)
)
{
arg1_idx = 1;
arg2 = (char)lua_tonumber(L, 2);
arg4 = (char)lua_tonumber(L, 4);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*CharTensor*] [char] CharTensor~3D [char] CharTensor~3D CharTensor~3D", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.CharTensor");
THCharTensor_baddbmm(arg1,arg2,arg3,arg4,arg5,arg6);
return 1;
}

static int torch_CharTensor_numel(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
ptrdiff_t arg2 = 0;
if(narg == 1
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
)
{
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: CharTensor", type_buf);
}
arg2 = THCharTensor_numel(arg1);
lua_pushnumber(L, (lua_Number)arg2);
return 1;
}

static int torch_CharTensor_cumsum(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
long arg3 = 0;
if(narg == 1
&& (arg2 = luaT_toudata(L, 1, "torch.CharTensor"))
)
{
arg1 = THCharTensor_new();
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
)
{
arg1_idx = 1;
}
else if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
)
{
arg3 = (long)lua_tonumber(L, 2)-1;
arg1 = THCharTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (long)lua_tonumber(L, 3)-1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*CharTensor*] CharTensor [index]", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.CharTensor");
THCharTensor_cumsum(arg1,arg2,arg3);
return 1;
}

static int torch_CharTensor_cumprod(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
long arg3 = 0;
if(narg == 1
&& (arg2 = luaT_toudata(L, 1, "torch.CharTensor"))
)
{
arg1 = THCharTensor_new();
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
)
{
arg1_idx = 1;
}
else if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
)
{
arg3 = (long)lua_tonumber(L, 2)-1;
arg1 = THCharTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (long)lua_tonumber(L, 3)-1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*CharTensor*] CharTensor [index]", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.CharTensor");
THCharTensor_cumprod(arg1,arg2,arg3);
return 1;
}

static int torch_CharTensor_sum(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THCharTensor *arg1 = NULL;
long arg2 = 0;
THCharTensor *arg3 = NULL;
int arg3_idx = 0;
THCharTensor *arg4 = NULL;
long arg5 = 0;
int arg6 = 1;
if(narg == 1
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
)
{
argset = 1;
}
else if(narg == 2
&& (arg4 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 2;
arg5 = (long)lua_tonumber(L, 2)-1;
arg3 = THCharTensor_new();
}
else if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg4 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg3_idx = 1;
arg5 = (long)lua_tonumber(L, 3)-1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: CharTensor | [*CharTensor*] CharTensor index", type_buf);
}
if(argset == 1)
{
arg2 = THCharTensor_sumall(arg1);
lua_pushnumber(L, (lua_Number)arg2);
return 1;
}
else if(argset == 2)
{
if(arg3_idx)
lua_pushvalue(L, arg3_idx);
else
luaT_pushudata(L, arg3, "torch.CharTensor");
THCharTensor_sum(arg3,arg4,arg5,arg6);
return 1;
}
return 0;
}

static int torch_CharTensor_prod(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THCharTensor *arg1 = NULL;
long arg2 = 0;
THCharTensor *arg3 = NULL;
int arg3_idx = 0;
THCharTensor *arg4 = NULL;
long arg5 = 0;
int arg6 = 1;
if(narg == 1
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
)
{
argset = 1;
}
else if(narg == 2
&& (arg4 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 2;
arg5 = (long)lua_tonumber(L, 2)-1;
arg3 = THCharTensor_new();
}
else if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg4 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg3_idx = 1;
arg5 = (long)lua_tonumber(L, 3)-1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: CharTensor | [*CharTensor*] CharTensor index", type_buf);
}
if(argset == 1)
{
arg2 = THCharTensor_prodall(arg1);
lua_pushnumber(L, (lua_Number)arg2);
return 1;
}
else if(argset == 2)
{
if(arg3_idx)
lua_pushvalue(L, arg3_idx);
else
luaT_pushudata(L, arg3, "torch.CharTensor");
THCharTensor_prod(arg3,arg4,arg5,arg6);
return 1;
}
return 0;
}

static int torch_CharTensor_min(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THCharTensor *arg1 = NULL;
char arg2 = 0;
THCharTensor *arg3 = NULL;
int arg3_idx = 0;
THLongTensor *arg4 = NULL;
int arg4_idx = 0;
THCharTensor *arg5 = NULL;
long arg6 = 0;
int arg7 = 1;
if(narg == 1
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
)
{
argset = 1;
}
else if(narg == 2
&& (arg5 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 2;
arg6 = (long)lua_tonumber(L, 2)-1;
arg3 = THCharTensor_new();
arg4 = THLongTensor_new();
}
else if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg3_idx = 1;
arg6 = (long)lua_tonumber(L, 3)-1;
arg4 = THLongTensor_new();
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg4_idx = 1;
arg6 = (long)lua_tonumber(L, 3)-1;
arg3 = THCharTensor_new();
}
else if(narg == 4
&& (arg3 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg4 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg5 = luaT_toudata(L, 3, "torch.CharTensor"))
&& lua_isnumber(L, 4)
)
{
argset = 2;
arg3_idx = 1;
arg4_idx = 2;
arg6 = (long)lua_tonumber(L, 4)-1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: CharTensor | [*CharTensor*] [*LongTensor*] CharTensor index", type_buf);
}
if(argset == 1)
{
arg2 = THCharTensor_minall(arg1);
lua_pushnumber(L, (lua_Number)arg2);
return 1;
}
else if(argset == 2)
{
if(arg3_idx)
lua_pushvalue(L, arg3_idx);
else
luaT_pushudata(L, arg3, "torch.CharTensor");
if(arg4_idx)
lua_pushvalue(L, arg4_idx);
else
luaT_pushudata(L, arg4, "torch.LongTensor");
THCharTensor_min(arg3,arg4,arg5,arg6,arg7);
THLongTensor_add(arg4, arg4, 1);
return 2;
}
return 0;
}

static int torch_CharTensor_max(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THCharTensor *arg1 = NULL;
char arg2 = 0;
THCharTensor *arg3 = NULL;
int arg3_idx = 0;
THLongTensor *arg4 = NULL;
int arg4_idx = 0;
THCharTensor *arg5 = NULL;
long arg6 = 0;
int arg7 = 1;
if(narg == 1
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
)
{
argset = 1;
}
else if(narg == 2
&& (arg5 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 2;
arg6 = (long)lua_tonumber(L, 2)-1;
arg3 = THCharTensor_new();
arg4 = THLongTensor_new();
}
else if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg3_idx = 1;
arg6 = (long)lua_tonumber(L, 3)-1;
arg4 = THLongTensor_new();
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg4_idx = 1;
arg6 = (long)lua_tonumber(L, 3)-1;
arg3 = THCharTensor_new();
}
else if(narg == 4
&& (arg3 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg4 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg5 = luaT_toudata(L, 3, "torch.CharTensor"))
&& lua_isnumber(L, 4)
)
{
argset = 2;
arg3_idx = 1;
arg4_idx = 2;
arg6 = (long)lua_tonumber(L, 4)-1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: CharTensor | [*CharTensor*] [*LongTensor*] CharTensor index", type_buf);
}
if(argset == 1)
{
arg2 = THCharTensor_maxall(arg1);
lua_pushnumber(L, (lua_Number)arg2);
return 1;
}
else if(argset == 2)
{
if(arg3_idx)
lua_pushvalue(L, arg3_idx);
else
luaT_pushudata(L, arg3, "torch.CharTensor");
if(arg4_idx)
lua_pushvalue(L, arg4_idx);
else
luaT_pushudata(L, arg4, "torch.LongTensor");
THCharTensor_max(arg3,arg4,arg5,arg6,arg7);
THLongTensor_add(arg4, arg4, 1);
return 2;
}
return 0;
}

static int torch_CharTensor_cmin(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
THCharTensor *arg3 = NULL;
THCharTensor *arg4 = NULL;
int arg4_idx = 0;
THCharTensor *arg5 = NULL;
char arg6 = 0;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
)
{
argset = 1;
arg1 = THCharTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
)
{
argset = 1;
arg1_idx = 1;
}
else if(narg == 2
&& (arg5 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 2;
arg6 = (char)lua_tonumber(L, 2);
arg4 = THCharTensor_new();
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg4_idx = 1;
arg6 = (char)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*CharTensor*] CharTensor CharTensor | [*CharTensor*] CharTensor char", type_buf);
}
if(argset == 1)
{
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.CharTensor");
THCharTensor_cmin(arg1,arg2,arg3);
return 1;
}
else if(argset == 2)
{
if(arg4_idx)
lua_pushvalue(L, arg4_idx);
else
luaT_pushudata(L, arg4, "torch.CharTensor");
THCharTensor_cminValue(arg4,arg5,arg6);
return 1;
}
return 0;
}

static int torch_CharTensor_cmax(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
THCharTensor *arg3 = NULL;
THCharTensor *arg4 = NULL;
int arg4_idx = 0;
THCharTensor *arg5 = NULL;
char arg6 = 0;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
)
{
argset = 1;
arg1 = THCharTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
)
{
argset = 1;
arg1_idx = 1;
}
else if(narg == 2
&& (arg5 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 2;
arg6 = (char)lua_tonumber(L, 2);
arg4 = THCharTensor_new();
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg4_idx = 1;
arg6 = (char)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*CharTensor*] CharTensor CharTensor | [*CharTensor*] CharTensor char", type_buf);
}
if(argset == 1)
{
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.CharTensor");
THCharTensor_cmax(arg1,arg2,arg3);
return 1;
}
else if(argset == 2)
{
if(arg4_idx)
lua_pushvalue(L, arg4_idx);
else
luaT_pushudata(L, arg4, "torch.CharTensor");
THCharTensor_cmaxValue(arg4,arg5,arg6);
return 1;
}
return 0;
}

static int torch_CharTensor_trace(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
long arg2 = 0;
if(narg == 1
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
)
{
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: CharTensor", type_buf);
}
arg2 = THCharTensor_trace(arg1);
lua_pushnumber(L, (lua_Number)arg2);
return 1;
}

static int torch_CharTensor_cross(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
THCharTensor *arg3 = NULL;
long arg4 = -1;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
)
{
arg1 = THCharTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
)
{
arg1_idx = 1;
}
else if(narg == 3
&& (arg2 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
arg4 = (long)lua_tonumber(L, 3)-1;
arg1 = THCharTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
&& lua_isnumber(L, 4)
)
{
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 4)-1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*CharTensor*] CharTensor CharTensor [index]", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.CharTensor");
THCharTensor_cross(arg1,arg2,arg3,arg4);
return 1;
}

static int torch_CharTensor_diag(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
long arg3 = 0;
if(narg == 1
&& (arg2 = luaT_toudata(L, 1, "torch.CharTensor"))
)
{
arg1 = THCharTensor_new();
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
)
{
arg1_idx = 1;
}
else if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
)
{
arg3 = (long)lua_tonumber(L, 2);
arg1 = THCharTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (long)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*CharTensor*] CharTensor [long]", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.CharTensor");
THCharTensor_diag(arg1,arg2,arg3);
return 1;
}

static int torch_CharTensor_eye(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
long arg2 = 0;
long arg3 = 0;
if(narg == 1
&& lua_isnumber(L, 1)
)
{
arg2 = (long)lua_tonumber(L, 1);
arg1 = THCharTensor_new();
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
)
{
arg1_idx = 1;
arg2 = (long)lua_tonumber(L, 2);
}
else if(narg == 2
&& lua_isnumber(L, 1)
&& lua_isnumber(L, 2)
)
{
arg2 = (long)lua_tonumber(L, 1);
arg3 = (long)lua_tonumber(L, 2);
arg1 = THCharTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg2 = (long)lua_tonumber(L, 2);
arg3 = (long)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*CharTensor*] long [long]", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.CharTensor");
THCharTensor_eye(arg1,arg2,arg3);
return 1;
}

static int torch_CharTensor_range(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
long arg2 = 0;
long arg3 = 0;
long arg4 = 1;
if(narg == 2
&& lua_isnumber(L, 1)
&& lua_isnumber(L, 2)
)
{
arg2 = (long)lua_tonumber(L, 1);
arg3 = (long)lua_tonumber(L, 2);
arg1 = THCharTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg2 = (long)lua_tonumber(L, 2);
arg3 = (long)lua_tonumber(L, 3);
}
else if(narg == 3
&& lua_isnumber(L, 1)
&& lua_isnumber(L, 2)
&& lua_isnumber(L, 3)
)
{
arg2 = (long)lua_tonumber(L, 1);
arg3 = (long)lua_tonumber(L, 2);
arg4 = (long)lua_tonumber(L, 3);
arg1 = THCharTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
&& lua_isnumber(L, 3)
&& lua_isnumber(L, 4)
)
{
arg1_idx = 1;
arg2 = (long)lua_tonumber(L, 2);
arg3 = (long)lua_tonumber(L, 3);
arg4 = (long)lua_tonumber(L, 4);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*CharTensor*] long long [long]", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.CharTensor");
THCharTensor_range(arg1,arg2,arg3,arg4);
return 1;
}

static int torch_CharTensor_randperm(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THGenerator *arg2 = NULL;
long arg3 = 0;
if(narg == 1
&& lua_isnumber(L, 1)
)
{
arg3 = (long)lua_tonumber(L, 1);
arg1 = THCharTensor_new();
lua_getglobal(L,"torch");
arg2 = luaT_getfieldcheckudata(L, -1, "_gen", torch_Generator);
lua_pop(L, 2);
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
)
{
arg1_idx = 1;
arg3 = (long)lua_tonumber(L, 2);
lua_getglobal(L,"torch");
arg2 = luaT_getfieldcheckudata(L, -1, "_gen", torch_Generator);
lua_pop(L, 2);
}
else if(narg == 2
&& (arg2 = luaT_toudata(L, 1, torch_Generator))
&& lua_isnumber(L, 2)
)
{
arg3 = (long)lua_tonumber(L, 2);
arg1 = THCharTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, torch_Generator))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (long)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*CharTensor*] [Generator] long", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.CharTensor");
THCharTensor_randperm(arg1,arg2,arg3);

THCharTensor_add(arg1, arg1, 1);
return 1;
}

static int torch_CharTensor_sort(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THLongTensor *arg2 = NULL;
int arg2_idx = 0;
THCharTensor *arg3 = NULL;
long arg4 = 0;
int arg5 = 0;
if(narg == 1
&& (arg3 = luaT_toudata(L, 1, "torch.CharTensor"))
)
{
arg1 = THCharTensor_new();
arg2 = THLongTensor_new();
arg4 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
)
{
arg1_idx = 1;
arg2 = THLongTensor_new();
arg4 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
)
{
arg2_idx = 1;
arg1 = THCharTensor_new();
arg4 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 2
&& (arg3 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
)
{
arg4 = (long)lua_tonumber(L, 2)-1;
arg1 = THCharTensor_new();
arg2 = THLongTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 3)-1;
arg2 = THLongTensor_new();
}
else if(narg == 3
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
arg2_idx = 1;
arg4 = (long)lua_tonumber(L, 3)-1;
arg1 = THCharTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
&& lua_isnumber(L, 4)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = (long)lua_tonumber(L, 4)-1;
}
else if(narg == 2
&& (arg3 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isboolean(L, 2)
)
{
arg5 = lua_toboolean(L, 2);
arg1 = THCharTensor_new();
arg2 = THLongTensor_new();
arg4 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isboolean(L, 3)
)
{
arg1_idx = 1;
arg5 = lua_toboolean(L, 3);
arg2 = THLongTensor_new();
arg4 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isboolean(L, 3)
)
{
arg2_idx = 1;
arg5 = lua_toboolean(L, 3);
arg1 = THCharTensor_new();
arg4 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
&& lua_isboolean(L, 4)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg5 = lua_toboolean(L, 4);
arg4 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
&& lua_isboolean(L, 3)
)
{
arg4 = (long)lua_tonumber(L, 2)-1;
arg5 = lua_toboolean(L, 3);
arg1 = THCharTensor_new();
arg2 = THLongTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
)
{
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 3)-1;
arg5 = lua_toboolean(L, 4);
arg2 = THLongTensor_new();
}
else if(narg == 4
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
)
{
arg2_idx = 1;
arg4 = (long)lua_tonumber(L, 3)-1;
arg5 = lua_toboolean(L, 4);
arg1 = THCharTensor_new();
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
&& lua_isnumber(L, 4)
&& lua_isboolean(L, 5)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = (long)lua_tonumber(L, 4)-1;
arg5 = lua_toboolean(L, 5);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*CharTensor*] [*LongTensor*] CharTensor [index] [boolean]", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.CharTensor");
if(arg2_idx)
lua_pushvalue(L, arg2_idx);
else
luaT_pushudata(L, arg2, "torch.LongTensor");
THCharTensor_sort(arg1,arg2,arg3,arg4,arg5);
THLongTensor_add(arg2, arg2, 1);
return 2;
}

static int torch_CharTensor_topk(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THLongTensor *arg2 = NULL;
int arg2_idx = 0;
THCharTensor *arg3 = NULL;
long arg4 = 1;
long arg5 = 0;
int arg6 = 0;
int arg7 = 0;
if(narg == 1
&& (arg3 = luaT_toudata(L, 1, "torch.CharTensor"))
)
{
arg1 = THCharTensor_new();
arg2 = THLongTensor_new();
arg5 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
)
{
arg1_idx = 1;
arg2 = THLongTensor_new();
arg5 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
)
{
arg2_idx = 1;
arg1 = THCharTensor_new();
arg5 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
)
{
arg1_idx = 1;
arg2_idx = 2;
arg5 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 2
&& (arg3 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
)
{
arg4 = (long)lua_tonumber(L, 2);
arg1 = THCharTensor_new();
arg2 = THLongTensor_new();
arg5 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg2 = THLongTensor_new();
arg5 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
arg2_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg1 = THCharTensor_new();
arg5 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
&& lua_isnumber(L, 4)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = (long)lua_tonumber(L, 4);
arg5 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 2
&& (arg3 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
)
{
arg5 = (long)lua_tonumber(L, 2)-1;
arg1 = THCharTensor_new();
arg2 = THLongTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg5 = (long)lua_tonumber(L, 3)-1;
arg2 = THLongTensor_new();
}
else if(narg == 3
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
arg2_idx = 1;
arg5 = (long)lua_tonumber(L, 3)-1;
arg1 = THCharTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
&& lua_isnumber(L, 4)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg5 = (long)lua_tonumber(L, 4)-1;
}
else if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
&& lua_isnumber(L, 3)
)
{
arg4 = (long)lua_tonumber(L, 2);
arg5 = (long)lua_tonumber(L, 3)-1;
arg1 = THCharTensor_new();
arg2 = THLongTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
&& lua_isnumber(L, 4)
)
{
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg5 = (long)lua_tonumber(L, 4)-1;
arg2 = THLongTensor_new();
}
else if(narg == 4
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
&& lua_isnumber(L, 4)
)
{
arg2_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg5 = (long)lua_tonumber(L, 4)-1;
arg1 = THCharTensor_new();
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
&& lua_isnumber(L, 4)
&& lua_isnumber(L, 5)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = (long)lua_tonumber(L, 4);
arg5 = (long)lua_tonumber(L, 5)-1;
}
else if(narg == 2
&& (arg3 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isboolean(L, 2)
)
{
arg6 = lua_toboolean(L, 2);
arg1 = THCharTensor_new();
arg2 = THLongTensor_new();
arg5 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isboolean(L, 3)
)
{
arg1_idx = 1;
arg6 = lua_toboolean(L, 3);
arg2 = THLongTensor_new();
arg5 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isboolean(L, 3)
)
{
arg2_idx = 1;
arg6 = lua_toboolean(L, 3);
arg1 = THCharTensor_new();
arg5 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
&& lua_isboolean(L, 4)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg6 = lua_toboolean(L, 4);
arg5 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
&& lua_isboolean(L, 3)
)
{
arg4 = (long)lua_tonumber(L, 2);
arg6 = lua_toboolean(L, 3);
arg1 = THCharTensor_new();
arg2 = THLongTensor_new();
arg5 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
)
{
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg6 = lua_toboolean(L, 4);
arg2 = THLongTensor_new();
arg5 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 4
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
)
{
arg2_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg6 = lua_toboolean(L, 4);
arg1 = THCharTensor_new();
arg5 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
&& lua_isnumber(L, 4)
&& lua_isboolean(L, 5)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = (long)lua_tonumber(L, 4);
arg6 = lua_toboolean(L, 5);
arg5 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
&& lua_isboolean(L, 3)
)
{
arg5 = (long)lua_tonumber(L, 2)-1;
arg6 = lua_toboolean(L, 3);
arg1 = THCharTensor_new();
arg2 = THLongTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
)
{
arg1_idx = 1;
arg5 = (long)lua_tonumber(L, 3)-1;
arg6 = lua_toboolean(L, 4);
arg2 = THLongTensor_new();
}
else if(narg == 4
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
)
{
arg2_idx = 1;
arg5 = (long)lua_tonumber(L, 3)-1;
arg6 = lua_toboolean(L, 4);
arg1 = THCharTensor_new();
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
&& lua_isnumber(L, 4)
&& lua_isboolean(L, 5)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg5 = (long)lua_tonumber(L, 4)-1;
arg6 = lua_toboolean(L, 5);
}
else if(narg == 4
&& (arg3 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
)
{
arg4 = (long)lua_tonumber(L, 2);
arg5 = (long)lua_tonumber(L, 3)-1;
arg6 = lua_toboolean(L, 4);
arg1 = THCharTensor_new();
arg2 = THLongTensor_new();
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
&& lua_isnumber(L, 4)
&& lua_isboolean(L, 5)
)
{
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg5 = (long)lua_tonumber(L, 4)-1;
arg6 = lua_toboolean(L, 5);
arg2 = THLongTensor_new();
}
else if(narg == 5
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
&& lua_isnumber(L, 4)
&& lua_isboolean(L, 5)
)
{
arg2_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg5 = (long)lua_tonumber(L, 4)-1;
arg6 = lua_toboolean(L, 5);
arg1 = THCharTensor_new();
}
else if(narg == 6
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
&& lua_isnumber(L, 4)
&& lua_isnumber(L, 5)
&& lua_isboolean(L, 6)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = (long)lua_tonumber(L, 4);
arg5 = (long)lua_tonumber(L, 5)-1;
arg6 = lua_toboolean(L, 6);
}
else if(narg == 2
&& (arg3 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isboolean(L, 2)
)
{
arg7 = lua_toboolean(L, 2);
arg1 = THCharTensor_new();
arg2 = THLongTensor_new();
arg5 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isboolean(L, 3)
)
{
arg1_idx = 1;
arg7 = lua_toboolean(L, 3);
arg2 = THLongTensor_new();
arg5 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isboolean(L, 3)
)
{
arg2_idx = 1;
arg7 = lua_toboolean(L, 3);
arg1 = THCharTensor_new();
arg5 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
&& lua_isboolean(L, 4)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg7 = lua_toboolean(L, 4);
arg5 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
&& lua_isboolean(L, 3)
)
{
arg4 = (long)lua_tonumber(L, 2);
arg7 = lua_toboolean(L, 3);
arg1 = THCharTensor_new();
arg2 = THLongTensor_new();
arg5 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
)
{
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg7 = lua_toboolean(L, 4);
arg2 = THLongTensor_new();
arg5 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 4
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
)
{
arg2_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg7 = lua_toboolean(L, 4);
arg1 = THCharTensor_new();
arg5 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
&& lua_isnumber(L, 4)
&& lua_isboolean(L, 5)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = (long)lua_tonumber(L, 4);
arg7 = lua_toboolean(L, 5);
arg5 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
&& lua_isboolean(L, 3)
)
{
arg5 = (long)lua_tonumber(L, 2)-1;
arg7 = lua_toboolean(L, 3);
arg1 = THCharTensor_new();
arg2 = THLongTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
)
{
arg1_idx = 1;
arg5 = (long)lua_tonumber(L, 3)-1;
arg7 = lua_toboolean(L, 4);
arg2 = THLongTensor_new();
}
else if(narg == 4
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
)
{
arg2_idx = 1;
arg5 = (long)lua_tonumber(L, 3)-1;
arg7 = lua_toboolean(L, 4);
arg1 = THCharTensor_new();
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
&& lua_isnumber(L, 4)
&& lua_isboolean(L, 5)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg5 = (long)lua_tonumber(L, 4)-1;
arg7 = lua_toboolean(L, 5);
}
else if(narg == 4
&& (arg3 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
)
{
arg4 = (long)lua_tonumber(L, 2);
arg5 = (long)lua_tonumber(L, 3)-1;
arg7 = lua_toboolean(L, 4);
arg1 = THCharTensor_new();
arg2 = THLongTensor_new();
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
&& lua_isnumber(L, 4)
&& lua_isboolean(L, 5)
)
{
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg5 = (long)lua_tonumber(L, 4)-1;
arg7 = lua_toboolean(L, 5);
arg2 = THLongTensor_new();
}
else if(narg == 5
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
&& lua_isnumber(L, 4)
&& lua_isboolean(L, 5)
)
{
arg2_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg5 = (long)lua_tonumber(L, 4)-1;
arg7 = lua_toboolean(L, 5);
arg1 = THCharTensor_new();
}
else if(narg == 6
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
&& lua_isnumber(L, 4)
&& lua_isnumber(L, 5)
&& lua_isboolean(L, 6)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = (long)lua_tonumber(L, 4);
arg5 = (long)lua_tonumber(L, 5)-1;
arg7 = lua_toboolean(L, 6);
}
else if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isboolean(L, 2)
&& lua_isboolean(L, 3)
)
{
arg6 = lua_toboolean(L, 2);
arg7 = lua_toboolean(L, 3);
arg1 = THCharTensor_new();
arg2 = THLongTensor_new();
arg5 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isboolean(L, 3)
&& lua_isboolean(L, 4)
)
{
arg1_idx = 1;
arg6 = lua_toboolean(L, 3);
arg7 = lua_toboolean(L, 4);
arg2 = THLongTensor_new();
arg5 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 4
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isboolean(L, 3)
&& lua_isboolean(L, 4)
)
{
arg2_idx = 1;
arg6 = lua_toboolean(L, 3);
arg7 = lua_toboolean(L, 4);
arg1 = THCharTensor_new();
arg5 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
&& lua_isboolean(L, 4)
&& lua_isboolean(L, 5)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg6 = lua_toboolean(L, 4);
arg7 = lua_toboolean(L, 5);
arg5 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 4
&& (arg3 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
&& lua_isboolean(L, 3)
&& lua_isboolean(L, 4)
)
{
arg4 = (long)lua_tonumber(L, 2);
arg6 = lua_toboolean(L, 3);
arg7 = lua_toboolean(L, 4);
arg1 = THCharTensor_new();
arg2 = THLongTensor_new();
arg5 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
&& lua_isboolean(L, 5)
)
{
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg6 = lua_toboolean(L, 4);
arg7 = lua_toboolean(L, 5);
arg2 = THLongTensor_new();
arg5 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 5
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
&& lua_isboolean(L, 5)
)
{
arg2_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg6 = lua_toboolean(L, 4);
arg7 = lua_toboolean(L, 5);
arg1 = THCharTensor_new();
arg5 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 6
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
&& lua_isnumber(L, 4)
&& lua_isboolean(L, 5)
&& lua_isboolean(L, 6)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = (long)lua_tonumber(L, 4);
arg6 = lua_toboolean(L, 5);
arg7 = lua_toboolean(L, 6);
arg5 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 4
&& (arg3 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
&& lua_isboolean(L, 3)
&& lua_isboolean(L, 4)
)
{
arg5 = (long)lua_tonumber(L, 2)-1;
arg6 = lua_toboolean(L, 3);
arg7 = lua_toboolean(L, 4);
arg1 = THCharTensor_new();
arg2 = THLongTensor_new();
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
&& lua_isboolean(L, 5)
)
{
arg1_idx = 1;
arg5 = (long)lua_tonumber(L, 3)-1;
arg6 = lua_toboolean(L, 4);
arg7 = lua_toboolean(L, 5);
arg2 = THLongTensor_new();
}
else if(narg == 5
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
&& lua_isboolean(L, 5)
)
{
arg2_idx = 1;
arg5 = (long)lua_tonumber(L, 3)-1;
arg6 = lua_toboolean(L, 4);
arg7 = lua_toboolean(L, 5);
arg1 = THCharTensor_new();
}
else if(narg == 6
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
&& lua_isnumber(L, 4)
&& lua_isboolean(L, 5)
&& lua_isboolean(L, 6)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg5 = (long)lua_tonumber(L, 4)-1;
arg6 = lua_toboolean(L, 5);
arg7 = lua_toboolean(L, 6);
}
else if(narg == 5
&& (arg3 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
&& lua_isboolean(L, 5)
)
{
arg4 = (long)lua_tonumber(L, 2);
arg5 = (long)lua_tonumber(L, 3)-1;
arg6 = lua_toboolean(L, 4);
arg7 = lua_toboolean(L, 5);
arg1 = THCharTensor_new();
arg2 = THLongTensor_new();
}
else if(narg == 6
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
&& lua_isnumber(L, 4)
&& lua_isboolean(L, 5)
&& lua_isboolean(L, 6)
)
{
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg5 = (long)lua_tonumber(L, 4)-1;
arg6 = lua_toboolean(L, 5);
arg7 = lua_toboolean(L, 6);
arg2 = THLongTensor_new();
}
else if(narg == 6
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
&& lua_isnumber(L, 4)
&& lua_isboolean(L, 5)
&& lua_isboolean(L, 6)
)
{
arg2_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg5 = (long)lua_tonumber(L, 4)-1;
arg6 = lua_toboolean(L, 5);
arg7 = lua_toboolean(L, 6);
arg1 = THCharTensor_new();
}
else if(narg == 7
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
&& lua_isnumber(L, 4)
&& lua_isnumber(L, 5)
&& lua_isboolean(L, 6)
&& lua_isboolean(L, 7)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = (long)lua_tonumber(L, 4);
arg5 = (long)lua_tonumber(L, 5)-1;
arg6 = lua_toboolean(L, 6);
arg7 = lua_toboolean(L, 7);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*CharTensor*] [*LongTensor*] CharTensor [long] [index] [boolean] [boolean]", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.CharTensor");
if(arg2_idx)
lua_pushvalue(L, arg2_idx);
else
luaT_pushudata(L, arg2, "torch.LongTensor");
THCharTensor_topk(arg1,arg2,arg3,arg4,arg5,arg6,arg7);
THLongTensor_add(arg2, arg2, 1);
return 2;
}

static int torch_CharTensor_kthvalue(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THLongTensor *arg2 = NULL;
int arg2_idx = 0;
THCharTensor *arg3 = NULL;
long arg4 = 0;
long arg5 = 0;
int arg6 = 1;
if(narg == 2
&& (arg3 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
)
{
arg4 = (long)lua_tonumber(L, 2);
arg1 = THCharTensor_new();
arg2 = THLongTensor_new();
arg5 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg2 = THLongTensor_new();
arg5 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
arg2_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg1 = THCharTensor_new();
arg5 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
&& lua_isnumber(L, 4)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = (long)lua_tonumber(L, 4);
arg5 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
&& lua_isnumber(L, 3)
)
{
arg4 = (long)lua_tonumber(L, 2);
arg5 = (long)lua_tonumber(L, 3)-1;
arg1 = THCharTensor_new();
arg2 = THLongTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
&& lua_isnumber(L, 4)
)
{
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg5 = (long)lua_tonumber(L, 4)-1;
arg2 = THLongTensor_new();
}
else if(narg == 4
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
&& lua_isnumber(L, 4)
)
{
arg2_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg5 = (long)lua_tonumber(L, 4)-1;
arg1 = THCharTensor_new();
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
&& lua_isnumber(L, 4)
&& lua_isnumber(L, 5)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = (long)lua_tonumber(L, 4);
arg5 = (long)lua_tonumber(L, 5)-1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*CharTensor*] [*LongTensor*] CharTensor long [index]", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.CharTensor");
if(arg2_idx)
lua_pushvalue(L, arg2_idx);
else
luaT_pushudata(L, arg2, "torch.LongTensor");
THCharTensor_kthvalue(arg1,arg2,arg3,arg4,arg5,arg6);
THLongTensor_add(arg2, arg2, 1);
return 2;
}

static int torch_CharTensor_mode(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THLongTensor *arg2 = NULL;
int arg2_idx = 0;
THCharTensor *arg3 = NULL;
long arg4 = 0;
int arg5 = 1;
if(narg == 1
&& (arg3 = luaT_toudata(L, 1, "torch.CharTensor"))
)
{
arg1 = THCharTensor_new();
arg2 = THLongTensor_new();
arg4 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
)
{
arg1_idx = 1;
arg2 = THLongTensor_new();
arg4 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
)
{
arg2_idx = 1;
arg1 = THCharTensor_new();
arg4 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 2
&& (arg3 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
)
{
arg4 = (long)lua_tonumber(L, 2)-1;
arg1 = THCharTensor_new();
arg2 = THLongTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 3)-1;
arg2 = THLongTensor_new();
}
else if(narg == 3
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
arg2_idx = 1;
arg4 = (long)lua_tonumber(L, 3)-1;
arg1 = THCharTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
&& lua_isnumber(L, 4)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = (long)lua_tonumber(L, 4)-1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*CharTensor*] [*LongTensor*] CharTensor [index]", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.CharTensor");
if(arg2_idx)
lua_pushvalue(L, arg2_idx);
else
luaT_pushudata(L, arg2, "torch.LongTensor");
THCharTensor_mode(arg1,arg2,arg3,arg4,arg5);
THLongTensor_add(arg2, arg2, 1);
return 2;
}

static int torch_CharTensor_median(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THLongTensor *arg2 = NULL;
int arg2_idx = 0;
THCharTensor *arg3 = NULL;
long arg4 = 0;
int arg5 = 1;
if(narg == 1
&& (arg3 = luaT_toudata(L, 1, "torch.CharTensor"))
)
{
arg1 = THCharTensor_new();
arg2 = THLongTensor_new();
arg4 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
)
{
arg1_idx = 1;
arg2 = THLongTensor_new();
arg4 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
)
{
arg2_idx = 1;
arg1 = THCharTensor_new();
arg4 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 2
&& (arg3 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
)
{
arg4 = (long)lua_tonumber(L, 2)-1;
arg1 = THCharTensor_new();
arg2 = THLongTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 3)-1;
arg2 = THLongTensor_new();
}
else if(narg == 3
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
arg2_idx = 1;
arg4 = (long)lua_tonumber(L, 3)-1;
arg1 = THCharTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
&& lua_isnumber(L, 4)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = (long)lua_tonumber(L, 4)-1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*CharTensor*] [*LongTensor*] CharTensor [index]", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.CharTensor");
if(arg2_idx)
lua_pushvalue(L, arg2_idx);
else
luaT_pushudata(L, arg2, "torch.LongTensor");
THCharTensor_median(arg1,arg2,arg3,arg4,arg5);
THLongTensor_add(arg2, arg2, 1);
return 2;
}

static int torch_CharTensor_tril(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
int arg3 = 0;
if(narg == 1
&& (arg2 = luaT_toudata(L, 1, "torch.CharTensor"))
)
{
arg1 = THCharTensor_new();
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
)
{
arg1_idx = 1;
}
else if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
)
{
arg3 = (int)lua_tonumber(L, 2);
arg1 = THCharTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (int)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*CharTensor*] CharTensor [int]", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.CharTensor");
THCharTensor_tril(arg1,arg2,arg3);
return 1;
}

static int torch_CharTensor_triu(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
int arg3 = 0;
if(narg == 1
&& (arg2 = luaT_toudata(L, 1, "torch.CharTensor"))
)
{
arg1 = THCharTensor_new();
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
)
{
arg1_idx = 1;
}
else if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
)
{
arg3 = (int)lua_tonumber(L, 2);
arg1 = THCharTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (int)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*CharTensor*] CharTensor [int]", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.CharTensor");
THCharTensor_triu(arg1,arg2,arg3);
return 1;
}

static int torch_CharTensor_cat(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
THCharTensor *arg3 = NULL;
long arg4 = -2;
THCharTensor *arg5 = NULL;
int arg5_idx = 0;
THCharTensor **arg6_data = NULL;
long arg6_size = 0;
int arg6_i = 0;
long arg7 = -2;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
)
{
argset = 1;
arg1 = THCharTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
)
{
argset = 1;
arg1_idx = 1;
}
else if(narg == 3
&& (arg2 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 1;
arg4 = (long)lua_tonumber(L, 3)-1;
arg1 = THCharTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
&& lua_isnumber(L, 4)
)
{
argset = 1;
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 4)-1;
}
else if(narg == 1
&& torch_isnonemptytable(L, 1)
)
{
argset = 2;
do
{
  arg6_size++;
  lua_checkstack(L, 1);
  lua_rawgeti(L, 1, arg6_size);
}
while (!lua_isnil(L, -1));
arg6_size--;
lua_pop(L, 1);
arg6_data = (THCharTensor**)THAlloc(arg6_size * sizeof(THCharTensor*));
for (arg6_i = arg6_size - 1; arg6_i >= 0; arg6_i--)
{
  if (!(arg6_data[arg6_i] = luaT_toudata(L, -1, "torch.CharTensor")))
    luaL_error(L, "expected CharTensor in tensor array");
  lua_pop(L, 1);
}

arg5 = THCharTensor_new();
}
else if(narg == 2
&& (arg5 = luaT_toudata(L, 1, "torch.CharTensor"))
&& torch_isnonemptytable(L, 2)
)
{
argset = 2;
arg5_idx = 1;
do
{
  arg6_size++;
  lua_checkstack(L, 1);
  lua_rawgeti(L, 2, arg6_size);
}
while (!lua_isnil(L, -1));
arg6_size--;
lua_pop(L, 1);
arg6_data = (THCharTensor**)THAlloc(arg6_size * sizeof(THCharTensor*));
for (arg6_i = arg6_size - 1; arg6_i >= 0; arg6_i--)
{
  if (!(arg6_data[arg6_i] = luaT_toudata(L, -1, "torch.CharTensor")))
    luaL_error(L, "expected CharTensor in tensor array");
  lua_pop(L, 1);
}

}
else if(narg == 2
&& torch_isnonemptytable(L, 1)
&& lua_isnumber(L, 2)
)
{
argset = 2;
do
{
  arg6_size++;
  lua_checkstack(L, 1);
  lua_rawgeti(L, 1, arg6_size);
}
while (!lua_isnil(L, -1));
arg6_size--;
lua_pop(L, 1);
arg6_data = (THCharTensor**)THAlloc(arg6_size * sizeof(THCharTensor*));
for (arg6_i = arg6_size - 1; arg6_i >= 0; arg6_i--)
{
  if (!(arg6_data[arg6_i] = luaT_toudata(L, -1, "torch.CharTensor")))
    luaL_error(L, "expected CharTensor in tensor array");
  lua_pop(L, 1);
}

arg7 = (long)lua_tonumber(L, 2)-1;
arg5 = THCharTensor_new();
}
else if(narg == 3
&& (arg5 = luaT_toudata(L, 1, "torch.CharTensor"))
&& torch_isnonemptytable(L, 2)
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg5_idx = 1;
do
{
  arg6_size++;
  lua_checkstack(L, 1);
  lua_rawgeti(L, 2, arg6_size);
}
while (!lua_isnil(L, -1));
arg6_size--;
lua_pop(L, 1);
arg6_data = (THCharTensor**)THAlloc(arg6_size * sizeof(THCharTensor*));
for (arg6_i = arg6_size - 1; arg6_i >= 0; arg6_i--)
{
  if (!(arg6_data[arg6_i] = luaT_toudata(L, -1, "torch.CharTensor")))
    luaL_error(L, "expected CharTensor in tensor array");
  lua_pop(L, 1);
}

arg7 = (long)lua_tonumber(L, 3)-1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*CharTensor*] CharTensor CharTensor [index] | [*CharTensor*] {CharTensor+} [index]", type_buf);
}
if(argset == 1)
{
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.CharTensor");
THCharTensor_cat(arg1,arg2,arg3,arg4);
return 1;
}
else if(argset == 2)
{
if(arg5_idx)
lua_pushvalue(L, arg5_idx);
else
luaT_pushudata(L, arg5, "torch.CharTensor");
THCharTensor_catArray(arg5,arg6_data,arg6_size,arg7);
THFree(arg6_data);
return 1;
}
return 0;
}

static void THCharTensor_random2__(THCharTensor *self, THGenerator *gen, long a, long b)
{
  THArgCheck(b >= a, 2, "upper bound must be larger than lower bound");
  TH_TENSOR_APPLY(char, self, *self_data = ((THRandom_random(gen) % (b+1-a)) + a);)
}

static void THCharTensor_random1__(THCharTensor *self, THGenerator *gen, long b)
{
  THArgCheck(b > 0, 1, "upper bound must be strictly positive");
  TH_TENSOR_APPLY(char, self, *self_data = (THRandom_random(gen) % b + 1);)
}

static int torch_CharTensor_random(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THGenerator *arg1 = NULL;
long arg2 = 0;
long arg3 = 0;
long arg4 = 0;
THGenerator *arg5 = NULL;
long arg6 = 0;
long arg7 = 0;
THGenerator *arg8 = NULL;
long arg9 = 0;
THCharTensor *arg10 = NULL;
int arg10_idx = 0;
THGenerator *arg11 = NULL;
long arg12 = 0;
long arg13 = 0;
THCharTensor *arg14 = NULL;
int arg14_idx = 0;
THGenerator *arg15 = NULL;
long arg16 = 0;
THCharTensor *arg17 = NULL;
int arg17_idx = 0;
THGenerator *arg18 = NULL;
if(narg == 2
&& lua_isnumber(L, 1)
&& lua_isnumber(L, 2)
)
{
argset = 1;
arg2 = (long)lua_tonumber(L, 1);
arg3 = (long)lua_tonumber(L, 2);
lua_getglobal(L,"torch");
arg1 = luaT_getfieldcheckudata(L, -1, "_gen", torch_Generator);
lua_pop(L, 2);
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, torch_Generator))
&& lua_isnumber(L, 2)
&& lua_isnumber(L, 3)
)
{
argset = 1;
arg2 = (long)lua_tonumber(L, 2);
arg3 = (long)lua_tonumber(L, 3);
}
else if(narg == 1
&& lua_isnumber(L, 1)
)
{
argset = 2;
arg6 = (long)lua_tonumber(L, 1);
lua_getglobal(L,"torch");
arg5 = luaT_getfieldcheckudata(L, -1, "_gen", torch_Generator);
lua_pop(L, 2);
}
else if(narg == 2
&& (arg5 = luaT_toudata(L, 1, torch_Generator))
&& lua_isnumber(L, 2)
)
{
argset = 2;
arg6 = (long)lua_tonumber(L, 2);
}
else if(narg == 0
)
{
argset = 3;
lua_getglobal(L,"torch");
arg8 = luaT_getfieldcheckudata(L, -1, "_gen", torch_Generator);
lua_pop(L, 2);
}
else if(narg == 1
&& (arg8 = luaT_toudata(L, 1, torch_Generator))
)
{
argset = 3;
}
else if(narg == 3
&& (arg10 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
&& lua_isnumber(L, 3)
)
{
argset = 4;
arg10_idx = 1;
arg12 = (long)lua_tonumber(L, 2);
arg13 = (long)lua_tonumber(L, 3);
lua_getglobal(L,"torch");
arg11 = luaT_getfieldcheckudata(L, -1, "_gen", torch_Generator);
lua_pop(L, 2);
}
else if(narg == 4
&& (arg10 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg11 = luaT_toudata(L, 2, torch_Generator))
&& lua_isnumber(L, 3)
&& lua_isnumber(L, 4)
)
{
argset = 4;
arg10_idx = 1;
arg12 = (long)lua_tonumber(L, 3);
arg13 = (long)lua_tonumber(L, 4);
}
else if(narg == 2
&& (arg14 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 5;
arg14_idx = 1;
arg16 = (long)lua_tonumber(L, 2);
lua_getglobal(L,"torch");
arg15 = luaT_getfieldcheckudata(L, -1, "_gen", torch_Generator);
lua_pop(L, 2);
}
else if(narg == 3
&& (arg14 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg15 = luaT_toudata(L, 2, torch_Generator))
&& lua_isnumber(L, 3)
)
{
argset = 5;
arg14_idx = 1;
arg16 = (long)lua_tonumber(L, 3);
}
else if(narg == 1
&& (arg17 = luaT_toudata(L, 1, "torch.CharTensor"))
)
{
argset = 6;
arg17_idx = 1;
lua_getglobal(L,"torch");
arg18 = luaT_getfieldcheckudata(L, -1, "_gen", torch_Generator);
lua_pop(L, 2);
}
else if(narg == 2
&& (arg17 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg18 = luaT_toudata(L, 2, torch_Generator))
)
{
argset = 6;
arg17_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [Generator] long long | [Generator] long | [Generator] | *CharTensor* [Generator] long long | *CharTensor* [Generator] long | *CharTensor* [Generator]", type_buf);
}
if(argset == 1)
{
arg4 = THRandom_random2__(arg1,arg2,arg3);
lua_pushnumber(L, (lua_Number)arg4);
return 1;
}
else if(argset == 2)
{
arg7 = THRandom_random1__(arg5,arg6);
lua_pushnumber(L, (lua_Number)arg7);
return 1;
}
else if(argset == 3)
{
arg9 = THRandom_random(arg8);
lua_pushnumber(L, (lua_Number)arg9);
return 1;
}
else if(argset == 4)
{
lua_pushvalue(L, arg10_idx);
THCharTensor_random2__(arg10,arg11,arg12,arg13);
return 1;
}
else if(argset == 5)
{
lua_pushvalue(L, arg14_idx);
THCharTensor_random1__(arg14,arg15,arg16);
return 1;
}
else if(argset == 6)
{
lua_pushvalue(L, arg17_idx);
THCharTensor_random(arg17,arg18);
return 1;
}
return 0;
}

static int torch_CharTensor_geometric(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THGenerator *arg1 = NULL;
double arg2 = 0;
double arg3 = 0;
THCharTensor *arg4 = NULL;
int arg4_idx = 0;
THGenerator *arg5 = NULL;
double arg6 = 0;
if(narg == 1
&& lua_isnumber(L, 1)
)
{
argset = 1;
arg2 = (double)lua_tonumber(L, 1);
lua_getglobal(L,"torch");
arg1 = luaT_getfieldcheckudata(L, -1, "_gen", torch_Generator);
lua_pop(L, 2);
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, torch_Generator))
&& lua_isnumber(L, 2)
)
{
argset = 1;
arg2 = (double)lua_tonumber(L, 2);
}
else if(narg == 2
&& (arg4 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 2;
arg4_idx = 1;
arg6 = (double)lua_tonumber(L, 2);
lua_getglobal(L,"torch");
arg5 = luaT_getfieldcheckudata(L, -1, "_gen", torch_Generator);
lua_pop(L, 2);
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg5 = luaT_toudata(L, 2, torch_Generator))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg4_idx = 1;
arg6 = (double)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [Generator] double | *CharTensor* [Generator] double", type_buf);
}
if(argset == 1)
{
arg3 = THRandom_geometric(arg1,arg2);
lua_pushnumber(L, (lua_Number)arg3);
return 1;
}
else if(argset == 2)
{
lua_pushvalue(L, arg4_idx);
THCharTensor_geometric(arg4,arg5,arg6);
return 1;
}
return 0;
}

static int torch_CharTensor_bernoulli(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THGenerator *arg1 = NULL;
double arg2 = 0.5;
double arg3 = 0;
THCharTensor *arg4 = NULL;
int arg4_idx = 0;
THGenerator *arg5 = NULL;
double arg6 = 0.5;
THCharTensor *arg7 = NULL;
int arg7_idx = 0;
THGenerator *arg8 = NULL;
THFloatTensor *arg9 = NULL;
THCharTensor *arg10 = NULL;
int arg10_idx = 0;
THGenerator *arg11 = NULL;
THDoubleTensor *arg12 = NULL;
if(narg == 0
)
{
argset = 1;
lua_getglobal(L,"torch");
arg1 = luaT_getfieldcheckudata(L, -1, "_gen", torch_Generator);
lua_pop(L, 2);
}
else if(narg == 1
&& (arg1 = luaT_toudata(L, 1, torch_Generator))
)
{
argset = 1;
}
else if(narg == 1
&& lua_isnumber(L, 1)
)
{
argset = 1;
arg2 = (double)lua_tonumber(L, 1);
lua_getglobal(L,"torch");
arg1 = luaT_getfieldcheckudata(L, -1, "_gen", torch_Generator);
lua_pop(L, 2);
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, torch_Generator))
&& lua_isnumber(L, 2)
)
{
argset = 1;
arg2 = (double)lua_tonumber(L, 2);
}
else if(narg == 1
&& (arg4 = luaT_toudata(L, 1, "torch.CharTensor"))
)
{
argset = 2;
arg4_idx = 1;
lua_getglobal(L,"torch");
arg5 = luaT_getfieldcheckudata(L, -1, "_gen", torch_Generator);
lua_pop(L, 2);
}
else if(narg == 2
&& (arg4 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg5 = luaT_toudata(L, 2, torch_Generator))
)
{
argset = 2;
arg4_idx = 1;
}
else if(narg == 2
&& (arg4 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 2;
arg4_idx = 1;
arg6 = (double)lua_tonumber(L, 2);
lua_getglobal(L,"torch");
arg5 = luaT_getfieldcheckudata(L, -1, "_gen", torch_Generator);
lua_pop(L, 2);
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg5 = luaT_toudata(L, 2, torch_Generator))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg4_idx = 1;
arg6 = (double)lua_tonumber(L, 3);
}
else if(narg == 2
&& (arg7 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg9 = luaT_toudata(L, 2, "torch.FloatTensor"))
)
{
argset = 3;
arg7_idx = 1;
lua_getglobal(L,"torch");
arg8 = luaT_getfieldcheckudata(L, -1, "_gen", torch_Generator);
lua_pop(L, 2);
}
else if(narg == 3
&& (arg7 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg8 = luaT_toudata(L, 2, torch_Generator))
&& (arg9 = luaT_toudata(L, 3, "torch.FloatTensor"))
)
{
argset = 3;
arg7_idx = 1;
}
else if(narg == 2
&& (arg10 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg12 = luaT_toudata(L, 2, "torch.DoubleTensor"))
)
{
argset = 4;
arg10_idx = 1;
lua_getglobal(L,"torch");
arg11 = luaT_getfieldcheckudata(L, -1, "_gen", torch_Generator);
lua_pop(L, 2);
}
else if(narg == 3
&& (arg10 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg11 = luaT_toudata(L, 2, torch_Generator))
&& (arg12 = luaT_toudata(L, 3, "torch.DoubleTensor"))
)
{
argset = 4;
arg10_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [Generator] [double] | *CharTensor* [Generator] [double] | *CharTensor* [Generator] FloatTensor | *CharTensor* [Generator] DoubleTensor", type_buf);
}
if(argset == 1)
{
arg3 = THRandom_bernoulli(arg1,arg2);
lua_pushnumber(L, (lua_Number)arg3);
return 1;
}
else if(argset == 2)
{
lua_pushvalue(L, arg4_idx);
THCharTensor_bernoulli(arg4,arg5,arg6);
return 1;
}
else if(argset == 3)
{
lua_pushvalue(L, arg7_idx);
THCharTensor_bernoulli_FloatTensor(arg7,arg8,arg9);
return 1;
}
else if(argset == 4)
{
lua_pushvalue(L, arg10_idx);
THCharTensor_bernoulli_DoubleTensor(arg10,arg11,arg12);
return 1;
}
return 0;
}

static int torch_CharTensor_squeeze(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
THCharTensor *arg3 = NULL;
int arg3_idx = 0;
THCharTensor *arg4 = NULL;
long arg5 = 0;
if(narg == 1
&& (arg2 = luaT_toudata(L, 1, "torch.CharTensor"))
)
{
argset = 1;
arg1 = THCharTensor_new();
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
)
{
argset = 1;
arg1_idx = 1;
}
else if(narg == 2
&& (arg4 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 2;
arg5 = (long)lua_tonumber(L, 2)-1;
arg3 = THCharTensor_new();
}
else if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg4 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg3_idx = 1;
arg5 = (long)lua_tonumber(L, 3)-1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*CharTensor*] CharTensor | [*CharTensor*] CharTensor index", type_buf);
}
if(argset == 1)
{
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.CharTensor");
THCharTensor_squeeze(arg1,arg2);
if(arg1->nDimension == 1 && arg1->size[0] == 1)
lua_pushnumber(L, (lua_Number)(*THCharTensor_data(arg1)));
return 1;
}
else if(argset == 2)
{
if(arg3_idx)
lua_pushvalue(L, arg3_idx);
else
luaT_pushudata(L, arg3, "torch.CharTensor");
{int hasdims = arg4->nDimension > 1;
THCharTensor_squeeze1d(arg3,arg4,arg5);
if(!hasdims && arg3->nDimension == 1 && arg3->size[0] == 1)
lua_pushnumber(L, (lua_Number)(*THCharTensor_data(arg3)));}
return 1;
}
return 0;
}

static int torch_CharTensor_sign(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
if(narg == 1
&& (arg2 = luaT_toudata(L, 1, "torch.CharTensor"))
)
{
arg1 = THCharTensor_new();
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
)
{
arg1_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*CharTensor*] CharTensor", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.CharTensor");
THCharTensor_sign(arg1,arg2);
return 1;
}

static int torch_CharTensor_conv2(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
char arg2 = 0;
char arg3 = 1;
THCharTensor *arg4 = NULL;
THCharTensor *arg5 = NULL;
char arg6 = 1;
char arg7 = 1;
const char *arg8 = NULL;
char arg8_default = 'V';
const char *arg9 = NULL;
char arg9_default = 'C';
THCharTensor *arg10 = NULL;
int arg10_idx = 0;
char arg11 = 0;
char arg12 = 1;
THCharTensor *arg13 = NULL;
THCharTensor *arg14 = NULL;
char arg15 = 1;
char arg16 = 1;
const char *arg17 = NULL;
char arg17_default = 'V';
const char *arg18 = NULL;
char arg18_default = 'C';
THCharTensor *arg19 = NULL;
int arg19_idx = 0;
char arg20 = 0;
char arg21 = 1;
THCharTensor *arg22 = NULL;
THCharTensor *arg23 = NULL;
char arg24 = 1;
char arg25 = 1;
const char *arg26 = NULL;
char arg26_default = 'V';
const char *arg27 = NULL;
char arg27_default = 'C';
if(narg == 2
&& (arg4 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg4->nDimension == 2)
&& (arg5 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg5->nDimension == 2)
)
{
argset = 1;
arg1 = THCharTensor_new();
arg8 = &arg8_default;
arg9 = &arg9_default;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg4 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg4->nDimension == 2)
&& (arg5 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg5->nDimension == 2)
)
{
argset = 1;
arg1_idx = 1;
arg8 = &arg8_default;
arg9 = &arg9_default;
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg4->nDimension == 2)
&& (arg5 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg5->nDimension == 2)
&& (arg8 = lua_tostring(L, 3)) && (*arg8 == 'V' || *arg8 == 'F')
)
{
argset = 1;
arg1 = THCharTensor_new();
arg9 = &arg9_default;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg4 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg4->nDimension == 2)
&& (arg5 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg5->nDimension == 2)
&& (arg8 = lua_tostring(L, 4)) && (*arg8 == 'V' || *arg8 == 'F')
)
{
argset = 1;
arg1_idx = 1;
arg9 = &arg9_default;
}
else if(narg == 2
&& (arg13 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg13->nDimension == 3)
&& (arg14 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg14->nDimension == 3)
)
{
argset = 2;
arg10 = THCharTensor_new();
arg17 = &arg17_default;
arg18 = &arg18_default;
}
else if(narg == 3
&& (arg10 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg13 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg13->nDimension == 3)
&& (arg14 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg14->nDimension == 3)
)
{
argset = 2;
arg10_idx = 1;
arg17 = &arg17_default;
arg18 = &arg18_default;
}
else if(narg == 3
&& (arg13 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg13->nDimension == 3)
&& (arg14 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg14->nDimension == 3)
&& (arg17 = lua_tostring(L, 3)) && (*arg17 == 'V' || *arg17 == 'F')
)
{
argset = 2;
arg10 = THCharTensor_new();
arg18 = &arg18_default;
}
else if(narg == 4
&& (arg10 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg13 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg13->nDimension == 3)
&& (arg14 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg14->nDimension == 3)
&& (arg17 = lua_tostring(L, 4)) && (*arg17 == 'V' || *arg17 == 'F')
)
{
argset = 2;
arg10_idx = 1;
arg18 = &arg18_default;
}
else if(narg == 2
&& (arg22 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg22->nDimension == 3)
&& (arg23 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg23->nDimension == 4)
)
{
argset = 3;
arg19 = THCharTensor_new();
arg26 = &arg26_default;
arg27 = &arg27_default;
}
else if(narg == 3
&& (arg19 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg22 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg22->nDimension == 3)
&& (arg23 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg23->nDimension == 4)
)
{
argset = 3;
arg19_idx = 1;
arg26 = &arg26_default;
arg27 = &arg27_default;
}
else if(narg == 3
&& (arg22 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg22->nDimension == 3)
&& (arg23 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg23->nDimension == 4)
&& (arg26 = lua_tostring(L, 3)) && (*arg26 == 'V' || *arg26 == 'F')
)
{
argset = 3;
arg19 = THCharTensor_new();
arg27 = &arg27_default;
}
else if(narg == 4
&& (arg19 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg22 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg22->nDimension == 3)
&& (arg23 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg23->nDimension == 4)
&& (arg26 = lua_tostring(L, 4)) && (*arg26 == 'V' || *arg26 == 'F')
)
{
argset = 3;
arg19_idx = 1;
arg27 = &arg27_default;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*CharTensor*] CharTensor~2D CharTensor~2D [(V|F)] | [*CharTensor*] CharTensor~3D CharTensor~3D [(V|F)] | [*CharTensor*] CharTensor~3D CharTensor~4D [(V|F)]", type_buf);
}
if(argset == 1)
{
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.CharTensor");
THCharTensor_conv2Dmul(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9);
return 1;
}
else if(argset == 2)
{
if(arg10_idx)
lua_pushvalue(L, arg10_idx);
else
luaT_pushudata(L, arg10, "torch.CharTensor");
THCharTensor_conv2Dcmul(arg10,arg11,arg12,arg13,arg14,arg15,arg16,arg17,arg18);
return 1;
}
else if(argset == 3)
{
if(arg19_idx)
lua_pushvalue(L, arg19_idx);
else
luaT_pushudata(L, arg19, "torch.CharTensor");
THCharTensor_conv2Dmv(arg19,arg20,arg21,arg22,arg23,arg24,arg25,arg26,arg27);
return 1;
}
return 0;
}

static int torch_CharTensor_xcorr2(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
char arg2 = 0;
char arg3 = 1;
THCharTensor *arg4 = NULL;
THCharTensor *arg5 = NULL;
char arg6 = 1;
char arg7 = 1;
const char *arg8 = NULL;
char arg8_default = 'V';
const char *arg9 = NULL;
char arg9_default = 'X';
THCharTensor *arg10 = NULL;
int arg10_idx = 0;
char arg11 = 0;
char arg12 = 1;
THCharTensor *arg13 = NULL;
THCharTensor *arg14 = NULL;
char arg15 = 1;
char arg16 = 1;
const char *arg17 = NULL;
char arg17_default = 'V';
const char *arg18 = NULL;
char arg18_default = 'X';
THCharTensor *arg19 = NULL;
int arg19_idx = 0;
char arg20 = 0;
char arg21 = 1;
THCharTensor *arg22 = NULL;
THCharTensor *arg23 = NULL;
char arg24 = 1;
char arg25 = 1;
const char *arg26 = NULL;
char arg26_default = 'V';
const char *arg27 = NULL;
char arg27_default = 'X';
if(narg == 2
&& (arg4 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg4->nDimension == 2)
&& (arg5 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg5->nDimension == 2)
)
{
argset = 1;
arg1 = THCharTensor_new();
arg8 = &arg8_default;
arg9 = &arg9_default;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg4 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg4->nDimension == 2)
&& (arg5 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg5->nDimension == 2)
)
{
argset = 1;
arg1_idx = 1;
arg8 = &arg8_default;
arg9 = &arg9_default;
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg4->nDimension == 2)
&& (arg5 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg5->nDimension == 2)
&& (arg8 = lua_tostring(L, 3)) && (*arg8 == 'V' || *arg8 == 'F')
)
{
argset = 1;
arg1 = THCharTensor_new();
arg9 = &arg9_default;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg4 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg4->nDimension == 2)
&& (arg5 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg5->nDimension == 2)
&& (arg8 = lua_tostring(L, 4)) && (*arg8 == 'V' || *arg8 == 'F')
)
{
argset = 1;
arg1_idx = 1;
arg9 = &arg9_default;
}
else if(narg == 2
&& (arg13 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg13->nDimension == 3)
&& (arg14 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg14->nDimension == 3)
)
{
argset = 2;
arg10 = THCharTensor_new();
arg17 = &arg17_default;
arg18 = &arg18_default;
}
else if(narg == 3
&& (arg10 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg13 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg13->nDimension == 3)
&& (arg14 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg14->nDimension == 3)
)
{
argset = 2;
arg10_idx = 1;
arg17 = &arg17_default;
arg18 = &arg18_default;
}
else if(narg == 3
&& (arg13 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg13->nDimension == 3)
&& (arg14 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg14->nDimension == 3)
&& (arg17 = lua_tostring(L, 3)) && (*arg17 == 'V' || *arg17 == 'F')
)
{
argset = 2;
arg10 = THCharTensor_new();
arg18 = &arg18_default;
}
else if(narg == 4
&& (arg10 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg13 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg13->nDimension == 3)
&& (arg14 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg14->nDimension == 3)
&& (arg17 = lua_tostring(L, 4)) && (*arg17 == 'V' || *arg17 == 'F')
)
{
argset = 2;
arg10_idx = 1;
arg18 = &arg18_default;
}
else if(narg == 2
&& (arg22 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg22->nDimension == 3)
&& (arg23 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg23->nDimension == 4)
)
{
argset = 3;
arg19 = THCharTensor_new();
arg26 = &arg26_default;
arg27 = &arg27_default;
}
else if(narg == 3
&& (arg19 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg22 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg22->nDimension == 3)
&& (arg23 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg23->nDimension == 4)
)
{
argset = 3;
arg19_idx = 1;
arg26 = &arg26_default;
arg27 = &arg27_default;
}
else if(narg == 3
&& (arg22 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg22->nDimension == 3)
&& (arg23 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg23->nDimension == 4)
&& (arg26 = lua_tostring(L, 3)) && (*arg26 == 'V' || *arg26 == 'F')
)
{
argset = 3;
arg19 = THCharTensor_new();
arg27 = &arg27_default;
}
else if(narg == 4
&& (arg19 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg22 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg22->nDimension == 3)
&& (arg23 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg23->nDimension == 4)
&& (arg26 = lua_tostring(L, 4)) && (*arg26 == 'V' || *arg26 == 'F')
)
{
argset = 3;
arg19_idx = 1;
arg27 = &arg27_default;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*CharTensor*] CharTensor~2D CharTensor~2D [(V|F)] | [*CharTensor*] CharTensor~3D CharTensor~3D [(V|F)] | [*CharTensor*] CharTensor~3D CharTensor~4D [(V|F)]", type_buf);
}
if(argset == 1)
{
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.CharTensor");
THCharTensor_conv2Dmul(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9);
return 1;
}
else if(argset == 2)
{
if(arg10_idx)
lua_pushvalue(L, arg10_idx);
else
luaT_pushudata(L, arg10, "torch.CharTensor");
THCharTensor_conv2Dcmul(arg10,arg11,arg12,arg13,arg14,arg15,arg16,arg17,arg18);
return 1;
}
else if(argset == 3)
{
if(arg19_idx)
lua_pushvalue(L, arg19_idx);
else
luaT_pushudata(L, arg19, "torch.CharTensor");
THCharTensor_conv2Dmv(arg19,arg20,arg21,arg22,arg23,arg24,arg25,arg26,arg27);
return 1;
}
return 0;
}

static int torch_CharTensor_conv3(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
char arg2 = 0;
char arg3 = 1;
THCharTensor *arg4 = NULL;
THCharTensor *arg5 = NULL;
char arg6 = 1;
char arg7 = 1;
char arg8 = 1;
const char *arg9 = NULL;
char arg9_default = 'V';
const char *arg10 = NULL;
char arg10_default = 'C';
THCharTensor *arg11 = NULL;
int arg11_idx = 0;
char arg12 = 0;
char arg13 = 1;
THCharTensor *arg14 = NULL;
THCharTensor *arg15 = NULL;
char arg16 = 1;
char arg17 = 1;
char arg18 = 1;
const char *arg19 = NULL;
char arg19_default = 'V';
const char *arg20 = NULL;
char arg20_default = 'C';
THCharTensor *arg21 = NULL;
int arg21_idx = 0;
char arg22 = 0;
char arg23 = 1;
THCharTensor *arg24 = NULL;
THCharTensor *arg25 = NULL;
char arg26 = 1;
char arg27 = 1;
char arg28 = 1;
const char *arg29 = NULL;
char arg29_default = 'V';
const char *arg30 = NULL;
char arg30_default = 'C';
if(narg == 2
&& (arg4 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg4->nDimension == 3)
&& (arg5 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg5->nDimension == 3)
)
{
argset = 1;
arg1 = THCharTensor_new();
arg9 = &arg9_default;
arg10 = &arg10_default;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg4 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg4->nDimension == 3)
&& (arg5 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg5->nDimension == 3)
)
{
argset = 1;
arg1_idx = 1;
arg9 = &arg9_default;
arg10 = &arg10_default;
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg4->nDimension == 3)
&& (arg5 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg5->nDimension == 3)
&& (arg9 = lua_tostring(L, 3)) && (*arg9 == 'V' || *arg9 == 'F')
)
{
argset = 1;
arg1 = THCharTensor_new();
arg10 = &arg10_default;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg4 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg4->nDimension == 3)
&& (arg5 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg5->nDimension == 3)
&& (arg9 = lua_tostring(L, 4)) && (*arg9 == 'V' || *arg9 == 'F')
)
{
argset = 1;
arg1_idx = 1;
arg10 = &arg10_default;
}
else if(narg == 2
&& (arg14 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg14->nDimension == 4)
&& (arg15 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg15->nDimension == 4)
)
{
argset = 2;
arg11 = THCharTensor_new();
arg19 = &arg19_default;
arg20 = &arg20_default;
}
else if(narg == 3
&& (arg11 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg14 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg14->nDimension == 4)
&& (arg15 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg15->nDimension == 4)
)
{
argset = 2;
arg11_idx = 1;
arg19 = &arg19_default;
arg20 = &arg20_default;
}
else if(narg == 3
&& (arg14 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg14->nDimension == 4)
&& (arg15 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg15->nDimension == 4)
&& (arg19 = lua_tostring(L, 3)) && (*arg19 == 'V' || *arg19 == 'F')
)
{
argset = 2;
arg11 = THCharTensor_new();
arg20 = &arg20_default;
}
else if(narg == 4
&& (arg11 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg14 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg14->nDimension == 4)
&& (arg15 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg15->nDimension == 4)
&& (arg19 = lua_tostring(L, 4)) && (*arg19 == 'V' || *arg19 == 'F')
)
{
argset = 2;
arg11_idx = 1;
arg20 = &arg20_default;
}
else if(narg == 2
&& (arg24 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg24->nDimension == 4)
&& (arg25 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg25->nDimension == 5)
)
{
argset = 3;
arg21 = THCharTensor_new();
arg29 = &arg29_default;
arg30 = &arg30_default;
}
else if(narg == 3
&& (arg21 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg24 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg24->nDimension == 4)
&& (arg25 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg25->nDimension == 5)
)
{
argset = 3;
arg21_idx = 1;
arg29 = &arg29_default;
arg30 = &arg30_default;
}
else if(narg == 3
&& (arg24 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg24->nDimension == 4)
&& (arg25 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg25->nDimension == 5)
&& (arg29 = lua_tostring(L, 3)) && (*arg29 == 'V' || *arg29 == 'F')
)
{
argset = 3;
arg21 = THCharTensor_new();
arg30 = &arg30_default;
}
else if(narg == 4
&& (arg21 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg24 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg24->nDimension == 4)
&& (arg25 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg25->nDimension == 5)
&& (arg29 = lua_tostring(L, 4)) && (*arg29 == 'V' || *arg29 == 'F')
)
{
argset = 3;
arg21_idx = 1;
arg30 = &arg30_default;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*CharTensor*] CharTensor~3D CharTensor~3D [(V|F)] | [*CharTensor*] CharTensor~4D CharTensor~4D [(V|F)] | [*CharTensor*] CharTensor~4D CharTensor~5D [(V|F)]", type_buf);
}
if(argset == 1)
{
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.CharTensor");
THCharTensor_conv3Dmul(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10);
return 1;
}
else if(argset == 2)
{
if(arg11_idx)
lua_pushvalue(L, arg11_idx);
else
luaT_pushudata(L, arg11, "torch.CharTensor");
THCharTensor_conv3Dcmul(arg11,arg12,arg13,arg14,arg15,arg16,arg17,arg18,arg19,arg20);
return 1;
}
else if(argset == 3)
{
if(arg21_idx)
lua_pushvalue(L, arg21_idx);
else
luaT_pushudata(L, arg21, "torch.CharTensor");
THCharTensor_conv3Dmv(arg21,arg22,arg23,arg24,arg25,arg26,arg27,arg28,arg29,arg30);
return 1;
}
return 0;
}

static int torch_CharTensor_xcorr3(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
char arg2 = 0;
char arg3 = 1;
THCharTensor *arg4 = NULL;
THCharTensor *arg5 = NULL;
char arg6 = 1;
char arg7 = 1;
char arg8 = 1;
const char *arg9 = NULL;
char arg9_default = 'V';
const char *arg10 = NULL;
char arg10_default = 'X';
THCharTensor *arg11 = NULL;
int arg11_idx = 0;
char arg12 = 0;
char arg13 = 1;
THCharTensor *arg14 = NULL;
THCharTensor *arg15 = NULL;
char arg16 = 1;
char arg17 = 1;
char arg18 = 1;
const char *arg19 = NULL;
char arg19_default = 'V';
const char *arg20 = NULL;
char arg20_default = 'X';
THCharTensor *arg21 = NULL;
int arg21_idx = 0;
char arg22 = 0;
char arg23 = 1;
THCharTensor *arg24 = NULL;
THCharTensor *arg25 = NULL;
char arg26 = 1;
char arg27 = 1;
char arg28 = 1;
const char *arg29 = NULL;
char arg29_default = 'V';
const char *arg30 = NULL;
char arg30_default = 'X';
if(narg == 2
&& (arg4 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg4->nDimension == 3)
&& (arg5 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg5->nDimension == 3)
)
{
argset = 1;
arg1 = THCharTensor_new();
arg9 = &arg9_default;
arg10 = &arg10_default;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg4 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg4->nDimension == 3)
&& (arg5 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg5->nDimension == 3)
)
{
argset = 1;
arg1_idx = 1;
arg9 = &arg9_default;
arg10 = &arg10_default;
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg4->nDimension == 3)
&& (arg5 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg5->nDimension == 3)
&& (arg9 = lua_tostring(L, 3)) && (*arg9 == 'V' || *arg9 == 'F')
)
{
argset = 1;
arg1 = THCharTensor_new();
arg10 = &arg10_default;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg4 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg4->nDimension == 3)
&& (arg5 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg5->nDimension == 3)
&& (arg9 = lua_tostring(L, 4)) && (*arg9 == 'V' || *arg9 == 'F')
)
{
argset = 1;
arg1_idx = 1;
arg10 = &arg10_default;
}
else if(narg == 2
&& (arg14 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg14->nDimension == 4)
&& (arg15 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg15->nDimension == 4)
)
{
argset = 2;
arg11 = THCharTensor_new();
arg19 = &arg19_default;
arg20 = &arg20_default;
}
else if(narg == 3
&& (arg11 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg14 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg14->nDimension == 4)
&& (arg15 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg15->nDimension == 4)
)
{
argset = 2;
arg11_idx = 1;
arg19 = &arg19_default;
arg20 = &arg20_default;
}
else if(narg == 3
&& (arg14 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg14->nDimension == 4)
&& (arg15 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg15->nDimension == 4)
&& (arg19 = lua_tostring(L, 3)) && (*arg19 == 'V' || *arg19 == 'F')
)
{
argset = 2;
arg11 = THCharTensor_new();
arg20 = &arg20_default;
}
else if(narg == 4
&& (arg11 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg14 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg14->nDimension == 4)
&& (arg15 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg15->nDimension == 4)
&& (arg19 = lua_tostring(L, 4)) && (*arg19 == 'V' || *arg19 == 'F')
)
{
argset = 2;
arg11_idx = 1;
arg20 = &arg20_default;
}
else if(narg == 2
&& (arg24 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg24->nDimension == 4)
&& (arg25 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg25->nDimension == 5)
)
{
argset = 3;
arg21 = THCharTensor_new();
arg29 = &arg29_default;
arg30 = &arg30_default;
}
else if(narg == 3
&& (arg21 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg24 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg24->nDimension == 4)
&& (arg25 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg25->nDimension == 5)
)
{
argset = 3;
arg21_idx = 1;
arg29 = &arg29_default;
arg30 = &arg30_default;
}
else if(narg == 3
&& (arg24 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg24->nDimension == 4)
&& (arg25 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg25->nDimension == 5)
&& (arg29 = lua_tostring(L, 3)) && (*arg29 == 'V' || *arg29 == 'F')
)
{
argset = 3;
arg21 = THCharTensor_new();
arg30 = &arg30_default;
}
else if(narg == 4
&& (arg21 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg24 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg24->nDimension == 4)
&& (arg25 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg25->nDimension == 5)
&& (arg29 = lua_tostring(L, 4)) && (*arg29 == 'V' || *arg29 == 'F')
)
{
argset = 3;
arg21_idx = 1;
arg30 = &arg30_default;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*CharTensor*] CharTensor~3D CharTensor~3D [(V|F)] | [*CharTensor*] CharTensor~4D CharTensor~4D [(V|F)] | [*CharTensor*] CharTensor~4D CharTensor~5D [(V|F)]", type_buf);
}
if(argset == 1)
{
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.CharTensor");
THCharTensor_conv3Dmul(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10);
return 1;
}
else if(argset == 2)
{
if(arg11_idx)
lua_pushvalue(L, arg11_idx);
else
luaT_pushudata(L, arg11, "torch.CharTensor");
THCharTensor_conv3Dcmul(arg11,arg12,arg13,arg14,arg15,arg16,arg17,arg18,arg19,arg20);
return 1;
}
else if(argset == 3)
{
if(arg21_idx)
lua_pushvalue(L, arg21_idx);
else
luaT_pushudata(L, arg21, "torch.CharTensor");
THCharTensor_conv3Dmv(arg21,arg22,arg23,arg24,arg25,arg26,arg27,arg28,arg29,arg30);
return 1;
}
return 0;
}

static int torch_CharTensor_lt(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
char arg3 = 0;
THCharTensor *arg4 = NULL;
int arg4_idx = 0;
THCharTensor *arg5 = NULL;
char arg6 = 0;
THByteTensor *arg7 = NULL;
int arg7_idx = 0;
THCharTensor *arg8 = NULL;
THCharTensor *arg9 = NULL;
THCharTensor *arg10 = NULL;
int arg10_idx = 0;
THCharTensor *arg11 = NULL;
THCharTensor *arg12 = NULL;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 1;
arg3 = (char)lua_tonumber(L, 2);
arg1 = THByteTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 1;
arg1_idx = 1;
arg3 = (char)lua_tonumber(L, 3);
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg4_idx = 1;
arg6 = (char)lua_tonumber(L, 3);
}
else if(narg == 2
&& (arg8 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg9 = luaT_toudata(L, 2, "torch.CharTensor"))
)
{
argset = 3;
arg7 = THByteTensor_new();
}
else if(narg == 3
&& (arg7 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg8 = luaT_toudata(L, 2, "torch.CharTensor"))
&& (arg9 = luaT_toudata(L, 3, "torch.CharTensor"))
)
{
argset = 3;
arg7_idx = 1;
}
else if(narg == 3
&& (arg10 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg11 = luaT_toudata(L, 2, "torch.CharTensor"))
&& (arg12 = luaT_toudata(L, 3, "torch.CharTensor"))
)
{
argset = 4;
arg10_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] CharTensor char | *CharTensor* CharTensor char | [*ByteTensor*] CharTensor CharTensor | *CharTensor* CharTensor CharTensor", type_buf);
}
if(argset == 1)
{
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THCharTensor_ltValue(arg1,arg2,arg3);
return 1;
}
else if(argset == 2)
{
lua_pushvalue(L, arg4_idx);
THCharTensor_ltValueT(arg4,arg5,arg6);
return 1;
}
else if(argset == 3)
{
if(arg7_idx)
lua_pushvalue(L, arg7_idx);
else
luaT_pushudata(L, arg7, "torch.ByteTensor");
THCharTensor_ltTensor(arg7,arg8,arg9);
return 1;
}
else if(argset == 4)
{
lua_pushvalue(L, arg10_idx);
THCharTensor_ltTensorT(arg10,arg11,arg12);
return 1;
}
return 0;
}

static int torch_CharTensor_gt(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
char arg3 = 0;
THCharTensor *arg4 = NULL;
int arg4_idx = 0;
THCharTensor *arg5 = NULL;
char arg6 = 0;
THByteTensor *arg7 = NULL;
int arg7_idx = 0;
THCharTensor *arg8 = NULL;
THCharTensor *arg9 = NULL;
THCharTensor *arg10 = NULL;
int arg10_idx = 0;
THCharTensor *arg11 = NULL;
THCharTensor *arg12 = NULL;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 1;
arg3 = (char)lua_tonumber(L, 2);
arg1 = THByteTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 1;
arg1_idx = 1;
arg3 = (char)lua_tonumber(L, 3);
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg4_idx = 1;
arg6 = (char)lua_tonumber(L, 3);
}
else if(narg == 2
&& (arg8 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg9 = luaT_toudata(L, 2, "torch.CharTensor"))
)
{
argset = 3;
arg7 = THByteTensor_new();
}
else if(narg == 3
&& (arg7 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg8 = luaT_toudata(L, 2, "torch.CharTensor"))
&& (arg9 = luaT_toudata(L, 3, "torch.CharTensor"))
)
{
argset = 3;
arg7_idx = 1;
}
else if(narg == 3
&& (arg10 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg11 = luaT_toudata(L, 2, "torch.CharTensor"))
&& (arg12 = luaT_toudata(L, 3, "torch.CharTensor"))
)
{
argset = 4;
arg10_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] CharTensor char | *CharTensor* CharTensor char | [*ByteTensor*] CharTensor CharTensor | *CharTensor* CharTensor CharTensor", type_buf);
}
if(argset == 1)
{
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THCharTensor_gtValue(arg1,arg2,arg3);
return 1;
}
else if(argset == 2)
{
lua_pushvalue(L, arg4_idx);
THCharTensor_gtValueT(arg4,arg5,arg6);
return 1;
}
else if(argset == 3)
{
if(arg7_idx)
lua_pushvalue(L, arg7_idx);
else
luaT_pushudata(L, arg7, "torch.ByteTensor");
THCharTensor_gtTensor(arg7,arg8,arg9);
return 1;
}
else if(argset == 4)
{
lua_pushvalue(L, arg10_idx);
THCharTensor_gtTensorT(arg10,arg11,arg12);
return 1;
}
return 0;
}

static int torch_CharTensor_le(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
char arg3 = 0;
THCharTensor *arg4 = NULL;
int arg4_idx = 0;
THCharTensor *arg5 = NULL;
char arg6 = 0;
THByteTensor *arg7 = NULL;
int arg7_idx = 0;
THCharTensor *arg8 = NULL;
THCharTensor *arg9 = NULL;
THCharTensor *arg10 = NULL;
int arg10_idx = 0;
THCharTensor *arg11 = NULL;
THCharTensor *arg12 = NULL;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 1;
arg3 = (char)lua_tonumber(L, 2);
arg1 = THByteTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 1;
arg1_idx = 1;
arg3 = (char)lua_tonumber(L, 3);
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg4_idx = 1;
arg6 = (char)lua_tonumber(L, 3);
}
else if(narg == 2
&& (arg8 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg9 = luaT_toudata(L, 2, "torch.CharTensor"))
)
{
argset = 3;
arg7 = THByteTensor_new();
}
else if(narg == 3
&& (arg7 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg8 = luaT_toudata(L, 2, "torch.CharTensor"))
&& (arg9 = luaT_toudata(L, 3, "torch.CharTensor"))
)
{
argset = 3;
arg7_idx = 1;
}
else if(narg == 3
&& (arg10 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg11 = luaT_toudata(L, 2, "torch.CharTensor"))
&& (arg12 = luaT_toudata(L, 3, "torch.CharTensor"))
)
{
argset = 4;
arg10_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] CharTensor char | *CharTensor* CharTensor char | [*ByteTensor*] CharTensor CharTensor | *CharTensor* CharTensor CharTensor", type_buf);
}
if(argset == 1)
{
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THCharTensor_leValue(arg1,arg2,arg3);
return 1;
}
else if(argset == 2)
{
lua_pushvalue(L, arg4_idx);
THCharTensor_leValueT(arg4,arg5,arg6);
return 1;
}
else if(argset == 3)
{
if(arg7_idx)
lua_pushvalue(L, arg7_idx);
else
luaT_pushudata(L, arg7, "torch.ByteTensor");
THCharTensor_leTensor(arg7,arg8,arg9);
return 1;
}
else if(argset == 4)
{
lua_pushvalue(L, arg10_idx);
THCharTensor_leTensorT(arg10,arg11,arg12);
return 1;
}
return 0;
}

static int torch_CharTensor_ge(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
char arg3 = 0;
THCharTensor *arg4 = NULL;
int arg4_idx = 0;
THCharTensor *arg5 = NULL;
char arg6 = 0;
THByteTensor *arg7 = NULL;
int arg7_idx = 0;
THCharTensor *arg8 = NULL;
THCharTensor *arg9 = NULL;
THCharTensor *arg10 = NULL;
int arg10_idx = 0;
THCharTensor *arg11 = NULL;
THCharTensor *arg12 = NULL;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 1;
arg3 = (char)lua_tonumber(L, 2);
arg1 = THByteTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 1;
arg1_idx = 1;
arg3 = (char)lua_tonumber(L, 3);
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg4_idx = 1;
arg6 = (char)lua_tonumber(L, 3);
}
else if(narg == 2
&& (arg8 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg9 = luaT_toudata(L, 2, "torch.CharTensor"))
)
{
argset = 3;
arg7 = THByteTensor_new();
}
else if(narg == 3
&& (arg7 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg8 = luaT_toudata(L, 2, "torch.CharTensor"))
&& (arg9 = luaT_toudata(L, 3, "torch.CharTensor"))
)
{
argset = 3;
arg7_idx = 1;
}
else if(narg == 3
&& (arg10 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg11 = luaT_toudata(L, 2, "torch.CharTensor"))
&& (arg12 = luaT_toudata(L, 3, "torch.CharTensor"))
)
{
argset = 4;
arg10_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] CharTensor char | *CharTensor* CharTensor char | [*ByteTensor*] CharTensor CharTensor | *CharTensor* CharTensor CharTensor", type_buf);
}
if(argset == 1)
{
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THCharTensor_geValue(arg1,arg2,arg3);
return 1;
}
else if(argset == 2)
{
lua_pushvalue(L, arg4_idx);
THCharTensor_geValueT(arg4,arg5,arg6);
return 1;
}
else if(argset == 3)
{
if(arg7_idx)
lua_pushvalue(L, arg7_idx);
else
luaT_pushudata(L, arg7, "torch.ByteTensor");
THCharTensor_geTensor(arg7,arg8,arg9);
return 1;
}
else if(argset == 4)
{
lua_pushvalue(L, arg10_idx);
THCharTensor_geTensorT(arg10,arg11,arg12);
return 1;
}
return 0;
}

static int torch_CharTensor_eq(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
char arg3 = 0;
THCharTensor *arg4 = NULL;
int arg4_idx = 0;
THCharTensor *arg5 = NULL;
char arg6 = 0;
THByteTensor *arg7 = NULL;
int arg7_idx = 0;
THCharTensor *arg8 = NULL;
THCharTensor *arg9 = NULL;
THCharTensor *arg10 = NULL;
int arg10_idx = 0;
THCharTensor *arg11 = NULL;
THCharTensor *arg12 = NULL;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 1;
arg3 = (char)lua_tonumber(L, 2);
arg1 = THByteTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 1;
arg1_idx = 1;
arg3 = (char)lua_tonumber(L, 3);
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg4_idx = 1;
arg6 = (char)lua_tonumber(L, 3);
}
else if(narg == 2
&& (arg8 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg9 = luaT_toudata(L, 2, "torch.CharTensor"))
)
{
argset = 3;
arg7 = THByteTensor_new();
}
else if(narg == 3
&& (arg7 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg8 = luaT_toudata(L, 2, "torch.CharTensor"))
&& (arg9 = luaT_toudata(L, 3, "torch.CharTensor"))
)
{
argset = 3;
arg7_idx = 1;
}
else if(narg == 3
&& (arg10 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg11 = luaT_toudata(L, 2, "torch.CharTensor"))
&& (arg12 = luaT_toudata(L, 3, "torch.CharTensor"))
)
{
argset = 4;
arg10_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] CharTensor char | *CharTensor* CharTensor char | [*ByteTensor*] CharTensor CharTensor | *CharTensor* CharTensor CharTensor", type_buf);
}
if(argset == 1)
{
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THCharTensor_eqValue(arg1,arg2,arg3);
return 1;
}
else if(argset == 2)
{
lua_pushvalue(L, arg4_idx);
THCharTensor_eqValueT(arg4,arg5,arg6);
return 1;
}
else if(argset == 3)
{
if(arg7_idx)
lua_pushvalue(L, arg7_idx);
else
luaT_pushudata(L, arg7, "torch.ByteTensor");
THCharTensor_eqTensor(arg7,arg8,arg9);
return 1;
}
else if(argset == 4)
{
lua_pushvalue(L, arg10_idx);
THCharTensor_eqTensorT(arg10,arg11,arg12);
return 1;
}
return 0;
}

static int torch_CharTensor_ne(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
char arg3 = 0;
THCharTensor *arg4 = NULL;
int arg4_idx = 0;
THCharTensor *arg5 = NULL;
char arg6 = 0;
THByteTensor *arg7 = NULL;
int arg7_idx = 0;
THCharTensor *arg8 = NULL;
THCharTensor *arg9 = NULL;
THCharTensor *arg10 = NULL;
int arg10_idx = 0;
THCharTensor *arg11 = NULL;
THCharTensor *arg12 = NULL;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 1;
arg3 = (char)lua_tonumber(L, 2);
arg1 = THByteTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 1;
arg1_idx = 1;
arg3 = (char)lua_tonumber(L, 3);
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg4_idx = 1;
arg6 = (char)lua_tonumber(L, 3);
}
else if(narg == 2
&& (arg8 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg9 = luaT_toudata(L, 2, "torch.CharTensor"))
)
{
argset = 3;
arg7 = THByteTensor_new();
}
else if(narg == 3
&& (arg7 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg8 = luaT_toudata(L, 2, "torch.CharTensor"))
&& (arg9 = luaT_toudata(L, 3, "torch.CharTensor"))
)
{
argset = 3;
arg7_idx = 1;
}
else if(narg == 3
&& (arg10 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg11 = luaT_toudata(L, 2, "torch.CharTensor"))
&& (arg12 = luaT_toudata(L, 3, "torch.CharTensor"))
)
{
argset = 4;
arg10_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] CharTensor char | *CharTensor* CharTensor char | [*ByteTensor*] CharTensor CharTensor | *CharTensor* CharTensor CharTensor", type_buf);
}
if(argset == 1)
{
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THCharTensor_neValue(arg1,arg2,arg3);
return 1;
}
else if(argset == 2)
{
lua_pushvalue(L, arg4_idx);
THCharTensor_neValueT(arg4,arg5,arg6);
return 1;
}
else if(argset == 3)
{
if(arg7_idx)
lua_pushvalue(L, arg7_idx);
else
luaT_pushudata(L, arg7, "torch.ByteTensor");
THCharTensor_neTensor(arg7,arg8,arg9);
return 1;
}
else if(argset == 4)
{
lua_pushvalue(L, arg10_idx);
THCharTensor_neTensorT(arg10,arg11,arg12);
return 1;
}
return 0;
}

static int torch_CharTensor_nonzero(lua_State *L)
{
int narg = lua_gettop(L);
THLongTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
if(narg == 1
&& (arg2 = luaT_toudata(L, 1, "torch.CharTensor"))
)
{
arg1 = THLongTensor_new();
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
)
{
THLongTensor_add(arg1, arg1, -1);
arg1_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*LongTensor*] CharTensor", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.LongTensor");
THCharTensor_nonzero(arg1,arg2);
THLongTensor_add(arg1, arg1, 1);
return 1;
}

static int m_torch_CharTensor_zero(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
if(narg == 1
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
)
{
arg1_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *CharTensor*", type_buf);
}
lua_pushvalue(L, arg1_idx);
THCharTensor_zero(arg1);
return 1;
}

static int m_torch_CharTensor_fill(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
char arg2 = 0;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
)
{
arg1_idx = 1;
arg2 = (char)lua_tonumber(L, 2);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *CharTensor* char", type_buf);
}
lua_pushvalue(L, arg1_idx);
THCharTensor_fill(arg1,arg2);
return 1;
}

static int m_torch_CharTensor_zeros(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THLongStorage *arg2 = NULL;
if(narg >= 2
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& torch_islongargs(L, 2)
)
{
arg1_idx = 1;
arg2 = torch_checklongargs(L, 2);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *CharTensor* (LongStorage | dim1 [dim2...])", type_buf);
}
lua_pushvalue(L, arg1_idx);
THCharTensor_zeros(arg1,arg2);
THLongStorage_free(arg2);
return 1;
}

static int m_torch_CharTensor_ones(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THLongStorage *arg2 = NULL;
if(narg >= 2
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& torch_islongargs(L, 2)
)
{
arg1_idx = 1;
arg2 = torch_checklongargs(L, 2);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *CharTensor* (LongStorage | dim1 [dim2...])", type_buf);
}
lua_pushvalue(L, arg1_idx);
THCharTensor_ones(arg1,arg2);
THLongStorage_free(arg2);
return 1;
}

static int m_torch_CharTensor_reshape(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
THLongStorage *arg3 = NULL;
if(narg >= 2
&& (arg2 = luaT_toudata(L, 1, "torch.CharTensor"))
&& torch_islongargs(L, 2)
)
{
arg3 = torch_checklongargs(L, 2);
arg1 = THCharTensor_new();
}
else if(narg >= 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& torch_islongargs(L, 3)
)
{
arg1_idx = 1;
arg3 = torch_checklongargs(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*CharTensor*] CharTensor (LongStorage | dim1 [dim2...])", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.CharTensor");
THCharTensor_reshape(arg1,arg2,arg3);
THLongStorage_free(arg3);
return 1;
}

static int m_torch_CharTensor_gather(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
long arg3 = 0;
THLongTensor *arg4 = NULL;
if(narg == 3
&& (arg2 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
&& (arg4 = luaT_toudata(L, 3, "torch.LongTensor"))
)
{
arg3 = (long)lua_tonumber(L, 2)-1;
arg1 = THCharTensor_new();
THLongStorage* arg1_size = THLongTensor_newSizeOf(arg4);
THCharTensor_resize(arg1, arg1_size, NULL);
THLongStorage_free(arg1_size);
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
&& (arg4 = luaT_toudata(L, 4, "torch.LongTensor"))
)
{
arg1_idx = 1;
arg3 = (long)lua_tonumber(L, 3)-1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*CharTensor*] CharTensor index LongTensor", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.CharTensor");
THCharTensor_gather(arg1,arg2,arg3,arg4);
return 1;
}

static int m_torch_CharTensor_scatter(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
long arg2 = 0;
THLongTensor *arg3 = NULL;
THCharTensor *arg4 = NULL;
THCharTensor *arg5 = NULL;
int arg5_idx = 0;
long arg6 = 0;
THLongTensor *arg7 = NULL;
char arg8 = 0;
if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
&& (arg3 = luaT_toudata(L, 3, "torch.LongTensor"))
&& (arg4 = luaT_toudata(L, 4, "torch.CharTensor"))
)
{
argset = 1;
arg1_idx = 1;
arg2 = (long)lua_tonumber(L, 2)-1;
}
else if(narg == 4
&& (arg5 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
&& (arg7 = luaT_toudata(L, 3, "torch.LongTensor"))
&& lua_isnumber(L, 4)
)
{
argset = 2;
arg5_idx = 1;
arg6 = (long)lua_tonumber(L, 2)-1;
arg8 = (char)lua_tonumber(L, 4);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *CharTensor* index LongTensor CharTensor | *CharTensor* index LongTensor char", type_buf);
}
if(argset == 1)
{
lua_pushvalue(L, arg1_idx);
THCharTensor_scatter(arg1,arg2,arg3,arg4);
return 1;
}
else if(argset == 2)
{
lua_pushvalue(L, arg5_idx);
THCharTensor_scatterFill(arg5,arg6,arg7,arg8);
return 1;
}
return 0;
}

static int m_torch_CharTensor_dot(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
THCharTensor *arg2 = NULL;
long arg3 = 0;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
)
{
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: CharTensor CharTensor", type_buf);
}
arg3 = THCharTensor_dot(arg1,arg2);
lua_pushnumber(L, (lua_Number)arg3);
return 1;
}

static int m_torch_CharTensor_equal(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
THCharTensor *arg2 = NULL;
int arg3 = 0;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
)
{
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: CharTensor CharTensor", type_buf);
}
arg3 = THCharTensor_equal(arg1,arg2);
lua_pushboolean(L, arg3);
return 1;
}

static int m_torch_CharTensor_add(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
char arg3 = 0;
THCharTensor *arg4 = NULL;
int arg4_idx = 0;
THCharTensor *arg5 = NULL;
char arg6 = 1;
THCharTensor *arg7 = NULL;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 1;
arg1_idx = 1;
arg3 = (char)lua_tonumber(L, 2);
arg2 = arg1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 1;
arg1_idx = 1;
arg3 = (char)lua_tonumber(L, 3);
}
else if(narg == 2
&& (arg4 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg7 = luaT_toudata(L, 2, "torch.CharTensor"))
)
{
argset = 2;
arg4_idx = 1;
arg5 = arg4;
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.CharTensor"))
&& (arg7 = luaT_toudata(L, 3, "torch.CharTensor"))
)
{
argset = 2;
arg4_idx = 1;
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
&& (arg7 = luaT_toudata(L, 3, "torch.CharTensor"))
)
{
argset = 2;
arg4_idx = 1;
arg6 = (char)lua_tonumber(L, 2);
arg5 = arg4;
}
else if(narg == 4
&& (arg4 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
&& (arg7 = luaT_toudata(L, 4, "torch.CharTensor"))
)
{
argset = 2;
arg4_idx = 1;
arg6 = (char)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *CharTensor* [CharTensor] char | *CharTensor* [CharTensor] [char] CharTensor", type_buf);
}
if(argset == 1)
{
lua_pushvalue(L, arg1_idx);
THCharTensor_add(arg1,arg2,arg3);
return 1;
}
else if(argset == 2)
{
lua_pushvalue(L, arg4_idx);
THCharTensor_cadd(arg4,arg5,arg6,arg7);
return 1;
}
return 0;
}

static int m_torch_CharTensor_csub(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
char arg3 = 0;
THCharTensor *arg4 = NULL;
int arg4_idx = 0;
THCharTensor *arg5 = NULL;
char arg6 = 1;
THCharTensor *arg7 = NULL;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 1;
arg1_idx = 1;
arg3 = (char)lua_tonumber(L, 2);
arg2 = arg1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 1;
arg1_idx = 1;
arg3 = (char)lua_tonumber(L, 3);
}
else if(narg == 2
&& (arg4 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg7 = luaT_toudata(L, 2, "torch.CharTensor"))
)
{
argset = 2;
arg4_idx = 1;
arg5 = arg4;
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.CharTensor"))
&& (arg7 = luaT_toudata(L, 3, "torch.CharTensor"))
)
{
argset = 2;
arg4_idx = 1;
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
&& (arg7 = luaT_toudata(L, 3, "torch.CharTensor"))
)
{
argset = 2;
arg4_idx = 1;
arg6 = (char)lua_tonumber(L, 2);
arg5 = arg4;
}
else if(narg == 4
&& (arg4 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
&& (arg7 = luaT_toudata(L, 4, "torch.CharTensor"))
)
{
argset = 2;
arg4_idx = 1;
arg6 = (char)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *CharTensor* [CharTensor] char | *CharTensor* [CharTensor] [char] CharTensor", type_buf);
}
if(argset == 1)
{
lua_pushvalue(L, arg1_idx);
THCharTensor_sub(arg1,arg2,arg3);
return 1;
}
else if(argset == 2)
{
lua_pushvalue(L, arg4_idx);
THCharTensor_csub(arg4,arg5,arg6,arg7);
return 1;
}
return 0;
}

static int m_torch_CharTensor_mul(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
char arg3 = 0;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
)
{
arg1_idx = 1;
arg3 = (char)lua_tonumber(L, 2);
arg2 = arg1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (char)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *CharTensor* [CharTensor] char", type_buf);
}
lua_pushvalue(L, arg1_idx);
THCharTensor_mul(arg1,arg2,arg3);
return 1;
}

static int m_torch_CharTensor_div(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
char arg3 = 0;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
)
{
arg1_idx = 1;
arg3 = (char)lua_tonumber(L, 2);
arg2 = arg1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (char)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *CharTensor* [CharTensor] char", type_buf);
}
lua_pushvalue(L, arg1_idx);
THCharTensor_div(arg1,arg2,arg3);
return 1;
}

static int m_torch_CharTensor_lshift(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
char arg3 = 0;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
)
{
arg1_idx = 1;
arg3 = (char)lua_tonumber(L, 2);
arg2 = arg1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (char)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *CharTensor* [CharTensor] char", type_buf);
}
lua_pushvalue(L, arg1_idx);
THCharTensor_lshift(arg1,arg2,arg3);
return 1;
}

static int m_torch_CharTensor_rshift(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
char arg3 = 0;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
)
{
arg1_idx = 1;
arg3 = (char)lua_tonumber(L, 2);
arg2 = arg1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (char)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *CharTensor* [CharTensor] char", type_buf);
}
lua_pushvalue(L, arg1_idx);
THCharTensor_rshift(arg1,arg2,arg3);
return 1;
}

static int m_torch_CharTensor_fmod(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
char arg3 = 0;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
)
{
arg1_idx = 1;
arg3 = (char)lua_tonumber(L, 2);
arg2 = arg1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (char)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *CharTensor* [CharTensor] char", type_buf);
}
lua_pushvalue(L, arg1_idx);
THCharTensor_fmod(arg1,arg2,arg3);
return 1;
}

static int m_torch_CharTensor_remainder(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
char arg3 = 0;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
)
{
arg1_idx = 1;
arg3 = (char)lua_tonumber(L, 2);
arg2 = arg1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (char)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *CharTensor* [CharTensor] char", type_buf);
}
lua_pushvalue(L, arg1_idx);
THCharTensor_remainder(arg1,arg2,arg3);
return 1;
}

static int m_torch_CharTensor_bitand(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
char arg3 = 0;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
)
{
arg1_idx = 1;
arg3 = (char)lua_tonumber(L, 2);
arg2 = arg1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (char)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *CharTensor* [CharTensor] char", type_buf);
}
lua_pushvalue(L, arg1_idx);
THCharTensor_bitand(arg1,arg2,arg3);
return 1;
}

static int m_torch_CharTensor_bitor(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
char arg3 = 0;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
)
{
arg1_idx = 1;
arg3 = (char)lua_tonumber(L, 2);
arg2 = arg1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (char)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *CharTensor* [CharTensor] char", type_buf);
}
lua_pushvalue(L, arg1_idx);
THCharTensor_bitor(arg1,arg2,arg3);
return 1;
}

static int m_torch_CharTensor_bitxor(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
char arg3 = 0;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
)
{
arg1_idx = 1;
arg3 = (char)lua_tonumber(L, 2);
arg2 = arg1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (char)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *CharTensor* [CharTensor] char", type_buf);
}
lua_pushvalue(L, arg1_idx);
THCharTensor_bitxor(arg1,arg2,arg3);
return 1;
}

static int m_torch_CharTensor_mod(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
char arg3 = 0;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
)
{
arg1_idx = 1;
arg3 = (char)lua_tonumber(L, 2);
arg2 = arg1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (char)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *CharTensor* [CharTensor] char", type_buf);
}
lua_pushvalue(L, arg1_idx);
THCharTensor_fmod(arg1,arg2,arg3);
return 1;
}

static int m_torch_CharTensor_clamp(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
char arg3 = 0;
char arg4 = 0;
if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (char)lua_tonumber(L, 2);
arg4 = (char)lua_tonumber(L, 3);
arg2 = arg1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
&& lua_isnumber(L, 4)
)
{
arg1_idx = 1;
arg3 = (char)lua_tonumber(L, 3);
arg4 = (char)lua_tonumber(L, 4);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *CharTensor* [CharTensor] char char", type_buf);
}
lua_pushvalue(L, arg1_idx);
THCharTensor_clamp(arg1,arg2,arg3,arg4);
return 1;
}

static int m_torch_CharTensor_match(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
THCharTensor *arg3 = NULL;
char arg4 = 1;
if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
)
{
arg1_idx = 1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
&& lua_isnumber(L, 4)
)
{
arg1_idx = 1;
arg4 = (char)lua_tonumber(L, 4);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *CharTensor* CharTensor CharTensor [char]", type_buf);
}
lua_pushvalue(L, arg1_idx);
THCharTensor_match(arg1,arg2,arg3,arg4);
return 1;
}

static int m_torch_CharTensor_cmul(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
THCharTensor *arg3 = NULL;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
)
{
arg1_idx = 1;
arg2 = arg1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
)
{
arg1_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *CharTensor* [CharTensor] CharTensor", type_buf);
}
lua_pushvalue(L, arg1_idx);
THCharTensor_cmul(arg1,arg2,arg3);
return 1;
}

static int m_torch_CharTensor_cpow(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
THCharTensor *arg3 = NULL;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
)
{
arg1_idx = 1;
arg2 = arg1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
)
{
arg1_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *CharTensor* [CharTensor] CharTensor", type_buf);
}
lua_pushvalue(L, arg1_idx);
THCharTensor_cpow(arg1,arg2,arg3);
return 1;
}

static int m_torch_CharTensor_cdiv(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
THCharTensor *arg3 = NULL;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
)
{
arg1_idx = 1;
arg2 = arg1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
)
{
arg1_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *CharTensor* [CharTensor] CharTensor", type_buf);
}
lua_pushvalue(L, arg1_idx);
THCharTensor_cdiv(arg1,arg2,arg3);
return 1;
}

static int m_torch_CharTensor_clshift(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
THCharTensor *arg3 = NULL;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
)
{
arg1_idx = 1;
arg2 = arg1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
)
{
arg1_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *CharTensor* [CharTensor] CharTensor", type_buf);
}
lua_pushvalue(L, arg1_idx);
THCharTensor_clshift(arg1,arg2,arg3);
return 1;
}

static int m_torch_CharTensor_crshift(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
THCharTensor *arg3 = NULL;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
)
{
arg1_idx = 1;
arg2 = arg1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
)
{
arg1_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *CharTensor* [CharTensor] CharTensor", type_buf);
}
lua_pushvalue(L, arg1_idx);
THCharTensor_crshift(arg1,arg2,arg3);
return 1;
}

static int m_torch_CharTensor_cfmod(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
THCharTensor *arg3 = NULL;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
)
{
arg1_idx = 1;
arg2 = arg1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
)
{
arg1_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *CharTensor* [CharTensor] CharTensor", type_buf);
}
lua_pushvalue(L, arg1_idx);
THCharTensor_cfmod(arg1,arg2,arg3);
return 1;
}

static int m_torch_CharTensor_cremainder(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
THCharTensor *arg3 = NULL;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
)
{
arg1_idx = 1;
arg2 = arg1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
)
{
arg1_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *CharTensor* [CharTensor] CharTensor", type_buf);
}
lua_pushvalue(L, arg1_idx);
THCharTensor_cremainder(arg1,arg2,arg3);
return 1;
}

static int m_torch_CharTensor_cbitand(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
THCharTensor *arg3 = NULL;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
)
{
arg1_idx = 1;
arg2 = arg1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
)
{
arg1_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *CharTensor* [CharTensor] CharTensor", type_buf);
}
lua_pushvalue(L, arg1_idx);
THCharTensor_cbitand(arg1,arg2,arg3);
return 1;
}

static int m_torch_CharTensor_cbitor(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
THCharTensor *arg3 = NULL;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
)
{
arg1_idx = 1;
arg2 = arg1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
)
{
arg1_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *CharTensor* [CharTensor] CharTensor", type_buf);
}
lua_pushvalue(L, arg1_idx);
THCharTensor_cbitor(arg1,arg2,arg3);
return 1;
}

static int m_torch_CharTensor_cbitxor(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
THCharTensor *arg3 = NULL;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
)
{
arg1_idx = 1;
arg2 = arg1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
)
{
arg1_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *CharTensor* [CharTensor] CharTensor", type_buf);
}
lua_pushvalue(L, arg1_idx);
THCharTensor_cbitxor(arg1,arg2,arg3);
return 1;
}

static int m_torch_CharTensor_cmod(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
THCharTensor *arg3 = NULL;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
)
{
arg1_idx = 1;
arg2 = arg1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
)
{
arg1_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *CharTensor* [CharTensor] CharTensor", type_buf);
}
lua_pushvalue(L, arg1_idx);
THCharTensor_cfmod(arg1,arg2,arg3);
return 1;
}

static int m_torch_CharTensor_addcmul(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
char arg3 = 1;
THCharTensor *arg4 = NULL;
THCharTensor *arg5 = NULL;
if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg4 = luaT_toudata(L, 2, "torch.CharTensor"))
&& (arg5 = luaT_toudata(L, 3, "torch.CharTensor"))
)
{
arg1_idx = 1;
arg2 = arg1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& (arg4 = luaT_toudata(L, 3, "torch.CharTensor"))
&& (arg5 = luaT_toudata(L, 4, "torch.CharTensor"))
)
{
arg1_idx = 1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
&& (arg4 = luaT_toudata(L, 3, "torch.CharTensor"))
&& (arg5 = luaT_toudata(L, 4, "torch.CharTensor"))
)
{
arg1_idx = 1;
arg3 = (char)lua_tonumber(L, 2);
arg2 = arg1;
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
&& (arg4 = luaT_toudata(L, 4, "torch.CharTensor"))
&& (arg5 = luaT_toudata(L, 5, "torch.CharTensor"))
)
{
arg1_idx = 1;
arg3 = (char)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *CharTensor* [CharTensor] [char] CharTensor CharTensor", type_buf);
}
lua_pushvalue(L, arg1_idx);
THCharTensor_addcmul(arg1,arg2,arg3,arg4,arg5);
return 1;
}

static int m_torch_CharTensor_addcdiv(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
char arg3 = 1;
THCharTensor *arg4 = NULL;
THCharTensor *arg5 = NULL;
if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg4 = luaT_toudata(L, 2, "torch.CharTensor"))
&& (arg5 = luaT_toudata(L, 3, "torch.CharTensor"))
)
{
arg1_idx = 1;
arg2 = arg1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& (arg4 = luaT_toudata(L, 3, "torch.CharTensor"))
&& (arg5 = luaT_toudata(L, 4, "torch.CharTensor"))
)
{
arg1_idx = 1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
&& (arg4 = luaT_toudata(L, 3, "torch.CharTensor"))
&& (arg5 = luaT_toudata(L, 4, "torch.CharTensor"))
)
{
arg1_idx = 1;
arg3 = (char)lua_tonumber(L, 2);
arg2 = arg1;
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
&& (arg4 = luaT_toudata(L, 4, "torch.CharTensor"))
&& (arg5 = luaT_toudata(L, 5, "torch.CharTensor"))
)
{
arg1_idx = 1;
arg3 = (char)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *CharTensor* [CharTensor] [char] CharTensor CharTensor", type_buf);
}
lua_pushvalue(L, arg1_idx);
THCharTensor_addcdiv(arg1,arg2,arg3,arg4,arg5);
return 1;
}

static int m_torch_CharTensor_mv(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
char arg2 = 0;
THCharTensor *arg3 = NULL;
char arg4 = 1;
THCharTensor *arg5 = NULL;
THCharTensor *arg6 = NULL;
if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg6->nDimension == 1)
)
{
arg1_idx = 1;
arg3 = arg1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *CharTensor* CharTensor~2D CharTensor~1D", type_buf);
}
THCharTensor_zero(arg1);
lua_pushvalue(L, arg1_idx);
THCharTensor_addmv(arg1,arg2,arg3,arg4,arg5,arg6);
return 1;
}

static int m_torch_CharTensor_mm(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
char arg2 = 0;
THCharTensor *arg3 = NULL;
char arg4 = 1;
THCharTensor *arg5 = NULL;
THCharTensor *arg6 = NULL;
if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg6->nDimension == 2)
)
{
arg1_idx = 1;
arg3 = arg1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *CharTensor* CharTensor~2D CharTensor~2D", type_buf);
}
THCharTensor_zero(arg1);
lua_pushvalue(L, arg1_idx);
THCharTensor_addmm(arg1,arg2,arg3,arg4,arg5,arg6);
return 1;
}

static int m_torch_CharTensor_bmm(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
char arg2 = 0;
THCharTensor *arg3 = NULL;
char arg4 = 1;
THCharTensor *arg5 = NULL;
THCharTensor *arg6 = NULL;
if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg5->nDimension == 3)
&& (arg6 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg6->nDimension == 3)
)
{
arg1_idx = 1;
arg3 = arg1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *CharTensor* CharTensor~3D CharTensor~3D", type_buf);
}
THCharTensor_zero(arg1);
lua_pushvalue(L, arg1_idx);
THCharTensor_baddbmm(arg1,arg2,arg3,arg4,arg5,arg6);
return 1;
}

static int m_torch_CharTensor_ger(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
char arg2 = 1;
THCharTensor *arg3 = NULL;
char arg4 = 1;
THCharTensor *arg5 = NULL;
THCharTensor *arg6 = NULL;
if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg5->nDimension == 1)
&& (arg6 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg6->nDimension == 1)
)
{
arg1_idx = 1;
arg3 = arg1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *CharTensor* CharTensor~1D CharTensor~1D", type_buf);
}
THCharTensor_zero(arg1);
lua_pushvalue(L, arg1_idx);
THCharTensor_addr(arg1,arg2,arg3,arg4,arg5,arg6);
return 1;
}

static int m_torch_CharTensor_addmv(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
char arg2 = 1;
THCharTensor *arg3 = NULL;
char arg4 = 1;
THCharTensor *arg5 = NULL;
THCharTensor *arg6 = NULL;
THCharTensor *arg7 = NULL;
int arg7_idx = 0;
char arg8 = 0;
THCharTensor *arg9 = NULL;
char arg10 = 0;
THCharTensor *arg11 = NULL;
THCharTensor *arg12 = NULL;
if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg1->nDimension == 1)
&& (arg5 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg6->nDimension == 1)
)
{
argset = 1;
arg1_idx = 1;
arg3 = arg1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg1->nDimension == 1)
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg3->nDimension == 1)
&& (arg5 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 4, "torch.CharTensor")) && (arg6->nDimension == 1)
)
{
argset = 1;
arg1_idx = 1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg1->nDimension == 1)
&& lua_isnumber(L, 2)
&& (arg5 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 4, "torch.CharTensor")) && (arg6->nDimension == 1)
)
{
argset = 1;
arg1_idx = 1;
arg4 = (char)lua_tonumber(L, 2);
arg3 = arg1;
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg1->nDimension == 1)
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg3->nDimension == 1)
&& lua_isnumber(L, 3)
&& (arg5 = luaT_toudata(L, 4, "torch.CharTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 5, "torch.CharTensor")) && (arg6->nDimension == 1)
)
{
argset = 1;
arg1_idx = 1;
arg4 = (char)lua_tonumber(L, 3);
}
else if(narg == 5
&& (arg7 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg7->nDimension == 1)
&& lua_isnumber(L, 2)
&& lua_isnumber(L, 3)
&& (arg11 = luaT_toudata(L, 4, "torch.CharTensor")) && (arg11->nDimension == 2)
&& (arg12 = luaT_toudata(L, 5, "torch.CharTensor")) && (arg12->nDimension == 1)
)
{
argset = 2;
arg7_idx = 1;
arg8 = (char)lua_tonumber(L, 2);
arg10 = (char)lua_tonumber(L, 3);
arg9 = arg7;
}
else if(narg == 6
&& (arg7 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg7->nDimension == 1)
&& lua_isnumber(L, 2)
&& (arg9 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg9->nDimension == 1)
&& lua_isnumber(L, 4)
&& (arg11 = luaT_toudata(L, 5, "torch.CharTensor")) && (arg11->nDimension == 2)
&& (arg12 = luaT_toudata(L, 6, "torch.CharTensor")) && (arg12->nDimension == 1)
)
{
argset = 2;
arg7_idx = 1;
arg8 = (char)lua_tonumber(L, 2);
arg10 = (char)lua_tonumber(L, 4);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *CharTensor~1D* [CharTensor~1D] [char] CharTensor~2D CharTensor~1D | *CharTensor~1D* char [CharTensor~1D] char CharTensor~2D CharTensor~1D", type_buf);
}
if(argset == 1)
{
lua_pushvalue(L, arg1_idx);
THCharTensor_addmv(arg1,arg2,arg3,arg4,arg5,arg6);
return 1;
}
else if(argset == 2)
{
lua_pushvalue(L, arg7_idx);
THCharTensor_addmv(arg7,arg8,arg9,arg10,arg11,arg12);
return 1;
}
return 0;
}

static int m_torch_CharTensor_addmm(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
char arg2 = 1;
THCharTensor *arg3 = NULL;
char arg4 = 1;
THCharTensor *arg5 = NULL;
THCharTensor *arg6 = NULL;
THCharTensor *arg7 = NULL;
int arg7_idx = 0;
char arg8 = 0;
THCharTensor *arg9 = NULL;
char arg10 = 0;
THCharTensor *arg11 = NULL;
THCharTensor *arg12 = NULL;
if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg1->nDimension == 2)
&& (arg5 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg6->nDimension == 2)
)
{
argset = 1;
arg1_idx = 1;
arg3 = arg1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg1->nDimension == 2)
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg3->nDimension == 2)
&& (arg5 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 4, "torch.CharTensor")) && (arg6->nDimension == 2)
)
{
argset = 1;
arg1_idx = 1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg1->nDimension == 2)
&& lua_isnumber(L, 2)
&& (arg5 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 4, "torch.CharTensor")) && (arg6->nDimension == 2)
)
{
argset = 1;
arg1_idx = 1;
arg4 = (char)lua_tonumber(L, 2);
arg3 = arg1;
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg1->nDimension == 2)
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg3->nDimension == 2)
&& lua_isnumber(L, 3)
&& (arg5 = luaT_toudata(L, 4, "torch.CharTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 5, "torch.CharTensor")) && (arg6->nDimension == 2)
)
{
argset = 1;
arg1_idx = 1;
arg4 = (char)lua_tonumber(L, 3);
}
else if(narg == 5
&& (arg7 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg7->nDimension == 2)
&& lua_isnumber(L, 2)
&& lua_isnumber(L, 3)
&& (arg11 = luaT_toudata(L, 4, "torch.CharTensor")) && (arg11->nDimension == 2)
&& (arg12 = luaT_toudata(L, 5, "torch.CharTensor")) && (arg12->nDimension == 2)
)
{
argset = 2;
arg7_idx = 1;
arg8 = (char)lua_tonumber(L, 2);
arg10 = (char)lua_tonumber(L, 3);
arg9 = arg7;
}
else if(narg == 6
&& (arg7 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg7->nDimension == 2)
&& lua_isnumber(L, 2)
&& (arg9 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg9->nDimension == 2)
&& lua_isnumber(L, 4)
&& (arg11 = luaT_toudata(L, 5, "torch.CharTensor")) && (arg11->nDimension == 2)
&& (arg12 = luaT_toudata(L, 6, "torch.CharTensor")) && (arg12->nDimension == 2)
)
{
argset = 2;
arg7_idx = 1;
arg8 = (char)lua_tonumber(L, 2);
arg10 = (char)lua_tonumber(L, 4);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *CharTensor~2D* [CharTensor~2D] [char] CharTensor~2D CharTensor~2D | *CharTensor~2D* char [CharTensor~2D] char CharTensor~2D CharTensor~2D", type_buf);
}
if(argset == 1)
{
lua_pushvalue(L, arg1_idx);
THCharTensor_addmm(arg1,arg2,arg3,arg4,arg5,arg6);
return 1;
}
else if(argset == 2)
{
lua_pushvalue(L, arg7_idx);
THCharTensor_addmm(arg7,arg8,arg9,arg10,arg11,arg12);
return 1;
}
return 0;
}

static int m_torch_CharTensor_addr(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
char arg2 = 1;
THCharTensor *arg3 = NULL;
char arg4 = 1;
THCharTensor *arg5 = NULL;
THCharTensor *arg6 = NULL;
THCharTensor *arg7 = NULL;
int arg7_idx = 0;
char arg8 = 0;
THCharTensor *arg9 = NULL;
char arg10 = 0;
THCharTensor *arg11 = NULL;
THCharTensor *arg12 = NULL;
if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg1->nDimension == 2)
&& (arg5 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg5->nDimension == 1)
&& (arg6 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg6->nDimension == 1)
)
{
argset = 1;
arg1_idx = 1;
arg3 = arg1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg1->nDimension == 2)
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg3->nDimension == 2)
&& (arg5 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg5->nDimension == 1)
&& (arg6 = luaT_toudata(L, 4, "torch.CharTensor")) && (arg6->nDimension == 1)
)
{
argset = 1;
arg1_idx = 1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg1->nDimension == 2)
&& lua_isnumber(L, 2)
&& (arg5 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg5->nDimension == 1)
&& (arg6 = luaT_toudata(L, 4, "torch.CharTensor")) && (arg6->nDimension == 1)
)
{
argset = 1;
arg1_idx = 1;
arg4 = (char)lua_tonumber(L, 2);
arg3 = arg1;
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg1->nDimension == 2)
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg3->nDimension == 2)
&& lua_isnumber(L, 3)
&& (arg5 = luaT_toudata(L, 4, "torch.CharTensor")) && (arg5->nDimension == 1)
&& (arg6 = luaT_toudata(L, 5, "torch.CharTensor")) && (arg6->nDimension == 1)
)
{
argset = 1;
arg1_idx = 1;
arg4 = (char)lua_tonumber(L, 3);
}
else if(narg == 5
&& (arg7 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg7->nDimension == 2)
&& lua_isnumber(L, 2)
&& lua_isnumber(L, 3)
&& (arg11 = luaT_toudata(L, 4, "torch.CharTensor")) && (arg11->nDimension == 1)
&& (arg12 = luaT_toudata(L, 5, "torch.CharTensor")) && (arg12->nDimension == 1)
)
{
argset = 2;
arg7_idx = 1;
arg8 = (char)lua_tonumber(L, 2);
arg10 = (char)lua_tonumber(L, 3);
arg9 = arg7;
}
else if(narg == 6
&& (arg7 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg7->nDimension == 2)
&& lua_isnumber(L, 2)
&& (arg9 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg9->nDimension == 2)
&& lua_isnumber(L, 4)
&& (arg11 = luaT_toudata(L, 5, "torch.CharTensor")) && (arg11->nDimension == 1)
&& (arg12 = luaT_toudata(L, 6, "torch.CharTensor")) && (arg12->nDimension == 1)
)
{
argset = 2;
arg7_idx = 1;
arg8 = (char)lua_tonumber(L, 2);
arg10 = (char)lua_tonumber(L, 4);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *CharTensor~2D* [CharTensor~2D] [char] CharTensor~1D CharTensor~1D | *CharTensor~2D* char [CharTensor~2D] char CharTensor~1D CharTensor~1D", type_buf);
}
if(argset == 1)
{
lua_pushvalue(L, arg1_idx);
THCharTensor_addr(arg1,arg2,arg3,arg4,arg5,arg6);
return 1;
}
else if(argset == 2)
{
lua_pushvalue(L, arg7_idx);
THCharTensor_addr(arg7,arg8,arg9,arg10,arg11,arg12);
return 1;
}
return 0;
}

static int m_torch_CharTensor_addbmm(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
char arg2 = 1;
THCharTensor *arg3 = NULL;
char arg4 = 1;
THCharTensor *arg5 = NULL;
THCharTensor *arg6 = NULL;
THCharTensor *arg7 = NULL;
int arg7_idx = 0;
char arg8 = 0;
THCharTensor *arg9 = NULL;
char arg10 = 0;
THCharTensor *arg11 = NULL;
THCharTensor *arg12 = NULL;
if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg1->nDimension == 2)
&& (arg5 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg5->nDimension == 3)
&& (arg6 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg6->nDimension == 3)
)
{
argset = 1;
arg1_idx = 1;
arg3 = arg1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg1->nDimension == 2)
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg3->nDimension == 2)
&& (arg5 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg5->nDimension == 3)
&& (arg6 = luaT_toudata(L, 4, "torch.CharTensor")) && (arg6->nDimension == 3)
)
{
argset = 1;
arg1_idx = 1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg1->nDimension == 2)
&& lua_isnumber(L, 2)
&& (arg5 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg5->nDimension == 3)
&& (arg6 = luaT_toudata(L, 4, "torch.CharTensor")) && (arg6->nDimension == 3)
)
{
argset = 1;
arg1_idx = 1;
arg4 = (char)lua_tonumber(L, 2);
arg3 = arg1;
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg1->nDimension == 2)
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg3->nDimension == 2)
&& lua_isnumber(L, 3)
&& (arg5 = luaT_toudata(L, 4, "torch.CharTensor")) && (arg5->nDimension == 3)
&& (arg6 = luaT_toudata(L, 5, "torch.CharTensor")) && (arg6->nDimension == 3)
)
{
argset = 1;
arg1_idx = 1;
arg4 = (char)lua_tonumber(L, 3);
}
else if(narg == 5
&& (arg7 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg7->nDimension == 2)
&& lua_isnumber(L, 2)
&& lua_isnumber(L, 3)
&& (arg11 = luaT_toudata(L, 4, "torch.CharTensor")) && (arg11->nDimension == 3)
&& (arg12 = luaT_toudata(L, 5, "torch.CharTensor")) && (arg12->nDimension == 3)
)
{
argset = 2;
arg7_idx = 1;
arg8 = (char)lua_tonumber(L, 2);
arg10 = (char)lua_tonumber(L, 3);
arg9 = arg7;
}
else if(narg == 6
&& (arg7 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg7->nDimension == 2)
&& lua_isnumber(L, 2)
&& (arg9 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg9->nDimension == 2)
&& lua_isnumber(L, 4)
&& (arg11 = luaT_toudata(L, 5, "torch.CharTensor")) && (arg11->nDimension == 3)
&& (arg12 = luaT_toudata(L, 6, "torch.CharTensor")) && (arg12->nDimension == 3)
)
{
argset = 2;
arg7_idx = 1;
arg8 = (char)lua_tonumber(L, 2);
arg10 = (char)lua_tonumber(L, 4);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *CharTensor~2D* [CharTensor~2D] [char] CharTensor~3D CharTensor~3D | *CharTensor~2D* char [CharTensor~2D] char CharTensor~3D CharTensor~3D", type_buf);
}
if(argset == 1)
{
lua_pushvalue(L, arg1_idx);
THCharTensor_addbmm(arg1,arg2,arg3,arg4,arg5,arg6);
return 1;
}
else if(argset == 2)
{
lua_pushvalue(L, arg7_idx);
THCharTensor_addbmm(arg7,arg8,arg9,arg10,arg11,arg12);
return 1;
}
return 0;
}

static int m_torch_CharTensor_baddbmm(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
char arg2 = 1;
THCharTensor *arg3 = NULL;
char arg4 = 1;
THCharTensor *arg5 = NULL;
THCharTensor *arg6 = NULL;
THCharTensor *arg7 = NULL;
int arg7_idx = 0;
char arg8 = 0;
THCharTensor *arg9 = NULL;
char arg10 = 0;
THCharTensor *arg11 = NULL;
THCharTensor *arg12 = NULL;
if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg1->nDimension == 3)
&& (arg5 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg5->nDimension == 3)
&& (arg6 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg6->nDimension == 3)
)
{
argset = 1;
arg1_idx = 1;
arg3 = arg1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg1->nDimension == 3)
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg3->nDimension == 3)
&& (arg5 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg5->nDimension == 3)
&& (arg6 = luaT_toudata(L, 4, "torch.CharTensor")) && (arg6->nDimension == 3)
)
{
argset = 1;
arg1_idx = 1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg1->nDimension == 3)
&& lua_isnumber(L, 2)
&& (arg5 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg5->nDimension == 3)
&& (arg6 = luaT_toudata(L, 4, "torch.CharTensor")) && (arg6->nDimension == 3)
)
{
argset = 1;
arg1_idx = 1;
arg4 = (char)lua_tonumber(L, 2);
arg3 = arg1;
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg1->nDimension == 3)
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg3->nDimension == 3)
&& lua_isnumber(L, 3)
&& (arg5 = luaT_toudata(L, 4, "torch.CharTensor")) && (arg5->nDimension == 3)
&& (arg6 = luaT_toudata(L, 5, "torch.CharTensor")) && (arg6->nDimension == 3)
)
{
argset = 1;
arg1_idx = 1;
arg4 = (char)lua_tonumber(L, 3);
}
else if(narg == 5
&& (arg7 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg7->nDimension == 3)
&& lua_isnumber(L, 2)
&& lua_isnumber(L, 3)
&& (arg11 = luaT_toudata(L, 4, "torch.CharTensor")) && (arg11->nDimension == 3)
&& (arg12 = luaT_toudata(L, 5, "torch.CharTensor")) && (arg12->nDimension == 3)
)
{
argset = 2;
arg7_idx = 1;
arg8 = (char)lua_tonumber(L, 2);
arg10 = (char)lua_tonumber(L, 3);
arg9 = arg7;
}
else if(narg == 6
&& (arg7 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg7->nDimension == 3)
&& lua_isnumber(L, 2)
&& (arg9 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg9->nDimension == 3)
&& lua_isnumber(L, 4)
&& (arg11 = luaT_toudata(L, 5, "torch.CharTensor")) && (arg11->nDimension == 3)
&& (arg12 = luaT_toudata(L, 6, "torch.CharTensor")) && (arg12->nDimension == 3)
)
{
argset = 2;
arg7_idx = 1;
arg8 = (char)lua_tonumber(L, 2);
arg10 = (char)lua_tonumber(L, 4);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *CharTensor~3D* [CharTensor~3D] [char] CharTensor~3D CharTensor~3D | *CharTensor~3D* char [CharTensor~3D] char CharTensor~3D CharTensor~3D", type_buf);
}
if(argset == 1)
{
lua_pushvalue(L, arg1_idx);
THCharTensor_baddbmm(arg1,arg2,arg3,arg4,arg5,arg6);
return 1;
}
else if(argset == 2)
{
lua_pushvalue(L, arg7_idx);
THCharTensor_baddbmm(arg7,arg8,arg9,arg10,arg11,arg12);
return 1;
}
return 0;
}

static int m_torch_CharTensor_numel(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
ptrdiff_t arg2 = 0;
if(narg == 1
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
)
{
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: CharTensor", type_buf);
}
arg2 = THCharTensor_numel(arg1);
lua_pushnumber(L, (lua_Number)arg2);
return 1;
}

static int m_torch_CharTensor_cumsum(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
long arg3 = 0;
if(narg == 1
&& (arg2 = luaT_toudata(L, 1, "torch.CharTensor"))
)
{
arg1 = THCharTensor_new();
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
)
{
arg1_idx = 1;
}
else if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
)
{
arg3 = (long)lua_tonumber(L, 2)-1;
arg1 = THCharTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (long)lua_tonumber(L, 3)-1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*CharTensor*] CharTensor [index]", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.CharTensor");
THCharTensor_cumsum(arg1,arg2,arg3);
return 1;
}

static int m_torch_CharTensor_cumprod(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
long arg3 = 0;
if(narg == 1
&& (arg2 = luaT_toudata(L, 1, "torch.CharTensor"))
)
{
arg1 = THCharTensor_new();
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
)
{
arg1_idx = 1;
}
else if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
)
{
arg3 = (long)lua_tonumber(L, 2)-1;
arg1 = THCharTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (long)lua_tonumber(L, 3)-1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*CharTensor*] CharTensor [index]", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.CharTensor");
THCharTensor_cumprod(arg1,arg2,arg3);
return 1;
}

static int m_torch_CharTensor_sum(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THCharTensor *arg1 = NULL;
long arg2 = 0;
THCharTensor *arg3 = NULL;
int arg3_idx = 0;
THCharTensor *arg4 = NULL;
long arg5 = 0;
int arg6 = 1;
if(narg == 1
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
)
{
argset = 1;
}
else if(narg == 2
&& (arg4 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 2;
arg5 = (long)lua_tonumber(L, 2)-1;
arg3 = THCharTensor_new();
}
else if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg4 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg3_idx = 1;
arg5 = (long)lua_tonumber(L, 3)-1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: CharTensor | [*CharTensor*] CharTensor index", type_buf);
}
if(argset == 1)
{
arg2 = THCharTensor_sumall(arg1);
lua_pushnumber(L, (lua_Number)arg2);
return 1;
}
else if(argset == 2)
{
if(arg3_idx)
lua_pushvalue(L, arg3_idx);
else
luaT_pushudata(L, arg3, "torch.CharTensor");
THCharTensor_sum(arg3,arg4,arg5,arg6);
return 1;
}
return 0;
}

static int m_torch_CharTensor_prod(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THCharTensor *arg1 = NULL;
long arg2 = 0;
THCharTensor *arg3 = NULL;
int arg3_idx = 0;
THCharTensor *arg4 = NULL;
long arg5 = 0;
int arg6 = 1;
if(narg == 1
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
)
{
argset = 1;
}
else if(narg == 2
&& (arg4 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 2;
arg5 = (long)lua_tonumber(L, 2)-1;
arg3 = THCharTensor_new();
}
else if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg4 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg3_idx = 1;
arg5 = (long)lua_tonumber(L, 3)-1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: CharTensor | [*CharTensor*] CharTensor index", type_buf);
}
if(argset == 1)
{
arg2 = THCharTensor_prodall(arg1);
lua_pushnumber(L, (lua_Number)arg2);
return 1;
}
else if(argset == 2)
{
if(arg3_idx)
lua_pushvalue(L, arg3_idx);
else
luaT_pushudata(L, arg3, "torch.CharTensor");
THCharTensor_prod(arg3,arg4,arg5,arg6);
return 1;
}
return 0;
}

static int m_torch_CharTensor_min(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THCharTensor *arg1 = NULL;
char arg2 = 0;
THCharTensor *arg3 = NULL;
int arg3_idx = 0;
THLongTensor *arg4 = NULL;
int arg4_idx = 0;
THCharTensor *arg5 = NULL;
long arg6 = 0;
int arg7 = 1;
if(narg == 1
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
)
{
argset = 1;
}
else if(narg == 2
&& (arg5 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 2;
arg6 = (long)lua_tonumber(L, 2)-1;
arg3 = THCharTensor_new();
arg4 = THLongTensor_new();
}
else if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg3_idx = 1;
arg6 = (long)lua_tonumber(L, 3)-1;
arg4 = THLongTensor_new();
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg4_idx = 1;
arg6 = (long)lua_tonumber(L, 3)-1;
arg3 = THCharTensor_new();
}
else if(narg == 4
&& (arg3 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg4 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg5 = luaT_toudata(L, 3, "torch.CharTensor"))
&& lua_isnumber(L, 4)
)
{
argset = 2;
arg3_idx = 1;
arg4_idx = 2;
arg6 = (long)lua_tonumber(L, 4)-1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: CharTensor | [*CharTensor*] [*LongTensor*] CharTensor index", type_buf);
}
if(argset == 1)
{
arg2 = THCharTensor_minall(arg1);
lua_pushnumber(L, (lua_Number)arg2);
return 1;
}
else if(argset == 2)
{
if(arg3_idx)
lua_pushvalue(L, arg3_idx);
else
luaT_pushudata(L, arg3, "torch.CharTensor");
if(arg4_idx)
lua_pushvalue(L, arg4_idx);
else
luaT_pushudata(L, arg4, "torch.LongTensor");
THCharTensor_min(arg3,arg4,arg5,arg6,arg7);
THLongTensor_add(arg4, arg4, 1);
return 2;
}
return 0;
}

static int m_torch_CharTensor_max(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THCharTensor *arg1 = NULL;
char arg2 = 0;
THCharTensor *arg3 = NULL;
int arg3_idx = 0;
THLongTensor *arg4 = NULL;
int arg4_idx = 0;
THCharTensor *arg5 = NULL;
long arg6 = 0;
int arg7 = 1;
if(narg == 1
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
)
{
argset = 1;
}
else if(narg == 2
&& (arg5 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 2;
arg6 = (long)lua_tonumber(L, 2)-1;
arg3 = THCharTensor_new();
arg4 = THLongTensor_new();
}
else if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg3_idx = 1;
arg6 = (long)lua_tonumber(L, 3)-1;
arg4 = THLongTensor_new();
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg4_idx = 1;
arg6 = (long)lua_tonumber(L, 3)-1;
arg3 = THCharTensor_new();
}
else if(narg == 4
&& (arg3 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg4 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg5 = luaT_toudata(L, 3, "torch.CharTensor"))
&& lua_isnumber(L, 4)
)
{
argset = 2;
arg3_idx = 1;
arg4_idx = 2;
arg6 = (long)lua_tonumber(L, 4)-1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: CharTensor | [*CharTensor*] [*LongTensor*] CharTensor index", type_buf);
}
if(argset == 1)
{
arg2 = THCharTensor_maxall(arg1);
lua_pushnumber(L, (lua_Number)arg2);
return 1;
}
else if(argset == 2)
{
if(arg3_idx)
lua_pushvalue(L, arg3_idx);
else
luaT_pushudata(L, arg3, "torch.CharTensor");
if(arg4_idx)
lua_pushvalue(L, arg4_idx);
else
luaT_pushudata(L, arg4, "torch.LongTensor");
THCharTensor_max(arg3,arg4,arg5,arg6,arg7);
THLongTensor_add(arg4, arg4, 1);
return 2;
}
return 0;
}

static int m_torch_CharTensor_cmin(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
THCharTensor *arg3 = NULL;
THCharTensor *arg4 = NULL;
int arg4_idx = 0;
THCharTensor *arg5 = NULL;
char arg6 = 0;
if(narg == 1
&& (arg3 = luaT_toudata(L, 1, "torch.CharTensor"))
)
{
argset = 1;
arg1 = THCharTensor_new();
arg2 = arg1;
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
)
{
argset = 1;
arg1_idx = 1;
arg2 = arg1;
}
else if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
)
{
argset = 1;
arg1 = THCharTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
)
{
argset = 1;
arg1_idx = 1;
}
else if(narg == 1
&& lua_isnumber(L, 1)
)
{
argset = 2;
arg6 = (char)lua_tonumber(L, 1);
arg4 = THCharTensor_new();
arg5 = arg4;
}
else if(narg == 2
&& (arg4 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 2;
arg4_idx = 1;
arg6 = (char)lua_tonumber(L, 2);
arg5 = arg4;
}
else if(narg == 2
&& (arg5 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 2;
arg6 = (char)lua_tonumber(L, 2);
arg4 = THCharTensor_new();
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg4_idx = 1;
arg6 = (char)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*CharTensor*] [CharTensor] CharTensor | [*CharTensor*] [CharTensor] char", type_buf);
}
if(argset == 1)
{
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.CharTensor");
THCharTensor_cmin(arg1,arg2,arg3);
return 1;
}
else if(argset == 2)
{
if(arg4_idx)
lua_pushvalue(L, arg4_idx);
else
luaT_pushudata(L, arg4, "torch.CharTensor");
THCharTensor_cminValue(arg4,arg5,arg6);
return 1;
}
return 0;
}

static int m_torch_CharTensor_cmax(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
THCharTensor *arg3 = NULL;
THCharTensor *arg4 = NULL;
int arg4_idx = 0;
THCharTensor *arg5 = NULL;
char arg6 = 0;
if(narg == 1
&& (arg3 = luaT_toudata(L, 1, "torch.CharTensor"))
)
{
argset = 1;
arg1 = THCharTensor_new();
arg2 = arg1;
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
)
{
argset = 1;
arg1_idx = 1;
arg2 = arg1;
}
else if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
)
{
argset = 1;
arg1 = THCharTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
)
{
argset = 1;
arg1_idx = 1;
}
else if(narg == 1
&& lua_isnumber(L, 1)
)
{
argset = 2;
arg6 = (char)lua_tonumber(L, 1);
arg4 = THCharTensor_new();
arg5 = arg4;
}
else if(narg == 2
&& (arg4 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 2;
arg4_idx = 1;
arg6 = (char)lua_tonumber(L, 2);
arg5 = arg4;
}
else if(narg == 2
&& (arg5 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 2;
arg6 = (char)lua_tonumber(L, 2);
arg4 = THCharTensor_new();
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg4_idx = 1;
arg6 = (char)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*CharTensor*] [CharTensor] CharTensor | [*CharTensor*] [CharTensor] char", type_buf);
}
if(argset == 1)
{
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.CharTensor");
THCharTensor_cmax(arg1,arg2,arg3);
return 1;
}
else if(argset == 2)
{
if(arg4_idx)
lua_pushvalue(L, arg4_idx);
else
luaT_pushudata(L, arg4, "torch.CharTensor");
THCharTensor_cmaxValue(arg4,arg5,arg6);
return 1;
}
return 0;
}

static int m_torch_CharTensor_trace(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
long arg2 = 0;
if(narg == 1
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
)
{
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: CharTensor", type_buf);
}
arg2 = THCharTensor_trace(arg1);
lua_pushnumber(L, (lua_Number)arg2);
return 1;
}

static int m_torch_CharTensor_cross(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
THCharTensor *arg3 = NULL;
long arg4 = -1;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
)
{
arg1 = THCharTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
)
{
arg1_idx = 1;
}
else if(narg == 3
&& (arg2 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
arg4 = (long)lua_tonumber(L, 3)-1;
arg1 = THCharTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
&& lua_isnumber(L, 4)
)
{
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 4)-1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*CharTensor*] CharTensor CharTensor [index]", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.CharTensor");
THCharTensor_cross(arg1,arg2,arg3,arg4);
return 1;
}

static int m_torch_CharTensor_diag(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
long arg3 = 0;
if(narg == 1
&& (arg2 = luaT_toudata(L, 1, "torch.CharTensor"))
)
{
arg1 = THCharTensor_new();
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
)
{
arg1_idx = 1;
}
else if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
)
{
arg3 = (long)lua_tonumber(L, 2);
arg1 = THCharTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (long)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*CharTensor*] CharTensor [long]", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.CharTensor");
THCharTensor_diag(arg1,arg2,arg3);
return 1;
}

static int m_torch_CharTensor_eye(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
long arg2 = 0;
long arg3 = 0;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
)
{
arg1_idx = 1;
arg2 = (long)lua_tonumber(L, 2);
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg2 = (long)lua_tonumber(L, 2);
arg3 = (long)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *CharTensor* long [long]", type_buf);
}
lua_pushvalue(L, arg1_idx);
THCharTensor_eye(arg1,arg2,arg3);
return 1;
}

static int m_torch_CharTensor_range(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
long arg2 = 0;
long arg3 = 0;
long arg4 = 1;
if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg2 = (long)lua_tonumber(L, 2);
arg3 = (long)lua_tonumber(L, 3);
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
&& lua_isnumber(L, 3)
&& lua_isnumber(L, 4)
)
{
arg1_idx = 1;
arg2 = (long)lua_tonumber(L, 2);
arg3 = (long)lua_tonumber(L, 3);
arg4 = (long)lua_tonumber(L, 4);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *CharTensor* long long [long]", type_buf);
}
lua_pushvalue(L, arg1_idx);
THCharTensor_range(arg1,arg2,arg3,arg4);
return 1;
}

static int m_torch_CharTensor_randperm(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THGenerator *arg2 = NULL;
long arg3 = 0;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
)
{
arg1_idx = 1;
arg3 = (long)lua_tonumber(L, 2);
lua_getglobal(L,"torch");
arg2 = luaT_getfieldcheckudata(L, -1, "_gen", torch_Generator);
lua_pop(L, 2);
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, torch_Generator))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (long)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *CharTensor* [Generator] long", type_buf);
}
lua_pushvalue(L, arg1_idx);
THCharTensor_randperm(arg1,arg2,arg3);

THCharTensor_add(arg1, arg1, 1);
return 1;
}

static int m_torch_CharTensor_sort(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THLongTensor *arg2 = NULL;
int arg2_idx = 0;
THCharTensor *arg3 = NULL;
long arg4 = 0;
int arg5 = 0;
if(narg == 1
&& (arg3 = luaT_toudata(L, 1, "torch.CharTensor"))
)
{
arg1 = THCharTensor_new();
arg2 = THLongTensor_new();
arg4 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
)
{
arg1_idx = 1;
arg2 = THLongTensor_new();
arg4 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
)
{
arg2_idx = 1;
arg1 = THCharTensor_new();
arg4 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 2
&& (arg3 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
)
{
arg4 = (long)lua_tonumber(L, 2)-1;
arg1 = THCharTensor_new();
arg2 = THLongTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 3)-1;
arg2 = THLongTensor_new();
}
else if(narg == 3
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
arg2_idx = 1;
arg4 = (long)lua_tonumber(L, 3)-1;
arg1 = THCharTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
&& lua_isnumber(L, 4)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = (long)lua_tonumber(L, 4)-1;
}
else if(narg == 2
&& (arg3 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isboolean(L, 2)
)
{
arg5 = lua_toboolean(L, 2);
arg1 = THCharTensor_new();
arg2 = THLongTensor_new();
arg4 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isboolean(L, 3)
)
{
arg1_idx = 1;
arg5 = lua_toboolean(L, 3);
arg2 = THLongTensor_new();
arg4 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isboolean(L, 3)
)
{
arg2_idx = 1;
arg5 = lua_toboolean(L, 3);
arg1 = THCharTensor_new();
arg4 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
&& lua_isboolean(L, 4)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg5 = lua_toboolean(L, 4);
arg4 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
&& lua_isboolean(L, 3)
)
{
arg4 = (long)lua_tonumber(L, 2)-1;
arg5 = lua_toboolean(L, 3);
arg1 = THCharTensor_new();
arg2 = THLongTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
)
{
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 3)-1;
arg5 = lua_toboolean(L, 4);
arg2 = THLongTensor_new();
}
else if(narg == 4
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
)
{
arg2_idx = 1;
arg4 = (long)lua_tonumber(L, 3)-1;
arg5 = lua_toboolean(L, 4);
arg1 = THCharTensor_new();
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
&& lua_isnumber(L, 4)
&& lua_isboolean(L, 5)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = (long)lua_tonumber(L, 4)-1;
arg5 = lua_toboolean(L, 5);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*CharTensor*] [*LongTensor*] CharTensor [index] [boolean]", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.CharTensor");
if(arg2_idx)
lua_pushvalue(L, arg2_idx);
else
luaT_pushudata(L, arg2, "torch.LongTensor");
THCharTensor_sort(arg1,arg2,arg3,arg4,arg5);
THLongTensor_add(arg2, arg2, 1);
return 2;
}

static int m_torch_CharTensor_topk(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THLongTensor *arg2 = NULL;
int arg2_idx = 0;
THCharTensor *arg3 = NULL;
long arg4 = 1;
long arg5 = 0;
int arg6 = 0;
int arg7 = 0;
if(narg == 1
&& (arg3 = luaT_toudata(L, 1, "torch.CharTensor"))
)
{
arg1 = THCharTensor_new();
arg2 = THLongTensor_new();
arg5 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
)
{
arg1_idx = 1;
arg2 = THLongTensor_new();
arg5 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
)
{
arg2_idx = 1;
arg1 = THCharTensor_new();
arg5 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
)
{
arg1_idx = 1;
arg2_idx = 2;
arg5 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 2
&& (arg3 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
)
{
arg4 = (long)lua_tonumber(L, 2);
arg1 = THCharTensor_new();
arg2 = THLongTensor_new();
arg5 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg2 = THLongTensor_new();
arg5 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
arg2_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg1 = THCharTensor_new();
arg5 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
&& lua_isnumber(L, 4)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = (long)lua_tonumber(L, 4);
arg5 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 2
&& (arg3 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
)
{
arg5 = (long)lua_tonumber(L, 2)-1;
arg1 = THCharTensor_new();
arg2 = THLongTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg5 = (long)lua_tonumber(L, 3)-1;
arg2 = THLongTensor_new();
}
else if(narg == 3
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
arg2_idx = 1;
arg5 = (long)lua_tonumber(L, 3)-1;
arg1 = THCharTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
&& lua_isnumber(L, 4)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg5 = (long)lua_tonumber(L, 4)-1;
}
else if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
&& lua_isnumber(L, 3)
)
{
arg4 = (long)lua_tonumber(L, 2);
arg5 = (long)lua_tonumber(L, 3)-1;
arg1 = THCharTensor_new();
arg2 = THLongTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
&& lua_isnumber(L, 4)
)
{
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg5 = (long)lua_tonumber(L, 4)-1;
arg2 = THLongTensor_new();
}
else if(narg == 4
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
&& lua_isnumber(L, 4)
)
{
arg2_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg5 = (long)lua_tonumber(L, 4)-1;
arg1 = THCharTensor_new();
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
&& lua_isnumber(L, 4)
&& lua_isnumber(L, 5)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = (long)lua_tonumber(L, 4);
arg5 = (long)lua_tonumber(L, 5)-1;
}
else if(narg == 2
&& (arg3 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isboolean(L, 2)
)
{
arg6 = lua_toboolean(L, 2);
arg1 = THCharTensor_new();
arg2 = THLongTensor_new();
arg5 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isboolean(L, 3)
)
{
arg1_idx = 1;
arg6 = lua_toboolean(L, 3);
arg2 = THLongTensor_new();
arg5 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isboolean(L, 3)
)
{
arg2_idx = 1;
arg6 = lua_toboolean(L, 3);
arg1 = THCharTensor_new();
arg5 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
&& lua_isboolean(L, 4)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg6 = lua_toboolean(L, 4);
arg5 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
&& lua_isboolean(L, 3)
)
{
arg4 = (long)lua_tonumber(L, 2);
arg6 = lua_toboolean(L, 3);
arg1 = THCharTensor_new();
arg2 = THLongTensor_new();
arg5 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
)
{
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg6 = lua_toboolean(L, 4);
arg2 = THLongTensor_new();
arg5 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 4
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
)
{
arg2_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg6 = lua_toboolean(L, 4);
arg1 = THCharTensor_new();
arg5 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
&& lua_isnumber(L, 4)
&& lua_isboolean(L, 5)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = (long)lua_tonumber(L, 4);
arg6 = lua_toboolean(L, 5);
arg5 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
&& lua_isboolean(L, 3)
)
{
arg5 = (long)lua_tonumber(L, 2)-1;
arg6 = lua_toboolean(L, 3);
arg1 = THCharTensor_new();
arg2 = THLongTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
)
{
arg1_idx = 1;
arg5 = (long)lua_tonumber(L, 3)-1;
arg6 = lua_toboolean(L, 4);
arg2 = THLongTensor_new();
}
else if(narg == 4
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
)
{
arg2_idx = 1;
arg5 = (long)lua_tonumber(L, 3)-1;
arg6 = lua_toboolean(L, 4);
arg1 = THCharTensor_new();
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
&& lua_isnumber(L, 4)
&& lua_isboolean(L, 5)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg5 = (long)lua_tonumber(L, 4)-1;
arg6 = lua_toboolean(L, 5);
}
else if(narg == 4
&& (arg3 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
)
{
arg4 = (long)lua_tonumber(L, 2);
arg5 = (long)lua_tonumber(L, 3)-1;
arg6 = lua_toboolean(L, 4);
arg1 = THCharTensor_new();
arg2 = THLongTensor_new();
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
&& lua_isnumber(L, 4)
&& lua_isboolean(L, 5)
)
{
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg5 = (long)lua_tonumber(L, 4)-1;
arg6 = lua_toboolean(L, 5);
arg2 = THLongTensor_new();
}
else if(narg == 5
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
&& lua_isnumber(L, 4)
&& lua_isboolean(L, 5)
)
{
arg2_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg5 = (long)lua_tonumber(L, 4)-1;
arg6 = lua_toboolean(L, 5);
arg1 = THCharTensor_new();
}
else if(narg == 6
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
&& lua_isnumber(L, 4)
&& lua_isnumber(L, 5)
&& lua_isboolean(L, 6)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = (long)lua_tonumber(L, 4);
arg5 = (long)lua_tonumber(L, 5)-1;
arg6 = lua_toboolean(L, 6);
}
else if(narg == 2
&& (arg3 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isboolean(L, 2)
)
{
arg7 = lua_toboolean(L, 2);
arg1 = THCharTensor_new();
arg2 = THLongTensor_new();
arg5 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isboolean(L, 3)
)
{
arg1_idx = 1;
arg7 = lua_toboolean(L, 3);
arg2 = THLongTensor_new();
arg5 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isboolean(L, 3)
)
{
arg2_idx = 1;
arg7 = lua_toboolean(L, 3);
arg1 = THCharTensor_new();
arg5 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
&& lua_isboolean(L, 4)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg7 = lua_toboolean(L, 4);
arg5 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
&& lua_isboolean(L, 3)
)
{
arg4 = (long)lua_tonumber(L, 2);
arg7 = lua_toboolean(L, 3);
arg1 = THCharTensor_new();
arg2 = THLongTensor_new();
arg5 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
)
{
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg7 = lua_toboolean(L, 4);
arg2 = THLongTensor_new();
arg5 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 4
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
)
{
arg2_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg7 = lua_toboolean(L, 4);
arg1 = THCharTensor_new();
arg5 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
&& lua_isnumber(L, 4)
&& lua_isboolean(L, 5)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = (long)lua_tonumber(L, 4);
arg7 = lua_toboolean(L, 5);
arg5 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
&& lua_isboolean(L, 3)
)
{
arg5 = (long)lua_tonumber(L, 2)-1;
arg7 = lua_toboolean(L, 3);
arg1 = THCharTensor_new();
arg2 = THLongTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
)
{
arg1_idx = 1;
arg5 = (long)lua_tonumber(L, 3)-1;
arg7 = lua_toboolean(L, 4);
arg2 = THLongTensor_new();
}
else if(narg == 4
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
)
{
arg2_idx = 1;
arg5 = (long)lua_tonumber(L, 3)-1;
arg7 = lua_toboolean(L, 4);
arg1 = THCharTensor_new();
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
&& lua_isnumber(L, 4)
&& lua_isboolean(L, 5)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg5 = (long)lua_tonumber(L, 4)-1;
arg7 = lua_toboolean(L, 5);
}
else if(narg == 4
&& (arg3 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
)
{
arg4 = (long)lua_tonumber(L, 2);
arg5 = (long)lua_tonumber(L, 3)-1;
arg7 = lua_toboolean(L, 4);
arg1 = THCharTensor_new();
arg2 = THLongTensor_new();
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
&& lua_isnumber(L, 4)
&& lua_isboolean(L, 5)
)
{
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg5 = (long)lua_tonumber(L, 4)-1;
arg7 = lua_toboolean(L, 5);
arg2 = THLongTensor_new();
}
else if(narg == 5
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
&& lua_isnumber(L, 4)
&& lua_isboolean(L, 5)
)
{
arg2_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg5 = (long)lua_tonumber(L, 4)-1;
arg7 = lua_toboolean(L, 5);
arg1 = THCharTensor_new();
}
else if(narg == 6
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
&& lua_isnumber(L, 4)
&& lua_isnumber(L, 5)
&& lua_isboolean(L, 6)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = (long)lua_tonumber(L, 4);
arg5 = (long)lua_tonumber(L, 5)-1;
arg7 = lua_toboolean(L, 6);
}
else if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isboolean(L, 2)
&& lua_isboolean(L, 3)
)
{
arg6 = lua_toboolean(L, 2);
arg7 = lua_toboolean(L, 3);
arg1 = THCharTensor_new();
arg2 = THLongTensor_new();
arg5 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isboolean(L, 3)
&& lua_isboolean(L, 4)
)
{
arg1_idx = 1;
arg6 = lua_toboolean(L, 3);
arg7 = lua_toboolean(L, 4);
arg2 = THLongTensor_new();
arg5 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 4
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isboolean(L, 3)
&& lua_isboolean(L, 4)
)
{
arg2_idx = 1;
arg6 = lua_toboolean(L, 3);
arg7 = lua_toboolean(L, 4);
arg1 = THCharTensor_new();
arg5 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
&& lua_isboolean(L, 4)
&& lua_isboolean(L, 5)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg6 = lua_toboolean(L, 4);
arg7 = lua_toboolean(L, 5);
arg5 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 4
&& (arg3 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
&& lua_isboolean(L, 3)
&& lua_isboolean(L, 4)
)
{
arg4 = (long)lua_tonumber(L, 2);
arg6 = lua_toboolean(L, 3);
arg7 = lua_toboolean(L, 4);
arg1 = THCharTensor_new();
arg2 = THLongTensor_new();
arg5 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
&& lua_isboolean(L, 5)
)
{
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg6 = lua_toboolean(L, 4);
arg7 = lua_toboolean(L, 5);
arg2 = THLongTensor_new();
arg5 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 5
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
&& lua_isboolean(L, 5)
)
{
arg2_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg6 = lua_toboolean(L, 4);
arg7 = lua_toboolean(L, 5);
arg1 = THCharTensor_new();
arg5 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 6
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
&& lua_isnumber(L, 4)
&& lua_isboolean(L, 5)
&& lua_isboolean(L, 6)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = (long)lua_tonumber(L, 4);
arg6 = lua_toboolean(L, 5);
arg7 = lua_toboolean(L, 6);
arg5 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 4
&& (arg3 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
&& lua_isboolean(L, 3)
&& lua_isboolean(L, 4)
)
{
arg5 = (long)lua_tonumber(L, 2)-1;
arg6 = lua_toboolean(L, 3);
arg7 = lua_toboolean(L, 4);
arg1 = THCharTensor_new();
arg2 = THLongTensor_new();
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
&& lua_isboolean(L, 5)
)
{
arg1_idx = 1;
arg5 = (long)lua_tonumber(L, 3)-1;
arg6 = lua_toboolean(L, 4);
arg7 = lua_toboolean(L, 5);
arg2 = THLongTensor_new();
}
else if(narg == 5
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
&& lua_isboolean(L, 5)
)
{
arg2_idx = 1;
arg5 = (long)lua_tonumber(L, 3)-1;
arg6 = lua_toboolean(L, 4);
arg7 = lua_toboolean(L, 5);
arg1 = THCharTensor_new();
}
else if(narg == 6
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
&& lua_isnumber(L, 4)
&& lua_isboolean(L, 5)
&& lua_isboolean(L, 6)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg5 = (long)lua_tonumber(L, 4)-1;
arg6 = lua_toboolean(L, 5);
arg7 = lua_toboolean(L, 6);
}
else if(narg == 5
&& (arg3 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
&& lua_isboolean(L, 5)
)
{
arg4 = (long)lua_tonumber(L, 2);
arg5 = (long)lua_tonumber(L, 3)-1;
arg6 = lua_toboolean(L, 4);
arg7 = lua_toboolean(L, 5);
arg1 = THCharTensor_new();
arg2 = THLongTensor_new();
}
else if(narg == 6
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
&& lua_isnumber(L, 4)
&& lua_isboolean(L, 5)
&& lua_isboolean(L, 6)
)
{
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg5 = (long)lua_tonumber(L, 4)-1;
arg6 = lua_toboolean(L, 5);
arg7 = lua_toboolean(L, 6);
arg2 = THLongTensor_new();
}
else if(narg == 6
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
&& lua_isnumber(L, 4)
&& lua_isboolean(L, 5)
&& lua_isboolean(L, 6)
)
{
arg2_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg5 = (long)lua_tonumber(L, 4)-1;
arg6 = lua_toboolean(L, 5);
arg7 = lua_toboolean(L, 6);
arg1 = THCharTensor_new();
}
else if(narg == 7
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
&& lua_isnumber(L, 4)
&& lua_isnumber(L, 5)
&& lua_isboolean(L, 6)
&& lua_isboolean(L, 7)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = (long)lua_tonumber(L, 4);
arg5 = (long)lua_tonumber(L, 5)-1;
arg6 = lua_toboolean(L, 6);
arg7 = lua_toboolean(L, 7);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*CharTensor*] [*LongTensor*] CharTensor [long] [index] [boolean] [boolean]", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.CharTensor");
if(arg2_idx)
lua_pushvalue(L, arg2_idx);
else
luaT_pushudata(L, arg2, "torch.LongTensor");
THCharTensor_topk(arg1,arg2,arg3,arg4,arg5,arg6,arg7);
THLongTensor_add(arg2, arg2, 1);
return 2;
}

static int m_torch_CharTensor_kthvalue(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THLongTensor *arg2 = NULL;
int arg2_idx = 0;
THCharTensor *arg3 = NULL;
long arg4 = 0;
long arg5 = 0;
int arg6 = 1;
if(narg == 2
&& (arg3 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
)
{
arg4 = (long)lua_tonumber(L, 2);
arg1 = THCharTensor_new();
arg2 = THLongTensor_new();
arg5 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg2 = THLongTensor_new();
arg5 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
arg2_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg1 = THCharTensor_new();
arg5 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
&& lua_isnumber(L, 4)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = (long)lua_tonumber(L, 4);
arg5 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
&& lua_isnumber(L, 3)
)
{
arg4 = (long)lua_tonumber(L, 2);
arg5 = (long)lua_tonumber(L, 3)-1;
arg1 = THCharTensor_new();
arg2 = THLongTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
&& lua_isnumber(L, 4)
)
{
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg5 = (long)lua_tonumber(L, 4)-1;
arg2 = THLongTensor_new();
}
else if(narg == 4
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
&& lua_isnumber(L, 4)
)
{
arg2_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg5 = (long)lua_tonumber(L, 4)-1;
arg1 = THCharTensor_new();
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
&& lua_isnumber(L, 4)
&& lua_isnumber(L, 5)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = (long)lua_tonumber(L, 4);
arg5 = (long)lua_tonumber(L, 5)-1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*CharTensor*] [*LongTensor*] CharTensor long [index]", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.CharTensor");
if(arg2_idx)
lua_pushvalue(L, arg2_idx);
else
luaT_pushudata(L, arg2, "torch.LongTensor");
THCharTensor_kthvalue(arg1,arg2,arg3,arg4,arg5,arg6);
THLongTensor_add(arg2, arg2, 1);
return 2;
}

static int m_torch_CharTensor_mode(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THLongTensor *arg2 = NULL;
int arg2_idx = 0;
THCharTensor *arg3 = NULL;
long arg4 = 0;
int arg5 = 1;
if(narg == 1
&& (arg3 = luaT_toudata(L, 1, "torch.CharTensor"))
)
{
arg1 = THCharTensor_new();
arg2 = THLongTensor_new();
arg4 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
)
{
arg1_idx = 1;
arg2 = THLongTensor_new();
arg4 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
)
{
arg2_idx = 1;
arg1 = THCharTensor_new();
arg4 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 2
&& (arg3 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
)
{
arg4 = (long)lua_tonumber(L, 2)-1;
arg1 = THCharTensor_new();
arg2 = THLongTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 3)-1;
arg2 = THLongTensor_new();
}
else if(narg == 3
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
arg2_idx = 1;
arg4 = (long)lua_tonumber(L, 3)-1;
arg1 = THCharTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
&& lua_isnumber(L, 4)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = (long)lua_tonumber(L, 4)-1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*CharTensor*] [*LongTensor*] CharTensor [index]", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.CharTensor");
if(arg2_idx)
lua_pushvalue(L, arg2_idx);
else
luaT_pushudata(L, arg2, "torch.LongTensor");
THCharTensor_mode(arg1,arg2,arg3,arg4,arg5);
THLongTensor_add(arg2, arg2, 1);
return 2;
}

static int m_torch_CharTensor_median(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THLongTensor *arg2 = NULL;
int arg2_idx = 0;
THCharTensor *arg3 = NULL;
long arg4 = 0;
int arg5 = 1;
if(narg == 1
&& (arg3 = luaT_toudata(L, 1, "torch.CharTensor"))
)
{
arg1 = THCharTensor_new();
arg2 = THLongTensor_new();
arg4 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
)
{
arg1_idx = 1;
arg2 = THLongTensor_new();
arg4 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
)
{
arg2_idx = 1;
arg1 = THCharTensor_new();
arg4 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = THCharTensor_nDimension(arg3)-1;
}
else if(narg == 2
&& (arg3 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
)
{
arg4 = (long)lua_tonumber(L, 2)-1;
arg1 = THCharTensor_new();
arg2 = THLongTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 3)-1;
arg2 = THLongTensor_new();
}
else if(narg == 3
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
arg2_idx = 1;
arg4 = (long)lua_tonumber(L, 3)-1;
arg1 = THCharTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
&& lua_isnumber(L, 4)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = (long)lua_tonumber(L, 4)-1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*CharTensor*] [*LongTensor*] CharTensor [index]", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.CharTensor");
if(arg2_idx)
lua_pushvalue(L, arg2_idx);
else
luaT_pushudata(L, arg2, "torch.LongTensor");
THCharTensor_median(arg1,arg2,arg3,arg4,arg5);
THLongTensor_add(arg2, arg2, 1);
return 2;
}

static int m_torch_CharTensor_tril(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
int arg3 = 0;
if(narg == 1
&& (arg2 = luaT_toudata(L, 1, "torch.CharTensor"))
)
{
arg1 = THCharTensor_new();
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
)
{
arg1_idx = 1;
}
else if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
)
{
arg3 = (int)lua_tonumber(L, 2);
arg1 = THCharTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (int)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*CharTensor*] CharTensor [int]", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.CharTensor");
THCharTensor_tril(arg1,arg2,arg3);
return 1;
}

static int m_torch_CharTensor_triu(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
int arg3 = 0;
if(narg == 1
&& (arg2 = luaT_toudata(L, 1, "torch.CharTensor"))
)
{
arg1 = THCharTensor_new();
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
)
{
arg1_idx = 1;
}
else if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
)
{
arg3 = (int)lua_tonumber(L, 2);
arg1 = THCharTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (int)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*CharTensor*] CharTensor [int]", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.CharTensor");
THCharTensor_triu(arg1,arg2,arg3);
return 1;
}

static int m_torch_CharTensor_cat(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
THCharTensor *arg3 = NULL;
long arg4 = -2;
THCharTensor *arg5 = NULL;
int arg5_idx = 0;
THCharTensor **arg6_data = NULL;
long arg6_size = 0;
int arg6_i = 0;
long arg7 = -2;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
)
{
argset = 1;
arg1 = THCharTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
)
{
argset = 1;
arg1_idx = 1;
}
else if(narg == 3
&& (arg2 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 1;
arg4 = (long)lua_tonumber(L, 3)-1;
arg1 = THCharTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.CharTensor"))
&& lua_isnumber(L, 4)
)
{
argset = 1;
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 4)-1;
}
else if(narg == 1
&& torch_isnonemptytable(L, 1)
)
{
argset = 2;
do
{
  arg6_size++;
  lua_checkstack(L, 1);
  lua_rawgeti(L, 1, arg6_size);
}
while (!lua_isnil(L, -1));
arg6_size--;
lua_pop(L, 1);
arg6_data = (THCharTensor**)THAlloc(arg6_size * sizeof(THCharTensor*));
for (arg6_i = arg6_size - 1; arg6_i >= 0; arg6_i--)
{
  if (!(arg6_data[arg6_i] = luaT_toudata(L, -1, "torch.CharTensor")))
    luaL_error(L, "expected CharTensor in tensor array");
  lua_pop(L, 1);
}

arg5 = THCharTensor_new();
}
else if(narg == 2
&& (arg5 = luaT_toudata(L, 1, "torch.CharTensor"))
&& torch_isnonemptytable(L, 2)
)
{
argset = 2;
arg5_idx = 1;
do
{
  arg6_size++;
  lua_checkstack(L, 1);
  lua_rawgeti(L, 2, arg6_size);
}
while (!lua_isnil(L, -1));
arg6_size--;
lua_pop(L, 1);
arg6_data = (THCharTensor**)THAlloc(arg6_size * sizeof(THCharTensor*));
for (arg6_i = arg6_size - 1; arg6_i >= 0; arg6_i--)
{
  if (!(arg6_data[arg6_i] = luaT_toudata(L, -1, "torch.CharTensor")))
    luaL_error(L, "expected CharTensor in tensor array");
  lua_pop(L, 1);
}

}
else if(narg == 2
&& torch_isnonemptytable(L, 1)
&& lua_isnumber(L, 2)
)
{
argset = 2;
do
{
  arg6_size++;
  lua_checkstack(L, 1);
  lua_rawgeti(L, 1, arg6_size);
}
while (!lua_isnil(L, -1));
arg6_size--;
lua_pop(L, 1);
arg6_data = (THCharTensor**)THAlloc(arg6_size * sizeof(THCharTensor*));
for (arg6_i = arg6_size - 1; arg6_i >= 0; arg6_i--)
{
  if (!(arg6_data[arg6_i] = luaT_toudata(L, -1, "torch.CharTensor")))
    luaL_error(L, "expected CharTensor in tensor array");
  lua_pop(L, 1);
}

arg7 = (long)lua_tonumber(L, 2)-1;
arg5 = THCharTensor_new();
}
else if(narg == 3
&& (arg5 = luaT_toudata(L, 1, "torch.CharTensor"))
&& torch_isnonemptytable(L, 2)
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg5_idx = 1;
do
{
  arg6_size++;
  lua_checkstack(L, 1);
  lua_rawgeti(L, 2, arg6_size);
}
while (!lua_isnil(L, -1));
arg6_size--;
lua_pop(L, 1);
arg6_data = (THCharTensor**)THAlloc(arg6_size * sizeof(THCharTensor*));
for (arg6_i = arg6_size - 1; arg6_i >= 0; arg6_i--)
{
  if (!(arg6_data[arg6_i] = luaT_toudata(L, -1, "torch.CharTensor")))
    luaL_error(L, "expected CharTensor in tensor array");
  lua_pop(L, 1);
}

arg7 = (long)lua_tonumber(L, 3)-1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*CharTensor*] CharTensor CharTensor [index] | [*CharTensor*] {CharTensor+} [index]", type_buf);
}
if(argset == 1)
{
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.CharTensor");
THCharTensor_cat(arg1,arg2,arg3,arg4);
return 1;
}
else if(argset == 2)
{
if(arg5_idx)
lua_pushvalue(L, arg5_idx);
else
luaT_pushudata(L, arg5, "torch.CharTensor");
THCharTensor_catArray(arg5,arg6_data,arg6_size,arg7);
THFree(arg6_data);
return 1;
}
return 0;
}

static int m_torch_CharTensor_random(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THGenerator *arg1 = NULL;
long arg2 = 0;
long arg3 = 0;
long arg4 = 0;
THGenerator *arg5 = NULL;
long arg6 = 0;
long arg7 = 0;
THGenerator *arg8 = NULL;
long arg9 = 0;
THCharTensor *arg10 = NULL;
int arg10_idx = 0;
THGenerator *arg11 = NULL;
long arg12 = 0;
long arg13 = 0;
THCharTensor *arg14 = NULL;
int arg14_idx = 0;
THGenerator *arg15 = NULL;
long arg16 = 0;
THCharTensor *arg17 = NULL;
int arg17_idx = 0;
THGenerator *arg18 = NULL;
if(narg == 2
&& lua_isnumber(L, 1)
&& lua_isnumber(L, 2)
)
{
argset = 1;
arg2 = (long)lua_tonumber(L, 1);
arg3 = (long)lua_tonumber(L, 2);
lua_getglobal(L,"torch");
arg1 = luaT_getfieldcheckudata(L, -1, "_gen", torch_Generator);
lua_pop(L, 2);
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, torch_Generator))
&& lua_isnumber(L, 2)
&& lua_isnumber(L, 3)
)
{
argset = 1;
arg2 = (long)lua_tonumber(L, 2);
arg3 = (long)lua_tonumber(L, 3);
}
else if(narg == 1
&& lua_isnumber(L, 1)
)
{
argset = 2;
arg6 = (long)lua_tonumber(L, 1);
lua_getglobal(L,"torch");
arg5 = luaT_getfieldcheckudata(L, -1, "_gen", torch_Generator);
lua_pop(L, 2);
}
else if(narg == 2
&& (arg5 = luaT_toudata(L, 1, torch_Generator))
&& lua_isnumber(L, 2)
)
{
argset = 2;
arg6 = (long)lua_tonumber(L, 2);
}
else if(narg == 0
)
{
argset = 3;
lua_getglobal(L,"torch");
arg8 = luaT_getfieldcheckudata(L, -1, "_gen", torch_Generator);
lua_pop(L, 2);
}
else if(narg == 1
&& (arg8 = luaT_toudata(L, 1, torch_Generator))
)
{
argset = 3;
}
else if(narg == 3
&& (arg10 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
&& lua_isnumber(L, 3)
)
{
argset = 4;
arg10_idx = 1;
arg12 = (long)lua_tonumber(L, 2);
arg13 = (long)lua_tonumber(L, 3);
lua_getglobal(L,"torch");
arg11 = luaT_getfieldcheckudata(L, -1, "_gen", torch_Generator);
lua_pop(L, 2);
}
else if(narg == 4
&& (arg10 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg11 = luaT_toudata(L, 2, torch_Generator))
&& lua_isnumber(L, 3)
&& lua_isnumber(L, 4)
)
{
argset = 4;
arg10_idx = 1;
arg12 = (long)lua_tonumber(L, 3);
arg13 = (long)lua_tonumber(L, 4);
}
else if(narg == 2
&& (arg14 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 5;
arg14_idx = 1;
arg16 = (long)lua_tonumber(L, 2);
lua_getglobal(L,"torch");
arg15 = luaT_getfieldcheckudata(L, -1, "_gen", torch_Generator);
lua_pop(L, 2);
}
else if(narg == 3
&& (arg14 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg15 = luaT_toudata(L, 2, torch_Generator))
&& lua_isnumber(L, 3)
)
{
argset = 5;
arg14_idx = 1;
arg16 = (long)lua_tonumber(L, 3);
}
else if(narg == 1
&& (arg17 = luaT_toudata(L, 1, "torch.CharTensor"))
)
{
argset = 6;
arg17_idx = 1;
lua_getglobal(L,"torch");
arg18 = luaT_getfieldcheckudata(L, -1, "_gen", torch_Generator);
lua_pop(L, 2);
}
else if(narg == 2
&& (arg17 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg18 = luaT_toudata(L, 2, torch_Generator))
)
{
argset = 6;
arg17_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [Generator] long long | [Generator] long | [Generator] | *CharTensor* [Generator] long long | *CharTensor* [Generator] long | *CharTensor* [Generator]", type_buf);
}
if(argset == 1)
{
arg4 = THRandom_random2__(arg1,arg2,arg3);
lua_pushnumber(L, (lua_Number)arg4);
return 1;
}
else if(argset == 2)
{
arg7 = THRandom_random1__(arg5,arg6);
lua_pushnumber(L, (lua_Number)arg7);
return 1;
}
else if(argset == 3)
{
arg9 = THRandom_random(arg8);
lua_pushnumber(L, (lua_Number)arg9);
return 1;
}
else if(argset == 4)
{
lua_pushvalue(L, arg10_idx);
THCharTensor_random2__(arg10,arg11,arg12,arg13);
return 1;
}
else if(argset == 5)
{
lua_pushvalue(L, arg14_idx);
THCharTensor_random1__(arg14,arg15,arg16);
return 1;
}
else if(argset == 6)
{
lua_pushvalue(L, arg17_idx);
THCharTensor_random(arg17,arg18);
return 1;
}
return 0;
}

static int m_torch_CharTensor_geometric(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THGenerator *arg1 = NULL;
double arg2 = 0;
double arg3 = 0;
THCharTensor *arg4 = NULL;
int arg4_idx = 0;
THGenerator *arg5 = NULL;
double arg6 = 0;
if(narg == 1
&& lua_isnumber(L, 1)
)
{
argset = 1;
arg2 = (double)lua_tonumber(L, 1);
lua_getglobal(L,"torch");
arg1 = luaT_getfieldcheckudata(L, -1, "_gen", torch_Generator);
lua_pop(L, 2);
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, torch_Generator))
&& lua_isnumber(L, 2)
)
{
argset = 1;
arg2 = (double)lua_tonumber(L, 2);
}
else if(narg == 2
&& (arg4 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 2;
arg4_idx = 1;
arg6 = (double)lua_tonumber(L, 2);
lua_getglobal(L,"torch");
arg5 = luaT_getfieldcheckudata(L, -1, "_gen", torch_Generator);
lua_pop(L, 2);
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg5 = luaT_toudata(L, 2, torch_Generator))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg4_idx = 1;
arg6 = (double)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [Generator] double | *CharTensor* [Generator] double", type_buf);
}
if(argset == 1)
{
arg3 = THRandom_geometric(arg1,arg2);
lua_pushnumber(L, (lua_Number)arg3);
return 1;
}
else if(argset == 2)
{
lua_pushvalue(L, arg4_idx);
THCharTensor_geometric(arg4,arg5,arg6);
return 1;
}
return 0;
}

static int m_torch_CharTensor_bernoulli(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THGenerator *arg1 = NULL;
double arg2 = 0.5;
double arg3 = 0;
THCharTensor *arg4 = NULL;
int arg4_idx = 0;
THGenerator *arg5 = NULL;
double arg6 = 0.5;
THCharTensor *arg7 = NULL;
int arg7_idx = 0;
THGenerator *arg8 = NULL;
THFloatTensor *arg9 = NULL;
THCharTensor *arg10 = NULL;
int arg10_idx = 0;
THGenerator *arg11 = NULL;
THDoubleTensor *arg12 = NULL;
if(narg == 0
)
{
argset = 1;
lua_getglobal(L,"torch");
arg1 = luaT_getfieldcheckudata(L, -1, "_gen", torch_Generator);
lua_pop(L, 2);
}
else if(narg == 1
&& (arg1 = luaT_toudata(L, 1, torch_Generator))
)
{
argset = 1;
}
else if(narg == 1
&& lua_isnumber(L, 1)
)
{
argset = 1;
arg2 = (double)lua_tonumber(L, 1);
lua_getglobal(L,"torch");
arg1 = luaT_getfieldcheckudata(L, -1, "_gen", torch_Generator);
lua_pop(L, 2);
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, torch_Generator))
&& lua_isnumber(L, 2)
)
{
argset = 1;
arg2 = (double)lua_tonumber(L, 2);
}
else if(narg == 1
&& (arg4 = luaT_toudata(L, 1, "torch.CharTensor"))
)
{
argset = 2;
arg4_idx = 1;
lua_getglobal(L,"torch");
arg5 = luaT_getfieldcheckudata(L, -1, "_gen", torch_Generator);
lua_pop(L, 2);
}
else if(narg == 2
&& (arg4 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg5 = luaT_toudata(L, 2, torch_Generator))
)
{
argset = 2;
arg4_idx = 1;
}
else if(narg == 2
&& (arg4 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 2;
arg4_idx = 1;
arg6 = (double)lua_tonumber(L, 2);
lua_getglobal(L,"torch");
arg5 = luaT_getfieldcheckudata(L, -1, "_gen", torch_Generator);
lua_pop(L, 2);
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg5 = luaT_toudata(L, 2, torch_Generator))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg4_idx = 1;
arg6 = (double)lua_tonumber(L, 3);
}
else if(narg == 2
&& (arg7 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg9 = luaT_toudata(L, 2, "torch.FloatTensor"))
)
{
argset = 3;
arg7_idx = 1;
lua_getglobal(L,"torch");
arg8 = luaT_getfieldcheckudata(L, -1, "_gen", torch_Generator);
lua_pop(L, 2);
}
else if(narg == 3
&& (arg7 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg8 = luaT_toudata(L, 2, torch_Generator))
&& (arg9 = luaT_toudata(L, 3, "torch.FloatTensor"))
)
{
argset = 3;
arg7_idx = 1;
}
else if(narg == 2
&& (arg10 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg12 = luaT_toudata(L, 2, "torch.DoubleTensor"))
)
{
argset = 4;
arg10_idx = 1;
lua_getglobal(L,"torch");
arg11 = luaT_getfieldcheckudata(L, -1, "_gen", torch_Generator);
lua_pop(L, 2);
}
else if(narg == 3
&& (arg10 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg11 = luaT_toudata(L, 2, torch_Generator))
&& (arg12 = luaT_toudata(L, 3, "torch.DoubleTensor"))
)
{
argset = 4;
arg10_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [Generator] [double] | *CharTensor* [Generator] [double] | *CharTensor* [Generator] FloatTensor | *CharTensor* [Generator] DoubleTensor", type_buf);
}
if(argset == 1)
{
arg3 = THRandom_bernoulli(arg1,arg2);
lua_pushnumber(L, (lua_Number)arg3);
return 1;
}
else if(argset == 2)
{
lua_pushvalue(L, arg4_idx);
THCharTensor_bernoulli(arg4,arg5,arg6);
return 1;
}
else if(argset == 3)
{
lua_pushvalue(L, arg7_idx);
THCharTensor_bernoulli_FloatTensor(arg7,arg8,arg9);
return 1;
}
else if(argset == 4)
{
lua_pushvalue(L, arg10_idx);
THCharTensor_bernoulli_DoubleTensor(arg10,arg11,arg12);
return 1;
}
return 0;
}

static int m_torch_CharTensor_squeeze(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
THCharTensor *arg3 = NULL;
int arg3_idx = 0;
THCharTensor *arg4 = NULL;
long arg5 = 0;
if(narg == 1
&& (arg2 = luaT_toudata(L, 1, "torch.CharTensor"))
)
{
argset = 1;
arg1 = THCharTensor_new();
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
)
{
argset = 1;
arg1_idx = 1;
}
else if(narg == 2
&& (arg4 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 2;
arg5 = (long)lua_tonumber(L, 2)-1;
arg3 = THCharTensor_new();
}
else if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg4 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg3_idx = 1;
arg5 = (long)lua_tonumber(L, 3)-1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*CharTensor*] CharTensor | [*CharTensor*] CharTensor index", type_buf);
}
if(argset == 1)
{
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.CharTensor");
THCharTensor_squeeze(arg1,arg2);
if(arg1->nDimension == 1 && arg1->size[0] == 1)
lua_pushnumber(L, (lua_Number)(*THCharTensor_data(arg1)));
return 1;
}
else if(argset == 2)
{
if(arg3_idx)
lua_pushvalue(L, arg3_idx);
else
luaT_pushudata(L, arg3, "torch.CharTensor");
{int hasdims = arg4->nDimension > 1;
THCharTensor_squeeze1d(arg3,arg4,arg5);
if(!hasdims && arg3->nDimension == 1 && arg3->size[0] == 1)
lua_pushnumber(L, (lua_Number)(*THCharTensor_data(arg3)));}
return 1;
}
return 0;
}

static int m_torch_CharTensor_sign(lua_State *L)
{
int narg = lua_gettop(L);
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
if(narg == 1
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
)
{
arg1_idx = 1;
arg2 = arg1;
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
)
{
arg1_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *CharTensor* [CharTensor]", type_buf);
}
lua_pushvalue(L, arg1_idx);
THCharTensor_sign(arg1,arg2);
return 1;
}

static int m_torch_CharTensor_conv2(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
char arg2 = 0;
char arg3 = 1;
THCharTensor *arg4 = NULL;
THCharTensor *arg5 = NULL;
char arg6 = 1;
char arg7 = 1;
const char *arg8 = NULL;
char arg8_default = 'V';
const char *arg9 = NULL;
char arg9_default = 'C';
THCharTensor *arg10 = NULL;
int arg10_idx = 0;
char arg11 = 0;
char arg12 = 1;
THCharTensor *arg13 = NULL;
THCharTensor *arg14 = NULL;
char arg15 = 1;
char arg16 = 1;
const char *arg17 = NULL;
char arg17_default = 'V';
const char *arg18 = NULL;
char arg18_default = 'C';
THCharTensor *arg19 = NULL;
int arg19_idx = 0;
char arg20 = 0;
char arg21 = 1;
THCharTensor *arg22 = NULL;
THCharTensor *arg23 = NULL;
char arg24 = 1;
char arg25 = 1;
const char *arg26 = NULL;
char arg26_default = 'V';
const char *arg27 = NULL;
char arg27_default = 'C';
if(narg == 2
&& (arg4 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg4->nDimension == 2)
&& (arg5 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg5->nDimension == 2)
)
{
argset = 1;
arg1 = THCharTensor_new();
arg8 = &arg8_default;
arg9 = &arg9_default;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg4 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg4->nDimension == 2)
&& (arg5 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg5->nDimension == 2)
)
{
argset = 1;
arg1_idx = 1;
arg8 = &arg8_default;
arg9 = &arg9_default;
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg4->nDimension == 2)
&& (arg5 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg5->nDimension == 2)
&& (arg8 = lua_tostring(L, 3)) && (*arg8 == 'V' || *arg8 == 'F')
)
{
argset = 1;
arg1 = THCharTensor_new();
arg9 = &arg9_default;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg4 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg4->nDimension == 2)
&& (arg5 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg5->nDimension == 2)
&& (arg8 = lua_tostring(L, 4)) && (*arg8 == 'V' || *arg8 == 'F')
)
{
argset = 1;
arg1_idx = 1;
arg9 = &arg9_default;
}
else if(narg == 2
&& (arg13 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg13->nDimension == 3)
&& (arg14 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg14->nDimension == 3)
)
{
argset = 2;
arg10 = THCharTensor_new();
arg17 = &arg17_default;
arg18 = &arg18_default;
}
else if(narg == 3
&& (arg10 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg13 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg13->nDimension == 3)
&& (arg14 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg14->nDimension == 3)
)
{
argset = 2;
arg10_idx = 1;
arg17 = &arg17_default;
arg18 = &arg18_default;
}
else if(narg == 3
&& (arg13 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg13->nDimension == 3)
&& (arg14 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg14->nDimension == 3)
&& (arg17 = lua_tostring(L, 3)) && (*arg17 == 'V' || *arg17 == 'F')
)
{
argset = 2;
arg10 = THCharTensor_new();
arg18 = &arg18_default;
}
else if(narg == 4
&& (arg10 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg13 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg13->nDimension == 3)
&& (arg14 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg14->nDimension == 3)
&& (arg17 = lua_tostring(L, 4)) && (*arg17 == 'V' || *arg17 == 'F')
)
{
argset = 2;
arg10_idx = 1;
arg18 = &arg18_default;
}
else if(narg == 2
&& (arg22 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg22->nDimension == 3)
&& (arg23 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg23->nDimension == 4)
)
{
argset = 3;
arg19 = THCharTensor_new();
arg26 = &arg26_default;
arg27 = &arg27_default;
}
else if(narg == 3
&& (arg19 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg22 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg22->nDimension == 3)
&& (arg23 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg23->nDimension == 4)
)
{
argset = 3;
arg19_idx = 1;
arg26 = &arg26_default;
arg27 = &arg27_default;
}
else if(narg == 3
&& (arg22 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg22->nDimension == 3)
&& (arg23 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg23->nDimension == 4)
&& (arg26 = lua_tostring(L, 3)) && (*arg26 == 'V' || *arg26 == 'F')
)
{
argset = 3;
arg19 = THCharTensor_new();
arg27 = &arg27_default;
}
else if(narg == 4
&& (arg19 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg22 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg22->nDimension == 3)
&& (arg23 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg23->nDimension == 4)
&& (arg26 = lua_tostring(L, 4)) && (*arg26 == 'V' || *arg26 == 'F')
)
{
argset = 3;
arg19_idx = 1;
arg27 = &arg27_default;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*CharTensor*] CharTensor~2D CharTensor~2D [(V|F)] | [*CharTensor*] CharTensor~3D CharTensor~3D [(V|F)] | [*CharTensor*] CharTensor~3D CharTensor~4D [(V|F)]", type_buf);
}
if(argset == 1)
{
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.CharTensor");
THCharTensor_conv2Dmul(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9);
return 1;
}
else if(argset == 2)
{
if(arg10_idx)
lua_pushvalue(L, arg10_idx);
else
luaT_pushudata(L, arg10, "torch.CharTensor");
THCharTensor_conv2Dcmul(arg10,arg11,arg12,arg13,arg14,arg15,arg16,arg17,arg18);
return 1;
}
else if(argset == 3)
{
if(arg19_idx)
lua_pushvalue(L, arg19_idx);
else
luaT_pushudata(L, arg19, "torch.CharTensor");
THCharTensor_conv2Dmv(arg19,arg20,arg21,arg22,arg23,arg24,arg25,arg26,arg27);
return 1;
}
return 0;
}

static int m_torch_CharTensor_xcorr2(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
char arg2 = 0;
char arg3 = 1;
THCharTensor *arg4 = NULL;
THCharTensor *arg5 = NULL;
char arg6 = 1;
char arg7 = 1;
const char *arg8 = NULL;
char arg8_default = 'V';
const char *arg9 = NULL;
char arg9_default = 'X';
THCharTensor *arg10 = NULL;
int arg10_idx = 0;
char arg11 = 0;
char arg12 = 1;
THCharTensor *arg13 = NULL;
THCharTensor *arg14 = NULL;
char arg15 = 1;
char arg16 = 1;
const char *arg17 = NULL;
char arg17_default = 'V';
const char *arg18 = NULL;
char arg18_default = 'X';
THCharTensor *arg19 = NULL;
int arg19_idx = 0;
char arg20 = 0;
char arg21 = 1;
THCharTensor *arg22 = NULL;
THCharTensor *arg23 = NULL;
char arg24 = 1;
char arg25 = 1;
const char *arg26 = NULL;
char arg26_default = 'V';
const char *arg27 = NULL;
char arg27_default = 'X';
if(narg == 2
&& (arg4 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg4->nDimension == 2)
&& (arg5 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg5->nDimension == 2)
)
{
argset = 1;
arg1 = THCharTensor_new();
arg8 = &arg8_default;
arg9 = &arg9_default;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg4 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg4->nDimension == 2)
&& (arg5 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg5->nDimension == 2)
)
{
argset = 1;
arg1_idx = 1;
arg8 = &arg8_default;
arg9 = &arg9_default;
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg4->nDimension == 2)
&& (arg5 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg5->nDimension == 2)
&& (arg8 = lua_tostring(L, 3)) && (*arg8 == 'V' || *arg8 == 'F')
)
{
argset = 1;
arg1 = THCharTensor_new();
arg9 = &arg9_default;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg4 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg4->nDimension == 2)
&& (arg5 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg5->nDimension == 2)
&& (arg8 = lua_tostring(L, 4)) && (*arg8 == 'V' || *arg8 == 'F')
)
{
argset = 1;
arg1_idx = 1;
arg9 = &arg9_default;
}
else if(narg == 2
&& (arg13 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg13->nDimension == 3)
&& (arg14 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg14->nDimension == 3)
)
{
argset = 2;
arg10 = THCharTensor_new();
arg17 = &arg17_default;
arg18 = &arg18_default;
}
else if(narg == 3
&& (arg10 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg13 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg13->nDimension == 3)
&& (arg14 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg14->nDimension == 3)
)
{
argset = 2;
arg10_idx = 1;
arg17 = &arg17_default;
arg18 = &arg18_default;
}
else if(narg == 3
&& (arg13 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg13->nDimension == 3)
&& (arg14 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg14->nDimension == 3)
&& (arg17 = lua_tostring(L, 3)) && (*arg17 == 'V' || *arg17 == 'F')
)
{
argset = 2;
arg10 = THCharTensor_new();
arg18 = &arg18_default;
}
else if(narg == 4
&& (arg10 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg13 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg13->nDimension == 3)
&& (arg14 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg14->nDimension == 3)
&& (arg17 = lua_tostring(L, 4)) && (*arg17 == 'V' || *arg17 == 'F')
)
{
argset = 2;
arg10_idx = 1;
arg18 = &arg18_default;
}
else if(narg == 2
&& (arg22 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg22->nDimension == 3)
&& (arg23 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg23->nDimension == 4)
)
{
argset = 3;
arg19 = THCharTensor_new();
arg26 = &arg26_default;
arg27 = &arg27_default;
}
else if(narg == 3
&& (arg19 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg22 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg22->nDimension == 3)
&& (arg23 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg23->nDimension == 4)
)
{
argset = 3;
arg19_idx = 1;
arg26 = &arg26_default;
arg27 = &arg27_default;
}
else if(narg == 3
&& (arg22 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg22->nDimension == 3)
&& (arg23 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg23->nDimension == 4)
&& (arg26 = lua_tostring(L, 3)) && (*arg26 == 'V' || *arg26 == 'F')
)
{
argset = 3;
arg19 = THCharTensor_new();
arg27 = &arg27_default;
}
else if(narg == 4
&& (arg19 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg22 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg22->nDimension == 3)
&& (arg23 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg23->nDimension == 4)
&& (arg26 = lua_tostring(L, 4)) && (*arg26 == 'V' || *arg26 == 'F')
)
{
argset = 3;
arg19_idx = 1;
arg27 = &arg27_default;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*CharTensor*] CharTensor~2D CharTensor~2D [(V|F)] | [*CharTensor*] CharTensor~3D CharTensor~3D [(V|F)] | [*CharTensor*] CharTensor~3D CharTensor~4D [(V|F)]", type_buf);
}
if(argset == 1)
{
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.CharTensor");
THCharTensor_conv2Dmul(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9);
return 1;
}
else if(argset == 2)
{
if(arg10_idx)
lua_pushvalue(L, arg10_idx);
else
luaT_pushudata(L, arg10, "torch.CharTensor");
THCharTensor_conv2Dcmul(arg10,arg11,arg12,arg13,arg14,arg15,arg16,arg17,arg18);
return 1;
}
else if(argset == 3)
{
if(arg19_idx)
lua_pushvalue(L, arg19_idx);
else
luaT_pushudata(L, arg19, "torch.CharTensor");
THCharTensor_conv2Dmv(arg19,arg20,arg21,arg22,arg23,arg24,arg25,arg26,arg27);
return 1;
}
return 0;
}

static int m_torch_CharTensor_conv3(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
char arg2 = 0;
char arg3 = 1;
THCharTensor *arg4 = NULL;
THCharTensor *arg5 = NULL;
char arg6 = 1;
char arg7 = 1;
char arg8 = 1;
const char *arg9 = NULL;
char arg9_default = 'V';
const char *arg10 = NULL;
char arg10_default = 'C';
THCharTensor *arg11 = NULL;
int arg11_idx = 0;
char arg12 = 0;
char arg13 = 1;
THCharTensor *arg14 = NULL;
THCharTensor *arg15 = NULL;
char arg16 = 1;
char arg17 = 1;
char arg18 = 1;
const char *arg19 = NULL;
char arg19_default = 'V';
const char *arg20 = NULL;
char arg20_default = 'C';
THCharTensor *arg21 = NULL;
int arg21_idx = 0;
char arg22 = 0;
char arg23 = 1;
THCharTensor *arg24 = NULL;
THCharTensor *arg25 = NULL;
char arg26 = 1;
char arg27 = 1;
char arg28 = 1;
const char *arg29 = NULL;
char arg29_default = 'V';
const char *arg30 = NULL;
char arg30_default = 'C';
if(narg == 2
&& (arg4 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg4->nDimension == 3)
&& (arg5 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg5->nDimension == 3)
)
{
argset = 1;
arg1 = THCharTensor_new();
arg9 = &arg9_default;
arg10 = &arg10_default;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg4 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg4->nDimension == 3)
&& (arg5 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg5->nDimension == 3)
)
{
argset = 1;
arg1_idx = 1;
arg9 = &arg9_default;
arg10 = &arg10_default;
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg4->nDimension == 3)
&& (arg5 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg5->nDimension == 3)
&& (arg9 = lua_tostring(L, 3)) && (*arg9 == 'V' || *arg9 == 'F')
)
{
argset = 1;
arg1 = THCharTensor_new();
arg10 = &arg10_default;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg4 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg4->nDimension == 3)
&& (arg5 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg5->nDimension == 3)
&& (arg9 = lua_tostring(L, 4)) && (*arg9 == 'V' || *arg9 == 'F')
)
{
argset = 1;
arg1_idx = 1;
arg10 = &arg10_default;
}
else if(narg == 2
&& (arg14 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg14->nDimension == 4)
&& (arg15 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg15->nDimension == 4)
)
{
argset = 2;
arg11 = THCharTensor_new();
arg19 = &arg19_default;
arg20 = &arg20_default;
}
else if(narg == 3
&& (arg11 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg14 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg14->nDimension == 4)
&& (arg15 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg15->nDimension == 4)
)
{
argset = 2;
arg11_idx = 1;
arg19 = &arg19_default;
arg20 = &arg20_default;
}
else if(narg == 3
&& (arg14 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg14->nDimension == 4)
&& (arg15 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg15->nDimension == 4)
&& (arg19 = lua_tostring(L, 3)) && (*arg19 == 'V' || *arg19 == 'F')
)
{
argset = 2;
arg11 = THCharTensor_new();
arg20 = &arg20_default;
}
else if(narg == 4
&& (arg11 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg14 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg14->nDimension == 4)
&& (arg15 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg15->nDimension == 4)
&& (arg19 = lua_tostring(L, 4)) && (*arg19 == 'V' || *arg19 == 'F')
)
{
argset = 2;
arg11_idx = 1;
arg20 = &arg20_default;
}
else if(narg == 2
&& (arg24 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg24->nDimension == 4)
&& (arg25 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg25->nDimension == 5)
)
{
argset = 3;
arg21 = THCharTensor_new();
arg29 = &arg29_default;
arg30 = &arg30_default;
}
else if(narg == 3
&& (arg21 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg24 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg24->nDimension == 4)
&& (arg25 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg25->nDimension == 5)
)
{
argset = 3;
arg21_idx = 1;
arg29 = &arg29_default;
arg30 = &arg30_default;
}
else if(narg == 3
&& (arg24 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg24->nDimension == 4)
&& (arg25 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg25->nDimension == 5)
&& (arg29 = lua_tostring(L, 3)) && (*arg29 == 'V' || *arg29 == 'F')
)
{
argset = 3;
arg21 = THCharTensor_new();
arg30 = &arg30_default;
}
else if(narg == 4
&& (arg21 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg24 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg24->nDimension == 4)
&& (arg25 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg25->nDimension == 5)
&& (arg29 = lua_tostring(L, 4)) && (*arg29 == 'V' || *arg29 == 'F')
)
{
argset = 3;
arg21_idx = 1;
arg30 = &arg30_default;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*CharTensor*] CharTensor~3D CharTensor~3D [(V|F)] | [*CharTensor*] CharTensor~4D CharTensor~4D [(V|F)] | [*CharTensor*] CharTensor~4D CharTensor~5D [(V|F)]", type_buf);
}
if(argset == 1)
{
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.CharTensor");
THCharTensor_conv3Dmul(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10);
return 1;
}
else if(argset == 2)
{
if(arg11_idx)
lua_pushvalue(L, arg11_idx);
else
luaT_pushudata(L, arg11, "torch.CharTensor");
THCharTensor_conv3Dcmul(arg11,arg12,arg13,arg14,arg15,arg16,arg17,arg18,arg19,arg20);
return 1;
}
else if(argset == 3)
{
if(arg21_idx)
lua_pushvalue(L, arg21_idx);
else
luaT_pushudata(L, arg21, "torch.CharTensor");
THCharTensor_conv3Dmv(arg21,arg22,arg23,arg24,arg25,arg26,arg27,arg28,arg29,arg30);
return 1;
}
return 0;
}

static int m_torch_CharTensor_xcorr3(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THCharTensor *arg1 = NULL;
int arg1_idx = 0;
char arg2 = 0;
char arg3 = 1;
THCharTensor *arg4 = NULL;
THCharTensor *arg5 = NULL;
char arg6 = 1;
char arg7 = 1;
char arg8 = 1;
const char *arg9 = NULL;
char arg9_default = 'V';
const char *arg10 = NULL;
char arg10_default = 'X';
THCharTensor *arg11 = NULL;
int arg11_idx = 0;
char arg12 = 0;
char arg13 = 1;
THCharTensor *arg14 = NULL;
THCharTensor *arg15 = NULL;
char arg16 = 1;
char arg17 = 1;
char arg18 = 1;
const char *arg19 = NULL;
char arg19_default = 'V';
const char *arg20 = NULL;
char arg20_default = 'X';
THCharTensor *arg21 = NULL;
int arg21_idx = 0;
char arg22 = 0;
char arg23 = 1;
THCharTensor *arg24 = NULL;
THCharTensor *arg25 = NULL;
char arg26 = 1;
char arg27 = 1;
char arg28 = 1;
const char *arg29 = NULL;
char arg29_default = 'V';
const char *arg30 = NULL;
char arg30_default = 'X';
if(narg == 2
&& (arg4 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg4->nDimension == 3)
&& (arg5 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg5->nDimension == 3)
)
{
argset = 1;
arg1 = THCharTensor_new();
arg9 = &arg9_default;
arg10 = &arg10_default;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg4 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg4->nDimension == 3)
&& (arg5 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg5->nDimension == 3)
)
{
argset = 1;
arg1_idx = 1;
arg9 = &arg9_default;
arg10 = &arg10_default;
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg4->nDimension == 3)
&& (arg5 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg5->nDimension == 3)
&& (arg9 = lua_tostring(L, 3)) && (*arg9 == 'V' || *arg9 == 'F')
)
{
argset = 1;
arg1 = THCharTensor_new();
arg10 = &arg10_default;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg4 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg4->nDimension == 3)
&& (arg5 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg5->nDimension == 3)
&& (arg9 = lua_tostring(L, 4)) && (*arg9 == 'V' || *arg9 == 'F')
)
{
argset = 1;
arg1_idx = 1;
arg10 = &arg10_default;
}
else if(narg == 2
&& (arg14 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg14->nDimension == 4)
&& (arg15 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg15->nDimension == 4)
)
{
argset = 2;
arg11 = THCharTensor_new();
arg19 = &arg19_default;
arg20 = &arg20_default;
}
else if(narg == 3
&& (arg11 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg14 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg14->nDimension == 4)
&& (arg15 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg15->nDimension == 4)
)
{
argset = 2;
arg11_idx = 1;
arg19 = &arg19_default;
arg20 = &arg20_default;
}
else if(narg == 3
&& (arg14 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg14->nDimension == 4)
&& (arg15 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg15->nDimension == 4)
&& (arg19 = lua_tostring(L, 3)) && (*arg19 == 'V' || *arg19 == 'F')
)
{
argset = 2;
arg11 = THCharTensor_new();
arg20 = &arg20_default;
}
else if(narg == 4
&& (arg11 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg14 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg14->nDimension == 4)
&& (arg15 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg15->nDimension == 4)
&& (arg19 = lua_tostring(L, 4)) && (*arg19 == 'V' || *arg19 == 'F')
)
{
argset = 2;
arg11_idx = 1;
arg20 = &arg20_default;
}
else if(narg == 2
&& (arg24 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg24->nDimension == 4)
&& (arg25 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg25->nDimension == 5)
)
{
argset = 3;
arg21 = THCharTensor_new();
arg29 = &arg29_default;
arg30 = &arg30_default;
}
else if(narg == 3
&& (arg21 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg24 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg24->nDimension == 4)
&& (arg25 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg25->nDimension == 5)
)
{
argset = 3;
arg21_idx = 1;
arg29 = &arg29_default;
arg30 = &arg30_default;
}
else if(narg == 3
&& (arg24 = luaT_toudata(L, 1, "torch.CharTensor")) && (arg24->nDimension == 4)
&& (arg25 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg25->nDimension == 5)
&& (arg29 = lua_tostring(L, 3)) && (*arg29 == 'V' || *arg29 == 'F')
)
{
argset = 3;
arg21 = THCharTensor_new();
arg30 = &arg30_default;
}
else if(narg == 4
&& (arg21 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg24 = luaT_toudata(L, 2, "torch.CharTensor")) && (arg24->nDimension == 4)
&& (arg25 = luaT_toudata(L, 3, "torch.CharTensor")) && (arg25->nDimension == 5)
&& (arg29 = lua_tostring(L, 4)) && (*arg29 == 'V' || *arg29 == 'F')
)
{
argset = 3;
arg21_idx = 1;
arg30 = &arg30_default;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*CharTensor*] CharTensor~3D CharTensor~3D [(V|F)] | [*CharTensor*] CharTensor~4D CharTensor~4D [(V|F)] | [*CharTensor*] CharTensor~4D CharTensor~5D [(V|F)]", type_buf);
}
if(argset == 1)
{
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.CharTensor");
THCharTensor_conv3Dmul(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10);
return 1;
}
else if(argset == 2)
{
if(arg11_idx)
lua_pushvalue(L, arg11_idx);
else
luaT_pushudata(L, arg11, "torch.CharTensor");
THCharTensor_conv3Dcmul(arg11,arg12,arg13,arg14,arg15,arg16,arg17,arg18,arg19,arg20);
return 1;
}
else if(argset == 3)
{
if(arg21_idx)
lua_pushvalue(L, arg21_idx);
else
luaT_pushudata(L, arg21, "torch.CharTensor");
THCharTensor_conv3Dmv(arg21,arg22,arg23,arg24,arg25,arg26,arg27,arg28,arg29,arg30);
return 1;
}
return 0;
}

static int m_torch_CharTensor_lt(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
char arg3 = 0;
THCharTensor *arg4 = NULL;
int arg4_idx = 0;
THCharTensor *arg5 = NULL;
char arg6 = 0;
THByteTensor *arg7 = NULL;
int arg7_idx = 0;
THCharTensor *arg8 = NULL;
THCharTensor *arg9 = NULL;
THCharTensor *arg10 = NULL;
int arg10_idx = 0;
THCharTensor *arg11 = NULL;
THCharTensor *arg12 = NULL;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 1;
arg3 = (char)lua_tonumber(L, 2);
arg1 = THByteTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 1;
arg1_idx = 1;
arg3 = (char)lua_tonumber(L, 3);
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg4_idx = 1;
arg6 = (char)lua_tonumber(L, 3);
}
else if(narg == 2
&& (arg8 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg9 = luaT_toudata(L, 2, "torch.CharTensor"))
)
{
argset = 3;
arg7 = THByteTensor_new();
}
else if(narg == 3
&& (arg7 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg8 = luaT_toudata(L, 2, "torch.CharTensor"))
&& (arg9 = luaT_toudata(L, 3, "torch.CharTensor"))
)
{
argset = 3;
arg7_idx = 1;
}
else if(narg == 3
&& (arg10 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg11 = luaT_toudata(L, 2, "torch.CharTensor"))
&& (arg12 = luaT_toudata(L, 3, "torch.CharTensor"))
)
{
argset = 4;
arg10_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] CharTensor char | *CharTensor* CharTensor char | [*ByteTensor*] CharTensor CharTensor | *CharTensor* CharTensor CharTensor", type_buf);
}
if(argset == 1)
{
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THCharTensor_ltValue(arg1,arg2,arg3);
return 1;
}
else if(argset == 2)
{
lua_pushvalue(L, arg4_idx);
THCharTensor_ltValueT(arg4,arg5,arg6);
return 1;
}
else if(argset == 3)
{
if(arg7_idx)
lua_pushvalue(L, arg7_idx);
else
luaT_pushudata(L, arg7, "torch.ByteTensor");
THCharTensor_ltTensor(arg7,arg8,arg9);
return 1;
}
else if(argset == 4)
{
lua_pushvalue(L, arg10_idx);
THCharTensor_ltTensorT(arg10,arg11,arg12);
return 1;
}
return 0;
}

static int m_torch_CharTensor_gt(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
char arg3 = 0;
THCharTensor *arg4 = NULL;
int arg4_idx = 0;
THCharTensor *arg5 = NULL;
char arg6 = 0;
THByteTensor *arg7 = NULL;
int arg7_idx = 0;
THCharTensor *arg8 = NULL;
THCharTensor *arg9 = NULL;
THCharTensor *arg10 = NULL;
int arg10_idx = 0;
THCharTensor *arg11 = NULL;
THCharTensor *arg12 = NULL;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 1;
arg3 = (char)lua_tonumber(L, 2);
arg1 = THByteTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 1;
arg1_idx = 1;
arg3 = (char)lua_tonumber(L, 3);
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg4_idx = 1;
arg6 = (char)lua_tonumber(L, 3);
}
else if(narg == 2
&& (arg8 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg9 = luaT_toudata(L, 2, "torch.CharTensor"))
)
{
argset = 3;
arg7 = THByteTensor_new();
}
else if(narg == 3
&& (arg7 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg8 = luaT_toudata(L, 2, "torch.CharTensor"))
&& (arg9 = luaT_toudata(L, 3, "torch.CharTensor"))
)
{
argset = 3;
arg7_idx = 1;
}
else if(narg == 3
&& (arg10 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg11 = luaT_toudata(L, 2, "torch.CharTensor"))
&& (arg12 = luaT_toudata(L, 3, "torch.CharTensor"))
)
{
argset = 4;
arg10_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] CharTensor char | *CharTensor* CharTensor char | [*ByteTensor*] CharTensor CharTensor | *CharTensor* CharTensor CharTensor", type_buf);
}
if(argset == 1)
{
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THCharTensor_gtValue(arg1,arg2,arg3);
return 1;
}
else if(argset == 2)
{
lua_pushvalue(L, arg4_idx);
THCharTensor_gtValueT(arg4,arg5,arg6);
return 1;
}
else if(argset == 3)
{
if(arg7_idx)
lua_pushvalue(L, arg7_idx);
else
luaT_pushudata(L, arg7, "torch.ByteTensor");
THCharTensor_gtTensor(arg7,arg8,arg9);
return 1;
}
else if(argset == 4)
{
lua_pushvalue(L, arg10_idx);
THCharTensor_gtTensorT(arg10,arg11,arg12);
return 1;
}
return 0;
}

static int m_torch_CharTensor_le(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
char arg3 = 0;
THCharTensor *arg4 = NULL;
int arg4_idx = 0;
THCharTensor *arg5 = NULL;
char arg6 = 0;
THByteTensor *arg7 = NULL;
int arg7_idx = 0;
THCharTensor *arg8 = NULL;
THCharTensor *arg9 = NULL;
THCharTensor *arg10 = NULL;
int arg10_idx = 0;
THCharTensor *arg11 = NULL;
THCharTensor *arg12 = NULL;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 1;
arg3 = (char)lua_tonumber(L, 2);
arg1 = THByteTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 1;
arg1_idx = 1;
arg3 = (char)lua_tonumber(L, 3);
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg4_idx = 1;
arg6 = (char)lua_tonumber(L, 3);
}
else if(narg == 2
&& (arg8 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg9 = luaT_toudata(L, 2, "torch.CharTensor"))
)
{
argset = 3;
arg7 = THByteTensor_new();
}
else if(narg == 3
&& (arg7 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg8 = luaT_toudata(L, 2, "torch.CharTensor"))
&& (arg9 = luaT_toudata(L, 3, "torch.CharTensor"))
)
{
argset = 3;
arg7_idx = 1;
}
else if(narg == 3
&& (arg10 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg11 = luaT_toudata(L, 2, "torch.CharTensor"))
&& (arg12 = luaT_toudata(L, 3, "torch.CharTensor"))
)
{
argset = 4;
arg10_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] CharTensor char | *CharTensor* CharTensor char | [*ByteTensor*] CharTensor CharTensor | *CharTensor* CharTensor CharTensor", type_buf);
}
if(argset == 1)
{
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THCharTensor_leValue(arg1,arg2,arg3);
return 1;
}
else if(argset == 2)
{
lua_pushvalue(L, arg4_idx);
THCharTensor_leValueT(arg4,arg5,arg6);
return 1;
}
else if(argset == 3)
{
if(arg7_idx)
lua_pushvalue(L, arg7_idx);
else
luaT_pushudata(L, arg7, "torch.ByteTensor");
THCharTensor_leTensor(arg7,arg8,arg9);
return 1;
}
else if(argset == 4)
{
lua_pushvalue(L, arg10_idx);
THCharTensor_leTensorT(arg10,arg11,arg12);
return 1;
}
return 0;
}

static int m_torch_CharTensor_ge(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
char arg3 = 0;
THCharTensor *arg4 = NULL;
int arg4_idx = 0;
THCharTensor *arg5 = NULL;
char arg6 = 0;
THByteTensor *arg7 = NULL;
int arg7_idx = 0;
THCharTensor *arg8 = NULL;
THCharTensor *arg9 = NULL;
THCharTensor *arg10 = NULL;
int arg10_idx = 0;
THCharTensor *arg11 = NULL;
THCharTensor *arg12 = NULL;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 1;
arg3 = (char)lua_tonumber(L, 2);
arg1 = THByteTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 1;
arg1_idx = 1;
arg3 = (char)lua_tonumber(L, 3);
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg4_idx = 1;
arg6 = (char)lua_tonumber(L, 3);
}
else if(narg == 2
&& (arg8 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg9 = luaT_toudata(L, 2, "torch.CharTensor"))
)
{
argset = 3;
arg7 = THByteTensor_new();
}
else if(narg == 3
&& (arg7 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg8 = luaT_toudata(L, 2, "torch.CharTensor"))
&& (arg9 = luaT_toudata(L, 3, "torch.CharTensor"))
)
{
argset = 3;
arg7_idx = 1;
}
else if(narg == 3
&& (arg10 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg11 = luaT_toudata(L, 2, "torch.CharTensor"))
&& (arg12 = luaT_toudata(L, 3, "torch.CharTensor"))
)
{
argset = 4;
arg10_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] CharTensor char | *CharTensor* CharTensor char | [*ByteTensor*] CharTensor CharTensor | *CharTensor* CharTensor CharTensor", type_buf);
}
if(argset == 1)
{
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THCharTensor_geValue(arg1,arg2,arg3);
return 1;
}
else if(argset == 2)
{
lua_pushvalue(L, arg4_idx);
THCharTensor_geValueT(arg4,arg5,arg6);
return 1;
}
else if(argset == 3)
{
if(arg7_idx)
lua_pushvalue(L, arg7_idx);
else
luaT_pushudata(L, arg7, "torch.ByteTensor");
THCharTensor_geTensor(arg7,arg8,arg9);
return 1;
}
else if(argset == 4)
{
lua_pushvalue(L, arg10_idx);
THCharTensor_geTensorT(arg10,arg11,arg12);
return 1;
}
return 0;
}

static int m_torch_CharTensor_eq(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
char arg3 = 0;
THCharTensor *arg4 = NULL;
int arg4_idx = 0;
THCharTensor *arg5 = NULL;
char arg6 = 0;
THByteTensor *arg7 = NULL;
int arg7_idx = 0;
THCharTensor *arg8 = NULL;
THCharTensor *arg9 = NULL;
THCharTensor *arg10 = NULL;
int arg10_idx = 0;
THCharTensor *arg11 = NULL;
THCharTensor *arg12 = NULL;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 1;
arg3 = (char)lua_tonumber(L, 2);
arg1 = THByteTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 1;
arg1_idx = 1;
arg3 = (char)lua_tonumber(L, 3);
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg4_idx = 1;
arg6 = (char)lua_tonumber(L, 3);
}
else if(narg == 2
&& (arg8 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg9 = luaT_toudata(L, 2, "torch.CharTensor"))
)
{
argset = 3;
arg7 = THByteTensor_new();
}
else if(narg == 3
&& (arg7 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg8 = luaT_toudata(L, 2, "torch.CharTensor"))
&& (arg9 = luaT_toudata(L, 3, "torch.CharTensor"))
)
{
argset = 3;
arg7_idx = 1;
}
else if(narg == 3
&& (arg10 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg11 = luaT_toudata(L, 2, "torch.CharTensor"))
&& (arg12 = luaT_toudata(L, 3, "torch.CharTensor"))
)
{
argset = 4;
arg10_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] CharTensor char | *CharTensor* CharTensor char | [*ByteTensor*] CharTensor CharTensor | *CharTensor* CharTensor CharTensor", type_buf);
}
if(argset == 1)
{
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THCharTensor_eqValue(arg1,arg2,arg3);
return 1;
}
else if(argset == 2)
{
lua_pushvalue(L, arg4_idx);
THCharTensor_eqValueT(arg4,arg5,arg6);
return 1;
}
else if(argset == 3)
{
if(arg7_idx)
lua_pushvalue(L, arg7_idx);
else
luaT_pushudata(L, arg7, "torch.ByteTensor");
THCharTensor_eqTensor(arg7,arg8,arg9);
return 1;
}
else if(argset == 4)
{
lua_pushvalue(L, arg10_idx);
THCharTensor_eqTensorT(arg10,arg11,arg12);
return 1;
}
return 0;
}

static int m_torch_CharTensor_ne(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
char arg3 = 0;
THCharTensor *arg4 = NULL;
int arg4_idx = 0;
THCharTensor *arg5 = NULL;
char arg6 = 0;
THByteTensor *arg7 = NULL;
int arg7_idx = 0;
THCharTensor *arg8 = NULL;
THCharTensor *arg9 = NULL;
THCharTensor *arg10 = NULL;
int arg10_idx = 0;
THCharTensor *arg11 = NULL;
THCharTensor *arg12 = NULL;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.CharTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 1;
arg3 = (char)lua_tonumber(L, 2);
arg1 = THByteTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 1;
arg1_idx = 1;
arg3 = (char)lua_tonumber(L, 3);
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.CharTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg4_idx = 1;
arg6 = (char)lua_tonumber(L, 3);
}
else if(narg == 2
&& (arg8 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg9 = luaT_toudata(L, 2, "torch.CharTensor"))
)
{
argset = 3;
arg7 = THByteTensor_new();
}
else if(narg == 3
&& (arg7 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg8 = luaT_toudata(L, 2, "torch.CharTensor"))
&& (arg9 = luaT_toudata(L, 3, "torch.CharTensor"))
)
{
argset = 3;
arg7_idx = 1;
}
else if(narg == 3
&& (arg10 = luaT_toudata(L, 1, "torch.CharTensor"))
&& (arg11 = luaT_toudata(L, 2, "torch.CharTensor"))
&& (arg12 = luaT_toudata(L, 3, "torch.CharTensor"))
)
{
argset = 4;
arg10_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] CharTensor char | *CharTensor* CharTensor char | [*ByteTensor*] CharTensor CharTensor | *CharTensor* CharTensor CharTensor", type_buf);
}
if(argset == 1)
{
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THCharTensor_neValue(arg1,arg2,arg3);
return 1;
}
else if(argset == 2)
{
lua_pushvalue(L, arg4_idx);
THCharTensor_neValueT(arg4,arg5,arg6);
return 1;
}
else if(argset == 3)
{
if(arg7_idx)
lua_pushvalue(L, arg7_idx);
else
luaT_pushudata(L, arg7, "torch.ByteTensor");
THCharTensor_neTensor(arg7,arg8,arg9);
return 1;
}
else if(argset == 4)
{
lua_pushvalue(L, arg10_idx);
THCharTensor_neTensorT(arg10,arg11,arg12);
return 1;
}
return 0;
}

static int m_torch_CharTensor_nonzero(lua_State *L)
{
int narg = lua_gettop(L);
THLongTensor *arg1 = NULL;
int arg1_idx = 0;
THCharTensor *arg2 = NULL;
if(narg == 1
&& (arg2 = luaT_toudata(L, 1, "torch.CharTensor"))
)
{
arg1 = THLongTensor_new();
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.CharTensor"))
)
{
THLongTensor_add(arg1, arg1, -1);
arg1_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*LongTensor*] CharTensor", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.LongTensor");
THCharTensor_nonzero(arg1,arg2);
THLongTensor_add(arg1, arg1, 1);
return 1;
}

static const struct luaL_Reg m_torch_CharTensorMath__ [] = {
{"zero", m_torch_CharTensor_zero},
{"fill", m_torch_CharTensor_fill},
{"zeros", m_torch_CharTensor_zeros},
{"ones", m_torch_CharTensor_ones},
{"reshape", m_torch_CharTensor_reshape},
{"gather", m_torch_CharTensor_gather},
{"scatter", m_torch_CharTensor_scatter},
{"dot", m_torch_CharTensor_dot},
{"equal", m_torch_CharTensor_equal},
{"add", m_torch_CharTensor_add},
{"csub", m_torch_CharTensor_csub},
{"mul", m_torch_CharTensor_mul},
{"div", m_torch_CharTensor_div},
{"lshift", m_torch_CharTensor_lshift},
{"rshift", m_torch_CharTensor_rshift},
{"fmod", m_torch_CharTensor_fmod},
{"remainder", m_torch_CharTensor_remainder},
{"bitand", m_torch_CharTensor_bitand},
{"bitor", m_torch_CharTensor_bitor},
{"bitxor", m_torch_CharTensor_bitxor},
{"mod", m_torch_CharTensor_mod},
{"clamp", m_torch_CharTensor_clamp},
{"match", m_torch_CharTensor_match},
{"cmul", m_torch_CharTensor_cmul},
{"cpow", m_torch_CharTensor_cpow},
{"cdiv", m_torch_CharTensor_cdiv},
{"clshift", m_torch_CharTensor_clshift},
{"crshift", m_torch_CharTensor_crshift},
{"cfmod", m_torch_CharTensor_cfmod},
{"cremainder", m_torch_CharTensor_cremainder},
{"cbitand", m_torch_CharTensor_cbitand},
{"cbitor", m_torch_CharTensor_cbitor},
{"cbitxor", m_torch_CharTensor_cbitxor},
{"cmod", m_torch_CharTensor_cmod},
{"addcmul", m_torch_CharTensor_addcmul},
{"addcdiv", m_torch_CharTensor_addcdiv},
{"mv", m_torch_CharTensor_mv},
{"mm", m_torch_CharTensor_mm},
{"bmm", m_torch_CharTensor_bmm},
{"ger", m_torch_CharTensor_ger},
{"addmv", m_torch_CharTensor_addmv},
{"addmm", m_torch_CharTensor_addmm},
{"addr", m_torch_CharTensor_addr},
{"addbmm", m_torch_CharTensor_addbmm},
{"baddbmm", m_torch_CharTensor_baddbmm},
{"numel", m_torch_CharTensor_numel},
{"cumsum", m_torch_CharTensor_cumsum},
{"cumprod", m_torch_CharTensor_cumprod},
{"sum", m_torch_CharTensor_sum},
{"prod", m_torch_CharTensor_prod},
{"min", m_torch_CharTensor_min},
{"max", m_torch_CharTensor_max},
{"cmin", m_torch_CharTensor_cmin},
{"cmax", m_torch_CharTensor_cmax},
{"trace", m_torch_CharTensor_trace},
{"cross", m_torch_CharTensor_cross},
{"diag", m_torch_CharTensor_diag},
{"eye", m_torch_CharTensor_eye},
{"range", m_torch_CharTensor_range},
{"randperm", m_torch_CharTensor_randperm},
{"sort", m_torch_CharTensor_sort},
{"topk", m_torch_CharTensor_topk},
{"kthvalue", m_torch_CharTensor_kthvalue},
{"mode", m_torch_CharTensor_mode},
{"median", m_torch_CharTensor_median},
{"tril", m_torch_CharTensor_tril},
{"triu", m_torch_CharTensor_triu},
{"cat", m_torch_CharTensor_cat},
{"random", m_torch_CharTensor_random},
{"geometric", m_torch_CharTensor_geometric},
{"bernoulli", m_torch_CharTensor_bernoulli},
{"squeeze", m_torch_CharTensor_squeeze},
{"sign", m_torch_CharTensor_sign},
{"conv2", m_torch_CharTensor_conv2},
{"xcorr2", m_torch_CharTensor_xcorr2},
{"conv3", m_torch_CharTensor_conv3},
{"xcorr3", m_torch_CharTensor_xcorr3},
{"lt", m_torch_CharTensor_lt},
{"gt", m_torch_CharTensor_gt},
{"le", m_torch_CharTensor_le},
{"ge", m_torch_CharTensor_ge},
{"eq", m_torch_CharTensor_eq},
{"ne", m_torch_CharTensor_ne},
{"nonzero", m_torch_CharTensor_nonzero},
{NULL, NULL}
};

static const struct luaL_Reg torch_CharTensorMath__ [] = {
{"zero", torch_CharTensor_zero},
{"fill", torch_CharTensor_fill},
{"zeros", torch_CharTensor_zeros},
{"ones", torch_CharTensor_ones},
{"reshape", torch_CharTensor_reshape},
{"gather", torch_CharTensor_gather},
{"scatter", torch_CharTensor_scatter},
{"dot", torch_CharTensor_dot},
{"equal", torch_CharTensor_equal},
{"add", torch_CharTensor_add},
{"csub", torch_CharTensor_csub},
{"mul", torch_CharTensor_mul},
{"div", torch_CharTensor_div},
{"lshift", torch_CharTensor_lshift},
{"rshift", torch_CharTensor_rshift},
{"fmod", torch_CharTensor_fmod},
{"remainder", torch_CharTensor_remainder},
{"bitand", torch_CharTensor_bitand},
{"bitor", torch_CharTensor_bitor},
{"bitxor", torch_CharTensor_bitxor},
{"mod", torch_CharTensor_mod},
{"clamp", torch_CharTensor_clamp},
{"match", torch_CharTensor_match},
{"cmul", torch_CharTensor_cmul},
{"cpow", torch_CharTensor_cpow},
{"cdiv", torch_CharTensor_cdiv},
{"clshift", torch_CharTensor_clshift},
{"crshift", torch_CharTensor_crshift},
{"cfmod", torch_CharTensor_cfmod},
{"cremainder", torch_CharTensor_cremainder},
{"cbitand", torch_CharTensor_cbitand},
{"cbitor", torch_CharTensor_cbitor},
{"cbitxor", torch_CharTensor_cbitxor},
{"cmod", torch_CharTensor_cmod},
{"addcmul", torch_CharTensor_addcmul},
{"addcdiv", torch_CharTensor_addcdiv},
{"mv", torch_CharTensor_mv},
{"mm", torch_CharTensor_mm},
{"bmm", torch_CharTensor_bmm},
{"ger", torch_CharTensor_ger},
{"addmv", torch_CharTensor_addmv},
{"addmm", torch_CharTensor_addmm},
{"addr", torch_CharTensor_addr},
{"addbmm", torch_CharTensor_addbmm},
{"baddbmm", torch_CharTensor_baddbmm},
{"numel", torch_CharTensor_numel},
{"cumsum", torch_CharTensor_cumsum},
{"cumprod", torch_CharTensor_cumprod},
{"sum", torch_CharTensor_sum},
{"prod", torch_CharTensor_prod},
{"min", torch_CharTensor_min},
{"max", torch_CharTensor_max},
{"cmin", torch_CharTensor_cmin},
{"cmax", torch_CharTensor_cmax},
{"trace", torch_CharTensor_trace},
{"cross", torch_CharTensor_cross},
{"diag", torch_CharTensor_diag},
{"eye", torch_CharTensor_eye},
{"range", torch_CharTensor_range},
{"randperm", torch_CharTensor_randperm},
{"sort", torch_CharTensor_sort},
{"topk", torch_CharTensor_topk},
{"kthvalue", torch_CharTensor_kthvalue},
{"mode", torch_CharTensor_mode},
{"median", torch_CharTensor_median},
{"tril", torch_CharTensor_tril},
{"triu", torch_CharTensor_triu},
{"cat", torch_CharTensor_cat},
{"random", torch_CharTensor_random},
{"geometric", torch_CharTensor_geometric},
{"bernoulli", torch_CharTensor_bernoulli},
{"squeeze", torch_CharTensor_squeeze},
{"sign", torch_CharTensor_sign},
{"conv2", torch_CharTensor_conv2},
{"xcorr2", torch_CharTensor_xcorr2},
{"conv3", torch_CharTensor_conv3},
{"xcorr3", torch_CharTensor_xcorr3},
{"lt", torch_CharTensor_lt},
{"gt", torch_CharTensor_gt},
{"le", torch_CharTensor_le},
{"ge", torch_CharTensor_ge},
{"eq", torch_CharTensor_eq},
{"ne", torch_CharTensor_ne},
{"nonzero", torch_CharTensor_nonzero},
{NULL, NULL}
};

static void torch_CharTensorMath_init(lua_State *L)
{
  luaT_pushmetatable(L, "torch.CharTensor");

  /* register methods */
  luaT_setfuncs(L, m_torch_CharTensorMath__, 0);

  /* register functions into the "torch" field of the tensor metaclass */
  lua_pushstring(L, "torch");
  lua_newtable(L);
  luaT_setfuncs(L, torch_CharTensorMath__, 0);
  lua_rawset(L, -3);
  lua_pop(L, 1);
}

static int torch_ShortTensor_zero(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
if(narg == 1
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
)
{
arg1_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ShortTensor*", type_buf);
}
lua_pushvalue(L, arg1_idx);
THShortTensor_zero(arg1);
return 1;
}

static int torch_ShortTensor_fill(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
short arg2 = 0;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
)
{
arg1_idx = 1;
arg2 = (short)lua_tonumber(L, 2);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ShortTensor* short", type_buf);
}
lua_pushvalue(L, arg1_idx);
THShortTensor_fill(arg1,arg2);
return 1;
}

static int torch_ShortTensor_zeros(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THLongStorage *arg2 = NULL;
if(narg >= 1
&& torch_islongargs(L, 1)
)
{
arg2 = torch_checklongargs(L, 1);
arg1 = THShortTensor_new();
}
else if(narg >= 2
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& torch_islongargs(L, 2)
)
{
arg1_idx = 1;
arg2 = torch_checklongargs(L, 2);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ShortTensor*] (LongStorage | dim1 [dim2...])", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ShortTensor");
THShortTensor_zeros(arg1,arg2);
THLongStorage_free(arg2);
return 1;
}

static int torch_ShortTensor_ones(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THLongStorage *arg2 = NULL;
if(narg >= 1
&& torch_islongargs(L, 1)
)
{
arg2 = torch_checklongargs(L, 1);
arg1 = THShortTensor_new();
}
else if(narg >= 2
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& torch_islongargs(L, 2)
)
{
arg1_idx = 1;
arg2 = torch_checklongargs(L, 2);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ShortTensor*] (LongStorage | dim1 [dim2...])", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ShortTensor");
THShortTensor_ones(arg1,arg2);
THLongStorage_free(arg2);
return 1;
}

static int torch_ShortTensor_reshape(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THShortTensor *arg2 = NULL;
THLongStorage *arg3 = NULL;
if(narg >= 2
&& (arg2 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& torch_islongargs(L, 2)
)
{
arg3 = torch_checklongargs(L, 2);
arg1 = THShortTensor_new();
}
else if(narg >= 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& torch_islongargs(L, 3)
)
{
arg1_idx = 1;
arg3 = torch_checklongargs(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ShortTensor*] ShortTensor (LongStorage | dim1 [dim2...])", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ShortTensor");
THShortTensor_reshape(arg1,arg2,arg3);
THLongStorage_free(arg3);
return 1;
}

static int torch_ShortTensor_gather(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THShortTensor *arg2 = NULL;
long arg3 = 0;
THLongTensor *arg4 = NULL;
if(narg == 3
&& (arg2 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
&& (arg4 = luaT_toudata(L, 3, "torch.LongTensor"))
)
{
arg3 = (long)lua_tonumber(L, 2)-1;
arg1 = THShortTensor_new();
THLongStorage* arg1_size = THLongTensor_newSizeOf(arg4);
THShortTensor_resize(arg1, arg1_size, NULL);
THLongStorage_free(arg1_size);
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
&& (arg4 = luaT_toudata(L, 4, "torch.LongTensor"))
)
{
arg1_idx = 1;
arg3 = (long)lua_tonumber(L, 3)-1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ShortTensor*] ShortTensor index LongTensor", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ShortTensor");
THShortTensor_gather(arg1,arg2,arg3,arg4);
return 1;
}

static int torch_ShortTensor_scatter(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
long arg2 = 0;
THLongTensor *arg3 = NULL;
THShortTensor *arg4 = NULL;
THShortTensor *arg5 = NULL;
int arg5_idx = 0;
long arg6 = 0;
THLongTensor *arg7 = NULL;
short arg8 = 0;
if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
&& (arg3 = luaT_toudata(L, 3, "torch.LongTensor"))
&& (arg4 = luaT_toudata(L, 4, "torch.ShortTensor"))
)
{
argset = 1;
arg1_idx = 1;
arg2 = (long)lua_tonumber(L, 2)-1;
}
else if(narg == 4
&& (arg5 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
&& (arg7 = luaT_toudata(L, 3, "torch.LongTensor"))
&& lua_isnumber(L, 4)
)
{
argset = 2;
arg5_idx = 1;
arg6 = (long)lua_tonumber(L, 2)-1;
arg8 = (short)lua_tonumber(L, 4);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ShortTensor* index LongTensor ShortTensor | *ShortTensor* index LongTensor short", type_buf);
}
if(argset == 1)
{
lua_pushvalue(L, arg1_idx);
THShortTensor_scatter(arg1,arg2,arg3,arg4);
return 1;
}
else if(argset == 2)
{
lua_pushvalue(L, arg5_idx);
THShortTensor_scatterFill(arg5,arg6,arg7,arg8);
return 1;
}
return 0;
}

static int torch_ShortTensor_dot(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
THShortTensor *arg2 = NULL;
long arg3 = 0;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
)
{
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: ShortTensor ShortTensor", type_buf);
}
arg3 = THShortTensor_dot(arg1,arg2);
lua_pushnumber(L, (lua_Number)arg3);
return 1;
}

static int torch_ShortTensor_equal(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
THShortTensor *arg2 = NULL;
int arg3 = 0;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
)
{
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: ShortTensor ShortTensor", type_buf);
}
arg3 = THShortTensor_equal(arg1,arg2);
lua_pushboolean(L, arg3);
return 1;
}

static int torch_ShortTensor_add(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THShortTensor *arg2 = NULL;
short arg3 = 0;
THShortTensor *arg4 = NULL;
int arg4_idx = 0;
THShortTensor *arg5 = NULL;
short arg6 = 1;
THShortTensor *arg7 = NULL;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 1;
arg3 = (short)lua_tonumber(L, 2);
arg1 = THShortTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 1;
arg1_idx = 1;
arg3 = (short)lua_tonumber(L, 3);
}
else if(narg == 2
&& (arg5 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg7 = luaT_toudata(L, 2, "torch.ShortTensor"))
)
{
argset = 2;
arg4 = THShortTensor_new();
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& (arg7 = luaT_toudata(L, 3, "torch.ShortTensor"))
)
{
argset = 2;
arg4_idx = 1;
}
else if(narg == 3
&& (arg5 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
&& (arg7 = luaT_toudata(L, 3, "torch.ShortTensor"))
)
{
argset = 2;
arg6 = (short)lua_tonumber(L, 2);
arg4 = THShortTensor_new();
}
else if(narg == 4
&& (arg4 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
&& (arg7 = luaT_toudata(L, 4, "torch.ShortTensor"))
)
{
argset = 2;
arg4_idx = 1;
arg6 = (short)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ShortTensor*] ShortTensor short | [*ShortTensor*] ShortTensor [short] ShortTensor", type_buf);
}
if(argset == 1)
{
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ShortTensor");
THShortTensor_add(arg1,arg2,arg3);
return 1;
}
else if(argset == 2)
{
if(arg4_idx)
lua_pushvalue(L, arg4_idx);
else
luaT_pushudata(L, arg4, "torch.ShortTensor");
THShortTensor_cadd(arg4,arg5,arg6,arg7);
return 1;
}
return 0;
}

static int torch_ShortTensor_csub(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THShortTensor *arg2 = NULL;
short arg3 = 0;
THShortTensor *arg4 = NULL;
int arg4_idx = 0;
THShortTensor *arg5 = NULL;
short arg6 = 1;
THShortTensor *arg7 = NULL;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 1;
arg3 = (short)lua_tonumber(L, 2);
arg1 = THShortTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 1;
arg1_idx = 1;
arg3 = (short)lua_tonumber(L, 3);
}
else if(narg == 2
&& (arg5 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg7 = luaT_toudata(L, 2, "torch.ShortTensor"))
)
{
argset = 2;
arg4 = THShortTensor_new();
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& (arg7 = luaT_toudata(L, 3, "torch.ShortTensor"))
)
{
argset = 2;
arg4_idx = 1;
}
else if(narg == 3
&& (arg5 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
&& (arg7 = luaT_toudata(L, 3, "torch.ShortTensor"))
)
{
argset = 2;
arg6 = (short)lua_tonumber(L, 2);
arg4 = THShortTensor_new();
}
else if(narg == 4
&& (arg4 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
&& (arg7 = luaT_toudata(L, 4, "torch.ShortTensor"))
)
{
argset = 2;
arg4_idx = 1;
arg6 = (short)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ShortTensor*] ShortTensor short | [*ShortTensor*] ShortTensor [short] ShortTensor", type_buf);
}
if(argset == 1)
{
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ShortTensor");
THShortTensor_sub(arg1,arg2,arg3);
return 1;
}
else if(argset == 2)
{
if(arg4_idx)
lua_pushvalue(L, arg4_idx);
else
luaT_pushudata(L, arg4, "torch.ShortTensor");
THShortTensor_csub(arg4,arg5,arg6,arg7);
return 1;
}
return 0;
}

static int torch_ShortTensor_mul(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THShortTensor *arg2 = NULL;
short arg3 = 0;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
)
{
arg3 = (short)lua_tonumber(L, 2);
arg1 = THShortTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (short)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ShortTensor*] ShortTensor short", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ShortTensor");
THShortTensor_mul(arg1,arg2,arg3);
return 1;
}

static int torch_ShortTensor_div(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THShortTensor *arg2 = NULL;
short arg3 = 0;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
)
{
arg3 = (short)lua_tonumber(L, 2);
arg1 = THShortTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (short)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ShortTensor*] ShortTensor short", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ShortTensor");
THShortTensor_div(arg1,arg2,arg3);
return 1;
}

static int torch_ShortTensor_lshift(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THShortTensor *arg2 = NULL;
short arg3 = 0;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
)
{
arg3 = (short)lua_tonumber(L, 2);
arg1 = THShortTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (short)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ShortTensor*] ShortTensor short", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ShortTensor");
THShortTensor_lshift(arg1,arg2,arg3);
return 1;
}

static int torch_ShortTensor_rshift(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THShortTensor *arg2 = NULL;
short arg3 = 0;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
)
{
arg3 = (short)lua_tonumber(L, 2);
arg1 = THShortTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (short)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ShortTensor*] ShortTensor short", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ShortTensor");
THShortTensor_rshift(arg1,arg2,arg3);
return 1;
}

static int torch_ShortTensor_fmod(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THShortTensor *arg2 = NULL;
short arg3 = 0;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
)
{
arg3 = (short)lua_tonumber(L, 2);
arg1 = THShortTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (short)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ShortTensor*] ShortTensor short", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ShortTensor");
THShortTensor_fmod(arg1,arg2,arg3);
return 1;
}

static int torch_ShortTensor_remainder(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THShortTensor *arg2 = NULL;
short arg3 = 0;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
)
{
arg3 = (short)lua_tonumber(L, 2);
arg1 = THShortTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (short)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ShortTensor*] ShortTensor short", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ShortTensor");
THShortTensor_remainder(arg1,arg2,arg3);
return 1;
}

static int torch_ShortTensor_bitand(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THShortTensor *arg2 = NULL;
short arg3 = 0;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
)
{
arg3 = (short)lua_tonumber(L, 2);
arg1 = THShortTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (short)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ShortTensor*] ShortTensor short", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ShortTensor");
THShortTensor_bitand(arg1,arg2,arg3);
return 1;
}

static int torch_ShortTensor_bitor(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THShortTensor *arg2 = NULL;
short arg3 = 0;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
)
{
arg3 = (short)lua_tonumber(L, 2);
arg1 = THShortTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (short)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ShortTensor*] ShortTensor short", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ShortTensor");
THShortTensor_bitor(arg1,arg2,arg3);
return 1;
}

static int torch_ShortTensor_bitxor(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THShortTensor *arg2 = NULL;
short arg3 = 0;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
)
{
arg3 = (short)lua_tonumber(L, 2);
arg1 = THShortTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (short)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ShortTensor*] ShortTensor short", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ShortTensor");
THShortTensor_bitxor(arg1,arg2,arg3);
return 1;
}

static int torch_ShortTensor_mod(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THShortTensor *arg2 = NULL;
short arg3 = 0;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
)
{
arg3 = (short)lua_tonumber(L, 2);
arg1 = THShortTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (short)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ShortTensor*] ShortTensor short", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ShortTensor");
THShortTensor_fmod(arg1,arg2,arg3);
return 1;
}

static int torch_ShortTensor_clamp(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THShortTensor *arg2 = NULL;
short arg3 = 0;
short arg4 = 0;
if(narg == 3
&& (arg2 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
&& lua_isnumber(L, 3)
)
{
arg3 = (short)lua_tonumber(L, 2);
arg4 = (short)lua_tonumber(L, 3);
arg1 = THShortTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
&& lua_isnumber(L, 4)
)
{
arg1_idx = 1;
arg3 = (short)lua_tonumber(L, 3);
arg4 = (short)lua_tonumber(L, 4);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ShortTensor*] ShortTensor short short", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ShortTensor");
THShortTensor_clamp(arg1,arg2,arg3,arg4);
return 1;
}

static int torch_ShortTensor_match(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THShortTensor *arg2 = NULL;
THShortTensor *arg3 = NULL;
short arg4 = 1;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
)
{
arg1 = THShortTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor"))
)
{
arg1_idx = 1;
}
else if(narg == 3
&& (arg2 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
)
{
arg4 = (short)lua_tonumber(L, 3);
arg1 = THShortTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor"))
&& lua_isnumber(L, 4)
)
{
arg1_idx = 1;
arg4 = (short)lua_tonumber(L, 4);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ShortTensor*] ShortTensor ShortTensor [short]", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ShortTensor");
THShortTensor_match(arg1,arg2,arg3,arg4);
return 1;
}

static int torch_ShortTensor_cmul(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THShortTensor *arg2 = NULL;
THShortTensor *arg3 = NULL;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
)
{
arg1 = THShortTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor"))
)
{
arg1_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ShortTensor*] ShortTensor ShortTensor", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ShortTensor");
THShortTensor_cmul(arg1,arg2,arg3);
return 1;
}

static int torch_ShortTensor_cpow(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THShortTensor *arg2 = NULL;
THShortTensor *arg3 = NULL;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
)
{
arg1 = THShortTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor"))
)
{
arg1_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ShortTensor*] ShortTensor ShortTensor", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ShortTensor");
THShortTensor_cpow(arg1,arg2,arg3);
return 1;
}

static int torch_ShortTensor_cdiv(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THShortTensor *arg2 = NULL;
THShortTensor *arg3 = NULL;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
)
{
arg1 = THShortTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor"))
)
{
arg1_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ShortTensor*] ShortTensor ShortTensor", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ShortTensor");
THShortTensor_cdiv(arg1,arg2,arg3);
return 1;
}

static int torch_ShortTensor_clshift(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THShortTensor *arg2 = NULL;
THShortTensor *arg3 = NULL;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
)
{
arg1 = THShortTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor"))
)
{
arg1_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ShortTensor*] ShortTensor ShortTensor", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ShortTensor");
THShortTensor_clshift(arg1,arg2,arg3);
return 1;
}

static int torch_ShortTensor_crshift(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THShortTensor *arg2 = NULL;
THShortTensor *arg3 = NULL;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
)
{
arg1 = THShortTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor"))
)
{
arg1_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ShortTensor*] ShortTensor ShortTensor", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ShortTensor");
THShortTensor_crshift(arg1,arg2,arg3);
return 1;
}

static int torch_ShortTensor_cfmod(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THShortTensor *arg2 = NULL;
THShortTensor *arg3 = NULL;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
)
{
arg1 = THShortTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor"))
)
{
arg1_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ShortTensor*] ShortTensor ShortTensor", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ShortTensor");
THShortTensor_cfmod(arg1,arg2,arg3);
return 1;
}

static int torch_ShortTensor_cremainder(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THShortTensor *arg2 = NULL;
THShortTensor *arg3 = NULL;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
)
{
arg1 = THShortTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor"))
)
{
arg1_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ShortTensor*] ShortTensor ShortTensor", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ShortTensor");
THShortTensor_cremainder(arg1,arg2,arg3);
return 1;
}

static int torch_ShortTensor_cbitand(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THShortTensor *arg2 = NULL;
THShortTensor *arg3 = NULL;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
)
{
arg1 = THShortTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor"))
)
{
arg1_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ShortTensor*] ShortTensor ShortTensor", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ShortTensor");
THShortTensor_cbitand(arg1,arg2,arg3);
return 1;
}

static int torch_ShortTensor_cbitor(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THShortTensor *arg2 = NULL;
THShortTensor *arg3 = NULL;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
)
{
arg1 = THShortTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor"))
)
{
arg1_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ShortTensor*] ShortTensor ShortTensor", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ShortTensor");
THShortTensor_cbitor(arg1,arg2,arg3);
return 1;
}

static int torch_ShortTensor_cbitxor(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THShortTensor *arg2 = NULL;
THShortTensor *arg3 = NULL;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
)
{
arg1 = THShortTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor"))
)
{
arg1_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ShortTensor*] ShortTensor ShortTensor", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ShortTensor");
THShortTensor_cbitxor(arg1,arg2,arg3);
return 1;
}

static int torch_ShortTensor_cmod(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THShortTensor *arg2 = NULL;
THShortTensor *arg3 = NULL;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
)
{
arg1 = THShortTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor"))
)
{
arg1_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ShortTensor*] ShortTensor ShortTensor", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ShortTensor");
THShortTensor_cfmod(arg1,arg2,arg3);
return 1;
}

static int torch_ShortTensor_addcmul(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THShortTensor *arg2 = NULL;
short arg3 = 1;
THShortTensor *arg4 = NULL;
THShortTensor *arg5 = NULL;
if(narg == 3
&& (arg2 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg4 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& (arg5 = luaT_toudata(L, 3, "torch.ShortTensor"))
)
{
arg1 = THShortTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& (arg4 = luaT_toudata(L, 3, "torch.ShortTensor"))
&& (arg5 = luaT_toudata(L, 4, "torch.ShortTensor"))
)
{
arg1_idx = 1;
}
else if(narg == 4
&& (arg2 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
&& (arg4 = luaT_toudata(L, 3, "torch.ShortTensor"))
&& (arg5 = luaT_toudata(L, 4, "torch.ShortTensor"))
)
{
arg3 = (short)lua_tonumber(L, 2);
arg1 = THShortTensor_new();
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
&& (arg4 = luaT_toudata(L, 4, "torch.ShortTensor"))
&& (arg5 = luaT_toudata(L, 5, "torch.ShortTensor"))
)
{
arg1_idx = 1;
arg3 = (short)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ShortTensor*] ShortTensor [short] ShortTensor ShortTensor", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ShortTensor");
THShortTensor_addcmul(arg1,arg2,arg3,arg4,arg5);
return 1;
}

static int torch_ShortTensor_addcdiv(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THShortTensor *arg2 = NULL;
short arg3 = 1;
THShortTensor *arg4 = NULL;
THShortTensor *arg5 = NULL;
if(narg == 3
&& (arg2 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg4 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& (arg5 = luaT_toudata(L, 3, "torch.ShortTensor"))
)
{
arg1 = THShortTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& (arg4 = luaT_toudata(L, 3, "torch.ShortTensor"))
&& (arg5 = luaT_toudata(L, 4, "torch.ShortTensor"))
)
{
arg1_idx = 1;
}
else if(narg == 4
&& (arg2 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
&& (arg4 = luaT_toudata(L, 3, "torch.ShortTensor"))
&& (arg5 = luaT_toudata(L, 4, "torch.ShortTensor"))
)
{
arg3 = (short)lua_tonumber(L, 2);
arg1 = THShortTensor_new();
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
&& (arg4 = luaT_toudata(L, 4, "torch.ShortTensor"))
&& (arg5 = luaT_toudata(L, 5, "torch.ShortTensor"))
)
{
arg1_idx = 1;
arg3 = (short)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ShortTensor*] ShortTensor [short] ShortTensor ShortTensor", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ShortTensor");
THShortTensor_addcdiv(arg1,arg2,arg3,arg4,arg5);
return 1;
}

static int torch_ShortTensor_mv(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
short arg2 = 0;
THShortTensor *arg3 = NULL;
short arg4 = 1;
THShortTensor *arg5 = NULL;
THShortTensor *arg6 = NULL;
if(narg == 2
&& (arg5 = luaT_toudata(L, 1, "torch.ShortTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg6->nDimension == 1)
)
{
arg1 = THShortTensor_new();
THShortTensor_resize1d(arg1, arg5->size[0]);
arg3 = arg1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 3, "torch.ShortTensor")) && (arg6->nDimension == 1)
)
{
arg1_idx = 1;
arg3 = arg1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ShortTensor*] ShortTensor~2D ShortTensor~1D", type_buf);
}
THShortTensor_zero(arg1);
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ShortTensor");
THShortTensor_addmv(arg1,arg2,arg3,arg4,arg5,arg6);
return 1;
}

static int torch_ShortTensor_mm(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
short arg2 = 0;
THShortTensor *arg3 = NULL;
short arg4 = 1;
THShortTensor *arg5 = NULL;
THShortTensor *arg6 = NULL;
if(narg == 2
&& (arg5 = luaT_toudata(L, 1, "torch.ShortTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg6->nDimension == 2)
)
{
arg1 = THShortTensor_new();
THShortTensor_resize2d(arg1, arg5->size[0], arg6->size[1]);
arg3 = arg1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 3, "torch.ShortTensor")) && (arg6->nDimension == 2)
)
{
arg1_idx = 1;
arg3 = arg1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ShortTensor*] ShortTensor~2D ShortTensor~2D", type_buf);
}
THShortTensor_zero(arg1);
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ShortTensor");
THShortTensor_addmm(arg1,arg2,arg3,arg4,arg5,arg6);
return 1;
}

static int torch_ShortTensor_bmm(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
short arg2 = 0;
THShortTensor *arg3 = NULL;
short arg4 = 1;
THShortTensor *arg5 = NULL;
THShortTensor *arg6 = NULL;
if(narg == 2
&& (arg5 = luaT_toudata(L, 1, "torch.ShortTensor")) && (arg5->nDimension == 3)
&& (arg6 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg6->nDimension == 3)
)
{
arg1 = THShortTensor_new();
THShortTensor_resize3d(arg1, arg5->size[0], arg5->size[1], arg6->size[2]);
arg3 = arg1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg5->nDimension == 3)
&& (arg6 = luaT_toudata(L, 3, "torch.ShortTensor")) && (arg6->nDimension == 3)
)
{
arg1_idx = 1;
arg3 = arg1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ShortTensor*] ShortTensor~3D ShortTensor~3D", type_buf);
}
THShortTensor_zero(arg1);
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ShortTensor");
THShortTensor_baddbmm(arg1,arg2,arg3,arg4,arg5,arg6);
return 1;
}

static int torch_ShortTensor_ger(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
short arg2 = 1;
THShortTensor *arg3 = NULL;
short arg4 = 1;
THShortTensor *arg5 = NULL;
THShortTensor *arg6 = NULL;
if(narg == 2
&& (arg5 = luaT_toudata(L, 1, "torch.ShortTensor")) && (arg5->nDimension == 1)
&& (arg6 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg6->nDimension == 1)
)
{
arg1 = THShortTensor_new();
THShortTensor_resize2d(arg1, arg5->size[0], arg6->size[0]);
arg3 = arg1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg5->nDimension == 1)
&& (arg6 = luaT_toudata(L, 3, "torch.ShortTensor")) && (arg6->nDimension == 1)
)
{
arg1_idx = 1;
arg3 = arg1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ShortTensor*] ShortTensor~1D ShortTensor~1D", type_buf);
}
THShortTensor_zero(arg1);
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ShortTensor");
THShortTensor_addr(arg1,arg2,arg3,arg4,arg5,arg6);
return 1;
}

static int torch_ShortTensor_addmv(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
short arg2 = 1;
THShortTensor *arg3 = NULL;
short arg4 = 1;
THShortTensor *arg5 = NULL;
THShortTensor *arg6 = NULL;
if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.ShortTensor")) && (arg3->nDimension == 1)
&& (arg5 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 3, "torch.ShortTensor")) && (arg6->nDimension == 1)
)
{
arg1 = THShortTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg3->nDimension == 1)
&& (arg5 = luaT_toudata(L, 3, "torch.ShortTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 4, "torch.ShortTensor")) && (arg6->nDimension == 1)
)
{
arg1_idx = 1;
}
else if(narg == 4
&& lua_isnumber(L, 1)
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg3->nDimension == 1)
&& (arg5 = luaT_toudata(L, 3, "torch.ShortTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 4, "torch.ShortTensor")) && (arg6->nDimension == 1)
)
{
arg2 = (short)lua_tonumber(L, 1);
arg1 = THShortTensor_new();
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor")) && (arg3->nDimension == 1)
&& (arg5 = luaT_toudata(L, 4, "torch.ShortTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 5, "torch.ShortTensor")) && (arg6->nDimension == 1)
)
{
arg1_idx = 1;
arg2 = (short)lua_tonumber(L, 2);
}
else if(narg == 4
&& (arg3 = luaT_toudata(L, 1, "torch.ShortTensor")) && (arg3->nDimension == 1)
&& lua_isnumber(L, 2)
&& (arg5 = luaT_toudata(L, 3, "torch.ShortTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 4, "torch.ShortTensor")) && (arg6->nDimension == 1)
)
{
arg4 = (short)lua_tonumber(L, 2);
arg1 = THShortTensor_new();
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg3->nDimension == 1)
&& lua_isnumber(L, 3)
&& (arg5 = luaT_toudata(L, 4, "torch.ShortTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 5, "torch.ShortTensor")) && (arg6->nDimension == 1)
)
{
arg1_idx = 1;
arg4 = (short)lua_tonumber(L, 3);
}
else if(narg == 5
&& lua_isnumber(L, 1)
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg3->nDimension == 1)
&& lua_isnumber(L, 3)
&& (arg5 = luaT_toudata(L, 4, "torch.ShortTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 5, "torch.ShortTensor")) && (arg6->nDimension == 1)
)
{
arg2 = (short)lua_tonumber(L, 1);
arg4 = (short)lua_tonumber(L, 3);
arg1 = THShortTensor_new();
}
else if(narg == 6
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor")) && (arg3->nDimension == 1)
&& lua_isnumber(L, 4)
&& (arg5 = luaT_toudata(L, 5, "torch.ShortTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 6, "torch.ShortTensor")) && (arg6->nDimension == 1)
)
{
arg1_idx = 1;
arg2 = (short)lua_tonumber(L, 2);
arg4 = (short)lua_tonumber(L, 4);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ShortTensor*] [short] ShortTensor~1D [short] ShortTensor~2D ShortTensor~1D", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ShortTensor");
THShortTensor_addmv(arg1,arg2,arg3,arg4,arg5,arg6);
return 1;
}

static int torch_ShortTensor_addmm(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
short arg2 = 1;
THShortTensor *arg3 = NULL;
short arg4 = 1;
THShortTensor *arg5 = NULL;
THShortTensor *arg6 = NULL;
if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.ShortTensor")) && (arg3->nDimension == 2)
&& (arg5 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 3, "torch.ShortTensor")) && (arg6->nDimension == 2)
)
{
arg1 = THShortTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg3->nDimension == 2)
&& (arg5 = luaT_toudata(L, 3, "torch.ShortTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 4, "torch.ShortTensor")) && (arg6->nDimension == 2)
)
{
arg1_idx = 1;
}
else if(narg == 4
&& lua_isnumber(L, 1)
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg3->nDimension == 2)
&& (arg5 = luaT_toudata(L, 3, "torch.ShortTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 4, "torch.ShortTensor")) && (arg6->nDimension == 2)
)
{
arg2 = (short)lua_tonumber(L, 1);
arg1 = THShortTensor_new();
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor")) && (arg3->nDimension == 2)
&& (arg5 = luaT_toudata(L, 4, "torch.ShortTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 5, "torch.ShortTensor")) && (arg6->nDimension == 2)
)
{
arg1_idx = 1;
arg2 = (short)lua_tonumber(L, 2);
}
else if(narg == 4
&& (arg3 = luaT_toudata(L, 1, "torch.ShortTensor")) && (arg3->nDimension == 2)
&& lua_isnumber(L, 2)
&& (arg5 = luaT_toudata(L, 3, "torch.ShortTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 4, "torch.ShortTensor")) && (arg6->nDimension == 2)
)
{
arg4 = (short)lua_tonumber(L, 2);
arg1 = THShortTensor_new();
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg3->nDimension == 2)
&& lua_isnumber(L, 3)
&& (arg5 = luaT_toudata(L, 4, "torch.ShortTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 5, "torch.ShortTensor")) && (arg6->nDimension == 2)
)
{
arg1_idx = 1;
arg4 = (short)lua_tonumber(L, 3);
}
else if(narg == 5
&& lua_isnumber(L, 1)
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg3->nDimension == 2)
&& lua_isnumber(L, 3)
&& (arg5 = luaT_toudata(L, 4, "torch.ShortTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 5, "torch.ShortTensor")) && (arg6->nDimension == 2)
)
{
arg2 = (short)lua_tonumber(L, 1);
arg4 = (short)lua_tonumber(L, 3);
arg1 = THShortTensor_new();
}
else if(narg == 6
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor")) && (arg3->nDimension == 2)
&& lua_isnumber(L, 4)
&& (arg5 = luaT_toudata(L, 5, "torch.ShortTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 6, "torch.ShortTensor")) && (arg6->nDimension == 2)
)
{
arg1_idx = 1;
arg2 = (short)lua_tonumber(L, 2);
arg4 = (short)lua_tonumber(L, 4);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ShortTensor*] [short] ShortTensor~2D [short] ShortTensor~2D ShortTensor~2D", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ShortTensor");
THShortTensor_addmm(arg1,arg2,arg3,arg4,arg5,arg6);
return 1;
}

static int torch_ShortTensor_addr(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
short arg2 = 1;
THShortTensor *arg3 = NULL;
short arg4 = 1;
THShortTensor *arg5 = NULL;
THShortTensor *arg6 = NULL;
if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.ShortTensor")) && (arg3->nDimension == 2)
&& (arg5 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg5->nDimension == 1)
&& (arg6 = luaT_toudata(L, 3, "torch.ShortTensor")) && (arg6->nDimension == 1)
)
{
arg1 = THShortTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg3->nDimension == 2)
&& (arg5 = luaT_toudata(L, 3, "torch.ShortTensor")) && (arg5->nDimension == 1)
&& (arg6 = luaT_toudata(L, 4, "torch.ShortTensor")) && (arg6->nDimension == 1)
)
{
arg1_idx = 1;
}
else if(narg == 4
&& lua_isnumber(L, 1)
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg3->nDimension == 2)
&& (arg5 = luaT_toudata(L, 3, "torch.ShortTensor")) && (arg5->nDimension == 1)
&& (arg6 = luaT_toudata(L, 4, "torch.ShortTensor")) && (arg6->nDimension == 1)
)
{
arg2 = (short)lua_tonumber(L, 1);
arg1 = THShortTensor_new();
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor")) && (arg3->nDimension == 2)
&& (arg5 = luaT_toudata(L, 4, "torch.ShortTensor")) && (arg5->nDimension == 1)
&& (arg6 = luaT_toudata(L, 5, "torch.ShortTensor")) && (arg6->nDimension == 1)
)
{
arg1_idx = 1;
arg2 = (short)lua_tonumber(L, 2);
}
else if(narg == 4
&& (arg3 = luaT_toudata(L, 1, "torch.ShortTensor")) && (arg3->nDimension == 2)
&& lua_isnumber(L, 2)
&& (arg5 = luaT_toudata(L, 3, "torch.ShortTensor")) && (arg5->nDimension == 1)
&& (arg6 = luaT_toudata(L, 4, "torch.ShortTensor")) && (arg6->nDimension == 1)
)
{
arg4 = (short)lua_tonumber(L, 2);
arg1 = THShortTensor_new();
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg3->nDimension == 2)
&& lua_isnumber(L, 3)
&& (arg5 = luaT_toudata(L, 4, "torch.ShortTensor")) && (arg5->nDimension == 1)
&& (arg6 = luaT_toudata(L, 5, "torch.ShortTensor")) && (arg6->nDimension == 1)
)
{
arg1_idx = 1;
arg4 = (short)lua_tonumber(L, 3);
}
else if(narg == 5
&& lua_isnumber(L, 1)
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg3->nDimension == 2)
&& lua_isnumber(L, 3)
&& (arg5 = luaT_toudata(L, 4, "torch.ShortTensor")) && (arg5->nDimension == 1)
&& (arg6 = luaT_toudata(L, 5, "torch.ShortTensor")) && (arg6->nDimension == 1)
)
{
arg2 = (short)lua_tonumber(L, 1);
arg4 = (short)lua_tonumber(L, 3);
arg1 = THShortTensor_new();
}
else if(narg == 6
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor")) && (arg3->nDimension == 2)
&& lua_isnumber(L, 4)
&& (arg5 = luaT_toudata(L, 5, "torch.ShortTensor")) && (arg5->nDimension == 1)
&& (arg6 = luaT_toudata(L, 6, "torch.ShortTensor")) && (arg6->nDimension == 1)
)
{
arg1_idx = 1;
arg2 = (short)lua_tonumber(L, 2);
arg4 = (short)lua_tonumber(L, 4);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ShortTensor*] [short] ShortTensor~2D [short] ShortTensor~1D ShortTensor~1D", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ShortTensor");
THShortTensor_addr(arg1,arg2,arg3,arg4,arg5,arg6);
return 1;
}

static int torch_ShortTensor_addbmm(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
short arg2 = 1;
THShortTensor *arg3 = NULL;
short arg4 = 1;
THShortTensor *arg5 = NULL;
THShortTensor *arg6 = NULL;
if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.ShortTensor")) && (arg3->nDimension == 2)
&& (arg5 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg5->nDimension == 3)
&& (arg6 = luaT_toudata(L, 3, "torch.ShortTensor")) && (arg6->nDimension == 3)
)
{
arg1 = THShortTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg3->nDimension == 2)
&& (arg5 = luaT_toudata(L, 3, "torch.ShortTensor")) && (arg5->nDimension == 3)
&& (arg6 = luaT_toudata(L, 4, "torch.ShortTensor")) && (arg6->nDimension == 3)
)
{
arg1_idx = 1;
}
else if(narg == 4
&& lua_isnumber(L, 1)
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg3->nDimension == 2)
&& (arg5 = luaT_toudata(L, 3, "torch.ShortTensor")) && (arg5->nDimension == 3)
&& (arg6 = luaT_toudata(L, 4, "torch.ShortTensor")) && (arg6->nDimension == 3)
)
{
arg2 = (short)lua_tonumber(L, 1);
arg1 = THShortTensor_new();
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor")) && (arg3->nDimension == 2)
&& (arg5 = luaT_toudata(L, 4, "torch.ShortTensor")) && (arg5->nDimension == 3)
&& (arg6 = luaT_toudata(L, 5, "torch.ShortTensor")) && (arg6->nDimension == 3)
)
{
arg1_idx = 1;
arg2 = (short)lua_tonumber(L, 2);
}
else if(narg == 4
&& (arg3 = luaT_toudata(L, 1, "torch.ShortTensor")) && (arg3->nDimension == 2)
&& lua_isnumber(L, 2)
&& (arg5 = luaT_toudata(L, 3, "torch.ShortTensor")) && (arg5->nDimension == 3)
&& (arg6 = luaT_toudata(L, 4, "torch.ShortTensor")) && (arg6->nDimension == 3)
)
{
arg4 = (short)lua_tonumber(L, 2);
arg1 = THShortTensor_new();
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg3->nDimension == 2)
&& lua_isnumber(L, 3)
&& (arg5 = luaT_toudata(L, 4, "torch.ShortTensor")) && (arg5->nDimension == 3)
&& (arg6 = luaT_toudata(L, 5, "torch.ShortTensor")) && (arg6->nDimension == 3)
)
{
arg1_idx = 1;
arg4 = (short)lua_tonumber(L, 3);
}
else if(narg == 5
&& lua_isnumber(L, 1)
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg3->nDimension == 2)
&& lua_isnumber(L, 3)
&& (arg5 = luaT_toudata(L, 4, "torch.ShortTensor")) && (arg5->nDimension == 3)
&& (arg6 = luaT_toudata(L, 5, "torch.ShortTensor")) && (arg6->nDimension == 3)
)
{
arg2 = (short)lua_tonumber(L, 1);
arg4 = (short)lua_tonumber(L, 3);
arg1 = THShortTensor_new();
}
else if(narg == 6
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor")) && (arg3->nDimension == 2)
&& lua_isnumber(L, 4)
&& (arg5 = luaT_toudata(L, 5, "torch.ShortTensor")) && (arg5->nDimension == 3)
&& (arg6 = luaT_toudata(L, 6, "torch.ShortTensor")) && (arg6->nDimension == 3)
)
{
arg1_idx = 1;
arg2 = (short)lua_tonumber(L, 2);
arg4 = (short)lua_tonumber(L, 4);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ShortTensor*] [short] ShortTensor~2D [short] ShortTensor~3D ShortTensor~3D", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ShortTensor");
THShortTensor_addbmm(arg1,arg2,arg3,arg4,arg5,arg6);
return 1;
}

static int torch_ShortTensor_baddbmm(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
short arg2 = 1;
THShortTensor *arg3 = NULL;
short arg4 = 1;
THShortTensor *arg5 = NULL;
THShortTensor *arg6 = NULL;
if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.ShortTensor")) && (arg3->nDimension == 3)
&& (arg5 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg5->nDimension == 3)
&& (arg6 = luaT_toudata(L, 3, "torch.ShortTensor")) && (arg6->nDimension == 3)
)
{
arg1 = THShortTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg3->nDimension == 3)
&& (arg5 = luaT_toudata(L, 3, "torch.ShortTensor")) && (arg5->nDimension == 3)
&& (arg6 = luaT_toudata(L, 4, "torch.ShortTensor")) && (arg6->nDimension == 3)
)
{
arg1_idx = 1;
}
else if(narg == 4
&& lua_isnumber(L, 1)
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg3->nDimension == 3)
&& (arg5 = luaT_toudata(L, 3, "torch.ShortTensor")) && (arg5->nDimension == 3)
&& (arg6 = luaT_toudata(L, 4, "torch.ShortTensor")) && (arg6->nDimension == 3)
)
{
arg2 = (short)lua_tonumber(L, 1);
arg1 = THShortTensor_new();
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor")) && (arg3->nDimension == 3)
&& (arg5 = luaT_toudata(L, 4, "torch.ShortTensor")) && (arg5->nDimension == 3)
&& (arg6 = luaT_toudata(L, 5, "torch.ShortTensor")) && (arg6->nDimension == 3)
)
{
arg1_idx = 1;
arg2 = (short)lua_tonumber(L, 2);
}
else if(narg == 4
&& (arg3 = luaT_toudata(L, 1, "torch.ShortTensor")) && (arg3->nDimension == 3)
&& lua_isnumber(L, 2)
&& (arg5 = luaT_toudata(L, 3, "torch.ShortTensor")) && (arg5->nDimension == 3)
&& (arg6 = luaT_toudata(L, 4, "torch.ShortTensor")) && (arg6->nDimension == 3)
)
{
arg4 = (short)lua_tonumber(L, 2);
arg1 = THShortTensor_new();
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg3->nDimension == 3)
&& lua_isnumber(L, 3)
&& (arg5 = luaT_toudata(L, 4, "torch.ShortTensor")) && (arg5->nDimension == 3)
&& (arg6 = luaT_toudata(L, 5, "torch.ShortTensor")) && (arg6->nDimension == 3)
)
{
arg1_idx = 1;
arg4 = (short)lua_tonumber(L, 3);
}
else if(narg == 5
&& lua_isnumber(L, 1)
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg3->nDimension == 3)
&& lua_isnumber(L, 3)
&& (arg5 = luaT_toudata(L, 4, "torch.ShortTensor")) && (arg5->nDimension == 3)
&& (arg6 = luaT_toudata(L, 5, "torch.ShortTensor")) && (arg6->nDimension == 3)
)
{
arg2 = (short)lua_tonumber(L, 1);
arg4 = (short)lua_tonumber(L, 3);
arg1 = THShortTensor_new();
}
else if(narg == 6
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor")) && (arg3->nDimension == 3)
&& lua_isnumber(L, 4)
&& (arg5 = luaT_toudata(L, 5, "torch.ShortTensor")) && (arg5->nDimension == 3)
&& (arg6 = luaT_toudata(L, 6, "torch.ShortTensor")) && (arg6->nDimension == 3)
)
{
arg1_idx = 1;
arg2 = (short)lua_tonumber(L, 2);
arg4 = (short)lua_tonumber(L, 4);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ShortTensor*] [short] ShortTensor~3D [short] ShortTensor~3D ShortTensor~3D", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ShortTensor");
THShortTensor_baddbmm(arg1,arg2,arg3,arg4,arg5,arg6);
return 1;
}

static int torch_ShortTensor_numel(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
ptrdiff_t arg2 = 0;
if(narg == 1
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
)
{
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: ShortTensor", type_buf);
}
arg2 = THShortTensor_numel(arg1);
lua_pushnumber(L, (lua_Number)arg2);
return 1;
}

static int torch_ShortTensor_cumsum(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THShortTensor *arg2 = NULL;
long arg3 = 0;
if(narg == 1
&& (arg2 = luaT_toudata(L, 1, "torch.ShortTensor"))
)
{
arg1 = THShortTensor_new();
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
)
{
arg1_idx = 1;
}
else if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
)
{
arg3 = (long)lua_tonumber(L, 2)-1;
arg1 = THShortTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (long)lua_tonumber(L, 3)-1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ShortTensor*] ShortTensor [index]", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ShortTensor");
THShortTensor_cumsum(arg1,arg2,arg3);
return 1;
}

static int torch_ShortTensor_cumprod(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THShortTensor *arg2 = NULL;
long arg3 = 0;
if(narg == 1
&& (arg2 = luaT_toudata(L, 1, "torch.ShortTensor"))
)
{
arg1 = THShortTensor_new();
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
)
{
arg1_idx = 1;
}
else if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
)
{
arg3 = (long)lua_tonumber(L, 2)-1;
arg1 = THShortTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (long)lua_tonumber(L, 3)-1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ShortTensor*] ShortTensor [index]", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ShortTensor");
THShortTensor_cumprod(arg1,arg2,arg3);
return 1;
}

static int torch_ShortTensor_sum(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THShortTensor *arg1 = NULL;
long arg2 = 0;
THShortTensor *arg3 = NULL;
int arg3_idx = 0;
THShortTensor *arg4 = NULL;
long arg5 = 0;
int arg6 = 1;
if(narg == 1
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
)
{
argset = 1;
}
else if(narg == 2
&& (arg4 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 2;
arg5 = (long)lua_tonumber(L, 2)-1;
arg3 = THShortTensor_new();
}
else if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg4 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg3_idx = 1;
arg5 = (long)lua_tonumber(L, 3)-1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: ShortTensor | [*ShortTensor*] ShortTensor index", type_buf);
}
if(argset == 1)
{
arg2 = THShortTensor_sumall(arg1);
lua_pushnumber(L, (lua_Number)arg2);
return 1;
}
else if(argset == 2)
{
if(arg3_idx)
lua_pushvalue(L, arg3_idx);
else
luaT_pushudata(L, arg3, "torch.ShortTensor");
THShortTensor_sum(arg3,arg4,arg5,arg6);
return 1;
}
return 0;
}

static int torch_ShortTensor_prod(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THShortTensor *arg1 = NULL;
long arg2 = 0;
THShortTensor *arg3 = NULL;
int arg3_idx = 0;
THShortTensor *arg4 = NULL;
long arg5 = 0;
int arg6 = 1;
if(narg == 1
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
)
{
argset = 1;
}
else if(narg == 2
&& (arg4 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 2;
arg5 = (long)lua_tonumber(L, 2)-1;
arg3 = THShortTensor_new();
}
else if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg4 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg3_idx = 1;
arg5 = (long)lua_tonumber(L, 3)-1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: ShortTensor | [*ShortTensor*] ShortTensor index", type_buf);
}
if(argset == 1)
{
arg2 = THShortTensor_prodall(arg1);
lua_pushnumber(L, (lua_Number)arg2);
return 1;
}
else if(argset == 2)
{
if(arg3_idx)
lua_pushvalue(L, arg3_idx);
else
luaT_pushudata(L, arg3, "torch.ShortTensor");
THShortTensor_prod(arg3,arg4,arg5,arg6);
return 1;
}
return 0;
}

static int torch_ShortTensor_min(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THShortTensor *arg1 = NULL;
short arg2 = 0;
THShortTensor *arg3 = NULL;
int arg3_idx = 0;
THLongTensor *arg4 = NULL;
int arg4_idx = 0;
THShortTensor *arg5 = NULL;
long arg6 = 0;
int arg7 = 1;
if(narg == 1
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
)
{
argset = 1;
}
else if(narg == 2
&& (arg5 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 2;
arg6 = (long)lua_tonumber(L, 2)-1;
arg3 = THShortTensor_new();
arg4 = THLongTensor_new();
}
else if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg3_idx = 1;
arg6 = (long)lua_tonumber(L, 3)-1;
arg4 = THLongTensor_new();
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg4_idx = 1;
arg6 = (long)lua_tonumber(L, 3)-1;
arg3 = THShortTensor_new();
}
else if(narg == 4
&& (arg3 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg4 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg5 = luaT_toudata(L, 3, "torch.ShortTensor"))
&& lua_isnumber(L, 4)
)
{
argset = 2;
arg3_idx = 1;
arg4_idx = 2;
arg6 = (long)lua_tonumber(L, 4)-1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: ShortTensor | [*ShortTensor*] [*LongTensor*] ShortTensor index", type_buf);
}
if(argset == 1)
{
arg2 = THShortTensor_minall(arg1);
lua_pushnumber(L, (lua_Number)arg2);
return 1;
}
else if(argset == 2)
{
if(arg3_idx)
lua_pushvalue(L, arg3_idx);
else
luaT_pushudata(L, arg3, "torch.ShortTensor");
if(arg4_idx)
lua_pushvalue(L, arg4_idx);
else
luaT_pushudata(L, arg4, "torch.LongTensor");
THShortTensor_min(arg3,arg4,arg5,arg6,arg7);
THLongTensor_add(arg4, arg4, 1);
return 2;
}
return 0;
}

static int torch_ShortTensor_max(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THShortTensor *arg1 = NULL;
short arg2 = 0;
THShortTensor *arg3 = NULL;
int arg3_idx = 0;
THLongTensor *arg4 = NULL;
int arg4_idx = 0;
THShortTensor *arg5 = NULL;
long arg6 = 0;
int arg7 = 1;
if(narg == 1
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
)
{
argset = 1;
}
else if(narg == 2
&& (arg5 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 2;
arg6 = (long)lua_tonumber(L, 2)-1;
arg3 = THShortTensor_new();
arg4 = THLongTensor_new();
}
else if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg3_idx = 1;
arg6 = (long)lua_tonumber(L, 3)-1;
arg4 = THLongTensor_new();
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg4_idx = 1;
arg6 = (long)lua_tonumber(L, 3)-1;
arg3 = THShortTensor_new();
}
else if(narg == 4
&& (arg3 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg4 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg5 = luaT_toudata(L, 3, "torch.ShortTensor"))
&& lua_isnumber(L, 4)
)
{
argset = 2;
arg3_idx = 1;
arg4_idx = 2;
arg6 = (long)lua_tonumber(L, 4)-1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: ShortTensor | [*ShortTensor*] [*LongTensor*] ShortTensor index", type_buf);
}
if(argset == 1)
{
arg2 = THShortTensor_maxall(arg1);
lua_pushnumber(L, (lua_Number)arg2);
return 1;
}
else if(argset == 2)
{
if(arg3_idx)
lua_pushvalue(L, arg3_idx);
else
luaT_pushudata(L, arg3, "torch.ShortTensor");
if(arg4_idx)
lua_pushvalue(L, arg4_idx);
else
luaT_pushudata(L, arg4, "torch.LongTensor");
THShortTensor_max(arg3,arg4,arg5,arg6,arg7);
THLongTensor_add(arg4, arg4, 1);
return 2;
}
return 0;
}

static int torch_ShortTensor_cmin(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THShortTensor *arg2 = NULL;
THShortTensor *arg3 = NULL;
THShortTensor *arg4 = NULL;
int arg4_idx = 0;
THShortTensor *arg5 = NULL;
short arg6 = 0;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
)
{
argset = 1;
arg1 = THShortTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor"))
)
{
argset = 1;
arg1_idx = 1;
}
else if(narg == 2
&& (arg5 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 2;
arg6 = (short)lua_tonumber(L, 2);
arg4 = THShortTensor_new();
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg4_idx = 1;
arg6 = (short)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ShortTensor*] ShortTensor ShortTensor | [*ShortTensor*] ShortTensor short", type_buf);
}
if(argset == 1)
{
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ShortTensor");
THShortTensor_cmin(arg1,arg2,arg3);
return 1;
}
else if(argset == 2)
{
if(arg4_idx)
lua_pushvalue(L, arg4_idx);
else
luaT_pushudata(L, arg4, "torch.ShortTensor");
THShortTensor_cminValue(arg4,arg5,arg6);
return 1;
}
return 0;
}

static int torch_ShortTensor_cmax(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THShortTensor *arg2 = NULL;
THShortTensor *arg3 = NULL;
THShortTensor *arg4 = NULL;
int arg4_idx = 0;
THShortTensor *arg5 = NULL;
short arg6 = 0;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
)
{
argset = 1;
arg1 = THShortTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor"))
)
{
argset = 1;
arg1_idx = 1;
}
else if(narg == 2
&& (arg5 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 2;
arg6 = (short)lua_tonumber(L, 2);
arg4 = THShortTensor_new();
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg4_idx = 1;
arg6 = (short)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ShortTensor*] ShortTensor ShortTensor | [*ShortTensor*] ShortTensor short", type_buf);
}
if(argset == 1)
{
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ShortTensor");
THShortTensor_cmax(arg1,arg2,arg3);
return 1;
}
else if(argset == 2)
{
if(arg4_idx)
lua_pushvalue(L, arg4_idx);
else
luaT_pushudata(L, arg4, "torch.ShortTensor");
THShortTensor_cmaxValue(arg4,arg5,arg6);
return 1;
}
return 0;
}

static int torch_ShortTensor_trace(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
long arg2 = 0;
if(narg == 1
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
)
{
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: ShortTensor", type_buf);
}
arg2 = THShortTensor_trace(arg1);
lua_pushnumber(L, (lua_Number)arg2);
return 1;
}

static int torch_ShortTensor_cross(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THShortTensor *arg2 = NULL;
THShortTensor *arg3 = NULL;
long arg4 = -1;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
)
{
arg1 = THShortTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor"))
)
{
arg1_idx = 1;
}
else if(narg == 3
&& (arg2 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
)
{
arg4 = (long)lua_tonumber(L, 3)-1;
arg1 = THShortTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor"))
&& lua_isnumber(L, 4)
)
{
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 4)-1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ShortTensor*] ShortTensor ShortTensor [index]", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ShortTensor");
THShortTensor_cross(arg1,arg2,arg3,arg4);
return 1;
}

static int torch_ShortTensor_diag(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THShortTensor *arg2 = NULL;
long arg3 = 0;
if(narg == 1
&& (arg2 = luaT_toudata(L, 1, "torch.ShortTensor"))
)
{
arg1 = THShortTensor_new();
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
)
{
arg1_idx = 1;
}
else if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
)
{
arg3 = (long)lua_tonumber(L, 2);
arg1 = THShortTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (long)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ShortTensor*] ShortTensor [long]", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ShortTensor");
THShortTensor_diag(arg1,arg2,arg3);
return 1;
}

static int torch_ShortTensor_eye(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
long arg2 = 0;
long arg3 = 0;
if(narg == 1
&& lua_isnumber(L, 1)
)
{
arg2 = (long)lua_tonumber(L, 1);
arg1 = THShortTensor_new();
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
)
{
arg1_idx = 1;
arg2 = (long)lua_tonumber(L, 2);
}
else if(narg == 2
&& lua_isnumber(L, 1)
&& lua_isnumber(L, 2)
)
{
arg2 = (long)lua_tonumber(L, 1);
arg3 = (long)lua_tonumber(L, 2);
arg1 = THShortTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg2 = (long)lua_tonumber(L, 2);
arg3 = (long)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ShortTensor*] long [long]", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ShortTensor");
THShortTensor_eye(arg1,arg2,arg3);
return 1;
}

static int torch_ShortTensor_range(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
long arg2 = 0;
long arg3 = 0;
long arg4 = 1;
if(narg == 2
&& lua_isnumber(L, 1)
&& lua_isnumber(L, 2)
)
{
arg2 = (long)lua_tonumber(L, 1);
arg3 = (long)lua_tonumber(L, 2);
arg1 = THShortTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg2 = (long)lua_tonumber(L, 2);
arg3 = (long)lua_tonumber(L, 3);
}
else if(narg == 3
&& lua_isnumber(L, 1)
&& lua_isnumber(L, 2)
&& lua_isnumber(L, 3)
)
{
arg2 = (long)lua_tonumber(L, 1);
arg3 = (long)lua_tonumber(L, 2);
arg4 = (long)lua_tonumber(L, 3);
arg1 = THShortTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
&& lua_isnumber(L, 3)
&& lua_isnumber(L, 4)
)
{
arg1_idx = 1;
arg2 = (long)lua_tonumber(L, 2);
arg3 = (long)lua_tonumber(L, 3);
arg4 = (long)lua_tonumber(L, 4);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ShortTensor*] long long [long]", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ShortTensor");
THShortTensor_range(arg1,arg2,arg3,arg4);
return 1;
}

static int torch_ShortTensor_randperm(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THGenerator *arg2 = NULL;
long arg3 = 0;
if(narg == 1
&& lua_isnumber(L, 1)
)
{
arg3 = (long)lua_tonumber(L, 1);
arg1 = THShortTensor_new();
lua_getglobal(L,"torch");
arg2 = luaT_getfieldcheckudata(L, -1, "_gen", torch_Generator);
lua_pop(L, 2);
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
)
{
arg1_idx = 1;
arg3 = (long)lua_tonumber(L, 2);
lua_getglobal(L,"torch");
arg2 = luaT_getfieldcheckudata(L, -1, "_gen", torch_Generator);
lua_pop(L, 2);
}
else if(narg == 2
&& (arg2 = luaT_toudata(L, 1, torch_Generator))
&& lua_isnumber(L, 2)
)
{
arg3 = (long)lua_tonumber(L, 2);
arg1 = THShortTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, torch_Generator))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (long)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ShortTensor*] [Generator] long", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ShortTensor");
THShortTensor_randperm(arg1,arg2,arg3);

THShortTensor_add(arg1, arg1, 1);
return 1;
}

static int torch_ShortTensor_sort(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THLongTensor *arg2 = NULL;
int arg2_idx = 0;
THShortTensor *arg3 = NULL;
long arg4 = 0;
int arg5 = 0;
if(narg == 1
&& (arg3 = luaT_toudata(L, 1, "torch.ShortTensor"))
)
{
arg1 = THShortTensor_new();
arg2 = THLongTensor_new();
arg4 = THShortTensor_nDimension(arg3)-1;
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
)
{
arg1_idx = 1;
arg2 = THLongTensor_new();
arg4 = THShortTensor_nDimension(arg3)-1;
}
else if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
)
{
arg2_idx = 1;
arg1 = THShortTensor_new();
arg4 = THShortTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor"))
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = THShortTensor_nDimension(arg3)-1;
}
else if(narg == 2
&& (arg3 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
)
{
arg4 = (long)lua_tonumber(L, 2)-1;
arg1 = THShortTensor_new();
arg2 = THLongTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 3)-1;
arg2 = THLongTensor_new();
}
else if(narg == 3
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
)
{
arg2_idx = 1;
arg4 = (long)lua_tonumber(L, 3)-1;
arg1 = THShortTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor"))
&& lua_isnumber(L, 4)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = (long)lua_tonumber(L, 4)-1;
}
else if(narg == 2
&& (arg3 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isboolean(L, 2)
)
{
arg5 = lua_toboolean(L, 2);
arg1 = THShortTensor_new();
arg2 = THLongTensor_new();
arg4 = THShortTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isboolean(L, 3)
)
{
arg1_idx = 1;
arg5 = lua_toboolean(L, 3);
arg2 = THLongTensor_new();
arg4 = THShortTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isboolean(L, 3)
)
{
arg2_idx = 1;
arg5 = lua_toboolean(L, 3);
arg1 = THShortTensor_new();
arg4 = THShortTensor_nDimension(arg3)-1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor"))
&& lua_isboolean(L, 4)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg5 = lua_toboolean(L, 4);
arg4 = THShortTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
&& lua_isboolean(L, 3)
)
{
arg4 = (long)lua_tonumber(L, 2)-1;
arg5 = lua_toboolean(L, 3);
arg1 = THShortTensor_new();
arg2 = THLongTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
)
{
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 3)-1;
arg5 = lua_toboolean(L, 4);
arg2 = THLongTensor_new();
}
else if(narg == 4
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
)
{
arg2_idx = 1;
arg4 = (long)lua_tonumber(L, 3)-1;
arg5 = lua_toboolean(L, 4);
arg1 = THShortTensor_new();
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor"))
&& lua_isnumber(L, 4)
&& lua_isboolean(L, 5)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = (long)lua_tonumber(L, 4)-1;
arg5 = lua_toboolean(L, 5);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ShortTensor*] [*LongTensor*] ShortTensor [index] [boolean]", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ShortTensor");
if(arg2_idx)
lua_pushvalue(L, arg2_idx);
else
luaT_pushudata(L, arg2, "torch.LongTensor");
THShortTensor_sort(arg1,arg2,arg3,arg4,arg5);
THLongTensor_add(arg2, arg2, 1);
return 2;
}

static int torch_ShortTensor_topk(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THLongTensor *arg2 = NULL;
int arg2_idx = 0;
THShortTensor *arg3 = NULL;
long arg4 = 1;
long arg5 = 0;
int arg6 = 0;
int arg7 = 0;
if(narg == 1
&& (arg3 = luaT_toudata(L, 1, "torch.ShortTensor"))
)
{
arg1 = THShortTensor_new();
arg2 = THLongTensor_new();
arg5 = THShortTensor_nDimension(arg3)-1;
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
)
{
arg1_idx = 1;
arg2 = THLongTensor_new();
arg5 = THShortTensor_nDimension(arg3)-1;
}
else if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
)
{
arg2_idx = 1;
arg1 = THShortTensor_new();
arg5 = THShortTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor"))
)
{
arg1_idx = 1;
arg2_idx = 2;
arg5 = THShortTensor_nDimension(arg3)-1;
}
else if(narg == 2
&& (arg3 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
)
{
arg4 = (long)lua_tonumber(L, 2);
arg1 = THShortTensor_new();
arg2 = THLongTensor_new();
arg5 = THShortTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg2 = THLongTensor_new();
arg5 = THShortTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
)
{
arg2_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg1 = THShortTensor_new();
arg5 = THShortTensor_nDimension(arg3)-1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor"))
&& lua_isnumber(L, 4)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = (long)lua_tonumber(L, 4);
arg5 = THShortTensor_nDimension(arg3)-1;
}
else if(narg == 2
&& (arg3 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
)
{
arg5 = (long)lua_tonumber(L, 2)-1;
arg1 = THShortTensor_new();
arg2 = THLongTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg5 = (long)lua_tonumber(L, 3)-1;
arg2 = THLongTensor_new();
}
else if(narg == 3
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
)
{
arg2_idx = 1;
arg5 = (long)lua_tonumber(L, 3)-1;
arg1 = THShortTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor"))
&& lua_isnumber(L, 4)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg5 = (long)lua_tonumber(L, 4)-1;
}
else if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
&& lua_isnumber(L, 3)
)
{
arg4 = (long)lua_tonumber(L, 2);
arg5 = (long)lua_tonumber(L, 3)-1;
arg1 = THShortTensor_new();
arg2 = THLongTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
&& lua_isnumber(L, 4)
)
{
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg5 = (long)lua_tonumber(L, 4)-1;
arg2 = THLongTensor_new();
}
else if(narg == 4
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
&& lua_isnumber(L, 4)
)
{
arg2_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg5 = (long)lua_tonumber(L, 4)-1;
arg1 = THShortTensor_new();
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor"))
&& lua_isnumber(L, 4)
&& lua_isnumber(L, 5)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = (long)lua_tonumber(L, 4);
arg5 = (long)lua_tonumber(L, 5)-1;
}
else if(narg == 2
&& (arg3 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isboolean(L, 2)
)
{
arg6 = lua_toboolean(L, 2);
arg1 = THShortTensor_new();
arg2 = THLongTensor_new();
arg5 = THShortTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isboolean(L, 3)
)
{
arg1_idx = 1;
arg6 = lua_toboolean(L, 3);
arg2 = THLongTensor_new();
arg5 = THShortTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isboolean(L, 3)
)
{
arg2_idx = 1;
arg6 = lua_toboolean(L, 3);
arg1 = THShortTensor_new();
arg5 = THShortTensor_nDimension(arg3)-1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor"))
&& lua_isboolean(L, 4)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg6 = lua_toboolean(L, 4);
arg5 = THShortTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
&& lua_isboolean(L, 3)
)
{
arg4 = (long)lua_tonumber(L, 2);
arg6 = lua_toboolean(L, 3);
arg1 = THShortTensor_new();
arg2 = THLongTensor_new();
arg5 = THShortTensor_nDimension(arg3)-1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
)
{
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg6 = lua_toboolean(L, 4);
arg2 = THLongTensor_new();
arg5 = THShortTensor_nDimension(arg3)-1;
}
else if(narg == 4
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
)
{
arg2_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg6 = lua_toboolean(L, 4);
arg1 = THShortTensor_new();
arg5 = THShortTensor_nDimension(arg3)-1;
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor"))
&& lua_isnumber(L, 4)
&& lua_isboolean(L, 5)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = (long)lua_tonumber(L, 4);
arg6 = lua_toboolean(L, 5);
arg5 = THShortTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
&& lua_isboolean(L, 3)
)
{
arg5 = (long)lua_tonumber(L, 2)-1;
arg6 = lua_toboolean(L, 3);
arg1 = THShortTensor_new();
arg2 = THLongTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
)
{
arg1_idx = 1;
arg5 = (long)lua_tonumber(L, 3)-1;
arg6 = lua_toboolean(L, 4);
arg2 = THLongTensor_new();
}
else if(narg == 4
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
)
{
arg2_idx = 1;
arg5 = (long)lua_tonumber(L, 3)-1;
arg6 = lua_toboolean(L, 4);
arg1 = THShortTensor_new();
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor"))
&& lua_isnumber(L, 4)
&& lua_isboolean(L, 5)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg5 = (long)lua_tonumber(L, 4)-1;
arg6 = lua_toboolean(L, 5);
}
else if(narg == 4
&& (arg3 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
)
{
arg4 = (long)lua_tonumber(L, 2);
arg5 = (long)lua_tonumber(L, 3)-1;
arg6 = lua_toboolean(L, 4);
arg1 = THShortTensor_new();
arg2 = THLongTensor_new();
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
&& lua_isnumber(L, 4)
&& lua_isboolean(L, 5)
)
{
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg5 = (long)lua_tonumber(L, 4)-1;
arg6 = lua_toboolean(L, 5);
arg2 = THLongTensor_new();
}
else if(narg == 5
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
&& lua_isnumber(L, 4)
&& lua_isboolean(L, 5)
)
{
arg2_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg5 = (long)lua_tonumber(L, 4)-1;
arg6 = lua_toboolean(L, 5);
arg1 = THShortTensor_new();
}
else if(narg == 6
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor"))
&& lua_isnumber(L, 4)
&& lua_isnumber(L, 5)
&& lua_isboolean(L, 6)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = (long)lua_tonumber(L, 4);
arg5 = (long)lua_tonumber(L, 5)-1;
arg6 = lua_toboolean(L, 6);
}
else if(narg == 2
&& (arg3 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isboolean(L, 2)
)
{
arg7 = lua_toboolean(L, 2);
arg1 = THShortTensor_new();
arg2 = THLongTensor_new();
arg5 = THShortTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isboolean(L, 3)
)
{
arg1_idx = 1;
arg7 = lua_toboolean(L, 3);
arg2 = THLongTensor_new();
arg5 = THShortTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isboolean(L, 3)
)
{
arg2_idx = 1;
arg7 = lua_toboolean(L, 3);
arg1 = THShortTensor_new();
arg5 = THShortTensor_nDimension(arg3)-1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor"))
&& lua_isboolean(L, 4)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg7 = lua_toboolean(L, 4);
arg5 = THShortTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
&& lua_isboolean(L, 3)
)
{
arg4 = (long)lua_tonumber(L, 2);
arg7 = lua_toboolean(L, 3);
arg1 = THShortTensor_new();
arg2 = THLongTensor_new();
arg5 = THShortTensor_nDimension(arg3)-1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
)
{
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg7 = lua_toboolean(L, 4);
arg2 = THLongTensor_new();
arg5 = THShortTensor_nDimension(arg3)-1;
}
else if(narg == 4
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
)
{
arg2_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg7 = lua_toboolean(L, 4);
arg1 = THShortTensor_new();
arg5 = THShortTensor_nDimension(arg3)-1;
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor"))
&& lua_isnumber(L, 4)
&& lua_isboolean(L, 5)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = (long)lua_tonumber(L, 4);
arg7 = lua_toboolean(L, 5);
arg5 = THShortTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
&& lua_isboolean(L, 3)
)
{
arg5 = (long)lua_tonumber(L, 2)-1;
arg7 = lua_toboolean(L, 3);
arg1 = THShortTensor_new();
arg2 = THLongTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
)
{
arg1_idx = 1;
arg5 = (long)lua_tonumber(L, 3)-1;
arg7 = lua_toboolean(L, 4);
arg2 = THLongTensor_new();
}
else if(narg == 4
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
)
{
arg2_idx = 1;
arg5 = (long)lua_tonumber(L, 3)-1;
arg7 = lua_toboolean(L, 4);
arg1 = THShortTensor_new();
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor"))
&& lua_isnumber(L, 4)
&& lua_isboolean(L, 5)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg5 = (long)lua_tonumber(L, 4)-1;
arg7 = lua_toboolean(L, 5);
}
else if(narg == 4
&& (arg3 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
)
{
arg4 = (long)lua_tonumber(L, 2);
arg5 = (long)lua_tonumber(L, 3)-1;
arg7 = lua_toboolean(L, 4);
arg1 = THShortTensor_new();
arg2 = THLongTensor_new();
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
&& lua_isnumber(L, 4)
&& lua_isboolean(L, 5)
)
{
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg5 = (long)lua_tonumber(L, 4)-1;
arg7 = lua_toboolean(L, 5);
arg2 = THLongTensor_new();
}
else if(narg == 5
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
&& lua_isnumber(L, 4)
&& lua_isboolean(L, 5)
)
{
arg2_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg5 = (long)lua_tonumber(L, 4)-1;
arg7 = lua_toboolean(L, 5);
arg1 = THShortTensor_new();
}
else if(narg == 6
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor"))
&& lua_isnumber(L, 4)
&& lua_isnumber(L, 5)
&& lua_isboolean(L, 6)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = (long)lua_tonumber(L, 4);
arg5 = (long)lua_tonumber(L, 5)-1;
arg7 = lua_toboolean(L, 6);
}
else if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isboolean(L, 2)
&& lua_isboolean(L, 3)
)
{
arg6 = lua_toboolean(L, 2);
arg7 = lua_toboolean(L, 3);
arg1 = THShortTensor_new();
arg2 = THLongTensor_new();
arg5 = THShortTensor_nDimension(arg3)-1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isboolean(L, 3)
&& lua_isboolean(L, 4)
)
{
arg1_idx = 1;
arg6 = lua_toboolean(L, 3);
arg7 = lua_toboolean(L, 4);
arg2 = THLongTensor_new();
arg5 = THShortTensor_nDimension(arg3)-1;
}
else if(narg == 4
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isboolean(L, 3)
&& lua_isboolean(L, 4)
)
{
arg2_idx = 1;
arg6 = lua_toboolean(L, 3);
arg7 = lua_toboolean(L, 4);
arg1 = THShortTensor_new();
arg5 = THShortTensor_nDimension(arg3)-1;
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor"))
&& lua_isboolean(L, 4)
&& lua_isboolean(L, 5)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg6 = lua_toboolean(L, 4);
arg7 = lua_toboolean(L, 5);
arg5 = THShortTensor_nDimension(arg3)-1;
}
else if(narg == 4
&& (arg3 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
&& lua_isboolean(L, 3)
&& lua_isboolean(L, 4)
)
{
arg4 = (long)lua_tonumber(L, 2);
arg6 = lua_toboolean(L, 3);
arg7 = lua_toboolean(L, 4);
arg1 = THShortTensor_new();
arg2 = THLongTensor_new();
arg5 = THShortTensor_nDimension(arg3)-1;
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
&& lua_isboolean(L, 5)
)
{
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg6 = lua_toboolean(L, 4);
arg7 = lua_toboolean(L, 5);
arg2 = THLongTensor_new();
arg5 = THShortTensor_nDimension(arg3)-1;
}
else if(narg == 5
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
&& lua_isboolean(L, 5)
)
{
arg2_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg6 = lua_toboolean(L, 4);
arg7 = lua_toboolean(L, 5);
arg1 = THShortTensor_new();
arg5 = THShortTensor_nDimension(arg3)-1;
}
else if(narg == 6
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor"))
&& lua_isnumber(L, 4)
&& lua_isboolean(L, 5)
&& lua_isboolean(L, 6)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = (long)lua_tonumber(L, 4);
arg6 = lua_toboolean(L, 5);
arg7 = lua_toboolean(L, 6);
arg5 = THShortTensor_nDimension(arg3)-1;
}
else if(narg == 4
&& (arg3 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
&& lua_isboolean(L, 3)
&& lua_isboolean(L, 4)
)
{
arg5 = (long)lua_tonumber(L, 2)-1;
arg6 = lua_toboolean(L, 3);
arg7 = lua_toboolean(L, 4);
arg1 = THShortTensor_new();
arg2 = THLongTensor_new();
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
&& lua_isboolean(L, 5)
)
{
arg1_idx = 1;
arg5 = (long)lua_tonumber(L, 3)-1;
arg6 = lua_toboolean(L, 4);
arg7 = lua_toboolean(L, 5);
arg2 = THLongTensor_new();
}
else if(narg == 5
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
&& lua_isboolean(L, 5)
)
{
arg2_idx = 1;
arg5 = (long)lua_tonumber(L, 3)-1;
arg6 = lua_toboolean(L, 4);
arg7 = lua_toboolean(L, 5);
arg1 = THShortTensor_new();
}
else if(narg == 6
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor"))
&& lua_isnumber(L, 4)
&& lua_isboolean(L, 5)
&& lua_isboolean(L, 6)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg5 = (long)lua_tonumber(L, 4)-1;
arg6 = lua_toboolean(L, 5);
arg7 = lua_toboolean(L, 6);
}
else if(narg == 5
&& (arg3 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
&& lua_isboolean(L, 5)
)
{
arg4 = (long)lua_tonumber(L, 2);
arg5 = (long)lua_tonumber(L, 3)-1;
arg6 = lua_toboolean(L, 4);
arg7 = lua_toboolean(L, 5);
arg1 = THShortTensor_new();
arg2 = THLongTensor_new();
}
else if(narg == 6
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
&& lua_isnumber(L, 4)
&& lua_isboolean(L, 5)
&& lua_isboolean(L, 6)
)
{
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg5 = (long)lua_tonumber(L, 4)-1;
arg6 = lua_toboolean(L, 5);
arg7 = lua_toboolean(L, 6);
arg2 = THLongTensor_new();
}
else if(narg == 6
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
&& lua_isnumber(L, 4)
&& lua_isboolean(L, 5)
&& lua_isboolean(L, 6)
)
{
arg2_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg5 = (long)lua_tonumber(L, 4)-1;
arg6 = lua_toboolean(L, 5);
arg7 = lua_toboolean(L, 6);
arg1 = THShortTensor_new();
}
else if(narg == 7
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor"))
&& lua_isnumber(L, 4)
&& lua_isnumber(L, 5)
&& lua_isboolean(L, 6)
&& lua_isboolean(L, 7)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = (long)lua_tonumber(L, 4);
arg5 = (long)lua_tonumber(L, 5)-1;
arg6 = lua_toboolean(L, 6);
arg7 = lua_toboolean(L, 7);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ShortTensor*] [*LongTensor*] ShortTensor [long] [index] [boolean] [boolean]", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ShortTensor");
if(arg2_idx)
lua_pushvalue(L, arg2_idx);
else
luaT_pushudata(L, arg2, "torch.LongTensor");
THShortTensor_topk(arg1,arg2,arg3,arg4,arg5,arg6,arg7);
THLongTensor_add(arg2, arg2, 1);
return 2;
}

static int torch_ShortTensor_kthvalue(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THLongTensor *arg2 = NULL;
int arg2_idx = 0;
THShortTensor *arg3 = NULL;
long arg4 = 0;
long arg5 = 0;
int arg6 = 1;
if(narg == 2
&& (arg3 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
)
{
arg4 = (long)lua_tonumber(L, 2);
arg1 = THShortTensor_new();
arg2 = THLongTensor_new();
arg5 = THShortTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg2 = THLongTensor_new();
arg5 = THShortTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
)
{
arg2_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg1 = THShortTensor_new();
arg5 = THShortTensor_nDimension(arg3)-1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor"))
&& lua_isnumber(L, 4)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = (long)lua_tonumber(L, 4);
arg5 = THShortTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
&& lua_isnumber(L, 3)
)
{
arg4 = (long)lua_tonumber(L, 2);
arg5 = (long)lua_tonumber(L, 3)-1;
arg1 = THShortTensor_new();
arg2 = THLongTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
&& lua_isnumber(L, 4)
)
{
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg5 = (long)lua_tonumber(L, 4)-1;
arg2 = THLongTensor_new();
}
else if(narg == 4
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
&& lua_isnumber(L, 4)
)
{
arg2_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg5 = (long)lua_tonumber(L, 4)-1;
arg1 = THShortTensor_new();
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor"))
&& lua_isnumber(L, 4)
&& lua_isnumber(L, 5)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = (long)lua_tonumber(L, 4);
arg5 = (long)lua_tonumber(L, 5)-1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ShortTensor*] [*LongTensor*] ShortTensor long [index]", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ShortTensor");
if(arg2_idx)
lua_pushvalue(L, arg2_idx);
else
luaT_pushudata(L, arg2, "torch.LongTensor");
THShortTensor_kthvalue(arg1,arg2,arg3,arg4,arg5,arg6);
THLongTensor_add(arg2, arg2, 1);
return 2;
}

static int torch_ShortTensor_mode(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THLongTensor *arg2 = NULL;
int arg2_idx = 0;
THShortTensor *arg3 = NULL;
long arg4 = 0;
int arg5 = 1;
if(narg == 1
&& (arg3 = luaT_toudata(L, 1, "torch.ShortTensor"))
)
{
arg1 = THShortTensor_new();
arg2 = THLongTensor_new();
arg4 = THShortTensor_nDimension(arg3)-1;
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
)
{
arg1_idx = 1;
arg2 = THLongTensor_new();
arg4 = THShortTensor_nDimension(arg3)-1;
}
else if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
)
{
arg2_idx = 1;
arg1 = THShortTensor_new();
arg4 = THShortTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor"))
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = THShortTensor_nDimension(arg3)-1;
}
else if(narg == 2
&& (arg3 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
)
{
arg4 = (long)lua_tonumber(L, 2)-1;
arg1 = THShortTensor_new();
arg2 = THLongTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 3)-1;
arg2 = THLongTensor_new();
}
else if(narg == 3
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
)
{
arg2_idx = 1;
arg4 = (long)lua_tonumber(L, 3)-1;
arg1 = THShortTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor"))
&& lua_isnumber(L, 4)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = (long)lua_tonumber(L, 4)-1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ShortTensor*] [*LongTensor*] ShortTensor [index]", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ShortTensor");
if(arg2_idx)
lua_pushvalue(L, arg2_idx);
else
luaT_pushudata(L, arg2, "torch.LongTensor");
THShortTensor_mode(arg1,arg2,arg3,arg4,arg5);
THLongTensor_add(arg2, arg2, 1);
return 2;
}

static int torch_ShortTensor_median(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THLongTensor *arg2 = NULL;
int arg2_idx = 0;
THShortTensor *arg3 = NULL;
long arg4 = 0;
int arg5 = 1;
if(narg == 1
&& (arg3 = luaT_toudata(L, 1, "torch.ShortTensor"))
)
{
arg1 = THShortTensor_new();
arg2 = THLongTensor_new();
arg4 = THShortTensor_nDimension(arg3)-1;
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
)
{
arg1_idx = 1;
arg2 = THLongTensor_new();
arg4 = THShortTensor_nDimension(arg3)-1;
}
else if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
)
{
arg2_idx = 1;
arg1 = THShortTensor_new();
arg4 = THShortTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor"))
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = THShortTensor_nDimension(arg3)-1;
}
else if(narg == 2
&& (arg3 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
)
{
arg4 = (long)lua_tonumber(L, 2)-1;
arg1 = THShortTensor_new();
arg2 = THLongTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 3)-1;
arg2 = THLongTensor_new();
}
else if(narg == 3
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
)
{
arg2_idx = 1;
arg4 = (long)lua_tonumber(L, 3)-1;
arg1 = THShortTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor"))
&& lua_isnumber(L, 4)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = (long)lua_tonumber(L, 4)-1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ShortTensor*] [*LongTensor*] ShortTensor [index]", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ShortTensor");
if(arg2_idx)
lua_pushvalue(L, arg2_idx);
else
luaT_pushudata(L, arg2, "torch.LongTensor");
THShortTensor_median(arg1,arg2,arg3,arg4,arg5);
THLongTensor_add(arg2, arg2, 1);
return 2;
}

static int torch_ShortTensor_tril(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THShortTensor *arg2 = NULL;
int arg3 = 0;
if(narg == 1
&& (arg2 = luaT_toudata(L, 1, "torch.ShortTensor"))
)
{
arg1 = THShortTensor_new();
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
)
{
arg1_idx = 1;
}
else if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
)
{
arg3 = (int)lua_tonumber(L, 2);
arg1 = THShortTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (int)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ShortTensor*] ShortTensor [int]", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ShortTensor");
THShortTensor_tril(arg1,arg2,arg3);
return 1;
}

static int torch_ShortTensor_triu(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THShortTensor *arg2 = NULL;
int arg3 = 0;
if(narg == 1
&& (arg2 = luaT_toudata(L, 1, "torch.ShortTensor"))
)
{
arg1 = THShortTensor_new();
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
)
{
arg1_idx = 1;
}
else if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
)
{
arg3 = (int)lua_tonumber(L, 2);
arg1 = THShortTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (int)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ShortTensor*] ShortTensor [int]", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ShortTensor");
THShortTensor_triu(arg1,arg2,arg3);
return 1;
}

static int torch_ShortTensor_cat(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THShortTensor *arg2 = NULL;
THShortTensor *arg3 = NULL;
long arg4 = -2;
THShortTensor *arg5 = NULL;
int arg5_idx = 0;
THShortTensor **arg6_data = NULL;
long arg6_size = 0;
int arg6_i = 0;
long arg7 = -2;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
)
{
argset = 1;
arg1 = THShortTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor"))
)
{
argset = 1;
arg1_idx = 1;
}
else if(narg == 3
&& (arg2 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 1;
arg4 = (long)lua_tonumber(L, 3)-1;
arg1 = THShortTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor"))
&& lua_isnumber(L, 4)
)
{
argset = 1;
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 4)-1;
}
else if(narg == 1
&& torch_isnonemptytable(L, 1)
)
{
argset = 2;
do
{
  arg6_size++;
  lua_checkstack(L, 1);
  lua_rawgeti(L, 1, arg6_size);
}
while (!lua_isnil(L, -1));
arg6_size--;
lua_pop(L, 1);
arg6_data = (THShortTensor**)THAlloc(arg6_size * sizeof(THShortTensor*));
for (arg6_i = arg6_size - 1; arg6_i >= 0; arg6_i--)
{
  if (!(arg6_data[arg6_i] = luaT_toudata(L, -1, "torch.ShortTensor")))
    luaL_error(L, "expected ShortTensor in tensor array");
  lua_pop(L, 1);
}

arg5 = THShortTensor_new();
}
else if(narg == 2
&& (arg5 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& torch_isnonemptytable(L, 2)
)
{
argset = 2;
arg5_idx = 1;
do
{
  arg6_size++;
  lua_checkstack(L, 1);
  lua_rawgeti(L, 2, arg6_size);
}
while (!lua_isnil(L, -1));
arg6_size--;
lua_pop(L, 1);
arg6_data = (THShortTensor**)THAlloc(arg6_size * sizeof(THShortTensor*));
for (arg6_i = arg6_size - 1; arg6_i >= 0; arg6_i--)
{
  if (!(arg6_data[arg6_i] = luaT_toudata(L, -1, "torch.ShortTensor")))
    luaL_error(L, "expected ShortTensor in tensor array");
  lua_pop(L, 1);
}

}
else if(narg == 2
&& torch_isnonemptytable(L, 1)
&& lua_isnumber(L, 2)
)
{
argset = 2;
do
{
  arg6_size++;
  lua_checkstack(L, 1);
  lua_rawgeti(L, 1, arg6_size);
}
while (!lua_isnil(L, -1));
arg6_size--;
lua_pop(L, 1);
arg6_data = (THShortTensor**)THAlloc(arg6_size * sizeof(THShortTensor*));
for (arg6_i = arg6_size - 1; arg6_i >= 0; arg6_i--)
{
  if (!(arg6_data[arg6_i] = luaT_toudata(L, -1, "torch.ShortTensor")))
    luaL_error(L, "expected ShortTensor in tensor array");
  lua_pop(L, 1);
}

arg7 = (long)lua_tonumber(L, 2)-1;
arg5 = THShortTensor_new();
}
else if(narg == 3
&& (arg5 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& torch_isnonemptytable(L, 2)
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg5_idx = 1;
do
{
  arg6_size++;
  lua_checkstack(L, 1);
  lua_rawgeti(L, 2, arg6_size);
}
while (!lua_isnil(L, -1));
arg6_size--;
lua_pop(L, 1);
arg6_data = (THShortTensor**)THAlloc(arg6_size * sizeof(THShortTensor*));
for (arg6_i = arg6_size - 1; arg6_i >= 0; arg6_i--)
{
  if (!(arg6_data[arg6_i] = luaT_toudata(L, -1, "torch.ShortTensor")))
    luaL_error(L, "expected ShortTensor in tensor array");
  lua_pop(L, 1);
}

arg7 = (long)lua_tonumber(L, 3)-1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ShortTensor*] ShortTensor ShortTensor [index] | [*ShortTensor*] {ShortTensor+} [index]", type_buf);
}
if(argset == 1)
{
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ShortTensor");
THShortTensor_cat(arg1,arg2,arg3,arg4);
return 1;
}
else if(argset == 2)
{
if(arg5_idx)
lua_pushvalue(L, arg5_idx);
else
luaT_pushudata(L, arg5, "torch.ShortTensor");
THShortTensor_catArray(arg5,arg6_data,arg6_size,arg7);
THFree(arg6_data);
return 1;
}
return 0;
}

static void THShortTensor_random2__(THShortTensor *self, THGenerator *gen, long a, long b)
{
  THArgCheck(b >= a, 2, "upper bound must be larger than lower bound");
  TH_TENSOR_APPLY(short, self, *self_data = ((THRandom_random(gen) % (b+1-a)) + a);)
}

static void THShortTensor_random1__(THShortTensor *self, THGenerator *gen, long b)
{
  THArgCheck(b > 0, 1, "upper bound must be strictly positive");
  TH_TENSOR_APPLY(short, self, *self_data = (THRandom_random(gen) % b + 1);)
}

static int torch_ShortTensor_random(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THGenerator *arg1 = NULL;
long arg2 = 0;
long arg3 = 0;
long arg4 = 0;
THGenerator *arg5 = NULL;
long arg6 = 0;
long arg7 = 0;
THGenerator *arg8 = NULL;
long arg9 = 0;
THShortTensor *arg10 = NULL;
int arg10_idx = 0;
THGenerator *arg11 = NULL;
long arg12 = 0;
long arg13 = 0;
THShortTensor *arg14 = NULL;
int arg14_idx = 0;
THGenerator *arg15 = NULL;
long arg16 = 0;
THShortTensor *arg17 = NULL;
int arg17_idx = 0;
THGenerator *arg18 = NULL;
if(narg == 2
&& lua_isnumber(L, 1)
&& lua_isnumber(L, 2)
)
{
argset = 1;
arg2 = (long)lua_tonumber(L, 1);
arg3 = (long)lua_tonumber(L, 2);
lua_getglobal(L,"torch");
arg1 = luaT_getfieldcheckudata(L, -1, "_gen", torch_Generator);
lua_pop(L, 2);
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, torch_Generator))
&& lua_isnumber(L, 2)
&& lua_isnumber(L, 3)
)
{
argset = 1;
arg2 = (long)lua_tonumber(L, 2);
arg3 = (long)lua_tonumber(L, 3);
}
else if(narg == 1
&& lua_isnumber(L, 1)
)
{
argset = 2;
arg6 = (long)lua_tonumber(L, 1);
lua_getglobal(L,"torch");
arg5 = luaT_getfieldcheckudata(L, -1, "_gen", torch_Generator);
lua_pop(L, 2);
}
else if(narg == 2
&& (arg5 = luaT_toudata(L, 1, torch_Generator))
&& lua_isnumber(L, 2)
)
{
argset = 2;
arg6 = (long)lua_tonumber(L, 2);
}
else if(narg == 0
)
{
argset = 3;
lua_getglobal(L,"torch");
arg8 = luaT_getfieldcheckudata(L, -1, "_gen", torch_Generator);
lua_pop(L, 2);
}
else if(narg == 1
&& (arg8 = luaT_toudata(L, 1, torch_Generator))
)
{
argset = 3;
}
else if(narg == 3
&& (arg10 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
&& lua_isnumber(L, 3)
)
{
argset = 4;
arg10_idx = 1;
arg12 = (long)lua_tonumber(L, 2);
arg13 = (long)lua_tonumber(L, 3);
lua_getglobal(L,"torch");
arg11 = luaT_getfieldcheckudata(L, -1, "_gen", torch_Generator);
lua_pop(L, 2);
}
else if(narg == 4
&& (arg10 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg11 = luaT_toudata(L, 2, torch_Generator))
&& lua_isnumber(L, 3)
&& lua_isnumber(L, 4)
)
{
argset = 4;
arg10_idx = 1;
arg12 = (long)lua_tonumber(L, 3);
arg13 = (long)lua_tonumber(L, 4);
}
else if(narg == 2
&& (arg14 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 5;
arg14_idx = 1;
arg16 = (long)lua_tonumber(L, 2);
lua_getglobal(L,"torch");
arg15 = luaT_getfieldcheckudata(L, -1, "_gen", torch_Generator);
lua_pop(L, 2);
}
else if(narg == 3
&& (arg14 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg15 = luaT_toudata(L, 2, torch_Generator))
&& lua_isnumber(L, 3)
)
{
argset = 5;
arg14_idx = 1;
arg16 = (long)lua_tonumber(L, 3);
}
else if(narg == 1
&& (arg17 = luaT_toudata(L, 1, "torch.ShortTensor"))
)
{
argset = 6;
arg17_idx = 1;
lua_getglobal(L,"torch");
arg18 = luaT_getfieldcheckudata(L, -1, "_gen", torch_Generator);
lua_pop(L, 2);
}
else if(narg == 2
&& (arg17 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg18 = luaT_toudata(L, 2, torch_Generator))
)
{
argset = 6;
arg17_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [Generator] long long | [Generator] long | [Generator] | *ShortTensor* [Generator] long long | *ShortTensor* [Generator] long | *ShortTensor* [Generator]", type_buf);
}
if(argset == 1)
{
arg4 = THRandom_random2__(arg1,arg2,arg3);
lua_pushnumber(L, (lua_Number)arg4);
return 1;
}
else if(argset == 2)
{
arg7 = THRandom_random1__(arg5,arg6);
lua_pushnumber(L, (lua_Number)arg7);
return 1;
}
else if(argset == 3)
{
arg9 = THRandom_random(arg8);
lua_pushnumber(L, (lua_Number)arg9);
return 1;
}
else if(argset == 4)
{
lua_pushvalue(L, arg10_idx);
THShortTensor_random2__(arg10,arg11,arg12,arg13);
return 1;
}
else if(argset == 5)
{
lua_pushvalue(L, arg14_idx);
THShortTensor_random1__(arg14,arg15,arg16);
return 1;
}
else if(argset == 6)
{
lua_pushvalue(L, arg17_idx);
THShortTensor_random(arg17,arg18);
return 1;
}
return 0;
}

static int torch_ShortTensor_geometric(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THGenerator *arg1 = NULL;
double arg2 = 0;
double arg3 = 0;
THShortTensor *arg4 = NULL;
int arg4_idx = 0;
THGenerator *arg5 = NULL;
double arg6 = 0;
if(narg == 1
&& lua_isnumber(L, 1)
)
{
argset = 1;
arg2 = (double)lua_tonumber(L, 1);
lua_getglobal(L,"torch");
arg1 = luaT_getfieldcheckudata(L, -1, "_gen", torch_Generator);
lua_pop(L, 2);
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, torch_Generator))
&& lua_isnumber(L, 2)
)
{
argset = 1;
arg2 = (double)lua_tonumber(L, 2);
}
else if(narg == 2
&& (arg4 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 2;
arg4_idx = 1;
arg6 = (double)lua_tonumber(L, 2);
lua_getglobal(L,"torch");
arg5 = luaT_getfieldcheckudata(L, -1, "_gen", torch_Generator);
lua_pop(L, 2);
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg5 = luaT_toudata(L, 2, torch_Generator))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg4_idx = 1;
arg6 = (double)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [Generator] double | *ShortTensor* [Generator] double", type_buf);
}
if(argset == 1)
{
arg3 = THRandom_geometric(arg1,arg2);
lua_pushnumber(L, (lua_Number)arg3);
return 1;
}
else if(argset == 2)
{
lua_pushvalue(L, arg4_idx);
THShortTensor_geometric(arg4,arg5,arg6);
return 1;
}
return 0;
}

static int torch_ShortTensor_bernoulli(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THGenerator *arg1 = NULL;
double arg2 = 0.5;
double arg3 = 0;
THShortTensor *arg4 = NULL;
int arg4_idx = 0;
THGenerator *arg5 = NULL;
double arg6 = 0.5;
THShortTensor *arg7 = NULL;
int arg7_idx = 0;
THGenerator *arg8 = NULL;
THFloatTensor *arg9 = NULL;
THShortTensor *arg10 = NULL;
int arg10_idx = 0;
THGenerator *arg11 = NULL;
THDoubleTensor *arg12 = NULL;
if(narg == 0
)
{
argset = 1;
lua_getglobal(L,"torch");
arg1 = luaT_getfieldcheckudata(L, -1, "_gen", torch_Generator);
lua_pop(L, 2);
}
else if(narg == 1
&& (arg1 = luaT_toudata(L, 1, torch_Generator))
)
{
argset = 1;
}
else if(narg == 1
&& lua_isnumber(L, 1)
)
{
argset = 1;
arg2 = (double)lua_tonumber(L, 1);
lua_getglobal(L,"torch");
arg1 = luaT_getfieldcheckudata(L, -1, "_gen", torch_Generator);
lua_pop(L, 2);
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, torch_Generator))
&& lua_isnumber(L, 2)
)
{
argset = 1;
arg2 = (double)lua_tonumber(L, 2);
}
else if(narg == 1
&& (arg4 = luaT_toudata(L, 1, "torch.ShortTensor"))
)
{
argset = 2;
arg4_idx = 1;
lua_getglobal(L,"torch");
arg5 = luaT_getfieldcheckudata(L, -1, "_gen", torch_Generator);
lua_pop(L, 2);
}
else if(narg == 2
&& (arg4 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg5 = luaT_toudata(L, 2, torch_Generator))
)
{
argset = 2;
arg4_idx = 1;
}
else if(narg == 2
&& (arg4 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 2;
arg4_idx = 1;
arg6 = (double)lua_tonumber(L, 2);
lua_getglobal(L,"torch");
arg5 = luaT_getfieldcheckudata(L, -1, "_gen", torch_Generator);
lua_pop(L, 2);
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg5 = luaT_toudata(L, 2, torch_Generator))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg4_idx = 1;
arg6 = (double)lua_tonumber(L, 3);
}
else if(narg == 2
&& (arg7 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg9 = luaT_toudata(L, 2, "torch.FloatTensor"))
)
{
argset = 3;
arg7_idx = 1;
lua_getglobal(L,"torch");
arg8 = luaT_getfieldcheckudata(L, -1, "_gen", torch_Generator);
lua_pop(L, 2);
}
else if(narg == 3
&& (arg7 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg8 = luaT_toudata(L, 2, torch_Generator))
&& (arg9 = luaT_toudata(L, 3, "torch.FloatTensor"))
)
{
argset = 3;
arg7_idx = 1;
}
else if(narg == 2
&& (arg10 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg12 = luaT_toudata(L, 2, "torch.DoubleTensor"))
)
{
argset = 4;
arg10_idx = 1;
lua_getglobal(L,"torch");
arg11 = luaT_getfieldcheckudata(L, -1, "_gen", torch_Generator);
lua_pop(L, 2);
}
else if(narg == 3
&& (arg10 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg11 = luaT_toudata(L, 2, torch_Generator))
&& (arg12 = luaT_toudata(L, 3, "torch.DoubleTensor"))
)
{
argset = 4;
arg10_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [Generator] [double] | *ShortTensor* [Generator] [double] | *ShortTensor* [Generator] FloatTensor | *ShortTensor* [Generator] DoubleTensor", type_buf);
}
if(argset == 1)
{
arg3 = THRandom_bernoulli(arg1,arg2);
lua_pushnumber(L, (lua_Number)arg3);
return 1;
}
else if(argset == 2)
{
lua_pushvalue(L, arg4_idx);
THShortTensor_bernoulli(arg4,arg5,arg6);
return 1;
}
else if(argset == 3)
{
lua_pushvalue(L, arg7_idx);
THShortTensor_bernoulli_FloatTensor(arg7,arg8,arg9);
return 1;
}
else if(argset == 4)
{
lua_pushvalue(L, arg10_idx);
THShortTensor_bernoulli_DoubleTensor(arg10,arg11,arg12);
return 1;
}
return 0;
}

static int torch_ShortTensor_squeeze(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THShortTensor *arg2 = NULL;
THShortTensor *arg3 = NULL;
int arg3_idx = 0;
THShortTensor *arg4 = NULL;
long arg5 = 0;
if(narg == 1
&& (arg2 = luaT_toudata(L, 1, "torch.ShortTensor"))
)
{
argset = 1;
arg1 = THShortTensor_new();
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
)
{
argset = 1;
arg1_idx = 1;
}
else if(narg == 2
&& (arg4 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 2;
arg5 = (long)lua_tonumber(L, 2)-1;
arg3 = THShortTensor_new();
}
else if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg4 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg3_idx = 1;
arg5 = (long)lua_tonumber(L, 3)-1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ShortTensor*] ShortTensor | [*ShortTensor*] ShortTensor index", type_buf);
}
if(argset == 1)
{
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ShortTensor");
THShortTensor_squeeze(arg1,arg2);
if(arg1->nDimension == 1 && arg1->size[0] == 1)
lua_pushnumber(L, (lua_Number)(*THShortTensor_data(arg1)));
return 1;
}
else if(argset == 2)
{
if(arg3_idx)
lua_pushvalue(L, arg3_idx);
else
luaT_pushudata(L, arg3, "torch.ShortTensor");
{int hasdims = arg4->nDimension > 1;
THShortTensor_squeeze1d(arg3,arg4,arg5);
if(!hasdims && arg3->nDimension == 1 && arg3->size[0] == 1)
lua_pushnumber(L, (lua_Number)(*THShortTensor_data(arg3)));}
return 1;
}
return 0;
}

static int torch_ShortTensor_sign(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THShortTensor *arg2 = NULL;
if(narg == 1
&& (arg2 = luaT_toudata(L, 1, "torch.ShortTensor"))
)
{
arg1 = THShortTensor_new();
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
)
{
arg1_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ShortTensor*] ShortTensor", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ShortTensor");
THShortTensor_sign(arg1,arg2);
return 1;
}

static int torch_ShortTensor_conv2(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
short arg2 = 0;
short arg3 = 1;
THShortTensor *arg4 = NULL;
THShortTensor *arg5 = NULL;
short arg6 = 1;
short arg7 = 1;
const char *arg8 = NULL;
char arg8_default = 'V';
const char *arg9 = NULL;
char arg9_default = 'C';
THShortTensor *arg10 = NULL;
int arg10_idx = 0;
short arg11 = 0;
short arg12 = 1;
THShortTensor *arg13 = NULL;
THShortTensor *arg14 = NULL;
short arg15 = 1;
short arg16 = 1;
const char *arg17 = NULL;
char arg17_default = 'V';
const char *arg18 = NULL;
char arg18_default = 'C';
THShortTensor *arg19 = NULL;
int arg19_idx = 0;
short arg20 = 0;
short arg21 = 1;
THShortTensor *arg22 = NULL;
THShortTensor *arg23 = NULL;
short arg24 = 1;
short arg25 = 1;
const char *arg26 = NULL;
char arg26_default = 'V';
const char *arg27 = NULL;
char arg27_default = 'C';
if(narg == 2
&& (arg4 = luaT_toudata(L, 1, "torch.ShortTensor")) && (arg4->nDimension == 2)
&& (arg5 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg5->nDimension == 2)
)
{
argset = 1;
arg1 = THShortTensor_new();
arg8 = &arg8_default;
arg9 = &arg9_default;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg4 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg4->nDimension == 2)
&& (arg5 = luaT_toudata(L, 3, "torch.ShortTensor")) && (arg5->nDimension == 2)
)
{
argset = 1;
arg1_idx = 1;
arg8 = &arg8_default;
arg9 = &arg9_default;
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.ShortTensor")) && (arg4->nDimension == 2)
&& (arg5 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg5->nDimension == 2)
&& (arg8 = lua_tostring(L, 3)) && (*arg8 == 'V' || *arg8 == 'F')
)
{
argset = 1;
arg1 = THShortTensor_new();
arg9 = &arg9_default;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg4 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg4->nDimension == 2)
&& (arg5 = luaT_toudata(L, 3, "torch.ShortTensor")) && (arg5->nDimension == 2)
&& (arg8 = lua_tostring(L, 4)) && (*arg8 == 'V' || *arg8 == 'F')
)
{
argset = 1;
arg1_idx = 1;
arg9 = &arg9_default;
}
else if(narg == 2
&& (arg13 = luaT_toudata(L, 1, "torch.ShortTensor")) && (arg13->nDimension == 3)
&& (arg14 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg14->nDimension == 3)
)
{
argset = 2;
arg10 = THShortTensor_new();
arg17 = &arg17_default;
arg18 = &arg18_default;
}
else if(narg == 3
&& (arg10 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg13 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg13->nDimension == 3)
&& (arg14 = luaT_toudata(L, 3, "torch.ShortTensor")) && (arg14->nDimension == 3)
)
{
argset = 2;
arg10_idx = 1;
arg17 = &arg17_default;
arg18 = &arg18_default;
}
else if(narg == 3
&& (arg13 = luaT_toudata(L, 1, "torch.ShortTensor")) && (arg13->nDimension == 3)
&& (arg14 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg14->nDimension == 3)
&& (arg17 = lua_tostring(L, 3)) && (*arg17 == 'V' || *arg17 == 'F')
)
{
argset = 2;
arg10 = THShortTensor_new();
arg18 = &arg18_default;
}
else if(narg == 4
&& (arg10 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg13 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg13->nDimension == 3)
&& (arg14 = luaT_toudata(L, 3, "torch.ShortTensor")) && (arg14->nDimension == 3)
&& (arg17 = lua_tostring(L, 4)) && (*arg17 == 'V' || *arg17 == 'F')
)
{
argset = 2;
arg10_idx = 1;
arg18 = &arg18_default;
}
else if(narg == 2
&& (arg22 = luaT_toudata(L, 1, "torch.ShortTensor")) && (arg22->nDimension == 3)
&& (arg23 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg23->nDimension == 4)
)
{
argset = 3;
arg19 = THShortTensor_new();
arg26 = &arg26_default;
arg27 = &arg27_default;
}
else if(narg == 3
&& (arg19 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg22 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg22->nDimension == 3)
&& (arg23 = luaT_toudata(L, 3, "torch.ShortTensor")) && (arg23->nDimension == 4)
)
{
argset = 3;
arg19_idx = 1;
arg26 = &arg26_default;
arg27 = &arg27_default;
}
else if(narg == 3
&& (arg22 = luaT_toudata(L, 1, "torch.ShortTensor")) && (arg22->nDimension == 3)
&& (arg23 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg23->nDimension == 4)
&& (arg26 = lua_tostring(L, 3)) && (*arg26 == 'V' || *arg26 == 'F')
)
{
argset = 3;
arg19 = THShortTensor_new();
arg27 = &arg27_default;
}
else if(narg == 4
&& (arg19 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg22 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg22->nDimension == 3)
&& (arg23 = luaT_toudata(L, 3, "torch.ShortTensor")) && (arg23->nDimension == 4)
&& (arg26 = lua_tostring(L, 4)) && (*arg26 == 'V' || *arg26 == 'F')
)
{
argset = 3;
arg19_idx = 1;
arg27 = &arg27_default;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ShortTensor*] ShortTensor~2D ShortTensor~2D [(V|F)] | [*ShortTensor*] ShortTensor~3D ShortTensor~3D [(V|F)] | [*ShortTensor*] ShortTensor~3D ShortTensor~4D [(V|F)]", type_buf);
}
if(argset == 1)
{
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ShortTensor");
THShortTensor_conv2Dmul(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9);
return 1;
}
else if(argset == 2)
{
if(arg10_idx)
lua_pushvalue(L, arg10_idx);
else
luaT_pushudata(L, arg10, "torch.ShortTensor");
THShortTensor_conv2Dcmul(arg10,arg11,arg12,arg13,arg14,arg15,arg16,arg17,arg18);
return 1;
}
else if(argset == 3)
{
if(arg19_idx)
lua_pushvalue(L, arg19_idx);
else
luaT_pushudata(L, arg19, "torch.ShortTensor");
THShortTensor_conv2Dmv(arg19,arg20,arg21,arg22,arg23,arg24,arg25,arg26,arg27);
return 1;
}
return 0;
}

static int torch_ShortTensor_xcorr2(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
short arg2 = 0;
short arg3 = 1;
THShortTensor *arg4 = NULL;
THShortTensor *arg5 = NULL;
short arg6 = 1;
short arg7 = 1;
const char *arg8 = NULL;
char arg8_default = 'V';
const char *arg9 = NULL;
char arg9_default = 'X';
THShortTensor *arg10 = NULL;
int arg10_idx = 0;
short arg11 = 0;
short arg12 = 1;
THShortTensor *arg13 = NULL;
THShortTensor *arg14 = NULL;
short arg15 = 1;
short arg16 = 1;
const char *arg17 = NULL;
char arg17_default = 'V';
const char *arg18 = NULL;
char arg18_default = 'X';
THShortTensor *arg19 = NULL;
int arg19_idx = 0;
short arg20 = 0;
short arg21 = 1;
THShortTensor *arg22 = NULL;
THShortTensor *arg23 = NULL;
short arg24 = 1;
short arg25 = 1;
const char *arg26 = NULL;
char arg26_default = 'V';
const char *arg27 = NULL;
char arg27_default = 'X';
if(narg == 2
&& (arg4 = luaT_toudata(L, 1, "torch.ShortTensor")) && (arg4->nDimension == 2)
&& (arg5 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg5->nDimension == 2)
)
{
argset = 1;
arg1 = THShortTensor_new();
arg8 = &arg8_default;
arg9 = &arg9_default;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg4 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg4->nDimension == 2)
&& (arg5 = luaT_toudata(L, 3, "torch.ShortTensor")) && (arg5->nDimension == 2)
)
{
argset = 1;
arg1_idx = 1;
arg8 = &arg8_default;
arg9 = &arg9_default;
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.ShortTensor")) && (arg4->nDimension == 2)
&& (arg5 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg5->nDimension == 2)
&& (arg8 = lua_tostring(L, 3)) && (*arg8 == 'V' || *arg8 == 'F')
)
{
argset = 1;
arg1 = THShortTensor_new();
arg9 = &arg9_default;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg4 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg4->nDimension == 2)
&& (arg5 = luaT_toudata(L, 3, "torch.ShortTensor")) && (arg5->nDimension == 2)
&& (arg8 = lua_tostring(L, 4)) && (*arg8 == 'V' || *arg8 == 'F')
)
{
argset = 1;
arg1_idx = 1;
arg9 = &arg9_default;
}
else if(narg == 2
&& (arg13 = luaT_toudata(L, 1, "torch.ShortTensor")) && (arg13->nDimension == 3)
&& (arg14 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg14->nDimension == 3)
)
{
argset = 2;
arg10 = THShortTensor_new();
arg17 = &arg17_default;
arg18 = &arg18_default;
}
else if(narg == 3
&& (arg10 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg13 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg13->nDimension == 3)
&& (arg14 = luaT_toudata(L, 3, "torch.ShortTensor")) && (arg14->nDimension == 3)
)
{
argset = 2;
arg10_idx = 1;
arg17 = &arg17_default;
arg18 = &arg18_default;
}
else if(narg == 3
&& (arg13 = luaT_toudata(L, 1, "torch.ShortTensor")) && (arg13->nDimension == 3)
&& (arg14 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg14->nDimension == 3)
&& (arg17 = lua_tostring(L, 3)) && (*arg17 == 'V' || *arg17 == 'F')
)
{
argset = 2;
arg10 = THShortTensor_new();
arg18 = &arg18_default;
}
else if(narg == 4
&& (arg10 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg13 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg13->nDimension == 3)
&& (arg14 = luaT_toudata(L, 3, "torch.ShortTensor")) && (arg14->nDimension == 3)
&& (arg17 = lua_tostring(L, 4)) && (*arg17 == 'V' || *arg17 == 'F')
)
{
argset = 2;
arg10_idx = 1;
arg18 = &arg18_default;
}
else if(narg == 2
&& (arg22 = luaT_toudata(L, 1, "torch.ShortTensor")) && (arg22->nDimension == 3)
&& (arg23 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg23->nDimension == 4)
)
{
argset = 3;
arg19 = THShortTensor_new();
arg26 = &arg26_default;
arg27 = &arg27_default;
}
else if(narg == 3
&& (arg19 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg22 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg22->nDimension == 3)
&& (arg23 = luaT_toudata(L, 3, "torch.ShortTensor")) && (arg23->nDimension == 4)
)
{
argset = 3;
arg19_idx = 1;
arg26 = &arg26_default;
arg27 = &arg27_default;
}
else if(narg == 3
&& (arg22 = luaT_toudata(L, 1, "torch.ShortTensor")) && (arg22->nDimension == 3)
&& (arg23 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg23->nDimension == 4)
&& (arg26 = lua_tostring(L, 3)) && (*arg26 == 'V' || *arg26 == 'F')
)
{
argset = 3;
arg19 = THShortTensor_new();
arg27 = &arg27_default;
}
else if(narg == 4
&& (arg19 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg22 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg22->nDimension == 3)
&& (arg23 = luaT_toudata(L, 3, "torch.ShortTensor")) && (arg23->nDimension == 4)
&& (arg26 = lua_tostring(L, 4)) && (*arg26 == 'V' || *arg26 == 'F')
)
{
argset = 3;
arg19_idx = 1;
arg27 = &arg27_default;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ShortTensor*] ShortTensor~2D ShortTensor~2D [(V|F)] | [*ShortTensor*] ShortTensor~3D ShortTensor~3D [(V|F)] | [*ShortTensor*] ShortTensor~3D ShortTensor~4D [(V|F)]", type_buf);
}
if(argset == 1)
{
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ShortTensor");
THShortTensor_conv2Dmul(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9);
return 1;
}
else if(argset == 2)
{
if(arg10_idx)
lua_pushvalue(L, arg10_idx);
else
luaT_pushudata(L, arg10, "torch.ShortTensor");
THShortTensor_conv2Dcmul(arg10,arg11,arg12,arg13,arg14,arg15,arg16,arg17,arg18);
return 1;
}
else if(argset == 3)
{
if(arg19_idx)
lua_pushvalue(L, arg19_idx);
else
luaT_pushudata(L, arg19, "torch.ShortTensor");
THShortTensor_conv2Dmv(arg19,arg20,arg21,arg22,arg23,arg24,arg25,arg26,arg27);
return 1;
}
return 0;
}

static int torch_ShortTensor_conv3(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
short arg2 = 0;
short arg3 = 1;
THShortTensor *arg4 = NULL;
THShortTensor *arg5 = NULL;
short arg6 = 1;
short arg7 = 1;
short arg8 = 1;
const char *arg9 = NULL;
char arg9_default = 'V';
const char *arg10 = NULL;
char arg10_default = 'C';
THShortTensor *arg11 = NULL;
int arg11_idx = 0;
short arg12 = 0;
short arg13 = 1;
THShortTensor *arg14 = NULL;
THShortTensor *arg15 = NULL;
short arg16 = 1;
short arg17 = 1;
short arg18 = 1;
const char *arg19 = NULL;
char arg19_default = 'V';
const char *arg20 = NULL;
char arg20_default = 'C';
THShortTensor *arg21 = NULL;
int arg21_idx = 0;
short arg22 = 0;
short arg23 = 1;
THShortTensor *arg24 = NULL;
THShortTensor *arg25 = NULL;
short arg26 = 1;
short arg27 = 1;
short arg28 = 1;
const char *arg29 = NULL;
char arg29_default = 'V';
const char *arg30 = NULL;
char arg30_default = 'C';
if(narg == 2
&& (arg4 = luaT_toudata(L, 1, "torch.ShortTensor")) && (arg4->nDimension == 3)
&& (arg5 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg5->nDimension == 3)
)
{
argset = 1;
arg1 = THShortTensor_new();
arg9 = &arg9_default;
arg10 = &arg10_default;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg4 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg4->nDimension == 3)
&& (arg5 = luaT_toudata(L, 3, "torch.ShortTensor")) && (arg5->nDimension == 3)
)
{
argset = 1;
arg1_idx = 1;
arg9 = &arg9_default;
arg10 = &arg10_default;
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.ShortTensor")) && (arg4->nDimension == 3)
&& (arg5 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg5->nDimension == 3)
&& (arg9 = lua_tostring(L, 3)) && (*arg9 == 'V' || *arg9 == 'F')
)
{
argset = 1;
arg1 = THShortTensor_new();
arg10 = &arg10_default;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg4 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg4->nDimension == 3)
&& (arg5 = luaT_toudata(L, 3, "torch.ShortTensor")) && (arg5->nDimension == 3)
&& (arg9 = lua_tostring(L, 4)) && (*arg9 == 'V' || *arg9 == 'F')
)
{
argset = 1;
arg1_idx = 1;
arg10 = &arg10_default;
}
else if(narg == 2
&& (arg14 = luaT_toudata(L, 1, "torch.ShortTensor")) && (arg14->nDimension == 4)
&& (arg15 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg15->nDimension == 4)
)
{
argset = 2;
arg11 = THShortTensor_new();
arg19 = &arg19_default;
arg20 = &arg20_default;
}
else if(narg == 3
&& (arg11 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg14 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg14->nDimension == 4)
&& (arg15 = luaT_toudata(L, 3, "torch.ShortTensor")) && (arg15->nDimension == 4)
)
{
argset = 2;
arg11_idx = 1;
arg19 = &arg19_default;
arg20 = &arg20_default;
}
else if(narg == 3
&& (arg14 = luaT_toudata(L, 1, "torch.ShortTensor")) && (arg14->nDimension == 4)
&& (arg15 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg15->nDimension == 4)
&& (arg19 = lua_tostring(L, 3)) && (*arg19 == 'V' || *arg19 == 'F')
)
{
argset = 2;
arg11 = THShortTensor_new();
arg20 = &arg20_default;
}
else if(narg == 4
&& (arg11 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg14 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg14->nDimension == 4)
&& (arg15 = luaT_toudata(L, 3, "torch.ShortTensor")) && (arg15->nDimension == 4)
&& (arg19 = lua_tostring(L, 4)) && (*arg19 == 'V' || *arg19 == 'F')
)
{
argset = 2;
arg11_idx = 1;
arg20 = &arg20_default;
}
else if(narg == 2
&& (arg24 = luaT_toudata(L, 1, "torch.ShortTensor")) && (arg24->nDimension == 4)
&& (arg25 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg25->nDimension == 5)
)
{
argset = 3;
arg21 = THShortTensor_new();
arg29 = &arg29_default;
arg30 = &arg30_default;
}
else if(narg == 3
&& (arg21 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg24 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg24->nDimension == 4)
&& (arg25 = luaT_toudata(L, 3, "torch.ShortTensor")) && (arg25->nDimension == 5)
)
{
argset = 3;
arg21_idx = 1;
arg29 = &arg29_default;
arg30 = &arg30_default;
}
else if(narg == 3
&& (arg24 = luaT_toudata(L, 1, "torch.ShortTensor")) && (arg24->nDimension == 4)
&& (arg25 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg25->nDimension == 5)
&& (arg29 = lua_tostring(L, 3)) && (*arg29 == 'V' || *arg29 == 'F')
)
{
argset = 3;
arg21 = THShortTensor_new();
arg30 = &arg30_default;
}
else if(narg == 4
&& (arg21 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg24 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg24->nDimension == 4)
&& (arg25 = luaT_toudata(L, 3, "torch.ShortTensor")) && (arg25->nDimension == 5)
&& (arg29 = lua_tostring(L, 4)) && (*arg29 == 'V' || *arg29 == 'F')
)
{
argset = 3;
arg21_idx = 1;
arg30 = &arg30_default;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ShortTensor*] ShortTensor~3D ShortTensor~3D [(V|F)] | [*ShortTensor*] ShortTensor~4D ShortTensor~4D [(V|F)] | [*ShortTensor*] ShortTensor~4D ShortTensor~5D [(V|F)]", type_buf);
}
if(argset == 1)
{
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ShortTensor");
THShortTensor_conv3Dmul(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10);
return 1;
}
else if(argset == 2)
{
if(arg11_idx)
lua_pushvalue(L, arg11_idx);
else
luaT_pushudata(L, arg11, "torch.ShortTensor");
THShortTensor_conv3Dcmul(arg11,arg12,arg13,arg14,arg15,arg16,arg17,arg18,arg19,arg20);
return 1;
}
else if(argset == 3)
{
if(arg21_idx)
lua_pushvalue(L, arg21_idx);
else
luaT_pushudata(L, arg21, "torch.ShortTensor");
THShortTensor_conv3Dmv(arg21,arg22,arg23,arg24,arg25,arg26,arg27,arg28,arg29,arg30);
return 1;
}
return 0;
}

static int torch_ShortTensor_xcorr3(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
short arg2 = 0;
short arg3 = 1;
THShortTensor *arg4 = NULL;
THShortTensor *arg5 = NULL;
short arg6 = 1;
short arg7 = 1;
short arg8 = 1;
const char *arg9 = NULL;
char arg9_default = 'V';
const char *arg10 = NULL;
char arg10_default = 'X';
THShortTensor *arg11 = NULL;
int arg11_idx = 0;
short arg12 = 0;
short arg13 = 1;
THShortTensor *arg14 = NULL;
THShortTensor *arg15 = NULL;
short arg16 = 1;
short arg17 = 1;
short arg18 = 1;
const char *arg19 = NULL;
char arg19_default = 'V';
const char *arg20 = NULL;
char arg20_default = 'X';
THShortTensor *arg21 = NULL;
int arg21_idx = 0;
short arg22 = 0;
short arg23 = 1;
THShortTensor *arg24 = NULL;
THShortTensor *arg25 = NULL;
short arg26 = 1;
short arg27 = 1;
short arg28 = 1;
const char *arg29 = NULL;
char arg29_default = 'V';
const char *arg30 = NULL;
char arg30_default = 'X';
if(narg == 2
&& (arg4 = luaT_toudata(L, 1, "torch.ShortTensor")) && (arg4->nDimension == 3)
&& (arg5 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg5->nDimension == 3)
)
{
argset = 1;
arg1 = THShortTensor_new();
arg9 = &arg9_default;
arg10 = &arg10_default;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg4 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg4->nDimension == 3)
&& (arg5 = luaT_toudata(L, 3, "torch.ShortTensor")) && (arg5->nDimension == 3)
)
{
argset = 1;
arg1_idx = 1;
arg9 = &arg9_default;
arg10 = &arg10_default;
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.ShortTensor")) && (arg4->nDimension == 3)
&& (arg5 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg5->nDimension == 3)
&& (arg9 = lua_tostring(L, 3)) && (*arg9 == 'V' || *arg9 == 'F')
)
{
argset = 1;
arg1 = THShortTensor_new();
arg10 = &arg10_default;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg4 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg4->nDimension == 3)
&& (arg5 = luaT_toudata(L, 3, "torch.ShortTensor")) && (arg5->nDimension == 3)
&& (arg9 = lua_tostring(L, 4)) && (*arg9 == 'V' || *arg9 == 'F')
)
{
argset = 1;
arg1_idx = 1;
arg10 = &arg10_default;
}
else if(narg == 2
&& (arg14 = luaT_toudata(L, 1, "torch.ShortTensor")) && (arg14->nDimension == 4)
&& (arg15 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg15->nDimension == 4)
)
{
argset = 2;
arg11 = THShortTensor_new();
arg19 = &arg19_default;
arg20 = &arg20_default;
}
else if(narg == 3
&& (arg11 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg14 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg14->nDimension == 4)
&& (arg15 = luaT_toudata(L, 3, "torch.ShortTensor")) && (arg15->nDimension == 4)
)
{
argset = 2;
arg11_idx = 1;
arg19 = &arg19_default;
arg20 = &arg20_default;
}
else if(narg == 3
&& (arg14 = luaT_toudata(L, 1, "torch.ShortTensor")) && (arg14->nDimension == 4)
&& (arg15 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg15->nDimension == 4)
&& (arg19 = lua_tostring(L, 3)) && (*arg19 == 'V' || *arg19 == 'F')
)
{
argset = 2;
arg11 = THShortTensor_new();
arg20 = &arg20_default;
}
else if(narg == 4
&& (arg11 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg14 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg14->nDimension == 4)
&& (arg15 = luaT_toudata(L, 3, "torch.ShortTensor")) && (arg15->nDimension == 4)
&& (arg19 = lua_tostring(L, 4)) && (*arg19 == 'V' || *arg19 == 'F')
)
{
argset = 2;
arg11_idx = 1;
arg20 = &arg20_default;
}
else if(narg == 2
&& (arg24 = luaT_toudata(L, 1, "torch.ShortTensor")) && (arg24->nDimension == 4)
&& (arg25 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg25->nDimension == 5)
)
{
argset = 3;
arg21 = THShortTensor_new();
arg29 = &arg29_default;
arg30 = &arg30_default;
}
else if(narg == 3
&& (arg21 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg24 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg24->nDimension == 4)
&& (arg25 = luaT_toudata(L, 3, "torch.ShortTensor")) && (arg25->nDimension == 5)
)
{
argset = 3;
arg21_idx = 1;
arg29 = &arg29_default;
arg30 = &arg30_default;
}
else if(narg == 3
&& (arg24 = luaT_toudata(L, 1, "torch.ShortTensor")) && (arg24->nDimension == 4)
&& (arg25 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg25->nDimension == 5)
&& (arg29 = lua_tostring(L, 3)) && (*arg29 == 'V' || *arg29 == 'F')
)
{
argset = 3;
arg21 = THShortTensor_new();
arg30 = &arg30_default;
}
else if(narg == 4
&& (arg21 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg24 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg24->nDimension == 4)
&& (arg25 = luaT_toudata(L, 3, "torch.ShortTensor")) && (arg25->nDimension == 5)
&& (arg29 = lua_tostring(L, 4)) && (*arg29 == 'V' || *arg29 == 'F')
)
{
argset = 3;
arg21_idx = 1;
arg30 = &arg30_default;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ShortTensor*] ShortTensor~3D ShortTensor~3D [(V|F)] | [*ShortTensor*] ShortTensor~4D ShortTensor~4D [(V|F)] | [*ShortTensor*] ShortTensor~4D ShortTensor~5D [(V|F)]", type_buf);
}
if(argset == 1)
{
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ShortTensor");
THShortTensor_conv3Dmul(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10);
return 1;
}
else if(argset == 2)
{
if(arg11_idx)
lua_pushvalue(L, arg11_idx);
else
luaT_pushudata(L, arg11, "torch.ShortTensor");
THShortTensor_conv3Dcmul(arg11,arg12,arg13,arg14,arg15,arg16,arg17,arg18,arg19,arg20);
return 1;
}
else if(argset == 3)
{
if(arg21_idx)
lua_pushvalue(L, arg21_idx);
else
luaT_pushudata(L, arg21, "torch.ShortTensor");
THShortTensor_conv3Dmv(arg21,arg22,arg23,arg24,arg25,arg26,arg27,arg28,arg29,arg30);
return 1;
}
return 0;
}

static int torch_ShortTensor_lt(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THShortTensor *arg2 = NULL;
short arg3 = 0;
THShortTensor *arg4 = NULL;
int arg4_idx = 0;
THShortTensor *arg5 = NULL;
short arg6 = 0;
THByteTensor *arg7 = NULL;
int arg7_idx = 0;
THShortTensor *arg8 = NULL;
THShortTensor *arg9 = NULL;
THShortTensor *arg10 = NULL;
int arg10_idx = 0;
THShortTensor *arg11 = NULL;
THShortTensor *arg12 = NULL;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 1;
arg3 = (short)lua_tonumber(L, 2);
arg1 = THByteTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 1;
arg1_idx = 1;
arg3 = (short)lua_tonumber(L, 3);
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg4_idx = 1;
arg6 = (short)lua_tonumber(L, 3);
}
else if(narg == 2
&& (arg8 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg9 = luaT_toudata(L, 2, "torch.ShortTensor"))
)
{
argset = 3;
arg7 = THByteTensor_new();
}
else if(narg == 3
&& (arg7 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg8 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& (arg9 = luaT_toudata(L, 3, "torch.ShortTensor"))
)
{
argset = 3;
arg7_idx = 1;
}
else if(narg == 3
&& (arg10 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg11 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& (arg12 = luaT_toudata(L, 3, "torch.ShortTensor"))
)
{
argset = 4;
arg10_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] ShortTensor short | *ShortTensor* ShortTensor short | [*ByteTensor*] ShortTensor ShortTensor | *ShortTensor* ShortTensor ShortTensor", type_buf);
}
if(argset == 1)
{
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THShortTensor_ltValue(arg1,arg2,arg3);
return 1;
}
else if(argset == 2)
{
lua_pushvalue(L, arg4_idx);
THShortTensor_ltValueT(arg4,arg5,arg6);
return 1;
}
else if(argset == 3)
{
if(arg7_idx)
lua_pushvalue(L, arg7_idx);
else
luaT_pushudata(L, arg7, "torch.ByteTensor");
THShortTensor_ltTensor(arg7,arg8,arg9);
return 1;
}
else if(argset == 4)
{
lua_pushvalue(L, arg10_idx);
THShortTensor_ltTensorT(arg10,arg11,arg12);
return 1;
}
return 0;
}

static int torch_ShortTensor_gt(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THShortTensor *arg2 = NULL;
short arg3 = 0;
THShortTensor *arg4 = NULL;
int arg4_idx = 0;
THShortTensor *arg5 = NULL;
short arg6 = 0;
THByteTensor *arg7 = NULL;
int arg7_idx = 0;
THShortTensor *arg8 = NULL;
THShortTensor *arg9 = NULL;
THShortTensor *arg10 = NULL;
int arg10_idx = 0;
THShortTensor *arg11 = NULL;
THShortTensor *arg12 = NULL;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 1;
arg3 = (short)lua_tonumber(L, 2);
arg1 = THByteTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 1;
arg1_idx = 1;
arg3 = (short)lua_tonumber(L, 3);
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg4_idx = 1;
arg6 = (short)lua_tonumber(L, 3);
}
else if(narg == 2
&& (arg8 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg9 = luaT_toudata(L, 2, "torch.ShortTensor"))
)
{
argset = 3;
arg7 = THByteTensor_new();
}
else if(narg == 3
&& (arg7 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg8 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& (arg9 = luaT_toudata(L, 3, "torch.ShortTensor"))
)
{
argset = 3;
arg7_idx = 1;
}
else if(narg == 3
&& (arg10 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg11 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& (arg12 = luaT_toudata(L, 3, "torch.ShortTensor"))
)
{
argset = 4;
arg10_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] ShortTensor short | *ShortTensor* ShortTensor short | [*ByteTensor*] ShortTensor ShortTensor | *ShortTensor* ShortTensor ShortTensor", type_buf);
}
if(argset == 1)
{
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THShortTensor_gtValue(arg1,arg2,arg3);
return 1;
}
else if(argset == 2)
{
lua_pushvalue(L, arg4_idx);
THShortTensor_gtValueT(arg4,arg5,arg6);
return 1;
}
else if(argset == 3)
{
if(arg7_idx)
lua_pushvalue(L, arg7_idx);
else
luaT_pushudata(L, arg7, "torch.ByteTensor");
THShortTensor_gtTensor(arg7,arg8,arg9);
return 1;
}
else if(argset == 4)
{
lua_pushvalue(L, arg10_idx);
THShortTensor_gtTensorT(arg10,arg11,arg12);
return 1;
}
return 0;
}

static int torch_ShortTensor_le(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THShortTensor *arg2 = NULL;
short arg3 = 0;
THShortTensor *arg4 = NULL;
int arg4_idx = 0;
THShortTensor *arg5 = NULL;
short arg6 = 0;
THByteTensor *arg7 = NULL;
int arg7_idx = 0;
THShortTensor *arg8 = NULL;
THShortTensor *arg9 = NULL;
THShortTensor *arg10 = NULL;
int arg10_idx = 0;
THShortTensor *arg11 = NULL;
THShortTensor *arg12 = NULL;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 1;
arg3 = (short)lua_tonumber(L, 2);
arg1 = THByteTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 1;
arg1_idx = 1;
arg3 = (short)lua_tonumber(L, 3);
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg4_idx = 1;
arg6 = (short)lua_tonumber(L, 3);
}
else if(narg == 2
&& (arg8 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg9 = luaT_toudata(L, 2, "torch.ShortTensor"))
)
{
argset = 3;
arg7 = THByteTensor_new();
}
else if(narg == 3
&& (arg7 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg8 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& (arg9 = luaT_toudata(L, 3, "torch.ShortTensor"))
)
{
argset = 3;
arg7_idx = 1;
}
else if(narg == 3
&& (arg10 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg11 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& (arg12 = luaT_toudata(L, 3, "torch.ShortTensor"))
)
{
argset = 4;
arg10_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] ShortTensor short | *ShortTensor* ShortTensor short | [*ByteTensor*] ShortTensor ShortTensor | *ShortTensor* ShortTensor ShortTensor", type_buf);
}
if(argset == 1)
{
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THShortTensor_leValue(arg1,arg2,arg3);
return 1;
}
else if(argset == 2)
{
lua_pushvalue(L, arg4_idx);
THShortTensor_leValueT(arg4,arg5,arg6);
return 1;
}
else if(argset == 3)
{
if(arg7_idx)
lua_pushvalue(L, arg7_idx);
else
luaT_pushudata(L, arg7, "torch.ByteTensor");
THShortTensor_leTensor(arg7,arg8,arg9);
return 1;
}
else if(argset == 4)
{
lua_pushvalue(L, arg10_idx);
THShortTensor_leTensorT(arg10,arg11,arg12);
return 1;
}
return 0;
}

static int torch_ShortTensor_ge(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THShortTensor *arg2 = NULL;
short arg3 = 0;
THShortTensor *arg4 = NULL;
int arg4_idx = 0;
THShortTensor *arg5 = NULL;
short arg6 = 0;
THByteTensor *arg7 = NULL;
int arg7_idx = 0;
THShortTensor *arg8 = NULL;
THShortTensor *arg9 = NULL;
THShortTensor *arg10 = NULL;
int arg10_idx = 0;
THShortTensor *arg11 = NULL;
THShortTensor *arg12 = NULL;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 1;
arg3 = (short)lua_tonumber(L, 2);
arg1 = THByteTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 1;
arg1_idx = 1;
arg3 = (short)lua_tonumber(L, 3);
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg4_idx = 1;
arg6 = (short)lua_tonumber(L, 3);
}
else if(narg == 2
&& (arg8 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg9 = luaT_toudata(L, 2, "torch.ShortTensor"))
)
{
argset = 3;
arg7 = THByteTensor_new();
}
else if(narg == 3
&& (arg7 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg8 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& (arg9 = luaT_toudata(L, 3, "torch.ShortTensor"))
)
{
argset = 3;
arg7_idx = 1;
}
else if(narg == 3
&& (arg10 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg11 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& (arg12 = luaT_toudata(L, 3, "torch.ShortTensor"))
)
{
argset = 4;
arg10_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] ShortTensor short | *ShortTensor* ShortTensor short | [*ByteTensor*] ShortTensor ShortTensor | *ShortTensor* ShortTensor ShortTensor", type_buf);
}
if(argset == 1)
{
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THShortTensor_geValue(arg1,arg2,arg3);
return 1;
}
else if(argset == 2)
{
lua_pushvalue(L, arg4_idx);
THShortTensor_geValueT(arg4,arg5,arg6);
return 1;
}
else if(argset == 3)
{
if(arg7_idx)
lua_pushvalue(L, arg7_idx);
else
luaT_pushudata(L, arg7, "torch.ByteTensor");
THShortTensor_geTensor(arg7,arg8,arg9);
return 1;
}
else if(argset == 4)
{
lua_pushvalue(L, arg10_idx);
THShortTensor_geTensorT(arg10,arg11,arg12);
return 1;
}
return 0;
}

static int torch_ShortTensor_eq(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THShortTensor *arg2 = NULL;
short arg3 = 0;
THShortTensor *arg4 = NULL;
int arg4_idx = 0;
THShortTensor *arg5 = NULL;
short arg6 = 0;
THByteTensor *arg7 = NULL;
int arg7_idx = 0;
THShortTensor *arg8 = NULL;
THShortTensor *arg9 = NULL;
THShortTensor *arg10 = NULL;
int arg10_idx = 0;
THShortTensor *arg11 = NULL;
THShortTensor *arg12 = NULL;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 1;
arg3 = (short)lua_tonumber(L, 2);
arg1 = THByteTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 1;
arg1_idx = 1;
arg3 = (short)lua_tonumber(L, 3);
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg4_idx = 1;
arg6 = (short)lua_tonumber(L, 3);
}
else if(narg == 2
&& (arg8 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg9 = luaT_toudata(L, 2, "torch.ShortTensor"))
)
{
argset = 3;
arg7 = THByteTensor_new();
}
else if(narg == 3
&& (arg7 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg8 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& (arg9 = luaT_toudata(L, 3, "torch.ShortTensor"))
)
{
argset = 3;
arg7_idx = 1;
}
else if(narg == 3
&& (arg10 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg11 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& (arg12 = luaT_toudata(L, 3, "torch.ShortTensor"))
)
{
argset = 4;
arg10_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] ShortTensor short | *ShortTensor* ShortTensor short | [*ByteTensor*] ShortTensor ShortTensor | *ShortTensor* ShortTensor ShortTensor", type_buf);
}
if(argset == 1)
{
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THShortTensor_eqValue(arg1,arg2,arg3);
return 1;
}
else if(argset == 2)
{
lua_pushvalue(L, arg4_idx);
THShortTensor_eqValueT(arg4,arg5,arg6);
return 1;
}
else if(argset == 3)
{
if(arg7_idx)
lua_pushvalue(L, arg7_idx);
else
luaT_pushudata(L, arg7, "torch.ByteTensor");
THShortTensor_eqTensor(arg7,arg8,arg9);
return 1;
}
else if(argset == 4)
{
lua_pushvalue(L, arg10_idx);
THShortTensor_eqTensorT(arg10,arg11,arg12);
return 1;
}
return 0;
}

static int torch_ShortTensor_ne(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THByteTensor *arg1 = NULL;
int arg1_idx = 0;
THShortTensor *arg2 = NULL;
short arg3 = 0;
THShortTensor *arg4 = NULL;
int arg4_idx = 0;
THShortTensor *arg5 = NULL;
short arg6 = 0;
THByteTensor *arg7 = NULL;
int arg7_idx = 0;
THShortTensor *arg8 = NULL;
THShortTensor *arg9 = NULL;
THShortTensor *arg10 = NULL;
int arg10_idx = 0;
THShortTensor *arg11 = NULL;
THShortTensor *arg12 = NULL;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 1;
arg3 = (short)lua_tonumber(L, 2);
arg1 = THByteTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 1;
arg1_idx = 1;
arg3 = (short)lua_tonumber(L, 3);
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg4_idx = 1;
arg6 = (short)lua_tonumber(L, 3);
}
else if(narg == 2
&& (arg8 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg9 = luaT_toudata(L, 2, "torch.ShortTensor"))
)
{
argset = 3;
arg7 = THByteTensor_new();
}
else if(narg == 3
&& (arg7 = luaT_toudata(L, 1, "torch.ByteTensor"))
&& (arg8 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& (arg9 = luaT_toudata(L, 3, "torch.ShortTensor"))
)
{
argset = 3;
arg7_idx = 1;
}
else if(narg == 3
&& (arg10 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg11 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& (arg12 = luaT_toudata(L, 3, "torch.ShortTensor"))
)
{
argset = 4;
arg10_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ByteTensor*] ShortTensor short | *ShortTensor* ShortTensor short | [*ByteTensor*] ShortTensor ShortTensor | *ShortTensor* ShortTensor ShortTensor", type_buf);
}
if(argset == 1)
{
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ByteTensor");
THShortTensor_neValue(arg1,arg2,arg3);
return 1;
}
else if(argset == 2)
{
lua_pushvalue(L, arg4_idx);
THShortTensor_neValueT(arg4,arg5,arg6);
return 1;
}
else if(argset == 3)
{
if(arg7_idx)
lua_pushvalue(L, arg7_idx);
else
luaT_pushudata(L, arg7, "torch.ByteTensor");
THShortTensor_neTensor(arg7,arg8,arg9);
return 1;
}
else if(argset == 4)
{
lua_pushvalue(L, arg10_idx);
THShortTensor_neTensorT(arg10,arg11,arg12);
return 1;
}
return 0;
}

static int torch_ShortTensor_nonzero(lua_State *L)
{
int narg = lua_gettop(L);
THLongTensor *arg1 = NULL;
int arg1_idx = 0;
THShortTensor *arg2 = NULL;
if(narg == 1
&& (arg2 = luaT_toudata(L, 1, "torch.ShortTensor"))
)
{
arg1 = THLongTensor_new();
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
)
{
THLongTensor_add(arg1, arg1, -1);
arg1_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*LongTensor*] ShortTensor", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.LongTensor");
THShortTensor_nonzero(arg1,arg2);
THLongTensor_add(arg1, arg1, 1);
return 1;
}

static int m_torch_ShortTensor_zero(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
if(narg == 1
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
)
{
arg1_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ShortTensor*", type_buf);
}
lua_pushvalue(L, arg1_idx);
THShortTensor_zero(arg1);
return 1;
}

static int m_torch_ShortTensor_fill(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
short arg2 = 0;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
)
{
arg1_idx = 1;
arg2 = (short)lua_tonumber(L, 2);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ShortTensor* short", type_buf);
}
lua_pushvalue(L, arg1_idx);
THShortTensor_fill(arg1,arg2);
return 1;
}

static int m_torch_ShortTensor_zeros(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THLongStorage *arg2 = NULL;
if(narg >= 2
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& torch_islongargs(L, 2)
)
{
arg1_idx = 1;
arg2 = torch_checklongargs(L, 2);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ShortTensor* (LongStorage | dim1 [dim2...])", type_buf);
}
lua_pushvalue(L, arg1_idx);
THShortTensor_zeros(arg1,arg2);
THLongStorage_free(arg2);
return 1;
}

static int m_torch_ShortTensor_ones(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THLongStorage *arg2 = NULL;
if(narg >= 2
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& torch_islongargs(L, 2)
)
{
arg1_idx = 1;
arg2 = torch_checklongargs(L, 2);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ShortTensor* (LongStorage | dim1 [dim2...])", type_buf);
}
lua_pushvalue(L, arg1_idx);
THShortTensor_ones(arg1,arg2);
THLongStorage_free(arg2);
return 1;
}

static int m_torch_ShortTensor_reshape(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THShortTensor *arg2 = NULL;
THLongStorage *arg3 = NULL;
if(narg >= 2
&& (arg2 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& torch_islongargs(L, 2)
)
{
arg3 = torch_checklongargs(L, 2);
arg1 = THShortTensor_new();
}
else if(narg >= 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& torch_islongargs(L, 3)
)
{
arg1_idx = 1;
arg3 = torch_checklongargs(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ShortTensor*] ShortTensor (LongStorage | dim1 [dim2...])", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ShortTensor");
THShortTensor_reshape(arg1,arg2,arg3);
THLongStorage_free(arg3);
return 1;
}

static int m_torch_ShortTensor_gather(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THShortTensor *arg2 = NULL;
long arg3 = 0;
THLongTensor *arg4 = NULL;
if(narg == 3
&& (arg2 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
&& (arg4 = luaT_toudata(L, 3, "torch.LongTensor"))
)
{
arg3 = (long)lua_tonumber(L, 2)-1;
arg1 = THShortTensor_new();
THLongStorage* arg1_size = THLongTensor_newSizeOf(arg4);
THShortTensor_resize(arg1, arg1_size, NULL);
THLongStorage_free(arg1_size);
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
&& (arg4 = luaT_toudata(L, 4, "torch.LongTensor"))
)
{
arg1_idx = 1;
arg3 = (long)lua_tonumber(L, 3)-1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ShortTensor*] ShortTensor index LongTensor", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ShortTensor");
THShortTensor_gather(arg1,arg2,arg3,arg4);
return 1;
}

static int m_torch_ShortTensor_scatter(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
long arg2 = 0;
THLongTensor *arg3 = NULL;
THShortTensor *arg4 = NULL;
THShortTensor *arg5 = NULL;
int arg5_idx = 0;
long arg6 = 0;
THLongTensor *arg7 = NULL;
short arg8 = 0;
if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
&& (arg3 = luaT_toudata(L, 3, "torch.LongTensor"))
&& (arg4 = luaT_toudata(L, 4, "torch.ShortTensor"))
)
{
argset = 1;
arg1_idx = 1;
arg2 = (long)lua_tonumber(L, 2)-1;
}
else if(narg == 4
&& (arg5 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
&& (arg7 = luaT_toudata(L, 3, "torch.LongTensor"))
&& lua_isnumber(L, 4)
)
{
argset = 2;
arg5_idx = 1;
arg6 = (long)lua_tonumber(L, 2)-1;
arg8 = (short)lua_tonumber(L, 4);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ShortTensor* index LongTensor ShortTensor | *ShortTensor* index LongTensor short", type_buf);
}
if(argset == 1)
{
lua_pushvalue(L, arg1_idx);
THShortTensor_scatter(arg1,arg2,arg3,arg4);
return 1;
}
else if(argset == 2)
{
lua_pushvalue(L, arg5_idx);
THShortTensor_scatterFill(arg5,arg6,arg7,arg8);
return 1;
}
return 0;
}

static int m_torch_ShortTensor_dot(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
THShortTensor *arg2 = NULL;
long arg3 = 0;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
)
{
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: ShortTensor ShortTensor", type_buf);
}
arg3 = THShortTensor_dot(arg1,arg2);
lua_pushnumber(L, (lua_Number)arg3);
return 1;
}

static int m_torch_ShortTensor_equal(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
THShortTensor *arg2 = NULL;
int arg3 = 0;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
)
{
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: ShortTensor ShortTensor", type_buf);
}
arg3 = THShortTensor_equal(arg1,arg2);
lua_pushboolean(L, arg3);
return 1;
}

static int m_torch_ShortTensor_add(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THShortTensor *arg2 = NULL;
short arg3 = 0;
THShortTensor *arg4 = NULL;
int arg4_idx = 0;
THShortTensor *arg5 = NULL;
short arg6 = 1;
THShortTensor *arg7 = NULL;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 1;
arg1_idx = 1;
arg3 = (short)lua_tonumber(L, 2);
arg2 = arg1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 1;
arg1_idx = 1;
arg3 = (short)lua_tonumber(L, 3);
}
else if(narg == 2
&& (arg4 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg7 = luaT_toudata(L, 2, "torch.ShortTensor"))
)
{
argset = 2;
arg4_idx = 1;
arg5 = arg4;
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& (arg7 = luaT_toudata(L, 3, "torch.ShortTensor"))
)
{
argset = 2;
arg4_idx = 1;
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
&& (arg7 = luaT_toudata(L, 3, "torch.ShortTensor"))
)
{
argset = 2;
arg4_idx = 1;
arg6 = (short)lua_tonumber(L, 2);
arg5 = arg4;
}
else if(narg == 4
&& (arg4 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
&& (arg7 = luaT_toudata(L, 4, "torch.ShortTensor"))
)
{
argset = 2;
arg4_idx = 1;
arg6 = (short)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ShortTensor* [ShortTensor] short | *ShortTensor* [ShortTensor] [short] ShortTensor", type_buf);
}
if(argset == 1)
{
lua_pushvalue(L, arg1_idx);
THShortTensor_add(arg1,arg2,arg3);
return 1;
}
else if(argset == 2)
{
lua_pushvalue(L, arg4_idx);
THShortTensor_cadd(arg4,arg5,arg6,arg7);
return 1;
}
return 0;
}

static int m_torch_ShortTensor_csub(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THShortTensor *arg2 = NULL;
short arg3 = 0;
THShortTensor *arg4 = NULL;
int arg4_idx = 0;
THShortTensor *arg5 = NULL;
short arg6 = 1;
THShortTensor *arg7 = NULL;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 1;
arg1_idx = 1;
arg3 = (short)lua_tonumber(L, 2);
arg2 = arg1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 1;
arg1_idx = 1;
arg3 = (short)lua_tonumber(L, 3);
}
else if(narg == 2
&& (arg4 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg7 = luaT_toudata(L, 2, "torch.ShortTensor"))
)
{
argset = 2;
arg4_idx = 1;
arg5 = arg4;
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& (arg7 = luaT_toudata(L, 3, "torch.ShortTensor"))
)
{
argset = 2;
arg4_idx = 1;
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
&& (arg7 = luaT_toudata(L, 3, "torch.ShortTensor"))
)
{
argset = 2;
arg4_idx = 1;
arg6 = (short)lua_tonumber(L, 2);
arg5 = arg4;
}
else if(narg == 4
&& (arg4 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
&& (arg7 = luaT_toudata(L, 4, "torch.ShortTensor"))
)
{
argset = 2;
arg4_idx = 1;
arg6 = (short)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ShortTensor* [ShortTensor] short | *ShortTensor* [ShortTensor] [short] ShortTensor", type_buf);
}
if(argset == 1)
{
lua_pushvalue(L, arg1_idx);
THShortTensor_sub(arg1,arg2,arg3);
return 1;
}
else if(argset == 2)
{
lua_pushvalue(L, arg4_idx);
THShortTensor_csub(arg4,arg5,arg6,arg7);
return 1;
}
return 0;
}

static int m_torch_ShortTensor_mul(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THShortTensor *arg2 = NULL;
short arg3 = 0;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
)
{
arg1_idx = 1;
arg3 = (short)lua_tonumber(L, 2);
arg2 = arg1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (short)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ShortTensor* [ShortTensor] short", type_buf);
}
lua_pushvalue(L, arg1_idx);
THShortTensor_mul(arg1,arg2,arg3);
return 1;
}

static int m_torch_ShortTensor_div(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THShortTensor *arg2 = NULL;
short arg3 = 0;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
)
{
arg1_idx = 1;
arg3 = (short)lua_tonumber(L, 2);
arg2 = arg1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (short)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ShortTensor* [ShortTensor] short", type_buf);
}
lua_pushvalue(L, arg1_idx);
THShortTensor_div(arg1,arg2,arg3);
return 1;
}

static int m_torch_ShortTensor_lshift(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THShortTensor *arg2 = NULL;
short arg3 = 0;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
)
{
arg1_idx = 1;
arg3 = (short)lua_tonumber(L, 2);
arg2 = arg1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (short)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ShortTensor* [ShortTensor] short", type_buf);
}
lua_pushvalue(L, arg1_idx);
THShortTensor_lshift(arg1,arg2,arg3);
return 1;
}

static int m_torch_ShortTensor_rshift(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THShortTensor *arg2 = NULL;
short arg3 = 0;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
)
{
arg1_idx = 1;
arg3 = (short)lua_tonumber(L, 2);
arg2 = arg1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (short)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ShortTensor* [ShortTensor] short", type_buf);
}
lua_pushvalue(L, arg1_idx);
THShortTensor_rshift(arg1,arg2,arg3);
return 1;
}

static int m_torch_ShortTensor_fmod(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THShortTensor *arg2 = NULL;
short arg3 = 0;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
)
{
arg1_idx = 1;
arg3 = (short)lua_tonumber(L, 2);
arg2 = arg1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (short)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ShortTensor* [ShortTensor] short", type_buf);
}
lua_pushvalue(L, arg1_idx);
THShortTensor_fmod(arg1,arg2,arg3);
return 1;
}

static int m_torch_ShortTensor_remainder(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THShortTensor *arg2 = NULL;
short arg3 = 0;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
)
{
arg1_idx = 1;
arg3 = (short)lua_tonumber(L, 2);
arg2 = arg1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (short)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ShortTensor* [ShortTensor] short", type_buf);
}
lua_pushvalue(L, arg1_idx);
THShortTensor_remainder(arg1,arg2,arg3);
return 1;
}

static int m_torch_ShortTensor_bitand(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THShortTensor *arg2 = NULL;
short arg3 = 0;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
)
{
arg1_idx = 1;
arg3 = (short)lua_tonumber(L, 2);
arg2 = arg1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (short)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ShortTensor* [ShortTensor] short", type_buf);
}
lua_pushvalue(L, arg1_idx);
THShortTensor_bitand(arg1,arg2,arg3);
return 1;
}

static int m_torch_ShortTensor_bitor(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THShortTensor *arg2 = NULL;
short arg3 = 0;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
)
{
arg1_idx = 1;
arg3 = (short)lua_tonumber(L, 2);
arg2 = arg1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (short)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ShortTensor* [ShortTensor] short", type_buf);
}
lua_pushvalue(L, arg1_idx);
THShortTensor_bitor(arg1,arg2,arg3);
return 1;
}

static int m_torch_ShortTensor_bitxor(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THShortTensor *arg2 = NULL;
short arg3 = 0;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
)
{
arg1_idx = 1;
arg3 = (short)lua_tonumber(L, 2);
arg2 = arg1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (short)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ShortTensor* [ShortTensor] short", type_buf);
}
lua_pushvalue(L, arg1_idx);
THShortTensor_bitxor(arg1,arg2,arg3);
return 1;
}

static int m_torch_ShortTensor_mod(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THShortTensor *arg2 = NULL;
short arg3 = 0;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
)
{
arg1_idx = 1;
arg3 = (short)lua_tonumber(L, 2);
arg2 = arg1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (short)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ShortTensor* [ShortTensor] short", type_buf);
}
lua_pushvalue(L, arg1_idx);
THShortTensor_fmod(arg1,arg2,arg3);
return 1;
}

static int m_torch_ShortTensor_clamp(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THShortTensor *arg2 = NULL;
short arg3 = 0;
short arg4 = 0;
if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (short)lua_tonumber(L, 2);
arg4 = (short)lua_tonumber(L, 3);
arg2 = arg1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
&& lua_isnumber(L, 4)
)
{
arg1_idx = 1;
arg3 = (short)lua_tonumber(L, 3);
arg4 = (short)lua_tonumber(L, 4);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ShortTensor* [ShortTensor] short short", type_buf);
}
lua_pushvalue(L, arg1_idx);
THShortTensor_clamp(arg1,arg2,arg3,arg4);
return 1;
}

static int m_torch_ShortTensor_match(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THShortTensor *arg2 = NULL;
THShortTensor *arg3 = NULL;
short arg4 = 1;
if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor"))
)
{
arg1_idx = 1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor"))
&& lua_isnumber(L, 4)
)
{
arg1_idx = 1;
arg4 = (short)lua_tonumber(L, 4);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ShortTensor* ShortTensor ShortTensor [short]", type_buf);
}
lua_pushvalue(L, arg1_idx);
THShortTensor_match(arg1,arg2,arg3,arg4);
return 1;
}

static int m_torch_ShortTensor_cmul(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THShortTensor *arg2 = NULL;
THShortTensor *arg3 = NULL;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
)
{
arg1_idx = 1;
arg2 = arg1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor"))
)
{
arg1_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ShortTensor* [ShortTensor] ShortTensor", type_buf);
}
lua_pushvalue(L, arg1_idx);
THShortTensor_cmul(arg1,arg2,arg3);
return 1;
}

static int m_torch_ShortTensor_cpow(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THShortTensor *arg2 = NULL;
THShortTensor *arg3 = NULL;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
)
{
arg1_idx = 1;
arg2 = arg1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor"))
)
{
arg1_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ShortTensor* [ShortTensor] ShortTensor", type_buf);
}
lua_pushvalue(L, arg1_idx);
THShortTensor_cpow(arg1,arg2,arg3);
return 1;
}

static int m_torch_ShortTensor_cdiv(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THShortTensor *arg2 = NULL;
THShortTensor *arg3 = NULL;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
)
{
arg1_idx = 1;
arg2 = arg1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor"))
)
{
arg1_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ShortTensor* [ShortTensor] ShortTensor", type_buf);
}
lua_pushvalue(L, arg1_idx);
THShortTensor_cdiv(arg1,arg2,arg3);
return 1;
}

static int m_torch_ShortTensor_clshift(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THShortTensor *arg2 = NULL;
THShortTensor *arg3 = NULL;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
)
{
arg1_idx = 1;
arg2 = arg1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor"))
)
{
arg1_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ShortTensor* [ShortTensor] ShortTensor", type_buf);
}
lua_pushvalue(L, arg1_idx);
THShortTensor_clshift(arg1,arg2,arg3);
return 1;
}

static int m_torch_ShortTensor_crshift(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THShortTensor *arg2 = NULL;
THShortTensor *arg3 = NULL;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
)
{
arg1_idx = 1;
arg2 = arg1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor"))
)
{
arg1_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ShortTensor* [ShortTensor] ShortTensor", type_buf);
}
lua_pushvalue(L, arg1_idx);
THShortTensor_crshift(arg1,arg2,arg3);
return 1;
}

static int m_torch_ShortTensor_cfmod(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THShortTensor *arg2 = NULL;
THShortTensor *arg3 = NULL;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
)
{
arg1_idx = 1;
arg2 = arg1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor"))
)
{
arg1_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ShortTensor* [ShortTensor] ShortTensor", type_buf);
}
lua_pushvalue(L, arg1_idx);
THShortTensor_cfmod(arg1,arg2,arg3);
return 1;
}

static int m_torch_ShortTensor_cremainder(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THShortTensor *arg2 = NULL;
THShortTensor *arg3 = NULL;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
)
{
arg1_idx = 1;
arg2 = arg1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor"))
)
{
arg1_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ShortTensor* [ShortTensor] ShortTensor", type_buf);
}
lua_pushvalue(L, arg1_idx);
THShortTensor_cremainder(arg1,arg2,arg3);
return 1;
}

static int m_torch_ShortTensor_cbitand(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THShortTensor *arg2 = NULL;
THShortTensor *arg3 = NULL;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
)
{
arg1_idx = 1;
arg2 = arg1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor"))
)
{
arg1_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ShortTensor* [ShortTensor] ShortTensor", type_buf);
}
lua_pushvalue(L, arg1_idx);
THShortTensor_cbitand(arg1,arg2,arg3);
return 1;
}

static int m_torch_ShortTensor_cbitor(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THShortTensor *arg2 = NULL;
THShortTensor *arg3 = NULL;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
)
{
arg1_idx = 1;
arg2 = arg1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor"))
)
{
arg1_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ShortTensor* [ShortTensor] ShortTensor", type_buf);
}
lua_pushvalue(L, arg1_idx);
THShortTensor_cbitor(arg1,arg2,arg3);
return 1;
}

static int m_torch_ShortTensor_cbitxor(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THShortTensor *arg2 = NULL;
THShortTensor *arg3 = NULL;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
)
{
arg1_idx = 1;
arg2 = arg1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor"))
)
{
arg1_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ShortTensor* [ShortTensor] ShortTensor", type_buf);
}
lua_pushvalue(L, arg1_idx);
THShortTensor_cbitxor(arg1,arg2,arg3);
return 1;
}

static int m_torch_ShortTensor_cmod(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THShortTensor *arg2 = NULL;
THShortTensor *arg3 = NULL;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
)
{
arg1_idx = 1;
arg2 = arg1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor"))
)
{
arg1_idx = 1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ShortTensor* [ShortTensor] ShortTensor", type_buf);
}
lua_pushvalue(L, arg1_idx);
THShortTensor_cfmod(arg1,arg2,arg3);
return 1;
}

static int m_torch_ShortTensor_addcmul(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THShortTensor *arg2 = NULL;
short arg3 = 1;
THShortTensor *arg4 = NULL;
THShortTensor *arg5 = NULL;
if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg4 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& (arg5 = luaT_toudata(L, 3, "torch.ShortTensor"))
)
{
arg1_idx = 1;
arg2 = arg1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& (arg4 = luaT_toudata(L, 3, "torch.ShortTensor"))
&& (arg5 = luaT_toudata(L, 4, "torch.ShortTensor"))
)
{
arg1_idx = 1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
&& (arg4 = luaT_toudata(L, 3, "torch.ShortTensor"))
&& (arg5 = luaT_toudata(L, 4, "torch.ShortTensor"))
)
{
arg1_idx = 1;
arg3 = (short)lua_tonumber(L, 2);
arg2 = arg1;
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
&& (arg4 = luaT_toudata(L, 4, "torch.ShortTensor"))
&& (arg5 = luaT_toudata(L, 5, "torch.ShortTensor"))
)
{
arg1_idx = 1;
arg3 = (short)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ShortTensor* [ShortTensor] [short] ShortTensor ShortTensor", type_buf);
}
lua_pushvalue(L, arg1_idx);
THShortTensor_addcmul(arg1,arg2,arg3,arg4,arg5);
return 1;
}

static int m_torch_ShortTensor_addcdiv(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THShortTensor *arg2 = NULL;
short arg3 = 1;
THShortTensor *arg4 = NULL;
THShortTensor *arg5 = NULL;
if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg4 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& (arg5 = luaT_toudata(L, 3, "torch.ShortTensor"))
)
{
arg1_idx = 1;
arg2 = arg1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& (arg4 = luaT_toudata(L, 3, "torch.ShortTensor"))
&& (arg5 = luaT_toudata(L, 4, "torch.ShortTensor"))
)
{
arg1_idx = 1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
&& (arg4 = luaT_toudata(L, 3, "torch.ShortTensor"))
&& (arg5 = luaT_toudata(L, 4, "torch.ShortTensor"))
)
{
arg1_idx = 1;
arg3 = (short)lua_tonumber(L, 2);
arg2 = arg1;
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
&& (arg4 = luaT_toudata(L, 4, "torch.ShortTensor"))
&& (arg5 = luaT_toudata(L, 5, "torch.ShortTensor"))
)
{
arg1_idx = 1;
arg3 = (short)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ShortTensor* [ShortTensor] [short] ShortTensor ShortTensor", type_buf);
}
lua_pushvalue(L, arg1_idx);
THShortTensor_addcdiv(arg1,arg2,arg3,arg4,arg5);
return 1;
}

static int m_torch_ShortTensor_mv(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
short arg2 = 0;
THShortTensor *arg3 = NULL;
short arg4 = 1;
THShortTensor *arg5 = NULL;
THShortTensor *arg6 = NULL;
if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 3, "torch.ShortTensor")) && (arg6->nDimension == 1)
)
{
arg1_idx = 1;
arg3 = arg1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ShortTensor* ShortTensor~2D ShortTensor~1D", type_buf);
}
THShortTensor_zero(arg1);
lua_pushvalue(L, arg1_idx);
THShortTensor_addmv(arg1,arg2,arg3,arg4,arg5,arg6);
return 1;
}

static int m_torch_ShortTensor_mm(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
short arg2 = 0;
THShortTensor *arg3 = NULL;
short arg4 = 1;
THShortTensor *arg5 = NULL;
THShortTensor *arg6 = NULL;
if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 3, "torch.ShortTensor")) && (arg6->nDimension == 2)
)
{
arg1_idx = 1;
arg3 = arg1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ShortTensor* ShortTensor~2D ShortTensor~2D", type_buf);
}
THShortTensor_zero(arg1);
lua_pushvalue(L, arg1_idx);
THShortTensor_addmm(arg1,arg2,arg3,arg4,arg5,arg6);
return 1;
}

static int m_torch_ShortTensor_bmm(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
short arg2 = 0;
THShortTensor *arg3 = NULL;
short arg4 = 1;
THShortTensor *arg5 = NULL;
THShortTensor *arg6 = NULL;
if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg5->nDimension == 3)
&& (arg6 = luaT_toudata(L, 3, "torch.ShortTensor")) && (arg6->nDimension == 3)
)
{
arg1_idx = 1;
arg3 = arg1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ShortTensor* ShortTensor~3D ShortTensor~3D", type_buf);
}
THShortTensor_zero(arg1);
lua_pushvalue(L, arg1_idx);
THShortTensor_baddbmm(arg1,arg2,arg3,arg4,arg5,arg6);
return 1;
}

static int m_torch_ShortTensor_ger(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
short arg2 = 1;
THShortTensor *arg3 = NULL;
short arg4 = 1;
THShortTensor *arg5 = NULL;
THShortTensor *arg6 = NULL;
if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg5->nDimension == 1)
&& (arg6 = luaT_toudata(L, 3, "torch.ShortTensor")) && (arg6->nDimension == 1)
)
{
arg1_idx = 1;
arg3 = arg1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ShortTensor* ShortTensor~1D ShortTensor~1D", type_buf);
}
THShortTensor_zero(arg1);
lua_pushvalue(L, arg1_idx);
THShortTensor_addr(arg1,arg2,arg3,arg4,arg5,arg6);
return 1;
}

static int m_torch_ShortTensor_addmv(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
short arg2 = 1;
THShortTensor *arg3 = NULL;
short arg4 = 1;
THShortTensor *arg5 = NULL;
THShortTensor *arg6 = NULL;
THShortTensor *arg7 = NULL;
int arg7_idx = 0;
short arg8 = 0;
THShortTensor *arg9 = NULL;
short arg10 = 0;
THShortTensor *arg11 = NULL;
THShortTensor *arg12 = NULL;
if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor")) && (arg1->nDimension == 1)
&& (arg5 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 3, "torch.ShortTensor")) && (arg6->nDimension == 1)
)
{
argset = 1;
arg1_idx = 1;
arg3 = arg1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor")) && (arg1->nDimension == 1)
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg3->nDimension == 1)
&& (arg5 = luaT_toudata(L, 3, "torch.ShortTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 4, "torch.ShortTensor")) && (arg6->nDimension == 1)
)
{
argset = 1;
arg1_idx = 1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor")) && (arg1->nDimension == 1)
&& lua_isnumber(L, 2)
&& (arg5 = luaT_toudata(L, 3, "torch.ShortTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 4, "torch.ShortTensor")) && (arg6->nDimension == 1)
)
{
argset = 1;
arg1_idx = 1;
arg4 = (short)lua_tonumber(L, 2);
arg3 = arg1;
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor")) && (arg1->nDimension == 1)
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg3->nDimension == 1)
&& lua_isnumber(L, 3)
&& (arg5 = luaT_toudata(L, 4, "torch.ShortTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 5, "torch.ShortTensor")) && (arg6->nDimension == 1)
)
{
argset = 1;
arg1_idx = 1;
arg4 = (short)lua_tonumber(L, 3);
}
else if(narg == 5
&& (arg7 = luaT_toudata(L, 1, "torch.ShortTensor")) && (arg7->nDimension == 1)
&& lua_isnumber(L, 2)
&& lua_isnumber(L, 3)
&& (arg11 = luaT_toudata(L, 4, "torch.ShortTensor")) && (arg11->nDimension == 2)
&& (arg12 = luaT_toudata(L, 5, "torch.ShortTensor")) && (arg12->nDimension == 1)
)
{
argset = 2;
arg7_idx = 1;
arg8 = (short)lua_tonumber(L, 2);
arg10 = (short)lua_tonumber(L, 3);
arg9 = arg7;
}
else if(narg == 6
&& (arg7 = luaT_toudata(L, 1, "torch.ShortTensor")) && (arg7->nDimension == 1)
&& lua_isnumber(L, 2)
&& (arg9 = luaT_toudata(L, 3, "torch.ShortTensor")) && (arg9->nDimension == 1)
&& lua_isnumber(L, 4)
&& (arg11 = luaT_toudata(L, 5, "torch.ShortTensor")) && (arg11->nDimension == 2)
&& (arg12 = luaT_toudata(L, 6, "torch.ShortTensor")) && (arg12->nDimension == 1)
)
{
argset = 2;
arg7_idx = 1;
arg8 = (short)lua_tonumber(L, 2);
arg10 = (short)lua_tonumber(L, 4);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ShortTensor~1D* [ShortTensor~1D] [short] ShortTensor~2D ShortTensor~1D | *ShortTensor~1D* short [ShortTensor~1D] short ShortTensor~2D ShortTensor~1D", type_buf);
}
if(argset == 1)
{
lua_pushvalue(L, arg1_idx);
THShortTensor_addmv(arg1,arg2,arg3,arg4,arg5,arg6);
return 1;
}
else if(argset == 2)
{
lua_pushvalue(L, arg7_idx);
THShortTensor_addmv(arg7,arg8,arg9,arg10,arg11,arg12);
return 1;
}
return 0;
}

static int m_torch_ShortTensor_addmm(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
short arg2 = 1;
THShortTensor *arg3 = NULL;
short arg4 = 1;
THShortTensor *arg5 = NULL;
THShortTensor *arg6 = NULL;
THShortTensor *arg7 = NULL;
int arg7_idx = 0;
short arg8 = 0;
THShortTensor *arg9 = NULL;
short arg10 = 0;
THShortTensor *arg11 = NULL;
THShortTensor *arg12 = NULL;
if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor")) && (arg1->nDimension == 2)
&& (arg5 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 3, "torch.ShortTensor")) && (arg6->nDimension == 2)
)
{
argset = 1;
arg1_idx = 1;
arg3 = arg1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor")) && (arg1->nDimension == 2)
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg3->nDimension == 2)
&& (arg5 = luaT_toudata(L, 3, "torch.ShortTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 4, "torch.ShortTensor")) && (arg6->nDimension == 2)
)
{
argset = 1;
arg1_idx = 1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor")) && (arg1->nDimension == 2)
&& lua_isnumber(L, 2)
&& (arg5 = luaT_toudata(L, 3, "torch.ShortTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 4, "torch.ShortTensor")) && (arg6->nDimension == 2)
)
{
argset = 1;
arg1_idx = 1;
arg4 = (short)lua_tonumber(L, 2);
arg3 = arg1;
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor")) && (arg1->nDimension == 2)
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg3->nDimension == 2)
&& lua_isnumber(L, 3)
&& (arg5 = luaT_toudata(L, 4, "torch.ShortTensor")) && (arg5->nDimension == 2)
&& (arg6 = luaT_toudata(L, 5, "torch.ShortTensor")) && (arg6->nDimension == 2)
)
{
argset = 1;
arg1_idx = 1;
arg4 = (short)lua_tonumber(L, 3);
}
else if(narg == 5
&& (arg7 = luaT_toudata(L, 1, "torch.ShortTensor")) && (arg7->nDimension == 2)
&& lua_isnumber(L, 2)
&& lua_isnumber(L, 3)
&& (arg11 = luaT_toudata(L, 4, "torch.ShortTensor")) && (arg11->nDimension == 2)
&& (arg12 = luaT_toudata(L, 5, "torch.ShortTensor")) && (arg12->nDimension == 2)
)
{
argset = 2;
arg7_idx = 1;
arg8 = (short)lua_tonumber(L, 2);
arg10 = (short)lua_tonumber(L, 3);
arg9 = arg7;
}
else if(narg == 6
&& (arg7 = luaT_toudata(L, 1, "torch.ShortTensor")) && (arg7->nDimension == 2)
&& lua_isnumber(L, 2)
&& (arg9 = luaT_toudata(L, 3, "torch.ShortTensor")) && (arg9->nDimension == 2)
&& lua_isnumber(L, 4)
&& (arg11 = luaT_toudata(L, 5, "torch.ShortTensor")) && (arg11->nDimension == 2)
&& (arg12 = luaT_toudata(L, 6, "torch.ShortTensor")) && (arg12->nDimension == 2)
)
{
argset = 2;
arg7_idx = 1;
arg8 = (short)lua_tonumber(L, 2);
arg10 = (short)lua_tonumber(L, 4);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ShortTensor~2D* [ShortTensor~2D] [short] ShortTensor~2D ShortTensor~2D | *ShortTensor~2D* short [ShortTensor~2D] short ShortTensor~2D ShortTensor~2D", type_buf);
}
if(argset == 1)
{
lua_pushvalue(L, arg1_idx);
THShortTensor_addmm(arg1,arg2,arg3,arg4,arg5,arg6);
return 1;
}
else if(argset == 2)
{
lua_pushvalue(L, arg7_idx);
THShortTensor_addmm(arg7,arg8,arg9,arg10,arg11,arg12);
return 1;
}
return 0;
}

static int m_torch_ShortTensor_addr(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
short arg2 = 1;
THShortTensor *arg3 = NULL;
short arg4 = 1;
THShortTensor *arg5 = NULL;
THShortTensor *arg6 = NULL;
THShortTensor *arg7 = NULL;
int arg7_idx = 0;
short arg8 = 0;
THShortTensor *arg9 = NULL;
short arg10 = 0;
THShortTensor *arg11 = NULL;
THShortTensor *arg12 = NULL;
if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor")) && (arg1->nDimension == 2)
&& (arg5 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg5->nDimension == 1)
&& (arg6 = luaT_toudata(L, 3, "torch.ShortTensor")) && (arg6->nDimension == 1)
)
{
argset = 1;
arg1_idx = 1;
arg3 = arg1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor")) && (arg1->nDimension == 2)
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg3->nDimension == 2)
&& (arg5 = luaT_toudata(L, 3, "torch.ShortTensor")) && (arg5->nDimension == 1)
&& (arg6 = luaT_toudata(L, 4, "torch.ShortTensor")) && (arg6->nDimension == 1)
)
{
argset = 1;
arg1_idx = 1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor")) && (arg1->nDimension == 2)
&& lua_isnumber(L, 2)
&& (arg5 = luaT_toudata(L, 3, "torch.ShortTensor")) && (arg5->nDimension == 1)
&& (arg6 = luaT_toudata(L, 4, "torch.ShortTensor")) && (arg6->nDimension == 1)
)
{
argset = 1;
arg1_idx = 1;
arg4 = (short)lua_tonumber(L, 2);
arg3 = arg1;
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor")) && (arg1->nDimension == 2)
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg3->nDimension == 2)
&& lua_isnumber(L, 3)
&& (arg5 = luaT_toudata(L, 4, "torch.ShortTensor")) && (arg5->nDimension == 1)
&& (arg6 = luaT_toudata(L, 5, "torch.ShortTensor")) && (arg6->nDimension == 1)
)
{
argset = 1;
arg1_idx = 1;
arg4 = (short)lua_tonumber(L, 3);
}
else if(narg == 5
&& (arg7 = luaT_toudata(L, 1, "torch.ShortTensor")) && (arg7->nDimension == 2)
&& lua_isnumber(L, 2)
&& lua_isnumber(L, 3)
&& (arg11 = luaT_toudata(L, 4, "torch.ShortTensor")) && (arg11->nDimension == 1)
&& (arg12 = luaT_toudata(L, 5, "torch.ShortTensor")) && (arg12->nDimension == 1)
)
{
argset = 2;
arg7_idx = 1;
arg8 = (short)lua_tonumber(L, 2);
arg10 = (short)lua_tonumber(L, 3);
arg9 = arg7;
}
else if(narg == 6
&& (arg7 = luaT_toudata(L, 1, "torch.ShortTensor")) && (arg7->nDimension == 2)
&& lua_isnumber(L, 2)
&& (arg9 = luaT_toudata(L, 3, "torch.ShortTensor")) && (arg9->nDimension == 2)
&& lua_isnumber(L, 4)
&& (arg11 = luaT_toudata(L, 5, "torch.ShortTensor")) && (arg11->nDimension == 1)
&& (arg12 = luaT_toudata(L, 6, "torch.ShortTensor")) && (arg12->nDimension == 1)
)
{
argset = 2;
arg7_idx = 1;
arg8 = (short)lua_tonumber(L, 2);
arg10 = (short)lua_tonumber(L, 4);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ShortTensor~2D* [ShortTensor~2D] [short] ShortTensor~1D ShortTensor~1D | *ShortTensor~2D* short [ShortTensor~2D] short ShortTensor~1D ShortTensor~1D", type_buf);
}
if(argset == 1)
{
lua_pushvalue(L, arg1_idx);
THShortTensor_addr(arg1,arg2,arg3,arg4,arg5,arg6);
return 1;
}
else if(argset == 2)
{
lua_pushvalue(L, arg7_idx);
THShortTensor_addr(arg7,arg8,arg9,arg10,arg11,arg12);
return 1;
}
return 0;
}

static int m_torch_ShortTensor_addbmm(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
short arg2 = 1;
THShortTensor *arg3 = NULL;
short arg4 = 1;
THShortTensor *arg5 = NULL;
THShortTensor *arg6 = NULL;
THShortTensor *arg7 = NULL;
int arg7_idx = 0;
short arg8 = 0;
THShortTensor *arg9 = NULL;
short arg10 = 0;
THShortTensor *arg11 = NULL;
THShortTensor *arg12 = NULL;
if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor")) && (arg1->nDimension == 2)
&& (arg5 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg5->nDimension == 3)
&& (arg6 = luaT_toudata(L, 3, "torch.ShortTensor")) && (arg6->nDimension == 3)
)
{
argset = 1;
arg1_idx = 1;
arg3 = arg1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor")) && (arg1->nDimension == 2)
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg3->nDimension == 2)
&& (arg5 = luaT_toudata(L, 3, "torch.ShortTensor")) && (arg5->nDimension == 3)
&& (arg6 = luaT_toudata(L, 4, "torch.ShortTensor")) && (arg6->nDimension == 3)
)
{
argset = 1;
arg1_idx = 1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor")) && (arg1->nDimension == 2)
&& lua_isnumber(L, 2)
&& (arg5 = luaT_toudata(L, 3, "torch.ShortTensor")) && (arg5->nDimension == 3)
&& (arg6 = luaT_toudata(L, 4, "torch.ShortTensor")) && (arg6->nDimension == 3)
)
{
argset = 1;
arg1_idx = 1;
arg4 = (short)lua_tonumber(L, 2);
arg3 = arg1;
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor")) && (arg1->nDimension == 2)
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg3->nDimension == 2)
&& lua_isnumber(L, 3)
&& (arg5 = luaT_toudata(L, 4, "torch.ShortTensor")) && (arg5->nDimension == 3)
&& (arg6 = luaT_toudata(L, 5, "torch.ShortTensor")) && (arg6->nDimension == 3)
)
{
argset = 1;
arg1_idx = 1;
arg4 = (short)lua_tonumber(L, 3);
}
else if(narg == 5
&& (arg7 = luaT_toudata(L, 1, "torch.ShortTensor")) && (arg7->nDimension == 2)
&& lua_isnumber(L, 2)
&& lua_isnumber(L, 3)
&& (arg11 = luaT_toudata(L, 4, "torch.ShortTensor")) && (arg11->nDimension == 3)
&& (arg12 = luaT_toudata(L, 5, "torch.ShortTensor")) && (arg12->nDimension == 3)
)
{
argset = 2;
arg7_idx = 1;
arg8 = (short)lua_tonumber(L, 2);
arg10 = (short)lua_tonumber(L, 3);
arg9 = arg7;
}
else if(narg == 6
&& (arg7 = luaT_toudata(L, 1, "torch.ShortTensor")) && (arg7->nDimension == 2)
&& lua_isnumber(L, 2)
&& (arg9 = luaT_toudata(L, 3, "torch.ShortTensor")) && (arg9->nDimension == 2)
&& lua_isnumber(L, 4)
&& (arg11 = luaT_toudata(L, 5, "torch.ShortTensor")) && (arg11->nDimension == 3)
&& (arg12 = luaT_toudata(L, 6, "torch.ShortTensor")) && (arg12->nDimension == 3)
)
{
argset = 2;
arg7_idx = 1;
arg8 = (short)lua_tonumber(L, 2);
arg10 = (short)lua_tonumber(L, 4);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ShortTensor~2D* [ShortTensor~2D] [short] ShortTensor~3D ShortTensor~3D | *ShortTensor~2D* short [ShortTensor~2D] short ShortTensor~3D ShortTensor~3D", type_buf);
}
if(argset == 1)
{
lua_pushvalue(L, arg1_idx);
THShortTensor_addbmm(arg1,arg2,arg3,arg4,arg5,arg6);
return 1;
}
else if(argset == 2)
{
lua_pushvalue(L, arg7_idx);
THShortTensor_addbmm(arg7,arg8,arg9,arg10,arg11,arg12);
return 1;
}
return 0;
}

static int m_torch_ShortTensor_baddbmm(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
short arg2 = 1;
THShortTensor *arg3 = NULL;
short arg4 = 1;
THShortTensor *arg5 = NULL;
THShortTensor *arg6 = NULL;
THShortTensor *arg7 = NULL;
int arg7_idx = 0;
short arg8 = 0;
THShortTensor *arg9 = NULL;
short arg10 = 0;
THShortTensor *arg11 = NULL;
THShortTensor *arg12 = NULL;
if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor")) && (arg1->nDimension == 3)
&& (arg5 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg5->nDimension == 3)
&& (arg6 = luaT_toudata(L, 3, "torch.ShortTensor")) && (arg6->nDimension == 3)
)
{
argset = 1;
arg1_idx = 1;
arg3 = arg1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor")) && (arg1->nDimension == 3)
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg3->nDimension == 3)
&& (arg5 = luaT_toudata(L, 3, "torch.ShortTensor")) && (arg5->nDimension == 3)
&& (arg6 = luaT_toudata(L, 4, "torch.ShortTensor")) && (arg6->nDimension == 3)
)
{
argset = 1;
arg1_idx = 1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor")) && (arg1->nDimension == 3)
&& lua_isnumber(L, 2)
&& (arg5 = luaT_toudata(L, 3, "torch.ShortTensor")) && (arg5->nDimension == 3)
&& (arg6 = luaT_toudata(L, 4, "torch.ShortTensor")) && (arg6->nDimension == 3)
)
{
argset = 1;
arg1_idx = 1;
arg4 = (short)lua_tonumber(L, 2);
arg3 = arg1;
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor")) && (arg1->nDimension == 3)
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor")) && (arg3->nDimension == 3)
&& lua_isnumber(L, 3)
&& (arg5 = luaT_toudata(L, 4, "torch.ShortTensor")) && (arg5->nDimension == 3)
&& (arg6 = luaT_toudata(L, 5, "torch.ShortTensor")) && (arg6->nDimension == 3)
)
{
argset = 1;
arg1_idx = 1;
arg4 = (short)lua_tonumber(L, 3);
}
else if(narg == 5
&& (arg7 = luaT_toudata(L, 1, "torch.ShortTensor")) && (arg7->nDimension == 3)
&& lua_isnumber(L, 2)
&& lua_isnumber(L, 3)
&& (arg11 = luaT_toudata(L, 4, "torch.ShortTensor")) && (arg11->nDimension == 3)
&& (arg12 = luaT_toudata(L, 5, "torch.ShortTensor")) && (arg12->nDimension == 3)
)
{
argset = 2;
arg7_idx = 1;
arg8 = (short)lua_tonumber(L, 2);
arg10 = (short)lua_tonumber(L, 3);
arg9 = arg7;
}
else if(narg == 6
&& (arg7 = luaT_toudata(L, 1, "torch.ShortTensor")) && (arg7->nDimension == 3)
&& lua_isnumber(L, 2)
&& (arg9 = luaT_toudata(L, 3, "torch.ShortTensor")) && (arg9->nDimension == 3)
&& lua_isnumber(L, 4)
&& (arg11 = luaT_toudata(L, 5, "torch.ShortTensor")) && (arg11->nDimension == 3)
&& (arg12 = luaT_toudata(L, 6, "torch.ShortTensor")) && (arg12->nDimension == 3)
)
{
argset = 2;
arg7_idx = 1;
arg8 = (short)lua_tonumber(L, 2);
arg10 = (short)lua_tonumber(L, 4);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ShortTensor~3D* [ShortTensor~3D] [short] ShortTensor~3D ShortTensor~3D | *ShortTensor~3D* short [ShortTensor~3D] short ShortTensor~3D ShortTensor~3D", type_buf);
}
if(argset == 1)
{
lua_pushvalue(L, arg1_idx);
THShortTensor_baddbmm(arg1,arg2,arg3,arg4,arg5,arg6);
return 1;
}
else if(argset == 2)
{
lua_pushvalue(L, arg7_idx);
THShortTensor_baddbmm(arg7,arg8,arg9,arg10,arg11,arg12);
return 1;
}
return 0;
}

static int m_torch_ShortTensor_numel(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
ptrdiff_t arg2 = 0;
if(narg == 1
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
)
{
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: ShortTensor", type_buf);
}
arg2 = THShortTensor_numel(arg1);
lua_pushnumber(L, (lua_Number)arg2);
return 1;
}

static int m_torch_ShortTensor_cumsum(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THShortTensor *arg2 = NULL;
long arg3 = 0;
if(narg == 1
&& (arg2 = luaT_toudata(L, 1, "torch.ShortTensor"))
)
{
arg1 = THShortTensor_new();
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
)
{
arg1_idx = 1;
}
else if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
)
{
arg3 = (long)lua_tonumber(L, 2)-1;
arg1 = THShortTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (long)lua_tonumber(L, 3)-1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ShortTensor*] ShortTensor [index]", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ShortTensor");
THShortTensor_cumsum(arg1,arg2,arg3);
return 1;
}

static int m_torch_ShortTensor_cumprod(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THShortTensor *arg2 = NULL;
long arg3 = 0;
if(narg == 1
&& (arg2 = luaT_toudata(L, 1, "torch.ShortTensor"))
)
{
arg1 = THShortTensor_new();
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
)
{
arg1_idx = 1;
}
else if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
)
{
arg3 = (long)lua_tonumber(L, 2)-1;
arg1 = THShortTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (long)lua_tonumber(L, 3)-1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ShortTensor*] ShortTensor [index]", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ShortTensor");
THShortTensor_cumprod(arg1,arg2,arg3);
return 1;
}

static int m_torch_ShortTensor_sum(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THShortTensor *arg1 = NULL;
long arg2 = 0;
THShortTensor *arg3 = NULL;
int arg3_idx = 0;
THShortTensor *arg4 = NULL;
long arg5 = 0;
int arg6 = 1;
if(narg == 1
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
)
{
argset = 1;
}
else if(narg == 2
&& (arg4 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 2;
arg5 = (long)lua_tonumber(L, 2)-1;
arg3 = THShortTensor_new();
}
else if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg4 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg3_idx = 1;
arg5 = (long)lua_tonumber(L, 3)-1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: ShortTensor | [*ShortTensor*] ShortTensor index", type_buf);
}
if(argset == 1)
{
arg2 = THShortTensor_sumall(arg1);
lua_pushnumber(L, (lua_Number)arg2);
return 1;
}
else if(argset == 2)
{
if(arg3_idx)
lua_pushvalue(L, arg3_idx);
else
luaT_pushudata(L, arg3, "torch.ShortTensor");
THShortTensor_sum(arg3,arg4,arg5,arg6);
return 1;
}
return 0;
}

static int m_torch_ShortTensor_prod(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THShortTensor *arg1 = NULL;
long arg2 = 0;
THShortTensor *arg3 = NULL;
int arg3_idx = 0;
THShortTensor *arg4 = NULL;
long arg5 = 0;
int arg6 = 1;
if(narg == 1
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
)
{
argset = 1;
}
else if(narg == 2
&& (arg4 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 2;
arg5 = (long)lua_tonumber(L, 2)-1;
arg3 = THShortTensor_new();
}
else if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg4 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg3_idx = 1;
arg5 = (long)lua_tonumber(L, 3)-1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: ShortTensor | [*ShortTensor*] ShortTensor index", type_buf);
}
if(argset == 1)
{
arg2 = THShortTensor_prodall(arg1);
lua_pushnumber(L, (lua_Number)arg2);
return 1;
}
else if(argset == 2)
{
if(arg3_idx)
lua_pushvalue(L, arg3_idx);
else
luaT_pushudata(L, arg3, "torch.ShortTensor");
THShortTensor_prod(arg3,arg4,arg5,arg6);
return 1;
}
return 0;
}

static int m_torch_ShortTensor_min(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THShortTensor *arg1 = NULL;
short arg2 = 0;
THShortTensor *arg3 = NULL;
int arg3_idx = 0;
THLongTensor *arg4 = NULL;
int arg4_idx = 0;
THShortTensor *arg5 = NULL;
long arg6 = 0;
int arg7 = 1;
if(narg == 1
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
)
{
argset = 1;
}
else if(narg == 2
&& (arg5 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 2;
arg6 = (long)lua_tonumber(L, 2)-1;
arg3 = THShortTensor_new();
arg4 = THLongTensor_new();
}
else if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg3_idx = 1;
arg6 = (long)lua_tonumber(L, 3)-1;
arg4 = THLongTensor_new();
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg4_idx = 1;
arg6 = (long)lua_tonumber(L, 3)-1;
arg3 = THShortTensor_new();
}
else if(narg == 4
&& (arg3 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg4 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg5 = luaT_toudata(L, 3, "torch.ShortTensor"))
&& lua_isnumber(L, 4)
)
{
argset = 2;
arg3_idx = 1;
arg4_idx = 2;
arg6 = (long)lua_tonumber(L, 4)-1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: ShortTensor | [*ShortTensor*] [*LongTensor*] ShortTensor index", type_buf);
}
if(argset == 1)
{
arg2 = THShortTensor_minall(arg1);
lua_pushnumber(L, (lua_Number)arg2);
return 1;
}
else if(argset == 2)
{
if(arg3_idx)
lua_pushvalue(L, arg3_idx);
else
luaT_pushudata(L, arg3, "torch.ShortTensor");
if(arg4_idx)
lua_pushvalue(L, arg4_idx);
else
luaT_pushudata(L, arg4, "torch.LongTensor");
THShortTensor_min(arg3,arg4,arg5,arg6,arg7);
THLongTensor_add(arg4, arg4, 1);
return 2;
}
return 0;
}

static int m_torch_ShortTensor_max(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THShortTensor *arg1 = NULL;
short arg2 = 0;
THShortTensor *arg3 = NULL;
int arg3_idx = 0;
THLongTensor *arg4 = NULL;
int arg4_idx = 0;
THShortTensor *arg5 = NULL;
long arg6 = 0;
int arg7 = 1;
if(narg == 1
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
)
{
argset = 1;
}
else if(narg == 2
&& (arg5 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 2;
arg6 = (long)lua_tonumber(L, 2)-1;
arg3 = THShortTensor_new();
arg4 = THLongTensor_new();
}
else if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg3_idx = 1;
arg6 = (long)lua_tonumber(L, 3)-1;
arg4 = THLongTensor_new();
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg4_idx = 1;
arg6 = (long)lua_tonumber(L, 3)-1;
arg3 = THShortTensor_new();
}
else if(narg == 4
&& (arg3 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg4 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg5 = luaT_toudata(L, 3, "torch.ShortTensor"))
&& lua_isnumber(L, 4)
)
{
argset = 2;
arg3_idx = 1;
arg4_idx = 2;
arg6 = (long)lua_tonumber(L, 4)-1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: ShortTensor | [*ShortTensor*] [*LongTensor*] ShortTensor index", type_buf);
}
if(argset == 1)
{
arg2 = THShortTensor_maxall(arg1);
lua_pushnumber(L, (lua_Number)arg2);
return 1;
}
else if(argset == 2)
{
if(arg3_idx)
lua_pushvalue(L, arg3_idx);
else
luaT_pushudata(L, arg3, "torch.ShortTensor");
if(arg4_idx)
lua_pushvalue(L, arg4_idx);
else
luaT_pushudata(L, arg4, "torch.LongTensor");
THShortTensor_max(arg3,arg4,arg5,arg6,arg7);
THLongTensor_add(arg4, arg4, 1);
return 2;
}
return 0;
}

static int m_torch_ShortTensor_cmin(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THShortTensor *arg2 = NULL;
THShortTensor *arg3 = NULL;
THShortTensor *arg4 = NULL;
int arg4_idx = 0;
THShortTensor *arg5 = NULL;
short arg6 = 0;
if(narg == 1
&& (arg3 = luaT_toudata(L, 1, "torch.ShortTensor"))
)
{
argset = 1;
arg1 = THShortTensor_new();
arg2 = arg1;
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
)
{
argset = 1;
arg1_idx = 1;
arg2 = arg1;
}
else if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
)
{
argset = 1;
arg1 = THShortTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor"))
)
{
argset = 1;
arg1_idx = 1;
}
else if(narg == 1
&& lua_isnumber(L, 1)
)
{
argset = 2;
arg6 = (short)lua_tonumber(L, 1);
arg4 = THShortTensor_new();
arg5 = arg4;
}
else if(narg == 2
&& (arg4 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 2;
arg4_idx = 1;
arg6 = (short)lua_tonumber(L, 2);
arg5 = arg4;
}
else if(narg == 2
&& (arg5 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 2;
arg6 = (short)lua_tonumber(L, 2);
arg4 = THShortTensor_new();
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg4_idx = 1;
arg6 = (short)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ShortTensor*] [ShortTensor] ShortTensor | [*ShortTensor*] [ShortTensor] short", type_buf);
}
if(argset == 1)
{
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ShortTensor");
THShortTensor_cmin(arg1,arg2,arg3);
return 1;
}
else if(argset == 2)
{
if(arg4_idx)
lua_pushvalue(L, arg4_idx);
else
luaT_pushudata(L, arg4, "torch.ShortTensor");
THShortTensor_cminValue(arg4,arg5,arg6);
return 1;
}
return 0;
}

static int m_torch_ShortTensor_cmax(lua_State *L)
{
int narg = lua_gettop(L);
int argset = 0;
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THShortTensor *arg2 = NULL;
THShortTensor *arg3 = NULL;
THShortTensor *arg4 = NULL;
int arg4_idx = 0;
THShortTensor *arg5 = NULL;
short arg6 = 0;
if(narg == 1
&& (arg3 = luaT_toudata(L, 1, "torch.ShortTensor"))
)
{
argset = 1;
arg1 = THShortTensor_new();
arg2 = arg1;
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
)
{
argset = 1;
arg1_idx = 1;
arg2 = arg1;
}
else if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
)
{
argset = 1;
arg1 = THShortTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor"))
)
{
argset = 1;
arg1_idx = 1;
}
else if(narg == 1
&& lua_isnumber(L, 1)
)
{
argset = 2;
arg6 = (short)lua_tonumber(L, 1);
arg4 = THShortTensor_new();
arg5 = arg4;
}
else if(narg == 2
&& (arg4 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 2;
arg4_idx = 1;
arg6 = (short)lua_tonumber(L, 2);
arg5 = arg4;
}
else if(narg == 2
&& (arg5 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
)
{
argset = 2;
arg6 = (short)lua_tonumber(L, 2);
arg4 = THShortTensor_new();
}
else if(narg == 3
&& (arg4 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg5 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
)
{
argset = 2;
arg4_idx = 1;
arg6 = (short)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ShortTensor*] [ShortTensor] ShortTensor | [*ShortTensor*] [ShortTensor] short", type_buf);
}
if(argset == 1)
{
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ShortTensor");
THShortTensor_cmax(arg1,arg2,arg3);
return 1;
}
else if(argset == 2)
{
if(arg4_idx)
lua_pushvalue(L, arg4_idx);
else
luaT_pushudata(L, arg4, "torch.ShortTensor");
THShortTensor_cmaxValue(arg4,arg5,arg6);
return 1;
}
return 0;
}

static int m_torch_ShortTensor_trace(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
long arg2 = 0;
if(narg == 1
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
)
{
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: ShortTensor", type_buf);
}
arg2 = THShortTensor_trace(arg1);
lua_pushnumber(L, (lua_Number)arg2);
return 1;
}

static int m_torch_ShortTensor_cross(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THShortTensor *arg2 = NULL;
THShortTensor *arg3 = NULL;
long arg4 = -1;
if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
)
{
arg1 = THShortTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor"))
)
{
arg1_idx = 1;
}
else if(narg == 3
&& (arg2 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
)
{
arg4 = (long)lua_tonumber(L, 3)-1;
arg1 = THShortTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor"))
&& lua_isnumber(L, 4)
)
{
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 4)-1;
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ShortTensor*] ShortTensor ShortTensor [index]", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ShortTensor");
THShortTensor_cross(arg1,arg2,arg3,arg4);
return 1;
}

static int m_torch_ShortTensor_diag(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THShortTensor *arg2 = NULL;
long arg3 = 0;
if(narg == 1
&& (arg2 = luaT_toudata(L, 1, "torch.ShortTensor"))
)
{
arg1 = THShortTensor_new();
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
)
{
arg1_idx = 1;
}
else if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
)
{
arg3 = (long)lua_tonumber(L, 2);
arg1 = THShortTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (long)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ShortTensor*] ShortTensor [long]", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ShortTensor");
THShortTensor_diag(arg1,arg2,arg3);
return 1;
}

static int m_torch_ShortTensor_eye(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
long arg2 = 0;
long arg3 = 0;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
)
{
arg1_idx = 1;
arg2 = (long)lua_tonumber(L, 2);
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg2 = (long)lua_tonumber(L, 2);
arg3 = (long)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ShortTensor* long [long]", type_buf);
}
lua_pushvalue(L, arg1_idx);
THShortTensor_eye(arg1,arg2,arg3);
return 1;
}

static int m_torch_ShortTensor_range(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
long arg2 = 0;
long arg3 = 0;
long arg4 = 1;
if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg2 = (long)lua_tonumber(L, 2);
arg3 = (long)lua_tonumber(L, 3);
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
&& lua_isnumber(L, 3)
&& lua_isnumber(L, 4)
)
{
arg1_idx = 1;
arg2 = (long)lua_tonumber(L, 2);
arg3 = (long)lua_tonumber(L, 3);
arg4 = (long)lua_tonumber(L, 4);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ShortTensor* long long [long]", type_buf);
}
lua_pushvalue(L, arg1_idx);
THShortTensor_range(arg1,arg2,arg3,arg4);
return 1;
}

static int m_torch_ShortTensor_randperm(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THGenerator *arg2 = NULL;
long arg3 = 0;
if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
)
{
arg1_idx = 1;
arg3 = (long)lua_tonumber(L, 2);
lua_getglobal(L,"torch");
arg2 = luaT_getfieldcheckudata(L, -1, "_gen", torch_Generator);
lua_pop(L, 2);
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, torch_Generator))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg3 = (long)lua_tonumber(L, 3);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: *ShortTensor* [Generator] long", type_buf);
}
lua_pushvalue(L, arg1_idx);
THShortTensor_randperm(arg1,arg2,arg3);

THShortTensor_add(arg1, arg1, 1);
return 1;
}

static int m_torch_ShortTensor_sort(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THLongTensor *arg2 = NULL;
int arg2_idx = 0;
THShortTensor *arg3 = NULL;
long arg4 = 0;
int arg5 = 0;
if(narg == 1
&& (arg3 = luaT_toudata(L, 1, "torch.ShortTensor"))
)
{
arg1 = THShortTensor_new();
arg2 = THLongTensor_new();
arg4 = THShortTensor_nDimension(arg3)-1;
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
)
{
arg1_idx = 1;
arg2 = THLongTensor_new();
arg4 = THShortTensor_nDimension(arg3)-1;
}
else if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
)
{
arg2_idx = 1;
arg1 = THShortTensor_new();
arg4 = THShortTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor"))
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = THShortTensor_nDimension(arg3)-1;
}
else if(narg == 2
&& (arg3 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
)
{
arg4 = (long)lua_tonumber(L, 2)-1;
arg1 = THShortTensor_new();
arg2 = THLongTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 3)-1;
arg2 = THLongTensor_new();
}
else if(narg == 3
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
)
{
arg2_idx = 1;
arg4 = (long)lua_tonumber(L, 3)-1;
arg1 = THShortTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor"))
&& lua_isnumber(L, 4)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = (long)lua_tonumber(L, 4)-1;
}
else if(narg == 2
&& (arg3 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isboolean(L, 2)
)
{
arg5 = lua_toboolean(L, 2);
arg1 = THShortTensor_new();
arg2 = THLongTensor_new();
arg4 = THShortTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isboolean(L, 3)
)
{
arg1_idx = 1;
arg5 = lua_toboolean(L, 3);
arg2 = THLongTensor_new();
arg4 = THShortTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isboolean(L, 3)
)
{
arg2_idx = 1;
arg5 = lua_toboolean(L, 3);
arg1 = THShortTensor_new();
arg4 = THShortTensor_nDimension(arg3)-1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor"))
&& lua_isboolean(L, 4)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg5 = lua_toboolean(L, 4);
arg4 = THShortTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
&& lua_isboolean(L, 3)
)
{
arg4 = (long)lua_tonumber(L, 2)-1;
arg5 = lua_toboolean(L, 3);
arg1 = THShortTensor_new();
arg2 = THLongTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
)
{
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 3)-1;
arg5 = lua_toboolean(L, 4);
arg2 = THLongTensor_new();
}
else if(narg == 4
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
)
{
arg2_idx = 1;
arg4 = (long)lua_tonumber(L, 3)-1;
arg5 = lua_toboolean(L, 4);
arg1 = THShortTensor_new();
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor"))
&& lua_isnumber(L, 4)
&& lua_isboolean(L, 5)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = (long)lua_tonumber(L, 4)-1;
arg5 = lua_toboolean(L, 5);
}
else
{
char type_buf[512];
str_arg_types(L, type_buf, 512);
luaL_error(L, "invalid arguments: %s\nexpected arguments: [*ShortTensor*] [*LongTensor*] ShortTensor [index] [boolean]", type_buf);
}
if(arg1_idx)
lua_pushvalue(L, arg1_idx);
else
luaT_pushudata(L, arg1, "torch.ShortTensor");
if(arg2_idx)
lua_pushvalue(L, arg2_idx);
else
luaT_pushudata(L, arg2, "torch.LongTensor");
THShortTensor_sort(arg1,arg2,arg3,arg4,arg5);
THLongTensor_add(arg2, arg2, 1);
return 2;
}

static int m_torch_ShortTensor_topk(lua_State *L)
{
int narg = lua_gettop(L);
THShortTensor *arg1 = NULL;
int arg1_idx = 0;
THLongTensor *arg2 = NULL;
int arg2_idx = 0;
THShortTensor *arg3 = NULL;
long arg4 = 1;
long arg5 = 0;
int arg6 = 0;
int arg7 = 0;
if(narg == 1
&& (arg3 = luaT_toudata(L, 1, "torch.ShortTensor"))
)
{
arg1 = THShortTensor_new();
arg2 = THLongTensor_new();
arg5 = THShortTensor_nDimension(arg3)-1;
}
else if(narg == 2
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
)
{
arg1_idx = 1;
arg2 = THLongTensor_new();
arg5 = THShortTensor_nDimension(arg3)-1;
}
else if(narg == 2
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
)
{
arg2_idx = 1;
arg1 = THShortTensor_new();
arg5 = THShortTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor"))
)
{
arg1_idx = 1;
arg2_idx = 2;
arg5 = THShortTensor_nDimension(arg3)-1;
}
else if(narg == 2
&& (arg3 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
)
{
arg4 = (long)lua_tonumber(L, 2);
arg1 = THShortTensor_new();
arg2 = THLongTensor_new();
arg5 = THShortTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg2 = THLongTensor_new();
arg5 = THShortTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
)
{
arg2_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg1 = THShortTensor_new();
arg5 = THShortTensor_nDimension(arg3)-1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor"))
&& lua_isnumber(L, 4)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = (long)lua_tonumber(L, 4);
arg5 = THShortTensor_nDimension(arg3)-1;
}
else if(narg == 2
&& (arg3 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
)
{
arg5 = (long)lua_tonumber(L, 2)-1;
arg1 = THShortTensor_new();
arg2 = THLongTensor_new();
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
)
{
arg1_idx = 1;
arg5 = (long)lua_tonumber(L, 3)-1;
arg2 = THLongTensor_new();
}
else if(narg == 3
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
)
{
arg2_idx = 1;
arg5 = (long)lua_tonumber(L, 3)-1;
arg1 = THShortTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor"))
&& lua_isnumber(L, 4)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg5 = (long)lua_tonumber(L, 4)-1;
}
else if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
&& lua_isnumber(L, 3)
)
{
arg4 = (long)lua_tonumber(L, 2);
arg5 = (long)lua_tonumber(L, 3)-1;
arg1 = THShortTensor_new();
arg2 = THLongTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
&& lua_isnumber(L, 4)
)
{
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg5 = (long)lua_tonumber(L, 4)-1;
arg2 = THLongTensor_new();
}
else if(narg == 4
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
&& lua_isnumber(L, 4)
)
{
arg2_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg5 = (long)lua_tonumber(L, 4)-1;
arg1 = THShortTensor_new();
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor"))
&& lua_isnumber(L, 4)
&& lua_isnumber(L, 5)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = (long)lua_tonumber(L, 4);
arg5 = (long)lua_tonumber(L, 5)-1;
}
else if(narg == 2
&& (arg3 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isboolean(L, 2)
)
{
arg6 = lua_toboolean(L, 2);
arg1 = THShortTensor_new();
arg2 = THLongTensor_new();
arg5 = THShortTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isboolean(L, 3)
)
{
arg1_idx = 1;
arg6 = lua_toboolean(L, 3);
arg2 = THLongTensor_new();
arg5 = THShortTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isboolean(L, 3)
)
{
arg2_idx = 1;
arg6 = lua_toboolean(L, 3);
arg1 = THShortTensor_new();
arg5 = THShortTensor_nDimension(arg3)-1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor"))
&& lua_isboolean(L, 4)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg6 = lua_toboolean(L, 4);
arg5 = THShortTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
&& lua_isboolean(L, 3)
)
{
arg4 = (long)lua_tonumber(L, 2);
arg6 = lua_toboolean(L, 3);
arg1 = THShortTensor_new();
arg2 = THLongTensor_new();
arg5 = THShortTensor_nDimension(arg3)-1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
)
{
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg6 = lua_toboolean(L, 4);
arg2 = THLongTensor_new();
arg5 = THShortTensor_nDimension(arg3)-1;
}
else if(narg == 4
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
)
{
arg2_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg6 = lua_toboolean(L, 4);
arg1 = THShortTensor_new();
arg5 = THShortTensor_nDimension(arg3)-1;
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor"))
&& lua_isnumber(L, 4)
&& lua_isboolean(L, 5)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = (long)lua_tonumber(L, 4);
arg6 = lua_toboolean(L, 5);
arg5 = THShortTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
&& lua_isboolean(L, 3)
)
{
arg5 = (long)lua_tonumber(L, 2)-1;
arg6 = lua_toboolean(L, 3);
arg1 = THShortTensor_new();
arg2 = THLongTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
)
{
arg1_idx = 1;
arg5 = (long)lua_tonumber(L, 3)-1;
arg6 = lua_toboolean(L, 4);
arg2 = THLongTensor_new();
}
else if(narg == 4
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
)
{
arg2_idx = 1;
arg5 = (long)lua_tonumber(L, 3)-1;
arg6 = lua_toboolean(L, 4);
arg1 = THShortTensor_new();
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor"))
&& lua_isnumber(L, 4)
&& lua_isboolean(L, 5)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg5 = (long)lua_tonumber(L, 4)-1;
arg6 = lua_toboolean(L, 5);
}
else if(narg == 4
&& (arg3 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
)
{
arg4 = (long)lua_tonumber(L, 2);
arg5 = (long)lua_tonumber(L, 3)-1;
arg6 = lua_toboolean(L, 4);
arg1 = THShortTensor_new();
arg2 = THLongTensor_new();
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
&& lua_isnumber(L, 4)
&& lua_isboolean(L, 5)
)
{
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg5 = (long)lua_tonumber(L, 4)-1;
arg6 = lua_toboolean(L, 5);
arg2 = THLongTensor_new();
}
else if(narg == 5
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
&& lua_isnumber(L, 4)
&& lua_isboolean(L, 5)
)
{
arg2_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg5 = (long)lua_tonumber(L, 4)-1;
arg6 = lua_toboolean(L, 5);
arg1 = THShortTensor_new();
}
else if(narg == 6
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor"))
&& lua_isnumber(L, 4)
&& lua_isnumber(L, 5)
&& lua_isboolean(L, 6)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = (long)lua_tonumber(L, 4);
arg5 = (long)lua_tonumber(L, 5)-1;
arg6 = lua_toboolean(L, 6);
}
else if(narg == 2
&& (arg3 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isboolean(L, 2)
)
{
arg7 = lua_toboolean(L, 2);
arg1 = THShortTensor_new();
arg2 = THLongTensor_new();
arg5 = THShortTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isboolean(L, 3)
)
{
arg1_idx = 1;
arg7 = lua_toboolean(L, 3);
arg2 = THLongTensor_new();
arg5 = THShortTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isboolean(L, 3)
)
{
arg2_idx = 1;
arg7 = lua_toboolean(L, 3);
arg1 = THShortTensor_new();
arg5 = THShortTensor_nDimension(arg3)-1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor"))
&& lua_isboolean(L, 4)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg7 = lua_toboolean(L, 4);
arg5 = THShortTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
&& lua_isboolean(L, 3)
)
{
arg4 = (long)lua_tonumber(L, 2);
arg7 = lua_toboolean(L, 3);
arg1 = THShortTensor_new();
arg2 = THLongTensor_new();
arg5 = THShortTensor_nDimension(arg3)-1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
)
{
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg7 = lua_toboolean(L, 4);
arg2 = THLongTensor_new();
arg5 = THShortTensor_nDimension(arg3)-1;
}
else if(narg == 4
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
)
{
arg2_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg7 = lua_toboolean(L, 4);
arg1 = THShortTensor_new();
arg5 = THShortTensor_nDimension(arg3)-1;
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor"))
&& lua_isnumber(L, 4)
&& lua_isboolean(L, 5)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = (long)lua_tonumber(L, 4);
arg7 = lua_toboolean(L, 5);
arg5 = THShortTensor_nDimension(arg3)-1;
}
else if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
&& lua_isboolean(L, 3)
)
{
arg5 = (long)lua_tonumber(L, 2)-1;
arg7 = lua_toboolean(L, 3);
arg1 = THShortTensor_new();
arg2 = THLongTensor_new();
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
)
{
arg1_idx = 1;
arg5 = (long)lua_tonumber(L, 3)-1;
arg7 = lua_toboolean(L, 4);
arg2 = THLongTensor_new();
}
else if(narg == 4
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
)
{
arg2_idx = 1;
arg5 = (long)lua_tonumber(L, 3)-1;
arg7 = lua_toboolean(L, 4);
arg1 = THShortTensor_new();
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor"))
&& lua_isnumber(L, 4)
&& lua_isboolean(L, 5)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg5 = (long)lua_tonumber(L, 4)-1;
arg7 = lua_toboolean(L, 5);
}
else if(narg == 4
&& (arg3 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isnumber(L, 2)
&& lua_isnumber(L, 3)
&& lua_isboolean(L, 4)
)
{
arg4 = (long)lua_tonumber(L, 2);
arg5 = (long)lua_tonumber(L, 3)-1;
arg7 = lua_toboolean(L, 4);
arg1 = THShortTensor_new();
arg2 = THLongTensor_new();
}
else if(narg == 5
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
&& lua_isnumber(L, 4)
&& lua_isboolean(L, 5)
)
{
arg1_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg5 = (long)lua_tonumber(L, 4)-1;
arg7 = lua_toboolean(L, 5);
arg2 = THLongTensor_new();
}
else if(narg == 5
&& (arg2 = luaT_toudata(L, 1, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 2, "torch.ShortTensor"))
&& lua_isnumber(L, 3)
&& lua_isnumber(L, 4)
&& lua_isboolean(L, 5)
)
{
arg2_idx = 1;
arg4 = (long)lua_tonumber(L, 3);
arg5 = (long)lua_tonumber(L, 4)-1;
arg7 = lua_toboolean(L, 5);
arg1 = THShortTensor_new();
}
else if(narg == 6
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg2 = luaT_toudata(L, 2, "torch.LongTensor"))
&& (arg3 = luaT_toudata(L, 3, "torch.ShortTensor"))
&& lua_isnumber(L, 4)
&& lua_isnumber(L, 5)
&& lua_isboolean(L, 6)
)
{
arg1_idx = 1;
arg2_idx = 2;
arg4 = (long)lua_tonumber(L, 4);
arg5 = (long)lua_tonumber(L, 5)-1;
arg7 = lua_toboolean(L, 6);
}
else if(narg == 3
&& (arg3 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& lua_isboolean(L, 2)
&& lua_isboolean(L, 3)
)
{
arg6 = lua_toboolean(L, 2);
arg7 = lua_toboolean(L, 3);
arg1 = THShortTensor_new();
arg2 = THLongTensor_new();
arg5 = THShortTensor_nDimension(arg3)-1;
}
else if(narg == 4
&& (arg1 = luaT_toudata(L, 1, "torch.ShortTensor"))
&& (arg3 = luaT