<?
$wn_ver="3.1.13";

$home=getenv('HOME');
$username=getenv('USERNAME');

//plugin data
include_once(getenv('DOCUMENT_ROOT')."/httpsocket.php");
$host="localhost";
$ssl=getenv('SSL');
$port=getenv('SERVER_PORT');

$adminpath="wisenavAdmin";

//make code look like CLI for $_GET and $_POST
$_GET = Array();
$QUERY_STRING=getenv('QUERY_STRING');
if ($QUERY_STRING != "")
{
	parse_str(unhtmlentities($QUERY_STRING), $get_array);
	foreach ($get_array as $key => $value)
	{
		$_GET[urldecode($key)] = urldecode($value);
	}
}

$_POST = Array();
$POST_STRING=getenv('POST');
if ($POST_STRING != "")
{
	parse_str(unhtmlentities($POST_STRING), $post_array);
	foreach ($post_array as $key => $value)
	{
                $_POST[urldecode($key)] = urldecode($value);
	}
}

$domain = $_GET['domain'];
if (!is_domain($domain))
{
	$domain = $_POST['domain'];
	if (!is_domain($domain))
	{
		die("You must pass a valid domain name");
	}
}

//file where list of created websites are created.
$wn_dir_list=$home."/domains/".$domain."/.wisenav";

function unhtmlentities($string)
{
     return preg_replace('~&#([0-9][0-9])~e', 'chr(\\1)', $string);
}

function is_domain($domain)
{
        if (strlen($domain) > 60) return false;
        return ereg("^(([a-z0-9\-])+\.)+([a-zA-Z0-9]{2,4})$", $domain);
}

function newSock()
{
        global $host;
        global $port;
        global $ssl;
	global $username;

        $tsock = new HTTPSocket;
        $tsock->set_method('POST');
	$tsock->set_login($username);

        if ($ssl)
        {
                $tsock->connect("ssl://$host", $port);
        }
        else
        {
                $tsock->connect("$host", $port);
        }

        return $tsock;
}

function get_list()
{
	global $wn_dir_list;
	if (!file_exists($wn_dir_list)) return 0;
	if (!filesize($wn_dir_list)) return 0;
	$arr = Array();

	$fp = @fopen($wn_dir_list, "r");
	if (!$fp) return 0;

	$count = 0;
	while (!feof($fp))
        {
                $buffer = fgets($fp, 1024);

                //chop the \n at the end, and set.
		$arr[$count++] = substr($buffer, 0, -1);
        }

        fclose($fp);

	return $arr;
}

function is_dir_in_wisenav_list($dir)
{
	//check to see if the given dir is in the list already
	
	global $wn_dir_list;

	$fp = @fopen($wn_dir_list, "r");

	if (!$fp) return 0;

	while (!feof($fp))
	{
		$buffer = fgets($fp, 1024);

		//chop the \n at the end
		$buffer = substr($buffer, 0, -1);

		if ($dir == $buffer)
		{
			fclose($fp);
			return 1;
		}
	}

	fclose($fp);	
}

function touch_wisenav_dir($dir)
{
	//this function is here to keep track of where WN was installed to.

	if (is_dir_in_wisenav_list($dir)) return; //it's already in there. No need to add it.
	
	global $wn_dir_list;

	$fp = fopen($wn_dir_list, "a");

	if ($fp)
	{
		fwrite($fp, $dir."\n");		
		fclose($fp);
	}
	else
	{
		echo "Unable to add directory to the $wn_dir_list list";
	}	
}

function is_valid_path($path)
{

	if (strlen($path) == 0) return 1;

	//must not start or end with / character
	//must not contain repeated // characters
	//must not contains repeated .. characters
	//<> are not allowed
	//no quotes or double quotes.
	//no |, $, #, & or \

	if (substr($path, 0, 1) == '/')
	{
		return 0;
	}

	if (substr($path, -1) == '/')
	{
		return 0;
	}

	if (strstr($path, '//')) return 0;
	if (strstr($path, '..')) return 0;
	if (strstr($path, '<'))  return 0;
	if (strstr($path, '>'))  return 0;
	if (strstr($path, '\'')) return 0;
	if (strstr($path, '"'))  return 0;
	if (strstr($path, '|'))  return 0;
	if (strstr($path, '$'))  return 0;
	if (strstr($path, '#'))  return 0;
	if (strstr($path, '&'))  return 0;
	if (strstr($path, '\\')) return 0;
	if (strstr($path, '\t')) return 0;
	if (strstr($path, '\n')) return 0;

	return 1;
}

function html_char($str)
{
	return htmlspecialchars($str);
}


function has_suphp()
{
	//function returns 1 if we have it , 0 if we dont.
	//needs to be for .php files.
	//if unsure, return 2

	//usr/local/directadmin/custombuild/options.conf
	//default_php=5
	//php4_cgi=no
	//php5_cgi=no

	$fp = @fopen("/usr/local/directadmin/custombuild/options.conf", "r");
	if ($fp)
	{
		$arr = Array();
	        while (!feof($fp))
	        {
	                $buffer = fgets($fp, 1024);
	                //chop the \n at the end.
	                $buffer = substr($buffer, 0, -1);
			
			if (substr($buffer, 0, 1) == '#') continue;

			$value="";
			list($name, $value) = split('=', $buffer);
			if ($value == "") continue;

			$arr[$name] = $value;
		}

		fclose($fp);

		if ($arr['default_php'] == "5" && $arr['php5_cgi'] == "yes")
		{
			return 1;
		}

		if ($arr['default_php'] == "4" && $arr['php4_cgi'] == "yes")
		{
			return 1;
		}

		return 0;
        }
		
		

	return 2;
}


?>
