<?php

// sendShortEmailForm.php

// create a new content node
ini_set("always_populate_raw_post_data", true);

if (strtoupper(substr(PHP_OS,0,3)=='WIN')) {
  $eol="\r\n";
} elseif (strtoupper(substr(PHP_OS,0,3)=='MAC')) {
  $eol="\r";
} else {
  $eol="\n";
}

$toEmail = "";
$fromEmail = "";
$emailSubject = "";
$fullName = "";
$phone = "";
$company = "";
$comments = "";


/******************************************************************************
# function: windowsCheckDnsrr                                                 
#
# parameters: 
#   host - the host name to verify
#
# return:    
#   boolean - returns true if the host is a valid, else return false.
#
# notes:
#   This is a windows script only.  It checks DNS to see if we have a
#   valid host name (the host name associated with the user's email).
#
******************************************************************************/
function windowsCheckDnsrr($host,$recType='') {
	if(!empty($host)) {
		if($recType=='') {
			$recType="MX";
		}
		exec("nslookup -type=$recType $host",$output);
		foreach($output as $line) {
			if(preg_match("/^$host/", $line)) {
				return true;
			}
		}
		return false;
	}
	return false;
}


/******************************************************************************
# function: validateEmail                                                  
#
# parameters: 
#   emailAddress - the email address to validate
#
# return:    
#   boolean - returns true if the email is valid, else false is returned.
#
******************************************************************************/
function validateEmail($email) {
	// checks proper syntax
	if(preg_match("/^([a-zA-Z0-9])+([a-zA-Z0-9\._-])*@([a-zA-Z0-9_-])+([a-zA-Z0-9\._-]+)+\.([a-zA-Z0-9])+$/", $email)) {

		// gets domain name
		list($username,$domain)=split('@',$email);
		
		// determine the platform for the host, as we have a different 
		// validating function for windows and unix
		if (strtoupper(substr(PHP_OS, 0, 3)) == 'WIN') {
			return true;
			// we are on a Windows platform
			//if(!windowsCheckDnsrr($domain)){
			//	return false;
		    //}
		} else {
			// checks MX records in the DNS
			if(!checkdnsrr($domain, 'MX')) {
				return false;
			}
		}
		return true;
	}
	return false;
}


// The handler for the XML element opening tags
function startElementHandler($parser, $name, $attr) {
	global  $toEmail, $fromEmail, $emailSubject, $fullName, $comments, $phone, $company;

	if (strcmp($name, "EMAILFORM") == 0) {
		$toEmail = urldecode($attr["TOEMAIL"]);
		$fromEmail = urldecode($attr["FROMEMAIL"]);
		$emailSubject = urldecode($attr["EMAILSUBJECT"]);
		$fullName = urldecode($attr["FULLNAME"]);
		$phone = urldecode($attr["PHONE"]);
		$company = urldecode($attr["COMPANY"]);
		$comments = $attr["COMMENTS"];
	}
}

// The handler for the XML element closing tags
function endElementHandler () {
	// nothing to do in this case
}

// create our XML parser
$parser = xml_parser_create();

// register the start and end element handlers
xml_set_element_handler($parser, "startElementHandler", "endElementHandler");

if (!xml_parse($parser, $HTTP_RAW_POST_DATA, true)) {
	// return XML document with an error message
	$message = "There was an error in the XML line " .
				xml_get_current_line_number($parser) . " at position " .
				xml_get_current_column_number($parser);

	echo "<response><status>". $message ."</status></response>";
	exit;
}

// finished parsing the XML
xml_parser_free($parser);

//fwrite($fp, "to: $toEmail from: $fromEmail first: $firstName last: $lastName comments: $comments \n");
if ($toEmail == "" || $fromEmail == "" || $fullName == "" || $phone == "" || $company == "" || $comments == "") {
	$message = "An internal required field for creating the scene is invalid.";
	echo "<response><status>". $message ."</status></response>";
	exit;
}
if ($emailSubject == "") {
	$emailSubject = "WiseNav Email Form";
}

if (!validateEmail($fromEmail)) {
	echo "<response><status>WiseNav is unable to validate your email address.</status></response>";
	exit;
}
// substitue php newlines for flash new lines
$comments = ereg_replace("%0D","<BR>",$comments);
$comments = urldecode($comments);
$comments = ereg_replace("<BR>", $eol, $comments);


// create the email message
$body = "WISENAV EMAIL FORM" . $eol . $eol . "FULL NAME: " . $fullName . $eol . "EMAIL: " . $fromEmail . $eol . 
		"TELEPHONE NUMBER: " . $phone . $eol . "COMPANY: " . $company . $eol . $eol .
		"COMMENTS:" . $eol . "--------" . $eol . "$comments" . $eol;


// send the email
$headers = "From: " . $firstName ." ". $lastName . "<" . $fromEmail .">\r\n";
$headers .= "Reply-To: " . $fromEmail . "\r\n";
$headers .= "Return-path: " . $fromEmail . "\r\n";
$headers .= "Message-ID: <".time()."-".$fromEmail.">" . $eol;
$headers .= "X-Mailer: PHP/".phpversion();          // These two to help avoid spam-filters

$mailsend = mail($toEmail, $emailSubject, $body, $headers);
if (!$mailsend) {
	echo "<response><status>Unable to send your email.</status></response>";
} else {
	echo "<response><status>success</status></response>";
}
?>