<?php

ini_set("always_populate_raw_post_data", true);

//************************************
// convert old photo album to new photo album
// - the new photo album now has its own directory for its images, so it's not independent
// - to convert, we create a new directory for the photo album and we copy over its images
//************************************

include "includes/getDocumentRoot.inc.php";

// global variables
$site = "";
$dir = "";
$message = "";


function createPhotoAlbumDir() {
	global $site, $dir;

	// if the photo album directory does not exist, then create it
	$photoAlbumDir = getDocumentRoot() . $site . "/photoAlbums";
	if (!is_dir($photoAlbumDir)) {
		$result = mkdir($photoAlbumDir, 0755);
		if (!$result) {
			$message = "Error creating top dir for the photo albums.";
			return $message;
		}
	}

	// create a bogus text file in the photoAlbums directory so that FrontPage does not
	// delete it if the directory is empty (for user whose HSP supports FrontPage extension).
	$bogusfile = $photoAlbumDir . "/" . "frontpage_fix.txt";
	if (!$fileHandle = fopen($bogusfile, "w")) {
		$message = 'An error (file open) occured while creating the top Photo Album directory.';
		return $message;
	}
	if (fwrite($fileHandle, "This file is present to prevent Frontpage from deleting an empty directory.") === FALSE) {
		$message = 'An error (file write) occured while creating the top Photo Album directory.';
		fclose($fileHandle);
		return $message;
	}


	// create the directory for the new photo album
	$newDir = $photoAlbumDir . "/" . $dir;
	$result = mkdir($newDir, 0755);
	if ($result) {
		// create the bogus file frontpage_fix.txt which will prevent
		// FrontPage to delete an empty directory for user that have
		// the FrontPage extension with their HSP
		$bogusfile = $newDir . "/" . "frontpage_fix.txt";


		if (!$fileHandle = fopen($bogusfile, "w")) {
			$message = 'An error (file open) occured while creating the new Photo Album.';
			return $message;
		}

		if (fwrite($fileHandle, "This file is present to prevent Frontpage from deleting an empty directory.") === FALSE) {
			$message = 'An error (file write) occured while creating the new Photo Album.';
			fclose($fileHandle);
			return $message;
		}
		return "success";
	} else {
		$message = "Error creating new dir for the photo album.";
		return $message;
	}

}

// The handler for the XML element opening tags
function startElementHandler($parser, $name, $attr) {
	global $dir, $site, $message;

	// TODO: we also need the full path, so we can set the path, such as "content/sitename/merchants/maps/" for saving the map
	if (strcmp($name, "CONVERTPHOTOALBUM") == 0) {
		$dir = $attr["DIR"];
		$site = $attr["SITE"];
		
		if ($site == "" || $dir == "") {
			echo "<response><status>Error, invalid values send to the server for converting the Photo Album.</status></response>";
			exit;
		}

		// create the photo album directory
		$result = createPhotoAlbumDir();
		if ($result != success) {
			echo "<response><status>" . $message . "</status></response>";
			exit;
		}
	} else if (strcmp($name, "IMAGE") == 0) {
		if ($site == "" || $dir == "") {
			echo "<response><status>Error, invalid values send to the server.</status></response>";
			exit;
		}

		$name = $attr["NAME"];				
		$sourceImage = getDocumentRoot() . $site . "/images/mapImages/" . $name;
		$photoAlbumImage = getDocumentRoot() . $site . "/photoAlbums/" . $dir . "/" . $name;
		if (is_file($sourceImage)) {

			// copy the image
			$result = copy($sourceImage, $photoAlbumImage);
			if (!$result) {
				if ($message == "") {
					$message = "Error copying the image(s): " . $name;
				} else {
					$message .= ", " . $name;
				}
			}
		}
	}
}

// The handler for the XML element closing tags
function endElementHandler () {
	// nothing to do in this case
}

// create our XML parser
$parser = xml_parser_create();

// register the start and end element handlers
xml_set_element_handler($parser, "startElementHandler", "endElementHandler");


if (!xml_parse($parser, $HTTP_RAW_POST_DATA, true)) {
	// return XML document with an error message
	$message = "There was an error in the XML line " .
				xml_get_current_line_number($parser) . " at position " .
				xml_get_current_column_number($parser);
	echo "<response><status>". $message ."</status></response>";
	exit;
}

// finished parsing the XML
xml_parser_free($parser);

if ($message != "") {
	$message .= ".";
	echo "<response><status>" . $message . "</status></response>";
} else {
	echo "<response><status>success</status></response>";
}
?>