<?php

// createApplicationFile.php

// create a new application file
// include "includes/getDocumentRoot.inc.php";

$sourceFile = "";
$destFile = "";
$filename = "";
$type = "";

ini_set("always_populate_raw_post_data", true);


//$logHandle = fopen("c:/log/createApplicationFile.txt" ,"w");
//fwrite($logHandle, "startup");


// The handler for the XML element opening tags
function startElementHandler($parser, $name, $attr) {
	global  $sourceFile, $destFile, $filename, $type;

	if (strcmp($name, "APPLICATIONFILE") == 0) {
		$sourceFile = $attr["SOURCEFILE"];
		$destFile = $attr["DESTFILE"];
		$filename = $attr["FILENAME"];
		$type = $attr["TYPE"];
	}
}

// The handler for the XML element closing tags
function endElementHandler () {
	// nothing to do in this case
}

// create our XML parser
$parser = xml_parser_create();

// register the start and end element handlers
xml_set_element_handler($parser, "startElementHandler", "endElementHandler");

if (!xml_parse($parser, $HTTP_RAW_POST_DATA, true)) {
	// return XML document with an error message
	$message = "There was an error in the XML line " .
				xml_get_current_line_number($parser) . " at position " .
				xml_get_current_column_number($parser);

	echo "<response><status>". $message ."</status></response>";
	exit;
}

// finished parsing the XML
xml_parser_free($parser);


if ($sourceFile == "" || $destFile == "" || $filename == "" || $type == "") {
	$message = "Unexpected error.";
	echo "<response><status>". $message ."</status></response>";
	exit;
}

//fwrite($logHandle, "coping ../" . $sourceFile . ", ../" . $destFile);

// copy the template application XML file
copy("../" . $sourceFile, "../" . $destFile);

// if this is a photos button, also create the corresponding directory in the photoAlbums directory, as this
// is where we keep the images for this button
//fwrite($logHandle, "Button Type: $type \n");
if ($type == "photos") {
	//fwrite($logHandle, "Create directory for photos \n");


	// 1 get the name of the filename without the extension, this is the subdirectory for the images
	$imageDir = substr($filename, 0, -4);
	//fwrite($logHandle, "ImageDir: $imageDir \n");

	// 2) remove the filename from the path
	$mapPath = substr($destFile, 0, -(strlen($filename)));
	//fwrite($logHandle, "mapPath: $mapPath \n");

	// 2) append "photoAlbums" and the image dir
	$mapPath = "../" . $mapPath . "photoAlbums/" . $imageDir;
	//fwrite($logHandle, "Dir to create: $mapPath \n");

	// 3) create the directory 
	mkdir($mapPath);

	// 4 create a bogus file to prevent Frontpage from removing an empty directory
	$bogusFile = $mapPath . "/frontpage_fix.txt";
	$fp = fopen($bogusFile, "w");
	fwrite($fp, "This is a file to prevent Frontpage from deleting an empty directory.");
	fclose($fp);
}

//fclose($logHandle);

// return the result, including the filename
echo '<response><status>success</status><filename>' . $filename . '</filename></response>';

?>