<?php

// createMap.php

// create a new content node
include "includes/getDocumentRoot.inc.php";

$nodeName = "";
$directory = "";
$mapWidth = "";
$mapHeight = "";
$softwareVersion = "";

ini_set("always_populate_raw_post_data", true);

// The handler for the XML element opening tags
function startElementHandler($parser, $name, $attr) {
	global  $nodeName, $directory, $mapWidth, $mapHeight, $softwareVersion;

	if (strcmp($name, "MAPNODE") == 0) {
		$nodeName = $attr["MAPNAME"];
		$directory = $attr["DIRECTORY"];
		$mapWidth = $attr["MAPWIDTH"];
		$mapHeight = $attr["MAPHEIGHT"];
		$softwareVersion = $attr["SOFTWAREVERSION"];
	}
}

// The handler for the XML element closing tags
function endElementHandler () {
	// nothing to do in this case
}

// create our XML parser
$parser = xml_parser_create();

// register the start and end element handlers
xml_set_element_handler($parser, "startElementHandler", "endElementHandler");

if (!xml_parse($parser, $HTTP_RAW_POST_DATA, true)) {
	// return XML document with an error message
	$message = "There was an error in the XML line " .
				xml_get_current_line_number($parser) . " at position " .
				xml_get_current_column_number($parser);

	echo "<response><status>". $message ."</status></response>";
	exit;
}

// finished parsing the XML
xml_parser_free($parser);


if ($nodeName == "" || $directory == "" || $mapWidth == "" || $mapHeight == "" || $softwareVersion == "") {
	$message = "An internal required field for creating the scene is invalid.";
	echo "<response><status>". $message ."</status></response>";
	exit;
}

// if the map directory does not exist, create it
$dirlength = strlen($directory) - 1;
$topDir = getDocumentRoot() . substr($directory, 0, $dirlength);
if (!Is_dir($topDir)) {
	if (!mkdir($topDir)) {
		echo '<response><status>An error (mkdir-topDir) occured while creating the new scene.</status></response>';
		exit;
	}

	// TODO: check if dir was successfully created and with proper permissions
}


// create the new directory for the map
// TODO: check if the dir was successfully created and with proper permissions; if not return error message
$destination = getDocumentRoot() . $directory . $nodeName;
if (!mkdir($destination)) {
	echo '<response><status>An error (mkdir-scene) occured while creating the new scene.</status></response>';
	exit;
}
$message = "";

// create the map.xml document
$dirRoot = getDocumentRoot() . $directory . $nodeName . "/";
$xmlFilename = $dirRoot . "map.xml";
$xmlContent = "<?xml version=\"1.0\"?><map sound=\"\" filename=\"map.xml\" softwareVersion=\"" . $softwareVersion . "\" mapWidth=\"" . $mapWidth . "\" mapHeight=\"" . $mapHeight . "\" desc=\"bogus\" mapname=\"map.xml\" ><image scale=\"100\" y=\"0\" x=\"0\"></image><components /><areas /><canvas /><buttons /><controls /></map>";
if (!$fileHandle = fopen($xmlFilename ,"w")) {
	echo '<response><status>An error (file open) occured while creating the new scene.</status></response>';
	exit;
}

if (fwrite($fileHandle, $xmlContent) === FALSE) {
	echo '<response><status>An error (file write) occured while creating the new scene.</status></response>';
	fclose($fileHandle);
	exit;
}

fclose($fileHandle);

echo '<response><status>success</status><mapName>' . urlencode($nodeName) . '</mapName></response>';
?>