<?php


//*********************************
// delete a content node from disk
//*********************************

include "includes/getDocumentRoot.inc.php";

$directory = "";
$filename = "";

ini_set("always_populate_raw_post_data", true);

// remove a directory and all it's content (this is a recursive function)
/* function rmdirrORIGINAL($dir) {
	if ($objs = glob($dir."/*")) {
		foreach($objs as $obj) {
			is_dir($obj)? rmdirr($obj) : unlink($obj);
		}
	}
	rmdir($dir);
} */

 function rmdirr($dirname)
 {
     // Sanity check
     if (!file_exists($dirname)) {
         return false;
     }
  
     // Simple delete for a file
     if (is_file($dirname) || is_link($dirname)) {
         return unlink($dirname);
     }
  
     // Loop through the folder
     $dir = dir($dirname);
     while (false !== $entry = $dir->read()) {
         // Skip pointers
         if ($entry == '.' || $entry == '..') {
             continue;
         }
  
         // Recurse
         rmdirr($dirname . DIRECTORY_SEPARATOR . $entry);
     }
  
     // Clean up
     $dir->close();
     return rmdir($dirname);
 }

// The handler for the XML element opening tags
function startElementHandler($parser, $name, $attr) {
	global $directory, $filename;
	
	if (strcmp($name, "CONTENTNODE") == 0) {
		$directory = $attr["DIRECTORY"];
		$filename = $attr["FILENAME"];
	}
}

// The handler for the XML element closing tags
function endElementHandler () {
	// nothing to do in this case
}

// create our XML parser
$parser = xml_parser_create();

// register the start and end element handlers
xml_set_element_handler($parser, "startElementHandler", "endElementHandler");

if (!xml_parse($parser, $HTTP_RAW_POST_DATA, true)) {
	// return XML document with an error message
	$errormsg = "There was an error in the XML line " .
				xml_get_current_line_number($parser) . " at position " .
				xml_get_current_column_number($parser);

	echo "<response><status>". $message ."</status></response>";
	exit;
}

// finished parsing the XML
xml_parser_free($parser);

if ($directory == "" || $filename == "") {
	$message = "Unexpected error";
	echo "<response><status>". $message ."</status></response>";
	exit;
}


//location of the content node directory to delete
$doc_root = getDocumentRoot();
$fullpath = $doc_root . "/" . $directory . $filename;

// remove the directory
$delResult = rmdirr($fullpath);

if ($delResult) {
	$message = "success";
} else {
	$message = "Error Deleting the Content Node!";
}
echo "<response><status>". $message ."</status><filename>" . $filename . "</filename></response>";
?>