<?php

// duplicate a scene

$oldName = "";
$newName = "";
$directory = "";

ini_set("always_populate_raw_post_data", true);


//$logHandle = fopen("c:/log/renameMap.txt" ,"w");
//fwrite($logHandle, "startup");


// The handler for the XML element opening tags
function startElementHandler($parser, $name, $attr) {
	global  $oldName, $newName, $directory;

	if (strcmp($name, "MAPNODE") == 0) {
		$oldName = $attr["OLDNAME"];
		$newName = $attr["NEWNAME"];
		$directory = $attr["DIRECTORY"];
	}
}

// The handler for the XML element closing tags
function endElementHandler () {
	// nothing to do in this case
}

// create our XML parser
$parser = xml_parser_create();

// register the start and end element handlers
xml_set_element_handler($parser, "startElementHandler", "endElementHandler");

if (!xml_parse($parser, $HTTP_RAW_POST_DATA, true)) {
	// return XML document with an error message
	$message = "There was an error in the XML line " .
				xml_get_current_line_number($parser) . " at position " .
				xml_get_current_column_number($parser);

	echo "<response><status>". $message ."</status></response>";
	exit;
}

// finished parsing the XML
xml_parser_free($parser);

//fwrite($logHandle, "oldName: $oldName newName: $newName dir: $directory \n");

if ($oldName == "" || $newName == "" || $directory == "") {
	$message = "Unexpected error.";
	echo "<response><status>". $message ."</status></response>";
	exit;
}

// create the contentNode
$source = "../" . $directory . "/" . $oldName;
$destination = "../" . $directory . "/" . $newName;
$message = "";

copyDirectory($source, $destination);
echo "<response><status>success</status><newName>" . urlencode($newName) . "</newName></response>";


// copy the directory; on error return an error message and exit.
function copyDirectory($src, $dest) {
	global $logHandle;

	if (!mkdir($dest, 0777)) {
		$message = "ERROR creating the duplicate directory.";
		echo "<response><status>" . urlencode($message) . "</status></response>";
		exit();
	} 

	if ($handle = opendir($src)) {
		
		while (false !== ($file = readdir($handle))) { 			
			if ($file != "." && $file != ".." && $file != ".svn") {
				if (is_dir($src . "/" . $file)) {
					copyDirectory($src . "/" . $file, $dest . "/" . $file);
				} elseif (is_file($src . "/" . $file)) {
					copy($src . "/" . $file, $dest . "/" . $file);
				} 
			} 
		}
		closedir($handle); 
	} else {
		$message = "ERROR openning the scene to duplicate.";
		echo '<response><status>' . urlencode($message) . '</status></response>';
		exit();
	}
} 

//fclose($logHandle);
?>