<?php

function updateSceneMenuShadowPage($shadowMenuID, $shadowSceneList, $urlWebRoot, $updateHtmlIndex, $startupScene) {

	$shadowFile = "../../sceneMenuInclude/" . $shadowMenuID . ".inc";
	$indexShadowFile = "../../sceneMenuInclude/" . $shadowMenuID . ".htmlinc";

	if ($shadowSceneList == "") {

		// NOTE: we don't need to worry about index.html because if
		//       we are on startup page and removing the last menu,
		//       the required changes will be made to index.html
		//       when saving the scene
		unlink($shadowFile);
		unlink($indexShadowFile);
	} else {
		$myArrayContent = "";
		$myHtmlIndexContent = "";
		$counter = 0;
		$token = strtok($shadowSceneList, ',');
		while($token) {
			if ($counter == 0) {
				$myArrayContent = "'" . $token . "'";
				$myHtmlIndexContent = '<a href="' . $urlWebRoot . $token . '.php">' . $token . '</a>';
			} else {
				$myArrayContent = $myArrayContent . ", '" . $token . "'";
				$myHtmlIndexContent = $myHtmlIndexContent .  '<br><a href="' . $urlWebRoot . $token . '.php">' . $token . '</a>';
			}
			$counter++;
			$token = strtok(",");
		}			
		$shadowContent = '<?php $scenesArray = array(' . $myArrayContent  . '); $urlWebRoot = "' . $urlWebRoot . '"; foreach ($scenesArray as $scene) { if ($scene != $myScene) {$mydata = ';
		$shadowContent .= "'" . '<a href="' . "'" . ' . $urlWebRoot . $scene . ' . "'" .'.php">' . "'"  . ' . $scene . ' . "'" . '</a>' . "'" . '; echo "<br>$mydata"; }} ?>';

		// write the include files for the shadow php files
		// TODO: handle errors writing to disk
		$fp = fopen($shadowFile, "w+");
		fwrite($fp, $shadowContent);
		fclose($fp);

		// write include URL links for index.html
		$finalURLContent = '<div id="sceneMenu">' . $myHtmlIndexContent . '</div>';
		$fp = fopen($indexShadowFile, "w+");
		fwrite($fp, $finalURLContent);
		fclose($fp);

		// if this modified menu is also in the startup scene, we need to rewrite the index.html with the proper scene menu links
		//fwrite($fd, "updateHtmlIndex: $updateHtmlIndex statupScene: $startupScene \n");
		if ($updateHtmlIndex == "true") {
			
			// 1) remove the URL for the startup scene (since we do not want to point a URL link to ourself)
			$urlToRemove = '<a href="' . $urlWebRoot . $startupScene . '.php">' . $startupScene . '</a>';
			$myURLLinks = str_replace($urlToRemove, "", $finalURLContent);
			//fwrite($fd, "New URL for index: $myURLLinks \n");

			// 2) load the startup scene php file 
			$filename = "../../" . $startupScene . ".php";
			$fp = fopen($filename,"r");
			$phpContent = fread($fp, filesize($filename));
			fclose($fp);

			// 3) remove the div for "sceneMenu" and add the new div for "sceneMenu
			$phpInclude = '<div id="sceneMenu"><?php $myScene="' . $startupScene . '"; include("./sceneMenuInclude/' . $shadowMenuID .'.inc"); ?></div>';

			// make sure that the php tag exists (it could be absent if there was only one scene on the menu)
			if (strpos($phpContent, $phpInclude) === FALSE) {
				// no php tags found, insert the links just before the </body> tag
				$newURLLinks = $myURLLinks . '</body>';
				$finalContent = str_replace("</body>", $newURLLinks, $phpContent);
			} else {
				// substitue the URL links for the php tag
				$finalContent = str_replace($phpInclude, $myURLLinks, $phpContent);
			}

			// 4) write index.html to disk
			$filename = "../../index.html";
			$fp = fopen($filename,"w+");
			fwrite($fp, $finalContent);
			fclose($fp);
		}
	}
}

?>