<?php

//************************************
// create a new photo album directory
//************************************

include "includes/getDocumentRoot.inc.php";

// global variables
$dir = "";
$site = "";
$message = "Unknow error, please delete your new photo album and try again.";


ini_set("always_populate_raw_post_data", true);


// The handler for the XML element opening tags
function startElementHandler($parser, $name, $attr) {
	global $dir, $site;

	// TODO: we also need the full path, so we can set the path, such as "content/sitename/merchants/maps/" for saving the map
	if (strcmp($name, "PHOTOALBUM") == 0) {
		$dir = $attr["DIR"];
		$site = $attr["SITE"];
	}
}

// The handler for the XML element closing tags
function endElementHandler () {
	// nothing to do in this case
}

// create our XML parser
$parser = xml_parser_create();

// register the start and end element handlers
xml_set_element_handler($parser, "startElementHandler", "endElementHandler");

if (!xml_parse($parser, $HTTP_RAW_POST_DATA, true)) {
	// return XML document with an error message
	$message = "There was an error in the XML line " .
				xml_get_current_line_number($parser) . " at position " .
				xml_get_current_column_number($parser);
	echo "<response><status>". $message ."</status></response>";
	exit;
}

// finished parsing the XML
xml_parser_free($parser);

if ($dir == "" || $site == "") {
	$message = "Error reading the incomming photo album information...";
	echo "<response><status>". $message ."</status></response>";
	exit;
}


// if the photo album directory does not exist, then create it
$photoAlbumDir = getDocumentRoot() . $site . "/photoAlbums";
if (!is_dir($photoAlbumDir)) {
	$result = mkdir($photoAlbumDir, 0755);
	if (!$result) {
		$message = "Error creating top dir for the photo albums.";
		echo "<response><status>". $message ."</status></response>";
		exit;
	}
}

// create a bogus text file in the photoAlbums directory so that FrontPage does not
// delete it if the directory is empty (for user whose HSP supports FrontPage extension).
$bogusfile = $photoAlbumDir . "/" . "frontpage_fix.txt";
if (!$fileHandle = fopen($bogusfile, "w")) {
	echo '<response><status>An error (file open) occured while creating the top Photo Album directory.</status></response>';
	exit;
}
if (fwrite($fileHandle, "This file is present to prevent Frontpage from deleting an empty directory.") === FALSE) {
	echo '<response><status>An error (file write) occured while creating the top Photo Album directory.</status></response>';
	fclose($fileHandle);
	exit;
}


// create the directory for the new photo album
$newDir = $photoAlbumDir . "/" . $dir;
$result = mkdir($newDir, 0755);
if ($result) {
	// create the bogus file frontpage_fix.txt which will prevent
	// FrontPage to delete an empty directory for user that have
	// the FrontPage extension with their HSP
	$bogusfile = $newDir . "/" . "frontpage_fix.txt";


	if (!$fileHandle = fopen($bogusfile, "w")) {
		echo '<response><status>An error (file open) occured while creating the new Photo Album.</status></response>';
		exit;
	}

	if (fwrite($fileHandle, "This file is present to prevent Frontpage from deleting an empty directory.") === FALSE) {
		echo '<response><status>An error (file write) occured while creating the new Photo Album.</status></response>';
		fclose($fileHandle);
		exit;
	}
} else {
	$message = "Error creating new dir for the photo album.";
	echo "<response><status>". $message ."</status></response>";
	exit;
}

echo "<response><status>success</status></response>";
?>