<?php

//*************************
// Save a map file to disk
//*************************

ini_set("always_populate_raw_post_data", true);

// global variables
//$dir = "";
$mapName = "";
$decodedMapName = "";
$text = "";
$mapWidth = "";
$mapHeight = "";
$siteName = "";
$isIndex = "false";
$sceneMenuID = "";
$seoDescription = "";
$seoKeywords = "";
$seoTitle = "";
$seoMainHeading = "";
$urlWebRoot = "";
$publishMode = "scene";


// get the HSP include data if it has any
$hspInclude = "";
if (Is_file("./includes/hspInclude.php")) {
include "./includes/hspInclude.php";
} 


// DEBUG ONLY, print raw content to file for debuging
// $fd = fopen("c:/log/publishToHTML.txt", "w+");
//fwrite($fd,"$HTTP_RAW_POST_DATA \n");

// The handler for the XML element opening tags
function startElementHandler($parser, $name, $attr) {
	global $dir, $mapName, $mapWidth, $mapHeight, $text, $siteName, $decodedMapName, $isIndex;
	global $sceneMenuID, $seoDescription, $seoKeywords, $seoTitle, $seoMainHeading, $urlWebRoot, $publishMode, $fd;

	if (strcmp($name, "MAP") == 0) {
		$siteName = $attr["SITENAME"];
		//$dir = $attr["DIRNAME"];
		$mapName = $attr["MAPNAME"];
		$decodedMapName = urldecode($mapName);
		$mapWidth = $attr["MAPWIDTH"];
		$mapHeight = $attr["MAPHEIGHT"];
		$text = urldecode($attr["HTMLCONTENT"]);
		$isIndex = $attr["ISINDEX"];
		$sceneMenuID = $attr["SCENEMENUID"];
		$seoDescription = urldecode($attr["SEODESCRIPTION"]);
		$seoKeywords = urldecode($attr["SEOKEYWORDS"]);
		$seoTitle = urldecode($attr["SEOTITLE"]);
		$seoMainHeading = urldecode($attr["SEOMAINHEADING"]);
		$urlWebRoot = $attr["URLWEBROOT"];
		$publishMode = $attr["PUBLISHMODE"];
		//fwrite($fd, "isIndex: $isIndex sceneMenuID: $sceneMenuID mapName: $mapName \n");

		// we are done parsing, exit the parser; NOTE: this doesn not work, it hangs, so we are stuck reading the whole document for now
		// xml_parser_free($parser);
	}
}

// The handler for the XML element closing tags
function endElementHandler () {
	// nothing to do in this case
}

// create our XML parser
$parser = xml_parser_create();

// register the start and end element handlers
xml_set_element_handler($parser, "startElementHandler", "endElementHandler");

if (!xml_parse($parser, $HTTP_RAW_POST_DATA, true)) {
	// return XML document with an error message
	$message = "There was an error in the XML line " .
				xml_get_current_line_number($parser) . " at position " .
				xml_get_current_column_number($parser);
	// $message = "parsing error.";
	echo "<response><status>". $message ."</status><publishMode>" . $publishMode . "</publishMode></response>";
	exit;
}

// finished parsing the XML
xml_parser_free($parser);

if ($mapName == "" || $mapWidth == "" || $mapHeight == "" || $siteName == "") {
	$message = "Error reading the incomming map information...";
	echo "<response><status>". $message ."</status><publishMode>" . $publishMode . "</publishMode></response>";
	exit;
}

// remove the string 'LETTERSPACING="0" KERNING="0"' since it's not supported in HTML (this
// is added by the WiseNav text editor
$stringToChange = 'LETTERSPACING="0" KERNING="0"';
$newString = '';
$text = str_replace($stringToChange, $newString, $text);


// get the scene's description and keywords
$metaTagDescription = "";
if ($seoDescription != "" && $seoDescription != "undefined") {
	$metaTagDescription = '<meta name="description" content="' . $seoDescription . '">';
}
$metaTagKeywords = "";
if ($seoKeywords != "" && $seoKeywords != "undefined") {
	$metaTagKeywords = '<meta name="keywords" content="' . $seoKeywords . '">';
}
$pageTitle = $decodedMapName;
if ($seoTitle != "" && $seoTitle != "undefined") {
	$pageTitle = $seoTitle;
}
$pageMainHeading = "";
if ($seoMainHeading != "" && $seoMainHeading != "undefined") {
	$pageMainHeading = "<h1>$seoMainHeading</h1>";
}


// create the HTML page with the embeded WiseNav scene
$myRedirectStartHTML = <<<WISENAVHTML
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
    <head>
        <title>$pageTitle</title>
        <meta http-equiv="content-type" content="text/html; charset=utf-8">
		$metaTagDescription
		$metaTagKeywords
        <script type="text/javascript" src="swfobject/swfobject.js"></script>
        <script type="text/javascript" src="swfaddress/swfaddress.js"></script>
		<script language="JavaScript" type="text/javascript">
			// get a random number
			function generateRandomNumber() {
			  var rannum;
				rannum = Math.random()*10000;
				rannum = Math.round(rannum);
				return rannum;
			}
			// shadow
			var n4=(document.layers);
			var n6=(document.getElementById&&!document.all);
			var ie=(document.all);
			var O=(navigator.appName.indexOf("Opera") != -1)?true:false;
			var handleshadow=1;
			function shadow(event) {
				if (handleshadow) {
					handleshadow=0;
					var d = document.getElementById('htmltext');
					if (d != null) {
						d.parentNode.removeChild(d);
					}
					d = document.getElementById('builtwith');
					if (d != null) {
						d.parentNode.removeChild(d);
					}
					d = document.getElementById('sceneMenu');
					if (d != null) {
						d.parentNode.removeChild(d);
					}
					d = document.getElementById('spacing');
					if (d != null) {
						d.parentNode.removeChild(d);
					}
					if (n4||n6){
						// window.captureEvents(Event.MOUSEMOVE);
						if (n4)window.onMouseMove=null;
						if (n6)document.onmousemove=null;
					}
					if (ie||O){				
						document.onmousemove = null;
					}
				}
			}
			if (n4||n6){
				window.captureEvents(Event.MOUSEMOVE);
				if (n4)window.onMouseMove=shadow;
				if (n6)document.onmousemove=shadow;
			}
			if (ie||O){
				document.onmousemove=shadow;
			}
			// -->
		</script>
        <style type="text/css">
            /* hide from ie on mac \*/
           /*html {
                height: 100%;
                overflow: hidden;
            } */
            #flashcontent {
                height: 100%;
            } 
            /* end hide */
           body {
                height: 100%;
                margin: 0;
                padding: 0;
                background-color: #FFFFFF;
                font: 76% Arial, sans-serif;
            } 
        </style>
    </head>
    <body>
        <div id="flashcontent" align="center">
			<br>
			<strong>This content requires the latest Adobe Flash Player. <a href="http://www.adobe.com/go/getflash">Get Flash</a></strong>
		</div>
		<div align="center">
			<script type="text/javascript">
				// <![CDATA[
				var so = new SWFObject('swfRuntime/shell.swf?sitewidth=$mapWidth&siteheight=$mapHeight&nocache=' + generateRandomNumber(), 'shell', $mapWidth, $mapHeight, '8', '#CCCCCC');
				so.addParam('menu', 'false');            
				so.addParam('FlashVars', 'htmlshadow=true&contentNode=$siteName&startupMap=$mapName&viewerToolbarColor=16777164'); 
				so.addParam('width', $mapWidth);
				so.addParam('height', $mapHeight);
				so.addParam('quality', 'high');
				so.addParam('scale', 'noscale');
				so.write('flashcontent');
				// ]]>
			</script>
		</div>
		<div id="spacing"> <br> <br> <br> <br> <br> <br> <br> <br> <br> <br> <br> <br> <br> <br> <br> <br> <br> <br> <br> <br></div>
		<div id="htmltext">$pageMainHeading $text
		</div>
WISENAVHTML;

$myRedirectMenusHTML = "";
if ($sceneMenuID != "") {
	$myRedirectMenusHTML = '<div id="sceneMenu"><?php $myScene="' . $urlWebRoot . $decodedMapName . '"; include("./sceneMenuInclude/' . $sceneMenuID . '.inc"); ?></div>';
}
$wisenavLogo = '<div id="builtwith"><br><font FACE="Verdana" size="2">Built with <a href="http://www.wisenav.com">www.wisenav.com</a></font></div>';
$myRedirectEndHTML = "</body></html>";
$myRedirectPHP = $myRedirectStartHTML . $myRedirectMenusHTML . $wisenavLogo . $myRedirectEndHTML;
$filename = "../../" . $decodedMapName . ".php";
$message = "Error opening output file on server";
$fp = fopen($filename,"w+");
if (!fwrite($fp, $myRedirectPHP)) {
	$message = "Error publishing the WiseNav HTML page!";
	fclose($fp);
	exit;
} else {
	$message = "success";
	fclose($fp);

	//fwrite($dp, "isIndex: $isIndex menuID: $sceneMenuID\n");
	// fclose($dp);

	// if this scene is the entry level scene, then also copy to index.html
	if ($isIndex == "true") {
		if ($sceneMenuID == "") {
			// there are no scene menus, so simply copy the php file directly
			// copy($filename, "../../index.html");


			// check if there is a include file for the HSP, and if so, add it to the <HEAD> section
			if ($hspInclude != "") {
				$dataToModify = '</body>';
				$newDataString = $hspInclude . '</body>';
				$finalContent = str_replace($dataToModify, $newDataString, $myRedirectPHP);
			} else {
				$finalContent = $myRedirectPHP;
			}
	
			// 6) write index.html to disk
			$filename = "../../index.html";
			$fp = fopen($filename,"w+");
			fwrite($fp, $finalContent);
			fclose($fp);			

		} else {
			// we have scene menus, so we need to get copy the URL links directly in the html file (we cannot include
			// the php file).


			// 1) read the index file [menuid].htmlinc
			$filename = "../../sceneMenuInclude/" . $sceneMenuID . ".htmlinc";
			$myIndexData = "";
			$fp = fopen($filename,"r");
			$myIndexData = fread($fp, filesize($filename));  // TODO: handle open and write errors
			fclose($fp);

			//fwrite($fd, "urlIncludeFile data: $myIndexData \n");

			// remove the URL for the startup scene (since we do not want to point a URL link to ourself
			$urlToRemove = '<a href="' . $urlWebRoot . $decodedMapName . '.php">' . $decodedMapName . '</a>';
			$myRedirectMenus = str_replace($urlToRemove, "", $myIndexData);
			//fwrite($fd, "URLToRemove: $urlToRemove \n");
			//fwrite($fd, "urlIncludeFile with removed SceneURL: $myRedirectMenus \n");
			
			// write the file
			$myIndex = $myRedirectStartHTML . $myRedirectMenus . $wisenavLogo . $myRedirectEndHTML;


			// 5) check if the HSP has an include file, and if yes, add it to the <head> section
			if ($hspInclude != "") {
				$dataToModify = '</body>';
				$newDataString = $hspInclude . '</body>';
				$finalContent = str_replace($dataToModify, $newDataString, $myIndex);
			} else {
				$finalContent = $myIndex;
			}

			// fwrite($dp, "FINAL: $myIndex \n");
			//fclose($dp);
			$fp = fopen("../../index.html","w+");
			fwrite($fp, $finalContent);  // TODO: handle open and write errors
			fclose($fp);
		}
	}
}
// fclose($fp);
//fclose($fd);
echo "<response><status>". $message ."</status><publishMode>" . $publishMode . "</publishMode><mapname>" . $decodedMapName . "</mapname></response>";
?>