<?php
ini_set("always_populate_raw_post_data", true);

//$log = fopen("c:/temp/removeUnusedResources.txt", "w+");
//fwrite($log, "in removeUnusedResources.php \n");
//fwrite($log, "$HTTP_RAW_POST_DATA \n");
//fclose($log);

/* includes */
include_once 'includes/getDocumentRoot.inc.php';


// global variables
$errorString = "";
$video = "";
$audio = "";
$backgroundImages = "";
$pictures = "";
$animations = "";
$contentRoot = getDocumentRoot();


function addToErrorString($filename) {
	global $errorString, $log;

	if ($errorString == "") {
		$errorString = "The following file(s) could not be removed: " . $filename;
	} else {
		$errorString = $errorString . ", " . $filename;
	}
	// fwrite($log, "Added delete error for file: " . $filename . " \n");

}


// The handler for the XML element opening tags
function startElementHandler($parser, $name, $attr) {
	global $errorString, $video, $audio, $backgroundImages, $pictures, $animations, $contentRoot, $log;

	if (strcmp($name, "RESOURCE") == 0) {
		$filename = $attr["FILENAME"];
		$type = $attr["RESOURCETYPE"];
		$fullPath = "";


		// delete the file
		switch ($type) {
			case "backgroundImage":
				$fullPath = $backgroundImages . $filename;
				break;
			case "picture":
				$fullPath = $pictures . $filename;
				break;
			case "animation":
				$fullPath = $animations . $filename;
				break;
			case "movie":
				$fullPath = $video . $filename;
				break;
			case "audio":
				$fullPath = $audio . $filename;
				break;
			default:
				addToErrorString($filename);
				break;
		}		
		
		if ($fullPath != "") {
			$result = unlink($fullPath);
			if (!$result) { 
				addToErrorString($filename);
			} 
			
			//else {
			//	fwrite($log, "deleted: " . $fullPath . " \n");
			//}
		}

			
		//$startupNode = $attr["STARTUPNODE"];
		//fwrite($log, "oldmap: $oldStartupMap newmap: $startupMap \n");
	} elseif (strcmp($name, "RESOURCES") == 0) {
		$root = $contentRoot . $attr["SITENAME"] . '/';
		$video = $root . "flv/";
		$audio = $root . "audio/";
		$backgroundImages = $root . "images/mapBackgroundImages/";
		$pictures = $root . "images/mapImages/";
		$animations = $root . "swfAnimations/";
	}
}

// The handler for the XML element closing tags
function endElementHandler () {
	// nothing to do in this case
}

// create our XML parser
$parser = xml_parser_create();

// register the start and end element handlers
xml_set_element_handler($parser, "startElementHandler", "endElementHandler");

if (!xml_parse($parser, $HTTP_RAW_POST_DATA, true)) {
	// return XML document with an error message
	$message = "There was an error in the XML line " .
				xml_get_current_line_number($parser) . " at position " .
				xml_get_current_column_number($parser);
	// $message = "parsing error.";
	echo "<response><status>". $message ."</status></response>";
	// fclose($log);
	exit;
}

// finished parsing the XML
xml_parser_free($parser);

if ($errorString == "") {
	$errorString = "success";
}
echo "<response><status>" . $errorString . "</status></response>";

// fclose($log);
?>
