<?php

// rename a Site or rename a Scene

$oldName = "";
$newName = "";
$directory = "";
$isIndex = "false";
$urlWebRoot = "";

ini_set("always_populate_raw_post_data", true);


//$logHandle = fopen("c:/log/renameMap.txt" ,"w");
//fwrite($logHandle, "startup");


// The handler for the XML element opening tags
function startElementHandler($parser, $name, $attr) {
	global  $oldName, $newName, $directory, $isIndex;

	if (strcmp($name, "MAPNODE") == 0) {
		$oldName = $attr["OLDNAME"];
		$newName = $attr["NEWNAME"];
		$directory = $attr["DIRECTORY"];
		$isIndex = $attr["ISINDEX"];
		$urlWebRoot = $attr["URLWEBROOT"];
	}
}

// The handler for the XML element closing tags
function endElementHandler () {
	// nothing to do in this case
}

// create our XML parser
$parser = xml_parser_create();

// register the start and end element handlers
xml_set_element_handler($parser, "startElementHandler", "endElementHandler");

if (!xml_parse($parser, $HTTP_RAW_POST_DATA, true)) {
	// return XML document with an error message
	$message = "There was an error in the XML line " .
				xml_get_current_line_number($parser) . " at position " .
				xml_get_current_column_number($parser);

	echo "<response><status>". $message ."</status></response>";
	exit;
}

// finished parsing the XML
xml_parser_free($parser);

//fwrite($logHandle, "oldName: $oldName newName: $newName dir: $directory \n");

if ($oldName == "" || $newName == "" || $directory == "") {
	$message = "Unexpected error.";
	echo "<response><status>". $message ."</status></response>";
	exit;
}

// create the contentNode
$source = "../" . $directory . "/" . $oldName;
$destination = "../" . $directory . "/" . $newName;
$message = "";

//fwrite($logHandle, "calling copyDirectory, source: " . $source . " dest: " . $destination);
if (rename($source, $destination)) {
	//fwrite($logHandle, "SUCCESS calling rename");

	// also rename the shadow php files
	$oldShadow = "../../" . $oldName . ".php";
	$newShadow = "../../" . $newName . ".php";
	rename($oldShadow, $newShadow);


	// since we change the name of the scene, we must also change the instances of the old
	// name inside the php file to the new name

	// step 1: read the .php file in memory
	$fp = fopen($newShadow,"r");
	$phpContent = fread($fp, filesize($newShadow));
	fclose($fp);

	// step 2: change the title of the page that display in the browser to reflect the new name for the scene
	$stringToChange = '<title>' . $oldName . '</title>';
	$newString = '<title>' . $newName . '</title>';
	$finalContent = str_replace($stringToChange, $newString, $phpContent);

	// step 3: change the name of the scene in the flash object
	$stringToChange = '&startupMap='. $oldName . '&viewerToolbarColor=';
	$newString = '&startupMap='. $newName . '&viewerToolbarColor=';
	//fwrite($logHandle, "new flash object string for replacement: $newString \n");
	$finalContent = str_replace($stringToChange, $newString, $finalContent);			


	// step 4: we need to rename the scene name in the php tag '<?php $myScene="33"';
	$stringToChange = '<?php $myScene="' . $urlWebRoot . $oldName . '";';
	//fwrite($logHandle, "string to change: $stringToChange \n");
	if (strpos($phpContent, $stringToChange) === FALSE) {
		// no changes to do since the php tag is not there
		//fwrite($logHandle, "No php tag to change");
	} else {
		// substitue the new name for the scene
		$newString = '<?php $myScene="' . $urlWebRoot . $newName . '";';
		//fwrite($logHandle, "new string for replacement: $newString \n");
		$finalContent = str_replace($stringToChange, $newString, $finalContent);
	}

	// step 5: write the new content to disk
	$fp = fopen($newShadow,"w+");
	fwrite($fp, $finalContent);
	fclose($fp);
	
	// NOTE: the .inc and .htmlinc files will be rewriten by the sceneMenuManager via a callback
	//       when the client handles the result of this query; it will also handle 
	//       index.html if it requires an update


	
	// TODO: I don't think that this is needed since index.html will be udpated
	//       by sceneMenuManager when calling its function "renameScene"
	// if this is the startup scene in the startup map, also copy to index.html
	//if ($isIndex == "true") {
		// 1) open up the index.html page and read it

		// 2) substitue $oldName for $newName

		// 3) write the new index.html content to disk

		// copy($newShadow, "../../index.html");
	//}
	echo "<response><status>success</status><oldName>" . urlencode($oldName) . "</oldName><newName>" . urlencode($newName) . "</newName></response>";
} else {
	//fwrite($logHandle, "ERROR calling rename");
	$message = "Unable to rename.";
	echo "<response><status>" . $message . "</status></response>";
}

//fclose($logHandle);
?>