<?php
$packageID = $_GET['packageid'];
$chunkid = $_GET['chunkid'];
$urlpath = urldecode($_GET['urlpath']);
// $mycache = $_GET['nocache'];
$httpTarget = $urlpath . "php/packages/" . $packageID . "/chunk_" . $chunkid;


// function to remove a directory; it will remove all the files in the directory
// and is will also recursively remove all sub-directories.  This function is
// needed since the php function "rmdir" only removes a directory if it's empty.
function proxy_rmdir($dirname) {
	// Sanity check
	if (!file_exists($dirname)) {
		return false;
	}

	// Simple delete for a file
	if (is_file($dirname) || is_link($dirname)) {
		return unlink($dirname);
	}

	// Loop through the folder
	$dir = dir($dirname);
	while (false !== $entry = $dir->read()) {
		// Skip pointers
		if ($entry == '.' || $entry == '..') {
			continue;
		}

		// Recurse
		if (!proxy_rmdir($dirname . DIRECTORY_SEPARATOR . $entry)) {
			$dir->close();
			return false;
		}
	}

	// Clean up
	$dir->close();
	return rmdir($dirname);
}



// if we are downloading the first chunck for a template, we first delete the templateChunks directory
// and it's content, and then create a new empty one 
// if the chunk directory does not exist, then exit
if ($chunkid == "1" && is_dir("templateChunks")) {
	if (!proxy_rmdir("templateChunks")) {	
		echo '<chunk status="error" message="Unable to remove old template (chunks) folder."/>';
		exit();
	}
}


// make call to the backend server for the zip file
if (ini_get('allow_url_fopen') == '1') {

	// get the zip File containing the template's content
	$fstring = file_get_contents($httpTarget);
	if ($fstring == FALSE) {
		// TODO: error reading the file, do something... inform the user with ERROR CODE
		// echo '<chunk status="error" message="Unable to retrieve data for the template."/>';
		echo '<chunk status="error" message="Error, httpTarget: ' . $httpTarget . '"/>';
		// echo "Unable to read string content <br>";
		// exit();
	} else {

		// create the templateChunks dir if it does not exist
		if (!Is_dir("templateChunks")) {
			mkdir("templateChunks");
		}

		// write the file to disk
		// echo "Writing string content to disk. <br>";
		$xmlFile = "./templateChunks/" . $packageID . ".zip";
		$fd = fopen($xmlFile, "a");
		$fout = fwrite($fd, $fstring);
		fclose($fd);
		echo '<chunk status="success"/>';
	}
} else {
	// echo '<invalidresponse status="error" message="allow_url_fopen protocol not supported."/>';
	echo '<chunk status="error" message="allow_url_fopen not available."/>';
	//exit();
}

?>