<?php

//*************************
// Save a map file to disk
//*************************

ini_set("always_populate_raw_post_data", true);

$log = "";
//$log = fopen("c:/temp/saveWebServerConfig.txt", "w+");
//fwrite($log, "in saveWebServerConfig.php \n");
//fwrite($log, "$HTTP_RAW_POST_DATA \n");
//fwrite($log, "\nEnd of saveWebServerConfig.php");
//fclose($log);


//location to store the configuration file
$filename = "../../webserverConfig.xml";
//$startupNode = "";   // to take into account when we handle shadow HTML for professional version...
$startupMap = "";
$oldStartupMap = "";
$menuid = "";
$urlWebRoot = "";

// get the HSP include data if it has any
$hspInclude = "";
if (Is_file("./includes/hspInclude.php")) {
include "./includes/hspInclude.php";
} 


// The handler for the XML element opening tags
function startElementHandler($parser, $name, $attr) {
	global $startupMap, $oldStartupMap, $menuid, $urlWebRoot, $log;

	if (strcmp($name, "CONTENTNODE") == 0) {
		$startupMap = $attr["STARTUPMAP"];
		$oldStartupMap = $attr["OLDSTARTUPMAP"];
		$menuid = $attr["MENUID"];
		$urlWebRoot = $attr["URLWEBROOT"];
		//$startupNode = $attr["STARTUPNODE"];
		//fwrite($log, "oldmap: $oldStartupMap newmap: $startupMap \n");
	}
}

// The handler for the XML element closing tags
function endElementHandler () {
	// nothing to do in this case
}

// create our XML parser
$parser = xml_parser_create();

// register the start and end element handlers
xml_set_element_handler($parser, "startElementHandler", "endElementHandler");

if (!xml_parse($parser, $HTTP_RAW_POST_DATA, true)) {
	// return XML document with an error message
	$message = "There was an error in the XML line " .
				xml_get_current_line_number($parser) . " at position " .
				xml_get_current_column_number($parser);
	// $message = "parsing error.";
	echo "<response><status>". $message ."</status></response>";
	exit;
}

// finished parsing the XML
xml_parser_free($parser);

if ($startupMap == "" || $oldStartupMap == "") {
	$message = "Error reading the incomming startup scene information...";
	echo "<response><status>". $message ."</status></response>";
	exit;
}


//we want to overwrite the file on disk
$fp = fopen($filename,"w+");
if (fwrite($fp,$HTTP_RAW_POST_DATA)) {
	fclose($fp);
	$message = "success";

	// if we are changing the startup scene, copy the corresponding shadow HTML page to index.html
	// so that SEO can index it and so that the viewer starts up with the proper HTML page.
	//fwrite($log, " write to index.html; oldmap: $oldStartupMap newmap: $startupMap \n");
	if ($startupMap != $oldStartupMap) {
		$startupScene = urldecode($startupMap);
		$filename = "../../" . $startupScene . ".php";
		if ($menuid == "") {
			// there are no scene menus

			$fp = fopen($filename,"r");
			$phpFileContent = fread($fp, filesize($filename));
			fclose($fp);
			
			// check if there is a include file for the HSP, and if so, add it to the <HEAD> section
			if ($hspInclude != "") {
				$dataToModify = '<script type="text/javascript" src="swfaddress/swfaddress.js"></script>';
				$newDataString = '<script type="text/javascript" src="swfaddress/swfaddress.js"></script>' . $hspInclude;
				$finalContent = str_replace($dataToModify, $newDataString, $phpFileContent);
			} else {
				$finalContent = $phpFileContent;
			}
	
			// 6) write index.html to disk
			$filename = "../../index.html";
			$fp = fopen($filename,"w+");
			fwrite($fp, $finalContent);
			fclose($fp);			
			
			//  so simply copy the php file directly
			// copy($filename, "../../index.html");
		} else {

			// 1) get the URL links for this menuid
			$indexShadowFile = "../../sceneMenuInclude/" . $menuid . ".htmlinc";
			$myIndexData = "";
			$fp = fopen($indexShadowFile,"r");
			$myIndexData = fread($fp, filesize($filename));  // TODO: handle open and write errors
			fclose($fp);

			// 2) remove the URL for the startup scene (since we do not want to point a URL link to ourself)
			$urlToRemove = '<a href="' . $urlWebRoot . $startupScene . '.php">' . $startupScene . '</a>';
			$myURLLinks = str_replace($urlToRemove, "", $myIndexData);

			// 3) load the startup scene php file 
			$filename = "../../" . $startupScene . ".php";
			$fp = fopen($filename,"r");
			$phpContent = fread($fp, filesize($filename));
			fclose($fp);

			// 4) remove the div for "sceneMenu" and add the new div for "sceneMenu
			$phpInclude = '<div id="sceneMenu"><?php $myScene="' . $urlWebRoot . $startupScene . '"; include("./sceneMenuInclude/' . $menuid .'.inc"); ?></div>';

			// make sure that the php tag exists (it could be absent if there was only one scene on the menu)
			if (strpos($phpContent, $phpInclude) === FALSE) {
				// no php tags found, insert the links just before the </body> tag
				$newURLLinks = $myURLLinks . '</body>';
				$divContent = str_replace("</body>", $newURLLinks, $phpContent);
			} else {
				// substitue the URL links for the php tag
				$divContent = str_replace($phpInclude, $myURLLinks, $phpContent);
			}


			// 5) check if the HSP has an include file, and if yes, add it to the <head> section
			if ($hspInclude != "") {
				$dataToModify = '<script type="text/javascript" src="swfaddress/swfaddress.js"></script>';
				$newDataString = '<script type="text/javascript" src="swfaddress/swfaddress.js"></script>' . $hspInclude;
				$finalContent = str_replace($dataToModify, $newDataString, $divContent);
			} else {
				$finalContent = $divContent;
			}
	
			// 6) write index.html to disk
			$filename = "../../index.html";
			$fp = fopen($filename,"w+");
			fwrite($fp, $finalContent);
			fclose($fp);
		}
	}
} else {
	$message = "Error saving the map file!";
	fclose($fp);
}

echo "<response><status>". $message ."</status></response>";
?>