<?php

// SAVE an XML file to disk

/* includes */
include "includes/getDocumentRoot.inc.php";

ini_set("always_populate_raw_post_data", true);

/* page variables */
$message = "";
$debug = 0;
$pageName = "";
$saveDir = "";
$saveMsg = "";

// open file for debug trace
// $fp = fopen("c:/log/saveXML.txt", "w+");
// fwrite($fp, "Start trace for saveXML.php \n");
// fwrite($fp, $HTTP_RAW_POST_DATA);

// The handler for the XML element opening tags
function startElementHandler($parser, $name, $attr) {
	global $pageName, $saveDir, $saveMsg;

	// TODO: change so we all have the save root name when saving (and when reading if the name is important)
	// contactus, coupon, directions, events, Label, interior, logo, custompage, photos
	switch ($name) {
		case "CONFIG":
		case "CONTACTUS":
		case "URLLINK";
		case "SCENELINK":
		case "STARTUPMAP":
		case "SCENEMENUS":
			$pageName = $attr["PAGENAME"];
			$saveDir = $attr["SAVEDIR"];
			$saveMsg = $attr["SAVEMESSAGE"];
			break;
	}
}


// The handler for the XML element closing tags
function endElementHandler () {
	// nothing to do in this case
}

// create our XML parser
$parser = xml_parser_create();

// register the start and end element handlers
xml_set_element_handler($parser, "startElementHandler", "endElementHandler");

if (!xml_parse($parser, $HTTP_RAW_POST_DATA, true)) {
	// return XML document with an error message
	$message = "There was an error in the XML line " .
				xml_get_current_line_number($parser) . " at position " .
				xml_get_current_column_number($parser);

	echo "<response><status>error</status><message>". $message ."</message></response>";
	exit;
}

// finished parsing the XML
xml_parser_free($parser);

if ($pageName == NULL || $pageName == ""|| $saveDir == "" || $saveMsg == "") {
	$message = "Unexpected error (some of the required fields are empty)";
	echo "<response><status>error</status><message>" . $message . "</message></response>";
	exit;
}

// fwrite($fp, "pageName " . $pageName . " \n");
// fwrite($fp, "saveDir " . $saveDir . " \n");
// fwrite($fp, "saveMsg " . $saveMsg . " \n");


// build path to save document
if ($saveDir == "./") {
	$filename = "../../" . $pageName;
} else {
	$filename = "../" . $saveDir . "/" . $pageName;
}
	
//$saveDirectory = "../" . $saveDir;
//$filename = $saveDirectory . "/" . $pageName;

// check if subdirectory is already there, if not create it
$saveDirectory = "../" . $saveDir;
if ($saveDir != "./" && !file_exists($saveDirectory)) {
	mkdir($saveDirectory, 0772);
}

// write file to disk
$fileHandle = fopen($filename, "w+");
if (fwrite($fileHandle, $HTTP_RAW_POST_DATA)) {
	$status = "success";
	$message = $saveMsg;
} else {
	$status = "error";
	$message = "Error saving your file.";
}
fclose($fileHandle);
// fwrite($fp, "status: " . $status . " return message: " . $message);
// fclose($fp);

echo "<response><status>". $status ."</status><message>" . $message . "</message></response>";
?>
