<?php
include "includes/getDocumentRoot.inc.php";

// global variables
$filePath = "";
$method = "";
$fileData = "";

ini_set("always_populate_raw_post_data", true);


// The handler for the XML element opening tags
function startElementHandler($parser, $name, $attr)
{
	global $filePath, $method;

	if (strcmp($name, "WISENAVSERVERFILE") == 0) {
		$filePath = $attr["FILEPATH"];
		$method = $attr["METHOD"];
	}
}

function characterDataHandler($parser, $data)
{
	global $fileData;
	// The append is required - PHP 4 can split the data across multiple calls.
	$fileData .= $data;
}

// The handler for the XML element closing tags
function endElementHandler ()
{
	// nothing to do in this case
}

// Setup the XML parser
$parser = xml_parser_create();
xml_set_element_handler($parser, "startElementHandler", "endElementHandler");
xml_set_character_data_handler($parser, "characterDataHandler");

// Parse the XML
if (!xml_parse($parser, $HTTP_RAW_POST_DATA, true))
{
	// return XML document with an error message

	$message = "There was an error in the XML line " .
	xml_get_current_line_number($parser) . " at position " .
	xml_get_current_column_number($parser);

	echo "<response><status>". $message ."</status></response>";

	exit;
}

xml_parser_free($parser);

if ($filePath == "" || $method == "") {

	$message = "Error reading the incoming map information...";
	echo "<response><status>". $message ."</status></response>";

	exit;
}

$localFile = getDocumentRoot() . $filePath;

switch ($method)
{
	case "write":

		// We want to create/overwrite the xml output from flash.
		$fp = fopen($localFile, "w+");
		if ($fp === false) {

			echo "<response><status>File error</status></response>";
			exit;
		}

		if (fwrite($fp, $fileData)) {
			$message = "success";
		} else {
			$message = "Error saving the map file!";
		}

		echo "<response><status>". $message ."</status></response>";

		break;
	case "read":

		$size = filesize($localFile);
		if ($size === false) {

			echo "<response><status>File error</status></response>";

			exit;
		}

		// We want to create/overwrite the xml output from flash.
		$fp = fopen($localFile, "r");
		if ($fp === false) {

			echo "<response><status>File error</status></response>";

			exit;
		}

		$contents = fread($fp, filesize($localFile));
		if ($contents === false) {
			// Error reading the file.
			echo "<response><status>File error</status></response>";
		} else {
			echo $contents;
		}
		break;
	default:
		break;
}

fclose($fp);
?>
