<?php

// TODO: handle erros and recover where possible, and if not, 
//       return to original state
require_once "dUnzip2.php";
$packageID = $_GET['packageid'];


////////////
// FUNCTIONS
////////////

// function to remove a directory; it will remove all the files in the directory
// and is will also recursively remove all sub-directories.  This function is
// needed since the php function "rmdir" only removes a directory if it's empty.
function proxy_rmdir($dirname) {
	// Sanity check
	if (!file_exists($dirname)) {
		return false;
	}

	// Simple delete for a file
	if (is_file($dirname) || is_link($dirname)) {
		return unlink($dirname);
	}

	// Loop through the folder
	$dir = dir($dirname);
	while (false !== $entry = $dir->read()) {
		// Skip pointers
		if ($entry == '.' || $entry == '..') {
			continue;
		}

		// Recurse
		if (!proxy_rmdir($dirname . DIRECTORY_SEPARATOR . $entry)) {
			$dir->close();
			return false;
		}
	}

	// Clean up
	$dir->close();
	return rmdir($dirname);
}


function restoreOldContent() {
	global $backupIndex, $backupWebserverConfig, $backupSceneMenus;
	proxy_rmdir("./../../content");
	rename($backupIndex, "./../../index.xml");
	rename($backupWebserverConfig, "./../../webserverConfig.xml");
	if (Is_file($backupSceneMenus)) {
		rename($backupSceneMenus, "./../../sceneMenus.xml");
	}
}


///////////
// STARTUP
///////////



// NOTE: maybe put up a temporary index.html file that says that the site is down for 1 minutes for an update,
//       and ask the user to return in 1 minute

// if the chunk directory does not exist, then exit
if (!Is_dir("templateChunks")) {
	echo '<chunk status="Error, temporary \"templateChunks\" directory does not exist."/>';
	exit();
}

// change to the "templateChunks" directory
$initialDir = getcwd();
if (!chdir("templateChunks")) {
	echo '<chunk status="Error, unable to change to the temporary \"templateChunks\" directory."/>';	
	exit();
}

// when we unzip, the "content" dir is created, so if one already exists, delete it
if (Is_dir("content")) {
	if (!proxy_rmdir("content")) {
		echo '<chunk status="Error, unable to remove old content directory."/>';
		chdir($initialDir);
		exit;
	}
}

// unzip the file
$zipFile = $packageID . ".zip";
$zip = new dUnzip2($zipFile);
$zip->unzipAll("./");
$zip->close();


// now delete the zip file
if (!unlink($zipFile)) {
	proxy_rmdir("content");  // remove unziped content directory
	chdir($initialDir);
	echo '<chunk status="Error, unable to remove compressed file."/>';
	exit();
}

if (!Is_dir("content")) {
	chdir($initialDir);
	echo '<chunk status="Error, content directory does not exist."/>';
	exit();
}

// return to the php directory
if (!chdir($initialDir)) {
	echo '<chunk status="Error, unable to return to php directory."/>';
	exit();
}


// rename the old content folder to a temporary directory
$tempDir = "./templateChunks/contentBefore" . $packageID;
if (!rename("./../../content", $tempDir)) {
	echo '<chunk status="Error, unable to rename old content directory."/>';
	proxy_rmdir("./templateChunks/content");
	exit();
}

// move the new content folder
if (!rename("./templateChunks/content", "./../../content")) {
	proxy_rmdir("./templateChunks/content");
	rename($tempDir, "./../../content");
	echo '<chunk status="Error, unable to move new content directory."/>';	
	exit();
}


// move the old files for index.html, webserverConfig.xml and sceneMenus.xml to the temporary directory
$backupIndex = "./templateChunks/contentBefore" . $packageID . "/index.html";
$backupWebserverConfig = "./templateChunks/contentBefore" . $packageID . "/webserverConfig.xml";
$backupSceneMenus = "./templateChunks/contentBefore" . $packageID . "/sceneMenus.xml";
if (!rename("./../../index.html", $backupIndex)) {
	proxy_rmdir("./../../content");
	rename($tempDir, "./../../content");
	echo '<chunk status="Error, unable to rename old index file."/>';
	exit();
}
if (!rename("./../../webserverConfig.xml", $backupWebserverConfig)) {
	echo '<chunk status="Error, unable to rename old webserverConfig file."/>';
	rename($backupIndex, "./../../index.html");
	proxy_rmdir("./../../content");
	rename($tempDir, "./../../content");
	exit();
}
if (Is_file("./../../sceneMenus.xml")) {
	if (!rename("./../../sceneMenus.xml", $backupSceneMenus)) {
		echo '<chunk status="Error, unable to rename old sceneMenus file."/>';
		rename($backupIndex, "./../../index.html");
		rename($backupWebserverConfig, "./../../webserverConfig.xml");
		proxy_rmdir("./../../content");
		rename($tempDir, "./../../content");
		exit();
	}
}

// move the new index.html, webserverConfig.xml and sceneMenus.xml
if (!rename("./../../content/index.html", "./../../index.html")) {
	echo '<chunk status="Error, unable to move new index file."/>';
	restoreOldContent();
	exit();
}
if (!rename("./../../content/webserverConfig.xml", "./../../webserverConfig.xml")) {
	echo '<chunk status="Error, unable to move new webserverConfig file."/>';	
	unlink("./../../index.html");
	restoreOldContent();
	exit();
}
if (Is_file("./../../content/sceneMenus.xml")) {
	if (!rename("./../../content/sceneMenus.xml", "./../../sceneMenus.xml")) {
		echo '<chunk status="Error, unable to move new sceneMenus file."/>';	
		unlink("./../../index.html");
		unlink("./../../webserverConfig.xml");
		restoreOldContent();
		exit();
	}
}

// now delete the old content folder
if (!proxy_rmdir($tempDir)) {	
	echo '<chunk status="Unable to remove old content folder, but the new template was successfully installed."/>';
	exit();
}

if (is_dir("./../../sceneMenuInclude")) {
	if (!proxy_rmdir("./../../sceneMenuInclude")) {	
		echo '<chunk status="Unable to remove old scene menu folder, but the new template was successfully installed."/>';
		exit();
	}
}
mkdir("./../../sceneMenuInclude");

// successfully downloaded and installed the template
echo '<chunk status="success"/>';

?>