<?php
// write the index.html file to disk


ini_set("always_populate_raw_post_data", true);

// DEBUG ONLY, print raw content to file for debuging
//$dp = fopen("../../html/sceneRaw.xml", "w+");
//fwrite($dp,$HTTP_RAW_POST_DATA);
//fclose($dp);

$sceneName = "";
$menuid = "";
$phpContent = "";
$urlContent = "";

// The handler for the XML element opening tags
function startElementHandler($parser, $name, $attr) {
	global $sceneName, $menuid;

	if (strcmp($name, "INDEXHTML") == 0) {
		$sceneName = $attr["SITENAME"];
		$menuid = $attr["MENUID"];
	}
}

// The handler for the XML element closing tags
function endElementHandler () {
	// nothing to do in this case
}

// create our XML parser
$parser = xml_parser_create();

// register the start and end element handlers
xml_set_element_handler($parser, "startElementHandler", "endElementHandler");

if (!xml_parse($parser, $HTTP_RAW_POST_DATA, true)) {
	// return XML document with an error message
	$message = "There was an error in the XML line " .
				xml_get_current_line_number($parser) . " at position " .
				xml_get_current_column_number($parser);
	// $message = "parsing error.";
	echo "<response><status>". $message ."</status></response>";
	exit;
}

// finished parsing the XML
xml_parser_free($parser);

if ($sceneName == "") {
	$message = "Error reading the incomming map information...";
	echo "<response><status>". $message ."</status></response>";
	exit;
}

// step 1: open the corresponding php shadow file and read in memory
$filename = "../../" . $sceneName . ".php";
$fp = fopen($filename,"w+");
fread($fp, $phpcontent);
fclose($fp);

// step 2:  read the index include file and get the URL links
if ($menuid == "") {
	$finalURL = "";
else {
	// get the URL links for the scene menu
	$filename = "../../sceneMenuInclude/" . $menuid . ".htmlinc";
	$fp = fopen($filename,"r");
	fread($fp, $urlContent);
	fclose($fp);

	// remove the URL for the startup scene (since we do not want to point a URL link to ourself
	$urlToRemove = '<a href="' . $sceneName . '.php">' . $sceneName . '</a>';
	$finalURL = str_replace($urlToRemove, "", $urlContent);
} 

// step 3: substitue the URL links for the php include
$phpInclude = '<?php $myScene="' . $sceneName . '"; include("./sceneMenuInclude/' . $menuid .'.inc"); ?>';
$finalContent = str_replace($phpInclude, $finalURL, $phpContent);

// step 4:  write the file to disk
$filename = "../../index.html";
$fp = fopen($filename,"w+");
fread($fp, $finalContent);
fclose($fp);


// TODO: return message
?>