#!/usr/bin/perl
# Mod_Frontpage configuration script
# (C) 2001 Jean-Michel Dault and Mandrakesoft
# You can use it according to the Apache licence
# Please send modifications to: <jmdault@mandrakesoft.com> and
# mbr@freebsd.org so modules can benefit from it!
#
# Modified for the FreeBSD ports system and to work with
# FP extensions 5.0 from Martin Blapp <mbr@freebsd.org>
#
$thechoice="/usr/local/sbin/httpd";
print "\nLet's see if it's a valid httpd...";
$_=`$thechoice -v`;
if (/Server version:/) { print " YES!\n"; 
} else {die "\n\nSorry, can't find Apache version!\n"; }

$httpd=$thechoice;
$thechoice=~s|/httpd||;

print "sbindir is $thechoice, trying to find apxs...";

$sbindir=$thechoice;
$apxs="$thechoice/apxs";
$apachectl="$thechoice/apachectl";
$_=`file $apxs`;
if (/can't stat/) {die "\nSorry, can't find $apxs\n";}
print "Found!\n";

$confdir=`$apxs -q SYSCONFDIR`; 
print "Config directory: $confdir\n";
$cc=`$apxs -q CC`;
print "Compiler: $cc\n";
$cflags=`$apxs -q CFLAGS`;
print "CFLAGS: $cflags\n";
$includedir=`$apxs -q INCLUDEDIR`;
print "Include directory: $includedir\n";
$libexecdir=`$apxs -q LIBEXECDIR`;
print "Libexecdir: $libexecdir\n";
print "\n";
$httpdconf="$confdir/httpd.conf";
open(FILE,"$httpdconf") or die "Can't find $httpdconf!\n";
print "Reading httpd.conf...\n";
while(<FILE>) {
    if (!$user && /^User (\w*)/) {
	$user=$1;
    }
    if (!$group && /^Group (\w*)/) {
	$group=$1;
    }
    if (!$userdir && /^UserDir (\w*)/) {
	$userdir=$1;
    }
    if (!$serverroot && /^ServerRoot (\S*)/) {
	$serverroot=$1;
    }
    if (!$errorlog && /^ErrorLog (\S*)/) {
	$errorlog=$1;
	$errorlog=~ s/error/fpexec/;
    }
    if (!$documentroot && /^DocumentRoot (\S*)/) {
	$documentroot=$1;
    }
}
close(FILE);
print "Apache user, group: $user, $group\n";
print "Userdir: $userdir\n";
print "ServerRoot: $serverroot\n";
print "ErrorLog: $errorlog\n";
$_=$errorlog;
if (/^\//) { 
    print "ErrorLog is absolute\n";
} else {
    print "ErrorLog was relative, expanded to ";
    $errorlog="$serverroot/$errorlog";
    print "$errorlog\n";
}
print "DocumentRoot: $documentroot\n";

$webdir = $documentroot;
$webdir =~ s/"//g;
($uid, $gid) = (stat $webdir)[4,5];
print "Content uid, gid: $uid, $gid\n";

#
# User "www" in FreeBSD has user 80, gid 80 
#
if ($uid < 80) {
    print "UID too low! Using default value 100\n";
    $uid=100;
}
if ($gid < 80) {
    print "GID too low! Using default value 100\n";
    $gid=100;
}


### Create Makefile
$install=`which install`;
chop $install;
open(MTMP,"Makefile.in") or die "Can't find Makefile.tmpl\n";
open(MAKF,"> Makefile") or die "Can't create Makefile\n";
print "Creating Makefile\n";
while(<MTMP>) {
$_=~ s|\$\(apxs\)|$apxs|;
$_=~ s|\$\(apachectl\)|$apachectl|;
$_=~ s|\$\(cc\)|$cc|;
$_=~ s|\$\(includedir\)|$includedir|;
$_=~ s|\$\(cflags\)|$cflags|;
$_=~ s|\$\(sbindir\)|$sbindir|;
$_=~ s|\$\(install\)|$install|;
#$_=~ s|\$\(\)|$|;
#$_=~ s|\$\(\)|$|;
$_=~ s|\$\(fpexec_caller\)|$user|;
$_=~ s|\$\(fpexec_uidmin\)|$uid|;
$_=~ s|\$\(fpexec_gidmin\)|$gid|;
$_=~ s|\$\(fpexec_logexec\)|$errorlog|;
$_=~ s|\$\(fpexec_userdir\)|$userdir|;
$_=~ s|\$\(fpexec_docroot\)|$documentroot|;
$_=~ s|"\$\(fpexec_bin\)|\\\\\"$sbindir\/fpexec\\\\|;
$_=~ s|"\$\(fpstatic_bin\)|\\\\\"$sbindir\/fpstatic\\\\|;
$_=~ s|\$\(httpdconf\)|$httpdconf|;
$_=~ s|\$\(libexecdir\)|$libexecdir|;
$_=~ s|root.root|root:wheel|;
print MAKF $_;
}
