/*****************************************************************************
*    Open LiteSpeed is an open source HTTP server.                           *
*    Copyright (C) 2013 - 2015  LiteSpeed Technologies, Inc.                 *
*                                                                            *
*    This program is free software: you can redistribute it and/or modify    *
*    it under the terms of the GNU General Public License as published by    *
*    the Free Software Foundation, either version 3 of the License, or       *
*    (at your option) any later version.                                     *
*                                                                            *
*    This program is distributed in the hope that it will be useful,         *
*    but WITHOUT ANY WARRANTY; without even the implied warranty of          *
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the            *
*    GNU General Public License for more details.                            *
*                                                                            *
*    You should have received a copy of the GNU General Public License       *
*    along with this program. If not, see http://www.gnu.org/licenses/.      *
*****************************************************************************/
#include <lsr/ls_crc64.h>

#ifndef UINT64_C
#   define UINT64_C(c)   (c ## ULL)
#endif

#ifdef WORDS_BIGENDIAN
// byteswap.h is a GNU extension. It contains inline assembly versions
// for byteswapping. When byteswap.h is not available, we use generic code.
#define HAVE_BYTESWAP_H
#ifdef HAVE_BYTESWAP_H
#   include <byteswap.h>
#else
#   define bswap_32(num) \
    ( (((num) << 24)                       ) \
      | (((num) <<  8) & UINT32_C(0x00FF0000)) \
      | (((num) >>  8) & UINT32_C(0x0000FF00)) \
      | (((num) >> 24)                       ) )

#   define bswap_64(num) \
    ( (((num) << 56)                               ) \
      | (((num) << 40) & UINT64_C(0x00FF000000000000)) \
      | (((num) << 24) & UINT64_C(0x0000FF0000000000)) \
      | (((num) <<  8) & UINT64_C(0x000000FF00000000)) \
      | (((num) >>  8) & UINT64_C(0x00000000FF000000)) \
      | (((num) >> 24) & UINT64_C(0x0000000000FF0000)) \
      | (((num) >> 40) & UINT64_C(0x000000000000FF00)) \
      | (((num) >> 56)                               ) )
#endif
#   define A1(x) ((x) >> 56)
#   define A(x) ((x) >> 24)
#   define B(x) (((x) >> 16) & 0xFF)
#   define C(x) (((x) >> 8) & 0xFF)
#   define D(x) ((x) & 0xFF)
#   define S8(x) ((x) << 8)
#   define S32(x) ((x) << 32)

/* This file has been automatically generated by crc64_tablegen.c. */
const uint64_t ls_crc64_table[4][256] =
{
    {
        UINT64_C(0x0000000000000000), UINT64_C(0x6F5FA703BE4C2EB3),
        UINT64_C(0x5BA040A8573684F4), UINT64_C(0x34FFE7ABE97AAA47),
        UINT64_C(0x335E8FFF84C3D07B), UINT64_C(0x5C0128FC3A8FFEC8),
        UINT64_C(0x68FECF57D3F5548F), UINT64_C(0x07A168546DB97A3C),
        UINT64_C(0x66BC1EFF0987A1F7), UINT64_C(0x09E3B9FCB7CB8F44),
        UINT64_C(0x3D1C5E575EB12503), UINT64_C(0x5243F954E0FD0BB0),
        UINT64_C(0x55E291008D44718C), UINT64_C(0x3ABD360333085F3F),
        UINT64_C(0x0E42D1A8DA72F578), UINT64_C(0x611D76AB643EDBCB),
        UINT64_C(0x4966335138A19B7D), UINT64_C(0x2639945286EDB5CE),
        UINT64_C(0x12C673F96F971F89), UINT64_C(0x7D99D4FAD1DB313A),
        UINT64_C(0x7A38BCAEBC624B06), UINT64_C(0x15671BAD022E65B5),
        UINT64_C(0x2198FC06EB54CFF2), UINT64_C(0x4EC75B055518E141),
        UINT64_C(0x2FDA2DAE31263A8A), UINT64_C(0x40858AAD8F6A1439),
        UINT64_C(0x747A6D066610BE7E), UINT64_C(0x1B25CA05D85C90CD),
        UINT64_C(0x1C84A251B5E5EAF1), UINT64_C(0x73DB05520BA9C442),
        UINT64_C(0x4724E2F9E2D36E05), UINT64_C(0x287B45FA5C9F40B6),
        UINT64_C(0x92CC66A2704237FB), UINT64_C(0xFD93C1A1CE0E1948),
        UINT64_C(0xC96C260A2774B30F), UINT64_C(0xA633810999389DBC),
        UINT64_C(0xA192E95DF481E780), UINT64_C(0xCECD4E5E4ACDC933),
        UINT64_C(0xFA32A9F5A3B76374), UINT64_C(0x956D0EF61DFB4DC7),
        UINT64_C(0xF470785D79C5960C), UINT64_C(0x9B2FDF5EC789B8BF),
        UINT64_C(0xAFD038F52EF312F8), UINT64_C(0xC08F9FF690BF3C4B),
        UINT64_C(0xC72EF7A2FD064677), UINT64_C(0xA87150A1434A68C4),
        UINT64_C(0x9C8EB70AAA30C283), UINT64_C(0xF3D11009147CEC30),
        UINT64_C(0xDBAA55F348E3AC86), UINT64_C(0xB4F5F2F0F6AF8235),
        UINT64_C(0x800A155B1FD52872), UINT64_C(0xEF55B258A19906C1),
        UINT64_C(0xE8F4DA0CCC207CFD), UINT64_C(0x87AB7D0F726C524E),
        UINT64_C(0xB3549AA49B16F809), UINT64_C(0xDC0B3DA7255AD6BA),
        UINT64_C(0xBD164B0C41640D71), UINT64_C(0xD249EC0FFF2823C2),
        UINT64_C(0xE6B60BA416528985), UINT64_C(0x89E9ACA7A81EA736),
        UINT64_C(0x8E48C4F3C5A7DD0A), UINT64_C(0xE11763F07BEBF3B9),
        UINT64_C(0xD5E8845B929159FE), UINT64_C(0xBAB723582CDD774D),
        UINT64_C(0xA187C3EBCA2BB664), UINT64_C(0xCED864E8746798D7),
        UINT64_C(0xFA2783439D1D3290), UINT64_C(0x9578244023511C23),
        UINT64_C(0x92D94C144EE8661F), UINT64_C(0xFD86EB17F0A448AC),
        UINT64_C(0xC9790CBC19DEE2EB), UINT64_C(0xA626ABBFA792CC58),
        UINT64_C(0xC73BDD14C3AC1793), UINT64_C(0xA8647A177DE03920),
        UINT64_C(0x9C9B9DBC949A9367), UINT64_C(0xF3C43ABF2AD6BDD4),
        UINT64_C(0xF46552EB476FC7E8), UINT64_C(0x9B3AF5E8F923E95B),
        UINT64_C(0xAFC512431059431C), UINT64_C(0xC09AB540AE156DAF),
        UINT64_C(0xE8E1F0BAF28A2D19), UINT64_C(0x87BE57B94CC603AA),
        UINT64_C(0xB341B012A5BCA9ED), UINT64_C(0xDC1E17111BF0875E),
        UINT64_C(0xDBBF7F457649FD62), UINT64_C(0xB4E0D846C805D3D1),
        UINT64_C(0x801F3FED217F7996), UINT64_C(0xEF4098EE9F335725),
        UINT64_C(0x8E5DEE45FB0D8CEE), UINT64_C(0xE10249464541A25D),
        UINT64_C(0xD5FDAEEDAC3B081A), UINT64_C(0xBAA209EE127726A9),
        UINT64_C(0xBD0361BA7FCE5C95), UINT64_C(0xD25CC6B9C1827226),
        UINT64_C(0xE6A3211228F8D861), UINT64_C(0x89FC861196B4F6D2),
        UINT64_C(0x334BA549BA69819F), UINT64_C(0x5C14024A0425AF2C),
        UINT64_C(0x68EBE5E1ED5F056B), UINT64_C(0x07B442E253132BD8),
        UINT64_C(0x00152AB63EAA51E4), UINT64_C(0x6F4A8DB580E67F57),
        UINT64_C(0x5BB56A1E699CD510), UINT64_C(0x34EACD1DD7D0FBA3),
        UINT64_C(0x55F7BBB6B3EE2068), UINT64_C(0x3AA81CB50DA20EDB),
        UINT64_C(0x0E57FB1EE4D8A49C), UINT64_C(0x61085C1D5A948A2F),
        UINT64_C(0x66A93449372DF013), UINT64_C(0x09F6934A8961DEA0),
        UINT64_C(0x3D0974E1601B74E7), UINT64_C(0x5256D3E2DE575A54),
        UINT64_C(0x7A2D961882C81AE2), UINT64_C(0x1572311B3C843451),
        UINT64_C(0x218DD6B0D5FE9E16), UINT64_C(0x4ED271B36BB2B0A5),
        UINT64_C(0x497319E7060BCA99), UINT64_C(0x262CBEE4B847E42A),
        UINT64_C(0x12D3594F513D4E6D), UINT64_C(0x7D8CFE4CEF7160DE),
        UINT64_C(0x1C9188E78B4FBB15), UINT64_C(0x73CE2FE4350395A6),
        UINT64_C(0x4731C84FDC793FE1), UINT64_C(0x286E6F4C62351152),
        UINT64_C(0x2FCF07180F8C6B6E), UINT64_C(0x4090A01BB1C045DD),
        UINT64_C(0x746F47B058BAEF9A), UINT64_C(0x1B30E0B3E6F6C129),
        UINT64_C(0x420F87D795576CC9), UINT64_C(0x2D5020D42B1B427A),
        UINT64_C(0x19AFC77FC261E83D), UINT64_C(0x76F0607C7C2DC68E),
        UINT64_C(0x715108281194BCB2), UINT64_C(0x1E0EAF2BAFD89201),
        UINT64_C(0x2AF1488046A23846), UINT64_C(0x45AEEF83F8EE16F5),
        UINT64_C(0x24B399289CD0CD3E), UINT64_C(0x4BEC3E2B229CE38D),
        UINT64_C(0x7F13D980CBE649CA), UINT64_C(0x104C7E8375AA6779),
        UINT64_C(0x17ED16D718131D45), UINT64_C(0x78B2B1D4A65F33F6),
        UINT64_C(0x4C4D567F4F2599B1), UINT64_C(0x2312F17CF169B702),
        UINT64_C(0x0B69B486ADF6F7B4), UINT64_C(0x6436138513BAD907),
        UINT64_C(0x50C9F42EFAC07340), UINT64_C(0x3F96532D448C5DF3),
        UINT64_C(0x38373B79293527CF), UINT64_C(0x57689C7A9779097C),
        UINT64_C(0x63977BD17E03A33B), UINT64_C(0x0CC8DCD2C04F8D88),
        UINT64_C(0x6DD5AA79A4715643), UINT64_C(0x028A0D7A1A3D78F0),
        UINT64_C(0x3675EAD1F347D2B7), UINT64_C(0x592A4DD24D0BFC04),
        UINT64_C(0x5E8B258620B28638), UINT64_C(0x31D482859EFEA88B),
        UINT64_C(0x052B652E778402CC), UINT64_C(0x6A74C22DC9C82C7F),
        UINT64_C(0xD0C3E175E5155B32), UINT64_C(0xBF9C46765B597581),
        UINT64_C(0x8B63A1DDB223DFC6), UINT64_C(0xE43C06DE0C6FF175),
        UINT64_C(0xE39D6E8A61D68B49), UINT64_C(0x8CC2C989DF9AA5FA),
        UINT64_C(0xB83D2E2236E00FBD), UINT64_C(0xD762892188AC210E),
        UINT64_C(0xB67FFF8AEC92FAC5), UINT64_C(0xD920588952DED476),
        UINT64_C(0xEDDFBF22BBA47E31), UINT64_C(0x8280182105E85082),
        UINT64_C(0x8521707568512ABE), UINT64_C(0xEA7ED776D61D040D),
        UINT64_C(0xDE8130DD3F67AE4A), UINT64_C(0xB1DE97DE812B80F9),
        UINT64_C(0x99A5D224DDB4C04F), UINT64_C(0xF6FA752763F8EEFC),
        UINT64_C(0xC205928C8A8244BB), UINT64_C(0xAD5A358F34CE6A08),
        UINT64_C(0xAAFB5DDB59771034), UINT64_C(0xC5A4FAD8E73B3E87),
        UINT64_C(0xF15B1D730E4194C0), UINT64_C(0x9E04BA70B00DBA73),
        UINT64_C(0xFF19CCDBD43361B8), UINT64_C(0x90466BD86A7F4F0B),
        UINT64_C(0xA4B98C738305E54C), UINT64_C(0xCBE62B703D49CBFF),
        UINT64_C(0xCC47432450F0B1C3), UINT64_C(0xA318E427EEBC9F70),
        UINT64_C(0x97E7038C07C63537), UINT64_C(0xF8B8A48FB98A1B84),
        UINT64_C(0xE388443C5F7CDAAD), UINT64_C(0x8CD7E33FE130F41E),
        UINT64_C(0xB8280494084A5E59), UINT64_C(0xD777A397B60670EA),
        UINT64_C(0xD0D6CBC3DBBF0AD6), UINT64_C(0xBF896CC065F32465),
        UINT64_C(0x8B768B6B8C898E22), UINT64_C(0xE4292C6832C5A091),
        UINT64_C(0x85345AC356FB7B5A), UINT64_C(0xEA6BFDC0E8B755E9),
        UINT64_C(0xDE941A6B01CDFFAE), UINT64_C(0xB1CBBD68BF81D11D),
        UINT64_C(0xB66AD53CD238AB21), UINT64_C(0xD935723F6C748592),
        UINT64_C(0xEDCA9594850E2FD5), UINT64_C(0x829532973B420166),
        UINT64_C(0xAAEE776D67DD41D0), UINT64_C(0xC5B1D06ED9916F63),
        UINT64_C(0xF14E37C530EBC524), UINT64_C(0x9E1190C68EA7EB97),
        UINT64_C(0x99B0F892E31E91AB), UINT64_C(0xF6EF5F915D52BF18),
        UINT64_C(0xC210B83AB428155F), UINT64_C(0xAD4F1F390A643BEC),
        UINT64_C(0xCC5269926E5AE027), UINT64_C(0xA30DCE91D016CE94),
        UINT64_C(0x97F2293A396C64D3), UINT64_C(0xF8AD8E3987204A60),
        UINT64_C(0xFF0CE66DEA99305C), UINT64_C(0x9053416E54D51EEF),
        UINT64_C(0xA4ACA6C5BDAFB4A8), UINT64_C(0xCBF301C603E39A1B),
        UINT64_C(0x7144229E2F3EED56), UINT64_C(0x1E1B859D9172C3E5),
        UINT64_C(0x2AE46236780869A2), UINT64_C(0x45BBC535C6444711),
        UINT64_C(0x421AAD61ABFD3D2D), UINT64_C(0x2D450A6215B1139E),
        UINT64_C(0x19BAEDC9FCCBB9D9), UINT64_C(0x76E54ACA4287976A),
        UINT64_C(0x17F83C6126B94CA1), UINT64_C(0x78A79B6298F56212),
        UINT64_C(0x4C587CC9718FC855), UINT64_C(0x2307DBCACFC3E6E6),
        UINT64_C(0x24A6B39EA27A9CDA), UINT64_C(0x4BF9149D1C36B269),
        UINT64_C(0x7F06F336F54C182E), UINT64_C(0x105954354B00369D),
        UINT64_C(0x382211CF179F762B), UINT64_C(0x577DB6CCA9D35898),
        UINT64_C(0x6382516740A9F2DF), UINT64_C(0x0CDDF664FEE5DC6C),
        UINT64_C(0x0B7C9E30935CA650), UINT64_C(0x642339332D1088E3),
        UINT64_C(0x50DCDE98C46A22A4), UINT64_C(0x3F83799B7A260C17),
        UINT64_C(0x5E9E0F301E18D7DC), UINT64_C(0x31C1A833A054F96F),
        UINT64_C(0x053E4F98492E5328), UINT64_C(0x6A61E89BF7627D9B),
        UINT64_C(0x6DC080CF9ADB07A7), UINT64_C(0x029F27CC24972914),
        UINT64_C(0x3660C067CDED8353), UINT64_C(0x593F676473A1ADE0)
    }, {
        UINT64_C(0x0000000000000000), UINT64_C(0x0DF1D05C9279E954),
        UINT64_C(0x1AE2A1B924F3D2A9), UINT64_C(0x171371E5B68A3BFD),
        UINT64_C(0xB1DA4DDC62497DC1), UINT64_C(0xBC2B9D80F0309495),
        UINT64_C(0xAB38EC6546BAAF68), UINT64_C(0xA6C93C39D4C3463C),
        UINT64_C(0xE7AB9517EE3D2210), UINT64_C(0xEA5A454B7C44CB44),
        UINT64_C(0xFD4934AECACEF0B9), UINT64_C(0xF0B8E4F258B719ED),
        UINT64_C(0x5671D8CB8C745FD1), UINT64_C(0x5B8008971E0DB685),
        UINT64_C(0x4C937972A8878D78), UINT64_C(0x4162A92E3AFE642C),
        UINT64_C(0xCE572B2FDC7B4420), UINT64_C(0xC3A6FB734E02AD74),
        UINT64_C(0xD4B58A96F8889689), UINT64_C(0xD9445ACA6AF17FDD),
        UINT64_C(0x7F8D66F3BE3239E1), UINT64_C(0x727CB6AF2C4BD0B5),
        UINT64_C(0x656FC74A9AC1EB48), UINT64_C(0x689E171608B8021C),
        UINT64_C(0x29FCBE3832466630), UINT64_C(0x240D6E64A03F8F64),
        UINT64_C(0x331E1F8116B5B499), UINT64_C(0x3EEFCFDD84CC5DCD),
        UINT64_C(0x9826F3E4500F1BF1), UINT64_C(0x95D723B8C276F2A5),
        UINT64_C(0x82C4525D74FCC958), UINT64_C(0x8F358201E685200C),
        UINT64_C(0x9CAF565EB8F78840), UINT64_C(0x915E86022A8E6114),
        UINT64_C(0x864DF7E79C045AE9), UINT64_C(0x8BBC27BB0E7DB3BD),
        UINT64_C(0x2D751B82DABEF581), UINT64_C(0x2084CBDE48C71CD5),
        UINT64_C(0x3797BA3BFE4D2728), UINT64_C(0x3A666A676C34CE7C),
        UINT64_C(0x7B04C34956CAAA50), UINT64_C(0x76F51315C4B34304),
        UINT64_C(0x61E662F0723978F9), UINT64_C(0x6C17B2ACE04091AD),
        UINT64_C(0xCADE8E953483D791), UINT64_C(0xC72F5EC9A6FA3EC5),
        UINT64_C(0xD03C2F2C10700538), UINT64_C(0xDDCDFF708209EC6C),
        UINT64_C(0x52F87D71648CCC60), UINT64_C(0x5F09AD2DF6F52534),
        UINT64_C(0x481ADCC8407F1EC9), UINT64_C(0x45EB0C94D206F79D),
        UINT64_C(0xE32230AD06C5B1A1), UINT64_C(0xEED3E0F194BC58F5),
        UINT64_C(0xF9C0911422366308), UINT64_C(0xF4314148B04F8A5C),
        UINT64_C(0xB553E8668AB1EE70), UINT64_C(0xB8A2383A18C80724),
        UINT64_C(0xAFB149DFAE423CD9), UINT64_C(0xA24099833C3BD58D),
        UINT64_C(0x0489A5BAE8F893B1), UINT64_C(0x097875E67A817AE5),
        UINT64_C(0x1E6B0403CC0B4118), UINT64_C(0x139AD45F5E72A84C),
        UINT64_C(0x385FADBC70EF1181), UINT64_C(0x35AE7DE0E296F8D5),
        UINT64_C(0x22BD0C05541CC328), UINT64_C(0x2F4CDC59C6652A7C),
        UINT64_C(0x8985E06012A66C40), UINT64_C(0x8474303C80DF8514),
        UINT64_C(0x936741D93655BEE9), UINT64_C(0x9E969185A42C57BD),
        UINT64_C(0xDFF438AB9ED23391), UINT64_C(0xD205E8F70CABDAC5),
        UINT64_C(0xC5169912BA21E138), UINT64_C(0xC8E7494E2858086C),
        UINT64_C(0x6E2E7577FC9B4E50), UINT64_C(0x63DFA52B6EE2A704),
        UINT64_C(0x74CCD4CED8689CF9), UINT64_C(0x793D04924A1175AD),
        UINT64_C(0xF6088693AC9455A1), UINT64_C(0xFBF956CF3EEDBCF5),
        UINT64_C(0xECEA272A88678708), UINT64_C(0xE11BF7761A1E6E5C),
        UINT64_C(0x47D2CB4FCEDD2860), UINT64_C(0x4A231B135CA4C134),
        UINT64_C(0x5D306AF6EA2EFAC9), UINT64_C(0x50C1BAAA7857139D),
        UINT64_C(0x11A3138442A977B1), UINT64_C(0x1C52C3D8D0D09EE5),
        UINT64_C(0x0B41B23D665AA518), UINT64_C(0x06B06261F4234C4C),
        UINT64_C(0xA0795E5820E00A70), UINT64_C(0xAD888E04B299E324),
        UINT64_C(0xBA9BFFE10413D8D9), UINT64_C(0xB76A2FBD966A318D),
        UINT64_C(0xA4F0FBE2C81899C1), UINT64_C(0xA9012BBE5A617095),
        UINT64_C(0xBE125A5BECEB4B68), UINT64_C(0xB3E38A077E92A23C),
        UINT64_C(0x152AB63EAA51E400), UINT64_C(0x18DB666238280D54),
        UINT64_C(0x0FC817878EA236A9), UINT64_C(0x0239C7DB1CDBDFFD),
        UINT64_C(0x435B6EF52625BBD1), UINT64_C(0x4EAABEA9B45C5285),
        UINT64_C(0x59B9CF4C02D66978), UINT64_C(0x54481F1090AF802C),
        UINT64_C(0xF2812329446CC610), UINT64_C(0xFF70F375D6152F44),
        UINT64_C(0xE8638290609F14B9), UINT64_C(0xE59252CCF2E6FDED),
        UINT64_C(0x6AA7D0CD1463DDE1), UINT64_C(0x67560091861A34B5),
        UINT64_C(0x7045717430900F48), UINT64_C(0x7DB4A128A2E9E61C),
        UINT64_C(0xDB7D9D11762AA020), UINT64_C(0xD68C4D4DE4534974),
        UINT64_C(0xC19F3CA852D97289), UINT64_C(0xCC6EECF4C0A09BDD),
        UINT64_C(0x8D0C45DAFA5EFFF1), UINT64_C(0x80FD9586682716A5),
        UINT64_C(0x97EEE463DEAD2D58), UINT64_C(0x9A1F343F4CD4C40C),
        UINT64_C(0x3CD6080698178230), UINT64_C(0x3127D85A0A6E6B64),
        UINT64_C(0x2634A9BFBCE45099), UINT64_C(0x2BC579E32E9DB9CD),
        UINT64_C(0xF5A054D6CA71FB90), UINT64_C(0xF851848A580812C4),
        UINT64_C(0xEF42F56FEE822939), UINT64_C(0xE2B325337CFBC06D),
        UINT64_C(0x447A190AA8388651), UINT64_C(0x498BC9563A416F05),
        UINT64_C(0x5E98B8B38CCB54F8), UINT64_C(0x536968EF1EB2BDAC),
        UINT64_C(0x120BC1C1244CD980), UINT64_C(0x1FFA119DB63530D4),
        UINT64_C(0x08E9607800BF0B29), UINT64_C(0x0518B02492C6E27D),
        UINT64_C(0xA3D18C1D4605A441), UINT64_C(0xAE205C41D47C4D15),
        UINT64_C(0xB9332DA462F676E8), UINT64_C(0xB4C2FDF8F08F9FBC),
        UINT64_C(0x3BF77FF9160ABFB0), UINT64_C(0x3606AFA5847356E4),
        UINT64_C(0x2115DE4032F96D19), UINT64_C(0x2CE40E1CA080844D),
        UINT64_C(0x8A2D32257443C271), UINT64_C(0x87DCE279E63A2B25),
        UINT64_C(0x90CF939C50B010D8), UINT64_C(0x9D3E43C0C2C9F98C),
        UINT64_C(0xDC5CEAEEF8379DA0), UINT64_C(0xD1AD3AB26A4E74F4),
        UINT64_C(0xC6BE4B57DCC44F09), UINT64_C(0xCB4F9B0B4EBDA65D),
        UINT64_C(0x6D86A7329A7EE061), UINT64_C(0x6077776E08070935),
        UINT64_C(0x7764068BBE8D32C8), UINT64_C(0x7A95D6D72CF4DB9C),
        UINT64_C(0x690F0288728673D0), UINT64_C(0x64FED2D4E0FF9A84),
        UINT64_C(0x73EDA3315675A179), UINT64_C(0x7E1C736DC40C482D),
        UINT64_C(0xD8D54F5410CF0E11), UINT64_C(0xD5249F0882B6E745),
        UINT64_C(0xC237EEED343CDCB8), UINT64_C(0xCFC63EB1A64535EC),
        UINT64_C(0x8EA4979F9CBB51C0), UINT64_C(0x835547C30EC2B894),
        UINT64_C(0x94463626B8488369), UINT64_C(0x99B7E67A2A316A3D),
        UINT64_C(0x3F7EDA43FEF22C01), UINT64_C(0x328F0A1F6C8BC555),
        UINT64_C(0x259C7BFADA01FEA8), UINT64_C(0x286DABA6487817FC),
        UINT64_C(0xA75829A7AEFD37F0), UINT64_C(0xAAA9F9FB3C84DEA4),
        UINT64_C(0xBDBA881E8A0EE559), UINT64_C(0xB04B584218770C0D),
        UINT64_C(0x1682647BCCB44A31), UINT64_C(0x1B73B4275ECDA365),
        UINT64_C(0x0C60C5C2E8479898), UINT64_C(0x0191159E7A3E71CC),
        UINT64_C(0x40F3BCB040C015E0), UINT64_C(0x4D026CECD2B9FCB4),
        UINT64_C(0x5A111D096433C749), UINT64_C(0x57E0CD55F64A2E1D),
        UINT64_C(0xF129F16C22896821), UINT64_C(0xFCD82130B0F08175),
        UINT64_C(0xEBCB50D5067ABA88), UINT64_C(0xE63A8089940353DC),
        UINT64_C(0xCDFFF96ABA9EEA11), UINT64_C(0xC00E293628E70345),
        UINT64_C(0xD71D58D39E6D38B8), UINT64_C(0xDAEC888F0C14D1EC),
        UINT64_C(0x7C25B4B6D8D797D0), UINT64_C(0x71D464EA4AAE7E84),
        UINT64_C(0x66C7150FFC244579), UINT64_C(0x6B36C5536E5DAC2D),
        UINT64_C(0x2A546C7D54A3C801), UINT64_C(0x27A5BC21C6DA2155),
        UINT64_C(0x30B6CDC470501AA8), UINT64_C(0x3D471D98E229F3FC),
        UINT64_C(0x9B8E21A136EAB5C0), UINT64_C(0x967FF1FDA4935C94),
        UINT64_C(0x816C801812196769), UINT64_C(0x8C9D504480608E3D),
        UINT64_C(0x03A8D24566E5AE31), UINT64_C(0x0E590219F49C4765),
        UINT64_C(0x194A73FC42167C98), UINT64_C(0x14BBA3A0D06F95CC),
        UINT64_C(0xB2729F9904ACD3F0), UINT64_C(0xBF834FC596D53AA4),
        UINT64_C(0xA8903E20205F0159), UINT64_C(0xA561EE7CB226E80D),
        UINT64_C(0xE403475288D88C21), UINT64_C(0xE9F2970E1AA16575),
        UINT64_C(0xFEE1E6EBAC2B5E88), UINT64_C(0xF31036B73E52B7DC),
        UINT64_C(0x55D90A8EEA91F1E0), UINT64_C(0x5828DAD278E818B4),
        UINT64_C(0x4F3BAB37CE622349), UINT64_C(0x42CA7B6B5C1BCA1D),
        UINT64_C(0x5150AF3402696251), UINT64_C(0x5CA17F6890108B05),
        UINT64_C(0x4BB20E8D269AB0F8), UINT64_C(0x4643DED1B4E359AC),
        UINT64_C(0xE08AE2E860201F90), UINT64_C(0xED7B32B4F259F6C4),
        UINT64_C(0xFA68435144D3CD39), UINT64_C(0xF799930DD6AA246D),
        UINT64_C(0xB6FB3A23EC544041), UINT64_C(0xBB0AEA7F7E2DA915),
        UINT64_C(0xAC199B9AC8A792E8), UINT64_C(0xA1E84BC65ADE7BBC),
        UINT64_C(0x072177FF8E1D3D80), UINT64_C(0x0AD0A7A31C64D4D4),
        UINT64_C(0x1DC3D646AAEEEF29), UINT64_C(0x1032061A3897067D),
        UINT64_C(0x9F07841BDE122671), UINT64_C(0x92F654474C6BCF25),
        UINT64_C(0x85E525A2FAE1F4D8), UINT64_C(0x8814F5FE68981D8C),
        UINT64_C(0x2EDDC9C7BC5B5BB0), UINT64_C(0x232C199B2E22B2E4),
        UINT64_C(0x343F687E98A88919), UINT64_C(0x39CEB8220AD1604D),
        UINT64_C(0x78AC110C302F0461), UINT64_C(0x755DC150A256ED35),
        UINT64_C(0x624EB0B514DCD6C8), UINT64_C(0x6FBF60E986A53F9C),
        UINT64_C(0xC9765CD0526679A0), UINT64_C(0xC4878C8CC01F90F4),
        UINT64_C(0xD394FD697695AB09), UINT64_C(0xDE652D35E4EC425D)
    }, {
        UINT64_C(0x0000000000000000), UINT64_C(0xCB6D6A914AE10B3F),
        UINT64_C(0x96DBD42295C2177E), UINT64_C(0x5DB6BEB3DF231C41),
        UINT64_C(0x2CB7A9452A852FFC), UINT64_C(0xE7DAC3D4606424C3),
        UINT64_C(0xBA6C7D67BF473882), UINT64_C(0x710117F6F5A633BD),
        UINT64_C(0xDD705D247FA5876A), UINT64_C(0x161D37B535448C55),
        UINT64_C(0x4BAB8906EA679014), UINT64_C(0x80C6E397A0869B2B),
        UINT64_C(0xF1C7F4615520A896), UINT64_C(0x3AAA9EF01FC1A3A9),
        UINT64_C(0x671C2043C0E2BFE8), UINT64_C(0xAC714AD28A03B4D7),
        UINT64_C(0xBAE1BA48FE4A0FD5), UINT64_C(0x718CD0D9B4AB04EA),
        UINT64_C(0x2C3A6E6A6B8818AB), UINT64_C(0xE75704FB21691394),
        UINT64_C(0x9656130DD4CF2029), UINT64_C(0x5D3B799C9E2E2B16),
        UINT64_C(0x008DC72F410D3757), UINT64_C(0xCBE0ADBE0BEC3C68),
        UINT64_C(0x6791E76C81EF88BF), UINT64_C(0xACFC8DFDCB0E8380),
        UINT64_C(0xF14A334E142D9FC1), UINT64_C(0x3A2759DF5ECC94FE),
        UINT64_C(0x4B264E29AB6AA743), UINT64_C(0x804B24B8E18BAC7C),
        UINT64_C(0xDDFD9A0B3EA8B03D), UINT64_C(0x1690F09A7449BB02),
        UINT64_C(0xF1DD7B3ED73AC638), UINT64_C(0x3AB011AF9DDBCD07),
        UINT64_C(0x6706AF1C42F8D146), UINT64_C(0xAC6BC58D0819DA79),
        UINT64_C(0xDD6AD27BFDBFE9C4), UINT64_C(0x1607B8EAB75EE2FB),
        UINT64_C(0x4BB10659687DFEBA), UINT64_C(0x80DC6CC8229CF585),
        UINT64_C(0x2CAD261AA89F4152), UINT64_C(0xE7C04C8BE27E4A6D),
        UINT64_C(0xBA76F2383D5D562C), UINT64_C(0x711B98A977BC5D13),
        UINT64_C(0x001A8F5F821A6EAE), UINT64_C(0xCB77E5CEC8FB6591),
        UINT64_C(0x96C15B7D17D879D0), UINT64_C(0x5DAC31EC5D3972EF),
        UINT64_C(0x4B3CC1762970C9ED), UINT64_C(0x8051ABE76391C2D2),
        UINT64_C(0xDDE71554BCB2DE93), UINT64_C(0x168A7FC5F653D5AC),
        UINT64_C(0x678B683303F5E611), UINT64_C(0xACE602A24914ED2E),
        UINT64_C(0xF150BC119637F16F), UINT64_C(0x3A3DD680DCD6FA50),
        UINT64_C(0x964C9C5256D54E87), UINT64_C(0x5D21F6C31C3445B8),
        UINT64_C(0x00974870C31759F9), UINT64_C(0xCBFA22E189F652C6),
        UINT64_C(0xBAFB35177C50617B), UINT64_C(0x71965F8636B16A44),
        UINT64_C(0x2C20E135E9927605), UINT64_C(0xE74D8BA4A3737D3A),
        UINT64_C(0xE2BBF77CAE758C71), UINT64_C(0x29D69DEDE494874E),
        UINT64_C(0x7460235E3BB79B0F), UINT64_C(0xBF0D49CF71569030),
        UINT64_C(0xCE0C5E3984F0A38D), UINT64_C(0x056134A8CE11A8B2),
        UINT64_C(0x58D78A1B1132B4F3), UINT64_C(0x93BAE08A5BD3BFCC),
        UINT64_C(0x3FCBAA58D1D00B1B), UINT64_C(0xF4A6C0C99B310024),
        UINT64_C(0xA9107E7A44121C65), UINT64_C(0x627D14EB0EF3175A),
        UINT64_C(0x137C031DFB5524E7), UINT64_C(0xD811698CB1B42FD8),
        UINT64_C(0x85A7D73F6E973399), UINT64_C(0x4ECABDAE247638A6),
        UINT64_C(0x585A4D34503F83A4), UINT64_C(0x933727A51ADE889B),
        UINT64_C(0xCE819916C5FD94DA), UINT64_C(0x05ECF3878F1C9FE5),
        UINT64_C(0x74EDE4717ABAAC58), UINT64_C(0xBF808EE0305BA767),
        UINT64_C(0xE2363053EF78BB26), UINT64_C(0x295B5AC2A599B019),
        UINT64_C(0x852A10102F9A04CE), UINT64_C(0x4E477A81657B0FF1),
        UINT64_C(0x13F1C432BA5813B0), UINT64_C(0xD89CAEA3F0B9188F),
        UINT64_C(0xA99DB955051F2B32), UINT64_C(0x62F0D3C44FFE200D),
        UINT64_C(0x3F466D7790DD3C4C), UINT64_C(0xF42B07E6DA3C3773),
        UINT64_C(0x13668C42794F4A49), UINT64_C(0xD80BE6D333AE4176),
        UINT64_C(0x85BD5860EC8D5D37), UINT64_C(0x4ED032F1A66C5608),
        UINT64_C(0x3FD1250753CA65B5), UINT64_C(0xF4BC4F96192B6E8A),
        UINT64_C(0xA90AF125C60872CB), UINT64_C(0x62679BB48CE979F4),
        UINT64_C(0xCE16D16606EACD23), UINT64_C(0x057BBBF74C0BC61C),
        UINT64_C(0x58CD05449328DA5D), UINT64_C(0x93A06FD5D9C9D162),
        UINT64_C(0xE2A178232C6FE2DF), UINT64_C(0x29CC12B2668EE9E0),
        UINT64_C(0x747AAC01B9ADF5A1), UINT64_C(0xBF17C690F34CFE9E),
        UINT64_C(0xA987360A8705459C), UINT64_C(0x62EA5C9BCDE44EA3),
        UINT64_C(0x3F5CE22812C752E2), UINT64_C(0xF43188B9582659DD),
        UINT64_C(0x85309F4FAD806A60), UINT64_C(0x4E5DF5DEE761615F),
        UINT64_C(0x13EB4B6D38427D1E), UINT64_C(0xD88621FC72A37621),
        UINT64_C(0x74F76B2EF8A0C2F6), UINT64_C(0xBF9A01BFB241C9C9),
        UINT64_C(0xE22CBF0C6D62D588), UINT64_C(0x2941D59D2783DEB7),
        UINT64_C(0x5840C26BD225ED0A), UINT64_C(0x932DA8FA98C4E635),
        UINT64_C(0xCE9B164947E7FA74), UINT64_C(0x05F67CD80D06F14B),
        UINT64_C(0xC477EFF95CEB18E3), UINT64_C(0x0F1A8568160A13DC),
        UINT64_C(0x52AC3BDBC9290F9D), UINT64_C(0x99C1514A83C804A2),
        UINT64_C(0xE8C046BC766E371F), UINT64_C(0x23AD2C2D3C8F3C20),
        UINT64_C(0x7E1B929EE3AC2061), UINT64_C(0xB576F80FA94D2B5E),
        UINT64_C(0x1907B2DD234E9F89), UINT64_C(0xD26AD84C69AF94B6),
        UINT64_C(0x8FDC66FFB68C88F7), UINT64_C(0x44B10C6EFC6D83C8),
        UINT64_C(0x35B01B9809CBB075), UINT64_C(0xFEDD7109432ABB4A),
        UINT64_C(0xA36BCFBA9C09A70B), UINT64_C(0x6806A52BD6E8AC34),
        UINT64_C(0x7E9655B1A2A11736), UINT64_C(0xB5FB3F20E8401C09),
        UINT64_C(0xE84D819337630048), UINT64_C(0x2320EB027D820B77),
        UINT64_C(0x5221FCF4882438CA), UINT64_C(0x994C9665C2C533F5),
        UINT64_C(0xC4FA28D61DE62FB4), UINT64_C(0x0F9742475707248B),
        UINT64_C(0xA3E60895DD04905C), UINT64_C(0x688B620497E59B63),
        UINT64_C(0x353DDCB748C68722), UINT64_C(0xFE50B62602278C1D),
        UINT64_C(0x8F51A1D0F781BFA0), UINT64_C(0x443CCB41BD60B49F),
        UINT64_C(0x198A75F26243A8DE), UINT64_C(0xD2E71F6328A2A3E1),
        UINT64_C(0x35AA94C78BD1DEDB), UINT64_C(0xFEC7FE56C130D5E4),
        UINT64_C(0xA37140E51E13C9A5), UINT64_C(0x681C2A7454F2C29A),
        UINT64_C(0x191D3D82A154F127), UINT64_C(0xD2705713EBB5FA18),
        UINT64_C(0x8FC6E9A03496E659), UINT64_C(0x44AB83317E77ED66),
        UINT64_C(0xE8DAC9E3F47459B1), UINT64_C(0x23B7A372BE95528E),
        UINT64_C(0x7E011DC161B64ECF), UINT64_C(0xB56C77502B5745F0),
        UINT64_C(0xC46D60A6DEF1764D), UINT64_C(0x0F000A3794107D72),
        UINT64_C(0x52B6B4844B336133), UINT64_C(0x99DBDE1501D26A0C),
        UINT64_C(0x8F4B2E8F759BD10E), UINT64_C(0x4426441E3F7ADA31),
        UINT64_C(0x1990FAADE059C670), UINT64_C(0xD2FD903CAAB8CD4F),
        UINT64_C(0xA3FC87CA5F1EFEF2), UINT64_C(0x6891ED5B15FFF5CD),
        UINT64_C(0x352753E8CADCE98C), UINT64_C(0xFE4A3979803DE2B3),
        UINT64_C(0x523B73AB0A3E5664), UINT64_C(0x9956193A40DF5D5B),
        UINT64_C(0xC4E0A7899FFC411A), UINT64_C(0x0F8DCD18D51D4A25),
        UINT64_C(0x7E8CDAEE20BB7998), UINT64_C(0xB5E1B07F6A5A72A7),
        UINT64_C(0xE8570ECCB5796EE6), UINT64_C(0x233A645DFF9865D9),
        UINT64_C(0x26CC1885F29E9492), UINT64_C(0xEDA17214B87F9FAD),
        UINT64_C(0xB017CCA7675C83EC), UINT64_C(0x7B7AA6362DBD88D3),
        UINT64_C(0x0A7BB1C0D81BBB6E), UINT64_C(0xC116DB5192FAB051),
        UINT64_C(0x9CA065E24DD9AC10), UINT64_C(0x57CD0F730738A72F),
        UINT64_C(0xFBBC45A18D3B13F8), UINT64_C(0x30D12F30C7DA18C7),
        UINT64_C(0x6D67918318F90486), UINT64_C(0xA60AFB1252180FB9),
        UINT64_C(0xD70BECE4A7BE3C04), UINT64_C(0x1C668675ED5F373B),
        UINT64_C(0x41D038C6327C2B7A), UINT64_C(0x8ABD5257789D2045),
        UINT64_C(0x9C2DA2CD0CD49B47), UINT64_C(0x5740C85C46359078),
        UINT64_C(0x0AF676EF99168C39), UINT64_C(0xC19B1C7ED3F78706),
        UINT64_C(0xB09A0B882651B4BB), UINT64_C(0x7BF761196CB0BF84),
        UINT64_C(0x2641DFAAB393A3C5), UINT64_C(0xED2CB53BF972A8FA),
        UINT64_C(0x415DFFE973711C2D), UINT64_C(0x8A30957839901712),
        UINT64_C(0xD7862BCBE6B30B53), UINT64_C(0x1CEB415AAC52006C),
        UINT64_C(0x6DEA56AC59F433D1), UINT64_C(0xA6873C3D131538EE),
        UINT64_C(0xFB31828ECC3624AF), UINT64_C(0x305CE81F86D72F90),
        UINT64_C(0xD71163BB25A452AA), UINT64_C(0x1C7C092A6F455995),
        UINT64_C(0x41CAB799B06645D4), UINT64_C(0x8AA7DD08FA874EEB),
        UINT64_C(0xFBA6CAFE0F217D56), UINT64_C(0x30CBA06F45C07669),
        UINT64_C(0x6D7D1EDC9AE36A28), UINT64_C(0xA610744DD0026117),
        UINT64_C(0x0A613E9F5A01D5C0), UINT64_C(0xC10C540E10E0DEFF),
        UINT64_C(0x9CBAEABDCFC3C2BE), UINT64_C(0x57D7802C8522C981),
        UINT64_C(0x26D697DA7084FA3C), UINT64_C(0xEDBBFD4B3A65F103),
        UINT64_C(0xB00D43F8E546ED42), UINT64_C(0x7B602969AFA7E67D),
        UINT64_C(0x6DF0D9F3DBEE5D7F), UINT64_C(0xA69DB362910F5640),
        UINT64_C(0xFB2B0DD14E2C4A01), UINT64_C(0x3046674004CD413E),
        UINT64_C(0x414770B6F16B7283), UINT64_C(0x8A2A1A27BB8A79BC),
        UINT64_C(0xD79CA49464A965FD), UINT64_C(0x1CF1CE052E486EC2),
        UINT64_C(0xB08084D7A44BDA15), UINT64_C(0x7BEDEE46EEAAD12A),
        UINT64_C(0x265B50F53189CD6B), UINT64_C(0xED363A647B68C654),
        UINT64_C(0x9C372D928ECEF5E9), UINT64_C(0x575A4703C42FFED6),
        UINT64_C(0x0AECF9B01B0CE297), UINT64_C(0xC181932151EDE9A8)
    }, {
        UINT64_C(0x0000000000000000), UINT64_C(0xDCA12C225E8AEE1D),
        UINT64_C(0xB8435944BC14DD3B), UINT64_C(0x64E27566E29E3326),
        UINT64_C(0x7087B2887829BA77), UINT64_C(0xAC269EAA26A3546A),
        UINT64_C(0xC8C4EBCCC43D674C), UINT64_C(0x1465C7EE9AB78951),
        UINT64_C(0xE00E6511F15274EF), UINT64_C(0x3CAF4933AFD89AF2),
        UINT64_C(0x584D3C554D46A9D4), UINT64_C(0x84EC107713CC47C9),
        UINT64_C(0x9089D799897BCE98), UINT64_C(0x4C28FBBBD7F12085),
        UINT64_C(0x28CA8EDD356F13A3), UINT64_C(0xF46BA2FF6BE5FDBE),
        UINT64_C(0x4503C48DC90A304C), UINT64_C(0x99A2E8AF9780DE51),
        UINT64_C(0xFD409DC9751EED77), UINT64_C(0x21E1B1EB2B94036A),
        UINT64_C(0x35847605B1238A3B), UINT64_C(0xE9255A27EFA96426),
        UINT64_C(0x8DC72F410D375700), UINT64_C(0x5166036353BDB91D),
        UINT64_C(0xA50DA19C385844A3), UINT64_C(0x79AC8DBE66D2AABE),
        UINT64_C(0x1D4EF8D8844C9998), UINT64_C(0xC1EFD4FADAC67785),
        UINT64_C(0xD58A13144071FED4), UINT64_C(0x092B3F361EFB10C9),
        UINT64_C(0x6DC94A50FC6523EF), UINT64_C(0xB1686672A2EFCDF2),
        UINT64_C(0x8A06881B93156098), UINT64_C(0x56A7A439CD9F8E85),
        UINT64_C(0x3245D15F2F01BDA3), UINT64_C(0xEEE4FD7D718B53BE),
        UINT64_C(0xFA813A93EB3CDAEF), UINT64_C(0x262016B1B5B634F2),
        UINT64_C(0x42C263D7572807D4), UINT64_C(0x9E634FF509A2E9C9),
        UINT64_C(0x6A08ED0A62471477), UINT64_C(0xB6A9C1283CCDFA6A),
        UINT64_C(0xD24BB44EDE53C94C), UINT64_C(0x0EEA986C80D92751),
        UINT64_C(0x1A8F5F821A6EAE00), UINT64_C(0xC62E73A044E4401D),
        UINT64_C(0xA2CC06C6A67A733B), UINT64_C(0x7E6D2AE4F8F09D26),
        UINT64_C(0xCF054C965A1F50D4), UINT64_C(0x13A460B40495BEC9),
        UINT64_C(0x774615D2E60B8DEF), UINT64_C(0xABE739F0B88163F2),
        UINT64_C(0xBF82FE1E2236EAA3), UINT64_C(0x6323D23C7CBC04BE),
        UINT64_C(0x07C1A75A9E223798), UINT64_C(0xDB608B78C0A8D985),
        UINT64_C(0x2F0B2987AB4D243B), UINT64_C(0xF3AA05A5F5C7CA26),
        UINT64_C(0x974870C31759F900), UINT64_C(0x4BE95CE149D3171D),
        UINT64_C(0x5F8C9B0FD3649E4C), UINT64_C(0x832DB72D8DEE7051),
        UINT64_C(0xE7CFC24B6F704377), UINT64_C(0x3B6EEE6931FAAD6A),
        UINT64_C(0x91131E980D8418A2), UINT64_C(0x4DB232BA530EF6BF),
        UINT64_C(0x295047DCB190C599), UINT64_C(0xF5F16BFEEF1A2B84),
        UINT64_C(0xE194AC1075ADA2D5), UINT64_C(0x3D3580322B274CC8),
        UINT64_C(0x59D7F554C9B97FEE), UINT64_C(0x8576D976973391F3),
        UINT64_C(0x711D7B89FCD66C4D), UINT64_C(0xADBC57ABA25C8250),
        UINT64_C(0xC95E22CD40C2B176), UINT64_C(0x15FF0EEF1E485F6B),
        UINT64_C(0x019AC90184FFD63A), UINT64_C(0xDD3BE523DA753827),
        UINT64_C(0xB9D9904538EB0B01), UINT64_C(0x6578BC676661E51C),
        UINT64_C(0xD410DA15C48E28EE), UINT64_C(0x08B1F6379A04C6F3),
        UINT64_C(0x6C538351789AF5D5), UINT64_C(0xB0F2AF7326101BC8),
        UINT64_C(0xA497689DBCA79299), UINT64_C(0x783644BFE22D7C84),
        UINT64_C(0x1CD431D900B34FA2), UINT64_C(0xC0751DFB5E39A1BF),
        UINT64_C(0x341EBF0435DC5C01), UINT64_C(0xE8BF93266B56B21C),
        UINT64_C(0x8C5DE64089C8813A), UINT64_C(0x50FCCA62D7426F27),
        UINT64_C(0x44990D8C4DF5E676), UINT64_C(0x983821AE137F086B),
        UINT64_C(0xFCDA54C8F1E13B4D), UINT64_C(0x207B78EAAF6BD550),
        UINT64_C(0x1B1596839E91783A), UINT64_C(0xC7B4BAA1C01B9627),
        UINT64_C(0xA356CFC72285A501), UINT64_C(0x7FF7E3E57C0F4B1C),
        UINT64_C(0x6B92240BE6B8C24D), UINT64_C(0xB7330829B8322C50),
        UINT64_C(0xD3D17D4F5AAC1F76), UINT64_C(0x0F70516D0426F16B),
        UINT64_C(0xFB1BF3926FC30CD5), UINT64_C(0x27BADFB03149E2C8),
        UINT64_C(0x4358AAD6D3D7D1EE), UINT64_C(0x9FF986F48D5D3FF3),
        UINT64_C(0x8B9C411A17EAB6A2), UINT64_C(0x573D6D38496058BF),
        UINT64_C(0x33DF185EABFE6B99), UINT64_C(0xEF7E347CF5748584),
        UINT64_C(0x5E16520E579B4876), UINT64_C(0x82B77E2C0911A66B),
        UINT64_C(0xE6550B4AEB8F954D), UINT64_C(0x3AF42768B5057B50),
        UINT64_C(0x2E91E0862FB2F201), UINT64_C(0xF230CCA471381C1C),
        UINT64_C(0x96D2B9C293A62F3A), UINT64_C(0x4A7395E0CD2CC127),
        UINT64_C(0xBE18371FA6C93C99), UINT64_C(0x62B91B3DF843D284),
        UINT64_C(0x065B6E5B1ADDE1A2), UINT64_C(0xDAFA427944570FBF),
        UINT64_C(0xCE9F8597DEE086EE), UINT64_C(0x123EA9B5806A68F3),
        UINT64_C(0x76DCDCD362F45BD5), UINT64_C(0xAA7DF0F13C7EB5C8),
        UINT64_C(0xA739329F30A7E9D6), UINT64_C(0x7B981EBD6E2D07CB),
        UINT64_C(0x1F7A6BDB8CB334ED), UINT64_C(0xC3DB47F9D239DAF0),
        UINT64_C(0xD7BE8017488E53A1), UINT64_C(0x0B1FAC351604BDBC),
        UINT64_C(0x6FFDD953F49A8E9A), UINT64_C(0xB35CF571AA106087),
        UINT64_C(0x4737578EC1F59D39), UINT64_C(0x9B967BAC9F7F7324),
        UINT64_C(0xFF740ECA7DE14002), UINT64_C(0x23D522E8236BAE1F),
        UINT64_C(0x37B0E506B9DC274E), UINT64_C(0xEB11C924E756C953),
        UINT64_C(0x8FF3BC4205C8FA75), UINT64_C(0x535290605B421468),
        UINT64_C(0xE23AF612F9ADD99A), UINT64_C(0x3E9BDA30A7273787),
        UINT64_C(0x5A79AF5645B904A1), UINT64_C(0x86D883741B33EABC),
        UINT64_C(0x92BD449A818463ED), UINT64_C(0x4E1C68B8DF0E8DF0),
        UINT64_C(0x2AFE1DDE3D90BED6), UINT64_C(0xF65F31FC631A50CB),
        UINT64_C(0x0234930308FFAD75), UINT64_C(0xDE95BF2156754368),
        UINT64_C(0xBA77CA47B4EB704E), UINT64_C(0x66D6E665EA619E53),
        UINT64_C(0x72B3218B70D61702), UINT64_C(0xAE120DA92E5CF91F),
        UINT64_C(0xCAF078CFCCC2CA39), UINT64_C(0x165154ED92482424),
        UINT64_C(0x2D3FBA84A3B2894E), UINT64_C(0xF19E96A6FD386753),
        UINT64_C(0x957CE3C01FA65475), UINT64_C(0x49DDCFE2412CBA68),
        UINT64_C(0x5DB8080CDB9B3339), UINT64_C(0x8119242E8511DD24),
        UINT64_C(0xE5FB5148678FEE02), UINT64_C(0x395A7D6A3905001F),
        UINT64_C(0xCD31DF9552E0FDA1), UINT64_C(0x1190F3B70C6A13BC),
        UINT64_C(0x757286D1EEF4209A), UINT64_C(0xA9D3AAF3B07ECE87),
        UINT64_C(0xBDB66D1D2AC947D6), UINT64_C(0x6117413F7443A9CB),
        UINT64_C(0x05F5345996DD9AED), UINT64_C(0xD954187BC85774F0),
        UINT64_C(0x683C7E096AB8B902), UINT64_C(0xB49D522B3432571F),
        UINT64_C(0xD07F274DD6AC6439), UINT64_C(0x0CDE0B6F88268A24),
        UINT64_C(0x18BBCC8112910375), UINT64_C(0xC41AE0A34C1BED68),
        UINT64_C(0xA0F895C5AE85DE4E), UINT64_C(0x7C59B9E7F00F3053),
        UINT64_C(0x88321B189BEACDED), UINT64_C(0x5493373AC56023F0),
        UINT64_C(0x3071425C27FE10D6), UINT64_C(0xECD06E7E7974FECB),
        UINT64_C(0xF8B5A990E3C3779A), UINT64_C(0x241485B2BD499987),
        UINT64_C(0x40F6F0D45FD7AAA1), UINT64_C(0x9C57DCF6015D44BC),
        UINT64_C(0x362A2C073D23F174), UINT64_C(0xEA8B002563A91F69),
        UINT64_C(0x8E69754381372C4F), UINT64_C(0x52C85961DFBDC252),
        UINT64_C(0x46AD9E8F450A4B03), UINT64_C(0x9A0CB2AD1B80A51E),
        UINT64_C(0xFEEEC7CBF91E9638), UINT64_C(0x224FEBE9A7947825),
        UINT64_C(0xD6244916CC71859B), UINT64_C(0x0A85653492FB6B86),
        UINT64_C(0x6E671052706558A0), UINT64_C(0xB2C63C702EEFB6BD),
        UINT64_C(0xA6A3FB9EB4583FEC), UINT64_C(0x7A02D7BCEAD2D1F1),
        UINT64_C(0x1EE0A2DA084CE2D7), UINT64_C(0xC2418EF856C60CCA),
        UINT64_C(0x7329E88AF429C138), UINT64_C(0xAF88C4A8AAA32F25),
        UINT64_C(0xCB6AB1CE483D1C03), UINT64_C(0x17CB9DEC16B7F21E),
        UINT64_C(0x03AE5A028C007B4F), UINT64_C(0xDF0F7620D28A9552),
        UINT64_C(0xBBED03463014A674), UINT64_C(0x674C2F646E9E4869),
        UINT64_C(0x93278D9B057BB5D7), UINT64_C(0x4F86A1B95BF15BCA),
        UINT64_C(0x2B64D4DFB96F68EC), UINT64_C(0xF7C5F8FDE7E586F1),
        UINT64_C(0xE3A03F137D520FA0), UINT64_C(0x3F01133123D8E1BD),
        UINT64_C(0x5BE36657C146D29B), UINT64_C(0x87424A759FCC3C86),
        UINT64_C(0xBC2CA41CAE3691EC), UINT64_C(0x608D883EF0BC7FF1),
        UINT64_C(0x046FFD5812224CD7), UINT64_C(0xD8CED17A4CA8A2CA),
        UINT64_C(0xCCAB1694D61F2B9B), UINT64_C(0x100A3AB68895C586),
        UINT64_C(0x74E84FD06A0BF6A0), UINT64_C(0xA84963F2348118BD),
        UINT64_C(0x5C22C10D5F64E503), UINT64_C(0x8083ED2F01EE0B1E),
        UINT64_C(0xE4619849E3703838), UINT64_C(0x38C0B46BBDFAD625),
        UINT64_C(0x2CA57385274D5F74), UINT64_C(0xF0045FA779C7B169),
        UINT64_C(0x94E62AC19B59824F), UINT64_C(0x484706E3C5D36C52),
        UINT64_C(0xF92F6091673CA1A0), UINT64_C(0x258E4CB339B64FBD),
        UINT64_C(0x416C39D5DB287C9B), UINT64_C(0x9DCD15F785A29286),
        UINT64_C(0x89A8D2191F151BD7), UINT64_C(0x5509FE3B419FF5CA),
        UINT64_C(0x31EB8B5DA301C6EC), UINT64_C(0xED4AA77FFD8B28F1),
        UINT64_C(0x19210580966ED54F), UINT64_C(0xC58029A2C8E43B52),
        UINT64_C(0xA1625CC42A7A0874), UINT64_C(0x7DC370E674F0E669),
        UINT64_C(0x69A6B708EE476F38), UINT64_C(0xB5079B2AB0CD8125),
        UINT64_C(0xD1E5EE4C5253B203), UINT64_C(0x0D44C26E0CD95C1E)
    }
};

#else

#   define A1 A
#   define A(x) ((x) & 0xFF)
#   define B(x) (((x) >> 8) & 0xFF)
#   define C(x) (((x) >> 16) & 0xFF)
#   define D(x) ((x) >> 24)
#   define S8(x) ((x) >> 8)
#   define S32(x) ((x) >> 32)
/* This file has been automatically generated by crc64_tablegen.c. */
const uint64_t ls_crc64_table[4][256] =
{
    {
        UINT64_C(0x0000000000000000), UINT64_C(0xB32E4CBE03A75F6F),
        UINT64_C(0xF4843657A840A05B), UINT64_C(0x47AA7AE9ABE7FF34),
        UINT64_C(0x7BD0C384FF8F5E33), UINT64_C(0xC8FE8F3AFC28015C),
        UINT64_C(0x8F54F5D357CFFE68), UINT64_C(0x3C7AB96D5468A107),
        UINT64_C(0xF7A18709FF1EBC66), UINT64_C(0x448FCBB7FCB9E309),
        UINT64_C(0x0325B15E575E1C3D), UINT64_C(0xB00BFDE054F94352),
        UINT64_C(0x8C71448D0091E255), UINT64_C(0x3F5F08330336BD3A),
        UINT64_C(0x78F572DAA8D1420E), UINT64_C(0xCBDB3E64AB761D61),
        UINT64_C(0x7D9BA13851336649), UINT64_C(0xCEB5ED8652943926),
        UINT64_C(0x891F976FF973C612), UINT64_C(0x3A31DBD1FAD4997D),
        UINT64_C(0x064B62BCAEBC387A), UINT64_C(0xB5652E02AD1B6715),
        UINT64_C(0xF2CF54EB06FC9821), UINT64_C(0x41E11855055BC74E),
        UINT64_C(0x8A3A2631AE2DDA2F), UINT64_C(0x39146A8FAD8A8540),
        UINT64_C(0x7EBE1066066D7A74), UINT64_C(0xCD905CD805CA251B),
        UINT64_C(0xF1EAE5B551A2841C), UINT64_C(0x42C4A90B5205DB73),
        UINT64_C(0x056ED3E2F9E22447), UINT64_C(0xB6409F5CFA457B28),
        UINT64_C(0xFB374270A266CC92), UINT64_C(0x48190ECEA1C193FD),
        UINT64_C(0x0FB374270A266CC9), UINT64_C(0xBC9D3899098133A6),
        UINT64_C(0x80E781F45DE992A1), UINT64_C(0x33C9CD4A5E4ECDCE),
        UINT64_C(0x7463B7A3F5A932FA), UINT64_C(0xC74DFB1DF60E6D95),
        UINT64_C(0x0C96C5795D7870F4), UINT64_C(0xBFB889C75EDF2F9B),
        UINT64_C(0xF812F32EF538D0AF), UINT64_C(0x4B3CBF90F69F8FC0),
        UINT64_C(0x774606FDA2F72EC7), UINT64_C(0xC4684A43A15071A8),
        UINT64_C(0x83C230AA0AB78E9C), UINT64_C(0x30EC7C140910D1F3),
        UINT64_C(0x86ACE348F355AADB), UINT64_C(0x3582AFF6F0F2F5B4),
        UINT64_C(0x7228D51F5B150A80), UINT64_C(0xC10699A158B255EF),
        UINT64_C(0xFD7C20CC0CDAF4E8), UINT64_C(0x4E526C720F7DAB87),
        UINT64_C(0x09F8169BA49A54B3), UINT64_C(0xBAD65A25A73D0BDC),
        UINT64_C(0x710D64410C4B16BD), UINT64_C(0xC22328FF0FEC49D2),
        UINT64_C(0x85895216A40BB6E6), UINT64_C(0x36A71EA8A7ACE989),
        UINT64_C(0x0ADDA7C5F3C4488E), UINT64_C(0xB9F3EB7BF06317E1),
        UINT64_C(0xFE5991925B84E8D5), UINT64_C(0x4D77DD2C5823B7BA),
        UINT64_C(0x64B62BCAEBC387A1), UINT64_C(0xD7986774E864D8CE),
        UINT64_C(0x90321D9D438327FA), UINT64_C(0x231C512340247895),
        UINT64_C(0x1F66E84E144CD992), UINT64_C(0xAC48A4F017EB86FD),
        UINT64_C(0xEBE2DE19BC0C79C9), UINT64_C(0x58CC92A7BFAB26A6),
        UINT64_C(0x9317ACC314DD3BC7), UINT64_C(0x2039E07D177A64A8),
        UINT64_C(0x67939A94BC9D9B9C), UINT64_C(0xD4BDD62ABF3AC4F3),
        UINT64_C(0xE8C76F47EB5265F4), UINT64_C(0x5BE923F9E8F53A9B),
        UINT64_C(0x1C4359104312C5AF), UINT64_C(0xAF6D15AE40B59AC0),
        UINT64_C(0x192D8AF2BAF0E1E8), UINT64_C(0xAA03C64CB957BE87),
        UINT64_C(0xEDA9BCA512B041B3), UINT64_C(0x5E87F01B11171EDC),
        UINT64_C(0x62FD4976457FBFDB), UINT64_C(0xD1D305C846D8E0B4),
        UINT64_C(0x96797F21ED3F1F80), UINT64_C(0x2557339FEE9840EF),
        UINT64_C(0xEE8C0DFB45EE5D8E), UINT64_C(0x5DA24145464902E1),
        UINT64_C(0x1A083BACEDAEFDD5), UINT64_C(0xA9267712EE09A2BA),
        UINT64_C(0x955CCE7FBA6103BD), UINT64_C(0x267282C1B9C65CD2),
        UINT64_C(0x61D8F8281221A3E6), UINT64_C(0xD2F6B4961186FC89),
        UINT64_C(0x9F8169BA49A54B33), UINT64_C(0x2CAF25044A02145C),
        UINT64_C(0x6B055FEDE1E5EB68), UINT64_C(0xD82B1353E242B407),
        UINT64_C(0xE451AA3EB62A1500), UINT64_C(0x577FE680B58D4A6F),
        UINT64_C(0x10D59C691E6AB55B), UINT64_C(0xA3FBD0D71DCDEA34),
        UINT64_C(0x6820EEB3B6BBF755), UINT64_C(0xDB0EA20DB51CA83A),
        UINT64_C(0x9CA4D8E41EFB570E), UINT64_C(0x2F8A945A1D5C0861),
        UINT64_C(0x13F02D374934A966), UINT64_C(0xA0DE61894A93F609),
        UINT64_C(0xE7741B60E174093D), UINT64_C(0x545A57DEE2D35652),
        UINT64_C(0xE21AC88218962D7A), UINT64_C(0x5134843C1B317215),
        UINT64_C(0x169EFED5B0D68D21), UINT64_C(0xA5B0B26BB371D24E),
        UINT64_C(0x99CA0B06E7197349), UINT64_C(0x2AE447B8E4BE2C26),
        UINT64_C(0x6D4E3D514F59D312), UINT64_C(0xDE6071EF4CFE8C7D),
        UINT64_C(0x15BB4F8BE788911C), UINT64_C(0xA6950335E42FCE73),
        UINT64_C(0xE13F79DC4FC83147), UINT64_C(0x521135624C6F6E28),
        UINT64_C(0x6E6B8C0F1807CF2F), UINT64_C(0xDD45C0B11BA09040),
        UINT64_C(0x9AEFBA58B0476F74), UINT64_C(0x29C1F6E6B3E0301B),
        UINT64_C(0xC96C5795D7870F42), UINT64_C(0x7A421B2BD420502D),
        UINT64_C(0x3DE861C27FC7AF19), UINT64_C(0x8EC62D7C7C60F076),
        UINT64_C(0xB2BC941128085171), UINT64_C(0x0192D8AF2BAF0E1E),
        UINT64_C(0x4638A2468048F12A), UINT64_C(0xF516EEF883EFAE45),
        UINT64_C(0x3ECDD09C2899B324), UINT64_C(0x8DE39C222B3EEC4B),
        UINT64_C(0xCA49E6CB80D9137F), UINT64_C(0x7967AA75837E4C10),
        UINT64_C(0x451D1318D716ED17), UINT64_C(0xF6335FA6D4B1B278),
        UINT64_C(0xB199254F7F564D4C), UINT64_C(0x02B769F17CF11223),
        UINT64_C(0xB4F7F6AD86B4690B), UINT64_C(0x07D9BA1385133664),
        UINT64_C(0x4073C0FA2EF4C950), UINT64_C(0xF35D8C442D53963F),
        UINT64_C(0xCF273529793B3738), UINT64_C(0x7C0979977A9C6857),
        UINT64_C(0x3BA3037ED17B9763), UINT64_C(0x888D4FC0D2DCC80C),
        UINT64_C(0x435671A479AAD56D), UINT64_C(0xF0783D1A7A0D8A02),
        UINT64_C(0xB7D247F3D1EA7536), UINT64_C(0x04FC0B4DD24D2A59),
        UINT64_C(0x3886B22086258B5E), UINT64_C(0x8BA8FE9E8582D431),
        UINT64_C(0xCC0284772E652B05), UINT64_C(0x7F2CC8C92DC2746A),
        UINT64_C(0x325B15E575E1C3D0), UINT64_C(0x8175595B76469CBF),
        UINT64_C(0xC6DF23B2DDA1638B), UINT64_C(0x75F16F0CDE063CE4),
        UINT64_C(0x498BD6618A6E9DE3), UINT64_C(0xFAA59ADF89C9C28C),
        UINT64_C(0xBD0FE036222E3DB8), UINT64_C(0x0E21AC88218962D7),
        UINT64_C(0xC5FA92EC8AFF7FB6), UINT64_C(0x76D4DE52895820D9),
        UINT64_C(0x317EA4BB22BFDFED), UINT64_C(0x8250E80521188082),
        UINT64_C(0xBE2A516875702185), UINT64_C(0x0D041DD676D77EEA),
        UINT64_C(0x4AAE673FDD3081DE), UINT64_C(0xF9802B81DE97DEB1),
        UINT64_C(0x4FC0B4DD24D2A599), UINT64_C(0xFCEEF8632775FAF6),
        UINT64_C(0xBB44828A8C9205C2), UINT64_C(0x086ACE348F355AAD),
        UINT64_C(0x34107759DB5DFBAA), UINT64_C(0x873E3BE7D8FAA4C5),
        UINT64_C(0xC094410E731D5BF1), UINT64_C(0x73BA0DB070BA049E),
        UINT64_C(0xB86133D4DBCC19FF), UINT64_C(0x0B4F7F6AD86B4690),
        UINT64_C(0x4CE50583738CB9A4), UINT64_C(0xFFCB493D702BE6CB),
        UINT64_C(0xC3B1F050244347CC), UINT64_C(0x709FBCEE27E418A3),
        UINT64_C(0x3735C6078C03E797), UINT64_C(0x841B8AB98FA4B8F8),
        UINT64_C(0xADDA7C5F3C4488E3), UINT64_C(0x1EF430E13FE3D78C),
        UINT64_C(0x595E4A08940428B8), UINT64_C(0xEA7006B697A377D7),
        UINT64_C(0xD60ABFDBC3CBD6D0), UINT64_C(0x6524F365C06C89BF),
        UINT64_C(0x228E898C6B8B768B), UINT64_C(0x91A0C532682C29E4),
        UINT64_C(0x5A7BFB56C35A3485), UINT64_C(0xE955B7E8C0FD6BEA),
        UINT64_C(0xAEFFCD016B1A94DE), UINT64_C(0x1DD181BF68BDCBB1),
        UINT64_C(0x21AB38D23CD56AB6), UINT64_C(0x9285746C3F7235D9),
        UINT64_C(0xD52F0E859495CAED), UINT64_C(0x6601423B97329582),
        UINT64_C(0xD041DD676D77EEAA), UINT64_C(0x636F91D96ED0B1C5),
        UINT64_C(0x24C5EB30C5374EF1), UINT64_C(0x97EBA78EC690119E),
        UINT64_C(0xAB911EE392F8B099), UINT64_C(0x18BF525D915FEFF6),
        UINT64_C(0x5F1528B43AB810C2), UINT64_C(0xEC3B640A391F4FAD),
        UINT64_C(0x27E05A6E926952CC), UINT64_C(0x94CE16D091CE0DA3),
        UINT64_C(0xD3646C393A29F297), UINT64_C(0x604A2087398EADF8),
        UINT64_C(0x5C3099EA6DE60CFF), UINT64_C(0xEF1ED5546E415390),
        UINT64_C(0xA8B4AFBDC5A6ACA4), UINT64_C(0x1B9AE303C601F3CB),
        UINT64_C(0x56ED3E2F9E224471), UINT64_C(0xE5C372919D851B1E),
        UINT64_C(0xA26908783662E42A), UINT64_C(0x114744C635C5BB45),
        UINT64_C(0x2D3DFDAB61AD1A42), UINT64_C(0x9E13B115620A452D),
        UINT64_C(0xD9B9CBFCC9EDBA19), UINT64_C(0x6A978742CA4AE576),
        UINT64_C(0xA14CB926613CF817), UINT64_C(0x1262F598629BA778),
        UINT64_C(0x55C88F71C97C584C), UINT64_C(0xE6E6C3CFCADB0723),
        UINT64_C(0xDA9C7AA29EB3A624), UINT64_C(0x69B2361C9D14F94B),
        UINT64_C(0x2E184CF536F3067F), UINT64_C(0x9D36004B35545910),
        UINT64_C(0x2B769F17CF112238), UINT64_C(0x9858D3A9CCB67D57),
        UINT64_C(0xDFF2A94067518263), UINT64_C(0x6CDCE5FE64F6DD0C),
        UINT64_C(0x50A65C93309E7C0B), UINT64_C(0xE388102D33392364),
        UINT64_C(0xA4226AC498DEDC50), UINT64_C(0x170C267A9B79833F),
        UINT64_C(0xDCD7181E300F9E5E), UINT64_C(0x6FF954A033A8C131),
        UINT64_C(0x28532E49984F3E05), UINT64_C(0x9B7D62F79BE8616A),
        UINT64_C(0xA707DB9ACF80C06D), UINT64_C(0x14299724CC279F02),
        UINT64_C(0x5383EDCD67C06036), UINT64_C(0xE0ADA17364673F59)
    }, {
        UINT64_C(0x0000000000000000), UINT64_C(0x54E979925CD0F10D),
        UINT64_C(0xA9D2F324B9A1E21A), UINT64_C(0xFD3B8AB6E5711317),
        UINT64_C(0xC17D4962DC4DDAB1), UINT64_C(0x959430F0809D2BBC),
        UINT64_C(0x68AFBA4665EC38AB), UINT64_C(0x3C46C3D4393CC9A6),
        UINT64_C(0x10223DEE1795ABE7), UINT64_C(0x44CB447C4B455AEA),
        UINT64_C(0xB9F0CECAAE3449FD), UINT64_C(0xED19B758F2E4B8F0),
        UINT64_C(0xD15F748CCBD87156), UINT64_C(0x85B60D1E9708805B),
        UINT64_C(0x788D87A87279934C), UINT64_C(0x2C64FE3A2EA96241),
        UINT64_C(0x20447BDC2F2B57CE), UINT64_C(0x74AD024E73FBA6C3),
        UINT64_C(0x899688F8968AB5D4), UINT64_C(0xDD7FF16ACA5A44D9),
        UINT64_C(0xE13932BEF3668D7F), UINT64_C(0xB5D04B2CAFB67C72),
        UINT64_C(0x48EBC19A4AC76F65), UINT64_C(0x1C02B80816179E68),
        UINT64_C(0x3066463238BEFC29), UINT64_C(0x648F3FA0646E0D24),
        UINT64_C(0x99B4B516811F1E33), UINT64_C(0xCD5DCC84DDCFEF3E),
        UINT64_C(0xF11B0F50E4F32698), UINT64_C(0xA5F276C2B823D795),
        UINT64_C(0x58C9FC745D52C482), UINT64_C(0x0C2085E60182358F),
        UINT64_C(0x4088F7B85E56AF9C), UINT64_C(0x14618E2A02865E91),
        UINT64_C(0xE95A049CE7F74D86), UINT64_C(0xBDB37D0EBB27BC8B),
        UINT64_C(0x81F5BEDA821B752D), UINT64_C(0xD51CC748DECB8420),
        UINT64_C(0x28274DFE3BBA9737), UINT64_C(0x7CCE346C676A663A),
        UINT64_C(0x50AACA5649C3047B), UINT64_C(0x0443B3C41513F576),
        UINT64_C(0xF9783972F062E661), UINT64_C(0xAD9140E0ACB2176C),
        UINT64_C(0x91D78334958EDECA), UINT64_C(0xC53EFAA6C95E2FC7),
        UINT64_C(0x380570102C2F3CD0), UINT64_C(0x6CEC098270FFCDDD),
        UINT64_C(0x60CC8C64717DF852), UINT64_C(0x3425F5F62DAD095F),
        UINT64_C(0xC91E7F40C8DC1A48), UINT64_C(0x9DF706D2940CEB45),
        UINT64_C(0xA1B1C506AD3022E3), UINT64_C(0xF558BC94F1E0D3EE),
        UINT64_C(0x086336221491C0F9), UINT64_C(0x5C8A4FB0484131F4),
        UINT64_C(0x70EEB18A66E853B5), UINT64_C(0x2407C8183A38A2B8),
        UINT64_C(0xD93C42AEDF49B1AF), UINT64_C(0x8DD53B3C839940A2),
        UINT64_C(0xB193F8E8BAA58904), UINT64_C(0xE57A817AE6757809),
        UINT64_C(0x18410BCC03046B1E), UINT64_C(0x4CA8725E5FD49A13),
        UINT64_C(0x8111EF70BCAD5F38), UINT64_C(0xD5F896E2E07DAE35),
        UINT64_C(0x28C31C54050CBD22), UINT64_C(0x7C2A65C659DC4C2F),
        UINT64_C(0x406CA61260E08589), UINT64_C(0x1485DF803C307484),
        UINT64_C(0xE9BE5536D9416793), UINT64_C(0xBD572CA48591969E),
        UINT64_C(0x9133D29EAB38F4DF), UINT64_C(0xC5DAAB0CF7E805D2),
        UINT64_C(0x38E121BA129916C5), UINT64_C(0x6C0858284E49E7C8),
        UINT64_C(0x504E9BFC77752E6E), UINT64_C(0x04A7E26E2BA5DF63),
        UINT64_C(0xF99C68D8CED4CC74), UINT64_C(0xAD75114A92043D79),
        UINT64_C(0xA15594AC938608F6), UINT64_C(0xF5BCED3ECF56F9FB),
        UINT64_C(0x088767882A27EAEC), UINT64_C(0x5C6E1E1A76F71BE1),
        UINT64_C(0x6028DDCE4FCBD247), UINT64_C(0x34C1A45C131B234A),
        UINT64_C(0xC9FA2EEAF66A305D), UINT64_C(0x9D135778AABAC150),
        UINT64_C(0xB177A9428413A311), UINT64_C(0xE59ED0D0D8C3521C),
        UINT64_C(0x18A55A663DB2410B), UINT64_C(0x4C4C23F46162B006),
        UINT64_C(0x700AE020585E79A0), UINT64_C(0x24E399B2048E88AD),
        UINT64_C(0xD9D81304E1FF9BBA), UINT64_C(0x8D316A96BD2F6AB7),
        UINT64_C(0xC19918C8E2FBF0A4), UINT64_C(0x9570615ABE2B01A9),
        UINT64_C(0x684BEBEC5B5A12BE), UINT64_C(0x3CA2927E078AE3B3),
        UINT64_C(0x00E451AA3EB62A15), UINT64_C(0x540D28386266DB18),
        UINT64_C(0xA936A28E8717C80F), UINT64_C(0xFDDFDB1CDBC73902),
        UINT64_C(0xD1BB2526F56E5B43), UINT64_C(0x85525CB4A9BEAA4E),
        UINT64_C(0x7869D6024CCFB959), UINT64_C(0x2C80AF90101F4854),
        UINT64_C(0x10C66C44292381F2), UINT64_C(0x442F15D675F370FF),
        UINT64_C(0xB9149F60908263E8), UINT64_C(0xEDFDE6F2CC5292E5),
        UINT64_C(0xE1DD6314CDD0A76A), UINT64_C(0xB5341A8691005667),
        UINT64_C(0x480F903074714570), UINT64_C(0x1CE6E9A228A1B47D),
        UINT64_C(0x20A02A76119D7DDB), UINT64_C(0x744953E44D4D8CD6),
        UINT64_C(0x8972D952A83C9FC1), UINT64_C(0xDD9BA0C0F4EC6ECC),
        UINT64_C(0xF1FF5EFADA450C8D), UINT64_C(0xA51627688695FD80),
        UINT64_C(0x582DADDE63E4EE97), UINT64_C(0x0CC4D44C3F341F9A),
        UINT64_C(0x308217980608D63C), UINT64_C(0x646B6E0A5AD82731),
        UINT64_C(0x9950E4BCBFA93426), UINT64_C(0xCDB99D2EE379C52B),
        UINT64_C(0x90FB71CAD654A0F5), UINT64_C(0xC41208588A8451F8),
        UINT64_C(0x392982EE6FF542EF), UINT64_C(0x6DC0FB7C3325B3E2),
        UINT64_C(0x518638A80A197A44), UINT64_C(0x056F413A56C98B49),
        UINT64_C(0xF854CB8CB3B8985E), UINT64_C(0xACBDB21EEF686953),
        UINT64_C(0x80D94C24C1C10B12), UINT64_C(0xD43035B69D11FA1F),
        UINT64_C(0x290BBF007860E908), UINT64_C(0x7DE2C69224B01805),
        UINT64_C(0x41A405461D8CD1A3), UINT64_C(0x154D7CD4415C20AE),
        UINT64_C(0xE876F662A42D33B9), UINT64_C(0xBC9F8FF0F8FDC2B4),
        UINT64_C(0xB0BF0A16F97FF73B), UINT64_C(0xE4567384A5AF0636),
        UINT64_C(0x196DF93240DE1521), UINT64_C(0x4D8480A01C0EE42C),
        UINT64_C(0x71C2437425322D8A), UINT64_C(0x252B3AE679E2DC87),
        UINT64_C(0xD810B0509C93CF90), UINT64_C(0x8CF9C9C2C0433E9D),
        UINT64_C(0xA09D37F8EEEA5CDC), UINT64_C(0xF4744E6AB23AADD1),
        UINT64_C(0x094FC4DC574BBEC6), UINT64_C(0x5DA6BD4E0B9B4FCB),
        UINT64_C(0x61E07E9A32A7866D), UINT64_C(0x350907086E777760),
        UINT64_C(0xC8328DBE8B066477), UINT64_C(0x9CDBF42CD7D6957A),
        UINT64_C(0xD073867288020F69), UINT64_C(0x849AFFE0D4D2FE64),
        UINT64_C(0x79A1755631A3ED73), UINT64_C(0x2D480CC46D731C7E),
        UINT64_C(0x110ECF10544FD5D8), UINT64_C(0x45E7B682089F24D5),
        UINT64_C(0xB8DC3C34EDEE37C2), UINT64_C(0xEC3545A6B13EC6CF),
        UINT64_C(0xC051BB9C9F97A48E), UINT64_C(0x94B8C20EC3475583),
        UINT64_C(0x698348B826364694), UINT64_C(0x3D6A312A7AE6B799),
        UINT64_C(0x012CF2FE43DA7E3F), UINT64_C(0x55C58B6C1F0A8F32),
        UINT64_C(0xA8FE01DAFA7B9C25), UINT64_C(0xFC177848A6AB6D28),
        UINT64_C(0xF037FDAEA72958A7), UINT64_C(0xA4DE843CFBF9A9AA),
        UINT64_C(0x59E50E8A1E88BABD), UINT64_C(0x0D0C771842584BB0),
        UINT64_C(0x314AB4CC7B648216), UINT64_C(0x65A3CD5E27B4731B),
        UINT64_C(0x989847E8C2C5600C), UINT64_C(0xCC713E7A9E159101),
        UINT64_C(0xE015C040B0BCF340), UINT64_C(0xB4FCB9D2EC6C024D),
        UINT64_C(0x49C73364091D115A), UINT64_C(0x1D2E4AF655CDE057),
        UINT64_C(0x216889226CF129F1), UINT64_C(0x7581F0B03021D8FC),
        UINT64_C(0x88BA7A06D550CBEB), UINT64_C(0xDC53039489803AE6),
        UINT64_C(0x11EA9EBA6AF9FFCD), UINT64_C(0x4503E72836290EC0),
        UINT64_C(0xB8386D9ED3581DD7), UINT64_C(0xECD1140C8F88ECDA),
        UINT64_C(0xD097D7D8B6B4257C), UINT64_C(0x847EAE4AEA64D471),
        UINT64_C(0x794524FC0F15C766), UINT64_C(0x2DAC5D6E53C5366B),
        UINT64_C(0x01C8A3547D6C542A), UINT64_C(0x5521DAC621BCA527),
        UINT64_C(0xA81A5070C4CDB630), UINT64_C(0xFCF329E2981D473D),
        UINT64_C(0xC0B5EA36A1218E9B), UINT64_C(0x945C93A4FDF17F96),
        UINT64_C(0x6967191218806C81), UINT64_C(0x3D8E608044509D8C),
        UINT64_C(0x31AEE56645D2A803), UINT64_C(0x65479CF41902590E),
        UINT64_C(0x987C1642FC734A19), UINT64_C(0xCC956FD0A0A3BB14),
        UINT64_C(0xF0D3AC04999F72B2), UINT64_C(0xA43AD596C54F83BF),
        UINT64_C(0x59015F20203E90A8), UINT64_C(0x0DE826B27CEE61A5),
        UINT64_C(0x218CD888524703E4), UINT64_C(0x7565A11A0E97F2E9),
        UINT64_C(0x885E2BACEBE6E1FE), UINT64_C(0xDCB7523EB73610F3),
        UINT64_C(0xE0F191EA8E0AD955), UINT64_C(0xB418E878D2DA2858),
        UINT64_C(0x492362CE37AB3B4F), UINT64_C(0x1DCA1B5C6B7BCA42),
        UINT64_C(0x5162690234AF5051), UINT64_C(0x058B1090687FA15C),
        UINT64_C(0xF8B09A268D0EB24B), UINT64_C(0xAC59E3B4D1DE4346),
        UINT64_C(0x901F2060E8E28AE0), UINT64_C(0xC4F659F2B4327BED),
        UINT64_C(0x39CDD344514368FA), UINT64_C(0x6D24AAD60D9399F7),
        UINT64_C(0x414054EC233AFBB6), UINT64_C(0x15A92D7E7FEA0ABB),
        UINT64_C(0xE892A7C89A9B19AC), UINT64_C(0xBC7BDE5AC64BE8A1),
        UINT64_C(0x803D1D8EFF772107), UINT64_C(0xD4D4641CA3A7D00A),
        UINT64_C(0x29EFEEAA46D6C31D), UINT64_C(0x7D0697381A063210),
        UINT64_C(0x712612DE1B84079F), UINT64_C(0x25CF6B4C4754F692),
        UINT64_C(0xD8F4E1FAA225E585), UINT64_C(0x8C1D9868FEF51488),
        UINT64_C(0xB05B5BBCC7C9DD2E), UINT64_C(0xE4B2222E9B192C23),
        UINT64_C(0x1989A8987E683F34), UINT64_C(0x4D60D10A22B8CE39),
        UINT64_C(0x61042F300C11AC78), UINT64_C(0x35ED56A250C15D75),
        UINT64_C(0xC8D6DC14B5B04E62), UINT64_C(0x9C3FA586E960BF6F),
        UINT64_C(0xA0796652D05C76C9), UINT64_C(0xF4901FC08C8C87C4),
        UINT64_C(0x09AB957669FD94D3), UINT64_C(0x5D42ECE4352D65DE)
    }, {
        UINT64_C(0x0000000000000000), UINT64_C(0x3F0BE14A916A6DCB),
        UINT64_C(0x7E17C29522D4DB96), UINT64_C(0x411C23DFB3BEB65D),
        UINT64_C(0xFC2F852A45A9B72C), UINT64_C(0xC3246460D4C3DAE7),
        UINT64_C(0x823847BF677D6CBA), UINT64_C(0xBD33A6F5F6170171),
        UINT64_C(0x6A87A57F245D70DD), UINT64_C(0x558C4435B5371D16),
        UINT64_C(0x149067EA0689AB4B), UINT64_C(0x2B9B86A097E3C680),
        UINT64_C(0x96A8205561F4C7F1), UINT64_C(0xA9A3C11FF09EAA3A),
        UINT64_C(0xE8BFE2C043201C67), UINT64_C(0xD7B4038AD24A71AC),
        UINT64_C(0xD50F4AFE48BAE1BA), UINT64_C(0xEA04ABB4D9D08C71),
        UINT64_C(0xAB18886B6A6E3A2C), UINT64_C(0x94136921FB0457E7),
        UINT64_C(0x2920CFD40D135696), UINT64_C(0x162B2E9E9C793B5D),
        UINT64_C(0x57370D412FC78D00), UINT64_C(0x683CEC0BBEADE0CB),
        UINT64_C(0xBF88EF816CE79167), UINT64_C(0x80830ECBFD8DFCAC),
        UINT64_C(0xC19F2D144E334AF1), UINT64_C(0xFE94CC5EDF59273A),
        UINT64_C(0x43A76AAB294E264B), UINT64_C(0x7CAC8BE1B8244B80),
        UINT64_C(0x3DB0A83E0B9AFDDD), UINT64_C(0x02BB49749AF09016),
        UINT64_C(0x38C63AD73E7BDDF1), UINT64_C(0x07CDDB9DAF11B03A),
        UINT64_C(0x46D1F8421CAF0667), UINT64_C(0x79DA19088DC56BAC),
        UINT64_C(0xC4E9BFFD7BD26ADD), UINT64_C(0xFBE25EB7EAB80716),
        UINT64_C(0xBAFE7D685906B14B), UINT64_C(0x85F59C22C86CDC80),
        UINT64_C(0x52419FA81A26AD2C), UINT64_C(0x6D4A7EE28B4CC0E7),
        UINT64_C(0x2C565D3D38F276BA), UINT64_C(0x135DBC77A9981B71),
        UINT64_C(0xAE6E1A825F8F1A00), UINT64_C(0x9165FBC8CEE577CB),
        UINT64_C(0xD079D8177D5BC196), UINT64_C(0xEF72395DEC31AC5D),
        UINT64_C(0xEDC9702976C13C4B), UINT64_C(0xD2C29163E7AB5180),
        UINT64_C(0x93DEB2BC5415E7DD), UINT64_C(0xACD553F6C57F8A16),
        UINT64_C(0x11E6F50333688B67), UINT64_C(0x2EED1449A202E6AC),
        UINT64_C(0x6FF1379611BC50F1), UINT64_C(0x50FAD6DC80D63D3A),
        UINT64_C(0x874ED556529C4C96), UINT64_C(0xB845341CC3F6215D),
        UINT64_C(0xF95917C370489700), UINT64_C(0xC652F689E122FACB),
        UINT64_C(0x7B61507C1735FBBA), UINT64_C(0x446AB136865F9671),
        UINT64_C(0x057692E935E1202C), UINT64_C(0x3A7D73A3A48B4DE7),
        UINT64_C(0x718C75AE7CF7BBE2), UINT64_C(0x4E8794E4ED9DD629),
        UINT64_C(0x0F9BB73B5E236074), UINT64_C(0x30905671CF490DBF),
        UINT64_C(0x8DA3F084395E0CCE), UINT64_C(0xB2A811CEA8346105),
        UINT64_C(0xF3B432111B8AD758), UINT64_C(0xCCBFD35B8AE0BA93),
        UINT64_C(0x1B0BD0D158AACB3F), UINT64_C(0x2400319BC9C0A6F4),
        UINT64_C(0x651C12447A7E10A9), UINT64_C(0x5A17F30EEB147D62),
        UINT64_C(0xE72455FB1D037C13), UINT64_C(0xD82FB4B18C6911D8),
        UINT64_C(0x9933976E3FD7A785), UINT64_C(0xA6387624AEBDCA4E),
        UINT64_C(0xA4833F50344D5A58), UINT64_C(0x9B88DE1AA5273793),
        UINT64_C(0xDA94FDC5169981CE), UINT64_C(0xE59F1C8F87F3EC05),
        UINT64_C(0x58ACBA7A71E4ED74), UINT64_C(0x67A75B30E08E80BF),
        UINT64_C(0x26BB78EF533036E2), UINT64_C(0x19B099A5C25A5B29),
        UINT64_C(0xCE049A2F10102A85), UINT64_C(0xF10F7B65817A474E),
        UINT64_C(0xB01358BA32C4F113), UINT64_C(0x8F18B9F0A3AE9CD8),
        UINT64_C(0x322B1F0555B99DA9), UINT64_C(0x0D20FE4FC4D3F062),
        UINT64_C(0x4C3CDD90776D463F), UINT64_C(0x73373CDAE6072BF4),
        UINT64_C(0x494A4F79428C6613), UINT64_C(0x7641AE33D3E60BD8),
        UINT64_C(0x375D8DEC6058BD85), UINT64_C(0x08566CA6F132D04E),
        UINT64_C(0xB565CA530725D13F), UINT64_C(0x8A6E2B19964FBCF4),
        UINT64_C(0xCB7208C625F10AA9), UINT64_C(0xF479E98CB49B6762),
        UINT64_C(0x23CDEA0666D116CE), UINT64_C(0x1CC60B4CF7BB7B05),
        UINT64_C(0x5DDA28934405CD58), UINT64_C(0x62D1C9D9D56FA093),
        UINT64_C(0xDFE26F2C2378A1E2), UINT64_C(0xE0E98E66B212CC29),
        UINT64_C(0xA1F5ADB901AC7A74), UINT64_C(0x9EFE4CF390C617BF),
        UINT64_C(0x9C4505870A3687A9), UINT64_C(0xA34EE4CD9B5CEA62),
        UINT64_C(0xE252C71228E25C3F), UINT64_C(0xDD592658B98831F4),
        UINT64_C(0x606A80AD4F9F3085), UINT64_C(0x5F6161E7DEF55D4E),
        UINT64_C(0x1E7D42386D4BEB13), UINT64_C(0x2176A372FC2186D8),
        UINT64_C(0xF6C2A0F82E6BF774), UINT64_C(0xC9C941B2BF019ABF),
        UINT64_C(0x88D5626D0CBF2CE2), UINT64_C(0xB7DE83279DD54129),
        UINT64_C(0x0AED25D26BC24058), UINT64_C(0x35E6C498FAA82D93),
        UINT64_C(0x74FAE74749169BCE), UINT64_C(0x4BF1060DD87CF605),
        UINT64_C(0xE318EB5CF9EF77C4), UINT64_C(0xDC130A1668851A0F),
        UINT64_C(0x9D0F29C9DB3BAC52), UINT64_C(0xA204C8834A51C199),
        UINT64_C(0x1F376E76BC46C0E8), UINT64_C(0x203C8F3C2D2CAD23),
        UINT64_C(0x6120ACE39E921B7E), UINT64_C(0x5E2B4DA90FF876B5),
        UINT64_C(0x899F4E23DDB20719), UINT64_C(0xB694AF694CD86AD2),
        UINT64_C(0xF7888CB6FF66DC8F), UINT64_C(0xC8836DFC6E0CB144),
        UINT64_C(0x75B0CB09981BB035), UINT64_C(0x4ABB2A430971DDFE),
        UINT64_C(0x0BA7099CBACF6BA3), UINT64_C(0x34ACE8D62BA50668),
        UINT64_C(0x3617A1A2B155967E), UINT64_C(0x091C40E8203FFBB5),
        UINT64_C(0x4800633793814DE8), UINT64_C(0x770B827D02EB2023),
        UINT64_C(0xCA382488F4FC2152), UINT64_C(0xF533C5C265964C99),
        UINT64_C(0xB42FE61DD628FAC4), UINT64_C(0x8B2407574742970F),
        UINT64_C(0x5C9004DD9508E6A3), UINT64_C(0x639BE59704628B68),
        UINT64_C(0x2287C648B7DC3D35), UINT64_C(0x1D8C270226B650FE),
        UINT64_C(0xA0BF81F7D0A1518F), UINT64_C(0x9FB460BD41CB3C44),
        UINT64_C(0xDEA84362F2758A19), UINT64_C(0xE1A3A228631FE7D2),
        UINT64_C(0xDBDED18BC794AA35), UINT64_C(0xE4D530C156FEC7FE),
        UINT64_C(0xA5C9131EE54071A3), UINT64_C(0x9AC2F254742A1C68),
        UINT64_C(0x27F154A1823D1D19), UINT64_C(0x18FAB5EB135770D2),
        UINT64_C(0x59E69634A0E9C68F), UINT64_C(0x66ED777E3183AB44),
        UINT64_C(0xB15974F4E3C9DAE8), UINT64_C(0x8E5295BE72A3B723),
        UINT64_C(0xCF4EB661C11D017E), UINT64_C(0xF045572B50776CB5),
        UINT64_C(0x4D76F1DEA6606DC4), UINT64_C(0x727D1094370A000F),
        UINT64_C(0x3361334B84B4B652), UINT64_C(0x0C6AD20115DEDB99),
        UINT64_C(0x0ED19B758F2E4B8F), UINT64_C(0x31DA7A3F1E442644),
        UINT64_C(0x70C659E0ADFA9019), UINT64_C(0x4FCDB8AA3C90FDD2),
        UINT64_C(0xF2FE1E5FCA87FCA3), UINT64_C(0xCDF5FF155BED9168),
        UINT64_C(0x8CE9DCCAE8532735), UINT64_C(0xB3E23D8079394AFE),
        UINT64_C(0x64563E0AAB733B52), UINT64_C(0x5B5DDF403A195699),
        UINT64_C(0x1A41FC9F89A7E0C4), UINT64_C(0x254A1DD518CD8D0F),
        UINT64_C(0x9879BB20EEDA8C7E), UINT64_C(0xA7725A6A7FB0E1B5),
        UINT64_C(0xE66E79B5CC0E57E8), UINT64_C(0xD96598FF5D643A23),
        UINT64_C(0x92949EF28518CC26), UINT64_C(0xAD9F7FB81472A1ED),
        UINT64_C(0xEC835C67A7CC17B0), UINT64_C(0xD388BD2D36A67A7B),
        UINT64_C(0x6EBB1BD8C0B17B0A), UINT64_C(0x51B0FA9251DB16C1),
        UINT64_C(0x10ACD94DE265A09C), UINT64_C(0x2FA73807730FCD57),
        UINT64_C(0xF8133B8DA145BCFB), UINT64_C(0xC718DAC7302FD130),
        UINT64_C(0x8604F9188391676D), UINT64_C(0xB90F185212FB0AA6),
        UINT64_C(0x043CBEA7E4EC0BD7), UINT64_C(0x3B375FED7586661C),
        UINT64_C(0x7A2B7C32C638D041), UINT64_C(0x45209D785752BD8A),
        UINT64_C(0x479BD40CCDA22D9C), UINT64_C(0x789035465CC84057),
        UINT64_C(0x398C1699EF76F60A), UINT64_C(0x0687F7D37E1C9BC1),
        UINT64_C(0xBBB45126880B9AB0), UINT64_C(0x84BFB06C1961F77B),
        UINT64_C(0xC5A393B3AADF4126), UINT64_C(0xFAA872F93BB52CED),
        UINT64_C(0x2D1C7173E9FF5D41), UINT64_C(0x121790397895308A),
        UINT64_C(0x530BB3E6CB2B86D7), UINT64_C(0x6C0052AC5A41EB1C),
        UINT64_C(0xD133F459AC56EA6D), UINT64_C(0xEE3815133D3C87A6),
        UINT64_C(0xAF2436CC8E8231FB), UINT64_C(0x902FD7861FE85C30),
        UINT64_C(0xAA52A425BB6311D7), UINT64_C(0x9559456F2A097C1C),
        UINT64_C(0xD44566B099B7CA41), UINT64_C(0xEB4E87FA08DDA78A),
        UINT64_C(0x567D210FFECAA6FB), UINT64_C(0x6976C0456FA0CB30),
        UINT64_C(0x286AE39ADC1E7D6D), UINT64_C(0x176102D04D7410A6),
        UINT64_C(0xC0D5015A9F3E610A), UINT64_C(0xFFDEE0100E540CC1),
        UINT64_C(0xBEC2C3CFBDEABA9C), UINT64_C(0x81C922852C80D757),
        UINT64_C(0x3CFA8470DA97D626), UINT64_C(0x03F1653A4BFDBBED),
        UINT64_C(0x42ED46E5F8430DB0), UINT64_C(0x7DE6A7AF6929607B),
        UINT64_C(0x7F5DEEDBF3D9F06D), UINT64_C(0x40560F9162B39DA6),
        UINT64_C(0x014A2C4ED10D2BFB), UINT64_C(0x3E41CD0440674630),
        UINT64_C(0x83726BF1B6704741), UINT64_C(0xBC798ABB271A2A8A),
        UINT64_C(0xFD65A96494A49CD7), UINT64_C(0xC26E482E05CEF11C),
        UINT64_C(0x15DA4BA4D78480B0), UINT64_C(0x2AD1AAEE46EEED7B),
        UINT64_C(0x6BCD8931F5505B26), UINT64_C(0x54C6687B643A36ED),
        UINT64_C(0xE9F5CE8E922D379C), UINT64_C(0xD6FE2FC403475A57),
        UINT64_C(0x97E20C1BB0F9EC0A), UINT64_C(0xA8E9ED51219381C1)
    }, {
        UINT64_C(0x0000000000000000), UINT64_C(0x1DEE8A5E222CA1DC),
        UINT64_C(0x3BDD14BC445943B8), UINT64_C(0x26339EE26675E264),
        UINT64_C(0x77BA297888B28770), UINT64_C(0x6A54A326AA9E26AC),
        UINT64_C(0x4C673DC4CCEBC4C8), UINT64_C(0x5189B79AEEC76514),
        UINT64_C(0xEF7452F111650EE0), UINT64_C(0xF29AD8AF3349AF3C),
        UINT64_C(0xD4A9464D553C4D58), UINT64_C(0xC947CC137710EC84),
        UINT64_C(0x98CE7B8999D78990), UINT64_C(0x8520F1D7BBFB284C),
        UINT64_C(0xA3136F35DD8ECA28), UINT64_C(0xBEFDE56BFFA26BF4),
        UINT64_C(0x4C300AC98DC40345), UINT64_C(0x51DE8097AFE8A299),
        UINT64_C(0x77ED1E75C99D40FD), UINT64_C(0x6A03942BEBB1E121),
        UINT64_C(0x3B8A23B105768435), UINT64_C(0x2664A9EF275A25E9),
        UINT64_C(0x0057370D412FC78D), UINT64_C(0x1DB9BD5363036651),
        UINT64_C(0xA34458389CA10DA5), UINT64_C(0xBEAAD266BE8DAC79),
        UINT64_C(0x98994C84D8F84E1D), UINT64_C(0x8577C6DAFAD4EFC1),
        UINT64_C(0xD4FE714014138AD5), UINT64_C(0xC910FB1E363F2B09),
        UINT64_C(0xEF2365FC504AC96D), UINT64_C(0xF2CDEFA2726668B1),
        UINT64_C(0x986015931B88068A), UINT64_C(0x858E9FCD39A4A756),
        UINT64_C(0xA3BD012F5FD14532), UINT64_C(0xBE538B717DFDE4EE),
        UINT64_C(0xEFDA3CEB933A81FA), UINT64_C(0xF234B6B5B1162026),
        UINT64_C(0xD4072857D763C242), UINT64_C(0xC9E9A209F54F639E),
        UINT64_C(0x771447620AED086A), UINT64_C(0x6AFACD3C28C1A9B6),
        UINT64_C(0x4CC953DE4EB44BD2), UINT64_C(0x5127D9806C98EA0E),
        UINT64_C(0x00AE6E1A825F8F1A), UINT64_C(0x1D40E444A0732EC6),
        UINT64_C(0x3B737AA6C606CCA2), UINT64_C(0x269DF0F8E42A6D7E),
        UINT64_C(0xD4501F5A964C05CF), UINT64_C(0xC9BE9504B460A413),
        UINT64_C(0xEF8D0BE6D2154677), UINT64_C(0xF26381B8F039E7AB),
        UINT64_C(0xA3EA36221EFE82BF), UINT64_C(0xBE04BC7C3CD22363),
        UINT64_C(0x9837229E5AA7C107), UINT64_C(0x85D9A8C0788B60DB),
        UINT64_C(0x3B244DAB87290B2F), UINT64_C(0x26CAC7F5A505AAF3),
        UINT64_C(0x00F95917C3704897), UINT64_C(0x1D17D349E15CE94B),
        UINT64_C(0x4C9E64D30F9B8C5F), UINT64_C(0x5170EE8D2DB72D83),
        UINT64_C(0x7743706F4BC2CFE7), UINT64_C(0x6AADFA3169EE6E3B),
        UINT64_C(0xA218840D981E1391), UINT64_C(0xBFF60E53BA32B24D),
        UINT64_C(0x99C590B1DC475029), UINT64_C(0x842B1AEFFE6BF1F5),
        UINT64_C(0xD5A2AD7510AC94E1), UINT64_C(0xC84C272B3280353D),
        UINT64_C(0xEE7FB9C954F5D759), UINT64_C(0xF391339776D97685),
        UINT64_C(0x4D6CD6FC897B1D71), UINT64_C(0x50825CA2AB57BCAD),
        UINT64_C(0x76B1C240CD225EC9), UINT64_C(0x6B5F481EEF0EFF15),
        UINT64_C(0x3AD6FF8401C99A01), UINT64_C(0x273875DA23E53BDD),
        UINT64_C(0x010BEB384590D9B9), UINT64_C(0x1CE5616667BC7865),
        UINT64_C(0xEE288EC415DA10D4), UINT64_C(0xF3C6049A37F6B108),
        UINT64_C(0xD5F59A785183536C), UINT64_C(0xC81B102673AFF2B0),
        UINT64_C(0x9992A7BC9D6897A4), UINT64_C(0x847C2DE2BF443678),
        UINT64_C(0xA24FB300D931D41C), UINT64_C(0xBFA1395EFB1D75C0),
        UINT64_C(0x015CDC3504BF1E34), UINT64_C(0x1CB2566B2693BFE8),
        UINT64_C(0x3A81C88940E65D8C), UINT64_C(0x276F42D762CAFC50),
        UINT64_C(0x76E6F54D8C0D9944), UINT64_C(0x6B087F13AE213898),
        UINT64_C(0x4D3BE1F1C854DAFC), UINT64_C(0x50D56BAFEA787B20),
        UINT64_C(0x3A78919E8396151B), UINT64_C(0x27961BC0A1BAB4C7),
        UINT64_C(0x01A58522C7CF56A3), UINT64_C(0x1C4B0F7CE5E3F77F),
        UINT64_C(0x4DC2B8E60B24926B), UINT64_C(0x502C32B8290833B7),
        UINT64_C(0x761FAC5A4F7DD1D3), UINT64_C(0x6BF126046D51700F),
        UINT64_C(0xD50CC36F92F31BFB), UINT64_C(0xC8E24931B0DFBA27),
        UINT64_C(0xEED1D7D3D6AA5843), UINT64_C(0xF33F5D8DF486F99F),
        UINT64_C(0xA2B6EA171A419C8B), UINT64_C(0xBF586049386D3D57),
        UINT64_C(0x996BFEAB5E18DF33), UINT64_C(0x848574F57C347EEF),
        UINT64_C(0x76489B570E52165E), UINT64_C(0x6BA611092C7EB782),
        UINT64_C(0x4D958FEB4A0B55E6), UINT64_C(0x507B05B56827F43A),
        UINT64_C(0x01F2B22F86E0912E), UINT64_C(0x1C1C3871A4CC30F2),
        UINT64_C(0x3A2FA693C2B9D296), UINT64_C(0x27C12CCDE095734A),
        UINT64_C(0x993CC9A61F3718BE), UINT64_C(0x84D243F83D1BB962),
        UINT64_C(0xA2E1DD1A5B6E5B06), UINT64_C(0xBF0F57447942FADA),
        UINT64_C(0xEE86E0DE97859FCE), UINT64_C(0xF3686A80B5A93E12),
        UINT64_C(0xD55BF462D3DCDC76), UINT64_C(0xC8B57E3CF1F07DAA),
        UINT64_C(0xD6E9A7309F3239A7), UINT64_C(0xCB072D6EBD1E987B),
        UINT64_C(0xED34B38CDB6B7A1F), UINT64_C(0xF0DA39D2F947DBC3),
        UINT64_C(0xA1538E481780BED7), UINT64_C(0xBCBD041635AC1F0B),
        UINT64_C(0x9A8E9AF453D9FD6F), UINT64_C(0x876010AA71F55CB3),
        UINT64_C(0x399DF5C18E573747), UINT64_C(0x24737F9FAC7B969B),
        UINT64_C(0x0240E17DCA0E74FF), UINT64_C(0x1FAE6B23E822D523),
        UINT64_C(0x4E27DCB906E5B037), UINT64_C(0x53C956E724C911EB),
        UINT64_C(0x75FAC80542BCF38F), UINT64_C(0x6814425B60905253),
        UINT64_C(0x9AD9ADF912F63AE2), UINT64_C(0x873727A730DA9B3E),
        UINT64_C(0xA104B94556AF795A), UINT64_C(0xBCEA331B7483D886),
        UINT64_C(0xED6384819A44BD92), UINT64_C(0xF08D0EDFB8681C4E),
        UINT64_C(0xD6BE903DDE1DFE2A), UINT64_C(0xCB501A63FC315FF6),
        UINT64_C(0x75ADFF0803933402), UINT64_C(0x6843755621BF95DE),
        UINT64_C(0x4E70EBB447CA77BA), UINT64_C(0x539E61EA65E6D666),
        UINT64_C(0x0217D6708B21B372), UINT64_C(0x1FF95C2EA90D12AE),
        UINT64_C(0x39CAC2CCCF78F0CA), UINT64_C(0x24244892ED545116),
        UINT64_C(0x4E89B2A384BA3F2D), UINT64_C(0x536738FDA6969EF1),
        UINT64_C(0x7554A61FC0E37C95), UINT64_C(0x68BA2C41E2CFDD49),
        UINT64_C(0x39339BDB0C08B85D), UINT64_C(0x24DD11852E241981),
        UINT64_C(0x02EE8F674851FBE5), UINT64_C(0x1F0005396A7D5A39),
        UINT64_C(0xA1FDE05295DF31CD), UINT64_C(0xBC136A0CB7F39011),
        UINT64_C(0x9A20F4EED1867275), UINT64_C(0x87CE7EB0F3AAD3A9),
        UINT64_C(0xD647C92A1D6DB6BD), UINT64_C(0xCBA943743F411761),
        UINT64_C(0xED9ADD965934F505), UINT64_C(0xF07457C87B1854D9),
        UINT64_C(0x02B9B86A097E3C68), UINT64_C(0x1F5732342B529DB4),
        UINT64_C(0x3964ACD64D277FD0), UINT64_C(0x248A26886F0BDE0C),
        UINT64_C(0x7503911281CCBB18), UINT64_C(0x68ED1B4CA3E01AC4),
        UINT64_C(0x4EDE85AEC595F8A0), UINT64_C(0x53300FF0E7B9597C),
        UINT64_C(0xEDCDEA9B181B3288), UINT64_C(0xF02360C53A379354),
        UINT64_C(0xD610FE275C427130), UINT64_C(0xCBFE74797E6ED0EC),
        UINT64_C(0x9A77C3E390A9B5F8), UINT64_C(0x879949BDB2851424),
        UINT64_C(0xA1AAD75FD4F0F640), UINT64_C(0xBC445D01F6DC579C),
        UINT64_C(0x74F1233D072C2A36), UINT64_C(0x691FA96325008BEA),
        UINT64_C(0x4F2C37814375698E), UINT64_C(0x52C2BDDF6159C852),
        UINT64_C(0x034B0A458F9EAD46), UINT64_C(0x1EA5801BADB20C9A),
        UINT64_C(0x38961EF9CBC7EEFE), UINT64_C(0x257894A7E9EB4F22),
        UINT64_C(0x9B8571CC164924D6), UINT64_C(0x866BFB923465850A),
        UINT64_C(0xA05865705210676E), UINT64_C(0xBDB6EF2E703CC6B2),
        UINT64_C(0xEC3F58B49EFBA3A6), UINT64_C(0xF1D1D2EABCD7027A),
        UINT64_C(0xD7E24C08DAA2E01E), UINT64_C(0xCA0CC656F88E41C2),
        UINT64_C(0x38C129F48AE82973), UINT64_C(0x252FA3AAA8C488AF),
        UINT64_C(0x031C3D48CEB16ACB), UINT64_C(0x1EF2B716EC9DCB17),
        UINT64_C(0x4F7B008C025AAE03), UINT64_C(0x52958AD220760FDF),
        UINT64_C(0x74A614304603EDBB), UINT64_C(0x69489E6E642F4C67),
        UINT64_C(0xD7B57B059B8D2793), UINT64_C(0xCA5BF15BB9A1864F),
        UINT64_C(0xEC686FB9DFD4642B), UINT64_C(0xF186E5E7FDF8C5F7),
        UINT64_C(0xA00F527D133FA0E3), UINT64_C(0xBDE1D8233113013F),
        UINT64_C(0x9BD246C15766E35B), UINT64_C(0x863CCC9F754A4287),
        UINT64_C(0xEC9136AE1CA42CBC), UINT64_C(0xF17FBCF03E888D60),
        UINT64_C(0xD74C221258FD6F04), UINT64_C(0xCAA2A84C7AD1CED8),
        UINT64_C(0x9B2B1FD69416ABCC), UINT64_C(0x86C59588B63A0A10),
        UINT64_C(0xA0F60B6AD04FE874), UINT64_C(0xBD188134F26349A8),
        UINT64_C(0x03E5645F0DC1225C), UINT64_C(0x1E0BEE012FED8380),
        UINT64_C(0x383870E3499861E4), UINT64_C(0x25D6FABD6BB4C038),
        UINT64_C(0x745F4D278573A52C), UINT64_C(0x69B1C779A75F04F0),
        UINT64_C(0x4F82599BC12AE694), UINT64_C(0x526CD3C5E3064748),
        UINT64_C(0xA0A13C6791602FF9), UINT64_C(0xBD4FB639B34C8E25),
        UINT64_C(0x9B7C28DBD5396C41), UINT64_C(0x8692A285F715CD9D),
        UINT64_C(0xD71B151F19D2A889), UINT64_C(0xCAF59F413BFE0955),
        UINT64_C(0xECC601A35D8BEB31), UINT64_C(0xF1288BFD7FA74AED),
        UINT64_C(0x4FD56E9680052119), UINT64_C(0x523BE4C8A22980C5),
        UINT64_C(0x74087A2AC45C62A1), UINT64_C(0x69E6F074E670C37D),
        UINT64_C(0x386F47EE08B7A669), UINT64_C(0x2581CDB02A9B07B5),
        UINT64_C(0x03B253524CEEE5D1), UINT64_C(0x1E5CD90C6EC2440D)
    }
};
#endif

extern uint64_t
ls_crc64(uint64_t crc, const uint8_t *buf, size_t size)
{
    crc = ~crc;

#ifdef WORDS_BIGENDIAN
    crc = bswap_64(crc);
#endif

    if (size > 4)
    {
        while ((uintptr_t)(buf) & 3)
        {
            crc = ls_crc64_table[0][*buf++ ^ A1(crc)] ^ S8(crc);
            --size;
        }

        const uint8_t *const limit = buf + (size & ~(size_t)(3));
        size &= (size_t)(3);

        // Calculate the CRC64 using the slice-by-four algorithm.
        //
        // In contrast to CRC32 code, this one seems to be fastest
        // with -O3 -fomit-frame-pointer.
        while (buf < limit)
        {
#ifdef WORDS_BIGENDIAN
            const uint32_t tmp = (crc >> 32) ^ *(uint32_t *)(buf);
#else
            const uint32_t tmp = crc ^ *(uint32_t *)(buf);
#endif
            buf += 4;

            // It is critical for performance, that
            // the crc variable is XORed between the
            // two table-lookup pairs.
            crc = ls_crc64_table[3][A(tmp)]
                  ^ ls_crc64_table[2][B(tmp)]
                  ^ S32(crc)
                  ^ ls_crc64_table[1][C(tmp)]
                  ^ ls_crc64_table[0][D(tmp)];
        }
    }

    while (size-- != 0)
        crc = ls_crc64_table[0][*buf++ ^ A1(crc)] ^ S8(crc);

#ifdef WORDS_BIGENDIAN
    crc = bswap_64(crc);
#endif

    return ~crc;
}









