<?php

class Service extends ControllerBase
{

	public static function singleton()
	{
		if (!isset(self::$_instance)) {
			self::$_instance = new self();
		}

		return self::$_instance;
	}

	public static function ConfigDispData()
	{
		$cc = self::singleton();

		$data = $cc->process_config();
		// temp
		if (is_a($data, 'DaData')) {
			$data = $data->GetRootNode();
        }
		$cc->_disp->Set(DInfo::FLD_PgData, $data);

		return $cc->_disp;
	}

	protected function getConfFilePath($type, $name='')
	{
		$path = null;

		if ( $type == DInfo::CT_SERV) {
			$path = SERVER_ROOT . 'conf/httpd_config.conf' ; //fixed location
		}
		elseif ( $type ==  DInfo::CT_ADMIN) {
			$adminRoot = PathTool::GetAbsFile('$SERVER_ROOT/admin/','SR'); //fixed loc

			if ($name == '') {
				$path = $adminRoot . 'conf/admin_config.conf' ;
			} elseif ($name == 'key') {
				$path = $adminRoot . 'conf/jcryption_keypair' ;
			}
		}
		elseif ( $type ==  DInfo::CT_VH ) {
			$vh = $this->_serv->GetChildNodeById('virtualhost', $name);
			if ($vh != null) {
				$vhrootpath = $vh->GetChildVal('vhRoot');
				$path = PathTool::GetAbsFile($vh->GetChildVal('configFile'), 'VR', $name, $vhrootpath);
			}
			else {
				die ("cannot find config file for vh $name\n");
				// should set as conf err
			}
		}

		return $path;
	}

	protected function getConfData()
	{
		$view = $this->_disp->Get(DInfo::FLD_View);
		$pid = $this->_disp->Get(DInfo::FLD_PID);
		$tid = $this->_disp->Get(DInfo::FLD_TID);

		if ( ($view == DInfo::CT_SERV && strpos($tid, 'S_MIME') !== false)
			|| ($view == DInfo::CT_ADMIN && $pid == 'usr')
			|| ($view == DInfo::CT_VH && (strpos($tid, 'V_UDB') !== false || strpos($tid, 'V_GDB') !== false))) {
			$confdata = $this->_special;
		}
		elseif ($this->_disp->Get(DInfo::FLD_ConfType) == DInfo::CT_ADMIN) {
			$confdata = $this->_admin;
		}
		else  {
			$confdata = $this->_serv;
		}

		$this->_disp->Set(DInfo::FLD_ConfData, $confdata);
		return $confdata;
	}

	protected function load_server_config($load_admin=false)
	{
		$this->_serv = new DaData(DInfo::CT_SERV, $this->getConfFilePath(DInfo::CT_SERV));
		$this->_disp->Set(DInfo::FLD_ServData, $this->_serv);
		if (($conferr = $this->_serv->GetConfErr()) != null) {
			$this->_disp->Set(DInfo::FLD_TopMsg, $conferr);
		}

		$has_set_timout = CAuthorizer::HasSetTimeout();
		if (!$has_set_timout || $load_admin) {
			$this->_admin = new DaData(DInfo::CT_ADMIN, $this->getConfFilePath(DInfo::CT_ADMIN));
			if (($conferr = $this->_admin->GetConfErr()) != null)
				$this->_disp->Set(DInfo::FLD_TopMsg, $conferr);

			if (!$has_set_timout) {
				$timeout = $this->_admin->GetChildVal('sessionTimeout');
				if ($timeout == null)
					$timeout = 60; // default
				CAuthorizer::SetTimeout($timeout);
			}
		}
	}

	protected function loadConfig()
	{
		// always load serv
		$this->load_server_config(($this->_disp->Get(DInfo::FLD_ConfType) == DInfo::CT_ADMIN));
		$view = $this->_disp->Get(DInfo::FLD_View);
		$pid = $this->_disp->Get(DInfo::FLD_PID);
		$tid = $this->_disp->Get(DInfo::FLD_TID);

		// special
		if ($view == DInfo::CT_SERV && strpos($tid, 'S_MIME') !== false) {
			$mime = $this->_serv->GetChildrenValues('mime');
			$file = PathTool::GetAbsFile($mime[0], 'SR');
			$this->_special = new DaData(DInfo::CT_EX, $file, 'MIME');
			if (($conferr = $this->_special->GetConfErr()) != null)
				$this->_disp->Set(DInfo::FLD_TopMsg, $conferr);

		}
		elseif ($view == DInfo::CT_ADMIN && $pid == 'usr') {
			$file = SERVER_ROOT . 'admin/conf/htpasswd';
			$this->_special = new DaData(DInfo::CT_EX, $file, 'ADMUSR');
			if (($conferr = $this->_special->GetConfErr()) != null)
				$this->_disp->Set(DInfo::FLD_TopMsg, $conferr);
		}
		elseif ($view == DInfo::CT_VH &&
				(($isudb = strpos($tid, 'V_UDB')) !== false || strpos($tid, 'V_GDB') !== false )) {
			$realm = $this->_curOne->GetChildNodeById('realm', $this->_disp->GetFirst(DInfo::FLD_REF));
			if ($realm != null) {
				$isudb = ($isudb !== false);
				$file = $realm->GetChildVal($isudb ? 'userDB:location' : 'groupDB:location');
				$vhroot = $this->_disp->GetVHRoot();
				$file = PathTool::GetAbsFile($file, 'VR', $this->_disp->Get(DInfo::FLD_ViewName), $vhroot);
				$this->_special = new DaData(DInfo::CT_EX, $file, $isudb ? 'V_UDB' : 'V_GDB');
				if (($conferr = $this->_special->GetConfErr()) != null)
					$this->_disp->Set(DInfo::FLD_TopMsg, $conferr);
			}
		}

	}

	protected function process_config()
	{
		//init here
		$this->_disp->InitConf();
        if ($this->_disp->Get(DInfo::FLD_View) == 'vh_' && $this->_disp->Get(DInfo::FLD_REF) == '') {
            $this->_disp->Set(DInfo::FLD_REF, $this->_disp->Get(DInfo::FLD_ViewName) );
        }

		$this->loadConfig();

		$confdata = $this->getConfData($this->_disp);

		$needTrim = 0;
		$tblDef = DTblDef::GetInstance();
		$disp_act = $this->_disp->Get(DInfo::FLD_ACT);

		if ( $needTrim ) {
			$this->_disp->TrimLastId();
			// need reload
			$this->loadConfig();
			$confdata = $this->getConfData($this->_disp);
		}

		return $confdata;
	}



}
