/* Copyright (c) 2017 - 2021 LiteSpeed Technologies Inc.  See LICENSE. */
#line 2 "ls-sfparser.c"
#line 2 "ls-sfparser.l"
/*
MIT License

Copyright (c) 2020 LiteSpeed Technologies Inc

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
*/



#line 30 "ls-sfparser.c"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 5
#define YY_FLEX_SUBMINOR_VERSION 35
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#endif /* ! C99 */

#endif /* ! FLEXINT_H */

#ifdef __cplusplus

/* The "const" storage-class-modifier is valid. */
#define YY_USE_CONST

#else	/* ! __cplusplus */

/* C99 requires __STDC__ to be defined as 1. */
#if defined (__STDC__)

#define YY_USE_CONST

#endif	/* defined (__STDC__) */
#endif	/* ! __cplusplus */

#ifdef YY_USE_CONST
#define yyconst const
#else
#define yyconst
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)

/* An opaque pointer. */
#ifndef YY_TYPEDEF_YY_SCANNER_T
#define YY_TYPEDEF_YY_SCANNER_T
typedef void* yyscan_t;
#endif

/* For convenience, these vars (plus the bison vars far below)
   are macros in the reentrant scanner. */
#define yyin yyg->yyin_r
#define yyout yyg->yyout_r
#define yyextra yyg->yyextra_r
#define yyleng yyg->yyleng_r
#define yytext yyg->yytext_r
#define yylineno (YY_CURRENT_BUFFER_LVALUE->yy_bs_lineno)
#define yycolumn (YY_CURRENT_BUFFER_LVALUE->yy_bs_column)
#define yy_flex_debug yyg->yy_flex_debug_r

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN yyg->yy_start = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START ((yyg->yy_start - 1) / 2)
#define YYSTATE YY_START

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE ls_sfp_restart(yyin ,yyscanner )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k.
 * Moreover, YY_BUF_SIZE is 2*YY_READ_BUF_SIZE in the general case.
 * Ditto for the __ia64__ case accordingly.
 */
#define YY_BUF_SIZE 32768
#else
#define YY_BUF_SIZE 16384
#endif /* __ia64__ */
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

    #define YY_LESS_LINENO(n)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = yyg->yy_hold_char; \
		YY_RESTORE_YY_MORE_OFFSET \
		yyg->yy_c_buf_p = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )

#define unput(c) yyunput( c, yyg->yytext_ptr , yyscanner )

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef size_t yy_size_t;
#endif

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	yy_size_t yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */
    
	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via ls_sfp_restart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( yyg->yy_buffer_stack \
                          ? yyg->yy_buffer_stack[yyg->yy_buffer_stack_top] \
                          : NULL)

/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE yyg->yy_buffer_stack[yyg->yy_buffer_stack_top]

void ls_sfp_restart (FILE *input_file ,yyscan_t yyscanner );
void ls_sfp__switch_to_buffer (YY_BUFFER_STATE new_buffer ,yyscan_t yyscanner );
YY_BUFFER_STATE ls_sfp__create_buffer (FILE *file,int size ,yyscan_t yyscanner );
void ls_sfp__delete_buffer (YY_BUFFER_STATE b ,yyscan_t yyscanner );
void ls_sfp__flush_buffer (YY_BUFFER_STATE b ,yyscan_t yyscanner );
void ls_sfp_push_buffer_state (YY_BUFFER_STATE new_buffer ,yyscan_t yyscanner );
void ls_sfp_pop_buffer_state (yyscan_t yyscanner );

static int ls_sfp_ensure_buffer_stack (yyscan_t yyscanner );
static void ls_sfp__load_buffer_state (yyscan_t yyscanner );
static void ls_sfp__init_buffer (YY_BUFFER_STATE b,FILE *file ,yyscan_t yyscanner );

#define YY_FLUSH_BUFFER ls_sfp__flush_buffer(YY_CURRENT_BUFFER ,yyscanner)

YY_BUFFER_STATE ls_sfp__scan_buffer (char *base,yy_size_t size ,yyscan_t yyscanner );
YY_BUFFER_STATE ls_sfp__scan_string (yyconst char *yy_str ,yyscan_t yyscanner );
YY_BUFFER_STATE ls_sfp__scan_bytes (yyconst char *bytes,int len ,yyscan_t yyscanner );

void *ls_sfp_alloc (yy_size_t ,yyscan_t yyscanner );
void *ls_sfp_realloc (void *,yy_size_t ,yyscan_t yyscanner );
void ls_sfp_free (void * ,yyscan_t yyscanner );

#define yy_new_buffer ls_sfp__create_buffer

#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        ls_sfp_ensure_buffer_stack (yyscanner); \
		YY_CURRENT_BUFFER_LVALUE =    \
            ls_sfp__create_buffer(yyin,YY_BUF_SIZE ,yyscanner); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}

#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        ls_sfp_ensure_buffer_stack (yyscanner); \
		YY_CURRENT_BUFFER_LVALUE =    \
            ls_sfp__create_buffer(yyin,YY_BUF_SIZE ,yyscanner); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}

#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* Begin user sect3 */

#define ls_sfp_wrap(n) 1
#define YY_SKIP_YYWRAP

typedef unsigned char YY_CHAR;

typedef int yy_state_type;

#define yytext_ptr yytext_r

static yy_state_type yy_get_previous_state (yyscan_t yyscanner );
static yy_state_type yy_try_NUL_trans (yy_state_type current_state  ,yyscan_t yyscanner);
static int yy_get_next_buffer (yyscan_t yyscanner );
static void yy_fatal_error (yyconst char msg[] ,yyscan_t yyscanner );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	yyg->yytext_ptr = yy_bp; \
	yyleng = (size_t) (yy_cp - yy_bp); \
	yyg->yy_hold_char = *yy_cp; \
	*yy_cp = '\0'; \
	yyg->yy_c_buf_p = yy_cp;

#define YY_NUM_RULES 93
#define YY_END_OF_BUFFER 94
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static yyconst flex_int16_t yy_accept[365] =
    {   0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,   94,   93,    1,    2,   93,   93,    8,    7,
        6,   93,   33,   93,   30,   93,   93,    3,    4,   37,
       39,   38,   45,   43,   44,   42,   40,   41,   93,   49,
       93,   46,   93,   93,   64,   66,   65,   54,   52,   53,
       55,   93,   56,   60,   93,   57,   93,   93,   67,   93,

       75,   93,   72,   93,   93,   69,   71,   70,   68,   78,
       93,   82,   93,   79,   93,   93,   85,   86,   90,   91,
       89,   87,   88,   93,    9,   13,   93,   10,   93,   93,
       18,   17,   16,   19,   21,   23,   22,   20,   93,   27,
       93,   24,   93,   93,   92,    1,    2,    0,    8,    0,
        7,    8,    5,    0,   32,    0,   33,   30,    0,   30,
        0,   34,   35,    3,    4,   37,   36,   38,   45,   40,
       41,    0,   48,    0,   49,   46,    0,   46,    0,   50,
       51,   64,   63,   65,   52,   55,    0,   59,    0,   56,
       60,   57,    0,   57,    0,   61,   62,   67,    0,   74,

        0,   75,   72,    0,   72,    0,   76,   77,   69,   78,
        0,   81,    0,   82,   79,    0,   79,    0,   83,   84,
       85,   86,   90,   87,   88,    0,   12,    0,   13,   10,
        0,   10,    0,   14,   15,   18,   16,   16,   19,   21,
        0,   26,    0,   27,   24,    0,   24,    0,   28,   29,
        5,   31,   30,   47,   46,   58,   57,   73,   72,   80,
       79,   11,   10,   25,   24,   31,   30,   47,   46,   58,
       57,   73,   72,   80,   79,   11,   10,   25,   24,   31,
       30,   47,   46,   58,   57,   73,   72,   80,   79,   11,
       10,   25,   24,   30,   46,   57,   72,   79,   10,   24,

       30,   46,   57,   72,   79,   10,   24,   30,   46,   57,
       72,   79,   10,   24,   30,   46,   57,   72,   79,   10,
       24,   30,   46,   57,   72,   79,   10,   24,   30,   46,
       57,   72,   79,   10,   24,   30,   46,   57,   72,   79,
       10,   24,   30,   46,   57,   72,   79,   10,   24,   30,
       46,   57,   72,   79,   10,   24,   30,   46,   57,   72,
       79,   10,   24,    0
    } ;

static yyconst flex_int32_t yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    4,    5,    6,    7,    7,    7,    7,    7,    8,
        9,   10,   11,   12,   13,   14,   11,   15,   15,   16,
       16,   16,   16,   16,   16,   16,   16,   17,   18,   19,
       20,   19,   21,   19,   22,   22,   22,   22,   22,   22,
       22,   22,   22,   22,   22,   22,   22,   22,   22,   22,
       22,   22,   22,   22,   22,   22,   22,   22,   22,   22,
       19,   23,   24,   25,   26,   25,   27,   27,   27,   27,

       27,   27,   27,   27,   27,   27,   27,   27,   27,   27,
       27,   27,   27,   27,   27,   27,   27,   27,   27,   27,
       27,   27,   24,   25,   24,   25,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static yyconst flex_int32_t yy_meta[28] =
    {   0,
        1,    1,    1,    2,    3,    2,    3,    2,    2,    4,
        5,    2,    4,    4,    6,    6,    5,    2,    2,    7,
        2,    5,    2,    2,    3,    4,    6
    } ;

static yyconst flex_int16_t yy_base[395] =
    {   0,
        0,    0,    0,    1,   27,   46,   61,    0,    5,   10,
        4,   22,   26,   31,    9,   52,   83,    0,   51,   68,
       99,  104,  115,    0,   15,   58,  137,    0,  137,  156,
      173,    0,   55,   57,   77,  109,  108,  129,    0,    0,
      195,    0,  157,  163,   82,  124,  178,  205,  220,    0,
      803,  802,  804,  807,  799,    0,  136,  195,   19,  807,
      794,  139,    0,    2,  155,  784,  785,   50,    0,  216,
      807,  795,  794,  807,  807,  807,  793,    0,  140,    0,
       75,  177,  779,  780,  225,  807,  790,  807,  118,  807,
      122,  179,  789,    0,   99,  224,  775,  776,    0,  209,

        0,  229,  234,  773,  774,  784,  807,  807,  807,  783,
      240,    0,  236,  239,  769,  770,  780,  779,  778,  807,
      807,  777,    0,  250,  807,    0,  242,  245,  763,  764,
      258,  807,  760,    0,  744,  807,  807,  807,  258,    0,
      250,  253,  702,  675,  807,  683,    0,  268,  176,  273,
      807,  217,  667,  265,  807,  272,    0,  268,  271,  278,
      365,  807,  807,  294,    0,  295,  807,  374,  307,  275,
        0,  283,  807,  284,    0,  286,  288,  294,  257,  807,
      807,  310,  807,  227,  313,  314,  299,  807,  313,  224,
        0,  309,  305,  315,  207,  807,  807,    0,  320,  807,

      321,    0,  318,  322,  325,  189,  807,  807,  199,  180,
      329,  807,  336,    0,  331,  333,  339,  156,  807,  807,
      161,  140,   90,   83,    0,  344,  807,  345,    0,  342,
      345,  348,   67,  807,  807,  361,   61,   56,    0,   53,
      360,  807,  363,    0,  356,  358,  361,   24,  807,  807,
       29,  365,  373,  369,  376,  378,  381,  383,  386,  388,
      391,  393,  396,  398,  401,  403,  406,  408,  411,  413,
      416,  418,  421,  423,  426,  428,  431,  433,  436,  807,
      439,  807,  442,  807,  445,  807,  448,  807,  451,  807,
      454,  807,  457,  460,  463,  466,  469,  472,  475,  478,

      481,  484,  487,  490,  493,  496,  499,  502,  505,  508,
      511,  514,  517,  520,  523,  526,  529,  532,  535,  538,
      541,  544,  547,  550,  553,  556,  559,  562,  565,  568,
      571,  574,  577,  580,  583,  586,  589,  592,  595,  598,
      601,  604,  606,  608,  610,  612,  614,  616,  618,  620,
      622,  624,  626,  628,  630,  632,  807,  807,  807,  807,
      807,  807,  807,  807,  648,  655,  662,  666,  671,  676,
      678,  682,  685,  690,  695,  697,  703,  708,  710,  714,
      719,  724,  726,  732,  737,  739,  743,  748,  753,  755,
      759,  764,  769,  771

    } ;

static yyconst flex_int16_t yy_def[395] =
    {   0,
      365,  365,  365,  365,  365,  365,  365,    7,  365,  365,
      365,  365,  365,  365,  365,  365,  365,   17,  365,  365,
      366,  366,  365,   23,  365,  365,  365,   27,  365,  365,
      365,   31,  365,  365,  365,  365,  365,  365,  365,  365,
      365,   41,  365,  365,  365,  365,  365,  365,  365,   49,
      367,  367,  364,  364,  364,  368,  364,  364,  364,  364,
      364,  369,  370,  364,  364,  371,  364,  364,  372,  364,
      364,  364,  364,  364,  364,  364,  364,  373,  374,  375,
      364,  364,  376,  364,  364,  364,  364,  364,  364,  364,
      364,  377,  364,  378,  364,  364,  379,  364,  380,  381,

      382,  364,  364,  383,  364,  364,  364,  364,  364,  364,
      384,  385,  364,  364,  386,  364,  364,  364,  364,  364,
      364,  364,  387,  388,  364,  389,  364,  364,  390,  364,
      364,  364,  364,  391,  364,  364,  364,  364,  392,  393,
      364,  364,  394,  364,  364,  364,  368,  364,  364,  364,
      364,  364,  364,  369,  364,  364,  370,  364,  364,  364,
      371,  364,  364,  364,  372,  364,  364,  364,  364,  364,
      373,  374,  364,  364,  375,  364,  364,  364,  376,  364,
      364,  364,  364,  364,  364,  364,  377,  364,  364,  364,
      378,  364,  364,  364,  379,  364,  364,  380,  381,  364,

      364,  382,  364,  364,  364,  383,  364,  364,  364,  364,
      384,  364,  364,  385,  364,  364,  364,  386,  364,  364,
      364,  364,  364,  364,  387,  388,  364,  364,  389,  364,
      364,  364,  390,  364,  364,  364,  364,  364,  391,  364,
      392,  364,  364,  393,  364,  364,  364,  394,  364,  364,
      364,  364,  364,  364,  364,  364,  364,  364,  364,  364,
      364,  364,  364,  364,  364,  364,  364,  364,  364,  364,
      364,  364,  364,  364,  364,  364,  364,  364,  364,  364,
      364,  364,  364,  364,  364,  364,  364,  364,  364,  364,
      364,  364,  364,  364,  364,  364,  364,  364,  364,  364,

      364,  364,  364,  364,  364,  364,  364,  364,  364,  364,
      364,  364,  364,  364,  364,  364,  364,  364,  364,  364,
      364,  364,  364,  364,  364,  364,  364,  364,  364,  364,
      364,  364,  364,  364,  364,  364,  364,  364,  364,  364,
      364,  364,  364,  364,  364,  364,  364,  364,  364,  364,
      364,  364,  364,  364,  364,  364,  364,  364,  364,  364,
      364,  364,  364,    0,  364,  364,  364,  364,  364,  364,
      364,  364,  364,  364,  364,  364,  364,  364,  364,  364,
      364,  364,  364,  364,  364,  364,  364,  364,  364,  364,
      364,  364,  364,  364

    } ;

static yyconst flex_int16_t yy_nxt[835] =
    {   0,
      364,  364,  364,   55,   55,   70,   68,   70,   68,   56,
       56,   68,   77,   68,   69,   71,  158,  158,   78,   69,
      152,   72,  152,   70,   99,   70,   56,   56,   57,   73,
       58,   69,  251,   71,   73,   78,   69,   74,   59,   72,
      249,   99,   74,   75,   60,   76,   61,   57,   75,   58,
       76,  164,   85,  164,   85,   77,  240,   59,  117,  238,
      117,   78,   86,   60,  238,   61,   62,   99,   87,   85,
       63,   85,  118,   64,  118,   65,   65,   66,   78,   86,
      119,   67,   63,  234,   99,   87,  224,   63,   79,  176,
      176,  134,   80,  223,  120,   81,  121,   82,   82,   83,

       89,   54,   89,   84,   80,   89,   54,   89,  134,   80,
       90,  122,  119,  192,  192,   90,   91,  123,   91,  185,
       92,  185,   93,  186,   94,  186,  120,   95,  121,   96,
       96,   97,  122,  134,  123,   98,   94,  148,  123,  148,
      106,   94,  100,  222,  155,  173,  101,  149,  107,  102,
      134,  103,  103,  104,  108,  123,  109,  105,  101,  106,
      131,  156,  174,  101,  221,  132,  131,  107,  159,  160,
      160,  132,  219,  108,  133,  109,  110,  152,  111,  152,
      133,  135,  112,  210,  188,  113,  136,  114,  114,  115,
      177,  178,  178,  116,  112,  137,  148,  138,  150,  112,

      124,  189,  209,  125,  126,  207,  149,  127,  135,  128,
      128,  129,  151,  136,  200,  130,  126,  166,  152,  166,
      152,  126,  137,  196,  138,  139,  182,  190,  182,  140,
      184,  201,  141,  167,  142,  142,  143,  193,  194,  194,
      144,  140,  183,  203,  203,  212,  140,  204,  205,  205,
      215,  215,  216,  217,  217,  227,  230,  230,  231,  232,
      232,  236,  213,  242,  245,  245,  246,  247,  247,  148,
      155,  148,  228,  180,  148,  237,  150,  154,  170,  149,
      243,  159,  160,  160,  149,  252,  252,  156,  173,  172,
      151,  159,  253,  253,  154,  164,  166,  164,  166,  177,

      178,  178,  254,  254,  188,  174,  172,  177,  255,  255,
      169,  182,  167,  182,  185,  186,  185,  186,  187,  256,
      256,  189,  193,  194,  194,  200,  199,  183,  193,  257,
      257,  204,  205,  205,  212,  187,  258,  258,  204,  259,
      259,  211,  201,  199,  216,  217,  217,  260,  260,  227,
      226,  213,  216,  261,  261,  231,  232,  232,  211,  262,
      262,  231,  263,  263,  236,  242,  228,  226,  241,  246,
      247,  247,  264,  264,  246,  265,  265,  168,  237,  266,
      266,  162,  243,  268,  268,  241,  159,  267,  267,  177,
      269,  269,  270,  270,  193,  271,  271,  272,  272,  204,

      273,  273,  274,  274,  216,  275,  275,  276,  276,  231,
      277,  277,  278,  278,  246,  279,  279,  280,  280,  159,
      281,  281,  282,  282,  177,  283,  283,  284,  284,  193,
      285,  285,  286,  286,  204,  287,  287,  288,  288,  216,
      289,  289,  290,  290,  231,  291,  291,  292,  292,  246,
      293,  293,  159,  294,  294,  177,  295,  295,  193,  296,
      296,  204,  297,  297,  216,  298,  298,  231,  299,  299,
      246,  300,  300,  159,  301,  301,  177,  302,  302,  193,
      303,  303,  204,  304,  304,  216,  305,  305,  231,  306,
      306,  246,  307,  307,  159,  308,  308,  177,  309,  309,

      193,  310,  310,  204,  311,  311,  216,  312,  312,  231,
      313,  313,  246,  314,  314,  159,  315,  315,  177,  316,
      316,  193,  317,  317,  204,  318,  318,  216,  319,  319,
      231,  320,  320,  246,  321,  321,  159,  322,  322,  177,
      323,  323,  193,  324,  324,  204,  325,  325,  216,  326,
      326,  231,  327,  327,  246,  328,  328,  159,  329,  329,
      177,  330,  330,  193,  331,  331,  204,  332,  332,  216,
      333,  333,  231,  334,  334,  246,  335,  335,  159,  336,
      336,  177,  337,  337,  193,  338,  338,  204,  339,  339,
      216,  340,  340,  231,  341,  341,  246,  342,  342,  159,

      343,  343,  177,  344,  344,  193,  345,  345,  204,  346,
      346,  216,  347,  347,  231,  348,  348,  246,  349,  349,
      350,  350,  351,  351,  352,  352,  353,  353,  354,  354,
      355,  355,  356,  356,  357,  357,  358,  358,  359,  359,
      360,  360,  361,  361,  362,  362,  363,  363,   54,   54,
       54,   54,   54,   54,   54,   88,   88,   88,   88,   88,
       88,   88,  145,  145,  145,  145,  145,  145,  145,  147,
      251,  147,  154,  154,  154,  154,  154,  154,  157,  157,
      157,  157,  161,  161,  161,  165,  146,  165,  171,  250,
      171,  172,  172,  172,  172,  172,  172,  175,  175,  175,

      175,  179,  179,  179,  187,  187,  187,  187,  187,  187,
      191,  191,  191,  191,  195,  195,  195,  198,  249,  198,
      199,  199,  199,  199,  199,  199,  202,  202,  202,  202,
      206,  206,  206,  211,  211,  211,  211,  211,  211,  214,
      214,  214,  214,  218,  218,  218,  225,  240,  225,  226,
      226,  226,  226,  226,  226,  229,  229,  229,  229,  233,
      233,  233,  239,  238,  239,  241,  241,  241,  241,  241,
      241,  244,  244,  244,  244,  248,  248,  248,  235,  234,
      224,  223,  222,  221,  220,  219,  210,  209,  208,  207,
      197,  196,  190,  184,  181,  180,  170,  169,  168,  163,

      162,  153,  146,  364,   54,   54,   53,  364,  364,  364,
      364,  364,  364,  364,  364,  364,  364,  364,  364,  364,
      364,  364,  364,  364,  364,  364,  364,  364,  364,  364,
      364,  364,  364,  364
    } ;

static yyconst flex_int16_t yy_chk[835] =
    {   0,
        0,    0,    0,    3,    4,   11,    9,   11,    9,    3,
        4,   10,   15,   10,    9,   11,   64,   64,   15,   10,
       59,   11,   59,   12,   25,   12,    3,    4,    5,   13,
        5,    9,  251,   12,   14,   15,   10,   13,    5,   12,
      248,   25,   14,   13,    5,   13,    5,    6,   14,    6,
       14,   68,   19,   68,   19,   16,  240,    6,   33,  238,
       34,   16,   19,    6,  237,    6,    7,   26,   19,   20,
        7,   20,   33,    7,   34,    7,    7,    7,   16,   20,
       35,    7,    7,  233,   26,   20,  224,    7,   17,   81,
       81,   45,   17,  223,   35,   17,   35,   17,   17,   17,

       21,   21,   21,   17,   17,   22,   22,   22,   45,   17,
       21,   37,   36,   95,   95,   22,   23,   37,   23,   89,
       23,   89,   23,   91,   23,   91,   36,   23,   36,   23,
       23,   23,   38,   46,   37,   23,   23,   57,   38,   57,
       29,   23,   27,  222,   62,   79,   27,   57,   29,   27,
       46,   27,   27,   27,   29,   38,   29,   27,   27,   30,
       43,   62,   79,   27,  221,   43,   44,   30,   65,   65,
       65,   44,  218,   30,   43,   30,   31,  149,   31,  149,
       44,   47,   31,  210,   92,   31,   47,   31,   31,   31,
       82,   82,   82,   31,   31,   47,   58,   47,   58,   31,

       41,   92,  209,   41,   41,  206,   58,   41,   48,   41,
       41,   41,   58,   48,  100,   41,   41,   70,  152,   70,
      152,   41,   48,  195,   48,   49,   85,  190,   85,   49,
      184,  100,   49,   70,   49,   49,   49,   96,   96,   96,
       49,   49,   85,  102,  102,  111,   49,  103,  103,  103,
      113,  113,  114,  114,  114,  124,  127,  127,  128,  128,
      128,  131,  111,  139,  141,  141,  142,  142,  142,  148,
      154,  148,  124,  179,  150,  131,  150,  156,  170,  148,
      139,  158,  158,  158,  150,  159,  159,  154,  172,  174,
      150,  160,  160,  160,  156,  164,  166,  164,  166,  176,

      176,  176,  177,  177,  187,  172,  174,  178,  178,  178,
      169,  182,  166,  182,  185,  186,  185,  186,  189,  193,
      193,  187,  192,  192,  192,  199,  201,  182,  194,  194,
      194,  203,  203,  203,  211,  189,  204,  204,  205,  205,
      205,  213,  199,  201,  215,  215,  215,  216,  216,  226,
      228,  211,  217,  217,  217,  230,  230,  230,  213,  231,
      231,  232,  232,  232,  236,  241,  226,  228,  243,  245,
      245,  245,  246,  246,  247,  247,  247,  168,  236,  252,
      252,  161,  241,  254,  254,  243,  253,  253,  253,  255,
      255,  255,  256,  256,  257,  257,  257,  258,  258,  259,

      259,  259,  260,  260,  261,  261,  261,  262,  262,  263,
      263,  263,  264,  264,  265,  265,  265,  266,  266,  267,
      267,  267,  268,  268,  269,  269,  269,  270,  270,  271,
      271,  271,  272,  272,  273,  273,  273,  274,  274,  275,
      275,  275,  276,  276,  277,  277,  277,  278,  278,  279,
      279,  279,  281,  281,  281,  283,  283,  283,  285,  285,
      285,  287,  287,  287,  289,  289,  289,  291,  291,  291,
      293,  293,  293,  294,  294,  294,  295,  295,  295,  296,
      296,  296,  297,  297,  297,  298,  298,  298,  299,  299,
      299,  300,  300,  300,  301,  301,  301,  302,  302,  302,

      303,  303,  303,  304,  304,  304,  305,  305,  305,  306,
      306,  306,  307,  307,  307,  308,  308,  308,  309,  309,
      309,  310,  310,  310,  311,  311,  311,  312,  312,  312,
      313,  313,  313,  314,  314,  314,  315,  315,  315,  316,
      316,  316,  317,  317,  317,  318,  318,  318,  319,  319,
      319,  320,  320,  320,  321,  321,  321,  322,  322,  322,
      323,  323,  323,  324,  324,  324,  325,  325,  325,  326,
      326,  326,  327,  327,  327,  328,  328,  328,  329,  329,
      329,  330,  330,  330,  331,  331,  331,  332,  332,  332,
      333,  333,  333,  334,  334,  334,  335,  335,  335,  336,

      336,  336,  337,  337,  337,  338,  338,  338,  339,  339,
      339,  340,  340,  340,  341,  341,  341,  342,  342,  342,
      343,  343,  344,  344,  345,  345,  346,  346,  347,  347,
      348,  348,  349,  349,  350,  350,  351,  351,  352,  352,
      353,  353,  354,  354,  355,  355,  356,  356,  365,  365,
      365,  365,  365,  365,  365,  366,  366,  366,  366,  366,
      366,  366,  367,  367,  367,  367,  367,  367,  367,  368,
      153,  368,  369,  369,  369,  369,  369,  369,  370,  370,
      370,  370,  371,  371,  371,  372,  146,  372,  373,  144,
      373,  374,  374,  374,  374,  374,  374,  375,  375,  375,

      375,  376,  376,  376,  377,  377,  377,  377,  377,  377,
      378,  378,  378,  378,  379,  379,  379,  380,  143,  380,
      381,  381,  381,  381,  381,  381,  382,  382,  382,  382,
      383,  383,  383,  384,  384,  384,  384,  384,  384,  385,
      385,  385,  385,  386,  386,  386,  387,  135,  387,  388,
      388,  388,  388,  388,  388,  389,  389,  389,  389,  390,
      390,  390,  391,  133,  391,  392,  392,  392,  392,  392,
      392,  393,  393,  393,  393,  394,  394,  394,  130,  129,
      122,  119,  118,  117,  116,  115,  110,  106,  105,  104,
       98,   97,   93,   87,   84,   83,   77,   73,   72,   67,

       66,   61,   55,   53,   52,   51,  364,  364,  364,  364,
      364,  364,  364,  364,  364,  364,  364,  364,  364,  364,
      364,  364,  364,  364,  364,  364,  364,  364,  364,  364,
      364,  364,  364,  364
    } ;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
#line 1 "ls-sfparser.l"

#line 27 "ls-sfparser.l"
#include <stddef.h>
#include "ls-sfparser.h"
struct ls_sf_parser
{
    /* Return 0 on success, -1 on error to stop parsing. */
    int              (*callback)(void *user_data, enum ls_sf_dt,
                                            char *str, size_t len, int off);
    void              *user_data;
    const char        *errmsg;
    enum ls_sf_tlt     top_level_type;
    int                mem_failed;
    char              *mem;
    size_t             mem_sz;
    size_t             mem_off;
    /* XXX "last malloced" allows for a couple of rudimentary optimizations,
     * but they never occurred in the input I tried.
     */
    char              *last_malloced;
};
#define SFP ((struct ls_sf_parser *) yyextra)
#define CALLBACK(dt_, str_, len_, addl_) do {                       \
    if (SFP->callback(SFP->user_data, (dt_), (str_), (len_),        \
            (addl_) >= 0 ?                                          \
            yyg->yy_c_buf_p - yyleng - YY_CURRENT_BUFFER->yy_ch_buf + (addl_) :  \
            (addl_)))                                               \
        return -1;                                                  \
} while (0)
#define YY_FATAL_ERROR(msg_) do {                                   \
    (void) yy_fatal_error /* silence compiler warning */;           \
    ((struct ls_sf_parser *)                                        \
                (ls_sfp_get_extra(yyscanner)))->errmsg = (msg_);         \
    ((struct yyguts_t*)yyscanner)->yy_start = 1 + 2 * ERROR_STATE;  \
} while (0)
#define YY_NO_INPUT 1
#define YY_NO_UNISTD_H 1
/* TCHAR: RFC 7230, Section 3.2.6 */







#line 821 "ls-sfparser.c"

#define INITIAL 0
#define DICTIONARY 1
#define DIC_MEMBER_EQ 2
#define DIC_MEMBER_ITEM 3
#define DIC_NEXT_ITEM 4
#define DIC_OPTIONAL_PARAM 5
#define DIC_PARAM_EQ 6
#define DIC_PARAM_KEY 7
#define DIC_PARAM_ITEM 8
#define LIST_OPTIONAL_PARAM 9
#define LIST 10
#define LIST_NEXT_ITEM 11
#define LIST_PARAM_KEY 12
#define LIST_PARAM_ITEM 13
#define LIST_PARAM_EQ 14
#define ITEM 15
#define ITEM_OPTIONAL_PARAM 16
#define ITEM_PARAM_EQ 17
#define ITEM_PARAM_KEY 18
#define ITEM_BARE_ITEM 19
#define INNER_LIST 20
#define IL_OPTIONAL_PARAM 21
#define IL_PARAM_KEY 22
#define IL_PARAM_EQ 23
#define IL_PARAM_ITEM 24
#define ERROR_STATE 25

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

/* Holds the entire state of the reentrant scanner. */
struct yyguts_t
    {

    /* User-defined. Not touched by flex. */
    YY_EXTRA_TYPE yyextra_r;

    /* The rest are the same as the globals declared in the non-reentrant scanner. */
    FILE *yyin_r, *yyout_r;
    size_t yy_buffer_stack_top; /**< index of top of stack. */
    size_t yy_buffer_stack_max; /**< capacity of stack. */
    YY_BUFFER_STATE * yy_buffer_stack; /**< Stack as an array. */
    char yy_hold_char;
    int yy_n_chars;
    int yyleng_r;
    char *yy_c_buf_p;
    int yy_init;
    int yy_start;
    int yy_did_buffer_switch_on_eof;
    int yy_start_stack_ptr;
    int yy_start_stack_depth;
    int *yy_start_stack;
    yy_state_type yy_last_accepting_state;
    char* yy_last_accepting_cpos;

    int yylineno_r;
    int yy_flex_debug_r;

    char *yytext_r;
    int yy_more_flag;
    int yy_more_len;

    }; /* end struct yyguts_t */

static int yy_init_globals (yyscan_t yyscanner );

int ls_sfp_lex_init (yyscan_t* scanner);

int ls_sfp_lex_init_extra (YY_EXTRA_TYPE user_defined,yyscan_t* scanner);

/* Accessor methods to globals.
   These are made visible to non-reentrant scanners for convenience. */

int ls_sfp_lex_destroy (yyscan_t yyscanner );

int ls_sfp_get_debug (yyscan_t yyscanner );

void ls_sfp_set_debug (int debug_flag ,yyscan_t yyscanner );

YY_EXTRA_TYPE ls_sfp_get_extra (yyscan_t yyscanner );

void ls_sfp_set_extra (YY_EXTRA_TYPE user_defined ,yyscan_t yyscanner );

FILE *ls_sfp_get_in (yyscan_t yyscanner );

void ls_sfp_set_in  (FILE * in_str ,yyscan_t yyscanner );

FILE *ls_sfp_get_out (yyscan_t yyscanner );

void ls_sfp_set_out  (FILE * out_str ,yyscan_t yyscanner );

int ls_sfp_get_leng (yyscan_t yyscanner );

char *ls_sfp_get_text (yyscan_t yyscanner );

int ls_sfp_get_lineno (yyscan_t yyscanner );

void ls_sfp_set_lineno (int line_number ,yyscan_t yyscanner );

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int ls_sfp_wrap (yyscan_t yyscanner );
#else
extern int ls_sfp_wrap (yyscan_t yyscanner );
#endif
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy (char *,yyconst char *,int ,yyscan_t yyscanner);
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * ,yyscan_t yyscanner);
#endif

#ifndef YY_NO_INPUT

#ifdef __cplusplus
static int yyinput (yyscan_t yyscanner );
#else
static int input (yyscan_t yyscanner );
#endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k */
#define YY_READ_BUF_SIZE 16384
#else
#define YY_READ_BUF_SIZE 8192
#endif /* __ia64__ */
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO do { if (fwrite( yytext, yyleng, 1, yyout )) {} } while (0)
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		size_t n; \
		for ( n = 0; n < max_size && \
			     (c = getc( yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = fread(buf, 1, max_size, yyin))==0 && ferror(yyin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(yyin); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg , yyscanner)
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

extern int ls_sfp_lex (yyscan_t yyscanner);

#define YY_DECL int ls_sfp_lex (yyscan_t yyscanner)
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK break;
#endif

#define YY_RULE_SETUP \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	register yy_state_type yy_current_state;
	register char *yy_cp, *yy_bp;
	register int yy_act;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

#line 101 "ls-sfparser.l"


    char TRUE[] = "1";

    switch (SFP->top_level_type)
    {
    case LS_SF_TLT_DICTIONARY:
        BEGIN(DICTIONARY);
        break;
    case LS_SF_TLT_LIST:
        BEGIN(LIST);
        break;
    case LS_SF_TLT_ITEM:
        BEGIN(ITEM);
        break;
    default:
        SFP->errmsg = "invalid top-level type specified";
        return -1;
    }

#line 1091 "ls-sfparser.c"

	if ( !yyg->yy_init )
		{
		yyg->yy_init = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! yyg->yy_start )
			yyg->yy_start = 1;	/* first start state */

		if ( ! yyin )
			yyin = stdin;

		if ( ! yyout )
			yyout = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			if (ls_sfp_ensure_buffer_stack (yyscanner))
                return -1;
			YY_CURRENT_BUFFER_LVALUE =
				ls_sfp__create_buffer(yyin,YY_BUF_SIZE ,yyscanner);
		}

		ls_sfp__load_buffer_state(yyscanner );
		}

	while ( 1 )		/* loops until end-of-file is reached */
		{
		yy_cp = yyg->yy_c_buf_p;

		/* Support of yytext. */
		*yy_cp = yyg->yy_hold_char;

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = yyg->yy_start;
yy_match:
		do
			{
			register YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)];
			if ( yy_accept[yy_current_state] )
				{
				yyg->yy_last_accepting_state = yy_current_state;
				yyg->yy_last_accepting_cpos = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 365 )
					yy_c = yy_meta[(unsigned int) yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
			++yy_cp;
			}
		while ( yy_current_state != 364 );
		yy_cp = yyg->yy_last_accepting_cpos;
		yy_current_state = yyg->yy_last_accepting_state;

yy_find_action:
		yy_act = yy_accept[yy_current_state];

		YY_DO_BEFORE_ACTION;

do_action:	/* This label is used only to access EOF actions. */

		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = yyg->yy_hold_char;
			yy_cp = yyg->yy_last_accepting_cpos;
			yy_current_state = yyg->yy_last_accepting_state;
			goto yy_find_action;

case 1:
YY_RULE_SETUP
#line 122 "ls-sfparser.l"
/* Eat up whitespace */
	YY_BREAK
case 2:
YY_RULE_SETUP
#line 123 "ls-sfparser.l"
{ CALLBACK(LS_SF_DT_NAME, yytext, yyleng, 0);
                                      BEGIN(DIC_MEMBER_EQ); }
	YY_BREAK


case YY_STATE_EOF(DIC_NEXT_ITEM):
#line 128 "ls-sfparser.l"
{ return -1; }
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 129 "ls-sfparser.l"
/* Eat up whitespace */
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 130 "ls-sfparser.l"
{ CALLBACK(LS_SF_DT_NAME, yytext, yyleng, 0);
                                      BEGIN(DIC_MEMBER_EQ); }
	YY_BREAK

case 5:
YY_RULE_SETUP
#line 134 "ls-sfparser.l"
{ CALLBACK(LS_SF_DT_INNER_LIST_BEGIN, yytext + 1, yyleng - 1, 1);
                                      BEGIN(INNER_LIST); }
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 137 "ls-sfparser.l"
{ BEGIN(DIC_MEMBER_ITEM); }
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 139 "ls-sfparser.l"
{ TRUE[0] = '1';
                                      CALLBACK(LS_SF_DT_BOOLEAN, TRUE, 1, -1);
                                      BEGIN(DIC_PARAM_KEY); }
	YY_BREAK
case 8:
YY_RULE_SETUP
#line 143 "ls-sfparser.l"
{ TRUE[0] = '1';
                                      CALLBACK(LS_SF_DT_BOOLEAN, TRUE, 1, -1);
                                      BEGIN(DIC_NEXT_ITEM); }
	YY_BREAK
case YY_STATE_EOF(DIC_MEMBER_EQ):
#line 147 "ls-sfparser.l"
{ TRUE[0] = '1';
                                      CALLBACK(LS_SF_DT_BOOLEAN, TRUE, 1, -1);
                                      return 0; }
	YY_BREAK

case 9:
YY_RULE_SETUP
#line 152 "ls-sfparser.l"
{ CALLBACK(LS_SF_DT_INNER_LIST_END, yytext, yyleng, 0);
                                      if (SFP->top_level_type == LS_SF_TLT_DICTIONARY)
                                          BEGIN(DIC_OPTIONAL_PARAM);
                                      else
                                          BEGIN(LIST_OPTIONAL_PARAM); }
	YY_BREAK
case 10:
YY_RULE_SETUP
#line 157 "ls-sfparser.l"
{ CALLBACK(LS_SF_DT_INTEGER, yytext, yyleng, 0);
                                      BEGIN(IL_OPTIONAL_PARAM);
                                    }
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 160 "ls-sfparser.l"
{ CALLBACK(LS_SF_DT_DECIMAL, yytext, yyleng, 0);
                                      BEGIN(IL_OPTIONAL_PARAM);
                                    }
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 163 "ls-sfparser.l"
{
                                      yytext[yyleng - 1] = '\0';
                                      CALLBACK(LS_SF_DT_STRING, yytext + 1, yyleng - 2, 1);
                                      BEGIN(IL_OPTIONAL_PARAM);
                                    }
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 168 "ls-sfparser.l"
{ CALLBACK(LS_SF_DT_TOKEN, yytext, yyleng, 0);
                                      BEGIN(IL_OPTIONAL_PARAM);
                                    }
	YY_BREAK
case 14:
YY_RULE_SETUP
#line 171 "ls-sfparser.l"
{
                                      yytext[yyleng - 1] = '\0';
                                      CALLBACK(LS_SF_DT_BYTESEQ, yytext + 1, yyleng - 2, 1);
                                      BEGIN(IL_OPTIONAL_PARAM);
                                    }
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 176 "ls-sfparser.l"
{ CALLBACK(LS_SF_DT_BOOLEAN, yytext + 1, yyleng - 1, 1);
                                      BEGIN(IL_OPTIONAL_PARAM);
                                    }
	YY_BREAK
case YY_STATE_EOF(INNER_LIST):
#line 179 "ls-sfparser.l"
{ return -1; }
	YY_BREAK


case 16:
YY_RULE_SETUP
#line 183 "ls-sfparser.l"
{ BEGIN(IL_PARAM_KEY); }
	YY_BREAK
case 17:
YY_RULE_SETUP
#line 184 "ls-sfparser.l"
{ CALLBACK(LS_SF_DT_INNER_LIST_END, yytext, yyleng, 0);
                                      if (SFP->top_level_type == LS_SF_TLT_DICTIONARY)
                                          BEGIN(DIC_OPTIONAL_PARAM);
                                      else
                                          BEGIN(LIST_OPTIONAL_PARAM); }
	YY_BREAK
case 18:
YY_RULE_SETUP
#line 189 "ls-sfparser.l"
{ BEGIN(INNER_LIST); }
	YY_BREAK
case YY_STATE_EOF(IL_OPTIONAL_PARAM):
#line 190 "ls-sfparser.l"
{ return -1; }
	YY_BREAK

case 19:
YY_RULE_SETUP
#line 193 "ls-sfparser.l"
{ CALLBACK(LS_SF_DT_PARAM_NAME, yytext, yyleng, 0);
                                        BEGIN(IL_PARAM_EQ); }
	YY_BREAK

case 20:
YY_RULE_SETUP
#line 197 "ls-sfparser.l"
{ BEGIN(IL_PARAM_ITEM); }
	YY_BREAK
case 21:
YY_RULE_SETUP
#line 198 "ls-sfparser.l"
{ TRUE[0] = '1';
                                      CALLBACK(LS_SF_DT_BOOLEAN, TRUE, 1, -1);
                                      BEGIN(IL_OPTIONAL_PARAM); }
	YY_BREAK
case 22:
YY_RULE_SETUP
#line 201 "ls-sfparser.l"
{ TRUE[0] = '1';
                                      CALLBACK(LS_SF_DT_BOOLEAN, TRUE, 1, -1);
                                      BEGIN(IL_PARAM_KEY); }
	YY_BREAK
case 23:
YY_RULE_SETUP
#line 204 "ls-sfparser.l"
{ TRUE[0] = '1';
                                      CALLBACK(LS_SF_DT_BOOLEAN, TRUE, 1, -1);
                                      CALLBACK(LS_SF_DT_INNER_LIST_END, yytext, yyleng, 0);
                                      if (SFP->top_level_type == LS_SF_TLT_DICTIONARY)
                                          BEGIN(DIC_OPTIONAL_PARAM);
                                      else
                                          BEGIN(LIST_OPTIONAL_PARAM); }
	YY_BREAK


case 24:
YY_RULE_SETUP
#line 214 "ls-sfparser.l"
{ CALLBACK(LS_SF_DT_INTEGER, yytext, yyleng, 0);
                                      BEGIN(IL_OPTIONAL_PARAM);
                                    }
	YY_BREAK
case 25:
YY_RULE_SETUP
#line 217 "ls-sfparser.l"
{ CALLBACK(LS_SF_DT_DECIMAL, yytext, yyleng, 0);
                                      BEGIN(IL_OPTIONAL_PARAM);
                                    }
	YY_BREAK
case 26:
YY_RULE_SETUP
#line 220 "ls-sfparser.l"
{
                                      yytext[yyleng - 1] = '\0';
                                      CALLBACK(LS_SF_DT_STRING, yytext + 1, yyleng - 2, 1);
                                      BEGIN(IL_OPTIONAL_PARAM);
                                    }
	YY_BREAK
case 27:
YY_RULE_SETUP
#line 225 "ls-sfparser.l"
{ CALLBACK(LS_SF_DT_TOKEN, yytext, yyleng, 0);
                                      BEGIN(IL_OPTIONAL_PARAM);
                                    }
	YY_BREAK
case 28:
YY_RULE_SETUP
#line 228 "ls-sfparser.l"
{
                                      yytext[yyleng - 1] = '\0';
                                      CALLBACK(LS_SF_DT_BYTESEQ, yytext + 1, yyleng - 2, 1);
                                      BEGIN(IL_OPTIONAL_PARAM);
                                    }
	YY_BREAK
case 29:
YY_RULE_SETUP
#line 233 "ls-sfparser.l"
{ CALLBACK(LS_SF_DT_BOOLEAN, yytext + 1, yyleng - 1, 1);
                                      BEGIN(IL_OPTIONAL_PARAM);
                                    }
	YY_BREAK
case YY_STATE_EOF(IL_PARAM_ITEM):
#line 236 "ls-sfparser.l"
{ return -1; }
	YY_BREAK


case 30:
YY_RULE_SETUP
#line 240 "ls-sfparser.l"
{ CALLBACK(LS_SF_DT_INTEGER, yytext, yyleng, 0);
                                      BEGIN(DIC_OPTIONAL_PARAM);
                                    }
	YY_BREAK
case 31:
YY_RULE_SETUP
#line 243 "ls-sfparser.l"
{ CALLBACK(LS_SF_DT_DECIMAL, yytext, yyleng, 0);
                                      BEGIN(DIC_OPTIONAL_PARAM);
                                    }
	YY_BREAK
case 32:
YY_RULE_SETUP
#line 246 "ls-sfparser.l"
{
                                      yytext[yyleng - 1] = '\0';
                                      CALLBACK(LS_SF_DT_STRING, yytext + 1, yyleng - 2, 1);
                                      BEGIN(DIC_OPTIONAL_PARAM);
                                    }
	YY_BREAK
case 33:
YY_RULE_SETUP
#line 251 "ls-sfparser.l"
{ CALLBACK(LS_SF_DT_TOKEN, yytext, yyleng, 0);
                                      BEGIN(DIC_OPTIONAL_PARAM);
                                    }
	YY_BREAK
case 34:
YY_RULE_SETUP
#line 254 "ls-sfparser.l"
{
                                      yytext[yyleng - 1] = '\0';
                                      CALLBACK(LS_SF_DT_BYTESEQ, yytext + 1, yyleng - 2, 1);
                                      BEGIN(DIC_OPTIONAL_PARAM);
                                    }
	YY_BREAK
case 35:
YY_RULE_SETUP
#line 259 "ls-sfparser.l"
{ CALLBACK(LS_SF_DT_BOOLEAN, yytext + 1, yyleng - 1, 1);
                                      BEGIN(DIC_OPTIONAL_PARAM);
                                    }
	YY_BREAK
case YY_STATE_EOF(DIC_MEMBER_ITEM):
#line 262 "ls-sfparser.l"
{ return -1; }
	YY_BREAK


case 36:
YY_RULE_SETUP
#line 266 "ls-sfparser.l"
{ return -1; }
	YY_BREAK
case 37:
YY_RULE_SETUP
#line 267 "ls-sfparser.l"
/* Eat up whitespace */
	YY_BREAK
case 38:
YY_RULE_SETUP
#line 268 "ls-sfparser.l"
{ BEGIN(DIC_PARAM_KEY); }
	YY_BREAK
case 39:
YY_RULE_SETUP
#line 269 "ls-sfparser.l"
{ BEGIN(DIC_NEXT_ITEM); }
	YY_BREAK
case YY_STATE_EOF(DIC_OPTIONAL_PARAM):
#line 270 "ls-sfparser.l"
{ return 0; }
	YY_BREAK


case 40:
YY_RULE_SETUP
#line 274 "ls-sfparser.l"
/* Eat up whitespace */
	YY_BREAK
case 41:
YY_RULE_SETUP
#line 275 "ls-sfparser.l"
{ CALLBACK(LS_SF_DT_PARAM_NAME, yytext, yyleng, 0);
                                        BEGIN(DIC_PARAM_EQ); }
	YY_BREAK


case 42:
YY_RULE_SETUP
#line 280 "ls-sfparser.l"
{ BEGIN(DIC_PARAM_ITEM); }
	YY_BREAK
case 43:
YY_RULE_SETUP
#line 281 "ls-sfparser.l"
{ TRUE[0] = '1';
                                      CALLBACK(LS_SF_DT_BOOLEAN, TRUE, 1, -1);
                                      BEGIN(DIC_NEXT_ITEM);
                                    }
	YY_BREAK
case 44:
YY_RULE_SETUP
#line 285 "ls-sfparser.l"
{ TRUE[0] = '1';
                                      CALLBACK(LS_SF_DT_BOOLEAN, TRUE, 1, -1);
                                      BEGIN(DIC_PARAM_KEY);
                                    }
	YY_BREAK
case 45:
YY_RULE_SETUP
#line 289 "ls-sfparser.l"
{ TRUE[0] = '1';
                                      CALLBACK(LS_SF_DT_BOOLEAN, TRUE, 1, -1);
                                      BEGIN(DIC_OPTIONAL_PARAM);
                                    }
	YY_BREAK
case YY_STATE_EOF(DIC_PARAM_EQ):
#line 293 "ls-sfparser.l"
{ TRUE[0] = '1';
                                      CALLBACK(LS_SF_DT_BOOLEAN, TRUE, 1, -1);
                                      return 0;
                                    }
	YY_BREAK


case 46:
YY_RULE_SETUP
#line 300 "ls-sfparser.l"
{ CALLBACK(LS_SF_DT_INTEGER, yytext, yyleng, 0);
                                      BEGIN(DIC_OPTIONAL_PARAM);
                                    }
	YY_BREAK
case 47:
YY_RULE_SETUP
#line 303 "ls-sfparser.l"
{ CALLBACK(LS_SF_DT_DECIMAL, yytext, yyleng, 0);
                                      BEGIN(DIC_OPTIONAL_PARAM);
                                    }
	YY_BREAK
case 48:
YY_RULE_SETUP
#line 306 "ls-sfparser.l"
{
                                      yytext[yyleng - 1] = '\0';
                                      CALLBACK(LS_SF_DT_STRING, yytext + 1, yyleng - 2, 1);
                                      BEGIN(DIC_OPTIONAL_PARAM);
                                    }
	YY_BREAK
case 49:
YY_RULE_SETUP
#line 311 "ls-sfparser.l"
{ CALLBACK(LS_SF_DT_TOKEN, yytext, yyleng, 0);
                                      BEGIN(DIC_OPTIONAL_PARAM);
                                    }
	YY_BREAK
case 50:
YY_RULE_SETUP
#line 314 "ls-sfparser.l"
{
                                      yytext[yyleng - 1] = '\0';
                                      CALLBACK(LS_SF_DT_BYTESEQ, yytext + 1, yyleng - 2, 1);
                                      BEGIN(DIC_OPTIONAL_PARAM);
                                    }
	YY_BREAK
case 51:
YY_RULE_SETUP
#line 319 "ls-sfparser.l"
{ CALLBACK(LS_SF_DT_BOOLEAN, yytext + 1, yyleng - 1, 1);
                                      BEGIN(DIC_OPTIONAL_PARAM);
                                    }
	YY_BREAK
case YY_STATE_EOF(DIC_PARAM_ITEM):
#line 322 "ls-sfparser.l"
{ return -1; }
	YY_BREAK


case 52:
YY_RULE_SETUP
#line 326 "ls-sfparser.l"
/* Eat up whitespace */
	YY_BREAK
case 53:
YY_RULE_SETUP
#line 327 "ls-sfparser.l"
{ return -1; }
	YY_BREAK
case 54:
YY_RULE_SETUP
#line 328 "ls-sfparser.l"
{ yyless(0); BEGIN(LIST_NEXT_ITEM); }
	YY_BREAK


case YY_STATE_EOF(LIST_NEXT_ITEM):
#line 332 "ls-sfparser.l"
{ return -1; }
	YY_BREAK
case 55:
YY_RULE_SETUP
#line 333 "ls-sfparser.l"
/* Eat up whitespace */
	YY_BREAK
case 56:
YY_RULE_SETUP
#line 334 "ls-sfparser.l"
{ CALLBACK(LS_SF_DT_INNER_LIST_BEGIN, yytext, yyleng, 0);
                                      BEGIN(INNER_LIST); }
	YY_BREAK
case 57:
YY_RULE_SETUP
#line 336 "ls-sfparser.l"
{ CALLBACK(LS_SF_DT_INTEGER, yytext, yyleng, 0);
                                      BEGIN(LIST_OPTIONAL_PARAM);
                                    }
	YY_BREAK
case 58:
YY_RULE_SETUP
#line 339 "ls-sfparser.l"
{ CALLBACK(LS_SF_DT_DECIMAL, yytext, yyleng, 0);
                                      BEGIN(LIST_OPTIONAL_PARAM);
                                    }
	YY_BREAK
case 59:
YY_RULE_SETUP
#line 342 "ls-sfparser.l"
{
                                      yytext[yyleng - 1] = '\0';
                                      CALLBACK(LS_SF_DT_STRING, yytext + 1, yyleng - 2, 1);
                                      BEGIN(LIST_OPTIONAL_PARAM);
                                    }
	YY_BREAK
case 60:
YY_RULE_SETUP
#line 347 "ls-sfparser.l"
{ CALLBACK(LS_SF_DT_TOKEN, yytext, yyleng, 0);
                                      BEGIN(LIST_OPTIONAL_PARAM);
                                    }
	YY_BREAK
case 61:
YY_RULE_SETUP
#line 350 "ls-sfparser.l"
{
                                      yytext[yyleng - 1] = '\0';
                                      CALLBACK(LS_SF_DT_BYTESEQ, yytext + 1, yyleng - 2, 1);
                                      BEGIN(LIST_OPTIONAL_PARAM);
                                    }
	YY_BREAK
case 62:
YY_RULE_SETUP
#line 355 "ls-sfparser.l"
{ CALLBACK(LS_SF_DT_BOOLEAN, yytext + 1, yyleng - 1, 1);
                                      BEGIN(LIST_OPTIONAL_PARAM);
                                    }
	YY_BREAK


case 63:
YY_RULE_SETUP
#line 361 "ls-sfparser.l"
{ return -1; }
	YY_BREAK
case 64:
YY_RULE_SETUP
#line 362 "ls-sfparser.l"
/* Eat up whitespace */
	YY_BREAK
case 65:
YY_RULE_SETUP
#line 363 "ls-sfparser.l"
{ BEGIN(LIST_PARAM_KEY); }
	YY_BREAK
case 66:
YY_RULE_SETUP
#line 364 "ls-sfparser.l"
{ BEGIN(LIST_NEXT_ITEM); }
	YY_BREAK

case 67:
YY_RULE_SETUP
#line 367 "ls-sfparser.l"
{ CALLBACK(LS_SF_DT_PARAM_NAME, yytext, yyleng, 0);
                                        BEGIN(LIST_PARAM_EQ); }
	YY_BREAK

case 68:
YY_RULE_SETUP
#line 371 "ls-sfparser.l"
{ BEGIN(LIST_PARAM_ITEM); }
	YY_BREAK
case 69:
YY_RULE_SETUP
#line 372 "ls-sfparser.l"
{ TRUE[0] = '1';
                                      CALLBACK(LS_SF_DT_BOOLEAN, TRUE, 1, -1);
                                      BEGIN(LIST_OPTIONAL_PARAM); }
	YY_BREAK
case 70:
YY_RULE_SETUP
#line 375 "ls-sfparser.l"
{ TRUE[0] = '1';
                                      CALLBACK(LS_SF_DT_BOOLEAN, TRUE, 1, -1);
                                      BEGIN(LIST_PARAM_KEY); }
	YY_BREAK
case 71:
YY_RULE_SETUP
#line 378 "ls-sfparser.l"
{ TRUE[0] = '1';
                                      CALLBACK(LS_SF_DT_BOOLEAN, TRUE, 1, -1);
                                      BEGIN(LIST_NEXT_ITEM); }
	YY_BREAK


case 72:
YY_RULE_SETUP
#line 384 "ls-sfparser.l"
{ CALLBACK(LS_SF_DT_INTEGER, yytext, yyleng, 0);
                                      BEGIN(LIST_OPTIONAL_PARAM);
                                    }
	YY_BREAK
case 73:
YY_RULE_SETUP
#line 387 "ls-sfparser.l"
{ CALLBACK(LS_SF_DT_DECIMAL, yytext, yyleng, 0);
                                      BEGIN(LIST_OPTIONAL_PARAM);
                                    }
	YY_BREAK
case 74:
YY_RULE_SETUP
#line 390 "ls-sfparser.l"
{
                                      yytext[yyleng - 1] = '\0';
                                      CALLBACK(LS_SF_DT_STRING, yytext + 1, yyleng - 2, 1);
                                      BEGIN(LIST_OPTIONAL_PARAM);
                                    }
	YY_BREAK
case 75:
YY_RULE_SETUP
#line 395 "ls-sfparser.l"
{ CALLBACK(LS_SF_DT_TOKEN, yytext, yyleng, 0);
                                      BEGIN(LIST_OPTIONAL_PARAM);
                                    }
	YY_BREAK
case 76:
YY_RULE_SETUP
#line 398 "ls-sfparser.l"
{
                                      yytext[yyleng - 1] = '\0';
                                      CALLBACK(LS_SF_DT_BYTESEQ, yytext + 1, yyleng - 2, 1);
                                      BEGIN(LIST_OPTIONAL_PARAM);
                                    }
	YY_BREAK
case 77:
YY_RULE_SETUP
#line 403 "ls-sfparser.l"
{ CALLBACK(LS_SF_DT_BOOLEAN, yytext + 1, yyleng - 1, 1);
                                      BEGIN(LIST_OPTIONAL_PARAM);
                                    }
	YY_BREAK


case 78:
YY_RULE_SETUP
#line 409 "ls-sfparser.l"
/* Eat up whitespace */
	YY_BREAK
case 79:
YY_RULE_SETUP
#line 410 "ls-sfparser.l"
{ CALLBACK(LS_SF_DT_INTEGER, yytext, yyleng, 0);
                                      BEGIN(ITEM_OPTIONAL_PARAM);
                                    }
	YY_BREAK
case 80:
YY_RULE_SETUP
#line 413 "ls-sfparser.l"
{ CALLBACK(LS_SF_DT_DECIMAL, yytext, yyleng, 0);
                                      BEGIN(ITEM_OPTIONAL_PARAM);
                                    }
	YY_BREAK
case 81:
YY_RULE_SETUP
#line 416 "ls-sfparser.l"
{
                                      yytext[yyleng - 1] = '\0';
                                      CALLBACK(LS_SF_DT_STRING, yytext + 1, yyleng - 2, 1);
                                      BEGIN(ITEM_OPTIONAL_PARAM);
                                    }
	YY_BREAK
case 82:
YY_RULE_SETUP
#line 421 "ls-sfparser.l"
{ CALLBACK(LS_SF_DT_TOKEN, yytext, yyleng, 0);
                                      BEGIN(ITEM_OPTIONAL_PARAM);
                                    }
	YY_BREAK
case 83:
YY_RULE_SETUP
#line 424 "ls-sfparser.l"
{
                                      yytext[yyleng - 1] = '\0';
                                      CALLBACK(LS_SF_DT_BYTESEQ, yytext + 1, yyleng - 2, 1);
                                      BEGIN(ITEM_OPTIONAL_PARAM);
                                    }
	YY_BREAK
case 84:
YY_RULE_SETUP
#line 429 "ls-sfparser.l"
{ CALLBACK(LS_SF_DT_BOOLEAN, yytext + 1, yyleng - 1, 1);
                                      BEGIN(ITEM_OPTIONAL_PARAM);
                                    }
	YY_BREAK
case YY_STATE_EOF(ITEM):
#line 432 "ls-sfparser.l"
{ return -1; }
	YY_BREAK


case 85:
YY_RULE_SETUP
#line 436 "ls-sfparser.l"
/* Eat up whitespace */
	YY_BREAK
case 86:
YY_RULE_SETUP
#line 437 "ls-sfparser.l"
{ BEGIN(ITEM_PARAM_KEY); }
	YY_BREAK


case 87:
YY_RULE_SETUP
#line 441 "ls-sfparser.l"
/* Eat up whitespace */
	YY_BREAK
case 88:
YY_RULE_SETUP
#line 442 "ls-sfparser.l"
{ CALLBACK(LS_SF_DT_PARAM_NAME, yytext, yyleng, 0);
                                        BEGIN(ITEM_PARAM_EQ); }
	YY_BREAK


case 89:
YY_RULE_SETUP
#line 447 "ls-sfparser.l"
{ BEGIN(ITEM); }
	YY_BREAK
case 90:
YY_RULE_SETUP
#line 448 "ls-sfparser.l"
{ TRUE[0] = '1';
                                      CALLBACK(LS_SF_DT_BOOLEAN, TRUE, 1, -1);
                                      BEGIN(ITEM_OPTIONAL_PARAM);
                                    }
	YY_BREAK
case 91:
YY_RULE_SETUP
#line 452 "ls-sfparser.l"
{ TRUE[0] = '1';
                                      CALLBACK(LS_SF_DT_BOOLEAN, TRUE, 1, -1);
                                      BEGIN(ITEM_PARAM_KEY);
                                    }
	YY_BREAK
case YY_STATE_EOF(ITEM_PARAM_EQ):
#line 456 "ls-sfparser.l"
{ TRUE[0] = '1';
                                      CALLBACK(LS_SF_DT_BOOLEAN, TRUE, 1, -1);
                                      return 0;
                                    }
	YY_BREAK

case 92:
YY_RULE_SETUP
#line 462 "ls-sfparser.l"
{ return -1; }
	YY_BREAK
case 93:
YY_RULE_SETUP
#line 464 "ls-sfparser.l"
YY_FATAL_ERROR( "flex scanner jammed" );
	YY_BREAK
#line 1893 "ls-sfparser.c"
case YY_STATE_EOF(INITIAL):
case YY_STATE_EOF(DICTIONARY):
case YY_STATE_EOF(DIC_PARAM_KEY):
case YY_STATE_EOF(LIST_OPTIONAL_PARAM):
case YY_STATE_EOF(LIST):
case YY_STATE_EOF(LIST_PARAM_KEY):
case YY_STATE_EOF(LIST_PARAM_ITEM):
case YY_STATE_EOF(LIST_PARAM_EQ):
case YY_STATE_EOF(ITEM_OPTIONAL_PARAM):
case YY_STATE_EOF(ITEM_PARAM_KEY):
case YY_STATE_EOF(ITEM_BARE_ITEM):
case YY_STATE_EOF(IL_PARAM_KEY):
case YY_STATE_EOF(IL_PARAM_EQ):
case YY_STATE_EOF(ERROR_STATE):
	yyterminate();

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - yyg->yytext_ptr) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = yyg->yy_hold_char;
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * ls_sfp_lex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			yyg->yy_n_chars = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = yyin;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( yyg->yy_c_buf_p <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			yyg->yy_c_buf_p = yyg->yytext_ptr + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state( yyscanner );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state , yyscanner);

			yy_bp = yyg->yytext_ptr + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++yyg->yy_c_buf_p;
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = yyg->yy_last_accepting_cpos;
				yy_current_state = yyg->yy_last_accepting_state;
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer( yyscanner ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				yyg->yy_did_buffer_switch_on_eof = 0;

				if ( ls_sfp_wrap(yyscanner ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					yyg->yy_c_buf_p = yyg->yytext_ptr + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! yyg->yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				yyg->yy_c_buf_p =
					yyg->yytext_ptr + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state( yyscanner );

				yy_cp = yyg->yy_c_buf_p;
				yy_bp = yyg->yytext_ptr + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				yyg->yy_c_buf_p =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars];

				yy_current_state = yy_get_previous_state( yyscanner );

				yy_cp = yyg->yy_c_buf_p;
				yy_bp = yyg->yytext_ptr + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
} /* end of ls_sfp_lex */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int yy_get_next_buffer (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	register char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	register char *source = yyg->yytext_ptr;
	register int number_to_move, i;
	int ret_val;

	if ( yyg->yy_c_buf_p > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( yyg->yy_c_buf_p - yyg->yytext_ptr - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) (yyg->yy_c_buf_p - yyg->yytext_ptr) - 1;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars = 0;

	else
		{
			int num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER;

			int yy_c_buf_p_offset =
				(int) (yyg->yy_c_buf_p - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				int new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					ls_sfp_realloc((void *) b->yy_ch_buf,b->yy_buf_size + 2 ,yyscanner );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = 0;

			if ( ! b->yy_ch_buf )
            {
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );
                return EOB_ACT_END_OF_FILE;
            }

			yyg->yy_c_buf_p = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			yyg->yy_n_chars, (size_t) num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars;
		}

	if ( yyg->yy_n_chars == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			ls_sfp_restart(yyin  ,yyscanner);
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if ((yy_size_t) (yyg->yy_n_chars + number_to_move) > YY_CURRENT_BUFFER_LVALUE->yy_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		yy_size_t new_size = yyg->yy_n_chars + number_to_move + (yyg->yy_n_chars >> 1);
		YY_CURRENT_BUFFER_LVALUE->yy_ch_buf = (char *) ls_sfp_realloc((void *) YY_CURRENT_BUFFER_LVALUE->yy_ch_buf,new_size ,yyscanner );
		if ( ! YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
        {
			YY_FATAL_ERROR( "out of dynamic memory in yy_get_next_buffer()" );
            return EOB_ACT_END_OF_FILE;
        }
	}

	yyg->yy_n_chars += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars + 1] = YY_END_OF_BUFFER_CHAR;

	yyg->yytext_ptr = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

    static yy_state_type yy_get_previous_state (yyscan_t yyscanner)
{
	register yy_state_type yy_current_state;
	register char *yy_cp;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	yy_current_state = yyg->yy_start;

	for ( yy_cp = yyg->yytext_ptr + YY_MORE_ADJ; yy_cp < yyg->yy_c_buf_p; ++yy_cp )
		{
		register YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		if ( yy_accept[yy_current_state] )
			{
			yyg->yy_last_accepting_state = yy_current_state;
			yyg->yy_last_accepting_cpos = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 365 )
				yy_c = yy_meta[(unsigned int) yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state , yyscan_t yyscanner)
{
	register int yy_is_jam;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner; /* This var may be unused depending upon options. */
	register char *yy_cp = yyg->yy_c_buf_p;

	register YY_CHAR yy_c = 1;
	if ( yy_accept[yy_current_state] )
		{
		yyg->yy_last_accepting_state = yy_current_state;
		yyg->yy_last_accepting_cpos = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 365 )
			yy_c = yy_meta[(unsigned int) yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
	yy_is_jam = (yy_current_state == 364);

	return yy_is_jam ? 0 : yy_current_state;
}

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (yyscan_t yyscanner)
#else
    static int input  (yyscan_t yyscanner)
#endif

{
	int c;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	*yyg->yy_c_buf_p = yyg->yy_hold_char;

	if ( *yyg->yy_c_buf_p == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( yyg->yy_c_buf_p < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars] )
			/* This was really a NUL. */
			*yyg->yy_c_buf_p = '\0';

		else
			{ /* need more input */
			int offset = yyg->yy_c_buf_p - yyg->yytext_ptr;
			++yyg->yy_c_buf_p;

			switch ( yy_get_next_buffer( yyscanner ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					ls_sfp_restart(yyin ,yyscanner);

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( ls_sfp_wrap(yyscanner ) )
						return EOF;

					if ( ! yyg->yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput(yyscanner);
#else
					return input(yyscanner);
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					yyg->yy_c_buf_p = yyg->yytext_ptr + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) yyg->yy_c_buf_p;	/* cast for 8-bit char's */
	*yyg->yy_c_buf_p = '\0';	/* preserve yytext */
	yyg->yy_hold_char = *++yyg->yy_c_buf_p;

	return c;
}
#endif	/* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * @param yyscanner The scanner object.
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void ls_sfp_restart  (FILE * input_file , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	if ( ! YY_CURRENT_BUFFER ){
        if (ls_sfp_ensure_buffer_stack (yyscanner))
            return;
		YY_CURRENT_BUFFER_LVALUE =
            ls_sfp__create_buffer(yyin,YY_BUF_SIZE ,yyscanner);
	}

	ls_sfp__init_buffer(YY_CURRENT_BUFFER,input_file ,yyscanner);
	ls_sfp__load_buffer_state(yyscanner );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * @param yyscanner The scanner object.
 */
    void ls_sfp__switch_to_buffer  (YY_BUFFER_STATE  new_buffer , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	/* TODO. We should be able to replace this entire function body
	 * with
	 *		ls_sfp_pop_buffer_state();
	 *		ls_sfp_push_buffer_state(new_buffer);
     */
	if (ls_sfp_ensure_buffer_stack (yyscanner))
        return;
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*yyg->yy_c_buf_p = yyg->yy_hold_char;
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = yyg->yy_c_buf_p;
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars;
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	ls_sfp__load_buffer_state(yyscanner );

	/* We don't actually know whether we did this switch during
	 * EOF (ls_sfp_wrap()) processing, but the only time this flag
	 * is looked at is after ls_sfp_wrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	yyg->yy_did_buffer_switch_on_eof = 1;
}

static void ls_sfp__load_buffer_state  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	yyg->yy_n_chars = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	yyg->yytext_ptr = yyg->yy_c_buf_p = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	yyin = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
	yyg->yy_hold_char = *yyg->yy_c_buf_p;
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * @param yyscanner The scanner object.
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE ls_sfp__create_buffer  (FILE * file, int  size , yyscan_t yyscanner)
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) ls_sfp_alloc(sizeof( struct yy_buffer_state ) ,yyscanner );
	if ( ! b )
    {
		YY_FATAL_ERROR( "out of dynamic memory in ls_sfp__create_buffer()" );
        return NULL;
    }

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) ls_sfp_alloc(b->yy_buf_size + 2 ,yyscanner );
	if ( ! b->yy_ch_buf )
    {
		YY_FATAL_ERROR( "out of dynamic memory in ls_sfp__create_buffer()" );
        return NULL;
    }

	b->yy_is_our_buffer = 1;

	ls_sfp__init_buffer(b,file ,yyscanner);

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with ls_sfp__create_buffer()
 * @param yyscanner The scanner object.
 */
    void ls_sfp__delete_buffer (YY_BUFFER_STATE  b , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		ls_sfp_free((void *) b->yy_ch_buf ,yyscanner );

	ls_sfp_free((void *) b ,yyscanner );
}

/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a ls_sfp_restart() or at EOF.
 */
    static void ls_sfp__init_buffer  (YY_BUFFER_STATE  b, FILE * file , yyscan_t yyscanner)

{
	int oerrno = errno;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	ls_sfp__flush_buffer(b ,yyscanner);

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then ls_sfp__init_buffer was _probably_
     * called from ls_sfp_restart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

        b->yy_is_interactive = 0;
    
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * @param yyscanner The scanner object.
 */
    void ls_sfp__flush_buffer (YY_BUFFER_STATE  b , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		ls_sfp__load_buffer_state(yyscanner );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  @param yyscanner The scanner object.
 */
void ls_sfp_push_buffer_state (YY_BUFFER_STATE new_buffer , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	if (new_buffer == NULL)
		return;

	if (ls_sfp_ensure_buffer_stack(yyscanner))
        return;

	/* This block is copied from ls_sfp__switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*yyg->yy_c_buf_p = yyg->yy_hold_char;
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = yyg->yy_c_buf_p;
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars;
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		yyg->yy_buffer_stack_top++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from ls_sfp__switch_to_buffer. */
	ls_sfp__load_buffer_state(yyscanner );
	yyg->yy_did_buffer_switch_on_eof = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  @param yyscanner The scanner object.
 */
void ls_sfp_pop_buffer_state (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	if (!YY_CURRENT_BUFFER)
		return;

	ls_sfp__delete_buffer(YY_CURRENT_BUFFER ,yyscanner);
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if (yyg->yy_buffer_stack_top > 0)
		--yyg->yy_buffer_stack_top;

	if (YY_CURRENT_BUFFER) {
		ls_sfp__load_buffer_state(yyscanner );
		yyg->yy_did_buffer_switch_on_eof = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static int ls_sfp_ensure_buffer_stack (yyscan_t yyscanner)
{
	int num_to_alloc;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	if (!yyg->yy_buffer_stack) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
		num_to_alloc = 1;
		yyg->yy_buffer_stack = (struct yy_buffer_state**)ls_sfp_alloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								, yyscanner);
		if ( ! yyg->yy_buffer_stack )
        {
			YY_FATAL_ERROR( "out of dynamic memory in ls_sfp_ensure_buffer_stack()" );
            return -1;
        }
								  
		memset(yyg->yy_buffer_stack, 0, num_to_alloc * sizeof(struct yy_buffer_state*));
				
		yyg->yy_buffer_stack_max = num_to_alloc;
		yyg->yy_buffer_stack_top = 0;
		return 0;
	}

	if (yyg->yy_buffer_stack_top >= (yyg->yy_buffer_stack_max) - 1){

		/* Increase the buffer to prepare for a possible push. */
		int grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = yyg->yy_buffer_stack_max + grow_size;
		yyg->yy_buffer_stack = (struct yy_buffer_state**)ls_sfp_realloc
								(yyg->yy_buffer_stack,
								num_to_alloc * sizeof(struct yy_buffer_state*)
								, yyscanner);
		if ( ! yyg->yy_buffer_stack )
        {
			YY_FATAL_ERROR( "out of dynamic memory in ls_sfp_ensure_buffer_stack()" );
            return -1;
        }

		/* zero only the new slots.*/
		memset(yyg->yy_buffer_stack + yyg->yy_buffer_stack_max, 0, grow_size * sizeof(struct yy_buffer_state*));
		yyg->yy_buffer_stack_max = num_to_alloc;
	}

    return 0;
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * @param yyscanner The scanner object.
 * @return the newly allocated buffer state object. 
 */
YY_BUFFER_STATE ls_sfp__scan_buffer  (char * base, yy_size_t  size , yyscan_t yyscanner)
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return 0;

	b = (YY_BUFFER_STATE) ls_sfp_alloc(sizeof( struct yy_buffer_state ) ,yyscanner );
	if ( ! b )
    {
		YY_FATAL_ERROR( "out of dynamic memory in ls_sfp__scan_buffer()" );
        return 0;
    }

	b->yy_buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = 0;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	ls_sfp__switch_to_buffer(b ,yyscanner );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to ls_sfp_lex() will
 * scan from a @e copy of @a str.
 * @param yystr a NUL-terminated string to scan
 * @param yyscanner The scanner object.
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       ls_sfp__scan_bytes() instead.
 */
YY_BUFFER_STATE ls_sfp__scan_string (yyconst char * yystr , yyscan_t yyscanner)
{
    
	return ls_sfp__scan_bytes(yystr,strlen(yystr) ,yyscanner);
}

/** Setup the input buffer state to scan the given bytes. The next call to ls_sfp_lex() will
 * scan from a @e copy of @a bytes.
 * @param yybytes the byte buffer to scan
 * @param _yybytes_len the number of bytes in the buffer pointed to by @a bytes.
 * @param yyscanner The scanner object.
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE ls_sfp__scan_bytes  (yyconst char * yybytes, int  _yybytes_len , yyscan_t yyscanner)
{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	int i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = _yybytes_len + 2;
	buf = (char *) ls_sfp_alloc(n ,yyscanner );
	if ( ! buf )
    {
		YY_FATAL_ERROR( "out of dynamic memory in ls_sfp__scan_bytes()" );
        return NULL;
    }

	for ( i = 0; i < _yybytes_len; ++i )
		buf[i] = yybytes[i];

	buf[_yybytes_len] = buf[_yybytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = ls_sfp__scan_buffer(buf,n ,yyscanner);
	if ( ! b )
    {
		YY_FATAL_ERROR( "bad buffer in ls_sfp__scan_bytes()" );
        return NULL;
    }

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void yy_fatal_error (yyconst char* msg , yyscan_t yyscanner)
{
    	(void) fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		yytext[yyleng] = yyg->yy_hold_char; \
		yyg->yy_c_buf_p = yytext + yyless_macro_arg; \
		yyg->yy_hold_char = *yyg->yy_c_buf_p; \
		*yyg->yy_c_buf_p = '\0'; \
		yyleng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the user-defined data for this scanner.
 * @param yyscanner The scanner object.
 */
YY_EXTRA_TYPE ls_sfp_get_extra  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyextra;
}

/** Get the current line number.
 * @param yyscanner The scanner object.
 */
int ls_sfp_get_lineno  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    
        if (! YY_CURRENT_BUFFER)
            return 0;
    
    return yylineno;
}

/** Get the current column number.
 * @param yyscanner The scanner object.
 */
int ls_sfp_get_column  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    
        if (! YY_CURRENT_BUFFER)
            return 0;
    
    return yycolumn;
}

/** Get the input stream.
 * @param yyscanner The scanner object.
 */
FILE *ls_sfp_get_in  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyin;
}

/** Get the output stream.
 * @param yyscanner The scanner object.
 */
FILE *ls_sfp_get_out  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyout;
}

/** Get the length of the current token.
 * @param yyscanner The scanner object.
 */
int ls_sfp_get_leng  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyleng;
}

/** Get the current token.
 * @param yyscanner The scanner object.
 */

char *ls_sfp_get_text  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yytext;
}

/** Set the user-defined data. This data is never touched by the scanner.
 * @param user_defined The data to be associated with this scanner.
 * @param yyscanner The scanner object.
 */
void ls_sfp_set_extra (YY_EXTRA_TYPE  user_defined , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yyextra = user_defined ;
}

/** Set the current line number.
 * @param line_number
 * @param yyscanner The scanner object.
 */
void ls_sfp_set_lineno (int  line_number , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

        /* lineno is only valid if an input buffer exists. */
        if (! YY_CURRENT_BUFFER )
           yy_fatal_error( "ls_sfp_set_lineno called with no buffer" , yyscanner); 
    
    yylineno = line_number;
}

/** Set the current column.
 * @param line_number
 * @param yyscanner The scanner object.
 */
void ls_sfp_set_column (int  column_no , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

        /* column is only valid if an input buffer exists. */
        if (! YY_CURRENT_BUFFER )
           yy_fatal_error( "ls_sfp_set_column called with no buffer" , yyscanner); 
    
    yycolumn = column_no;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param in_str A readable stream.
 * @param yyscanner The scanner object.
 * @see ls_sfp__switch_to_buffer
 */
void ls_sfp_set_in (FILE *  in_str , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yyin = in_str ;
}

void ls_sfp_set_out (FILE *  out_str , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yyout = out_str ;
}

int ls_sfp_get_debug  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yy_flex_debug;
}

void ls_sfp_set_debug (int  bdebug , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yy_flex_debug = bdebug ;
}

/* Accessor methods for yylval and yylloc */

/* User-visible API */

/* ls_sfp_lex_init is special because it creates the scanner itself, so it is
 * the ONLY reentrant function that doesn't take the scanner as the last argument.
 * That's why we explicitly handle the declaration, instead of using our macros.
 */

int ls_sfp_lex_init(yyscan_t* ptr_yy_globals)

{
    if (ptr_yy_globals == NULL){
        errno = EINVAL;
        return 1;
    }

    *ptr_yy_globals = (yyscan_t) ls_sfp_alloc ( sizeof( struct yyguts_t ), NULL );

    if (*ptr_yy_globals == NULL){
        errno = ENOMEM;
        return 1;
    }

    /* By setting to 0xAA, we expose bugs in yy_init_globals. Leave at 0x00 for releases. */
    memset(*ptr_yy_globals,0x00,sizeof(struct yyguts_t));

    return yy_init_globals ( *ptr_yy_globals );
}

/* ls_sfp_lex_init_extra has the same functionality as ls_sfp_lex_init, but follows the
 * convention of taking the scanner as the last argument. Note however, that
 * this is a *pointer* to a scanner, as it will be allocated by this call (and
 * is the reason, too, why this function also must handle its own declaration).
 * The user defined value in the first argument will be available to ls_sfp_alloc in
 * the yyextra field.
 */

int ls_sfp_lex_init_extra(YY_EXTRA_TYPE yy_user_defined,yyscan_t* ptr_yy_globals )

{
    struct yyguts_t dummy_yyguts;

    ls_sfp_set_extra (yy_user_defined, &dummy_yyguts);

    if (ptr_yy_globals == NULL){
        errno = EINVAL;
        return 1;
    }
	
    *ptr_yy_globals = (yyscan_t) ls_sfp_alloc ( sizeof( struct yyguts_t ), &dummy_yyguts );
	
    if (*ptr_yy_globals == NULL){
        errno = ENOMEM;
        return 1;
    }
    
    /* By setting to 0xAA, we expose bugs in
    yy_init_globals. Leave at 0x00 for releases. */
    memset(*ptr_yy_globals,0x00,sizeof(struct yyguts_t));
    
    ls_sfp_set_extra (yy_user_defined, *ptr_yy_globals);
    
    return yy_init_globals ( *ptr_yy_globals );
}

static int yy_init_globals (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from ls_sfp_lex_destroy(), so don't allocate here.
     */

    yyg->yy_buffer_stack = 0;
    yyg->yy_buffer_stack_top = 0;
    yyg->yy_buffer_stack_max = 0;
    yyg->yy_c_buf_p = (char *) 0;
    yyg->yy_init = 0;
    yyg->yy_start = 0;

    yyg->yy_start_stack_ptr = 0;
    yyg->yy_start_stack_depth = 0;
    yyg->yy_start_stack =  NULL;

/* Defined in main.c */
#ifdef YY_STDINIT
    yyin = stdin;
    yyout = stdout;
#else
    yyin = (FILE *) 0;
    yyout = (FILE *) 0;
#endif

    /* For future reference: Set errno on error, since we are called by
     * ls_sfp_lex_init()
     */
    return 0;
}

/* ls_sfp_lex_destroy is for both reentrant and non-reentrant scanners. */
int ls_sfp_lex_destroy  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		ls_sfp__delete_buffer(YY_CURRENT_BUFFER ,yyscanner );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		ls_sfp_pop_buffer_state(yyscanner);
	}

	/* Destroy the stack itself. */
	ls_sfp_free(yyg->yy_buffer_stack ,yyscanner);
	yyg->yy_buffer_stack = NULL;

    /* Destroy the start condition stack. */
        ls_sfp_free(yyg->yy_start_stack ,yyscanner );
        yyg->yy_start_stack = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * ls_sfp_lex() is called, initialization will occur. */
    yy_init_globals( yyscanner);

    /* Destroy the main struct (reentrant only). */
    ls_sfp_free ( yyscanner , yyscanner );
    yyscanner = NULL;
    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, yyconst char * s2, int n , yyscan_t yyscanner)
{
	register int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * s , yyscan_t yyscanner)
{
	register int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

#define YYTABLES_NAME "yytables"

#line 464 "ls-sfparser.l"



const char *const ls_sf_dt2str[] =
{
    [LS_SF_DT_INTEGER]      = "INTEGER",
    [LS_SF_DT_DECIMAL]      = "DECIMAL",
    [LS_SF_DT_NAME]         = "NAME",
    [LS_SF_DT_PARAM_NAME]   = "PARAM_NAME",
    [LS_SF_DT_STRING]       = "STRING",
    [LS_SF_DT_TOKEN]        = "TOKEN",
    [LS_SF_DT_BYTESEQ]      = "BYTESEQ",
    [LS_SF_DT_BOOLEAN]      = "BOOLEAN",
    [LS_SF_DT_INNER_LIST_BEGIN] = "INNER_LIST_BEGIN",
    [LS_SF_DT_INNER_LIST_END] = "INNER_LIST_END",
};


int
ls_sf_parse (enum ls_sf_tlt top_level_type, const char *input, size_t input_sz,
    int (*callback)(void *user_data, enum ls_sf_dt, char *str, size_t, int),
    void *user_data, char *mem_buf, size_t mem_buf_sz)
{
    struct ls_sf_parser parser;
    yyscan_t scanner;
    YY_BUFFER_STATE buf;
    int ret;

    parser.top_level_type = top_level_type;
    parser.callback = callback;
    parser.user_data = user_data;
    parser.errmsg = NULL;
    parser.mem_failed = 0;

    if (mem_buf && mem_buf_sz)
    {
        parser.mem = mem_buf;
        parser.mem_off = 0;
        parser.mem_sz = mem_buf_sz;
        parser.last_malloced = NULL;
    }
    else
        parser.mem = NULL;

    if (0 != ls_sfp_lex_init_extra(&parser, &scanner))
        return -1;

    buf = ls_sfp__scan_bytes(input, input_sz, scanner);
    if (buf)
    {
        ret = ls_sfp_lex(scanner);
        if (parser.mem_failed)
            ret = -2;
        else if (parser.errmsg)
            ret = -1;
        ls_sfp__delete_buffer(buf, scanner);
    }
    else
        ret = -2;

    ls_sfp_lex_destroy(scanner);
    return ret;
}


void *
ls_sfp_alloc (size_t bytes, void *yyscanner)
{
    struct ls_sf_parser *const parser = ls_sfp_get_extra(yyscanner);

    if (parser->mem)
    {
        if (bytes + parser->mem_off < parser->mem_sz)
        {
            parser->last_malloced = parser->mem + parser->mem_off;
            parser->mem_off += bytes;
            return parser->last_malloced;
        }
        else
        {
            parser->mem_failed = 1;
            return NULL;
        }
    }
    else
        return malloc(bytes);
}


#define MAX(a, b) ((a) > (b) ? (a) : (b))

void *
ls_sfp_realloc (void *ptr, size_t bytes, void *yyscanner)
{
    struct ls_sf_parser *const parser = ls_sfp_get_extra(yyscanner);
    void *ret;

    if (parser->mem)
    {
        if ((char *) ptr == parser->last_malloced)
        {
            if (parser->last_malloced + bytes <= parser->mem + parser->mem_sz)
                return ptr;
            else
            {
                parser->mem_failed = 1;
                return NULL;
            }
        }
        else if (ret = ls_sfp_alloc(bytes, yyscanner), ret != NULL)
        {
            memcpy(ret, ptr,
                /* We don't know how large it was, so just copy the max */
                MAX(bytes, (size_t) (
                                parser->mem + parser->mem_sz - (char *) ptr)));
            return ret;
        }
        else
        {
            parser->mem_failed = 1;
            return NULL;
        }
    }
    else
        return realloc(ptr, bytes);
}


void
ls_sfp_free (void *ptr, void *yyscanner)
{
    struct ls_sf_parser *const parser = ls_sfp_get_extra(yyscanner);

    if (parser->mem)
    {
        if ((char *) ptr == parser->last_malloced)
            parser->mem_off = parser->last_malloced - parser->mem;
    }
    else
        free(ptr);
}

