/* Generated by re2c 0.13.5 on Fri Mar 26 18:06:18 2010 */
/*
   +----------------------------------------------------------------------+
   | PHP Version 5                                                        |
   +----------------------------------------------------------------------+
   | Copyright (c) 1997-2006 The PHP Group                                |
   +----------------------------------------------------------------------+
   | This source file is subject to version 3.01 of the PHP license,      |
   | that is bundled with this package in the file LICENSE, and is        |
   | available through the world-wide-web at the following url:           |
   | http://www.php.net/license/3_01.txt                                  |
   | If you did not receive a copy of the PHP license and are unable to   |
   | obtain it through the world-wide-web, please send a note to          |
   | license@php.net so we can mail you a copy immediately.               |
   +----------------------------------------------------------------------+
   | Authors: Derick Rethans <derick@derickrethans.nl>                    |
   +----------------------------------------------------------------------+
 */

/* $Id: parse_date.c 301252 2010-07-13 23:59:54Z kalle $ */

#include "timelib.h"

#include <stdio.h>
#include <ctype.h>

#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#else
#include <strings.h>
#endif

#if defined(_MSC_VER)
# define strtoll(s, f, b) _atoi64(s)
#elif !defined(HAVE_STRTOLL)
# if defined(HAVE_ATOLL)
#  define strtoll(s, f, b) atoll(s)
# else
#  define strtoll(s, f, b) strtol(s, f, b)
# endif
#endif

#define TIMELIB_UNSET   -99999

#define TIMELIB_SECOND  1
#define TIMELIB_MINUTE  2
#define TIMELIB_HOUR    3
#define TIMELIB_DAY     4
#define TIMELIB_MONTH   5
#define TIMELIB_YEAR    6
#define TIMELIB_WEEKDAY 7
#define TIMELIB_SPECIAL 8

#define EOI      257
#define TIME     258
#define DATE     259

#define TIMELIB_XMLRPC_SOAP    260
#define TIMELIB_TIME12         261
#define TIMELIB_TIME24         262
#define TIMELIB_GNU_NOCOLON    263
#define TIMELIB_GNU_NOCOLON_TZ 264
#define TIMELIB_ISO_NOCOLON    265

#define TIMELIB_AMERICAN       266
#define TIMELIB_ISO_DATE       267
#define TIMELIB_DATE_FULL      268
#define TIMELIB_DATE_TEXT      269
#define TIMELIB_DATE_NOCOLON   270
#define TIMELIB_PG_YEARDAY     271
#define TIMELIB_PG_TEXT        272
#define TIMELIB_PG_REVERSE     273
#define TIMELIB_CLF            274
#define TIMELIB_DATE_NO_DAY    275
#define TIMELIB_SHORTDATE_WITH_TIME 276
#define TIMELIB_DATE_FULL_POINTED 277
#define TIMELIB_TIME24_WITH_ZONE 278
#define TIMELIB_ISO_WEEK       279

#define TIMELIB_TIMEZONE       300
#define TIMELIB_AGO            301

#define TIMELIB_RELATIVE       310

#define TIMELIB_ERROR          999

/* Some compilers like AIX, defines uchar in sys/types.h */
#undef uchar
typedef unsigned char uchar;

#define   BSIZE	   8192

#define   YYCTYPE      uchar
#define   YYCURSOR     cursor
#define   YYLIMIT      s->lim
#define   YYMARKER     s->ptr
#define   YYFILL(n)    return EOI;

#define   RET(i)       {s->cur = cursor; return i;}

#define timelib_string_free free

#define TIMELIB_HAVE_TIME() { if (s->time->have_time) { add_error(s, "Double time specification"); timelib_string_free(str); return TIMELIB_ERROR; } else { s->time->have_time = 1; s->time->h = 0; s->time->i = 0; s->time->s = 0; s->time->f = 0; } }
#define TIMELIB_UNHAVE_TIME() { s->time->have_time = 0; s->time->h = 0; s->time->i = 0; s->time->s = 0; s->time->f = 0; }
#define TIMELIB_HAVE_DATE() { if (s->time->have_date) { add_error(s, "Double date specification"); timelib_string_free(str); return TIMELIB_ERROR; } else { s->time->have_date = 1; } }
#define TIMELIB_UNHAVE_DATE() { s->time->have_date = 0; s->time->d = 0; s->time->m = 0; s->time->y = 0; }
#define TIMELIB_HAVE_RELATIVE() { s->time->have_relative = 1; s->time->relative.weekday_behavior = 1; }
#define TIMELIB_HAVE_WEEKDAY_RELATIVE() { s->time->have_weekday_relative = 1; }
#define TIMELIB_HAVE_SPECIAL_RELATIVE() { s->time->have_special_relative = 1; }
#define TIMELIB_HAVE_TZ() { s->cur = cursor; if (s->time->have_zone) { add_warning(s, "Double timezone specification"); timelib_string_free(str); return TIMELIB_ERROR; } else { s->time->have_zone = 1; } }

#define TIMELIB_INIT  s->cur = cursor; str = timelib_string(s); ptr = str
#define TIMELIB_DEINIT timelib_string_free(str)
#define TIMELIB_ADJUST_RELATIVE_WEEKDAY() if (in->time.have_weekday_relative && (in.rel.d > 0)) { in.rel.d -= 7; }

#define TIMELIB_PROCESS_YEAR(x) { \
	if ((x) == TIMELIB_UNSET) {         \
	/*	(x) = 0; */          \
	} else if ((x) < 100) {  \
		if ((x) < 70) {      \
			(x) += 2000;     \
		} else {             \
			(x) += 1900;     \
		}                    \
	}                        \
}

#ifdef DEBUG_PARSER
#define DEBUG_OUTPUT(s) printf("%s\n", s);
#define YYDEBUG(s,c) { if (s != -1) { printf("state: %d ", s); printf("[%c]\n", c); } }
#else
#define DEBUG_OUTPUT(s)
#define YYDEBUG(s,c)
#endif

#include "timelib_structs.h"

typedef struct timelib_elems {
	unsigned int   c; /* Number of elements */
	char         **v; /* Values */
} timelib_elems;

typedef struct Scanner {
	int           fd;
	uchar        *lim, *str, *ptr, *cur, *tok, *pos;
	unsigned int  line, len;
	struct timelib_error_container *errors;

	struct timelib_time *time;
	const timelib_tzdb  *tzdb;
} Scanner;

typedef struct _timelib_lookup_table {
    const char *name;
    int         type;
    int         value;
} timelib_lookup_table;

typedef struct _timelib_relunit {
	const char *name;
	int         unit;
	int         multiplier;
} timelib_relunit;

#define HOUR(a) (int)(a * 60)

/* The timezone table. */
const static timelib_tz_lookup_table timelib_timezone_lookup[] = {
#include "timezonemap.h"
	{ NULL, 0, 0, NULL },
};

const static timelib_tz_lookup_table timelib_timezone_fallbackmap[] = {
#include "fallbackmap.h"
	{ NULL, 0, 0, NULL },
};

const static timelib_tz_lookup_table timelib_timezone_utc[] = {
	{ "utc", 0, 0, "UTC" },
};

static timelib_relunit const timelib_relunit_lookup[] = {
	{ "sec",         TIMELIB_SECOND,  1 },
	{ "secs",        TIMELIB_SECOND,  1 },
	{ "second",      TIMELIB_SECOND,  1 },
	{ "seconds",     TIMELIB_SECOND,  1 },
	{ "min",         TIMELIB_MINUTE,  1 },
	{ "mins",        TIMELIB_MINUTE,  1 },
	{ "minute",      TIMELIB_MINUTE,  1 },
	{ "minutes",     TIMELIB_MINUTE,  1 },
	{ "hour",        TIMELIB_HOUR,    1 },
	{ "hours",       TIMELIB_HOUR,    1 },
	{ "day",         TIMELIB_DAY,     1 },
	{ "days",        TIMELIB_DAY,     1 },
	{ "week",        TIMELIB_DAY,     7 },
	{ "weeks",       TIMELIB_DAY,     7 },
	{ "fortnight",   TIMELIB_DAY,    14 },
	{ "fortnights",  TIMELIB_DAY,    14 },
	{ "forthnight",  TIMELIB_DAY,    14 },
	{ "forthnights", TIMELIB_DAY,    14 },
	{ "month",       TIMELIB_MONTH,   1 },
	{ "months",      TIMELIB_MONTH,   1 },
	{ "year",        TIMELIB_YEAR,    1 },
	{ "years",       TIMELIB_YEAR,    1 },

	{ "monday",      TIMELIB_WEEKDAY, 1 },
	{ "mon",         TIMELIB_WEEKDAY, 1 },
	{ "tuesday",     TIMELIB_WEEKDAY, 2 },
	{ "tue",         TIMELIB_WEEKDAY, 2 },
	{ "wednesday",   TIMELIB_WEEKDAY, 3 },
	{ "wed",         TIMELIB_WEEKDAY, 3 },
	{ "thursday",    TIMELIB_WEEKDAY, 4 },
	{ "thu",         TIMELIB_WEEKDAY, 4 },
	{ "friday",      TIMELIB_WEEKDAY, 5 },
	{ "fri",         TIMELIB_WEEKDAY, 5 },
	{ "saturday",    TIMELIB_WEEKDAY, 6 },
	{ "sat",         TIMELIB_WEEKDAY, 6 },
	{ "sunday",      TIMELIB_WEEKDAY, 0 },
	{ "sun",         TIMELIB_WEEKDAY, 0 },

	{ "weekday",     TIMELIB_SPECIAL, TIMELIB_SPECIAL_WEEKDAY },
	{ "weekdays",    TIMELIB_SPECIAL, TIMELIB_SPECIAL_WEEKDAY },
	{ NULL,          0,          0 }
};

/* The relative text table. */
static timelib_lookup_table const timelib_reltext_lookup[] = {
	{ "first",    0,  1 },
	{ "next",     0,  1 },
	{ "second",   0,  2 },
	{ "third",    0,  3 },
	{ "fourth",   0,  4 },
	{ "fifth",    0,  5 },
	{ "sixth",    0,  6 },
	{ "seventh",  0,  7 },
	{ "eight",    0,  8 },
	{ "eighth",   0,  8 },
	{ "ninth",    0,  9 },
	{ "tenth",    0, 10 },
	{ "eleventh", 0, 11 },
	{ "twelfth",  0, 12 },
	{ "last",     0, -1 },
	{ "previous", 0, -1 },
	{ "this",     1,  0 },
	{ NULL,       1,  0 }
};

/* The month table. */
static timelib_lookup_table const timelib_month_lookup[] = {
	{ "jan",  0,  1 },
	{ "feb",  0,  2 },
	{ "mar",  0,  3 },
	{ "apr",  0,  4 },
	{ "may",  0,  5 },
	{ "jun",  0,  6 },
	{ "jul",  0,  7 },
	{ "aug",  0,  8 },
	{ "sep",  0,  9 },
	{ "sept", 0,  9 },
	{ "oct",  0, 10 },
	{ "nov",  0, 11 },
	{ "dec",  0, 12 },
	{ "i",    0,  1 },
	{ "ii",   0,  2 },
	{ "iii",  0,  3 },
	{ "iv",   0,  4 },
	{ "v",    0,  5 },
	{ "vi",   0,  6 },
	{ "vii",  0,  7 },
	{ "viii", 0,  8 },
	{ "ix",   0,  9 },
	{ "x",    0, 10 },
	{ "xi",   0, 11 },
	{ "xii",  0, 12 },

	{ "january",   0,  1 },
	{ "february",  0,  2 },
	{ "march",     0,  3 },
	{ "april",     0,  4 },
	{ "may",       0,  5 },
	{ "june",      0,  6 },
	{ "july",      0,  7 },
	{ "august",    0,  8 },
	{ "september", 0,  9 },
	{ "october",   0, 10 },
	{ "november",  0, 11 },
	{ "december",  0, 12 },
	{  NULL,       0,  0 }
};

#if 0
static char* timelib_ltrim(char *s)
{
	char *ptr = s;
	while (ptr[0] == ' ' || ptr[0] == '\t') {
		ptr++;
	}
	return ptr;
}
#endif

#if 0
uchar *fill(Scanner *s, uchar *cursor){
	if(!s->eof){
		unsigned int cnt = s->tok - s->bot;
		if(cnt){
			memcpy(s->bot, s->tok, s->lim - s->tok);
			s->tok = s->bot;
			s->ptr -= cnt;
			cursor -= cnt;
			s->pos -= cnt;
			s->lim -= cnt;
		}
		if((s->top - s->lim) < BSIZE){
			uchar *buf = (uchar*) malloc(((s->lim - s->bot) + BSIZE)*sizeof(uchar));
			memcpy(buf, s->tok, s->lim - s->tok);
			s->tok = buf;
			s->ptr = &buf[s->ptr - s->bot];
			cursor = &buf[cursor - s->bot];
			s->pos = &buf[s->pos - s->bot];
			s->lim = &buf[s->lim - s->bot];
			s->top = &s->lim[BSIZE];
			free(s->bot);
			s->bot = buf;
		}
		if((cnt = read(s->fd, (char*) s->lim, BSIZE)) != BSIZE){
			s->eof = &s->lim[cnt]; *(s->eof)++ = '\n';
		}
		s->lim += cnt;
	}
	return cursor;
}
#endif

static void add_warning(Scanner *s, char *error)
{
	s->errors->warning_count++;
	s->errors->warning_messages = realloc(s->errors->warning_messages, s->errors->warning_count * sizeof(timelib_error_message));
	s->errors->warning_messages[s->errors->warning_count - 1].position = s->tok ? s->tok - s->str : 0;
	s->errors->warning_messages[s->errors->warning_count - 1].character = s->tok ? *s->tok : 0;
	s->errors->warning_messages[s->errors->warning_count - 1].message = strdup(error);
}

static void add_error(Scanner *s, char *error)
{
	s->errors->error_count++;
	s->errors->error_messages = realloc(s->errors->error_messages, s->errors->error_count * sizeof(timelib_error_message));
	s->errors->error_messages[s->errors->error_count - 1].position = s->tok ? s->tok - s->str : 0;
	s->errors->error_messages[s->errors->error_count - 1].character = s->tok ? *s->tok : 0;
	s->errors->error_messages[s->errors->error_count - 1].message = strdup(error);
}

static timelib_sll timelib_meridian(char **ptr, timelib_sll h)
{
	timelib_sll retval = 0;

	while (!strchr("AaPp", **ptr)) {
		++*ptr;
	}
	if (**ptr == 'a' || **ptr == 'A') {
		if (h == 12) {
			retval = -12;
		}
	} else if (h != 12) {
		retval = 12;
	}
	++*ptr;
	if (**ptr == '.') {
		*ptr += 3;
	} else {
		++*ptr;
	}
	return retval;
}

static char *timelib_string(Scanner *s)
{
	char *tmp = calloc(1, s->cur - s->tok + 1);
	memcpy(tmp, s->tok, s->cur - s->tok);

	return tmp;
}

static timelib_sll timelib_get_nr(char **ptr, int max_length)
{
	char *begin, *end, *str;
	timelib_sll tmp_nr = TIMELIB_UNSET;
	int len = 0;

	while ((**ptr < '0') || (**ptr > '9')) {
		if (**ptr == '\0') {
			return TIMELIB_UNSET;
		}
		++*ptr;
	}
	begin = *ptr;
	while ((**ptr >= '0') && (**ptr <= '9') && len < max_length) {
		++*ptr;
		++len;
	}
	end = *ptr;
	str = calloc(1, end - begin + 1);
	memcpy(str, begin, end - begin);
	tmp_nr = strtoll(str, NULL, 10);
	free(str);
	return tmp_nr;
}

static void timelib_skip_day_suffix(char **ptr)
{
	if (isspace(**ptr)) {
		return;
	}
	if (!strncasecmp(*ptr, "nd", 2) || !strncasecmp(*ptr, "rd", 2) ||!strncasecmp(*ptr, "st", 2) || !strncasecmp(*ptr, "th", 2)) {
		*ptr += 2;
	}
}

static double timelib_get_frac_nr(char **ptr, int max_length)
{
	char *begin, *end, *str;
	double tmp_nr = TIMELIB_UNSET;
	int len = 0;

	while ((**ptr != '.') && ((**ptr < '0') || (**ptr > '9'))) {
		if (**ptr == '\0') {
			return TIMELIB_UNSET;
		}
		++*ptr;
	}
	begin = *ptr;
	while (((**ptr == '.') || ((**ptr >= '0') && (**ptr <= '9'))) && len < max_length) {
		++*ptr;
		++len;
	}
	end = *ptr;
	str = calloc(1, end - begin + 1);
	memcpy(str, begin, end - begin);
	tmp_nr = strtod(str, NULL);
	free(str);
	return tmp_nr;
}

static timelib_ull timelib_get_unsigned_nr(char **ptr, int max_length)
{
	timelib_ull dir = 1;

	while (((**ptr < '0') || (**ptr > '9')) && (**ptr != '+') && (**ptr != '-')) {
		if (**ptr == '\0') {
			return TIMELIB_UNSET;
		}
		++*ptr;
	}

	while (**ptr == '+' || **ptr == '-')
	{
		if (**ptr == '-') {
			dir *= -1;
		}
		++*ptr;
	}
	return dir * timelib_get_nr(ptr, max_length);
}

static long timelib_parse_tz_cor(char **ptr)
{
	char *begin = *ptr, *end;
	long  tmp;

	while (isdigit(**ptr) || **ptr == ':') {
		++*ptr;
	}
	end = *ptr;
	switch (end - begin) {
		case 1:
		case 2:
			return HOUR(strtol(begin, NULL, 10));
			break;
		case 3:
		case 4:
			if (begin[1] == ':') {
				tmp = HOUR(strtol(begin, NULL, 10)) + strtol(begin + 2, NULL, 10);
				return tmp;
			} else if (begin[2] == ':') {
				tmp = HOUR(strtol(begin, NULL, 10)) + strtol(begin + 3, NULL, 10);
				return tmp;
			} else {
				tmp = strtol(begin, NULL, 10);
				return HOUR(tmp / 100) + tmp % 100;
			}
		case 5:
			tmp = HOUR(strtol(begin, NULL, 10)) + strtol(begin + 3, NULL, 10);
			return tmp;
	}
	return 0;
}

static timelib_sll timelib_lookup_relative_text(char **ptr, int *behavior)
{
	char *word;
	char *begin = *ptr, *end;
	timelib_sll  value = 0;
	const timelib_lookup_table *tp;

	while ((**ptr >= 'A' && **ptr <= 'Z') || (**ptr >= 'a' && **ptr <= 'z')) {
		++*ptr;
	}
	end = *ptr;
	word = calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_reltext_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			value = tp->value;
			*behavior = tp->type;
		}
	}

	free(word);
	return value;
}

static timelib_sll timelib_get_relative_text(char **ptr, int *behavior)
{
	while (**ptr == ' ' || **ptr == '\t' || **ptr == '-' || **ptr == '/') {
		++*ptr;
	}
	return timelib_lookup_relative_text(ptr, behavior);
}

static long timelib_lookup_month(char **ptr)
{
	char *word;
	char *begin = *ptr, *end;
	long  value = 0;
	const timelib_lookup_table *tp;

	while ((**ptr >= 'A' && **ptr <= 'Z') || (**ptr >= 'a' && **ptr <= 'z')) {
		++*ptr;
	}
	end = *ptr;
	word = calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_month_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			value = tp->value;
		}
	}

	free(word);
	return value;
}

static long timelib_get_month(char **ptr)
{
	while (**ptr == ' ' || **ptr == '\t' || **ptr == '-' || **ptr == '.' || **ptr == '/') {
		++*ptr;
	}
	return timelib_lookup_month(ptr);
}

static void timelib_eat_spaces(char **ptr)
{
	while (**ptr == ' ' || **ptr == '\t') {
		++*ptr;
	}
}

static const timelib_relunit* timelib_lookup_relunit(char **ptr)
{
	char *word;
	char *begin = *ptr, *end;
	const timelib_relunit *tp, *value = NULL;

	while (**ptr != '\0' && **ptr != ' ' && **ptr != '\t') {
		++*ptr;
	}
	end = *ptr;
	word = calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_relunit_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			value = tp;
			break;
		}
	}

	free(word);
	return value;
}

static void timelib_set_relative(char **ptr, timelib_sll amount, int behavior, Scanner *s)
{
	const timelib_relunit* relunit;

	if (!(relunit = timelib_lookup_relunit(ptr))) {
		return;
	}

	switch (relunit->unit) {
		case TIMELIB_SECOND: s->time->relative.s += amount * relunit->multiplier; break;
		case TIMELIB_MINUTE: s->time->relative.i += amount * relunit->multiplier; break;
		case TIMELIB_HOUR:   s->time->relative.h += amount * relunit->multiplier; break;
		case TIMELIB_DAY:    s->time->relative.d += amount * relunit->multiplier; break;
		case TIMELIB_MONTH:  s->time->relative.m += amount * relunit->multiplier; break;
		case TIMELIB_YEAR:   s->time->relative.y += amount * relunit->multiplier; break;

		case TIMELIB_WEEKDAY:
			TIMELIB_HAVE_WEEKDAY_RELATIVE();
			TIMELIB_UNHAVE_TIME();
			s->time->relative.d += (amount > 0 ? amount - 1 : amount) * 7;
			s->time->relative.weekday = relunit->multiplier;
			s->time->relative.weekday_behavior = behavior;
			break;

		case TIMELIB_SPECIAL:
			TIMELIB_HAVE_SPECIAL_RELATIVE();
			TIMELIB_UNHAVE_TIME();
			s->time->special.type = relunit->multiplier;
			s->time->special.amount = amount;
	}
}

const static timelib_tz_lookup_table* zone_search(const char *word, long gmtoffset, int isdst)
{
	int first_found = 0;
	const timelib_tz_lookup_table  *tp, *first_found_elem = NULL;
	const timelib_tz_lookup_table  *fmp;

	if (strcasecmp("utc", word) == 0 || strcasecmp("gmt", word) == 0) {
		return timelib_timezone_utc;
	}
	
	for (tp = timelib_timezone_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			if (!first_found) {
				first_found = 1;
				first_found_elem = tp;
				if (gmtoffset == -1) {
					return tp;
				}
			}
			if (tp->gmtoffset == gmtoffset) {
				return tp;
			}
		}
	}
	if (first_found) {
		return first_found_elem;
	}

	/* Still didn't find anything, let's find the zone solely based on
	 * offset/isdst then */
	for (fmp = timelib_timezone_fallbackmap; fmp->name; fmp++) {
		if ((fmp->gmtoffset * 3600) == gmtoffset && fmp->type == isdst) {
			return fmp;
		}
	}
	return NULL;
}

static long timelib_lookup_zone(char **ptr, int *dst, char **tz_abbr, int *found)
{
	char *word;
	char *begin = *ptr, *end;
	long  value = 0;
	const timelib_tz_lookup_table *tp;

	while (**ptr != '\0' && **ptr != ')' && **ptr != ' ') {
		++*ptr;
	}
	end = *ptr;
	word = calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	if ((tp = zone_search(word, -1, 0))) {
		value = -tp->gmtoffset / 60;
		*dst = tp->type;
		value += tp->type * 60;
		*found = 1;
	} else {
		*found = 0;
	}

	*tz_abbr = word;
	return value;
}

static long timelib_get_zone(char **ptr, int *dst, timelib_time *t, int *tz_not_found, const timelib_tzdb *tzdb, timelib_tz_get_wrapper tz_wrapper)
{
	timelib_tzinfo *res;
	long            retval = 0;

	*tz_not_found = 0;

	while (**ptr == ' ' || **ptr == '\t' || **ptr == '(') {
		++*ptr;
	}
	if (**ptr == '+') {
		++*ptr;
		t->is_localtime = 1;
		t->zone_type = TIMELIB_ZONETYPE_OFFSET;
		*tz_not_found = 0;
		t->dst = 0;

		retval = -1 * timelib_parse_tz_cor(ptr);
	} else if (**ptr == '-') {
		++*ptr;
		t->is_localtime = 1;
		t->zone_type = TIMELIB_ZONETYPE_OFFSET;
		*tz_not_found = 0;
		t->dst = 0;

		retval = timelib_parse_tz_cor(ptr);
	} else {
		int found = 0;
		long offset;
		char *tz_abbr;

		t->is_localtime = 1;

		offset = timelib_lookup_zone(ptr, dst, &tz_abbr, &found);
		if (found) {
			t->zone_type = TIMELIB_ZONETYPE_ABBR;
		}
#if 0
		/* If we found a TimeZone identifier, use it */
		if (tz_name) {
			t->tz_info = timelib_parse_tzfile(tz_name);
			t->zone_type = TIMELIB_ZONETYPE_ID;
		}
#endif
		/* If we have a TimeZone identifier to start with, use it */
		if (strstr(tz_abbr, "/") || strcmp(tz_abbr, "UTC") == 0) {
			if ((res = tz_wrapper(tz_abbr, tzdb)) != NULL) {
				t->tz_info = res;
				t->zone_type = TIMELIB_ZONETYPE_ID;
				found++;
			}
		}
		if (found && t->zone_type != TIMELIB_ZONETYPE_ID) {
			timelib_time_tz_abbr_update(t, tz_abbr);
		}
		free(tz_abbr);
		*tz_not_found = (found == 0);
		retval = offset;
	}
	while (**ptr == ')') {
		++*ptr;
	}
	return retval;
}

#define timelib_split_free(arg) {       \
	int i;                         \
	for (i = 0; i < arg.c; i++) {  \
		free(arg.v[i]);            \
	}                              \
	if (arg.v) {                   \
		free(arg.v);               \
	}                              \
}

static int scan(Scanner *s, timelib_tz_get_wrapper tz_get_wrapper)
{
	uchar *cursor = s->cur;
	char *str, *ptr = NULL;
		
std:
	s->tok = cursor;
	s->len = 0;



{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	static const unsigned char yybm[] = {
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0, 100,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		100,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0, 128,  64, 160,  96,   0, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   0,   0,   0,   0,   0,   0, 
		  0,   8,   8,   8,   8,   8,   8,   8, 
		  8,   8,   8,   8,   8,   8,   8,   8, 
		  8,   8,   8,   8,   8,   8,   8,   8, 
		  8,   8,   8,   0,   0,   0,   0,   0, 
		  0,  24,  24,  24,  88,  24,  24,  24, 
		 88,  24,  24,  24,  24,  24,  88,  24, 
		 24,  24,  88,  88,  88,  24,  24,  24, 
		 24,  24,  24,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
	};

	YYDEBUG(0, *YYCURSOR);
	if ((YYLIMIT - YYCURSOR) < 30) YYFILL(30);
	yych = *YYCURSOR;
	YYDEBUG(-1, yych);
	switch (yych) {
	case 0x00:
	case '\n':	goto yy48;
	case '\t':
	case ' ':	goto yy45;
	case '(':	goto yy42;
	case '+':
	case '-':	goto yy18;
	case ',':
	case '.':	goto yy47;
	case '0':	goto yy13;
	case '1':	goto yy14;
	case '2':	goto yy15;
	case '3':	goto yy16;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy17;
	case '@':	goto yy11;
	case 'A':	goto yy26;
	case 'B':
	case 'C':
	case 'G':
	case 'H':
	case 'K':
	case 'Q':
	case 'R':
	case 'U':
	case 'Z':	goto yy43;
	case 'D':	goto yy32;
	case 'E':	goto yy36;
	case 'F':	goto yy24;
	case 'I':	goto yy19;
	case 'J':	goto yy22;
	case 'L':	goto yy38;
	case 'M':	goto yy7;
	case 'N':	goto yy5;
	case 'O':	goto yy30;
	case 'P':	goto yy40;
	case 'S':	goto yy28;
	case 'T':	goto yy9;
	case 'V':	goto yy20;
	case 'W':	goto yy34;
	case 'X':	goto yy21;
	case 'Y':	goto yy2;
	case 'a':	goto yy27;
	case 'b':
	case 'c':
	case 'g':
	case 'h':
	case 'i':
	case 'k':
	case 'q':
	case 'r':
	case 'u':
	case 'v':
	case 'x':
	case 'z':	goto yy44;
	case 'd':	goto yy33;
	case 'e':	goto yy37;
	case 'f':	goto yy25;
	case 'j':	goto yy23;
	case 'l':	goto yy39;
	case 'm':	goto yy8;
	case 'n':	goto yy6;
	case 'o':	goto yy31;
	case 'p':	goto yy41;
	case 's':	goto yy29;
	case 't':	goto yy10;
	case 'w':	goto yy35;
	case 'y':	goto yy4;
	default:	goto yy50;
	}
yy2:
	YYDEBUG(2, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= 'E') {
		if (yych <= ')') {
			if (yych >= ')') goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy137;
			goto yy1417;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy137;
			if (yych >= 'a') goto yy142;
		} else {
			if (yych <= 'e') goto yy1426;
			if (yych <= 'z') goto yy142;
		}
	}
yy3:
	YYDEBUG(3, *YYCURSOR);
	{
		int tz_not_found;
		DEBUG_OUTPUT("tzcorrection | tz");
		TIMELIB_INIT;
		TIMELIB_HAVE_TZ();
		s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
if (tz_not_found) {
			add_error(s, "The timezone could not be found in the database");
		}
		TIMELIB_DEINIT;
		return TIMELIB_TIMEZONE;
	}
yy4:
	YYDEBUG(4, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy137;
			goto yy1417;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy137;
			if (yych <= '`') goto yy3;
			goto yy137;
		} else {
			if (yych <= 'e') goto yy1417;
			if (yych <= 'z') goto yy137;
			goto yy3;
		}
	}
yy5:
	YYDEBUG(5, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'D') {
			if (yych == ')') goto yy136;
			if (yych <= '@') goto yy3;
			goto yy137;
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy1388;
				goto yy137;
			} else {
				if (yych <= 'I') goto yy1389;
				if (yych <= 'N') goto yy137;
				goto yy1387;
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy137;
				goto yy3;
			} else {
				if (yych == 'e') goto yy1404;
				goto yy142;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy1405;
				goto yy142;
			} else {
				if (yych <= 'o') goto yy1403;
				if (yych <= 'z') goto yy142;
				goto yy3;
			}
		}
	}
yy6:
	YYDEBUG(6, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'D') {
			if (yych == ')') goto yy136;
			if (yych <= '@') goto yy3;
			goto yy137;
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy1388;
				goto yy137;
			} else {
				if (yych <= 'I') goto yy1389;
				if (yych <= 'N') goto yy137;
				goto yy1387;
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy137;
				goto yy3;
			} else {
				if (yych == 'e') goto yy1388;
				goto yy137;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy1389;
				goto yy137;
			} else {
				if (yych <= 'o') goto yy1387;
				if (yych <= 'z') goto yy137;
				goto yy3;
			}
		}
	}
yy7:
	YYDEBUG(7, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'A') {
			if (yych == ')') goto yy136;
			if (yych <= '@') goto yy3;
			goto yy1357;
		} else {
			if (yych == 'I') goto yy1358;
			if (yych <= 'N') goto yy137;
			goto yy1359;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy137;
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1372;
			goto yy142;
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy1373;
				goto yy142;
			} else {
				if (yych <= 'o') goto yy1374;
				if (yych <= 'z') goto yy142;
				goto yy3;
			}
		}
	}
yy8:
	YYDEBUG(8, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'A') {
			if (yych == ')') goto yy136;
			if (yych <= '@') goto yy3;
			goto yy1357;
		} else {
			if (yych == 'I') goto yy1358;
			if (yych <= 'N') goto yy137;
			goto yy1359;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy137;
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1357;
			goto yy137;
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy1358;
				goto yy137;
			} else {
				if (yych <= 'o') goto yy1359;
				if (yych <= 'z') goto yy137;
				goto yy3;
			}
		}
	}
yy9:
	YYDEBUG(9, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch (yych) {
	case ')':	goto yy136;
	case '0':
	case '1':	goto yy1289;
	case '2':	goto yy1290;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1291;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'X':
	case 'Y':
	case 'Z':	goto yy137;
	case 'E':	goto yy1284;
	case 'H':	goto yy1285;
	case 'O':	goto yy1286;
	case 'U':	goto yy1287;
	case 'W':	goto yy1288;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'x':
	case 'y':
	case 'z':	goto yy142;
	case 'e':	goto yy1326;
	case 'h':	goto yy1327;
	case 'o':	goto yy1328;
	case 'u':	goto yy1329;
	case 'w':	goto yy1330;
	default:	goto yy3;
	}
yy10:
	YYDEBUG(10, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch (yych) {
	case ')':	goto yy136;
	case '0':
	case '1':	goto yy1289;
	case '2':	goto yy1290;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1291;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'x':
	case 'y':
	case 'z':	goto yy137;
	case 'E':
	case 'e':	goto yy1284;
	case 'H':
	case 'h':	goto yy1285;
	case 'O':
	case 'o':	goto yy1286;
	case 'U':
	case 'u':	goto yy1287;
	case 'W':
	case 'w':	goto yy1288;
	default:	goto yy3;
	}
yy11:
	YYDEBUG(11, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy1280;
	if (yych <= '/') goto yy12;
	if (yych <= '9') goto yy1281;
yy12:
	YYDEBUG(12, *YYCURSOR);
	{
		add_error(s, "Unexpected character");
		goto std;
	}
yy13:
	YYDEBUG(13, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch (yych) {
	case '\t':	goto yy1234;
	case ' ':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'o':
	case 'w':
	case 'y':	goto yy1236;
	case '-':	goto yy678;
	case '.':	goto yy1246;
	case '/':	goto yy677;
	case '0':	goto yy1279;
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1278;
	case ':':	goto yy1247;
	case 'n':	goto yy675;
	case 'r':	goto yy676;
	case 's':	goto yy669;
	case 't':	goto yy673;
	default:	goto yy12;
	}
yy14:
	YYDEBUG(14, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch (yych) {
	case '\t':	goto yy665;
	case ' ':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'o':
	case 'p':
	case 'w':
	case 'y':	goto yy667;
	case '-':	goto yy678;
	case '.':	goto yy679;
	case '/':	goto yy677;
	case '0':
	case '1':
	case '2':	goto yy1278;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1245;
	case ':':	goto yy688;
	case 'n':	goto yy675;
	case 'r':	goto yy676;
	case 's':	goto yy669;
	case 't':	goto yy673;
	default:	goto yy12;
	}
yy15:
	YYDEBUG(15, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch (yych) {
	case '\t':	goto yy665;
	case ' ':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'o':
	case 'p':
	case 'w':
	case 'y':	goto yy667;
	case '-':	goto yy678;
	case '.':	goto yy679;
	case '/':	goto yy677;
	case '0':
	case '1':
	case '2':
	case '3':	goto yy1245;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1232;
	case ':':	goto yy688;
	case 'n':	goto yy675;
	case 'r':	goto yy676;
	case 's':	goto yy669;
	case 't':	goto yy673;
	default:	goto yy12;
	}
yy16:
	YYDEBUG(16, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch (yych) {
	case '\t':	goto yy665;
	case ' ':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'o':
	case 'p':
	case 'w':
	case 'y':	goto yy667;
	case '-':	goto yy678;
	case '.':	goto yy679;
	case '/':	goto yy677;
	case '0':
	case '1':	goto yy1232;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy674;
	case ':':	goto yy688;
	case 'n':	goto yy675;
	case 'r':	goto yy676;
	case 's':	goto yy669;
	case 't':	goto yy673;
	default:	goto yy12;
	}
yy17:
	YYDEBUG(17, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch (yych) {
	case '\t':	goto yy665;
	case ' ':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'o':
	case 'p':
	case 'w':
	case 'y':	goto yy667;
	case '-':	goto yy678;
	case '.':	goto yy679;
	case '/':	goto yy677;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy674;
	case ':':	goto yy688;
	case 'n':	goto yy675;
	case 'r':	goto yy676;
	case 's':	goto yy669;
	case 't':	goto yy673;
	default:	goto yy12;
	}
yy18:
	YYDEBUG(18, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 4) {
		goto yy54;
	}
	YYDEBUG(-1, yych);
	switch (yych) {
	case '+':
	case '-':	goto yy643;
	case '0':
	case '1':	goto yy640;
	case '2':	goto yy641;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy642;
	default:	goto yy12;
	}
yy19:
	YYDEBUG(19, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy3;
				goto yy306;
			} else {
				if (yych == ' ') goto yy306;
				goto yy3;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy136;
				goto yy3;
			} else {
				if (yych == '/') goto yy3;
				goto yy306;
			}
		}
	} else {
		if (yych <= 'V') {
			if (yych <= 'H') {
				if (yych <= '@') goto yy3;
				goto yy137;
			} else {
				if (yych <= 'I') goto yy639;
				if (yych <= 'U') goto yy137;
				goto yy638;
			}
		} else {
			if (yych <= 'Z') {
				if (yych == 'X') goto yy638;
				goto yy137;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy142;
				goto yy3;
			}
		}
	}
yy20:
	YYDEBUG(20, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy306;
			if (yych <= 0x1F) goto yy3;
			goto yy306;
		} else {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy306;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy3;
			if (yych <= '9') goto yy306;
			if (yych <= '@') goto yy3;
			goto yy137;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'I') goto yy635;
				goto yy137;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy142;
				goto yy3;
			}
		}
	}
yy21:
	YYDEBUG(21, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy306;
			if (yych <= 0x1F) goto yy3;
			goto yy306;
		} else {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy306;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy3;
			if (yych <= '9') goto yy306;
			if (yych <= '@') goto yy3;
			goto yy137;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'I') goto yy633;
				goto yy137;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy142;
				goto yy3;
			}
		}
	}
yy22:
	YYDEBUG(22, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= '@') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= 'A') goto yy616;
			if (yych <= 'T') goto yy137;
			goto yy615;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy137;
			if (yych <= '`') goto yy3;
			goto yy625;
		} else {
			if (yych == 'u') goto yy624;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy23:
	YYDEBUG(23, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= '@') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= 'A') goto yy616;
			if (yych <= 'T') goto yy137;
			goto yy615;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy137;
			if (yych <= '`') goto yy3;
			goto yy616;
		} else {
			if (yych == 'u') goto yy615;
			if (yych <= 'z') goto yy137;
			goto yy3;
		}
	}
yy24:
	YYDEBUG(24, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'E') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy136;
			} else {
				if (yych <= '@') goto yy3;
				if (yych <= 'D') goto yy137;
				goto yy577;
			}
		} else {
			if (yych <= 'N') {
				if (yych == 'I') goto yy578;
				goto yy137;
			} else {
				if (yych <= 'O') goto yy579;
				if (yych <= 'Q') goto yy137;
				goto yy580;
			}
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'd') {
				if (yych <= 'Z') goto yy137;
				if (yych <= '`') goto yy3;
				goto yy142;
			} else {
				if (yych <= 'e') goto yy596;
				if (yych <= 'h') goto yy142;
				goto yy597;
			}
		} else {
			if (yych <= 'q') {
				if (yych == 'o') goto yy598;
				goto yy142;
			} else {
				if (yych <= 'r') goto yy599;
				if (yych <= 'z') goto yy142;
				goto yy3;
			}
		}
	}
yy25:
	YYDEBUG(25, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'E') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy136;
			} else {
				if (yych <= '@') goto yy3;
				if (yych <= 'D') goto yy137;
				goto yy577;
			}
		} else {
			if (yych <= 'N') {
				if (yych == 'I') goto yy578;
				goto yy137;
			} else {
				if (yych <= 'O') goto yy579;
				if (yych <= 'Q') goto yy137;
				goto yy580;
			}
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'd') {
				if (yych <= 'Z') goto yy137;
				if (yych <= '`') goto yy3;
				goto yy137;
			} else {
				if (yych <= 'e') goto yy577;
				if (yych <= 'h') goto yy137;
				goto yy578;
			}
		} else {
			if (yych <= 'q') {
				if (yych == 'o') goto yy579;
				goto yy137;
			} else {
				if (yych <= 'r') goto yy580;
				if (yych <= 'z') goto yy137;
				goto yy3;
			}
		}
	}
yy26:
	YYDEBUG(26, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'F') {
			if (yych == ')') goto yy136;
			if (yych <= '@') goto yy3;
			goto yy137;
		} else {
			if (yych <= 'O') {
				if (yych <= 'G') goto yy556;
				goto yy137;
			} else {
				if (yych <= 'P') goto yy555;
				if (yych <= 'T') goto yy137;
				goto yy554;
			}
		}
	} else {
		if (yych <= 'o') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy137;
				goto yy3;
			} else {
				if (yych == 'g') goto yy568;
				goto yy142;
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'p') goto yy567;
				goto yy142;
			} else {
				if (yych <= 'u') goto yy566;
				if (yych <= 'z') goto yy142;
				goto yy3;
			}
		}
	}
yy27:
	YYDEBUG(27, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'F') {
			if (yych == ')') goto yy136;
			if (yych <= '@') goto yy3;
			goto yy137;
		} else {
			if (yych <= 'O') {
				if (yych <= 'G') goto yy556;
				goto yy137;
			} else {
				if (yych <= 'P') goto yy555;
				if (yych <= 'T') goto yy137;
				goto yy554;
			}
		}
	} else {
		if (yych <= 'o') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy137;
				goto yy3;
			} else {
				if (yych == 'g') goto yy556;
				goto yy137;
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'p') goto yy555;
				goto yy137;
			} else {
				if (yych <= 'u') goto yy554;
				if (yych <= 'z') goto yy137;
				goto yy3;
			}
		}
	}
yy28:
	YYDEBUG(28, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy136;
			} else {
				if (yych <= '@') goto yy3;
				if (yych <= 'A') goto yy497;
				goto yy137;
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy496;
				goto yy137;
			} else {
				if (yych <= 'I') goto yy498;
				if (yych <= 'T') goto yy137;
				goto yy499;
			}
		}
	} else {
		if (yych <= 'e') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy137;
				goto yy3;
			} else {
				if (yych <= 'a') goto yy526;
				if (yych <= 'd') goto yy142;
				goto yy525;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'i') goto yy527;
				goto yy142;
			} else {
				if (yych <= 'u') goto yy528;
				if (yych <= 'z') goto yy142;
				goto yy3;
			}
		}
	}
yy29:
	YYDEBUG(29, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy136;
			} else {
				if (yych <= '@') goto yy3;
				if (yych <= 'A') goto yy497;
				goto yy137;
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy496;
				goto yy137;
			} else {
				if (yych <= 'I') goto yy498;
				if (yych <= 'T') goto yy137;
				goto yy499;
			}
		}
	} else {
		if (yych <= 'e') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy137;
				goto yy3;
			} else {
				if (yych <= 'a') goto yy497;
				if (yych <= 'd') goto yy137;
				goto yy496;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'i') goto yy498;
				goto yy137;
			} else {
				if (yych <= 'u') goto yy499;
				if (yych <= 'z') goto yy137;
				goto yy3;
			}
		}
	}
yy30:
	YYDEBUG(30, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'C') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'B') goto yy137;
			goto yy486;
		}
	} else {
		if (yych <= 'b') {
			if (yych <= 'Z') goto yy137;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 'c') goto yy491;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy31:
	YYDEBUG(31, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'C') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'B') goto yy137;
			goto yy486;
		}
	} else {
		if (yych <= 'b') {
			if (yych <= 'Z') goto yy137;
			if (yych <= '`') goto yy3;
			goto yy137;
		} else {
			if (yych <= 'c') goto yy486;
			if (yych <= 'z') goto yy137;
			goto yy3;
		}
	}
yy32:
	YYDEBUG(32, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy137;
			goto yy302;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy137;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 'e') goto yy477;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy33:
	YYDEBUG(33, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy137;
			goto yy302;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy137;
			if (yych <= '`') goto yy3;
			goto yy137;
		} else {
			if (yych <= 'e') goto yy302;
			if (yych <= 'z') goto yy137;
			goto yy3;
		}
	}
yy34:
	YYDEBUG(34, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy137;
			goto yy275;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy137;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 'e') goto yy289;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy35:
	YYDEBUG(35, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy137;
			goto yy275;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy137;
			if (yych <= '`') goto yy3;
			goto yy137;
		} else {
			if (yych <= 'e') goto yy275;
			if (yych <= 'z') goto yy137;
			goto yy3;
		}
	}
yy36:
	YYDEBUG(36, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= '@') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych == 'I') goto yy253;
			if (yych <= 'K') goto yy137;
			goto yy254;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy137;
			if (yych <= '`') goto yy3;
			if (yych <= 'h') goto yy142;
			goto yy264;
		} else {
			if (yych == 'l') goto yy265;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy37:
	YYDEBUG(37, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= '@') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych == 'I') goto yy253;
			if (yych <= 'K') goto yy137;
			goto yy254;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy137;
			if (yych <= '`') goto yy3;
			if (yych <= 'h') goto yy137;
			goto yy253;
		} else {
			if (yych == 'l') goto yy254;
			if (yych <= 'z') goto yy137;
			goto yy3;
		}
	}
yy38:
	YYDEBUG(38, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy136;
		if (yych <= '@') goto yy3;
		goto yy247;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy137;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy250;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy39:
	YYDEBUG(39, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy136;
		if (yych <= '@') goto yy3;
		goto yy247;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy137;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy247;
			if (yych <= 'z') goto yy137;
			goto yy3;
		}
	}
yy40:
	YYDEBUG(40, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy137;
			goto yy153;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy137;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 'r') goto yy240;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy41:
	YYDEBUG(41, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy137;
			goto yy153;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy137;
			if (yych <= '`') goto yy3;
			goto yy137;
		} else {
			if (yych <= 'r') goto yy153;
			if (yych <= 'z') goto yy137;
			goto yy3;
		}
	}
yy42:
	YYDEBUG(42, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') goto yy12;
	if (yych <= 'Z') goto yy152;
	if (yych <= '`') goto yy12;
	if (yych <= 'z') goto yy152;
	goto yy12;
yy43:
	YYDEBUG(43, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy136;
		goto yy3;
	} else {
		if (yych <= 'Z') goto yy137;
		if (yych <= '`') goto yy3;
		if (yych <= 'z') goto yy142;
		goto yy3;
	}
yy44:
	YYDEBUG(44, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy136;
		goto yy3;
	} else {
		if (yych <= 'Z') goto yy137;
		if (yych <= '`') goto yy3;
		if (yych <= 'z') goto yy137;
		goto yy3;
	}
yy45:
	YYDEBUG(45, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 4) {
		goto yy54;
	}
	if (yych <= '/') goto yy46;
	if (yych <= '9') goto yy51;
yy46:
	YYDEBUG(46, *YYCURSOR);
	{
		goto std;
	}
yy47:
	YYDEBUG(47, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy46;
yy48:
	YYDEBUG(48, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(49, *YYCURSOR);
	{
		s->pos = cursor; s->line++;
		goto std;
	}
yy50:
	YYDEBUG(50, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy12;
yy51:
	YYDEBUG(51, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
	yych = *YYCURSOR;
	YYDEBUG(52, *YYCURSOR);
	if (yybm[0+yych] & 2) {
		goto yy51;
	}
	if (yych <= 'W') {
		if (yych <= 'F') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy56;
				if (yych >= ' ') goto yy56;
			} else {
				if (yych == 'D') goto yy61;
				if (yych >= 'F') goto yy63;
			}
		} else {
			if (yych <= 'M') {
				if (yych == 'H') goto yy60;
				if (yych >= 'M') goto yy59;
			} else {
				if (yych <= 'S') {
					if (yych >= 'S') goto yy58;
				} else {
					if (yych <= 'T') goto yy65;
					if (yych >= 'W') goto yy62;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy64;
				if (yych >= 'd') goto yy61;
			} else {
				if (yych <= 'f') {
					if (yych >= 'f') goto yy63;
				} else {
					if (yych == 'h') goto yy60;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'm') goto yy59;
				if (yych <= 'r') goto yy53;
				if (yych <= 's') goto yy58;
				goto yy65;
			} else {
				if (yych <= 'w') {
					if (yych >= 'w') goto yy62;
				} else {
					if (yych == 'y') goto yy64;
				}
			}
		}
	}
yy53:
	YYDEBUG(53, *YYCURSOR);
	YYCURSOR = YYMARKER;
	if (yyaccept <= 15) {
		if (yyaccept <= 7) {
			if (yyaccept <= 3) {
				if (yyaccept <= 1) {
					if (yyaccept <= 0) {
						goto yy3;
					} else {
						goto yy12;
					}
				} else {
					if (yyaccept <= 2) {
						goto yy46;
					} else {
						goto yy69;
					}
				}
			} else {
				if (yyaccept <= 5) {
					if (yyaccept <= 4) {
						goto yy173;
					} else {
						goto yy277;
					}
				} else {
					if (yyaccept <= 6) {
						goto yy304;
					} else {
						goto yy309;
					}
				}
			}
		} else {
			if (yyaccept <= 11) {
				if (yyaccept <= 9) {
					if (yyaccept <= 8) {
						goto yy333;
					} else {
						goto yy402;
					}
				} else {
					if (yyaccept <= 10) {
						goto yy558;
					} else {
						goto yy681;
					}
				}
			} else {
				if (yyaccept <= 13) {
					if (yyaccept <= 12) {
						goto yy696;
					} else {
						goto yy801;
					}
				} else {
					if (yyaccept <= 14) {
						goto yy845;
					} else {
						goto yy855;
					}
				}
			}
		}
	} else {
		if (yyaccept <= 23) {
			if (yyaccept <= 19) {
				if (yyaccept <= 17) {
					if (yyaccept <= 16) {
						goto yy949;
					} else {
						goto yy969;
					}
				} else {
					if (yyaccept <= 18) {
						goto yy1000;
					} else {
						goto yy1007;
					}
				}
			} else {
				if (yyaccept <= 21) {
					if (yyaccept <= 20) {
						goto yy1034;
					} else {
						goto yy979;
					}
				} else {
					if (yyaccept <= 22) {
						goto yy660;
					} else {
						goto yy1159;
					}
				}
			}
		} else {
			if (yyaccept <= 27) {
				if (yyaccept <= 25) {
					if (yyaccept <= 24) {
						goto yy1028;
					} else {
						goto yy1250;
					}
				} else {
					if (yyaccept <= 26) {
						goto yy1258;
					} else {
						goto yy1313;
					}
				}
			} else {
				if (yyaccept <= 29) {
					if (yyaccept <= 28) {
						goto yy1316;
					} else {
						goto yy1394;
					}
				} else {
					if (yyaccept <= 30) {
						goto yy1402;
					} else {
						goto yy1425;
					}
				}
			}
		}
	}
yy54:
	YYDEBUG(54, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(55, *YYCURSOR);
	if (yybm[0+yych] & 4) {
		goto yy54;
	}
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy51;
	goto yy53;
yy56:
	YYDEBUG(56, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
	yych = *YYCURSOR;
yy57:
	YYDEBUG(57, *YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'F') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy56;
				if (yych <= 0x1F) goto yy53;
				goto yy56;
			} else {
				if (yych == 'D') goto yy61;
				if (yych <= 'E') goto yy53;
				goto yy63;
			}
		} else {
			if (yych <= 'M') {
				if (yych == 'H') goto yy60;
				if (yych <= 'L') goto yy53;
				goto yy59;
			} else {
				if (yych <= 'S') {
					if (yych <= 'R') goto yy53;
				} else {
					if (yych <= 'T') goto yy65;
					if (yych <= 'V') goto yy53;
					goto yy62;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy64;
				if (yych <= 'c') goto yy53;
				goto yy61;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy53;
					goto yy63;
				} else {
					if (yych == 'h') goto yy60;
					goto yy53;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'm') goto yy59;
				if (yych <= 'r') goto yy53;
				if (yych >= 't') goto yy65;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy53;
					goto yy62;
				} else {
					if (yych == 'y') goto yy64;
					goto yy53;
				}
			}
		}
	}
yy58:
	YYDEBUG(58, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy123;
			goto yy53;
		} else {
			if (yych <= 'E') goto yy124;
			if (yych <= 'T') goto yy53;
			goto yy122;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy123;
			goto yy53;
		} else {
			if (yych <= 'e') goto yy124;
			if (yych == 'u') goto yy122;
			goto yy53;
		}
	}
yy59:
	YYDEBUG(59, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych == 'I') goto yy114;
		if (yych <= 'N') goto yy53;
		goto yy113;
	} else {
		if (yych <= 'i') {
			if (yych <= 'h') goto yy53;
			goto yy114;
		} else {
			if (yych == 'o') goto yy113;
			goto yy53;
		}
	}
yy60:
	YYDEBUG(60, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy111;
	if (yych == 'o') goto yy111;
	goto yy53;
yy61:
	YYDEBUG(61, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy110;
	if (yych == 'a') goto yy110;
	goto yy53;
yy62:
	YYDEBUG(62, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy98;
	if (yych == 'e') goto yy98;
	goto yy53;
yy63:
	YYDEBUG(63, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych == 'O') goto yy83;
		if (yych <= 'Q') goto yy53;
		goto yy82;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy53;
			goto yy83;
		} else {
			if (yych == 'r') goto yy82;
			goto yy53;
		}
	}
yy64:
	YYDEBUG(64, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy79;
	if (yych == 'e') goto yy79;
	goto yy53;
yy65:
	YYDEBUG(65, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'H') goto yy66;
		if (yych <= 'T') goto yy53;
		goto yy67;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy53;
		} else {
			if (yych == 'u') goto yy67;
			goto yy53;
		}
	}
yy66:
	YYDEBUG(66, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy74;
	if (yych == 'u') goto yy74;
	goto yy53;
yy67:
	YYDEBUG(67, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy68;
	if (yych != 'e') goto yy53;
yy68:
	YYDEBUG(68, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'S') goto yy70;
	if (yych == 's') goto yy70;
yy69:
	YYDEBUG(69, *YYCURSOR);
	{
		timelib_ull i;
		DEBUG_OUTPUT("relative");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		while(*ptr) {
			i = timelib_get_unsigned_nr((char **) &ptr, 24);
			timelib_eat_spaces((char **) &ptr);
			timelib_set_relative((char **) &ptr, i, 1, s);
		}
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy70:
	YYDEBUG(70, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy71;
	if (yych != 'd') goto yy53;
yy71:
	YYDEBUG(71, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy72;
	if (yych != 'a') goto yy53;
yy72:
	YYDEBUG(72, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy73;
	if (yych != 'y') goto yy53;
yy73:
	YYDEBUG(73, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy69;
yy74:
	YYDEBUG(74, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'R') goto yy75;
	if (yych != 'r') goto yy69;
yy75:
	YYDEBUG(75, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy76;
	if (yych != 's') goto yy53;
yy76:
	YYDEBUG(76, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy77;
	if (yych != 'd') goto yy53;
yy77:
	YYDEBUG(77, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy78;
	if (yych != 'a') goto yy53;
yy78:
	YYDEBUG(78, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy73;
	if (yych == 'y') goto yy73;
	goto yy53;
yy79:
	YYDEBUG(79, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy80;
	if (yych != 'a') goto yy53;
yy80:
	YYDEBUG(80, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy81;
	if (yych != 'r') goto yy53;
yy81:
	YYDEBUG(81, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy73;
	if (yych == 's') goto yy73;
	goto yy69;
yy82:
	YYDEBUG(82, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy95;
	if (yych == 'i') goto yy95;
	goto yy53;
yy83:
	YYDEBUG(83, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy84;
	if (yych != 'r') goto yy53;
yy84:
	YYDEBUG(84, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy85;
	if (yych != 't') goto yy53;
yy85:
	YYDEBUG(85, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'H') goto yy87;
		if (yych <= 'M') goto yy53;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy53;
			goto yy87;
		} else {
			if (yych != 'n') goto yy53;
		}
	}
	YYDEBUG(86, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy92;
	if (yych == 'i') goto yy92;
	goto yy53;
yy87:
	YYDEBUG(87, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy88;
	if (yych != 'n') goto yy53;
yy88:
	YYDEBUG(88, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy89;
	if (yych != 'i') goto yy53;
yy89:
	YYDEBUG(89, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy90;
	if (yych != 'g') goto yy53;
yy90:
	YYDEBUG(90, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy91;
	if (yych != 'h') goto yy53;
yy91:
	YYDEBUG(91, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy81;
	if (yych == 't') goto yy81;
	goto yy53;
yy92:
	YYDEBUG(92, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy93;
	if (yych != 'g') goto yy53;
yy93:
	YYDEBUG(93, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy94;
	if (yych != 'h') goto yy53;
yy94:
	YYDEBUG(94, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy81;
	if (yych == 't') goto yy81;
	goto yy53;
yy95:
	YYDEBUG(95, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'D') goto yy96;
	if (yych != 'd') goto yy69;
yy96:
	YYDEBUG(96, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy97;
	if (yych != 'a') goto yy53;
yy97:
	YYDEBUG(97, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy73;
	if (yych == 'y') goto yy73;
	goto yy53;
yy98:
	YYDEBUG(98, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= 'C') goto yy53;
		if (yych <= 'D') goto yy100;
	} else {
		if (yych <= 'c') goto yy53;
		if (yych <= 'd') goto yy100;
		if (yych >= 'f') goto yy53;
	}
	YYDEBUG(99, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'K') goto yy106;
	if (yych == 'k') goto yy106;
	goto yy53;
yy100:
	YYDEBUG(100, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'N') goto yy101;
	if (yych != 'n') goto yy69;
yy101:
	YYDEBUG(101, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy102;
	if (yych != 'e') goto yy53;
yy102:
	YYDEBUG(102, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy103;
	if (yych != 's') goto yy53;
yy103:
	YYDEBUG(103, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy104;
	if (yych != 'd') goto yy53;
yy104:
	YYDEBUG(104, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy105;
	if (yych != 'a') goto yy53;
yy105:
	YYDEBUG(105, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy73;
	if (yych == 'y') goto yy73;
	goto yy53;
yy106:
	YYDEBUG(106, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == 'D') goto yy107;
		if (yych <= 'R') goto yy69;
		goto yy73;
	} else {
		if (yych <= 'd') {
			if (yych <= 'c') goto yy69;
		} else {
			if (yych == 's') goto yy73;
			goto yy69;
		}
	}
yy107:
	YYDEBUG(107, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy108;
	if (yych != 'a') goto yy53;
yy108:
	YYDEBUG(108, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy109;
	if (yych != 'y') goto yy53;
yy109:
	YYDEBUG(109, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy73;
	if (yych == 's') goto yy73;
	goto yy69;
yy110:
	YYDEBUG(110, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy81;
	if (yych == 'y') goto yy81;
	goto yy53;
yy111:
	YYDEBUG(111, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy112;
	if (yych != 'u') goto yy53;
yy112:
	YYDEBUG(112, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy81;
	if (yych == 'r') goto yy81;
	goto yy53;
yy113:
	YYDEBUG(113, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy118;
	if (yych == 'n') goto yy118;
	goto yy53;
yy114:
	YYDEBUG(114, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy115;
	if (yych != 'n') goto yy53;
yy115:
	YYDEBUG(115, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych == 'S') goto yy73;
		if (yych <= 'T') goto yy69;
	} else {
		if (yych <= 's') {
			if (yych <= 'r') goto yy69;
			goto yy73;
		} else {
			if (yych != 'u') goto yy69;
		}
	}
	YYDEBUG(116, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy117;
	if (yych != 't') goto yy53;
yy117:
	YYDEBUG(117, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy81;
	if (yych == 'e') goto yy81;
	goto yy53;
yy118:
	YYDEBUG(118, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == 'D') goto yy119;
		if (yych <= 'S') goto yy69;
		goto yy120;
	} else {
		if (yych <= 'd') {
			if (yych <= 'c') goto yy69;
		} else {
			if (yych == 't') goto yy120;
			goto yy69;
		}
	}
yy119:
	YYDEBUG(119, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy121;
	if (yych == 'a') goto yy121;
	goto yy53;
yy120:
	YYDEBUG(120, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy81;
	if (yych == 'h') goto yy81;
	goto yy53;
yy121:
	YYDEBUG(121, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy73;
	if (yych == 'y') goto yy73;
	goto yy53;
yy122:
	YYDEBUG(122, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy133;
	if (yych == 'n') goto yy133;
	goto yy53;
yy123:
	YYDEBUG(123, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy128;
	if (yych == 't') goto yy128;
	goto yy53;
yy124:
	YYDEBUG(124, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy125;
	if (yych != 'c') goto yy53;
yy125:
	YYDEBUG(125, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == 'O') goto yy126;
		if (yych <= 'R') goto yy69;
		goto yy73;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy69;
		} else {
			if (yych == 's') goto yy73;
			goto yy69;
		}
	}
yy126:
	YYDEBUG(126, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy127;
	if (yych != 'n') goto yy53;
yy127:
	YYDEBUG(127, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy81;
	if (yych == 'd') goto yy81;
	goto yy53;
yy128:
	YYDEBUG(128, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'U') goto yy129;
	if (yych != 'u') goto yy69;
yy129:
	YYDEBUG(129, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy130;
	if (yych != 'r') goto yy53;
yy130:
	YYDEBUG(130, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy131;
	if (yych != 'd') goto yy53;
yy131:
	YYDEBUG(131, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy132;
	if (yych != 'a') goto yy53;
yy132:
	YYDEBUG(132, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy73;
	if (yych == 'y') goto yy73;
	goto yy53;
yy133:
	YYDEBUG(133, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'D') goto yy134;
	if (yych != 'd') goto yy69;
yy134:
	YYDEBUG(134, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy135;
	if (yych != 'a') goto yy53;
yy135:
	YYDEBUG(135, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy73;
	if (yych == 'y') goto yy73;
	goto yy53;
yy136:
	YYDEBUG(136, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy3;
yy137:
	YYDEBUG(137, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy136;
		goto yy3;
	} else {
		if (yych <= 'Z') goto yy138;
		if (yych <= '`') goto yy3;
		if (yych >= '{') goto yy3;
	}
yy138:
	YYDEBUG(138, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy136;
		goto yy3;
	} else {
		if (yych <= 'Z') goto yy139;
		if (yych <= '`') goto yy3;
		if (yych >= '{') goto yy3;
	}
yy139:
	YYDEBUG(139, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy136;
		goto yy3;
	} else {
		if (yych <= 'Z') goto yy140;
		if (yych <= '`') goto yy3;
		if (yych >= '{') goto yy3;
	}
yy140:
	YYDEBUG(140, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy136;
		goto yy3;
	} else {
		if (yych <= 'Z') goto yy141;
		if (yych <= '`') goto yy3;
		if (yych >= '{') goto yy3;
	}
yy141:
	YYDEBUG(141, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ')') goto yy136;
	goto yy3;
yy142:
	YYDEBUG(142, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy3;
			if (yych <= 'Z') goto yy138;
			goto yy3;
		} else {
			if (yych <= '_') goto yy144;
			if (yych <= '`') goto yy3;
			if (yych >= '{') goto yy3;
		}
	}
yy143:
	YYDEBUG(143, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy3;
			if (yych <= 'Z') goto yy139;
			goto yy3;
		} else {
			if (yych <= '_') goto yy144;
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy147;
			goto yy3;
		}
	}
yy144:
	YYDEBUG(144, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yybm[0+yych] & 8) {
		goto yy145;
	}
	goto yy53;
yy145:
	YYDEBUG(145, *YYCURSOR);
	yyaccept = 0;
	YYMARKER = ++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(146, *YYCURSOR);
	if (yybm[0+yych] & 8) {
		goto yy145;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy144;
		goto yy3;
	} else {
		if (yych <= '/') goto yy144;
		if (yych == '_') goto yy144;
		goto yy3;
	}
yy147:
	YYDEBUG(147, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy3;
			if (yych <= 'Z') goto yy140;
			goto yy3;
		} else {
			if (yych <= '_') goto yy144;
			if (yych <= '`') goto yy3;
			if (yych >= '{') goto yy3;
		}
	}
yy148:
	YYDEBUG(148, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy3;
			if (yych <= 'Z') goto yy141;
			goto yy3;
		} else {
			if (yych <= '_') goto yy144;
			if (yych <= '`') goto yy3;
			if (yych >= '{') goto yy3;
		}
	}
yy149:
	YYDEBUG(149, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy150;
	}
	if (yych <= '-') {
		if (yych == ')') goto yy136;
		if (yych <= ',') goto yy3;
		goto yy144;
	} else {
		if (yych <= '/') {
			if (yych <= '.') goto yy3;
			goto yy144;
		} else {
			if (yych == '_') goto yy144;
			goto yy3;
		}
	}
yy150:
	YYDEBUG(150, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
yy151:
	YYDEBUG(151, *YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy150;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy144;
		goto yy53;
	} else {
		if (yych <= '/') goto yy144;
		if (yych == '_') goto yy144;
		goto yy53;
	}
yy152:
	YYDEBUG(152, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy136;
		goto yy3;
	} else {
		if (yych <= 'Z') goto yy137;
		if (yych <= '`') goto yy3;
		if (yych <= 'z') goto yy137;
		goto yy3;
	}
yy153:
	YYDEBUG(153, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy138;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy138;
			if (yych <= '`') goto yy3;
			goto yy138;
		} else {
			if (yych <= 'e') goto yy154;
			if (yych <= 'z') goto yy138;
			goto yy3;
		}
	}
yy154:
	YYDEBUG(154, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'V') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'U') goto yy139;
		}
	} else {
		if (yych <= 'u') {
			if (yych <= 'Z') goto yy139;
			if (yych <= '`') goto yy3;
			goto yy139;
		} else {
			if (yych <= 'v') goto yy155;
			if (yych <= 'z') goto yy139;
			goto yy3;
		}
	}
yy155:
	YYDEBUG(155, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'I') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'H') goto yy140;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'i') goto yy156;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy156:
	YYDEBUG(156, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'N') goto yy141;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'o') goto yy157;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy157:
	YYDEBUG(157, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == ')') goto yy136;
		goto yy3;
	} else {
		if (yych <= 'U') goto yy158;
		if (yych != 'u') goto yy3;
	}
yy158:
	YYDEBUG(158, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy159;
	if (yych != 's') goto yy53;
yy159:
	YYDEBUG(159, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '\t') goto yy160;
	if (yych != ' ') goto yy53;
yy160:
	YYDEBUG(160, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
	yych = *YYCURSOR;
	YYDEBUG(161, *YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'F') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy160;
				if (yych <= 0x1F) goto yy53;
				goto yy160;
			} else {
				if (yych == 'D') goto yy165;
				if (yych <= 'E') goto yy53;
				goto yy167;
			}
		} else {
			if (yych <= 'M') {
				if (yych == 'H') goto yy164;
				if (yych <= 'L') goto yy53;
				goto yy163;
			} else {
				if (yych <= 'S') {
					if (yych <= 'R') goto yy53;
				} else {
					if (yych <= 'T') goto yy169;
					if (yych <= 'V') goto yy53;
					goto yy166;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy168;
				if (yych <= 'c') goto yy53;
				goto yy165;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy53;
					goto yy167;
				} else {
					if (yych == 'h') goto yy164;
					goto yy53;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'm') goto yy163;
				if (yych <= 'r') goto yy53;
				if (yych >= 't') goto yy169;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy53;
					goto yy166;
				} else {
					if (yych == 'y') goto yy168;
					goto yy53;
				}
			}
		}
	}
	YYDEBUG(162, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy227;
			goto yy53;
		} else {
			if (yych <= 'E') goto yy228;
			if (yych <= 'T') goto yy53;
			goto yy226;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy227;
			goto yy53;
		} else {
			if (yych <= 'e') goto yy228;
			if (yych == 'u') goto yy226;
			goto yy53;
		}
	}
yy163:
	YYDEBUG(163, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych == 'I') goto yy218;
		if (yych <= 'N') goto yy53;
		goto yy217;
	} else {
		if (yych <= 'i') {
			if (yych <= 'h') goto yy53;
			goto yy218;
		} else {
			if (yych == 'o') goto yy217;
			goto yy53;
		}
	}
yy164:
	YYDEBUG(164, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy215;
	if (yych == 'o') goto yy215;
	goto yy53;
yy165:
	YYDEBUG(165, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy214;
	if (yych == 'a') goto yy214;
	goto yy53;
yy166:
	YYDEBUG(166, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy202;
	if (yych == 'e') goto yy202;
	goto yy53;
yy167:
	YYDEBUG(167, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych == 'O') goto yy187;
		if (yych <= 'Q') goto yy53;
		goto yy186;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy53;
			goto yy187;
		} else {
			if (yych == 'r') goto yy186;
			goto yy53;
		}
	}
yy168:
	YYDEBUG(168, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy183;
	if (yych == 'e') goto yy183;
	goto yy53;
yy169:
	YYDEBUG(169, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'H') goto yy170;
		if (yych <= 'T') goto yy53;
		goto yy171;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy53;
		} else {
			if (yych == 'u') goto yy171;
			goto yy53;
		}
	}
yy170:
	YYDEBUG(170, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy178;
	if (yych == 'u') goto yy178;
	goto yy53;
yy171:
	YYDEBUG(171, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy172;
	if (yych != 'e') goto yy53;
yy172:
	YYDEBUG(172, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'S') goto yy174;
	if (yych == 's') goto yy174;
yy173:
	YYDEBUG(173, *YYCURSOR);
	{
		timelib_sll i;
		int         behavior = 0;
		DEBUG_OUTPUT("relativetext");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		while(*ptr) {
			i = timelib_get_relative_text((char **) &ptr, &behavior);
			timelib_eat_spaces((char **) &ptr);
			timelib_set_relative((char **) &ptr, i, behavior, s);
		}
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy174:
	YYDEBUG(174, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy175;
	if (yych != 'd') goto yy53;
yy175:
	YYDEBUG(175, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy176;
	if (yych != 'a') goto yy53;
yy176:
	YYDEBUG(176, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy177;
	if (yych != 'y') goto yy53;
yy177:
	YYDEBUG(177, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy173;
yy178:
	YYDEBUG(178, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'R') goto yy179;
	if (yych != 'r') goto yy173;
yy179:
	YYDEBUG(179, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy180;
	if (yych != 's') goto yy53;
yy180:
	YYDEBUG(180, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy181;
	if (yych != 'd') goto yy53;
yy181:
	YYDEBUG(181, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy182;
	if (yych != 'a') goto yy53;
yy182:
	YYDEBUG(182, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy177;
	if (yych == 'y') goto yy177;
	goto yy53;
yy183:
	YYDEBUG(183, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy184;
	if (yych != 'a') goto yy53;
yy184:
	YYDEBUG(184, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy185;
	if (yych != 'r') goto yy53;
yy185:
	YYDEBUG(185, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy177;
	if (yych == 's') goto yy177;
	goto yy173;
yy186:
	YYDEBUG(186, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy199;
	if (yych == 'i') goto yy199;
	goto yy53;
yy187:
	YYDEBUG(187, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy188;
	if (yych != 'r') goto yy53;
yy188:
	YYDEBUG(188, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy189;
	if (yych != 't') goto yy53;
yy189:
	YYDEBUG(189, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'H') goto yy191;
		if (yych <= 'M') goto yy53;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy53;
			goto yy191;
		} else {
			if (yych != 'n') goto yy53;
		}
	}
	YYDEBUG(190, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy196;
	if (yych == 'i') goto yy196;
	goto yy53;
yy191:
	YYDEBUG(191, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy192;
	if (yych != 'n') goto yy53;
yy192:
	YYDEBUG(192, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy193;
	if (yych != 'i') goto yy53;
yy193:
	YYDEBUG(193, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy194;
	if (yych != 'g') goto yy53;
yy194:
	YYDEBUG(194, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy195;
	if (yych != 'h') goto yy53;
yy195:
	YYDEBUG(195, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy185;
	if (yych == 't') goto yy185;
	goto yy53;
yy196:
	YYDEBUG(196, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy197;
	if (yych != 'g') goto yy53;
yy197:
	YYDEBUG(197, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy198;
	if (yych != 'h') goto yy53;
yy198:
	YYDEBUG(198, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy185;
	if (yych == 't') goto yy185;
	goto yy53;
yy199:
	YYDEBUG(199, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'D') goto yy200;
	if (yych != 'd') goto yy173;
yy200:
	YYDEBUG(200, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy201;
	if (yych != 'a') goto yy53;
yy201:
	YYDEBUG(201, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy177;
	if (yych == 'y') goto yy177;
	goto yy53;
yy202:
	YYDEBUG(202, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= 'C') goto yy53;
		if (yych <= 'D') goto yy204;
	} else {
		if (yych <= 'c') goto yy53;
		if (yych <= 'd') goto yy204;
		if (yych >= 'f') goto yy53;
	}
	YYDEBUG(203, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'K') goto yy210;
	if (yych == 'k') goto yy210;
	goto yy53;
yy204:
	YYDEBUG(204, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'N') goto yy205;
	if (yych != 'n') goto yy173;
yy205:
	YYDEBUG(205, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy206;
	if (yych != 'e') goto yy53;
yy206:
	YYDEBUG(206, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy207;
	if (yych != 's') goto yy53;
yy207:
	YYDEBUG(207, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy208;
	if (yych != 'd') goto yy53;
yy208:
	YYDEBUG(208, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy209;
	if (yych != 'a') goto yy53;
yy209:
	YYDEBUG(209, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy177;
	if (yych == 'y') goto yy177;
	goto yy53;
yy210:
	YYDEBUG(210, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == 'D') goto yy211;
		if (yych <= 'R') goto yy173;
		goto yy177;
	} else {
		if (yych <= 'd') {
			if (yych <= 'c') goto yy173;
		} else {
			if (yych == 's') goto yy177;
			goto yy173;
		}
	}
yy211:
	YYDEBUG(211, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy212;
	if (yych != 'a') goto yy53;
yy212:
	YYDEBUG(212, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy213;
	if (yych != 'y') goto yy53;
yy213:
	YYDEBUG(213, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy177;
	if (yych == 's') goto yy177;
	goto yy173;
yy214:
	YYDEBUG(214, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy185;
	if (yych == 'y') goto yy185;
	goto yy53;
yy215:
	YYDEBUG(215, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy216;
	if (yych != 'u') goto yy53;
yy216:
	YYDEBUG(216, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy185;
	if (yych == 'r') goto yy185;
	goto yy53;
yy217:
	YYDEBUG(217, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy222;
	if (yych == 'n') goto yy222;
	goto yy53;
yy218:
	YYDEBUG(218, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy219;
	if (yych != 'n') goto yy53;
yy219:
	YYDEBUG(219, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych == 'S') goto yy177;
		if (yych <= 'T') goto yy173;
	} else {
		if (yych <= 's') {
			if (yych <= 'r') goto yy173;
			goto yy177;
		} else {
			if (yych != 'u') goto yy173;
		}
	}
	YYDEBUG(220, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy221;
	if (yych != 't') goto yy53;
yy221:
	YYDEBUG(221, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy185;
	if (yych == 'e') goto yy185;
	goto yy53;
yy222:
	YYDEBUG(222, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == 'D') goto yy223;
		if (yych <= 'S') goto yy173;
		goto yy224;
	} else {
		if (yych <= 'd') {
			if (yych <= 'c') goto yy173;
		} else {
			if (yych == 't') goto yy224;
			goto yy173;
		}
	}
yy223:
	YYDEBUG(223, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy225;
	if (yych == 'a') goto yy225;
	goto yy53;
yy224:
	YYDEBUG(224, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy185;
	if (yych == 'h') goto yy185;
	goto yy53;
yy225:
	YYDEBUG(225, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy177;
	if (yych == 'y') goto yy177;
	goto yy53;
yy226:
	YYDEBUG(226, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy237;
	if (yych == 'n') goto yy237;
	goto yy53;
yy227:
	YYDEBUG(227, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy232;
	if (yych == 't') goto yy232;
	goto yy53;
yy228:
	YYDEBUG(228, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy229;
	if (yych != 'c') goto yy53;
yy229:
	YYDEBUG(229, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == 'O') goto yy230;
		if (yych <= 'R') goto yy173;
		goto yy177;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy173;
		} else {
			if (yych == 's') goto yy177;
			goto yy173;
		}
	}
yy230:
	YYDEBUG(230, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy231;
	if (yych != 'n') goto yy53;
yy231:
	YYDEBUG(231, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy185;
	if (yych == 'd') goto yy185;
	goto yy53;
yy232:
	YYDEBUG(232, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'U') goto yy233;
	if (yych != 'u') goto yy173;
yy233:
	YYDEBUG(233, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy234;
	if (yych != 'r') goto yy53;
yy234:
	YYDEBUG(234, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy235;
	if (yych != 'd') goto yy53;
yy235:
	YYDEBUG(235, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy236;
	if (yych != 'a') goto yy53;
yy236:
	YYDEBUG(236, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy177;
	if (yych == 'y') goto yy177;
	goto yy53;
yy237:
	YYDEBUG(237, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'D') goto yy238;
	if (yych != 'd') goto yy173;
yy238:
	YYDEBUG(238, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy239;
	if (yych != 'a') goto yy53;
yy239:
	YYDEBUG(239, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy177;
	if (yych == 'y') goto yy177;
	goto yy53;
yy240:
	YYDEBUG(240, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy138;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy154;
			if (yych <= 'Z') goto yy138;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy143;
			} else {
				if (yych <= 'e') goto yy241;
				if (yych <= 'z') goto yy143;
				goto yy3;
			}
		}
	}
yy241:
	YYDEBUG(241, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy139;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'V') goto yy155;
			if (yych <= 'Z') goto yy139;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'u') {
				if (yych <= '`') goto yy3;
				goto yy147;
			} else {
				if (yych <= 'v') goto yy242;
				if (yych <= 'z') goto yy147;
				goto yy3;
			}
		}
	}
yy242:
	YYDEBUG(242, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy140;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'I') goto yy156;
			if (yych <= 'Z') goto yy140;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'h') {
				if (yych <= '`') goto yy3;
				goto yy148;
			} else {
				if (yych <= 'i') goto yy243;
				if (yych <= 'z') goto yy148;
				goto yy3;
			}
		}
	}
yy243:
	YYDEBUG(243, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'O') goto yy157;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy3;
				goto yy149;
			} else {
				if (yych <= 'o') goto yy244;
				if (yych <= 'z') goto yy149;
				goto yy3;
			}
		}
	}
yy244:
	YYDEBUG(244, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= ',') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy144;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'U') goto yy158;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'u') goto yy245;
			if (yych <= 'z') goto yy150;
			goto yy3;
		}
	}
yy245:
	YYDEBUG(245, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy159;
	if (yych != 's') goto yy151;
yy246:
	YYDEBUG(246, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm[0+yych] & 16) {
		goto yy150;
	}
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy53;
			goto yy160;
		} else {
			if (yych == ' ') goto yy160;
			goto yy53;
		}
	} else {
		if (yych <= '/') {
			if (yych == '.') goto yy53;
			goto yy144;
		} else {
			if (yych == '_') goto yy144;
			goto yy53;
		}
	}
yy247:
	YYDEBUG(247, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'R') goto yy138;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy138;
			if (yych <= '`') goto yy3;
			goto yy138;
		} else {
			if (yych <= 's') goto yy248;
			if (yych <= 'z') goto yy138;
			goto yy3;
		}
	}
yy248:
	YYDEBUG(248, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy139;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy139;
			if (yych <= '`') goto yy3;
			goto yy139;
		} else {
			if (yych <= 't') goto yy249;
			if (yych <= 'z') goto yy139;
			goto yy3;
		}
	}
yy249:
	YYDEBUG(249, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '(') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy3;
			goto yy160;
		} else {
			if (yych == ' ') goto yy160;
			goto yy3;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= ')') goto yy136;
			if (yych <= '@') goto yy3;
			goto yy140;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy250:
	YYDEBUG(250, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy138;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy248;
			if (yych <= 'Z') goto yy138;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy3;
				goto yy143;
			} else {
				if (yych <= 's') goto yy251;
				if (yych <= 'z') goto yy143;
				goto yy3;
			}
		}
	}
yy251:
	YYDEBUG(251, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy139;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy249;
			if (yych <= 'Z') goto yy139;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy147;
			} else {
				if (yych <= 't') goto yy252;
				if (yych <= 'z') goto yy147;
				goto yy3;
			}
		}
	}
yy252:
	YYDEBUG(252, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy160;
			if (yych <= 0x1F) goto yy3;
			goto yy160;
		} else {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= 'Z') {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy140;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy3;
				goto yy144;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy148;
				goto yy3;
			}
		}
	}
yy253:
	YYDEBUG(253, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'G') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'F') goto yy138;
			goto yy260;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy138;
			if (yych <= '`') goto yy3;
			goto yy138;
		} else {
			if (yych <= 'g') goto yy260;
			if (yych <= 'z') goto yy138;
			goto yy3;
		}
	}
yy254:
	YYDEBUG(254, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy138;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy138;
			if (yych <= '`') goto yy3;
			goto yy138;
		} else {
			if (yych <= 'e') goto yy255;
			if (yych <= 'z') goto yy138;
			goto yy3;
		}
	}
yy255:
	YYDEBUG(255, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'V') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'U') goto yy139;
		}
	} else {
		if (yych <= 'u') {
			if (yych <= 'Z') goto yy139;
			if (yych <= '`') goto yy3;
			goto yy139;
		} else {
			if (yych <= 'v') goto yy256;
			if (yych <= 'z') goto yy139;
			goto yy3;
		}
	}
yy256:
	YYDEBUG(256, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy140;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'e') goto yy257;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy257:
	YYDEBUG(257, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy141;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'n') goto yy258;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy258:
	YYDEBUG(258, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == ')') goto yy136;
		goto yy3;
	} else {
		if (yych <= 'T') goto yy259;
		if (yych != 't') goto yy3;
	}
yy259:
	YYDEBUG(259, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy159;
	if (yych == 'h') goto yy159;
	goto yy53;
yy260:
	YYDEBUG(260, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy139;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy139;
			if (yych <= '`') goto yy3;
			goto yy139;
		} else {
			if (yych <= 'h') goto yy261;
			if (yych <= 'z') goto yy139;
			goto yy3;
		}
	}
yy261:
	YYDEBUG(261, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy140;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy140;
		} else {
			if (yych <= 't') goto yy262;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy262:
	YYDEBUG(262, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy160;
			goto yy3;
		} else {
			if (yych <= ' ') goto yy160;
			if (yych == ')') goto yy136;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych == 'H') goto yy263;
			if (yych <= 'Z') goto yy141;
			goto yy3;
		} else {
			if (yych == 'h') goto yy263;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy263:
	YYDEBUG(263, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 0x1F) {
		if (yych == '\t') goto yy160;
		goto yy3;
	} else {
		if (yych <= ' ') goto yy160;
		if (yych == ')') goto yy136;
		goto yy3;
	}
yy264:
	YYDEBUG(264, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'F') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy138;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'G') goto yy260;
			if (yych <= 'Z') goto yy138;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'f') {
				if (yych <= '`') goto yy3;
				goto yy143;
			} else {
				if (yych <= 'g') goto yy271;
				if (yych <= 'z') goto yy143;
				goto yy3;
			}
		}
	}
yy265:
	YYDEBUG(265, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy138;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy255;
			if (yych <= 'Z') goto yy138;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy143;
			} else {
				if (yych <= 'e') goto yy266;
				if (yych <= 'z') goto yy143;
				goto yy3;
			}
		}
	}
yy266:
	YYDEBUG(266, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy139;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'V') goto yy256;
			if (yych <= 'Z') goto yy139;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'u') {
				if (yych <= '`') goto yy3;
				goto yy147;
			} else {
				if (yych <= 'v') goto yy267;
				if (yych <= 'z') goto yy147;
				goto yy3;
			}
		}
	}
yy267:
	YYDEBUG(267, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy140;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy257;
			if (yych <= 'Z') goto yy140;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy148;
			} else {
				if (yych <= 'e') goto yy268;
				if (yych <= 'z') goto yy148;
				goto yy3;
			}
		}
	}
yy268:
	YYDEBUG(268, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy258;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy149;
			} else {
				if (yych <= 'n') goto yy269;
				if (yych <= 'z') goto yy149;
				goto yy3;
			}
		}
	}
yy269:
	YYDEBUG(269, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= ',') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy144;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'T') goto yy259;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 't') goto yy270;
			if (yych <= 'z') goto yy150;
			goto yy3;
		}
	}
yy270:
	YYDEBUG(270, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy159;
	if (yych == 'h') goto yy246;
	goto yy151;
yy271:
	YYDEBUG(271, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy139;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy261;
			if (yych <= 'Z') goto yy139;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy3;
				goto yy147;
			} else {
				if (yych <= 'h') goto yy272;
				if (yych <= 'z') goto yy147;
				goto yy3;
			}
		}
	}
yy272:
	YYDEBUG(272, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy140;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy262;
			if (yych <= 'Z') goto yy140;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy148;
			} else {
				if (yych <= 't') goto yy273;
				if (yych <= 'z') goto yy148;
				goto yy3;
			}
		}
	}
yy273:
	YYDEBUG(273, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy3;
				goto yy160;
			} else {
				if (yych == ' ') goto yy160;
				goto yy3;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy136;
				goto yy3;
			} else {
				if (yych == '.') goto yy3;
				goto yy144;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'G') {
				if (yych <= '@') goto yy3;
				goto yy141;
			} else {
				if (yych <= 'H') goto yy263;
				if (yych <= 'Z') goto yy141;
				goto yy3;
			}
		} else {
			if (yych <= 'g') {
				if (yych <= '_') goto yy144;
				if (yych <= '`') goto yy3;
				goto yy149;
			} else {
				if (yych <= 'h') goto yy274;
				if (yych <= 'z') goto yy149;
				goto yy3;
			}
		}
	}
yy274:
	YYDEBUG(274, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy150;
	}
	if (yych <= ')') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy160;
			goto yy3;
		} else {
			if (yych <= ' ') goto yy160;
			if (yych <= '(') goto yy3;
			goto yy136;
		}
	} else {
		if (yych <= '.') {
			if (yych == '-') goto yy144;
			goto yy3;
		} else {
			if (yych <= '/') goto yy144;
			if (yych == '_') goto yy144;
			goto yy3;
		}
	}
yy275:
	YYDEBUG(275, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= '@') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= 'C') goto yy138;
			if (yych >= 'E') goto yy278;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy138;
			if (yych <= '`') goto yy3;
			goto yy138;
		} else {
			if (yych <= 'd') goto yy276;
			if (yych <= 'e') goto yy278;
			if (yych <= 'z') goto yy138;
			goto yy3;
		}
	}
yy276:
	YYDEBUG(276, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= 'N') {
		if (yych <= ')') {
			if (yych >= ')') goto yy136;
		} else {
			if (yych <= '@') goto yy277;
			if (yych <= 'M') goto yy139;
			goto yy284;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy139;
			if (yych >= 'a') goto yy139;
		} else {
			if (yych <= 'n') goto yy284;
			if (yych <= 'z') goto yy139;
		}
	}
yy277:
	YYDEBUG(277, *YYCURSOR);
	{
		const timelib_relunit* relunit;
		DEBUG_OUTPUT("daytext");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_HAVE_WEEKDAY_RELATIVE();
		TIMELIB_UNHAVE_TIME();
		relunit = timelib_lookup_relunit((char**) &ptr);
		s->time->relative.weekday = relunit->multiplier;
		if (s->time->relative.weekday_behavior != 2) {
			s->time->relative.weekday_behavior = 1;
		}
		
		TIMELIB_DEINIT;
		return TIMELIB_WEEKDAY;
	}
yy278:
	YYDEBUG(278, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'K') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'J') goto yy139;
		}
	} else {
		if (yych <= 'j') {
			if (yych <= 'Z') goto yy139;
			if (yych <= '`') goto yy3;
			goto yy139;
		} else {
			if (yych <= 'k') goto yy279;
			if (yych <= 'z') goto yy139;
			goto yy3;
		}
	}
yy279:
	YYDEBUG(279, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy140;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'd') goto yy280;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy280:
	YYDEBUG(280, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy136;
		if (yych <= '@') goto yy3;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy141;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy281;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy281:
	YYDEBUG(281, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych == ')') goto yy136;
		goto yy3;
	} else {
		if (yych <= 'Y') goto yy282;
		if (yych != 'y') goto yy3;
	}
yy282:
	YYDEBUG(282, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy283;
	if (yych != 's') goto yy277;
yy283:
	YYDEBUG(283, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy277;
yy284:
	YYDEBUG(284, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy140;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'e') goto yy285;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy285:
	YYDEBUG(285, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'R') goto yy141;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 's') goto yy286;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy286:
	YYDEBUG(286, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych == ')') goto yy136;
		goto yy3;
	} else {
		if (yych <= 'D') goto yy287;
		if (yych != 'd') goto yy3;
	}
yy287:
	YYDEBUG(287, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy288;
	if (yych != 'a') goto yy53;
yy288:
	YYDEBUG(288, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy283;
	if (yych == 'y') goto yy283;
	goto yy53;
yy289:
	YYDEBUG(289, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych <= '/') {
				if (yych <= '.') goto yy3;
				goto yy144;
			} else {
				if (yych <= '@') goto yy3;
				if (yych <= 'C') goto yy138;
				goto yy276;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'E') goto yy278;
				goto yy138;
			} else {
				if (yych == '_') goto yy144;
				goto yy3;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= 'c') goto yy143;
			} else {
				if (yych <= 'e') goto yy291;
				if (yych <= 'z') goto yy143;
				goto yy3;
			}
		}
	}
	YYDEBUG(290, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy277;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy277;
			goto yy139;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy284;
			if (yych <= 'Z') goto yy139;
			if (yych <= '^') goto yy277;
			goto yy144;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy277;
				goto yy147;
			} else {
				if (yych <= 'n') goto yy297;
				if (yych <= 'z') goto yy147;
				goto yy277;
			}
		}
	}
yy291:
	YYDEBUG(291, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'J') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy139;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'K') goto yy279;
			if (yych <= 'Z') goto yy139;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'j') {
				if (yych <= '`') goto yy3;
				goto yy147;
			} else {
				if (yych <= 'k') goto yy292;
				if (yych <= 'z') goto yy147;
				goto yy3;
			}
		}
	}
yy292:
	YYDEBUG(292, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy140;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy280;
			if (yych <= 'Z') goto yy140;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy3;
				goto yy148;
			} else {
				if (yych <= 'd') goto yy293;
				if (yych <= 'z') goto yy148;
				goto yy3;
			}
		}
	}
yy293:
	YYDEBUG(293, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy144;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy281;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy294;
			if (yych <= 'z') goto yy149;
			goto yy3;
		}
	}
yy294:
	YYDEBUG(294, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= ',') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy144;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Y') goto yy282;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'y') goto yy295;
			if (yych <= 'z') goto yy150;
			goto yy3;
		}
	}
yy295:
	YYDEBUG(295, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '.') {
			if (yych == '-') goto yy144;
			goto yy277;
		} else {
			if (yych <= '/') goto yy144;
			if (yych <= 'R') goto yy277;
			goto yy283;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy144;
			goto yy277;
		} else {
			if (yych == 's') goto yy296;
			if (yych <= 'z') goto yy150;
			goto yy277;
		}
	}
yy296:
	YYDEBUG(296, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy150;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy144;
		goto yy277;
	} else {
		if (yych <= '/') goto yy144;
		if (yych == '_') goto yy144;
		goto yy277;
	}
yy297:
	YYDEBUG(297, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy140;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy285;
			if (yych <= 'Z') goto yy140;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy148;
			} else {
				if (yych <= 'e') goto yy298;
				if (yych <= 'z') goto yy148;
				goto yy3;
			}
		}
	}
yy298:
	YYDEBUG(298, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy286;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy3;
				goto yy149;
			} else {
				if (yych <= 's') goto yy299;
				if (yych <= 'z') goto yy149;
				goto yy3;
			}
		}
	}
yy299:
	YYDEBUG(299, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= ',') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy144;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'D') goto yy287;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'd') goto yy300;
			if (yych <= 'z') goto yy150;
			goto yy3;
		}
	}
yy300:
	YYDEBUG(300, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy288;
	if (yych != 'a') goto yy151;
	YYDEBUG(301, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy283;
	if (yych == 'y') goto yy296;
	goto yy151;
yy302:
	YYDEBUG(302, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'C') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'B') goto yy138;
		}
	} else {
		if (yych <= 'b') {
			if (yych <= 'Z') goto yy138;
			if (yych <= '`') goto yy3;
			goto yy138;
		} else {
			if (yych <= 'c') goto yy303;
			if (yych <= 'z') goto yy138;
			goto yy3;
		}
	}
yy303:
	YYDEBUG(303, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych >= '\t') goto yy306;
			} else {
				if (yych == ' ') goto yy306;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy136;
			} else {
				if (yych <= '-') goto yy307;
				if (yych <= '.') goto yy306;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy306;
			} else {
				if (yych == 'E') goto yy312;
				goto yy139;
			}
		} else {
			if (yych <= 'd') {
				if (yych >= 'a') goto yy139;
			} else {
				if (yych <= 'e') goto yy312;
				if (yych <= 'z') goto yy139;
			}
		}
	}
yy304:
	YYDEBUG(304, *YYCURSOR);
	{
		DEBUG_OUTPUT("monthtext");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_lookup_month((char **) &ptr);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_TEXT;
	}
yy305:
	YYDEBUG(305, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 20) YYFILL(20);
	yych = *YYCURSOR;
yy306:
	YYDEBUG(306, *YYCURSOR);
	if (yybm[0+yych] & 32) {
		goto yy305;
	}
	if (yych <= '/') goto yy53;
	if (yych <= '2') goto yy308;
	if (yych <= '3') goto yy310;
	if (yych <= '9') goto yy311;
	goto yy53;
yy307:
	YYDEBUG(307, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy306;
	if (yych <= '0') goto yy464;
	if (yych <= '2') goto yy465;
	if (yych <= '3') goto yy466;
	goto yy306;
yy308:
	YYDEBUG(308, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy326;
			if (yych <= '0') goto yy405;
			goto yy406;
		} else {
			if (yych <= '2') goto yy462;
			if (yych <= '9') goto yy463;
			goto yy326;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy322;
			if (yych <= 'q') goto yy326;
			goto yy323;
		} else {
			if (yych <= 's') goto yy321;
			if (yych <= 't') goto yy324;
			goto yy326;
		}
	}
yy309:
	YYDEBUG(309, *YYCURSOR);
	{
		DEBUG_OUTPUT("datetextual | datenoyear");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_TEXT;
	}
yy310:
	YYDEBUG(310, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy326;
			if (yych <= '0') goto yy405;
			goto yy406;
		} else {
			if (yych <= '2') goto yy319;
			if (yych <= '9') goto yy320;
			goto yy326;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy322;
			if (yych <= 'q') goto yy326;
			goto yy323;
		} else {
			if (yych <= 's') goto yy321;
			if (yych <= 't') goto yy324;
			goto yy326;
		}
	}
yy311:
	YYDEBUG(311, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy326;
			if (yych <= '0') goto yy317;
			goto yy318;
		} else {
			if (yych <= '2') goto yy319;
			if (yych <= '9') goto yy320;
			goto yy326;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy322;
			if (yych <= 'q') goto yy326;
			goto yy323;
		} else {
			if (yych <= 's') goto yy321;
			if (yych <= 't') goto yy324;
			goto yy326;
		}
	}
yy312:
	YYDEBUG(312, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'L') goto yy140;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'm') goto yy313;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy313:
	YYDEBUG(313, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'B') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'A') goto yy141;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'b') goto yy314;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy314:
	YYDEBUG(314, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == ')') goto yy136;
		goto yy3;
	} else {
		if (yych <= 'E') goto yy315;
		if (yych != 'e') goto yy3;
	}
yy315:
	YYDEBUG(315, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy316;
	if (yych != 'r') goto yy53;
yy316:
	YYDEBUG(316, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy306;
		if (yych <= 0x1F) goto yy304;
		goto yy306;
	} else {
		if (yych <= '.') {
			if (yych <= ',') goto yy304;
			goto yy306;
		} else {
			if (yych <= '/') goto yy304;
			if (yych <= '9') goto yy306;
			goto yy304;
		}
	}
yy317:
	YYDEBUG(317, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy331;
		goto yy53;
	} else {
		if (yych <= '0') goto yy403;
		if (yych <= '9') goto yy404;
		if (yych <= ':') goto yy331;
		goto yy53;
	}
yy318:
	YYDEBUG(318, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy371;
		goto yy53;
	} else {
		if (yych <= '2') goto yy404;
		if (yych <= '9') goto yy403;
		if (yych <= ':') goto yy371;
		goto yy53;
	}
yy319:
	YYDEBUG(319, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy371;
		goto yy53;
	} else {
		if (yych <= '3') goto yy403;
		if (yych <= '9') goto yy400;
		if (yych <= ':') goto yy371;
		goto yy53;
	}
yy320:
	YYDEBUG(320, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy371;
		goto yy53;
	} else {
		if (yych <= '9') goto yy400;
		if (yych <= ':') goto yy371;
		goto yy53;
	}
yy321:
	YYDEBUG(321, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	goto yy326;
yy322:
	YYDEBUG(322, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	goto yy326;
yy323:
	YYDEBUG(323, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	goto yy326;
yy324:
	YYDEBUG(324, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	goto yy326;
yy325:
	YYDEBUG(325, *YYCURSOR);
	yyaccept = 7;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 17) YYFILL(17);
	yych = *YYCURSOR;
yy326:
	YYDEBUG(326, *YYCURSOR);
	if (yybm[0+yych] & 64) {
		goto yy325;
	}
	if (yych <= '2') {
		if (yych <= '/') goto yy309;
		if (yych <= '0') goto yy366;
		if (yych <= '1') goto yy367;
		goto yy368;
	} else {
		if (yych <= '9') goto yy369;
		if (yych != 'T') goto yy309;
	}
	YYDEBUG(327, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '1') goto yy328;
	if (yych <= '2') goto yy329;
	if (yych <= '9') goto yy330;
	goto yy53;
yy328:
	YYDEBUG(328, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy331;
		goto yy53;
	} else {
		if (yych <= '9') goto yy330;
		if (yych <= ':') goto yy331;
		goto yy53;
	}
yy329:
	YYDEBUG(329, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy331;
		goto yy53;
	} else {
		if (yych <= '3') goto yy330;
		if (yych == ':') goto yy331;
		goto yy53;
	}
yy330:
	YYDEBUG(330, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '.') goto yy331;
	if (yych != ':') goto yy53;
yy331:
	YYDEBUG(331, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy332;
	if (yych <= '9') goto yy334;
	goto yy53;
yy332:
	YYDEBUG(332, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy335;
	} else {
		if (yych <= '9') goto yy334;
		if (yych <= ':') goto yy335;
	}
yy333:
	YYDEBUG(333, *YYCURSOR);
	{
		int tz_not_found;
		DEBUG_OUTPUT("dateshortwithtimeshort | dateshortwithtimelong | dateshortwithtimelongtz");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);

		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':') {
			s->time->s = timelib_get_nr((char **) &ptr, 2);

			if (*ptr == '.') {
				s->time->f = timelib_get_frac_nr((char **) &ptr, 8);
			}
		}

		if (*ptr != '\0') {
			s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
			if (tz_not_found) {
				add_error(s, "The timezone could not be found in the database");
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_SHORTDATE_WITH_TIME;
	}
yy334:
	YYDEBUG(334, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy335;
	if (yych != ':') goto yy333;
yy335:
	YYDEBUG(335, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy336;
	if (yych <= '6') goto yy337;
	if (yych <= '9') goto yy338;
	goto yy53;
yy336:
	YYDEBUG(336, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy333;
	if (yych <= '9') goto yy339;
	goto yy333;
yy337:
	YYDEBUG(337, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy339;
	goto yy333;
yy338:
	YYDEBUG(338, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy333;
yy339:
	YYDEBUG(339, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '*') {
		if (yych <= 0x1F) {
			if (yych != '\t') goto yy333;
		} else {
			if (yych <= ' ') goto yy340;
			if (yych == '(') goto yy343;
			goto yy333;
		}
	} else {
		if (yych <= '@') {
			if (yych == ',') goto yy333;
			if (yych <= '-') goto yy342;
			goto yy333;
		} else {
			if (yych <= 'Z') goto yy344;
			if (yych <= '`') goto yy333;
			if (yych <= 'z') goto yy345;
			goto yy333;
		}
	}
yy340:
	YYDEBUG(340, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 8) YYFILL(8);
	yych = *YYCURSOR;
	YYDEBUG(341, *YYCURSOR);
	if (yych <= '*') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy340;
			goto yy53;
		} else {
			if (yych <= ' ') goto yy340;
			if (yych == '(') goto yy343;
			goto yy53;
		}
	} else {
		if (yych <= '@') {
			if (yych == ',') goto yy53;
			if (yych >= '.') goto yy53;
		} else {
			if (yych <= 'Z') goto yy344;
			if (yych <= '`') goto yy53;
			if (yych <= 'z') goto yy345;
			goto yy53;
		}
	}
yy342:
	YYDEBUG(342, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '1') goto yy361;
	if (yych <= '2') goto yy362;
	if (yych <= '9') goto yy363;
	goto yy53;
yy343:
	YYDEBUG(343, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') goto yy53;
	if (yych <= 'Z') goto yy345;
	if (yych <= '`') goto yy53;
	if (yych <= 'z') goto yy345;
	goto yy53;
yy344:
	YYDEBUG(344, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy338;
		goto yy333;
	} else {
		if (yych <= 'Z') goto yy346;
		if (yych <= '`') goto yy333;
		if (yych <= 'z') goto yy351;
		goto yy333;
	}
yy345:
	YYDEBUG(345, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy338;
		goto yy333;
	} else {
		if (yych <= 'Z') goto yy346;
		if (yych <= '`') goto yy333;
		if (yych >= '{') goto yy333;
	}
yy346:
	YYDEBUG(346, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy338;
		goto yy333;
	} else {
		if (yych <= 'Z') goto yy347;
		if (yych <= '`') goto yy333;
		if (yych >= '{') goto yy333;
	}
yy347:
	YYDEBUG(347, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy338;
		goto yy333;
	} else {
		if (yych <= 'Z') goto yy348;
		if (yych <= '`') goto yy333;
		if (yych >= '{') goto yy333;
	}
yy348:
	YYDEBUG(348, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy338;
		goto yy333;
	} else {
		if (yych <= 'Z') goto yy349;
		if (yych <= '`') goto yy333;
		if (yych >= '{') goto yy333;
	}
yy349:
	YYDEBUG(349, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy338;
		goto yy333;
	} else {
		if (yych <= 'Z') goto yy350;
		if (yych <= '`') goto yy333;
		if (yych >= '{') goto yy333;
	}
yy350:
	YYDEBUG(350, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ')') goto yy338;
	goto yy333;
yy351:
	YYDEBUG(351, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy338;
			goto yy333;
		} else {
			if (yych == '.') goto yy333;
			goto yy353;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy333;
			if (yych <= 'Z') goto yy347;
			goto yy333;
		} else {
			if (yych <= '_') goto yy353;
			if (yych <= '`') goto yy333;
			if (yych >= '{') goto yy333;
		}
	}
yy352:
	YYDEBUG(352, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy338;
			goto yy333;
		} else {
			if (yych == '.') goto yy333;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy333;
			if (yych <= 'Z') goto yy348;
			goto yy333;
		} else {
			if (yych <= '_') goto yy353;
			if (yych <= '`') goto yy333;
			if (yych <= 'z') goto yy356;
			goto yy333;
		}
	}
yy353:
	YYDEBUG(353, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '@') goto yy53;
	if (yych <= 'Z') goto yy354;
	if (yych <= '`') goto yy53;
	if (yych >= '{') goto yy53;
yy354:
	YYDEBUG(354, *YYCURSOR);
	yyaccept = 8;
	YYMARKER = ++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(355, *YYCURSOR);
	if (yych <= '@') {
		if (yych <= '-') {
			if (yych <= ',') goto yy333;
			goto yy353;
		} else {
			if (yych == '/') goto yy353;
			goto yy333;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy354;
			if (yych <= '^') goto yy333;
			goto yy353;
		} else {
			if (yych <= '`') goto yy333;
			if (yych <= 'z') goto yy354;
			goto yy333;
		}
	}
yy356:
	YYDEBUG(356, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy338;
			goto yy333;
		} else {
			if (yych == '.') goto yy333;
			goto yy353;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy333;
			if (yych <= 'Z') goto yy349;
			goto yy333;
		} else {
			if (yych <= '_') goto yy353;
			if (yych <= '`') goto yy333;
			if (yych >= '{') goto yy333;
		}
	}
	YYDEBUG(357, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy338;
			goto yy333;
		} else {
			if (yych == '.') goto yy333;
			goto yy353;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy333;
			if (yych <= 'Z') goto yy350;
			goto yy333;
		} else {
			if (yych <= '_') goto yy353;
			if (yych <= '`') goto yy333;
			if (yych >= '{') goto yy333;
		}
	}
	YYDEBUG(358, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ')') {
			if (yych <= '(') goto yy333;
			goto yy338;
		} else {
			if (yych == '-') goto yy353;
			goto yy333;
		}
	} else {
		if (yych <= '_') {
			if (yych <= '/') goto yy353;
			if (yych <= '^') goto yy333;
			goto yy353;
		} else {
			if (yych <= '`') goto yy333;
			if (yych >= '{') goto yy333;
		}
	}
yy359:
	YYDEBUG(359, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(360, *YYCURSOR);
	if (yych <= '/') {
		if (yych == '-') goto yy353;
		if (yych <= '.') goto yy53;
		goto yy353;
	} else {
		if (yych <= '_') {
			if (yych <= '^') goto yy53;
			goto yy353;
		} else {
			if (yych <= '`') goto yy53;
			if (yych <= 'z') goto yy359;
			goto yy53;
		}
	}
yy361:
	YYDEBUG(361, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy333;
	if (yych <= '9') goto yy363;
	if (yych <= ':') goto yy364;
	goto yy333;
yy362:
	YYDEBUG(362, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy333;
		if (yych >= '4') goto yy365;
	} else {
		if (yych <= '9') goto yy338;
		if (yych <= ':') goto yy364;
		goto yy333;
	}
yy363:
	YYDEBUG(363, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy333;
	if (yych <= '5') goto yy365;
	if (yych <= '9') goto yy338;
	if (yych >= ';') goto yy333;
yy364:
	YYDEBUG(364, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy333;
	if (yych <= '5') goto yy365;
	if (yych <= '9') goto yy338;
	goto yy333;
yy365:
	YYDEBUG(365, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy333;
	if (yych <= '9') goto yy338;
	goto yy333;
yy366:
	YYDEBUG(366, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy331;
		goto yy309;
	} else {
		if (yych <= '0') goto yy398;
		if (yych <= '9') goto yy399;
		if (yych <= ':') goto yy331;
		goto yy309;
	}
yy367:
	YYDEBUG(367, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy371;
		goto yy309;
	} else {
		if (yych <= '2') goto yy399;
		if (yych <= '9') goto yy398;
		if (yych <= ':') goto yy371;
		goto yy309;
	}
yy368:
	YYDEBUG(368, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy371;
		goto yy309;
	} else {
		if (yych <= '3') goto yy398;
		if (yych <= '9') goto yy370;
		if (yych <= ':') goto yy371;
		goto yy309;
	}
yy369:
	YYDEBUG(369, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy371;
		goto yy309;
	} else {
		if (yych <= '9') goto yy370;
		if (yych <= ':') goto yy371;
		goto yy309;
	}
yy370:
	YYDEBUG(370, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy309;
	if (yych <= '9') goto yy396;
	goto yy309;
yy371:
	YYDEBUG(371, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy372;
	if (yych <= '9') goto yy373;
	goto yy53;
yy372:
	YYDEBUG(372, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy374;
		goto yy333;
	} else {
		if (yych <= '9') goto yy389;
		if (yych <= ':') goto yy374;
		goto yy333;
	}
yy373:
	YYDEBUG(373, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy374;
	if (yych != ':') goto yy333;
yy374:
	YYDEBUG(374, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy375;
	if (yych <= '6') goto yy376;
	if (yych <= '9') goto yy338;
	goto yy53;
yy375:
	YYDEBUG(375, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy333;
	if (yych <= '9') goto yy377;
	goto yy333;
yy376:
	YYDEBUG(376, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '0') goto yy333;
yy377:
	YYDEBUG(377, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '*') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy379;
			goto yy333;
		} else {
			if (yych <= ' ') goto yy379;
			if (yych == '(') goto yy379;
			goto yy333;
		}
	} else {
		if (yych <= '@') {
			if (yych == ',') goto yy333;
			if (yych <= '-') goto yy379;
			goto yy333;
		} else {
			if (yych <= 'Z') goto yy379;
			if (yych <= '`') goto yy333;
			if (yych <= 'z') goto yy379;
			goto yy333;
		}
	}
yy378:
	YYDEBUG(378, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 8) YYFILL(8);
	yych = *YYCURSOR;
yy379:
	YYDEBUG(379, *YYCURSOR);
	if (yych <= '-') {
		if (yych <= '\'') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy53;
				goto yy378;
			} else {
				if (yych == ' ') goto yy378;
				goto yy53;
			}
		} else {
			if (yych <= '*') {
				if (yych <= '(') goto yy343;
				goto yy53;
			} else {
				if (yych == ',') goto yy53;
				goto yy342;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= 'A') {
				if (yych <= '@') goto yy53;
			} else {
				if (yych != 'P') goto yy344;
			}
		} else {
			if (yych <= 'o') {
				if (yych <= '`') goto yy53;
				if (yych <= 'a') goto yy381;
				goto yy345;
			} else {
				if (yych <= 'p') goto yy381;
				if (yych <= 'z') goto yy345;
				goto yy53;
			}
		}
	}
	YYDEBUG(380, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy338;
			goto yy333;
		} else {
			if (yych <= '.') goto yy382;
			if (yych <= '@') goto yy333;
			goto yy346;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'M') goto yy383;
			if (yych <= 'Z') goto yy346;
			goto yy333;
		} else {
			if (yych == 'm') goto yy388;
			if (yych <= 'z') goto yy351;
			goto yy333;
		}
	}
yy381:
	YYDEBUG(381, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy338;
			goto yy333;
		} else {
			if (yych <= '.') goto yy382;
			if (yych <= '@') goto yy333;
			goto yy346;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'M') goto yy383;
			if (yych <= 'Z') goto yy346;
			goto yy333;
		} else {
			if (yych == 'm') goto yy383;
			if (yych <= 'z') goto yy346;
			goto yy333;
		}
	}
yy382:
	YYDEBUG(382, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy387;
	if (yych == 'm') goto yy387;
	goto yy53;
yy383:
	YYDEBUG(383, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ')') {
		if (yych <= '\t') {
			if (yych <= 0x00) goto yy385;
			if (yych <= 0x08) goto yy333;
			goto yy385;
		} else {
			if (yych == ' ') goto yy385;
			if (yych <= '(') goto yy333;
			goto yy338;
		}
	} else {
		if (yych <= '@') {
			if (yych != '.') goto yy333;
		} else {
			if (yych <= 'Z') goto yy347;
			if (yych <= '`') goto yy333;
			if (yych <= 'z') goto yy347;
			goto yy333;
		}
	}
yy384:
	YYDEBUG(384, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy385;
		if (yych <= 0x08) goto yy53;
	} else {
		if (yych != ' ') goto yy53;
	}
yy385:
	YYDEBUG(385, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(386, *YYCURSOR);
	{
		DEBUG_OUTPUT("dateshortwithtimeshort12 | dateshortwithtimelong12");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);

		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->s = timelib_get_nr((char **) &ptr, 2);

			if (*ptr == '.') {
				s->time->f = timelib_get_frac_nr((char **) &ptr, 8);
			}
		}

		s->time->h += timelib_meridian((char **) &ptr, s->time->h);
		TIMELIB_DEINIT;
		return TIMELIB_SHORTDATE_WITH_TIME;
	}
yy387:
	YYDEBUG(387, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy385;
		if (yych == '\t') goto yy385;
		goto yy53;
	} else {
		if (yych <= ' ') goto yy385;
		if (yych == '.') goto yy384;
		goto yy53;
	}
yy388:
	YYDEBUG(388, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= 0x1F) {
			if (yych <= 0x00) goto yy385;
			if (yych == '\t') goto yy385;
			goto yy333;
		} else {
			if (yych <= '(') {
				if (yych <= ' ') goto yy385;
				goto yy333;
			} else {
				if (yych <= ')') goto yy338;
				if (yych <= ',') goto yy333;
				goto yy353;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '.') goto yy384;
			if (yych <= '/') goto yy353;
			if (yych <= '@') goto yy333;
			goto yy347;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy333;
				goto yy353;
			} else {
				if (yych <= '`') goto yy333;
				if (yych <= 'z') goto yy352;
				goto yy333;
			}
		}
	}
yy389:
	YYDEBUG(389, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy390;
			if (yych <= 0x1F) goto yy333;
		} else {
			if (yych == '.') goto yy374;
			if (yych <= '9') goto yy333;
			goto yy374;
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy392;
			if (yych <= 'O') goto yy333;
			goto yy392;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy333;
				goto yy392;
			} else {
				if (yych == 'p') goto yy392;
				goto yy333;
			}
		}
	}
yy390:
	YYDEBUG(390, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	YYDEBUG(391, *YYCURSOR);
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy390;
			goto yy53;
		} else {
			if (yych <= ' ') goto yy390;
			if (yych <= '@') goto yy53;
		}
	} else {
		if (yych <= '`') {
			if (yych != 'P') goto yy53;
		} else {
			if (yych <= 'a') goto yy392;
			if (yych != 'p') goto yy53;
		}
	}
yy392:
	YYDEBUG(392, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych != '.') goto yy53;
	} else {
		if (yych <= 'M') goto yy394;
		if (yych == 'm') goto yy394;
		goto yy53;
	}
yy393:
	YYDEBUG(393, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy394;
	if (yych != 'm') goto yy53;
yy394:
	YYDEBUG(394, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy385;
		if (yych == '\t') goto yy385;
		goto yy53;
	} else {
		if (yych <= ' ') goto yy385;
		if (yych != '.') goto yy53;
	}
yy395:
	YYDEBUG(395, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy385;
		if (yych <= 0x08) goto yy53;
		goto yy385;
	} else {
		if (yych == ' ') goto yy385;
		goto yy53;
	}
yy396:
	YYDEBUG(396, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy309;
	if (yych >= ':') goto yy309;
	YYDEBUG(397, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy309;
yy398:
	YYDEBUG(398, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy331;
		goto yy309;
	} else {
		if (yych <= '9') goto yy396;
		if (yych <= ':') goto yy331;
		goto yy309;
	}
yy399:
	YYDEBUG(399, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy371;
		goto yy309;
	} else {
		if (yych <= '9') goto yy396;
		if (yych <= ':') goto yy371;
		goto yy309;
	}
yy400:
	YYDEBUG(400, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= ':') goto yy53;
yy401:
	YYDEBUG(401, *YYCURSOR);
	++YYCURSOR;
yy402:
	YYDEBUG(402, *YYCURSOR);
	{
		DEBUG_OUTPUT("datenoday");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->d = 1;
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NO_DAY;
	}
yy403:
	YYDEBUG(403, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy331;
		goto yy53;
	} else {
		if (yych <= '9') goto yy401;
		if (yych <= ':') goto yy331;
		goto yy53;
	}
yy404:
	YYDEBUG(404, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy371;
		goto yy53;
	} else {
		if (yych <= '9') goto yy401;
		if (yych <= ':') goto yy371;
		goto yy53;
	}
yy405:
	YYDEBUG(405, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '/') {
			if (yych == '.') goto yy438;
			goto yy326;
		} else {
			if (yych <= '0') goto yy439;
			if (yych <= '1') goto yy409;
			if (yych <= '2') goto yy410;
			goto yy404;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy331;
			if (yych == 'n') goto yy322;
			goto yy326;
		} else {
			if (yych <= 'r') goto yy323;
			if (yych <= 's') goto yy321;
			if (yych <= 't') goto yy324;
			goto yy326;
		}
	}
yy406:
	YYDEBUG(406, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '/') {
			if (yych != '.') goto yy326;
		} else {
			if (yych <= '0') goto yy408;
			if (yych <= '1') goto yy409;
			if (yych <= '2') goto yy410;
			goto yy404;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy371;
			if (yych == 'n') goto yy322;
			goto yy326;
		} else {
			if (yych <= 'r') goto yy323;
			if (yych <= 's') goto yy321;
			if (yych <= 't') goto yy324;
			goto yy326;
		}
	}
yy407:
	YYDEBUG(407, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '1') {
		if (yych <= '/') goto yy326;
		if (yych <= '0') goto yy413;
		goto yy414;
	} else {
		if (yych <= '2') goto yy415;
		if (yych <= '5') goto yy416;
		if (yych <= '9') goto yy417;
		goto yy326;
	}
yy408:
	YYDEBUG(408, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy371;
		goto yy53;
	} else {
		if (yych <= '0') goto yy411;
		if (yych <= '9') goto yy412;
		if (yych <= ':') goto yy371;
		goto yy53;
	}
yy409:
	YYDEBUG(409, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy371;
		goto yy53;
	} else {
		if (yych <= '2') goto yy412;
		if (yych <= '9') goto yy411;
		if (yych <= ':') goto yy371;
		goto yy53;
	}
yy410:
	YYDEBUG(410, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy371;
		goto yy53;
	} else {
		if (yych <= '3') goto yy411;
		if (yych <= '9') goto yy401;
		if (yych <= ':') goto yy371;
		goto yy53;
	}
yy411:
	YYDEBUG(411, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy331;
	if (yych == ':') goto yy331;
	goto yy402;
yy412:
	YYDEBUG(412, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy371;
	if (yych == ':') goto yy371;
	goto yy402;
yy413:
	YYDEBUG(413, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy433;
		goto yy309;
	} else {
		if (yych <= '0') goto yy432;
		if (yych <= '9') goto yy437;
		if (yych <= ':') goto yy433;
		goto yy309;
	}
yy414:
	YYDEBUG(414, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy418;
		goto yy309;
	} else {
		if (yych <= '2') goto yy437;
		if (yych <= '9') goto yy432;
		if (yych <= ':') goto yy418;
		goto yy309;
	}
yy415:
	YYDEBUG(415, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy418;
		goto yy309;
	} else {
		if (yych <= '3') goto yy432;
		if (yych <= '9') goto yy431;
		if (yych <= ':') goto yy418;
		goto yy309;
	}
yy416:
	YYDEBUG(416, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy418;
		goto yy309;
	} else {
		if (yych <= '9') goto yy431;
		if (yych <= ':') goto yy418;
		goto yy309;
	}
yy417:
	YYDEBUG(417, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych != '.') goto yy309;
	} else {
		if (yych <= '9') goto yy370;
		if (yych >= ';') goto yy309;
	}
yy418:
	YYDEBUG(418, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy419;
	if (yych <= '6') goto yy420;
	if (yych <= '9') goto yy373;
	goto yy53;
yy419:
	YYDEBUG(419, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy374;
		goto yy333;
	} else {
		if (yych <= '9') goto yy421;
		if (yych <= ':') goto yy374;
		goto yy333;
	}
yy420:
	YYDEBUG(420, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy374;
		goto yy333;
	} else {
		if (yych <= '0') goto yy377;
		if (yych == ':') goto yy374;
		goto yy333;
	}
yy421:
	YYDEBUG(421, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy423;
			if (yych <= 0x1F) goto yy333;
			goto yy423;
		} else {
			if (yych <= '(') {
				if (yych <= '\'') goto yy333;
				goto yy423;
			} else {
				if (yych == '+') goto yy423;
				goto yy333;
			}
		}
	} else {
		if (yych <= ':') {
			if (yych <= '-') goto yy423;
			if (yych <= '.') goto yy374;
			if (yych <= '9') goto yy333;
			goto yy374;
		} else {
			if (yych <= 'Z') {
				if (yych <= '@') goto yy333;
				goto yy423;
			} else {
				if (yych <= '`') goto yy333;
				if (yych <= 'z') goto yy423;
				goto yy333;
			}
		}
	}
yy422:
	YYDEBUG(422, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 8) YYFILL(8);
	yych = *YYCURSOR;
yy423:
	YYDEBUG(423, *YYCURSOR);
	if (yych <= '-') {
		if (yych <= '\'') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy53;
				goto yy422;
			} else {
				if (yych == ' ') goto yy422;
				goto yy53;
			}
		} else {
			if (yych <= '*') {
				if (yych <= '(') goto yy343;
				goto yy53;
			} else {
				if (yych == ',') goto yy53;
				goto yy342;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= 'A') {
				if (yych <= '@') goto yy53;
			} else {
				if (yych != 'P') goto yy344;
			}
		} else {
			if (yych <= 'o') {
				if (yych <= '`') goto yy53;
				if (yych <= 'a') goto yy425;
				goto yy345;
			} else {
				if (yych <= 'p') goto yy425;
				if (yych <= 'z') goto yy345;
				goto yy53;
			}
		}
	}
	YYDEBUG(424, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy338;
			goto yy333;
		} else {
			if (yych <= '.') goto yy427;
			if (yych <= '@') goto yy333;
			goto yy346;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'M') goto yy426;
			if (yych <= 'Z') goto yy346;
			goto yy333;
		} else {
			if (yych == 'm') goto yy430;
			if (yych <= 'z') goto yy351;
			goto yy333;
		}
	}
yy425:
	YYDEBUG(425, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy338;
			goto yy333;
		} else {
			if (yych <= '.') goto yy427;
			if (yych <= '@') goto yy333;
			goto yy346;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'M') goto yy426;
			if (yych <= 'Z') goto yy346;
			goto yy333;
		} else {
			if (yych == 'm') goto yy426;
			if (yych <= 'z') goto yy346;
			goto yy333;
		}
	}
yy426:
	YYDEBUG(426, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ')') {
		if (yych <= '\t') {
			if (yych <= 0x00) goto yy385;
			if (yych <= 0x08) goto yy333;
			goto yy385;
		} else {
			if (yych == ' ') goto yy385;
			if (yych <= '(') goto yy333;
			goto yy338;
		}
	} else {
		if (yych <= '@') {
			if (yych == '.') goto yy429;
			goto yy333;
		} else {
			if (yych <= 'Z') goto yy347;
			if (yych <= '`') goto yy333;
			if (yych <= 'z') goto yy347;
			goto yy333;
		}
	}
yy427:
	YYDEBUG(427, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy428;
	if (yych != 'm') goto yy53;
yy428:
	YYDEBUG(428, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy385;
		if (yych == '\t') goto yy385;
		goto yy53;
	} else {
		if (yych <= ' ') goto yy385;
		if (yych != '.') goto yy53;
	}
yy429:
	YYDEBUG(429, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy385;
		if (yych <= 0x08) goto yy53;
		goto yy385;
	} else {
		if (yych == ' ') goto yy385;
		goto yy53;
	}
yy430:
	YYDEBUG(430, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= 0x1F) {
			if (yych <= 0x00) goto yy385;
			if (yych == '\t') goto yy385;
			goto yy333;
		} else {
			if (yych <= '(') {
				if (yych <= ' ') goto yy385;
				goto yy333;
			} else {
				if (yych <= ')') goto yy338;
				if (yych <= ',') goto yy333;
				goto yy353;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '.') goto yy429;
			if (yych <= '/') goto yy353;
			if (yych <= '@') goto yy333;
			goto yy347;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy333;
				goto yy353;
			} else {
				if (yych <= '`') goto yy333;
				if (yych <= 'z') goto yy352;
				goto yy333;
			}
		}
	}
yy431:
	YYDEBUG(431, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy390;
			if (yych <= 0x1F) goto yy309;
			goto yy390;
		} else {
			if (yych <= '.') {
				if (yych <= '-') goto yy309;
				goto yy374;
			} else {
				if (yych <= '/') goto yy309;
				if (yych <= '9') goto yy396;
				goto yy374;
			}
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy392;
			if (yych <= 'O') goto yy309;
			goto yy392;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy309;
				goto yy392;
			} else {
				if (yych == 'p') goto yy392;
				goto yy309;
			}
		}
	}
yy432:
	YYDEBUG(432, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy390;
			if (yych <= 0x1F) goto yy309;
			goto yy390;
		} else {
			if (yych <= '.') {
				if (yych <= '-') goto yy309;
			} else {
				if (yych <= '/') goto yy309;
				if (yych <= '9') goto yy396;
			}
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy392;
			if (yych <= 'O') goto yy309;
			goto yy392;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy309;
				goto yy392;
			} else {
				if (yych == 'p') goto yy392;
				goto yy309;
			}
		}
	}
yy433:
	YYDEBUG(433, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy434;
	if (yych <= '6') goto yy435;
	if (yych <= '9') goto yy334;
	goto yy53;
yy434:
	YYDEBUG(434, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy335;
		goto yy333;
	} else {
		if (yych <= '9') goto yy436;
		if (yych <= ':') goto yy335;
		goto yy333;
	}
yy435:
	YYDEBUG(435, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy335;
		goto yy333;
	} else {
		if (yych <= '0') goto yy377;
		if (yych == ':') goto yy335;
		goto yy333;
	}
yy436:
	YYDEBUG(436, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy379;
			if (yych <= 0x1F) goto yy333;
			goto yy379;
		} else {
			if (yych <= '(') {
				if (yych <= '\'') goto yy333;
				goto yy379;
			} else {
				if (yych == '+') goto yy379;
				goto yy333;
			}
		}
	} else {
		if (yych <= ':') {
			if (yych <= '-') goto yy379;
			if (yych <= '.') goto yy335;
			if (yych <= '9') goto yy333;
			goto yy335;
		} else {
			if (yych <= 'Z') {
				if (yych <= '@') goto yy333;
				goto yy379;
			} else {
				if (yych <= '`') goto yy333;
				if (yych <= 'z') goto yy379;
				goto yy333;
			}
		}
	}
yy437:
	YYDEBUG(437, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy390;
			if (yych <= 0x1F) goto yy309;
			goto yy390;
		} else {
			if (yych <= '.') {
				if (yych <= '-') goto yy309;
				goto yy418;
			} else {
				if (yych <= '/') goto yy309;
				if (yych <= '9') goto yy396;
				goto yy418;
			}
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy392;
			if (yych <= 'O') goto yy309;
			goto yy392;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy309;
				goto yy392;
			} else {
				if (yych == 'p') goto yy392;
				goto yy309;
			}
		}
	}
yy438:
	YYDEBUG(438, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '1') {
		if (yych <= '/') goto yy326;
		if (yych <= '0') goto yy440;
		goto yy441;
	} else {
		if (yych <= '2') goto yy442;
		if (yych <= '5') goto yy443;
		if (yych <= '9') goto yy444;
		goto yy326;
	}
yy439:
	YYDEBUG(439, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy331;
		goto yy53;
	} else {
		if (yych <= '0') goto yy411;
		if (yych <= '9') goto yy412;
		if (yych <= ':') goto yy331;
		goto yy53;
	}
yy440:
	YYDEBUG(440, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy457;
		goto yy309;
	} else {
		if (yych <= '0') goto yy456;
		if (yych <= '9') goto yy461;
		if (yych <= ':') goto yy457;
		goto yy309;
	}
yy441:
	YYDEBUG(441, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy445;
		goto yy309;
	} else {
		if (yych <= '2') goto yy461;
		if (yych <= '9') goto yy456;
		if (yych <= ':') goto yy445;
		goto yy309;
	}
yy442:
	YYDEBUG(442, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy445;
		goto yy309;
	} else {
		if (yych <= '3') goto yy456;
		if (yych <= '9') goto yy455;
		if (yych <= ':') goto yy445;
		goto yy309;
	}
yy443:
	YYDEBUG(443, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy445;
		goto yy309;
	} else {
		if (yych <= '9') goto yy455;
		if (yych <= ':') goto yy445;
		goto yy309;
	}
yy444:
	YYDEBUG(444, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych != '.') goto yy309;
	} else {
		if (yych <= '9') goto yy370;
		if (yych >= ';') goto yy309;
	}
yy445:
	YYDEBUG(445, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy446;
	if (yych <= '6') goto yy447;
	if (yych <= '9') goto yy373;
	goto yy53;
yy446:
	YYDEBUG(446, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy374;
		goto yy333;
	} else {
		if (yych <= '9') goto yy448;
		if (yych <= ':') goto yy374;
		goto yy333;
	}
yy447:
	YYDEBUG(447, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy374;
		goto yy333;
	} else {
		if (yych <= '0') goto yy339;
		if (yych == ':') goto yy374;
		goto yy333;
	}
yy448:
	YYDEBUG(448, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy450;
			if (yych <= 0x1F) goto yy333;
			goto yy450;
		} else {
			if (yych <= '(') {
				if (yych <= '\'') goto yy333;
				goto yy450;
			} else {
				if (yych == '+') goto yy450;
				goto yy333;
			}
		}
	} else {
		if (yych <= ':') {
			if (yych <= '-') goto yy450;
			if (yych <= '.') goto yy374;
			if (yych <= '9') goto yy333;
			goto yy374;
		} else {
			if (yych <= 'Z') {
				if (yych <= '@') goto yy333;
				goto yy450;
			} else {
				if (yych <= '`') goto yy333;
				if (yych <= 'z') goto yy450;
				goto yy333;
			}
		}
	}
yy449:
	YYDEBUG(449, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 8) YYFILL(8);
	yych = *YYCURSOR;
yy450:
	YYDEBUG(450, *YYCURSOR);
	if (yych <= '-') {
		if (yych <= '\'') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy53;
				goto yy449;
			} else {
				if (yych == ' ') goto yy449;
				goto yy53;
			}
		} else {
			if (yych <= '*') {
				if (yych <= '(') goto yy343;
				goto yy53;
			} else {
				if (yych == ',') goto yy53;
				goto yy342;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= 'A') {
				if (yych <= '@') goto yy53;
			} else {
				if (yych != 'P') goto yy344;
			}
		} else {
			if (yych <= 'o') {
				if (yych <= '`') goto yy53;
				if (yych <= 'a') goto yy452;
				goto yy345;
			} else {
				if (yych <= 'p') goto yy452;
				if (yych <= 'z') goto yy345;
				goto yy53;
			}
		}
	}
	YYDEBUG(451, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy338;
			goto yy333;
		} else {
			if (yych <= '.') goto yy393;
			if (yych <= '@') goto yy333;
			goto yy346;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'M') goto yy453;
			if (yych <= 'Z') goto yy346;
			goto yy333;
		} else {
			if (yych == 'm') goto yy454;
			if (yych <= 'z') goto yy351;
			goto yy333;
		}
	}
yy452:
	YYDEBUG(452, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy338;
			goto yy333;
		} else {
			if (yych <= '.') goto yy393;
			if (yych <= '@') goto yy333;
			goto yy346;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'M') goto yy453;
			if (yych <= 'Z') goto yy346;
			goto yy333;
		} else {
			if (yych == 'm') goto yy453;
			if (yych <= 'z') goto yy346;
			goto yy333;
		}
	}
yy453:
	YYDEBUG(453, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ')') {
		if (yych <= '\t') {
			if (yych <= 0x00) goto yy385;
			if (yych <= 0x08) goto yy333;
			goto yy385;
		} else {
			if (yych == ' ') goto yy385;
			if (yych <= '(') goto yy333;
			goto yy338;
		}
	} else {
		if (yych <= '@') {
			if (yych == '.') goto yy395;
			goto yy333;
		} else {
			if (yych <= 'Z') goto yy347;
			if (yych <= '`') goto yy333;
			if (yych <= 'z') goto yy347;
			goto yy333;
		}
	}
yy454:
	YYDEBUG(454, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= 0x1F) {
			if (yych <= 0x00) goto yy385;
			if (yych == '\t') goto yy385;
			goto yy333;
		} else {
			if (yych <= '(') {
				if (yych <= ' ') goto yy385;
				goto yy333;
			} else {
				if (yych <= ')') goto yy338;
				if (yych <= ',') goto yy333;
				goto yy353;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '.') goto yy395;
			if (yych <= '/') goto yy353;
			if (yych <= '@') goto yy333;
			goto yy347;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy333;
				goto yy353;
			} else {
				if (yych <= '`') goto yy333;
				if (yych <= 'z') goto yy352;
				goto yy333;
			}
		}
	}
yy455:
	YYDEBUG(455, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy335;
		goto yy309;
	} else {
		if (yych <= '9') goto yy396;
		if (yych <= ':') goto yy335;
		goto yy309;
	}
yy456:
	YYDEBUG(456, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych != '.') goto yy309;
	} else {
		if (yych <= '9') goto yy396;
		if (yych >= ';') goto yy309;
	}
yy457:
	YYDEBUG(457, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy458;
	if (yych <= '6') goto yy459;
	if (yych <= '9') goto yy334;
	goto yy53;
yy458:
	YYDEBUG(458, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy335;
		goto yy333;
	} else {
		if (yych <= '9') goto yy460;
		if (yych <= ':') goto yy335;
		goto yy333;
	}
yy459:
	YYDEBUG(459, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy335;
		goto yy333;
	} else {
		if (yych <= '0') goto yy339;
		if (yych == ':') goto yy335;
		goto yy333;
	}
yy460:
	YYDEBUG(460, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy340;
			if (yych <= 0x1F) goto yy333;
			goto yy340;
		} else {
			if (yych <= '(') {
				if (yych <= '\'') goto yy333;
				goto yy343;
			} else {
				if (yych == '+') goto yy342;
				goto yy333;
			}
		}
	} else {
		if (yych <= ':') {
			if (yych <= '-') goto yy342;
			if (yych <= '.') goto yy335;
			if (yych <= '9') goto yy333;
			goto yy335;
		} else {
			if (yych <= 'Z') {
				if (yych <= '@') goto yy333;
				goto yy344;
			} else {
				if (yych <= '`') goto yy333;
				if (yych <= 'z') goto yy345;
				goto yy333;
			}
		}
	}
yy461:
	YYDEBUG(461, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy445;
		goto yy309;
	} else {
		if (yych <= '9') goto yy396;
		if (yych <= ':') goto yy445;
		goto yy309;
	}
yy462:
	YYDEBUG(462, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '/') {
			if (yych == '.') goto yy407;
			goto yy326;
		} else {
			if (yych <= '0') goto yy439;
			if (yych <= '1') goto yy409;
			if (yych <= '2') goto yy410;
			goto yy404;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy371;
			if (yych == 'n') goto yy322;
			goto yy326;
		} else {
			if (yych <= 'r') goto yy323;
			if (yych <= 's') goto yy321;
			if (yych <= 't') goto yy324;
			goto yy326;
		}
	}
yy463:
	YYDEBUG(463, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '/') {
			if (yych == '.') goto yy407;
			goto yy326;
		} else {
			if (yych <= '0') goto yy439;
			if (yych <= '1') goto yy409;
			if (yych <= '2') goto yy410;
			goto yy404;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy371;
			if (yych == 'n') goto yy322;
			goto yy326;
		} else {
			if (yych <= 'r') goto yy323;
			if (yych <= 's') goto yy321;
			if (yych <= 't') goto yy324;
			goto yy326;
		}
	}
yy464:
	YYDEBUG(464, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy326;
			if (yych <= '0') goto yy467;
			goto yy468;
		} else {
			if (yych <= '2') goto yy475;
			if (yych <= '9') goto yy476;
			goto yy326;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy322;
			if (yych <= 'q') goto yy326;
			goto yy323;
		} else {
			if (yych <= 's') goto yy321;
			if (yych <= 't') goto yy324;
			goto yy326;
		}
	}
yy465:
	YYDEBUG(465, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy326;
			if (yych <= '0') goto yy467;
			goto yy468;
		} else {
			if (yych <= '2') goto yy475;
			if (yych <= '9') goto yy476;
			goto yy326;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy322;
			if (yych <= 'q') goto yy326;
			goto yy323;
		} else {
			if (yych <= 's') goto yy321;
			if (yych <= 't') goto yy324;
			goto yy326;
		}
	}
yy466:
	YYDEBUG(466, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy326;
			if (yych >= '1') goto yy468;
		} else {
			if (yych <= '2') goto yy319;
			if (yych <= '9') goto yy320;
			goto yy326;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy322;
			if (yych <= 'q') goto yy326;
			goto yy323;
		} else {
			if (yych <= 's') goto yy321;
			if (yych <= 't') goto yy324;
			goto yy326;
		}
	}
yy467:
	YYDEBUG(467, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '/') {
			if (yych <= ',') goto yy326;
			if (yych <= '-') goto yy469;
			if (yych <= '.') goto yy438;
			goto yy326;
		} else {
			if (yych <= '0') goto yy439;
			if (yych <= '1') goto yy409;
			if (yych <= '2') goto yy410;
			goto yy404;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy331;
			if (yych == 'n') goto yy322;
			goto yy326;
		} else {
			if (yych <= 'r') goto yy323;
			if (yych <= 's') goto yy321;
			if (yych <= 't') goto yy324;
			goto yy326;
		}
	}
yy468:
	YYDEBUG(468, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '/') {
			if (yych <= ',') goto yy326;
			if (yych <= '-') goto yy469;
			if (yych <= '.') goto yy407;
			goto yy326;
		} else {
			if (yych <= '0') goto yy408;
			if (yych <= '1') goto yy409;
			if (yych <= '2') goto yy410;
			goto yy404;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy371;
			if (yych == 'n') goto yy322;
			goto yy326;
		} else {
			if (yych <= 'r') goto yy323;
			if (yych <= 's') goto yy321;
			if (yych <= 't') goto yy324;
			goto yy326;
		}
	}
yy469:
	YYDEBUG(469, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= ':') goto yy53;
	YYDEBUG(470, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '/') goto yy471;
	if (yych <= '9') goto yy472;
yy471:
	YYDEBUG(471, *YYCURSOR);
	{
		DEBUG_OUTPUT("pgtextshort");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_PG_TEXT;
	}
yy472:
	YYDEBUG(472, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy471;
	if (yych >= ':') goto yy471;
	YYDEBUG(473, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy471;
	if (yych >= ':') goto yy471;
	YYDEBUG(474, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy471;
yy475:
	YYDEBUG(475, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '/') {
			if (yych <= ',') goto yy326;
			if (yych <= '-') goto yy469;
			if (yych <= '.') goto yy407;
			goto yy326;
		} else {
			if (yych <= '0') goto yy439;
			if (yych <= '1') goto yy409;
			if (yych <= '2') goto yy410;
			goto yy404;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy371;
			if (yych == 'n') goto yy322;
			goto yy326;
		} else {
			if (yych <= 'r') goto yy323;
			if (yych <= 's') goto yy321;
			if (yych <= 't') goto yy324;
			goto yy326;
		}
	}
yy476:
	YYDEBUG(476, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '/') {
			if (yych <= ',') goto yy326;
			if (yych <= '-') goto yy469;
			if (yych <= '.') goto yy407;
			goto yy326;
		} else {
			if (yych <= '0') goto yy439;
			if (yych <= '1') goto yy409;
			if (yych <= '2') goto yy410;
			goto yy404;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy371;
			if (yych == 'n') goto yy322;
			goto yy326;
		} else {
			if (yych <= 'r') goto yy323;
			if (yych <= 's') goto yy321;
			if (yych <= 't') goto yy324;
			goto yy326;
		}
	}
yy477:
	YYDEBUG(477, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'B') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy138;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'C') goto yy303;
			if (yych <= 'Z') goto yy138;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'b') {
				if (yych <= '`') goto yy3;
				goto yy143;
			} else {
				if (yych <= 'c') goto yy478;
				if (yych <= 'z') goto yy143;
				goto yy3;
			}
		}
	}
yy478:
	YYDEBUG(478, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy304;
				goto yy306;
			} else {
				if (yych == ' ') goto yy306;
				goto yy304;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy136;
				if (yych <= ',') goto yy304;
			} else {
				if (yych == '/') goto yy144;
				goto yy306;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'D') {
				if (yych <= '@') goto yy304;
				goto yy139;
			} else {
				if (yych <= 'E') goto yy312;
				if (yych <= 'Z') goto yy139;
				goto yy304;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '_') goto yy144;
				if (yych <= '`') goto yy304;
				goto yy147;
			} else {
				if (yych <= 'e') goto yy480;
				if (yych <= 'z') goto yy147;
				goto yy304;
			}
		}
	}
yy479:
	YYDEBUG(479, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm[0+yych] & 8) {
		goto yy145;
	}
	if (yych <= '/') goto yy306;
	if (yych <= '0') goto yy464;
	if (yych <= '2') goto yy465;
	if (yych <= '3') goto yy466;
	goto yy306;
yy480:
	YYDEBUG(480, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy140;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'M') goto yy313;
			if (yych <= 'Z') goto yy140;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'l') {
				if (yych <= '`') goto yy3;
				goto yy148;
			} else {
				if (yych <= 'm') goto yy481;
				if (yych <= 'z') goto yy148;
				goto yy3;
			}
		}
	}
yy481:
	YYDEBUG(481, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'B') goto yy314;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy3;
				goto yy149;
			} else {
				if (yych <= 'b') goto yy482;
				if (yych <= 'z') goto yy149;
				goto yy3;
			}
		}
	}
yy482:
	YYDEBUG(482, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= ',') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy144;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'E') goto yy315;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'e') goto yy483;
			if (yych <= 'z') goto yy150;
			goto yy3;
		}
	}
yy483:
	YYDEBUG(483, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy316;
	if (yych != 'r') goto yy151;
yy484:
	YYDEBUG(484, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy150;
	}
	if (yych <= '-') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy306;
			goto yy304;
		} else {
			if (yych <= ' ') goto yy306;
			if (yych <= ',') goto yy304;
		}
	} else {
		if (yych <= '9') {
			if (yych == '/') goto yy144;
			goto yy306;
		} else {
			if (yych == '_') goto yy144;
			goto yy304;
		}
	}
yy485:
	YYDEBUG(485, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm[0+yych] & 8) {
		goto yy145;
	}
	goto yy306;
yy486:
	YYDEBUG(486, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy138;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy138;
			if (yych <= '`') goto yy3;
			goto yy138;
		} else {
			if (yych <= 't') goto yy487;
			if (yych <= 'z') goto yy138;
			goto yy3;
		}
	}
yy487:
	YYDEBUG(487, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy304;
				goto yy306;
			} else {
				if (yych == ' ') goto yy306;
				goto yy304;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy136;
				goto yy304;
			} else {
				if (yych <= '-') goto yy307;
				if (yych <= '.') goto yy306;
				goto yy304;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy306;
				goto yy304;
			} else {
				if (yych != 'O') goto yy139;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy304;
				goto yy139;
			} else {
				if (yych <= 'o') goto yy488;
				if (yych <= 'z') goto yy139;
				goto yy304;
			}
		}
	}
yy488:
	YYDEBUG(488, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'B') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'A') goto yy140;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'b') goto yy489;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy489:
	YYDEBUG(489, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy141;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'e') goto yy490;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy490:
	YYDEBUG(490, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Q') {
		if (yych == ')') goto yy136;
		goto yy3;
	} else {
		if (yych <= 'R') goto yy316;
		if (yych == 'r') goto yy316;
		goto yy3;
	}
yy491:
	YYDEBUG(491, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy138;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy487;
			if (yych <= 'Z') goto yy138;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy143;
			} else {
				if (yych <= 't') goto yy492;
				if (yych <= 'z') goto yy143;
				goto yy3;
			}
		}
	}
yy492:
	YYDEBUG(492, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy304;
				goto yy306;
			} else {
				if (yych == ' ') goto yy306;
				goto yy304;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy136;
				if (yych <= ',') goto yy304;
				goto yy479;
			} else {
				if (yych == '/') goto yy144;
				goto yy306;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'N') {
				if (yych <= '@') goto yy304;
				goto yy139;
			} else {
				if (yych <= 'O') goto yy488;
				if (yych <= 'Z') goto yy139;
				goto yy304;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= '_') goto yy144;
				if (yych <= '`') goto yy304;
				goto yy147;
			} else {
				if (yych <= 'o') goto yy493;
				if (yych <= 'z') goto yy147;
				goto yy304;
			}
		}
	}
yy493:
	YYDEBUG(493, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy140;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'B') goto yy489;
			if (yych <= 'Z') goto yy140;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy3;
				goto yy148;
			} else {
				if (yych <= 'b') goto yy494;
				if (yych <= 'z') goto yy148;
				goto yy3;
			}
		}
	}
yy494:
	YYDEBUG(494, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy490;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy149;
			} else {
				if (yych <= 'e') goto yy495;
				if (yych <= 'z') goto yy149;
				goto yy3;
			}
		}
	}
yy495:
	YYDEBUG(495, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= ',') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy144;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'R') goto yy316;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'r') goto yy484;
			if (yych <= 'z') goto yy150;
			goto yy3;
		}
	}
yy496:
	YYDEBUG(496, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'V') {
		if (yych <= 'B') {
			if (yych == ')') goto yy136;
			if (yych <= '@') goto yy3;
			goto yy138;
		} else {
			if (yych <= 'O') {
				if (yych <= 'C') goto yy513;
				goto yy138;
			} else {
				if (yych <= 'P') goto yy512;
				if (yych <= 'U') goto yy138;
				goto yy514;
			}
		}
	} else {
		if (yych <= 'o') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy138;
				goto yy3;
			} else {
				if (yych == 'c') goto yy513;
				goto yy138;
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'p') goto yy512;
				goto yy138;
			} else {
				if (yych <= 'v') goto yy514;
				if (yych <= 'z') goto yy138;
				goto yy3;
			}
		}
	}
yy497:
	YYDEBUG(497, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy138;
			goto yy507;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy138;
			if (yych <= '`') goto yy3;
			goto yy138;
		} else {
			if (yych <= 't') goto yy507;
			if (yych <= 'z') goto yy138;
			goto yy3;
		}
	}
yy498:
	YYDEBUG(498, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'W') goto yy138;
			goto yy504;
		}
	} else {
		if (yych <= 'w') {
			if (yych <= 'Z') goto yy138;
			if (yych <= '`') goto yy3;
			goto yy138;
		} else {
			if (yych <= 'x') goto yy504;
			if (yych <= 'z') goto yy138;
			goto yy3;
		}
	}
yy499:
	YYDEBUG(499, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy138;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy138;
			if (yych <= '`') goto yy3;
			goto yy138;
		} else {
			if (yych <= 'n') goto yy500;
			if (yych <= 'z') goto yy138;
			goto yy3;
		}
	}
yy500:
	YYDEBUG(500, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy277;
			goto yy136;
		} else {
			if (yych <= '@') goto yy277;
			if (yych <= 'C') goto yy139;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy139;
			if (yych <= '`') goto yy277;
			goto yy139;
		} else {
			if (yych <= 'd') goto yy501;
			if (yych <= 'z') goto yy139;
			goto yy277;
		}
	}
yy501:
	YYDEBUG(501, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy136;
		if (yych <= '@') goto yy3;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy140;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy502;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy502:
	YYDEBUG(502, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'X') goto yy141;
		}
	} else {
		if (yych <= 'x') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'y') goto yy503;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy503:
	YYDEBUG(503, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ')') goto yy136;
	goto yy277;
yy504:
	YYDEBUG(504, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy139;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy139;
			if (yych <= '`') goto yy3;
			goto yy139;
		} else {
			if (yych <= 't') goto yy505;
			if (yych <= 'z') goto yy139;
			goto yy3;
		}
	}
yy505:
	YYDEBUG(505, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy140;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'h') goto yy506;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy506:
	YYDEBUG(506, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '(') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy3;
			goto yy160;
		} else {
			if (yych == ' ') goto yy160;
			goto yy3;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= ')') goto yy136;
			if (yych <= '@') goto yy3;
			goto yy141;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy507:
	YYDEBUG(507, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= ')') {
			if (yych <= '(') goto yy277;
			goto yy136;
		} else {
			if (yych <= '@') goto yy277;
			if (yych <= 'T') goto yy139;
		}
	} else {
		if (yych <= 't') {
			if (yych <= 'Z') goto yy139;
			if (yych <= '`') goto yy277;
			goto yy139;
		} else {
			if (yych <= 'u') goto yy508;
			if (yych <= 'z') goto yy139;
			goto yy277;
		}
	}
yy508:
	YYDEBUG(508, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy140;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'r') goto yy509;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy509:
	YYDEBUG(509, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy141;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'd') goto yy510;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy510:
	YYDEBUG(510, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych == ')') goto yy136;
		goto yy3;
	} else {
		if (yych <= 'A') goto yy511;
		if (yych != 'a') goto yy3;
	}
yy511:
	YYDEBUG(511, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy283;
	if (yych == 'y') goto yy283;
	goto yy53;
yy512:
	YYDEBUG(512, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy304;
				goto yy306;
			} else {
				if (yych == ' ') goto yy306;
				goto yy304;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy136;
				goto yy304;
			} else {
				if (yych <= '-') goto yy307;
				if (yych <= '.') goto yy306;
				goto yy304;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy306;
				goto yy304;
			} else {
				if (yych == 'T') goto yy520;
				goto yy139;
			}
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy304;
				goto yy139;
			} else {
				if (yych <= 't') goto yy520;
				if (yych <= 'z') goto yy139;
				goto yy304;
			}
		}
	}
yy513:
	YYDEBUG(513, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'N') goto yy139;
			goto yy518;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy139;
			if (yych <= '`') goto yy3;
			goto yy139;
		} else {
			if (yych <= 'o') goto yy518;
			if (yych <= 'z') goto yy139;
			goto yy3;
		}
	}
yy514:
	YYDEBUG(514, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy139;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy139;
			if (yych <= '`') goto yy3;
			goto yy139;
		} else {
			if (yych <= 'e') goto yy515;
			if (yych <= 'z') goto yy139;
			goto yy3;
		}
	}
yy515:
	YYDEBUG(515, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy140;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'n') goto yy516;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy516:
	YYDEBUG(516, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy141;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 't') goto yy517;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy517:
	YYDEBUG(517, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych == ')') goto yy136;
		goto yy3;
	} else {
		if (yych <= 'H') goto yy159;
		if (yych == 'h') goto yy159;
		goto yy3;
	}
yy518:
	YYDEBUG(518, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy140;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'n') goto yy519;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy519:
	YYDEBUG(519, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy141;
			goto yy263;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'd') goto yy263;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy520:
	YYDEBUG(520, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy304;
				goto yy306;
			} else {
				if (yych == ' ') goto yy306;
				goto yy304;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy136;
				goto yy304;
			} else {
				if (yych <= '-') goto yy307;
				if (yych <= '.') goto yy306;
				goto yy304;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy306;
				goto yy304;
			} else {
				if (yych != 'E') goto yy140;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy304;
				goto yy140;
			} else {
				if (yych <= 'e') goto yy521;
				if (yych <= 'z') goto yy140;
				goto yy304;
			}
		}
	}
yy521:
	YYDEBUG(521, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'L') goto yy141;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'm') goto yy522;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy522:
	YYDEBUG(522, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych == ')') goto yy136;
		goto yy3;
	} else {
		if (yych <= 'B') goto yy523;
		if (yych != 'b') goto yy3;
	}
yy523:
	YYDEBUG(523, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy524;
	if (yych != 'e') goto yy53;
yy524:
	YYDEBUG(524, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy316;
	if (yych == 'r') goto yy316;
	goto yy53;
yy525:
	YYDEBUG(525, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '/') {
			if (yych <= ',') {
				if (yych == ')') goto yy136;
				goto yy3;
			} else {
				if (yych == '.') goto yy3;
				goto yy144;
			}
		} else {
			if (yych <= 'C') {
				if (yych <= '@') goto yy3;
				if (yych <= 'B') goto yy138;
				goto yy513;
			} else {
				if (yych == 'P') goto yy512;
				goto yy138;
			}
		}
	} else {
		if (yych <= 'b') {
			if (yych <= '^') {
				if (yych <= 'V') goto yy514;
				if (yych <= 'Z') goto yy138;
				goto yy3;
			} else {
				if (yych <= '_') goto yy144;
				if (yych <= '`') goto yy3;
				goto yy143;
			}
		} else {
			if (yych <= 'p') {
				if (yych <= 'c') goto yy542;
				if (yych <= 'o') goto yy143;
				goto yy541;
			} else {
				if (yych == 'v') goto yy543;
				if (yych <= 'z') goto yy143;
				goto yy3;
			}
		}
	}
yy526:
	YYDEBUG(526, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy138;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy507;
			if (yych <= 'Z') goto yy138;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy143;
			} else {
				if (yych <= 't') goto yy536;
				if (yych <= 'z') goto yy143;
				goto yy3;
			}
		}
	}
yy527:
	YYDEBUG(527, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy138;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'X') goto yy504;
			if (yych <= 'Z') goto yy138;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'w') {
				if (yych <= '`') goto yy3;
				goto yy143;
			} else {
				if (yych <= 'x') goto yy533;
				if (yych <= 'z') goto yy143;
				goto yy3;
			}
		}
	}
yy528:
	YYDEBUG(528, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy138;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy500;
			if (yych <= 'Z') goto yy138;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy143;
			} else {
				if (yych <= 'n') goto yy529;
				if (yych <= 'z') goto yy143;
				goto yy3;
			}
		}
	}
yy529:
	YYDEBUG(529, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy277;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy277;
			goto yy139;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy501;
			if (yych <= 'Z') goto yy139;
			if (yych <= '^') goto yy277;
			goto yy144;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy277;
				goto yy147;
			} else {
				if (yych <= 'd') goto yy530;
				if (yych <= 'z') goto yy147;
				goto yy277;
			}
		}
	}
yy530:
	YYDEBUG(530, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy144;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy502;
			if (yych <= 'Z') goto yy140;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy531;
			if (yych <= 'z') goto yy148;
			goto yy3;
		}
	}
yy531:
	YYDEBUG(531, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Y') goto yy503;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'x') {
				if (yych <= '`') goto yy3;
				goto yy149;
			} else {
				if (yych <= 'y') goto yy532;
				if (yych <= 'z') goto yy149;
				goto yy3;
			}
		}
	}
yy532:
	YYDEBUG(532, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy150;
	}
	if (yych <= '-') {
		if (yych == ')') goto yy136;
		if (yych <= ',') goto yy277;
		goto yy144;
	} else {
		if (yych <= '/') {
			if (yych <= '.') goto yy277;
			goto yy144;
		} else {
			if (yych == '_') goto yy144;
			goto yy277;
		}
	}
yy533:
	YYDEBUG(533, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy139;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy505;
			if (yych <= 'Z') goto yy139;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy147;
			} else {
				if (yych <= 't') goto yy534;
				if (yych <= 'z') goto yy147;
				goto yy3;
			}
		}
	}
yy534:
	YYDEBUG(534, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy140;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy506;
			if (yych <= 'Z') goto yy140;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy3;
				goto yy148;
			} else {
				if (yych <= 'h') goto yy535;
				if (yych <= 'z') goto yy148;
				goto yy3;
			}
		}
	}
yy535:
	YYDEBUG(535, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy160;
			if (yych <= 0x1F) goto yy3;
			goto yy160;
		} else {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= 'Z') {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy141;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy3;
				goto yy144;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy149;
				goto yy3;
			}
		}
	}
yy536:
	YYDEBUG(536, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy277;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy277;
			goto yy139;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'U') goto yy508;
			if (yych <= 'Z') goto yy139;
			if (yych <= '^') goto yy277;
			goto yy144;
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy277;
				goto yy147;
			} else {
				if (yych <= 'u') goto yy537;
				if (yych <= 'z') goto yy147;
				goto yy277;
			}
		}
	}
yy537:
	YYDEBUG(537, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy140;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy509;
			if (yych <= 'Z') goto yy140;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy3;
				goto yy148;
			} else {
				if (yych <= 'r') goto yy538;
				if (yych <= 'z') goto yy148;
				goto yy3;
			}
		}
	}
yy538:
	YYDEBUG(538, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy510;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy3;
				goto yy149;
			} else {
				if (yych <= 'd') goto yy539;
				if (yych <= 'z') goto yy149;
				goto yy3;
			}
		}
	}
yy539:
	YYDEBUG(539, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy144;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy511;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy540;
			if (yych <= 'z') goto yy150;
			goto yy3;
		}
	}
yy540:
	YYDEBUG(540, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy283;
	if (yych == 'y') goto yy296;
	goto yy151;
yy541:
	YYDEBUG(541, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy304;
				goto yy306;
			} else {
				if (yych == ' ') goto yy306;
				goto yy304;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy136;
				if (yych <= ',') goto yy304;
				goto yy479;
			} else {
				if (yych == '/') goto yy144;
				goto yy306;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'S') {
				if (yych <= '@') goto yy304;
				goto yy139;
			} else {
				if (yych <= 'T') goto yy520;
				if (yych <= 'Z') goto yy139;
				goto yy304;
			}
		} else {
			if (yych <= 's') {
				if (yych <= '_') goto yy144;
				if (yych <= '`') goto yy304;
				goto yy147;
			} else {
				if (yych <= 't') goto yy549;
				if (yych <= 'z') goto yy147;
				goto yy304;
			}
		}
	}
yy542:
	YYDEBUG(542, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy139;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'O') goto yy518;
			if (yych <= 'Z') goto yy139;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy3;
				goto yy147;
			} else {
				if (yych <= 'o') goto yy547;
				if (yych <= 'z') goto yy147;
				goto yy3;
			}
		}
	}
yy543:
	YYDEBUG(543, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy139;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy515;
			if (yych <= 'Z') goto yy139;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy147;
			} else {
				if (yych <= 'e') goto yy544;
				if (yych <= 'z') goto yy147;
				goto yy3;
			}
		}
	}
yy544:
	YYDEBUG(544, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy140;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy516;
			if (yych <= 'Z') goto yy140;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy148;
			} else {
				if (yych <= 'n') goto yy545;
				if (yych <= 'z') goto yy148;
				goto yy3;
			}
		}
	}
yy545:
	YYDEBUG(545, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy517;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy149;
			} else {
				if (yych <= 't') goto yy546;
				if (yych <= 'z') goto yy149;
				goto yy3;
			}
		}
	}
yy546:
	YYDEBUG(546, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= ',') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy144;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'H') goto yy159;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'h') goto yy246;
			if (yych <= 'z') goto yy150;
			goto yy3;
		}
	}
yy547:
	YYDEBUG(547, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy140;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy519;
			if (yych <= 'Z') goto yy140;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy148;
			} else {
				if (yych <= 'n') goto yy548;
				if (yych <= 'z') goto yy148;
				goto yy3;
			}
		}
	}
yy548:
	YYDEBUG(548, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy263;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy3;
				goto yy149;
			} else {
				if (yych <= 'd') goto yy274;
				if (yych <= 'z') goto yy149;
				goto yy3;
			}
		}
	}
yy549:
	YYDEBUG(549, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy304;
				goto yy306;
			} else {
				if (yych == ' ') goto yy306;
				goto yy304;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy136;
				if (yych <= ',') goto yy304;
				goto yy479;
			} else {
				if (yych == '/') goto yy144;
				goto yy306;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'D') {
				if (yych <= '@') goto yy304;
				goto yy140;
			} else {
				if (yych <= 'E') goto yy521;
				if (yych <= 'Z') goto yy140;
				goto yy304;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '_') goto yy144;
				if (yych <= '`') goto yy304;
				goto yy148;
			} else {
				if (yych <= 'e') goto yy550;
				if (yych <= 'z') goto yy148;
				goto yy304;
			}
		}
	}
yy550:
	YYDEBUG(550, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'M') goto yy522;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'l') {
				if (yych <= '`') goto yy3;
				goto yy149;
			} else {
				if (yych <= 'm') goto yy551;
				if (yych <= 'z') goto yy149;
				goto yy3;
			}
		}
	}
yy551:
	YYDEBUG(551, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= ',') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy144;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'B') goto yy523;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'b') goto yy552;
			if (yych <= 'z') goto yy150;
			goto yy3;
		}
	}
yy552:
	YYDEBUG(552, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy524;
	if (yych != 'e') goto yy151;
	YYDEBUG(553, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy316;
	if (yych == 'r') goto yy484;
	goto yy151;
yy554:
	YYDEBUG(554, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'G') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'F') goto yy138;
			goto yy562;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy138;
			if (yych <= '`') goto yy3;
			goto yy138;
		} else {
			if (yych <= 'g') goto yy562;
			if (yych <= 'z') goto yy138;
			goto yy3;
		}
	}
yy555:
	YYDEBUG(555, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy138;
			goto yy559;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy138;
			if (yych <= '`') goto yy3;
			goto yy138;
		} else {
			if (yych <= 'r') goto yy559;
			if (yych <= 'z') goto yy138;
			goto yy3;
		}
	}
yy556:
	YYDEBUG(556, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'N') goto yy138;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy138;
			if (yych <= '`') goto yy3;
			goto yy138;
		} else {
			if (yych <= 'o') goto yy557;
			if (yych <= 'z') goto yy138;
			goto yy3;
		}
	}
yy557:
	YYDEBUG(557, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '@') {
		if (yych == ')') goto yy136;
	} else {
		if (yych <= 'Z') goto yy139;
		if (yych <= '`') goto yy558;
		if (yych <= 'z') goto yy139;
	}
yy558:
	YYDEBUG(558, *YYCURSOR);
	{
		DEBUG_OUTPUT("ago");
		TIMELIB_INIT;
		s->time->relative.y = 0 - s->time->relative.y;
		s->time->relative.m = 0 - s->time->relative.m;
		s->time->relative.d = 0 - s->time->relative.d;
		s->time->relative.h = 0 - s->time->relative.h;
		s->time->relative.i = 0 - s->time->relative.i;
		s->time->relative.s = 0 - s->time->relative.s;
		s->time->relative.weekday = 0 - s->time->relative.weekday;
		if (s->time->have_special_relative && s->time->special.type == TIMELIB_SPECIAL_WEEKDAY) {
			s->time->special.amount = 0 - s->time->special.amount;
		}
		TIMELIB_DEINIT;
		return TIMELIB_AGO;
	}
yy559:
	YYDEBUG(559, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy304;
				goto yy306;
			} else {
				if (yych == ' ') goto yy306;
				goto yy304;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy136;
				goto yy304;
			} else {
				if (yych <= '-') goto yy307;
				if (yych <= '.') goto yy306;
				goto yy304;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy306;
				goto yy304;
			} else {
				if (yych != 'I') goto yy139;
			}
		} else {
			if (yych <= 'h') {
				if (yych <= '`') goto yy304;
				goto yy139;
			} else {
				if (yych <= 'i') goto yy560;
				if (yych <= 'z') goto yy139;
				goto yy304;
			}
		}
	}
yy560:
	YYDEBUG(560, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'K') goto yy140;
		}
	} else {
		if (yych <= 'k') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'l') goto yy561;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy561:
	YYDEBUG(561, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy306;
			goto yy304;
		} else {
			if (yych <= ' ') goto yy306;
			if (yych == ')') goto yy136;
			goto yy304;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy304;
			if (yych <= '9') goto yy306;
			goto yy304;
		} else {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy304;
			if (yych <= 'z') goto yy141;
			goto yy304;
		}
	}
yy562:
	YYDEBUG(562, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy304;
				goto yy306;
			} else {
				if (yych == ' ') goto yy306;
				goto yy304;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy136;
				goto yy304;
			} else {
				if (yych <= '-') goto yy307;
				if (yych <= '.') goto yy306;
				goto yy304;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy306;
				goto yy304;
			} else {
				if (yych != 'U') goto yy139;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy304;
				goto yy139;
			} else {
				if (yych <= 'u') goto yy563;
				if (yych <= 'z') goto yy139;
				goto yy304;
			}
		}
	}
yy563:
	YYDEBUG(563, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'R') goto yy140;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy140;
		} else {
			if (yych <= 's') goto yy564;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy564:
	YYDEBUG(564, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy141;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 't') goto yy565;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy565:
	YYDEBUG(565, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '(') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy304;
			goto yy306;
		} else {
			if (yych == ' ') goto yy306;
			goto yy304;
		}
	} else {
		if (yych <= '.') {
			if (yych <= ')') goto yy136;
			if (yych <= ',') goto yy304;
			goto yy306;
		} else {
			if (yych <= '/') goto yy304;
			if (yych <= '9') goto yy306;
			goto yy304;
		}
	}
yy566:
	YYDEBUG(566, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'F') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy138;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'G') goto yy562;
			if (yych <= 'Z') goto yy138;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'f') {
				if (yych <= '`') goto yy3;
				goto yy143;
			} else {
				if (yych <= 'g') goto yy573;
				if (yych <= 'z') goto yy143;
				goto yy3;
			}
		}
	}
yy567:
	YYDEBUG(567, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy138;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy559;
			if (yych <= 'Z') goto yy138;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy3;
				goto yy143;
			} else {
				if (yych <= 'r') goto yy570;
				if (yych <= 'z') goto yy143;
				goto yy3;
			}
		}
	}
yy568:
	YYDEBUG(568, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy138;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'O') goto yy557;
			if (yych <= 'Z') goto yy138;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy3;
				goto yy143;
			} else {
				if (yych <= 'o') goto yy569;
				if (yych <= 'z') goto yy143;
				goto yy3;
			}
		}
	}
yy569:
	YYDEBUG(569, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy136;
			goto yy558;
		} else {
			if (yych == '.') goto yy558;
			goto yy144;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy558;
			if (yych <= 'Z') goto yy139;
			goto yy558;
		} else {
			if (yych <= '_') goto yy144;
			if (yych <= '`') goto yy558;
			if (yych <= 'z') goto yy147;
			goto yy558;
		}
	}
yy570:
	YYDEBUG(570, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy304;
				goto yy306;
			} else {
				if (yych == ' ') goto yy306;
				goto yy304;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy136;
				if (yych <= ',') goto yy304;
				goto yy479;
			} else {
				if (yych == '/') goto yy144;
				goto yy306;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'H') {
				if (yych <= '@') goto yy304;
				goto yy139;
			} else {
				if (yych <= 'I') goto yy560;
				if (yych <= 'Z') goto yy139;
				goto yy304;
			}
		} else {
			if (yych <= 'h') {
				if (yych <= '_') goto yy144;
				if (yych <= '`') goto yy304;
				goto yy147;
			} else {
				if (yych <= 'i') goto yy571;
				if (yych <= 'z') goto yy147;
				goto yy304;
			}
		}
	}
yy571:
	YYDEBUG(571, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'K') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy140;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'L') goto yy561;
			if (yych <= 'Z') goto yy140;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'k') {
				if (yych <= '`') goto yy3;
				goto yy148;
			} else {
				if (yych <= 'l') goto yy572;
				if (yych <= 'z') goto yy148;
				goto yy3;
			}
		}
	}
yy572:
	YYDEBUG(572, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy306;
			if (yych <= 0x1F) goto yy304;
			goto yy306;
		} else {
			if (yych <= ')') {
				if (yych <= '(') goto yy304;
				goto yy136;
			} else {
				if (yych <= ',') goto yy304;
				if (yych <= '-') goto yy485;
				goto yy306;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '/') goto yy144;
			if (yych <= '9') goto yy306;
			if (yych <= '@') goto yy304;
			goto yy141;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy304;
				goto yy144;
			} else {
				if (yych <= '`') goto yy304;
				if (yych <= 'z') goto yy149;
				goto yy304;
			}
		}
	}
yy573:
	YYDEBUG(573, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy304;
				goto yy306;
			} else {
				if (yych == ' ') goto yy306;
				goto yy304;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy136;
				if (yych <= ',') goto yy304;
				goto yy479;
			} else {
				if (yych == '/') goto yy144;
				goto yy306;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'T') {
				if (yych <= '@') goto yy304;
				goto yy139;
			} else {
				if (yych <= 'U') goto yy563;
				if (yych <= 'Z') goto yy139;
				goto yy304;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '_') goto yy144;
				if (yych <= '`') goto yy304;
				goto yy147;
			} else {
				if (yych <= 'u') goto yy574;
				if (yych <= 'z') goto yy147;
				goto yy304;
			}
		}
	}
yy574:
	YYDEBUG(574, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy140;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy564;
			if (yych <= 'Z') goto yy140;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy3;
				goto yy148;
			} else {
				if (yych <= 's') goto yy575;
				if (yych <= 'z') goto yy148;
				goto yy3;
			}
		}
	}
yy575:
	YYDEBUG(575, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy565;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy149;
			} else {
				if (yych <= 't') goto yy576;
				if (yych <= 'z') goto yy149;
				goto yy3;
			}
		}
	}
yy576:
	YYDEBUG(576, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy150;
	}
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy306;
			goto yy304;
		} else {
			if (yych <= ' ') goto yy306;
			if (yych == ')') goto yy136;
			goto yy304;
		}
	} else {
		if (yych <= '/') {
			if (yych <= '-') goto yy485;
			if (yych <= '.') goto yy306;
			goto yy144;
		} else {
			if (yych <= '9') goto yy306;
			if (yych == '_') goto yy144;
			goto yy304;
		}
	}
yy577:
	YYDEBUG(577, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'B') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'A') goto yy138;
			goto yy591;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy138;
			if (yych <= '`') goto yy3;
			goto yy138;
		} else {
			if (yych <= 'b') goto yy591;
			if (yych <= 'z') goto yy138;
			goto yy3;
		}
	}
yy578:
	YYDEBUG(578, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= '@') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych == 'F') goto yy588;
			if (yych <= 'Q') goto yy138;
			goto yy587;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy138;
			if (yych <= '`') goto yy3;
			if (yych <= 'e') goto yy138;
			goto yy588;
		} else {
			if (yych == 'r') goto yy587;
			if (yych <= 'z') goto yy138;
			goto yy3;
		}
	}
yy579:
	YYDEBUG(579, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'T') goto yy138;
			goto yy584;
		}
	} else {
		if (yych <= 't') {
			if (yych <= 'Z') goto yy138;
			if (yych <= '`') goto yy3;
			goto yy138;
		} else {
			if (yych <= 'u') goto yy584;
			if (yych <= 'z') goto yy138;
			goto yy3;
		}
	}
yy580:
	YYDEBUG(580, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'I') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'H') goto yy138;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy138;
			if (yych <= '`') goto yy3;
			goto yy138;
		} else {
			if (yych <= 'i') goto yy581;
			if (yych <= 'z') goto yy138;
			goto yy3;
		}
	}
yy581:
	YYDEBUG(581, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy277;
			goto yy136;
		} else {
			if (yych <= '@') goto yy277;
			if (yych <= 'C') goto yy139;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy139;
			if (yych <= '`') goto yy277;
			goto yy139;
		} else {
			if (yych <= 'd') goto yy582;
			if (yych <= 'z') goto yy139;
			goto yy277;
		}
	}
yy582:
	YYDEBUG(582, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy136;
		if (yych <= '@') goto yy3;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy140;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy583;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy583:
	YYDEBUG(583, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'X') goto yy141;
			goto yy503;
		}
	} else {
		if (yych <= 'x') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'y') goto yy503;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy584:
	YYDEBUG(584, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy139;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy139;
			if (yych <= '`') goto yy3;
			goto yy139;
		} else {
			if (yych <= 'r') goto yy585;
			if (yych <= 'z') goto yy139;
			goto yy3;
		}
	}
yy585:
	YYDEBUG(585, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy140;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy140;
		} else {
			if (yych <= 't') goto yy586;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy586:
	YYDEBUG(586, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy141;
			goto yy263;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'h') goto yy263;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy587:
	YYDEBUG(587, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'R') goto yy139;
			goto yy590;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy139;
			if (yych <= '`') goto yy3;
			goto yy139;
		} else {
			if (yych <= 's') goto yy590;
			if (yych <= 'z') goto yy139;
			goto yy3;
		}
	}
yy588:
	YYDEBUG(588, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy139;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy139;
			if (yych <= '`') goto yy3;
			goto yy139;
		} else {
			if (yych <= 't') goto yy589;
			if (yych <= 'z') goto yy139;
			goto yy3;
		}
	}
yy589:
	YYDEBUG(589, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy140;
			goto yy506;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'h') goto yy506;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy590:
	YYDEBUG(590, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy140;
			goto yy506;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy140;
		} else {
			if (yych <= 't') goto yy506;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy591:
	YYDEBUG(591, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy304;
				goto yy306;
			} else {
				if (yych == ' ') goto yy306;
				goto yy304;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy136;
				goto yy304;
			} else {
				if (yych <= '-') goto yy307;
				if (yych <= '.') goto yy306;
				goto yy304;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy306;
				goto yy304;
			} else {
				if (yych != 'R') goto yy139;
			}
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy304;
				goto yy139;
			} else {
				if (yych <= 'r') goto yy592;
				if (yych <= 'z') goto yy139;
				goto yy304;
			}
		}
	}
yy592:
	YYDEBUG(592, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'T') goto yy140;
		}
	} else {
		if (yych <= 't') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'u') goto yy593;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy593:
	YYDEBUG(593, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy136;
		if (yych <= '@') goto yy3;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy141;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy594;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy594:
	YYDEBUG(594, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych == ')') goto yy136;
		goto yy3;
	} else {
		if (yych <= 'R') goto yy595;
		if (yych != 'r') goto yy3;
	}
yy595:
	YYDEBUG(595, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy316;
	if (yych == 'y') goto yy316;
	goto yy53;
yy596:
	YYDEBUG(596, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy138;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'B') goto yy591;
			if (yych <= 'Z') goto yy138;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy3;
				goto yy143;
			} else {
				if (yych <= 'b') goto yy610;
				if (yych <= 'z') goto yy143;
				goto yy3;
			}
		}
	}
yy597:
	YYDEBUG(597, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy136;
			} else {
				if (yych == '-') goto yy144;
				goto yy3;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy144;
				goto yy3;
			} else {
				if (yych == 'F') goto yy588;
				goto yy138;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'R') goto yy587;
				goto yy138;
			} else {
				if (yych == '_') goto yy144;
				goto yy3;
			}
		} else {
			if (yych <= 'q') {
				if (yych == 'f') goto yy607;
				goto yy143;
			} else {
				if (yych <= 'r') goto yy606;
				if (yych <= 'z') goto yy143;
				goto yy3;
			}
		}
	}
yy598:
	YYDEBUG(598, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy138;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'U') goto yy584;
			if (yych <= 'Z') goto yy138;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy3;
				goto yy143;
			} else {
				if (yych <= 'u') goto yy603;
				if (yych <= 'z') goto yy143;
				goto yy3;
			}
		}
	}
yy599:
	YYDEBUG(599, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy138;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'I') goto yy581;
			if (yych <= 'Z') goto yy138;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'h') {
				if (yych <= '`') goto yy3;
				goto yy143;
			} else {
				if (yych <= 'i') goto yy600;
				if (yych <= 'z') goto yy143;
				goto yy3;
			}
		}
	}
yy600:
	YYDEBUG(600, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy277;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy277;
			goto yy139;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy582;
			if (yych <= 'Z') goto yy139;
			if (yych <= '^') goto yy277;
			goto yy144;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy277;
				goto yy147;
			} else {
				if (yych <= 'd') goto yy601;
				if (yych <= 'z') goto yy147;
				goto yy277;
			}
		}
	}
yy601:
	YYDEBUG(601, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy144;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy583;
			if (yych <= 'Z') goto yy140;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy602;
			if (yych <= 'z') goto yy148;
			goto yy3;
		}
	}
yy602:
	YYDEBUG(602, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Y') goto yy503;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'x') {
				if (yych <= '`') goto yy3;
				goto yy149;
			} else {
				if (yych <= 'y') goto yy532;
				if (yych <= 'z') goto yy149;
				goto yy3;
			}
		}
	}
yy603:
	YYDEBUG(603, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy139;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy585;
			if (yych <= 'Z') goto yy139;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy3;
				goto yy147;
			} else {
				if (yych <= 'r') goto yy604;
				if (yych <= 'z') goto yy147;
				goto yy3;
			}
		}
	}
yy604:
	YYDEBUG(604, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy140;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy586;
			if (yych <= 'Z') goto yy140;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy148;
			} else {
				if (yych <= 't') goto yy605;
				if (yych <= 'z') goto yy148;
				goto yy3;
			}
		}
	}
yy605:
	YYDEBUG(605, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy263;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy3;
				goto yy149;
			} else {
				if (yych <= 'h') goto yy274;
				if (yych <= 'z') goto yy149;
				goto yy3;
			}
		}
	}
yy606:
	YYDEBUG(606, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy139;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy590;
			if (yych <= 'Z') goto yy139;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy3;
				goto yy147;
			} else {
				if (yych <= 's') goto yy609;
				if (yych <= 'z') goto yy147;
				goto yy3;
			}
		}
	}
yy607:
	YYDEBUG(607, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy139;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy589;
			if (yych <= 'Z') goto yy139;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy147;
			} else {
				if (yych <= 't') goto yy608;
				if (yych <= 'z') goto yy147;
				goto yy3;
			}
		}
	}
yy608:
	YYDEBUG(608, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy140;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy506;
			if (yych <= 'Z') goto yy140;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy3;
				goto yy148;
			} else {
				if (yych <= 'h') goto yy535;
				if (yych <= 'z') goto yy148;
				goto yy3;
			}
		}
	}
yy609:
	YYDEBUG(609, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy140;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy506;
			if (yych <= 'Z') goto yy140;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy148;
			} else {
				if (yych <= 't') goto yy535;
				if (yych <= 'z') goto yy148;
				goto yy3;
			}
		}
	}
yy610:
	YYDEBUG(610, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy304;
				goto yy306;
			} else {
				if (yych == ' ') goto yy306;
				goto yy304;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy136;
				if (yych <= ',') goto yy304;
				goto yy479;
			} else {
				if (yych == '/') goto yy144;
				goto yy306;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'Q') {
				if (yych <= '@') goto yy304;
				goto yy139;
			} else {
				if (yych <= 'R') goto yy592;
				if (yych <= 'Z') goto yy139;
				goto yy304;
			}
		} else {
			if (yych <= 'q') {
				if (yych <= '_') goto yy144;
				if (yych <= '`') goto yy304;
				goto yy147;
			} else {
				if (yych <= 'r') goto yy611;
				if (yych <= 'z') goto yy147;
				goto yy304;
			}
		}
	}
yy611:
	YYDEBUG(611, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy140;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'U') goto yy593;
			if (yych <= 'Z') goto yy140;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy3;
				goto yy148;
			} else {
				if (yych <= 'u') goto yy612;
				if (yych <= 'z') goto yy148;
				goto yy3;
			}
		}
	}
yy612:
	YYDEBUG(612, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy144;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy594;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy613;
			if (yych <= 'z') goto yy149;
			goto yy3;
		}
	}
yy613:
	YYDEBUG(613, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= ',') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy144;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'R') goto yy595;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'r') goto yy614;
			if (yych <= 'z') goto yy150;
			goto yy3;
		}
	}
yy614:
	YYDEBUG(614, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy316;
	if (yych == 'y') goto yy484;
	goto yy151;
yy615:
	YYDEBUG(615, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= '@') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych == 'L') goto yy622;
			if (yych <= 'M') goto yy138;
			goto yy621;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy138;
			if (yych <= '`') goto yy3;
			if (yych <= 'k') goto yy138;
			goto yy622;
		} else {
			if (yych == 'n') goto yy621;
			if (yych <= 'z') goto yy138;
			goto yy3;
		}
	}
yy616:
	YYDEBUG(616, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy138;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy138;
			if (yych <= '`') goto yy3;
			goto yy138;
		} else {
			if (yych <= 'n') goto yy617;
			if (yych <= 'z') goto yy138;
			goto yy3;
		}
	}
yy617:
	YYDEBUG(617, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy304;
				goto yy306;
			} else {
				if (yych == ' ') goto yy306;
				goto yy304;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy136;
				goto yy304;
			} else {
				if (yych <= '-') goto yy307;
				if (yych <= '.') goto yy306;
				goto yy304;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy306;
				goto yy304;
			} else {
				if (yych != 'U') goto yy139;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy304;
				goto yy139;
			} else {
				if (yych <= 'u') goto yy618;
				if (yych <= 'z') goto yy139;
				goto yy304;
			}
		}
	}
yy618:
	YYDEBUG(618, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy136;
		if (yych <= '@') goto yy3;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy140;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy619;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy619:
	YYDEBUG(619, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy141;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'r') goto yy620;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy620:
	YYDEBUG(620, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych == ')') goto yy136;
		goto yy3;
	} else {
		if (yych <= 'Y') goto yy316;
		if (yych == 'y') goto yy316;
		goto yy3;
	}
yy621:
	YYDEBUG(621, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy304;
				goto yy306;
			} else {
				if (yych == ' ') goto yy306;
				goto yy304;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy136;
				goto yy304;
			} else {
				if (yych <= '-') goto yy307;
				if (yych <= '.') goto yy306;
				goto yy304;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy306;
				goto yy304;
			} else {
				if (yych == 'E') goto yy623;
				goto yy139;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy304;
				goto yy139;
			} else {
				if (yych <= 'e') goto yy623;
				if (yych <= 'z') goto yy139;
				goto yy304;
			}
		}
	}
yy622:
	YYDEBUG(622, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy304;
				goto yy306;
			} else {
				if (yych == ' ') goto yy306;
				goto yy304;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy136;
				goto yy304;
			} else {
				if (yych <= '-') goto yy307;
				if (yych <= '.') goto yy306;
				goto yy304;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy306;
				goto yy304;
			} else {
				if (yych != 'Y') goto yy139;
			}
		} else {
			if (yych <= 'x') {
				if (yych <= '`') goto yy304;
				goto yy139;
			} else {
				if (yych <= 'y') goto yy623;
				if (yych <= 'z') goto yy139;
				goto yy304;
			}
		}
	}
yy623:
	YYDEBUG(623, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy306;
			goto yy304;
		} else {
			if (yych <= ' ') goto yy306;
			if (yych == ')') goto yy136;
			goto yy304;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy304;
			if (yych <= '9') goto yy306;
			goto yy304;
		} else {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy304;
			if (yych <= 'z') goto yy140;
			goto yy304;
		}
	}
yy624:
	YYDEBUG(624, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy136;
			} else {
				if (yych == '-') goto yy144;
				goto yy3;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy144;
				goto yy3;
			} else {
				if (yych == 'L') goto yy622;
				goto yy138;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'N') goto yy621;
				goto yy138;
			} else {
				if (yych == '_') goto yy144;
				goto yy3;
			}
		} else {
			if (yych <= 'm') {
				if (yych == 'l') goto yy631;
				goto yy143;
			} else {
				if (yych <= 'n') goto yy630;
				if (yych <= 'z') goto yy143;
				goto yy3;
			}
		}
	}
yy625:
	YYDEBUG(625, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy138;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy617;
			if (yych <= 'Z') goto yy138;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy143;
			} else {
				if (yych <= 'n') goto yy626;
				if (yych <= 'z') goto yy143;
				goto yy3;
			}
		}
	}
yy626:
	YYDEBUG(626, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy304;
				goto yy306;
			} else {
				if (yych == ' ') goto yy306;
				goto yy304;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy136;
				if (yych <= ',') goto yy304;
				goto yy479;
			} else {
				if (yych == '/') goto yy144;
				goto yy306;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'T') {
				if (yych <= '@') goto yy304;
				goto yy139;
			} else {
				if (yych <= 'U') goto yy618;
				if (yych <= 'Z') goto yy139;
				goto yy304;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '_') goto yy144;
				if (yych <= '`') goto yy304;
				goto yy147;
			} else {
				if (yych <= 'u') goto yy627;
				if (yych <= 'z') goto yy147;
				goto yy304;
			}
		}
	}
yy627:
	YYDEBUG(627, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy144;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy619;
			if (yych <= 'Z') goto yy140;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy628;
			if (yych <= 'z') goto yy148;
			goto yy3;
		}
	}
yy628:
	YYDEBUG(628, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy620;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy3;
				goto yy149;
			} else {
				if (yych <= 'r') goto yy629;
				if (yych <= 'z') goto yy149;
				goto yy3;
			}
		}
	}
yy629:
	YYDEBUG(629, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= ',') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy144;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Y') goto yy316;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'y') goto yy484;
			if (yych <= 'z') goto yy150;
			goto yy3;
		}
	}
yy630:
	YYDEBUG(630, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy304;
				goto yy306;
			} else {
				if (yych == ' ') goto yy306;
				goto yy304;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy136;
				if (yych <= ',') goto yy304;
				goto yy479;
			} else {
				if (yych == '/') goto yy144;
				goto yy306;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'D') {
				if (yych <= '@') goto yy304;
				goto yy139;
			} else {
				if (yych <= 'E') goto yy623;
				if (yych <= 'Z') goto yy139;
				goto yy304;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '_') goto yy144;
				if (yych <= '`') goto yy304;
				goto yy147;
			} else {
				if (yych <= 'e') goto yy632;
				if (yych <= 'z') goto yy147;
				goto yy304;
			}
		}
	}
yy631:
	YYDEBUG(631, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy304;
				goto yy306;
			} else {
				if (yych == ' ') goto yy306;
				goto yy304;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy136;
				if (yych <= ',') goto yy304;
				goto yy479;
			} else {
				if (yych == '/') goto yy144;
				goto yy306;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'X') {
				if (yych <= '@') goto yy304;
				goto yy139;
			} else {
				if (yych <= 'Y') goto yy623;
				if (yych <= 'Z') goto yy139;
				goto yy304;
			}
		} else {
			if (yych <= 'x') {
				if (yych <= '_') goto yy144;
				if (yych <= '`') goto yy304;
				goto yy147;
			} else {
				if (yych <= 'y') goto yy632;
				if (yych <= 'z') goto yy147;
				goto yy304;
			}
		}
	}
yy632:
	YYDEBUG(632, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy306;
			if (yych <= 0x1F) goto yy304;
			goto yy306;
		} else {
			if (yych <= ')') {
				if (yych <= '(') goto yy304;
				goto yy136;
			} else {
				if (yych <= ',') goto yy304;
				if (yych <= '-') goto yy485;
				goto yy306;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '/') goto yy144;
			if (yych <= '9') goto yy306;
			if (yych <= '@') goto yy304;
			goto yy140;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy304;
				goto yy144;
			} else {
				if (yych <= '`') goto yy304;
				if (yych <= 'z') goto yy148;
				goto yy304;
			}
		}
	}
yy633:
	YYDEBUG(633, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy306;
			if (yych <= 0x1F) goto yy3;
			goto yy306;
		} else {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy306;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy3;
			if (yych <= '9') goto yy306;
			if (yych <= '@') goto yy3;
			goto yy138;
		} else {
			if (yych <= 'Z') {
				if (yych >= 'J') goto yy138;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy138;
				goto yy3;
			}
		}
	}
yy634:
	YYDEBUG(634, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy306;
			goto yy3;
		} else {
			if (yych <= ' ') goto yy306;
			if (yych == ')') goto yy136;
			goto yy3;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy3;
			if (yych <= '9') goto yy306;
			goto yy3;
		} else {
			if (yych <= 'Z') goto yy139;
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy139;
			goto yy3;
		}
	}
yy635:
	YYDEBUG(635, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy306;
			if (yych <= 0x1F) goto yy3;
			goto yy306;
		} else {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy306;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy3;
			if (yych <= '9') goto yy306;
			if (yych <= '@') goto yy3;
			goto yy138;
		} else {
			if (yych <= 'Z') {
				if (yych >= 'J') goto yy138;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy138;
				goto yy3;
			}
		}
	}
	YYDEBUG(636, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy306;
			if (yych <= 0x1F) goto yy3;
			goto yy306;
		} else {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy306;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy3;
			if (yych <= '9') goto yy306;
			if (yych <= '@') goto yy3;
			goto yy139;
		} else {
			if (yych <= 'Z') {
				if (yych >= 'J') goto yy139;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy139;
				goto yy3;
			}
		}
	}
	YYDEBUG(637, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy306;
			goto yy3;
		} else {
			if (yych <= ' ') goto yy306;
			if (yych == ')') goto yy136;
			goto yy3;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy3;
			if (yych <= '9') goto yy306;
			goto yy3;
		} else {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy638:
	YYDEBUG(638, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy306;
			goto yy3;
		} else {
			if (yych <= ' ') goto yy306;
			if (yych == ')') goto yy136;
			goto yy3;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy3;
			if (yych <= '9') goto yy306;
			goto yy3;
		} else {
			if (yych <= 'Z') goto yy138;
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy138;
			goto yy3;
		}
	}
yy639:
	YYDEBUG(639, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy306;
			if (yych <= 0x1F) goto yy3;
			goto yy306;
		} else {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy306;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy3;
			if (yych <= '9') goto yy306;
			if (yych <= '@') goto yy3;
			goto yy138;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'I') goto yy634;
				goto yy138;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy138;
				goto yy3;
			}
		}
	}
yy640:
	YYDEBUG(640, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy57;
				if (yych <= 0x1F) goto yy3;
				goto yy57;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy3;
					goto yy662;
				} else {
					if (yych <= ':') goto yy647;
					if (yych <= 'C') goto yy3;
					goto yy57;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy57;
				if (yych <= 'G') goto yy3;
				goto yy57;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy3;
					goto yy57;
				} else {
					if (yych <= 'R') goto yy3;
					if (yych <= 'T') goto yy57;
					goto yy3;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy3;
				if (yych <= 'Y') goto yy57;
				goto yy3;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy57;
					goto yy3;
				} else {
					if (yych == 'g') goto yy3;
					goto yy57;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy57;
				if (yych <= 'r') goto yy3;
				goto yy57;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy3;
					goto yy57;
				} else {
					if (yych == 'y') goto yy57;
					goto yy3;
				}
			}
		}
	}
yy641:
	YYDEBUG(641, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= ':') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy57;
				if (yych <= 0x1F) goto yy3;
				goto yy57;
			} else {
				if (yych <= '3') {
					if (yych <= '/') goto yy3;
					goto yy662;
				} else {
					if (yych <= '5') goto yy645;
					if (yych <= '9') goto yy646;
					goto yy647;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych <= 'D') {
					if (yych <= 'C') goto yy3;
					goto yy57;
				} else {
					if (yych == 'F') goto yy57;
					goto yy3;
				}
			} else {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy57;
					goto yy3;
				} else {
					if (yych <= 'M') goto yy57;
					if (yych <= 'R') goto yy3;
					goto yy57;
				}
			}
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Y') {
				if (yych == 'W') goto yy57;
				if (yych <= 'X') goto yy3;
				goto yy57;
			} else {
				if (yych <= 'd') {
					if (yych <= 'c') goto yy3;
					goto yy57;
				} else {
					if (yych == 'f') goto yy57;
					goto yy3;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'l') {
					if (yych <= 'h') goto yy57;
					goto yy3;
				} else {
					if (yych <= 'm') goto yy57;
					if (yych <= 'r') goto yy3;
					goto yy57;
				}
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy3;
					goto yy57;
				} else {
					if (yych == 'y') goto yy57;
					goto yy3;
				}
			}
		}
	}
yy642:
	YYDEBUG(642, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= 'C') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy57;
				if (yych <= 0x1F) goto yy3;
				goto yy57;
			} else {
				if (yych <= '5') {
					if (yych <= '/') goto yy3;
					goto yy645;
				} else {
					if (yych <= '9') goto yy646;
					if (yych <= ':') goto yy647;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych == 'E') goto yy3;
				if (yych <= 'F') goto yy57;
				goto yy3;
			} else {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy57;
					goto yy3;
				} else {
					if (yych <= 'M') goto yy57;
					if (yych <= 'R') goto yy3;
					goto yy57;
				}
			}
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Y') {
				if (yych == 'W') goto yy57;
				if (yych <= 'X') goto yy3;
				goto yy57;
			} else {
				if (yych <= 'd') {
					if (yych <= 'c') goto yy3;
					goto yy57;
				} else {
					if (yych == 'f') goto yy57;
					goto yy3;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'l') {
					if (yych <= 'h') goto yy57;
					goto yy3;
				} else {
					if (yych <= 'm') goto yy57;
					if (yych <= 'r') goto yy3;
					goto yy57;
				}
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy3;
					goto yy57;
				} else {
					if (yych == 'y') goto yy57;
					goto yy3;
				}
			}
		}
	}
yy643:
	YYDEBUG(643, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(644, *YYCURSOR);
	if (yybm[0+yych] & 4) {
		goto yy54;
	}
	if (yych <= ',') {
		if (yych == '+') goto yy643;
		goto yy53;
	} else {
		if (yych <= '-') goto yy643;
		if (yych <= '/') goto yy53;
		if (yych <= '9') goto yy51;
		goto yy53;
	}
yy645:
	YYDEBUG(645, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy57;
				if (yych <= 0x1F) goto yy3;
				goto yy57;
			} else {
				if (yych <= '/') goto yy3;
				if (yych <= '9') goto yy661;
				if (yych <= 'C') goto yy3;
				goto yy57;
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy57;
				if (yych <= 'G') goto yy3;
				goto yy57;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy3;
					goto yy57;
				} else {
					if (yych <= 'R') goto yy3;
					if (yych <= 'T') goto yy57;
					goto yy3;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy3;
				if (yych <= 'Y') goto yy57;
				goto yy3;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy57;
					goto yy3;
				} else {
					if (yych == 'g') goto yy3;
					goto yy57;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy57;
				if (yych <= 'r') goto yy3;
				goto yy57;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy3;
					goto yy57;
				} else {
					if (yych == 'y') goto yy57;
					goto yy3;
				}
			}
		}
	}
yy646:
	YYDEBUG(646, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy57;
				if (yych <= 0x1F) goto yy3;
				goto yy57;
			} else {
				if (yych <= '/') goto yy3;
				if (yych <= '9') goto yy649;
				if (yych <= 'C') goto yy3;
				goto yy57;
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy57;
				if (yych <= 'G') goto yy3;
				goto yy57;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy3;
					goto yy57;
				} else {
					if (yych <= 'R') goto yy3;
					if (yych <= 'T') goto yy57;
					goto yy3;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy3;
				if (yych <= 'Y') goto yy57;
				goto yy3;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy57;
					goto yy3;
				} else {
					if (yych == 'g') goto yy3;
					goto yy57;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy57;
				if (yych <= 'r') goto yy3;
				goto yy57;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy3;
					goto yy57;
				} else {
					if (yych == 'y') goto yy57;
					goto yy3;
				}
			}
		}
	}
yy647:
	YYDEBUG(647, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy3;
	if (yych <= '5') goto yy648;
	if (yych <= '9') goto yy136;
	goto yy3;
yy648:
	YYDEBUG(648, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy3;
	if (yych <= '9') goto yy136;
	goto yy3;
yy649:
	YYDEBUG(649, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych >= ':') goto yy57;
yy650:
	YYDEBUG(650, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm[0+yych] & 2) {
		goto yy51;
	}
	if (yych != '-') goto yy57;
yy651:
	YYDEBUG(651, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '0') goto yy652;
	if (yych <= '1') goto yy653;
	goto yy53;
yy652:
	YYDEBUG(652, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy654;
	goto yy53;
yy653:
	YYDEBUG(653, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= '3') goto yy53;
yy654:
	YYDEBUG(654, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '-') goto yy53;
	YYDEBUG(655, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '0') goto yy656;
	if (yych <= '2') goto yy657;
	if (yych <= '3') goto yy658;
	goto yy53;
yy656:
	YYDEBUG(656, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy659;
	goto yy53;
yy657:
	YYDEBUG(657, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy659;
	goto yy53;
yy658:
	YYDEBUG(658, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= '2') goto yy53;
yy659:
	YYDEBUG(659, *YYCURSOR);
	++YYCURSOR;
yy660:
	YYDEBUG(660, *YYCURSOR);
	{
		DEBUG_OUTPUT("iso8601date4 | iso8601date2 | iso8601dateslash | dateslash");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_unsigned_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
yy661:
	YYDEBUG(661, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy57;
				if (yych <= 0x1F) goto yy3;
				goto yy57;
			} else {
				if (yych <= '/') goto yy3;
				if (yych <= '9') goto yy650;
				if (yych <= 'C') goto yy3;
				goto yy57;
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy57;
				if (yych <= 'G') goto yy3;
				goto yy57;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy3;
					goto yy57;
				} else {
					if (yych <= 'R') goto yy3;
					if (yych <= 'T') goto yy57;
					goto yy3;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy3;
				if (yych <= 'Y') goto yy57;
				goto yy3;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy57;
					goto yy3;
				} else {
					if (yych == 'g') goto yy3;
					goto yy57;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy57;
				if (yych <= 'r') goto yy3;
				goto yy57;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy3;
					goto yy57;
				} else {
					if (yych == 'y') goto yy57;
					goto yy3;
				}
			}
		}
	}
yy662:
	YYDEBUG(662, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= 'C') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy57;
				if (yych <= 0x1F) goto yy3;
				goto yy57;
			} else {
				if (yych <= '5') {
					if (yych <= '/') goto yy3;
				} else {
					if (yych <= '9') goto yy661;
					if (yych <= ':') goto yy647;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych == 'E') goto yy3;
				if (yych <= 'F') goto yy57;
				goto yy3;
			} else {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy57;
					goto yy3;
				} else {
					if (yych <= 'M') goto yy57;
					if (yych <= 'R') goto yy3;
					goto yy57;
				}
			}
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Y') {
				if (yych == 'W') goto yy57;
				if (yych <= 'X') goto yy3;
				goto yy57;
			} else {
				if (yych <= 'd') {
					if (yych <= 'c') goto yy3;
					goto yy57;
				} else {
					if (yych == 'f') goto yy57;
					goto yy3;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'l') {
					if (yych <= 'h') goto yy57;
					goto yy3;
				} else {
					if (yych <= 'm') goto yy57;
					if (yych <= 'r') goto yy3;
					goto yy57;
				}
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy3;
					goto yy57;
				} else {
					if (yych == 'y') goto yy57;
					goto yy3;
				}
			}
		}
	}
	YYDEBUG(663, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy57;
				if (yych <= 0x1F) goto yy3;
				goto yy57;
			} else {
				if (yych <= '/') goto yy3;
				if (yych <= '9') goto yy664;
				if (yych <= 'C') goto yy3;
				goto yy57;
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy57;
				if (yych <= 'G') goto yy3;
				goto yy57;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy3;
					goto yy57;
				} else {
					if (yych <= 'R') goto yy3;
					if (yych <= 'T') goto yy57;
					goto yy3;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy3;
				if (yych <= 'Y') goto yy57;
				goto yy3;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy57;
					goto yy3;
				} else {
					if (yych == 'g') goto yy3;
					goto yy57;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy57;
				if (yych <= 'r') goto yy3;
				goto yy57;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy3;
					goto yy57;
				} else {
					if (yych == 'y') goto yy57;
					goto yy3;
				}
			}
		}
	}
yy664:
	YYDEBUG(664, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 2) {
		goto yy51;
	}
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy57;
				if (yych <= 0x1F) goto yy3;
				goto yy57;
			} else {
				if (yych == '-') goto yy651;
				if (yych <= 'C') goto yy3;
				goto yy57;
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy57;
				if (yych <= 'G') goto yy3;
				goto yy57;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy3;
					goto yy57;
				} else {
					if (yych <= 'R') goto yy3;
					if (yych <= 'T') goto yy57;
					goto yy3;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy3;
				if (yych <= 'Y') goto yy57;
				goto yy3;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy57;
					goto yy3;
				} else {
					if (yych == 'g') goto yy3;
					goto yy57;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy57;
				if (yych <= 'r') goto yy3;
				goto yy57;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy3;
					goto yy57;
				} else {
					if (yych == 'y') goto yy57;
					goto yy3;
				}
			}
		}
	}
yy665:
	YYDEBUG(665, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy667;
	if (yych <= '0') goto yy921;
	if (yych <= '1') goto yy922;
	if (yych <= '9') goto yy923;
	goto yy667;
yy666:
	YYDEBUG(666, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
yy667:
	YYDEBUG(667, *YYCURSOR);
	YYDEBUG(-1, yych);
	switch (yych) {
	case '\t':
	case ' ':	goto yy666;
	case '-':
	case '.':	goto yy766;
	case 'A':
	case 'a':	goto yy685;
	case 'D':
	case 'd':	goto yy671;
	case 'F':
	case 'f':	goto yy672;
	case 'H':
	case 'h':	goto yy60;
	case 'I':	goto yy680;
	case 'J':
	case 'j':	goto yy684;
	case 'M':
	case 'm':	goto yy670;
	case 'N':
	case 'n':	goto yy687;
	case 'O':
	case 'o':	goto yy686;
	case 'P':
	case 'p':	goto yy689;
	case 'S':
	case 's':	goto yy668;
	case 'T':
	case 't':	goto yy65;
	case 'V':	goto yy682;
	case 'W':
	case 'w':	goto yy62;
	case 'X':	goto yy683;
	case 'Y':
	case 'y':	goto yy64;
	default:	goto yy53;
	}
yy668:
	YYDEBUG(668, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy123;
			goto yy53;
		} else {
			if (yych <= 'E') goto yy1231;
			if (yych <= 'T') goto yy53;
			goto yy122;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy123;
			goto yy53;
		} else {
			if (yych <= 'e') goto yy1231;
			if (yych == 'u') goto yy122;
			goto yy53;
		}
	}
yy669:
	YYDEBUG(669, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '`') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy123;
			goto yy53;
		} else {
			if (yych <= 'E') goto yy1231;
			if (yych == 'U') goto yy122;
			goto yy53;
		}
	} else {
		if (yych <= 'e') {
			if (yych <= 'a') goto yy123;
			if (yych <= 'd') goto yy53;
			goto yy1231;
		} else {
			if (yych <= 's') goto yy53;
			if (yych <= 't') goto yy914;
			if (yych <= 'u') goto yy122;
			goto yy53;
		}
	}
yy670:
	YYDEBUG(670, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'H') {
			if (yych == 'A') goto yy781;
			goto yy53;
		} else {
			if (yych <= 'I') goto yy114;
			if (yych <= 'N') goto yy53;
			goto yy113;
		}
	} else {
		if (yych <= 'h') {
			if (yych == 'a') goto yy781;
			goto yy53;
		} else {
			if (yych <= 'i') goto yy114;
			if (yych == 'o') goto yy113;
			goto yy53;
		}
	}
yy671:
	YYDEBUG(671, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych == 'A') goto yy110;
		if (yych <= 'D') goto yy53;
		goto yy768;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy53;
			goto yy110;
		} else {
			if (yych == 'e') goto yy768;
			goto yy53;
		}
	}
yy672:
	YYDEBUG(672, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'N') {
			if (yych == 'E') goto yy784;
			goto yy53;
		} else {
			if (yych <= 'O') goto yy83;
			if (yych <= 'Q') goto yy53;
			goto yy82;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'e') goto yy784;
			goto yy53;
		} else {
			if (yych <= 'o') goto yy83;
			if (yych == 'r') goto yy82;
			goto yy53;
		}
	}
yy673:
	YYDEBUG(673, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'H') goto yy66;
		if (yych <= 'T') goto yy53;
		goto yy67;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy53;
			goto yy1230;
		} else {
			if (yych == 'u') goto yy67;
			goto yy53;
		}
	}
yy674:
	YYDEBUG(674, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy927;
	if (yych <= '/') goto yy57;
	if (yych <= '9') goto yy926;
	goto yy57;
yy675:
	YYDEBUG(675, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'c') {
		if (yych == 'O') goto yy719;
		goto yy53;
	} else {
		if (yych <= 'd') goto yy914;
		if (yych == 'o') goto yy719;
		goto yy53;
	}
yy676:
	YYDEBUG(676, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy914;
	goto yy53;
yy677:
	YYDEBUG(677, *YYCURSOR);
	yych = *++YYCURSOR;
	YYDEBUG(-1, yych);
	switch (yych) {
	case '0':
	case '1':
	case '2':	goto yy854;
	case '3':	goto yy856;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy857;
	case 'A':
	case 'a':	goto yy861;
	case 'D':
	case 'd':	goto yy865;
	case 'F':
	case 'f':	goto yy859;
	case 'J':
	case 'j':	goto yy858;
	case 'M':
	case 'm':	goto yy860;
	case 'N':
	case 'n':	goto yy864;
	case 'O':
	case 'o':	goto yy863;
	case 'S':
	case 's':	goto yy862;
	default:	goto yy53;
	}
yy678:
	YYDEBUG(678, *YYCURSOR);
	yych = *++YYCURSOR;
	YYDEBUG(-1, yych);
	switch (yych) {
	case '0':	goto yy804;
	case '1':	goto yy805;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy806;
	case 'A':
	case 'a':	goto yy810;
	case 'D':
	case 'd':	goto yy814;
	case 'F':
	case 'f':	goto yy808;
	case 'J':
	case 'j':	goto yy807;
	case 'M':
	case 'm':	goto yy809;
	case 'N':
	case 'n':	goto yy813;
	case 'O':
	case 'o':	goto yy812;
	case 'S':
	case 's':	goto yy811;
	default:	goto yy767;
	}
yy679:
	YYDEBUG(679, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '1') {
		if (yych <= '/') goto yy767;
		if (yych <= '0') goto yy757;
		goto yy758;
	} else {
		if (yych <= '5') goto yy759;
		if (yych <= '9') goto yy760;
		goto yy767;
	}
yy680:
	YYDEBUG(680, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy721;
		} else {
			if (yych <= ' ') goto yy721;
			if (yych <= ',') goto yy681;
			if (yych <= '.') goto yy721;
		}
	} else {
		if (yych <= 'U') {
			if (yych <= '9') goto yy723;
			if (yych == 'I') goto yy756;
		} else {
			if (yych == 'W') goto yy681;
			if (yych <= 'X') goto yy729;
		}
	}
yy681:
	YYDEBUG(681, *YYCURSOR);
	{
		DEBUG_OUTPUT("datenoyearrev");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		timelib_skip_day_suffix((char **) &ptr);
		s->time->m = timelib_get_month((char **) &ptr);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_TEXT;
	}
yy682:
	YYDEBUG(682, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy681;
			goto yy721;
		} else {
			if (yych == ' ') goto yy721;
			goto yy681;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy721;
			if (yych <= '/') goto yy681;
			goto yy723;
		} else {
			if (yych == 'I') goto yy754;
			goto yy681;
		}
	}
yy683:
	YYDEBUG(683, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy681;
			goto yy721;
		} else {
			if (yych == ' ') goto yy721;
			goto yy681;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy721;
			if (yych <= '/') goto yy681;
			goto yy723;
		} else {
			if (yych == 'I') goto yy753;
			goto yy681;
		}
	}
yy684:
	YYDEBUG(684, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy746;
		if (yych <= 'T') goto yy53;
		goto yy745;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy53;
			goto yy746;
		} else {
			if (yych == 'u') goto yy745;
			goto yy53;
		}
	}
yy685:
	YYDEBUG(685, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= 'L') {
			if (yych == '.') goto yy690;
			goto yy53;
		} else {
			if (yych <= 'M') goto yy691;
			if (yych == 'P') goto yy739;
			goto yy53;
		}
	} else {
		if (yych <= 'o') {
			if (yych <= 'U') goto yy738;
			if (yych == 'm') goto yy691;
			goto yy53;
		} else {
			if (yych <= 'p') goto yy739;
			if (yych == 'u') goto yy738;
			goto yy53;
		}
	}
yy686:
	YYDEBUG(686, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy733;
	if (yych == 'c') goto yy733;
	goto yy53;
yy687:
	YYDEBUG(687, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy719;
	if (yych == 'o') goto yy719;
	goto yy53;
yy688:
	YYDEBUG(688, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy695;
	if (yych <= '9') goto yy697;
	goto yy53;
yy689:
	YYDEBUG(689, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych != '.') goto yy53;
	} else {
		if (yych <= 'M') goto yy691;
		if (yych == 'm') goto yy691;
		goto yy53;
	}
yy690:
	YYDEBUG(690, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy691;
	if (yych != 'm') goto yy53;
yy691:
	YYDEBUG(691, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy693;
		if (yych == '\t') goto yy693;
		goto yy53;
	} else {
		if (yych <= ' ') goto yy693;
		if (yych != '.') goto yy53;
	}
	YYDEBUG(692, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy693;
		if (yych <= 0x08) goto yy53;
	} else {
		if (yych != ' ') goto yy53;
	}
yy693:
	YYDEBUG(693, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(694, *YYCURSOR);
	{
		DEBUG_OUTPUT("timetiny12 | timeshort12 | timelong12");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->i = timelib_get_nr((char **) &ptr, 2);
			if (*ptr == ':' || *ptr == '.') {
				s->time->s = timelib_get_nr((char **) &ptr, 2);
			}
		}
		s->time->h += timelib_meridian((char **) &ptr, s->time->h);
		TIMELIB_DEINIT;
		return TIMELIB_TIME12;
	}
yy695:
	YYDEBUG(695, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy698;
	} else {
		if (yych <= '9') goto yy712;
		if (yych <= ':') goto yy698;
	}
yy696:
	YYDEBUG(696, *YYCURSOR);
	{
		int tz_not_found;
		DEBUG_OUTPUT("timeshort24 | timelong24 | iso8601long");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->s = timelib_get_nr((char **) &ptr, 2);

			if (*ptr == '.') {
				s->time->f = timelib_get_frac_nr((char **) &ptr, 8);
			}
		}

		if (*ptr != '\0') {
			s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
			if (tz_not_found) {
				add_error(s, "The timezone could not be found in the database");
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_TIME24_WITH_ZONE;
	}
yy697:
	YYDEBUG(697, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy698;
	if (yych != ':') goto yy696;
yy698:
	YYDEBUG(698, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy699;
	if (yych <= '6') goto yy700;
	if (yych <= '9') goto yy701;
	goto yy53;
yy699:
	YYDEBUG(699, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy702;
	if (yych <= '/') goto yy696;
	if (yych <= '9') goto yy705;
	goto yy696;
yy700:
	YYDEBUG(700, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy702;
	if (yych == '0') goto yy705;
	goto yy696;
yy701:
	YYDEBUG(701, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych != '.') goto yy696;
yy702:
	YYDEBUG(702, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= ':') goto yy53;
yy703:
	YYDEBUG(703, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(704, *YYCURSOR);
	if (yych <= '/') goto yy696;
	if (yych <= '9') goto yy703;
	goto yy696;
yy705:
	YYDEBUG(705, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= 0x1F) {
			if (yych != '\t') goto yy696;
		} else {
			if (yych <= ' ') goto yy706;
			if (yych == '.') goto yy702;
			goto yy696;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'A') goto yy708;
			if (yych == 'P') goto yy708;
			goto yy696;
		} else {
			if (yych <= 'a') goto yy708;
			if (yych == 'p') goto yy708;
			goto yy696;
		}
	}
yy706:
	YYDEBUG(706, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	YYDEBUG(707, *YYCURSOR);
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy706;
			goto yy53;
		} else {
			if (yych <= ' ') goto yy706;
			if (yych <= '@') goto yy53;
		}
	} else {
		if (yych <= '`') {
			if (yych != 'P') goto yy53;
		} else {
			if (yych <= 'a') goto yy708;
			if (yych != 'p') goto yy53;
		}
	}
yy708:
	YYDEBUG(708, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych != '.') goto yy53;
	} else {
		if (yych <= 'M') goto yy710;
		if (yych == 'm') goto yy710;
		goto yy53;
	}
	YYDEBUG(709, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy710;
	if (yych != 'm') goto yy53;
yy710:
	YYDEBUG(710, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy693;
		if (yych == '\t') goto yy693;
		goto yy53;
	} else {
		if (yych <= ' ') goto yy693;
		if (yych != '.') goto yy53;
	}
	YYDEBUG(711, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy693;
		if (yych <= 0x08) goto yy53;
		goto yy693;
	} else {
		if (yych == ' ') goto yy693;
		goto yy53;
	}
yy712:
	YYDEBUG(712, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy713;
			if (yych <= 0x1F) goto yy696;
		} else {
			if (yych == '.') goto yy698;
			if (yych <= '9') goto yy696;
			goto yy698;
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy715;
			if (yych <= 'O') goto yy696;
			goto yy715;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy696;
				goto yy715;
			} else {
				if (yych == 'p') goto yy715;
				goto yy696;
			}
		}
	}
yy713:
	YYDEBUG(713, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	YYDEBUG(714, *YYCURSOR);
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy713;
			goto yy53;
		} else {
			if (yych <= ' ') goto yy713;
			if (yych <= '@') goto yy53;
		}
	} else {
		if (yych <= '`') {
			if (yych != 'P') goto yy53;
		} else {
			if (yych <= 'a') goto yy715;
			if (yych != 'p') goto yy53;
		}
	}
yy715:
	YYDEBUG(715, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych != '.') goto yy53;
	} else {
		if (yych <= 'M') goto yy717;
		if (yych == 'm') goto yy717;
		goto yy53;
	}
	YYDEBUG(716, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy717;
	if (yych != 'm') goto yy53;
yy717:
	YYDEBUG(717, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy693;
		if (yych == '\t') goto yy693;
		goto yy53;
	} else {
		if (yych <= ' ') goto yy693;
		if (yych != '.') goto yy53;
	}
	YYDEBUG(718, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy693;
		if (yych <= 0x08) goto yy53;
		goto yy693;
	} else {
		if (yych == ' ') goto yy693;
		goto yy53;
	}
yy719:
	YYDEBUG(719, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy720;
	if (yych != 'v') goto yy53;
yy720:
	YYDEBUG(720, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych != '\t') goto yy681;
		} else {
			if (yych <= ' ') goto yy721;
			if (yych <= ',') goto yy681;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy681;
			if (yych <= '9') goto yy723;
			goto yy681;
		} else {
			if (yych <= 'E') goto yy725;
			if (yych == 'e') goto yy725;
			goto yy681;
		}
	}
yy721:
	YYDEBUG(721, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 4) YYFILL(4);
	yych = *YYCURSOR;
yy722:
	YYDEBUG(722, *YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy721;
		if (yych <= 0x1F) goto yy53;
		goto yy721;
	} else {
		if (yych <= '.') {
			if (yych <= ',') goto yy53;
			goto yy721;
		} else {
			if (yych <= '/') goto yy53;
			if (yych >= ':') goto yy53;
		}
	}
yy723:
	YYDEBUG(723, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '/') goto yy724;
	if (yych <= '9') goto yy730;
yy724:
	YYDEBUG(724, *YYCURSOR);
	{
		DEBUG_OUTPUT("datefull");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		timelib_skip_day_suffix((char **) &ptr);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_FULL;
	}
yy725:
	YYDEBUG(725, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy726;
	if (yych != 'm') goto yy53;
yy726:
	YYDEBUG(726, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy727;
	if (yych != 'b') goto yy53;
yy727:
	YYDEBUG(727, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy728;
	if (yych != 'e') goto yy53;
yy728:
	YYDEBUG(728, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy729;
	if (yych != 'r') goto yy53;
yy729:
	YYDEBUG(729, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy721;
		if (yych <= 0x1F) goto yy681;
		goto yy721;
	} else {
		if (yych <= '.') {
			if (yych <= ',') goto yy681;
			goto yy721;
		} else {
			if (yych <= '/') goto yy681;
			if (yych <= '9') goto yy723;
			goto yy681;
		}
	}
yy730:
	YYDEBUG(730, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy724;
	if (yych >= ':') goto yy724;
yy731:
	YYDEBUG(731, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy724;
	if (yych >= ':') goto yy724;
	YYDEBUG(732, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy724;
yy733:
	YYDEBUG(733, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy734;
	if (yych != 't') goto yy53;
yy734:
	YYDEBUG(734, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy721;
			goto yy681;
		} else {
			if (yych <= ' ') goto yy721;
			if (yych <= ',') goto yy681;
			goto yy721;
		}
	} else {
		if (yych <= 'N') {
			if (yych <= '/') goto yy681;
			if (yych <= '9') goto yy723;
			goto yy681;
		} else {
			if (yych <= 'O') goto yy735;
			if (yych != 'o') goto yy681;
		}
	}
yy735:
	YYDEBUG(735, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy736;
	if (yych != 'b') goto yy53;
yy736:
	YYDEBUG(736, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy737;
	if (yych != 'e') goto yy53;
yy737:
	YYDEBUG(737, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy729;
	if (yych == 'r') goto yy729;
	goto yy53;
yy738:
	YYDEBUG(738, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy742;
	if (yych == 'g') goto yy742;
	goto yy53;
yy739:
	YYDEBUG(739, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy740;
	if (yych != 'r') goto yy53;
yy740:
	YYDEBUG(740, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy721;
			goto yy681;
		} else {
			if (yych <= ' ') goto yy721;
			if (yych <= ',') goto yy681;
			goto yy721;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy681;
			if (yych <= '9') goto yy723;
			goto yy681;
		} else {
			if (yych <= 'I') goto yy741;
			if (yych != 'i') goto yy681;
		}
	}
yy741:
	YYDEBUG(741, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'L') goto yy729;
	if (yych == 'l') goto yy729;
	goto yy53;
yy742:
	YYDEBUG(742, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy721;
			goto yy681;
		} else {
			if (yych <= ' ') goto yy721;
			if (yych <= ',') goto yy681;
			goto yy721;
		}
	} else {
		if (yych <= 'T') {
			if (yych <= '/') goto yy681;
			if (yych <= '9') goto yy723;
			goto yy681;
		} else {
			if (yych <= 'U') goto yy743;
			if (yych != 'u') goto yy681;
		}
	}
yy743:
	YYDEBUG(743, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy744;
	if (yych != 's') goto yy53;
yy744:
	YYDEBUG(744, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy729;
	if (yych == 't') goto yy729;
	goto yy53;
yy745:
	YYDEBUG(745, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy752;
		if (yych <= 'M') goto yy53;
		goto yy751;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy53;
			goto yy752;
		} else {
			if (yych == 'n') goto yy751;
			goto yy53;
		}
	}
yy746:
	YYDEBUG(746, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy747;
	if (yych != 'n') goto yy53;
yy747:
	YYDEBUG(747, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy721;
			goto yy681;
		} else {
			if (yych <= ' ') goto yy721;
			if (yych <= ',') goto yy681;
			goto yy721;
		}
	} else {
		if (yych <= 'T') {
			if (yych <= '/') goto yy681;
			if (yych <= '9') goto yy723;
			goto yy681;
		} else {
			if (yych <= 'U') goto yy748;
			if (yych != 'u') goto yy681;
		}
	}
yy748:
	YYDEBUG(748, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy749;
	if (yych != 'a') goto yy53;
yy749:
	YYDEBUG(749, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy750;
	if (yych != 'r') goto yy53;
yy750:
	YYDEBUG(750, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy729;
	if (yych == 'y') goto yy729;
	goto yy53;
yy751:
	YYDEBUG(751, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy721;
			goto yy681;
		} else {
			if (yych <= ' ') goto yy721;
			if (yych <= ',') goto yy681;
			goto yy721;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy681;
			if (yych <= '9') goto yy723;
			goto yy681;
		} else {
			if (yych <= 'E') goto yy729;
			if (yych == 'e') goto yy729;
			goto yy681;
		}
	}
yy752:
	YYDEBUG(752, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy721;
			goto yy681;
		} else {
			if (yych <= ' ') goto yy721;
			if (yych <= ',') goto yy681;
			goto yy721;
		}
	} else {
		if (yych <= 'X') {
			if (yych <= '/') goto yy681;
			if (yych <= '9') goto yy723;
			goto yy681;
		} else {
			if (yych <= 'Y') goto yy729;
			if (yych == 'y') goto yy729;
			goto yy681;
		}
	}
yy753:
	YYDEBUG(753, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy681;
			goto yy721;
		} else {
			if (yych == ' ') goto yy721;
			goto yy681;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy721;
			if (yych <= '/') goto yy681;
			goto yy723;
		} else {
			if (yych == 'I') goto yy729;
			goto yy681;
		}
	}
yy754:
	YYDEBUG(754, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy681;
			goto yy721;
		} else {
			if (yych == ' ') goto yy721;
			goto yy681;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy721;
			if (yych <= '/') goto yy681;
			goto yy723;
		} else {
			if (yych != 'I') goto yy681;
		}
	}
	YYDEBUG(755, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy681;
			goto yy721;
		} else {
			if (yych == ' ') goto yy721;
			goto yy681;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy721;
			if (yych <= '/') goto yy681;
			goto yy723;
		} else {
			if (yych == 'I') goto yy729;
			goto yy681;
		}
	}
yy756:
	YYDEBUG(756, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy681;
			goto yy721;
		} else {
			if (yych == ' ') goto yy721;
			goto yy681;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy721;
			if (yych <= '/') goto yy681;
			goto yy723;
		} else {
			if (yych == 'I') goto yy729;
			goto yy681;
		}
	}
yy757:
	YYDEBUG(757, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy696;
		if (yych <= '-') goto yy791;
		goto yy790;
	} else {
		if (yych <= '/') goto yy696;
		if (yych <= '9') goto yy803;
		if (yych <= ':') goto yy698;
		goto yy696;
	}
yy758:
	YYDEBUG(758, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') goto yy696;
		if (yych <= '-') goto yy791;
		if (yych <= '.') goto yy790;
		goto yy696;
	} else {
		if (yych <= '2') goto yy803;
		if (yych <= '9') goto yy712;
		if (yych <= ':') goto yy698;
		goto yy696;
	}
yy759:
	YYDEBUG(759, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy696;
		if (yych <= '-') goto yy791;
		goto yy790;
	} else {
		if (yych <= '/') goto yy696;
		if (yych <= '9') goto yy712;
		if (yych <= ':') goto yy698;
		goto yy696;
	}
yy760:
	YYDEBUG(760, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy696;
		if (yych <= '-') goto yy791;
		goto yy790;
	} else {
		if (yych == ':') goto yy698;
		goto yy696;
	}
yy761:
	YYDEBUG(761, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy784;
	if (yych == 'e') goto yy784;
	goto yy53;
yy762:
	YYDEBUG(762, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy781;
	if (yych == 'a') goto yy781;
	goto yy53;
yy763:
	YYDEBUG(763, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy739;
		if (yych <= 'T') goto yy53;
		goto yy738;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy53;
			goto yy739;
		} else {
			if (yych == 'u') goto yy738;
			goto yy53;
		}
	}
yy764:
	YYDEBUG(764, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy774;
	if (yych == 'e') goto yy774;
	goto yy53;
yy765:
	YYDEBUG(765, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy768;
	if (yych == 'e') goto yy768;
	goto yy53;
yy766:
	YYDEBUG(766, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
yy767:
	YYDEBUG(767, *YYCURSOR);
	YYDEBUG(-1, yych);
	switch (yych) {
	case '\t':
	case ' ':
	case '-':
	case '.':	goto yy766;
	case 'A':
	case 'a':	goto yy763;
	case 'D':
	case 'd':	goto yy765;
	case 'F':
	case 'f':	goto yy761;
	case 'I':	goto yy680;
	case 'J':
	case 'j':	goto yy684;
	case 'M':
	case 'm':	goto yy762;
	case 'N':
	case 'n':	goto yy687;
	case 'O':
	case 'o':	goto yy686;
	case 'S':
	case 's':	goto yy764;
	case 'V':	goto yy682;
	case 'X':	goto yy683;
	default:	goto yy53;
	}
yy768:
	YYDEBUG(768, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy769;
	if (yych != 'c') goto yy53;
yy769:
	YYDEBUG(769, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy721;
			goto yy681;
		} else {
			if (yych <= ' ') goto yy721;
			if (yych <= ',') goto yy681;
			goto yy721;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy681;
			if (yych <= '9') goto yy723;
			goto yy681;
		} else {
			if (yych <= 'E') goto yy770;
			if (yych != 'e') goto yy681;
		}
	}
yy770:
	YYDEBUG(770, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy771;
	if (yych != 'm') goto yy53;
yy771:
	YYDEBUG(771, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy772;
	if (yych != 'b') goto yy53;
yy772:
	YYDEBUG(772, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy773;
	if (yych != 'e') goto yy53;
yy773:
	YYDEBUG(773, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy729;
	if (yych == 'r') goto yy729;
	goto yy53;
yy774:
	YYDEBUG(774, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy775;
	if (yych != 'p') goto yy53;
yy775:
	YYDEBUG(775, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy721;
			goto yy681;
		} else {
			if (yych <= ' ') goto yy721;
			if (yych <= ',') goto yy681;
			goto yy721;
		}
	} else {
		if (yych <= 'S') {
			if (yych <= '/') goto yy681;
			if (yych <= '9') goto yy723;
			goto yy681;
		} else {
			if (yych <= 'T') goto yy776;
			if (yych != 't') goto yy681;
		}
	}
yy776:
	YYDEBUG(776, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy721;
			goto yy681;
		} else {
			if (yych <= ' ') goto yy721;
			if (yych <= ',') goto yy681;
			goto yy721;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy681;
			if (yych <= '9') goto yy723;
			goto yy681;
		} else {
			if (yych <= 'E') goto yy777;
			if (yych != 'e') goto yy681;
		}
	}
yy777:
	YYDEBUG(777, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy778;
	if (yych != 'm') goto yy53;
yy778:
	YYDEBUG(778, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy779;
	if (yych != 'b') goto yy53;
yy779:
	YYDEBUG(779, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy780;
	if (yych != 'e') goto yy53;
yy780:
	YYDEBUG(780, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy729;
	if (yych == 'r') goto yy729;
	goto yy53;
yy781:
	YYDEBUG(781, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy782;
		if (yych <= 'X') goto yy53;
		goto yy729;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy53;
		} else {
			if (yych == 'y') goto yy729;
			goto yy53;
		}
	}
yy782:
	YYDEBUG(782, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy721;
			goto yy681;
		} else {
			if (yych <= ' ') goto yy721;
			if (yych <= ',') goto yy681;
			goto yy721;
		}
	} else {
		if (yych <= 'B') {
			if (yych <= '/') goto yy681;
			if (yych <= '9') goto yy723;
			goto yy681;
		} else {
			if (yych <= 'C') goto yy783;
			if (yych != 'c') goto yy681;
		}
	}
yy783:
	YYDEBUG(783, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy729;
	if (yych == 'h') goto yy729;
	goto yy53;
yy784:
	YYDEBUG(784, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy785;
	if (yych != 'b') goto yy53;
yy785:
	YYDEBUG(785, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy721;
			goto yy681;
		} else {
			if (yych <= ' ') goto yy721;
			if (yych <= ',') goto yy681;
			goto yy721;
		}
	} else {
		if (yych <= 'Q') {
			if (yych <= '/') goto yy681;
			if (yych <= '9') goto yy723;
			goto yy681;
		} else {
			if (yych <= 'R') goto yy786;
			if (yych != 'r') goto yy681;
		}
	}
yy786:
	YYDEBUG(786, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy787;
	if (yych != 'u') goto yy53;
yy787:
	YYDEBUG(787, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy788;
	if (yych != 'a') goto yy53;
yy788:
	YYDEBUG(788, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy789;
	if (yych != 'r') goto yy53;
yy789:
	YYDEBUG(789, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy729;
	if (yych == 'y') goto yy729;
	goto yy53;
yy790:
	YYDEBUG(790, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy797;
	if (yych <= '6') goto yy798;
	if (yych <= '9') goto yy799;
	goto yy53;
yy791:
	YYDEBUG(791, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= ':') goto yy53;
	YYDEBUG(792, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= ':') goto yy53;
yy793:
	YYDEBUG(793, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= ':') goto yy53;
yy794:
	YYDEBUG(794, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= ':') goto yy53;
	YYDEBUG(795, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(796, *YYCURSOR);
	{
		DEBUG_OUTPUT("pointed date YYYY");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_FULL_POINTED;
	}
yy797:
	YYDEBUG(797, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy702;
	if (yych <= '/') goto yy696;
	if (yych <= '9') goto yy802;
	goto yy696;
yy798:
	YYDEBUG(798, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy702;
		goto yy696;
	} else {
		if (yych <= '0') goto yy802;
		if (yych <= '9') goto yy800;
		goto yy696;
	}
yy799:
	YYDEBUG(799, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy702;
	if (yych <= '/') goto yy696;
	if (yych >= ':') goto yy696;
yy800:
	YYDEBUG(800, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy801;
	if (yych <= '9') goto yy794;
yy801:
	YYDEBUG(801, *YYCURSOR);
	{
		DEBUG_OUTPUT("pointed date YY");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_FULL_POINTED;
	}
yy802:
	YYDEBUG(802, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy706;
			if (yych <= 0x1F) goto yy696;
			goto yy706;
		} else {
			if (yych == '.') goto yy702;
			if (yych <= '/') goto yy696;
			goto yy794;
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy708;
			if (yych <= 'O') goto yy696;
			goto yy708;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy696;
				goto yy708;
			} else {
				if (yych == 'p') goto yy708;
				goto yy696;
			}
		}
	}
yy803:
	YYDEBUG(803, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy713;
			if (yych <= 0x1F) goto yy696;
			goto yy713;
		} else {
			if (yych <= '-') {
				if (yych <= ',') goto yy696;
				goto yy791;
			} else {
				if (yych <= '.') goto yy790;
				if (yych <= '9') goto yy696;
				goto yy698;
			}
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy715;
			if (yych <= 'O') goto yy696;
			goto yy715;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy696;
				goto yy715;
			} else {
				if (yych == 'p') goto yy715;
				goto yy696;
			}
		}
	}
yy804:
	YYDEBUG(804, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy53;
		if (yych <= '-') goto yy843;
		goto yy791;
	} else {
		if (yych <= '/') goto yy53;
		if (yych <= '9') goto yy806;
		goto yy53;
	}
yy805:
	YYDEBUG(805, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy53;
		if (yych <= '-') goto yy843;
		goto yy791;
	} else {
		if (yych <= '/') goto yy53;
		if (yych >= '3') goto yy53;
	}
yy806:
	YYDEBUG(806, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy53;
	if (yych <= '-') goto yy843;
	if (yych <= '.') goto yy791;
	goto yy53;
yy807:
	YYDEBUG(807, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy839;
		if (yych <= 'T') goto yy53;
		goto yy838;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy53;
			goto yy839;
		} else {
			if (yych == 'u') goto yy838;
			goto yy53;
		}
	}
yy808:
	YYDEBUG(808, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy836;
	if (yych == 'e') goto yy836;
	goto yy53;
yy809:
	YYDEBUG(809, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy833;
	if (yych == 'a') goto yy833;
	goto yy53;
yy810:
	YYDEBUG(810, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy830;
		if (yych <= 'T') goto yy53;
		goto yy829;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy53;
			goto yy830;
		} else {
			if (yych == 'u') goto yy829;
			goto yy53;
		}
	}
yy811:
	YYDEBUG(811, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy826;
	if (yych == 'e') goto yy826;
	goto yy53;
yy812:
	YYDEBUG(812, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy824;
	if (yych == 'c') goto yy824;
	goto yy53;
yy813:
	YYDEBUG(813, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy822;
	if (yych == 'o') goto yy822;
	goto yy53;
yy814:
	YYDEBUG(814, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy815;
	if (yych != 'e') goto yy53;
yy815:
	YYDEBUG(815, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy816;
	if (yych != 'c') goto yy53;
yy816:
	YYDEBUG(816, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy721;
			goto yy681;
		} else {
			if (yych <= ' ') goto yy721;
			if (yych <= ',') goto yy681;
			if (yych >= '.') goto yy721;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy681;
			if (yych <= '9') goto yy723;
			goto yy681;
		} else {
			if (yych <= 'E') goto yy770;
			if (yych == 'e') goto yy770;
			goto yy681;
		}
	}
yy817:
	YYDEBUG(817, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy722;
	if (yych <= '0') goto yy818;
	if (yych <= '2') goto yy819;
	if (yych <= '3') goto yy820;
	goto yy722;
yy818:
	YYDEBUG(818, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy724;
	if (yych <= '9') goto yy821;
	goto yy724;
yy819:
	YYDEBUG(819, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy724;
	if (yych <= '9') goto yy821;
	goto yy724;
yy820:
	YYDEBUG(820, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy724;
	if (yych <= '1') goto yy821;
	if (yych <= '9') goto yy730;
	goto yy724;
yy821:
	YYDEBUG(821, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy724;
	if (yych <= '9') goto yy731;
	goto yy724;
yy822:
	YYDEBUG(822, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy823;
	if (yych != 'v') goto yy53;
yy823:
	YYDEBUG(823, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy721;
			goto yy681;
		} else {
			if (yych <= ' ') goto yy721;
			if (yych <= ',') goto yy681;
			if (yych <= '-') goto yy817;
			goto yy721;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy681;
			if (yych <= '9') goto yy723;
			goto yy681;
		} else {
			if (yych <= 'E') goto yy725;
			if (yych == 'e') goto yy725;
			goto yy681;
		}
	}
yy824:
	YYDEBUG(824, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy825;
	if (yych != 't') goto yy53;
yy825:
	YYDEBUG(825, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy721;
			goto yy681;
		} else {
			if (yych <= ' ') goto yy721;
			if (yych <= ',') goto yy681;
			if (yych <= '-') goto yy817;
			goto yy721;
		}
	} else {
		if (yych <= 'N') {
			if (yych <= '/') goto yy681;
			if (yych <= '9') goto yy723;
			goto yy681;
		} else {
			if (yych <= 'O') goto yy735;
			if (yych == 'o') goto yy735;
			goto yy681;
		}
	}
yy826:
	YYDEBUG(826, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy827;
	if (yych != 'p') goto yy53;
yy827:
	YYDEBUG(827, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy721;
			goto yy681;
		} else {
			if (yych <= ' ') goto yy721;
			if (yych <= ',') goto yy681;
			if (yych <= '-') goto yy817;
			goto yy721;
		}
	} else {
		if (yych <= 'S') {
			if (yych <= '/') goto yy681;
			if (yych <= '9') goto yy723;
			goto yy681;
		} else {
			if (yych <= 'T') goto yy828;
			if (yych != 't') goto yy681;
		}
	}
yy828:
	YYDEBUG(828, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy721;
			goto yy681;
		} else {
			if (yych <= ' ') goto yy721;
			if (yych <= ',') goto yy681;
			if (yych <= '-') goto yy817;
			goto yy721;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy681;
			if (yych <= '9') goto yy723;
			goto yy681;
		} else {
			if (yych <= 'E') goto yy777;
			if (yych == 'e') goto yy777;
			goto yy681;
		}
	}
yy829:
	YYDEBUG(829, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy832;
	if (yych == 'g') goto yy832;
	goto yy53;
yy830:
	YYDEBUG(830, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy831;
	if (yych != 'r') goto yy53;
yy831:
	YYDEBUG(831, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy721;
			goto yy681;
		} else {
			if (yych <= ' ') goto yy721;
			if (yych <= ',') goto yy681;
			if (yych <= '-') goto yy817;
			goto yy721;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy681;
			if (yych <= '9') goto yy723;
			goto yy681;
		} else {
			if (yych <= 'I') goto yy741;
			if (yych == 'i') goto yy741;
			goto yy681;
		}
	}
yy832:
	YYDEBUG(832, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy721;
			goto yy681;
		} else {
			if (yych <= ' ') goto yy721;
			if (yych <= ',') goto yy681;
			if (yych <= '-') goto yy817;
			goto yy721;
		}
	} else {
		if (yych <= 'T') {
			if (yych <= '/') goto yy681;
			if (yych <= '9') goto yy723;
			goto yy681;
		} else {
			if (yych <= 'U') goto yy743;
			if (yych == 'u') goto yy743;
			goto yy681;
		}
	}
yy833:
	YYDEBUG(833, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy834;
		if (yych <= 'X') goto yy53;
		goto yy835;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy53;
		} else {
			if (yych == 'y') goto yy835;
			goto yy53;
		}
	}
yy834:
	YYDEBUG(834, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy721;
			goto yy681;
		} else {
			if (yych <= ' ') goto yy721;
			if (yych <= ',') goto yy681;
			if (yych <= '-') goto yy817;
			goto yy721;
		}
	} else {
		if (yych <= 'B') {
			if (yych <= '/') goto yy681;
			if (yych <= '9') goto yy723;
			goto yy681;
		} else {
			if (yych <= 'C') goto yy783;
			if (yych == 'c') goto yy783;
			goto yy681;
		}
	}
yy835:
	YYDEBUG(835, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy681;
			goto yy721;
		} else {
			if (yych == ' ') goto yy721;
			goto yy681;
		}
	} else {
		if (yych <= '.') {
			if (yych <= '-') goto yy817;
			goto yy721;
		} else {
			if (yych <= '/') goto yy681;
			if (yych <= '9') goto yy723;
			goto yy681;
		}
	}
yy836:
	YYDEBUG(836, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy837;
	if (yych != 'b') goto yy53;
yy837:
	YYDEBUG(837, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy721;
			goto yy681;
		} else {
			if (yych <= ' ') goto yy721;
			if (yych <= ',') goto yy681;
			if (yych <= '-') goto yy817;
			goto yy721;
		}
	} else {
		if (yych <= 'Q') {
			if (yych <= '/') goto yy681;
			if (yych <= '9') goto yy723;
			goto yy681;
		} else {
			if (yych <= 'R') goto yy786;
			if (yych == 'r') goto yy786;
			goto yy681;
		}
	}
yy838:
	YYDEBUG(838, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy842;
		if (yych <= 'M') goto yy53;
		goto yy841;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy53;
			goto yy842;
		} else {
			if (yych == 'n') goto yy841;
			goto yy53;
		}
	}
yy839:
	YYDEBUG(839, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy840;
	if (yych != 'n') goto yy53;
yy840:
	YYDEBUG(840, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy721;
			goto yy681;
		} else {
			if (yych <= ' ') goto yy721;
			if (yych <= ',') goto yy681;
			if (yych <= '-') goto yy817;
			goto yy721;
		}
	} else {
		if (yych <= 'T') {
			if (yych <= '/') goto yy681;
			if (yych <= '9') goto yy723;
			goto yy681;
		} else {
			if (yych <= 'U') goto yy748;
			if (yych == 'u') goto yy748;
			goto yy681;
		}
	}
yy841:
	YYDEBUG(841, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy721;
			goto yy681;
		} else {
			if (yych <= ' ') goto yy721;
			if (yych <= ',') goto yy681;
			if (yych <= '-') goto yy817;
			goto yy721;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy681;
			if (yych <= '9') goto yy723;
			goto yy681;
		} else {
			if (yych <= 'E') goto yy729;
			if (yych == 'e') goto yy729;
			goto yy681;
		}
	}
yy842:
	YYDEBUG(842, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy721;
			goto yy681;
		} else {
			if (yych <= ' ') goto yy721;
			if (yych <= ',') goto yy681;
			if (yych <= '-') goto yy817;
			goto yy721;
		}
	} else {
		if (yych <= 'X') {
			if (yych <= '/') goto yy681;
			if (yych <= '9') goto yy723;
			goto yy681;
		} else {
			if (yych <= 'Y') goto yy729;
			if (yych == 'y') goto yy729;
			goto yy681;
		}
	}
yy843:
	YYDEBUG(843, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '2') goto yy844;
	if (yych <= '3') goto yy846;
	if (yych <= '9') goto yy847;
	goto yy53;
yy844:
	YYDEBUG(844, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy845;
		if (yych <= '9') goto yy853;
		if (yych >= 'n') goto yy849;
	} else {
		if (yych <= 'r') {
			if (yych >= 'r') goto yy850;
		} else {
			if (yych <= 's') goto yy848;
			if (yych <= 't') goto yy851;
		}
	}
yy845:
	YYDEBUG(845, *YYCURSOR);
	{
		DEBUG_OUTPUT("gnudateshort");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
yy846:
	YYDEBUG(846, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '1') {
			if (yych <= '/') goto yy845;
			goto yy853;
		} else {
			if (yych <= '9') goto yy793;
			if (yych <= 'm') goto yy845;
			goto yy849;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy845;
			goto yy850;
		} else {
			if (yych <= 's') goto yy848;
			if (yych <= 't') goto yy851;
			goto yy845;
		}
	}
yy847:
	YYDEBUG(847, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy845;
		if (yych <= '9') goto yy793;
		if (yych <= 'm') goto yy845;
		goto yy849;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy845;
			goto yy850;
		} else {
			if (yych <= 's') goto yy848;
			if (yych <= 't') goto yy851;
			goto yy845;
		}
	}
yy848:
	YYDEBUG(848, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy852;
	goto yy53;
yy849:
	YYDEBUG(849, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy852;
	goto yy53;
yy850:
	YYDEBUG(850, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy852;
	goto yy53;
yy851:
	YYDEBUG(851, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != 'h') goto yy53;
yy852:
	YYDEBUG(852, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy845;
yy853:
	YYDEBUG(853, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy845;
		if (yych <= '9') goto yy794;
		if (yych <= 'm') goto yy845;
		goto yy849;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy845;
			goto yy850;
		} else {
			if (yych <= 's') goto yy848;
			if (yych <= 't') goto yy851;
			goto yy845;
		}
	}
yy854:
	YYDEBUG(854, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') {
			if (yych >= '/') goto yy908;
		} else {
			if (yych <= '9') goto yy857;
			if (yych >= 'n') goto yy905;
		}
	} else {
		if (yych <= 'r') {
			if (yych >= 'r') goto yy906;
		} else {
			if (yych <= 's') goto yy904;
			if (yych <= 't') goto yy907;
		}
	}
yy855:
	YYDEBUG(855, *YYCURSOR);
	{
		DEBUG_OUTPUT("americanshort | american");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == '/') {
			s->time->y = timelib_get_nr((char **) &ptr, 4);
			TIMELIB_PROCESS_YEAR(s->time->y);
		}
		TIMELIB_DEINIT;
		return TIMELIB_AMERICAN;
	}
yy856:
	YYDEBUG(856, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') {
			if (yych <= '.') goto yy855;
			goto yy908;
		} else {
			if (yych <= '1') goto yy857;
			if (yych <= 'm') goto yy855;
			goto yy905;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy855;
			goto yy906;
		} else {
			if (yych <= 's') goto yy904;
			if (yych <= 't') goto yy907;
			goto yy855;
		}
	}
yy857:
	YYDEBUG(857, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == '/') goto yy908;
		if (yych <= 'm') goto yy855;
		goto yy905;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy855;
			goto yy906;
		} else {
			if (yych <= 's') goto yy904;
			if (yych <= 't') goto yy907;
			goto yy855;
		}
	}
yy858:
	YYDEBUG(858, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy903;
		if (yych <= 'T') goto yy53;
		goto yy902;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy53;
			goto yy903;
		} else {
			if (yych == 'u') goto yy902;
			goto yy53;
		}
	}
yy859:
	YYDEBUG(859, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy901;
	if (yych == 'e') goto yy901;
	goto yy53;
yy860:
	YYDEBUG(860, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy900;
	if (yych == 'a') goto yy900;
	goto yy53;
yy861:
	YYDEBUG(861, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy899;
		if (yych <= 'T') goto yy53;
		goto yy898;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy53;
			goto yy899;
		} else {
			if (yych == 'u') goto yy898;
			goto yy53;
		}
	}
yy862:
	YYDEBUG(862, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy896;
	if (yych == 'e') goto yy896;
	goto yy53;
yy863:
	YYDEBUG(863, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy895;
	if (yych == 'c') goto yy895;
	goto yy53;
yy864:
	YYDEBUG(864, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy894;
	if (yych == 'o') goto yy894;
	goto yy53;
yy865:
	YYDEBUG(865, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy866;
	if (yych != 'e') goto yy53;
yy866:
	YYDEBUG(866, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy867;
	if (yych != 'c') goto yy53;
yy867:
	YYDEBUG(867, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '/') goto yy53;
yy868:
	YYDEBUG(868, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= ':') goto yy53;
	YYDEBUG(869, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= ':') goto yy53;
	YYDEBUG(870, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= ':') goto yy53;
	YYDEBUG(871, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= ':') goto yy53;
	YYDEBUG(872, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy53;
	YYDEBUG(873, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '1') goto yy874;
	if (yych <= '2') goto yy875;
	goto yy53;
yy874:
	YYDEBUG(874, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy876;
	goto yy53;
yy875:
	YYDEBUG(875, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= '4') goto yy53;
yy876:
	YYDEBUG(876, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy53;
	YYDEBUG(877, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= '6') goto yy53;
	YYDEBUG(878, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= ':') goto yy53;
	YYDEBUG(879, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy53;
	YYDEBUG(880, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy881;
	if (yych <= '6') goto yy882;
	goto yy53;
yy881:
	YYDEBUG(881, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy883;
	goto yy53;
yy882:
	YYDEBUG(882, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '0') goto yy53;
yy883:
	YYDEBUG(883, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '\t') goto yy884;
	if (yych != ' ') goto yy53;
yy884:
	YYDEBUG(884, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 6) YYFILL(6);
	yych = *YYCURSOR;
	YYDEBUG(885, *YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy884;
		if (yych <= 0x1F) goto yy53;
		goto yy884;
	} else {
		if (yych <= '+') {
			if (yych <= '*') goto yy53;
		} else {
			if (yych != '-') goto yy53;
		}
	}
	YYDEBUG(886, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '1') goto yy887;
	if (yych <= '2') goto yy889;
	if (yych <= '9') goto yy890;
	goto yy53;
yy887:
	YYDEBUG(887, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '/') goto yy888;
	if (yych <= '9') goto yy890;
	if (yych <= ':') goto yy891;
yy888:
	YYDEBUG(888, *YYCURSOR);
	{
		int tz_not_found;
		DEBUG_OUTPUT("clf");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		s->time->s = timelib_get_nr((char **) &ptr, 2);
		s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
		if (tz_not_found) {
			add_error(s, "The timezone could not be found in the database");
		}
		TIMELIB_DEINIT;
		return TIMELIB_CLF;
	}
yy889:
	YYDEBUG(889, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy888;
		if (yych >= '4') goto yy892;
	} else {
		if (yych <= '9') goto yy893;
		if (yych <= ':') goto yy891;
		goto yy888;
	}
yy890:
	YYDEBUG(890, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy888;
	if (yych <= '5') goto yy892;
	if (yych <= '9') goto yy893;
	if (yych >= ';') goto yy888;
yy891:
	YYDEBUG(891, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy888;
	if (yych <= '5') goto yy892;
	if (yych <= '9') goto yy893;
	goto yy888;
yy892:
	YYDEBUG(892, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy888;
	if (yych >= ':') goto yy888;
yy893:
	YYDEBUG(893, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy888;
yy894:
	YYDEBUG(894, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy867;
	if (yych == 'v') goto yy867;
	goto yy53;
yy895:
	YYDEBUG(895, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy867;
	if (yych == 't') goto yy867;
	goto yy53;
yy896:
	YYDEBUG(896, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy897;
	if (yych != 'p') goto yy53;
yy897:
	YYDEBUG(897, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == '/') goto yy868;
		goto yy53;
	} else {
		if (yych <= 'T') goto yy867;
		if (yych == 't') goto yy867;
		goto yy53;
	}
yy898:
	YYDEBUG(898, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy867;
	if (yych == 'g') goto yy867;
	goto yy53;
yy899:
	YYDEBUG(899, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy867;
	if (yych == 'r') goto yy867;
	goto yy53;
yy900:
	YYDEBUG(900, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy867;
		if (yych <= 'X') goto yy53;
		goto yy867;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy53;
			goto yy867;
		} else {
			if (yych == 'y') goto yy867;
			goto yy53;
		}
	}
yy901:
	YYDEBUG(901, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy867;
	if (yych == 'b') goto yy867;
	goto yy53;
yy902:
	YYDEBUG(902, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy867;
		if (yych <= 'M') goto yy53;
		goto yy867;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy53;
			goto yy867;
		} else {
			if (yych == 'n') goto yy867;
			goto yy53;
		}
	}
yy903:
	YYDEBUG(903, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy867;
	if (yych == 'n') goto yy867;
	goto yy53;
yy904:
	YYDEBUG(904, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy913;
	goto yy53;
yy905:
	YYDEBUG(905, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy913;
	goto yy53;
yy906:
	YYDEBUG(906, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy913;
	goto yy53;
yy907:
	YYDEBUG(907, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy913;
	goto yy53;
yy908:
	YYDEBUG(908, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= ':') goto yy53;
	YYDEBUG(909, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy855;
	if (yych >= ':') goto yy855;
	YYDEBUG(910, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy855;
	if (yych >= ':') goto yy855;
	YYDEBUG(911, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy855;
	if (yych >= ':') goto yy855;
	YYDEBUG(912, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy855;
yy913:
	YYDEBUG(913, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '/') goto yy908;
	goto yy855;
yy914:
	YYDEBUG(914, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') {
		if (yych == '\t') goto yy916;
		goto yy767;
	} else {
		if (yych <= '-') goto yy917;
		if (yych <= '.') goto yy916;
		if (yych >= '0') goto yy767;
	}
yy915:
	YYDEBUG(915, *YYCURSOR);
	yych = *++YYCURSOR;
	YYDEBUG(-1, yych);
	switch (yych) {
	case 'A':
	case 'a':	goto yy861;
	case 'D':
	case 'd':	goto yy865;
	case 'F':
	case 'f':	goto yy859;
	case 'J':
	case 'j':	goto yy858;
	case 'M':
	case 'm':	goto yy860;
	case 'N':
	case 'n':	goto yy864;
	case 'O':
	case 'o':	goto yy863;
	case 'S':
	case 's':	goto yy862;
	default:	goto yy53;
	}
yy916:
	YYDEBUG(916, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy767;
	if (yych <= '0') goto yy921;
	if (yych <= '1') goto yy922;
	if (yych <= '9') goto yy923;
	goto yy767;
yy917:
	YYDEBUG(917, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy767;
	if (yych <= '0') goto yy918;
	if (yych <= '1') goto yy919;
	if (yych <= '9') goto yy920;
	goto yy767;
yy918:
	YYDEBUG(918, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy53;
	if (yych <= '.') goto yy791;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy920;
	goto yy53;
yy919:
	YYDEBUG(919, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy53;
	if (yych <= '.') goto yy791;
	if (yych <= '/') goto yy53;
	if (yych >= '3') goto yy53;
yy920:
	YYDEBUG(920, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy53;
	if (yych <= '.') goto yy791;
	goto yy53;
yy921:
	YYDEBUG(921, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy53;
		if (yych <= '-') goto yy791;
		goto yy924;
	} else {
		if (yych <= '/') goto yy53;
		if (yych <= '9') goto yy923;
		goto yy53;
	}
yy922:
	YYDEBUG(922, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy53;
		if (yych <= '-') goto yy791;
		goto yy924;
	} else {
		if (yych <= '/') goto yy53;
		if (yych >= '3') goto yy53;
	}
yy923:
	YYDEBUG(923, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy53;
	if (yych <= '-') goto yy791;
	if (yych >= '/') goto yy53;
yy924:
	YYDEBUG(924, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= ':') goto yy53;
	YYDEBUG(925, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy800;
	goto yy53;
yy926:
	YYDEBUG(926, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy970;
	if (yych <= '/') goto yy57;
	if (yych <= '9') goto yy968;
	goto yy57;
yy927:
	YYDEBUG(927, *YYCURSOR);
	yych = *++YYCURSOR;
	YYDEBUG(-1, yych);
	switch (yych) {
	case '0':	goto yy936;
	case '1':	goto yy937;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy938;
	case 'A':
	case 'a':	goto yy931;
	case 'D':
	case 'd':	goto yy935;
	case 'F':
	case 'f':	goto yy929;
	case 'J':
	case 'j':	goto yy928;
	case 'M':
	case 'm':	goto yy930;
	case 'N':
	case 'n':	goto yy934;
	case 'O':
	case 'o':	goto yy933;
	case 'S':
	case 's':	goto yy932;
	default:	goto yy53;
	}
yy928:
	YYDEBUG(928, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy967;
		if (yych <= 'T') goto yy53;
		goto yy966;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy53;
			goto yy967;
		} else {
			if (yych == 'u') goto yy966;
			goto yy53;
		}
	}
yy929:
	YYDEBUG(929, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy965;
	if (yych == 'e') goto yy965;
	goto yy53;
yy930:
	YYDEBUG(930, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy964;
	if (yych == 'a') goto yy964;
	goto yy53;
yy931:
	YYDEBUG(931, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy963;
		if (yych <= 'T') goto yy53;
		goto yy962;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy53;
			goto yy963;
		} else {
			if (yych == 'u') goto yy962;
			goto yy53;
		}
	}
yy932:
	YYDEBUG(932, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy960;
	if (yych == 'e') goto yy960;
	goto yy53;
yy933:
	YYDEBUG(933, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy959;
	if (yych == 'c') goto yy959;
	goto yy53;
yy934:
	YYDEBUG(934, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy958;
	if (yych == 'o') goto yy958;
	goto yy53;
yy935:
	YYDEBUG(935, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy950;
	if (yych == 'e') goto yy950;
	goto yy53;
yy936:
	YYDEBUG(936, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy939;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy943;
	goto yy53;
yy937:
	YYDEBUG(937, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy939;
	if (yych <= '/') goto yy53;
	if (yych <= '2') goto yy943;
	goto yy53;
yy938:
	YYDEBUG(938, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '-') goto yy53;
yy939:
	YYDEBUG(939, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '2') goto yy940;
	if (yych <= '3') goto yy941;
	if (yych <= '9') goto yy942;
	goto yy53;
yy940:
	YYDEBUG(940, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy845;
		if (yych <= '9') goto yy942;
		if (yych <= 'm') goto yy845;
		goto yy849;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy845;
			goto yy850;
		} else {
			if (yych <= 's') goto yy848;
			if (yych <= 't') goto yy851;
			goto yy845;
		}
	}
yy941:
	YYDEBUG(941, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy845;
		if (yych <= '1') goto yy942;
		if (yych <= 'm') goto yy845;
		goto yy849;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy845;
			goto yy850;
		} else {
			if (yych <= 's') goto yy848;
			if (yych <= 't') goto yy851;
			goto yy845;
		}
	}
yy942:
	YYDEBUG(942, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'q') {
		if (yych == 'n') goto yy849;
		goto yy845;
	} else {
		if (yych <= 'r') goto yy850;
		if (yych <= 's') goto yy848;
		if (yych <= 't') goto yy851;
		goto yy845;
	}
yy943:
	YYDEBUG(943, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '-') goto yy53;
	YYDEBUG(944, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy53;
		if (yych >= '1') goto yy946;
	} else {
		if (yych <= '3') goto yy947;
		if (yych <= '9') goto yy942;
		goto yy53;
	}
	YYDEBUG(945, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy845;
		if (yych <= '9') goto yy948;
		if (yych <= 'm') goto yy845;
		goto yy849;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy845;
			goto yy850;
		} else {
			if (yych <= 's') goto yy848;
			if (yych <= 't') goto yy851;
			goto yy845;
		}
	}
yy946:
	YYDEBUG(946, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy845;
		if (yych <= '9') goto yy948;
		if (yych <= 'm') goto yy845;
		goto yy849;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy845;
			goto yy850;
		} else {
			if (yych <= 's') goto yy848;
			if (yych <= 't') goto yy851;
			goto yy845;
		}
	}
yy947:
	YYDEBUG(947, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy845;
		if (yych <= '1') goto yy948;
		if (yych <= 'm') goto yy845;
		goto yy849;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy845;
			goto yy850;
		} else {
			if (yych <= 's') goto yy848;
			if (yych <= 't') goto yy851;
			goto yy845;
		}
	}
yy948:
	YYDEBUG(948, *YYCURSOR);
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'q') {
		if (yych == 'n') goto yy849;
	} else {
		if (yych <= 'r') goto yy850;
		if (yych <= 's') goto yy848;
		if (yych <= 't') goto yy851;
	}
yy949:
	YYDEBUG(949, *YYCURSOR);
	{
		DEBUG_OUTPUT("iso8601date2");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
yy950:
	YYDEBUG(950, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy951;
	if (yych != 'c') goto yy53;
yy951:
	YYDEBUG(951, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '-') goto yy53;
yy952:
	YYDEBUG(952, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '0') goto yy953;
	if (yych <= '2') goto yy954;
	if (yych <= '3') goto yy955;
	goto yy53;
yy953:
	YYDEBUG(953, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy956;
	goto yy53;
yy954:
	YYDEBUG(954, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy956;
	goto yy53;
yy955:
	YYDEBUG(955, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= '2') goto yy53;
yy956:
	YYDEBUG(956, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(957, *YYCURSOR);
	{
		DEBUG_OUTPUT("pgtextreverse");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_PG_TEXT;
	}
yy958:
	YYDEBUG(958, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy951;
	if (yych == 'v') goto yy951;
	goto yy53;
yy959:
	YYDEBUG(959, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy951;
	if (yych == 't') goto yy951;
	goto yy53;
yy960:
	YYDEBUG(960, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy961;
	if (yych != 'p') goto yy53;
yy961:
	YYDEBUG(961, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == '-') goto yy952;
		goto yy53;
	} else {
		if (yych <= 'T') goto yy951;
		if (yych == 't') goto yy951;
		goto yy53;
	}
yy962:
	YYDEBUG(962, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy951;
	if (yych == 'g') goto yy951;
	goto yy53;
yy963:
	YYDEBUG(963, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy951;
	if (yych == 'r') goto yy951;
	goto yy53;
yy964:
	YYDEBUG(964, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy951;
		if (yych <= 'X') goto yy53;
		goto yy951;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy53;
			goto yy951;
		} else {
			if (yych == 'y') goto yy951;
			goto yy53;
		}
	}
yy965:
	YYDEBUG(965, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy951;
	if (yych == 'b') goto yy951;
	goto yy53;
yy966:
	YYDEBUG(966, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy951;
		if (yych <= 'M') goto yy53;
		goto yy951;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy53;
			goto yy951;
		} else {
			if (yych == 'n') goto yy951;
			goto yy53;
		}
	}
yy967:
	YYDEBUG(967, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy951;
	if (yych == 'n') goto yy951;
	goto yy53;
yy968:
	YYDEBUG(968, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch (yych) {
	case '\t':
	case ' ':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'S':
	case 'T':
	case 'V':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'n':
	case 'o':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy976;
	case '-':	goto yy973;
	case '.':	goto yy977;
	case '/':	goto yy974;
	case '0':	goto yy990;
	case '1':	goto yy991;
	case '2':	goto yy993;
	case '3':	goto yy994;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy51;
	case ':':	goto yy992;
	case 'W':	goto yy995;
	default:	goto yy969;
	}
yy969:
	YYDEBUG(969, *YYCURSOR);
	{
		DEBUG_OUTPUT("year4");
		TIMELIB_INIT;
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_DEINIT;
		return TIMELIB_CLF;
	}
yy970:
	YYDEBUG(970, *YYCURSOR);
	yych = *++YYCURSOR;
	YYDEBUG(-1, yych);
	switch (yych) {
	case '0':	goto yy971;
	case '1':	goto yy972;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy938;
	case 'A':
	case 'a':	goto yy931;
	case 'D':
	case 'd':	goto yy935;
	case 'F':
	case 'f':	goto yy929;
	case 'J':
	case 'j':	goto yy928;
	case 'M':
	case 'm':	goto yy930;
	case 'N':
	case 'n':	goto yy934;
	case 'O':
	case 'o':	goto yy933;
	case 'S':
	case 's':	goto yy932;
	default:	goto yy53;
	}
yy971:
	YYDEBUG(971, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy939;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy938;
	goto yy53;
yy972:
	YYDEBUG(972, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy939;
	if (yych <= '/') goto yy53;
	if (yych <= '2') goto yy938;
	goto yy53;
yy973:
	YYDEBUG(973, *YYCURSOR);
	yych = *++YYCURSOR;
	YYDEBUG(-1, yych);
	switch (yych) {
	case '0':	goto yy1158;
	case '1':	goto yy1160;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1161;
	case 'A':
	case 'a':	goto yy1152;
	case 'D':
	case 'd':	goto yy1156;
	case 'F':
	case 'f':	goto yy1150;
	case 'J':
	case 'j':	goto yy1149;
	case 'M':
	case 'm':	goto yy1151;
	case 'N':
	case 'n':	goto yy1155;
	case 'O':
	case 'o':	goto yy1154;
	case 'S':
	case 's':	goto yy1153;
	case 'W':	goto yy1157;
	default:	goto yy1124;
	}
yy974:
	YYDEBUG(974, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '0') goto yy1132;
	if (yych <= '1') goto yy1133;
	if (yych <= '9') goto yy1134;
	goto yy53;
yy975:
	YYDEBUG(975, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
	yych = *YYCURSOR;
yy976:
	YYDEBUG(976, *YYCURSOR);
	YYDEBUG(-1, yych);
	switch (yych) {
	case '\t':
	case ' ':	goto yy975;
	case '-':
	case '.':	goto yy1123;
	case 'A':
	case 'a':	goto yy985;
	case 'D':
	case 'd':	goto yy989;
	case 'F':
	case 'f':	goto yy983;
	case 'H':
	case 'h':	goto yy60;
	case 'I':	goto yy978;
	case 'J':
	case 'j':	goto yy982;
	case 'M':
	case 'm':	goto yy984;
	case 'N':
	case 'n':	goto yy988;
	case 'O':
	case 'o':	goto yy987;
	case 'S':
	case 's':	goto yy986;
	case 'T':
	case 't':	goto yy65;
	case 'V':	goto yy980;
	case 'W':
	case 'w':	goto yy62;
	case 'X':	goto yy981;
	case 'Y':
	case 'y':	goto yy64;
	default:	goto yy53;
	}
yy977:
	YYDEBUG(977, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1124;
	if (yych <= '0') goto yy1116;
	if (yych <= '2') goto yy1117;
	if (yych <= '3') goto yy1118;
	goto yy1124;
yy978:
	YYDEBUG(978, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= 'U') {
		if (yych == 'I') goto yy1115;
	} else {
		if (yych == 'W') goto yy979;
		if (yych <= 'X') goto yy1069;
	}
yy979:
	YYDEBUG(979, *YYCURSOR);
	{
		DEBUG_OUTPUT("datenodayrev");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = 1;
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NO_DAY;
	}
yy980:
	YYDEBUG(980, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy1113;
	goto yy979;
yy981:
	YYDEBUG(981, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy1112;
	goto yy979;
yy982:
	YYDEBUG(982, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy1105;
		if (yych <= 'T') goto yy53;
		goto yy1104;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy53;
			goto yy1105;
		} else {
			if (yych == 'u') goto yy1104;
			goto yy53;
		}
	}
yy983:
	YYDEBUG(983, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'N') {
			if (yych == 'E') goto yy1098;
			goto yy53;
		} else {
			if (yych <= 'O') goto yy83;
			if (yych <= 'Q') goto yy53;
			goto yy82;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'e') goto yy1098;
			goto yy53;
		} else {
			if (yych <= 'o') goto yy83;
			if (yych == 'r') goto yy82;
			goto yy53;
		}
	}
yy984:
	YYDEBUG(984, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'H') {
			if (yych == 'A') goto yy1095;
			goto yy53;
		} else {
			if (yych <= 'I') goto yy114;
			if (yych <= 'N') goto yy53;
			goto yy113;
		}
	} else {
		if (yych <= 'h') {
			if (yych == 'a') goto yy1095;
			goto yy53;
		} else {
			if (yych <= 'i') goto yy114;
			if (yych == 'o') goto yy113;
			goto yy53;
		}
	}
yy985:
	YYDEBUG(985, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy1089;
		if (yych <= 'T') goto yy53;
		goto yy1088;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy53;
			goto yy1089;
		} else {
			if (yych == 'u') goto yy1088;
			goto yy53;
		}
	}
yy986:
	YYDEBUG(986, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy123;
			goto yy53;
		} else {
			if (yych <= 'E') goto yy1081;
			if (yych <= 'T') goto yy53;
			goto yy122;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy123;
			goto yy53;
		} else {
			if (yych <= 'e') goto yy1081;
			if (yych == 'u') goto yy122;
			goto yy53;
		}
	}
yy987:
	YYDEBUG(987, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy1076;
	if (yych == 'c') goto yy1076;
	goto yy53;
yy988:
	YYDEBUG(988, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1070;
	if (yych == 'o') goto yy1070;
	goto yy53;
yy989:
	YYDEBUG(989, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych == 'A') goto yy110;
		if (yych <= 'D') goto yy53;
		goto yy1063;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy53;
			goto yy110;
		} else {
			if (yych == 'e') goto yy1063;
			goto yy53;
		}
	}
yy990:
	YYDEBUG(990, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '0') goto yy1060;
	if (yych <= '9') goto yy1061;
	goto yy57;
yy991:
	YYDEBUG(991, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '2') goto yy1029;
	if (yych <= '9') goto yy1008;
	goto yy57;
yy992:
	YYDEBUG(992, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '0') goto yy1009;
	if (yych <= '1') goto yy1010;
	goto yy53;
yy993:
	YYDEBUG(993, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '9') goto yy1008;
	goto yy57;
yy994:
	YYDEBUG(994, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '5') goto yy1004;
	if (yych <= '6') goto yy1005;
	if (yych <= '9') goto yy51;
	goto yy57;
yy995:
	YYDEBUG(995, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy53;
		if (yych <= '0') goto yy996;
		if (yych <= '4') goto yy997;
		goto yy998;
	} else {
		if (yych <= 'E') {
			if (yych <= 'D') goto yy53;
			goto yy98;
		} else {
			if (yych == 'e') goto yy98;
			goto yy53;
		}
	}
yy996:
	YYDEBUG(996, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '0') goto yy53;
	if (yych <= '9') goto yy999;
	goto yy53;
yy997:
	YYDEBUG(997, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy999;
	goto yy53;
yy998:
	YYDEBUG(998, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= '4') goto yy53;
yy999:
	YYDEBUG(999, *YYCURSOR);
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy1001;
	if (yych <= '/') goto yy1000;
	if (yych <= '7') goto yy1002;
yy1000:
	YYDEBUG(1000, *YYCURSOR);
	{
		timelib_sll w, d;
		DEBUG_OUTPUT("isoweek");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		TIMELIB_HAVE_RELATIVE();
		
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		w = timelib_get_nr((char **) &ptr, 2);
		d = 1;
		s->time->m = 1;
		s->time->d = 1;
		s->time->relative.d = timelib_daynr_from_weeknr(s->time->y, w, d);

		TIMELIB_DEINIT;
		return TIMELIB_ISO_WEEK;
	}
yy1001:
	YYDEBUG(1001, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= '8') goto yy53;
yy1002:
	YYDEBUG(1002, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(1003, *YYCURSOR);
	{
		timelib_sll w, d;
		DEBUG_OUTPUT("isoweekday");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		TIMELIB_HAVE_RELATIVE();
		
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		w = timelib_get_nr((char **) &ptr, 2);
		d = timelib_get_nr((char **) &ptr, 1);
		s->time->m = 1;
		s->time->d = 1;
		s->time->relative.d = timelib_daynr_from_weeknr(s->time->y, w, d);

		TIMELIB_DEINIT;
		return TIMELIB_ISO_WEEK;
	}
yy1004:
	YYDEBUG(1004, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '9') goto yy1006;
	goto yy57;
yy1005:
	YYDEBUG(1005, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '6') goto yy1006;
	if (yych <= '9') goto yy51;
	goto yy57;
yy1006:
	YYDEBUG(1006, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 2) {
		goto yy51;
	}
	if (yych <= 'W') {
		if (yych <= 'F') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy57;
				if (yych >= ' ') goto yy57;
			} else {
				if (yych == 'D') goto yy57;
				if (yych >= 'F') goto yy57;
			}
		} else {
			if (yych <= 'M') {
				if (yych == 'H') goto yy57;
				if (yych >= 'M') goto yy57;
			} else {
				if (yych <= 'R') goto yy1007;
				if (yych <= 'T') goto yy57;
				if (yych >= 'W') goto yy57;
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy57;
				if (yych >= 'd') goto yy57;
			} else {
				if (yych == 'f') goto yy57;
				if (yych >= 'h') goto yy57;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy57;
				if (yych >= 's') goto yy57;
			} else {
				if (yych <= 'w') {
					if (yych >= 'w') goto yy57;
				} else {
					if (yych == 'y') goto yy57;
				}
			}
		}
	}
yy1007:
	YYDEBUG(1007, *YYCURSOR);
	{
		DEBUG_OUTPUT("pgydotd");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->d = timelib_get_nr((char **) &ptr, 3);
		s->time->m = 1;
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_PG_YEARDAY;
	}
yy1008:
	YYDEBUG(1008, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '9') goto yy1006;
	goto yy57;
yy1009:
	YYDEBUG(1009, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1011;
	goto yy53;
yy1010:
	YYDEBUG(1010, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= '3') goto yy53;
yy1011:
	YYDEBUG(1011, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy53;
	YYDEBUG(1012, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '0') goto yy1013;
	if (yych <= '2') goto yy1014;
	if (yych <= '3') goto yy1015;
	goto yy53;
yy1013:
	YYDEBUG(1013, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1016;
	goto yy53;
yy1014:
	YYDEBUG(1014, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1016;
	goto yy53;
yy1015:
	YYDEBUG(1015, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= '2') goto yy53;
yy1016:
	YYDEBUG(1016, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ' ') goto yy53;
	YYDEBUG(1017, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '1') goto yy1018;
	if (yych <= '2') goto yy1019;
	goto yy53;
yy1018:
	YYDEBUG(1018, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1020;
	goto yy53;
yy1019:
	YYDEBUG(1019, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= '4') goto yy53;
yy1020:
	YYDEBUG(1020, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy53;
	YYDEBUG(1021, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= '6') goto yy53;
	YYDEBUG(1022, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= ':') goto yy53;
	YYDEBUG(1023, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy53;
	YYDEBUG(1024, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1025;
	if (yych <= '6') goto yy1026;
	goto yy53;
yy1025:
	YYDEBUG(1025, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1027;
	goto yy53;
yy1026:
	YYDEBUG(1026, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '0') goto yy53;
yy1027:
	YYDEBUG(1027, *YYCURSOR);
	++YYCURSOR;
yy1028:
	YYDEBUG(1028, *YYCURSOR);
	{
		int tz_not_found;
		DEBUG_OUTPUT("xmlrpc | xmlrpcnocolon | soap | wddx | exif");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		s->time->s = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == '.') {
			s->time->f = timelib_get_frac_nr((char **) &ptr, 9);
			if (*ptr) { /* timezone is optional */
				s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
				if (tz_not_found) {
					add_error(s, "The timezone could not be found in the database");
				}
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_XMLRPC_SOAP;
	}
yy1029:
	YYDEBUG(1029, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy57;
		if (yych >= '1') goto yy1031;
	} else {
		if (yych <= '3') goto yy1032;
		if (yych <= '9') goto yy1006;
		goto yy57;
	}
yy1030:
	YYDEBUG(1030, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy57;
				if (yych <= 0x1F) goto yy1007;
				goto yy57;
			} else {
				if (yych <= '/') goto yy1007;
				if (yych <= '9') goto yy1033;
				if (yych <= 'C') goto yy1007;
				goto yy57;
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy57;
				if (yych <= 'G') goto yy1007;
				goto yy57;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy1007;
					goto yy57;
				} else {
					if (yych <= 'R') goto yy1007;
					if (yych <= 'T') goto yy57;
					goto yy1007;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy1007;
				if (yych <= 'Y') goto yy57;
				goto yy1007;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy57;
					goto yy1007;
				} else {
					if (yych == 'g') goto yy1007;
					goto yy57;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy57;
				if (yych <= 'r') goto yy1007;
				goto yy57;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy1007;
					goto yy57;
				} else {
					if (yych == 'y') goto yy57;
					goto yy1007;
				}
			}
		}
	}
yy1031:
	YYDEBUG(1031, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy57;
				if (yych <= 0x1F) goto yy1007;
				goto yy57;
			} else {
				if (yych <= '/') goto yy1007;
				if (yych <= '9') goto yy1033;
				if (yych <= 'C') goto yy1007;
				goto yy57;
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy57;
				if (yych <= 'G') goto yy1007;
				goto yy57;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy1007;
					goto yy57;
				} else {
					if (yych <= 'R') goto yy1007;
					if (yych <= 'T') goto yy57;
					goto yy1007;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy1007;
				if (yych <= 'Y') goto yy57;
				goto yy1007;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy57;
					goto yy1007;
				} else {
					if (yych == 'g') goto yy1007;
					goto yy57;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy57;
				if (yych <= 'r') goto yy1007;
				goto yy57;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy1007;
					goto yy57;
				} else {
					if (yych == 'y') goto yy57;
					goto yy1007;
				}
			}
		}
	}
yy1032:
	YYDEBUG(1032, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy57;
				if (yych <= 0x1F) goto yy1007;
				goto yy57;
			} else {
				if (yych <= '1') {
					if (yych <= '/') goto yy1007;
				} else {
					if (yych <= '9') goto yy51;
					if (yych <= 'C') goto yy1007;
					goto yy57;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy57;
				if (yych <= 'G') goto yy1007;
				goto yy57;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy1007;
					goto yy57;
				} else {
					if (yych <= 'R') goto yy1007;
					if (yych <= 'T') goto yy57;
					goto yy1007;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy1007;
				if (yych <= 'Y') goto yy57;
				goto yy1007;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy57;
					goto yy1007;
				} else {
					if (yych == 'g') goto yy1007;
					goto yy57;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy57;
				if (yych <= 'r') goto yy1007;
				goto yy57;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy1007;
					goto yy57;
				} else {
					if (yych == 'y') goto yy57;
					goto yy1007;
				}
			}
		}
	}
yy1033:
	YYDEBUG(1033, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 2) {
		goto yy51;
	}
	if (yych <= 'W') {
		if (yych <= 'F') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy56;
				if (yych >= ' ') goto yy56;
			} else {
				if (yych == 'D') goto yy61;
				if (yych >= 'F') goto yy63;
			}
		} else {
			if (yych <= 'M') {
				if (yych == 'H') goto yy60;
				if (yych >= 'M') goto yy59;
			} else {
				if (yych <= 'S') {
					if (yych >= 'S') goto yy58;
				} else {
					if (yych <= 'T') goto yy1035;
					if (yych >= 'W') goto yy62;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy64;
				if (yych >= 'd') goto yy61;
			} else {
				if (yych <= 'f') {
					if (yych >= 'f') goto yy63;
				} else {
					if (yych == 'h') goto yy60;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'm') goto yy59;
				if (yych <= 'r') goto yy1034;
				if (yych <= 's') goto yy58;
				goto yy1036;
			} else {
				if (yych <= 'w') {
					if (yych >= 'w') goto yy62;
				} else {
					if (yych == 'y') goto yy64;
				}
			}
		}
	}
yy1034:
	YYDEBUG(1034, *YYCURSOR);
	{
		DEBUG_OUTPUT("datenocolon");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NOCOLON;
	}
yy1035:
	YYDEBUG(1035, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= '2') {
			if (yych <= '/') goto yy53;
			if (yych <= '1') goto yy1050;
			goto yy1051;
		} else {
			if (yych <= '9') goto yy1052;
			if (yych <= 'G') goto yy53;
			goto yy66;
		}
	} else {
		if (yych <= 'g') {
			if (yych == 'U') goto yy67;
			goto yy53;
		} else {
			if (yych <= 'h') goto yy66;
			if (yych == 'u') goto yy67;
			goto yy53;
		}
	}
yy1036:
	YYDEBUG(1036, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= '2') {
			if (yych <= '/') goto yy53;
			if (yych >= '2') goto yy1038;
		} else {
			if (yych <= '9') goto yy1039;
			if (yych <= 'G') goto yy53;
			goto yy66;
		}
	} else {
		if (yych <= 'g') {
			if (yych == 'U') goto yy67;
			goto yy53;
		} else {
			if (yych <= 'h') goto yy66;
			if (yych == 'u') goto yy67;
			goto yy53;
		}
	}
	YYDEBUG(1037, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1044;
	if (yych <= '9') goto yy1039;
	goto yy53;
yy1038:
	YYDEBUG(1038, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '3') goto yy1044;
	if (yych <= '5') goto yy1040;
	goto yy53;
yy1039:
	YYDEBUG(1039, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= '6') goto yy53;
yy1040:
	YYDEBUG(1040, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= ':') goto yy53;
yy1041:
	YYDEBUG(1041, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1042;
	if (yych <= '6') goto yy1043;
	goto yy53;
yy1042:
	YYDEBUG(1042, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1027;
	goto yy53;
yy1043:
	YYDEBUG(1043, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy1027;
	goto yy53;
yy1044:
	YYDEBUG(1044, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1045;
	if (yych <= '9') goto yy1041;
	goto yy53;
yy1045:
	YYDEBUG(1045, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1046;
	if (yych <= '6') goto yy1047;
	if (yych <= '9') goto yy1041;
	goto yy53;
yy1046:
	YYDEBUG(1046, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1048;
	if (yych <= '6') goto yy1049;
	if (yych <= '9') goto yy1027;
	goto yy53;
yy1047:
	YYDEBUG(1047, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '0') goto yy1048;
	if (yych <= '5') goto yy1042;
	if (yych <= '6') goto yy1043;
	goto yy53;
yy1048:
	YYDEBUG(1048, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1028;
	if (yych <= '9') goto yy1027;
	goto yy1028;
yy1049:
	YYDEBUG(1049, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy1027;
	goto yy1028;
yy1050:
	YYDEBUG(1050, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1059;
	if (yych <= '9') goto yy1052;
	if (yych <= ':') goto yy1053;
	goto yy53;
yy1051:
	YYDEBUG(1051, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy53;
		if (yych <= '3') goto yy1059;
		goto yy1040;
	} else {
		if (yych == ':') goto yy1053;
		goto yy53;
	}
yy1052:
	YYDEBUG(1052, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1040;
	if (yych != ':') goto yy53;
yy1053:
	YYDEBUG(1053, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= '6') goto yy53;
	YYDEBUG(1054, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= ':') goto yy53;
	YYDEBUG(1055, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy53;
	YYDEBUG(1056, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1057;
	if (yych <= '6') goto yy1058;
	goto yy53;
yy1057:
	YYDEBUG(1057, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1027;
	goto yy53;
yy1058:
	YYDEBUG(1058, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy1027;
	goto yy53;
yy1059:
	YYDEBUG(1059, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1045;
	if (yych <= '9') goto yy1041;
	if (yych <= ':') goto yy1053;
	goto yy53;
yy1060:
	YYDEBUG(1060, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy57;
		if (yych <= '0') goto yy1062;
		goto yy1031;
	} else {
		if (yych <= '3') goto yy1032;
		if (yych <= '9') goto yy1006;
		goto yy57;
	}
yy1061:
	YYDEBUG(1061, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy57;
		if (yych <= '0') goto yy1030;
		goto yy1031;
	} else {
		if (yych <= '3') goto yy1032;
		if (yych <= '9') goto yy1006;
		goto yy57;
	}
yy1062:
	YYDEBUG(1062, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '9') goto yy1033;
	goto yy57;
yy1063:
	YYDEBUG(1063, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy1064;
	if (yych != 'c') goto yy53;
yy1064:
	YYDEBUG(1064, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy1065;
	if (yych != 'e') goto yy979;
yy1065:
	YYDEBUG(1065, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy1066;
	if (yych != 'm') goto yy53;
yy1066:
	YYDEBUG(1066, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy1067;
	if (yych != 'b') goto yy53;
yy1067:
	YYDEBUG(1067, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1068;
	if (yych != 'e') goto yy53;
yy1068:
	YYDEBUG(1068, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1069;
	if (yych != 'r') goto yy53;
yy1069:
	YYDEBUG(1069, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy979;
yy1070:
	YYDEBUG(1070, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy1071;
	if (yych != 'v') goto yy53;
yy1071:
	YYDEBUG(1071, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy1072;
	if (yych != 'e') goto yy979;
yy1072:
	YYDEBUG(1072, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy1073;
	if (yych != 'm') goto yy53;
yy1073:
	YYDEBUG(1073, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy1074;
	if (yych != 'b') goto yy53;
yy1074:
	YYDEBUG(1074, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1075;
	if (yych != 'e') goto yy53;
yy1075:
	YYDEBUG(1075, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1069;
	if (yych == 'r') goto yy1069;
	goto yy53;
yy1076:
	YYDEBUG(1076, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1077;
	if (yych != 't') goto yy53;
yy1077:
	YYDEBUG(1077, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'O') goto yy1078;
	if (yych != 'o') goto yy979;
yy1078:
	YYDEBUG(1078, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy1079;
	if (yych != 'b') goto yy53;
yy1079:
	YYDEBUG(1079, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1080;
	if (yych != 'e') goto yy53;
yy1080:
	YYDEBUG(1080, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1069;
	if (yych == 'r') goto yy1069;
	goto yy53;
yy1081:
	YYDEBUG(1081, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'P') {
		if (yych == 'C') goto yy125;
		if (yych <= 'O') goto yy53;
	} else {
		if (yych <= 'c') {
			if (yych <= 'b') goto yy53;
			goto yy125;
		} else {
			if (yych != 'p') goto yy53;
		}
	}
yy1082:
	YYDEBUG(1082, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1083;
	if (yych != 't') goto yy979;
yy1083:
	YYDEBUG(1083, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy1084;
	if (yych != 'e') goto yy979;
yy1084:
	YYDEBUG(1084, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy1085;
	if (yych != 'm') goto yy53;
yy1085:
	YYDEBUG(1085, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy1086;
	if (yych != 'b') goto yy53;
yy1086:
	YYDEBUG(1086, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1087;
	if (yych != 'e') goto yy53;
yy1087:
	YYDEBUG(1087, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1069;
	if (yych == 'r') goto yy1069;
	goto yy53;
yy1088:
	YYDEBUG(1088, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy1092;
	if (yych == 'g') goto yy1092;
	goto yy53;
yy1089:
	YYDEBUG(1089, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1090;
	if (yych != 'r') goto yy53;
yy1090:
	YYDEBUG(1090, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'I') goto yy1091;
	if (yych != 'i') goto yy979;
yy1091:
	YYDEBUG(1091, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'L') goto yy1069;
	if (yych == 'l') goto yy1069;
	goto yy53;
yy1092:
	YYDEBUG(1092, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'U') goto yy1093;
	if (yych != 'u') goto yy979;
yy1093:
	YYDEBUG(1093, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1094;
	if (yych != 's') goto yy53;
yy1094:
	YYDEBUG(1094, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1069;
	if (yych == 't') goto yy1069;
	goto yy53;
yy1095:
	YYDEBUG(1095, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy1096;
		if (yych <= 'X') goto yy53;
		goto yy1069;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy53;
		} else {
			if (yych == 'y') goto yy1069;
			goto yy53;
		}
	}
yy1096:
	YYDEBUG(1096, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'C') goto yy1097;
	if (yych != 'c') goto yy979;
yy1097:
	YYDEBUG(1097, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy1069;
	if (yych == 'h') goto yy1069;
	goto yy53;
yy1098:
	YYDEBUG(1098, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy1099;
	if (yych != 'b') goto yy53;
yy1099:
	YYDEBUG(1099, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'R') goto yy1100;
	if (yych != 'r') goto yy979;
yy1100:
	YYDEBUG(1100, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy1101;
	if (yych != 'u') goto yy53;
yy1101:
	YYDEBUG(1101, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1102;
	if (yych != 'a') goto yy53;
yy1102:
	YYDEBUG(1102, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1103;
	if (yych != 'r') goto yy53;
yy1103:
	YYDEBUG(1103, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1069;
	if (yych == 'y') goto yy1069;
	goto yy53;
yy1104:
	YYDEBUG(1104, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy1111;
		if (yych <= 'M') goto yy53;
		goto yy1110;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy53;
			goto yy1111;
		} else {
			if (yych == 'n') goto yy1110;
			goto yy53;
		}
	}
yy1105:
	YYDEBUG(1105, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1106;
	if (yych != 'n') goto yy53;
yy1106:
	YYDEBUG(1106, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'U') goto yy1107;
	if (yych != 'u') goto yy979;
yy1107:
	YYDEBUG(1107, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1108;
	if (yych != 'a') goto yy53;
yy1108:
	YYDEBUG(1108, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1109;
	if (yych != 'r') goto yy53;
yy1109:
	YYDEBUG(1109, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1069;
	if (yych == 'y') goto yy1069;
	goto yy53;
yy1110:
	YYDEBUG(1110, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1069;
	if (yych == 'e') goto yy1069;
	goto yy979;
yy1111:
	YYDEBUG(1111, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1069;
	if (yych == 'y') goto yy1069;
	goto yy979;
yy1112:
	YYDEBUG(1112, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy1069;
	goto yy979;
yy1113:
	YYDEBUG(1113, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != 'I') goto yy979;
	YYDEBUG(1114, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy1069;
	goto yy979;
yy1115:
	YYDEBUG(1115, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy1069;
	goto yy979;
yy1116:
	YYDEBUG(1116, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '0') goto yy1131;
	if (yych <= '9') goto yy1130;
	goto yy53;
yy1117:
	YYDEBUG(1117, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1129;
	goto yy53;
yy1118:
	YYDEBUG(1118, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1127;
	if (yych <= '6') goto yy1126;
	goto yy53;
yy1119:
	YYDEBUG(1119, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1098;
	if (yych == 'e') goto yy1098;
	goto yy53;
yy1120:
	YYDEBUG(1120, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1095;
	if (yych == 'a') goto yy1095;
	goto yy53;
yy1121:
	YYDEBUG(1121, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1125;
	if (yych == 'e') goto yy1125;
	goto yy53;
yy1122:
	YYDEBUG(1122, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1063;
	if (yych == 'e') goto yy1063;
	goto yy53;
yy1123:
	YYDEBUG(1123, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
yy1124:
	YYDEBUG(1124, *YYCURSOR);
	YYDEBUG(-1, yych);
	switch (yych) {
	case '\t':
	case ' ':
	case '-':
	case '.':	goto yy1123;
	case 'A':
	case 'a':	goto yy985;
	case 'D':
	case 'd':	goto yy1122;
	case 'F':
	case 'f':	goto yy1119;
	case 'I':	goto yy978;
	case 'J':
	case 'j':	goto yy982;
	case 'M':
	case 'm':	goto yy1120;
	case 'N':
	case 'n':	goto yy988;
	case 'O':
	case 'o':	goto yy987;
	case 'S':
	case 's':	goto yy1121;
	case 'V':	goto yy980;
	case 'X':	goto yy981;
	default:	goto yy53;
	}
yy1125:
	YYDEBUG(1125, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy1082;
	if (yych == 'p') goto yy1082;
	goto yy53;
yy1126:
	YYDEBUG(1126, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '6') goto yy1128;
	goto yy53;
yy1127:
	YYDEBUG(1127, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= ':') goto yy53;
yy1128:
	YYDEBUG(1128, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy1007;
yy1129:
	YYDEBUG(1129, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1128;
	goto yy53;
yy1130:
	YYDEBUG(1130, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1128;
	goto yy53;
yy1131:
	YYDEBUG(1131, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '0') goto yy53;
	if (yych <= '9') goto yy1128;
	goto yy53;
yy1132:
	YYDEBUG(1132, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') goto yy53;
	if (yych <= '/') goto yy1135;
	if (yych <= '9') goto yy1143;
	goto yy53;
yy1133:
	YYDEBUG(1133, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') goto yy53;
	if (yych <= '/') goto yy1135;
	if (yych <= '2') goto yy1143;
	goto yy53;
yy1134:
	YYDEBUG(1134, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '/') goto yy53;
yy1135:
	YYDEBUG(1135, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '2') goto yy1136;
	if (yych <= '3') goto yy1137;
	if (yych <= '9') goto yy1138;
	goto yy53;
yy1136:
	YYDEBUG(1136, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy660;
		if (yych <= '9') goto yy1138;
		if (yych <= 'm') goto yy660;
		goto yy1140;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy660;
			goto yy1141;
		} else {
			if (yych <= 's') goto yy1139;
			if (yych <= 't') goto yy1142;
			goto yy660;
		}
	}
yy1137:
	YYDEBUG(1137, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy660;
		if (yych <= '1') goto yy1138;
		if (yych <= 'm') goto yy660;
		goto yy1140;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy660;
			goto yy1141;
		} else {
			if (yych <= 's') goto yy1139;
			if (yych <= 't') goto yy1142;
			goto yy660;
		}
	}
yy1138:
	YYDEBUG(1138, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'q') {
		if (yych == 'n') goto yy1140;
		goto yy660;
	} else {
		if (yych <= 'r') goto yy1141;
		if (yych <= 's') goto yy1139;
		if (yych <= 't') goto yy1142;
		goto yy660;
	}
yy1139:
	YYDEBUG(1139, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy659;
	goto yy53;
yy1140:
	YYDEBUG(1140, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy659;
	goto yy53;
yy1141:
	YYDEBUG(1141, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy659;
	goto yy53;
yy1142:
	YYDEBUG(1142, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy659;
	goto yy53;
yy1143:
	YYDEBUG(1143, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '/') goto yy53;
	YYDEBUG(1144, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy53;
		if (yych >= '1') goto yy1146;
	} else {
		if (yych <= '3') goto yy1147;
		if (yych <= '9') goto yy1138;
		goto yy53;
	}
	YYDEBUG(1145, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy660;
		if (yych <= '9') goto yy1148;
		if (yych <= 'm') goto yy660;
		goto yy1140;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy660;
			goto yy1141;
		} else {
			if (yych <= 's') goto yy1139;
			if (yych <= 't') goto yy1142;
			goto yy660;
		}
	}
yy1146:
	YYDEBUG(1146, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy660;
		if (yych <= '9') goto yy1148;
		if (yych <= 'm') goto yy660;
		goto yy1140;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy660;
			goto yy1141;
		} else {
			if (yych <= 's') goto yy1139;
			if (yych <= 't') goto yy1142;
			goto yy660;
		}
	}
yy1147:
	YYDEBUG(1147, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy660;
		if (yych <= '1') goto yy1148;
		if (yych <= 'm') goto yy660;
		goto yy1140;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy660;
			goto yy1141;
		} else {
			if (yych <= 's') goto yy1139;
			if (yych <= 't') goto yy1142;
			goto yy660;
		}
	}
yy1148:
	YYDEBUG(1148, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == '/') goto yy659;
		if (yych <= 'm') goto yy660;
		goto yy1140;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy660;
			goto yy1141;
		} else {
			if (yych <= 's') goto yy1139;
			if (yych <= 't') goto yy1142;
			goto yy660;
		}
	}
yy1149:
	YYDEBUG(1149, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy1226;
		if (yych <= 'T') goto yy53;
		goto yy1225;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy53;
			goto yy1226;
		} else {
			if (yych == 'u') goto yy1225;
			goto yy53;
		}
	}
yy1150:
	YYDEBUG(1150, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1223;
	if (yych == 'e') goto yy1223;
	goto yy53;
yy1151:
	YYDEBUG(1151, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1220;
	if (yych == 'a') goto yy1220;
	goto yy53;
yy1152:
	YYDEBUG(1152, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy1217;
		if (yych <= 'T') goto yy53;
		goto yy1216;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy53;
			goto yy1217;
		} else {
			if (yych == 'u') goto yy1216;
			goto yy53;
		}
	}
yy1153:
	YYDEBUG(1153, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1213;
	if (yych == 'e') goto yy1213;
	goto yy53;
yy1154:
	YYDEBUG(1154, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy1211;
	if (yych == 'c') goto yy1211;
	goto yy53;
yy1155:
	YYDEBUG(1155, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1209;
	if (yych == 'o') goto yy1209;
	goto yy53;
yy1156:
	YYDEBUG(1156, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1207;
	if (yych == 'e') goto yy1207;
	goto yy53;
yy1157:
	YYDEBUG(1157, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '0') goto yy996;
	if (yych <= '4') goto yy997;
	if (yych <= '5') goto yy998;
	goto yy53;
yy1158:
	YYDEBUG(1158, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy1162;
	if (yych <= '/') goto yy1159;
	if (yych <= '9') goto yy1181;
yy1159:
	YYDEBUG(1159, *YYCURSOR);
	{
		DEBUG_OUTPUT("gnudateshorter");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = 1;
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
yy1160:
	YYDEBUG(1160, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy1162;
	if (yych <= '/') goto yy1159;
	if (yych <= '2') goto yy1181;
	goto yy1159;
yy1161:
	YYDEBUG(1161, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych != '-') goto yy1159;
yy1162:
	YYDEBUG(1162, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '2') goto yy1163;
	if (yych <= '3') goto yy1164;
	if (yych <= '9') goto yy1165;
	goto yy53;
yy1163:
	YYDEBUG(1163, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '9') {
			if (yych <= '/') goto yy845;
			goto yy1165;
		} else {
			if (yych == 'T') goto yy1170;
			goto yy845;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy1167;
			if (yych <= 'q') goto yy845;
			goto yy1168;
		} else {
			if (yych <= 's') goto yy1166;
			if (yych <= 't') goto yy1169;
			goto yy845;
		}
	}
yy1164:
	YYDEBUG(1164, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy845;
		} else {
			if (yych == 'T') goto yy1170;
			goto yy845;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy1167;
			if (yych <= 'q') goto yy845;
			goto yy1168;
		} else {
			if (yych <= 's') goto yy1166;
			if (yych <= 't') goto yy1169;
			goto yy845;
		}
	}
yy1165:
	YYDEBUG(1165, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == 'T') goto yy1170;
		if (yych <= 'm') goto yy845;
		goto yy1167;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy845;
			goto yy1168;
		} else {
			if (yych <= 's') goto yy1166;
			if (yych <= 't') goto yy1169;
			goto yy845;
		}
	}
yy1166:
	YYDEBUG(1166, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy1180;
	goto yy53;
yy1167:
	YYDEBUG(1167, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy1180;
	goto yy53;
yy1168:
	YYDEBUG(1168, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy1180;
	goto yy53;
yy1169:
	YYDEBUG(1169, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy1180;
	goto yy53;
yy1170:
	YYDEBUG(1170, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '1') goto yy1171;
	if (yych <= '2') goto yy1172;
	if (yych <= '9') goto yy1173;
	goto yy53;
yy1171:
	YYDEBUG(1171, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1173;
	if (yych <= ':') goto yy1174;
	goto yy53;
yy1172:
	YYDEBUG(1172, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '3') goto yy1173;
	if (yych == ':') goto yy1174;
	goto yy53;
yy1173:
	YYDEBUG(1173, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy53;
yy1174:
	YYDEBUG(1174, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1175;
	if (yych <= '9') goto yy1176;
	goto yy53;
yy1175:
	YYDEBUG(1175, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1176;
	if (yych <= ':') goto yy1177;
	goto yy53;
yy1176:
	YYDEBUG(1176, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy53;
yy1177:
	YYDEBUG(1177, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1178;
	if (yych <= '6') goto yy1179;
	if (yych <= '9') goto yy1027;
	goto yy53;
yy1178:
	YYDEBUG(1178, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1028;
	if (yych <= '9') goto yy1027;
	goto yy1028;
yy1179:
	YYDEBUG(1179, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy1027;
	goto yy1028;
yy1180:
	YYDEBUG(1180, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'T') goto yy1170;
	goto yy845;
yy1181:
	YYDEBUG(1181, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych != '-') goto yy1159;
	YYDEBUG(1182, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy53;
		if (yych >= '1') goto yy1184;
	} else {
		if (yych <= '3') goto yy1185;
		if (yych <= '9') goto yy1165;
		goto yy53;
	}
	YYDEBUG(1183, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '9') {
			if (yych <= '/') goto yy845;
			goto yy1186;
		} else {
			if (yych == 'T') goto yy1170;
			goto yy845;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy1167;
			if (yych <= 'q') goto yy845;
			goto yy1168;
		} else {
			if (yych <= 's') goto yy1166;
			if (yych <= 't') goto yy1169;
			goto yy845;
		}
	}
yy1184:
	YYDEBUG(1184, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '9') {
			if (yych <= '/') goto yy845;
			goto yy1186;
		} else {
			if (yych == 'T') goto yy1170;
			goto yy845;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy1167;
			if (yych <= 'q') goto yy845;
			goto yy1168;
		} else {
			if (yych <= 's') goto yy1166;
			if (yych <= 't') goto yy1169;
			goto yy845;
		}
	}
yy1185:
	YYDEBUG(1185, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy845;
		} else {
			if (yych == 'T') goto yy1170;
			goto yy845;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy1167;
			if (yych <= 'q') goto yy845;
			goto yy1168;
		} else {
			if (yych <= 's') goto yy1166;
			if (yych <= 't') goto yy1169;
			goto yy845;
		}
	}
yy1186:
	YYDEBUG(1186, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == 'T') goto yy1187;
		if (yych <= 'm') goto yy660;
		goto yy1167;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy660;
			goto yy1168;
		} else {
			if (yych <= 's') goto yy1166;
			if (yych <= 't') goto yy1169;
			goto yy660;
		}
	}
yy1187:
	YYDEBUG(1187, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '1') goto yy1188;
	if (yych <= '2') goto yy1189;
	if (yych <= '9') goto yy1173;
	goto yy53;
yy1188:
	YYDEBUG(1188, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1190;
	if (yych <= ':') goto yy1174;
	goto yy53;
yy1189:
	YYDEBUG(1189, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '3') goto yy1190;
	if (yych == ':') goto yy1174;
	goto yy53;
yy1190:
	YYDEBUG(1190, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy53;
	YYDEBUG(1191, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1192;
	if (yych <= '9') goto yy1176;
	goto yy53;
yy1192:
	YYDEBUG(1192, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1193;
	if (yych <= ':') goto yy1177;
	goto yy53;
yy1193:
	YYDEBUG(1193, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy53;
	YYDEBUG(1194, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1195;
	if (yych <= '6') goto yy1196;
	if (yych <= '9') goto yy1027;
	goto yy53;
yy1195:
	YYDEBUG(1195, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1028;
	if (yych <= '9') goto yy1197;
	goto yy1028;
yy1196:
	YYDEBUG(1196, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '0') goto yy1028;
yy1197:
	YYDEBUG(1197, *YYCURSOR);
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych != '.') goto yy1028;
	YYDEBUG(1198, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= ':') goto yy53;
yy1199:
	YYDEBUG(1199, *YYCURSOR);
	yyaccept = 24;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 6) YYFILL(6);
	yych = *YYCURSOR;
	YYDEBUG(1200, *YYCURSOR);
	if (yych <= ',') {
		if (yych != '+') goto yy1028;
	} else {
		if (yych <= '-') goto yy1201;
		if (yych <= '/') goto yy1028;
		if (yych <= '9') goto yy1199;
		goto yy1028;
	}
yy1201:
	YYDEBUG(1201, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '1') goto yy1202;
	if (yych <= '2') goto yy1203;
	if (yych <= '9') goto yy1204;
	goto yy53;
yy1202:
	YYDEBUG(1202, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1028;
	if (yych <= '9') goto yy1204;
	if (yych <= ':') goto yy1205;
	goto yy1028;
yy1203:
	YYDEBUG(1203, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy1028;
		if (yych >= '4') goto yy1206;
	} else {
		if (yych <= '9') goto yy1027;
		if (yych <= ':') goto yy1205;
		goto yy1028;
	}
yy1204:
	YYDEBUG(1204, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1028;
	if (yych <= '5') goto yy1206;
	if (yych <= '9') goto yy1027;
	if (yych >= ';') goto yy1028;
yy1205:
	YYDEBUG(1205, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1028;
	if (yych <= '5') goto yy1206;
	if (yych <= '9') goto yy1027;
	goto yy1028;
yy1206:
	YYDEBUG(1206, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1028;
	if (yych <= '9') goto yy1027;
	goto yy1028;
yy1207:
	YYDEBUG(1207, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy1208;
	if (yych != 'c') goto yy53;
yy1208:
	YYDEBUG(1208, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == '-') goto yy952;
		goto yy979;
	} else {
		if (yych <= 'E') goto yy1065;
		if (yych == 'e') goto yy1065;
		goto yy979;
	}
yy1209:
	YYDEBUG(1209, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy1210;
	if (yych != 'v') goto yy53;
yy1210:
	YYDEBUG(1210, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == '-') goto yy952;
		goto yy979;
	} else {
		if (yych <= 'E') goto yy1072;
		if (yych == 'e') goto yy1072;
		goto yy979;
	}
yy1211:
	YYDEBUG(1211, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1212;
	if (yych != 't') goto yy53;
yy1212:
	YYDEBUG(1212, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych == '-') goto yy952;
		goto yy979;
	} else {
		if (yych <= 'O') goto yy1078;
		if (yych == 'o') goto yy1078;
		goto yy979;
	}
yy1213:
	YYDEBUG(1213, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy1214;
	if (yych != 'p') goto yy53;
yy1214:
	YYDEBUG(1214, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == '-') goto yy952;
		goto yy979;
	} else {
		if (yych <= 'T') goto yy1215;
		if (yych != 't') goto yy979;
	}
yy1215:
	YYDEBUG(1215, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == '-') goto yy952;
		goto yy979;
	} else {
		if (yych <= 'E') goto yy1084;
		if (yych == 'e') goto yy1084;
		goto yy979;
	}
yy1216:
	YYDEBUG(1216, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy1219;
	if (yych == 'g') goto yy1219;
	goto yy53;
yy1217:
	YYDEBUG(1217, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1218;
	if (yych != 'r') goto yy53;
yy1218:
	YYDEBUG(1218, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych == '-') goto yy952;
		goto yy979;
	} else {
		if (yych <= 'I') goto yy1091;
		if (yych == 'i') goto yy1091;
		goto yy979;
	}
yy1219:
	YYDEBUG(1219, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == '-') goto yy952;
		goto yy979;
	} else {
		if (yych <= 'U') goto yy1093;
		if (yych == 'u') goto yy1093;
		goto yy979;
	}
yy1220:
	YYDEBUG(1220, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy1221;
		if (yych <= 'X') goto yy53;
		goto yy1222;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy53;
		} else {
			if (yych == 'y') goto yy1222;
			goto yy53;
		}
	}
yy1221:
	YYDEBUG(1221, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'B') {
		if (yych == '-') goto yy952;
		goto yy979;
	} else {
		if (yych <= 'C') goto yy1097;
		if (yych == 'c') goto yy1097;
		goto yy979;
	}
yy1222:
	YYDEBUG(1222, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy952;
	goto yy979;
yy1223:
	YYDEBUG(1223, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy1224;
	if (yych != 'b') goto yy53;
yy1224:
	YYDEBUG(1224, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych == '-') goto yy952;
		goto yy979;
	} else {
		if (yych <= 'R') goto yy1100;
		if (yych == 'r') goto yy1100;
		goto yy979;
	}
yy1225:
	YYDEBUG(1225, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy1229;
		if (yych <= 'M') goto yy53;
		goto yy1228;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy53;
			goto yy1229;
		} else {
			if (yych == 'n') goto yy1228;
			goto yy53;
		}
	}
yy1226:
	YYDEBUG(1226, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1227;
	if (yych != 'n') goto yy53;
yy1227:
	YYDEBUG(1227, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == '-') goto yy952;
		goto yy979;
	} else {
		if (yych <= 'U') goto yy1107;
		if (yych == 'u') goto yy1107;
		goto yy979;
	}
yy1228:
	YYDEBUG(1228, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == '-') goto yy952;
		goto yy979;
	} else {
		if (yych <= 'E') goto yy1069;
		if (yych == 'e') goto yy1069;
		goto yy979;
	}
yy1229:
	YYDEBUG(1229, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych == '-') goto yy952;
		goto yy979;
	} else {
		if (yych <= 'Y') goto yy1069;
		if (yych == 'y') goto yy1069;
		goto yy979;
	}
yy1230:
	YYDEBUG(1230, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy767;
			goto yy916;
		} else {
			if (yych <= ',') goto yy767;
			if (yych <= '-') goto yy917;
			goto yy916;
		}
	} else {
		if (yych <= 'U') {
			if (yych <= '/') goto yy915;
			if (yych <= 'T') goto yy767;
			goto yy74;
		} else {
			if (yych == 'u') goto yy74;
			goto yy767;
		}
	}
yy1231:
	YYDEBUG(1231, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'P') {
		if (yych == 'C') goto yy125;
		if (yych <= 'O') goto yy53;
		goto yy775;
	} else {
		if (yych <= 'c') {
			if (yych <= 'b') goto yy53;
			goto yy125;
		} else {
			if (yych == 'p') goto yy775;
			goto yy53;
		}
	}
yy1232:
	YYDEBUG(1232, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= ',') {
			if (yych == '\t') goto yy1234;
			goto yy1236;
		} else {
			if (yych <= '-') goto yy1233;
			if (yych <= '.') goto yy916;
			if (yych <= '/') goto yy915;
			goto yy926;
		}
	} else {
		if (yych <= 'q') {
			if (yych == 'n') goto yy675;
			goto yy1236;
		} else {
			if (yych <= 'r') goto yy676;
			if (yych <= 's') goto yy669;
			if (yych <= 't') goto yy673;
			goto yy1236;
		}
	}
yy1233:
	YYDEBUG(1233, *YYCURSOR);
	yych = *++YYCURSOR;
	YYDEBUG(-1, yych);
	switch (yych) {
	case '0':	goto yy1237;
	case '1':	goto yy1238;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy806;
	case 'A':
	case 'a':	goto yy810;
	case 'D':
	case 'd':	goto yy814;
	case 'F':
	case 'f':	goto yy808;
	case 'J':
	case 'j':	goto yy807;
	case 'M':
	case 'm':	goto yy809;
	case 'N':
	case 'n':	goto yy813;
	case 'O':
	case 'o':	goto yy812;
	case 'S':
	case 's':	goto yy811;
	default:	goto yy767;
	}
yy1234:
	YYDEBUG(1234, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1236;
	if (yych <= '0') goto yy921;
	if (yych <= '1') goto yy922;
	if (yych <= '9') goto yy923;
	goto yy1236;
yy1235:
	YYDEBUG(1235, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
yy1236:
	YYDEBUG(1236, *YYCURSOR);
	YYDEBUG(-1, yych);
	switch (yych) {
	case '\t':
	case ' ':	goto yy1235;
	case '-':
	case '.':	goto yy766;
	case 'A':
	case 'a':	goto yy763;
	case 'D':
	case 'd':	goto yy671;
	case 'F':
	case 'f':	goto yy672;
	case 'H':
	case 'h':	goto yy60;
	case 'I':	goto yy680;
	case 'J':
	case 'j':	goto yy684;
	case 'M':
	case 'm':	goto yy670;
	case 'N':
	case 'n':	goto yy687;
	case 'O':
	case 'o':	goto yy686;
	case 'S':
	case 's':	goto yy668;
	case 'T':
	case 't':	goto yy65;
	case 'V':	goto yy682;
	case 'W':
	case 'w':	goto yy62;
	case 'X':	goto yy683;
	case 'Y':
	case 'y':	goto yy64;
	default:	goto yy53;
	}
yy1237:
	YYDEBUG(1237, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy53;
		if (yych <= '-') goto yy843;
		goto yy791;
	} else {
		if (yych <= '/') goto yy53;
		if (yych <= '9') goto yy1239;
		goto yy53;
	}
yy1238:
	YYDEBUG(1238, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy53;
		if (yych <= '-') goto yy843;
		goto yy791;
	} else {
		if (yych <= '/') goto yy53;
		if (yych >= '3') goto yy53;
	}
yy1239:
	YYDEBUG(1239, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy53;
	if (yych <= '-') goto yy1240;
	if (yych <= '.') goto yy791;
	goto yy53;
yy1240:
	YYDEBUG(1240, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy53;
		if (yych >= '1') goto yy1242;
	} else {
		if (yych <= '3') goto yy1243;
		if (yych <= '9') goto yy847;
		goto yy53;
	}
	YYDEBUG(1241, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy845;
		if (yych <= '9') goto yy1244;
		if (yych <= 'm') goto yy845;
		goto yy849;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy845;
			goto yy850;
		} else {
			if (yych <= 's') goto yy848;
			if (yych <= 't') goto yy851;
			goto yy845;
		}
	}
yy1242:
	YYDEBUG(1242, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy845;
		if (yych <= '9') goto yy1244;
		if (yych <= 'm') goto yy845;
		goto yy849;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy845;
			goto yy850;
		} else {
			if (yych <= 's') goto yy848;
			if (yych <= 't') goto yy851;
			goto yy845;
		}
	}
yy1243:
	YYDEBUG(1243, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '1') {
			if (yych <= '/') goto yy845;
		} else {
			if (yych <= '9') goto yy793;
			if (yych <= 'm') goto yy845;
			goto yy849;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy845;
			goto yy850;
		} else {
			if (yych <= 's') goto yy848;
			if (yych <= 't') goto yy851;
			goto yy845;
		}
	}
yy1244:
	YYDEBUG(1244, *YYCURSOR);
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy949;
		if (yych <= '9') goto yy794;
		if (yych <= 'm') goto yy949;
		goto yy849;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy949;
			goto yy850;
		} else {
			if (yych <= 's') goto yy848;
			if (yych <= 't') goto yy851;
			goto yy949;
		}
	}
yy1245:
	YYDEBUG(1245, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= '-') {
			if (yych == '\t') goto yy1234;
			if (yych <= ',') goto yy1236;
			goto yy1233;
		} else {
			if (yych <= '.') goto yy1246;
			if (yych <= '/') goto yy915;
			if (yych <= '5') goto yy1248;
			goto yy926;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy1247;
			if (yych == 'n') goto yy675;
			goto yy1236;
		} else {
			if (yych <= 'r') goto yy676;
			if (yych <= 's') goto yy669;
			if (yych <= 't') goto yy673;
			goto yy1236;
		}
	}
yy1246:
	YYDEBUG(1246, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '1') {
		if (yych <= '/') goto yy767;
		if (yych <= '0') goto yy1270;
		goto yy1271;
	} else {
		if (yych <= '5') goto yy1272;
		if (yych <= '9') goto yy1273;
		goto yy767;
	}
yy1247:
	YYDEBUG(1247, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1265;
	if (yych <= '9') goto yy1266;
	goto yy53;
yy1248:
	YYDEBUG(1248, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy970;
	if (yych <= '/') goto yy57;
	if (yych >= ':') goto yy57;
	YYDEBUG(1249, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch (yych) {
	case '\t':
	case ' ':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'S':
	case 'T':
	case 'V':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'n':
	case 'o':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy976;
	case '-':	goto yy973;
	case '.':	goto yy977;
	case '/':	goto yy974;
	case '0':	goto yy1251;
	case '1':	goto yy1252;
	case '2':	goto yy1253;
	case '3':	goto yy1254;
	case '4':
	case '5':	goto yy1255;
	case '6':	goto yy1256;
	case '7':
	case '8':
	case '9':	goto yy51;
	case ':':	goto yy992;
	case 'W':	goto yy995;
	default:	goto yy1250;
	}
yy1250:
	YYDEBUG(1250, *YYCURSOR);
	{
		DEBUG_OUTPUT("gnunocolon");
		TIMELIB_INIT;
		switch (s->time->have_time) {
			case 0:
				s->time->h = timelib_get_nr((char **) &ptr, 2);
				s->time->i = timelib_get_nr((char **) &ptr, 2);
				s->time->s = 0;
				break;
			case 1:
				s->time->y = timelib_get_nr((char **) &ptr, 4);
				break;
			default:
				TIMELIB_DEINIT;
				add_error(s, "Double time specification");
				return TIMELIB_ERROR;
		}
		s->time->have_time++;
		TIMELIB_DEINIT;
		return TIMELIB_GNU_NOCOLON;
	}
yy1251:
	YYDEBUG(1251, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '0') goto yy1263;
	if (yych <= '9') goto yy1264;
	goto yy57;
yy1252:
	YYDEBUG(1252, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '2') goto yy1262;
	if (yych <= '9') goto yy1261;
	goto yy57;
yy1253:
	YYDEBUG(1253, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '9') goto yy1261;
	goto yy57;
yy1254:
	YYDEBUG(1254, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '5') goto yy1259;
	if (yych <= '6') goto yy1260;
	if (yych <= '9') goto yy1257;
	goto yy57;
yy1255:
	YYDEBUG(1255, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '9') goto yy1257;
	goto yy57;
yy1256:
	YYDEBUG(1256, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '0') goto yy1257;
	if (yych <= '9') goto yy51;
	goto yy57;
yy1257:
	YYDEBUG(1257, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 2) {
		goto yy51;
	}
	if (yych <= 'W') {
		if (yych <= 'F') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy57;
				if (yych >= ' ') goto yy57;
			} else {
				if (yych == 'D') goto yy57;
				if (yych >= 'F') goto yy57;
			}
		} else {
			if (yych <= 'M') {
				if (yych == 'H') goto yy57;
				if (yych >= 'M') goto yy57;
			} else {
				if (yych <= 'R') goto yy1258;
				if (yych <= 'T') goto yy57;
				if (yych >= 'W') goto yy57;
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy57;
				if (yych >= 'd') goto yy57;
			} else {
				if (yych == 'f') goto yy57;
				if (yych >= 'h') goto yy57;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy57;
				if (yych >= 's') goto yy57;
			} else {
				if (yych <= 'w') {
					if (yych >= 'w') goto yy57;
				} else {
					if (yych == 'y') goto yy57;
				}
			}
		}
	}
yy1258:
	YYDEBUG(1258, *YYCURSOR);
	{
		int tz_not_found;
		DEBUG_OUTPUT("iso8601nocolon");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		s->time->s = timelib_get_nr((char **) &ptr, 2);

		if (*ptr != '\0') {
			s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
			if (tz_not_found) {
				add_error(s, "The timezone could not be found in the database");
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_ISO_NOCOLON;
	}
yy1259:
	YYDEBUG(1259, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy57;
				if (yych <= 0x1F) goto yy1258;
				goto yy57;
			} else {
				if (yych <= '/') goto yy1258;
				if (yych <= '9') goto yy1006;
				if (yych <= 'C') goto yy1258;
				goto yy57;
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy57;
				if (yych <= 'G') goto yy1258;
				goto yy57;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy1258;
					goto yy57;
				} else {
					if (yych <= 'R') goto yy1258;
					if (yych <= 'T') goto yy57;
					goto yy1258;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy1258;
				if (yych <= 'Y') goto yy57;
				goto yy1258;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy57;
					goto yy1258;
				} else {
					if (yych == 'g') goto yy1258;
					goto yy57;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy57;
				if (yych <= 'r') goto yy1258;
				goto yy57;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy1258;
					goto yy57;
				} else {
					if (yych == 'y') goto yy57;
					goto yy1258;
				}
			}
		}
	}
yy1260:
	YYDEBUG(1260, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy57;
				if (yych <= 0x1F) goto yy1258;
				goto yy57;
			} else {
				if (yych <= '6') {
					if (yych <= '/') goto yy1258;
					goto yy1006;
				} else {
					if (yych <= '9') goto yy51;
					if (yych <= 'C') goto yy1258;
					goto yy57;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy57;
				if (yych <= 'G') goto yy1258;
				goto yy57;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy1258;
					goto yy57;
				} else {
					if (yych <= 'R') goto yy1258;
					if (yych <= 'T') goto yy57;
					goto yy1258;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy1258;
				if (yych <= 'Y') goto yy57;
				goto yy1258;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy57;
					goto yy1258;
				} else {
					if (yych == 'g') goto yy1258;
					goto yy57;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy57;
				if (yych <= 'r') goto yy1258;
				goto yy57;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy1258;
					goto yy57;
				} else {
					if (yych == 'y') goto yy57;
					goto yy1258;
				}
			}
		}
	}
yy1261:
	YYDEBUG(1261, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy57;
				if (yych <= 0x1F) goto yy1258;
				goto yy57;
			} else {
				if (yych <= '/') goto yy1258;
				if (yych <= '9') goto yy1006;
				if (yych <= 'C') goto yy1258;
				goto yy57;
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy57;
				if (yych <= 'G') goto yy1258;
				goto yy57;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy1258;
					goto yy57;
				} else {
					if (yych <= 'R') goto yy1258;
					if (yych <= 'T') goto yy57;
					goto yy1258;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy1258;
				if (yych <= 'Y') goto yy57;
				goto yy1258;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy57;
					goto yy1258;
				} else {
					if (yych == 'g') goto yy1258;
					goto yy57;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy57;
				if (yych <= 'r') goto yy1258;
				goto yy57;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy1258;
					goto yy57;
				} else {
					if (yych == 'y') goto yy57;
					goto yy1258;
				}
			}
		}
	}
yy1262:
	YYDEBUG(1262, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '9') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy57;
				if (yych <= 0x1F) goto yy1258;
				goto yy57;
			} else {
				if (yych <= '0') {
					if (yych <= '/') goto yy1258;
					goto yy1030;
				} else {
					if (yych <= '2') goto yy1031;
					if (yych <= '3') goto yy1032;
					goto yy1006;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych <= 'D') {
					if (yych <= 'C') goto yy1258;
					goto yy57;
				} else {
					if (yych == 'F') goto yy57;
					goto yy1258;
				}
			} else {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy57;
					goto yy1258;
				} else {
					if (yych <= 'M') goto yy57;
					if (yych <= 'R') goto yy1258;
					goto yy57;
				}
			}
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Y') {
				if (yych == 'W') goto yy57;
				if (yych <= 'X') goto yy1258;
				goto yy57;
			} else {
				if (yych <= 'd') {
					if (yych <= 'c') goto yy1258;
					goto yy57;
				} else {
					if (yych == 'f') goto yy57;
					goto yy1258;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'l') {
					if (yych <= 'h') goto yy57;
					goto yy1258;
				} else {
					if (yych <= 'm') goto yy57;
					if (yych <= 'r') goto yy1258;
					goto yy57;
				}
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy1258;
					goto yy57;
				} else {
					if (yych == 'y') goto yy57;
					goto yy1258;
				}
			}
		}
	}
yy1263:
	YYDEBUG(1263, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '9') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy57;
				if (yych <= 0x1F) goto yy1258;
				goto yy57;
			} else {
				if (yych <= '0') {
					if (yych <= '/') goto yy1258;
					goto yy1062;
				} else {
					if (yych <= '2') goto yy1031;
					if (yych <= '3') goto yy1032;
					goto yy1006;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych <= 'D') {
					if (yych <= 'C') goto yy1258;
					goto yy57;
				} else {
					if (yych == 'F') goto yy57;
					goto yy1258;
				}
			} else {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy57;
					goto yy1258;
				} else {
					if (yych <= 'M') goto yy57;
					if (yych <= 'R') goto yy1258;
					goto yy57;
				}
			}
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Y') {
				if (yych == 'W') goto yy57;
				if (yych <= 'X') goto yy1258;
				goto yy57;
			} else {
				if (yych <= 'd') {
					if (yych <= 'c') goto yy1258;
					goto yy57;
				} else {
					if (yych == 'f') goto yy57;
					goto yy1258;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'l') {
					if (yych <= 'h') goto yy57;
					goto yy1258;
				} else {
					if (yych <= 'm') goto yy57;
					if (yych <= 'r') goto yy1258;
					goto yy57;
				}
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy1258;
					goto yy57;
				} else {
					if (yych == 'y') goto yy57;
					goto yy1258;
				}
			}
		}
	}
yy1264:
	YYDEBUG(1264, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '9') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy57;
				if (yych <= 0x1F) goto yy1258;
				goto yy57;
			} else {
				if (yych <= '0') {
					if (yych <= '/') goto yy1258;
					goto yy1030;
				} else {
					if (yych <= '2') goto yy1031;
					if (yych <= '3') goto yy1032;
					goto yy1006;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych <= 'D') {
					if (yych <= 'C') goto yy1258;
					goto yy57;
				} else {
					if (yych == 'F') goto yy57;
					goto yy1258;
				}
			} else {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy57;
					goto yy1258;
				} else {
					if (yych <= 'M') goto yy57;
					if (yych <= 'R') goto yy1258;
					goto yy57;
				}
			}
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Y') {
				if (yych == 'W') goto yy57;
				if (yych <= 'X') goto yy1258;
				goto yy57;
			} else {
				if (yych <= 'd') {
					if (yych <= 'c') goto yy1258;
					goto yy57;
				} else {
					if (yych == 'f') goto yy57;
					goto yy1258;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'l') {
					if (yych <= 'h') goto yy57;
					goto yy1258;
				} else {
					if (yych <= 'm') goto yy57;
					if (yych <= 'r') goto yy1258;
					goto yy57;
				}
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy1258;
					goto yy57;
				} else {
					if (yych == 'y') goto yy57;
					goto yy1258;
				}
			}
		}
	}
yy1265:
	YYDEBUG(1265, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy1267;
		goto yy696;
	} else {
		if (yych <= '9') goto yy1266;
		if (yych <= ':') goto yy1267;
		goto yy696;
	}
yy1266:
	YYDEBUG(1266, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy1267;
	if (yych != ':') goto yy696;
yy1267:
	YYDEBUG(1267, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1268;
	if (yych <= '6') goto yy1269;
	if (yych <= '9') goto yy701;
	goto yy53;
yy1268:
	YYDEBUG(1268, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy702;
	if (yych <= '/') goto yy696;
	if (yych <= '9') goto yy701;
	goto yy696;
yy1269:
	YYDEBUG(1269, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy702;
	if (yych == '0') goto yy701;
	goto yy696;
yy1270:
	YYDEBUG(1270, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy696;
		if (yych <= '-') goto yy791;
		goto yy1274;
	} else {
		if (yych <= '/') goto yy696;
		if (yych <= '9') goto yy1273;
		if (yych <= ':') goto yy1267;
		goto yy696;
	}
yy1271:
	YYDEBUG(1271, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') goto yy696;
		if (yych <= '-') goto yy791;
		if (yych <= '.') goto yy1274;
		goto yy696;
	} else {
		if (yych <= '2') goto yy1273;
		if (yych <= '9') goto yy1266;
		if (yych <= ':') goto yy1267;
		goto yy696;
	}
yy1272:
	YYDEBUG(1272, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy696;
		if (yych <= '-') goto yy791;
		goto yy1274;
	} else {
		if (yych <= '/') goto yy696;
		if (yych <= '9') goto yy1266;
		if (yych <= ':') goto yy1267;
		goto yy696;
	}
yy1273:
	YYDEBUG(1273, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy696;
		if (yych <= '-') goto yy791;
	} else {
		if (yych == ':') goto yy1267;
		goto yy696;
	}
yy1274:
	YYDEBUG(1274, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1275;
	if (yych <= '6') goto yy1276;
	if (yych <= '9') goto yy799;
	goto yy53;
yy1275:
	YYDEBUG(1275, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy702;
	if (yych <= '/') goto yy696;
	if (yych <= '9') goto yy1277;
	goto yy696;
yy1276:
	YYDEBUG(1276, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy702;
		goto yy696;
	} else {
		if (yych <= '0') goto yy1277;
		if (yych <= '9') goto yy800;
		goto yy696;
	}
yy1277:
	YYDEBUG(1277, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy702;
	if (yych <= '/') goto yy696;
	if (yych <= '9') goto yy794;
	goto yy696;
yy1278:
	YYDEBUG(1278, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= '-') {
			if (yych == '\t') goto yy665;
			if (yych <= ',') goto yy667;
			goto yy1233;
		} else {
			if (yych <= '.') goto yy679;
			if (yych <= '/') goto yy677;
			if (yych <= '5') goto yy1248;
			goto yy926;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy688;
			if (yych == 'n') goto yy675;
			goto yy667;
		} else {
			if (yych <= 'r') goto yy676;
			if (yych <= 's') goto yy669;
			if (yych <= 't') goto yy673;
			goto yy667;
		}
	}
yy1279:
	YYDEBUG(1279, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= '-') {
			if (yych == '\t') goto yy1234;
			if (yych <= ',') goto yy1236;
			goto yy1233;
		} else {
			if (yych <= '.') goto yy1246;
			if (yych <= '/') goto yy677;
			if (yych <= '5') goto yy1248;
			goto yy926;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy1247;
			if (yych == 'n') goto yy675;
			goto yy1236;
		} else {
			if (yych <= 'r') goto yy676;
			if (yych <= 's') goto yy669;
			if (yych <= 't') goto yy673;
			goto yy1236;
		}
	}
yy1280:
	YYDEBUG(1280, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= ':') goto yy53;
yy1281:
	YYDEBUG(1281, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(1282, *YYCURSOR);
	if (yych <= '/') goto yy1283;
	if (yych <= '9') goto yy1281;
yy1283:
	YYDEBUG(1283, *YYCURSOR);
	{
		timelib_ull i;

		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_DATE();
		TIMELIB_UNHAVE_TIME();

		i = timelib_get_unsigned_nr((char **) &ptr, 24);
		s->time->y = 1970;
		s->time->m = 1;
		s->time->d = 1;
		s->time->h = s->time->i = s->time->s = 0;
		s->time->f = 0.0;
		s->time->relative.s += i;
		s->time->is_localtime = 1;
		s->time->zone_type = TIMELIB_ZONETYPE_OFFSET;
		s->time->z = 0;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1284:
	YYDEBUG(1284, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy138;
			goto yy1324;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy138;
			if (yych <= '`') goto yy3;
			goto yy138;
		} else {
			if (yych <= 'n') goto yy1324;
			if (yych <= 'z') goto yy138;
			goto yy3;
		}
	}
yy1285:
	YYDEBUG(1285, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= '@') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych == 'I') goto yy1318;
			if (yych <= 'T') goto yy138;
			goto yy1317;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy138;
			if (yych <= '`') goto yy3;
			if (yych <= 'h') goto yy138;
			goto yy1318;
		} else {
			if (yych == 'u') goto yy1317;
			if (yych <= 'z') goto yy138;
			goto yy3;
		}
	}
yy1286:
	YYDEBUG(1286, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych <= '@') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych == 'D') goto yy1306;
			if (yych <= 'L') goto yy138;
			goto yy1307;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy138;
			if (yych <= '`') goto yy3;
			if (yych <= 'c') goto yy138;
			goto yy1306;
		} else {
			if (yych == 'm') goto yy1307;
			if (yych <= 'z') goto yy138;
			goto yy3;
		}
	}
yy1287:
	YYDEBUG(1287, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy138;
			goto yy1302;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy138;
			if (yych <= '`') goto yy3;
			goto yy138;
		} else {
			if (yych <= 'e') goto yy1302;
			if (yych <= 'z') goto yy138;
			goto yy3;
		}
	}
yy1288:
	YYDEBUG(1288, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy138;
			goto yy1298;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy138;
			if (yych <= '`') goto yy3;
			goto yy138;
		} else {
			if (yych <= 'e') goto yy1298;
			if (yych <= 'z') goto yy138;
			goto yy3;
		}
	}
yy1289:
	YYDEBUG(1289, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy1247;
		goto yy53;
	} else {
		if (yych <= '9') goto yy1292;
		if (yych <= ':') goto yy1247;
		goto yy53;
	}
yy1290:
	YYDEBUG(1290, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy1247;
		goto yy53;
	} else {
		if (yych <= '3') goto yy1292;
		if (yych == ':') goto yy1247;
		goto yy53;
	}
yy1291:
	YYDEBUG(1291, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '.') goto yy1247;
	if (yych == ':') goto yy1247;
	goto yy53;
yy1292:
	YYDEBUG(1292, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy1247;
		goto yy53;
	} else {
		if (yych <= '5') goto yy1293;
		if (yych == ':') goto yy1247;
		goto yy53;
	}
yy1293:
	YYDEBUG(1293, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= ':') goto yy53;
	YYDEBUG(1294, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy1250;
	if (yych <= '5') goto yy1295;
	if (yych <= '6') goto yy1296;
	goto yy1250;
yy1295:
	YYDEBUG(1295, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1297;
	goto yy53;
yy1296:
	YYDEBUG(1296, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '0') goto yy53;
yy1297:
	YYDEBUG(1297, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy1258;
yy1298:
	YYDEBUG(1298, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'K') goto yy139;
		}
	} else {
		if (yych <= 'k') {
			if (yych <= 'Z') goto yy139;
			if (yych <= '`') goto yy3;
			goto yy139;
		} else {
			if (yych <= 'l') goto yy1299;
			if (yych <= 'z') goto yy139;
			goto yy3;
		}
	}
yy1299:
	YYDEBUG(1299, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'F') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'E') goto yy140;
		}
	} else {
		if (yych <= 'e') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'f') goto yy1300;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy1300:
	YYDEBUG(1300, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy141;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 't') goto yy1301;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1301:
	YYDEBUG(1301, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych == ')') goto yy136;
		goto yy3;
	} else {
		if (yych <= 'H') goto yy159;
		if (yych == 'h') goto yy159;
		goto yy3;
	}
yy1302:
	YYDEBUG(1302, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy277;
			goto yy136;
		} else {
			if (yych <= '@') goto yy277;
			if (yych <= 'R') goto yy139;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy139;
			if (yych <= '`') goto yy277;
			goto yy139;
		} else {
			if (yych <= 's') goto yy1303;
			if (yych <= 'z') goto yy139;
			goto yy277;
		}
	}
yy1303:
	YYDEBUG(1303, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy140;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'd') goto yy1304;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy1304:
	YYDEBUG(1304, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy136;
		if (yych <= '@') goto yy3;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy141;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1305;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1305:
	YYDEBUG(1305, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych == ')') goto yy136;
		goto yy3;
	} else {
		if (yych <= 'Y') goto yy283;
		if (yych == 'y') goto yy283;
		goto yy3;
	}
yy1306:
	YYDEBUG(1306, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy136;
		if (yych <= '@') goto yy3;
		goto yy1314;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy139;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1314;
			if (yych <= 'z') goto yy139;
			goto yy3;
		}
	}
yy1307:
	YYDEBUG(1307, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'N') goto yy139;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy139;
			if (yych <= '`') goto yy3;
			goto yy139;
		} else {
			if (yych <= 'o') goto yy1308;
			if (yych <= 'z') goto yy139;
			goto yy3;
		}
	}
yy1308:
	YYDEBUG(1308, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy140;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'r') goto yy1309;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy1309:
	YYDEBUG(1309, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy141;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'r') goto yy1310;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1310:
	YYDEBUG(1310, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych == ')') goto yy136;
		goto yy3;
	} else {
		if (yych <= 'O') goto yy1311;
		if (yych != 'o') goto yy3;
	}
yy1311:
	YYDEBUG(1311, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'W') goto yy1312;
	if (yych != 'w') goto yy53;
yy1312:
	YYDEBUG(1312, *YYCURSOR);
	++YYCURSOR;
yy1313:
	YYDEBUG(1313, *YYCURSOR);
	{
		DEBUG_OUTPUT("tomorrow");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_TIME();

		s->time->relative.d = 1;
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1314:
	YYDEBUG(1314, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'X') goto yy140;
		}
	} else {
		if (yych <= 'x') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'y') goto yy1315;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy1315:
	YYDEBUG(1315, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '@') {
		if (yych == ')') goto yy136;
	} else {
		if (yych <= 'Z') goto yy141;
		if (yych <= '`') goto yy1316;
		if (yych <= 'z') goto yy141;
	}
yy1316:
	YYDEBUG(1316, *YYCURSOR);
	{
		DEBUG_OUTPUT("midnight | today");
		TIMELIB_INIT;
		TIMELIB_UNHAVE_TIME();

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1317:
	YYDEBUG(1317, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy277;
			goto yy136;
		} else {
			if (yych <= '@') goto yy277;
			if (yych <= 'Q') goto yy139;
			goto yy1320;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy139;
			if (yych <= '`') goto yy277;
			goto yy139;
		} else {
			if (yych <= 'r') goto yy1320;
			if (yych <= 'z') goto yy139;
			goto yy277;
		}
	}
yy1318:
	YYDEBUG(1318, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= '@') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych <= 'Q') goto yy139;
			if (yych >= 'S') goto yy249;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy139;
			if (yych <= '`') goto yy3;
			goto yy139;
		} else {
			if (yych <= 'r') goto yy1319;
			if (yych <= 's') goto yy249;
			if (yych <= 'z') goto yy139;
			goto yy3;
		}
	}
yy1319:
	YYDEBUG(1319, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy140;
			goto yy506;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'd') goto yy506;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy1320:
	YYDEBUG(1320, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'R') goto yy140;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy140;
		} else {
			if (yych <= 's') goto yy1321;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy1321:
	YYDEBUG(1321, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy141;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'd') goto yy1322;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1322:
	YYDEBUG(1322, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych == ')') goto yy136;
		goto yy3;
	} else {
		if (yych <= 'A') goto yy1323;
		if (yych != 'a') goto yy3;
	}
yy1323:
	YYDEBUG(1323, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy283;
	if (yych == 'y') goto yy283;
	goto yy53;
yy1324:
	YYDEBUG(1324, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy139;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy139;
			if (yych <= '`') goto yy3;
			goto yy139;
		} else {
			if (yych <= 't') goto yy1325;
			if (yych <= 'z') goto yy139;
			goto yy3;
		}
	}
yy1325:
	YYDEBUG(1325, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy140;
			goto yy506;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'h') goto yy506;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy1326:
	YYDEBUG(1326, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy138;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1324;
			if (yych <= 'Z') goto yy138;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy143;
			} else {
				if (yych <= 'n') goto yy1355;
				if (yych <= 'z') goto yy143;
				goto yy3;
			}
		}
	}
yy1327:
	YYDEBUG(1327, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy136;
			} else {
				if (yych == '-') goto yy144;
				goto yy3;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy144;
				goto yy3;
			} else {
				if (yych == 'I') goto yy1318;
				goto yy138;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'U') goto yy1317;
				goto yy138;
			} else {
				if (yych == '_') goto yy144;
				goto yy3;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'i') goto yy1349;
				goto yy143;
			} else {
				if (yych <= 'u') goto yy1348;
				if (yych <= 'z') goto yy143;
				goto yy3;
			}
		}
	}
yy1328:
	YYDEBUG(1328, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy136;
			} else {
				if (yych == '-') goto yy144;
				goto yy3;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy144;
				goto yy3;
			} else {
				if (yych == 'D') goto yy1306;
				goto yy138;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'M') goto yy1307;
				goto yy138;
			} else {
				if (yych == '_') goto yy144;
				goto yy3;
			}
		} else {
			if (yych <= 'l') {
				if (yych == 'd') goto yy1339;
				goto yy143;
			} else {
				if (yych <= 'm') goto yy1340;
				if (yych <= 'z') goto yy143;
				goto yy3;
			}
		}
	}
yy1329:
	YYDEBUG(1329, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy138;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy1302;
			if (yych <= 'Z') goto yy138;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy143;
			} else {
				if (yych <= 'e') goto yy1335;
				if (yych <= 'z') goto yy143;
				goto yy3;
			}
		}
	}
yy1330:
	YYDEBUG(1330, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy138;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy1298;
			if (yych <= 'Z') goto yy138;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy143;
			} else {
				if (yych <= 'e') goto yy1331;
				if (yych <= 'z') goto yy143;
				goto yy3;
			}
		}
	}
yy1331:
	YYDEBUG(1331, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'K') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy139;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'L') goto yy1299;
			if (yych <= 'Z') goto yy139;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'k') {
				if (yych <= '`') goto yy3;
				goto yy147;
			} else {
				if (yych <= 'l') goto yy1332;
				if (yych <= 'z') goto yy147;
				goto yy3;
			}
		}
	}
yy1332:
	YYDEBUG(1332, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy140;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'F') goto yy1300;
			if (yych <= 'Z') goto yy140;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'e') {
				if (yych <= '`') goto yy3;
				goto yy148;
			} else {
				if (yych <= 'f') goto yy1333;
				if (yych <= 'z') goto yy148;
				goto yy3;
			}
		}
	}
yy1333:
	YYDEBUG(1333, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1301;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy149;
			} else {
				if (yych <= 't') goto yy1334;
				if (yych <= 'z') goto yy149;
				goto yy3;
			}
		}
	}
yy1334:
	YYDEBUG(1334, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= ',') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy144;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'H') goto yy159;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'h') goto yy246;
			if (yych <= 'z') goto yy150;
			goto yy3;
		}
	}
yy1335:
	YYDEBUG(1335, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy277;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy277;
			goto yy139;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy1303;
			if (yych <= 'Z') goto yy139;
			if (yych <= '^') goto yy277;
			goto yy144;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy277;
				goto yy147;
			} else {
				if (yych <= 's') goto yy1336;
				if (yych <= 'z') goto yy147;
				goto yy277;
			}
		}
	}
yy1336:
	YYDEBUG(1336, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy140;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1304;
			if (yych <= 'Z') goto yy140;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy3;
				goto yy148;
			} else {
				if (yych <= 'd') goto yy1337;
				if (yych <= 'z') goto yy148;
				goto yy3;
			}
		}
	}
yy1337:
	YYDEBUG(1337, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy144;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy1305;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1338;
			if (yych <= 'z') goto yy149;
			goto yy3;
		}
	}
yy1338:
	YYDEBUG(1338, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= ',') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy144;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Y') goto yy283;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'y') goto yy296;
			if (yych <= 'z') goto yy150;
			goto yy3;
		}
	}
yy1339:
	YYDEBUG(1339, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy144;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy1314;
			if (yych <= 'Z') goto yy139;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1346;
			if (yych <= 'z') goto yy147;
			goto yy3;
		}
	}
yy1340:
	YYDEBUG(1340, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy139;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'O') goto yy1308;
			if (yych <= 'Z') goto yy139;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy3;
				goto yy147;
			} else {
				if (yych <= 'o') goto yy1341;
				if (yych <= 'z') goto yy147;
				goto yy3;
			}
		}
	}
yy1341:
	YYDEBUG(1341, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy140;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy1309;
			if (yych <= 'Z') goto yy140;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy3;
				goto yy148;
			} else {
				if (yych <= 'r') goto yy1342;
				if (yych <= 'z') goto yy148;
				goto yy3;
			}
		}
	}
yy1342:
	YYDEBUG(1342, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy1310;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy3;
				goto yy149;
			} else {
				if (yych <= 'r') goto yy1343;
				if (yych <= 'z') goto yy149;
				goto yy3;
			}
		}
	}
yy1343:
	YYDEBUG(1343, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= ',') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy144;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'O') goto yy1311;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'o') goto yy1344;
			if (yych <= 'z') goto yy150;
			goto yy3;
		}
	}
yy1344:
	YYDEBUG(1344, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'W') goto yy1312;
	if (yych != 'w') goto yy151;
	YYDEBUG(1345, *YYCURSOR);
	yyaccept = 27;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy150;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy144;
		goto yy1313;
	} else {
		if (yych <= '/') goto yy144;
		if (yych == '_') goto yy144;
		goto yy1313;
	}
yy1346:
	YYDEBUG(1346, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy140;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Y') goto yy1315;
			if (yych <= 'Z') goto yy140;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'x') {
				if (yych <= '`') goto yy3;
				goto yy148;
			} else {
				if (yych <= 'y') goto yy1347;
				if (yych <= 'z') goto yy148;
				goto yy3;
			}
		}
	}
yy1347:
	YYDEBUG(1347, *YYCURSOR);
	yyaccept = 28;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy136;
			goto yy1316;
		} else {
			if (yych == '.') goto yy1316;
			goto yy144;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy1316;
			if (yych <= 'Z') goto yy141;
			goto yy1316;
		} else {
			if (yych <= '_') goto yy144;
			if (yych <= '`') goto yy1316;
			if (yych <= 'z') goto yy149;
			goto yy1316;
		}
	}
yy1348:
	YYDEBUG(1348, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy277;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy277;
			goto yy139;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy1320;
			if (yych <= 'Z') goto yy139;
			if (yych <= '^') goto yy277;
			goto yy144;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy277;
				goto yy147;
			} else {
				if (yych <= 'r') goto yy1351;
				if (yych <= 'z') goto yy147;
				goto yy277;
			}
		}
	}
yy1349:
	YYDEBUG(1349, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych <= '/') {
				if (yych <= '.') goto yy3;
				goto yy144;
			} else {
				if (yych <= '@') goto yy3;
				if (yych <= 'Q') goto yy139;
				goto yy1319;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'S') goto yy249;
				goto yy139;
			} else {
				if (yych == '_') goto yy144;
				goto yy3;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'q') goto yy147;
			} else {
				if (yych <= 's') goto yy252;
				if (yych <= 'z') goto yy147;
				goto yy3;
			}
		}
	}
	YYDEBUG(1350, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy140;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy506;
			if (yych <= 'Z') goto yy140;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy3;
				goto yy148;
			} else {
				if (yych <= 'd') goto yy535;
				if (yych <= 'z') goto yy148;
				goto yy3;
			}
		}
	}
yy1351:
	YYDEBUG(1351, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy140;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy1321;
			if (yych <= 'Z') goto yy140;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy3;
				goto yy148;
			} else {
				if (yych <= 's') goto yy1352;
				if (yych <= 'z') goto yy148;
				goto yy3;
			}
		}
	}
yy1352:
	YYDEBUG(1352, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1322;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy3;
				goto yy149;
			} else {
				if (yych <= 'd') goto yy1353;
				if (yych <= 'z') goto yy149;
				goto yy3;
			}
		}
	}
yy1353:
	YYDEBUG(1353, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy144;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy1323;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1354;
			if (yych <= 'z') goto yy150;
			goto yy3;
		}
	}
yy1354:
	YYDEBUG(1354, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy283;
	if (yych == 'y') goto yy296;
	goto yy151;
yy1355:
	YYDEBUG(1355, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy139;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1325;
			if (yych <= 'Z') goto yy139;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy147;
			} else {
				if (yych <= 't') goto yy1356;
				if (yych <= 'z') goto yy147;
				goto yy3;
			}
		}
	}
yy1356:
	YYDEBUG(1356, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy140;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy506;
			if (yych <= 'Z') goto yy140;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy3;
				goto yy148;
			} else {
				if (yych <= 'h') goto yy535;
				if (yych <= 'z') goto yy148;
				goto yy3;
			}
		}
	}
yy1357:
	YYDEBUG(1357, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= '@') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych == 'R') goto yy1369;
			if (yych <= 'X') goto yy138;
			goto yy1370;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy138;
			if (yych <= '`') goto yy3;
			if (yych <= 'q') goto yy138;
			goto yy1369;
		} else {
			if (yych == 'y') goto yy1370;
			if (yych <= 'z') goto yy138;
			goto yy3;
		}
	}
yy1358:
	YYDEBUG(1358, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy138;
			goto yy1363;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy138;
			if (yych <= '`') goto yy3;
			goto yy138;
		} else {
			if (yych <= 'd') goto yy1363;
			if (yych <= 'z') goto yy138;
			goto yy3;
		}
	}
yy1359:
	YYDEBUG(1359, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy138;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy138;
			if (yych <= '`') goto yy3;
			goto yy138;
		} else {
			if (yych <= 'n') goto yy1360;
			if (yych <= 'z') goto yy138;
			goto yy3;
		}
	}
yy1360:
	YYDEBUG(1360, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy277;
			goto yy136;
		} else {
			if (yych <= '@') goto yy277;
			if (yych <= 'C') goto yy139;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy139;
			if (yych <= '`') goto yy277;
			goto yy139;
		} else {
			if (yych <= 'd') goto yy1361;
			if (yych <= 'z') goto yy139;
			goto yy277;
		}
	}
yy1361:
	YYDEBUG(1361, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy136;
		if (yych <= '@') goto yy3;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy140;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1362;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy1362:
	YYDEBUG(1362, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'X') goto yy141;
			goto yy503;
		}
	} else {
		if (yych <= 'x') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'y') goto yy503;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1363:
	YYDEBUG(1363, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy139;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy139;
			if (yych <= '`') goto yy3;
			goto yy139;
		} else {
			if (yych <= 'n') goto yy1364;
			if (yych <= 'z') goto yy139;
			goto yy3;
		}
	}
yy1364:
	YYDEBUG(1364, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'I') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'H') goto yy140;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'i') goto yy1365;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy1365:
	YYDEBUG(1365, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'G') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'F') goto yy141;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'g') goto yy1366;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1366:
	YYDEBUG(1366, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych == ')') goto yy136;
		goto yy3;
	} else {
		if (yych <= 'H') goto yy1367;
		if (yych != 'h') goto yy3;
	}
yy1367:
	YYDEBUG(1367, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1368;
	if (yych != 't') goto yy53;
yy1368:
	YYDEBUG(1368, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy1316;
yy1369:
	YYDEBUG(1369, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy304;
				goto yy306;
			} else {
				if (yych == ' ') goto yy306;
				goto yy304;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy136;
				goto yy304;
			} else {
				if (yych <= '-') goto yy307;
				if (yych <= '.') goto yy306;
				goto yy304;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy306;
				goto yy304;
			} else {
				if (yych == 'C') goto yy1371;
				goto yy139;
			}
		} else {
			if (yych <= 'b') {
				if (yych <= '`') goto yy304;
				goto yy139;
			} else {
				if (yych <= 'c') goto yy1371;
				if (yych <= 'z') goto yy139;
				goto yy304;
			}
		}
	}
yy1370:
	YYDEBUG(1370, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy306;
			if (yych <= 0x1F) goto yy304;
			goto yy306;
		} else {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy304;
			goto yy307;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy304;
			if (yych <= '9') goto yy306;
			goto yy304;
		} else {
			if (yych <= 'Z') goto yy139;
			if (yych <= '`') goto yy304;
			if (yych <= 'z') goto yy139;
			goto yy304;
		}
	}
yy1371:
	YYDEBUG(1371, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy140;
			goto yy561;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'h') goto yy561;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy1372:
	YYDEBUG(1372, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy136;
			} else {
				if (yych == '-') goto yy144;
				goto yy3;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy144;
				goto yy3;
			} else {
				if (yych == 'R') goto yy1369;
				goto yy138;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'Y') goto yy1370;
				goto yy138;
			} else {
				if (yych == '_') goto yy144;
				goto yy3;
			}
		} else {
			if (yych <= 'x') {
				if (yych == 'r') goto yy1384;
				goto yy143;
			} else {
				if (yych <= 'y') goto yy1385;
				if (yych <= 'z') goto yy143;
				goto yy3;
			}
		}
	}
yy1373:
	YYDEBUG(1373, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy138;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1363;
			if (yych <= 'Z') goto yy138;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy3;
				goto yy143;
			} else {
				if (yych <= 'd') goto yy1378;
				if (yych <= 'z') goto yy143;
				goto yy3;
			}
		}
	}
yy1374:
	YYDEBUG(1374, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy138;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1360;
			if (yych <= 'Z') goto yy138;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy143;
			} else {
				if (yych <= 'n') goto yy1375;
				if (yych <= 'z') goto yy143;
				goto yy3;
			}
		}
	}
yy1375:
	YYDEBUG(1375, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy277;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy277;
			goto yy139;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1361;
			if (yych <= 'Z') goto yy139;
			if (yych <= '^') goto yy277;
			goto yy144;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy277;
				goto yy147;
			} else {
				if (yych <= 'd') goto yy1376;
				if (yych <= 'z') goto yy147;
				goto yy277;
			}
		}
	}
yy1376:
	YYDEBUG(1376, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy144;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy1362;
			if (yych <= 'Z') goto yy140;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1377;
			if (yych <= 'z') goto yy148;
			goto yy3;
		}
	}
yy1377:
	YYDEBUG(1377, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Y') goto yy503;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'x') {
				if (yych <= '`') goto yy3;
				goto yy149;
			} else {
				if (yych <= 'y') goto yy532;
				if (yych <= 'z') goto yy149;
				goto yy3;
			}
		}
	}
yy1378:
	YYDEBUG(1378, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy139;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1364;
			if (yych <= 'Z') goto yy139;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy147;
			} else {
				if (yych <= 'n') goto yy1379;
				if (yych <= 'z') goto yy147;
				goto yy3;
			}
		}
	}
yy1379:
	YYDEBUG(1379, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy140;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'I') goto yy1365;
			if (yych <= 'Z') goto yy140;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'h') {
				if (yych <= '`') goto yy3;
				goto yy148;
			} else {
				if (yych <= 'i') goto yy1380;
				if (yych <= 'z') goto yy148;
				goto yy3;
			}
		}
	}
yy1380:
	YYDEBUG(1380, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'F') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'G') goto yy1366;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'f') {
				if (yych <= '`') goto yy3;
				goto yy149;
			} else {
				if (yych <= 'g') goto yy1381;
				if (yych <= 'z') goto yy149;
				goto yy3;
			}
		}
	}
yy1381:
	YYDEBUG(1381, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= ',') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy144;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'H') goto yy1367;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'h') goto yy1382;
			if (yych <= 'z') goto yy150;
			goto yy3;
		}
	}
yy1382:
	YYDEBUG(1382, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1368;
	if (yych != 't') goto yy151;
	YYDEBUG(1383, *YYCURSOR);
	yyaccept = 28;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy150;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy144;
		goto yy1316;
	} else {
		if (yych <= '/') goto yy144;
		if (yych == '_') goto yy144;
		goto yy1316;
	}
yy1384:
	YYDEBUG(1384, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy304;
				goto yy306;
			} else {
				if (yych == ' ') goto yy306;
				goto yy304;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy136;
				if (yych <= ',') goto yy304;
				goto yy479;
			} else {
				if (yych == '/') goto yy144;
				goto yy306;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'B') {
				if (yych <= '@') goto yy304;
				goto yy139;
			} else {
				if (yych <= 'C') goto yy1371;
				if (yych <= 'Z') goto yy139;
				goto yy304;
			}
		} else {
			if (yych <= 'b') {
				if (yych <= '_') goto yy144;
				if (yych <= '`') goto yy304;
				goto yy147;
			} else {
				if (yych <= 'c') goto yy1386;
				if (yych <= 'z') goto yy147;
				goto yy304;
			}
		}
	}
yy1385:
	YYDEBUG(1385, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy306;
			if (yych <= 0x1F) goto yy304;
			goto yy306;
		} else {
			if (yych <= ')') {
				if (yych <= '(') goto yy304;
				goto yy136;
			} else {
				if (yych <= ',') goto yy304;
				if (yych <= '-') goto yy479;
				goto yy306;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '/') goto yy144;
			if (yych <= '9') goto yy306;
			if (yych <= '@') goto yy304;
			goto yy139;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy304;
				goto yy144;
			} else {
				if (yych <= '`') goto yy304;
				if (yych <= 'z') goto yy147;
				goto yy304;
			}
		}
	}
yy1386:
	YYDEBUG(1386, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy140;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy561;
			if (yych <= 'Z') goto yy140;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy3;
				goto yy148;
			} else {
				if (yych <= 'h') goto yy572;
				if (yych <= 'z') goto yy148;
				goto yy3;
			}
		}
	}
yy1387:
	YYDEBUG(1387, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'W') {
		if (yych <= 'N') {
			if (yych == ')') goto yy136;
			if (yych <= '@') goto yy3;
			goto yy138;
		} else {
			if (yych <= 'O') goto yy1395;
			if (yych <= 'U') goto yy138;
			if (yych <= 'V') goto yy1396;
			goto yy1393;
		}
	} else {
		if (yych <= 'o') {
			if (yych <= 'Z') goto yy138;
			if (yych <= '`') goto yy3;
			if (yych <= 'n') goto yy138;
			goto yy1395;
		} else {
			if (yych <= 'v') {
				if (yych <= 'u') goto yy138;
				goto yy1396;
			} else {
				if (yych <= 'w') goto yy1393;
				if (yych <= 'z') goto yy138;
				goto yy3;
			}
		}
	}
yy1388:
	YYDEBUG(1388, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'W') goto yy138;
			goto yy1392;
		}
	} else {
		if (yych <= 'w') {
			if (yych <= 'Z') goto yy138;
			if (yych <= '`') goto yy3;
			goto yy138;
		} else {
			if (yych <= 'x') goto yy1392;
			if (yych <= 'z') goto yy138;
			goto yy3;
		}
	}
yy1389:
	YYDEBUG(1389, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy138;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy138;
			if (yych <= '`') goto yy3;
			goto yy138;
		} else {
			if (yych <= 'n') goto yy1390;
			if (yych <= 'z') goto yy138;
			goto yy3;
		}
	}
yy1390:
	YYDEBUG(1390, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy139;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy139;
			if (yych <= '`') goto yy3;
			goto yy139;
		} else {
			if (yych <= 't') goto yy1391;
			if (yych <= 'z') goto yy139;
			goto yy3;
		}
	}
yy1391:
	YYDEBUG(1391, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy140;
			goto yy506;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'h') goto yy506;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy1392:
	YYDEBUG(1392, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy139;
			goto yy249;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy139;
			if (yych <= '`') goto yy3;
			goto yy139;
		} else {
			if (yych <= 't') goto yy249;
			if (yych <= 'z') goto yy139;
			goto yy3;
		}
	}
yy1393:
	YYDEBUG(1393, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '@') {
		if (yych == ')') goto yy136;
	} else {
		if (yych <= 'Z') goto yy139;
		if (yych <= '`') goto yy1394;
		if (yych <= 'z') goto yy139;
	}
yy1394:
	YYDEBUG(1394, *YYCURSOR);
	{
		DEBUG_OUTPUT("now");
		TIMELIB_INIT;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1395:
	YYDEBUG(1395, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy139;
			goto yy1401;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy139;
			if (yych <= '`') goto yy3;
			goto yy139;
		} else {
			if (yych <= 'n') goto yy1401;
			if (yych <= 'z') goto yy139;
			goto yy3;
		}
	}
yy1396:
	YYDEBUG(1396, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy304;
				goto yy306;
			} else {
				if (yych == ' ') goto yy306;
				goto yy304;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy136;
				goto yy304;
			} else {
				if (yych <= '-') goto yy307;
				if (yych <= '.') goto yy306;
				goto yy304;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy306;
				goto yy304;
			} else {
				if (yych != 'E') goto yy139;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy304;
				goto yy139;
			} else {
				if (yych <= 'e') goto yy1397;
				if (yych <= 'z') goto yy139;
				goto yy304;
			}
		}
	}
yy1397:
	YYDEBUG(1397, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'L') goto yy140;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'm') goto yy1398;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy1398:
	YYDEBUG(1398, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'B') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'A') goto yy141;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'b') goto yy1399;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1399:
	YYDEBUG(1399, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == ')') goto yy136;
		goto yy3;
	} else {
		if (yych <= 'E') goto yy1400;
		if (yych != 'e') goto yy3;
	}
yy1400:
	YYDEBUG(1400, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy316;
	if (yych == 'r') goto yy316;
	goto yy53;
yy1401:
	YYDEBUG(1401, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '@') {
		if (yych == ')') goto yy136;
	} else {
		if (yych <= 'Z') goto yy140;
		if (yych <= '`') goto yy1402;
		if (yych <= 'z') goto yy140;
	}
yy1402:
	YYDEBUG(1402, *YYCURSOR);
	{
		DEBUG_OUTPUT("noon");
		TIMELIB_INIT;
		TIMELIB_UNHAVE_TIME();
		TIMELIB_HAVE_TIME();
		s->time->h = 12;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1403:
	YYDEBUG(1403, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy136;
			} else {
				if (yych == '-') goto yy144;
				goto yy3;
			}
		} else {
			if (yych <= 'N') {
				if (yych <= '/') goto yy144;
				if (yych <= '@') goto yy3;
				goto yy138;
			} else {
				if (yych <= 'O') goto yy1395;
				if (yych <= 'U') goto yy138;
				goto yy1396;
			}
		}
	} else {
		if (yych <= 'n') {
			if (yych <= '^') {
				if (yych <= 'W') goto yy1393;
				if (yych <= 'Z') goto yy138;
				goto yy3;
			} else {
				if (yych <= '_') goto yy144;
				if (yych <= '`') goto yy3;
				goto yy143;
			}
		} else {
			if (yych <= 'v') {
				if (yych <= 'o') goto yy1410;
				if (yych <= 'u') goto yy143;
				goto yy1411;
			} else {
				if (yych <= 'w') goto yy1409;
				if (yych <= 'z') goto yy143;
				goto yy3;
			}
		}
	}
yy1404:
	YYDEBUG(1404, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy138;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'X') goto yy1392;
			if (yych <= 'Z') goto yy138;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'w') {
				if (yych <= '`') goto yy3;
				goto yy143;
			} else {
				if (yych <= 'x') goto yy1408;
				if (yych <= 'z') goto yy143;
				goto yy3;
			}
		}
	}
yy1405:
	YYDEBUG(1405, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy138;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1390;
			if (yych <= 'Z') goto yy138;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy143;
			} else {
				if (yych <= 'n') goto yy1406;
				if (yych <= 'z') goto yy143;
				goto yy3;
			}
		}
	}
yy1406:
	YYDEBUG(1406, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy139;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1391;
			if (yych <= 'Z') goto yy139;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy147;
			} else {
				if (yych <= 't') goto yy1407;
				if (yych <= 'z') goto yy147;
				goto yy3;
			}
		}
	}
yy1407:
	YYDEBUG(1407, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy140;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy506;
			if (yych <= 'Z') goto yy140;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy3;
				goto yy148;
			} else {
				if (yych <= 'h') goto yy535;
				if (yych <= 'z') goto yy148;
				goto yy3;
			}
		}
	}
yy1408:
	YYDEBUG(1408, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy139;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy249;
			if (yych <= 'Z') goto yy139;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy147;
			} else {
				if (yych <= 't') goto yy252;
				if (yych <= 'z') goto yy147;
				goto yy3;
			}
		}
	}
yy1409:
	YYDEBUG(1409, *YYCURSOR);
	yyaccept = 29;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy136;
			goto yy1394;
		} else {
			if (yych == '.') goto yy1394;
			goto yy144;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy1394;
			if (yych <= 'Z') goto yy139;
			goto yy1394;
		} else {
			if (yych <= '_') goto yy144;
			if (yych <= '`') goto yy1394;
			if (yych <= 'z') goto yy147;
			goto yy1394;
		}
	}
yy1410:
	YYDEBUG(1410, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy139;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1401;
			if (yych <= 'Z') goto yy139;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy147;
			} else {
				if (yych <= 'n') goto yy1416;
				if (yych <= 'z') goto yy147;
				goto yy3;
			}
		}
	}
yy1411:
	YYDEBUG(1411, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy304;
				goto yy306;
			} else {
				if (yych == ' ') goto yy306;
				goto yy304;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy136;
				if (yych <= ',') goto yy304;
				goto yy479;
			} else {
				if (yych == '/') goto yy144;
				goto yy306;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'D') {
				if (yych <= '@') goto yy304;
				goto yy139;
			} else {
				if (yych <= 'E') goto yy1397;
				if (yych <= 'Z') goto yy139;
				goto yy304;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '_') goto yy144;
				if (yych <= '`') goto yy304;
				goto yy147;
			} else {
				if (yych <= 'e') goto yy1412;
				if (yych <= 'z') goto yy147;
				goto yy304;
			}
		}
	}
yy1412:
	YYDEBUG(1412, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy140;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'M') goto yy1398;
			if (yych <= 'Z') goto yy140;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'l') {
				if (yych <= '`') goto yy3;
				goto yy148;
			} else {
				if (yych <= 'm') goto yy1413;
				if (yych <= 'z') goto yy148;
				goto yy3;
			}
		}
	}
yy1413:
	YYDEBUG(1413, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'B') goto yy1399;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy3;
				goto yy149;
			} else {
				if (yych <= 'b') goto yy1414;
				if (yych <= 'z') goto yy149;
				goto yy3;
			}
		}
	}
yy1414:
	YYDEBUG(1414, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= ',') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy144;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'E') goto yy1400;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'e') goto yy1415;
			if (yych <= 'z') goto yy150;
			goto yy3;
		}
	}
yy1415:
	YYDEBUG(1415, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy316;
	if (yych == 'r') goto yy484;
	goto yy151;
yy1416:
	YYDEBUG(1416, *YYCURSOR);
	yyaccept = 30;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy136;
			goto yy1402;
		} else {
			if (yych == '.') goto yy1402;
			goto yy144;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy1402;
			if (yych <= 'Z') goto yy140;
			goto yy1402;
		} else {
			if (yych <= '_') goto yy144;
			if (yych <= '`') goto yy1402;
			if (yych <= 'z') goto yy148;
			goto yy1402;
		}
	}
yy1417:
	YYDEBUG(1417, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'R') goto yy138;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy138;
			if (yych <= '`') goto yy3;
			goto yy138;
		} else {
			if (yych <= 's') goto yy1418;
			if (yych <= 'z') goto yy138;
			goto yy3;
		}
	}
yy1418:
	YYDEBUG(1418, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy139;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy139;
			if (yych <= '`') goto yy3;
			goto yy139;
		} else {
			if (yych <= 't') goto yy1419;
			if (yych <= 'z') goto yy139;
			goto yy3;
		}
	}
yy1419:
	YYDEBUG(1419, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy140;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'e') goto yy1420;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy1420:
	YYDEBUG(1420, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy136;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy141;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'r') goto yy1421;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1421:
	YYDEBUG(1421, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych == ')') goto yy136;
		goto yy3;
	} else {
		if (yych <= 'D') goto yy1422;
		if (yych != 'd') goto yy3;
	}
yy1422:
	YYDEBUG(1422, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1423;
	if (yych != 'a') goto yy53;
yy1423:
	YYDEBUG(1423, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1424;
	if (yych != 'y') goto yy53;
yy1424:
	YYDEBUG(1424, *YYCURSOR);
	++YYCURSOR;
yy1425:
	YYDEBUG(1425, *YYCURSOR);
	{
		DEBUG_OUTPUT("yesterday");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_TIME();

		s->time->relative.d = -1;
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1426:
	YYDEBUG(1426, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy138;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy1418;
			if (yych <= 'Z') goto yy138;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy3;
				goto yy143;
			} else {
				if (yych <= 's') goto yy1427;
				if (yych <= 'z') goto yy143;
				goto yy3;
			}
		}
	}
yy1427:
	YYDEBUG(1427, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy139;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1419;
			if (yych <= 'Z') goto yy139;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy147;
			} else {
				if (yych <= 't') goto yy1428;
				if (yych <= 'z') goto yy147;
				goto yy3;
			}
		}
	}
yy1428:
	YYDEBUG(1428, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy140;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy1420;
			if (yych <= 'Z') goto yy140;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy148;
			} else {
				if (yych <= 'e') goto yy1429;
				if (yych <= 'z') goto yy148;
				goto yy3;
			}
		}
	}
yy1429:
	YYDEBUG(1429, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy136;
			if (yych <= ',') goto yy3;
			goto yy144;
		} else {
			if (yych == '/') goto yy144;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy1421;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy3;
				goto yy149;
			} else {
				if (yych <= 'r') goto yy1430;
				if (yych <= 'z') goto yy149;
				goto yy3;
			}
		}
	}
yy1430:
	YYDEBUG(1430, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= ',') {
			if (yych == ')') goto yy136;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy144;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'D') goto yy1422;
			if (yych == '_') goto yy144;
			goto yy3;
		} else {
			if (yych == 'd') goto yy1431;
			if (yych <= 'z') goto yy150;
			goto yy3;
		}
	}
yy1431:
	YYDEBUG(1431, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1423;
	if (yych != 'a') goto yy151;
	YYDEBUG(1432, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1424;
	if (yych != 'y') goto yy151;
	YYDEBUG(1433, *YYCURSOR);
	yyaccept = 31;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy150;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy144;
		goto yy1425;
	} else {
		if (yych <= '/') goto yy144;
		if (yych == '_') goto yy144;
		goto yy1425;
	}
}

}

#define YYMAXFILL 30

timelib_time* timelib_strtotime(char *s, int len, struct timelib_error_container **errors, const timelib_tzdb *tzdb, timelib_tz_get_wrapper tz_get_wrapper)
{
	Scanner in;
	int t;
	char *e = s + len - 1;

	memset(&in, 0, sizeof(in));
	in.errors = malloc(sizeof(struct timelib_error_container));
	in.errors->warning_count = 0;
	in.errors->warning_messages = NULL;
	in.errors->error_count = 0;
	in.errors->error_messages = NULL;

	if (len > 0) {
		while (isspace(*s) && s < e) {
			s++;
		}
		while (isspace(*e) && e > s) {
			e--;
		}
	}
	if (e - s < 0) {
		in.time = timelib_time_ctor();
		add_error(&in, "Empty string");
		if (errors) {
			*errors = in.errors;
		} else {
			timelib_error_container_dtor(in.errors);
		}
		in.time->y = in.time->d = in.time->m = in.time->h = in.time->i = in.time->s = in.time->f = in.time->dst = in.time->z = TIMELIB_UNSET;
		in.time->is_localtime = in.time->zone_type = 0;
		return in.time;
	}
	e++;

	in.str = malloc((e - s) + YYMAXFILL);
	memset(in.str, 0, (e - s) + YYMAXFILL);
	memcpy(in.str, s, (e - s));
	in.lim = in.str + (e - s) + YYMAXFILL;
	in.cur = in.str;
	in.time = timelib_time_ctor();
	in.time->y = TIMELIB_UNSET;
	in.time->d = TIMELIB_UNSET;
	in.time->m = TIMELIB_UNSET;
	in.time->h = TIMELIB_UNSET;
	in.time->i = TIMELIB_UNSET;
	in.time->s = TIMELIB_UNSET;
	in.time->f = TIMELIB_UNSET;
	in.time->z = TIMELIB_UNSET;
	in.time->dst = TIMELIB_UNSET;
	in.tzdb = tzdb;
	in.time->is_localtime = 0;
	in.time->zone_type = 0;

	do {
		t = scan(&in, tz_get_wrapper);
#ifdef DEBUG_PARSER
		printf("%d\n", t);
#endif
	} while(t != EOI);

	free(in.str);
	if (errors) {
		*errors = in.errors;
	} else {
		timelib_error_container_dtor(in.errors);
	}
	return in.time;
}

void timelib_fill_holes(timelib_time *parsed, timelib_time *now, int options)
{
	if (!(options & TIMELIB_OVERRIDE_TIME) && parsed->have_date && !parsed->have_time) {
		parsed->h = 0;
		parsed->i = 0;
		parsed->s = 0;
		parsed->f = 0;
	}
	if (parsed->y == TIMELIB_UNSET) parsed->y = now->y != TIMELIB_UNSET ? now->y : 0;
	if (parsed->d == TIMELIB_UNSET) parsed->d = now->d != TIMELIB_UNSET ? now->d : 0;
	if (parsed->m == TIMELIB_UNSET) parsed->m = now->m != TIMELIB_UNSET ? now->m : 0;
	if (parsed->h == TIMELIB_UNSET) parsed->h = now->h != TIMELIB_UNSET ? now->h : 0;
	if (parsed->i == TIMELIB_UNSET) parsed->i = now->i != TIMELIB_UNSET ? now->i : 0;
	if (parsed->s == TIMELIB_UNSET) parsed->s = now->s != TIMELIB_UNSET ? now->s : 0;
	if (parsed->f == TIMELIB_UNSET) parsed->f = now->f != TIMELIB_UNSET ? now->f : 0;
	if (parsed->z == TIMELIB_UNSET) parsed->z = now->z != TIMELIB_UNSET ? now->z : 0;
	if (parsed->dst == TIMELIB_UNSET) parsed->dst = now->dst != TIMELIB_UNSET ? now->dst : 0;

	if (!parsed->tz_abbr) {
		parsed->tz_abbr = now->tz_abbr ? strdup(now->tz_abbr) : NULL;
	}
	if (!parsed->tz_info) {
		parsed->tz_info = now->tz_info ? (!(options & TIMELIB_NO_CLONE) ? timelib_tzinfo_clone(now->tz_info) : now->tz_info) : NULL;
	}
	if (parsed->zone_type == 0 && now->zone_type != 0) {
		parsed->zone_type = now->zone_type;
/*		parsed->tz_abbr = now->tz_abbr ? strdup(now->tz_abbr) : NULL;
		parsed->tz_info = now->tz_info ? timelib_tzinfo_clone(now->tz_info) : NULL;
*/		parsed->is_localtime = 1;
	}
/*	timelib_dump_date(parsed, 2);
	timelib_dump_date(now, 2);
*/
}

char *timelib_timezone_id_from_abbr(const char *abbr, long gmtoffset, int isdst)
{
	const timelib_tz_lookup_table *tp;

	tp = zone_search(abbr, gmtoffset, isdst);
	if (tp) {
		return (tp->full_tz_name);
	} else {
		return NULL;
	}
}

const timelib_tz_lookup_table *timelib_timezone_abbreviations_list(void)
{
	return timelib_timezone_lookup;
}

#ifdef DEBUG_PARSER_STUB
int main(void)
{
	timelib_time time = timelib_strtotime("May 12");

	printf ("%04d-%02d-%02d %02d:%02d:%02d.%-5d %+04d %1d",
		time.y, time.m, time.d, time.h, time.i, time.s, time.f, time.z, time.dst);
	if (time.have_relative) {
		printf ("%3dY %3dM %3dD / %3dH %3dM %3dS", 
			time.relative.y, time.relative.m, time.relative.d, time.relative.h, time.relative.i, time.relative.s);
	}
	if (time.have_weekday_relative) {
		printf (" / %d", time.relative.weekday);
	}
	if (time.have_weeknr_day) {
		printf(" / %dW%d", time.relative.weeknr_day.weeknr, time.relative.weeknr_day.dayofweek);
	}
	return 0;				
}
#endif

/*
 * vim: syntax=c
 */
